/* moonshot-identity-management-view.c generated by valac 0.24.0, the Vala compiler
 * generated from moonshot-identity-management-view.vala, do not modify */

/*
 * Copyright (c) 2011-2014, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include "config.h"
#include <stdio.h>
#include <atk/atk.h>


#define TYPE_IDENTITY_MANAGER_VIEW (identity_manager_view_get_type ())
#define IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView))
#define IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))
#define IS_IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_VIEW))
#define IS_IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_VIEW))
#define IDENTITY_MANAGER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))

typedef struct _IdentityManagerView IdentityManagerView;
typedef struct _IdentityManagerViewClass IdentityManagerViewClass;
typedef struct _IdentityManagerViewPrivate IdentityManagerViewPrivate;

#define TYPE_IDENTITY_MANAGER_APP (identity_manager_app_get_type ())
#define IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp))
#define IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))
#define IS_IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_APP))
#define IS_IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_APP))
#define IDENTITY_MANAGER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))

typedef struct _IdentityManagerApp IdentityManagerApp;
typedef struct _IdentityManagerAppClass IdentityManagerAppClass;

#define TYPE_IDENTITY_MANAGER_MODEL (identity_manager_model_get_type ())
#define IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel))
#define IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))
#define IS_IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_MODEL))
#define IS_IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_MODEL))
#define IDENTITY_MANAGER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))

typedef struct _IdentityManagerModel IdentityManagerModel;
typedef struct _IdentityManagerModelClass IdentityManagerModelClass;

#define TYPE_IDENTITY_REQUEST (identity_request_get_type ())
#define IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_REQUEST, IdentityRequest))
#define IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_REQUEST, IdentityRequestClass))
#define IS_IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_REQUEST))
#define IS_IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_REQUEST))
#define IDENTITY_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_REQUEST, IdentityRequestClass))

typedef struct _IdentityRequest IdentityRequest;
typedef struct _IdentityRequestClass IdentityRequestClass;

#define TYPE_CUSTOM_VBOX (custom_vbox_get_type ())
#define CUSTOM_VBOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_VBOX, CustomVBox))
#define CUSTOM_VBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_VBOX, CustomVBoxClass))
#define IS_CUSTOM_VBOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_VBOX))
#define IS_CUSTOM_VBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_VBOX))
#define CUSTOM_VBOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_VBOX, CustomVBoxClass))

typedef struct _CustomVBox CustomVBox;
typedef struct _CustomVBoxClass CustomVBoxClass;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define IDENTITY_MANAGER_VIEW_TYPE_COLUMNS (identity_manager_view_columns_get_type ())
#define _identity_manager_app_unref0(var) ((var == NULL) ? NULL : (var = (identity_manager_app_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _IdentityManagerAppPrivate IdentityManagerAppPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ID_CARD_WIDGET (id_card_widget_get_type ())
#define ID_CARD_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD_WIDGET, IdCardWidget))
#define ID_CARD_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD_WIDGET, IdCardWidgetClass))
#define IS_ID_CARD_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD_WIDGET))
#define IS_ID_CARD_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD_WIDGET))
#define ID_CARD_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD_WIDGET, IdCardWidgetClass))

typedef struct _IdCardWidget IdCardWidget;
typedef struct _IdCardWidgetClass IdCardWidgetClass;

#define TYPE_ADD_PASSWORD_DIALOG (add_password_dialog_get_type ())
#define ADD_PASSWORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_PASSWORD_DIALOG, AddPasswordDialog))
#define ADD_PASSWORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_PASSWORD_DIALOG, AddPasswordDialogClass))
#define IS_ADD_PASSWORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_PASSWORD_DIALOG))
#define IS_ADD_PASSWORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_PASSWORD_DIALOG))
#define ADD_PASSWORD_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_PASSWORD_DIALOG, AddPasswordDialogClass))

typedef struct _AddPasswordDialog AddPasswordDialog;
typedef struct _AddPasswordDialogClass AddPasswordDialogClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_ADD_IDENTITY_DIALOG (add_identity_dialog_get_type ())
#define ADD_IDENTITY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_IDENTITY_DIALOG, AddIdentityDialog))
#define ADD_IDENTITY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_IDENTITY_DIALOG, AddIdentityDialogClass))
#define IS_ADD_IDENTITY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_IDENTITY_DIALOG))
#define IS_ADD_IDENTITY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_IDENTITY_DIALOG))
#define ADD_IDENTITY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_IDENTITY_DIALOG, AddIdentityDialogClass))

typedef struct _AddIdentityDialog AddIdentityDialog;
typedef struct _AddIdentityDialogClass AddIdentityDialogClass;

#define ID_CARD_TYPE_DIFF_FLAGS (id_card_diff_flags_get_type ())
typedef struct _AddIdentityDialogPrivate AddIdentityDialogPrivate;
typedef struct _IdentityRequestPrivate IdentityRequestPrivate;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IdentityManagerView {
	GtkWindow parent_instance;
	IdentityManagerViewPrivate * priv;
	IdentityManagerApp* parent_app;
	IdentityManagerModel* identities_manager;
	GQueue* request_queue;
};

struct _IdentityManagerViewClass {
	GtkWindowClass parent_class;
};

struct _IdentityManagerViewPrivate {
	GtkUIManager* ui_manager;
	GtkEntry* search_entry;
	GtkVBox* vbox_right;
	GtkVBox* login_vbox;
	GtkVBox* services_vbox;
	CustomVBox* custom_vbox;
	GtkVBox* services_internal_vbox;
	GtkEntry* issuer_entry;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkLabel* prompting_service;
	GtkLabel* no_identity_title;
	GtkCheckButton* remember_checkbutton;
	GtkButton* update_password_button;
	GtkListStore* listmodel;
	GtkTreeModelFilter* filter;
	GSList* candidates;
	GHashTable* service_button_map;
};

typedef enum  {
	IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_LOGO_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_ISSUER_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_USERNAME_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_PASSWORD_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_N_COLUMNS
} IdentityManagerViewColumns;

struct _IdentityManagerApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IdentityManagerAppPrivate * priv;
	IdentityManagerModel* model;
	IdCard* default_id_card;
	gboolean explicitly_launched;
	IdentityManagerView* view;
};

struct _IdentityManagerAppClass {
	GTypeClass parent_class;
	void (*finalize) (IdentityManagerApp *self);
};

typedef enum  {
	ID_CARD_DIFF_FLAGS_DISPLAY_NAME,
	ID_CARD_DIFF_FLAGS_USERNAME,
	ID_CARD_DIFF_FLAGS_PASSWORD,
	ID_CARD_DIFF_FLAGS_ISSUER,
	ID_CARD_DIFF_FLAGS_RULES,
	ID_CARD_DIFF_FLAGS_SERVICES,
	ID_CARD_DIFF_FLAGS_TRUST_ANCHOR
} IdCardDiffFlags;

struct _AddIdentityDialog {
	GtkDialog parent_instance;
	AddIdentityDialogPrivate * priv;
	gboolean complete;
};

struct _AddIdentityDialogClass {
	GtkDialogClass parent_class;
};

struct _IdentityRequest {
	GObject parent_instance;
	IdentityRequestPrivate * priv;
	IdCard* id_card;
	gboolean complete;
	gboolean select_default;
	gchar* nai;
	gchar* password;
	gchar* service;
	GSList* candidates;
};

struct _IdentityRequestClass {
	GObjectClass parent_class;
};


static gpointer identity_manager_view_parent_class = NULL;

GType identity_manager_view_get_type (void) G_GNUC_CONST;
gpointer identity_manager_app_ref (gpointer instance);
void identity_manager_app_unref (gpointer instance);
GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_identity_manager_app (GValue* value, gpointer v_object);
void value_take_identity_manager_app (GValue* value, gpointer v_object);
gpointer value_get_identity_manager_app (const GValue* value);
GType identity_manager_app_get_type (void) G_GNUC_CONST;
GType identity_manager_model_get_type (void) G_GNUC_CONST;
GType identity_request_get_type (void) G_GNUC_CONST;
GType custom_vbox_get_type (void) G_GNUC_CONST;
GType id_card_get_type (void) G_GNUC_CONST;
#define IDENTITY_MANAGER_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewPrivate))
enum  {
	IDENTITY_MANAGER_VIEW_DUMMY_PROPERTY
};
static GType identity_manager_view_columns_get_type (void) G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
#define IDENTITY_MANAGER_VIEW_WINDOW_WIDTH 400
#define IDENTITY_MANAGER_VIEW_WINDOW_HEIGHT 500
#define IDENTITY_MANAGER_VIEW_layout "<menubar name='MenuBar'>" "        <menu name='FileMenu' action='FileMenuAction'>" "            <menuitem name='AddIdCard' action='AddIdCardAction' />" "            <separator />" "            <menuitem name='Quit' action='QuitAction' />" "        </menu>" "" "        <menu name='HelpMenu' action='HelpMenuAction'>" "             <menuitem name='About' action='AboutAction' />" "        </menu>" "</menubar>"
IdentityManagerView* identity_manager_view_new (IdentityManagerApp* app);
IdentityManagerView* identity_manager_view_construct (GType object_type, IdentityManagerApp* app);
static void _g_free0_ (gpointer var);
static void identity_manager_view_build_ui (IdentityManagerView* self);
static void identity_manager_view_setup_list_model (IdentityManagerView* self);
static void identity_manager_view_load_id_cards (IdentityManagerView* self);
static void identity_manager_view_connect_signals (IdentityManagerView* self);
void identity_manager_view_on_card_list_changed (IdentityManagerView* self);
static gboolean identity_manager_view_visible_func (IdentityManagerView* self, GtkTreeModel* model, GtkTreeIter* iter);
const gchar* id_card_get_issuer (IdCard* self);
const gchar* id_card_get_display_name (IdCard* self);
gchar** id_card_get_services (IdCard* self, int* result_length1);
static gboolean _identity_manager_view_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static void identity_manager_view_search_entry_icon_press_cb (IdentityManagerView* self, GtkEntryIconPosition pos, GdkEvent* event);
static void identity_manager_view_search_entry_text_changed_cb (IdentityManagerView* self);
static void identity_manager_view_redraw_id_card_widgets (IdentityManagerView* self);
static gboolean identity_manager_view_search_entry_key_press_event_cb (IdentityManagerView* self, GdkEventKey* e);
static void identity_manager_view_update_password_cb (IdentityManagerView* self);
GType id_card_widget_get_type (void) G_GNUC_CONST;
IdCardWidget* custom_vbox_get_current_idcard (CustomVBox* self);
IdCard* id_card_widget_get_id_card (IdCardWidget* self);
GType add_password_dialog_get_type (void) G_GNUC_CONST;
AddPasswordDialog* add_password_dialog_new (IdCard* id_card, IdentityRequest* request);
AddPasswordDialog* add_password_dialog_construct (GType object_type, IdCard* id_card, IdentityRequest* request);
const gchar* add_password_dialog_get_password (AddPasswordDialog* self);
void id_card_set_password (IdCard* self, const gchar* value);
gboolean add_password_dialog_get_remember (AddPasswordDialog* self);
void id_card_set_store_password (IdCard* self, gboolean value);
void id_card_set_temporary (IdCard* self, gboolean value);
IdCard* identity_manager_model_update_card (IdentityManagerModel* self, IdCard* card);
const gchar* id_card_get_nai (IdCard* self);
void custom_vbox_set_current_idcard (CustomVBox* self, IdCardWidget* value);
static void identity_manager_view_remove_id_card_widget (IdentityManagerView* self, IdCardWidget* id_card_widget);
GeeLinkedList* identity_manager_model_get_card_list (IdentityManagerModel* self);
static void identity_manager_view_add_id_card_data (IdentityManagerView* self, IdCard* id_card);
static IdCardWidget* identity_manager_view_add_id_card_widget (IdentityManagerView* self, IdCard* id_card);
static void identity_manager_view_fill_details (IdentityManagerView* self, IdCardWidget* id_card_widget);
void id_card_widget_expand (IdCardWidget* self);
#define ID_CARD_NO_IDENTITY "No Identity"
const gchar* id_card_get_username (IdCard* self);
const gchar* id_card_get_password (IdCard* self);
gboolean id_card_get_store_password (IdCard* self);
static void identity_manager_view_fill_services_vbox (IdentityManagerView* self, IdCard* id_card);
static void identity_manager_view_show_details (IdentityManagerView* self, IdCard* id_card);
static void identity_manager_view_details_identity_cb (IdentityManagerView* self, IdCardWidget* id_card_widget);
GType add_identity_dialog_get_type (void) G_GNUC_CONST;
static IdCard* identity_manager_view_get_id_card_data (IdentityManagerView* self, AddIdentityDialog* dialog);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
const gchar* add_identity_dialog_get_display_name (AddIdentityDialog* self);
void id_card_set_display_name (IdCard* self, const gchar* value);
const gchar* add_identity_dialog_get_issuer (AddIdentityDialog* self);
void id_card_set_issuer (IdCard* self, const gchar* value);
const gchar* add_identity_dialog_get_username (AddIdentityDialog* self);
void id_card_set_username (IdCard* self, const gchar* value);
const gchar* add_identity_dialog_get_password (AddIdentityDialog* self);
gboolean add_identity_dialog_get_store_password (AddIdentityDialog* self);
void id_card_set_services (IdCard* self, gchar** value, int value_length1);
GdkPixbuf* get_pixbuf (IdCard* id);
static void identity_manager_view_remove_id_card_data (IdentityManagerView* self, IdCard* id_card);
IdCardWidget* id_card_widget_new (IdCard* id_card);
IdCardWidget* id_card_widget_construct (GType object_type, IdCard* id_card);
void custom_vbox_add_id_card_widget (CustomVBox* self, IdCardWidget* id_card_widget);
static void _identity_manager_view_details_identity_cb_id_card_widget_details_id (IdCardWidget* _sender, gpointer self);
static void identity_manager_view_remove_identity_cb (IdentityManagerView* self, IdCardWidget* id_card_widget);
static void _identity_manager_view_remove_identity_cb_id_card_widget_remove_id (IdCardWidget* _sender, gpointer self);
static void __lambda5_ (IdentityManagerView* self, IdCardWidget* w);
void identity_manager_view_send_identity_cb (IdentityManagerView* self, IdCard* id);
static void ___lambda5__id_card_widget_send_id (IdCardWidget* _sender, gpointer self);
void custom_vbox_receive_expanded_event (CustomVBox* self, IdCardWidget* id_card_widget);
static void _custom_vbox_receive_expanded_event_id_card_widget_expanded (IdCardWidget* _sender, gpointer self);
static void _identity_manager_view_fill_details_id_card_widget_expanded (IdCardWidget* _sender, gpointer self);
gboolean identity_manager_view_add_identity (IdentityManagerView* self, IdCard* id_card, gboolean force_flat_file_store);
IdCard* identity_manager_model_find_id_card (IdentityManagerModel* self, const gchar* nai, gboolean force_flat_file_store);
gint id_card_Compare (IdCard* self, IdCard* other);
GType id_card_diff_flags_get_type (void) G_GNUC_CONST;
void identity_manager_model_add_card (IdentityManagerModel* self, IdCard* card, gboolean force_flat_file_store);
static void identity_manager_view_add_identity_manual_cb (IdentityManagerView* self);
AddIdentityDialog* add_identity_dialog_new (void);
AddIdentityDialog* add_identity_dialog_construct (GType object_type);
void custom_vbox_remove_id_card_widget (CustomVBox* self, IdCardWidget* id_card_widget);
static void identity_manager_view_remove_identity (IdentityManagerView* self, IdCardWidget* id_card_widget);
gboolean identity_manager_model_remove_card (IdentityManagerModel* self, IdCard* card);
void identity_manager_view_set_prompting_service (IdentityManagerView* self, const gchar* service);
void identity_manager_view_queue_identity_request (IdentityManagerView* self, IdentityRequest* request);
IdCard* identity_manager_view_check_add_password (IdentityManagerView* self, IdCard* identity, IdentityRequest* request, IdentityManagerModel* model);
gboolean id_card_IsNoIdentity (IdCard* self);
void identity_request_return_identity (IdentityRequest* self, IdCard* id_card);
static void identity_manager_view_label_make_bold (IdentityManagerView* self, GtkLabel* label);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void ____lambda4_ (IdentityManagerView* self, GtkButton* remove_button);
static void _g_slist_free__g_free0_ (GSList* self);
static void _____lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void identity_manager_view_on_about_action (IdentityManagerView* self);
static GtkActionEntry* identity_manager_view_create_actions (IdentityManagerView* self, int* result_length1);
static void _vala_array_add1 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _identity_manager_view_add_identity_manual_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add2 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _gtk_main_quit_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add3 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _vala_array_add4 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _identity_manager_view_on_about_action_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add5 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void identity_manager_view_create_ui_manager (IdentityManagerView* self);
static void identity_manager_view_set_atk_name_description (IdentityManagerView* self, GtkWidget* widget, const gchar* name, const gchar* description);
GdkPixbuf* find_icon_sized (const gchar* name, GtkIconSize icon_size);
static void _identity_manager_view_search_entry_icon_press_cb_gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _identity_manager_view_search_entry_text_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _identity_manager_view_search_entry_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
CustomVBox* custom_vbox_new (IdentityManagerView* window, gboolean homogeneous, gint spacing);
CustomVBox* custom_vbox_construct (GType object_type, IdentityManagerView* window, gboolean homogeneous, gint spacing);
static void _identity_manager_view_update_password_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void identity_manager_view_set_atk_relation (GtkWidget* widget, GtkWidget* target_widget, AtkRelationType relationship);
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self);
static void _identity_manager_view_on_card_list_changed_identity_manager_model_card_list_changed (IdentityManagerModel* _sender, gpointer self);
static void identity_manager_view_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType identity_manager_view_columns_get_type (void) {
	static volatile gsize identity_manager_view_columns_type_id__volatile = 0;
	if (g_once_init_enter (&identity_manager_view_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL", "idcard-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_LOGO_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_LOGO_COL", "logo-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_ISSUER_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_ISSUER_COL", "issuer-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_USERNAME_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_USERNAME_COL", "username-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_PASSWORD_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_PASSWORD_COL", "password-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_N_COLUMNS, "IDENTITY_MANAGER_VIEW_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType identity_manager_view_columns_type_id;
		identity_manager_view_columns_type_id = g_enum_register_static ("IdentityManagerViewColumns", values);
		g_once_init_leave (&identity_manager_view_columns_type_id__volatile, identity_manager_view_columns_type_id);
	}
	return identity_manager_view_columns_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 415 "moonshot-identity-management-view.c"
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_queue_free (self);
#line 424 "moonshot-identity-management-view.c"
}


static gpointer _identity_manager_app_ref0 (gpointer self) {
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return self ? identity_manager_app_ref (self) : NULL;
#line 431 "moonshot-identity-management-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 438 "moonshot-identity-management-view.c"
}


static void _g_free0_ (gpointer var) {
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	var = (g_free (var), NULL);
#line 445 "moonshot-identity-management-view.c"
}


IdentityManagerView* identity_manager_view_construct (GType object_type, IdentityManagerApp* app) {
	IdentityManagerView * self = NULL;
	IdentityManagerApp* _tmp0_ = NULL;
	IdentityManagerApp* _tmp1_ = NULL;
	IdentityManagerApp* _tmp2_ = NULL;
	IdentityManagerModel* _tmp3_ = NULL;
	IdentityManagerModel* _tmp4_ = NULL;
	GQueue* _tmp5_ = NULL;
	GHashFunc _tmp6_ = NULL;
	GEqualFunc _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self = (IdentityManagerView*) g_object_new (object_type, NULL);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = app;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = _identity_manager_app_ref0 (_tmp0_);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_identity_manager_app_unref0 (self->parent_app);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->parent_app = _tmp1_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = self->parent_app;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_->model;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->identities_manager);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->identities_manager = _tmp4_;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = g_queue_new ();
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__g_queue_free__g_object_unref0_0 (self->request_queue);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->request_queue = _tmp5_;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = g_direct_hash;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = g_direct_equal;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_object_unref0_, _g_free0_);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_hash_table_unref0 (self->priv->service_button_map);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->service_button_map = _tmp8_;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_set_title ((GtkWindow*) self, "Moonshot Identity Selector");
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_set_default_size ((GtkWindow*) self, IDENTITY_MANAGER_VIEW_WINDOW_WIDTH, IDENTITY_MANAGER_VIEW_WINDOW_HEIGHT);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_build_ui (self);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_setup_list_model (self);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_load_id_cards (self);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_connect_signals (self);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return self;
#line 514 "moonshot-identity-management-view.c"
}


IdentityManagerView* identity_manager_view_new (IdentityManagerApp* app) {
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return identity_manager_view_construct (TYPE_IDENTITY_MANAGER_VIEW, app);
#line 521 "moonshot-identity-management-view.c"
}


void identity_manager_view_on_card_list_changed (IdentityManagerView* self) {
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_load_id_cards (self);
#line 530 "moonshot-identity-management-view.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1274 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1274 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1275 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 550 "moonshot-identity-management-view.c"
}


static gboolean identity_manager_view_visible_func (IdentityManagerView* self, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	IdCard* id_card = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	IdCard* _tmp2_ = NULL;
	GSList* _tmp3_ = NULL;
	gchar* entry_text = NULL;
	GtkEntry* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = model;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = *iter;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_tree_model_get (_tmp0_, &_tmp1_, IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL, &id_card, -1);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp2_ == NULL) {
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		result = FALSE;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (id_card);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return result;
#line 592 "moonshot-identity-management-view.c"
	}
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->priv->candidates;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp3_ != NULL) {
#line 598 "moonshot-identity-management-view.c"
		gboolean is_candidate = FALSE;
		GSList* _tmp4_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		is_candidate = FALSE;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = self->priv->candidates;
#line 606 "moonshot-identity-management-view.c"
		{
			GSList* candidate_collection = NULL;
			GSList* candidate_it = NULL;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			candidate_collection = _tmp4_;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			for (candidate_it = candidate_collection; candidate_it != NULL; candidate_it = candidate_it->next) {
#line 614 "moonshot-identity-management-view.c"
				IdCard* _tmp5_ = NULL;
				IdCard* candidate = NULL;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp5_ = _g_object_ref0 ((IdCard*) candidate_it->data);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				candidate = _tmp5_;
#line 621 "moonshot-identity-management-view.c"
				{
					IdCard* _tmp6_ = NULL;
					IdCard* _tmp7_ = NULL;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp6_ = candidate;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp7_ = id_card;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp6_ == _tmp7_) {
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						is_candidate = TRUE;
#line 633 "moonshot-identity-management-view.c"
					}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_object_unref0 (candidate);
#line 637 "moonshot-identity-management-view.c"
				}
			}
		}
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = is_candidate;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (!_tmp8_) {
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			result = FALSE;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (id_card);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			return result;
#line 651 "moonshot-identity-management-view.c"
		}
	}
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = self->priv->search_entry;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = gtk_entry_get_text (_tmp9_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	entry_text = _tmp11_;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = entry_text;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp13_ == NULL) {
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = TRUE;
#line 668 "moonshot-identity-management-view.c"
	} else {
		const gchar* _tmp14_ = NULL;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = entry_text;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = g_strcmp0 (_tmp14_, "") == 0;
#line 675 "moonshot-identity-management-view.c"
	}
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp12_) {
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		result = TRUE;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (entry_text);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (id_card);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return result;
#line 687 "moonshot-identity-management-view.c"
	}
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = entry_text;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, " ", 0);
#line 693 "moonshot-identity-management-view.c"
	{
		gchar** search_text_collection = NULL;
		gint search_text_collection_length1 = 0;
		gint _search_text_collection_size_ = 0;
		gint search_text_it = 0;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		search_text_collection = _tmp17_;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		search_text_collection_length1 = _vala_array_length (_tmp16_);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		for (search_text_it = 0; search_text_it < _vala_array_length (_tmp16_); search_text_it = search_text_it + 1) {
#line 705 "moonshot-identity-management-view.c"
			gchar* _tmp18_ = NULL;
			gchar* search_text = NULL;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp18_ = g_strdup (search_text_collection[search_text_it]);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			search_text = _tmp18_;
#line 712 "moonshot-identity-management-view.c"
			{
				const gchar* _tmp19_ = NULL;
				gchar* search_text_casefold = NULL;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				IdCard* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				IdCard* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				IdCard* _tmp42_ = NULL;
				gchar** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gchar** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp19_ = search_text;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (g_strcmp0 (_tmp19_, "") == 0) {
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_free0 (search_text);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					continue;
#line 737 "moonshot-identity-management-view.c"
				}
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp20_ = search_text;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp21_ = g_utf8_casefold (_tmp20_, (gssize) (-1));
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				search_text_casefold = _tmp21_;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp22_ = id_card;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp23_ = id_card_get_issuer (_tmp22_);
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp24_ = _tmp23_;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (_tmp24_ != NULL) {
#line 753 "moonshot-identity-management-view.c"
					gchar* issuer_casefold = NULL;
					IdCard* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					gboolean _tmp31_ = FALSE;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp25_ = id_card;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp26_ = id_card_get_issuer (_tmp25_);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp27_ = _tmp26_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp28_ = g_strdup (_tmp27_);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					issuer_casefold = _tmp28_;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp29_ = issuer_casefold;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp30_ = search_text_casefold;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp31_ = string_contains (_tmp29_, _tmp30_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp31_) {
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						result = TRUE;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (issuer_casefold);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (search_text_casefold);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (search_text);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						search_text_collection = (_vala_array_free (search_text_collection, search_text_collection_length1, (GDestroyNotify) g_free), NULL);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (entry_text);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_object_unref0 (id_card);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						return result;
#line 796 "moonshot-identity-management-view.c"
					}
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_free0 (issuer_casefold);
#line 800 "moonshot-identity-management-view.c"
				}
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp32_ = id_card;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp33_ = id_card_get_display_name (_tmp32_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp34_ = _tmp33_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (_tmp34_ != NULL) {
#line 810 "moonshot-identity-management-view.c"
					gchar* display_name_casefold = NULL;
					IdCard* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					gboolean _tmp41_ = FALSE;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp35_ = id_card;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp36_ = id_card_get_display_name (_tmp35_);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp37_ = _tmp36_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp38_ = g_utf8_casefold (_tmp37_, (gssize) (-1));
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					display_name_casefold = _tmp38_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp39_ = display_name_casefold;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp40_ = search_text_casefold;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp41_ = string_contains (_tmp39_, _tmp40_);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp41_) {
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						result = TRUE;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (display_name_casefold);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (search_text_casefold);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (search_text);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						search_text_collection = (_vala_array_free (search_text_collection, search_text_collection_length1, (GDestroyNotify) g_free), NULL);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (entry_text);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_object_unref0 (id_card);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						return result;
#line 853 "moonshot-identity-management-view.c"
					}
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_free0 (display_name_casefold);
#line 857 "moonshot-identity-management-view.c"
				}
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp42_ = id_card;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp43_ = id_card_get_services (_tmp42_, &_tmp43__length1);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp44_ = _tmp43_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp44__length1 = _tmp43__length1;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (_tmp44__length1 > 0) {
#line 869 "moonshot-identity-management-view.c"
					IdCard* _tmp45_ = NULL;
					gchar** _tmp46_ = NULL;
					gint _tmp46__length1 = 0;
					gchar** _tmp47_ = NULL;
					gint _tmp47__length1 = 0;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp45_ = id_card;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp46_ = id_card_get_services (_tmp45_, &_tmp46__length1);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp47_ = _tmp46_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp47__length1 = _tmp46__length1;
#line 883 "moonshot-identity-management-view.c"
					{
						gchar** service_collection = NULL;
						gint service_collection_length1 = 0;
						gint _service_collection_size_ = 0;
						gint service_it = 0;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						service_collection = _tmp47_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						service_collection_length1 = _tmp47__length1;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						for (service_it = 0; service_it < _tmp47__length1; service_it = service_it + 1) {
#line 895 "moonshot-identity-management-view.c"
							gchar* _tmp48_ = NULL;
							gchar* service = NULL;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp48_ = g_strdup (service_collection[service_it]);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							service = _tmp48_;
#line 902 "moonshot-identity-management-view.c"
							{
								gchar* service_casefold = NULL;
								const gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								const gchar* _tmp51_ = NULL;
								const gchar* _tmp52_ = NULL;
								gboolean _tmp53_ = FALSE;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_tmp49_ = service;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_tmp50_ = g_utf8_casefold (_tmp49_, (gssize) (-1));
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								service_casefold = _tmp50_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_tmp51_ = service_casefold;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_tmp52_ = search_text_casefold;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_tmp53_ = string_contains (_tmp51_, _tmp52_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								if (_tmp53_) {
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
									result = TRUE;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
									_g_free0 (service_casefold);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
									_g_free0 (service);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
									_g_free0 (search_text_casefold);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
									_g_free0 (search_text);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
									search_text_collection = (_vala_array_free (search_text_collection, search_text_collection_length1, (GDestroyNotify) g_free), NULL);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
									_g_free0 (entry_text);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
									_g_object_unref0 (id_card);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
									return result;
#line 942 "moonshot-identity-management-view.c"
								}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_g_free0 (service_casefold);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_g_free0 (service);
#line 948 "moonshot-identity-management-view.c"
							}
						}
					}
				}
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_free0 (search_text_casefold);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_free0 (search_text);
#line 957 "moonshot-identity-management-view.c"
			}
		}
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		search_text_collection = (_vala_array_free (search_text_collection, search_text_collection_length1, (GDestroyNotify) g_free), NULL);
#line 962 "moonshot-identity-management-view.c"
	}
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = FALSE;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (entry_text);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (id_card);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 972 "moonshot-identity-management-view.c"
}


static gboolean _identity_manager_view_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = identity_manager_view_visible_func ((IdentityManagerView*) self, model, iter);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 981 "moonshot-identity-management-view.c"
}


static void identity_manager_view_setup_list_model (IdentityManagerView* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	GtkTreeModelFilter* _tmp2_ = NULL;
	GtkTreeModelFilter* _tmp3_ = NULL;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = gtk_list_store_new ((gint) IDENTITY_MANAGER_VIEW_COLUMNS_N_COLUMNS, TYPE_ID_CARD, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->listmodel = _tmp0_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = self->priv->listmodel;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp1_, NULL);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->filter);
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->filter = _tmp2_;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->priv->filter;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_tree_model_filter_set_visible_func (_tmp3_, _identity_manager_view_visible_func_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
#line 1008 "moonshot-identity-management-view.c"
}


static void identity_manager_view_search_entry_icon_press_cb (IdentityManagerView* self, GtkEntryIconPosition pos, GdkEvent* event) {
	GtkEntryIconPosition _tmp0_ = 0;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (event != NULL);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = pos;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp0_ == GTK_ENTRY_ICON_PRIMARY) {
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		g_print ("Search entry icon pressed\n");
#line 1024 "moonshot-identity-management-view.c"
	} else {
		GtkEntry* _tmp1_ = NULL;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp1_ = self->priv->search_entry;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_entry_set_text (_tmp1_, "");
#line 1031 "moonshot-identity-management-view.c"
	}
}


static void identity_manager_view_search_entry_text_changed_cb (IdentityManagerView* self) {
	GtkTreeModelFilter* _tmp0_ = NULL;
	gboolean has_text = FALSE;
	GtkEntry* _tmp1_ = NULL;
	guint16 _tmp2_ = 0U;
	GtkEntry* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	GtkVBox* _tmp5_ = NULL;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->filter;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_tree_model_filter_refilter (_tmp0_);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_redraw_id_card_widgets (self);
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = self->priv->search_entry;
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = gtk_entry_get_text_length (_tmp1_);
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	has_text = ((gint) _tmp2_) > 0;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->priv->search_entry;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_sensitive (_tmp3_, GTK_ENTRY_ICON_PRIMARY, has_text);
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = self->priv->search_entry;
#line 209 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_sensitive (_tmp4_, GTK_ENTRY_ICON_SECONDARY, has_text);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = self->priv->vbox_right;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
#line 1070 "moonshot-identity-management-view.c"
}


static gboolean identity_manager_view_search_entry_key_press_event_cb (IdentityManagerView* self, GdkEventKey* e) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_ = {0};
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 214 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (e != NULL, FALSE);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = *e;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = _tmp0_.keyval;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = gdk_keyval_name (_tmp1_);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (g_strcmp0 (_tmp2_, "Escape") == 0) {
#line 1091 "moonshot-identity-management-view.c"
		GtkEntry* _tmp3_ = NULL;
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = self->priv->search_entry;
#line 217 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_entry_set_text (_tmp3_, "");
#line 1097 "moonshot-identity-management-view.c"
	}
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = FALSE;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 1103 "moonshot-identity-management-view.c"
}


static void identity_manager_view_update_password_cb (IdentityManagerView* self) {
	CustomVBox* _tmp0_ = NULL;
	IdCardWidget* _tmp1_ = NULL;
	IdCardWidget* _tmp2_ = NULL;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->custom_vbox;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = custom_vbox_get_current_idcard (_tmp0_);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _tmp1_;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp2_ != NULL) {
#line 1121 "moonshot-identity-management-view.c"
		IdCard* identity = NULL;
		CustomVBox* _tmp3_ = NULL;
		IdCardWidget* _tmp4_ = NULL;
		IdCardWidget* _tmp5_ = NULL;
		IdCard* _tmp6_ = NULL;
		IdCard* _tmp7_ = NULL;
		IdCard* _tmp8_ = NULL;
		AddPasswordDialog* dialog = NULL;
		IdCard* _tmp9_ = NULL;
		AddPasswordDialog* _tmp10_ = NULL;
		gint _result_ = 0;
		AddPasswordDialog* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		AddPasswordDialog* _tmp29_ = NULL;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = self->priv->custom_vbox;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = custom_vbox_get_current_idcard (_tmp3_);
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = _tmp4_;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = id_card_widget_get_id_card (_tmp5_);
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = _tmp6_;
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 227 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity = _tmp8_;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = identity;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = add_password_dialog_new (_tmp9_, NULL);
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		g_object_ref_sink (_tmp10_);
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		dialog = _tmp10_;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp11_ = dialog;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = gtk_dialog_run ((GtkDialog*) _tmp11_);
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_result_ = _tmp12_;
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp13_ = _result_;
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		switch (_tmp13_) {
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			case GTK_RESPONSE_OK:
#line 1171 "moonshot-identity-management-view.c"
			{
				IdCard* _tmp14_ = NULL;
				AddPasswordDialog* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				IdCard* _tmp18_ = NULL;
				AddPasswordDialog* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				AddPasswordDialog* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				IdentityManagerModel* _tmp26_ = NULL;
				IdCard* _tmp27_ = NULL;
				IdCard* _tmp28_ = NULL;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp14_ = identity;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp15_ = dialog;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp16_ = add_password_dialog_get_password (_tmp15_);
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp17_ = _tmp16_;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				id_card_set_password (_tmp14_, _tmp17_);
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp18_ = identity;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp19_ = dialog;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp20_ = add_password_dialog_get_remember (_tmp19_);
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp21_ = _tmp20_;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				id_card_set_store_password (_tmp18_, _tmp21_);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp22_ = dialog;
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp23_ = add_password_dialog_get_remember (_tmp22_);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp24_ = _tmp23_;
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (_tmp24_) {
#line 1215 "moonshot-identity-management-view.c"
					IdCard* _tmp25_ = NULL;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp25_ = identity;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					id_card_set_temporary (_tmp25_, FALSE);
#line 1221 "moonshot-identity-management-view.c"
				}
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp26_ = self->identities_manager;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp27_ = identity;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp28_ = identity_manager_model_update_card (_tmp26_, _tmp27_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (identity);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				identity = _tmp28_;
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				break;
#line 1235 "moonshot-identity-management-view.c"
			}
			default:
			{
#line 240 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				break;
#line 1241 "moonshot-identity-management-view.c"
			}
		}
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp29_ = dialog;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_object_destroy ((GtkObject*) _tmp29_);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (dialog);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (identity);
#line 1252 "moonshot-identity-management-view.c"
	}
}


static void identity_manager_view_load_id_cards (IdentityManagerView* self) {
	gchar* current_idcard_nai = NULL;
	CustomVBox* _tmp0_ = NULL;
	IdCardWidget* _tmp1_ = NULL;
	IdCardWidget* _tmp2_ = NULL;
	GList* children = NULL;
	CustomVBox* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	GList* _tmp14_ = NULL;
	GtkListStore* _tmp16_ = NULL;
	GeeLinkedList* card_list = NULL;
	IdentityManagerModel* _tmp17_ = NULL;
	GeeLinkedList* _tmp18_ = NULL;
	GeeLinkedList* _tmp19_ = NULL;
	CustomVBox* _tmp42_ = NULL;
	IdCardWidget* _tmp43_ = NULL;
	IdCardWidget* _tmp44_ = NULL;
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	current_idcard_nai = NULL;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->custom_vbox;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = custom_vbox_get_current_idcard (_tmp0_);
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _tmp1_;
#line 248 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp2_ != NULL) {
#line 1286 "moonshot-identity-management-view.c"
		CustomVBox* _tmp3_ = NULL;
		IdCardWidget* _tmp4_ = NULL;
		IdCardWidget* _tmp5_ = NULL;
		IdCard* _tmp6_ = NULL;
		IdCard* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		CustomVBox* _tmp11_ = NULL;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = self->priv->custom_vbox;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = custom_vbox_get_current_idcard (_tmp3_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = _tmp4_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = id_card_widget_get_id_card (_tmp5_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = _tmp6_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = id_card_get_nai (_tmp7_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = _tmp8_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (current_idcard_nai);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		current_idcard_nai = _tmp10_;
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp11_ = self->priv->custom_vbox;
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		custom_vbox_set_current_idcard (_tmp11_, NULL);
#line 1320 "moonshot-identity-management-view.c"
	}
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = self->priv->custom_vbox;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = gtk_container_get_children ((GtkContainer*) _tmp12_);
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	children = _tmp13_;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = children;
#line 1330 "moonshot-identity-management-view.c"
	{
		GList* id_card_widget_collection = NULL;
		GList* id_card_widget_it = NULL;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		id_card_widget_collection = _tmp14_;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		for (id_card_widget_it = id_card_widget_collection; id_card_widget_it != NULL; id_card_widget_it = id_card_widget_it->next) {
#line 1338 "moonshot-identity-management-view.c"
			GtkWidget* id_card_widget = NULL;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			id_card_widget = (GtkWidget*) id_card_widget_it->data;
#line 1342 "moonshot-identity-management-view.c"
			{
				GtkWidget* _tmp15_ = NULL;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp15_ = id_card_widget;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				identity_manager_view_remove_id_card_widget (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_ID_CARD_WIDGET, IdCardWidget));
#line 1349 "moonshot-identity-management-view.c"
			}
		}
	}
#line 256 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = self->priv->listmodel;
#line 256 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_list_store_clear (_tmp16_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = self->identities_manager;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp18_ = identity_manager_model_get_card_list (_tmp17_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	card_list = _tmp18_;
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp19_ = card_list;
#line 258 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp19_ == NULL) {
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (card_list);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_list_free0 (children);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (current_idcard_nai);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return;
#line 1375 "moonshot-identity-management-view.c"
	}
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp20_ = NULL;
		GeeLinkedList* _tmp21_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _id_card_index = 0;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp20_ = card_list;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_id_card_list = _tmp21_;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp22_ = _id_card_list;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24_ = _tmp23_;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_id_card_size = _tmp24_;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_id_card_index = -1;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		while (TRUE) {
#line 1404 "moonshot-identity-management-view.c"
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gpointer _tmp30_ = NULL;
			IdCard* _tmp31_ = NULL;
			IdCardWidget* id_card_widget = NULL;
			IdCard* _tmp32_ = NULL;
			IdCardWidget* _tmp33_ = NULL;
			IdCardWidget* _tmp34_ = NULL;
			IdCard* _tmp35_ = NULL;
			IdCard* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp25_ = _id_card_index;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_id_card_index = _tmp25_ + 1;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp26_ = _id_card_index;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp27_ = _id_card_size;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			if (!(_tmp26_ < _tmp27_)) {
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				break;
#line 1434 "moonshot-identity-management-view.c"
			}
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp28_ = _id_card_list;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp29_ = _id_card_index;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			id_card = (IdCard*) _tmp30_;
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp31_ = id_card;
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			identity_manager_view_add_id_card_data (self, _tmp31_);
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp32_ = id_card;
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp33_ = identity_manager_view_add_id_card_widget (self, _tmp32_);
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			id_card_widget = _tmp33_;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp34_ = id_card_widget;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp35_ = id_card_widget_get_id_card (_tmp34_);
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp36_ = _tmp35_;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp37_ = id_card_get_nai (_tmp36_);
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp38_ = _tmp37_;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp39_ = current_idcard_nai;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			if (g_strcmp0 (_tmp38_, _tmp39_) == 0) {
#line 1468 "moonshot-identity-management-view.c"
				IdCardWidget* _tmp40_ = NULL;
				IdCardWidget* _tmp41_ = NULL;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp40_ = id_card_widget;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				identity_manager_view_fill_details (self, _tmp40_);
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp41_ = id_card_widget;
#line 267 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				id_card_widget_expand (_tmp41_);
#line 1479 "moonshot-identity-management-view.c"
			}
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (id_card_widget);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (id_card);
#line 1485 "moonshot-identity-management-view.c"
		}
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_id_card_list);
#line 1489 "moonshot-identity-management-view.c"
	}
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp42_ = self->priv->custom_vbox;
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp43_ = custom_vbox_get_current_idcard (_tmp42_);
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp44_ = _tmp43_;
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp44_ == NULL) {
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_fill_details (self, NULL);
#line 1501 "moonshot-identity-management-view.c"
	}
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (card_list);
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_list_free0 (children);
#line 246 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (current_idcard_nai);
#line 1509 "moonshot-identity-management-view.c"
}


static void identity_manager_view_fill_details (IdentityManagerView* self, IdCardWidget* id_card_widget) {
	GList* vr_children = NULL;
	GtkVBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	IdCardWidget* _tmp5_ = NULL;
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->vbox_right;
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	vr_children = _tmp1_;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = vr_children;
#line 1529 "moonshot-identity-management-view.c"
	{
		GList* vr_child_collection = NULL;
		GList* vr_child_it = NULL;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		vr_child_collection = _tmp2_;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		for (vr_child_it = vr_child_collection; vr_child_it != NULL; vr_child_it = vr_child_it->next) {
#line 1537 "moonshot-identity-management-view.c"
			GtkWidget* vr_child = NULL;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			vr_child = (GtkWidget*) vr_child_it->data;
#line 1541 "moonshot-identity-management-view.c"
			{
				GtkVBox* _tmp3_ = NULL;
				GtkWidget* _tmp4_ = NULL;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp3_ = self->priv->vbox_right;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp4_ = vr_child;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				gtk_container_remove ((GtkContainer*) _tmp3_, _tmp4_);
#line 1551 "moonshot-identity-management-view.c"
			}
		}
	}
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = id_card_widget;
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp5_ != NULL) {
#line 1559 "moonshot-identity-management-view.c"
		IdCard* id_card = NULL;
		IdCardWidget* _tmp6_ = NULL;
		IdCard* _tmp7_ = NULL;
		IdCard* _tmp8_ = NULL;
		IdCard* _tmp9_ = NULL;
		IdCard* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkVBox* _tmp34_ = NULL;
		GtkVBox* _tmp35_ = NULL;
		GList* children = NULL;
		GtkVBox* _tmp36_ = NULL;
		GList* _tmp37_ = NULL;
		GList* _tmp38_ = NULL;
		IdCardWidget* _tmp41_ = NULL;
		IdCard* _tmp42_ = NULL;
		IdCard* _tmp43_ = NULL;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = id_card_widget;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = id_card_widget_get_id_card (_tmp6_);
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = _tmp7_;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		id_card = _tmp9_;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = id_card;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp11_ = id_card_get_display_name (_tmp10_);
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = _tmp11_;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (g_strcmp0 (_tmp12_, ID_CARD_NO_IDENTITY) == 0) {
#line 1595 "moonshot-identity-management-view.c"
			GtkVBox* _tmp13_ = NULL;
			GtkLabel* _tmp14_ = NULL;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp13_ = self->priv->vbox_right;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp14_ = self->priv->no_identity_title;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_box_pack_start ((GtkBox*) _tmp13_, (GtkWidget*) _tmp14_, FALSE, TRUE, (guint) 0);
#line 1604 "moonshot-identity-management-view.c"
		} else {
			GtkEntry* _tmp15_ = NULL;
			IdCard* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			GtkEntry* _tmp19_ = NULL;
			IdCard* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			IdCard* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			GtkEntry* _tmp27_ = NULL;
			GtkVBox* _tmp28_ = NULL;
			GtkVBox* _tmp29_ = NULL;
			GtkCheckButton* _tmp30_ = NULL;
			IdCard* _tmp31_ = NULL;
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_ = FALSE;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp15_ = self->priv->issuer_entry;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp16_ = id_card;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp17_ = id_card_get_issuer (_tmp16_);
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp18_ = _tmp17_;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_entry_set_text (_tmp15_, _tmp18_);
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp19_ = self->priv->username_entry;
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp20_ = id_card;
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp21_ = id_card_get_username (_tmp20_);
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp22_ = _tmp21_;
#line 285 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_entry_set_text (_tmp19_, _tmp22_);
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp24_ = id_card;
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp25_ = id_card_get_password (_tmp24_);
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp26_ = _tmp25_;
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp23_ = _tmp26_;
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			if (_tmp23_ == NULL) {
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp23_ = "";
#line 1657 "moonshot-identity-management-view.c"
			}
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp27_ = self->priv->password_entry;
#line 286 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_entry_set_text (_tmp27_, _tmp23_);
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp28_ = self->priv->vbox_right;
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp29_ = self->priv->login_vbox;
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_box_pack_start ((GtkBox*) _tmp28_, (GtkWidget*) _tmp29_, FALSE, TRUE, (guint) 0);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp30_ = self->priv->remember_checkbutton;
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp31_ = id_card;
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp32_ = id_card_get_store_password (_tmp31_);
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp33_ = _tmp32_;
#line 288 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp30_, _tmp33_);
#line 1679 "moonshot-identity-management-view.c"
		}
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp34_ = self->priv->vbox_right;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp35_ = self->priv->services_vbox;
#line 290 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_box_pack_start ((GtkBox*) _tmp34_, (GtkWidget*) _tmp35_, FALSE, TRUE, (guint) 0);
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp36_ = self->priv->services_internal_vbox;
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp37_ = gtk_container_get_children ((GtkContainer*) _tmp36_);
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		children = _tmp37_;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp38_ = children;
#line 1695 "moonshot-identity-management-view.c"
		{
			GList* hbox_collection = NULL;
			GList* hbox_it = NULL;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			hbox_collection = _tmp38_;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			for (hbox_it = hbox_collection; hbox_it != NULL; hbox_it = hbox_it->next) {
#line 1703 "moonshot-identity-management-view.c"
				GtkWidget* hbox = NULL;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				hbox = (GtkWidget*) hbox_it->data;
#line 1707 "moonshot-identity-management-view.c"
				{
					GtkVBox* _tmp39_ = NULL;
					GtkWidget* _tmp40_ = NULL;
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp39_ = self->priv->services_internal_vbox;
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp40_ = hbox;
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					gtk_container_remove ((GtkContainer*) _tmp39_, _tmp40_);
#line 1717 "moonshot-identity-management-view.c"
				}
			}
		}
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp41_ = id_card_widget;
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp42_ = id_card_widget_get_id_card (_tmp41_);
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp43_ = _tmp42_;
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_fill_services_vbox (self, _tmp43_);
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_list_free0 (children);
#line 279 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (id_card);
#line 1733 "moonshot-identity-management-view.c"
	}
#line 274 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_list_free0 (vr_children);
#line 1737 "moonshot-identity-management-view.c"
}


static void identity_manager_view_show_details (IdentityManagerView* self, IdCard* id_card) {
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkVBox* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card != NULL);
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->vbox_right;
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = self->priv->vbox_right;
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, !_tmp2_);
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->priv->vbox_right;
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = gtk_widget_get_visible ((GtkWidget*) _tmp3_);
#line 303 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp4_ == FALSE) {
#line 305 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_window_resize ((GtkWindow*) self, IDENTITY_MANAGER_VIEW_WINDOW_WIDTH, IDENTITY_MANAGER_VIEW_WINDOW_HEIGHT);
#line 1767 "moonshot-identity-management-view.c"
	}
}


static void identity_manager_view_details_identity_cb (IdentityManagerView* self, IdCardWidget* id_card_widget) {
	IdCardWidget* _tmp0_ = NULL;
	IdCardWidget* _tmp1_ = NULL;
	IdCard* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card_widget != NULL);
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = id_card_widget;
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_fill_details (self, _tmp0_);
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card_widget;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card_widget_get_id_card (_tmp1_);
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 312 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_show_details (self, _tmp3_);
#line 1793 "moonshot-identity-management-view.c"
}


static IdCard* identity_manager_view_get_id_card_data (IdentityManagerView* self, AddIdentityDialog* dialog) {
	IdCard* result = NULL;
	IdCard* id_card = NULL;
	IdCard* _tmp0_ = NULL;
	AddIdentityDialog* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	AddIdentityDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	AddIdentityDialog* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	AddIdentityDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	AddIdentityDialog* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (dialog != NULL, NULL);
#line 317 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = id_card_new ();
#line 317 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card = _tmp0_;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = dialog;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = add_identity_dialog_get_display_name (_tmp1_);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_display_name (id_card, _tmp3_);
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = dialog;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = add_identity_dialog_get_issuer (_tmp4_);
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = _tmp5_;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_issuer (id_card, _tmp6_);
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = dialog;
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = add_identity_dialog_get_username (_tmp7_);
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = _tmp8_;
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_username (id_card, _tmp9_);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = dialog;
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = add_identity_dialog_get_password (_tmp10_);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _tmp11_;
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_password (id_card, _tmp12_);
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = dialog;
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = add_identity_dialog_get_store_password (_tmp13_);
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = _tmp14_;
#line 323 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_store_password (id_card, _tmp15_);
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = g_new0 (gchar*, 0 + 1);
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = _tmp16_;
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17__length1 = 0;
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_services (id_card, _tmp17_, 0);
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
#line 326 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = id_card;
#line 326 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 1881 "moonshot-identity-management-view.c"
}


static void identity_manager_view_add_id_card_data (IdentityManagerView* self, IdCard* id_card) {
	GtkTreeIter iter = {0};
	GdkPixbuf* pixbuf = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	IdCard* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	IdCard* _tmp6_ = NULL;
	IdCard* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	IdCard* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	IdCard* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card != NULL);
#line 333 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->listmodel;
#line 333 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_list_store_append (_tmp0_, &_tmp1_);
#line 333 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	iter = _tmp1_;
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card;
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = get_pixbuf (_tmp2_);
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (pixbuf);
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	pixbuf = _tmp3_;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = self->priv->listmodel;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = iter;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = id_card;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = id_card;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = id_card_get_issuer (_tmp7_);
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = _tmp8_;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = id_card;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = id_card_get_username (_tmp10_);
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _tmp11_;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = id_card;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = id_card_get_password (_tmp13_);
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = _tmp14_;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_list_store_set (_tmp4_, &_tmp5_, IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL, _tmp6_, IDENTITY_MANAGER_VIEW_COLUMNS_LOGO_COL, pixbuf, IDENTITY_MANAGER_VIEW_COLUMNS_ISSUER_COL, _tmp9_, IDENTITY_MANAGER_VIEW_COLUMNS_USERNAME_COL, _tmp12_, IDENTITY_MANAGER_VIEW_COLUMNS_PASSWORD_COL, _tmp15_, -1);
#line 329 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (pixbuf);
#line 1950 "moonshot-identity-management-view.c"
}


static void identity_manager_view_remove_id_card_data (IdentityManagerView* self, IdCard* id_card) {
	GtkTreeIter iter = {0};
	gchar* issuer = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card != NULL);
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->listmodel;
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	iter = _tmp1_;
#line 348 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp2_) {
#line 1972 "moonshot-identity-management-view.c"
		{
			gboolean _tmp3_ = FALSE;
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp3_ = TRUE;
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			while (TRUE) {
#line 1979 "moonshot-identity-management-view.c"
				GtkListStore* _tmp6_ = NULL;
				GtkTreeIter _tmp7_ = {0};
				IdCard* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (!_tmp3_) {
#line 1988 "moonshot-identity-management-view.c"
					GtkListStore* _tmp4_ = NULL;
					gboolean _tmp5_ = FALSE;
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp4_ = self->priv->listmodel;
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (!_tmp5_) {
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						break;
#line 1999 "moonshot-identity-management-view.c"
					}
				}
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp3_ = FALSE;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp6_ = self->priv->listmodel;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp7_ = iter;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, IDENTITY_MANAGER_VIEW_COLUMNS_ISSUER_COL, &issuer, -1);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp8_ = id_card;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp9_ = id_card_get_issuer (_tmp8_);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp10_ = _tmp9_;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp11_ = issuer;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
#line 2020 "moonshot-identity-management-view.c"
					GtkListStore* _tmp12_ = NULL;
					GtkTreeIter _tmp13_ = {0};
#line 357 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp12_ = self->priv->listmodel;
#line 357 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp13_ = iter;
#line 357 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					gtk_list_store_remove (_tmp12_, &_tmp13_);
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					break;
#line 2031 "moonshot-identity-management-view.c"
				}
			}
		}
	}
#line 343 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (issuer);
#line 2038 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_details_identity_cb_id_card_widget_details_id (IdCardWidget* _sender, gpointer self) {
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_details_identity_cb ((IdentityManagerView*) self, _sender);
#line 2045 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_remove_identity_cb_id_card_widget_remove_id (IdCardWidget* _sender, gpointer self) {
#line 370 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_remove_identity_cb ((IdentityManagerView*) self, _sender);
#line 2052 "moonshot-identity-management-view.c"
}


static void __lambda5_ (IdentityManagerView* self, IdCardWidget* w) {
	IdCardWidget* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IdCard* _tmp2_ = NULL;
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (w != NULL);
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = w;
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card_widget_get_id_card (_tmp0_);
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _tmp1_;
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_send_identity_cb (self, _tmp2_);
#line 2070 "moonshot-identity-management-view.c"
}


static void ___lambda5__id_card_widget_send_id (IdCardWidget* _sender, gpointer self) {
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__lambda5_ ((IdentityManagerView*) self, _sender);
#line 2077 "moonshot-identity-management-view.c"
}


static void _custom_vbox_receive_expanded_event_id_card_widget_expanded (IdCardWidget* _sender, gpointer self) {
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	custom_vbox_receive_expanded_event ((CustomVBox*) self, _sender);
#line 2084 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_fill_details_id_card_widget_expanded (IdCardWidget* _sender, gpointer self) {
#line 373 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_fill_details ((IdentityManagerView*) self, _sender);
#line 2091 "moonshot-identity-management-view.c"
}


static IdCardWidget* identity_manager_view_add_id_card_widget (IdentityManagerView* self, IdCard* id_card) {
	IdCardWidget* result = NULL;
	IdCardWidget* id_card_widget = NULL;
	IdCard* _tmp0_ = NULL;
	IdCardWidget* _tmp1_ = NULL;
	CustomVBox* _tmp2_ = NULL;
	CustomVBox* _tmp3_ = NULL;
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 365 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (id_card != NULL, NULL);
#line 367 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = id_card;
#line 367 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card_widget_new (_tmp0_);
#line 367 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp1_);
#line 367 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_widget = _tmp1_;
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = self->priv->custom_vbox;
#line 368 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	custom_vbox_add_id_card_widget (_tmp2_, id_card_widget);
#line 369 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (id_card_widget, "details-id", (GCallback) _identity_manager_view_details_identity_cb_id_card_widget_details_id, self, 0);
#line 370 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (id_card_widget, "remove-id", (GCallback) _identity_manager_view_remove_identity_cb_id_card_widget_remove_id, self, 0);
#line 371 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (id_card_widget, "send-id", (GCallback) ___lambda5__id_card_widget_send_id, self, 0);
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->priv->custom_vbox;
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (id_card_widget, "expanded", (GCallback) _custom_vbox_receive_expanded_event_id_card_widget_expanded, _tmp3_, 0);
#line 373 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (id_card_widget, "expanded", (GCallback) _identity_manager_view_fill_details_id_card_widget_expanded, self, 0);
#line 374 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = id_card_widget;
#line 374 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 2134 "moonshot-identity-management-view.c"
}


gboolean identity_manager_view_add_identity (IdentityManagerView* self, IdCard* id_card, gboolean force_flat_file_store) {
	gboolean result = FALSE;
	GtkMessageDialog* dialog = NULL;
	IdCard* prev_id = NULL;
	IdentityManagerModel* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	IdCard* _tmp5_ = NULL;
	IdCard* _tmp6_ = NULL;
	gint ret = 0;
	GtkMessageDialog* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	GtkMessageDialog* _tmp38_ = NULL;
	gint _tmp39_ = 0;
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 377 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (id_card != NULL, FALSE);
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->identities_manager;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card_get_nai (_tmp1_);
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = force_flat_file_store;
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = identity_manager_model_find_id_card (_tmp0_, _tmp3_, _tmp4_);
#line 387 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	prev_id = _tmp5_;
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = prev_id;
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp6_ != NULL) {
#line 2176 "moonshot-identity-management-view.c"
		gint flags = 0;
		IdCard* _tmp7_ = NULL;
		IdCard* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = prev_id;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = id_card;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = id_card_Compare (_tmp7_, _tmp8_);
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		flags = _tmp9_;
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = flags;
#line 390 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (_tmp10_ == 0) {
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			result = FALSE;
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (prev_id);
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (dialog);
#line 391 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			return result;
#line 2202 "moonshot-identity-management-view.c"
		} else {
			gint _tmp11_ = 0;
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp11_ = flags;
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			if ((_tmp11_ & (1 << ID_CARD_DIFF_FLAGS_DISPLAY_NAME)) != 0) {
#line 2209 "moonshot-identity-management-view.c"
				const gchar* _tmp12_ = NULL;
				IdCard* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				IdCard* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				IdCard* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				GtkMessageDialog* _tmp22_ = NULL;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp12_ = _ ("Would you like to replace ID Card '%s' using nai '%s' with the new ID " \
"Card '%s'?");
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp13_ = prev_id;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp14_ = id_card_get_display_name (_tmp13_);
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp15_ = _tmp14_;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp16_ = prev_id;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp17_ = id_card_get_nai (_tmp16_);
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp18_ = _tmp17_;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp19_ = id_card;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp20_ = id_card_get_display_name (_tmp19_);
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp21_ = _tmp20_;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp22_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp12_, _tmp15_, _tmp18_, _tmp21_);
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				g_object_ref_sink (_tmp22_);
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (dialog);
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				dialog = _tmp22_;
#line 2249 "moonshot-identity-management-view.c"
			} else {
				const gchar* _tmp23_ = NULL;
				IdCard* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				IdCard* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				GtkMessageDialog* _tmp30_ = NULL;
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp23_ = _ ("Would you like to update ID Card '%s' using nai '%s'?");
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp24_ = id_card;
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp25_ = id_card_get_display_name (_tmp24_);
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp26_ = _tmp25_;
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp27_ = id_card;
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp28_ = id_card_get_nai (_tmp27_);
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp29_ = _tmp28_;
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp30_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp23_, _tmp26_, _tmp29_);
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				g_object_ref_sink (_tmp30_);
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (dialog);
#line 402 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				dialog = _tmp30_;
#line 2281 "moonshot-identity-management-view.c"
			}
		}
	} else {
		const gchar* _tmp31_ = NULL;
		IdCard* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		GtkMessageDialog* _tmp35_ = NULL;
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp31_ = _ ("Would you like to add '%s' ID Card to the ID Card Organizer?");
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp32_ = id_card;
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp33_ = id_card_get_display_name (_tmp32_);
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp34_ = _tmp33_;
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp35_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp31_, _tmp34_);
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		g_object_ref_sink (_tmp35_);
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (dialog);
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		dialog = _tmp35_;
#line 2306 "moonshot-identity-management-view.c"
	}
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp36_ = dialog;
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp37_ = gtk_dialog_run ((GtkDialog*) _tmp36_);
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	ret = _tmp37_;
#line 419 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp38_ = dialog;
#line 419 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_object_destroy ((GtkObject*) _tmp38_);
#line 422 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp39_ = ret;
#line 422 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp39_ == ((gint) GTK_RESPONSE_YES)) {
#line 2322 "moonshot-identity-management-view.c"
		IdentityManagerModel* _tmp40_ = NULL;
		IdCard* _tmp41_ = NULL;
		gboolean _tmp42_ = FALSE;
#line 423 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp40_ = self->identities_manager;
#line 423 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp41_ = id_card;
#line 423 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp42_ = force_flat_file_store;
#line 423 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_model_add_card (_tmp40_, _tmp41_, _tmp42_);
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		result = TRUE;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (prev_id);
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (dialog);
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return result;
#line 2342 "moonshot-identity-management-view.c"
	}
#line 427 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = FALSE;
#line 427 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (prev_id);
#line 427 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (dialog);
#line 427 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 2352 "moonshot-identity-management-view.c"
}


static void identity_manager_view_add_identity_manual_cb (IdentityManagerView* self) {
	AddIdentityDialog* dialog = NULL;
	AddIdentityDialog* _tmp0_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	AddIdentityDialog* _tmp10_ = NULL;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 432 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = add_identity_dialog_new ();
#line 432 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp0_);
#line 432 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	dialog = _tmp0_;
#line 433 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_result_ = (gint) GTK_RESPONSE_CANCEL;
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	while (TRUE) {
#line 2374 "moonshot-identity-management-view.c"
		AddIdentityDialog* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		AddIdentityDialog* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp1_ = dialog;
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp2_ = _tmp1_->complete;
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (!(!_tmp2_)) {
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2387 "moonshot-identity-management-view.c"
		}
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = dialog;
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = gtk_dialog_run ((GtkDialog*) _tmp3_);
#line 435 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_result_ = _tmp4_;
#line 2395 "moonshot-identity-management-view.c"
	}
#line 437 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _result_;
#line 437 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	switch (_tmp5_) {
#line 437 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		case GTK_RESPONSE_OK:
#line 2403 "moonshot-identity-management-view.c"
		{
			IdentityManagerModel* _tmp6_ = NULL;
			AddIdentityDialog* _tmp7_ = NULL;
			IdCard* _tmp8_ = NULL;
			IdCard* _tmp9_ = NULL;
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp6_ = self->identities_manager;
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp7_ = dialog;
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp8_ = identity_manager_view_get_id_card_data (self, _tmp7_);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp9_ = _tmp8_;
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			identity_manager_model_add_card (_tmp6_, _tmp9_, FALSE);
#line 439 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_tmp9_);
#line 440 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2423 "moonshot-identity-management-view.c"
		}
		default:
		{
#line 442 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2429 "moonshot-identity-management-view.c"
		}
	}
#line 444 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = dialog;
#line 444 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_object_destroy ((GtkObject*) _tmp10_);
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (dialog);
#line 2438 "moonshot-identity-management-view.c"
}


static void identity_manager_view_remove_id_card_widget (IdentityManagerView* self, IdCardWidget* id_card_widget) {
	CustomVBox* _tmp0_ = NULL;
	IdCardWidget* _tmp1_ = NULL;
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 447 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card_widget != NULL);
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->custom_vbox;
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card_widget;
#line 448 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	custom_vbox_remove_id_card_widget (_tmp0_, _tmp1_);
#line 2455 "moonshot-identity-management-view.c"
}


static void identity_manager_view_remove_identity (IdentityManagerView* self, IdCardWidget* id_card_widget) {
	IdCard* id_card = NULL;
	IdCardWidget* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IdCard* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	IdCardWidget* _tmp4_ = NULL;
	IdentityManagerModel* _tmp5_ = NULL;
#line 451 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 451 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card_widget != NULL);
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = id_card_widget;
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card_widget_get_id_card (_tmp0_);
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _tmp1_;
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 453 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card = _tmp3_;
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = id_card_widget;
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_remove_id_card_widget (self, _tmp4_);
#line 456 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = self->identities_manager;
#line 456 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_model_remove_card (_tmp5_, id_card);
#line 451 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (id_card);
#line 2491 "moonshot-identity-management-view.c"
}


static void identity_manager_view_redraw_id_card_widgets (IdentityManagerView* self) {
	GtkTreeIter iter = {0};
	IdCard* id_card = NULL;
	GList* children = NULL;
	CustomVBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GtkTreeModelFilter* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
#line 459 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->custom_vbox;
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 464 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	children = _tmp1_;
#line 465 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = children;
#line 2515 "moonshot-identity-management-view.c"
	{
		GList* id_card_widget_collection = NULL;
		GList* id_card_widget_it = NULL;
#line 465 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		id_card_widget_collection = _tmp2_;
#line 465 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		for (id_card_widget_it = id_card_widget_collection; id_card_widget_it != NULL; id_card_widget_it = id_card_widget_it->next) {
#line 2523 "moonshot-identity-management-view.c"
			GtkWidget* id_card_widget = NULL;
#line 465 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			id_card_widget = (GtkWidget*) id_card_widget_it->data;
#line 2527 "moonshot-identity-management-view.c"
			{
				GtkWidget* _tmp3_ = NULL;
#line 466 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp3_ = id_card_widget;
#line 466 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				identity_manager_view_remove_id_card_widget (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_ID_CARD_WIDGET, IdCardWidget));
#line 2534 "moonshot-identity-management-view.c"
			}
		}
	}
#line 468 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = self->priv->filter;
#line 468 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
#line 468 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	iter = _tmp5_;
#line 468 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp6_) {
#line 2546 "moonshot-identity-management-view.c"
		{
			gboolean _tmp7_ = FALSE;
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp7_ = TRUE;
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			while (TRUE) {
#line 2553 "moonshot-identity-management-view.c"
				GtkTreeModelFilter* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				IdCard* _tmp12_ = NULL;
				IdCardWidget* _tmp13_ = NULL;
				IdCardWidget* _tmp14_ = NULL;
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (!_tmp7_) {
#line 2561 "moonshot-identity-management-view.c"
					GtkTreeModelFilter* _tmp8_ = NULL;
					gboolean _tmp9_ = FALSE;
#line 477 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp8_ = self->priv->filter;
#line 477 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
#line 477 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (!_tmp9_) {
#line 477 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						break;
#line 2572 "moonshot-identity-management-view.c"
					}
				}
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp7_ = FALSE;
#line 472 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp10_ = self->priv->filter;
#line 472 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp11_ = iter;
#line 472 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL, &id_card, -1);
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp12_ = id_card;
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp13_ = identity_manager_view_add_id_card_widget (self, _tmp12_);
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp14_ = _tmp13_;
#line 475 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (_tmp14_);
#line 2591 "moonshot-identity-management-view.c"
			}
		}
	}
#line 459 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_list_free0 (children);
#line 459 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (id_card);
#line 2599 "moonshot-identity-management-view.c"
}


static void identity_manager_view_remove_identity_cb (IdentityManagerView* self, IdCardWidget* id_card_widget) {
	IdCard* id_card = NULL;
	IdCardWidget* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	IdCard* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp4_ = NULL;
	IdCard* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	gint _result_ = 0;
	GtkMessageDialog* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkMessageDialog* _tmp13_ = NULL;
#line 481 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 481 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card_widget != NULL);
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = id_card_widget;
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card_widget_get_id_card (_tmp0_);
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _tmp1_;
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card = _tmp3_;
#line 485 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = _ ("Are you sure you want to delete %s ID Card?");
#line 485 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = id_card;
#line 485 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = id_card_get_issuer (_tmp5_);
#line 485 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = _tmp6_;
#line 485 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp4_, _tmp7_);
#line 485 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp8_);
#line 485 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	dialog = _tmp8_;
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = dialog;
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = gtk_dialog_run ((GtkDialog*) _tmp9_);
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_result_ = _tmp10_;
#line 491 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = _result_;
#line 491 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	switch (_tmp11_) {
#line 491 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		case GTK_RESPONSE_YES:
#line 2660 "moonshot-identity-management-view.c"
		{
			IdCardWidget* _tmp12_ = NULL;
#line 493 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp12_ = id_card_widget;
#line 493 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			identity_manager_view_remove_identity (self, _tmp12_);
#line 494 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2669 "moonshot-identity-management-view.c"
		}
		default:
		{
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2675 "moonshot-identity-management-view.c"
		}
	}
#line 498 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = dialog;
#line 498 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_object_destroy ((GtkObject*) _tmp13_);
#line 481 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (dialog);
#line 481 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (id_card);
#line 2686 "moonshot-identity-management-view.c"
}


void identity_manager_view_set_prompting_service (IdentityManagerView* self, const gchar* service) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 501 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 501 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (service != NULL);
#line 503 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->prompting_service;
#line 503 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = _ ("Identity requested for service: %s");
#line 503 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = service;
#line 503 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = g_strdup_printf (_tmp1_, _tmp2_);
#line 503 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = _tmp3_;
#line 503 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_label_set_label (_tmp0_, _tmp4_);
#line 503 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp4_);
#line 2714 "moonshot-identity-management-view.c"
}


void identity_manager_view_queue_identity_request (IdentityManagerView* self, IdentityRequest* request) {
	GQueue* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GQueue* _tmp7_ = NULL;
	IdentityRequest* _tmp8_ = NULL;
	IdentityRequest* _tmp9_ = NULL;
#line 506 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 506 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (request != NULL);
#line 508 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->request_queue;
#line 508 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = g_queue_is_empty (_tmp0_);
#line 508 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp1_) {
#line 2734 "moonshot-identity-management-view.c"
		IdentityRequest* _tmp2_ = NULL;
		GSList* _tmp3_ = NULL;
		GtkTreeModelFilter* _tmp4_ = NULL;
		IdentityRequest* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 510 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp2_ = request;
#line 510 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = _tmp2_->candidates;
#line 510 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		self->priv->candidates = _tmp3_;
#line 511 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = self->priv->filter;
#line 511 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_tree_model_filter_refilter (_tmp4_);
#line 512 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_redraw_id_card_widgets (self);
#line 513 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = request;
#line 513 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = _tmp5_->service;
#line 513 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_set_prompting_service (self, _tmp6_);
#line 514 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_widget_show ((GtkWidget*) self);
#line 2760 "moonshot-identity-management-view.c"
	}
#line 516 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = self->request_queue;
#line 516 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = request;
#line 516 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 516 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_queue_push_tail (_tmp7_, _tmp9_);
#line 2770 "moonshot-identity-management-view.c"
}


IdCard* identity_manager_view_check_add_password (IdentityManagerView* self, IdCard* identity, IdentityRequest* request, IdentityManagerModel* model) {
	IdCard* result = NULL;
	IdCard* retval = NULL;
	IdCard* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	IdCard* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean idcard_has_pw = FALSE;
	gboolean _tmp9_ = FALSE;
	IdentityRequest* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean request_has_pw = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
#line 519 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 519 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (identity != NULL, NULL);
#line 519 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 519 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 521 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity;
#line 521 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 521 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	retval = _tmp1_;
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = identity;
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = id_card_get_password (_tmp3_);
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _tmp4_;
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp5_ != NULL) {
#line 2812 "moonshot-identity-management-view.c"
		IdCard* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = identity;
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = id_card_get_password (_tmp6_);
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = _tmp7_;
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp2_ = g_strcmp0 (_tmp8_, "") != 0;
#line 2824 "moonshot-identity-management-view.c"
	} else {
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp2_ = FALSE;
#line 2828 "moonshot-identity-management-view.c"
	}
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	idcard_has_pw = _tmp2_;
#line 523 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = request;
#line 523 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = _tmp10_->password;
#line 523 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp11_ != NULL) {
#line 2838 "moonshot-identity-management-view.c"
		IdentityRequest* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 523 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = request;
#line 523 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp13_ = _tmp12_->password;
#line 523 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = g_strcmp0 (_tmp13_, "") != 0;
#line 2847 "moonshot-identity-management-view.c"
	} else {
#line 523 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = FALSE;
#line 2851 "moonshot-identity-management-view.c"
	}
#line 523 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	request_has_pw = _tmp9_;
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = idcard_has_pw;
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (!_tmp15_) {
#line 2859 "moonshot-identity-management-view.c"
		IdCard* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp16_ = identity;
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp17_ = id_card_IsNoIdentity (_tmp16_);
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = !_tmp17_;
#line 2868 "moonshot-identity-management-view.c"
	} else {
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = FALSE;
#line 2872 "moonshot-identity-management-view.c"
	}
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp14_) {
#line 2876 "moonshot-identity-management-view.c"
		gboolean _tmp18_ = FALSE;
#line 525 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp18_ = request_has_pw;
#line 525 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (_tmp18_) {
#line 2882 "moonshot-identity-management-view.c"
			IdCard* _tmp19_ = NULL;
			IdentityRequest* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			IdentityManagerModel* _tmp22_ = NULL;
			IdCard* _tmp23_ = NULL;
			IdCard* _tmp24_ = NULL;
#line 526 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp19_ = identity;
#line 526 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp20_ = request;
#line 526 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp21_ = _tmp20_->password;
#line 526 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			id_card_set_password (_tmp19_, _tmp21_);
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp22_ = model;
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp23_ = identity;
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp24_ = identity_manager_model_update_card (_tmp22_, _tmp23_);
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (retval);
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			retval = _tmp24_;
#line 2907 "moonshot-identity-management-view.c"
		} else {
			AddPasswordDialog* dialog = NULL;
			IdCard* _tmp25_ = NULL;
			IdentityRequest* _tmp26_ = NULL;
			AddPasswordDialog* _tmp27_ = NULL;
			gint _result_ = 0;
			AddPasswordDialog* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			AddPasswordDialog* _tmp46_ = NULL;
#line 529 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp25_ = identity;
#line 529 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp26_ = request;
#line 529 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp27_ = add_password_dialog_new (_tmp25_, _tmp26_);
#line 529 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			g_object_ref_sink (_tmp27_);
#line 529 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			dialog = _tmp27_;
#line 530 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp28_ = dialog;
#line 530 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp29_ = gtk_dialog_run ((GtkDialog*) _tmp28_);
#line 530 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_result_ = _tmp29_;
#line 532 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp30_ = _result_;
#line 532 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			switch (_tmp30_) {
#line 532 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				case GTK_RESPONSE_OK:
#line 2940 "moonshot-identity-management-view.c"
				{
					IdCard* _tmp31_ = NULL;
					AddPasswordDialog* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					IdCard* _tmp35_ = NULL;
					AddPasswordDialog* _tmp36_ = NULL;
					gboolean _tmp37_ = FALSE;
					gboolean _tmp38_ = FALSE;
					AddPasswordDialog* _tmp39_ = NULL;
					gboolean _tmp40_ = FALSE;
					gboolean _tmp41_ = FALSE;
					IdentityManagerModel* _tmp43_ = NULL;
					IdCard* _tmp44_ = NULL;
					IdCard* _tmp45_ = NULL;
#line 534 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp31_ = identity;
#line 534 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp32_ = dialog;
#line 534 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp33_ = add_password_dialog_get_password (_tmp32_);
#line 534 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp34_ = _tmp33_;
#line 534 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					id_card_set_password (_tmp31_, _tmp34_);
#line 535 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp35_ = identity;
#line 535 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp36_ = dialog;
#line 535 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp37_ = add_password_dialog_get_remember (_tmp36_);
#line 535 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp38_ = _tmp37_;
#line 535 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					id_card_set_store_password (_tmp35_, _tmp38_);
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp39_ = dialog;
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp40_ = add_password_dialog_get_remember (_tmp39_);
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp41_ = _tmp40_;
#line 536 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp41_) {
#line 2984 "moonshot-identity-management-view.c"
						IdCard* _tmp42_ = NULL;
#line 537 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp42_ = identity;
#line 537 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						id_card_set_temporary (_tmp42_, FALSE);
#line 2990 "moonshot-identity-management-view.c"
					}
#line 538 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp43_ = model;
#line 538 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp44_ = identity;
#line 538 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp45_ = identity_manager_model_update_card (_tmp43_, _tmp44_);
#line 538 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_object_unref0 (retval);
#line 538 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					retval = _tmp45_;
#line 539 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					break;
#line 3004 "moonshot-identity-management-view.c"
				}
				default:
				{
#line 541 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					identity = NULL;
#line 542 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					break;
#line 3012 "moonshot-identity-management-view.c"
				}
			}
#line 544 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp46_ = dialog;
#line 544 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_object_destroy ((GtkObject*) _tmp46_);
#line 525 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (dialog);
#line 3021 "moonshot-identity-management-view.c"
		}
	}
#line 547 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = retval;
#line 547 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 3028 "moonshot-identity-management-view.c"
}


void identity_manager_view_send_identity_cb (IdentityManagerView* self, IdCard* id) {
	IdCard* identity = NULL;
	IdCard* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	GQueue* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	IdentityRequest* request = NULL;
	GQueue* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	IdCard* _tmp6_ = NULL;
	IdentityRequest* _tmp7_ = NULL;
	IdentityManagerModel* _tmp8_ = NULL;
	IdCard* _tmp9_ = NULL;
	GQueue* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GtkTreeModelFilter* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	IdCard* _tmp25_ = NULL;
	IdentityRequest* _tmp31_ = NULL;
	IdCard* _tmp32_ = NULL;
#line 550 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 550 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id != NULL);
#line 552 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = id;
#line 552 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 552 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity = _tmp1_;
#line 553 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = self->request_queue;
#line 553 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_->length;
#line 553 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (_tmp3_ > ((guint) 0));
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->candidates = NULL;
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = self->request_queue;
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = g_queue_pop_head (_tmp4_);
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	request = (IdentityRequest*) _tmp5_;
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = identity;
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = request;
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = self->identities_manager;
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = identity_manager_view_check_add_password (self, _tmp6_, _tmp7_, _tmp8_);
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (identity);
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity = _tmp9_;
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = self->request_queue;
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = g_queue_is_empty (_tmp10_);
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp11_) {
#line 3094 "moonshot-identity-management-view.c"
		GtkLabel* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		IdentityManagerApp* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		self->priv->candidates = NULL;
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = self->priv->prompting_service;
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp13_ = _ ("");
#line 561 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_label_set_label (_tmp12_, _tmp13_);
#line 562 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = self->parent_app;
#line 562 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp15_ = _tmp14_->explicitly_launched;
#line 562 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (!_tmp15_) {
#line 567 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_widget_hide ((GtkWidget*) self);
#line 3115 "moonshot-identity-management-view.c"
		}
	} else {
		IdentityRequest* next = NULL;
		GQueue* _tmp16_ = NULL;
		gconstpointer _tmp17_ = NULL;
		IdentityRequest* _tmp18_ = NULL;
		IdentityRequest* _tmp19_ = NULL;
		GSList* _tmp20_ = NULL;
		IdentityRequest* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
#line 570 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp16_ = self->request_queue;
#line 570 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp17_ = g_queue_peek_head (_tmp16_);
#line 570 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp18_ = _g_object_ref0 ((IdentityRequest*) _tmp17_);
#line 570 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		next = _tmp18_;
#line 571 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp19_ = next;
#line 571 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp20_ = _tmp19_->candidates;
#line 571 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		self->priv->candidates = _tmp20_;
#line 572 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp21_ = next;
#line 572 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp22_ = _tmp21_->service;
#line 572 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_set_prompting_service (self, _tmp22_);
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (next);
#line 3148 "moonshot-identity-management-view.c"
	}
#line 574 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp23_ = self->priv->filter;
#line 574 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_tree_model_filter_refilter (_tmp23_);
#line 575 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_redraw_id_card_widgets (self);
#line 577 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp25_ = identity;
#line 577 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp25_ != NULL) {
#line 3160 "moonshot-identity-management-view.c"
		IdCard* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
#line 577 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp26_ = identity;
#line 577 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp27_ = id_card_IsNoIdentity (_tmp26_);
#line 577 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24_ = !_tmp27_;
#line 3169 "moonshot-identity-management-view.c"
	} else {
#line 577 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24_ = FALSE;
#line 3173 "moonshot-identity-management-view.c"
	}
#line 577 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp24_) {
#line 3177 "moonshot-identity-management-view.c"
		IdentityManagerApp* _tmp28_ = NULL;
		IdCard* _tmp29_ = NULL;
		IdCard* _tmp30_ = NULL;
#line 578 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp28_ = self->parent_app;
#line 578 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp29_ = identity;
#line 578 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp30_ = _g_object_ref0 (_tmp29_);
#line 578 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_tmp28_->default_id_card);
#line 578 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp28_->default_id_card = _tmp30_;
#line 3191 "moonshot-identity-management-view.c"
	}
#line 580 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp31_ = request;
#line 580 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp32_ = identity;
#line 580 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_request_return_identity (_tmp31_, _tmp32_);
#line 550 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (request);
#line 550 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (identity);
#line 3203 "moonshot-identity-management-view.c"
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
#line 583 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 3210 "moonshot-identity-management-view.c"
}


static void identity_manager_view_label_make_bold (IdentityManagerView* self, GtkLabel* label) {
	PangoFontDescription* font_desc = NULL;
	PangoFontDescription* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
#line 583 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 583 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (label != NULL);
#line 585 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = pango_font_description_new ();
#line 585 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	font_desc = _tmp0_;
#line 587 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	pango_font_description_set_weight (font_desc, PANGO_WEIGHT_BOLD);
#line 594 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = label;
#line 594 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_modify_font ((GtkWidget*) _tmp1_, font_desc);
#line 583 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__vala_PangoFontDescription_free0 (font_desc);
#line 3234 "moonshot-identity-management-view.c"
}


static void _g_slist_free__g_free0_ (GSList* self) {
#line 640 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
#line 640 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_slist_free (self);
#line 3243 "moonshot-identity-management-view.c"
}


static void ____lambda4_ (IdentityManagerView* self, GtkButton* remove_button) {
	gchar* candidate = NULL;
	GHashTable* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp5_ = NULL;
	CustomVBox* _tmp6_ = NULL;
	IdCardWidget* _tmp7_ = NULL;
	IdCardWidget* _tmp8_ = NULL;
	IdCard* _tmp9_ = NULL;
	IdCard* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkMessageDialog* _tmp14_ = NULL;
	gint ret = 0;
	GtkMessageDialog* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GtkMessageDialog* _tmp17_ = NULL;
	gint _tmp18_ = 0;
#line 622 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (remove_button != NULL);
#line 624 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->service_button_map;
#line 624 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = remove_button;
#line 624 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 624 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
#line 624 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	candidate = _tmp3_;
#line 625 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = candidate;
#line 625 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp4_ == NULL) {
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (candidate);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return;
#line 3290 "moonshot-identity-management-view.c"
	}
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _ ("Are you sure you want to stop '%s' ID Card from being used with %s?");
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = self->priv->custom_vbox;
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = custom_vbox_get_current_idcard (_tmp6_);
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = _tmp7_;
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = id_card_widget_get_id_card (_tmp8_);
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = _tmp9_;
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = id_card_get_display_name (_tmp10_);
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _tmp11_;
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = candidate;
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp5_, _tmp12_, _tmp13_);
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp14_);
#line 627 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	dialog = _tmp14_;
#line 634 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = dialog;
#line 634 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = gtk_dialog_run ((GtkDialog*) _tmp15_);
#line 634 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	ret = _tmp16_;
#line 635 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = dialog;
#line 635 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp17_);
#line 637 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp18_ = ret;
#line 637 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp18_ == ((gint) GTK_RESPONSE_YES)) {
#line 3330 "moonshot-identity-management-view.c"
		IdCard* idcard = NULL;
		CustomVBox* _tmp19_ = NULL;
		IdCardWidget* _tmp20_ = NULL;
		IdCardWidget* _tmp21_ = NULL;
		IdCard* _tmp22_ = NULL;
		IdCard* _tmp23_ = NULL;
		IdCard* _tmp24_ = NULL;
		IdCard* _tmp25_ = NULL;
#line 639 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp19_ = self->priv->custom_vbox;
#line 639 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp20_ = custom_vbox_get_current_idcard (_tmp19_);
#line 639 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp21_ = _tmp20_;
#line 639 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp22_ = id_card_widget_get_id_card (_tmp21_);
#line 639 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp23_ = _tmp22_;
#line 639 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 639 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		idcard = _tmp24_;
#line 640 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp25_ = idcard;
#line 640 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (_tmp25_ != NULL) {
#line 3357 "moonshot-identity-management-view.c"
			GSList* services = NULL;
			IdCard* _tmp26_ = NULL;
			gchar** _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			IdCard* _tmp34_ = NULL;
			GSList* _tmp35_ = NULL;
			guint _tmp36_ = 0U;
			gchar** _tmp37_ = NULL;
			gchar** _tmp38_ = NULL;
			gint _tmp38__length1 = 0;
			IdentityManagerModel* _tmp54_ = NULL;
			IdCard* _tmp55_ = NULL;
			IdCard* _tmp56_ = NULL;
			IdCard* _tmp57_ = NULL;
#line 641 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			services = NULL;
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp26_ = idcard;
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp27_ = id_card_get_services (_tmp26_, &_tmp27__length1);
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp28_ = _tmp27_;
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp28__length1 = _tmp27__length1;
#line 3384 "moonshot-identity-management-view.c"
			{
				gchar** srv_collection = NULL;
				gint srv_collection_length1 = 0;
				gint _srv_collection_size_ = 0;
				gint srv_it = 0;
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				srv_collection = _tmp28_;
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				srv_collection_length1 = _tmp28__length1;
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				for (srv_it = 0; srv_it < _tmp28__length1; srv_it = srv_it + 1) {
#line 3396 "moonshot-identity-management-view.c"
					gchar* _tmp29_ = NULL;
					gchar* srv = NULL;
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp29_ = g_strdup (srv_collection[srv_it]);
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					srv = _tmp29_;
#line 3403 "moonshot-identity-management-view.c"
					{
						const gchar* _tmp30_ = NULL;
						const gchar* _tmp31_ = NULL;
						const gchar* _tmp32_ = NULL;
						gchar* _tmp33_ = NULL;
#line 645 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp30_ = srv;
#line 645 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp31_ = candidate;
#line 645 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						if (g_strcmp0 (_tmp30_, _tmp31_) == 0) {
#line 646 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_g_free0 (srv);
#line 646 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							continue;
#line 3419 "moonshot-identity-management-view.c"
						}
#line 647 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp32_ = srv;
#line 647 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp33_ = g_strdup (_tmp32_);
#line 647 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						services = g_slist_append (services, _tmp33_);
#line 643 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (srv);
#line 3429 "moonshot-identity-management-view.c"
					}
				}
			}
#line 650 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp34_ = idcard;
#line 650 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp35_ = services;
#line 650 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp36_ = g_slist_length (_tmp35_);
#line 650 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp37_ = g_new0 (gchar*, _tmp36_ + 1);
#line 650 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp38_ = _tmp37_;
#line 650 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp38__length1 = _tmp36_;
#line 650 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			id_card_set_services (_tmp34_, _tmp38_, _tmp36_);
#line 650 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
#line 3449 "moonshot-identity-management-view.c"
			{
				gint j = 0;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				j = 0;
#line 3454 "moonshot-identity-management-view.c"
				{
					gboolean _tmp39_ = FALSE;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp39_ = TRUE;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					while (TRUE) {
#line 3461 "moonshot-identity-management-view.c"
						gint _tmp41_ = 0;
						IdCard* _tmp42_ = NULL;
						gchar** _tmp43_ = NULL;
						gint _tmp43__length1 = 0;
						gchar** _tmp44_ = NULL;
						gint _tmp44__length1 = 0;
						IdCard* _tmp45_ = NULL;
						gchar** _tmp46_ = NULL;
						gint _tmp46__length1 = 0;
						gchar** _tmp47_ = NULL;
						gint _tmp47__length1 = 0;
						gint _tmp48_ = 0;
						GSList* _tmp49_ = NULL;
						gint _tmp50_ = 0;
						gconstpointer _tmp51_ = NULL;
						gchar* _tmp52_ = NULL;
						gchar* _tmp53_ = NULL;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						if (!_tmp39_) {
#line 3481 "moonshot-identity-management-view.c"
							gint _tmp40_ = 0;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp40_ = j;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							j = _tmp40_ + 1;
#line 3487 "moonshot-identity-management-view.c"
						}
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp39_ = FALSE;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp41_ = j;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp42_ = idcard;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp43_ = id_card_get_services (_tmp42_, &_tmp43__length1);
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp44_ = _tmp43_;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp44__length1 = _tmp43__length1;
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						if (!(_tmp41_ < _tmp44__length1)) {
#line 651 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							break;
#line 3505 "moonshot-identity-management-view.c"
						}
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp45_ = idcard;
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp46_ = id_card_get_services (_tmp45_, &_tmp46__length1);
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp47_ = _tmp46_;
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp47__length1 = _tmp46__length1;
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp48_ = j;
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp49_ = services;
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp50_ = j;
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp51_ = g_slist_nth_data (_tmp49_, (guint) _tmp50_);
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp52_ = g_strdup ((const gchar*) _tmp51_);
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (_tmp47_[_tmp48_]);
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp47_[_tmp48_] = _tmp52_;
#line 653 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp53_ = _tmp47_[_tmp48_];
#line 3531 "moonshot-identity-management-view.c"
					}
				}
			}
#line 656 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp54_ = self->identities_manager;
#line 656 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp55_ = idcard;
#line 656 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp56_ = identity_manager_model_update_card (_tmp54_, _tmp55_);
#line 656 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp57_ = _tmp56_;
#line 656 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_tmp57_);
#line 640 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			__g_slist_free__g_free0_0 (services);
#line 3547 "moonshot-identity-management-view.c"
		}
#line 637 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (idcard);
#line 3551 "moonshot-identity-management-view.c"
	}
#line 622 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (dialog);
#line 622 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (candidate);
#line 3557 "moonshot-identity-management-view.c"
}


static void _____lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 622 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	____lambda4_ ((IdentityManagerView*) self, _sender);
#line 3564 "moonshot-identity-management-view.c"
}


static void identity_manager_view_fill_services_vbox (IdentityManagerView* self, IdCard* id_card) {
	gint i = 0;
	gint n_columns = 0;
	IdCard* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GtkTable* services_table = NULL;
	gint _tmp3_ = 0;
	GtkTable* _tmp4_ = NULL;
	GtkTable* _tmp5_ = NULL;
	GtkTable* _tmp6_ = NULL;
	GtkVBox* _tmp7_ = NULL;
	GtkTable* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	IdCard* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	GtkVBox* _tmp33_ = NULL;
#line 597 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 597 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card != NULL);
#line 599 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	i = 0;
#line 600 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = id_card;
#line 600 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card_get_services (_tmp0_, &_tmp1__length1);
#line 600 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _tmp1_;
#line 600 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2__length1 = _tmp1__length1;
#line 600 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	n_columns = _tmp2__length1;
#line 602 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = n_columns;
#line 602 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = (GtkTable*) gtk_table_new ((guint) _tmp3_, (guint) 2, FALSE);
#line 602 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp4_);
#line 602 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	services_table = _tmp4_;
#line 603 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = services_table;
#line 603 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_set_col_spacings (_tmp5_, (guint) 10);
#line 604 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = services_table;
#line 604 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_set_row_spacings (_tmp6_, (guint) 10);
#line 605 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = self->priv->services_internal_vbox;
#line 605 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = services_table;
#line 605 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
#line 607 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = self->priv->service_button_map;
#line 607 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_hash_table_remove_all (_tmp9_);
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = id_card;
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = id_card_get_services (_tmp10_, &_tmp11__length1);
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _tmp11_;
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12__length1 = _tmp11__length1;
#line 3640 "moonshot-identity-management-view.c"
	{
		gchar** service_collection = NULL;
		gint service_collection_length1 = 0;
		gint _service_collection_size_ = 0;
		gint service_it = 0;
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		service_collection = _tmp12_;
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		service_collection_length1 = _tmp12__length1;
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		for (service_it = 0; service_it < _tmp12__length1; service_it = service_it + 1) {
#line 3652 "moonshot-identity-management-view.c"
			gchar* _tmp13_ = NULL;
			gchar* service = NULL;
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp13_ = g_strdup (service_collection[service_it]);
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			service = _tmp13_;
#line 3659 "moonshot-identity-management-view.c"
			{
				GtkLabel* label = NULL;
				const gchar* _tmp14_ = NULL;
				GtkLabel* _tmp15_ = NULL;
				GtkLabel* _tmp16_ = NULL;
				GtkButton* remove_button = NULL;
				GtkButton* _tmp17_ = NULL;
				GHashTable* _tmp18_ = NULL;
				GtkButton* _tmp19_ = NULL;
				GtkButton* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				GtkButton* _tmp23_ = NULL;
				GtkTable* _tmp24_ = NULL;
				GtkLabel* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				GtkTable* _tmp28_ = NULL;
				GtkButton* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
#line 611 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp14_ = service;
#line 611 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp15_ = (GtkLabel*) gtk_label_new (_tmp14_);
#line 611 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				g_object_ref_sink (_tmp15_);
#line 611 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				label = _tmp15_;
#line 612 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp16_ = label;
#line 612 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				gtk_misc_set_alignment ((GtkMisc*) _tmp16_, (gfloat) 0, (gfloat) 0.5);
#line 614 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp17_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_REMOVE);
#line 614 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				g_object_ref_sink (_tmp17_);
#line 614 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				remove_button = _tmp17_;
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp18_ = self->priv->service_button_map;
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp19_ = remove_button;
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp20_ = _g_object_ref0 (_tmp19_);
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp21_ = service;
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp22_ = g_strdup (_tmp21_);
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				g_hash_table_insert (_tmp18_, _tmp20_, _tmp22_);
#line 622 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp23_ = remove_button;
#line 622 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				g_signal_connect_object (_tmp23_, "clicked", (GCallback) _____lambda4__gtk_button_clicked, self, 0);
#line 661 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp24_ = services_table;
#line 661 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp25_ = label;
#line 661 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp26_ = i;
#line 661 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp27_ = i;
#line 661 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				gtk_table_attach_defaults (_tmp24_, (GtkWidget*) _tmp25_, (guint) 0, (guint) 1, (guint) _tmp26_, (guint) (_tmp27_ + 1));
#line 662 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp28_ = services_table;
#line 662 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp29_ = remove_button;
#line 662 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp30_ = i;
#line 662 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp31_ = i;
#line 662 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				gtk_table_attach_defaults (_tmp28_, (GtkWidget*) _tmp29_, (guint) 1, (guint) 2, (guint) _tmp30_, (guint) (_tmp31_ + 1));
#line 663 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp32_ = i;
#line 663 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				i = _tmp32_ + 1;
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (remove_button);
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (label);
#line 609 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_free0 (service);
#line 3746 "moonshot-identity-management-view.c"
			}
		}
	}
#line 665 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp33_ = self->priv->services_internal_vbox;
#line 665 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp33_);
#line 597 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (services_table);
#line 3756 "moonshot-identity-management-view.c"
}


static void identity_manager_view_on_about_action (IdentityManagerView* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar* copyright = NULL;
	gchar* _tmp4_ = NULL;
	gchar* license = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 668 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = g_strdup ("Javier Jardón <jjardon@codethink.co.uk>");
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = g_strdup ("Sam Thursfield <samthursfield@codethink.co.uk>");
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = g_strdup ("Alberto Ruiz <alberto.ruiz@codethink.co.uk>");
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = g_new0 (gchar*, 4 + 1);
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_[0] = _tmp0_;
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_[1] = _tmp1_;
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_[2] = _tmp2_;
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_[3] = NULL;
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	authors = _tmp3_;
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	authors_length1 = 4;
#line 670 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_authors_size_ = authors_length1;
#line 677 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = g_strdup ("Copyright 2011 JANET");
#line 677 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	copyright = _tmp4_;
#line 679 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = g_strdup ("\n" \
"Copyright (c) 2011, JANET(UK)\n" \
"All rights reserved.\n" \
"\n" \
"Redistribution and use in source and binary forms, with or without\n" \
"modification, are permitted provided that the following conditions\n" \
"are met:\n" \
"\n" \
"1. Redistributions of source code must retain the above copyright\n" \
"   notice, this list of conditions and the following disclaimer.\n" \
"\n" \
"2. Redistributions in binary form must reproduce the above copyright\n" \
"   notice, this list of conditions and the following disclaimer in the" \
"\n" \
"   documentation and/or other materials provided with the distribution" \
".\n" \
"\n" \
"3. Neither the name of JANET(UK) nor the names of its contributors\n" \
"   may be used to endorse or promote products derived from this softwa" \
"re\n" \
"   without specific prior written permission.\n" \
"\n" \
"THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \\" \
"\"AS IS\\\"\n" \
"AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, " \
"THE\n" \
"IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PUR" \
"POSE\n" \
"ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS" \
" BE LIABLE\n" \
"FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUEN" \
"TIAL\n" \
"DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOOD" \
"S\n" \
"OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n" \
"HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, ST" \
"RICT\n" \
"LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY " \
"WAY\n" \
"OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF" \
"\n" \
"SUCH DAMAGE.\n");
#line 679 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	license = _tmp5_;
#line 712 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = _ ("Moonshot project UI");
#line 712 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = _ ("Visit the Moonshot project web site");
#line 712 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = _ ("translator-credits");
#line 712 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_show_about_dialog ((GtkWindow*) self, "comments", _tmp6_, "copyright", copyright, "website", PACKAGE_URL, "version", PACKAGE_VERSION, "license", license, "website-label", _tmp7_, "authors", authors, "translator-credits", _tmp8_, NULL, NULL);
#line 668 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (license);
#line 668 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (copyright);
#line 668 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 3821 "moonshot-identity-management-view.c"
}


static void _vala_array_add1 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
#line 732 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if ((*length) == (*size)) {
#line 732 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 732 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*array = g_renew (GtkActionEntry, *array, *size);
#line 3832 "moonshot-identity-management-view.c"
	}
#line 732 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	(*array)[(*length)++] = *value;
#line 3836 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_add_identity_manual_cb_gtk_action_callback (GtkAction* action, gpointer self) {
#line 733 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_add_identity_manual_cb ((IdentityManagerView*) self);
#line 3843 "moonshot-identity-management-view.c"
}


static void _vala_array_add2 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
#line 743 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if ((*length) == (*size)) {
#line 743 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 743 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*array = g_renew (GtkActionEntry, *array, *size);
#line 3854 "moonshot-identity-management-view.c"
	}
#line 743 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	(*array)[(*length)++] = *value;
#line 3858 "moonshot-identity-management-view.c"
}


static void _gtk_main_quit_gtk_action_callback (GtkAction* action, gpointer self) {
#line 744 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_main_quit ();
#line 3865 "moonshot-identity-management-view.c"
}


static void _vala_array_add3 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
#line 754 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if ((*length) == (*size)) {
#line 754 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 754 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*array = g_renew (GtkActionEntry, *array, *size);
#line 3876 "moonshot-identity-management-view.c"
	}
#line 754 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	(*array)[(*length)++] = *value;
#line 3880 "moonshot-identity-management-view.c"
}


static void _vala_array_add4 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if ((*length) == (*size)) {
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*array = g_renew (GtkActionEntry, *array, *size);
#line 3891 "moonshot-identity-management-view.c"
	}
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	(*array)[(*length)++] = *value;
#line 3895 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_on_about_action_gtk_action_callback (GtkAction* action, gpointer self) {
#line 761 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_on_about_action ((IdentityManagerView*) self);
#line 3902 "moonshot-identity-management-view.c"
}


static void _vala_array_add5 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if ((*length) == (*size)) {
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*array = g_renew (GtkActionEntry, *array, *size);
#line 3913 "moonshot-identity-management-view.c"
	}
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	(*array)[(*length)++] = *value;
#line 3917 "moonshot-identity-management-view.c"
}


static GtkActionEntry* identity_manager_view_create_actions (IdentityManagerView* self, int* result_length1) {
	GtkActionEntry* result = NULL;
	GtkActionEntry* actions = NULL;
	GtkActionEntry* _tmp0_ = NULL;
	gint actions_length1 = 0;
	gint _actions_size_ = 0;
	GtkActionEntry filemenu = {0};
	GtkActionEntry _tmp1_ = {0};
	GtkActionEntry* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GtkActionEntry _tmp3_ = {0};
	GtkActionEntry add = {0};
	GtkActionEntry _tmp4_ = {0};
	GtkActionEntry* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GtkActionEntry _tmp6_ = {0};
	GtkActionEntry quit = {0};
	GtkActionEntry _tmp7_ = {0};
	GtkActionEntry* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GtkActionEntry _tmp9_ = {0};
	GtkActionEntry helpmenu = {0};
	GtkActionEntry _tmp10_ = {0};
	GtkActionEntry* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GtkActionEntry _tmp12_ = {0};
	GtkActionEntry about = {0};
	GtkActionEntry _tmp13_ = {0};
	GtkActionEntry* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	GtkActionEntry _tmp15_ = {0};
	GtkActionEntry* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
#line 725 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 726 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = g_new0 (GtkActionEntry, 0);
#line 726 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	actions = _tmp0_;
#line 726 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	actions_length1 = 0;
#line 726 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_actions_size_ = actions_length1;
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.name = "FileMenuAction";
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.stock_id = NULL;
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.label = "_File";
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.accelerator = NULL;
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.tooltip = NULL;
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.callback = (GCallback) NULL;
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	filemenu = _tmp1_;
#line 732 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = actions;
#line 732 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2__length1 = actions_length1;
#line 732 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = filemenu;
#line 732 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_vala_array_add1 (&actions, &actions_length1, &_actions_size_, &_tmp3_);
#line 733 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_.name = "AddIdCardAction";
#line 733 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_.stock_id = GTK_STOCK_ADD;
#line 733 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_.label = "Add ID Card";
#line 733 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_.accelerator = NULL;
#line 733 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_.tooltip = "Add a new ID Card";
#line 733 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_.callback = (GCallback) _identity_manager_view_add_identity_manual_cb_gtk_action_callback;
#line 733 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	add = _tmp4_;
#line 743 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = actions;
#line 743 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5__length1 = actions_length1;
#line 743 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = add;
#line 743 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_vala_array_add2 (&actions, &actions_length1, &_actions_size_, &_tmp6_);
#line 744 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.name = "QuitAction";
#line 744 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.stock_id = GTK_STOCK_QUIT;
#line 744 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.label = "Quit";
#line 744 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.accelerator = "<control>Q";
#line 744 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.tooltip = "Quit the application";
#line 744 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.callback = (GCallback) _gtk_main_quit_gtk_action_callback;
#line 744 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	quit = _tmp7_;
#line 754 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = actions;
#line 754 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8__length1 = actions_length1;
#line 754 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = quit;
#line 754 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_vala_array_add3 (&actions, &actions_length1, &_actions_size_, &_tmp9_);
#line 756 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_.name = "HelpMenuAction";
#line 756 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_.stock_id = NULL;
#line 756 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_.label = "_Help";
#line 756 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_.accelerator = NULL;
#line 756 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_.tooltip = NULL;
#line 756 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_.callback = (GCallback) NULL;
#line 756 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	helpmenu = _tmp10_;
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = actions;
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11__length1 = actions_length1;
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = helpmenu;
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_vala_array_add4 (&actions, &actions_length1, &_actions_size_, &_tmp12_);
#line 761 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_.name = "AboutAction";
#line 761 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_.stock_id = GTK_STOCK_ABOUT;
#line 761 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_.label = "About";
#line 761 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_.accelerator = NULL;
#line 761 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_.tooltip = "About this application";
#line 761 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_.callback = (GCallback) _identity_manager_view_on_about_action_gtk_action_callback;
#line 761 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	about = _tmp13_;
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = actions;
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14__length1 = actions_length1;
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = about;
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_vala_array_add5 (&actions, &actions_length1, &_actions_size_, &_tmp15_);
#line 773 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = actions;
#line 773 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16__length1 = actions_length1;
#line 773 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (result_length1) {
#line 773 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*result_length1 = _tmp16__length1;
#line 4082 "moonshot-identity-management-view.c"
	}
#line 773 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = _tmp16_;
#line 773 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 4088 "moonshot-identity-management-view.c"
}


static void identity_manager_view_create_ui_manager (IdentityManagerView* self) {
	GtkActionGroup* action_group = NULL;
	GtkActionGroup* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkActionEntry* _tmp2_ = NULL;
	GtkActionEntry* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GtkUIManager* _tmp4_ = NULL;
	GtkUIManager* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 777 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = gtk_action_group_new ("GeneralActionGroup");
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	action_group = _tmp0_;
#line 780 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = identity_manager_view_create_actions (self, &_tmp1_);
#line 780 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 780 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3__length1 = _tmp1_;
#line 780 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_action_group_add_actions (action_group, _tmp3_, _tmp1_, self);
#line 780 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 781 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = self->priv->ui_manager;
#line 781 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_ui_manager_insert_action_group (_tmp4_, action_group, 0);
#line 4122 "moonshot-identity-management-view.c"
	{
		GtkUIManager* _tmp5_ = NULL;
#line 784 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = self->priv->ui_manager;
#line 784 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_ui_manager_add_ui_from_string (_tmp5_, IDENTITY_MANAGER_VIEW_layout, (gssize) (-1), &_inner_error_);
#line 784 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (_inner_error_ != NULL) {
#line 4131 "moonshot-identity-management-view.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		e = _inner_error_;
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_inner_error_ = NULL;
#line 788 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = stderr;
#line 788 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = e;
#line 788 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = _tmp7_->message;
#line 788 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		fprintf (_tmp6_, "%s\n", _tmp8_);
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_error_free0 (e);
#line 4156 "moonshot-identity-management-view.c"
	}
	__finally4:
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_inner_error_ != NULL) {
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (action_group);
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		g_clear_error (&_inner_error_);
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return;
#line 4169 "moonshot-identity-management-view.c"
	}
#line 790 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = self->priv->ui_manager;
#line 790 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_ui_manager_ensure_update (_tmp9_);
#line 777 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (action_group);
#line 4177 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_search_entry_icon_press_cb_gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
#line 815 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_search_entry_icon_press_cb ((IdentityManagerView*) self, p0, p1);
#line 4184 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_search_entry_text_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 816 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_search_entry_text_changed_cb ((IdentityManagerView*) self);
#line 4191 "moonshot-identity-management-view.c"
}


static gboolean _identity_manager_view_search_entry_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = identity_manager_view_search_entry_key_press_event_cb ((IdentityManagerView*) self, event);
#line 817 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 4200 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_update_password_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 864 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_update_password_cb ((IdentityManagerView*) self);
#line 4207 "moonshot-identity-management-view.c"
}


static void identity_manager_view_build_ui (IdentityManagerView* self) {
	GtkEntry* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	GtkEntry* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	GtkEntry* _tmp10_ = NULL;
	GdkPixbuf* _tmp11_ = NULL;
	GdkPixbuf* _tmp12_ = NULL;
	GtkEntry* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkEntry* _tmp15_ = NULL;
	GtkEntry* _tmp16_ = NULL;
	GtkEntry* _tmp17_ = NULL;
	GtkEntry* _tmp18_ = NULL;
	CustomVBox* _tmp19_ = NULL;
	GtkViewport* viewport = NULL;
	GtkViewport* _tmp20_ = NULL;
	CustomVBox* _tmp21_ = NULL;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkVBox* vbox_left = NULL;
	GtkVBox* _tmp26_ = NULL;
	GtkEntry* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	GtkLabel* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	GtkLabel* login_vbox_title = NULL;
	const gchar* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkLabel* issuer_label = NULL;
	const gchar* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkEntry* _tmp38_ = NULL;
	GtkEntry* _tmp39_ = NULL;
	GtkLabel* username_label = NULL;
	const gchar* _tmp40_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	GtkEntry* _tmp42_ = NULL;
	GtkEntry* _tmp43_ = NULL;
	GtkLabel* password_label = NULL;
	const gchar* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkEntry* _tmp46_ = NULL;
	GtkEntry* _tmp47_ = NULL;
	GtkEntry* _tmp48_ = NULL;
	GtkEntry* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GtkCheckButton* _tmp51_ = NULL;
	GtkCheckButton* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	GtkButton* _tmp54_ = NULL;
	GtkButton* _tmp55_ = NULL;
	GtkEntry* _tmp56_ = NULL;
	GtkEntry* _tmp57_ = NULL;
	GtkEntry* _tmp58_ = NULL;
	GtkEntry* _tmp59_ = NULL;
	GtkTable* login_table = NULL;
	GtkTable* _tmp60_ = NULL;
	GtkEntry* _tmp61_ = NULL;
	GtkEntry* _tmp62_ = NULL;
	GtkEntry* _tmp63_ = NULL;
	GtkCheckButton* _tmp64_ = NULL;
	GtkButton* _tmp65_ = NULL;
	GtkAlignment* login_vbox_alignment = NULL;
	GtkAlignment* _tmp66_ = NULL;
	GtkVBox* _tmp67_ = NULL;
	GtkVBox* _tmp68_ = NULL;
	GtkVBox* _tmp69_ = NULL;
	GtkLabel* services_vbox_title = NULL;
	const gchar* _tmp70_ = NULL;
	GtkLabel* _tmp71_ = NULL;
	GtkAlignment* services_vbox_alignment = NULL;
	GtkAlignment* _tmp72_ = NULL;
	GtkVBox* _tmp73_ = NULL;
	GtkVBox* _tmp74_ = NULL;
	GtkVBox* _tmp75_ = NULL;
	GtkVBox* _tmp76_ = NULL;
	GtkVBox* _tmp77_ = NULL;
	GtkVBox* _tmp78_ = NULL;
	GtkVBox* _tmp79_ = NULL;
	GtkVBox* _tmp80_ = NULL;
	GtkVBox* _tmp81_ = NULL;
	GtkVBox* _tmp82_ = NULL;
	GtkHBox* hbox = NULL;
	GtkHBox* _tmp83_ = NULL;
	GtkVBox* _tmp84_ = NULL;
	GtkVBox* main_vbox = NULL;
	GtkVBox* _tmp85_ = NULL;
	GtkWidget* menubar = NULL;
	GtkUIManager* _tmp86_ = NULL;
	GtkWidget* _tmp87_ = NULL;
	GtkWidget* _tmp88_ = NULL;
	GtkVBox* _tmp89_ = NULL;
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 795 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_create_ui_manager (self);
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp0_);
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->search_entry = _tmp0_;
#line 799 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = self->priv->search_entry;
#line 799 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _ ("Search entry");
#line 799 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _ ("Search for a specific ID Card");
#line 799 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_set_atk_name_description (self, (GtkWidget*) _tmp1_, _tmp2_, _tmp3_);
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = self->priv->search_entry;
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = find_icon_sized ("edit-find", GTK_ICON_SIZE_MENU);
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = _tmp5_;
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_from_pixbuf (_tmp4_, GTK_ENTRY_ICON_PRIMARY, _tmp6_);
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (_tmp6_);
#line 803 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = self->priv->search_entry;
#line 803 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = _ ("Search identity or service");
#line 803 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_tooltip_text (_tmp7_, GTK_ENTRY_ICON_PRIMARY, _tmp8_);
#line 805 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = self->priv->search_entry;
#line 805 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_sensitive (_tmp9_, GTK_ENTRY_ICON_PRIMARY, FALSE);
#line 807 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = self->priv->search_entry;
#line 807 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = find_icon_sized ("process-stop", GTK_ICON_SIZE_MENU);
#line 807 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _tmp11_;
#line 807 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_from_pixbuf (_tmp10_, GTK_ENTRY_ICON_SECONDARY, _tmp12_);
#line 807 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (_tmp12_);
#line 810 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = self->priv->search_entry;
#line 810 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = _ ("Clear the current search");
#line 810 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_tooltip_text (_tmp13_, GTK_ENTRY_ICON_SECONDARY, _tmp14_);
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = self->priv->search_entry;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_sensitive (_tmp15_, GTK_ENTRY_ICON_SECONDARY, FALSE);
#line 815 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = self->priv->search_entry;
#line 815 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp16_, "icon-press", (GCallback) _identity_manager_view_search_entry_icon_press_cb_gtk_entry_icon_press, self, 0);
#line 816 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = self->priv->search_entry;
#line 816 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object ((GObject*) _tmp17_, "notify::text", (GCallback) _identity_manager_view_search_entry_text_changed_cb_g_object_notify, self, 0);
#line 817 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp18_ = self->priv->search_entry;
#line 817 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp18_, "key-press-event", (GCallback) _identity_manager_view_search_entry_key_press_event_cb_gtk_widget_key_press_event, self, 0);
#line 819 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp19_ = custom_vbox_new (self, FALSE, 6);
#line 819 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp19_);
#line 819 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->custom_vbox);
#line 819 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->custom_vbox = _tmp19_;
#line 821 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp20_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
#line 821 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp20_);
#line 821 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	viewport = _tmp20_;
#line 822 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_set_border_width ((GtkContainer*) viewport, (guint) 6);
#line 823 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_viewport_set_shadow_type (viewport, GTK_SHADOW_NONE);
#line 824 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp21_ = self->priv->custom_vbox;
#line 824 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_add ((GtkContainer*) viewport, (GtkWidget*) _tmp21_);
#line 825 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp22_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 825 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp22_);
#line 825 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	scroll = _tmp22_;
#line 826 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
#line 828 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_scrolled_window_add_with_viewport (scroll, (GtkWidget*) viewport);
#line 829 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp23_ = _ ("");
#line 829 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp24_ = (GtkLabel*) gtk_label_new (_tmp23_);
#line 829 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp24_);
#line 829 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->prompting_service);
#line 829 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->prompting_service = _tmp24_;
#line 831 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp25_ = self->priv->prompting_service;
#line 831 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp25_, (gfloat) 0, (gfloat) 0.5);
#line 833 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp26_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 833 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp26_);
#line 833 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	vbox_left = _tmp26_;
#line 834 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp27_ = self->priv->search_entry;
#line 834 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) vbox_left, (GtkWidget*) _tmp27_, FALSE, FALSE, (guint) 6);
#line 835 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) vbox_left, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
#line 836 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp28_ = self->priv->prompting_service;
#line 836 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) vbox_left, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 6);
#line 837 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) vbox_left, IDENTITY_MANAGER_VIEW_WINDOW_WIDTH, 0);
#line 839 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp29_ = _ ("No Identity: Send this identity to services which should not use Moons" \
"hot");
#line 839 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp30_ = (GtkLabel*) gtk_label_new (_tmp29_);
#line 839 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp30_);
#line 839 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->no_identity_title);
#line 839 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->no_identity_title = _tmp30_;
#line 840 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp31_ = self->priv->no_identity_title;
#line 840 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp31_, (gfloat) 0, (gfloat) 0.5);
#line 841 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp32_ = self->priv->no_identity_title;
#line 841 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_label_set_line_wrap (_tmp32_, TRUE);
#line 842 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp33_ = self->priv->no_identity_title;
#line 842 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp33_);
#line 844 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp34_ = _ ("Login: ");
#line 844 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp35_ = (GtkLabel*) gtk_label_new (_tmp34_);
#line 844 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp35_);
#line 844 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	login_vbox_title = _tmp35_;
#line 845 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_label_make_bold (self, login_vbox_title);
#line 846 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) login_vbox_title, (gfloat) 0, (gfloat) 0.5);
#line 847 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp36_ = _ ("Issuer:");
#line 847 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp37_ = (GtkLabel*) gtk_label_new (_tmp36_);
#line 847 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp37_);
#line 847 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	issuer_label = _tmp37_;
#line 848 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) issuer_label, (gfloat) 1, (gfloat) 0.5);
#line 849 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp38_ = (GtkEntry*) gtk_entry_new ();
#line 849 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp38_);
#line 849 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->issuer_entry);
#line 849 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->issuer_entry = _tmp38_;
#line 850 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp39_ = self->priv->issuer_entry;
#line 850 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp39_, FALSE);
#line 851 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp40_ = _ ("Username:");
#line 851 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp41_ = (GtkLabel*) gtk_label_new (_tmp40_);
#line 851 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp41_);
#line 851 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	username_label = _tmp41_;
#line 852 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) username_label, (gfloat) 1, (gfloat) 0.5);
#line 853 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp42_ = (GtkEntry*) gtk_entry_new ();
#line 853 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp42_);
#line 853 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 853 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->username_entry = _tmp42_;
#line 854 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp43_ = self->priv->username_entry;
#line 854 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_can_focus ((GtkWidget*) _tmp43_, FALSE);
#line 855 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp44_ = _ ("Password:");
#line 855 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp45_ = (GtkLabel*) gtk_label_new (_tmp44_);
#line 855 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp45_);
#line 855 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	password_label = _tmp45_;
#line 856 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) password_label, (gfloat) 1, (gfloat) 0.5);
#line 857 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp46_ = (GtkEntry*) gtk_entry_new ();
#line 857 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp46_);
#line 857 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 857 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->password_entry = _tmp46_;
#line 858 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp47_ = self->priv->password_entry;
#line 858 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_invisible_char (_tmp47_, (gunichar) '*');
#line 859 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp48_ = self->priv->password_entry;
#line 859 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_visibility (_tmp48_, FALSE);
#line 860 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp49_ = self->priv->password_entry;
#line 860 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp49_, FALSE);
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp50_ = _ ("Remember password");
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp51_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp50_);
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp51_);
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->remember_checkbutton);
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->remember_checkbutton = _tmp51_;
#line 862 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp52_ = self->priv->remember_checkbutton;
#line 862 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp52_, FALSE);
#line 863 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp53_ = _ ("Update Password");
#line 863 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp54_ = (GtkButton*) gtk_button_new_with_label (_tmp53_);
#line 863 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp54_);
#line 863 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->update_password_button);
#line 863 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->update_password_button = _tmp54_;
#line 864 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp55_ = self->priv->update_password_button;
#line 864 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp55_, "clicked", (GCallback) _identity_manager_view_update_password_cb_gtk_button_clicked, self, 0);
#line 866 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp56_ = self->priv->issuer_entry;
#line 866 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_set_atk_relation ((GtkWidget*) issuer_label, (GtkWidget*) _tmp56_, ATK_RELATION_LABEL_FOR);
#line 867 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp57_ = self->priv->username_entry;
#line 867 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_set_atk_relation ((GtkWidget*) username_label, (GtkWidget*) _tmp57_, ATK_RELATION_LABEL_FOR);
#line 868 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp58_ = self->priv->password_entry;
#line 868 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp59_ = self->priv->password_entry;
#line 868 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_set_atk_relation ((GtkWidget*) _tmp58_, (GtkWidget*) _tmp59_, ATK_RELATION_LABEL_FOR);
#line 870 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp60_ = (GtkTable*) gtk_table_new ((guint) 5, (guint) 2, FALSE);
#line 870 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp60_);
#line 870 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	login_table = _tmp60_;
#line 871 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_set_col_spacings (login_table, (guint) 10);
#line 872 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_set_row_spacings (login_table, (guint) 10);
#line 873 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach_defaults (login_table, (GtkWidget*) issuer_label, (guint) 0, (guint) 1, (guint) 0, (guint) 1);
#line 874 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp61_ = self->priv->issuer_entry;
#line 874 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach_defaults (login_table, (GtkWidget*) _tmp61_, (guint) 1, (guint) 2, (guint) 0, (guint) 1);
#line 875 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach_defaults (login_table, (GtkWidget*) username_label, (guint) 0, (guint) 1, (guint) 1, (guint) 2);
#line 876 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp62_ = self->priv->username_entry;
#line 876 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach_defaults (login_table, (GtkWidget*) _tmp62_, (guint) 1, (guint) 2, (guint) 1, (guint) 2);
#line 877 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach_defaults (login_table, (GtkWidget*) password_label, (guint) 0, (guint) 1, (guint) 2, (guint) 3);
#line 878 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp63_ = self->priv->password_entry;
#line 878 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach_defaults (login_table, (GtkWidget*) _tmp63_, (guint) 1, (guint) 2, (guint) 2, (guint) 3);
#line 879 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp64_ = self->priv->remember_checkbutton;
#line 879 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach_defaults (login_table, (GtkWidget*) _tmp64_, (guint) 1, (guint) 2, (guint) 3, (guint) 4);
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp65_ = self->priv->update_password_button;
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach_defaults (login_table, (GtkWidget*) _tmp65_, (guint) 0, (guint) 1, (guint) 4, (guint) 5);
#line 881 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp66_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0, (gfloat) 0, (gfloat) 0, (gfloat) 0);
#line 881 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp66_);
#line 881 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	login_vbox_alignment = _tmp66_;
#line 882 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_alignment_set_padding (login_vbox_alignment, (guint) 0, (guint) 0, (guint) 12, (guint) 0);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_add ((GtkContainer*) login_vbox_alignment, (GtkWidget*) login_table);
#line 884 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp67_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
#line 884 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp67_);
#line 884 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->login_vbox);
#line 884 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->login_vbox = _tmp67_;
#line 885 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp68_ = self->priv->login_vbox;
#line 885 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp68_, (GtkWidget*) login_vbox_title, FALSE, TRUE, (guint) 0);
#line 886 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp69_ = self->priv->login_vbox;
#line 886 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp69_, (GtkWidget*) login_vbox_alignment, FALSE, TRUE, (guint) 0);
#line 888 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp70_ = _ ("Services:");
#line 888 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp71_ = (GtkLabel*) gtk_label_new (_tmp70_);
#line 888 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp71_);
#line 888 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	services_vbox_title = _tmp71_;
#line 889 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_label_make_bold (self, services_vbox_title);
#line 890 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) services_vbox_title, (gfloat) 0, (gfloat) 0.5);
#line 891 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp72_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0, (gfloat) 0, (gfloat) 0, (gfloat) 0);
#line 891 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp72_);
#line 891 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	services_vbox_alignment = _tmp72_;
#line 892 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_alignment_set_padding (services_vbox_alignment, (guint) 0, (guint) 0, (guint) 12, (guint) 0);
#line 893 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp73_ = (GtkVBox*) gtk_vbox_new (TRUE, 6);
#line 893 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp73_);
#line 893 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->services_internal_vbox);
#line 893 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->services_internal_vbox = _tmp73_;
#line 894 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp74_ = self->priv->services_internal_vbox;
#line 894 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_add ((GtkContainer*) services_vbox_alignment, (GtkWidget*) _tmp74_);
#line 895 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp75_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
#line 895 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp75_);
#line 895 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->services_vbox);
#line 895 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->services_vbox = _tmp75_;
#line 896 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp76_ = self->priv->services_vbox;
#line 896 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp76_, (GtkWidget*) services_vbox_title, FALSE, TRUE, (guint) 0);
#line 897 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp77_ = self->priv->services_vbox;
#line 897 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp77_, (GtkWidget*) services_vbox_alignment, FALSE, TRUE, (guint) 0);
#line 899 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp78_ = (GtkVBox*) gtk_vbox_new (FALSE, 18);
#line 899 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp78_);
#line 899 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->vbox_right);
#line 899 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->vbox_right = _tmp78_;
#line 900 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp79_ = self->priv->vbox_right;
#line 900 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp80_ = self->priv->login_vbox;
#line 900 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp79_, (GtkWidget*) _tmp80_, FALSE, TRUE, (guint) 0);
#line 901 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp81_ = self->priv->vbox_right;
#line 901 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp82_ = self->priv->services_vbox;
#line 901 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp81_, (GtkWidget*) _tmp82_, FALSE, TRUE, (guint) 0);
#line 903 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp83_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
#line 903 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp83_);
#line 903 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	hbox = _tmp83_;
#line 904 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox_left, FALSE, FALSE, (guint) 0);
#line 905 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp84_ = self->priv->vbox_right;
#line 905 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) _tmp84_, TRUE, TRUE, (guint) 0);
#line 907 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp85_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 907 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp85_);
#line 907 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	main_vbox = _tmp85_;
#line 908 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_set_border_width ((GtkContainer*) main_vbox, (guint) 12);
#line 921 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp86_ = self->priv->ui_manager;
#line 921 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp87_ = gtk_ui_manager_get_widget (_tmp86_, "/MenuBar");
#line 921 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp88_ = _g_object_ref0 (_tmp87_);
#line 921 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	menubar = _tmp88_;
#line 922 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) main_vbox, menubar, FALSE, FALSE, (guint) 0);
#line 924 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) main_vbox, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
#line 925 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vbox);
#line 926 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_show_all ((GtkWidget*) main_vbox);
#line 927 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp89_ = self->priv->vbox_right;
#line 927 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp89_);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (menubar);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (main_vbox);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (hbox);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (services_vbox_alignment);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (services_vbox_title);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (login_vbox_alignment);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (login_table);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (password_label);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (username_label);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (issuer_label);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (login_vbox_title);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (vbox_left);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (scroll);
#line 793 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (viewport);
#line 4802 "moonshot-identity-management-view.c"
}


static void identity_manager_view_set_atk_name_description (IdentityManagerView* self, GtkWidget* widget, const gchar* name, const gchar* description) {
	AtkObject* atk_widget = NULL;
	GtkWidget* _tmp0_ = NULL;
	AtkObject* _tmp1_ = NULL;
	AtkObject* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 930 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 930 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (widget != NULL);
#line 930 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (name != NULL);
#line 930 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (description != NULL);
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = widget;
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = gtk_widget_get_accessible (_tmp0_);
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	atk_widget = _tmp2_;
#line 934 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = name;
#line 934 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	atk_object_set_name (atk_widget, _tmp3_);
#line 935 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = description;
#line 935 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	atk_object_set_description (atk_widget, _tmp4_);
#line 930 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (atk_widget);
#line 4839 "moonshot-identity-management-view.c"
}


static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self) {
#line 940 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_main_quit ();
#line 4846 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_on_card_list_changed_identity_manager_model_card_list_changed (IdentityManagerModel* _sender, gpointer self) {
#line 941 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_on_card_list_changed ((IdentityManagerView*) self);
#line 4853 "moonshot-identity-management-view.c"
}


static void identity_manager_view_connect_signals (IdentityManagerView* self) {
	IdentityManagerModel* _tmp0_ = NULL;
#line 938 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 940 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect ((GtkObject*) self, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
#line 941 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->identities_manager;
#line 941 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp0_, "card-list-changed", (GCallback) _identity_manager_view_on_card_list_changed_identity_manager_model_card_list_changed, self, 0);
#line 4867 "moonshot-identity-management-view.c"
}


static void identity_manager_view_set_atk_relation (GtkWidget* widget, GtkWidget* target_widget, AtkRelationType relationship) {
	AtkObject* atk_widget = NULL;
	GtkWidget* _tmp0_ = NULL;
	AtkObject* _tmp1_ = NULL;
	AtkObject* _tmp2_ = NULL;
	AtkObject* atk_target_widget = NULL;
	GtkWidget* _tmp3_ = NULL;
	AtkObject* _tmp4_ = NULL;
	AtkObject* _tmp5_ = NULL;
	AtkRelationType _tmp6_ = 0;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (widget != NULL);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (target_widget != NULL);
#line 946 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = widget;
#line 946 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = gtk_widget_get_accessible (_tmp0_);
#line 946 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 946 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	atk_widget = _tmp2_;
#line 947 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = target_widget;
#line 947 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = gtk_widget_get_accessible (_tmp3_);
#line 947 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 947 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	atk_target_widget = _tmp5_;
#line 949 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = relationship;
#line 949 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	atk_object_add_relationship (atk_widget, _tmp6_, atk_target_widget);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (atk_target_widget);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (atk_widget);
#line 4909 "moonshot-identity-management-view.c"
}


static void identity_manager_view_class_init (IdentityManagerViewClass * klass) {
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_type_class_add_private (klass, sizeof (IdentityManagerViewPrivate));
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	G_OBJECT_CLASS (klass)->finalize = identity_manager_view_finalize;
#line 4920 "moonshot-identity-management-view.c"
}


static void identity_manager_view_instance_init (IdentityManagerView * self) {
	GtkUIManager* _tmp0_ = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv = IDENTITY_MANAGER_VIEW_GET_PRIVATE (self);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = gtk_ui_manager_new ();
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->ui_manager = _tmp0_;
#line 4932 "moonshot-identity-management-view.c"
}


static void identity_manager_view_finalize (GObject* obj) {
	IdentityManagerView * self;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView);
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_identity_manager_app_unref0 (self->parent_app);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->ui_manager);
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->vbox_right);
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->login_vbox);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->services_vbox);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->custom_vbox);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->services_internal_vbox);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->issuer_entry);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->prompting_service);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->no_identity_title);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->remember_checkbutton);
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->update_password_button);
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->filter);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->identities_manager);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__g_queue_free__g_object_unref0_0 (self->request_queue);
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_hash_table_unref0 (self->priv->service_button_map);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	G_OBJECT_CLASS (identity_manager_view_parent_class)->finalize (obj);
#line 4980 "moonshot-identity-management-view.c"
}


GType identity_manager_view_get_type (void) {
	static volatile gsize identity_manager_view_type_id__volatile = 0;
	if (g_once_init_enter (&identity_manager_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IdentityManagerViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) identity_manager_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdentityManagerView), 0, (GInstanceInitFunc) identity_manager_view_instance_init, NULL };
		GType identity_manager_view_type_id;
		identity_manager_view_type_id = g_type_register_static (GTK_TYPE_WINDOW, "IdentityManagerView", &g_define_type_info, 0);
		g_once_init_leave (&identity_manager_view_type_id__volatile, identity_manager_view_type_id);
	}
	return identity_manager_view_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



