/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ViewsDrawer_H
#include "ViewsDrawer.h"
#endif

#ifndef Editor_H
#include "Editor.h"
#endif

#ifndef XMLabel_H
#include "XMLabel.h"
#endif


#ifndef EditorDrawer_H
#include "EditorDrawer.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif


#ifndef IconClass_H
#include "IconClass.h"
#endif
#ifndef FolderWindow_H
#include "FolderWindow.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif
#ifndef EditorDrawerFactory_H
#include "EditorDrawerFactory.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#ifndef SyncFolders_H
#include "SyncFolders.h"
#endif

#include <Drag.h>

#ifndef ViewEditor_H
#include "ViewEditor.h"
#endif

static Folder* folder(ViewEditor& e)
{
	return Folder::folder("templates",e.iconClass().defaultName() + "/Views", true);
}

ViewsDrawer::ViewsDrawer(ViewEditor& e):
	XEditorDrawer<UIViewsDrawer_c>(e), 
		FolderViewer(folder(e))
{
	FolderViewer::install(drag_);
}

ViewsDrawer::~ViewsDrawer()
{
}

void ViewsDrawer::edit(IconObject* o)
{	  	  
}


Widget ViewsDrawer::menu()
{	  	
	if ( current_.size() == 0 ) 	 
		return menu2_;
	return menu1_;
}

bool ViewsDrawer::accept(IconObject *o)
{
	return o->iconClass().type() == "View";
}

void ViewsDrawer::editCB( Widget, XtPointer )
{	       
 	for(vector<IconObjectH>::iterator j = current_.begin() ; 
		j != current_.end(); ++j)
			(*j)->edit();
}

void ViewsDrawer::openFolderCB( Widget, XtPointer )
{	
	folder_->open();
}

void ViewsDrawer::updateCB( Widget, XtPointer )
{	
	folder_->empty();
	fill(0);
}

struct Updater : public ClassScanner {

	Folder* folder_;

	void next(const IconClass& c) {

		if(c.type() == "View")
			c.createOne(folder_);
	}

	Updater(Folder* folder) : folder_(folder) {}

};

bool ViewsDrawer::fill(int pass)
{
	if(pass == 0)
	{
		Updater u(folder_);
		IconClass::scan(u);
	}
	return false;
}

static EditorDrawerMaker<ViewsDrawer,ViewEditor> maker(99);

