## REST API

### Usage

This API is used by the daemon with the others client to communicate.

It is used above an HTTP connection.

### History

#### Version 1.1

* Add the force parameter in the Analyze request.

#### Version 1

* API created.
* Command: Analyze, Status, Report, Retry, Clear

### API

#### Command

* Analyze: HTTP POST
* Status:  HTTP GET
* Report:  HTTP POST
* Retry:   HTTP PUT
* Clear:   HTTP DELETE

#### Analyze

JSON format for the parameters.

##### Request

Parameters:

* args:              Array of Arguments

- file:              String: Name of the file to analyze
- id:                Integer: a unique id for the request
- force:             Boolean: force to analyze the file even if registered in database (introduce in v1.1)

##### Response

Parameters:

* ok:                Array of valid arguments

- inId:              Integer: id given by the request
- outId:             Integer: unique id generated by the daemon
- create:            Boolean: if the file was not registered

* nok: Array of invalid arguments

- id:                Integer: id given by the request
- error:             Integer: Error code corresponding to the error

#### Status

URI format for the parameters.

##### Request

Parameters:

* List of:

- id:                Integer: id given by the Analyze command

##### Response

Parameters:

* ok:                Array of valid arguments

- id:                Integer: id given by the request
- finish:            Boolean: if the file is finished to be analyzed
- done:              Doule: Percent done by the analysis

* nok:               Array of invalid arguments

- id:                Integer: id given by the request
- error:             Integer: Error code corresponding to the error

#### Report

JSON format for the parameters.

##### Request

Parameters:

* args:              Array of Arguments

- id:                Integer: id given by the Analyze command
- reports:           Array of report kinds
- policies_contents: Array of policies contents (Strings)
- policies_names:    Array of policies names (Strings)
- display_content:   String:  display content
- display_name:      String:  display name (HTML, TEXT, XML, MAXML, JSTREE)

##### Response

Parameters:

* ok:                Structure of the following parameters

- report:            String: Contain the report corresponding to all requested parameters
- valid:             Boolean: true if all policies are valid

* nok:               Array of invalid arguments

- id:                Integer: id given by the request
- error:             Integer: Error code corresponding to the error

#### Retry

JSON format for the parameters.

##### Request

Parameters:

* ids:              Array of id given by the Analyze command

##### Response

Parameters:

* ok:                Array of Integer: ids of the files analyzed again

* nok:               Array of invalid arguments

- id:                Integer: id given by the request
- error:             Integer: Error code corresponding to the error

#### Clear

URI format for the parameters.

##### Request

Parameters:

* List of:

- id:                Integer: id given by the Analyze command

##### Response

Parameters:

* ok:                Array of Integer: ids of the files removed from Database

* nok:               Array of invalid arguments

- id:                Integer: id given by the request
- error:             Integer: Error code corresponding to the error

#### Report kinds

* NO\REPORT:      0
* POLICY:         1
* IMPLEMENTATION: 2
* MEDIAINFO:      3
* MEDIATRACE:     4

#### Error reason

* NOT\_REASON           0
* FILE\_NOT\_EXISTING   1
* ID\_NOT\_EXIsTING     2
* NOT\_READY            3
