%%% The contents of this file are subject to the Erlang Public License,
%%% Version 1.0, (the "License"); you may not use this file except in
%%% compliance with the License. You may obtain a copy of the License at
%%% http://www.erlang.org/license/EPL1_0.txt
%%%
%%% Software distributed under the License is distributed on an "AS IS"
%%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%%% the License for the specific language governing rights and limitations
%%% under the License.
%%%
%%% The Original Code is xmerl-0.13
%%%
%%% The Initial Developer of the Original Code is Ericsson Telecom
%%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%%% Telecom AB. All Rights Reserved.
%%%
%%% Contributor(s):
%%%    <michael.remond@IDEALX.com>: suggested #xmlDocument{}
%%%
%%%----------------------------------------------------------------------
%%% #0.    BASIC INFORMATION
%%%----------------------------------------------------------------------
%%% File:       xmerl.hrl
%%% Author       : Ulf Wiger <ulf.wiger@ericsson.com>
%%% Date         : 00-09-22
%%% Description  : Record and macro definitions for xmerl
%%%----------------------------------------------------------------------



%% records generated by the scanner
%% --------------------------------

%% XML declaration
-record(xmlDecl, {
		  vsn,
		  encoding,
		  attributes
		 }).

%% Attribute
-record(xmlAttribute, {
		       name,
		       parents = [],
		       pos,
		       language = [],   % inherits the element's language
		       expanded_name = [],
		       nsinfo = [],	% {Prefix, Local} | []
		       namespace = [],  % inherits the element's namespace
		       value
		      }).

%% namespace record
-record(xmlNamespace, {
		       default = [],
		       nodes = []
		      }).

%% namespace node - i.e. a {Prefix, URI} pair
-record(xmlNsNode, {
		    prefix,
		    uri = []
		   }).

%% XML Element
-record(xmlElement, {
		     name,
		     parents = [],
		     pos,
		     attributes = [],
		     content = [],
		     language = [],
		     expanded_name = [],
		     nsinfo = [],	% {Prefix, Local} | []
		     namespace = #xmlNamespace{}
		    }).

%% plain text
-record(xmlText, {
		  parents = [],
		  pos,
		  language = [], % inherits the element's language
		  value
		 }).

%% plain text
-record(xmlComment, {
		     parents = [],
		     pos,
		     language = [], % inherits the element's language
		     value
		 }).

%% processing instruction
-record(xmlPI, {
		name,
		pos,
		value
		}).

-record(xmlDocument, {
		      content
		     }).


%% XPATH (xmerl_xpath, xmerl_pred_funcs) records

-record(xmlContext, {
		     axis_type = forward,
		     context_node,
		     context_position = 1,
		     nodeset = [],
		     bindings = [],
		     functions = [],
		     namespace = [],
		     whole_document
		    }).

-record(xmlNode, {
		  type = element,
		  node,
		  parents = [],
		  pos = 1
		 }).

-record(xmlObj, {
		 type,
		 value
		 }).

-record(xmerl_fun_states, {event,
			   hook,
			   rules,
			   fetch,
			   cont}).


%% scanner state record
-record(xmerl_scanner, {
			encoding = "ISO-8859-1",
			declarations = [],	% [{Name, Attrs}]
			doctype_name,
			doctype_DTD = internal, % internal | DTDId
			rules,
			keep_rules = false,	% delete (ets) tab if false
			namespace_conformant = false, % true | false
			event_fun,
			hook_fun,
			acc_fun,
			fetch_fun,
			close_fun,
			continuation_fun,
			rules_read_fun,
			rules_write_fun,
			directory,
			fetch_path = [],
			user_state,
			fun_states = #xmerl_fun_states{},
			col = 1,
			line = 1
		       }).




%% scanner events

%% event : start | end
-record(xmerl_event, {
		      event,
		      line,
		      col,
		      pos,
		      data
		     }).



%% useful scanner macros
%% ---------------------

-ifdef(debug).
-define(dbg(Fmt, Args), ok=io:format("~p: " ++ Fmt, [?LINE|Args])).
-define(DBG, ok=io:format("<<~p:~p>>~n", [?MODULE, ?LINE])).
-else.
-define(dbg(Fmt, Args), no_debug).
-define(DBG, no_debug).
-endif.

-define(space, 16#20).
-define(cr, 16#9).
-define(lf, 16#D).
-define(tab, 16#A).

%% whitespace consists of 'space', 'carriage return', 'line feed' or 'tab'
-define(whitespace(H), H==?space ; H==?cr ; H==?lf ; H==?tab).

-define(strip1,  {_, T1,  S1}  = strip(T,  S)).
-define(strip2,  {_, T2,  S2}  = strip(T1, S1)).
-define(strip3,  {_, T3,  S3}  = strip(T2, S2)).
-define(strip4,  {_, T4,  S4}  = strip(T3, S3)).
-define(strip5,  {_, T5,  S5}  = strip(T4, S4)).
-define(strip6,  {_, T6,  S6}  = strip(T5, S5)).
-define(strip7,  {_, T7,  S7}  = strip(T6, S6)).
-define(strip8,  {_, T8,  S8}  = strip(T7, S7)).
-define(strip9,  {_, T9,  S9}  = strip(T8, S8)).
-define(strip10, {_, T10, S10} = strip(T9, S9)).

-define(bump_col(N), 
	?dbg("bump_col(~p), US = ~p~n", [N, S0#xmerl_scanner.user_state]),
	S = S0#xmerl_scanner{col = S0#xmerl_scanner.col + N}).
