/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include "mn-yahoo-mailbox.h"

#include "mn-yahoo-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 24 "src/mn-yahoo-mailbox.gob"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <glib/gi18n.h>
#include "mn-webmail-mailbox-private.h"
#include "mn-stock.h"
#include "mn-conf.h"
#include "mn-util.h"

#line 38 "mn-yahoo-mailbox.c"
/* self casting macros */
#define SELF(x) MN_YAHOO_MAILBOX(x)
#define SELF_CONST(x) MN_YAHOO_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_YAHOO_MAILBOX(x)
#define TYPE_SELF MN_TYPE_YAHOO_MAILBOX
#define SELF_CLASS(x) MN_YAHOO_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_YAHOO_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNYahooMailbox Self;
typedef MNYahooMailboxClass SelfClass;

/* here are local prototypes */
#line 40 "src/mn-yahoo-mailbox.gob"
static void mn_yahoo_mailbox_class_init (MNYahooMailboxClass * class);
#line 55 "mn-yahoo-mailbox.c"
#line 50 "src/mn-yahoo-mailbox.gob"
static void mn_yahoo_mailbox_init (MNYahooMailbox * self);
#line 58 "mn-yahoo-mailbox.c"
#line 56 "src/mn-yahoo-mailbox.gob"
static char * mn_yahoo_mailbox_create_cookies_file (GError ** err);
#line 61 "mn-yahoo-mailbox.c"
#line 95 "src/mn-yahoo-mailbox.gob"
static gboolean mn_yahoo_mailbox_can_convert (const char * str, const char * encoding);
#line 64 "mn-yahoo-mailbox.c"
#line 109 "src/mn-yahoo-mailbox.gob"
static const char * mn_yahoo_mailbox_get_config_file_encoding (const char * folder);
#line 67 "mn-yahoo-mailbox.c"
#line 123 "src/mn-yahoo-mailbox.gob"
static char * mn_yahoo_mailbox_create_config_file (MNYahooMailbox * self, const char * spool_file, const char * cookies_file, GError ** err);
#line 70 "mn-yahoo-mailbox.c"
#line 193 "src/mn-yahoo-mailbox.gob"
static char * ___7_mn_yahoo_mailbox_get_error_message (MNWebmailMailbox * mailbox, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure);
#line 73 "mn-yahoo-mailbox.c"
#line 235 "src/mn-yahoo-mailbox.gob"
static gboolean mn_yahoo_mailbox_run_fetchyahoo (MNYahooMailbox * self, const char * config_file, GError ** err);
#line 76 "mn-yahoo-mailbox.c"
#line 248 "src/mn-yahoo-mailbox.gob"
static gboolean ___9_mn_yahoo_mailbox_webmail_check (MNWebmailMailbox * mailbox, GError ** err);
#line 79 "mn-yahoo-mailbox.c"

/* pointer to the class of our parent */
static MNWebmailMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_create_cookies_file mn_yahoo_mailbox_create_cookies_file
#define self_can_convert mn_yahoo_mailbox_can_convert
#define self_get_config_file_encoding mn_yahoo_mailbox_get_config_file_encoding
#define self_create_config_file mn_yahoo_mailbox_create_config_file
#define self_run_fetchyahoo mn_yahoo_mailbox_run_fetchyahoo
GType
mn_yahoo_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNYahooMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_yahoo_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNYahooMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_yahoo_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_WEBMAIL_MAILBOX, "MNYahooMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNYahooMailbox *)g_object_new(mn_yahoo_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNYahooMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNYahooMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNYahooMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNYahooMailbox *)g_object_new_valist (mn_yahoo_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}

#line 40 "src/mn-yahoo-mailbox.gob"
static void 
mn_yahoo_mailbox_class_init (MNYahooMailboxClass * class G_GNUC_UNUSED)
{
#line 136 "mn-yahoo-mailbox.c"
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::class_init"
	MNWebmailMailboxClass *mn_webmail_mailbox_class = (MNWebmailMailboxClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_WEBMAIL_MAILBOX);

#line 193 "src/mn-yahoo-mailbox.gob"
	mn_webmail_mailbox_class->get_error_message = ___7_mn_yahoo_mailbox_get_error_message;
#line 248 "src/mn-yahoo-mailbox.gob"
	mn_webmail_mailbox_class->webmail_check = ___9_mn_yahoo_mailbox_webmail_check;
#line 146 "mn-yahoo-mailbox.c"
 {
#line 41 "src/mn-yahoo-mailbox.gob"

    MN_MAILBOX_CLASS(class)->type = "yahoo";

    /* 5 minutes is a good default */
    MN_MAILBOX_CLASS(class)->default_check_delay = 60 * 5;

    MN_WEBMAIL_MAILBOX_CLASS(class)->default_domain = "yahoo.com";
  
#line 157 "mn-yahoo-mailbox.c"
 }
}
#undef __GOB_FUNCTION__
#line 50 "src/mn-yahoo-mailbox.gob"
static void 
mn_yahoo_mailbox_init (MNYahooMailbox * self G_GNUC_UNUSED)
{
#line 165 "mn-yahoo-mailbox.c"
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::init"
 {
#line 51 "src/mn-yahoo-mailbox.gob"

    mn_mailbox_set_format(MN_MAILBOX(self), "Yahoo! Mail");
    mn_mailbox_set_stock_id(MN_MAILBOX(self), MN_STOCK_YAHOO);
  
#line 173 "mn-yahoo-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 56 "src/mn-yahoo-mailbox.gob"
static char * 
mn_yahoo_mailbox_create_cookies_file (GError ** err)
{
#line 184 "mn-yahoo-mailbox.c"
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::create_cookies_file"
{
#line 58 "src/mn-yahoo-mailbox.gob"
	
    char *filename;

    /*
     * If the file already exists, ensure it has the proper
     * permissions. Otherwise, create it with the proper permissions.
     */

    filename = g_build_filename(mn_conf_dot_dir, "yahoo-cookies", NULL);
    if (g_file_test(filename, G_FILE_TEST_EXISTS))
      {
	if (chmod(filename, S_IRUSR | S_IWUSR) < 0)
	  {
	    g_set_error(err, 0, 0, _("unable to change the permissions of %s: %s"), filename, g_strerror(errno));
	    goto error;
	  }
      }
    else
      {
	int fd;

	fd = open(filename, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR);
	if (fd < 0)
	  {
	    g_set_error(err, 0, 0, _("unable to create %s: %s"), filename, g_strerror(errno));
	    goto error;
	  }
	close(fd);
      }

    return filename;

  error:
    g_free(filename);
    return NULL;
  }}
#line 224 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__

#line 95 "src/mn-yahoo-mailbox.gob"
static gboolean 
mn_yahoo_mailbox_can_convert (const char * str, const char * encoding)
{
#line 231 "mn-yahoo-mailbox.c"
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::can_convert"
#line 95 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (str != NULL, (gboolean )0);
#line 95 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (encoding != NULL, (gboolean )0);
#line 237 "mn-yahoo-mailbox.c"
{
#line 98 "src/mn-yahoo-mailbox.gob"
	
    char *converted;
    gboolean can;

    converted = g_convert(str, -1, encoding, "UTF-8", NULL, NULL, NULL);
    can = converted != NULL;
    g_free(converted);

    return can;
  }}
#line 250 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__

#line 109 "src/mn-yahoo-mailbox.gob"
static const char * 
mn_yahoo_mailbox_get_config_file_encoding (const char * folder)
{
#line 257 "mn-yahoo-mailbox.c"
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::get_config_file_encoding"
#line 109 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (folder != NULL, (const char * )0);
#line 261 "mn-yahoo-mailbox.c"
{
#line 111 "src/mn-yahoo-mailbox.gob"
	
    /*
     * fetchyahoo does not seem to deal with the folder name encoding
     * at all, and Yahoo apparently uses ISO8859-1 when possible, and
     * UTF-8 otherwise.
     */
    if (self_can_convert(folder, "ISO8859-1"))
      return "ISO8859-1";
    else
      return "UTF-8";
  }}
#line 275 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__

#line 123 "src/mn-yahoo-mailbox.gob"
static char * 
mn_yahoo_mailbox_create_config_file (MNYahooMailbox * self, const char * spool_file, const char * cookies_file, GError ** err)
{
#line 282 "mn-yahoo-mailbox.c"
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::create_config_file"
#line 123 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 123 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (MN_IS_YAHOO_MAILBOX (self), (char * )0);
#line 123 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (spool_file != NULL, (char * )0);
#line 123 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (cookies_file != NULL, (char * )0);
#line 292 "mn-yahoo-mailbox.c"
{
#line 128 "src/mn-yahoo-mailbox.gob"
	
    GString *contents;
    char *filename;

    contents = g_string_new(NULL);

    g_string_append_printf(contents,
			   "username = %s\n"
			   "password = %s\n"
			   "folder = %s\n"
			   "spool = %s\n"
			   "cookie-file = %s\n"
			   "new-messages-only = 1\n"
			   "no-delete = 1\n"
			   "leave-unread = 1\n",
			   MN_AUTHENTICATED_MAILBOX(self)->username,
			   MN_AUTHENTICATED_MAILBOX(self)->runtime_password,
			   MN_WEBMAIL_MAILBOX(self)->folder,
			   spool_file,
			   cookies_file);

    if (mn_conf_get_bool(MN_CONF_SYSTEM_HTTP_PROXY_USE_HTTP_PROXY))
      {
	char *host;

	host = mn_conf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_HOST);
	if (host && *host)
	  {
	    g_string_append_printf(contents,
				   "use-proxy = 1\n"
				   "proxy-host = %s\n"
				   "proxy-port = %i\n",
				   host,
				   mn_conf_get_int(MN_CONF_SYSTEM_HTTP_PROXY_PORT));

	    if (mn_conf_get_bool(MN_CONF_SYSTEM_HTTP_PROXY_USE_AUTHENTICATION))
	      {
		char *user;
		char *password;

		user = mn_conf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_AUTHENTICATION_USER);
		password = mn_conf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_AUTHENTICATION_PASSWORD);

		if (user && *user && password && *password)
		  g_string_append_printf(contents,
					 "proxy-username = %s\n"
					 "proxy-password = %s\n",
					 user,
					 password);

		g_free(user);
		g_free(password);
	      }
	  }
	g_free(host);
      }

    mn_webmail_mailbox_print_config(MN_WEBMAIL_MAILBOX(self), contents->str);
    filename = mn_webmail_mailbox_write_temporary_file(contents->str, self_get_config_file_encoding(MN_WEBMAIL_MAILBOX(self)->folder), err);

    g_string_free(contents, TRUE);

    return filename;
  }}
#line 359 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__

#line 193 "src/mn-yahoo-mailbox.gob"
static char * 
___7_mn_yahoo_mailbox_get_error_message (MNWebmailMailbox * mailbox G_GNUC_UNUSED, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure)
#line 365 "mn-yahoo-mailbox.c"
#define PARENT_HANDLER(___mailbox,___helper_stdout,___helper_stderr,___is_auth_failure) \
	((MN_WEBMAIL_MAILBOX_CLASS(parent_class)->get_error_message)? \
		(* MN_WEBMAIL_MAILBOX_CLASS(parent_class)->get_error_message)(___mailbox,___helper_stdout,___helper_stderr,___is_auth_failure): \
		((char * )0))
{
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::get_error_message"
{
#line 198 "src/mn-yahoo-mailbox.gob"
	
    if (helper_stderr)
      {
	char **lines;
	int i;
	char *message = NULL;

	lines = g_strsplit(helper_stderr, "\n", 0);
	for (i = 0; lines[i]; i++)
	  if (g_str_has_prefix(lines[i], "Failed: "))
	    {
	      char *escaped;

	      if (mn_ascii_strcasestr(lines[i], "wrong password")
		  || mn_ascii_strcasestr(lines[i], "invalid ID")
		  || (mn_ascii_strcasestr(lines[i], "Yahoo user")
		      && mn_ascii_strcasestr(lines[i], "does not exist")))
		*is_auth_failure = TRUE;

	      escaped = mn_utf8_escape(lines[i] + 8);
	      message = g_strdup_printf(_("\"%s\""), escaped);
	      g_free(escaped);

	      break;
	    }
	g_strfreev(lines);

	if (message)
	  return message;

	if (mn_ascii_strcasestr(helper_stderr, "an image of text"))
	  return g_strdup(_("delay between mail checks too small"));
      }

    return NULL;
  }}
#line 410 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 235 "src/mn-yahoo-mailbox.gob"
static gboolean 
mn_yahoo_mailbox_run_fetchyahoo (MNYahooMailbox * self, const char * config_file, GError ** err)
{
#line 418 "mn-yahoo-mailbox.c"
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::run_fetchyahoo"
#line 235 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 235 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (MN_IS_YAHOO_MAILBOX (self), (gboolean )0);
#line 235 "src/mn-yahoo-mailbox.gob"
	g_return_val_if_fail (config_file != NULL, (gboolean )0);
#line 426 "mn-yahoo-mailbox.c"
{
#line 237 "src/mn-yahoo-mailbox.gob"
	
    char *command;
    gboolean status;

    command = g_strdup_printf("fetchyahoo --configfile=%s", config_file);
    status = mn_webmail_mailbox_run_helper(MN_WEBMAIL_MAILBOX(self), "fetchyahoo", command, err);
    g_free(command);

    return status;
  }}
#line 439 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__

#line 248 "src/mn-yahoo-mailbox.gob"
static gboolean 
___9_mn_yahoo_mailbox_webmail_check (MNWebmailMailbox * mailbox G_GNUC_UNUSED, GError ** err)
#line 445 "mn-yahoo-mailbox.c"
#define PARENT_HANDLER(___mailbox,___err) \
	((MN_WEBMAIL_MAILBOX_CLASS(parent_class)->webmail_check)? \
		(* MN_WEBMAIL_MAILBOX_CLASS(parent_class)->webmail_check)(___mailbox,___err): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::webmail_check"
{
#line 250 "src/mn-yahoo-mailbox.gob"
	
    Self *self = SELF(mailbox);
    char *spool_file;
    char *cookies_file;
    char *config_file = NULL;
    gboolean status = FALSE;

    /*
     * We create an empty spool file beforehand to make sure it is not
     * world-readable.
     */
    spool_file = mn_webmail_mailbox_create_spool_file(err);
    if (! spool_file)
      return FALSE;

    /*
     * Likewise, we create an empty cookies file beforehand to make
     * sure it is not world-readable.
     */
    cookies_file = self_create_cookies_file(err);
    if (! cookies_file)
      goto end;

    /*
     * We create a config file rather than use command line arguments
     * because for obvious reasons, we must not pass the password on
     * the command line.
     */
    config_file = self_create_config_file(self, spool_file, cookies_file, err);
    if (! config_file)
      goto end;

    if (! self_run_fetchyahoo(self, config_file, err))
      goto end;

    if (! mn_webmail_mailbox_read_spool_file(mailbox, spool_file, err))
      goto end;

    status = TRUE;

  end:
    unlink(spool_file);
    g_free(spool_file);

    g_free(cookies_file);

    if (config_file)
      {
	unlink(config_file);
	g_free(config_file);
      }

    return status;
  }}
#line 508 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
