/*
 * syncml plugin - A syncml plugin for OpenSync
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#ifndef _SML_DATA_SYNC_CALLBACKS_H
#define _SML_DATA_SYNC_CALLBACKS_H

#include "data_sync.h"

/* **************************************** */
/* *****     Management Callbacks     ***** */
/* **************************************** */

void smlDataSyncEventCallback(
		SmlManager *manager,
		SmlManagerEventType type,
		SmlSession *session,
		SmlError *error,
		void *userdata);

/* *************************************** */
/* *****     DsSession Callbacks     ***** */
/* *************************************** */

void smlDataSyncDatastoreConnectCallback(
		SmlDsSession *dsession,
		void *userdata);

/* *********************************** */
/* *****     Alert Callbacks     ***** */
/* *********************************** */

/* The real alert callbacks are specific for DS clients and servers.
 * So please check data_sync_client.h and data_sync_server.h for more details.
 */

void smlDataSyncAlertStatusCallback(
		SmlSession *session,
		SmlStatus *status,
		void *userdata);

/* ********************************** */
/* *****     Sync Callbacks     ***** */
/* ********************************** */

void smlDataSyncSyncCallback(
		SmlDsSession *dsession,
		unsigned int numchanges,
		void *userdata);

void smlDataSyncSyncStatusCallback(
		SmlSession *session,
		SmlStatus *status,
		void *userdata);

/* ************************************ */
/* *****     Change Callbacks     ***** */
/* ************************************ */

SmlBool smlDataSyncChangeCallback(
		SmlDsSession *dsession,
		SmlChangeType type,
		const char *uid,
		char *data,
		unsigned int size,
		const char *contenttype,
		void *userdata,
		SmlError **smlerror);

void smlDataSyncChangeStatusCallback(
		SmlDsSession *dsession,
		SmlStatus *status,
		const char *newuid,
		void *userdata);

void smlDataSyncMappingCallback(
		SmlDsSession *dsession,
		SmlLocation *orig,
		SmlLocation *newuid,
		void *userdata);

/* ********************************* */
/* *****     Map Callbacks     ***** */
/* ********************************* */

void smlDataSyncMapStatusCallback(
		SmlSession *session,
		SmlStatus *status,
		void *userdata);

/* ******************************************* */
/* *****     Authentication Callback     ***** */
/* ******************************************* */

SmlBool smlDataSyncVerifyUserCallback(
                SmlChal *chal,
                SmlCred *cred,
                const char *username,
                void *userdata,
                SmlError **error);

#endif /* _SML_DATA_SYNC_CALLBACKS_H */
