/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package org.netbeans.modules.i18n.wizard;

import org.openide.util.NbBundle;
import javax.swing.JPanel;


/**
 * Panel to monitor long tasks in i18n wizard. Namely searchnig
 * for hard codes strings and replacing the hard coded string
 * with internationalized ones.
 *
 * @author  Peter Zavadsky
 */
final class ProgressWizardPanel extends JPanel {

    /** Creates new form ProgressPanel */
    public ProgressWizardPanel(boolean withSubProgress) {
        initComponents();
	this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AdditionalWizardPanel.class).getString("ACS_ProgressWizardPanel"));                
        
        if(!withSubProgress) {
            remove(subLabel);
            remove(subProgress);
        }
        
        setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
    }

    
    /** Sets text of main label. */
    public void setMainText(String text) {
        mainLabel.setText(text);
    }
    
    /** Sets text of sub label. */
    public void setSubText(String text) {
        subLabel.setText(text);
    }

    /** Sets main progress bar value. */
    public void setMainProgress(int value) {
        mainProgress.setValue(value);
    }
    
    /** Sets sub progress bar value. */
    public void setSubProgress(int value) {
        subProgress.setValue(value);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        mainLabel = new javax.swing.JLabel();
        mainProgress = new javax.swing.JProgressBar();
        subLabel = new javax.swing.JLabel();
        subProgress = new javax.swing.JProgressBar();
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(mainLabel, gridBagConstraints1);
        
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(7, 0, 0, 0);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints1.weightx = 1.0;
        add(mainProgress, gridBagConstraints1);
        
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new java.awt.Insets(11, 0, 0, 0);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(subLabel, gridBagConstraints1);
        
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(7, 0, 0, 0);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints1.weightx = 1.0;
        add(subProgress, gridBagConstraints1);
        
    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel mainLabel;
    private javax.swing.JProgressBar mainProgress;
    private javax.swing.JLabel subLabel;
    private javax.swing.JProgressBar subProgress;
    // End of variables declaration//GEN-END:variables

}

