To download and unpack the latest version of libmceliece:

        wget -m https://lib.mceliece.org/libmceliece-latest-version.txt
        version=$(cat lib.mceliece.org/libmceliece-latest-version.txt)
        wget -m https://lib.mceliece.org/libmceliece-$version.tar.gz
        tar -xzf lib.mceliece.org/libmceliece-$version.tar.gz
        cd libmceliece-$version

Then [install](install.html).

### Archives and changelog (reverse chronological) {#changelog}

[`libmceliece-20230612.tar.gz`](libmceliece-20230612.tar.gz) [browse](libmceliece-20230612.html)

In `*/avx/pk_gen.c`,
use merge exchange in `sort_rows()`
and slightly reduce the number of lines of `minmax_rows()`.

Rename `encrypt()` as `pke_encrypt()`,
to more portably avoid name collision with POSIX `encrypt()`.

Add more 0-initialization in the `to_bitslicing` functions.
This doesn't help a full correctness proof,
but it does make it easier to see that undefined data is not used.
Thanks to Thom Wiggers for the suggestion.

For MacOS portability,
move `#include "encrypt.h"` after other inclusions,
and change `.hidden` to `.private_extern` (via a new `ASM_HIDDEN`)
if `__APPLE__` is defined.
Thanks to Thom Wiggers for the suggestions.

Specify 32-byte alignment for some arrays passed to `.S` files
in the `avx` implementations.
The `.S` files use `movdqu` instead of `movdqa`,
so they don't need alignment,
but the alignment could avoid warnings
from a compiler that checks for potentially inadequate alignment.
Thanks to Thom Wiggers for the suggestion.

Remove an unused pointer increment at the end of `benes.c`.
Thanks to Thom Wiggers for the suggestion.

Add various `linker` lines in `.c` files and `.S` files;
split `operations.c` into `kem_{keypair,enc,dec}.c` and `wrap_{keypair,enc,dec}.c`;
and split big constant arrays from `fft.c`, `fft_tr.c`
into separate `shared-*.c` files.
The `linker` lines trigger an infrastructure mechanism
to unify compiled code across implementations,
reducing `.so` size;
the splits improve the effectiveness of this mechanism,
and reduce the amount of code linked
into programs that use only one or two of `{keypair,enc,dec}`.
Further changes to the infrastructure may remove the need for `wrap*.c`.

Add `const` to prototypes for input pointers for some functions.
More can be done here.

Change prototypes from `*` and `[]` to, e.g., `[GFBITS]`
when necessary to eliminate compiler warnings.

Move `gf_mul2` to `crypto_kem/6688128/avx/gf.h` from `gf.c`.

Consistently define `nBlocksI` as a macro rather than a const.
This is a step towards portability to compilers that fail to support C99.

Extend information in `architectures` files.
This supports libmceliece's run-time selection of implementations.

Switch from `CRYPTO_NAMESPACE` to `CRYPTO_SHARED_NAMESPACE`
for symbols defined in `.S` files.

Rename `crypto_hash.h` as `hash.h`,
and rewrite `hash.h` as a wrapper around `crypto_xof_shake256()`.

Switch `keypair` return value to `void`.

Remove `namespacing` files, `goal-*` files, and `api.h`.

Rename `kem/mceliece*` as `kem/*`.

Starting point:
`vec` and `avx` implementations
from official round-4 software release
(in `supercop-20221025`),
plus `crypto_sort/int32`
and `crypto_xof/shake256`,
plus infrastructure based on lib25519 infrastructure.
