/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import sun.misc.CVM;
import sun.misc.ClassFileTransformer;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.security.util.SecurityConstants;

public abstract class ClassLoader {
    private boolean initialized = false;
    private ClassLoader parent;
    private Hashtable package2certs = new Hashtable(11);
    Certificate[] nocerts;
    private int loaderGlobalRoot;
    private Vector classes = new Vector();
    private Set domains = new HashSet();
    private HashMap packages = new HashMap();
    private static ClassLoader scl;
    private static boolean sclSet;
    private ProtectionDomain defaultDomain = null;
    private static Vector loadedLibraryNames;
    private static Vector systemNativeLibraries;
    private static Vector xrunNativeLibraries;
    private Vector nativeLibraries = new Vector();
    private static Stack nativeLibraryContext;
    private static String[] usr_paths;
    private static String[] sys_paths;
    private boolean defaultAssertionStatus = false;
    private Map packageAssertionStatus = null;
    Map classAssertionStatus = null;

    void addClass(Class clazz) {
        if (CVM.checkDebugFlags(262144) != 0) {
            System.err.println("CL: addClass() called for <" + clazz + "," + this + ">");
        }
        this.classes.addElement(clazz);
    }

    private void removeClass(Class clazz) {
        if (CVM.checkDebugFlags(262144) != 0) {
            System.err.println("CL: removeClass() called for <" + clazz + "," + this + ">");
        }
        this.classes.removeElement(clazz);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.InitializeLoaderGlobalRoot();
        this.parent = classLoader;
        this.initialized = true;
    }

    protected ClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.InitializeLoaderGlobalRoot();
        this.parent = ClassLoader.getSystemClassLoader();
        this.initialized = true;
    }

    private native void InitializeLoaderGlobalRoot();

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                if (this.parent != null) {
                    clazz = this.parent.loadClass(string, false);
                } else {
                    this.check();
                    clazz = ClassLoader.loadBootstrapClassOrNull(string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            if (clazz == null) {
                clazz = this.findClass(string);
            } else {
                clazz.addToLoaderCache(this);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class loadClassInternal(String string) throws ClassNotFoundException {
        return this.loadClass(string);
    }

    private void checkPackageAccess(Class clazz, ProtectionDomain protectionDomain) {
        String string;
        int n;
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = (string = clazz.getName()).lastIndexOf(46)) != -1) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    securityManager.checkPackageAccess(string.substring(0, n));
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
        }
        this.domains.add(protectionDomain);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        Object[] objectArray;
        Class clazz;
        block10: {
            this.check();
            if (string != null && string.startsWith("java.")) {
                throw new SecurityException("Prohibited package name: " + string.substring(0, string.lastIndexOf(46)));
            }
            if (protectionDomain == null) {
                protectionDomain = this.getDefaultDomain();
            }
            if (string != null) {
                this.checkCerts(string, protectionDomain.getCodeSource());
            }
            if (!ClassLoader.checkName(string)) {
                throw new NoClassDefFoundError("Illegal name: " + string);
            }
            clazz = null;
            try {
                clazz = this.defineClass0(string, byArray, n, n2, protectionDomain);
            }
            catch (ClassFormatError classFormatError) {
                Object[] objectArray2 = ClassFileTransformer.getTransformers();
                for (int i = 0; objectArray2 != null && i < objectArray2.length; ++i) {
                    try {
                        byte[] byArray2 = ((ClassFileTransformer)objectArray2[i]).transform(byArray, n, n2);
                        clazz = this.defineClass0(string, byArray2, 0, byArray2.length, protectionDomain);
                        break;
                    }
                    catch (ClassFormatError classFormatError2) {
                        continue;
                    }
                }
                if (clazz != null) break block10;
                throw classFormatError;
            }
        }
        clazz.loadSuperClasses();
        if (protectionDomain.getCodeSource() != null && (objectArray = protectionDomain.getCodeSource().getCertificates()) != null) {
            this.setSigners(clazz, objectArray);
        }
        return clazz;
    }

    private static boolean checkName(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (string.indexOf(47) != -1) {
            return false;
        }
        return string.charAt(0) != '[';
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    private synchronized void checkCerts(String string, CodeSource codeSource) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        Certificate[] certificateArray = (Certificate[])this.package2certs.get(string2);
        if (certificateArray == null) {
            if (codeSource != null) {
                certificateArray = codeSource.getCertificates();
            }
            if (certificateArray == null) {
                if (this.nocerts == null) {
                    this.nocerts = new Certificate[0];
                }
                certificateArray = this.nocerts;
            }
            this.package2certs.put(string2, certificateArray);
        } else {
            Certificate[] certificateArray2 = null;
            if (codeSource != null) {
                certificateArray2 = codeSource.getCertificates();
            }
            if (!this.compareCerts(certificateArray, certificateArray2)) {
                throw new SecurityException("class \"" + string + "\"'s signer information does not match signer information of other classes in the same package");
            }
        }
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n;
        boolean bl;
        int n2;
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return certificateArray.length == 0;
        }
        if (certificateArray2.length != certificateArray.length) {
            return false;
        }
        for (n2 = 0; n2 < certificateArray2.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray.length; ++n) {
                if (!certificateArray2[n2].equals(certificateArray[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray2.length; ++n) {
                if (!certificateArray[n2].equals(certificateArray2[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    protected final void resolveClass(Class clazz) {
        this.check();
        this.resolveClass0(clazz);
    }

    private native void resolveClass0(Class var1);

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        this.check();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.loadBootstrapClass(string);
        }
        return classLoader.loadClass(string);
    }

    private Class findBootstrapClass(String string) throws ClassNotFoundException {
        return ClassLoader.loadBootstrapClass(string);
    }

    static Class loadBootstrapClass(String string) throws ClassNotFoundException {
        Class clazz = ClassLoader.loadBootstrapClassOrNull(string);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class loadBootstrapClassOrNull(String string) throws ClassNotFoundException {
        if (!ClassLoader.checkName(string)) {
            throw new ClassNotFoundException(string);
        }
        Class clazz = ClassLoader.class;
        synchronized (clazz) {
            Class clazz2 = ClassLoader.loadBootstrapClass0(string);
            if (clazz2 != null && !clazz2.superClassesLoaded()) {
                clazz2.loadSuperClasses();
            }
            return clazz2;
        }
    }

    private static native Class loadBootstrapClass0(String var0) throws ClassNotFoundException;

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    protected final Class findLoadedClass(String string) {
        this.check();
        if (!ClassLoader.checkName(string)) {
            return null;
        }
        return this.findLoadedClass0(string);
    }

    private final native Class findLoadedClass0(String var1);

    protected final void setSigners(Class clazz, Object[] objectArray) {
        this.check();
        clazz.setSigners(objectArray);
    }

    public URL getResource(String string) {
        URL uRL = this.parent != null ? this.parent.getResource(string) : ClassLoader.getBootstrapResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{this.parent != null ? this.parent.getResources(string) : ClassLoader.getBootstrapResources(string), this.findResources(string)};
        return new CompoundEnumeration(enumerationArray);
    }

    protected URL findResource(String string) {
        return null;
    }

    protected Enumeration findResources(String string) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    public static URL getSystemResource(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResource(string);
        }
        return classLoader.getResource(string);
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResources(string);
        }
        return classLoader.getResources(string);
    }

    private static URL getBootstrapResource(String string) {
        URLClassPath uRLClassPath = ClassLoader.getBootstrapClassPath();
        Resource resource = uRLClassPath.getResource(string);
        return resource != null ? resource.getURL() : null;
    }

    private static Enumeration getBootstrapResources(String string) throws IOException {
        final Enumeration enumeration = ClassLoader.getBootstrapClassPath().getResources(string);
        return new Enumeration(){

            public Object nextElement() {
                return ((Resource)enumeration.nextElement()).getURL();
            }

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        return Launcher.getBootstrapClassPath();
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && !this.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        ClassLoader.initSystemClassLoader();
        if (scl == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != scl && !scl.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return scl;
    }

    private static synchronized void initSystemClassLoader() {
        if (!sclSet) {
            if (scl != null) {
                throw new IllegalStateException("recursive invocation");
            }
            Launcher launcher = Launcher.getLauncher();
            if (launcher != null) {
                Throwable throwable;
                block7: {
                    throwable = null;
                    scl = launcher.getClassLoader();
                    try {
                        SystemClassLoaderAction systemClassLoaderAction = new SystemClassLoaderAction(scl);
                        scl = (ClassLoader)AccessController.doPrivileged(systemClassLoaderAction);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throwable = privilegedActionException.getCause();
                        if (!(throwable instanceof InvocationTargetException)) break block7;
                        throwable = throwable.getCause();
                    }
                }
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new Error(throwable);
                }
            }
            sclSet = true;
        }
    }

    boolean isAncestor(ClassLoader classLoader) {
        ClassLoader classLoader2 = this;
        do {
            if (classLoader != (classLoader2 = classLoader2.parent)) continue;
            return true;
        } while (classLoader2 != null);
        return false;
    }

    static native ClassLoader getCallerClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = this.getPackage(string);
            if (package_ != null) {
                throw new IllegalArgumentException(string);
            }
            package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String string) {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = (Package)this.packages.get(string);
            if (package_ == null && (package_ = this.parent != null ? this.parent.getPackage(string) : Package.getSystemPackage(string)) != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Package[] packageArray = this.packages;
        synchronized (this.packages) {
            Map map = (Map)this.packages.clone();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            packageArray = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
            if (packageArray != null) {
                for (int i = 0; i < packageArray.length; ++i) {
                    String string = packageArray[i].getName();
                    if (map.get(string) != null) continue;
                    map.put(string, packageArray[i]);
                }
            }
            return (Package[])map.values().toArray(new Package[map.size()]);
        }
    }

    protected String findLibrary(String string) {
        return null;
    }

    private synchronized ProtectionDomain getDefaultDomain() {
        if (this.defaultDomain == null) {
            CodeSource codeSource = new CodeSource(null, null);
            this.defaultDomain = new ProtectionDomain(codeSource, null, this, null);
        }
        return this.defaultDomain;
    }

    static void loadLibrary(Class clazz, String string, boolean bl) {
        ClassLoader.loadLibraryInternal(clazz, string, bl, false);
    }

    private static Object loadLibraryInternal(Class clazz, String string, boolean bl, boolean bl2) {
        Object object;
        File file;
        int n;
        Object object2;
        String string2;
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        usr_paths = CVM.getUserLibrarySearchPaths();
        sys_paths = CVM.getSystemLibrarySearchPaths();
        if (bl) {
            Object object3 = ClassLoader.loadLibrary0(clazz, new File(string), bl2);
            if (object3 != null) {
                return object3;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findLibrary failed to return an absolute path: " + string2);
            }
            Object object4 = ClassLoader.loadLibrary0(clazz, file2, false);
            if (object4 != null) {
                return object4;
            }
            throw new UnsatisfiedLinkError("Can't load " + string2);
        }
        boolean bl3 = false;
        String string3 = System.getProperty("java.library.builtin." + string);
        if (string3 != null) {
            bl3 = true;
        } else {
            object2 = CVM.getBuiltinLibrarySearchPaths();
            for (n = 0; n < ((String[])object2).length; ++n) {
                if (!string.equals(object2[n])) continue;
                bl3 = true;
                break;
            }
        }
        if (bl3) {
            return ClassLoader.loadLibrary0(clazz, string, true, bl2);
        }
        object2 = System.mapLibraryName(string);
        for (n = 0; n < sys_paths.length; ++n) {
            file = new File(sys_paths[n], (String)object2);
            object = ClassLoader.loadLibrary0(clazz, file, bl2);
            if (object == null) continue;
            return object;
        }
        if (classLoader == null) {
            throw new UnsatisfiedLinkError("no " + string + " in sun.boot.library.path");
        }
        for (n = 0; n < usr_paths.length; ++n) {
            file = new File(usr_paths[n], (String)object2);
            object = ClassLoader.loadLibrary0(clazz, file, false);
            if (object == null) continue;
            return object;
        }
        throw new UnsatisfiedLinkError("no " + string + " in java.library.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadLibrary0(Class clazz, String string, boolean bl, boolean bl2) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        Vector vector = bl2 ? xrunNativeLibraries : (classLoader == null ? systemNativeLibraries : classLoader.nativeLibraries);
        Vector vector2 = vector;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(i);
                if (!string.equals(nativeLibrary.name)) continue;
                return nativeLibrary;
            }
            Vector vector3 = loadedLibraryNames;
            synchronized (vector3) {
                if (!bl2 && loadedLibraryNames.contains(string)) {
                    throw new UnsatisfiedLinkError("Native Library " + string + " already loaded in another classloader");
                }
                int n2 = nativeLibraryContext.size();
                for (int i = 0; i < n2; ++i) {
                    NativeLibrary nativeLibrary = (NativeLibrary)nativeLibraryContext.elementAt(i);
                    if (!string.equals(nativeLibrary.name) || nativeLibrary.isXrunLibrary != bl2) continue;
                    if (classLoader == nativeLibrary.fromClass.getClassLoader()) {
                        return nativeLibrary;
                    }
                    throw new UnsatisfiedLinkError("Native Library " + string + " is being loaded in another classloader");
                }
                NativeLibrary nativeLibrary = new NativeLibrary(clazz, string, bl2, bl);
                if (!bl) {
                    nativeLibraryContext.push(nativeLibrary);
                    try {
                        nativeLibrary.load(string);
                    }
                    finally {
                        nativeLibraryContext.pop();
                    }
                }
                if (nativeLibrary.handle != 0L || bl) {
                    if (!bl2) {
                        loadedLibraryNames.addElement(string);
                    }
                    vector.addElement(nativeLibrary);
                    return nativeLibrary;
                }
                return null;
            }
        }
    }

    private static Object loadLibrary0(Class clazz, final File file, boolean bl) {
        String string;
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
        if (!bl2.booleanValue()) {
            return null;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
        return ClassLoader.loadLibrary0(clazz, string, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long findNative(ClassLoader classLoader, String string) {
        Vector vector;
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                long l;
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(i);
                if (nativeLibrary.isBuiltin || (l = nativeLibrary.find(string)) == 0L) continue;
                return l;
            }
        }
        return 0L;
    }

    public synchronized void setDefaultAssertionStatus(boolean bl) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.defaultAssertionStatus = bl;
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl) {
        if (this.packageAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.packageAssertionStatus.put(string, bl);
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.classAssertionStatus.put(string, bl);
    }

    public synchronized void clearAssertionStatus() {
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        this.defaultAssertionStatus = false;
    }

    synchronized boolean desiredAssertionStatus(String string) {
        Boolean bl = (Boolean)this.classAssertionStatus.get(string);
        if (bl != null) {
            return bl;
        }
        int n = string.lastIndexOf(".");
        if (n < 0 && (bl = (Boolean)this.packageAssertionStatus.get(null)) != null) {
            return bl;
        }
        while (n > 0) {
            bl = (Boolean)this.packageAssertionStatus.get(string = string.substring(0, n));
            if (bl != null) {
                return bl;
            }
            n = string.lastIndexOf(".", n - 1);
        }
        return this.defaultAssertionStatus;
    }

    private void initializeJavaAssertionMaps() {
        int n;
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        AssertionStatusDirectives assertionStatusDirectives = ClassLoader.retrieveDirectives();
        for (n = 0; n < assertionStatusDirectives.classes.length; ++n) {
            this.classAssertionStatus.put(assertionStatusDirectives.classes[n], assertionStatusDirectives.classEnabled[n]);
        }
        for (n = 0; n < assertionStatusDirectives.packages.length; ++n) {
            this.packageAssertionStatus.put(assertionStatusDirectives.packages[n], assertionStatusDirectives.packageEnabled[n]);
        }
        this.defaultAssertionStatus = assertionStatusDirectives.deflt;
    }

    private static native AssertionStatusDirectives retrieveDirectives();

    static {
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        xrunNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private Class fromClass;
        String name;
        boolean isXrunLibrary;
        boolean isBuiltin;

        native void load(String var1);

        native long find(String var1);

        native void unload();

        public NativeLibrary(Class clazz, String string, boolean bl, boolean bl2) {
            this.name = string;
            this.fromClass = clazz;
            this.isXrunLibrary = bl;
            this.isBuiltin = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Vector vector = loadedLibraryNames;
            synchronized (vector) {
                if ((this.isXrunLibrary || this.fromClass.getClassLoader() != null) && this.handle != 0L) {
                    if (!this.isXrunLibrary) {
                        int n = loadedLibraryNames.size();
                        for (int i = 0; i < n; ++i) {
                            if (!this.name.equals(loadedLibraryNames.elementAt(i))) continue;
                            loadedLibraryNames.removeElementAt(i);
                            break;
                        }
                    }
                    nativeLibraryContext.push(this);
                    try {
                        this.unload();
                    }
                    finally {
                        nativeLibraryContext.pop();
                    }
                }
            }
        }

        static Class getFromClass() {
            return ((NativeLibrary)nativeLibraryContext.peek()).fromClass;
        }

        private static native boolean initIDs();

        static {
            if (!NativeLibrary.initIDs()) {
                throw new RuntimeException("NativeLibrary initIDs() failed");
            }
        }
    }
}

