#ifndef LIBINT2_STATICS_INITIALIZATION
static constexpr const std::size_t interpolation_order=15;
static constexpr const long cheb_table_tminlog2=1;
static constexpr const long cheb_table_tmaxlog2=10;
static constexpr const long cheb_table_uminlog10=-7;
static constexpr const long cheb_table_umaxlog10=3;
static constexpr const std::size_t cheb_table_mmax=20;
static constexpr const std::size_t cheb_table_nintervals=100;
#if LIBINT2_CONSTEXPR_STATICS
static constexpr double cheb_table[cheb_table_nintervals][(cheb_table_mmax+2)*(interpolation_order+1)*(interpolation_order+1)]=
#else  // LIBINT2_CONSTEXPR_STATICS
static double cheb_table[cheb_table_nintervals][(cheb_table_mmax+2)*(interpolation_order+1)*(interpolation_order+1)];
#endif  // LIBINT2_CONSTEXPR_STATICS
#else  // LIBINT2_STATICS_INITIALIZATION
template<> double libint2::TennoGmEval<double>::cheb_table[cheb_table_nintervals][(cheb_table_mmax+2)*(interpolation_order+1)*(interpolation_order+1)]=
#endif  // LIBINT2_STATICS_INITIALIZATION
#if defined(LIBINT2_STATICS_INITIALIZATION) || LIBINT2_CONSTEXPR_STATICS
{
{
// [{0,1.e-7},{2.,1.e-6}]: m=-1 maxabserror=3.67067210761511268e-19 maxrelerror=3.88968902521945967e-22
1574.099060592179150853882360604893486923,
-1814.388239571180937364905852264706336956,
1044.447806290430668012881344242156176914,
-400.8209005623276964761884145589544952414,
115.3657460636863080389402009691562755156,
-26.56389507104133928936090549112806333364,
5.097145113657456019223921619759660551069,
-0.8383278159657402270051705490085383307877,
0.1206452722876013446802819673140618510173,
-0.015433089095061562579036323260711224757,
0.001776801889735478569785767393695806412559,
-0.0001859653156285211387416592377620610971548,
0.00001784138614429287766291624168730221019922,
-1.580064044682850325935783365166438295944e-6,
1.306565295199279684465386299259425407589e-7,
-1.002196839192992537936436571622940246656e-8,
-1.491656466146609782972749921701033730074,
0.002291247061873228916000283568889911784953,
0.001316765414613674720618617549090421691189,
0.0005036539348756805554978471926429796566644,
0.0001440013104065501631331941128438080906071,
0.00003271548776340335707482989711408637086087,
6.108425070560800564853554945368736428538e-6,
9.493037306422692021186932111472888861847e-7,
1.20800663117533409183805510273340277277e-7,
1.145127064724888573267731676575985551049e-8,
4.12241093152346073898543862875803732695e-10,
-1.417531836674650246223357522764700635409e-10,
-4.77018555773530219573351970914726701285e-11,
-9.907487347872221992583533974639136956652e-12,
-1.690897054470308696717258541426675752719e-12,
-2.40510513406516301358273172934304551421e-13,
0.3789443395607031154820885645051425443989,
-8.102116989100790586372384059134605001621e-7,
-9.319568091612048205775372377600415601108e-7,
-7.143438872237132372195754665041023476382e-7,
-4.103817250822675956364615125430151647595e-7,
-1.884167140256867743102118545074320155159e-7,
-7.197938275141511089564435110945584236759e-8,
-2.351535435665026669445842282669429231234e-8,
-6.698693542930163861773978941985834014664e-9,
-1.687214900615387429416434571954921291647e-9,
-3.793556551437544032245093485556901350222e-10,
-7.655832737066798386817198937106571891502e-11,
-1.387596208335474449943412774986790636741e-11,
-2.244571967857931587791118597577829649814e-12,
-3.201911757998241375391765817817220668022e-13,
-3.694949129018902830786558182266725109789e-14,
-0.1336916932485361953361124033080345710685,
8.660357746242459799017024376766757895626e-8,
9.970588811274567199858264761849721872944e-8,
7.652684388412984033186102378185357172928e-8,
4.405210101869779747967993867594630760869e-8,
2.028647399670970658818085127875438076033e-8,
7.785016444954999493855352873283192551037e-9,
2.560673850648647240249987579320768743657e-9,
7.369435122080178983538935230568525623364e-10,
1.885020293200397778306414293135049142523e-10,
4.338607386138117760124755843291493175375e-11,
9.074220538816268110253232839224384831628e-12,
1.737835392696631207225623877439467810826e-12,
3.06806195013367536706846848036613281449e-13,
5.120793127061395748951088423148103319909e-14,
7.731161552539229559787020416106401584689e-15,
0.04448817611442931567278308274297991472039,
-1.627954416478540479749434572909620284876e-8,
-1.874250801927990332033540189697798906743e-8,
-1.43853914216243487633092613501896443742e-8,
-8.280879574422710645067821277199660488782e-9,
-3.813469959333886689406523064960140234653e-9,
-1.463460889405265401214203555673107132889e-9,
-4.81383803806615775339180696795389669409e-10,
-1.385487396295842066588448065824787260391e-10,
-3.544431444902184837135845316797664622008e-11,
-8.160276385264160221885156239009206130349e-12,
-1.707696807621132417645220379355769743003e-12,
-3.274144392218434606502409436622278598994e-13,
-5.793364641872944968047732967315900340597e-14,
-9.71909643024991491818812024029437289075e-15,
-1.481314917124813612884767125589048607921e-15,
-0.0132328628594148643070429940204281502931,
3.32207757365284822494479651266546450728e-9,
3.824681988140636378699144858057276945006e-9,
2.935550127798543895218593267608855242063e-9,
1.689836438653970678623128926979165190676e-9,
7.78196548369386132247647238111194802364e-10,
2.986425111356910509945103293967547846472e-10,
9.823473041133388118441154060472468287823e-11,
2.827367835414865282006924761050160086415e-11,
7.233335613596206957901484615681835638584e-12,
1.665411338176024093789159039587356355387e-12,
3.485592738681053279628491415738119495533e-13,
6.684383836590657354150640884063234731137e-14,
1.18329007952362855788043026322990057206e-14,
1.987178770320908900862257144459785525101e-15,
3.034553073812744174682087337620465847384e-16,
0.003499098779536835037693949809557466634179,
-6.63959690745244200382456599374367921014e-10,
-7.644116817007168182204340427546389459183e-10,
-5.867073999292862587017433966652394517602e-10,
-3.377356429636671511241308483571541860332e-10,
-1.555327486080098480729696713649005755467e-10,
-5.968769639626180249574505689322724365548e-11,
-1.96335815978893886168218840484287679722e-11,
-5.650922574040810398429238774354269337217e-12,
-1.445708716471833029558009726713659728806e-12,
-3.328694847492801826478682107705046175405e-13,
-6.967061977089526385370898799128950812276e-14,
-1.336211513839921378007002073771884553426e-14,
-2.365850091807366369149226798182420611684e-15,
-3.97485182785277203323931408209008532569e-16,
-6.074729460012693915157401739176797532122e-17,
-0.0008270992276543555204221591911250454934674,
1.257087098131136855564132307112392326371e-10,
1.44727477339235406308856417357492437487e-10,
1.110824081916867851117021185759601744018e-10,
6.394413312382049760663202092937038516322e-11,
2.94473236193664945211143485756058599974e-11,
1.130079895930273487524820580928132206189e-11,
3.717273882321164647909332019229125833963e-12,
1.069906388680630644901162545363416579172e-12,
2.737221951095685665193338156626263855238e-13,
6.302440901257403568664591104823597379816e-14,
1.319154422178512867301157376997845939024e-14,
2.530132830208790555215315230405500050662e-15,
4.480226136681452586927149884524947825758e-16,
7.528971565976958591234715251341151106617e-17,
1.151145959688038684228711242650677257694e-17,
0.0001761650817535160068763819753969135862435,
-2.228820598050298982551145796636765536059e-11,
-2.566024209291207254139517869137741980588e-11,
-1.969495853443074754656117625149779323419e-11,
-1.133732360191084420436666107464523886316e-11,
-5.22102504816956073763342534800185013591e-12,
-2.003638251029574792974635094970735330062e-12,
-6.590754893421866292075867062927893493973e-13,
-1.896955974435684304809357820966596116035e-13,
-4.853144539431167311953029812526141506145e-14,
-1.117443250859296296136351171290790559303e-14,
-2.338941165895980386856897037261996644383e-15,
-4.48622237744244958634048501531984825333e-16,
-7.944475451240403457479975941409006733716e-17,
-1.33525603453857867304419097358479783833e-17,
-2.042099544334402263622256189496304348152e-18,
-0.0000340815421213780080960698409761405843656,
3.688948878887688679654221487770234787653e-12,
4.247058888491804279360975397375695384329e-12,
3.259737455500451729790176228190739429749e-12,
1.876454904750551560888141111362982556237e-12,
8.641386692165309693254907262234507252846e-13,
3.316248947802260371050704369314247448023e-13,
1.090845559341546320515678953717611388475e-13,
3.139684083134314196480033411183290881842e-14,
8.032543947995551675526591566836208930212e-15,
1.849514462129210226324219160660748756339e-15,
3.871295229261883516215290475153257168356e-16,
7.4255254936358134736515579340442616128e-17,
1.315014529741456819534490300142276454465e-17,
2.210411558967226350550584670314508873514e-18,
3.381158247836897903154726429510912940199e-19,
6.033239066864414127434888359670968814777e-6,
-5.701878616540538928411021361030455302522e-13,
-6.564529742063711013006548472925025793594e-13,
-5.038461838854163466147177528857032321595e-13,
-2.900370702051225103591953201180792866716e-13,
-1.335669075308106955781712818209155852257e-13,
-5.125811880438899785518720277767607380021e-14,
-1.686083273997670870336007331876249130168e-14,
-4.852908819648689949455001719224933871816e-15,
-1.24156695959913124833799287349749077565e-15,
-2.858751995185125976628197054052052231019e-16,
-5.983819248484120319165382438930051084028e-17,
-1.147773413200619033153311499912056703062e-17,
-2.032699565351833134529465644504562685885e-18,
-3.41701625853764349716230262421337917182e-19,
-5.227537744775814777181057177817650435122e-20,
-9.837007667438730885143158194611717538789e-7,
8.24631499753804794848863715261781820354e-14,
9.493920220634472273719516067753012528672e-14,
7.286851872822152294385111181904856304404e-14,
4.194647759774249920009768011406736185811e-14,
1.931705423627963618676660509242533489175e-14,
7.41318387542030270457741516636980857181e-15,
2.438491751464945567567905764972839001216e-15,
7.018506805567726168830219815833826065624e-16,
1.795615670609836184239836074368303066249e-16,
4.134481129677988841496455618091601818687e-17,
8.654173258755599621906581107085629746494e-18,
1.660001224545419778099761129639652005395e-18,
2.93992171830606787665019911206836661428e-19,
4.942346781543374146769537037214114900065e-20,
7.561830774986757911807283668934455544843e-21,
1.485689595037498324545731775386307433669e-7,
-1.118694440175226185761990188602914667083e-14,
-1.287944477728250731940962140348709137228e-14,
-9.885337754984991925018189673431847619929e-15,
-5.690456193929477493115244815656502815872e-15,
-2.620550406230901805173572557269674068418e-15,
-1.005672221016971031323759734878483879508e-15,
-3.308057872416436389843826444101357624507e-16,
-9.521311754841791550212180217716682553275e-17,
-2.435936436026627600680309290779093946814e-17,
-5.60885984769400361526131221460765653208e-18,
-1.174035362183067228857122034437361897721e-18,
-2.251998019256223101402044112308366818215e-19,
-3.988443287698955549802351680017043700501e-20,
-6.705316573728452368874484355242285229756e-21,
-1.025999283473637088790319542857635523057e-21,
-2.089652765936793090960548332218134707789e-8,
1.427757177957231263467144357603942458664e-15,
1.643766090392348488463616789606632143309e-15,
1.261636934762052333581640400325275275846e-15,
7.26256410945051609763215630383222568679e-16,
3.34453263268082084575341520406334532706e-16,
1.283510496366387619662088807595573410769e-16,
4.22197998710362367252915216190110317077e-17,
1.21517845077107238395363730198354373342e-17,
3.10892059668548547825557519804185408726e-18,
7.158451323897461062088642586658428635115e-19,
1.498398345327407943190979791624155947734e-19,
2.874202223231361946130263055173077397244e-20,
5.090485444220305241339458489312613723991e-21,
8.558345858647658309777986377142607739124e-22,
1.309618760728761455506786469277366155837e-22,
2.78922286460273943678410762089769998105e-9,
-1.740269865403731826247757110703008877769e-16,
-2.003559606929252311527634458753352679514e-16,
-1.537788646804789042689416491878666605098e-16,
-8.852220950291973133166906553632757267287e-17,
-4.07659647921561538501936869737048091734e-17,
-1.5644502397502811333137260042304496731e-17,
-5.146104301933762430504239798680740173967e-18,
-1.481162275351147710540305904375365799481e-18,
-3.789418321490919658410799614659788408354e-19,
-8.725346290820989806101417019356193267119e-20,
-1.826384579444421341984371070973394947766e-20,
-3.503361451359546179009220070317514977943e-21,
-6.204863313733004581792420613217057187152e-22,
-1.043218250067824726843618790572655753887e-22,
-1.59644145946949539763683887912718599518e-23,
-3.440852516604281997076952092641259579597e-10,
1.979303523170012809100670781397192198422e-17,
2.278757270532424505625608391878865822579e-17,
1.749010651826979569924852488161455859907e-17,
1.00681124630881953837971956726229069656e-17,
4.636535133135316614362175610128158455269e-18,
1.779334577574248135049370471093617029316e-18,
5.85294599972423221512206736252882605832e-19,
1.684607432761254820030608477273016510931e-19,
4.309916891128707584861054883476026706446e-20,
9.92383573649762704744805304119845919898e-21,
2.077256973791263230845070642885851315465e-21,
3.98460358136828468514742336408833317383e-22,
7.057270778213753661068374298501367142965e-23,
1.186560168702232525731772397169196107239e-23,
1.815875673503063815866707165723282108853e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=0 maxabserror=1.8465488393784097871e-20 maxrelerror=2.7726501916065699917e-20
0.7458282330733048914699567235613975758428,
-0.001145623530936614458000140967881745014641,
-0.0006583827073068373603093078344421158268508,
-0.0002518269674378402777489228747657656404001,
-0.0000720006552032750815665966410611171915664,
-0.00001635774388170167853741475727640263862755,
-3.054212535280400282426704066080009763626e-6,
-4.746518653211346010593224591874778556491e-7,
-6.040033155876670459189580526871198289407e-8,
-5.72563532362444286633688031978045677948e-9,
-2.061205465761730369488625211933661144108e-10,
7.08765918337325123112535742187137540263e-11,
2.385092778867651097868403731959163921629e-11,
4.953743673936110996294678562361156602788e-12,
8.454485272351543483591188203746433492431e-13,
1.202552567032581506792115106906598130188e-13,
-0.3789443395607031059395149897052421148628,
8.102116989100790581281200421350261149983e-7,
9.319568091612048199913930894284139933439e-7,
7.143438872237132367696932518522526180376e-7,
4.103817250822675953774885438323437382649e-7,
1.884167140256867741909504425423449533919e-7,
7.197938275141511084987612932320836007306e-8,
2.351535435665026667940341462987234064115e-8,
6.698693542930163857440813130339061294027e-9,
1.687214900615387428307832403428631407992e-9,
3.793556551437544029692469411970462926526e-10,
7.65583273706679838147403560262771930603e-11,
1.38759620833547444891848044655853033224e-11,
2.244571967857931585975809566060417878406e-12,
3.201911757998241372339572445866178906268e-13,
3.694949129018902826115405357843213005755e-14,
0.2005375398728043003607287322260354770407,
-1.299053661936368973511277946442970550591e-7,
-1.49558832169118508419100152446446495269e-7,
-1.147902658261947608210945475475688092727e-7,
-6.607815152804669640562804755653584123311e-8,
-3.042971099506455996797721081857343831264e-8,
-1.16775246674324992736738726440961796767e-8,
-3.841010775972970871194103319297952669263e-9,
-1.105415268312026850644824649083198561691e-9,
-2.827530439800596675426478831481175834246e-10,
-6.507911079207176658531325456523329138711e-11,
-1.361133080822440220377805833036862893909e-11,
-2.606753089044946818204055587124936508539e-12,
-4.60209292520051306364841702755242052192e-13,
-7.681189690592093645361581774029166386065e-14,
-1.159674232880884437325136467050149743216e-14,
-0.08897635222886023497755820644220508837586,
3.255908832957089514921469354340318478509e-8,
3.748501603855990513860861943981942836605e-8,
2.877078284324877312657209969495773126749e-8,
1.656175914884546480895851380615388359845e-8,
7.626939918667793419963628742132375643997e-9,
2.926921778810538493498046726089150046193e-9,
9.627676076132340805803753714777530911008e-10,
2.770974792591691414796920309058295133556e-10,
7.088862889804388303652844936483593246164e-11,
1.632055277052836333905608936080501926757e-11,
3.415393615242273814149520013631260206162e-12,
6.548288784436886436365556705415482375748e-13,
1.158672928374592044125326526735287089629e-13,
1.943819286049988112661916339776285405046e-14,
2.962629834249635075356290931697195497651e-15,
0.0330821571485366310286294276604150355477,
-8.305193934132094216628176253032494396444e-9,
-9.561704970351560615102289405250138139355e-9,
-7.33887531949633645765031908844603471544e-9,
-4.224591096634913295287005820112177111141e-9,
-1.945491370923459159108115893413813692196e-9,
-7.466062778392252590831528095317359348386e-10,
-2.455868260283339238979335216573871327442e-10,
-7.068419588537140781845551242529415289519e-11,
-1.808333903399046002702452831627672303893e-11,
-4.163528345440047025191377032125010155777e-12,
-8.713981846702605549297272466630581883132e-13,
-1.671095959147659034703789537401911714801e-13,
-2.958225198809062000745963712604143961254e-14,
-4.967946925802256457242204618504616198832e-15,
-7.586382684531836263026154902767419680216e-16,
-0.01049729633853351235493416767312755770414,
1.99187907223162514021574303314546179043e-9,
2.293235045097421565741025137058976989067e-9,
1.760122199784229220088394290503519079488e-9,
1.013206928888912113393658505351750555096e-9,
4.665982458230673679841237066434089566126e-10,
1.790630891884161590053689494290149507862e-10,
5.890074479354670517961671660052836400195e-11,
1.69527677220874721159164067990378072763e-11,
4.337126149406555117245062012733025434618e-12,
9.986084542457811439978392266893963090679e-13,
2.090118593122547162694101204739301392032e-13,
4.00863454151149519339121396935368050896e-14,
7.097550275407453572043370326853967704601e-15,
1.192455548353369163855378443581351919154e-15,
1.822418838000039585522010402863813924049e-16,
0.002894847296804372116370981330628030423129,
-4.399804843466005146314540559978710433304e-10,
-5.065461706881328376680517325566443997096e-10,
-3.887884286715246134910377346191616037928e-10,
-2.238044659337291405260786085393463451837e-10,
-1.030656326679473190403035144606948586193e-10,
-3.955279635762273507897462418039694002749e-11,
-1.301045858814485312529231451141272395773e-11,
-3.744672360388187299715912641531154599722e-12,
-9.580276828850199245488224264374825333677e-13,
-2.205854315443614036377911568332856339718e-13,
-4.617040477632168962263623025316457019068e-14,
-8.855464905744911754102628622379029695716e-15,
-1.568079147841013682202825838915998253247e-15,
-2.635140048096147857265575329044768721322e-16,
-4.029010858914582280749891320968389262091e-17,
-0.0007046603286275615040205011334596097034957,
8.915282400808775807197499122773185451286e-11,
1.02640968470746710791669620616292892318e-10,
7.877983421378383130706166069692237836594e-11,
4.534929445142750783333851252812348075559e-11,
2.088410021284157240068390943481742754711e-11,
8.014553011856256647676540127699952072657e-12,
2.63630195991407182539450051680597937306e-12,
7.587823905068748912774915251462198660835e-13,
1.94125781764676225701644797070960139789e-13,
4.46977300775286444908998366915175665811e-14,
9.355764672617519365070554823911677910426e-15,
1.794488952709815966639946218047541615461e-15,
3.177790183565274358671848842731657255533e-16,
5.341024143314607682229491468358197520187e-17,
8.168398185235050379902626059796817644633e-18,
0.000153366939368579841860531005683369104752,
-1.660026994616108174724000246608356311779e-11,
-1.911176498804315708694892727719901027982e-11,
-1.466881854194629907507999212578015824258e-11,
-8.444047066884141334320643122706161568473e-12,
-3.88862400940513026833845923885164863831e-12,
-1.492312025716910229790882180639227878095e-12,
-4.908805014424821165051703734364873104508e-13,
-1.412857836658610077380214932583446106261e-13,
-3.614644774674503419780343624248494282904e-14,
-8.322815075152477827412561306435719238458e-15,
-1.742082852240772410120944965123330090116e-15,
-3.341486470357782283141619607048254469809e-16,
-5.917565380686836420146651051981526155727e-17,
-9.946852010056608301717474753904706806427e-18,
-1.521521210716079599331124233064591917692e-18,
-0.00003016617812087407944993591404454194100759,
2.850938389997619046825055999736415555099e-12,
3.282263813831450038144933554464699685317e-12,
2.519230107995864511673873404048017208013e-12,
1.450184883928349337305150789432682916984e-12,
6.678343225479000609121712552382566394079e-13,
2.562905114719736633954464355736472079357e-13,
8.430413654587915655146007786501386536608e-14,
2.426453628271774825459432972903532882487e-14,
6.207832798462491971132757877642683149566e-15,
1.42937553718786211174694988953283507602e-15,
2.991908660521021556645405654517381501482e-16,
5.738865217381236755073615569674438400867e-17,
1.016349455257227706217597561195275876594e-17,
1.708507578759151409389357618150725212987e-18,
2.613768029874146103523892059495602251836e-19,
5.410355353944985283386163941358671373568e-6,
-4.535473814025209644745669904717851812102e-13,
-5.221656772265884472849245551615547180785e-13,
-4.007769029649340175293992495316055545996e-13,
-2.307056555467025556679972479663097170317e-13,
-1.062438115435967589848956777901982546673e-13,
-4.077251639740328918266316601861237581e-14,
-1.341170630492611720005399559331426180425e-14,
-3.860179224263375534951872017368043063416e-15,
-9.87588741946520971620116823067629290283e-16,
-2.273964904793993055456874820848079069655e-16,
-4.759795885679557139222177274403767546642e-17,
-9.13000787320222946740553493586135638728e-18,
-1.616957146662556479796153681216674425971e-18,
-2.718291068807603439256106679767592813008e-19,
-4.159007445009730360354653492662092681851e-20,
-8.915114176996808132709785074184149099748e-7,
6.712687614871846134669487091856563624736e-14,
7.728266659616106579611656878180892884414e-14,
5.931663011274680036942035926166521631745e-14,
3.414538719835300238612189798714516602513e-14,
1.572452282301387054627643481963618572592e-14,
6.034501666021613978609346154490369376347e-15,
1.98498877927850208328850237656684670432e-15,
5.713230459804148285027797935117592791744e-16,
1.461675303351557555038755757834003832604e-16,
3.365577115128407897894947183757802534944e-17,
7.044758931658133212229276616129683976908e-18,
1.351303691470756736589421475935254907367e-18,
2.393251730700832469564896028325701957288e-19,
4.023502271004148835970562496037099415856e-20,
6.156473693537122310653791769108513642298e-21,
1.358238467661596376968120017229733290209e-7,
-9.280243467469935433698433059018031594925e-15,
-1.06842744396019655918702722550976632447e-14,
-8.20048261909867580749011781155937124599e-15,
-4.720576031707990273783939203438457562563e-15,
-2.173904470255649011183940475689509808241e-15,
-8.342658039542895614398740785556667936582e-16,
-2.744234299719965474017598344316024275348e-16,
-7.898508270990670158941951595224831618627e-17,
-2.020759587207739712607200137078809012663e-17,
-4.652904019617171710702345318435434010725e-18,
-9.739402235506155464907920225072208894503e-19,
-1.868195572643758752057871492134383499997e-19,
-3.30875200276967123805788542306828175939e-20,
-5.562817979293548758902680605737251668189e-21,
-8.51235844616289733781577699746524132579e-22,
-1.92440654319839646335488746897611237626e-8,
1.203226060581745199674214410372956999241e-15,
1.385265113553547943362280511290166870451e-15,
1.063230141287527565049894833657272920901e-15,
6.120443239691231810197998994317769730331e-16,
2.818566942645605601173987742215081718425e-16,
1.081664016451134053151663131167378451362e-16,
3.558026766615804930404369511877509641123e-17,
1.024078540557985807807964868468521721906e-17,
2.620011319747994758891808293707608475512e-18,
6.032721501328314161106841223000147251187e-19,
1.262765799075999389693237042110835999419e-19,
2.422230543313139319570860673587889460116e-20,
4.290052897406708015636755866025339421818e-21,
7.21282464232628798678549428446537072198e-22,
1.103780633537555622599677320679616501642e-22,
2.585049477471616102702756870049849882053e-9,
-1.48667083702319311171811005014322009242e-16,
-1.711592961431328913251104040050452845247e-16,
-1.313696004359771332054940455463654374604e-16,
-7.562240459196283383881417345835477409248e-17,
-3.482538927336028701552871560774633102308e-17,
-1.336472549946034468061267003346656216078e-17,
-4.39619494074358377795745568835187702969e-18,
-1.265322228982677346561163445914250174756e-18,
-3.237213340849041338133657827174780888792e-19,
-7.453873089565282499379619918693674765121e-20,
-1.560244481994592117082410657444740556069e-20,
-2.99286795119674475284391733938173118031e-21,
-5.300773238662734872299266527589005934661e-22,
-8.912350005167030088099686032473995092478e-23,
-1.363919133509384307853539384939134818142e-23,
-3.205981555177118078703337505255156170225e-10,
1.710192565856380363402158764847729514165e-17,
1.968931856169668421026559618850447738885e-17,
1.511210896647987266560834889220084812481e-17,
8.699227475956472141052093052105951555213e-18,
4.006140706554392930193028745113568452312e-18,
1.53741208799150649776214170723654633846e-18,
5.057166454958158290447516298206144339024e-19,
1.455564853253707056463705999755049997637e-19,
3.723934011315198500123042915293208626181e-20,
8.574585088770291548479537716924600805958e-21,
1.79483572615378801494039723385154251372e-21,
3.442876548082452729189963784180940162174e-22,
6.097851353393480175825616537185808792948e-23,
1.025270177135114087178572740638401528647e-23,
1.569099137511031847038901960395738674426e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=1 maxabserror=1.73542744254649241628e-20 maxrelerror=1.34238176717263551279e-19
0.1894721697803515529543262888833902764581,
-4.051058494550395290633413227596065650593e-7,
-4.659784045806024099948691127447639681239e-7,
-3.571719436118566183842115484747179078207e-7,
-2.05190862541133797688378692011013063072e-7,
-9.420835701284338709530686556118509341254e-8,
-3.598969137570755542487345581475548524486e-8,
-1.175767717832513333968045486313211091048e-8,
-3.349346771465081928714289634783371040373e-9,
-8.43607450307693714152351237803931775773e-10,
-1.896778275718772014842631274991649450453e-10,
-3.827916368533399190729475058655146260316e-11,
-6.937981041677372244577933550158275204781e-12,
-1.12228598392896579298534212697473038616e-12,
-1.600955878999120686165477332965372428975e-13,
-1.847474564509451413051107864703931368641e-14,
-0.2005375398728042914282720862295353914365,
1.299053661936368969068764365357821997923e-7,
1.495588321691185079076368987011064316633e-7,
1.147902658261947604285320292369851333491e-7,
6.60781515280466961796509386109609801372e-8,
3.042971099506455986391094477639339394971e-8,
1.167752466743249923373699666622548515119e-8,
3.841010775972970858057257689489693820657e-9,
1.105415268312026846863747767138785926931e-9,
2.82753043980059666575292341864548373382e-10,
6.507911079207176636257353915113099277457e-11,
1.361133080822440215715400258826381580312e-11,
2.606753089044946809260537777871600955728e-12,
4.602092925200513047807987871910753380455e-13,
7.681189690592093618727623738267853561891e-14,
1.159674232880884433248882734790328622562e-14,
0.1334645283432903593806435061147675917377,
-4.883863249435634304584541012657002332181e-8,
-5.622752405783985807865601865736813194772e-8,
-4.31561742648731599744139621058247972405e-8,
-2.484263872326819737724123552902117218248e-8,
-1.144040987800169020537970038265348531446e-8,
-4.390382668215807769196016195506713216916e-9,
-1.444151411419851130393037330118664610083e-9,
-4.156462188887537149603188640791878278768e-10,
-1.063329433470658252559978203598548877927e-10,
-2.448082915579254517004117089649487349819e-11,
-5.123090422863410755020650259477922231052e-12,
-9.822433176655329719377400250312258675401e-13,
-1.738009392561888077670347993342374373043e-13,
-2.915728929074982188299491225856056095493e-14,
-4.443944751374452642583473894735470499905e-15,
-0.06616431429707476316239609542483549961882,
1.661038786826426308729779535557619031905e-8,
1.912340994070320717884208940573004668362e-8,
1.467775063899273888331171141543708363708e-8,
8.449182193269864564806726130394006845025e-9,
3.89098274184693580599020545289711491392e-9,
1.493212555678457229342625230220412473153e-9,
4.911736520566700553718266245178085284798e-10,
1.413683917707434510264605370837853902264e-10,
3.616667806798108261292339510606463029303e-11,
8.327056690880131480588999119218056531702e-12,
1.742796369340528944780229832602991886807e-12,
3.342191918295333098506288563851488372242e-13,
5.916450397618150620477790878473227030659e-14,
9.935893851604557671413063207182809327975e-15,
1.517276536906374102529664346694431233655e-15,
0.02624324084633328299421966838746451319375,
-4.979697680579039662250503528572103973292e-9,
-5.73308761274352721784958868298012249272e-9,
-4.40030549946055255989948920101609933536e-9,
-2.533017322222268488308970699833868051267e-9,
-1.166495614557662988083274707418347490232e-9,
-4.476577229710383129550105415060166167827e-10,
-1.472518619838660772538259982098026592318e-10,
-4.238191930521848293139020029637494953489e-11,
-1.084281537351633730066705845669199045035e-11,
-2.496521135614441233781222892149925913136e-12,
-5.225296482806343570613429266775969847857e-13,
-1.00215863537786913013042393407745909032e-13,
-1.774387568851855124783616599018486339801e-14,
-2.98113887088340900731180049942829954559e-15,
-4.556047095000077686106326818229155028215e-16,
-0.008684541890341045925127614748240529377586,
1.319941453036217388901354776938287966185e-9,
1.519638512060272102265736031764339709451e-9,
1.166365286011406703480954561015769518512e-9,
6.714133977993642713085396007573614129752e-10,
3.091968980030023657043701925144314471146e-10,
1.186583890725460003615960612554060315151e-10,
3.903137576432857322635749088441234534523e-11,
1.123401708113405672377166016887618605466e-11,
2.874083048647255290593156706813332301344e-12,
6.61756294631287179458752105900747575222e-13,
1.385112143285889128030850291551689096155e-13,
2.65663947171625802680505054252157626778e-14,
4.704237443510261219859695718472299727394e-15,
7.905420144266955683405808799845914965654e-16,
1.208703257671086022162817687305142258907e-16,
0.002466311150209743759597529242490324470054,
-3.12034884028925563231551470261552968087e-10,
-3.592433896483254585404247863929238624858e-10,
-2.75729419748789867287884447449839282428e-10,
-1.587225305803108437085785943732446494497e-10,
-7.309435074509036648338722432033264093426e-11,
-2.80509355415524914903760743727500764084e-11,
-9.227056859717538239071314522081761548005e-12,
-2.655738366779325483465258094470751821186e-12,
-6.794402361777133762629006602337423851854e-13,
-1.564420552716603159569002774730499604442e-13,
-3.27451763542262199389340984891284477995e-14,
-6.280711334496805582463078124328324253417e-15,
-1.112226564250051084421665690612746751343e-15,
-1.869358450163820309306612501789066547541e-16,
-2.858939364837942196279929648866018468131e-17,
-0.0006134677589846643036824908849180002068457,
6.640107985975395589110064008596865161612e-11,
7.644706003864578028052700595964002035208e-11,
5.867527423415578703317165992834171606229e-11,
3.377618830574254149005819749931149021671e-11,
1.55544960552150168051952268130505854545e-11,
5.969248109619773197010716815042841696397e-12,
1.963522007990976488556491626616782584993e-12,
5.65143135302711140454000036543980888694e-13,
1.445857911505310510798740861591928811476e-13,
3.329126033826854103277805072298550304396e-14,
6.968331416845824210444681977211802967458e-15,
1.336594589655194523531206086874406981107e-15,
2.367026154952877813474521125291292837347e-16,
3.97874080852564986028300388507716618891e-17,
6.08608484975604578923371952784459394192e-18,
0.0001357478013769898549552627684795742569086,
-1.282922274721441674779951961445891968842e-11,
-1.477018715329037687008194769165935299245e-11,
-1.133653547911113067938676326619803839388e-11,
-6.525831973722733350719141216790024792991e-12,
-3.005254449644280389436173226668110880293e-12,
-1.153307300924943818944564227170454726529e-12,
-3.793686142265474567889468058020974228947e-13,
-1.0919041320605699363608961440692304068e-13,
-2.793524757615145459872543020315659444506e-14,
-6.432189913447192528633080097129968188751e-15,
-1.346358896418486777270420908778773627084e-15,
-2.582489346256336324232852612089084144226e-16,
-4.573572545885246660318549095224645933418e-17,
-7.688284099754829682310146653807112597615e-18,
-1.176195612729939574150280682430728005426e-18,
-0.00002705176065673000728829190892303360746615,
2.267736105727230303199854747530137667895e-12,
2.610827463619105527058705573191467762484e-12,
2.003883806769199305647059407688075530659e-12,
1.153527870144095041837220391980477533251e-12,
5.312188700161896546364906761178275914768e-13,
2.03862509953844131236091827056020609445e-13,
6.705850783002148366989941828592102781126e-14,
1.93008893014804226534199046609200380061e-14,
4.937941964936930155784114256536324654595e-15,
1.136982050646785860220070554886915354193e-15,
2.379897101893015830193773662606724907562e-16,
4.565002323480534606742027570338262417819e-17,
8.084782876213030767046919037387394956425e-18,
1.359145054013556028985491623918480825086e-18,
2.079502987280829854183558133319977862927e-19,
4.903313865860508234373933278258990549267e-6,
-3.691978685801643366979820989258122915021e-13,
-4.250547235697480880621686799914395802755e-13,
-3.262415095924653908888756744398636845077e-13,
-1.877996549034611557023651031464990863487e-13,
-8.648488718341835165350512497951732613694e-14,
-3.318976363659425657616402629618263026723e-14,
-1.091743975753798000640192654533588498515e-14,
-3.142277176424643190543489607184957738503e-15,
-8.039215252004604969992159042451431261208e-16,
-1.85106766281989011848029400890568390565e-16,
-3.874617934666669139560976715245970025828e-17,
-7.432171304891531523222394909968917931436e-18,
-1.31628862932213169607234933799106665693e-18,
-2.212926547397083525429703160115979611599e-19,
-3.386060988066170267864941273539221668777e-20,
-8.150344979392126714711457740685084944057e-7,
5.56860068350795399433716437102886370927e-14,
6.411088044812456124056427948938210632679e-14,
4.920691281224321376809631154382550758029e-14,
2.832576861711306126147449483121454947052e-14,
1.304449173306622495653898597071995147412e-14,
5.006003498327173636010564753378314271946e-15,
1.646675009354102819638937452900425020907e-15,
4.739491880712228703616762154005889079157e-16,
1.212554741950415935852773343375612907792e-16,
2.791970341628175359034646313319553903209e-17,
5.84411844591021239148885248950014031579e-18,
1.121008862728049729638120985928126747616e-18,
1.985413296994844574287153291372100808662e-19,
3.337963333247944018222925397682129756007e-20,
5.107832191341847438022699818869459068781e-21,
1.250830576783593444377214979421135775411e-7,
-7.8208125592757740800081582774627073937e-15,
-9.004042675708540306224182685583726325002e-15,
-6.910857331625374618464603450023660984069e-15,
-3.978208328870592001287772537099553026381e-15,
-1.832031774098936846070378630436649329299e-15,
-7.030675117362195246760300964096672088216e-16,
-2.312671021152383201884509957295135187207e-16,
-6.656377029835100173810413039310213444238e-17,
-1.702973207158702249463243325952670938571e-17,
-3.921190341711520906057316300977133190314e-18,
-8.207813096094458685513151687507173000765e-19,
-1.574418279561744409699848338174550177111e-19,
-2.788478460975951130503285796286438929098e-20,
-4.68824198881654658508517327379214907716e-21,
-7.174430205803854684315410206304204859634e-22,
-1.783278318199226200236038215311213100568e-8,
1.027612948657064429715872633643771697741e-15,
1.18308306453712600096165476753216708288e-15,
9.080497112475545129844017010572458194208e-16,
5.227153192104668928348086673479625152335e-16,
2.407191963081488444877116293140201452437e-16,
9.237932563427466496993221796723634696753e-17,
3.038727003523471056903761662060173475756e-17,
8.746128988557951683884381993022509143479e-18,
2.237618563556991486823574422682933337143e-18,
5.152247509672147065009188448105761365138e-19,
1.078468233038511160197573830814205887644e-19,
2.068722385804814163786659646941153091144e-20,
3.663985924287666454949754403897200331898e-21,
6.160367258220495870425364545263846546843e-22,
9.427632000572707581932138540357457664029e-23,
2.408631148984635904129126015141735627059e-9,
-1.284574781088064906541692290997094987689e-16,
-1.478921297307491446948207132171244075778e-16,
-1.135113931351969658084861062150725566847e-16,
-6.534239742618807698734884498987097123769e-17,
-3.009127407433608280718986490197025333605e-17,
-1.154794399425758187164891282985232417227e-17,
-3.798583051770672077141576831118651646444e-18,
-1.093316590452766324042248027850642170373e-18,
-2.797153855749233198310868172891189387405e-19,
-6.440617296518796736771620747220187114791e-20,
-1.348152705025827525588460221152872867367e-20,
-2.586043564439911272342362561880637146487e-21,
-4.580271570537256229485678176707223142533e-22,
-7.701099605818284049564486537983394325095e-23,
-1.178595658881053969854748485188287142953e-23,
-3.001031935368154332680695098681653215646e-10,
1.49232290804530257707846426339404198535e-17,
1.718100161679371251600663504405593630365e-17,
1.318690485090568404593425576817884677243e-17,
7.590991231281749498721728792287523580013e-18,
3.495779358916212206111989893373946326751e-18,
1.34155391585751549139485935304252721361e-18,
4.41291069189192180572505710655621092924e-19,
1.270134024280423652920025076287944687668e-19,
3.249527121360453040706585527575540653062e-20,
7.482241188039707044266983713894021259184e-21,
1.566188727230710920506280721175099007244e-21,
3.00429395172741467576468623438661735017e-22,
5.321094803225503084859230967876044205666e-23,
8.946842197490929053297544242490583058271e-24,
1.369289569936637099170807516263514035971e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=2 maxabserror=1.63723747901829152985e-20 maxrelerror=2.766762179789273049e-19
0.1002687699364021456995802069510023543946,
-6.495268309681844845280082532472541493354e-8,
-7.477941608455925395308462363549765885404e-8,
-5.739513291309738021370278261315075116183e-8,
-3.303907576402334808950124695294500177918e-8,
-1.521485549753227993180616252522655156925e-8,
-5.838762333716249616811198592636893151279e-9,
-1.920505387986485429009780650753625110216e-9,
-5.527076341560134234264489513449456697564e-10,
-1.413765219900298332862582483026978670044e-10,
-3.253955539603588318096719115754484431269e-11,
-6.805665404112201078510106683647660697652e-12,
-1.30337654452247340461743695751352819783e-12,
-2.301046462600256523881266220781907940736e-13,
-3.840594845296046809325596647435158031165e-14,
-5.798371164404422166185923387909453172974e-15,
-0.1334645283432903509851821388900108626658,
4.883863249435634265483694825666565250723e-8,
5.62275240578398576284909102734575502015e-8,
4.31561742648731596288995025446886032308e-8,
2.48426387232681971783471587869234828006e-8,
1.144040987800169011378562469683700711129e-8,
4.390382668215807734045514862813436378652e-9,
1.444151411419851118830621780085765825011e-9,
4.156462188887537116323973767306181625881e-10,
1.063329433470658244045777949832235557475e-10,
2.448082915579254497399618302055874263901e-11,
5.123090422863410713984290854365371127098e-12,
9.822433176655329640660401957156552979907e-13,
1.73800939256188806372819461005377008345e-13,
2.915728929074982164856936440707000951654e-14,
4.443944751374452606704327434060615762081e-15,
0.09924647144561215126567726712761671993294,
-2.491558180239639491654052660241150110747e-8,
-2.868511491105481109706517275922559345886e-8,
-2.201662595848910857733243767814372130657e-8,
-1.267377328990479699248296298977923676485e-8,
-5.836474112770403775885917313721375538302e-9,
-2.239818833517685869687978828698901921638e-9,
-7.367604780850050915029667560381968592049e-10,
-2.120525876561151789704161651937446193086e-10,
-5.425001710197162454126543946093198265766e-11,
-1.249058503632019736407558534684268526918e-11,
-2.614194554010793447143516669152555926826e-12,
-5.013287877442999705254899829325917186944e-13,
-8.874675596427226032551753552380726782158e-14,
-1.490384077740683667834884744017459694724e-14,
-2.275914805359561180001980284701325263766e-15,
-0.05248648169266797685407393687020329559469,
9.959395361158145031613382197920234303763e-9,
1.146617522548713008380464939357322934231e-8,
8.800610998921163181860635950287273613574e-9,
5.066034644444570399821595025971871041871e-9,
2.332991229115341368115345939754798527548e-9,
8.953154459420825327845939841149870620884e-10,
2.945037239677340975165943267807141724664e-10,
8.476383861043752510415880302192411577277e-11,
2.168563074703281767842006536570831086855e-11,
4.993042271228915411990288648601489672752e-12,
1.045059296561275610087724068758646264498e-12,
2.004317270755751488278068984367677319531e-13,
3.548775137703733678693034769500361423423e-14,
5.96227774176685740872246135836034067874e-15,
9.112094190000215665413307664832123111707e-16,
0.02171135472585214516297971290954927401514,
-3.299853632590522907156242918609687758201e-9,
-3.799096280150656579222235204770933332245e-9,
-2.915913215028498586362970483102512894318e-9,
-1.678533494498400217433575845034781963181e-9,
-7.729922450075010968686566779406775580957e-10,
-2.966459726813631521625789230420831629846e-10,
-9.757843941082082494033381354257170882899e-11,
-2.808504270283496677727762062826869651104e-11,
-7.185207621618093446000113842368083587058e-12,
-1.654390736578207637642834558835356869831e-12,
-3.46278035821470123693631080184142396681e-13,
-6.641598679290603665563220953352109740994e-14,
-1.17605936087755797200528476131930480353e-14,
-1.976355036066726590941572471378892065341e-15,
-3.021758144177696183870232162798952310288e-16,
-0.007398933450561493284108488913627753660847,
9.36104652083622068817709460732741467811e-10,
1.077730168941344484275004499819241119442e-9,
8.271882592435820224792750141809913337521e-10,
4.761675917393278717181064697821374589245e-10,
2.192830522345321267384410675027824896897e-10,
8.415280662437388340811788258031894690942e-11,
2.768117057905933019515190156224208610103e-11,
7.967215100311127081065182790465220592588e-12,
2.038320708526270949088710904461290990937e-12,
4.693261658133992746521712147892485484877e-13,
9.823552906234758218282290024443841416108e-14,
1.884213400342690858537796964274198926e-14,
3.336679692738904850003417792775543400701e-15,
5.608075350472547686506439969062479971823e-16,
8.576818094484879616999027329131968564411e-17,
0.002147137156458850335771999638952937537152,
-2.324037795096872981630919217807665276382e-10,
-2.675647101358916602826655461705085511518e-10,
-2.053634598200298944754538073456877268608e-10,
-1.182166590703778762990956423126587837715e-10,
-5.444073619338103431372501646546384155124e-11,
-2.089236838371851045119707638472736187605e-11,
-6.872327027984635868715690516561705666465e-12,
-1.97800097356415694079259466408495376649e-12,
-5.060502690280529337613090266585232818885e-13,
-1.165194111842148787686527150270227378442e-13,
-2.438915995901794502141536593824345085442e-14,
-4.67808106380422222454019478942670217521e-15,
-8.284591542354628687447067144934704336671e-16,
-1.392559282987265726579026124437473813953e-16,
-2.130129697419648894484256629624075031236e-17,
-0.0005429912069275136467406540292944052850918,
5.131689105496613573749255490110851091169e-11,
5.908074868927169153120980441229225423574e-11,
4.534614197486124276060789944857701091617e-11,
2.610332792851829479950595520315154649747e-11,
1.202101781406308843726322220597349701373e-11,
4.613229209642730596744703389847543896588e-12,
1.517474458861067180777520101493782249458e-12,
4.367616533868853469166074306964900323327e-13,
1.117409904485568569912684738242565695163e-13,
2.57287596869344312449715755710534104528e-14,
5.385435592612034534636952041267707951754e-15,
1.032995739833416279021992755653651036242e-15,
1.829429020711322391508714359740689753329e-16,
3.075313643865404783028409998562048775857e-17,
4.704782456985907250422256103260149839095e-18,
0.0001217329227978113206285494928495267829318,
-1.020481246887719049232504643665116371201e-11,
-1.174872357834741488393455893011315646316e-11,
-9.017477124368327404344915668633061653925e-12,
-5.190875412140975520509742271395264556242e-12,
-2.390484913457612551907010837811142266666e-12,
-9.17381294172427389883005389117532433194e-13,
-3.017632850311960559589918505586253729081e-13,
-8.685400179797473818940583154054933790945e-14,
-2.222073882720157551130499842242183198473e-14,
-5.116419224453322494837316313716178605587e-15,
-1.070953695128188181026151474322269724402e-15,
-2.054251044178076385465744877164407480055e-16,
-3.638152291837169253127765722929589863041e-17,
-6.116152738926861982446551547342124338862e-18,
-9.35776343643622836408234469830750886674e-19,
-0.00002451655418488409882022841393518317323401,
1.845988637640247970093416136005470628862e-12,
2.125272805887533545674656773001639080418e-12,
1.631206924759123591393164745009931968258e-12,
9.389979157727660706744928738646476647508e-13,
4.324242707091827989297263390721510521902e-13,
1.659487547821368844818267345887479630151e-13,
5.458717793260203964101577497572270412585e-14,
1.571137987956304769210653461328552977541e-14,
4.019606090299025554010669178728204084982e-15,
9.255334778042960817050175816436919506965e-16,
1.937308227161974564028646310692375587874e-16,
3.716084232630051806783834766211869451683e-17,
6.58144063186936288920278463712635443091e-18,
1.106462850865998537664111910282285238596e-18,
1.693029846882148433978388531756525044513e-19,
4.482690746567510424027552781477335487265e-6,
-3.062730817258921143290364950593333032218e-13,
-3.526098932746247746412184642391761462964e-13,
-2.706380594654044300714352265510935811795e-13,
-1.557917498432100059754366751861752552644e-13,
-7.174471487004805515809899849647461602916e-14,
-2.753302320822155287058788767205868976126e-14,
-9.056713856492592414663244801232107648127e-15,
-2.606720910012903344850046946194453262284e-15,
-6.66905204172202649154885145369319373208e-16,
-1.535583909170927797395686136018303186682e-16,
-3.214265608427507742847682726200086117441e-17,
-6.165549633484536881772198941398932476072e-18,
-1.091977470713392480935277043885117659126e-18,
-1.835880097887773519418298086171694459526e-19,
-2.809308110223554109846227266641411617597e-20,
-7.5058426825936375255817802243469028155e-7,
4.692887660375802456632933341456350077167e-14,
5.402886266117100948760897560729724402225e-14,
4.146867969092203251899436407744463226846e-14,
2.387128528607473325763778469932259945407e-14,
1.099312794047691807653663829764597936111e-14,
4.218764770757658875712258359212349215088e-15,
1.38772093262006450999088845711452434376e-15,
3.994166769087186354670545810296569372153e-16,
1.021871051380644792088393430324729986397e-16,
2.352914820797240681954000992333014370038e-17,
4.925107788865466998770142650337777515357e-18,
9.447315200201562084863107536928116027435e-19,
1.673229748730316060113470690312695478323e-19,
2.813185084471160133953953671261254120996e-20,
4.305025280187679296232203572325094236502e-21,
1.159099140781193652105610642344815698747e-7,
-6.679345073285450815360965900369234965985e-15,
-7.689879782780338871379588768589596391185e-15,
-5.902200213651171537467016012289058771699e-15,
-3.397578822508044111939943312047832446169e-15,
-1.564642193347599595948560660443954147986e-15,
-6.004531125747637877803179185101217880412e-16,
-1.975131421436809611888985129617366497708e-16,
-5.684865458757610021447059089339939820004e-17,
-1.454421778825441928792378203925375014437e-17,
-3.34889114233420424360625796082254284736e-18,
-7.009897536179222272118508048057989403245e-19,
-1.344641548711310235425065722782175038689e-19,
-2.381541253975129070181739010635930087417e-20,
-4.004155323926786600363728420328098373029e-21,
-6.127833161857592123708797649872426906878e-22,
-1.661363751595427564196592968426924043761e-8,
8.877103589499134959220694315415765956261e-16,
1.022014268772805336669438428150059101038e-15,
7.844248618472530851931829098208084988487e-16,
4.515511583492392496593488700626905070237e-16,
2.079469102797677214905154390023532224735e-16,
7.980251233055157299147303149812842713956e-17,
2.625025460267646981628801853454206497688e-17,
7.555406400321290581425806450891076489795e-18,
1.93298392199220944435432788344923235213e-18,
4.450813236437746729245214253645196947579e-19,
9.31646045974493862502532524214690775141e-20,
1.787095067540997541789047752566109555972e-20,
3.165213221417630583281460506849123241612e-21,
5.321870558792633366086558118141596581881e-22,
8.144718505062100975674306544889198115133e-23,
2.25468381620527937194467573156703094253e-9,
-1.120954171826472082522405139963419029869e-16,
-1.290546123419099020496197813982839599863e-16,
-9.905306637595171055300337201392911269052e-17,
-5.701951798541766859493874356795347402411e-17,
-2.625844872821986312895649639856395216495e-17,
-1.007704465982913975708175351444676591762e-17,
-3.3147455058698106580520213386028249956e-18,
-9.540576152994641163529940993030698615248e-19,
-2.44087319961936309124570721159448596632e-19,
-5.62026453343968318680063500956938207315e-20,
-1.176438285703188923938042674425622042872e-20,
-2.256667026673164653262232702087659077611e-21,
-3.996925600429320491790270812416329197599e-22,
-6.720395977195172955041755902527078218734e-23,
-1.02853818379703714072163561385105287464e-23,
-2.82064233097197671432210518693035609321e-10,
1.31349128270923330207372498657156286677e-17,
1.512212658564608625701634538855296151195e-17,
1.160666008405779803549356364584897877485e-17,
6.681329471604978468931726032343263686145e-18,
3.076864868760938131340461527575181809685e-18,
1.180789716694124577853510791230554238471e-18,
3.884092933677082261367101597921702863058e-19,
1.117928713225898899559296743618719861106e-19,
2.860124247845949296997566548867965193226e-20,
6.585621756732616319299723841494399866757e-21,
1.378509825956249091160223892364886300051e-21,
2.644292959410584295759970075619230058828e-22,
4.683504105349945917935774546766185668241e-23,
7.874917276130177632289349697427201930867e-24,
1.205266776655281258887609664682736265378e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=3 maxabserror=1.54955205604485763696e-20 maxrelerror=4.28483788419606412343e-19
0.06673226417164517547881683661386648460007,
-2.441931624717817132684935643034922314689e-8,
-2.811376202891992881359023419781772158922e-8,
-2.157808713243657981394685065498317722761e-8,
-1.242131936163409858888408657119336704498e-8,
-5.720204939000845056759496017462490032563e-9,
-2.195191334107903866971595429738072180038e-9,
-7.220757057099255593984816444213528644607e-10,
-2.078231094443768558113548539397602917791e-10,
-5.316647167353291220104964339569170733671e-11,
-1.224041457789627248671274483564431731289e-11,
-2.561545211431705356932416180640088803156e-12,
-4.911216588327664820215626208098827887575e-13,
-8.690046962809440318438039022382539062843e-14,
-1.457864464537491082394345759002213984658e-14,
-2.221972375687226303299936521473750767591e-15,
-0.09924647144561214334646220463106913321965,
2.491558180239639456976590409747802015621e-8,
2.868511491105481069782615065921936592194e-8,
2.201662595848910827090518878940611205548e-8,
1.267377328990479681608928760629205298985e-8,
5.836474112770403694653654039965587169626e-9,
2.239818833517685838513965864701041394968e-9,
7.367604780850050812485774872767207546656e-10,
2.12052587656115176018973347193906718729e-10,
5.425001710197162378616397316658431570722e-11,
1.249058503632019719020844972443460720486e-11,
2.614194554010793410749399732012526117375e-12,
5.013287877442999635442577202058936072799e-13,
8.874675596427225908901265293896984798943e-14,
1.490384077740683647043833838246507336653e-14,
2.275914805359561148180248915832419982986e-15,
0.07872972253900197145298389451438828366689,
-1.493909304173721780242255012551975503907e-8,
-1.719926283823069541928941386403722030595e-8,
-1.32009164983817449981237866247631865484e-8,
-7.599051966666855729444378239645092159419e-9,
-3.499486843673012111907577712219442574329e-9,
-1.342973168913123822100861169826786441639e-9,
-4.417555859516011538155097700348938979468e-10,
-1.27145757915656289826597306582898401477e-10,
-3.252844612054922707289812968318667914565e-11,
-7.489563406843373245839669568901439806191e-12,
-1.567588944841913441894250259853140848418e-12,
-3.006475906133627283754200167486786447429e-13,
-5.323162706555600608967456967882873063928e-14,
-8.943416612650286265974952252872130609833e-15,
-1.36681412850003237321324409923206974149e-15,
-0.04342270945170562116039027632856693599899,
6.599707265181104088340427568720720248845e-9,
7.598192560301380248895787916417770444748e-9,
5.831826430057048666546148822801407348309e-9,
3.357066988996830077088067047557810270693e-9,
1.545984490015015844480109003524030038326e-9,
5.932919453627315429879223441873238217854e-10,
1.951568788216433730879845385273392283189e-10,
5.617008540567042953220213230661991704208e-11,
1.437041524323631378365003090761199080949e-11,
3.308781473156444492932141105033806514381e-12,
6.925560716429463632667191698070620844998e-13,
1.328319735858132464782108112564604494832e-13,
2.3521187217551367229591329316911586057e-14,
3.952710072133488120376791621765978992996e-15,
6.043516288355445842833000218936926630437e-16,
0.01849733362640328877846549929485018413217,
-2.340261630209036809751494741055925388493e-9,
-2.694325422353340070317500269870273243511e-9,
-2.067970648108938830365802728089299749342e-9,
-1.190418979348310338956740842324420835777e-9,
-5.482076305863260154625576889129374605464e-10,
-2.103820165609330578043581713126799138451e-10,
-6.920292644764778250083776542430265146999e-11,
-1.991803775077766141881126580706022903024e-11,
-5.095801771315637388819284799595966026493e-12,
-1.173315414533488980065240299561668249726e-12,
-2.455888226558670283233245335188578913226e-13,
-4.710533500856690179378034881464949917407e-14,
-8.341699231847196649377331297019002743448e-15,
-1.402018837618125912188075343441753670632e-15,
-2.144204523621203053410696195266006811577e-16,
-0.00644141146931265534867043442687473830064,
6.972113385262641307773657101032561046374e-10,
8.026941304044539364695359664071374136941e-10,
6.160903794576174407025592702182507341938e-10,
3.546499772097104918163748921426472988874e-10,
1.633222085794877243070941061491682462892e-10,
6.267710515090402067036625369298279970585e-11,
2.061698108387117560580425084965022410471e-11,
5.934002920668658700381481173470089339788e-12,
1.518150807078066673010105056700975142417e-12,
3.495582335512418832446841757179931302234e-13,
7.316747987676020879139523897322128157923e-14,
1.403424319135634237215779940137903742111e-14,
2.485377462696412534465916934271749554513e-15,
4.177677848945023043132561754647155841591e-16,
6.390389092233273037535082707252391198378e-17,
0.001900469224258150493617617398751752495462,
-1.796091186928711813390356925223050224524e-10,
-2.067826204130147155024381347869789742996e-10,
-1.587114969124470783933773478903178303222e-10,
-9.136164775006313044194351795399199286655e-11,
-4.207356234933552366032863321660288611265e-11,
-1.614630223379358023613674040563695952868e-11,
-5.311160606028216121320090085541592447117e-12,
-1.528665786858266667583730677747168144568e-12,
-3.910934665710153351117205435511788954537e-13,
-9.005065890451604038342911082864795659462e-14,
-1.884902457419351583918205513212364045991e-14,
-3.615485089426815742602686049729355658865e-15,
-6.403001572507090147398422248030660821653e-16,
-1.076359775355827794852629583580417625873e-16,
-1.646673859949561508792919049141483642409e-17,
-0.0004869316925302790482514948729246750111937,
4.081924993413903847370793080922202458197e-11,
4.69948943808902571517321195646865288817e-11,
3.606990854928192871764118766350167837986e-11,
2.076350167838733577760867161872927345455e-11,
9.561939667564644545819557367834399726215e-12,
3.669525181960398016490773067435016303921e-12,
1.207053141858526081827917943520669974086e-12,
3.474160076909086764880579885922117796835e-13,
8.888295543647368287070498460857666818535e-14,
2.046567692720955369303222034723689508614e-14,
4.283814786666020602717459211314261562117e-15,
8.217004188515694656053259323757272382377e-16,
1.455260918825465437000843526394227011403e-16,
2.44646109908595327902270283451959924227e-17,
3.743105379954691874261238841580172099799e-18,
0.0001103244936829601944419980377851046842717,
-8.306948863224344492686999620894869856053e-12,
-9.563727619405656232515072994338806556269e-12,
-7.340431155975627695795199510746760767854e-12,
-4.225490617845685422226539513733464978597e-12,
-1.94590921674909338165318421645919010925e-12,
-7.46769395966140401428966443741681066464e-13,
-2.456423005146487398394599320163917343562e-13,
-7.070120940563263617723769363076719036265e-14,
-1.808822739293924198493908391435760880704e-14,
-4.164900647032423903074504110148683822792e-15,
-8.717887015767316741636272419576247886542e-16,
-1.672237903444042144352775584466804336441e-16,
-2.961648282145852961259888687178624898694e-17,
-4.979082825205591849043641137707273564924e-18,
-7.618634305319678270082456227582049840936e-19,
-0.00002241343944743180543515329406944573042441,
1.531364783146805253719552104019503493106e-12,
1.763048746259633887310124919393394055686e-12,
1.353189744619537633959281887496268506927e-12,
7.789584310520977024714521265886557802634e-13,
3.587234278303728017656042128073160838175e-13,
1.376650598120669336635834364105125637701e-13,
4.528355078646523405408874847217409546641e-14,
1.303359922650226076906201744398720928221e-14,
3.334524658873024600964636909097934636169e-15,
7.67791640978669139527461735948030548256e-16,
1.607132147767534662347915671496136892109e-16,
3.082773557526788793771479869258888563747e-17,
5.459885123264285157909386001886996330957e-18,
9.179396739325305285854982752520595403555e-19,
1.404653481138336568793818055674846020944e-19,
4.128214429209985097462424022526063334536e-6,
-2.581088607264815911484952632769834950732e-13,
-2.971587900040570004592712176816274679141e-13,
-2.280777731210009831589747062562123399511e-13,
-1.312920891179464642560964893570309549244e-13,
-6.046221290346994409521949371753552043589e-14,
-2.320320978163338325172115136732777097403e-14,
-7.632466294670368983678168440174427835495e-15,
-2.196792058385925256773206399496619273438e-15,
-5.620291640655326670386861233272971807723e-16,
-1.294103349013036758196892920293852493955e-16,
-2.70880969744239224419164149811981640347e-17,
-5.196024153428647722202674129326961771102e-18,
-9.202765023135633276828113801046214136349e-19,
-1.547252032723682428630587973359462160101e-19,
-2.367764265725283815881289030311836539419e-20,
-6.955405330997779859148383781334780693899e-7,
4.007961907887172530696052648895090483001e-14,
4.614336421833123926473108145108007239646e-14,
3.541633703540293548094131541527636031604e-14,
2.038727801957078969474358332374791330671e-14,
9.388684431960007856958199579443631605091e-15,
3.603037687613785046742443269717337465528e-15,
1.185183788820368729971242982817562288181e-15,
3.41122130443679379067265529568010261911e-16,
8.727303388849764064718479448480983301313e-17,
2.009512608376208548871089329773725211189e-17,
4.206310952620018174385383671150385669935e-18,
8.068563700785495165904272870715181843361e-19,
1.429051287299644203432440564381053515308e-19,
2.402705954850567592856939462048517535202e-20,
3.677025537582761110488382919517943133433e-21,
1.079856378127597558013484622021060276289e-7,
-5.769993138556978472199704448284122015875e-15,
-6.64294976269126286174933004907019463169e-15,
-5.098651857485027945125369576117096141928e-15,
-2.935019355254474938164138302465094152699e-15,
-1.351625824118011249520194717892469762211e-15,
-5.187051654189543693428140080990484825631e-16,
-1.706229823875674782206852377422619605164e-16,
-4.910908456561629008715971943288142882123e-17,
-1.256412505910235666364439966591738455983e-17,
-2.892966334453996448293889306965782826657e-18,
-6.05556895583190124172694060810229386694e-19,
-1.161586791042126402475577871222567153267e-19,
-2.057344309032272488406087218690286866883e-20,
-3.459141400127327924106394053545430315859e-21,
-5.29395305649077571746921560391380182219e-22,
-1.555000355584571979082226503849385272061e-8,
7.744758570054782673432266902551473475948e-16,
8.916482403869426423438937776282661073935e-16,
6.843652522198482126245273970659750539537e-16,
3.939522341233810952841802429495045048886e-16,
1.81421641224630259570847969750011340943e-16,
6.962307627383781427669815675331743328321e-17,
2.29018314801493834483221888226119511338e-17,
6.591657363149260746681080260615729078532e-18,
1.686418029988839043518389218768586279863e-18,
3.883083831594404385206451728485166515685e-19,
8.128101941760721448527854946910129946929e-20,
1.559148357906100264778462503362401681556e-20,
2.761505767709190106166588975537007302663e-21,
4.643170141759122766134490261495789313937e-22,
7.106239933256708381911649513181373443106e-23,
2.119181678557229724198905165454514214418e-9,
-9.866470808278526654816612526103300400118e-17,
-1.135919381282882910299893814790015062874e-16,
-8.718502696682418966191643023639130645592e-17,
-5.018772721488611511382716422303789922993e-17,
-2.311229454804073708128284665163864360582e-17,
-8.869664707110101056286029541410833872354e-18,
-2.917589942955126119608611229767396830921e-18,
-8.397475621719128287153979028894996253951e-19,
-2.148421754143400208610731564326646448733e-19,
-4.946880572101390245667176230436455875603e-20,
-1.035486664140825448972299160611577571615e-20,
-1.986297134812599864985156260075145652604e-21,
-3.518078775300521604555921759034531300797e-22,
-5.915353062498638123325586537266367884834e-23,
-9.053528762612696049620266545966144488053e-24,
-2.66065743757793362800203491001520153787e-10,
1.164916146590841755457800888538875144759e-17,
1.341159222772223663613271244383185597913e-17,
1.02937766152821059657018001793770116704e-17,
5.925573190271909822562469609193216401344e-18,
2.72882641859796516714218847297574551993e-18,
1.047225163113451552135328975298036944002e-18,
3.444745624758694347960242983728747289458e-19,
9.914749158565848820611793568708468408255e-20,
2.536603991406040832693729776219732202177e-20,
5.840699435327516999154018358248630142962e-21,
1.222583543737030450568275185902575465909e-21,
2.34519764255358573762534209945573567137e-22,
4.153777237689338221684019282869533174611e-23,
6.984315008275808278190774361719420386794e-24,
1.068983991917298856263933096292656323363e-24,
// [{0,1.e-7},{2.,1.e-6}]: m=4 maxabserror=1.47077906445538950262e-20 maxrelerror=5.77567868020813430559e-19
0.04962323572280607166015897815664353854407,
-1.245779090119819728437171769928791904183e-8,
-1.434255745552740534832449505464701538698e-8,
-1.100831297924455413500084237133248122804e-8,
-6.336886644952398407784594471703825088845e-9,
-2.918237056385201847207069911480819148468e-9,
-1.119909416758842919211024469871512235156e-9,
-3.683802390425025406091711508740910289497e-10,
-1.060262938280575880051354906678666383765e-10,
-2.712500855098581189196877290478084516026e-11,
-6.245292518160098594847899709974426796235e-12,
-1.307097277005396705321045394819289972823e-12,
-2.506643938721499817618366458343550794083e-13,
-4.437337798213612954268336876815023015675e-14,
-7.451920388703418234912643844506084582914e-15,
-1.137957402679780574043207403681913113019e-15,
-0.0787297225390019639590018059154611167975,
1.493909304173721749279284269051492649509e-8,
1.719926283823069506281505304343548911176e-8,
1.320091649838174472451962429721019669453e-8,
7.599051966666855571945185750438928455512e-9,
3.499486843673012039376541167916386055455e-9,
1.342973168913123794266064141429809081284e-9,
4.417555859516011446595224993256475742544e-10,
1.271457579156562871912987709130516025626e-10,
3.252844612054922639867927380378068922402e-11,
7.489563406843373090596197585321732602262e-12,
1.567588944841913409398425222002290315096e-12,
3.00647590613362722141954985409434386094e-13,
5.323162706555600498560762526752847815746e-14,
8.943416612650286080330966863206956185631e-15,
1.366814128500032344798925854749163507973e-15,
0.06513406417755843759786666595542157197039,
-9.899560897771656361577890835418115580157e-9,
-1.139728884045207063706708940796042094805e-8,
-8.747739645085573202234404359753391849727e-9,
-5.035600483495245232151628547831090739932e-9,
-2.31897673502252382037937376801924005939e-9,
-8.899379180440973350743546637764913919826e-10,
-2.927353182324650664056714884036030881103e-10,
-8.425512810850564624792475010066824695718e-11,
-2.15556228648544711742693776337098624179e-11,
-4.963172209734666854249057804128111736845e-12,
-1.03883410746441956894087757276506033181e-12,
-1.992479603787198743289179582796008280599e-13,
-3.528178082632705166119421347872439402356e-14,
-5.929065108200232317909085547366942160843e-15,
-9.065274432533168974469347250776581472871e-16,
-0.03699466725280783693251078321767485515193,
4.680523260418125651646560966996093661377e-9,
5.388650844706740044851800166408413605668e-9,
4.135941296217923638913653827630558275845e-9,
2.380837958696647145078612392966340968296e-9,
1.096415261172664219501393114416341490424e-9,
4.207640331218707931448846661937668134742e-10,
1.384058528952971036319580971667355208869e-10,
3.983607550155576568993446576270549030504e-11,
1.019160354263138807765945032624674573505e-11,
2.346630829067004048230018261941617422271e-12,
4.911776453117395174515885423869114112622e-13,
9.421067001713485109863733660004978658945e-14,
1.668339846369457883318061016039900214986e-14,
2.804037675236283021171429574470531128728e-15,
4.28840904724245385604827491472547828188e-16,
0.01610352867328121659311111904729384368155,
-1.743028346315643832182334401342255257376e-9,
-2.006735326011115850879032321459960616679e-9,
-1.540225948644029026167530038215187038002e-9,
-8.866249430242678391587264996124712562559e-10,
-4.083055214487154468550413979824902517328e-10,
-1.566927628772585688454700154295575715546e-10,
-5.154245270967745125174384061489597986684e-11,
-1.483500730167150636186811832799598374892e-11,
-3.795377017695130765154526283429207610784e-12,
-8.738955838780964378885698643854602989609e-13,
-1.829186996918987908395595075289855836823e-13,
-3.508560797839052385643300024744223778733e-14,
-6.213443656740972519201705631263728149508e-15,
-1.044419462236245870871777525020910795374e-15,
-1.597597273058303121793467261315234004049e-16,
-0.005701407672713986604156524659416711604356,
5.388273560761154498512692062509640400743e-10,
6.203478612361681094228384499829761748183e-10,
4.761344907351337953084039727800189834509e-10,
2.74084943248918686983064701018658296697e-10,
1.262206870474213901831227701587322275532e-10,
4.843890670115616941438206144687347376866e-11,
1.593348181801077780878709285187507406352e-11,
4.585997360553538399808085156407330297153e-12,
1.17328039970760640393133161455396479903e-12,
2.701519767122956159715805782681090372329e-13,
5.65470737223183710236300321807407147407e-14,
1.084645526823015559778212004750050830855e-14,
1.920900471743219426026356612635869596575e-15,
3.229079326052505617443701881368432313784e-16,
4.940021579825759838146219812499914005651e-17,
0.001704260923867225256247348193759980429334,
-1.428673747699265359026923161392660229224e-10,
-1.644821303336223550371645092132904438068e-10,
-1.262446799228754690663506331722611543506e-10,
-7.26722558745794395768863684642560687493e-11,
-3.346678883657930317460455853359451688875e-11,
-1.284333813690093888415171617043661330598e-11,
-4.224685996517849504413138260465410307334e-12,
-1.215956026921924425181760502212711497348e-12,
-3.110903440286157757675845815681243534228e-13,
-7.162986924545399774073317471343369867403e-14,
-1.49933517533772401119474745518241338047e-14,
-2.87595146598934925965855423682213791768e-15,
-5.093413215904815013181318408996537672279e-16,
-8.562613846827212028855840966709968095227e-17,
-1.310086882988179222562556045443093888597e-17,
-0.0004412979759989785119374177121878766107789,
3.322779550524785073878290180314796509269e-11,
3.825491053789333174720205457341515411682e-11,
2.936172467016198429404741472555508092736e-11,
1.690196249801183117729820905457345656738e-11,
7.783636879259518704316872024815291070584e-12,
2.9870775885707146297056331901220750048e-12,
9.825692036066384799004308966626403620336e-13,
2.828048380680921977491853883224675195289e-13,
7.235290968575015086589618237112924499299e-14,
1.665960261437740043095787961585258428925e-14,
3.487154811801140486951761652288993806953e-15,
6.688951624315365410132606249419273277634e-16,
1.18465931472503632920206770936163797366e-16,
1.991633133221002304025359300197711382582e-17,
3.047453726932006791160948576476971591329e-18,
0.0001008604773720203890212286530128804815118,
-6.891141518630015308327592420981593939339e-12,
-7.933719351801004569013436233527404665869e-12,
-6.089353845900799565614107440883153589942e-12,
-3.505312936921187771587686865943452473365e-12,
-1.614255423941127606281732234865177351372e-12,
-6.194927686571157994049722655465705355404e-13,
-2.037759783755492127247391151068114664414e-13,
-5.865119647218843698914050689679362513535e-14,
-1.500536095288570150560818334712296289787e-14,
-3.455062381631047954096526514645155058318e-15,
-7.232094659149486417052982676587691806942e-16,
-1.38724809977362808658648680310560563633e-16,
-2.456948303496825873310909754793370827488e-17,
-4.130728529380351079065997721929193023464e-18,
-6.320940660046958535131315966992511144844e-19,
-0.00002064105862765058758281886189190405087758,
1.290543745143333661482573835698128010167e-12,
1.485793307036000857689068488508271934421e-12,
1.140388372096366456165821296094327421353e-12,
6.564601615033668813270782860314365914323e-13,
3.023109336907833847397816909307962480834e-13,
1.160159987016471480263579263273819847664e-13,
3.81623149584027513539116213480176650303e-14,
1.098395553855679106104572633774113624688e-14,
2.810144604217400105513679479548110826117e-15,
6.470513944888681846946621139694485297869e-16,
1.354404262583533293262888759011217583447e-16,
2.598010952364154899237914678081133352891e-17,
4.601380520126687623627765441822828374894e-18,
7.736256815097966919251057925285095877701e-19,
1.18388162034440373366090594052534979052e-19,
3.825473837217882671682984250290413119033e-6,
-2.204379403319348031148842709750972747354e-13,
-2.537885439544354601597306264570746450695e-13,
-1.947898849742683263083229004573638977903e-13,
-1.121300471135944066569534792467833456869e-13,
-5.163777266782641100782293261028412814655e-14,
-1.981671046406438799298415349326213107773e-14,
-6.518511885262252278518615686073785464716e-15,
-1.876172018718474355932712449049957687916e-15,
-4.800017634662487030117390043324231083094e-16,
-1.105232112087823862019467690906573487716e-16,
-2.313471395447444391531154037084260696065e-17,
-4.437710748070456264157865712762292347455e-18,
-7.859783342373733601635137258525035928589e-19,
-1.321488487407608194639826757500415741327e-19,
-2.022364370526726482178022933627393438186e-20,
-6.479905239354345527317208806086413076865e-7,
3.462312739094442119544619501852730025479e-14,
3.986134651506274916281050789912951369628e-14,
3.05947110412864955725154536833428652135e-14,
1.761172788119681248205559825426504807029e-14,
8.110497182635566456121144690651800755056e-15,
3.112515836672093729864640096933928573148e-15,
1.0238315910563639543888231149379614737e-15,
2.946814754148028308500518441595038589806e-16,
7.53916498948740645331738587864418996994e-17,
1.735938667274356234468788156595974224067e-17,
3.633673915746864352210234744557390098367e-18,
6.970158640652523747522099544379813968806e-19,
1.2345195688279191874591090088951970331e-19,
2.075674816696300498485202928916453926514e-20,
3.176662608535240508705972771115410192933e-21,
1.010721702892414555925277986866523389946e-7,
-5.033981506767524502192083974718374371446e-15,
-5.795585119985071193862550284204091276675e-15,
-4.448275556151067926444584688105279263612e-15,
-2.560632772713550189197574375205154097212e-15,
-1.179214534046571317650980385984495242869e-15,
-4.525399665257391087125034128291717929259e-16,
-1.488586055945750390673237665751379923736e-16,
-4.284482332653563604253788112290956063704e-17,
-1.096147426462972581183429749594616740708e-17,
-2.523948554154351567761155639995253553612e-18,
-5.28314917503952673961078561518065505045e-19,
-1.013423972524310417885820942933439858239e-19,
-1.794938967640238873162884867254674758201e-20,
-3.017993700857018850359838706548459352712e-21,
-4.618953572190908486720207040227909738001e-22,
-1.461398677885573911584165569223682044776e-8,
6.815525102797906160860918677660502165111e-16,
7.846662913007955144977124062252442789037e-16,
6.022535831760554013538368842411105506045e-16,
3.466849709167708723201260838498140574648e-16,
1.596542741320496706809914937068430831326e-16,
6.126954968134630872630115951008804777808e-17,
2.015402244300814492369962911646902590507e-17,
5.800777858236428315662823814456094466204e-18,
1.484079001125092064034372586405177065418e-18,
3.417188192022548284072526821339456143547e-19,
7.152896914318966290579779324029944545639e-20,
1.372086976419572087704373578444465415145e-20,
2.430205084225127212383693335675018271935e-21,
4.086183801058403076433124239993228394911e-22,
6.253956507580289710110067100087280834126e-23,
1.999004424829080395507535934776744316395e-9,
-8.75060265696800131242682152282299426465e-17,
-1.007450321006946626299505290913483440371e-16,
-7.732466346651275788064027427162523299765e-17,
-4.451164717493119596313374077529168957649e-17,
-2.049836443714531856011871824774661832632e-17,
-7.866532989195859066129568671013724736009e-18,
-2.587619745705156721142734705294848499384e-18,
-7.447748978529597633790415017981032046739e-19,
-1.905443042580375139761012936169126753775e-19,
-4.387409371274777383137992347480814097276e-20,
-9.183787962173324523884440705389784657535e-21,
-1.761662681001690608681735175654604667555e-21,
-3.120229322417933216606594306253914797022e-22,
-5.246469409005180154255427247437853431554e-23,
-8.029981679747890677632860542906032556921e-24,
-2.517807510063571355512095016832377664401e-10,
1.040149376422361888487816437569547340436e-17,
1.197516178894673045612738676867301073636e-17,
9.19127564319058522133753710289984881084e-18,
5.290922767623109871374272503349538242775e-18,
2.436559239198706093384878264822389101394e-18,
9.350635963186420365748121583247121545852e-19,
3.075801263340870841369689675076461340552e-19,
8.852846042774390127279476237199361367193e-20,
2.264925834025410867995513846553837060446e-20,
5.215145610571477684129425739700718689412e-21,
1.091643065878446561442656651717856796887e-21,
2.094028664371389479311187433536253262335e-22,
3.708928885384675948929956537766052859828e-23,
6.236400413305259420333094870221020438783e-24,
9.545317227363187714053937382698824593681e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=5 maxabserror=1.39961813539720712298e-20 maxrelerror=7.19152288234293924386e-19
0.0393648612695009819670629128216793186133,
-7.469546520868608745934682148113878187286e-9,
-8.599631419115347530875929643640547468738e-9,
-6.600458249190872361851796493952168910225e-9,
-3.799525983333427785737720216037836738409e-9,
-1.749743421836506019580107756532944761219e-9,
-6.714865844565618970915230742161728650606e-10,
-2.208777929758005723161072649652787803732e-10,
-6.357287895782814359171946134052327607414e-11,
-1.626422306027461319833419851409307026796e-11,
-3.744781703421686545066589533798632912754e-12,
-7.837944724209567046507526027713439428279e-13,
-1.503237953066813610616816830004427897952e-13,
-2.661581353277800249115733176046351778527e-14,
-4.471708306325143039888629715014511353776e-15,
-6.83407064250016172357086743528758591002e-16,
-0.06513406417755843048586869069669305466575,
9.899560897771656083439466681083536609368e-9,
1.139728884045207031684840624969924641782e-8,
8.747739645085572956457499846461035757573e-9,
5.035600483495245090671089676451322814456e-9,
2.318976735022523755225196479349788097605e-9,
8.899379180440973100705294232947835353839e-10,
2.927353182324650581809044455232579685313e-10,
8.4255128108505643880651963253075036744e-11,
2.155562286485447056862247881263322657736e-11,
4.963172209734666714794668627668738024007e-12,
1.038834107464419539750018065468120722479e-12,
1.992479603787198687294110729456652902976e-13,
3.528178082632705066940916691587572151018e-14,
5.929065108200232151143144927410819666164e-15,
9.06527443253316871921584904211648548575e-16,
0.05549200087921176097191248729907485674001,
-7.020784890627188684360236673515248669805e-9,
-8.082976267060110305469062137758543026736e-9,
-6.20391194432688564118909473535143074954e-9,
-3.571256938044970822856758146372821496569e-9,
-1.644622891758996377716353162894824653021e-9,
-6.311460496828062083161653569407623026863e-10,
-2.076087793429456615658459306379394238358e-10,
-5.975411325233365029577354716128840473811e-11,
-1.528740531394708256699358736672516113137e-11,
-3.51994624360050617607683611123284659105e-12,
-7.367664679676092978907446469431966510802e-13,
-1.41316005025702280813107582810688959713e-13,
-2.502509769554186898750572613894651973028e-14,
-4.206056512854424655806338030414760027371e-15,
-6.432613570863680973946383504565830423099e-16,
-0.03220705734656362837058040066686240624011,
3.48605669263133440464679828287123133771e-9,
4.013470652022285513494574870059621938753e-9,
3.080451897288099354366208142559559855011e-9,
1.773249886048559453674356065971436626285e-9,
8.166110428974418426634238951075998469196e-10,
3.133855257545213395046579527938527492276e-10,
1.030849054193562846495655801663939378464e-10,
2.967001460334341053643789873801265617245e-11,
7.590754035390363307354115979699160184032e-12,
1.747791167756216310646009357162477447647e-12,
3.658373993838024871107023331402951296639e-13,
7.017121595678198869228277959633543258561e-14,
1.242688731348211170474309435107844884415e-14,
2.088838924472519766232464391136605814325e-15,
3.195194546116649138130420142765510202486e-16,
0.014253519181784565191944807787458751569,
-1.34706839019027372677009825908370451776e-9,
-1.550869653090403121764717272762366127772e-9,
-1.190336226837821323784752500436402568701e-9,
-6.852123581222891393712359170269564665008e-10,
-3.155517176185499856209857602996272762387e-10,
-1.210972667528890842623078090252833460724e-10,
-3.983370454502650398079763327271385293787e-11,
-1.146499340138371920185587452727892449274e-11,
-2.933200999268983569700871107635088512499e-12,
-6.753799417807315703614891186103120275306e-13,
-1.413676843057943640133981661403569557606e-13,
-2.711613817057508906831784397673725240209e-14,
-4.802251179357995441920590800702893895152e-15,
-8.072698315131174717698993470211808912477e-16,
-1.235005394956426287004827219424319701701e-16,
-0.005112782771544292757845145284987645895918,
4.286021243075355738151158239134830069062e-10,
4.934463909982835257089365737481912506353e-10,
3.787340397666434675692082157459497096194e-10,
2.180167676225968470861313216412430121952e-10,
1.004003665092122425558199799890410805164e-10,
3.853001441050108461393126153438898679275e-11,
1.267405798948719070574064684611612430965e-11,
3.647868080746674007312397560246568883569e-12,
9.332710320809609396240908762329264202042e-13,
2.148896077352368686477147380942206465764e-13,
4.498005525989620710742073587901645604389e-14,
8.627854397922870693791310684475517200752e-15,
1.528023964763442735474255063884253729958e-15,
2.568784154034708853887544848322832930025e-16,
3.930260648943943694701431883487164864895e-17,
0.001544542916007127724717932451574441292335,
-1.162972842687647911336949248657535407112e-10,
-1.338921868830840852260848734524198341965e-10,
-1.027660363459180309849926713110229737903e-10,
-5.915686874324351041520331607673790331465e-11,
-2.724272907750138652554263920898851246383e-11,
-1.045477156003321852399275272710767565596e-11,
-3.438992212634983548142347347143505342983e-12,
-9.898169332417042809142972409849889564432e-13,
-2.532351839009906793881503260954880839617e-13,
-5.83086091505201086920777477647712269879e-14,
-1.220504184134569017382669500427599346078e-14,
-2.341133068518376675470200269120556689095e-15,
-4.146307601551794655521101243692236915046e-16,
-6.970715966297330545312094523956508898782e-17,
-1.06660880442984872800723627094597223819e-17,
-0.0004034419106906350818904741098992436159694,
2.756456612154649325558291195489950343697e-11,
3.173487746134519701331810595769790638455e-11,
2.435741542515808564619809459523273431571e-11,
1.40212517716056637184468216162198433895e-11,
6.457021706780494637528772928840444952568e-12,
2.47797107885600094841289896937939598038e-12,
8.151039148928046012568892819555531806872e-13,
2.346047862890019091458627698458321085441e-13,
6.002144391394294300992157283525244889251e-14,
1.382024955010253192185929638354464091075e-14,
2.89283786859525782739764859333757604338e-15,
5.548992408561914487236687617977423774404e-16,
9.827793230755972793812252197665441289953e-17,
1.652291414571746303759995842734806184116e-17,
2.528376268334498452278903255529943320177e-18,
0.00009288476368986509182080098735159856505788,
-5.807446848149818535905711920393475916443e-12,
-6.686069875911087166440647873009505524714e-12,
-5.13174767001965766907185620023846712804e-12,
-2.954070724224253620314379016718524392817e-12,
-1.360399200438399078441024161533327480849e-12,
-5.220719937083599035195869711729355535554e-13,
-1.717304171651009633426339418268223930747e-13,
-4.942779988099088909530157120259153089083e-14,
-1.264565070810127570494099269401449848446e-14,
-2.91173127269539539155432828198699512123e-15,
-6.094819176383403443564697724687358952557e-16,
-1.169104927558231229988470485967185447365e-16,
-2.070621232275814923085210402234247547713e-17,
-3.481315563799028622705441316806192535268e-18,
-5.327467286965480075879265616721912524368e-19,
-0.00001912735635669304317998451500130670392367,
1.102189199968129816949117607634014761589e-12,
1.268942142178462502652901458467884396565e-12,
9.739489815518142068397921767095062818386e-13,
5.606499803727747578665283813579220284295e-13,
2.581887458174343039605855482237479092487e-13,
9.908350721972954577719425223253579365224e-14,
3.259254459090658205395746850438496691253e-14,
9.380855823629514111787897887466538932225e-15,
2.400007724897038974979588475867364170455e-15,
5.526158045033771339410633111237139180463e-16,
1.15673517119426217743824221681677935961e-16,
2.218854364025452631979850532758137821671e-17,
3.929889882256843263242172177739917694976e-18,
6.607439429001134915257408865688386110513e-19,
1.011181724850427486603850139906995219656e-19,
3.563948742906008353248028751077034500426e-6,
-1.904272326214136695218883945343783606035e-13,
-2.192374426410704162233228058696653457552e-13,
-1.68270938978430765695010674208480045741e-13,
-9.686451960936750671026640733289870929842e-14,
-4.460774199378286451248761665798027896084e-14,
-1.711883997581515317566863808167312100802e-14,
-5.631074696223652036216090463692415045554e-15,
-1.620748386892743255545827228411956738346e-15,
-4.146541440392265700503219745266144615509e-16,
-9.547664272998991177910975492525266319921e-17,
-1.998520989202043093614440367528816355978e-17,
-3.833587896008753508549607841445941459328e-18,
-6.789858768591088389012172232710281597352e-19,
-1.141621340878863817891688760603094635952e-19,
-1.747164728110734217434740043728410967472e-20,
-6.065058097655610497143365599366980819249e-7,
3.02067353660473301528732811926179219727e-14,
3.477678767305960145693817703507235048238e-14,
2.669216849121689704006915700758859678162e-14,
1.536524447527944609324769657937023655723e-14,
7.075953958587304684963915507783877758466e-15,
2.715495675429559066909548217084265252084e-15,
8.932358015991290870011278936262701128061e-16,
2.57093165410210980401746715999063434633e-16,
6.577504346634860134797265986162196634454e-17,
1.514511842935388520932711173193806919783e-17,
3.170188229253006491171674058696748684059e-18,
6.081116859857327214535003588005112074852e-19,
1.077064874761369053769796625163415562171e-19,
1.810966880197648662897005330090547085808e-20,
2.771633356619552919670577237193297169607e-21,
9.49881996229910391350145943815604008754e-8,
-4.429990553573130069347493271648420372493e-15,
-5.100214885485587710688328685713068289731e-15,
-3.914559251243252644184990991733691076417e-15,
-2.25340105576654019721508556239793456861e-15,
-1.037729177976299174490818474612260611582e-15,
-3.982430146091819916929080696646459282179e-16,
-1.309981662325554102681614807405406913926e-16,
-3.770419846906573764210738148159049450328e-17,
-9.646294095065259293317194267804506236683e-18,
-2.221121803601698252081081127793299181716e-18,
-4.649277242234601385536842483415146703356e-19,
-8.918362488498005373649530928498852443487e-20,
-1.579597374342606898663262398010021750617e-20,
-2.655959054159256353380005178163911049235e-21,
-4.064979254305063602771023526206950484596e-22,
-1.378397316939512188945364294009591445274e-8,
6.043672218284702685102544253873523885051e-16,
6.958034497373328414695521062133823384404e-16,
5.340488405365298306839958767595402174965e-16,
3.074231751246841468705096531747927555386e-16,
1.415735583156187974059239875644205582111e-16,
5.4330825720847928029013920556030600277e-17,
1.787159824454448174702575192495914152199e-17,
5.143846087509720375752268096506123281603e-18,
1.316009131217117849913068743146158563396e-18,
3.030198528874847388933952815446043462573e-19,
6.342854642756993869847613639580934931672e-20,
1.216705967802236461377995039623455085787e-20,
2.155010265843430542118796512785916511192e-21,
3.623513221450030240062833522205253110652e-22,
5.545963800438455791075525126892359193864e-23,
1.891696652281042859896093910259544718742e-9,
-7.81352252978160539743561073816246975253e-17,
-8.995649909260759257391294889520217994563e-17,
-6.904415937247197917752325876621359196009e-17,
-3.974500700294116926015794786184197088931e-17,
-1.830324657592799495654153877068780303316e-17,
-7.024126191562211273420753750381178596475e-18,
-2.310518375793969358165031688987387188127e-18,
-6.650190216150346665891181986276801337873e-19,
-1.701394959464801550861120798572831905686e-19,
-3.917577492367294250908931217663648930159e-20,
-8.200339238745643028165016368887211130496e-21,
-1.57301833098783057615357128811781242205e-21,
-2.786119073109918430127009873733970928854e-22,
-4.684736536046408201477842247679509799368e-23,
-7.170370064572707814080835149177063867998e-24,
-2.389484772274458610640342787811718354501e-10,
9.343709024895107876921757618447469745038e-18,
1.075734217189033351864335792516795223135e-17,
8.256564650580383744711297691075235993577e-18,
4.752859990337747164196230997783007576528e-18,
2.188772285711338878949933621551054926601e-18,
8.399719251210930938919314835982237321237e-19,
2.763006596459461860089267178257995989768e-19,
7.952553906209146975891740113116069553205e-20,
2.034594255623587995337606502473560323379e-20,
4.684794060697078740804671442044818529823e-21,
9.806300565410209858996608631935461982262e-22,
1.881083623389447340786702990851427277122e-22,
3.331776642777678895170217880709822409245e-23,
5.602291330002735219396139503359916159529e-24,
8.574919476285442128282570738322664538613e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=6 maxabserror=1.33501617235272872615e-20 maxrelerror=8.51676787441045317024e-19
0.03256703208877921523107191459224644434223,
-4.949780448885828041300644762362373461324e-9,
-5.698644420226035157941709583997489184944e-9,
-4.373869822542786477858422468855953359775e-9,
-2.517800241747622545122367246675784919876e-9,
-1.159488367511261877514426356057561186592e-9,
-4.449689590220486549975898784153093305697e-10,
-1.463676591162325290780594484704416493978e-10,
-4.212756405425282193675906186097683624947e-11,
-1.077781143242723528339867246103957923172e-11,
-2.481586104867333357187209265391866473629e-12,
-5.194170537322097698310251740830566627927e-13,
-9.9623980189359934356268346570611780255e-14,
-1.764089041316352533321017673780380402563e-14,
-2.964532554100116075320287814949456454308e-15,
-4.532637216266584359223293890545820871313e-16,
-0.05549200087921175420491714872321685350169,
7.020784890627188433149554488409570154006e-9,
8.082976267060110016252085941214207449199e-9,
6.20391194432688541920687710744305432261e-9,
3.571256938044970695073539167390479668437e-9,
1.644622891758996318870022089453283020954e-9,
6.311460496828061857330634849849456066685e-10,
2.076087793429456541373520282292338937409e-10,
5.97541132523336481576858035520018499116e-11,
1.528740531394708201998162720244506962479e-11,
3.519946243600506050123485777955338687082e-12,
7.367664679676092715259226751752515869773e-13,
1.413160050257022757556926757841551676473e-13,
2.502509769554186809173255703394636168441e-14,
4.206056512854424505183190517193316256607e-15,
6.432613570863680743397403102244399169045e-16,
0.04831058601984544787112704377660436704976,
-5.229085038947001794750472722823168516555e-9,
-6.020205978033428486431886677996709805103e-9,
-4.62067784593214919748127732547501046247e-9,
-2.659874829072839276029639132354436477528e-9,
-1.224916564346162807982837469953022105894e-9,
-4.700782886317820261378825789320912775101e-10,
-1.546273581290344325271567485809119045901e-10,
-4.450502190501511740288025589521336555966e-11,
-1.138613105308554536992342528439485231881e-11,
-2.621686751634324560119371518956868051844e-12,
-5.487560990757037503738229785615908851657e-13,
-1.052568239351729868188608754506722307884e-13,
-1.864033097022316822671080911801284662824e-14,
-3.133258386708779761941363541534573298163e-15,
-4.792791819174973879536395415548033922378e-16,
-0.02850703836357026759149430741046333663322,
2.694136780380589668811158778012900888411e-9,
3.101739306180854845654594323771260562582e-9,
2.380672453675679951076603023875138075777e-9,
1.370424716244599752364400408311730935066e-9,
6.311034352371098602076390071635047978199e-10,
2.421945335057819635533796320650118295976e-10,
7.966740909005425629976393860063561074105e-11,
2.292998680276779770353396587372672558608e-11,
5.866401998538059063271867774935224369368e-12,
1.350759883561484306840474387745119322276e-12,
2.827353686115931585633275575935878830827e-13,
5.42322763411510280214384005956658193232e-14,
9.604502358716141416083151832036360618746e-15,
1.614539663026260255349715508095181219688e-15,
2.470010789912891317138522734722597101166e-16,
0.01278195692886034914643654395456149462995,
-1.071505310768825412756372787460179473651e-9,
-1.233615977495693246746681931549174382735e-9,
-9.46835099416596720406283461640510489321e-10,
-5.450419190564852395970831591715110638865e-10,
-2.510009162730274388998576060168675011913e-10,
-9.632503602625149596636264405401642676817e-11,
-3.168514497371757691478795387965046741111e-11,
-9.119670201866569932564233251767859809856e-12,
-2.333177580202372905330650186816413027017e-12,
-5.372240193380853919905297624086053330384e-13,
-1.124501381497390986410594714319854901576e-13,
-2.156963599480690451079155321856558526185e-14,
-3.820059911908558622050454727788272978749e-15,
-6.421960385086691058395273869956520587201e-16,
-9.825651622359735136702777081329511334061e-17,
-0.004633628747966783673897008860271835667714,
3.488918528042675842336312825868208891393e-10,
4.016765606469188284955369350972194186615e-10,
3.082981090359631215275517740365168571356e-10,
1.774706062286995653576979986756461783995e-10,
8.172818723202938236839158603849479554953e-11,
3.136431467991745318374463908692417636052e-11,
1.031697663784501692328707360490683142874e-11,
2.969450799707862568825286198719436663004e-12,
7.59705551698558699105172415251440856656e-13,
1.749258274505441237234709986731006914615e-13,
3.661512552382435689322295193903533464053e-14,
7.023399205514326372305439542671084886772e-15,
1.243892280458311222429139589786316812195e-15,
2.091214789877046759662928041103519275171e-16,
3.19982641327094529550068147418502400017e-17,
0.001412046687427430465415215803129439690588,
-9.647598142577334140653602624703507719667e-11,
-1.110720711151233629087182500413034103647e-10,
-8.525095398837195707271395657797801976264e-11,
-4.907438120080325688448355635023636873677e-11,
-2.259957597381620562848814636763317620925e-11,
-8.672898776028421550687343899968305944671e-12,
-2.852863702135479769988369596015010418316e-12,
-8.211167520145759253189633979343719009203e-13,
-2.100750536995855410713164440483772424075e-13,
-4.837087342553966896118744062953247254311e-14,
-1.012493254012124938232477616736565047125e-14,
-1.942147343003930056852958955741997275397e-15,
-3.439727630777449465832132307773539561724e-16,
-5.783019951022734465248785146740272804302e-17,
-8.849316939203841066455159491702989091312e-18,
-0.0003715390559036819762254537718101577023996,
2.322978743507315425447722692143192060467e-11,
2.67442795525442086007468893744141150683e-11,
2.05269907176106576439372175818186617162e-11,
1.181628291850218300342528740041080136668e-11,
5.441596811703141410018184086638915753288e-12,
2.088287978651716580504740578776578436936e-12,
6.869216699163892944172295416394334448088e-13,
1.977111998854644357411627805547838986866e-13,
5.058260292489209511831730336616085473592e-14,
1.164692511207736190980026081671353479561e-14,
2.437927675011039213469668381505823508485e-15,
4.676419718783836590984989159906188963909e-16,
8.282484944248699452335853630554691060335e-17,
1.39252622806629838926150093970930072042e-17,
2.130986918684238901388419830536732655564e-18,
0.00008607310347678267685357627593750101795098,
-4.959851395322786750158352964525836253819e-12,
-5.710239634583354245904064946575021105695e-12,
-4.382770412976875649760468823670120880101e-12,
-2.522924909371281788738544646220029090035e-12,
-1.161849355116408164599427779897643458013e-12,
-4.458757820812078732170081449594168304189e-13,
-1.466664505250117130438377231716375128372e-13,
-4.221385116774504829791481368055727486708e-14,
-1.080003475216431454424798971949644680962e-14,
-2.486771117992015598799536778786721589465e-15,
-5.205308265615903963901356489433956440837e-16,
-9.984844628986989123426459478961465259811e-17,
-1.768450445398895614425084313503087668691e-17,
-2.973347740332055077124853937833892062543e-18,
-4.550317757665900237654622767875637491259e-19,
-0.00001781973150743627944225869400783531024878,
9.521357099828135657960277485718917135589e-13,
1.096186691526792595721044227547494619499e-12,
8.413542944890895026743081229328398040791e-13,
4.843223675563370064936342748912418956994e-13,
2.230386038241449860804122066577164396477e-13,
8.559415914453725718152717236944841896042e-14,
2.815536008188405968718492085984929357734e-14,
8.103738077862526420750905681054163956409e-15,
2.073269733516805266692019519000867329919e-15,
4.773829864600960426440969377681257542915e-16,
9.992600190424092237938391743072136464623e-17,
1.916793035767144723116210218369840328686e-17,
3.394927768534021888641892670331584146244e-18,
5.708103987511321879742668627531154748484e-19,
8.735819481998826800483004489931237766504e-20,
3.335782775119305715356782281288741271735e-6,
-1.661370735314390689739000188908811561069e-13,
-1.91272365610239644298187750381982788053e-13,
-1.468069523435949749690410895993644983808e-13,
-8.450885937470040250261915158860210943015e-14,
-3.891775356976514982763699278160334458447e-14,
-1.493522882351168199283834419081581818464e-14,
-4.912797766885261549801878967658596401253e-15,
-1.414012656733818014124663034129309850358e-15,
-3.617628022521100183674360618262735924024e-16,
-8.32981659107482068911999201684670754491e-17,
-1.743603830638487768473221915608174378543e-17,
-3.344614857122336797954506690528123000587e-18,
-5.923857845932064918628420984979260567646e-19,
-9.960319581011114955945174994290092955871e-20,
-1.524398612463466349769514700207310807494e-20,
-5.699984551566528879474563389161959037388e-7,
2.658251410555879395103963904956528722912e-14,
3.060424903740923424906921624611576571924e-14,
2.348962717980658649981510901494915207407e-14,
1.352171401414258411478783952952845029262e-14,
6.226977276379088736987094275240940194048e-15,
2.389689193590451858643865824416507266861e-15,
7.860650174673996203537738782197171494189e-16,
2.262470711021786603984952323571237699066e-16,
5.788336245997791827658934310664921279362e-17,
1.332801977505201185361242251873224339142e-17,
2.789836151804732642213810640501908178351e-18,
5.351535047603349631493350657559841580436e-19,
9.478500942530531057785802597106411034542e-20,
1.593729573873274050448910766533744353352e-20,
2.439223486694305793749613898608851759544e-21,
8.959323676380264588021537641606589779411e-8,
-3.928295485653933783124681138187681851147e-15,
-4.522617130418829304811124553937594286343e-15,
-3.47123664822541561903113496157377220415e-15,
-1.99820411731202713342625598030058339902e-15,
-9.202067053455431004375715942705123653922e-16,
-3.531421455387400112788700420570927868139e-16,
-1.161626841578534196925961808649508369831e-16,
-3.343422117241793304827606140943353230838e-17,
-8.55386020662610509346257334494140459743e-18,
-1.969583188915972908219898242712472570744e-18,
-4.122759533359189816667634140556356221446e-19,
-7.908404668876692511188996781035056259152e-20,
-1.400724060884082879324561231198250520837e-20,
-2.355228756973809094717672899618761088068e-21,
-3.604792533688561669889970710520550825062e-22,
-1.304295908184618540874041554000362969586e-8,
5.395629906824546706991247701461960927255e-16,
6.211948259450344881809510336285227019722e-16,
4.767846124716047174507366605412911358353e-16,
2.744592436149164178860486119261562271458e-16,
1.263931141926191121303888769443382232017e-16,
4.850512062801865617313113600927031017092e-17,
1.595529027765726838870043723911205670198e-17,
4.592290459026687276893729569224818595697e-18,
1.174898691654161241826748476799894415232e-18,
2.705284025674664805316429051405058474239e-19,
5.662745960781352560270301310019708922492e-20,
1.086248073599682339909428329674098098257e-20,
1.923954778566232924204873628848294404752e-21,
3.235044406163243792279791557432674308328e-22,
4.951496066068924913876488973319557070679e-23,
1.795300004239814834308270663162095169514e-9,
-7.019038447828983960734187077455567652475e-17,
-8.08096635931321157132412772696901991637e-17,
-6.202370447967691641814960777979686663415e-17,
-3.570370922489055194060538114773251787365e-17,
-1.644216101695261714328044770397776007082e-17,
-6.309908862609107138001515984799156619812e-18,
-2.075583634675827271082187521491620767305e-18,
-5.973996142060337310204250800487330894882e-19,
-1.528396837812439098053868650040565807778e-19,
-3.519239484247542500898429545910480427257e-20,
-7.36653944647775916465569660294927872302e-21,
-1.413078938694728065243285456482110909938e-21,
-2.502846444281017879168141775151943075675e-22,
-4.208467979258758427186209577761797971881e-23,
-6.44152074951376859482858208345785228271e-24,
-2.273584218500235904067324358846144487718e-10,
8.439198453435936333765396975937720685801e-18,
9.715985948544252715067266042104616736392e-18,
7.457294297449495524328588825671783887492e-18,
4.292763088860110031765784492818505996162e-18,
1.976889923208545184113072376076503283149e-18,
7.586591332686089978426779444777623855677e-19,
2.495536165997722503783825413590714157947e-19,
7.182714775924590581767897873100543361067e-20,
1.837637815642393852163130745633589993293e-20,
4.231290294607744090632023333946980098357e-21,
8.857026450919708626917651913139531744779e-22,
1.6989933718538488971223954650121990898e-22,
3.009269986668030495856291055662487208094e-23,
5.060050254919714394784011357506633532111e-24,
7.745087558560144229436111436584537012442e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=7 maxabserror=1.27610683886270082457e-20 maxrelerror=9.74958294352225490828e-19
0.02774600043960587709112087393060665518683,
-3.510392445313594216192699402137951126868e-9,
-4.041488133530055007686159612328413442849e-9,
-3.101955972163442709265815619929461651037e-9,
-1.785628469022485347342418223908224731182e-9,
-8.223114458794981593455089578899251173528e-10,
-3.155730248414030928321840641664722291105e-10,
-1.038043896714728270573776748912614693101e-10,
-2.987705662616682407559098476808993355879e-11,
-7.643702656973541009158837343219378397467e-12,
-1.759973121800253024870174345068549024804e-12,
-3.683832339838046357228617373303282314607e-13,
-7.065800251285113787015423252814007129826e-14,
-1.251254884777093404450383788098565252951e-14,
-2.103028256427212252362499062172702321268e-15,
-3.216306785431840371348029143958840763838e-16,
-0.04831058601984544141726688272886801689202,
5.229085038947001566743804949726548698057e-9,
6.020205978033428223929517967107987729906e-9,
4.620677845932148996003276603709528814454e-9,
2.659874829072839160049593805338734204256e-9,
1.224916564346162754572066529990547835027e-9,
4.700782886317820056407523026810387353566e-10,
1.546273581290344257848227462448104207877e-10,
4.450502190501511546228456244382246266951e-11,
1.138613105308554487343805402502101743301e-11,
2.621686751634324445800073373670026376144e-12,
5.487560990757037264442444312862016055986e-13,
1.052568239351729822285769682282097061573e-13,
1.864033097022316741367338767052724550857e-14,
3.133258386708779625229034562097943013182e-15,
4.792791819174973670276698546975561351428e-16,
0.04276055754535540646738263874571908621848,
-4.041205170570884674413882390071590716816e-9,
-4.652608959271282465579881573801682877557e-9,
-3.571008680513520077893193213362648693681e-9,
-2.055637074366899715629373043118010063038e-9,
-9.46655152855664830414547414456447182335e-10,
-3.632918002586729607201910221981074247118e-10,
-1.195011136350813895120787333400154340393e-10,
-3.439498020415169801238336432669372612095e-11,
-8.799602997807088967690370460520144360359e-12,
-2.026139825342226546096591175474481156076e-12,
-4.241030529173897558123694347886234578789e-13,
-8.134841451172654547874970200477853847912e-14,
-1.440675353807421273459181263808783793401e-14,
-2.421809494539390485675421868530068667325e-15,
-3.705016184869337132833135234927626032019e-16,
-0.02556391385772178287883733332942189962471,
2.14301062153768914150453434044760103247e-9,
2.467231954991430606407702296918648029306e-9,
1.893670198833227298723375803497349465596e-9,
1.090083838112989969371834539295396294759e-9,
5.020018325460638533559161805646913705499e-10,
1.926500720525064364279369811416841426828e-10,
6.337028994743628686317008916483388401394e-11,
1.823934040373346597773468868084436433929e-11,
4.666355160404829243876645711226014338867e-12,
1.074448038676189995074023127215848722756e-12,
2.249002762994822185923063510317848525547e-13,
4.31392719896145804081505073629946719635e-14,
7.640119823817253873154678309165756241019e-15,
1.284392077017361185869082723629053379123e-15,
1.965130324471982192947869087589006051814e-16,
0.01158407186991659336688628910166114532662,
-8.722296320106566329181236468252416863173e-10,
-1.004191401617282878489347890498822109085e-9,
-7.707452725898969104817419517036541423894e-10,
-4.436765155717426426860868879766864210831e-10,
-2.043204680800705681538611373731547125438e-10,
-7.841078669979252473831837592510522002647e-11,
-2.579244159461217776953875977836540831473e-11,
-7.423626999269551499604555352067734776618e-12,
-1.899263879246369904213623844774231718276e-12,
-4.373145686263541283875206350594751347895e-13,
-9.153781380955959842739050190596465503807e-14,
-1.755849801378556774650605900156634752882e-14,
-3.109730701145734097195247370018714816783e-15,
-5.228036974692542981722489535234306395339e-16,
-7.999566033177250094992129978196611939021e-17,
-0.004236140062230218308204461607207503447686,
2.894279442754804390434932558420444382022e-10,
3.332162133432521880924028182043579529034e-10,
2.557528619634903225135244560088878221338e-10,
1.472231436014740297201053289149095208145e-10,
6.779872792101769237159880584152006028948e-11,
2.601869632791989134355697333248027958289e-11,
8.558591106352041349565830832324376821624e-12,
2.463350256028070816859787795409934546018e-12,
6.302251610947509196158985601888332090432e-13,
1.45112620275696665057210616861857876316e-13,
3.037479762017068143333745462684302387482e-14,
5.826442028974755208650305851799348793756e-15,
1.031918289226675156158152089644340184826e-15,
1.734905985295790224553765037240946799858e-16,
2.654795081744268995857600756556349004086e-17,
0.001300386695672643077262071345109892288875,
-8.13042560230848090492973379382752151599e-11,
-9.360497843428323957286538547292197735427e-11,
-7.184446751192781849056848143537479396266e-11,
-4.135699021492487536834655944887301025585e-11,
-1.904558884103800941364720493260375285189e-11,
-7.309007925310563415672898613371385369731e-12,
-2.404225844717084490416116928609736860248e-12,
-6.919891996019237245734402384873342785192e-13,
-1.770391102378382292689759845088116869472e-13,
-4.076423789243560699195029039615605327772e-14,
-8.532746862573142027059689120709596608172e-15,
-1.636746901580961685866887481480575897603e-15,
-2.898869730498768295368303023044507330569e-16,
-4.873841798251757561167838871922726660964e-17,
-7.458454215425010706102303302264247597019e-18,
-0.0003442924149984081323420449931992460421198,
1.983940561984199609528661653619781335166e-11,
2.28409585827167207791615859260288558346e-11,
1.753108168597294497239715518236132701658e-11,
1.009169965709476957956411847488377604878e-11,
4.647397429496204398730492307363211268862e-12,
1.783503131790439687230108919418709243007e-12,
5.866658032400253591293124757828910568456e-13,
1.688554049990917018690703453007544059829e-13,
4.320013909260187620991316807367623862567e-14,
9.947084491296909481498335530167648199752e-15,
2.082123310292320339433301248999876999564e-15,
3.993937859355943368427453283777594300844e-16,
7.073801795342234479814099544324986670319e-17,
1.189339098444323054181221384888800106807e-17,
1.820127106604475608512246832512334177522e-18,
0.0000801887916608039140357422522000704463379,
-4.284610690789240031451839007938802222844e-12,
-4.932840107111790020831984706582690199599e-12,
-3.786094321548406919791403011229301372267e-12,
-2.179450651900971167190511291368019445531e-12,
-1.003673716240394753038717339367841025071e-12,
-3.851737157788352210422650178352729829109e-13,
-1.266991202462497914654006793591649185361e-13,
-3.646682131520125473739436672438648996552e-14,
-9.329713791825080431353794149063232936209e-15,
-2.148223436997992080378698359058662644702e-15,
-4.496670081352758730827409472786673526892e-16,
-8.6255686526306244510245224106864662119e-17,
-1.527717494366384862998489812699530731201e-17,
-2.568646791901670455964041295706984950222e-18,
-3.931118763105803420776863099113387598564e-19,
-0.00001667890223332814513183876674251489459963,
8.306849563844870899172538871569233264074e-13,
9.563613545560098668391128835906562739334e-13,
7.340343982970108277731798493995634788155e-13,
4.225440876716053667418443179635410487488e-13,
1.94588671507816822362007775181625645824e-13,
7.467610714534894276099852806193477954584e-14,
2.456397667277334986563392617390391804756e-14,
7.070059783271252920703796953697607070007e-15,
1.80881311571269014489049057002278974934e-15,
4.16490623347458237181599077100733182616e-16,
8.718014836835071754730579641947029866862e-17,
1.672306600577266741478061733452355894644e-17,
2.96192745642950994310506176906422799613e-18,
4.98015732452280448649091968336932850612e-19,
7.621989287743243044043664773523742132577e-20,
3.134992288437230925265318937148922693381e-6,
-1.462038540361908524853716829949805349785e-13,
-1.683234001639050797422063846679932914208e-13,
-1.291929728664321374214206673335538512457e-13,
-7.436944053495096325304675978283644658563e-14,
-3.424838121733778023096494391192853501703e-14,
-1.314329294302996933540202972228916252406e-14,
-4.323358378383901751246148600753736106786e-15,
-1.24435911622937785817137498048542574027e-15,
-3.183585511371072964284447954735031240013e-16,
-7.330412202726666452125493538023453303509e-17,
-1.534410161147983724336653451799369496633e-17,
-2.943344808794245672158980593631119438899e-18,
-5.213176461765224058498649085993081991306e-19,
-8.76551424259793091529998692007463665079e-20,
-1.34157316049247553361601809387044023334e-20,
-5.376254734815428202079857510437347967448e-7,
2.357210625739575208010405440634073258883e-14,
2.71383891433744337267984273504270386151e-14,
2.082948174737779399707598615099074351099e-14,
1.19904116046076193324212470686260434755e-14,
5.521786819920613476989877933116462976137e-15,
2.119062633962682333801681466105094123895e-15,
6.970451037232876057407504278246031884769e-16,
2.006251864374772158873419023233012264698e-16,
5.132824210389195613127439084100443673066e-17,
1.18186690387054924518218977340584257055e-17,
2.473900607266425341748370554702928000195e-18,
4.745512555529181379350188466822959781423e-19,
8.405176400437927015503980553634188417463e-20,
1.413277160982454317787201757990772288416e-20,
2.163089669552309769106694692344709641699e-21,
8.477675970529711564547199057323290473793e-8,
-3.507076059561488606567512232450260416499e-15,
-4.037670374017663107364129680830976917156e-15,
-3.099026302472386568994751033427477327947e-15,
-1.783942670694649215769526081501742767186e-15,
-8.215357104395413078142070584184434567744e-16,
-3.152757884757503498797006484018593853689e-16,
-1.037069211969758838092193861668411320084e-16,
-2.984917832610609391182958274090384944322e-17,
-7.636659935691921738209240304504647762715e-18,
-1.7583928111730147528861888298760280433e-18,
-3.680697366171286027643882258397772312252e-19,
-7.06044461554094399600902984363729840053e-20,
-1.250540873872829171169456893201635110495e-20,
-2.102728868925916873803178542487341207602e-21,
-3.218395916596388191723757530566659166879e-22,
-1.237738630268881022076814820174597521594e-8,
4.846310552972721325080701099405352145508e-16,
5.579521017656309262473347646583364658837e-16,
4.282440333436497205647230421807690041786e-16,
2.465170464906494547735816290831560320819e-16,
1.135252627303007808558872693247129661986e-16,
4.356690462527766378741552969043588604593e-17,
1.433091286704772383935854285661234123948e-17,
4.124758765475050980769203723467294687636e-18,
1.05528494890853035556940801983341600492e-18,
2.429866589561127544174060126537197377847e-19,
5.08624312259651504618688693014354694707e-20,
9.756633655468266499404624978325299371465e-21,
1.728095486320338596854722951137508707755e-21,
2.905744712437877361731943607368238281033e-22,
4.447558323063138684200228169760470761175e-23,
1.708233646174090570287651923158607724558e-9,
-6.339661463274034709085128537432723231791e-17,
-7.298804742640591430814288920095770244206e-17,
-5.602039286009994751017772351065281627136e-17,
-3.224792600455754044510678516009225664699e-17,
-1.485071471354048994357770523716059189729e-17,
-5.699169297023932890443963298538833885591e-18,
-1.874686862068702960100208564701611204158e-18,
-5.395770741547581372810161965775870273587e-19,
-1.3804630526529475463370545697026857357e-19,
-3.178613258246266620454469586590061189218e-20,
-6.653540603808212749591734625557269721595e-21,
-1.276311130886282450661927324758668442923e-21,
-2.260612009981085352488568688460316970335e-22,
-3.801191222525331689286687818425528462764e-23,
-5.818234741390157088242015913691545868324e-24,
-2.168388189348548941355081010807820529804e-10,
7.659757763141646979572176098209955877648e-18,
8.818621736906215995089849555446920159232e-18,
6.768541881779158044530365274109320614227e-18,
3.896285408061465377360033738549232148396e-18,
1.794305277824195949667103324266860354557e-18,
6.885897430378136549237712156695225963164e-19,
2.265049778234728161163388300599360591158e-19,
6.519323789897282644152397142813335773296e-20,
1.667915117285483566698110398319177342268e-20,
3.84049353281717039388713145064031611019e-21,
8.039009450777315230012877636389101089226e-22,
1.542080474631576003275712048391775403707e-22,
2.73135424110386892547595753896154890494e-23,
4.592775140007010207355185247925143317915e-24,
7.029964085568717780749781786873338637911e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=8 maxabserror=1.2221701250524951324e-20 maxrelerror=1.089390548964064223898e-18
0.02415529300992272069777608156372453371337,
-2.614542519473500783022146604655623084129e-9,
-3.010102989016714111562087668857825686915e-9,
-2.310338922966074497692576664386613356121e-9,
-1.329937414536419579846886743653498035661e-9,
-6.124582821730813772041026281412486285212e-10,
-2.350391443158910027889341221925348475866e-10,
-7.731367906451721288206881885063271597591e-11,
-2.225251095250755772816546042475383590688e-11,
-5.693065526542772435957431723315789335741e-12,
-1.310843375817162222724673806200452891738e-12,
-2.743780495378518631854147983319687487391e-13,
-5.26284119675864911072470741339602020873e-14,
-9.320165485111583705589502038455688089077e-15,
-1.566629193354389812404798950097354414877e-15,
-2.396395909587486834817334231172178141387e-16,
-0.04276055754535540029900414290926370233123,
4.041205170570884466542880131651557075445e-9,
4.65260895927128222625955337162147810819e-9,
3.57100868051351989420806441030381276312e-9,
2.055637074366899609891726152245960818848e-9,
9.466551528556647817205734472651816328779e-10,
3.632918002586729420331970831833724891704e-10,
1.19501113635081383365171376583959229269e-10,
3.439498020415169624316470442759387325873e-11,
8.799602997807088515050307161924800488478e-12,
2.026139825342226441872946554771080098204e-12,
4.241030529173897339960189946874796782672e-13,
8.134841451172654129382852546796222141723e-14,
1.440675353807421199335044858101205031014e-14,
2.421809494539390361034705154575418219392e-15,
3.70501618486933694204838654104124820645e-16,
0.03834587078658267918317131110253355989851,
-3.214515932306533868971652366945885254923e-9,
-3.700847932487146090036187889021606031934e-9,
-2.840505298249841086566080171150471153284e-9,
-1.63512575716948503377382353494167487964e-9,
-7.530027488190958167444733741254445680167e-10,
-2.889751080787596687301119274830992759207e-10,
-9.505543492115443492893568159700934902257e-11,
-2.735901060560020030042389853542180784649e-11,
-6.999532740607244207062399524035430353305e-12,
-1.611672058014285071185749315039056432323e-12,
-3.373504144492233443359245199294503122088e-13,
-6.470890798442187376726506047393805466681e-14,
-1.146017973572588136856031279205629628176e-14,
-1.926588115526041872771959904164533660974e-15,
-2.947695486707973433258774205980551613019e-16,
-0.02316814373983422334509855180668980237281,
1.744459264021348198153645565822367204236e-9,
2.008382803234605974294116383529379493563e-9,
1.541490545179824688891915445197567128721e-9,
8.873530311435030543779611555725990293458e-10,
4.086409361601493192352857361058267029783e-10,
1.568215733995881897896021038185769299903e-10,
5.158488318922538851489656836291546779756e-11,
1.484725399853940031296191471378238643173e-11,
3.79852775849281587370903127747101685852e-12,
8.746291372527257713557002935947408878683e-13,
1.830756276191228630500192323702776076446e-13,
3.511699602757183876087279417794754340394e-14,
6.219461402291592758559609268742183764692e-15,
1.04560739493852954197452337252550477883e-15,
1.599913206635482080004592504400789172834e-16,
0.01059035015557519545078060715646886739528,
-7.235698606886898127827281823905503739955e-10,
-8.330405333581174780953186898981423111563e-10,
-6.39382154908715834451739896565637917496e-10,
-3.680578590036793340529650399738760959512e-10,
-1.69496819802541587448043189696240116829e-10,
-6.504674081979871388606035598841844842408e-11,
-2.139647776587976967279516640429635259301e-11,
-6.158375640070080995427718119326021971532e-12,
-1.575562902736852726270399781834662789767e-12,
-3.627815506892360045833199311759560527219e-13,
-7.593699405042551922347145501118047046013e-14,
-1.456610507243666083148162839699528707812e-14,
-2.579795723066647649920067370559731448932e-15,
-4.337264963239407896047232361766616236638e-16,
-6.636987704360568914572112723528074646978e-17,
-0.003901160086968159453301015407737634575177,
2.439127680675772922413119231801653742e-10,
2.808149353009188458603238905655842651481e-10,
2.155334025343014558758523785101487502465e-10,
1.240709706439215186652555529389682993182e-10,
5.713676652272115784249782412927740119215e-11,
2.192702377578092073373874269135504293791e-11,
7.212677534101659286468248132730398827299e-12,
2.075967598791496848104076930795739097844e-12,
5.311173307098627188343672287140916067838e-13,
1.222927136764659287363896535246695326272e-13,
2.559824058754340844278019458821208722877e-14,
4.910240704709120476057196260807169118105e-15,
8.696609191436500403546725586201199798848e-16,
1.462152539465471065366509467725438606796e-16,
2.237536264612110407355661809418933871313e-17,
0.001205023452503771300560110827285135668507,
-6.943791966974794397670197278463334152769e-11,
-7.994335503985501300836630065333049879865e-11,
-6.135878590117124850671051884640763886918e-11,
-3.532094879998478151560982825009198162705e-11,
-1.62658910033072150024941664272572023911e-11,
-6.242260961293594116657274897626143989455e-12,
-2.05333031134898830953657000909540499185e-12,
-5.909939174993824488503945727198028241682e-13,
-1.512004868247619036221787968812979608008e-13,
-3.481479571969007929244491397296671043122e-14,
-7.287431586054707156268143915062652074795e-15,
-1.397878250780639165622525142101037905332e-15,
-2.475830628380513893678401246821282246947e-16,
-4.162686844573176515451383591183719605955e-17,
-6.370444873143287306158773243262039949334e-18,
-0.0003207551676862242272002473428411113781374,
1.713844279830350806433175813910737032909e-11,
1.973136046891111752064529393774129311153e-11,
1.514437731725086084284425307158280837226e-11,
8.717802625481863006432782456185502511161e-12,
4.014694873194690277361724625362465891855e-12,
1.540694866274912547399211747936699759138e-12,
5.067964820243099488299049209962373365726e-13,
1.458672855599421173577978821934513799785e-13,
3.73188552438320915174625852234906182018e-14,
8.592893765613961219647369103879931477929e-15,
1.79866803622978252758802097423891480928e-15,
3.450227468128057936355952992885713905878e-16,
6.110869989998348287140142884656325016194e-17,
1.027458718868076599099822508924953403253e-17,
1.572447508468084203500937221596726705105e-18,
0.00007505505993251378060161319024368126736199,
-3.738082299946426574421979560916734847263e-12,
-4.303626091145823705715749212705897201201e-12,
-3.303154788993025975645110357335138418417e-12,
-1.901448392597537965139549914674815208375e-12,
-8.756490208988251640933015615959599636501e-13,
-3.360424818139208126667995998831545527023e-13,
-1.105378949155911781238018184963464183913e-13,
-3.181526899251648579709169021755060949833e-14,
-8.139659012467936285086347215245547245208e-15,
-1.874207803166433112966400541658455689239e-15,
-3.923106672604662289328195232733666987869e-16,
-7.525379694980088943056409617145760713406e-17,
-1.332867354044029467704297787673899034129e-17,
-2.241070793766465338043991771647806727257e-18,
-3.429895176011620986268462074329532291515e-19,
-0.00001567495031486586550911903114105451369243,
7.310188952259588172749692579476982789646e-13,
8.416165691366470930953706361392110056331e-13,
6.459645330033274881982015601120652538662e-13,
3.718470119465701332437776416450986941654e-13,
1.712418182531354504967522070499522023923e-13,
6.571643100779455583348658861541898562695e-14,
2.161678080420840307653500151337369446069e-14,
6.221792389853406548388865070265733529054e-15,
1.591791939219309214234906121094781473379e-15,
3.665204221390859164504068266219187602999e-16,
7.672046870535147226987494533050008691192e-17,
1.471671649526510281426818076791595989196e-17,
2.606586893841120509647373227189533909347e-18,
4.382754873045971806956714350288083373029e-19,
6.707862361111892516756387056907511626184e-20,
2.956940855964529738914040372196798194241e-6,
-1.29646608633363300852224395359510215405e-13,
-1.492611681702007208699758567006669484059e-13,
-1.145621710105271852852804176679667448365e-13,
-6.594727614414153917558276349271541290411e-14,
-3.036983318257892753271572281660399200622e-14,
-1.165484666389390939052081731497667541692e-14,
-3.833748786613992673469794259798789209805e-15,
-1.103438731526220085532574465031373114468e-15,
-2.823053843055487877433615659065530130138e-16,
-6.500269185530199544656973736976952016954e-17,
-1.36064558816488608760582581874691617188e-17,
-2.610032393100160386636499624494294992935e-18,
-4.62284788381751073377853269481071294039e-19,
-7.773025837528628223994023997875834598731e-20,
-1.189699540530007679171548371879298064294e-20,
-5.087236895848286362473156208413210478659e-7,
2.104458365555602992891892171928360819696e-14,
2.422847138657794649576398649043826424548e-14,
1.859603760103469098378597028008081557344e-14,
1.070473811595606857295965560588830398043e-14,
4.929712584199282650831381309435163711166e-15,
1.891845968727510695462460833241405040177e-15,
6.223044330452822109304086631354619963266e-16,
1.791131756837854523776029168909497518615e-16,
4.582459181573932163288450905180021070775e-17,
1.055142346491921387133278079064778881843e-17,
2.208641682603140535271366560174133880669e-18,
4.236695043359117481146914927983624632191e-19,
7.504003810526292380714713443670108750491e-20,
1.261764875451121461421103714736639234624e-20,
1.931232794154665443973891974239439110023e-21,
8.045064146471265766965840953845669915189e-8,
-3.150025532789237193160741663914139867694e-15,
-3.6266007871839473966036543283572748133e-15,
-2.783518770725557806788841873646297199831e-15,
-1.602321977150513791376478572126361600887e-15,
-7.378963281600622712031230246172026683959e-16,
-2.83178018522470937319046647506317300952e-16,
-9.314867659735781708516144293114038630458e-17,
-2.68102823489260701558563386893798950382e-17,
-6.859185966229520435028081676529813094313e-18,
-1.579375014064331351535675927807193324331e-18,
-3.305977923700090256036928010687638264549e-19,
-6.341658212532667889538001811506741132242e-20,
-1.123234848848490883425358737365893192451e-20,
-1.88868829660078425431802815827641358667e-21,
-2.890842855409466636100084401605060590721e-22,
-1.177631282535653627548365526162484400191e-8,
4.376664472359123669177348728071664143075e-16,
5.038821014561034840827003267137974674112e-16,
3.867437788993758408495750328035461880727e-16,
2.226275848073027391635892152798892124096e-16,
1.02523763781495828152832733143373420832e-16,
3.934492700211519917514113972917590387256e-17,
1.294213486008327667118676807822254744106e-17,
3.725037702072528680837395234690455641541e-18,
9.530198990678883032278177361287728654711e-19,
2.194395312090133500212574857885486135235e-19,
4.59335464349922600738266709636382861886e-20,
8.811172483696299622539675428618435364425e-21,
1.560641445826597688958546587253242745253e-21,
2.624198791626184206701538382874157828598e-22,
4.016687846783333476874561381739891968303e-23,
1.629207604093637104049838011944798491264e-9,
-5.754212817703155350344469841407642168372e-17,
-6.624782114834612229767608865014799859383e-17,
-5.084707853461402739010998554964922172345e-17,
-2.926992749710539579819505541488156348488e-17,
-1.347929627612828772943469992268448636193e-17,
-5.172868449164762910575400099577900186104e-18,
-1.701565359329570077811001884888017071892e-18,
-4.897488627916514493520041457450037674222e-19,
-1.252981994381288180494177135733733229158e-19,
-2.885080422999987280076481162422571884188e-20,
-6.039116755669372917588018927019348897983e-21,
-1.158451689304557820931157315472237478923e-21,
-2.051865656797603487275858497705371099933e-22,
-3.450214421033125521299840941817065718857e-23,
-5.281095576785772344690434601707152687597e-24,
-2.072481310951090100187461883752206939417e-10,
6.983376295357404964709675129829907913948e-18,
8.039908831978340054164732891913727827625e-18,
6.170857697172770081474559422734413797167e-18,
3.552230800923952925092491196202879833627e-18,
1.635862336984256558678763967683700830494e-18,
6.277850642969668022181790446309298386599e-19,
2.065038733988664670464081151544513461547e-19,
5.943647512968081215748715272634694680232e-20,
1.520633400826086076749323834298385986454e-20,
3.501368264715115266289277268960599877904e-21,
7.329150452114177311810107257204321359712e-22,
1.405914207234178941636062315951082248859e-22,
2.490182556947859903540487661672707247539e-23,
4.187275000844528877368757969665570494521e-24,
6.409368078697987487287636270535799584101e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=9 maxabserror=1.17260252627582822629e-20 maxrelerror=1.19558920693809088455e-18
0.02138027877267770013908605962258378652655,
-2.020602585285442232950076364509033595611e-9,
-2.326304479635641112759793062106830058624e-9,
-1.785504340256759946820059295488567014922e-9,
-1.027818537183449804782395147239969038685e-9,
-4.733275764278323907850069772124157606794e-10,
-1.816459001293364709877088841845005075882e-10,
-5.975055681754069167308271186167229117395e-11,
-1.719749010207584811884718066371648336303e-11,
-4.399801498903544256825382162967024325148e-12,
-1.013069912671113220775345741841011051857e-12,
-2.120515264586948669642818375438390642881e-13,
-4.067420725586327064044443707890681491045e-14,
-7.203376769037105995529269900456123533813e-15,
-1.210904747269695180324656405860888738227e-15,
-1.85250809243466847072923071362398575554e-16,
-0.03834587078658267327612427298000483595575,
3.214515932306533678685414557438966277205e-9,
3.700847932487145870961067000072692648966e-9,
2.840505298249840918419720797145251284136e-9,
1.635125757169484936981009715462207698577e-9,
7.530027488190957721697457531394068194424e-10,
2.889751080787596516239360335363046468225e-10,
9.5055434921154429302022999392899539358e-11,
2.735901060560019868087129515640571562183e-11,
6.999532740607243792713092856594729041953e-12,
1.611672058014284975778793623982835912932e-12,
3.373504144492233243650907567908632913381e-13,
6.470890798442186993635462036253520774121e-14,
1.146017973572588069002006430624125918761e-14,
1.926588115526041758673768331863004094533e-15,
2.94769548670797325860911097768232059829e-16,
0.03475221560975133968480848326739411942665,
-2.616688896032022441223808237095659114554e-9,
-3.012574204851909127219628902449246466922e-9,
-2.312235817769737160577531949237017886431e-9,
-1.33102954671525465481196893497155525492e-9,
-6.129614042402240125835026193088621658497e-10,
-2.352323600993822976289835214997231746551e-10,
-7.737732478383808703034072919101244157857e-11,
-2.227088099780910169499039055997385194609e-11,
-5.697791637739224124109922041118005333724e-12,
-1.311943705879088729229918294435185745327e-12,
-2.746134414286843096873715401896296328423e-13,
-5.2675494041357761040242086983423477802e-14,
-9.329192103437389651306863846642273932185e-15,
-1.568411092407794399303102634536358568337e-15,
-2.399869809953223252170676373614821782899e-16,
-0.0211807003111513835965542106109245304165,
1.447139721377411602862999276262548288261e-9,
1.66608106671627177141387981538914302815e-9,
1.278764309817459925629906083762107094059e-9,
7.361157180073749339832902441554959516247e-10,
3.389936396050906656076819945394072240874e-10,
1.300934816396003024375862289082030728529e-10,
4.279295553176048493925578214127492075288e-11,
1.231675128014043415407693601544699506895e-11,
3.151125805473775083278266043071736978259e-12,
7.25563101378488042152766558835593962798e-13,
1.518739881008543945135783026085246730753e-13,
2.913221014487396544132889600980885446737e-14,
5.159591446133409327442620420154476156018e-15,
8.674529926479007532279443033563756451828e-16,
1.32739754087214313251100855449266757497e-16,
0.009752900217420062553580533369869602254158,
-6.097819201689328618279712656681917931775e-10,
-7.020373382522851771574142064743720686589e-10,
-5.388335063357444773253628190466470513665e-10,
-3.10177426609798522382883199337015383749e-10,
-1.428419163068004657109688216251326456335e-10,
-5.481755943945136971175437256847835287143e-11,
-1.803169383525384160336099567962495344538e-11,
-5.189918996978653870158767844734282546478e-12,
-1.327793326774634219014493205083703364389e-12,
-3.057317841911596230733293502968984509444e-13,
-6.399560146885743288657917957384281771818e-14,
-1.227560176177259244171149884311575321177e-14,
-2.174152297859088126755608537071930860238e-15,
-3.655381348663615490143216695839654261416e-16,
-5.593840661530180848944144609463028369438e-17,
-0.003615070357463652592983020471460592699134,
2.083137590077085679133599835571513744826e-10,
2.398300651177975010573652518615236810618e-10,
1.84076357702157110074150654376108654399e-10,
1.059628463991734024994769789302581496965e-10,
4.87976730095620079882117281933320258326e-11,
1.87267828837427666079115259944969942433e-11,
6.159990934001565972455552290744191632632e-12,
1.772981752485080501233200812912874993271e-12,
4.536014604709426652084796078454172940362e-13,
1.044443871583004771852248812058728129713e-13,
2.18622947580029931452119337664349948778e-14,
4.193634752311009013768241311297214031084e-15,
7.427491885086795817917081494471011684415e-16,
1.248806053362747304669944325038047395778e-16,
1.911133461928895138678484470236250350957e-17,
0.001122643086910747860897237239285066115133,
-5.998454979433880567536811071025754890127e-11,
-6.905976164150727530568930938766561734982e-11,
-5.300532061062236632376624434852372693055e-11,
-3.051230918932718161578595507487666417445e-11,
-1.405143205624619278359451038179750809144e-11,
-5.392432031987052925385983431651567314257e-12,
-1.77378768709326195426173902783143033189e-12,
-5.105354994621509746787854231117351169281e-13,
-1.306159933540144605192218533663157891928e-13,
-3.007512817978751149743190198948989398587e-14,
-6.295338126833260866580065098390486943562e-15,
-1.20757961385038744161840348033772062801e-15,
-2.138804496509282623577786433377969883134e-16,
-3.596105516054849241864822666952984470781e-17,
-5.503566279663675688581746760772607364612e-18,
-0.0003002202407288779015735228643991865680601,
1.495232923195920801452113127179919096566e-11,
1.721450440162440646176341417012047091501e-11,
1.321261918440220607025677029886967838663e-11,
7.605793586755832308524172787386511079273e-12,
3.502596091131973261747128406888594181111e-12,
1.344169930147986897308124601960152309781e-12,
4.421515806137602886820346715089581280667e-13,
1.272610762438990857038454541464351657053e-13,
3.255863611992971826970560744181667692132e-14,
7.496831228797092716212412326419368064047e-15,
1.569242672418523484972752110099372588746e-15,
3.010151884469319771695971990025096466292e-16,
5.331469427648842465042127639351790210424e-17,
8.964283194357526690524522558745959419425e-18,
1.371958073357616236112604334191301033562e-18,
0.00007053727630420817296701006210764779209167,
-3.289585025040194142472093948858995958843e-12,
-3.787274557112304721502175555619918701683e-12,
-2.906840395442859313243632475938456212405e-12,
-1.67331155199111460128130663953332292355e-12,
-7.705881813247079279707701943305903620932e-13,
-2.957239392225374772291584456507143248321e-13,
-9.727551351613142074367844862823023444438e-14,
-2.799806572475032430925113276630370864369e-14,
-7.163063718916529060151671476339288581199e-15,
-1.649341897882754786585312397339311181785e-15,
-3.452421088092044648230105445552811120256e-16,
-6.622522415870021399129207347510751790812e-17,
-1.172964100988772248032793626942038396319e-17,
-1.972239690786035344366422270229095711816e-18,
-3.018538059309347494732187528563384967362e-19,
-0.00001478469362389152582080763156172509710882,
6.482326999288773242922527817372158354663e-13,
7.463054456837340987021185482772676420327e-13,
5.728105517505656511553518248862454474101e-13,
3.297362061260216808969916267399850259257e-13,
1.518490855090891667716331714681428683608e-13,
5.827420246338332093185476656605608166296e-14,
1.916873378325600163742882461490611898133e-14,
5.517190736285318795679580826234634727503e-15,
1.411526174125284173652627987000308929198e-15,
3.250132871816319273066381900320593025439e-16,
6.803224338489380682964837459282666999145e-17,
1.305015505531210157743201134105572744786e-17,
2.311422717959187374133504936074583083733e-18,
3.886510860663354273338444234115006531479e-19,
5.948494552322753093990008866539696809692e-20,
2.797981013972819663272571129369584619132e-6,
-1.157452323573988273416851114246649460883e-13,
-1.332566182445562908633520629308050904404e-13,
-1.022782264685211465029709993544605490329e-13,
-5.887607095659212252285301669685650066931e-14,
-2.711342442561046002895501746809436070883e-14,
-1.040515482837674268697082456623410797187e-14,
-3.422675039753414501205927344765100626838e-15,
-9.851226556493578885970730771454275270955e-16,
-2.520353034400849284146969726750158861156e-16,
-5.803284021383609290454219397842692891311e-17,
-1.214753158968529869802159345089386563999e-17,
-2.330182721830685539190254889028661284198e-18,
-4.127202889270321016371115254850928678641e-19,
-6.939708149246528210544553260998883742782e-20,
-1.062178241022816684097761550896312720524e-20,
-4.827643057236450670825782955643082685202e-7,
1.890210055080640015887410836896258799082e-14,
2.176184669726547846520726349574224737523e-14,
1.670283340301405658796581718074882520991e-14,
9.614922422610425392507385160409136593665e-15,
4.427834138456906048017326843639631829453e-15,
1.699243172566760635717712938998747447664e-15,
5.589496443650882587537230769217439424947e-16,
1.608782682945740010465232597367854930328e-16,
4.115935617134708730016091191550793529021e-17,
9.477226461479445412017044730326704575724e-18,
1.983791132029898537952377913437674620821e-18,
3.805386975791944260372102900081858762414e-19,
6.740103498605317314323733325915622489487e-20,
1.13332974393638997100822271205084149881e-20,
1.734684446479932862868576112843650169666e-21,
7.65437601770504135797797100003590201786e-8,
-2.844761776102059981533695391489997260431e-15,
-3.275152918248362683502310248671296717782e-15,
-2.513772591675717048051016299422433967773e-15,
-1.44704362777826488071498611839065321295e-15,
-6.663880363437141316570720324742242149155e-16,
-2.557357209480099829793250803614367953366e-16,
-8.41218027639542501432845548318574146418e-17,
-2.421214816927489025656786082052657085747e-17,
-6.194476633410789195641323669111744660206e-18,
-1.426321790131438861235599722926491067069e-18,
-2.985606914684914212809148894930867540297e-19,
-5.727120923938850776873877849923368764021e-20,
-1.014391931720484948735099760059843743697e-20,
-1.70568716263245055506589920560011063793e-21,
-2.610782730975979804268949733227927352879e-22,
-1.123081178492393670702122925327153064715e-8,
3.972018585635409913253592232820198305747e-16,
4.572955244870007453570686304039901242411e-16,
3.509872633111440846752554818880775135557e-16,
2.02044484046849728764661608552231535108e-16,
9.304489943776784307353160124479866629325e-17,
3.570728133556083591919386563997228152756e-17,
1.174556699298679499987363065857608375634e-17,
3.380638910406133225139631015102788730231e-18,
8.64908524248714751413670819418872200434e-19,
1.991513553755775692794930740660460987767e-19,
4.168681926386454387836047524991933824133e-20,
7.996560774101501458248633828566614974111e-21,
1.416361785451168053248411218290650813675e-21,
2.381613480572948842399201628435816937021e-22,
3.645432536180639124239868875307351259277e-23,
1.557158898082608516121392107635879869922e-9,
-5.24616413416624089666688480434467293625e-17,
-6.039869480399992344276040693031863990447e-17,
-4.635770859133508037723325471823407479604e-17,
-2.668563891803256711508027107197259354734e-17,
-1.228918786317678286561912757489492755379e-17,
-4.716147819388821167734473697533850182965e-18,
-1.551331574691193485609661719586942784854e-18,
-4.465082376690251502511005113346561759671e-19,
-1.142354654859635353142879912287061684457e-19,
-2.63035412607556336645620377316194648061e-20,
-5.505922176292855818187253833406067537881e-21,
-1.056173467438463072993787157236456462515e-21,
-1.870714981042228841346102615744222665871e-22,
-3.145632120008289004699975847691373713182e-23,
-4.814948830255376034464368713875733736704e-24,
-1.984686880434761840568735636148366579413e-10,
6.392675428255564489599940477000298799684e-18,
7.359839357668454511193527707372050692304e-18,
5.648885133808266104520434682557124021495e-18,
3.251759295214127126330612210612892166614e-18,
1.497490145776289498125581057582602355849e-18,
5.746828124701869551112656127905782779357e-19,
1.890364056869892144352892405504192059465e-19,
5.440894862120971530602125976427623214913e-20,
1.392008515145039370966398553272449451729e-20,
3.205201328689645506219117967913966646854e-21,
6.709211351157084487861217220428771406726e-22,
1.286996236239451083163926756301293415188e-22,
2.279559297721048486817725085537459764588e-23,
3.833134403540178212633710112520276042779e-24,
5.867364246873681237940243142443895900184e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=10 maxabserror=1.126894350803946168929e-20 maxrelerror=1.29423161389317352344e-18
0.0191729353932913366280530371422527452171,
-1.607257966153266839046417477131104672913e-9,
-1.850423966243572935139417268993234980433e-9,
-1.420252649124920458948044029726260871394e-9,
-8.175628785847424683397912568624090359861e-10,
-3.765013744095478860154667132944642096513e-10,
-1.444875540393798257853324286838703213696e-10,
-4.752771746057721464224997747622730948145e-11,
-1.367950530280009933791388312961794396948e-11,
-3.499766370303621895711373386080903707883e-12,
-8.058360290071424877408409107955936777759e-13,
-1.686752072246116621514492289996150952705e-13,
-3.235445399221093496221226822939543330905e-14,
-5.730089867862940343953483982622807647287e-15,
-9.632940577630208791592209811128838342421e-16,
-1.473847743353986629032601361096106815734e-16,
-0.03475221560975133401787893046938099444242,
2.616688896032022266384340710386825766842e-9,
3.012574204851908925928258729156558726281e-9,
2.312235817769737006080704478836932886929e-9,
1.331029546715254565876455911752877215081e-9,
6.129614042402239716271944682483268327204e-10,
2.352323600993822819114264438304019924301e-10,
7.73773247838380818602006909419730506544e-11,
2.227088099780910020690715195941278657181e-11,
5.697791637739223743395916014564488450482e-12,
1.311943705879088641567707514739638820914e-12,
2.74613441428684291337675984819655948054e-13,
5.26754940413577575203023165191372353413e-14,
9.329192103437389027844865085259615760755e-15,
1.568411092407794294465823452926739117312e-15,
2.399869809953223091694877829292818899824e-16,
0.03177105046672707987966664044864793463609,
-2.170709582066117537053109766814122538514e-9,
-2.4991216000744078099648147905390637934e-9,
-1.918146464726190005756954378892478726874e-9,
-1.104173577011062468505198577035607061263e-9,
-5.084904594076360295103518130013113835128e-10,
-1.951402224594004655909908432706148839174e-10,
-6.418943329764073133466010121437469572086e-11,
-1.847512692021065236104273635195905350962e-11,
-4.726688708210662914000170027424206180148e-12,
-1.088344652067732129792612280219489709905e-12,
-2.278109821512816057036232591767639235948e-13,
-4.369831521731095083475048748275965015585e-14,
-7.739387169200114464571610706516767265814e-15,
-1.301179488971851209447483561421608590118e-15,
-1.991096311308214820621035753236701420408e-16,
-0.01950580043484107745071843832539005559596,
1.219563840337895105204350087760884943681e-9,
1.404074676504604181071569538096461420188e-9,
1.077667012671514917644547104204595075071e-9,
6.203548532196119902647319303508637520085e-10,
2.856838326136078140770244483453585780448e-10,
1.096351188789053807388288395290491515456e-10,
3.606338767050855204212833757114247963866e-11,
1.037983799395755781079836903366905330587e-11,
2.655586653549332416529708291079359591503e-12,
6.114635683823339776688191941143226343225e-13,
1.279912029377179494159777511235246658477e-13,
2.455120352354577640479033295920920285962e-14,
4.348304595718281025501231441350395143697e-15,
7.310762697327407157991296574347210988634e-16,
1.118768132306063137541382103137937342344e-16,
0.009037675893658808531807948449134017556095,
-5.207843975192618599994346927322374889518e-10,
-5.995751627944827465356823269595051541991e-10,
-4.601908942553843276859644786370497701568e-10,
-2.649071159979286434776580951995126213457e-10,
-1.219941825239027805821898702683717636156e-10,
-4.681695720935605712311206145207564699885e-11,
-1.539997733500363224081614184668732256804e-11,
-4.432454381212619888408240049187104537663e-12,
-1.134003651177335846527105574630378086625e-12,
-2.61110967895746399810159187399687529036e-13,
-5.465573689500647954644938549827614406974e-14,
-1.048408688077733007247231759954998711637e-14,
-1.856872971271664864975586629079796929865e-15,
-3.12201513340681093868686262362714302884e-16,
-4.777833654822150100755517607117744171875e-17,
-0.003367929260686519592221408941357231699962,
1.799536493816057755362423717917487707089e-10,
2.071792849228977649293818000425165309931e-10,
1.590159618306205861674933293809357237251e-10,
9.153692756726399447747595855129405282879e-11,
4.215429616840813426760389817235396920672e-11,
1.617729609583434622949735979368604314559e-11,
5.321363061238072088715424993627357163232e-12,
1.531606498374446756397281892432976422601e-12,
3.918479800589717011159946600410281813321e-13,
9.022538453865525739152081296652300182633e-14,
1.888601438035173340767785243182850649326e-14,
3.622738841522762712546860405380708807645e-15,
6.416413489477545648959518404859992738247e-16,
1.078831654807996280931975046143474059626e-16,
1.651069883886155182346655678914003186058e-17,
0.001050770842559685579829840832057086261746,
-5.233315231211218045998377034547899390639e-11,
-6.025076540597894741669426032313748285625e-11,
-4.624416714563300984387664585399557538056e-11,
-2.662027755377509960778407393196336285155e-11,
-1.225908631902162925653303399513355926164e-11,
-4.704594755540873617776893870765845331101e-12,
-1.547530532155700153435879008428406197332e-12,
-4.454137668558167360129530599975394754771e-13,
-1.139552264203091745353534523917074417385e-13,
-2.623890930091765437033258359604611967765e-14,
-5.492349353491589912884168503448407090758e-15,
-1.053553159569394738741538769033019819446e-15,
-1.866014299686186282748705458782532558364e-16,
-3.137499118040421961120773632465106929283e-17,
-4.801853256775058023674093887191959003064e-18,
-0.0002821491061750563374673554503652319484264,
1.315834012972268408961230391503108796377e-11,
1.514909826248362172289639567481065178545e-11,
1.162736160789380533382574243034552333891e-11,
6.693246223001700558928572243932877632616e-12,
3.082352732223736088837813965831575877928e-12,
1.182895759547678986086819008764783966659e-12,
3.891020549386944496283860163550889435893e-13,
1.119922631506068398094536274230087375082e-13,
2.86522549400373500440474183763235459644e-14,
6.597367606352971002123598374930886038769e-15,
1.380968438339389673242538903157294033371e-15,
2.649008972299532879772981192614818078897e-16,
4.691856414496602490793473802014405249425e-17,
7.888958780870058981771970332609738303156e-18,
1.207415226437068496798398118974034012123e-18,
0.00006653112119922577254062652778600901783234,
-2.917047146474576453925276354608180096421e-12,
-3.358374501886483220004050606238441141659e-12,
-2.577647480045120136286842871684878306641e-12,
-1.483812925936622673869455659064280336821e-12,
-6.833208840400399758979477599110788905306e-13,
-2.622339107970714045862882510060365087646e-13,
-8.625930192986665357069272785836724347834e-14,
-2.482735828600256389402851663917900749682e-14,
-6.351867776584060698063684057145985510782e-15,
-1.462559790710211566650740011311496250085e-15,
-3.061450948956126061299034590221907724084e-16,
-5.872569768437245013979650953674671449414e-17,
-1.040140221938621837094852403315010923202e-17,
-1.748929885376484055140269502584006330299e-18,
-2.676822545603139564175266136213369756564e-19,
-0.0000139898948470588910745559868324247116167,
5.787258464101095305556078031583988404798e-13,
6.662827281317350131931750519205166520875e-13,
5.11390853659944324885215298014805302651e-13,
2.9438019436034308082950996694462778287e-13,
1.355670482507232693967762694903652111931e-13,
5.202574579042362723207003075267551091392e-14,
1.711336587282550160120081244172177081273e-14,
4.925610594029875605697498308265605420539e-15,
1.260175830465336133794969422447075567051e-15,
2.9016404294335594549000564431976461915e-16,
6.073762484909308088673406376778352591114e-17,
1.165090725985679028844357540289077710772e-17,
2.063600320029216568999539052971155068203e-18,
3.469852183559676762288381253412421466968e-19,
5.31088831043819347420566049654998642964e-20,
2.655204374560818034669723501787512941607e-6,
-1.039615735451757001968570471566512484907e-13,
-1.196901804545786222332912377873733613166e-13,
-9.186560184530348725899162375334671871659e-14,
-5.288208376008988458025783656568025175962e-14,
-2.435309256734439291146819690353587096194e-14,
-9.345839293422354558387531720726261979552e-15,
-3.074223650674550717671703493565905676378e-15,
-8.84830650232528938106969711252885180484e-16,
-2.263765036155723626715883622647480869753e-16,
-5.212475582446575327988551901442510610396e-17,
-1.091085337932843484881918847955870972481e-17,
-2.092963249717851813612339229829522430796e-18,
-3.707057655809511726957587621570686322839e-19,
-6.233314821828102731539952686556027861267e-20,
-9.540766338708297895808357202323177570367e-21,
-4.593205606636799834998467589903238481721e-7,
1.707035994307789697483456562987488809817e-14,
1.965297750160394917643533912127417246184e-14,
1.508421665234358290715022406577690899503e-14,
8.683171922208333741881266291807420042309e-15,
3.998747360083775756606370709833765647675e-15,
1.534575177311267107286356296752928284311e-15,
5.047837271863917864631624597612719196877e-16,
1.452881178838039522897430657490713950715e-16,
3.717075598264976246948925163052084744994e-17,
8.558827865503593798449090859974585061007e-18,
1.791551937428956248032588563059510693701e-18,
3.436632780844720954328086336462707533432e-19,
6.086989633976472558711906971798444802169e-20,
1.023519586815188156653385324659302581908e-20,
1.566633867629376014792833699274755211135e-21,
7.299809221472018147927497254436757719419e-8,
-2.581747421361302295471314606713085241579e-15,
-2.972346467395371703562520051695681373783e-15,
-2.281360075355426255222947087951986341091e-15,
-1.313256256086436639066037640654578773068e-15,
-6.047766998435592306748006313534898204862e-16,
-2.320915159987071356990423243015896926443e-16,
-7.634427342806118999770898128709210244833e-17,
-2.197360259316874404508065462525834627446e-17,
-5.621764611550822317342818647306927227079e-18,
-1.294451390597789654427785090442049656695e-18,
-2.709575391047045805723578046057171826969e-19,
-5.197634328098801648936081023920905923147e-20,
-9.20612103500154619332792097952417930115e-21,
-1.548009990948189903746873702634014209024e-21,
-2.369471799986784079279020043378263026302e-22,
-1.073352861143418993234490072791094939842e-8,
3.620924363148091958091686163794912313584e-16,
4.16874310289878004042584458611926142254e-16,
3.199628378869765602283845993473267446252e-16,
1.841853926173914693406110038760557165112e-16,
8.482048707133024765339749055709030321838e-17,
3.255104888544916983607796317486892618349e-17,
1.070735519697949923475354094207033188962e-17,
3.081818461908329883568618354215832687307e-18,
7.884579390019067283703570918678434560714e-19,
1.815481351613147352151520769795348573582e-19,
3.800210298721360541941067225624972605753e-20,
7.289752750156453091700797221776586521235e-21,
1.291175080107355133250324736912808356635e-21,
2.171127682195420458356078023664222026148e-22,
3.323295558778983082817273782280345840457e-23,
1.491203777028390525578378075790024876307e-9,
-4.802465022567743577427129212723876767912e-17,
-5.529042023757082019762202654944015062339e-17,
-4.243696332843821324089642522662308606458e-17,
-2.442867693312958436580393550466917511317e-17,
-1.124981884014218296663187104543373237571e-17,
-4.317275508950556293630493657478018848085e-18,
-1.420126419252015562960880030899093968837e-18,
-4.087444697229897890773082459337303002989e-19,
-1.045739344516572738527683890930420038197e-19,
-2.407891261827560857689645505499861126097e-20,
-5.04026105172561270668990106280930494158e-21,
-9.668494090553281199581767252767646493025e-22,
-1.712507399956160699140809278245849993841e-22,
-2.879622900196875079173311446481645133931e-23,
-4.407827971683591204082798639987544838603e-24,
-1.904018650067955762241074927407333806339e-10,
5.873787335642342988093201442660405482695e-18,
6.762447390321718995035537136128062533932e-18,
5.190369894379882533024909032854697000105e-18,
2.987816752615571948553204365225310081959e-18,
1.375940155534578218593361360537644526561e-18,
5.280363125323094049723204987361010088402e-19,
1.736924935485970813873117595273696672746e-19,
4.999262814037888812604915344906787652031e-20,
1.279020772770379011453982087242447683278e-20,
2.94503976418721668526172309236558353202e-21,
6.164638407666549547971743444249617384123e-22,
1.182534930716574023178924087425041619615e-22,
2.094540372076163873976100672254548505476e-23,
3.522041712229780034867840645849747617618e-24,
5.391235580357004687858537747315511186902e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=11 maxabserror=1.084612165141377590661e-20 maxrelerror=1.385984650060291146478e-18
0.01737610780487566699930671729360591875034,
-1.308344448016011132918133337625435038773e-9,
-1.506287102425954462648632596889577891893e-9,
-1.156117908884868502798199533798924320554e-9,
-6.655147733576272827988336676475047710192e-10,
-3.064807021201119857494038052865458078958e-10,
-1.176161800496911409310780933162302068259e-10,
-3.86886623919190409219968550051228500149e-11,
-1.113544049890455010112120780575608070742e-11,
-2.848895818869611871101240387729599912369e-12,
-6.55971852939544320646455040279066819281e-13,
-1.37306720714342145640077281007927022278e-13,
-2.633774702067887875463410737155949312465e-14,
-4.664596051718694512945231885143998508356e-15,
-7.84205546203897147068590341669590779149e-16,
-1.199934904976611545595905115035439066746e-16,
-0.03177105046672707443411991810288174920819,
2.170709582066117375855118943633321389323e-9,
2.499121600074407624378774411976576812639e-9,
1.918146464726189863314411988203206156637e-9,
1.104173577011062386508688675058715140703e-9,
5.084904594076359917495716215429573031794e-10,
1.951402224594004510997621185875130396436e-10,
6.41894332976407265679088634064483184039e-11,
1.847512692021065098906381479315559358606e-11,
4.72668870821066256299045728460990545558e-12,
1.088344652067732048970009977013481701612e-12,
2.278109821512815887856032019497403904385e-13,
4.369831521731094758943872489040535698945e-14,
7.739387169200113889751142618624789635209e-15,
1.301179488971851112788913690618827273615e-15,
1.991096311308214672662992938079844870994e-16,
0.02925870065226162049228100807253253621826,
-1.829345760506842780594436612419115556865e-9,
-2.10611201475690641297215796486156372327e-9,
-1.616500519007272484968311609420330771464e-9,
-9.305322798294180478555703891950301185769e-10,
-4.285257489204117498787203027787546951915e-10,
-1.644526783183580821465183675313947883055e-10,
-5.409508150576283169412776779421679048231e-11,
-1.5569756990936337761262995570738256092e-11,
-3.983379980323998892166142030319037672172e-12,
-9.171953525735010280675446782849117071045e-13,
-1.919868044065769370107938085519563125474e-13,
-3.682680528531866707921341194922104168059e-14,
-6.522456893577421976106663431848555680477e-15,
-1.096614404599111147326264523534032103107e-15,
-1.678152198459094819016956448652160970735e-16,
-0.01807535178731853220400660812346847303923,
1.041568795038550809162494491614189766318e-9,
1.199150325588996680622702486922171271434e-9,
9.203817885107925927009136410806726883708e-10,
5.298142319958710663880627696366916964503e-10,
2.439883650478119068263076824390893304342e-10,
9.363391441871454948294174275747063829423e-11,
3.079995467000806552948397639693914931785e-11,
8.864908762425470336523269078344605542529e-12,
2.268007302354730679890805110885870900145e-12,
5.222219357915063817790530859484399412709e-13,
1.093114737900158021495118654191104807012e-13,
2.096817376155520551639133302377908668141e-14,
3.713745942543426327965045038607555809147e-15,
6.244030266813784311149451844962638541011e-16,
9.555667309644548843547653062852119714744e-17,
0.008419823151715988172892903245506751796657,
-4.498841234540055970283355327972072419048e-10,
-5.179482123072342328111514588952074023452e-10,
-3.975399045765436523547069316198395761391e-10,
-2.288423189181554886329624129096063534877e-10,
-1.053857404210182644661780365281960536017e-10,
-4.044324023958507072060908241777811623224e-11,
-1.330340765309491876243510572765590392823e-11,
-3.829016245936041637066841267522526300594e-12,
-9.796199501474099996787899609056316314335e-13,
-2.25563461346633710305233640245359352579e-13,
-4.721503595087840555401176896310996065998e-14,
-9.056847103806728773561036526497033218151e-15,
-1.604103372369354882832430818339092286994e-15,
-2.697079137019937683987522253506433988934e-16,
-4.127674709715306798412937536050939757216e-17,
-0.003152312527635118917805768089264509784386,
1.569994569350359580462099760094275270403e-10,
1.807522962164394903919170745885720322385e-10,
1.387325014357497695706116149637785790138e-10,
7.986083266066373168061245874044442949118e-11,
3.677725895676022490664347772107568795242e-11,
1.411378426650570220894095285760400927001e-11,
4.64259159642864118929097467900417863718e-12,
1.3362413005563807591533056299725762198e-12,
3.418656792580954946200263213553871976175e-13,
7.871672790210086733072780159204450816104e-14,
1.647704806033827117041019052548332583878e-14,
3.160659478682000276964209672257700661709e-15,
5.598042899012180979626168223538883188555e-16,
9.41249735404327947323640042700850296355e-17,
1.440555977020579803708728733637394083373e-17,
0.0009875218716209862606924830388171832550687,
-4.605419045426519907535101947690840955607e-11,
-5.302184391896415628774916483049106663654e-11,
-4.069576562783668745576209176584703526868e-11,
-2.342636178062589865984192556579296060323e-11,
-1.078823456283831379791412432397681049084e-11,
-4.140135158438074611613047315827985833296e-12,
-1.36185719229240350624456457793417350927e-12,
-3.919729210291309073201327745951189584985e-13,
-1.00282892290644191755723448131271285645e-13,
-2.309078662235362805190112040155116889148e-14,
-4.833389534212612019074849275919545742217e-15,
-9.271531403095838478363224588888311936077e-16,
-1.642149745082219537545089418542080108916e-16,
-2.761135573318660253507458497767176389502e-17,
-4.225953292551383846934491205382208663409e-18,
-0.0002661244857176951006108334028306912628817,
1.166818861315382679372535016164621875495e-11,
1.343349803892501019322115379642203284371e-11,
1.031058994426481114061022441609227725831e-11,
5.935251717610544362454465026267846365107e-12,
2.733283542544791197208577769644023471666e-12,
1.048935645638477376345483699812643032928e-12,
3.450372085254337836489772269318708562035e-13,
9.930943337598585337397243602654094089929e-14,
2.540747116568532365813809410367876198179e-14,
5.850239176506414447694473878619827596679e-15,
1.224580382442966544626351520993863551121e-15,
2.349027912862104306504079217259363578882e-16,
4.160560897473610609006948740059934883393e-17,
6.995719557849066179454041299085265378514e-18,
1.070729020742945594570562473813034979122e-18,
0.0000629545267075504339026914280580553024365,
-2.604266305880852518795791779173686199329e-12,
-2.998272273179639287478813373832867918717e-12,
-2.301258838850046135608921999305074824466e-12,
-1.324710873113521561781010335745166771765e-12,
-6.100517164337849204703829042658181477145e-13,
-2.341158557903938003205318038847176743892e-13,
-7.701014634004800627865155520927648720469e-14,
-2.216524764790196285702373414286790744881e-14,
-5.67079123063848641171210853197947943784e-15,
-1.305738191758668326500518257543360897631e-15,
-2.733193115097741621242763278611706516305e-16,
-5.24290826096699271327644817202893678596e-17,
-9.286201429559732999384687765629780698761e-18,
-1.561433480824161080761277946730712573093e-18,
-2.389899736975995326483694874321905270396e-19,
-0.00001327601204933319021549326759677218490433,
5.198075769540608788181286644063087518805e-13,
5.984505675094757093571895206141941300607e-13,
4.593277522861129909244951615609657197705e-13,
2.644102708936789884725791963526746865002e-13,
1.217653947231515947826841600863884734223e-13,
4.672917032757433454790520128783896124099e-14,
1.537110965502165348494638712969448440698e-14,
4.424150776362538213383220626036292415143e-15,
1.131881884920266588993891083773124014941e-15,
2.606236333330737112121219680890663824589e-16,
5.455423637961509070423407751529157577811e-17,
1.046481039463786277626703786316166735178e-17,
1.853527791033311622734691363896891418202e-18,
3.116655667369460393614979876037240547132e-19,
4.770380500460437483152170896157330472549e-20,
2.526263750671555753954784684551070041907e-6,
-9.388699866189442288248166165609219743974e-14,
-1.080913981045580732895539428494977943913e-13,
-8.296320835511113539116299607017771060492e-14,
-4.775745522413337277512241494568834938903e-14,
-2.199311492536437776117090412401348495148e-14,
-8.440165181006067551934371409864743978748e-15,
-2.776311060629845573352022547492210290359e-15,
-7.990848098595658776436584817557401373171e-16,
-2.044391992227015865040172375902119649558e-16,
-4.707356277407928068343143525760306353082e-17,
-9.853537647318391752105021184829468374455e-18,
-1.89014841147814384243352115880907898701e-18,
-3.347844975323723142253704849983843097712e-19,
-5.629358865283363140629850678244386778861e-20,
-8.616488013640637116667130435496662110446e-21,
-4.380442872700891459382298376009275739147e-7,
1.549213421946621328766102633453280492144e-14,
1.783597808161727607794326401748038392464e-14,
1.368961820121184389602346186695126110668e-14,
7.880376684253623465240464782381931200597e-15,
3.629046640791717377500339143639809867505e-15,
1.392697398423369297128614794888955536608e-15,
4.581144232361878098425952781211803488756e-16,
1.318556563152125155966976365788828389955e-16,
3.373417988324084216244679047838385524201e-17,
7.767535477617352961704013174774666099057e-18,
1.625918372707628861739637065243393304089e-18,
3.118912720266707406147763143915526630734e-19,
5.52426088908518182041523381357362870054e-20,
9.289049144150896586583277696623106270606e-21,
1.421834499438066471639534207010366985058e-21,
6.976583371844487913698940579389858815481e-8,
-2.353541032772743186598073484169437305166e-15,
-2.709614165822919195080279852985764696431e-15,
-2.079705601125608799299751722476208210084e-15,
-1.197174631908419079753923530809997739857e-15,
-5.513191569906367661774679017476385459534e-16,
-2.115764416155577473425468429492391117125e-16,
-6.959604035046225974197518944467118070246e-17,
-2.003131100820655083582342247090353880495e-17,
-5.124846381444801797572759959369600187487e-18,
-1.1800328939386685553173954767432139587e-18,
-2.470073929484473166649964148768322169962e-19,
-4.738218888647224997335130113631807917511e-20,
-8.392424765572697359606149361817769983895e-21,
-1.411197133465830260090796045757151783567e-21,
-2.160087220823397392665086600797195729597e-22,
-1.027834990966260544483180421086457297673e-8,
3.314344298570626291398866495791632975154e-16,
3.815779775852466216379420519865472723906e-16,
2.928719038670546099980175779586172218314e-16,
1.685906002741481978385265974021263278317e-16,
7.763882243371810539861369637169059359775e-17,
2.979498525366420774442294082929140605587e-17,
9.800774952781960978886947650311783658168e-18,
2.820884463265963803816921808339020076521e-18,
7.217002491326060586658456557690256465977e-19,
1.661767549459098584085646322794727545361e-19,
3.478455293502022420224465118913788053204e-20,
6.672555826861467035547097102450276543909e-21,
1.181859377741366201449482404668275696995e-21,
1.987325001152710651480154345523970447504e-22,
3.04199000306822415913198044569228861119e-23,
1.430601514544923335055737744957093397055e-9,
-4.4127012613027089407910264497323538586e-17,
-5.08030993015428052911129047176081616186e-17,
-3.89928175316068375942343747737314296712e-17,
-2.244606758769191768048176961650588621736e-17,
-1.033679381496284564161112802240857560595e-17,
-3.966889452156487297789827914753209447554e-18,
-1.304870336199784441904260100258404357215e-18,
-3.755711958071418970543376831730877873902e-19,
-9.608683903840077139170154854176628205605e-20,
-2.212470415497105329372510792287015698889e-20,
-4.631204064324816911973671616226078446712e-21,
-8.883831031314156543867183939554363944089e-22,
-1.573530084709904274453640132841127708401e-22,
-2.64594503173595909369554545589282894137e-23,
-4.050182998258730372728737792396021898912e-24,
-1.829643834218873339017578078616355367637e-10,
5.415537807617937880936823518330132594436e-18,
6.234868146348164205616399379014311078268e-18,
4.785437894086712405087326952619740589381e-18,
2.754719194744039888458703689922380160312e-18,
1.268594799076100875925719308066277365369e-18,
4.868410371791682712993353331879078538751e-19,
1.601417078474374625618951845717330235497e-19,
4.609240900222781776796151031065903005022e-20,
1.179237012649417272810778440346383086665e-20,
2.715281107522172996745940790059603079224e-21,
5.683704680236937971143426625087730312895e-22,
1.090280874427219195808945080737626719501e-22,
1.931141941650413870092792749996987180436e-23,
3.247299476616226293045217898061167957045e-24,
4.970734474827859925667301549008439918314e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=12 maxabserror=1.045385048503226737418e-20 maxrelerror=1.471473691891150843218e-18
0.01588552523336353720777631620685999660972,
-1.085354791033058687673361619040232836914e-9,
-1.249560800037203811896731119974096689355e-9,
-9.590732323630949314325841581790131485359e-10,
-5.520867885055311931250416275552990044777e-10,
-2.542452297038179958152397240344114692447e-10,
-9.75701112297002255270294130375864587628e-11,
-3.20947166488203632764376004945371179805e-11,
-9.237563460105325492368392911767635248479e-12,
-2.363344354105331280941710808946247173379e-12,
-5.44172326033866024357553314307702001759e-13,
-1.139054910756407943661230207741873911842e-13,
-2.184915760865547378960171317136565428969e-14,
-3.869693584600056943969112307511045168836e-15,
-6.505897444859255562420303280397310594803e-16,
-9.955481556541073360981686451867899214232e-17,
-0.0292587006522616152514903219378898645521,
1.829345760506842631503102028226365791849e-9,
2.106112014756906241324420118464622724775e-9,
1.616500519007272353223810905035793090988e-9,
9.305322798294179720173473274565061831942e-10,
4.285257489204117149539350971091808684681e-10,
1.644526783183580687436422411884769007903e-10,
5.409508150576282728537956624475145083784e-11,
1.556975699093633649232536484230288467626e-11,
3.983379980323998567518665339036533832163e-12,
9.171953525735009533150229749540252830737e-13,
1.91986804406576921363371845584444695063e-13,
3.68268052853186640776317734886597436064e-14,
6.522456893577421444455313586612120823145e-15,
1.096614404599111057926318417582218525905e-15,
1.678152198459094682168619908435673930852e-16,
0.02711302768097780246578942827223955817333,
-1.562353192557826327642402199617139631182e-9,
-1.798725488383495152064729340189279121276e-9,
-1.380572682766188989697878458151959326217e-9,
-7.947213479938066575188756785663059235273e-10,
-3.659825475717178869203301504735709343133e-10,
-1.404508716280718344635702998843461951947e-10,
-4.619993200501210166229928328733799528965e-11,
-1.32973631436382064741927842418165978677e-11,
-3.402010953532096267851440987234381465985e-12,
-7.833329036872596297759658970152047656866e-13,
-1.639672106850237151781632208359998319094e-13,
-3.145226064233281056765671264818290622588e-14,
-5.570618913815139898105468028164221163087e-15,
-9.366045400220677149703045963295665437972e-16,
-1.433350096446682431079556307442316580016e-16,
-0.01683964630343285707706955947694274553385,
8.997682469080362487499205700494120013586e-10,
1.035896424614497310903155150628452308146e-9,
7.95079809153109444279508053158635699661e-10,
4.576846378363237218256318411659722452852e-10,
2.107714808420423980177900500569350788779e-10,
8.088648047917239378506463340428636749522e-11,
2.660681530619057841188498071074719821604e-11,
7.658032491872296518204383203680164750305e-12,
1.959239900294874556136259107749686528512e-12,
4.511269226932799827188330454270155999167e-13,
9.443007190175944064621063018506971531545e-14,
1.811369420761396196079246566300995019403e-14,
3.208206744738799109298103927485722563347e-15,
5.394158274040025603952440372718141343714e-16,
8.255349419430843569489064636110552891584e-17,
0.007880781319087497750756338553373913305988,
-3.92498642337581693402437461875535875173e-10,
-4.518807405410892834088796071075412714151e-10,
-3.468312535893671764858787705207687640699e-10,
-1.996520816516551572397420869049112853993e-10,
-9.194314739189864100758321890149385929252e-11,
-3.528446066626351821224482037443567761089e-11,
-1.160647899107136044209576415820762208361e-11,
-3.340603251390882091923566411460458588726e-12,
-8.546641981452208772549970017135091721147e-13,
-1.96791819755248056088839720484265970026e-13,
-4.119262015084481713960218670839291870879e-14,
-7.901648696704835571066615372712820688157e-15,
-1.399510724753015997937724952551224162321e-15,
-2.353124338510770687776951985596740683865e-16,
-3.60138994255137422587102565693906541192e-17,
-0.002962565614820672985190264954303004287096,
1.381625713615926896769301829722742681795e-10,
1.590655317555075704033782111796167992754e-10,
1.220872968824471135722057827452074416254e-10,
7.027908534126581352983074556963751765214e-11,
3.236470368823315917015975524302840790355e-11,
1.242040547520608595467455700452804838005e-11,
4.085571576841639594984468449046648791799e-12,
1.175918763077154604099135684687376471729e-12,
3.00848676869313235238417103520708856646e-13,
6.927235986645776142579894808973940622665e-14,
1.450016860251158859907691336468592811352e-14,
2.781459420904534004443087843094270475243e-15,
4.9264492352037636028976911941108489437e-16,
8.283406719883850565084550473905010227715e-17,
1.267785987754373875224770344875339168455e-17,
0.0009314357000199215313765189374627342553967,
-4.083866014625712766822974221435776096859e-11,
-4.701724313648936236750225106736895129604e-11,
-3.608706480512012311100876778055756064945e-11,
-2.077338101174816854031415290569261539921e-11,
-9.566492398958007810287281087630521564477e-12,
-3.671274759754334356567969438981786820176e-12,
-1.207630229845486376606136219997022998772e-12,
-3.47583016817812162407729174315291020735e-13,
-8.892614908037492757812094375173717228939e-14,
-2.047583711788212104688967108183194279085e-14,
-4.286031338573339471609150283482593910503e-15,
-8.221597695061401767945416683205736389793e-16,
-1.456196314123563672992533743333965797059e-16,
-2.448501845260289263092090173613109473884e-17,
-3.747551572620387131866468447481234089962e-18,
-0.000251818107716373246251576648016339683484,
1.041706524873202719723113392358924655679e-11,
1.199308912174104940480872937331548568901e-11,
9.205035377675769407701901757735331241872e-12,
5.298843505276942342216193243269604491043e-12,
2.440206871640281927694484163945374493298e-12,
9.36463425427756355002384656389179563979e-13,
3.080405861056306900780562995594244121049e-13,
8.866099080616199020230608257098218912577e-14,
2.268316497744589470116253687522504495147e-14,
5.22295277967395717259342683942292322529e-15,
1.093277248684789443921526912075608772786e-15,
2.097163309461922524950706273063498605777e-16,
3.714480580813144945137071950959821350634e-17,
6.245733938412539862348982709437834705463e-18,
9.559598971042531994555234962484395397417e-19,
0.00005974205412156154551880674310705462781653,
-2.339134093543254875746957780344547912995e-12,
-2.693027550626564301942623648862252960319e-12,
-2.066974882857455146014210097207667372685e-12,
-1.189846217622704452711653369983658537626e-12,
-5.479442756099876138368209566372723396978e-13,
-2.102812662268658035578138905389746917867e-13,
-6.916999336627720523452585851838878455278e-14,
-1.990867847022561405738924905502242473996e-14,
-5.093468476153011371306663143744092864371e-15,
-1.172806348620005986515462819251573358305e-15,
-2.454940634196478281372373377536504807843e-16,
-4.709164672050550426102513526445002681781e-17,
-8.340875049843448273153509983333214085728e-18,
-1.402495048667243115624136345781723814836e-18,
-2.14667122268295848630928437128823819632e-19,
-0.00001263130929923130301235920644877881887163,
4.694347243745281477523886103227387610902e-13,
5.404566809000018352019840495568355245432e-13,
4.14815804131295439812617414925094684082e-13,
2.387871393216481498570201745522011268416e-13,
1.099655116285585841837821771973569728984e-13,
4.220080172856327297883229577831733974325e-14,
1.388154735053109630457340117231588183831e-14,
3.995421760354131606306031009025512220097e-15,
1.02219541050569085842051045518493619427e-15,
2.353676790297947743322950296971759430376e-16,
4.92676600113529276273106751582983264308e-17,
9.450736643057318930173637203380680171106e-18,
1.673921528654905428076142221495165695933e-18,
2.814677820021476694386457705900805979496e-19,
4.30824153831328542612900458361943632939e-20,
2.40924422283388370940032969400388652064e-6,
-8.520675580836830929043148238866449775865e-14,
-9.809789971314477896258186026105472507341e-14,
-7.529291566005084683540298090969755042279e-14,
-4.334208071664256292451182095534210217619e-14,
-1.995976064747653865203240250519092058607e-14,
-7.659837273634484494708245700285065455767e-15,
-2.519629848283493414278364164293635549848e-15,
-7.252062595408998522751059267826516595718e-16,
-1.855380276848035016256216575203876501143e-16,
-4.272145395197266684469521782916664633107e-17,
-8.942552897184527722733443311664761651239e-18,
-1.715402350505707136482224684162154790799e-18,
-3.038344116652058909569972754183555908813e-19,
-5.108978084722872579401141184478665372419e-20,
-7.820091362530431308499175152309006740059e-21,
-4.186486408185672809895334914494513063435e-7,
1.41227719977881773464574871503883761926e-14,
1.625944163838582017427725963720661411338e-14,
1.247958188035700533486779393963687336911e-14,
7.183823920045889681108341216790434734277e-15,
3.30827236229719323898217345336946075756e-15,
1.269595814766609669715157832484366088255e-15,
4.176213612446951669356212640828071328509e-16,
1.20200852360645687676469732756069073955e-16,
3.075240073189105288229997342476476388064e-17,
7.080962381157278989135682388347514908093e-18,
1.482204493452877816427204722500322584708e-18,
2.843238515141727369303561621647256628864e-19,
5.035998951493994803970740796663589414685e-20,
8.468097720119034444595101886284328626582e-21,
1.296192383126196370482302958952780923587e-21,
6.680724834259029978462019083871960247574e-8,
-2.154268320141820163263966979448909405376e-15,
-2.480192987584596545332505367725347296127e-15,
-1.903618355619516472631605774669164463977e-15,
-1.095810683882852197694908747094188763505e-15,
-5.046393509989635474337211068930149487767e-16,
-1.936624172042380422702640642737380508452e-16,
-6.370339678520005995366194841755777415937e-17,
-1.833527686463974415276470152726474420816e-17,
-4.690930824442907405499992106338121529314e-18,
-1.080121093203240817869266497230347705212e-18,
-2.260937719762580499165359336776540844635e-19,
-4.337049604331866723513982651109397371238e-20,
-7.681888137587336382219896929724598340485e-21,
-1.291727986511210454002240660872951262651e-21,
-1.977242582557981964809974814494253736386e-22,
-9.860152541759668035611399982877907821677e-9,
3.045067918581752935355788779908398603404e-16,
3.505763900204752843449663911035265200289e-16,
2.690773081565783613197202354299370651429e-16,
1.548933323301650857525110944047983129518e-16,
7.133099964786981050982053414526232566911e-17,
2.737427049752847117850562563007044904413e-17,
9.004504395961281019362940110530861128315e-18,
2.591700020146241612360944263701369153718e-18,
6.630653905762505662270228616339868681719e-19,
1.526757007180601174585589572603658086005e-19,
3.195849802039421709453581597756602361237e-20,
6.130455128452388294101371393739654505055e-21,
1.085844035491705993736701256336373070159e-21,
1.82588386674482316541156052968183864337e-22,
2.794903762377128630206670575705900496636e-23,
1.374726631123390951278883121602469776037e-9,
-4.068481248808180991106659693730922170985e-17,
-4.684012011995360474692036842697574965898e-17,
-3.595111885701244485117144542420331624899e-17,
-2.069512537435604400718748385643745824533e-17,
-9.530455397036651995626212795912777102158e-18,
-3.65744585577780834263490609930110503099e-18,
-1.203081870753711699855813650692383238623e-18,
-3.462741993182539461140000633516422690018e-19,
-8.859145386049841589541300292422263384367e-20,
-2.039884252189731628149363167766508128168e-20,
-4.269944522468905407745245754456914940709e-21,
-8.190852843562832190674023760673890960212e-22,
-1.450791254612349422218768995715135555517e-22,
-2.439568866967556513007363167847324259422e-23,
-3.734318168968235886192238505274449242683e-24,
-1.760854408082199281224614158776067975396e-10,
5.00884249264458379132975631036757506988e-18,
5.766642880293458202506325664300298775181e-18,
4.426061750305191692354871005270298809364e-18,
2.54784569005299926271070593807516726278e-18,
1.173326060020376617452747407199532653615e-18,
4.50280330895363255726752389634901464138e-19,
1.481154179494750082957258786017981661536e-19,
4.2630973456266213457576991889435057822e-20,
1.090679134301986198311786156056547577867e-20,
2.511370688557821715050970658179874776545e-21,
5.256876426570812077647214069148927217928e-22,
1.008405335581968294455894302157749711685e-22,
1.786125200048377967335586973297659442825e-23,
3.003462672169032368314141821793482887394e-24,
4.597529381553640319178209246444613357024e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=13 maxabserror=1.008893719584407016574e-20 maxrelerror=1.551271159152814529391e-18
0.01462935032613080761678622947381505447538,
-9.146728802534213155151152570038459345043e-10,
-1.053056007378453120390003340813608567124e-9,
-8.082502595036361764029790850966728864776e-10,
-4.652661399147089858884059903674591239769e-10,
-2.142628744602058574215822487106975445024e-10,
-8.222633915917903435056623437269339819994e-11,
-2.704754075288141363569819069967153734794e-11,
-7.784878495468168244150343451057282447705e-12,
-1.991689990161999283244491818550332924433e-12,
-4.585976762867504765389654534151637898766e-13,
-9.599340220328846065687148709893482312161e-14,
-1.841340264265933203405582466463556456457e-14,
-3.261228446788710721384533507889336408469e-15,
-5.483072022995555288213823603960567691306e-16,
-8.390760992295473408672824472525856235287e-17,
-0.02711302768097779741493137626959396555867,
1.56235319255782618934459946899225907548e-9,
1.79872548838349499284350378911318041716e-9,
1.380572682766188867491077676273732609159e-9,
7.94721347993806587170993187685421596578e-10,
3.659825475717178545239394374133087041029e-10,
1.404508716280718220310008210096528600053e-10,
4.619993200501209757272406337127494207798e-11,
1.329736314363820529712029458858158553999e-11,
3.402010953532095966706882553008532660862e-12,
7.833329036872595604351500514447532244885e-13,
1.639672106850237006635283326302250503199e-13,
3.14522606423328077833702119935028874982e-14,
5.570618913815139404941238123633184708338e-15,
9.366045400220676320417817166684536513165e-16,
1.433350096446682304136212354612762160665e-16,
0.02525946945514928962989003649866581657036,
-1.349652370362054479064945043661006817703e-9,
-1.553844636921746088322736104187788826779e-9,
-1.192619713729664260033159765588901466893e-9,
-6.865269567544856366269339681139020191991e-10,
-3.161572212630636218432453632820418224329e-10,
-1.213297207187586002013002942188377823012e-10,
-3.991022295928587075055899657501966507036e-11,
-1.148704873780844567897780370301984437363e-11,
-2.938859850442312064889770047837251715761e-12,
-6.766903840399200271953187164170304952793e-13,
-1.416451078526391720879510578241291584144e-13,
-2.71705413114209450740356447433599017244e-14,
-4.812310117108199041726456974186499328897e-15,
-8.091237411060039041189952573935441337634e-16,
-1.238302412914626632667145511413175608884e-16,
-0.01576156263817584431470256556919152520004,
7.849972846751866276885123596884401547846e-10,
9.037614810822053238732046440186521760509e-10,
6.936625071787548897697442127521224116983e-10,
3.993041633033221364095426080669098239635e-10,
1.838862947838027262140761457347224381676e-10,
7.056892133252912571220696165989472334356e-11,
2.321295798214340813547057344646680730506e-11,
6.681206502781961990350392785890316656592e-12,
1.709328396290492361717797483717059302385e-12,
3.935836395105077648706435001927929140399e-13,
8.238524030169207345707992384503922029234e-14,
1.580329739341013904022970496158362983177e-14,
2.799021449506114871902976075807595812854e-15,
4.7062486770216807365647999044719034063e-16,
7.202779885102961779463389070807863410148e-17,
0.00740641403705139339606841194449254150532,
-3.454064284039740955641220046798874379366e-10,
-3.976638293887601432258635391968436015846e-10,
-3.052182422061110428960853046385686241213e-10,
-1.756977133531606533735986198822607194977e-10,
-8.091175922058111091202368544805191451724e-11,
-3.105101368801452909522034863143967310749e-11,
-1.02139289421038734028888689166789096101e-11,
-2.939796907692821581888394919148017245289e-12,
-7.521216921732664766939246122006295547959e-13,
-1.731808996661405786624177347682416976989e-13,
-3.625042150627817085693308746321647505526e-14,
-6.953648552261181427130786946779101995561e-15,
-1.231612308800913697249935585481109891657e-15,
-2.070851679970916896799915925249209425924e-16,
-3.169464969385864663874626771701867879743e-17,
-0.00279430710001901122723305301052433485627,
1.225159804376555573777865845865331158028e-10,
1.410517294081834454067673437728907755827e-10,
1.082611944143743704422109840137395120218e-10,
6.232014303467691909004815905051808888905e-11,
2.869947719661264022546337636901191187921e-11,
1.101382427916269359725189039453127209186e-11,
3.622890689503463285027669910323651342779e-12,
1.042749050443939534828412490826752897373e-12,
2.667784472386950636126596967502133359158e-13,
6.142751135308690190686415440364639472371e-14,
1.28580940156029102520853923448158767322e-14,
2.466479308495956122600492206339378409292e-15,
4.368588942330901139655148258217503182278e-16,
7.345505535713958720608337137156979841068e-17,
1.124265471775873992839230556631770053582e-17,
0.0008813633770150156307791518807892032660736,
-3.645972837076554540966934379619762832846e-11,
-4.197581192632790363239900127112130816326e-11,
-3.221762382204497163641149664998711720088e-11,
-1.854595226857278713202988093636473918696e-11,
-8.540724050788645153342868401825005903007e-12,
-3.277621989015436824918413007655158397722e-12,
-1.078142051375723599244373003258041078683e-12,
-3.103134678232985599894581211346164001533e-13,
-7.939107742150364601905078605782144267412e-14,
-1.828033472896085758778771574934822016374e-14,
-3.826470370418115587073451954740521529285e-15,
-7.340071583157688618003987684355011166365e-16,
-1.30006820329185570863655914698832809083e-16,
-2.186006878456588684814364147367662425207e-17,
-3.34585963988356116288102998942202240757e-18,
-0.0002389682173403034376779028988205772871753,
9.356536397556736200237390815777957160132e-12,
1.077211022942775528631924581885125795275e-11,
8.267899552092832949754363868314577321e-12,
4.759384882385402699061346050568974809281e-12,
2.191777107917608144079972291971782258981e-12,
8.411250670095912074774427041269298839858e-13,
2.766799741565837863692995614663698721423e-13,
7.963471407992463222386035066908663691852e-14,
2.037387395553027341523396574165448116771e-14,
4.691225406204331652631765557591568335434e-15,
9.819762561327598093412152776572626430802e-16,
1.883665873527957070141089164892655069501e-16,
3.336350028275915764830242357777527453419e-17,
5.609980208690721678399511685845078261794e-18,
8.586684912195712614405258576180978900995e-19,
0.00005684089174961592469344462843110558002182,
-2.112456257127509638937428292983951042597e-12,
-2.432055061105155086461038602200194900581e-12,
-1.86667111633057124828348519596491376818e-12,
-1.074542125646307570810608234756835509668e-12,
-4.948448017293308574619139339636879551058e-13,
-1.899036075485899295623226403771576556995e-13,
-6.246696300175178144123051067338936267881e-14,
-1.797939789982321553042989331627217643344e-14,
-4.599879341705831885588884879042502661943e-15,
-1.059154554351592839003188300644251455083e-15,
-2.217044697826345882280899614091752064148e-16,
-4.252831484226146949480604758754125059613e-17,
-7.532646869825792249412816612966301850191e-18,
-1.266605017475859590520822553845493859886e-18,
-1.938708689893078454236346175261816183459e-19,
-0.00001204621200265009921530390922140742183364,
4.260335295754075657845359239717811925761e-13,
4.904892113568849395913434263139845427852e-13,
3.764643578593347297196594425573794585369e-13,
2.167102766872315569368803215410782715329e-13,
9.979874479963526957856801211625573632987e-14,
3.829916394186692791552867720072674521752e-14,
1.259814186449804705353630502369763286695e-14,
3.626029174459799841283087489027726760908e-15,
9.276895952088857264967305933120296350053e-16,
2.136071446804641631806410198809280922676e-16,
4.471273830391438952556515780949726970761e-17,
8.577006730134737562614263786700309170369e-18,
1.519171168739064494840391006013252602394e-18,
2.554487546467593102950477103879891345954e-19,
3.910043391416528663847307187041871092882e-20,
2.302568144866617980026388846371148817251e-6,
-7.767526235928875339741045087572956596322e-14,
-8.942694785945427312872565018501229340823e-14,
-6.863771480859247357363225074077295350198e-14,
-3.951103988791264014531437230049945831001e-14,
-1.819550182766310279587256419655830290991e-14,
-6.982778452962385155404847519569668758406e-15,
-2.296917970962665932148508985571215114856e-15,
-6.611048273233653653341868759530248127059e-16,
-1.691382396743791838690091223396363644899e-16,
-3.894530130481430541756978212091785374689e-17,
-8.152126432209731554979089609931039044782e-18,
-1.563781512927573266113951747571634806805e-18,
-2.769800007123154015362068187211283438069e-19,
-4.657454727766869134509862490092208014924e-20,
-7.129059609951487112939856343882645634745e-21,
-4.008951847819532519024596514873923769944e-7,
1.292702526850724802269143728875348782259e-14,
1.488278740467479775295278734626674387541e-14,
1.142296080513529699379963398284659134768e-14,
6.575584047566988821928697793219396778144e-15,
3.028167652517045610593183543192855511477e-15,
1.162101738855551122189736038681259034847e-15,
3.822622336588919281853581866809172083106e-16,
1.100237074153059178802844595841993104437e-16,
2.814866687736622897606499012226321416793e-17,
6.481436197112080826964525613327488727438e-18,
1.356711175464923287674614590221846020554e-18,
2.60251470807981665393684065694839354057e-19,
4.609637589661534342992196254757120622089e-20,
7.751216614346932839974570034351769240397e-21,
1.186475464086193772871154170929455869589e-21,
6.408903631360502541065751103699482397545e-8,
-1.979242549247028501976170069850072071886e-15,
-2.278687130936127123383675264622677230633e-15,
-1.74895690861379674644018633617697946179e-15,
-1.006780413899844978010847261627856196082e-15,
-4.636394108703884260762402514759389016987e-16,
-1.77928119739136381885059491180901484429e-16,
-5.852775278505436770001090912946122068971e-17,
-1.684561097433737851348239448127464397735e-17,
-4.309812684034105370458081860135866577704e-18,
-9.923661841378134740654357042523401930293e-19,
-2.077248218304146300266018682078356070414e-19,
-3.984691953741364221688430006273519638858e-20,
-7.057802234275281489303536445722217249618e-21,
-1.186793573148907875678808586294087523365e-21,
-1.81664008321307097549815990526182780694e-22,
-9.47461115072486311759012043057903929295e-9,
2.807286251017126415234761107140698200167e-16,
3.232007650110265744757923443339062856848e-16,
2.480657412306700890090181646021647244146e-16,
1.427981041605990977451341742454607935253e-16,
6.576094309836563397514967210392249930116e-17,
2.523668373351973765622410864863744553094e-17,
8.30136599303613858502056623426654857524e-18,
2.389321065201539637704141691052665449059e-18,
6.112884717015153212404594781281544326479e-19,
1.407537254473490922717884410097839183425e-19,
2.946297512181184770075848434628334918827e-20,
5.65175694711795932770287729347756402525e-21,
1.001058034455255933867510818813108248343e-21,
1.683322575992322494622972340474611300403e-22,
2.576709571461134500213816899454992966765e-23,
1.323047342009973027399905003176900253818e-9,
-3.762982682638611113698326240784555236545e-17,
-4.33229380389614908511766961108599720299e-17,
-3.325158206373524985264030164186636308943e-17,
-1.914114732895183084950319978579963585466e-17,
-8.814822290067300908587729208595465110458e-18,
-3.382811677848763472067213995594746482943e-18,
-1.112743620323374430512991578182740160303e-18,
-3.20272827827143986345294223500313151784e-19,
-8.193922456362949625272447386555960119367e-20,
-1.886712237460998791197869034221394336262e-20,
-3.94932263344647996523904067324502326208e-21,
-7.575825843048405439639387388302220152258e-22,
-1.341858582223492681967900579156764005916e-22,
-2.256405219488031889038413253186628314461e-23,
-3.453976531620174806816838562225398021563e-24,
-1.697044609804906556381535175953620155771e-10,
4.646255202410911359528657564683067085105e-18,
5.349198851651315349163417917056561421774e-18,
4.105661642452212718055680654718351713257e-18,
2.363408590399172177769280269913005768718e-18,
1.088389662907758495567486121911356117207e-18,
4.176848039807028335415462575200301428113e-19,
1.373934348099094713553750748571424241549e-19,
3.954494628413710110987266163251241751956e-20,
1.011725742898742177772303094177444578062e-20,
2.329575165791282464699782453357541380687e-21,
4.87633907993698338217322342620745527165e-22,
9.354093442818428930405870949829689004802e-23,
1.656835354004065997843894660360099447615e-23,
2.786068040718438698966612581637951106585e-24,
4.264790786185442596033608299562679301072e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=14 maxabserror=9.74861856943183645472e-21 maxrelerror=1.625894412239299945242e-18
0.01355651384048889869880954238058506838977,
-7.811765962789130944518289193648177998606e-10,
-8.993627441917474961679254941881543922685e-10,
-6.902863413830944335507198851602802928971e-10,
-3.973606739969032934733497998758125881554e-10,
-1.829912737858589272103242209646229081342e-10,
-7.022543581403591099568072556106768408301e-11,
-2.309996600250604877984253487765984289468e-11,
-6.648681571819102646683688053126591317669e-12,
-1.70100547676604798287336411608818627838e-12,
-3.916664518436297801070335723777155750433e-13,
-8.198360534251185030862526494677648279694e-14,
-1.572613032116640388724645164928580379421e-14,
-2.785309456907569701684423560168109691334e-15,
-4.68302270011033815888686270170519533179e-16,
-7.166750482233411518657300868724628238049e-17,
-0.02525946945514928475569314884861328909442,
1.349652370362054350430648102261960295961e-9,
1.55384463692174594022703232986890704444e-9,
1.192619713729664146365511883821251915312e-9,
6.865269567544855711945822937949069450829e-10,
3.16157221263063591710539577027709740869e-10,
1.213297207187585886374514960526739419117e-10,
3.991022295928586694674105126686385210762e-11,
1.14870487378084445841526732057929593551e-11,
2.938859850442311784787505849184054705801e-12,
6.766903840399199626996352610050972600278e-13,
1.416451078526391585875079396382125032226e-13,
2.717054131142094248429521496422193588389e-14,
4.812310117108198583020157826043206778903e-15,
8.091237411060038269844473107558097590953e-16,
1.238302412914626514592023544478253273425e-16,
0.02364234395726377035066986315050537431496,
-1.177495927012780040319472945525272517175e-9,
-1.3556422216233080995422008373237006399e-9,
-1.04049376076813242194745056086038545682e-9,
-5.98956244954983254864104021999573734126e-10,
-2.758294421757041124619935060604940047174e-10,
-1.058533819987936974489478039827721717485e-10,
-3.481943697321511512440703444708070286953e-11,
-1.002180975417294382631362854888456596216e-11,
-2.563992594435738757685623512936048500971e-12,
-5.90375459265761696836447872384887412259e-13,
-1.235778604525381205535037663033353304872e-13,
-2.370494609011521054917938323184085522924e-14,
-4.198532174259172660126317684923975357721e-15,
-7.059373015532521697218375714231939436445e-16,
-1.080416982765444357598481439522101370508e-16,
-0.01481282807410360591745459491577219782816,
6.908128568079698080952299763879666502509e-10,
7.953276587775451739041046740907971271662e-10,
6.104364844122411876168788027191949875435e-10,
3.513954267063323026403578885117840827939e-10,
1.618235184411672856190201910028946012908e-10,
6.210202737603100149283864443781893156616e-11,
2.042785788420838603659643895559665041458e-11,
5.879593815385827148913456928988323702692e-12,
1.504243384346580024515399226940801481152e-12,
3.463617993322919958110984086271572216484e-13,
7.250084301255861046054001894553934962985e-14,
1.390729710452279805960540366674578867385e-14,
2.463224617601904479998688753893458025381e-15,
4.141703359941963418048617106661080323016e-16,
6.338929938771927752749105341703382417068e-17,
0.006985767750047248770606410193339304211122,
-3.062899510941317799178664101984434828182e-10,
-3.526293235204504237669519454626015294355e-10,
-2.706529860359296402404193299982698225126e-10,
-1.558003575866886792906281892182499057474e-10,
-7.174869299152993421329934950650606742683e-11,
-2.753456069790609450778120036384152519196e-11,
-9.057226723758447859947508482903453357271e-12,
-2.606872626109788292809339606767968421617e-12,
-6.669461180967221692642210961506001150195e-13,
-1.535687783827136881292428775317737108918e-13,
-3.214523503900652904980847243066936467487e-14,
-6.166198271239747092598844045140964576738e-15,
-1.092147235582699918188397712484200451354e-15,
-1.836376383928447024127177272995644779147e-16,
-2.810663679439619685123844341623816914726e-17,
-0.002644090131005718881172998425737417385474,
1.093791851112587757962687607095258400102e-10,
1.259274357777888299450649439925503390313e-10,
9.665287146521780993004622730113139507298e-11,
5.563785680519043338280704823040606601965e-11,
2.562217215212281567152004088922782098445e-11,
9.832865966953009843403462853334841786468e-12,
3.234426154096480443505142183946452968234e-12,
9.309404034610622995180843125332562267935e-13,
2.381732322622509882295392573513577919871e-13,
5.484100418636220207247720935930386696966e-14,
1.147941111114542110078129348710577810358e-14,
2.202021474926411775915121440607516432162e-15,
3.900204609838557313505974934270420482902e-16,
6.558020635307531566571265299940103529048e-17,
1.003757891955541690580162526779548734409e-17,
0.0008363887606985107567088341577236064372783,
-3.274787739163828960360476368320373937413e-11,
-3.770238580321555854805390754457012749546e-11,
-2.893764843249255505941594552118778263842e-11,
-1.665784708844541062673557919561575723546e-11,
-7.67121987775606893185347868351808541535e-12,
-2.943937734550623864267134438448471699897e-12,
-9.683799095536532132453210141158186373905e-13,
-2.787214992813508869497623589143134037414e-13,
-7.130855884476905848613378934483637776071e-14,
-1.641928892181028058491903806088786650585e-14,
-3.436916896484570122907567396831658761836e-15,
-6.592830557386043916508228232438410335853e-16,
-1.167722509903335650347087190287017447715e-16,
-1.963493073053128658370232105305840166974e-17,
-3.005339719285913672769898476450697504219e-18,
-0.0002273635678226505648938036622380848362489,
8.44982505025990398060161490612601650016e-12,
9.728220269461077701952192859823064014297e-12,
7.466684484541545356667360190287876774441e-12,
4.298168513648724834841947677769298202843e-12,
1.979379212012249987794164534013102899931e-12,
7.596144321496092989844056144854310948948e-13,
2.49867852650167856491716892894839393947e-13,
7.191759178440911666576042413121882309695e-14,
1.839951741418384257016963166647703089992e-14,
4.236618228311491295684527146934372835815e-15,
8.868178814132330023144339398647320620494e-16,
1.701132598069268110616066631827104753783e-16,
3.013058755686258015169748350936718884448e-17,
5.06642008294557482954008342687251596338e-18,
7.754834779536803284603153529971328378176e-19,
0.00005420795391827618513849476711182537214587,
-1.917150880704177818549033364825359009328e-12,
-2.207201448359969704109705729979438374154e-12,
-1.694089608259363879242681785766118518892e-12,
-9.751962438792856218539598608048718945154e-13,
-4.490943510396336025317229882774407041594e-13,
-1.72346237523982569042775673501411937215e-13,
-5.669163831971025097391810931334843375088e-14,
-1.631713126476868699574383771722039303594e-14,
-4.174603173246286873692152424209559903872e-15,
-9.612321498661996739886093831128819636378e-16,
-2.01207322117287312912005438929390898068e-16,
-3.859653023758688359021890339831470121466e-17,
-6.836270250820360149166489251035229460503e-18,
-1.14951939448016591935473080149583053768e-18,
-1.759519523948038825176276981546961777439e-19,
-0.00001151283193148276144788535886687861660157,
3.883760797603777248262722674831179922188e-13,
4.471344721558843586979803166848213313244e-13,
3.431883690043802945142732295313195837655e-13,
1.975550814098787731819794915087571554194e-13,
9.097745478364746469768976558933479763534e-14,
3.491387140544512115653190930978637278605e-14,
1.148458299332325245601898979737279675685e-14,
3.305522161724264170332072010239274858082e-15,
8.456906931114090670084948397282749356476e-16,
1.9472639018398935013417655225291598965e-16,
4.076060780836986085913873076285399226578e-17,
7.818902893152908701256256286441746910406e-18,
1.384899176127461125685271803782118992816e-18,
2.328725972497333247528627873004386505795e-19,
3.56452767508595912128711307557467524074e-20,
2.204924115699483307112401762589058825003e-6,
-7.109865424282463415247675031731766376188e-14,
-8.185534830138303048790252868009576773132e-14,
-6.282629791807002374028195136494358575588e-14,
-3.616572002698572777357939232298014485219e-14,
-1.665492566492688814496386398501779682901e-14,
-6.391560936077649041247825443710501911596e-15,
-2.102442736552657748634440266355425663622e-15,
-6.051305207156295114002498253587073514981e-16,
-1.548177010674407264874202599789740329449e-16,
-3.564790673832532471817482344944293353198e-17,
-7.461913067261310489542090327886216213389e-18,
-1.431383396789121580532504749872961453935e-18,
-2.535301218698273965900124806497120964451e-19,
-4.263170053313497442949773867260793984666e-20,
-6.525616453784472922229992167772349541763e-21,
-3.845841046385198465713529702236822112451e-7,
1.18767717528324621258227100822018995935e-14,
1.367363841311593106427497936176402288843e-14,
1.0494904738722886013629790037963710002e-14,
6.041352125184796381012155852743978731434e-15,
2.782144846602418906640656549320170451342e-15,
1.067687064117974133316992068300175865859e-15,
3.512054453958546580856143230402109624529e-16,
1.010848704051885626095758236335246087277e-16,
2.58617427011656663653773058838299833314e-17,
5.954857160649001155722142125590886781572e-18,
1.246487095982247211858751835220819791652e-18,
2.391080209090899293027575709242638491515e-19,
4.23515078557142151135685120683778311871e-20,
7.1215508422370925728588168645206395565e-21,
1.090104889292208242791257391009994024665e-21,
6.158308334957182003471110379458791162636e-8,
-1.824687949261186279604911559280033702804e-15,
-2.100749579398550524084630965334397458942e-15,
-1.612384802169741027136935699512387353922e-15,
-9.281632029672641002181217051099313279447e-16,
-4.274348594126386183950918531492935926522e-16,
-1.640341189682335233131401995474394269672e-16,
-5.395745618856538437213482218151876973676e-17,
-1.553017741939492866770063137419781539387e-17,
-3.973270297614855357969734781201901680437e-18,
-9.148750916686456232169538744234710399192e-19,
-1.915042886311873952745437337495031745154e-19,
-3.673545149757403425042988493295276031809e-20,
-6.506705650538790450108637927033433568286e-21,
-1.094130823055325108254133840213589071976e-21,
-1.674817056406330304015122443346732739875e-22,
-9.118048853202634601953852738125353055737e-9,
2.596277491188661731909563981125982209478e-16,
2.989074847421403737694272585753566721055e-16,
2.294199610579040099709098809183470348291e-16,
1.320647320149681925743742365957460459316e-16,
6.081804414494465703943787213305621004967e-17,
2.333977737671336965266315628361508620751e-17,
7.677397037070506671217321247421112740633e-18,
2.209728827115275044541519023263675556044e-18,
5.653413284246964354508684538272542750604e-19,
1.301740894827247078303922039771246247535e-19,
2.724843038166792653890170704277562601182e-20,
5.226956021836188180250230570945058860544e-21,
9.258179294974646892458179282387225954668e-22,
1.556810951258473183730905427088355896055e-22,
2.383076917151416238934213614411745307597e-23,
1.275108662911397502263181833774028662046e-9,
-3.490613403768212056620572195298108524337e-17,
-4.018717095299290566167159255590905621637e-17,
-3.084479206646706313159289231185795649638e-17,
-1.775568784969438729583128216622972629116e-17,
-8.176794817618554368611371945472753689439e-18,
-3.137959737349969009106845343355344448648e-18,
-1.032201944007746594240571077341909872052e-18,
-2.970911273492164876317398675344413215715e-19,
-7.600838283671312178701185077966088945041e-20,
-1.750150595930958172279907763321975581821e-20,
-3.663469582450939867362083526236555123381e-21,
-7.027492621513274408335192389702328873537e-22,
-1.244738292210394536657894254413967640589e-22,
-2.093102139271784561611598947051599515962e-23,
-3.204029054594324452194396191787468386148e-24,
-1.637693137419016996709400257423065422472e-10,
4.321626063529169067787564082088481611781e-18,
4.975455757500467151447944476663222356637e-18,
3.818803237932114183670257606446626178296e-18,
2.198279643310352198904623037128551051425e-18,
1.012344995004534613724241684027731936803e-18,
3.88501601457190255755316749623683209159e-19,
1.277939022979512824876215282258801482729e-19,
3.678198530797344514809716591645286991049e-20,
9.410377129834028791744679813940538718768e-21,
2.166811134561926181518853291361969609676e-21,
4.535638500683740109876288509083334791423e-22,
8.70054880554651746135833294203500381415e-23,
1.541079759980315018057824048669426459604e-23,
2.591429243477355695146399510266026331868e-24,
3.966877846133765802582532781718133902827e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=15 maxabserror=9.4304911283428515184e-21 maxrelerror=1.695807996282629068734e-18
0.01262973472757464236947343511299399531421,
-6.748261851810271750092553605636816295503e-10,
-7.769223184608729698762708226613118724024e-10,
-5.963098568648320730006634204593937243418e-10,
-3.432634783772427854924702748043228949463e-10,
-1.580786106315317958069980015454734367976e-10,
-6.066486035937929430020077172776959544896e-11,
-1.995511147964293346727691076152110787394e-11,
-5.743524368904222290322455765288262595856e-12,
-1.469429925221155891945036427187897304127e-12,
-3.383451920199599812464971895672880991256e-13,
-7.082255392631957927212658573394840183229e-14,
-1.358527065571047123799889883597328386594e-14,
-2.406155058554099290775238770331551063457e-15,
-4.045618705530019133686543902869458317389e-16,
-6.191512064573132571068531572653247493939e-17,
-0.02364234395726376564120545797146722559675,
1.177495927012779920370942414065302584134e-9,
1.35564222162330796144635483541567872325e-9,
1.040493760768132315954976612269004267735e-9,
5.989562449549831938499369897464673335805e-10,
2.758294421757040843639363593687092816874e-10,
1.058533819987936866659238323238795904851e-10,
3.481943697321511157743388308664317606054e-11,
1.002180975417294280541420269823541736179e-11,
2.563992594435738496496631665338445885231e-12,
5.903754592657616366956764751049064811753e-13,
1.235778604525381079646392671910109867105e-13,
2.370494609011520813430163004042225225793e-14,
4.198532174259172232391720983867205185712e-15,
7.059373015532520977951016339231589912717e-16,
1.08041698276544424749449912777567424674e-16,
0.02221924211115541262799067934587494845008,
-1.036219285211954804476429757085498215386e-9,
-1.192991488166317867159122624705096993573e-9,
-9.156547266183618630158559185834454524846e-10,
-5.270931400594985009278216483619306250737e-10,
-2.427352776617509500577604372657619366683e-10,
-9.315304106404651053977885193167620643712e-11,
-3.064178682631258178527210649538128626829e-11,
-8.819390723078741509234862818132751305095e-12,
-2.256365076519870237830341691022336988824e-12,
-5.195426989984380400116314300187496173791e-13,
-1.08751264518837925381432593354430512788e-13,
-2.086094565678419894832777293303903930796e-14,
-3.694836926402857049259234825865775419881e-15,
-6.21255503991294568075205118116318267412e-16,
-9.508394908157892476690216369198414988704e-17,
-0.01397153550009528898323356078976833679881,
6.125799021882837171887289030916973369297e-10,
7.052586470409240545436339877838983496717e-10,
5.413059720718770925182420897006581492636e-10,
3.116007151733876120132674729998388127143e-10,
1.434973859830645903056738688110656663609e-10,
5.506912139581400110296023701632481210201e-11,
1.811445344751749178880528105226446720859e-11,
5.213745252219748147787972907908867718167e-12,
1.333892236193488231343841025414308171999e-12,
3.071375567654374829163449596116349668551e-13,
6.429047007801517365855312513489560291989e-14,
1.23323965424799000054536203359483002322e-14,
2.184294471165471717184607578176123930104e-15,
3.672752767857014921149215640994452774502e-16,
5.621327358879424400013837679016357796558e-17,
0.006610225327514027036716114256805664544562,
-2.734479627781402906428955399973322320708e-10,
-3.148185894444644200939438172736814062397e-10,
-2.416321786630386495732613850547980652444e-10,
-1.390946420129727013904823498701760022578e-10,
-6.40554303803054816798779508757478895254e-11,
-2.458216491738192689641987562427231529822e-11,
-8.086065385241004497052553333335850933262e-12,
-2.327351008652599159476980829251832647684e-12,
-5.954330806556129926457452324572483757373e-13,
-1.371025104659021715263703622923455591776e-13,
-2.869852777786285494005251458699002080356e-14,
-5.505053687315895580868218232224616052502e-15,
-9.750511524596156186113497084742693715285e-16,
-1.639505158826843021770585169304616996344e-16,
-2.509394729888793194042132733501816725841e-17,
-0.002509166282057533373714112395018684778945,
9.824363217394708541420220629638473965617e-11,
1.131071574085324738585316478036537426347e-10,
8.681294529662248374335201092011755621041e-11,
4.997354126484394991934699195401107839725e-11,
2.30136596330415026161638370908734545527e-11,
8.831813203564870680667914836342515041863e-12,
2.905139728632341517370606852581551950006e-12,
8.361644978358157153054355997183167399111e-13,
2.139256765321998185060386826381270416741e-13,
4.925786676494560663112198911589476823993e-14,
1.031075068935213935321506432082194411675e-14,
1.977849167196329163035321679769187897183e-15,
3.503167529675495945328672156968547505885e-16,
5.890479219101353166365763190803354357452e-17,
9.016019157768905576109467971994650515146e-18,
0.0007957724873864821773889830079168443626364,
-2.957438767608698424284109400149405934884e-11,
-3.404877094331791950441314648173134680611e-11,
-2.613339569605209777468661870410734430025e-11,
-1.504358979786073436805091492818457317621e-11,
-6.927827242084412408900661118830975188472e-12,
-2.658650512539573126960790450646888772129e-12,
-8.74537484280831000165035929040344773561e-13,
-2.517115712469411074922628785821437375899e-13,
-6.439831095002956562759642733343715279823e-14,
-1.482816379917912587310138251575469367396e-14,
-3.103862584964925683464812258740204918766e-15,
-5.953964093278137663212640422962330696073e-16,
-1.054570564496513540652856858098394724636e-16,
-1.773247029041584217864536130822544590775e-17,
-2.714192172854158083586762361916689053536e-18,
-0.0002168318164694380613767443672325460520516,
7.668603543098029071283559402241535183761e-12,
8.828805816789608294707940077457898992635e-12,
6.776358450959034370280132169611122843969e-12,
3.900784985833631620151760774916132334167e-12,
1.796377408909452357662207860016229070312e-12,
6.893849519191617490493622541947336107436e-13,
2.267665538785756516386993281385801126165e-13,
6.526852523169199978057294322934440971985e-14,
1.669841273714789735766140886756207906317e-14,
3.844928609633611040445571186767312073469e-15,
8.048292905977185702861276564771853794925e-16,
1.54386121358663526636633969929840838569e-16,
2.734508107560430516139752913062353954441e-17,
4.598077590082288313937650197637301072328e-18,
7.038078114408922757239971714617336673308e-19,
0.00005180774360108486710972737769515500104124,
-1.747692356692348019582841373397964802601e-12,
-2.012105122134843626624127524742532978668e-12,
-1.544347658549745491055817198231980001059e-12,
-8.889978652104510886497550169552303997324e-13,
-4.093985460041858229193380227942104569117e-13,
-1.571124211240908036775817138107336195554e-13,
-5.168062340403093413612450708979404200569e-14,
-1.487484970878484923733552417897098088028e-14,
-3.805608114146906570747956248833821089585e-15,
-8.762687547101810816593302351485143276249e-16,
-1.834227349036887694768403673645395205451e-16,
-3.518506297430533265793341971103504233421e-17,
-6.23204628462371547130663586441183400135e-18,
-1.047926686286967290374378994941178130613e-18,
-1.60403745174227129552681814585817614136e-19,
-0.00001102461208279981597772016819575984512591,
3.554930548449376907814124903454987783954e-13,
4.092764924026903215565840634500378302313e-13,
3.141312983958006419615427859744849123415e-13,
1.80828490074508847624674890986607376348e-13,
8.327457763994733711272517056565794108959e-14,
3.195778522942787477874019820851934993347e-14,
1.051220728455492099293523455355796437605e-14,
3.025650762028473808045636712108590540624e-15,
7.740880341913780701608450204191688816617e-16,
1.782394252066816821177802254605660958027e-16,
3.730954262788028364828617133891967511137e-17,
7.156912627867783172479551735642112914063e-18,
1.267649837779978115277289488682548888997e-18,
2.131583729206134908693181868330088376067e-19,
3.262806240781240793370038793769004883376e-20,
2.115213155314373122016074394621954437313e-6,
-6.532225890940113255870921628016534073962e-14,
-7.52050276997263539510030982326477269406e-14,
-5.772198867161562598624795288031166140745e-14,
-3.322744394663222296011790148831554713916e-14,
-1.53017999987985816272239700226263544448e-14,
-5.872280135374533248931073682962519085354e-15,
-1.93163037161761917218601779767318993418e-15,
-5.559669086725781609604485364342104240417e-16,
-1.42239615926905565125693700118019751997e-16,
-3.275172153779093726066867334406160378094e-17,
-6.855680525448182899998961275793854438674e-18,
-1.315094402269193938795237698032000373366e-18,
-2.329333440889937623621125582239401018258e-19,
-3.916853818861563651379383835042526578081e-20,
-5.995578200898917794803959553269719825511e-21,
-3.695467009563326094435109573958872082598e-7,
1.094935526758724255664655244411307636334e-14,
1.2605910770876000673193220850850580125e-14,
9.675393556572929304296273072236979530078e-15,
5.569603646330962078698045527366972843958e-15,
2.564896716386913099814531361651363770006e-15,
9.84315068963082025191138160309572715791e-16,
3.23781037409335583256509490849588536678e-16,
9.319151256075357338853629787332298798121e-17,
2.384229483467994422984876702545759885002e-17,
5.489866040072225536094463629928903145137e-18,
1.149154568195381134414329046212396326779e-18,
2.204374232221113610637000983801626889253e-19,
3.904461140601685833626966539210309816083e-20,
6.565521047806332041709436044731886684206e-21,
1.005002915984311803383207396317078880504e-21,
5.926549017704000435952224020094591974711e-8,
-1.687535398271254293444519042624236735874e-15,
-1.942846876046364163465490169750994865183e-15,
-1.491190008267807293805482799258050738301e-15,
-8.583978827173887787931474088002660114149e-16,
-3.953067524422498676826964090181669644622e-16,
-1.517045101863310973970503071998807487225e-16,
-4.990175091272456802264303698590275066784e-17,
-1.436285462146323793326444904065317831372e-17,
-3.674620709985196081170988808096044495948e-18,
-8.461090337014827185877594233023149777796e-19,
-1.771100776705801011629884126419750636129e-19,
-3.397430875654143119908608713648568758332e-20,
-6.017656175318360997827369208507533449811e-21,
-1.011900151418685997501216210043904599863e-21,
-1.548958715484013221715464471949587570192e-22,
-8.787320222872660098479858501766435180805e-9,
2.408171880718371397239906054206733008539e-16,
2.772510268471050477231440285694190325765e-16,
2.127980166325031489606430910724952429799e-16,
1.22496373125985892945938228149983523466e-16,
5.641165339377673769691883127343417549801e-17,
2.164876347537417277368476723444846288013e-17,
7.121154379406815682764262238876118196886e-18,
2.049629717676130228159276807714586393608e-18,
5.243813274586440073777263051896140204509e-19,
1.207427723598493394846175279728286794732e-19,
2.527425176861482477967625820843221322882e-20,
4.848262258659277838078164178322249545785e-21,
8.587440340379248131005270697597724948669e-22,
1.444029453828787867673483431536769573292e-22,
2.210456527923635923030078229065258788321e-23,
1.230519040883241383370037461286965178726e-9,
-3.246754713461952640735129947178456953759e-17,
-3.737964413131036619242088496306592284541e-17,
-2.868993575654155342709789635887685381277e-17,
-1.65152530289437211227775791762755903122e-17,
-7.605553641157658771808409335525887352796e-18,
-2.918737964105198848102428169196369284715e-18,
-9.600910597351520480466411767318229947252e-19,
-2.763359958876071247360944778604565350198e-19,
-7.069835722612603912274184171294463931371e-20,
-1.627883618582722184333351787838328074675e-20,
-3.407538159632638366792956334638115387355e-21,
-6.536555359310079695145526550131528516304e-22,
-1.157783657952321167327447713176149379385e-22,
-1.946891099510899512823784505797827331566e-23,
-2.980239332672249838637295985414807361615e-24,
-1.582348936886972600768739923691337588897e-10,
4.029840033780371462203641864534130608596e-18,
4.639524688235929724688633078764231649387e-18,
3.560966632166422824022949597350325327499e-18,
2.049856983226336590808621076834673137402e-18,
9.439938535533797901218014402741952530215e-19,
3.622708964942391345713848898939227348152e-19,
1.191655649510576330400562230051287132138e-19,
3.429855588504698152999409340855765454263e-20,
8.775012512312597695465521572020751850721e-21,
2.020514027174060074393315971846599757632e-21,
4.229406564093793075132211257139752571647e-22,
8.113122388063925840706625831843715166189e-23,
1.437034707747744003502885074359434253221e-23,
2.416480165126549156798966293291243968247e-24,
3.69909867739134188162501775171053442543e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=16 maxabserror=9.13245446975257826058e-21 maxrelerror=1.761427742924948705275e-18
0.01182117197863188281249469206170669128564,
-5.887479635063899599924391995116076541843e-10,
-6.778211108116539805009411109597778909759e-10,
-5.202468803840661578069156444069226698878e-10,
-2.994781224774915968267789862198111122761e-10,
-1.379147210878520421367502476272949035341e-10,
-5.292669099939684331560889937491087036934e-11,
-1.740971848660755578300883147720927788853e-11,
-5.010904877086471401064177476963825942251e-12,
-1.281996297217869247827986754526081264806e-12,
-2.951877296328808182510542008167326300872e-13,
-6.178893022626905396206046402041658904445e-14,
-1.185247304505760406326456344350939261737e-14,
-2.099266087129586115507507018418402886247e-15,
-3.529686507766260487817982559634099380978e-16,
-5.402084913827221235700555456304157705138e-17,
-0.02221924211115540807249777345862240716177,
1.036219285211954692363415937694544610182e-9,
1.192991488166317738084248301804040029766e-9,
9.156547266183617639472331322813845254766e-10,
5.270931400594984438993431871367627505072e-10,
2.427352776617509237951802044984435082508e-10,
9.315304106404650046114479036121329590159e-11,
3.064178682631257847000123021490599644419e-11,
8.819390723078740555024565044385242808367e-12,
2.256365076519869993703207491825512758306e-12,
5.195426989984379837994723126081288914925e-13,
1.087512645188379136149133588588797805219e-13,
2.086094565678419669119580087877312100996e-14,
3.694836926402856649464666830463437970243e-15,
6.212555039912945008465411964847943831286e-16,
9.508394908157891447560443606984772176846e-17,
0.02095730325014293710787412784033912410026,
-9.188698532824256622753626595320253991656e-10,
-1.05788797056138618139335383536272495345e-9,
-8.119589581078157152062247708561701010937e-10,
-4.674010727600814620158868206121674383976e-10,
-2.152460789745969057194074655278318690591e-10,
-8.260368209372100942984413690268417724538e-11,
-2.717168017127624024085315050803791404898e-11,
-7.820617878329622957830413841334730574472e-12,
-2.000838354290232535353521126935247743627e-12,
-4.60706335148156267740750211853661441241e-13,
-9.643570511702276956539963930605475842999e-14,
-1.849859481371985174950158456467191471472e-14,
-3.276441706748207884208942021234258860367e-15,
-5.509129151785522900378829237588308187175e-16,
-8.431991038319137393977831351760197164579e-17,
-0.01322045065502881964050648777534100255028,
5.4689592555629942190399483458303411585e-10,
6.296371788889505312507176288729068412611e-10,
4.832643573260939476517614017119879061539e-10,
2.781892840259549864301132554456092870445e-10,
1.281108607606153767925087785886405245851e-10,
4.916432983476554750965194789341978398808e-11,
1.617213077048256612615156420709801164662e-11,
4.654702017305358674217770637377794178553e-12,
1.190866161311267010913516270660488111804e-12,
2.74205020931813789519234603241877475646e-13,
5.739705555572768724641630277779543122629e-14,
1.101010737463217047329278044580876083476e-14,
1.95010230491929842279351009993741511957e-15,
3.279010317653799021468612742416562539159e-16,
5.018789459777759333584658894649292892647e-17,
0.006272915705143571821660548026799773705838,
-2.456090804348614853118203304632992118155e-10,
-2.827678935213240141389755863540207931331e-10,
-2.170323632415507057908346179199269491609e-10,
-1.249338531621067066904910338887139806984e-10,
-5.753414908260229757306499934729214734589e-11,
-2.207953300891161680245124997667426445558e-11,
-7.262849321580669619896081290117061236094e-12,
-2.090411244589486278933657586207875132139e-12,
-5.348141913304859842473052523797012786289e-13,
-1.231446669123608938178139993302684316531e-13,
-2.577687672337969471610718681194090900109e-14,
-4.94462291799069751675573472277166919255e-15,
-8.757918824188517764434074633903064856539e-16,
-1.472619804775300943751892324213408428986e-16,
-2.254004789442169221955079765505848259326e-17,
-0.002387317462122689930269239365286815985956,
8.872316302735638673590291962950557818705e-11,
1.021463128289123384511365350597014669782e-10,
7.840018708735697392254241933906789095092e-11,
4.513076939312207791020969892362398846332e-11,
2.078348172604134178166853549220827270379e-11,
7.975951537537401527461113691520844258798e-12,
2.623612452815744265544628726876143163006e-12,
7.551347137331244286922576801585444204312e-13,
1.931949328481189959890839384073520010253e-13,
4.44844913970838387677716637453999015659e-14,
9.311587754799840764258961677936579042395e-15,
1.78618922796522998917519180117054422254e-15,
3.163711693457283834002759182448728422581e-16,
5.319741087070510276680265040559861111833e-17,
8.142576518479440553311588288188567183602e-18,
0.0007589113576500102964358063371183374715616,
-2.684011240100920436423189007675456770452e-11,
-3.090082035895486172969693147781793916264e-11,
-2.371725457850339680978204618969799632471e-11,
-1.36527474505022020164836985560274547738e-11,
-6.287320931221992947905447262262364071716e-12,
-2.412847331731998264269249132927616053855e-12,
-7.936829385799265672283143820895457143184e-13,
-2.284398383123357230724460012771201931153e-13,
-5.844444458037933081470382508504211360722e-14,
-1.345725013380092058934405770847364059895e-14,
-2.816902517109447861586169146987462175054e-15,
-5.403514247586664339694387202513341620307e-16,
-9.570778376520739113880583544471635229258e-17,
-1.609327156538761332182779127470360422549e-17,
-2.463327340058370379383980207581707840414e-18,
-0.0002072309751746386674740318296686086067328,
6.990769445725912403060325394946509259921e-12,
8.048420510363874581556440889524624507518e-12,
6.177390650949904068794973350302733842524e-12,
3.555991470484409385163202524110719040284e-12,
1.637594188457326226787554128041397755268e-12,
6.284496862004992907210974895148577389834e-13,
2.067224941766831008089750679107638286386e-13,
5.949939899648112071549195298481859056008e-14,
1.522243249786562626581106786214614875671e-14,
3.505075028345302796872683537104745372869e-15,
7.33690941604285585224357568567274403725e-16,
1.407402522788663042014148507173259648403e-16,
2.492818520609373937852317713820597978207e-17,
4.191706756515162773473321701347659334931e-18,
6.416149824370026560207327775541320483867e-19,
0.00004961075428487962495951922702366650797845,
-1.599718744713901168664101744627416526404e-12,
-1.841744213407841043836518709708515956634e-12,
-1.413590840935761075334035127529028885418e-12,
-8.137282042730257672486534707624711263104e-13,
-3.747355988905724286674336840215948419594e-13,
-1.438100333446916745779504675650576027438e-13,
-4.730493271874390643620587372115802657737e-14,
-1.361542841135414604017796695261105121512e-14,
-3.483396149313867554311577953587409696392e-15,
-8.020774123830086322101414877836033563651e-16,
-1.678929416062872753260700309854532038316e-16,
-3.220610678336157798871826048588126245915e-17,
-5.704424262562943503645857128019732161737e-18,
-9.59212676890490621523664442808642465394e-19,
-1.468262806434583319736823663225197419724e-19,
-0.00001057605755861684999447952033045537852316,
3.266110923111476820037564489597874193545e-13,
3.760249056660009875706552050726669397648e-13,
2.886097646524377613972140306696553121246e-13,
1.661371168619343219102048143331882598567e-13,
7.65089526200506214540691597843851383784e-14,
2.93613824964568754321561264397753462895e-14,
9.658145877813127623127447872349332474759e-15,
2.779832822103852965779819736996473467756e-15,
7.11197639264058997240151525846968174192e-16,
1.637585062902512862535217440341941230997e-16,
3.427838140212141311729130615262639513469e-17,
6.575467939802385287312555895447773380288e-18,
1.164665999272687860460840195862581246009e-18,
1.958425696721728752533262943865494378446e-19,
2.997787244046351507070228865955633219105e-20,
2.032507416705808796230208875962931038988e-6,
-6.022146733788147875186029817125216219902e-14,
-6.933252462816843894745899410732657213829e-14,
-5.321467637214604601979435094356962552156e-14,
-3.063282685377492823234880990005299912996e-14,
-1.410693507116180604269554808182078272361e-14,
-5.413734080875160121312674091865398456892e-15,
-1.780796100999085870367134308072030315319e-15,
-5.125534328454317060577381179214174444516e-16,
-1.31132650695665204424354737238545188041e-16,
-3.019426992203252304174696159692491134607e-17,
-6.32035152788409096453130116236295279287e-18,
-1.212406096818062588784466361056147030262e-18,
-2.14745410396882045016384792181498712234e-19,
-3.61103737780112543274075527623255016366e-20,
-5.527517264861607508470121206529651581668e-21,
-3.556395661458051938820315487584067695981e-7,
1.012635977679263285921499600363112900269e-14,
1.165840223454012618198703359806052021307e-14,
8.948153937846735918885529401178492140453e-15,
5.150970937239524095303742956828868465585e-15,
2.372109291189387260511697041864201037891e-15,
9.103302078890048005735906547808871259634e-16,
2.994444346262566437706528781703706980738e-16,
8.618689330916467491991134617127119958495e-17,
2.20502227061753372857741094406741353195e-17,
5.077229488767932594033310675855775130711e-18,
1.062780886951509151445050684200559349963e-18,
2.038689524825497206300725871265976368495e-19,
3.611002863007007654175666785056892282565e-20,
6.072088940208776906245861878008441871942e-21,
9.294805525069381477880690380058703855779e-22,
5.711581193413818174023202438947179282681e-8,
-1.565269596400908991985047914541656302864e-15,
-1.802083175081382205378126038350275367195e-15,
-1.383149883428672195386576528380469586221e-15,
-7.962049970709282543190966548820610993006e-16,
-3.666658789883611696955206061912293984179e-16,
-1.407131755789569071146859436444982052317e-16,
-4.628625776485017193239566838239010596855e-17,
-1.332223462373672232867301343417440971453e-17,
-3.408386898561717186052863149672006231427e-18,
-7.848068988122001518345398392561439092757e-19,
-1.642782152648910054488693739829410152128e-19,
-3.151285657069003016486217932738208570359e-20,
-5.581685999403273331126408902015212424783e-21,
-9.38593883892768378307172781256949234284e-22,
-1.436758073464888071716450336220879396332e-22,
-8.479718707402145866720939556379954936772e-9,
2.239773796672459913954835091343407743921e-16,
2.578634816639545191098834234681680107578e-16,
1.979175268910723314604019865950157298887e-16,
1.13930475930248243269392570406665508858e-16,
5.246691312346464807010097723678593240045e-17,
2.013491434793153671527726170192100908559e-17,
6.623188335740871618495813315968380250054e-18,
1.906303910762203392916153602450857823507e-18,
4.877126268418537936375832435501885786867e-19,
1.122995529203693169900556487171863163305e-19,
2.350690201405652857637596999730556674085e-20,
4.509242607122465083029508245343649866886e-21,
7.986969977184064454291412706884185290846e-22,
1.343062573817549407673039705795652069852e-22,
2.055917288274086863064619552018250730961e-23,
1.18893968173152242796775786806049863012e-9,
-3.027565028995455811463714766568936195291e-17,
-3.485612972116985349169972909497076237889e-17,
-2.675306700682727753082176398840711148546e-17,
-1.540030191012554083214553839009977842405e-17,
-7.092099822227742342566259932468941269948e-18,
-2.721692891391560629397038531341348905898e-18,
-8.952749839745928313460365215978411650025e-19,
-2.576804724429801510478926547195637836384e-19,
-6.59254978025281643596936839140640815433e-20,
-1.517985221805135043049769435729887884529e-20,
-3.177496708080054405128660154699973546016e-21,
-6.095280592852875747176309342939716586623e-22,
-1.079625006707679693175897496270202707519e-22,
-1.815469335963225731595469778861435802756e-23,
-2.779083589932911089979122319674971653819e-24,
-1.530619764256338829952411903488524845324e-10,
3.766614907745662753262335854830765403416e-18,
4.336475572979616675055612632684706946329e-18,
3.328367856383490143906788370188544344623e-18,
1.915962383161503635481039261154980269349e-18,
8.823331284505938628090881555908633887119e-19,
3.38607731742058422627385110392322094962e-19,
1.113817948677260906934631244449929470062e-19,
3.205821171959073089453201057643710767642e-20,
8.201839127835310869369776025471740885564e-21,
1.888536838950192422361295719419100221629e-21,
3.953149178044760985279129948580259645855e-22,
7.583193668923712575280003024524771625225e-23,
1.343173410159493797813920448255790934055e-23,
2.258653863017322807896307483902082263862e-24,
3.457525164713514704820093135311803713209e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=17 maxabserror=8.85266498159362505025e-21 maxrelerror=1.823125486505742521931e-18
0.01110962105557770402838969376426009984009,
-5.181096426059773460005143951024447872552e-10,
-5.964957440831588688335173442864673899353e-10,
-4.578273633091808818135049316868066737193e-10,
-2.63546570029749221857503935508428871808e-10,
-1.213676388308754618551453341638167844683e-10,
-4.657652053202325021428361885225043717877e-11,
-1.532089341315628922964257671354817691663e-11,
-4.409695361539370275970117168801098451627e-12,
-1.128182538259934996457052902711645925811e-12,
-2.597713494992189918088877423043860860631e-13,
-5.437563225941895678843996817496436449013e-14,
-1.043047282839209834194998308300538446641e-14,
-1.84741846320142832408619404284757469638e-15,
-3.106277519956472503146163486307238414853e-16,
-4.754197454078945722116932591622132110351e-17,
-0.02095730325014293269661196314668982756559,
9.188698532824255572549974945737390636362e-10,
1.057887970561386060484192772775686874152e-9,
8.119589581078156224050181116757006123367e-10,
4.674010727600814085952226178827656750788e-10,
2.152460789745968811182866585083194455626e-10,
8.260368209372099998881835522400726332267e-11,
2.717168017127623713531738341592683521163e-11,
7.820617878329622063986604150361341160736e-12,
2.000838354290232306670652184529340242059e-12,
4.607063351481562150847424782875021212059e-13,
9.643570511702275854326183768524968573773e-14,
1.849859481371984963516021151285627985392e-14,
3.276441706748207509705593478318187073368e-15,
5.509129151785522270619216007275678945026e-16,
8.43199103831913642994182577747502797028e-17,
0.01983067598254323298228339960496101286816,
-8.203438883344492140438381046157494530423e-10,
-9.444557683334258903470363085347842835922e-10,
-7.248965359891409932192520759269373448247e-10,
-4.17283926038932520942956888177396038789e-10,
-1.921662911409230842070937706929279855739e-10,
-7.374649475214832856302959976619467951932e-11,
-2.425819615572385159001665805314012112748e-11,
-6.982053025958038702328441539032017552606e-12,
-1.786299241966900693157631587097229494749e-12,
-4.11307531397720724985522015186403983386e-13,
-8.609558333359153939048857957512515817202e-14,
-1.651516106194825734447038507992820166698e-14,
-2.92515345737894792370750753344203246256e-15,
-4.918515476480699019052662300310778386258e-16,
-7.528184189666639745651038793936754169053e-17,
-0.01254583141028788497235653341599725160544,
4.912181608697406193417079240913997381764e-10,
5.655357870426683471150833043064922119922e-10,
4.340647264831170068648322596564996499016e-10,
2.498677063242223907468482184561214722674e-10,
1.150682981652087293751872146533793977932e-10,
4.415906601782482017339354433129676441569e-11,
1.452569864316186112642925926658950333784e-11,
4.180822489179122768708511883307884579649e-12,
1.069628382661010398750255245446105682596e-12,
2.462893338247306365006435563833064404747e-13,
5.155375344676124170726916151399042179586e-14,
9.889245835981750349499593025351562552087e-15,
1.751583764837766488337612527583552415541e-15,
2.945239609550707718881212309685275035144e-16,
4.508009578884500450581549523180132139119e-17,
0.005968293655306471242066602155611473162118,
-2.218079075683851205796593715558839271764e-10,
-2.553657820722741153723047724638214100899e-10,
-1.960004677183872687607818219691060980006e-10,
-1.128269234828022209608877771861724859227e-10,
-5.195870431510198496214744224383875932956e-11,
-1.993987884384297825683993696199011691097e-11,
-6.55903113203918778529077725145494577664e-12,
-1.887836784332761313344714621963506622584e-12,
-4.829873321202847596820943953003119195947e-13,
-1.112112284927066656705617310021975334172e-13,
-2.327896938699898833126959085799723027747e-14,
-4.465473069912957271889006544991676720043e-15,
-7.909279233643001106375013071278648004719e-16,
-1.329935271767592511579840300555915318197e-16,
-2.035644129619806471847287399078426757495e-17,
-0.002276734072914437992677064096169886465077,
8.052033720218027117993428182018099768435e-11,
9.270246107588904678142768382690757551745e-11,
7.115176373476143706295083595168765915692e-11,
4.095824235107558900132280898940289080817e-11,
1.88619627934674881916587270992913517135e-11,
7.238541995119821216074395370773974259687e-12,
2.381048815714723127057497823506232154376e-12,
6.853195149297953172846790807575861952809e-13,
1.753333337392928971683808843500065359887e-13,
4.037175040097791424195620679940278118785e-14,
8.450707551239413030005374992423504520274e-15,
1.621054274258940038563391511918182447343e-15,
2.871233512926005462859663627391457371133e-16,
4.827981469565472735531139792800661768915e-17,
7.389982020097329260134751072017883111036e-18,
0.0007253084131179982890787472186109035962225,
-2.446769306019660936749328057878693080562e-11,
-2.816947178645306591066211188865482095965e-11,
-2.162086727846243931835233862302740042348e-11,
-1.244597014677474255146650532447306414085e-11,
-5.731579659637165255873260683037922872637e-12,
-2.199573901715763909460903669856433395492e-12,
-7.235287296230014119446371017019993686578e-13,
-2.082478964890109463143702566093456895498e-13,
-5.327851374286920050646087203986927837007e-14,
-1.226776259928673429106181302176605624704e-14,
-2.567918295631363311471208015637722505546e-15,
-4.925908829791710751769867362157497634315e-16,
-8.724864822188408678538619136561499645708e-17,
-1.467097364789656602167352599727865135885e-17,
-2.245652438543821797654255174996099754257e-18,
-0.0001984430178854305120707013008360742177901,
6.398874996612923552374085114061100361495e-12,
7.366976874075232608439297775039612217381e-12,
5.65436337943429253019677614670611068787e-12,
3.25491282612471086295845414550125411295e-12,
1.498942399721958615457016258295558768033e-12,
5.75240134975098086798685981166655597316e-13,
1.892197314000736752444539550025941421417e-13,
5.446171379655174287612121234109338296351e-14,
1.393358463592220519127181903938204743453e-14,
3.208309658435350749060045192587809517244e-15,
6.715717682888220712919669984217838248462e-16,
1.288244274909487258398759167542440247833e-16,
2.281769711357449620598869583800098056919e-17,
3.836850718210223276235345605920270557455e-18,
5.873051242038690860751539063654062411133e-19,
0.0000475922589287484032993237623334650193918,
-1.469749913439916871500951926772238363084e-12,
-1.692112073240185927256676990683283187139e-12,
-1.298743939203797773061395226191500723544e-12,
-7.476170248815860863705165649923310774897e-13,
-3.442902863310378970774091680776440574444e-13,
-1.321262210578353614535255582625186112404e-13,
-4.346165639219298749329995882202103716832e-14,
-1.250924768278337974348223476229141842619e-14,
-3.200389372419806258754629078309694555005e-15,
-7.369132773232847040369236525426485241176e-16,
-1.542527161038135413393682426508892519191e-16,
-2.958960568964563875977609226692254983204e-17,
-5.240996989736818653733802701252082538315e-18,
-8.812915623492989228467370778890822114907e-19,
-1.349004258021424117620562944468966093513e-19,
-0.00001016252912574661185425157001766541598414,
3.011071472469938155239266959902527292352e-13,
3.466624050372081094257934009916657614888e-13,
2.660732144600118557382959487241214357151e-13,
1.531640379052832014689682177009630522049e-13,
7.053463097874278048265318606324591943427e-14,
2.706865337405308183214003826623722483297e-14,
8.903974903032512042300359588257856124398e-15,
2.562765551854849312726031993870912848075e-15,
6.556628409656235401719537589058119645645e-16,
1.509712546259070857831853157987152474003e-16,
3.160173775698729777500493815121104982598e-17,
6.06202667010687077938511058859052720471e-18,
1.073726376431449798673647939764683746688e-18,
1.805517552900110014487310625149779026011e-19,
2.763756893441311266891220513239281152794e-20,
1.956018158017124094708940793751561681686e-6,
-5.569499131880557088862965563645926075132e-14,
-6.412122673460026420153296855550932435917e-14,
-4.921485774481949683402148480694346649159e-14,
-2.833034653681277679673366795465848568999e-14,
-1.304660404055863584713329985287737337154e-14,
-5.00681727127861131386602571442516708663e-15,
-1.646944761452822444446500072353061437332e-15,
-4.740280199850673875591553868338116694935e-16,
-1.212762522039778776342514919743745188864e-16,
-2.792476847887017628772449340279024541569e-17,
-5.845296195013679468262190236280980792436e-18,
-1.121279491247962480070600059498976707866e-18,
-1.986052022062261545939481355781005852721e-19,
-3.339649669473018135213689062134559692235e-20,
-5.112144190504980917870437009031403337757e-21,
-3.427400205958214704071533769737985115414e-7,
9.392692382429398942159325612706794862402e-15,
1.081373646432358071775030680910611795753e-14,
8.299849050748467878273258072193919904121e-15,
4.777776702528449418568130650366000032801e-15,
2.200247047798939651332825318747879394932e-15,
8.443756752335764815147651634792828730366e-16,
2.777493293993590898039103624429541094195e-16,
7.994255555791398462603257907625541698825e-17,
2.045266178761105310485129855768086885481e-17,
4.709380287295711081509685332080329068295e-18,
9.857820948352689118567667605175146855153e-19,
1.890987781093481454332265732429520507397e-19,
3.349394875502470909476569500648883871681e-20,
5.632207814707948092045381113545040707091e-21,
8.621535058767254054730549076957796349918e-22,
5.511645638980935862095798449031496121382e-8,
-1.455813425226365199737856908941791128169e-15,
-1.676067105703638141369733123423762802845e-15,
-1.28642898297861377093247116019747920213e-15,
-7.405279794236366959992007736717385519337e-16,
-3.410256724081061542726648738289215964586e-16,
-1.308733884956304346709972840137449576863e-16,
-4.30495548757992265197371862718105382717e-17,
-1.239063886693535050014416448786604743857e-17,
-3.170045970036401500742193904437701296751e-18,
-7.299272677634143920059805244535708737193e-19,
-1.527907129971029961444596234185528278128e-19,
-2.930928084644958437748801144298251724071e-20,
-5.191389475545335102612467245323787961238e-21,
-8.729669609223284742693448365938453826427e-22,
-1.336309938740547697053993193197695767391e-22,
-8.192902731768098975574090481858996152203e-9,
2.088425688376570415037114746940701433428e-16,
2.404388873839459001235544158028048138011e-16,
1.845436574970704648585453854844499918246e-16,
1.06231858951715389186196983959583716721e-16,
4.8921569995579584416814832825706775949e-17,
1.877433941734808620023273153955726787894e-17,
6.175640338381394570998690442047012097606e-18,
1.777489538074980698529718729179697620514e-18,
4.547565486207980158252596298656157272032e-19,
1.047111875243802914689316206275431064626e-19,
2.19184907074685705702330595145174072672e-20,
4.204547170978470023669736292341300079616e-21,
7.447293012117023223305314464236150629114e-22,
1.252317293430580889891840440262076716312e-22,
1.917021504015495714468260333448418324676e-23,
1.150075960495743503750312002038719485056e-9,
-2.82982820588296589889679056952207927486e-17,
-3.257960049309932461226525620723962518968e-17,
-2.500576637194721799986809345506538477028e-17,
-1.439447494944499117663060010581487997795e-17,
-6.628899516201189312922697156220044189027e-18,
-2.54393330233149269380122652325474643086e-18,
-8.368026796143863425351767231628341867829e-19,
-2.408508276124143085689421165581149555226e-19,
-6.161977342303337392066935806003748840467e-20,
-1.418842900685247826477208629722272933511e-20,
-2.969969946069104401158528575938621757406e-21,
-5.697193891292952818816468552469071776296e-22,
-1.009115647062447033690492811722020135504e-22,
-1.696908949781585409815037836145751158316e-23,
-2.597611620512343658067090673949150577557e-24,
-1.482162910520902831666529727767107091186e-10,
3.528343841213069386419963561928853367728e-18,
4.062155879119786117061799101278413705378e-18,
3.11781972439743183558000715203010743364e-18,
1.794761151700342972845736137969370869714e-18,
8.265179134756849194674921240930127015962e-19,
3.171878627630902461299965255577108089023e-19,
1.043359350488537177144519895109088296891e-19,
3.003025457639219658075432471534290816205e-20,
7.683003113783787628169125972814774620461e-21,
1.769071174518683503860974722305746424603e-21,
3.703081020123715680557293569314067440334e-22,
7.103501664580178360572169869081446778112e-23,
1.258209862844336790156421871999182318549e-23,
2.115788192414711710424013984250125737596e-24,
3.238848577539742876109351375440216461658e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=18 maxabserror=8.58949778537176029129e-21 maxrelerror=1.881233783392985885588e-18
0.01047865162507146634068082422783710487019,
-4.594349266412127784570877376599277518037e-10,
-5.289439852806930300459034650889277679448e-10,
-4.059794790539078110519254298859470568851e-10,
-2.337005363800407042109284127877041640035e-10,
-1.076230394872984405192243867438347382476e-10,
-4.130184104686049997908972218959253821208e-11,
-1.358584008563811856261950212213798645275e-11,
-3.910308939164811030542908602529413414067e-12,
-1.00041917714511615296425433001069090601e-12,
-2.303531675740781074569290526910361347683e-13,
-4.821785255851137925374585228310923068908e-14,
-9.249297406859924814149266057134973625971e-15,
-1.638220853374103754245106556581879386208e-15,
-2.754564575892761134287718228233203928033e-16,
-4.215995519159568213406585860482702989056e-17,
-0.01983067598254322870640652171464092729558,
8.203438883344491154642139524878285816192e-10,
9.444557683334257768530521305966000978045e-10,
7.248965359891409061094036379175652208129e-10,
4.172839260389324707985014157341054303782e-10,
1.921662911409230611147224541235296429287e-10,
7.374649475214831970100753591882461713423e-11,
2.425819615572384867493860008593449739161e-11,
6.982053025958037863302653933453370565826e-12,
1.786299241966900478499500897775833015262e-12,
4.113075313977206755588104469113137534688e-13,
8.609558333359152904431454268865350665633e-14,
1.651516106194825535979557242088800369248e-14,
2.925153457378947572170887346157503159142e-15,
4.918515476480698427911658771545347070379e-16,
7.52818418966663884072697139782639701353e-17,
0.01881874711543183087519349803063127589402,
-7.368272413046110053690816889316130325713e-10,
-8.483036805640026085813153229255139901339e-10,
-6.510970897246755777696590168901003811809e-10,
-3.748015594863336249605109438424618976385e-10,
-1.726024472478131119493688480576391716861e-10,
-6.623859902673723712431994518759067608001e-11,
-2.178854796474279394756713134248476012355e-11,
-6.271233733768684802944475359531963549167e-12,
-1.604442573991515764392506255454517233326e-12,
-3.694340007370959930352758189438822648483e-13,
-7.733063017014187057471366091721564678405e-14,
-1.483386875397262706151496947667096440529e-14,
-2.627375647256650004795794917741391147645e-15,
-4.41785941432606203620272166568079530702e-16,
-6.762014368326751376804549097699134241239e-17,
-0.01193658731061366106158658189685643385089,
4.436158151367868075267673508055515569928e-10,
5.107315641445673034795816058037460561379e-10,
3.920009354367891763860351827577635140941e-10,
2.256538469656128687288567733316652054253e-10,
1.039174086302078506117268207248613718343e-10,
3.98797576876874457820262670559026452513e-11,
1.311806226407886545127105978627615160272e-11,
3.775673568665663625497413674117945198231e-12,
9.659746642406055927972106879258497285435e-13,
2.224224569854216375308946060591784066425e-13,
4.655793877399971534355286189017514663618e-14,
8.930946139826248069620912141965435765267e-15,
1.581855846728659297223818604036024683684e-15,
2.659870543535284364775103025678432910938e-16,
4.071288259239765016750661307014923418525e-17,
0.005691835182285848949316974415605334715409,
-2.01300843005445179586514586799781275392e-10,
-2.317561526897162867289863330797168804812e-10,
-1.778794093368987340306515733729998297563e-10,
-1.023956058776861756531632191151708231624e-10,
-4.71549069836674324822632935930043791993e-11,
-1.809635498779905875327354435975148953796e-11,
-5.95262203928664522665124874281799126492e-12,
-1.713298787324441495822907980801062714352e-12,
-4.383333343482202701771035335067401461905e-13,
-1.009293760024420287866240309355750847244e-13,
-2.112676887809795550787313766199555158908e-14,
-4.052635685647239399316678866751553442938e-15,
-7.178083782314817584053737067325311609047e-16,
-1.206995367391335212296685906896513310848e-16,
-1.847495505024281841543598367267161458024e-17,
-0.002175925239319494309800491344564050820115,
7.340307917979445077756278882654198456534e-11,
8.450841535844348576507537169788315268364e-11,
6.486260183468448307593660692184145576677e-11,
3.733791043991964340896014533415971365555e-11,
1.719473897872517786793283670023110719023e-11,
6.598721705075789615615766300413977303411e-12,
2.170586188845484294388482812064786939844e-12,
6.247436894602632646798699835205928778474e-13,
1.598355412268756593329759268291471644891e-13,
3.680328779746140965421642800565555184459e-14,
7.703754886810613127668527815154775813949e-15,
1.477772648921500125875691003605426310395e-15,
2.617459446628159312489869256096009020002e-16,
4.401292094321274336277079643837915903275e-17,
6.736957315558452729470359423495812740079e-18,
0.0006945505626055683586778579816555040024188,
-2.239606248829187026144112842712645800877e-11,
-2.578441905943213716472233610151092229269e-11,
-1.979027182814960031856029516075712478037e-11,
-1.139219489151107822233754852264435103873e-11,
-5.246298399061205206035101440960246677828e-12,
-2.013340472426025619164899102933088219292e-12,
-6.622690599045940609877086490244251811112e-13,
-1.90615998289179156452242520638025255724e-13,
-4.876754622604702357949209913224363727612e-14,
-1.122908380459725019916949030142162431953e-14,
-2.35050118902626726055029056383977690899e-15,
-4.508854962212727609782976441049673683502e-16,
-7.986193989803365110843650410844308980033e-17,
-1.34289775138237145752475499315331332656e-17,
-2.055567934727002757820645038800976166639e-18,
-0.0001903690364380140046480523684675261988674,
5.878999670428002917369193004748255562191e-12,
6.768448312150873657203033543535060592433e-12,
5.194975771544159534076126325951006058666e-12,
2.990468108005019437136619034085020119992e-12,
1.377161149228725117841631496034373013426e-12,
5.285048857297764179001360908810635944864e-13,
1.738466260616679140183275055111529024247e-13,
5.003699087300019157811928485807365288704e-14,
1.280155752597469437795317321487336248771e-14,
2.947653117650454186017775206364780810965e-15,
6.170108661646369706394152110821061987124e-16,
1.183584230941612899662591957142993018281e-16,
2.096398801838684313051433842882982661634e-17,
3.525166259392503240318887665950568573677e-18,
5.39601704738660502003030697784883488882e-19,
0.00004573138098336425672006133711744395262855,
-1.354982160767872869833507828604391457773e-12,
-1.559980820544914402039378097818269904617e-12,
-1.197329463440957507729545690182156033149e-12,
-6.8923816963599153082396650546442589032e-13,
-3.174058389724776072490180145399136558567e-13,
-1.218089400175046392424819733248162251161e-13,
-4.006788700912960122742365632446423640111e-14,
-1.153244496765567380020883833765469478352e-14,
-2.950482780330849102277171332753850475526e-15,
-6.793706448922216846107501393781720987132e-16,
-1.422078197129524294730409515341759261778e-16,
-2.72791199783642222962257581116689334243e-17,
-4.831768687367200050970501860571971498735e-18,
-8.124828976995133747886334270878879728853e-19,
-1.243690600356215704925609311154298770776e-19,
-9.780083076520606117092072195073058508206e-6,
2.784747787692300225576247022915096055753e-13,
3.206059289446412244505038983113908646273e-13,
2.460741315892806197473341601202397655424e-13,
1.416516422299996334660192729696084397346e-13,
6.523297854716407518157909389271753018929e-14,
2.503407037045990359623087119264236569114e-14,
8.234718548843106685555326680724864948446e-15,
2.37013858643213424426351624722228535055e-15,
6.063808738045897538044095999879377430718e-16,
1.396237532350030664462022105744258224478e-16,
2.922646231191843693755569975307485726321e-17,
5.606393876145029327186548368636795640236e-18,
9.930253769048674172510488174963407683733e-19,
1.669823768395149006181439719272589430167e-19,
2.556070462887344892853490546305921790846e-20,
1.885070641286777472588634279483915530405e-6,
-5.165981990320968297973266919332270494021e-14,
-5.947556413885646143405030934862709338682e-14,
-4.564918020604790674451204698775420942973e-14,
-2.62777778661301549193898185612882855986e-14,
-1.210136152701988115163430845263676547468e-14,
-4.644067274556774838913781477634688627604e-15,
-1.527621660627399304793393384590763711036e-15,
-4.396841559987898432367146731775252800257e-16,
-1.12489665526153653989741356957059771213e-16,
-2.590159749643906299120267453961829250313e-17,
-5.421802760017877050936930038119771791791e-18,
-1.040043517164627805818219507910356283138e-18,
-1.842167602312070743973482834603856047958e-19,
-3.097715005681216907691300130845349119282e-20,
-4.74184536551616740723905850936083862681e-21,
-3.307425017583960864101186413356726178553e-7,
8.735889443212269798425412843627876599489e-15,
1.005756416386965441771652541972802326623e-14,
7.719465404785564273729580390469562209068e-15,
4.443681069131961832295869517920021216121e-15,
2.046390368331155613761684294076551395383e-15,
7.853310274229539702697809863446955587225e-16,
2.583271629910489266276779658816195032353e-16,
7.435242002967012477415650096888029846956e-17,
1.902247269245645610447051701973219425677e-17,
4.380069453576126512148705042003225682328e-18,
9.168501636644770500478763239831972208672e-19,
1.758759968041081505893543537223183008693e-19,
3.115193457884131100612192781225035875869e-20,
5.238406756022700781652443228035101322188e-21,
8.018785757440106820492965055990407187488e-22,
5.325220362284141422884068369994531540984e-8,
-1.357439507878231810603822839093122407973e-15,
-1.562809951925741266287369103745473923824e-15,
-1.199500911184170184146549384916405206792e-15,
-6.9048816598507616610079503360192571074e-16,
-3.179814932796229711652404915006208047837e-16,
-1.220298629786133574172789231171818064424e-16,
-4.014056247430976291143444900694481442158e-17,
-1.155336547154998476123635020263241400942e-17,
-2.955836585363657806383958204783310673119e-18,
-6.806040724730894140828808605056989756322e-19,
-1.424662864594538815321824467086265850407e-19,
-2.732880788367077255119975686974661395345e-20,
-4.840607838894491674359807899038336172697e-21,
-8.139839395662863545347212602714058756779e-22,
-1.246029838592322177750548838151884434215e-22,
-7.924836234366395402356042876465407020197e-9,
1.951902986328606309854726998646275546564e-16,
2.247211309941499248124508314458854265286e-16,
1.724798344727979568246433577621012105583e-16,
9.92873651405659357444745913184609322317e-17,
4.572351328856338340211270788917585059421e-17,
1.75470404748751510615187601498585178393e-17,
5.7719321749491933512714174174874518516e-18,
1.661293245381890417555282059800478491101e-18,
4.25028695582460320361869011810185548094e-19,
9.786614109719761807457158104165847915379e-20,
2.048567142144247440892869528672334500859e-20,
3.929697662663751480079913184518283271116e-21,
6.960477916581701375711733524538586920856e-22,
1.170460108216369238717522348053654227129e-22,
1.791728554158527544979343867839127082279e-23,
1.113670455942730876090488792628011748896e-9,
-2.650835286937778765279181212772282216685e-17,
-3.051886842676697948991832233706085427452e-17,
-2.342409616450388869173768873340012733888e-17,
-1.34839925096248822266380250199599382876e-17,
-6.209606968607392407459926535261702362601e-18,
-2.383023925957058240480244434566874149023e-18,
-7.838730883682375613488116962694718170166e-19,
-2.256164991645740881998573215217850201996e-19,
-5.77221968501439820669523649331385376067e-20,
-1.329098441403719530994351908011292801171e-20,
-2.782114868520378049620137597443420021573e-21,
-5.336841818708207782983699171546903876382e-22,
-9.452897122751601205799762571322883363203e-23,
-1.58958603999567100653474118416222907607e-23,
-2.433338368276461179731613238200351930982e-24,
-1.43667762698865843953486673621146188214e-10,
3.311971530241174735399136450670067584654e-18,
3.813048058202201738595452769206938020502e-18,
2.9266224183049504661496808730938856747e-18,
1.68469914908324566999434856192898662982e-18,
7.758325011469218434434883938821655368546e-19,
2.97736626911779120366934470359861424315e-19,
9.793763792902055551212224151546298649787e-20,
2.818868043119628549029391948028625331592e-20,
7.211851576654248905933563631442267671619e-21,
1.660585167464575271737188833966754629825e-21,
3.475995593189603606506203620905034635051e-22,
6.667895677489648511815794766119716469469e-23,
1.181054701218680464216934873454001073212e-23,
1.986051598658165312549066334941405644831e-24,
3.040266035931537417786920643970026434423e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=19 maxabserror=8.34151524923750609012e-21 maxrelerror=1.93605034860770325081e-18
0.009915337991271614345798613529038342449491,
-4.101719441672245575715445168131085337895e-10,
-4.722278841667128882416717060939505321038e-10,
-3.62448267994570452912820860503199591304e-10,
-2.086419630194662353175774692239841862966e-10,
-9.608314557046153051974931653891885051428e-11,
-3.687324737607415983606966835615544133968e-11,
-1.212909807786192433272133976494680095295e-11,
-3.491026512979018930284755864728876092233e-12,
-8.93149620983450238900123953481737217032e-13,
-2.056537656988603376989009654346386656205e-13,
-4.304779166679576450530582448683789042949e-14,
-8.257580530974127676665220727957614432546e-15,
-1.462576728689473785512872250786042868342e-15,
-2.459257738240349212992992447615586485783e-16,
-3.764092094833319418889550023723115397754e-17,
-0.01881874711543182672664537410702109195656,
7.368272413046109126557521523843152257225e-10,
8.483036805640025018411522023218527193342e-10,
6.51097089724675495843559486962949670467e-10,
3.748015594863335778000608421798407018833e-10,
1.726024472478130902311824478988719549881e-10,
6.62385990267372287896605706949952326545e-11,
2.178854796474279120595996820073097397561e-11,
6.271233733768684013847525085705555227555e-12,
1.604442573991515562508257978483535777087e-12,
3.694340007370959465498427077824751713535e-13,
7.733063017014186084421518222670338139868e-14,
1.48338687539726251949420737179957580607e-14,
2.62737564725664967417760126091230598867e-15,
4.417859414326061480236274380661852996503e-16,
6.76201436832675052572123056498238173763e-17,
0.01790488096592049491023400022204445863624,
-6.654237227051802832338434120491397556221e-10,
-7.660973462168510380476076134179525870244e-10,
-5.880014031551838281520701950685914117679e-10,
-3.384807704484193396888528781911212436724e-10,
-1.558761129453117927704693555061777919206e-10,
-5.981963653153117514056876834785932803721e-11,
-1.967709339611830030433908490233221661306e-11,
-5.663510352998496050569644554788693217603e-12,
-1.448961996360908545853985854256120024618e-12,
-3.336336854781324923681210527604435949095e-13,
-6.983690816099958056600654015000420367353e-14,
-1.339641920973937355285647081623004828897e-14,
-2.372783770092989202389485558739919181314e-15,
-3.989805815302926978583827658933041589034e-16,
-6.106932388859648185556677460122232102588e-17,
-0.0113836703645723950783878069611468234293,
4.026016860109059397226306406323198692468e-10,
4.635123053794505112282402549988021938993e-10,
3.557588186738112358082254375177959466469e-10,
2.047912117553802766578989827272646212644e-10,
9.430981396733851472321991523775163439662e-11,
3.619270997559951815275887069322989572286e-11,
1.190524407857375118259145258409931590871e-11,
3.426597574649015600023016152430168862035e-12,
8.766666686964744671645162809218233830734e-13,
2.018587520048918694876738237336695286476e-13,
4.225353775619754623384282894697238933531e-14,
8.105271371294792477710074893597475134598e-15,
1.435616756463019077464201605389740773593e-15,
2.41399073478276385520231641444015927262e-16,
3.69499101004870670832432647591603408986e-17,
0.005439813098298496856955513276268462414112,
-1.835076979494809463420780548238824387838e-10,
-2.112710383961027500245321156018419426807e-10,
-1.621565045867066298529332517234559371341e-10,
-9.334477609979647330784903681872059776243e-11,
-4.298684744681173110887185593696722076143e-11,
-1.649680426268900831795449190637291866199e-11,
-5.426465472113557541433781298010040987742e-12,
-1.561859223650614068822823524084202091519e-12,
-3.995888530671778675158148756843868857221e-13,
-9.200821949365092663854278842058988972264e-14,
-1.9259387217025989101562931078148338304e-14,
-3.694431622303646014875179640347091317739e-15,
-6.543648616570213539126679253942457145251e-16,
-1.100323023580287517811101206269754375456e-16,
-1.68423932888956562533636004694903789756e-17,
-0.002083651687783231856642023040241668586596,
6.718818746412756348416529105974870167678e-11,
7.735325717743519023029924468528805502184e-11,
5.937081548378778923414837504999571003778e-11,
3.417658467415272576339224234723093544316e-11,
1.573889519700838482030807705429707237314e-11,
6.040021417210829575209428111201636049488e-12,
1.986807179691661827165124968420344279764e-12,
5.718479948611707274198946458148285573107e-13,
1.463026386765121898898667274386584259968e-13,
3.368725141341668799409656147422742801341e-14,
7.051503567000292325056304829826216682583e-15,
1.352656488648758044843575340550768409549e-15,
2.395858196914333967933997944842828278534e-16,
4.028693254102256831129034837458840679134e-17,
6.166703804112339551395228938028905305652e-18,
0.0006662916275394208346762423854050932722267,
-2.05764988466361735900483469403226755294e-11,
-2.368956909268712426586179109647624293604e-11,
-1.818241520052664638873154803714695893714e-11,
-1.046663837808784753793886455659136914241e-11,
-4.820064022332902816898302054413239075776e-12,
-1.849767100066637949885181043500976574858e-12,
-6.08463191219923300635826954909483535716e-13,
-1.751294680566765997046572876432135675222e-13,
-4.480545134121228257845943406795882188788e-14,
-1.031678591184586325570557860798675347997e-14,
-2.159538031590730002500727117789186890372e-15,
-4.142544808323461250584570720362037051229e-16,
-7.337395806484664646601749801331017495888e-17,
-1.233808190795661308991730791060114350151e-17,
-1.888605966597994916944549369810487108179e-18,
-0.0001829255246349479799788353372227601347065,
5.41992865874796557098453863278836764468e-12,
6.239923300227865024120854767713598853435e-12,
4.789317867616340593684733714344636265456e-12,
2.75695268651811156569868144425923390655e-12,
1.269623359562139526215728516380520426415e-12,
4.872357614792881021762387738392429819533e-13,
1.602715485000842576268922365522234549576e-13,
4.612978000404750002650527507705478034118e-14,
1.180193115545908330717820948397579032267e-14,
2.71748258742889663968445016870638448771e-15,
5.688312804970953332401788875273522195319e-16,
1.091164802290671885814392087776024910472e-16,
1.932707480537152305543618664200723076082e-17,
3.249931600198636691929683880119483792795e-18,
4.974762415815442754290949173845372964206e-19,
0.00004401037376423283236855314623435268032105,
-1.25313650272448005351106861174884430395e-12,
-1.44272667825102701920149440025253406483e-12,
-1.107333590616814732049634994656883136764e-12,
-6.374323891514112906157842688342476014912e-13,
-2.935484030553315229214312945310107198758e-13,
-1.126533165109133534017868936501077876632e-13,
-3.705623341842787372275971065935473686303e-14,
-1.066562362416026883334288679447221551156e-14,
-2.728713928338197700341660337158844090695e-15,
-6.283068886865734290464977194500540747509e-16,
-1.315190802213245303025911754593699058035e-16,
-2.522877240768091931110754695480651265894e-17,
-4.468614189877503484233970292045371824582e-18,
-7.514206947361658614016811423670315688903e-19,
-1.150231706704718623062194493977475611039e-19,
-9.42534572255409061987721347294135915313e-6,
2.582989322727462788309348231829650537938e-13,
2.973776281483189587775587171854315983388e-13,
2.282457532457571399984791633255649925699e-13,
1.313888042590710490990406966660952773389e-13,
6.050676845819541380270689445934982168049e-14,
2.322032133809616549228119538094534969088e-14,
7.638103357619049462476959950067324198716e-15,
2.198419356561306390910281456779579401626e-15,
5.62447963456722216976250218691075458203e-16,
1.295079036282621440123389607823010820556e-16,
2.710899624748171887730634392887288533292e-17,
5.200214218758046987639462091375823854272e-18,
9.210832047619788449080559023334335644267e-19,
1.548856499946355150616980841062849035109e-19,
2.370921147509722352781963708409144500293e-20,
1.819084272412033640705726859028294230852e-6,
-4.804740305558786322380663248983188130833e-14,
-5.531661570126171630045609142594151936497e-14,
-4.245706955066687378176666725097515811922e-14,
-2.444025153557366889501112323230111373699e-14,
-1.125514963020489604928802859140041293102e-14,
-4.319321650295056097829785091482421875336e-15,
-1.420799725216562323664996620931709819391e-15,
-4.089384047894685654499865043766642028249e-16,
-1.046236240179026218481927966182661906098e-16,
-2.40903875690721667476786252637115457072e-17,
-5.042677067009224897503138825407554048036e-18,
-9.673182062570193076036045695567953164828e-19,
-1.713356798305255132597088560553591702195e-19,
-2.881124382515306965074350005294940565399e-20,
-4.410333187197978200276460606993347687275e-21,
-3.195556820331658172025187285688975711819e-7,
8.145585905304537892947930332140332737566e-15,
9.377952124716139633017625673227449294423e-15,
7.197843925158637580104145417729148002616e-15,
4.143411651125669200254225172302248522671e-15,
1.908111230582881753817795337541664637551e-15,
7.322644774565137132341010768624747919776e-16,
2.408714333353893823240091405176558057711e-16,
6.932826870129844678213693451309019510858e-17,
1.773708566051428975116171063766475841378e-17,
4.0841001817130506683475526888543053265e-18,
8.548973038080355196872183285378642815654e-19,
1.639919504094598482847662487778694693626e-19,
2.904703068631929243582493758277034346865e-20,
4.884472631348372352999941020799599316958e-21,
7.477050057615484723363635476926199329533e-22,
5.150981951272654624610245731933883874987e-8,
-1.268701900770651381472674061545432125041e-15,
-1.460647009777100327430948157336996824223e-15,
-1.121087960686982001101413407641323006604e-15,
-6.453500494571855485621701569707860950492e-16,
-2.971946281416318409995340860541813301539e-16,
-1.140526130614461493794088252711403738493e-16,
-3.75165229662178601143524878624252827988e-17,
-1.079810786138370276822553309994415586353e-17,
-2.762610220559493360051593850493425565965e-18,
-6.361123482877323391911993374267537916663e-19,
-1.331531866644344288263971514998827882885e-19,
-2.554232934849388723915520413205310994341e-20,
-4.52418569067264429533551948903051346221e-21,
-7.60778057871829512030018552796834257869e-22,
-1.164591393772409052102933910230094090669e-22,
-7.673740453274067075225331012710922997435e-9,
1.82833218518232843415094272856400951342e-16,
2.104945172332530614431916433711743878824e-16,
1.615605056067647011855731157395982977888e-16,
9.300169500581583668073979711615168263595e-17,
4.282885598575860189013055574231675387569e-17,
1.6436175271423979447540566552656939882e-17,
5.406523754280487212455549106112469736925e-18,
1.55612047233906781156820456574504997931e-18,
3.981211140539288911089890260706571448429e-19,
9.167048004697414144322551209967189202137e-20,
1.91887820329654712283698627026145562052e-20,
3.680922505289702378400641209866343401272e-21,
6.519844791225533587796180412569189479358e-22,
1.096367934415043604962317839710415861655e-22,
1.678319784033008738317837656240848091817e-23,
1.079497262022477113842328803052523112904e-9,
-2.488291521389721895196558743720170588569e-17,
-2.864751422910314293172818183156051447915e-17,
-2.198777883001560303977507154410928634643e-17,
-1.265718189466233792917851618007839075374e-17,
-5.828846706738737415421621571342606415144e-18,
-2.236901850264679540594590347936891322599e-18,
-7.358076357002664497104361462731328265291e-19,
-2.117821783646413138352716998469947155786e-19,
-5.418280011731511467673687945696964137715e-20,
-1.247601303224593592213929575694234752565e-20,
-2.611523167793735483739353003651182818284e-21,
-5.009604763317596368972125399581872652053e-22,
-8.873290119723515005569441204113551614129e-23,
-1.492124978599481936111906361060966984911e-23,
-2.284158670651947605930223459887525752677e-24,
-1.393898898434562166840837504831561140435e-10,
3.114896073378197986654248033305623467224e-18,
3.586156560643779046160754439644272564882e-18,
2.75247676908766039339440946962781346324e-18,
1.584452867524939330958458865941070502542e-18,
7.296673938736308196429031542936697428969e-19,
2.800201210499151767017937330624172826415e-19,
9.210996337544126642339690773834724030318e-20,
2.651134421209811754013020343384384762856e-20,
6.782718899428796115152276395435907735207e-21,
1.561774276714851950661797102866734039375e-21,
3.269162233901988810035698741299915927549e-22,
6.271137743190687868874960792139111775587e-23,
1.110780213258310247747261809695537292133e-23,
1.867884299997927927037319683293991286985e-24,
2.859390520947755765617581316298281712319e-25,
// [{0,1.e-7},{2.,1.e-6}]: m=20 maxabserror=8.10744078540313052039e-21 maxrelerror=1.987842092267314353119e-18
0.009409373557715913356126162975950290399669,
-3.684136206523054561763329335219743437801e-10,
-4.241518402820012507461056138156776418751e-10,
-3.255485448623377477878687007459007931593e-10,
-1.874007797431667888229450341956304374036e-10,
-8.630122362390654508009209674429681038263e-11,
-3.311929951336861438120699592915521252654e-11,
-1.089427398237139559849873206634140490783e-11,
-3.135616866884342005633956100168625669184e-12,
-8.022212869957577809241421053585980907822e-13,
-1.847170003685479731989392601115995743855e-13,
-3.866531508507093040620273558737185634083e-14,
-7.416934376986312594420051535233980847701e-15,
-1.313687823628324836548391140833642997354e-15,
-2.208929707163030739209381361188572810114e-16,
-3.38100718416337526146946145959885146529e-17,
-0.0179048809659204908816559716340924147173,
6.654237227051801958786574318742943235703e-10,
7.660973462168509374762350473240665137671e-10,
5.880014031551837509606921053570551346021e-10,
3.384807704484192952539272015015427989653e-10,
1.558761129453117723074330365175727816039e-10,
5.981963653153116728759080716473168467828e-11,
1.967709339611829772117640424609840449622e-11,
5.663510352998495307076593967935376507849e-12,
1.448961996360908355637121719316804320407e-12,
3.336336854781324485691878713950085859671e-13,
6.983690816099957139785303984296639059561e-14,
1.33964192097393717941554644628841893616e-14,
2.372783770092988890877795449577435076955e-15,
3.989805815302926454745315305550395570495e-16,
6.106932388859647383651140206461979159464e-17,
0.01707550554685859584218139421702205851187,
-6.039025290163589774863614878436602187228e-10,
-6.952684580691758450179037964461782374417e-10,
-5.336382280107169137142828649535205159181e-10,
-3.071868176330704495267417330402153261707e-10,
-1.414647209510077879910361442800926530373e-10,
-5.428906496339928333336870956032247180956e-11,
-1.785786611786062878181595966297968893584e-11,
-5.139896361973523977962178882935850453662e-12,
-1.315000003044711848605041803428129532504e-12,
-3.027881280073378382770479600130878813987e-13,
-6.338030663429632647730319451562377867692e-14,
-1.215790705694219008362976233396985820484e-14,
-2.153425134694528858339292834663831678567e-15,
-3.620986102174146189992575550670768340238e-16,
-5.542486515073060685825187604074841021256e-17,
-0.01087962619659767073257350177998300339699,
3.670153958989765728082519457337347042581e-10,
4.225420767922224011661896001651036045477e-10,
3.243130091734262317921458903874888293519e-10,
1.866895521996004139482417035638556510479e-10,
8.597369489362690105092998723279596766457e-11,
3.299360852537933633650488671687516843819e-11,
1.085293094422754918587229069780849153572e-11,
3.123718447301353082377033158750463620888e-12,
7.991777061343877011609388554846290335483e-13,
1.840164389873092137304721108285315710321e-13,
3.851877443405351892025273553977693977236e-14,
7.388863244607587581167815384635063041308e-15,
1.308729723314095057668371765589975647187e-15,
2.20064604716066306719473077017322969219e-16,
3.368478657779266011680177940851691255416e-17,
0.005209129219457847439232251580217010739863,
-1.679704686603140191154127473129049411788e-10,
-1.93383142943582346221574616630662709954e-10,
-1.484270387094651523965325478345861684287e-10,
-8.544146168537932722024016178649694483519e-11,
-3.934723799251981665842946343479198258263e-11,
-1.510005354302663437760099391781341702783e-11,
-4.96701794922900997867468657108153146831e-12,
-1.429619987152885202472474006518280237604e-12,
-3.657565966912698275770007793169211025867e-13,
-8.421812853353926839515700370729042048749e-14,
-1.76287589175002176366519495187751730785e-14,
-3.381641221621796670949991385893918492488e-15,
-5.989645492285660554733716662345044757721e-16,
-1.007173313525534886442523802405372547246e-16,
-1.541675951028040001760967101587410604243e-17,
-0.001998874882585757251913657370296799162142,
6.17294965392037037803514268532756343998e-11,
7.106870727724992226633040315078641205698e-11,
5.454724560095712789136480010294719775769e-11,
3.139991513390502365233915160022326398718e-11,
1.446019206683360439306297377610274681733e-11,
5.549301300136552845663432927433405180948e-12,
1.825389573638927900091921582571267165696e-12,
5.253884041640309963181466045399838676784e-13,
1.344163540221021011018028512178353011038e-13,
3.095035773518420225034474700942578632874e-14,
6.478614094698217635014152439676998333467e-15,
1.242763442482848463759370376260978181082e-15,
2.201218741920265370191136365000595595739e-16,
3.701424572344718515798527568783157724357e-17,
5.665817899729283766396847711268982395947e-18,
0.0006402393362285106588558430297000710172093,
-1.896975030574828195104225395960512801485e-11,
-2.183973155094765895331659700808817322645e-11,
-1.676261253677242215756096065579160887629e-11,
-9.649334402879722240876737597580717719252e-12,
-4.443681758498035241938347326562787270272e-12,
-1.705325165189231160254439241773495239866e-12,
-5.609504197541510066003423039999521989837e-13,
-1.614542300152761249478484366332087171796e-13,
-4.130675904439074437054109438575493570163e-14,
-9.511189056066520619185311223985570258231e-15,
-1.990909481753519750270989062300934789381e-15,
-3.819076808043605244189289465212725330451e-16,
-6.764476181926535155693246791947959260725e-17,
-1.137476060077342660827141776636928860771e-17,
-1.741166845547375804024626083921178365351e-18,
-0.0001760414957381370359584391469825262836103,
5.012546025668446866486966593163773101389e-12,
5.770906730009304989770026128543919851605e-12,
4.42933437551922939363225358877493292094e-12,
2.549729564118962736529422574425603450124e-12,
1.174193615681336163805447569574117034011e-12,
4.506132673714809372760559666774817059752e-13,
1.48224934110487775498895729079546152611e-13,
4.266249462235523640506637417278997563029e-14,
1.091485574551577266122997253937159255054e-14,
2.513227562152073956020378974641474211085e-15,
5.260763224355032318261291504462296584341e-16,
1.009150899280951479889361984173117195e-16,
1.787445681218223580112046051587288234745e-17,
3.005682787802031989693548530511722430559e-18,
4.600926840377963342059109175253910001472e-19,
0.00004241405567363511045024291809595437924421,
-1.162345193587876801509726968959447078901e-12,
-1.338199324779912572799485719535278489863e-12,
-1.027105888157179941949167245787694130923e-12,
-5.912496183318653769757805852391770455993e-13,
-2.722804576778292518029144976500090990424e-13,
-1.044914458740481125890439504357370954977e-13,
-3.437146506080494365701597708946759820733e-14,
-9.892887090572005928484359009800591691786e-15,
-2.531015831985260820354843446086730018337e-15,
-5.827855655051613675434866119585220776488e-16,
-1.219904829415997996718752717652929331048e-16,
-2.340096395140388581184897260009747309499e-17,
-4.144874415582442061608198499240152940222e-18,
-6.969854239927151451324026558667780936263e-19,
-1.066914514874344299278590399861078259583e-19,
-9.09541409459214093595366162204642721767e-6,
2.402368576995834938803089594459475016969e-13,
2.765828970875255528260788688568373900625e-13,
2.122852085092779733655570096533280695373e-13,
1.222011775225524270541909619927859074189e-13,
5.627571123814309667324558754963286331427e-14,
2.159659408563793968872359081709082117313e-14,
7.103993966364862444299846018178995666547e-15,
2.044690682774392677985523031297070915126e-15,
5.231177769609355497846621795963430945424e-16,
1.20451858837299622108791503982658301758e-16,
2.52133687967886667635002704440071193378e-17,
4.836587858797848883092471749982293199998e-18,
8.566778372226219253425396320205601559675e-19,
1.440561246315332068190117568943491906967e-19,
2.205165147056841660770189200383481390363e-20,
1.757556749512042388663704219481308424718e-6,
-4.48007329725834748049968121869701569963e-14,
-5.157874876692155288772266668508607557834e-14,
-3.958815086086911408433327844628245380202e-14,
-2.278876941886889452973711133406073189766e-14,
-1.049461422629690661238769617843971359654e-14,
-4.027455569337845619266830228136031264794e-15,
-1.32479319364313106974850048375696887798e-15,
-3.81305567168117016280541836809587969176e-16,
-9.755399398234271305693851565448711421805e-17,
-2.246255626070339225391335597053717448367e-17,
-4.70193627225530442985661109792356455478e-18,
-9.019559385135541221718359698218828195148e-19,
-1.597587061947109417730255168311736424676e-19,
-2.686460576497804494101258038632881406158e-20,
-4.112378494974961700503533741168658365363e-21,
-3.091001495556405702764340515902584585094e-7,
7.613105428820202313454301682813368170654e-15,
8.764911342036219876759088400021018293412e-15,
6.727317768275433473840219894568744060697e-15,
3.872555059654668756091669215665915771237e-15,
1.783377194877494691815652630196119079269e-15,
6.843960485519893120088943791221551251268e-16,
2.251255748074712195195926331147432512685e-16,
6.479625634192644784415570857747108883227e-17,
1.657760807073346152526237278852493044434e-17,
3.817122343663697491433684288276720188591e-18,
7.990129501465734097959965990271290248298e-19,
1.532719752657100239300909401013258860534e-19,
2.714830226602994346895982019754369979941e-20,
4.565204462293350382126468410775526427184e-21,
6.988369061440160458247913635256161454639e-22,
4.987774235548319674583780338495443459599e-8,
-1.188382848293130754472486185568292901587e-15,
-1.368176286382976165661574870403474698817e-15,
-1.050114062316623683104470557201275770529e-15,
-6.044941947790732052272471853919086102855e-16,
-2.783798167419025073509115279544391991611e-16,
-1.068321661805077380892265791824374761528e-16,
-3.514142643508095943429107118160526216139e-17,
-1.011450158880429831003004965140418299076e-17,
-2.587715226537405561750497737795277102837e-18,
-5.958415383241894082232164920444951322465e-19,
-1.247236122120779023175333895516682768664e-19,
-2.392533045143957529434104394043049554119e-20,
-4.237781177825768833297401710951531104384e-21,
-7.12619325102264627235827059774591554668e-22,
-1.090877499722751620209147496979933463767e-22,
-7.438054557083291480703974544603719566203e-9,
1.716126442764440858425232474984103134971e-16,
1.975763541550336007925196288863369941101e-16,
1.516454496643313583678212007860387916068e-16,
8.729413073475922666823614426408337969157e-17,
4.020042617769814609106296714230764695662e-17,
1.542747857259585831022589245955042205262e-17,
5.07472266837144299030071974120387176027e-18,
1.460620640315473408772358060122863374646e-18,
3.736882707567792344465112604185666087653e-19,
8.604464337990358937017238219434381902941e-20,
1.801116886445372583191956133836256195491e-20,
3.455027193295007347253232206228170268157e-21,
6.119735772203195896383962456313382749674e-22,
1.029089512453510836497477710894763635117e-22,
1.575339454710117601773729346795409273506e-23,
1.047357311434539029680632773661195779019e-9,
-2.340242668931575152758698434973981835712e-17,
-2.694303887834984765525150788563138333443e-17,
-2.067954573301642083457816312969856940812e-17,
-1.190410248109822647258982083576118214996e-17,
-5.482040906334720332721229752127210762781e-18,
-2.103810271819564392797823885657075526228e-18,
-6.92028438429394733456733167572008903541e-19,
-1.991815376519719375668763098393329018438e-19,
-5.095902981750438591458142123476948249796e-20,
-1.173371669348016774156318169598593446553e-20,
-2.456143892885719007136786818584417194658e-21,
-4.711548586347830872066282637680138158524e-22,
-8.34536758707260651107869534952512740287e-23,
-1.403354242166915707286194271012975659574e-23,
-2.14827968147123839595598280858734612592e-24,
-1.353592292475872007564102588874203507766e-10,
2.934890607446633481631093434671914928016e-18,
3.378917615602727527130949871019377304202e-18,
2.593415010114439052744463410043320847507e-18,
1.492889569738903866847736385029242438444e-18,
6.875009470800204071026474808886618601934e-19,
2.638381568440550696990593386472090180859e-19,
8.678706140429033204189191466292585223469e-20,
2.497929283510376064129567596652426783361e-20,
6.390756105275281722197469200564657646175e-21,
1.471521996792240426485949780831023111287e-21,
3.080243872525252452646096525736794881518e-22,
5.908744880933883157802419631449077776255e-23,
1.046592401431530828847749084517884665802e-23,
1.759951320152967978102149796164988763442e-24,
2.694179013126048156786539300313828738289e-25
}
,{
// [{0,1.e-6},{2.,0.00001}]: m=-1 maxabserror=1.29550089961281052e-19 maxrelerror=4.38166071265434249e-22
496.5052144413837237170145088879330855082,
-573.7550617919484740474403381949097606481,
330.2861924129486684993051038880489435348,
-126.7496342004515992245581094973494292762,
36.48215304391396617522728986291563584552,
-8.400174330893446332700801490643465715159,
1.61187072226114914491980198634997015037,
-0.2651008723075620794564143604275075843162,
0.0381515395749640361784625562858829491759,
-0.004880372418750068652482689024946336387821,
0.0005618693676494249725542651898204118157449,
-0.00005880878413361090535463923516129002791022,
5.641656411211630333440649165334675229124e-6,
-4.997073512412966994517961882866308463616e-7,
4.131090842265320883755095841551096350853e-8,
-3.169807532319296303407338021765793769858e-9,
-1.487360892745405563637975391200505758138,
0.007219689353881663059378480991156467263793,
0.004134253030548025263264615823969297570077,
0.001569946947901384643839138344497478781162,
0.0004423367047730427687730489964003632919884,
0.00009749278308700857044527486941872067747566,
0.00001705142068396829107772255868756961803118,
2.2682350410644149260710711195568471373e-6,
1.756935657987781996080398719312537333183e-7,
-1.4718584874650629780333502969027081809e-8,
-9.791483439000992304324310688008385551973e-9,
-2.575517835601959431783225960479039453912e-9,
-5.041316144486124825465700359498868524089e-10,
-7.974237402690479743562933052398572575493e-11,
-9.795062909610940295495788371603316729511e-12,
-6.89020253543865532726810591025387523105e-13,
0.3789411798968306664557504806204843806824,
-8.07086215019452982726004025182471953884e-6,
-9.265668049562418816170873547665306235838e-6,
-7.081499374942125014684314345978272303468e-6,
-4.050466833752765018796772635776871376593e-6,
-1.84743572516599163929792314806489765458e-6,
-6.987427417661436691351525418127969861869e-7,
-2.248278426644567194038948467303188517824e-7,
-6.256403296449455875350528477223022637297e-8,
-1.519265101944443903253614750744259521753e-8,
-3.221640139120507885340255247034715473993e-9,
-5.894053696166940065652809779196366381333e-10,
-8.93955369366837287015764324193466966441e-11,
-9.777794111226958182063072182227103586274e-12,
-9.252639739451579391808638770508436744802e-14,
2.954418026015685504172899502992195809933e-13,
-0.1336913547479516014961356832921050098911,
8.660229015076979446625492790803774903292e-7,
9.970292754423153983150938366904635087301e-7,
7.652230609776354023369094331898865279497e-7,
4.404688654992097196557042918572945321987e-7,
2.028168261641370977742379954160054422013e-7,
7.781349766710283891514223358751002754398e-8,
2.558270506724715025950422150020866538093e-8,
7.355664244418389530436687378706737878824e-9,
1.878014610911504295589272615940944826964e-9,
4.306573919875852655911750410295993011418e-10,
8.941333720336626081330140635576511432296e-11,
1.687625769800227284324892880122838917998e-11,
2.892552157001142189137432893167220487245e-12,
4.502561669045882761482932324015424497524e-13,
5.895972593198132010583776325641627576977e-14,
0.04448811248353382723542752412397910263319,
-1.627946725893628044468404392644370514541e-7,
-1.874233093815222617038901078551002042316e-7,
-1.438511959465645831268485510320808028598e-7,
-8.28056662656094606254706071035986179656e-8,
-3.813181729908637653658289709037219802269e-8,
-1.463239672258864358885430769090911914328e-8,
-4.812382761850092837815539609692235260521e-9,
-1.384649736038115504545194930082160989445e-9,
-3.540145713223358614797569461341273986121e-10,
-8.140540044174887035228183690226128100513e-11,
-1.699436595528133499110029078514927577624e-11,
-3.24259850240593989875298293496894581635e-12,
-5.681556470598771543332650909199257602427e-13,
-9.316533520995725503238917334930538140583e-14,
-1.359147060147744274599601404490463670466e-14,
-0.01323284987459297771456006026839193981572,
3.32206849552425358584897730502469083404e-8,
3.82466108502048115513084085723930425661e-8,
2.935518040423278531602712987326264682184e-8,
1.689799496870727682067057920796974187151e-8,
7.781625239680980073163477649200373659243e-9,
2.986163967145794032194939590182261055876e-9,
9.821755048998479156211322295263052488832e-10,
2.826378907218474771645133475965749114209e-10,
7.228275580194287791781333045843251567536e-11,
1.663080874073143387620796537681106417046e-11,
3.475837513290946922129260380881788979496e-12,
6.647119998268794593985624943714722306514e-13,
1.170077914308444130326303061764468145754e-13,
1.939573730691188457778773088787100988384e-14,
2.889960346807669713891929010194326225147e-15,
0.003499096184353032198219411671018557377891,
-6.639584288106531834752749511722455268106e-9,
-7.644087759924714984350230012119643607025e-9,
-5.867029395104266170991642997273914542253e-9,
-3.377305077307376635825677702855072022187e-9,
-1.555280189030910399089257011731148947632e-9,
-5.96840662355539684096881614669043216805e-10,
-1.963119340467017139653731653947546827467e-10,
-5.649547844359950463814202731019546881561e-11,
-1.445005300337428085074694565932998458435e-11,
-3.325455101230521194817228920039875366079e-12,
-6.953500085547612517031563735532223520161e-13,
-1.331030785716307634525621425280119742912e-13,
-2.347480081293618158190282083425911620488e-14,
-3.908652262996340200824099057681964014559e-15,
-5.87362262462528457747926369488199667764e-16,
-0.0008270987363033204707788960672442736516782,
1.257085276830828249777433862312604818145e-9,
1.447270579696986117887299890019448848041e-9,
1.110817644364802041716520528032172258659e-9,
6.394339197467171375826796076649553663685e-10,
2.944664099773545067179592237696729783437e-10,
1.130027503004513847262439167798889629792e-10,
3.716929201229245958208052193949518716332e-11,
1.069707977058678356650931258159872929142e-11,
2.736206720206665433527701384778068112631e-12,
6.297764975952836314924192513255172449014e-13,
1.317197007202018296082356813785849595556e-13,
2.522655234227139635894683575567817347254e-14,
4.453710980053268718234774453758655514762e-15,
7.433413325527537823360124751558172848917e-16,
1.122114232830519616364993372055443209814e-16,
0.0001761649946367630190771503766064968484943,
-2.228817997056204907875940673300246305888e-10,
-2.56601822028488816461437879400514601601e-10,
-1.969486659987628189211943481921200350292e-10,
-1.133721775849920499084189033610288285447e-10,
-5.220927562999428394755558664619424758102e-11,
-2.003563428636027483115911505101076944749e-11,
-6.590262653239715768054271642758474627471e-12,
-1.896672621513951052757931737644430264591e-12,
-4.851694676691518057494358528119555077567e-13,
-1.116775473239556631750159565671778996089e-13,
-2.336145723630559123733324346597490257326e-14,
-4.475543286101117621002204682382262007675e-15,
-7.906607313518096887135589313334457256043e-16,
-1.321608212599091282553219135355306081212e-16,
-2.000634115811458424584058053624177271821e-17,
-0.00003408152770257375939913907807775640104973,
3.688945281524183019873450524814162304455e-11,
4.247050605260592134451068527832636423061e-11,
3.259724740280708297733728419154293201966e-11,
1.876440265830245508511641498869394303213e-11,
8.641251862966495403092019411860057152577e-12,
3.316145462833718595805835833392714358248e-12,
1.09077747877670442283875244288382071571e-12,
3.139292183912352865594361214681647246804e-13,
8.030538670299110981780467694999440102045e-14,
1.848590868573579639631317591140826793547e-14,
3.867428874954010814453935087880881679267e-15,
7.410755225970667870800810400071347601224e-16,
1.30977692539286565693558225289182381885e-16,
2.191534610418889912724228725446231925284e-17,
3.32380395106416650309867528352216558742e-18,
6.03323683820036866680389656786595429565e-6,
-5.701873846503840394827966307557029034709e-12,
-6.564518758653170590128460568420585561081e-12,
-5.038444978707089822848642124695745937628e-12,
-2.900351291108916156904521403675234639476e-12,
-1.335651197196190491270826279445680780694e-12,
-5.125674661152045044435510723496212755861e-13,
-1.685993000281989464903181121323590766545e-13,
-4.852389167182568465202473133146139659602e-14,
-1.241301062407804602792295251475739289655e-14,
-2.857527319549004843974596674109360265026e-15,
-5.978692485234976101628762419242890147035e-16,
-1.145814875251753423629893576348294806693e-16,
-2.025754449210512758939143164148473634253e-17,
-3.391984851943210746039343609384625618986e-18,
-5.151482846331548646240296978270133253659e-19,
-9.837004444243720940493790612518610543402e-7,
8.246308961821746400534462291046529572721e-13,
9.493906322889370584965220849244981824579e-13,
7.2868305390071802213625906550330998913e-13,
4.194623198333136667963602304524068488946e-13,
1.931682801733668660150757839782210455504e-13,
7.413010246281341948651517523734140671424e-14,
2.438377524410755241750742809147488064046e-14,
7.01784926741356497324279652716936890405e-15,
1.795279219336557265319416794776758374569e-15,
4.132931491886539770364769450102009284017e-16,
8.647686116521875565130995866665023603633e-17,
1.657522983139110353960971731988747165057e-17,
2.931133649435876598081035289911740241981e-18,
4.910672701475488840905511512522093641225e-19,
7.46559166831845750609186156688009689236e-20,
1.48568915777910041333271899134655616545e-7,
-1.11869371275116781805465203965269505824e-13,
-1.287942802773015195030889031454435390104e-13,
-9.88531204348478750661610396534906534346e-14,
-5.690426592493172863385358868053130201028e-14,
-2.620523142331105919656993772957006658174e-14,
-1.005651295233693705453920954079928402989e-14,
-3.307920205925179664185021016425907160303e-15,
-9.52051928917182049991533702577872003874e-16,
-2.435530944274902489170055749259019172203e-16,
-5.6069922188458368538116612231849823553e-17,
-1.173253528134653885173983552575477424366e-17,
-2.249011221100576757906971069122154843685e-18,
-3.977851787583733447508198331133713824784e-19,
-6.667142221027667774022586980585236081854e-20,
-1.014400204012173119070567911134831089078e-20,
-2.089652207876598755077113556105724533411e-8,
1.427756343089937755110513681532886559921e-14,
1.643764168039932937499897051743724048275e-14,
1.261633983843352727447703035891669556123e-14,
7.262530135766184434243098387865871793302e-15,
3.344501341792402534146117358887164210411e-15,
1.283486479755537164323019288169818212318e-15,
4.221821986639393917230347768783689123351e-16,
1.215087499084064697199054754059896671562e-16,
3.108455211451908447906547514016564073709e-17,
7.156307833410602866300062560340732925962e-18,
1.497501027737349866495951847345178491245e-18,
2.870774242738179695861939072068473715296e-19,
5.078329426651176871033276653175311783746e-20,
8.514532314869230989287745003282988446765e-21,
1.296306139791808507198847458454474359324e-21,
2.789222184392280106437640853092371259186e-9,
-1.740268942935709526266674301513739392784e-15,
-2.003557482868700399134316541077816574934e-15,
-1.53778538625264805833611603211473496722e-15,
-8.852183411820754360546018684962136996925e-16,
-4.07656190503690820452604503974824111201e-16,
-1.564423703120489664678616814716130651556e-16,
-5.145929722730685808457395375682701269019e-17,
-1.481061780213069415621068908668674667355e-17,
-3.788904103680784653655832800753229702809e-18,
-8.722977883407137451896079962223335884857e-19,
-1.825393104977605913518561495053675124541e-19,
-3.4995737615835064229978591864153882687e-20,
-6.19143169046945089473145441499614542317e-21,
-1.038377107245282018754486240313201721994e-21,
-1.581731692011201822328929253460869948237e-22,
-3.440851742963931520242842174592822277408e-10,
1.979302562044885524927373729100058082052e-16,
2.278755057460569115751513046039523176592e-16,
1.749007254637369647509287829117646226834e-16,
1.00680733515187996326799606385248373228e-16,
4.636499110078005279813342583334546969981e-17,
1.779306928887033562809899027216960287124e-17,
5.852764104483437811812624765629320092626e-18,
1.684502726175091188572169438817990187813e-18,
4.309381123780104718794707983944145770232e-19,
9.921368073718302543255807690233351105553e-20,
2.076223947591160109507376948384408933202e-20,
3.980657148023553477730786224123444928369e-21,
7.043276201229399204982870662684073099624e-22,
1.181516099419965127202983474023718665495e-22,
1.800549238478095333638114267366435515587e-23,
// [{0,1.e-6},{2.,0.00001}]: m=0 maxabserror=1.8467515974068359926e-20 maxrelerror=2.7914448641373329733e-20
0.7436804463727027818025694615027929961835,
-0.003609844676940831529689232329949518232173,
-0.002067126515274012631632298510961512139045,
-0.000784973473950692321919561956703491736948,
-0.0002211683523865213843865203446061219648721,
-0.00004874639154350428522263552191567328856889,
-8.525710341984145538860545287502961850853e-6,
-1.134117520532207463035294102338813301428e-6,
-8.784678289938909980395044098285343692112e-8,
7.359292437325314890184530223907708080644e-9,
4.895741719500496152166248575206322633365e-9,
1.287758917800979715892469596319280670917e-9,
2.52065807224306241273449266378606989663e-10,
3.987118701345239871784373160224694555371e-11,
4.897531454805470147752771873377620299872e-12,
3.445101267719327663641491264188667090402e-13,
-0.3789411798968306569131788957858025074463,
8.070862150194529822168858894443511060853e-6,
9.265668049562418810309437315170132286266e-6,
7.081499374942125010185500259765357549264e-6,
4.050466833752765016207052228435247155986e-6,
1.847435725165991638105317575387150803949e-6,
6.987427417661436686774768839879292865948e-7,
2.248278426644567192533490804816626532404e-7,
6.256403296449455871017611096686505000881e-8,
1.519265101944443902145139700604738167161e-8,
3.221640139120507882788216661674816455654e-9,
5.894053696166940060312097448770181716217e-10,
8.939553693668372859917683451719707612193e-11,
9.777794111226958163943186118799039121016e-12,
9.252639739451579087786087661878377837442e-14,
-2.954418026015685508807687756337330607248e-13,
0.200537032121927409600762222135045346375,
-1.299034352261546920652546688125686001614e-6,
-1.495543913163473101684899064320458142471e-6,
-1.147834591466453106738388894450817737165e-6,
-6.607032982488145813446316460745353278059e-7,
-3.042252392462056475184106335680569012497e-7,
-1.167202465006542587016174099203432263781e-7,
-3.837405760087072549744467431448021699712e-8,
-1.103349636662758432679321833686692705932e-8,
-2.817021916367256451349918773172708848993e-9,
-6.459860879813779002207913651571091021723e-10,
-1.341200058050493916037707831003644205939e-10,
-2.531438654700340933846716111177914310201e-11,
-4.338828235501713296729725139179122084565e-12,
-6.753842503568824164079553208864046232624e-13,
-8.84395888979719804920404082632003283512e-14,
-0.08897622496706925810251268772478621915291,
3.255893451787264644355577050645546414552e-7,
3.748466187630455083862760348436674303496e-7,
2.877023918931299222518784346124346064213e-7,
1.656113325312193564376105738255793604322e-7,
7.626363459817295348323540427900865979406e-8,
2.926479344517736408730267611852859652479e-8,
9.624765523700210973926014238380245977737e-9,
2.769299472076238290292955439929623138783e-9,
7.080291426446735856840221643106186663209e-10,
1.628108008834981695590371888196520776337e-10,
3.398873191056275972960519924017418956315e-11,
6.48519700481189700513247821677420847968e-12,
1.136311294119757353602735005720520576653e-12,
1.863306704199150209561525100914682637377e-13,
2.718294120295496337679671725602161816543e-14,
0.03308212468648191454752506952028638085154,
-8.305171238810607618899576338182917081814e-8,
-9.561652712551172556206738339697868839237e-8,
-7.338795101058173048649315523450158536575e-8,
-4.224498742176805803941380007966434064186e-8,
-1.9454063099202388468209008173361702201e-8,
-7.465409917864461396771063113645571016564e-9,
-2.455438762249611998629072940801782097257e-9,
-7.065947268046164507133779333312074835676e-10,
-1.80706889504856621178270463047068100816e-10,
-4.157702185182845262581374816416232930084e-11,
-8.689593783227339667316368697320578834086e-12,
-1.661779999567193349157916307082864345557e-12,
-2.925194785771100947801914359401962724312e-13,
-4.848934326727955406991036546716079861143e-14,
-7.224900867019150285637210235777272706233e-15,
-0.01049728855298210385256517821735446415359,
1.991875286427852091333863377843358431429e-8,
2.293226327972685610620776944857985964483e-8,
1.760108818527650301783132010292671285053e-8,
1.013191523190123658255216533862145571696e-8,
4.665840567083109503870751881955134641332e-9,
1.790521987062926620393649407043170920253e-9,
5.88935802138890570003752597267807278909e-10,
1.694864353304489431623487580313258192065e-10,
4.335015901003341309294863885979175104688e-11,
9.9763653036709742682920846945274897071e-12,
2.086050025659974979486146809857868494062e-12,
3.993092357140661516740869706662073007779e-13,
7.042440243866235725969556877330114067468e-14,
1.172595678896449268940527930573932743845e-14,
1.762086787383846120540156462098940189305e-15,
0.002894845577075749439873283891809710546034,
-4.399798468914925023141375401739412778306e-9,
-5.065447028947540561753188575393500027637e-9,
-3.887861755283015791688589561542548915611e-9,
-2.238018719117083958686669543932847673482e-9,
-1.030632434922386644733747500974043067876e-9,
-3.955096260522114682987481521046781621497e-10,
-1.300925220432313715877326388745530717178e-10,
-3.743977919711353972760453386352682163771e-11,
-9.576723520738626807093262663689691257054e-12,
-2.204217741587014747936302033801489640037e-12,
-4.610189525214434824841750104391813043921e-13,
-8.829293319809121547869875636243165783611e-14,
-1.55879884302114507682625025670323524473e-14,
-2.60169466393883526531144556775390742332e-15,
-3.927399814913218983233741704693264023089e-16,
-0.0007046599801605492163834501988790338787471,
8.915271996832395653389673104584391322001e-10,
1.026407289104938584435645025076356966862e-9,
7.877946647556583242680655290040028962788e-10,
4.534887107778079410133106188858220350733e-10,
2.088371027216089853938702234725286014154e-10,
8.014253722281956508346143439560229350511e-11,
2.63610506384113865692841102034649919747e-11,
7.586690493381395922462002782310924127307e-12,
1.940677872550687656833575197160505659133e-12,
4.467101897272916001743686346806233642235e-13,
9.344582903551690798314968090587743396608e-14,
1.790217316171700246718797835140570871465e-14,
3.162642928470738427249832695665799123139e-15,
5.28643285553642600257684881285016719272e-16,
8.002536471081799352133416128199137301478e-17,
0.0001533668744839607572514658152978570045778,
-1.660025375802530994896505768875173134141e-10,
-1.911172771350271088704042480220958023623e-10,
-1.466876132345746660540710719882648938705e-10,
-8.443981191742779036158035691282282377723e-11,
-3.888563336265677595730756584127254890465e-11,
-1.492265457481076990549662701041280810272e-11,
-4.908498651883102095168419701774042070596e-12,
-1.412681482008767468171898690113435844451e-12,
-3.613742399711309728762763896095618554647e-13,
-8.318658904153082642125966345963929059043e-14,
-1.740342992802624230380253623977924741064e-14,
-3.334839849909973996988207613343425410261e-15,
-5.89399616112352106165280956997105612226e-16,
-9.861905741608359001315993884374440926814e-17,
-1.495711777174204096554256111773958254143e-17,
-0.00003016616697755744135268184558393210433613,
2.85093600497968104213895239274766787526e-11,
3.282258322127126792489283714074703939724e-11,
2.519221677923781335738819240761416157142e-11,
1.450175178458868434598995257586918264101e-11,
6.678253834934832430268338550188021132848e-12,
2.56283650508814004384322770186109631567e-12,
8.429962286087341002762136594900107208723e-13,
2.426193802083517697195259050419718130188e-13,
6.20650331273511196019341051720734393087e-14,
1.428763199475392139206798789709972967931e-14,
2.989345279338478786432532507242543692329e-15,
5.729072529325579556292783058997094871372e-16,
1.012876897785393679682224579681415155867e-16,
1.695991877620293626737969461582517645501e-17,
2.575740587210226381715145052489315825061e-18,
5.410353581187508826882309506534925142811e-6,
-4.535470494381008853697302540094166338804e-12,
-5.221649128505537575554893278970420732514e-12,
-4.00775729605027511808199216228745023615e-12,
-2.307043046673457215537028795999159755674e-12,
-1.062425673393224806356190107706472249355e-12,
-4.077156143707141989424163206574296782453e-13,
-1.341107805608360747556611556014485546382e-13,
-3.859817578252992123876452038519345030874e-14,
-9.874036937331211197797800326549227392081e-15,
-2.27311260394837577138504495168801351118e-15,
-4.756227957198492498436689486311948460883e-16,
-9.116377544502846203319665352221362173894e-17,
-1.612123708441861324590962412649709223445e-17,
-2.700870323537262532638232324586629861814e-18,
-4.106075932595645827778015372734191634027e-19,
-8.915111553242790261121448154430748726565e-7,
6.712683250094173817875559886846209019449e-13,
7.728256609347449463596341525590435455076e-13,
5.931647583549857804874899923539377938196e-13,
3.414520958024047455718535717035189242481e-13,
1.572435923087015984205889945920691818348e-13,
6.034376104609970915221971830401407893485e-14,
1.984906174968069162192383858343607804283e-14,
5.712754954983646394715962878486299012708e-15,
1.461431995294256242133872941930838772419e-15,
3.36445647791459591811973690504584821595e-16,
7.040067676590309759265496210570927218422e-17,
1.34951151677368522190447326874135803041e-17,
2.386896490898516713359896682984053714175e-18,
4.000596434878000795061803678015209583635e-19,
6.086875496084711545546142407132992080566e-20,
1.358238104929434851998484428288276814634e-7,
-9.28023804090657253255923844431985011452e-14,
-1.068426194448175916601209375389084098159e-13,
-8.200463438388847255291087106825959916822e-14,
-4.720553949114489557884495238698860590281e-14,
-2.173884131455698164352334378234953238009e-14,
-8.342501933702418485440733547336789338329e-15,
-2.74413160081953481270302499819495257328e-15,
-7.897917093091706039121619956089959447226e-16,
-2.020457090933464041069940702193663484111e-16,
-4.651510769811595833561518942940393051747e-17,
-9.733569750755263699525789925572154865365e-18,
-1.865967415726630504340954911847861701821e-18,
-3.300850699164722795764289776509098410356e-19,
-5.534339564438012979275774610478149308052e-20,
-8.425827590846710075576712691566334014011e-21,
-1.92440607289952661637142941110288506356e-8,
1.203225421555261045898242237277363873792e-14,
1.385263642141083582437897039914973599384e-14,
1.063227882586826554374817136237983474125e-14,
6.12041723545406530322393641319270202805e-15,
2.818542991879569162092238436959275949966e-15,
1.0816456335817847524478941683603786086e-15,
3.557905829379421142736900573974094471565e-16,
1.024008923994325296315451859204680200423e-16,
2.619655102747705167751058984511204393665e-17,
6.031080821138555480305502396522248604474e-18,
1.262078969403984733327629056883819168619e-18,
2.419606675782425736873231199922233055937e-19,
4.280748334246011019039535541898356467405e-20,
7.179288326920353566919172344435535298415e-21,
1.093590656271333228508480708842685297712e-21,
2.585048896384110324061853517423426831042e-9,
-1.4866701152679908517984074351014152735e-15,
-1.711591299528961225292116722363271470277e-15,
-1.313693453246284951542380116775512291746e-15,
-7.562211088432909398779455918380761394935e-16,
-3.482511875885299087112117974218778740343e-16,
-1.336451787213609013999830676280380464834e-16,
-4.396058346836389540188390172059145564665e-17,
-1.265243599758194753814185548057227440804e-17,
-3.236811007312048358144292858357707886658e-18,
-7.452020002590298925840572179256583847481e-19,
-1.559468732805628415362293001923756893336e-19,
-2.98990438408297357166575313468401596488e-20,
-5.290264035879512275930514698949052285399e-21,
-8.87447165597108141797709038890897204963e-22,
-1.352409774080761885681991989587623158617e-22,
-3.205980886722792852008826274206586775033e-10,
1.710191799953446592062464491982287497154e-16,
1.968930092613381266211270947103193628705e-16,
1.511208189489942504158134125331176341403e-16,
8.699196308663295145792237029178641693928e-17,
4.006112000437959294741002055239651800808e-17,
1.537390055255395024710360529115327374406e-17,
5.057021505925871864993481216525153083312e-18,
1.455481414447025167791265223230215090114e-18,
3.723507067745455027822263574829518996014e-19,
8.57261865071179811387092578538314169188e-20,
1.79401252468912863366418948585464574222e-20,
3.439731697287522069895581587628680083165e-21,
6.086699275225264664192604413155027200746e-22,
1.021250615977397214442157745701469162969e-22,
1.556885625004672695951667781867100642995e-23,
// [{0,1.e-6},{2.,0.00001}]: m=1 maxabserror=1.73771696480437533082e-20 maxrelerror=1.34484670917778126344e-19
0.1894705899484153284411582447328103119078,
-4.03543107509726491107724246692797370812e-6,
-4.632834024781209405146444344303985990956e-6,
-3.54074968747106250508639936521344823394e-6,
-2.02523341687638250809987032650033707292e-6,
-9.237178625829958190509752410329724169061e-7,
-3.493713708830718343380923615379072883968e-7,
-1.124139213322283596264620209940116573561e-7,
-3.128201648224727935502688921391021389769e-8,
-7.59632550972221951071005041654554404234e-9,
-1.610820069560253941390505614960523132609e-9,
-2.947026848083470030148508975392154675319e-10,
-4.46977684683418642994438447985285702368e-11,
-4.888897055613479081946007054826525184693e-12,
-4.626319869725789543463616608129768140988e-14,
1.477209013007842754410394275813187598508e-13,
-0.2005370321219274006683073125614051046101,
1.299034352261546916210034953187265699061e-6,
1.495543913163473096570270777776124105351e-6,
1.147834591466453102812770236729544127951e-6,
6.607032982488145790848680692419227290416e-7,
3.042252392462056464777548925231073418105e-7,
1.167202465006542583022539609546738077606e-7,
3.837405760087072536607971189617058836066e-8,
1.103349636662758428898446074310071753971e-8,
2.817021916367256441677392473954040124367e-9,
6.459860879813778979938682055245428368222e-10,
1.341200058050493911377286520820458661665e-10,
2.531438654700340924910778730714799594567e-11,
4.338828235501713280916177277555171023523e-12,
6.753842503568824137542484141895103288901e-13,
8.843958889797198008735903517974511246472e-14,
0.1334643374506038940680739693621302039231,
-4.883840177680896998735690077457697203336e-7,
-5.62269928144568266286842073695185225511e-7,
-4.315535878396948862233713664965844076566e-7,
-2.484169987968290362944454305226164633353e-7,
-1.143954518972594309791910017242197419673e-7,
-4.389719016776604642043988521600025453865e-8,
-1.443714828555031655611140227892229984089e-8,
-4.153949208114357462845881780006834294587e-9,
-1.062043713967010385537389044712907049993e-9,
-2.442162013252472559528057387086147549451e-10,
-5.09830978658441399322373679465020568292e-11,
-9.727795507217845572476539902701157605374e-12,
-1.704466941179636041868289318469761779935e-12,
-2.794960056298725333583408555356992600089e-13,
-4.077441180443244535869533500286753412119e-14,
-0.06616424937296533019989558266095251290517,
1.661034247762128989180957306714976859364e-7,
1.912330542510243106097955543822008478152e-7,
1.467759020211641206520005239797863795085e-7,
8.448997484353649581989233163737281000378e-8,
3.890812619840495181299502807607159083741e-8,
1.493081983572898990441289880741739781589e-8,
4.910877524499246072430633749230479542779e-9,
1.413189453609239254984286705644613993314e-9,
3.614137790097148677723531226888733439034e-10,
8.315404370365727947404039975613398348878e-11,
1.737918756645475765049712322445218693357e-11,
3.323559999134401714676467933282685422919e-12,
5.850389571542228469418643588311413906038e-13,
9.697868653455955408099505303364943618575e-14,
1.444980173403836857581201230429812679603e-14,
0.02624322138245476173838782964351658654444,
-4.979688216069607040054790633422037631675e-8,
-5.73306581993168733006965978796624854354e-8,
-4.400272046319105264168096248973234158426e-8,
-2.532978807975297350499433970992904161279e-8,
-1.166460141770771944124333946542090953379e-8,
-4.476304967657295705658512636050534947207e-9,
-1.472339505347219568227290555101285642931e-9,
-4.237160883261203844197615340828272693188e-10,
-1.083753975250830278580084636753565271645e-10,
-2.494091325917731943166848625915752744298e-11,
-5.21512506414991312225209771735593645057e-12,
-9.982730892851607146576715500553979084706e-13,
-1.760610060966550676349862309807534416203e-13,
-2.931489197241109317186329743837979074205e-14,
-4.405216968459594166954225677938211988144e-15,
-0.008684536731155177909643728142844509249165,
1.319939540670893353438759542181616978536e-8,
1.519634108680135761216901744059784960568e-8,
1.166358526581737605778685411329580005943e-8,
6.71405615733302043397013409087907256911e-9,
3.091897304758764075856991221360132883115e-9,
1.186528878153412398987244003635217008792e-9,
3.902775661286342814544136552288308476481e-10,
1.123193375910355836543484222384030086138e-10,
2.873017056213784389298388366400422599472e-11,
6.612653224743077753150334628908141969465e-12,
1.383056857560570487582896764229708260181e-12,
2.648787995935527080345316294634260292678e-13,
4.676396529050677089856364157508285408905e-14,
7.805083991795096071430412486052548181665e-15,
1.178219944470700783237640501034650003158e-15,
0.002466309930575200750450703064416479722179,
-3.120345198897522576086254210968406987619e-9,
-3.592425511874404747702375360724453497886e-9,
-2.757281326650268703599178252485455293974e-9,
-1.587210487725473446713232470619018396363e-9,
-7.30929859527080070706293418210792187612e-10,
-2.804988802804244031331188913576550617875e-10,
-9.22636772346227169589207772369869434915e-11,
-2.655341672688751675774235638215398908567e-11,
-6.792372553940871326074238619143779664146e-12,
-1.563485664048620587695010716954232946717e-12,
-3.270604016249579419710339854124832050922e-13,
-6.265760606613390722402863226602629565365e-14,
-1.106925024966960018894376119018050887251e-14,
-1.850251499441444143990118636142523435516e-15,
-2.800887764884266119523508168159937014547e-16,
-0.000613467499446187671669014788365793483475,
6.640101510721083748774471567405731302278e-10,
7.644691094048392361663714313139939349714e-10,
5.86750453602003468388044731921619816884e-10,
3.377592480517696529185136885451098235413e-10,
1.55542533626570891384046259547816006682e-10,
5.969061836676350457455571954813094989674e-11,
1.96339946297422979439732248213580907802e-11,
5.650725934427400957524203439877470127503e-12,
1.44549696151985905634801872590325833513e-12,
3.327463565426294712029953935169981271555e-13,
6.961371979089876969995957828471973959044e-14,
1.333935941474789690535953366306701380762e-14,
2.357598467123007220482087186600149928425e-15,
3.944762301129970458552185402566381957928e-16,
5.982847115538773628195224971442483428017e-17,
0.0001357477512320650139068577651194009644315,
-1.282921201463369873967713695130990649831e-10,
-1.477016244062092920223869375511769791592e-10,
-1.133649754378676703729655399914156868898e-10,
-6.525788299110081549361466848158946310725e-11,
-3.00521422389941600157750452337553820273e-11,
-1.1532764265907340207973232634587485602e-11,
-3.793483026440272995466875166847338738048e-12,
-1.09178721027588705244478685783146671127e-12,
-2.792926489037992409402934980776898600658e-13,
-6.42943439374185122586114256238100115873e-14,
-1.345205374886666368867624660764632368821e-14,
-2.578082636632527735827054938867186998814e-15,
-4.55794603726638066253621361885352475579e-16,
-7.631963444645782322014447202220962239901e-17,
-1.159083263535980438384220972394651326226e-17,
-0.00002705175179294575694947119227099809257094,
2.267734445905462859188420271902590906696e-11,
2.610823641739698727444703512576742772413e-11,
2.00387793997084362643684593700248394037e-11,
1.153521115748665768576888878528031718139e-11,
5.312126489960661685711062145289747222536e-12,
2.038577351531425869058962319352746497722e-12,
6.705536658643905427819669025333781433355e-13,
1.929908107179122900572562259778372778838e-13,
4.93701672405553095244876919014769151145e-14,
1.136555900309461858400651638508189316797e-14,
2.378113138010344399676248464483218241456e-15,
4.558187160497969001270824664592902114004e-16,
8.060615689957581106283673257773887943001e-17,
1.350434683125772633297091724922760273303e-17,
2.053037236383275170756257176204183771785e-18,
4.903312422795603901948200971256087953772e-6,
-3.691976285173730752558456545237466866067e-12,
-4.250541708049275435962911185661774476607e-12,
-3.262406610675320068901398307859411199283e-12,
-1.877986780037637791550459584936580253918e-12,
-8.648398742655566607288468668933003307961e-13,
-3.318907304877474535217482611778235012538e-13,
-1.091698543379410343238652043576321002924e-13,
-3.142015648752358781994901963258403437964e-14,
-8.037877057581951090869133236991092825369e-15,
-1.850451312302782140287669492153216048101e-15,
-3.872037744172098597996012703733376621375e-16,
-7.422314343265818740284703660702278023648e-17,
-1.312793247150067074521871483919026640346e-17,
-2.200328336515637074762571919418902882364e-18,
-3.347781976392145197656934408019244245659e-19,
-8.150342802821469174729133145757987539958e-7,
5.568597427381041724224316375370709638211e-13,
6.411080547305386629870177243351096286555e-13,
4.920679772130758221112069761345861731146e-13,
2.832563611386527134665747172336565709413e-13,
1.304436969318673355940644931406332792549e-13,
5.005909829388955620973665126448324378753e-14,
1.646613386438967270353536441308078040674e-14,
4.739137153394338109052174917600741588088e-15,
1.212373233656138584631073055291908240187e-15,
2.79113434324653421801233160364513281341e-16,
5.840618752033225046508683097296358820958e-17,
1.11967189101614062185931387212273430796e-17,
1.980672239787138566964461927353939080223e-18,
3.320875292983498558380260110063501819289e-19,
5.055910665902236946188638195103331659125e-20,
1.250830271095458155080879446776148022011e-7,
-7.820808405664403735593724316346408731461e-14,
-9.00403311166746535375706658054205108889e-14,
-6.910842650285639035780336237321357213891e-14,
-3.97819142636375546637602590858159610772e-14,
-1.832016206328804713956104610056015800974e-14,
-7.030555630459788072850299965228837283595e-15,
-2.312592413098947792086976692979911598818e-15,
-6.655924528792428852671768841368500685335e-16,
-1.70274166949644238195425731520098054223e-16,
-3.920123915192480561258643752374543402903e-17,
-8.20334876855006161311106759691247636126e-18,
-1.572712790622231568434347588577198866022e-18,
-2.782430583417239284800171303611557474449e-19,
-4.666443702771099809373142082536993629268e-20,
-7.108196322771393321032697094621412907683e-21,
-1.783277916541354057417629132326492902774e-8,
1.027612448853583942729492422415572780322e-14,
1.183081913697361129331464663189127793232e-14,
9.080479446438718139202390296674703956865e-15,
5.227132853339274955057972551406655146064e-15,
2.40717323040157139115743293116974680756e-15,
9.237788784957387481195514451770357150319e-16,
3.038632414514010816911830979995908568091e-16,
8.745584494255320138609624522929540497062e-17,
2.237339954275803504290084527081116834232e-17,
5.150964277783123082824738683435304223046e-18,
1.077931039644402839679097334093336079976e-18,
2.066670164978470031086913270397584065295e-19,
3.656708476792648121748979189762112715907e-20,
6.134137135610449770703448004214749797407e-21,
9.347931620319339924040807916332107106461e-22,
2.408630646889383195327610503914638019001e-9,
-1.284574205912814890924169852361843865513e-15,
-1.478919972917828349395085762012499707821e-15,
-1.135111898339381859421252087820839021316e-15,
-6.534216336708138784526563510763033269153e-16,
-3.009105849809300794543586816169052739819e-16,
-1.154777853354513939323565795689925783755e-16,
-3.798474198426102648096255662597998444768e-17,
-1.09325392985382878236042890279692504559e-17,
-2.796833231079784546473668013651553917628e-18,
-6.439140547370082347106858890464531284249e-19,
-1.347534499911845526391372217125326301313e-19,
-2.583681854783215890497445374903059878281e-20,
-4.571896619700690483510364324243495212623e-21,
-7.670913637946277296717279473201378469662e-22,
-1.169423595443199369459238733111263432882e-22,
-3.001031352071431750387296848388969922298e-10,
1.492322287977593552259628616066927461517e-16,
1.718098733920999755507652707543668173872e-16,
1.318688293401145818076659183826964021115e-16,
7.590965998536453461144529052775258397287e-17,
3.495756118714948220900702609761343300286e-17,
1.341536078360506142904611097562586437965e-17,
4.412793342496314278727837637854820834442e-18,
1.270066472981254104222364365990743853884e-18,
3.249181471627466695986384523949321505706e-19,
7.480649176499993283300385626662603949635e-20,
1.565522269882329043668202695088144125376e-20,
3.001747903213236695546663637134624241105e-21,
5.312066147888937338403153714216805639209e-22,
8.914299972822093669201077913348118356891e-23,
1.359401518098333325055767383299794233051e-23,
// [{0,1.e-6},{2.,0.00001}]: m=2 maxabserror=1.63754530472211763025e-20 maxrelerror=2.76691906332640641923e-19
0.1002685160609637003195978226082829009407,
-6.495171761307734580986435494759665763883e-7,
-7.477719565817365482777971370656657461809e-7,
-5.739172957332265514007528064903784640433e-7,
-3.303516491244072895391918205120527158989e-7,
-1.521126196231028232373843563047145374001e-7,
-5.83601232503271291505539897292409495595e-8,
-1.918702880043536268285137838746176235624e-8,
-5.516748183313792144437983570211349348e-9,
-1.40851095818362822082481830059087990325e-9,
-3.229930439906889489937389126957757901998e-10,
-6.70600029025246955681956286478610760948e-11,
-1.265719327350170462442566935412548464174e-11,
-2.169414117750856640435394617293269155907e-12,
-3.376921251784412068733148292911121195451e-13,
-4.421979444898599004309830485242227844181e-14,
-0.1334643374506038856726141304524336404275,
4.883840177680896959634859043656472779978e-7,
5.622699281445682617851944790061763653144e-7,
4.315535878396948827682321269270305703614e-7,
2.484169987968290343055108294700039523476e-7,
1.143954518972594300632559242975742225655e-7,
4.389719016776604606893923101010577601079e-8,
1.44371482855503164404901145591790286956e-8,
4.153949208114357429568317723175601688797e-9,
1.062043713967010377024033488955184912957e-9,
2.442162013252472539927449155038211197315e-10,
5.098309786584413952203664273961568716995e-11,
9.727795507217845493821761991583415784328e-12,
1.704466941179636027948200208131788802906e-12,
2.794960056298725310220380829553551604398e-13,
4.077441180443244500232033117709673546689e-14,
0.09924637405944800182192538169556100310364,
-2.491551371643193512330808948952415086131e-7,
-2.868495813765364692027113307541008981909e-7,
-2.201638530317461835016458268404533825058e-7,
-1.267349622653047451825630162818909495451e-7,
-5.836218929760742838849474751069171138677e-8,
-2.239622975359348511335677547250223663722e-8,
-7.3663162867488691930962566402077699846e-9,
-2.119784180413858906782554141756269262222e-9,
-5.421206685145723078767551974539752175865e-10,
-1.247310655554859206427152687880732778107e-10,
-2.606878134968213677536596672853864198434e-11,
-4.985339998701602629467596733735000149453e-12,
-8.775584357313342805812065276313129069513e-13,
-1.454680298018393328283437228337767909456e-13,
-2.167470260105755312413946620438640996823e-14,
-0.05248644276491093434215343330513432365442,
9.959376432139279787196493009004651671188e-8,
1.14661316398634503081861599726052134452e-7,
8.800544092638268590307847192248698864572e-8,
5.065957615950628124098901997866416510278e-8,
2.332920283541559280102027327722975812387e-8,
8.952609935314650479330248174604361189174e-9,
2.944679010694458566062102952810651641344e-9,
8.474321766522463609759040855300651867471e-10,
2.167507950501674863449334729547465735668e-10,
4.98818265183549682422385584736799318915e-11,
1.043025012829989517678611905923732288089e-11,
1.996546178570334646877059641622878691904e-12,
3.521220121933124744748751775825886230549e-13,
5.862978394482257894834356780609942479503e-14,
8.810433936919248221047361782740004376301e-15,
0.02171134182788747512435037815535383818954,
-3.299848851677212818507220564042956456595e-8,
-3.799085271700315726617339966425408867213e-8,
-2.91589631645432584213368596527428429238e-8,
-1.678514039333244647685141071709032710894e-8,
-7.729743261896862015999606494727631199086e-9,
-2.96632219538351251026876461862360302852e-9,
-9.756939153215796225217259705047042996742e-10,
-2.807983439775872088956888693872106559492e-10,
-7.182542640534416196924886677186247801715e-11,
-1.653163306185759129200353854880600759449e-11,
-3.457642143901404643840724288157456943374e-12,
-6.621969989838776330068931164321856922443e-13,
-1.169099132262661950375199017465028924179e-13,
-1.951270997948761727129640842865952777297e-14,
-2.945549861176733205613393909927648709009e-15,
-0.007398929791657864268998317944477927704243,
9.361035596661021531714064590167523980759e-9,
1.077727653558689535779295261819298444143e-8,
8.271843979922930360163322071324172058951e-9,
4.761631463160373795810239480926518623099e-9,
2.192789578573850530820173379239788887757e-9,
8.414966408384373339362207808070711044812e-10,
2.767910317029353287918029340919055016799e-10,
7.966025018039406989779307318622339709908e-11,
2.037711766175392899577720165096884571227e-11,
4.690456992130048169583873518527620949061e-12,
9.811812048715643635086884715026559573765e-13,
1.879728181977671420114595646453040919619e-13,
3.32077507488964945365157527365857762903e-14,
5.550754498305483348571836272041375599495e-15,
8.402663294624046333365969366973633492547e-16,
0.002147136248074182121581124468189040793069,
-2.324035528757863835522438924291901094571e-9,
-2.675641882923251615006011335087592261153e-9,
-2.053626587611858530914222481179178564791e-9,
-1.182157368183983587951540752969595322328e-9,
-5.443988676942828673372030971906532860058e-10,
-2.089171642841653028999599720810986333571e-10,
-6.871898120426022062352213864836199487853e-11,
-1.977754077054258067431229682641757205752e-11,
-5.059239365331448137160839981683506168779e-12,
-1.164612247901952489557538703983006407472e-12,
-2.436480192687210827998837883771912525025e-13,
-4.668775795172797133716895999360066761e-14,
-8.251594634950052620970387707376987952596e-15,
-1.380666805398767486617020814093172734107e-15,
-2.093996490443571887258917158316643583493e-16,
-0.0005429910063478140241521954289552299902719,
5.131684812464323808726007374992744224213e-10,
5.908064983859384187281495029636422912906e-10,
4.534599023356369764384807436164921212527e-10,
2.610315323006758334642316920265550190702e-10,
1.202085691108353487025404355915064192868e-10,
4.61310571230581770954221473807439582394e-11,
1.51739321253093806956169414421356666879e-11,
4.367148846729842849038704103750918960304e-12,
1.11717059705456454641019914809416850132e-12,
2.571773760810648872196558674021357248118e-13,
5.380821506481999466000050039415653484411e-14,
1.031233055982840955681060343855490966156e-14,
1.823178417260045841158967742697663968464e-15,
3.05278538180834111946805038099596892095e-16,
4.636333060169218401734281770358318402809e-17,
0.0001217328829107822210553473434209332920207,
-1.020480499967923949743946542507190900807e-10,
-1.174870637989009004942295617340894110119e-10,
-9.01745072377573569558198310297428919205e-11,
-5.190845017361553977105692353680997758283e-11,
-2.390456918867066246506213621960476683124e-11,
-9.173598075692776412607227563697582566734e-12,
-3.017491494350798610042967738961888941339e-12,
-8.684586476437609377142273838694872921651e-13,
-2.221657524323667445969248356215764690087e-13,
-5.114501547936007170843400220577618502384e-14,
-1.07015091138125508185995420311241509833e-14,
-2.051184220836949688021973810687125377462e-15,
-3.627277058025861730179291271109111478052e-16,
-6.076956069944973904537710180629936952273e-17,
-9.238667557437150298848151053909550354291e-18,
-0.00002451654696956233377454486114693329492716,
1.845987437326564954172005102491779089024e-11,
2.125270042064060099674556666799394014143e-11,
1.631202682135422645987835712239887039517e-11,
9.389930312753913068040375871968401588497e-12,
4.324197719258936697010869780483030042223e-12,
1.659453018438255059725418744608186279074e-12,
5.458490631439986766489332281817267540605e-13,
1.571007224149935426989621882735550093841e-13,
4.018936993240041863626745399930759380823e-14,
9.252253026159091661859588952447088420967e-15,
1.936018132208427039705893718370654653222e-15,
3.711155752939354469484750538084415938507e-16,
6.563963724988382705820084795643808512474e-17,
1.100163746859564321406045856048657289496e-17,
1.673890345403279126910681351258873948256e-18,
4.482689549453476276780534499377946953138e-6,
-3.062729026388959183278978120600868108972e-12,
-3.526094809116990624180132558972396673216e-12,
-2.706374264652018282144469967625172211718e-12,
-1.55791021075281965737701320612584016652e-12,
-7.174404365065080504513998542788235788072e-13,
-2.753250802901526571976038475337647536623e-13,
-9.056374930429026450862804576436917201515e-14,
-2.606525809970609777010498898833958084849e-14,
-6.668053746014192878373659417586771644334e-15,
-1.535124110019891113491350983231170566285e-15,
-3.212340776622966686140571499258310314075e-16,
-6.158196288411192506439544351144848101804e-17,
-1.089369889015872553406222811952566686541e-17,
-1.82648167490150118435733628818303127839e-18,
-2.780751268676874819433884704761764063965e-19,
-7.50584084830843102262298276553351489264e-7,
4.692885168053932578251515496937220634586e-13,
5.402880527335445587403064052553951345809e-13,
4.146859159740330857182772745173106297678e-13,
2.387118386472427618254308698793780269489e-13,
1.09930345280449219681027419307206849223e-13,
4.218693074155955028125674672661729208599e-14,
1.387673764853685631059074297370879115281e-14,
3.993895251570401428529959858745846724353e-15,
1.021732120140325477023085147070361569345e-15,
2.352274925077590528319153124201829164722e-16,
4.92242902569116931631157472564643124375e-17,
9.437081629924549666218962091159278004235e-18,
1.669600796433097963431661449931615233843e-18,
2.80010529912175590618541555024975872684e-19,
4.265282477841677686508960043922954880478e-20,
1.159098879709013416732259883870700281885e-7,
-6.679341824613320886723573579163383467098e-14,
-7.689872302438132159490451892140055041853e-14,
-5.902188730905707245625325835558159775558e-14,
-3.39756560251601287182327098414511064667e-14,
-1.564630017294902721959604573902294094241e-14,
-6.004437671194626736210714853080036906489e-15,
-1.975069939536258386268717284204408336443e-15,
-5.684511542961729027264458905832504307549e-16,
-1.454240685607361930658366852645313962857e-16,
-3.348057054570403678756621329078915183432e-17,
-7.006405833388516176964262680345450148728e-18,
-1.343307625907216095794003245226680183608e-18,
-2.376810986625854487645550246012529022132e-19,
-3.987106009230628121379786979155685294068e-20,
-6.076028719909035084212372624751049309024e-21,
-1.66136340462056600122210369454794775965e-8,
8.877099607803074959455509403321314315895e-15,
1.022013351953609545060365406323166644763e-14,
7.844234544782462729452457497184898930724e-15,
4.515495380566044180385050609917685420542e-15,
2.079454179362164673675303504547404565946e-15,
7.980136691571720573019570675580066081822e-16,
2.624950105681374955171443563352769014346e-16,
7.554972627385046683349096205603803398993e-17,
1.932761967038358922531007228553388628455e-17,
4.449790945212577582935230795404028920268e-18,
9.31218088622838052901374185195531439924e-19,
1.78546015549037295703879440914334546442e-19,
3.159415596130199767226759044618653169996e-20,
5.300974087521805591557136680864673484609e-21,
8.081224186543609535276950409668064122612e-22,
2.254683378063580217857217482074695153683e-9,
-1.120953706154210238090940827667932496856e-15,
-1.290545051169309893630661531413376051984e-15,
-9.905290177957684451246199243037997699841e-16,
-5.701932848692572047429055495248121897165e-16,
-2.625827419377896217952658158818238381256e-16,
-1.00769106998202391298648059798150052706e-16,
-3.314657376206348359316419267827050719429e-17,
-9.540068841198622635666762394780227805034e-18,
-2.440613615882114511206286822783576505519e-18,
-5.619068929143851857243814044522096777681e-19,
-1.17593777471444449517207114535193115368e-19,
-2.254754938427995202495055845506793786669e-20,
-3.99014505964348089893628280371439013395e-21,
-6.695956691958802468562071933099517539229e-22,
-1.021112234169564196802935525916059245372e-22,
-2.820641817574261684584197289540747544433e-10,
1.313490773745663047419292726973369069211e-16,
1.512211486632901298674261087099244981798e-16,
1.160664209424639272316925600934556183274e-16,
6.681308760078087650468795942565822528518e-17,
3.076845792751901005406304432335406146123e-17,
1.180775075328690673648386719936763391777e-17,
3.883996610993728206328315038975507939985e-18,
1.117873265786607837061016510579069761272e-18,
2.859840531653463431284746447026219181264e-19,
6.584315001424181678860741227739228755691e-20,
1.377962783960616280112103929067503405916e-20,
2.642203108391997192669606231263880914054e-21,
4.676093182773717822596216017486985144839e-22,
7.848205818954674133870270266931421182812e-23,
1.197150395951731296347648000904097695434e-23,
// [{0,1.e-6},{2.,0.00001}]: m=3 maxabserror=1.54974655578995080751e-20 maxrelerror=4.28504165194179706534e-19
0.0667321687253019428225328346195595758166,
-2.441920088840448479760517771461346234482e-7,
-2.811349640722841308860450345882382566043e-7,
-2.157767939198474413790870641581461849307e-7,
-1.242084993984145171498604944196712495741e-7,
-5.719772594862971503029480612216418092246e-8,
-2.194859508388302303395800107822318079865e-8,
-7.218574142775158220076768500832453868122e-9,
-2.076974604057178714735722634234488309048e-9,
-5.310218569835051884996252867057809160609e-10,
-1.22108100662623626993519489906144040093e-10,
-2.549154893292206976042123775742402363911e-11,
-4.86389775360892274679638601302699901455e-12,
-8.52233470589818013953834995245871847522e-13,
-1.39748002814936265507616993483802780769e-13,
-2.038720590221622250064099239353488264407e-14,
-0.09924637405944799390271167461951254487535,
2.491551371643193477653359287626802582428e-7,
2.868495813765364652103240085165214602872e-7,
2.201638530317461804373777877167490063275e-7,
1.267349622653047434186313854247149651759e-7,
5.836218929760742757617683320715046794896e-8,
2.239622975359348480162026736158809250319e-8,
7.366316286748869090554746486056850944533e-9,
2.119784180413858877269497449699547522008e-9,
5.421206685145723003264423043783025772529e-10,
1.247310655554859189043671376124192524221e-10,
2.606878134968213641156010789372869407943e-11,
4.985339998701602559706966492011510269306e-12,
8.775584357313342682344886106842519995037e-13,
1.454680298018393307558457232807547195061e-13,
2.167470260105755280792974829328539432247e-14,
0.07872966414736640768510214245143795306394,
-1.493906464820891993579712927764241272638e-7,
-1.719919745979517575586147925918949170276e-7,
-1.32008161389574031107942957497469516294e-7,
-7.598936423925942315859984401202257485229e-8,
-3.499380425312338979887273475416553017302e-8,
-1.342891490297197594823256961129498071049e-8,
-4.417018516041687924497689508587521031713e-9,
-1.271148264978369563166498651144810317551e-9,
-3.251261925752512350695951936238684002682e-10,
-7.482273977753245364167666663734665163737e-11,
-1.564537519244984303271224161369085288097e-11,
-2.994819267855502021616936527870478087013e-12,
-5.281830182899687207924258727157385134994e-13,
-8.794467591723386994685858209842340560144e-14,
-1.321565090537887256419509376590347171559e-14,
-0.04342268365577628108290383406255933774317,
6.599697703354483911021227936553403995379e-8,
7.598170543400698543637286437930477962994e-8,
5.831792632908703178012805655945585492762e-8,
3.357028078666518937505110635484584148858e-8,
1.545948652379386053863428060648378802718e-8,
5.932644390767077406556610012623839797749e-9,
1.951387830643176476716258512671826140205e-9,
5.615966879551793773373808832950902938765e-10,
1.436508528106895927370698801508800947252e-10,
3.306326612371547470615684011071020189804e-11,
6.915284287802870423738344115816117857643e-12,
1.324393997967766988996826544340034310552e-12,
2.33819826452534464889557748786341619799e-13,
3.902541995897558281726921455965739943638e-14,
5.891099722353519548961563547720884798502e-15,
0.01849732447914421624076184364158414391243,
-2.340258899165237020642006526193550340959e-8,
-2.694319133896702699092662744855005444696e-8,
-2.067960994980716364230605123787525676239e-8,
-1.190407865790084108639546495906595900119e-8,
-5.481973946434583313449957333366047743006e-9,
-2.103741602096076827861535434589021974837e-9,
-6.919775792573328922277354471069537176233e-10,
-1.991506254509836119742646304093754729384e-10,
-5.094279415438442268536559091594341136201e-11,
-1.172614248032502837440412920616990465608e-11,
-2.452953012178891644172742466551144256443e-12,
-4.699320454944141609062410976721413620078e-13,
-8.301937687224058249784219043472054622011e-14,
-1.387688624576359860607287019930251733697e-14,
-2.100665823655994832479565020514137702512e-15,
-0.006441408744158650717033287005470982802312,
6.972106586245613879604546244816798904659e-9,
8.026925648737544424619237257092358518767e-9,
6.160879762810853201403181341234806797199e-9,
3.546472104537719434375201603125970748063e-9,
1.633196603076294853736837329636563067961e-9,
6.267514928499808310843704166865344990021e-10,
2.06156943611953361088262802414835542621e-10,
5.933262231138963186747348332508588463277e-11,
1.517771809593342879028327627858910623387e-11,
3.493836743691832545682822709540070756083e-12,
7.309440578032280772909350215649135666342e-13,
1.400632738546210880259782969170938229916e-13,
2.475478390475054503011301658637025005466e-14,
4.142000416179581626053066310882599846109e-15,
6.28198947130520397895162446134740446671e-16,
0.00190046852222920181264392209462749767101,
-1.796089684367410393960271916283130030977e-9,
-2.067822744356422413130759163153445112648e-9,
-1.58710965817905669893751616194152862759e-9,
-9.136103630548563967577887558516514992179e-10,
-4.207299918890708554914842495050308229657e-10,
-1.614586999311438464995820709546463708405e-10,
-5.310876243872763915643989875105190026734e-11,
-1.528502096359612768393863708931420964138e-11,
-3.910097089701638336848134198728545214232e-12,
-9.001208162861819862584645574335953779052e-13,
-1.88328752727383751285441343705881222696e-13,
-3.609315695949795245709692155238675522251e-14,
-6.381124460427597876104846041193367275862e-15,
-1.068474883635846737787357101448294985429e-15,
-1.622716571063693748988022407572359378064e-16,
-0.0004869315329821624207934778447717862293404,
4.081922005734721321086353631586094178187e-10,
4.69948255870609088070803083601035801622e-10,
3.606980294691148665469007653508179486316e-10,
2.07633800992695629947073329383398490099e-10,
9.561827689202379554164372228040673274101e-11,
3.669439235547737796272772002550662316346e-11,
1.206996599474021022794115604028900776575e-11,
3.473834595564909123809513136432606972078e-12,
8.886630110060221451214949708770366914944e-13,
2.045800622113482794023675748095298651858e-13,
4.280603651676000640195955486242808168885e-14,
8.204736895142448728936696299492226230795e-15,
1.450910825297843396330253257298813541203e-15,
2.430782431482028070797667755986461030183e-16,
3.695467028321120145817695927530607650306e-17,
0.0001103244612140122758010844438704907319443,
-8.306943461812773023059954800587386793757e-11,
-9.563715182200030565592135981881314682722e-11,
-7.340412064168980871262923314699808896648e-11,
-4.225468637607507538670088807117313231755e-11,
-1.945888972224300178516667088162082049625e-11,
-7.467538577437452450223214590934269126874e-12,
-2.45632078232742944075250505468516972786e-12,
-7.069532503434830575803103873607358212977e-13,
-1.808521645617498712733045580692639588066e-13,
-4.163513858685222474086107694529567306144e-14,
-8.71208158847861217148787188060717964143e-15,
-1.670020087584091454394173261130556892701e-15,
-2.953783674052472607949534780983989225065e-16,
-4.950736857187669820292118872338132594846e-17,
-7.532506548698287549977673892337608587521e-18,
-0.00002241343346186407949146604634992840992278,
1.531363887712051325584263880602144231934e-11,
1.763046684445528132353665668189935658356e-11,
1.353186579619327161574144210725751216872e-11,
7.789547872133814556635588201844106623959e-12,
3.587200717342375441270257448860641960394e-12,
1.376624839166886585990546271353549775652e-12,
4.528185615657710593642314380047712704283e-13,
1.30326237265381475676642613057581667553e-13,
3.33402551114567546314198532455248538827e-14,
7.675617414614460347445407061482204361153e-15,
1.606169732109303383583607006248770979189e-15,
3.079096885922414363973679461921900903358e-16,
5.446847218082755671817459458841405581405e-17,
9.132404636310159331389923523691442468606e-18,
1.390375063985795298391928664764758307886e-18,
4.128213420352967497319237157084238461547e-6,
-2.581087236487652941586453276255577314505e-12,
-2.971584743710349773493134873201977733407e-12,
-2.280772886066004481128939065501474060825e-12,
-1.312915313004642025615789803848651621719e-12,
-6.046169913504354095677678020449671682519e-13,
-2.320281545028530985228407744342983559964e-13,
-7.632206871929823698700867863042003791815e-14,
-2.196642723737036847799449539855718704373e-14,
-5.619527518758574283446242351564362167616e-15,
-1.293751406332687020186102034975735764344e-15,
-2.70733637755192588503670900560425344367e-16,
-5.190395689223868308923581061960150859642e-17,
-9.18280578354195706743070112090460042741e-18,
-1.54005815007542601960010092638992612279e-18,
-2.34590572228950812832590799800325062825e-19,
-6.955403764425994575630315261384202235301e-7,
4.007959958555079847025076860973569763829e-13,
4.614331933331193082883564459037912712833e-13,
3.541626813437706804590134446750684868597e-13,
2.038719869437667534820316919208290551533e-13,
9.388611370815836390317439357505512669603e-14,
3.602981611176361868187358458004921364651e-14,
1.185146897242185047902371798770915465617e-14,
3.411008940925943222660775773352549719658e-15,
8.726216757734874346565348372023799282911e-16,
2.009012122644934715301948545618316029199e-16,
4.204215792493314249504828356901926200162e-17,
8.060559635034740384986992925285060956531e-18,
1.426212939324779147238612564767226468592e-18,
2.392475689982916310920313218303393998608e-19,
3.645940818203933793084344208838989135466e-20,
1.079856152598791874585421011631766995193e-7,
-5.769990550496940959531835582950193894109e-14,
-6.642943803464123232392432277588450478359e-14,
-5.098642709736355846506702198130270120108e-14,
-2.935008823524895192716266819937495017507e-14,
-1.351616124043849355905727817783309837048e-14,
-5.186977203445074654360233114584870320433e-15,
-1.706180844197057568944830343538615454128e-15,
-4.910626508772371009522338565527017160892e-16,
-1.256268237553860275254119175345206992223e-16,
-2.89230185604416570693053681949927394231e-17,
-6.052787278620042704901844747246818098224e-18,
-1.160524115619728951832582282779442053351e-18,
-2.053575914335822387771022628919237895134e-19,
-3.445558916335330719024661826107322755262e-20,
-5.252682425635514720895853144690667460798e-21,
-1.555000052869103003015041563999957474058e-8,
7.744755347345439998198943459093463577059e-15,
8.916474983308454363026083333504253139906e-15,
6.84364113121993139195540047642725512741e-15,
3.939509226891180947728010979338810106476e-15,
1.814204333498694892104902862411142005102e-15,
6.962214919656520977784409044017350426235e-16,
2.290122157418928713891711017469057802131e-16,
6.591306275360251845990497418521479479602e-17,
1.686238383703066160255985780920507046856e-17,
3.882256407382331630883986763249165104542e-18,
8.124638129302595128299888695562973816977e-19,
1.557825087264534633494836426267644706062e-19,
2.756813259225002976813306401448927245148e-20,
4.626256808368799635225872106357358765542e-21,
7.054848269253893530905867568215353139129e-22,
2.119181292911459916684431772800177985385e-9,
-9.866466985832892647949739965625743412369e-16,
-1.135918501132416359006981770968640758911e-15,
-8.718489185877306914258767309835128983777e-16,
-5.01875716660606656342009979906953149799e-16,
-2.31121512823695986343224203914501116297e-16,
-8.869554746738330662166670422409122726896e-17,
-2.917517602174329613161483229631522616594e-17,
-8.397059197371996290295546560617427593378e-18,
-2.148208676079195422819891548148776748149e-18,
-4.945899165684982298071988650661369599857e-19,
-1.035075821711668170771232256665202314735e-19,
-1.984727603629576831680411613774076240642e-20,
-3.512512984242907991063419754687343965778e-21,
-5.895292079696608428897595159037548241439e-22,
-8.992572681576662494705492196391191674793e-23,
-2.660656982253027357103673938240877114014e-10,
1.164915723738713870930369691084003264372e-16,
1.341158249119389838522805066220898540711e-16,
1.02937616691627374128495912018587802961e-16,
5.925555982922976884969062335759844962638e-17,
2.728810570053355470186176998530478885489e-17,
1.047212998915597516703544079625164335991e-17,
3.444665598869251319976344865244382921555e-18,
9.914288495393289743608140726997122420783e-19,
2.536368276950224233918843957286524960536e-19,
5.839613768644841151124928942657386226388e-20,
1.222129055007810431023956901280643357006e-20,
2.343461369293930605587102077287890619001e-21,
4.147620147689658877101556107617043967384e-22,
6.962122734861961147400569791618540812191e-23,
1.062240764915134948269949485956616380147e-23,
// [{0,1.e-6},{2.,0.00001}]: m=4 maxabserror=1.47089531656009554542e-20 maxrelerror=5.77583335793556305109e-19
0.04962318702972399693828371514910123475267,
-1.245775685821596738775556225342177775277e-7,
-1.4342479068826823259927620530188580015e-7,
-1.100819265158730902141713794475240071155e-7,
-6.336748113265237170671520610174294944079e-8,
-2.918109464880371378689085169298711467979e-8,
-1.119811487679674240035055379505210430615e-8,
-3.683158143374434545126200433113737323303e-9,
-1.059892090206929438591238690256631294133e-9,
-2.710603342572861501520899337243518185994e-10,
-6.236553277774295944962074024906048606192e-11,
-1.303439067484106820524368629956742816358e-11,
-2.492669999350801279750628746984530942814e-12,
-4.3877921786566713409903871584806618154e-13,
-7.273401490091966537486625413378692372411e-14,
-1.083735130052877640349833073176338018413e-14,
-0.07872966414736640019112126408656453330984,
1.49390646482089196261675275588904770788e-7,
1.719919745979517539938736185921537132458e-7,
1.320081613895740283719050708657323433226e-7,
7.59893642392594215836122210884923192156e-8,
3.499380425312338907356633156836622480223e-8,
1.34289149029719756698876404698914503009e-8,
4.417018516041687832939817510150715015075e-9,
1.271148264978369536814664987879439693865e-9,
3.251261925752512283279959392471167975931e-10,
7.482273977753245208951337196852789196135e-11,
1.56453751924498427078676170228803986166e-11,
2.994819267855501959325694449490959505668e-12,
5.281830182899687097671496660577033136926e-13,
8.794467591723386809596699229070543353654e-14,
1.321565090537887228173778146830053565607e-14,
0.06513402548366442748163610721277251465966,
-9.899546555031726095599017574234954783652e-8,
-1.139725581510104807917916722969868638095e-7,
-8.747688949363054969434128710474362571661e-8,
-5.035542117999778522776893558758766288935e-8,
-2.318922978569079134454075701970862466839e-8,
-8.898966586150616315757503114817118766487e-9,
-2.927081745964764782809937645158545373207e-9,
-8.423950319327690855014827086470457067063e-10,
-2.154762792160343940931366701241271298116e-10,
-4.959489918557321320755420770483401004476e-11,
-1.037292643170430587593616875830809519752e-11,
-1.986590996951650529580948793447658265866e-12,
-3.507297396788017054916609644293766484793e-13,
-5.853812993846337559546889172183725024191e-14,
-8.836649583530279532485080866286960654226e-15,
-0.03699464895828969185690009649034855401173,
4.680517798330526073409819827744457049463e-8,
5.38863826779346530236122036782649488951e-8,
4.135921989961478706580467525162545868613e-8,
2.380815731580194684371932808934532981125e-8,
1.096394789286928851199686869080807760402e-8,
4.207483204192200430573716181704202700382e-9,
1.383955158514681170422094628680728982516e-9,
3.98301250901971652278116399392165059608e-10,
1.018855883087699782719124364577166050541e-10,
2.345228496065031758419296383940223431743e-11,
4.905906024357837877301040669115774211091e-12,
9.39864090988838789628867015811281876852e-13,
1.66038753744483017753242333348198553528e-13,
2.77537724915275082477603370263327765916e-14,
4.201331647312037130889993893587818952296e-15,
0.01610352186039620501408272273685276156618,
-1.743026646561386975145371774324828952297e-8,
-2.006731412184367115872240157983343655984e-8,
-1.540219940702698724780713890589847119959e-8,
-8.866180261344214682332186415681322889543e-9,
-4.08299150769069849541436473523116814304e-9,
-1.566878732124937249559369139140059667548e-9,
-5.153923590298785251935786200794338204907e-10,
-1.483315557784726758357314731659341480959e-10,
-3.794429523983321283162924943932248231977e-11,
-8.734591859229498675622081087331792173334e-12,
-1.827360144508052887550812077977467190317e-12,
-3.501581846365494015077664919523862008279e-13,
-6.188695976187577517957809421145648686578e-14,
-1.035500104044885544496982412209873568988e-14,
-1.570497367826285941908487352247645208646e-15,
-0.005701405566627140570999613683733036477444,
5.38826905307725024875117951838321611149e-9,
6.203468233040506888185669990179177923245e-9,
4.76132897451509572824093770588493652596e-9,
2.740831089151862181552179800149546551591e-9,
1.262189975661360790461645679424717866285e-9,
4.843760997911858510931232827777694530211e-10,
1.593262873154442280584635614562435737056e-10,
4.585506289057577631376288864691034725225e-11,
1.173029126905052375076619361345656329665e-11,
2.700362448846023096732372635807359681471e-12,
5.649862581795304056022106997480762870655e-13,
1.082794708779912912704079542859785858301e-13,
1.914337338119384163254618534745009081108e-14,
3.205424650892607207308283521170292380042e-15,
4.868149713168292567642434954199304472531e-16,
0.001704260365448817058424868723788489219427,
-1.428672702011551473409894193711789788528e-9,
-1.64481889555219635504497503531552135014e-9,
-1.262443103145789213450013481241139540712e-9,
-7.267183034766723425991083932709023166571e-10,
-3.346639691231137517254005916841246413984e-10,
-1.284303732445662770562316187155566416109e-10,
-4.224488098172081529533770381540983818626e-11,
-1.215842108451462096384335631384579017263e-11,
-3.110320538530655574969019615568127175612e-12,
-7.160302177419242121242339622861189138706e-13,
-1.498211278091215500781949156539160503152e-13,
-2.871657913308707364852080152836986093042e-14,
-5.078187888558117231069204624566329274477e-15,
-8.507738510213399406966138623056168749252e-16,
-1.293413459916406512813104612253360069869e-16,
-0.0004412978461231866327541052318069310364579,
3.322777389960154698764481679875624037928e-10,
3.825486078907078792626594055539752052564e-10,
2.936164830293533382336936759669885291312e-10,
1.690187457705904691301498596797555076379e-10,
7.783555901160278904949804669890621506786e-11,
2.987015435681082589831860696823660195185e-11,
9.825283144789814724084835621969793006786e-12,
2.827813005829354052815023286721121462294e-12,
7.23408659386831685210847681302489698886e-13,
1.665405546098400593945858251036621714387e-13,
3.484832640883737675506885533431802336194e-14,
6.680080360868223955447805998187281833025e-15,
1.181513471485081772172306603400145931783e-15,
1.980294746004453471151610680199152318256e-16,
3.013002624254948799168075223173850192896e-17,
0.0001008604504369656438918466824043187023956,
-6.891137489173624413809591935975873244393e-11,
-7.933710073637532775124431605193829146467e-11,
-6.089339603399858738854413988333941540276e-11,
-3.505296539646971912910759363385832176699e-11,
-1.614240321508525626205320302911227601054e-11,
-6.194811771279186881611108079985252443789e-12,
-2.037683525410560088509270560778203961929e-12,
-5.864680672235186902786152291271910181686e-13,
-1.500311478811362379413853619905608534882e-13,
-3.454027833804001532511085648764399480012e-14,
-7.227763788689361088966108993544671518797e-15,
-1.385593597552391340109805007654400172138e-15,
-2.451081246167732495568123361523325087233e-16,
-4.109582083032888315664746689570734581973e-17,
-6.256687782888942219858520556932757838386e-18,
-0.00002064105358336768252023882544114051914268,
1.290543059754942843555728830081865154982e-11,
1.485791728871329769109958505130516771536e-11,
1.140385949525037712073037311400235058894e-11,
6.564573724167314644586337760352464387626e-12,
3.02308364849365991225044821777315703061e-12,
1.160140270454552734152072422157883237112e-12,
3.816101784506086742177669413613601022914e-13,
1.098320886552006538116310003074412549838e-13,
2.809762543375309289683394180161852810957e-14,
6.468754231976468370547978296140652741185e-15,
1.35366760284323256304567587874421478157e-15,
2.595196721044664577538914367406347237909e-16,
4.591400903106132900732846832467676407469e-17,
7.700287411863386499281120762786045909366e-18,
1.172952351667106481841466386589705735175e-18,
3.825472975603262406817265883266221691512e-6,
-2.204378331186582994810186183324312576303e-12,
-2.537882970868030004072387908435934724426e-12,
-1.947895060185857396851328962052776898322e-12,
-1.121296108249803625673926273356653718212e-12,
-5.163737083149071799982805993976866325239e-13,
-1.981640204362574874087103668889512562167e-13,
-6.51830898156065579898872161617856823694e-14,
-1.876055218775080586391512218529715598209e-14,
-4.799419987485715898086132603974623667015e-15,
-1.104956844906338386454197417428755445889e-15,
-2.312319057255162950655300012833506502133e-16,
-4.433308511439196372655849878482930184148e-17,
-7.844172426851150781152301724372028574272e-18,
-1.315861841131779199221279381604833906689e-18,
-2.005267773049425963436805516210481650607e-19,
-6.479903886057663532302028223793717932515e-7,
3.462311186150247103172223108950602784897e-13,
3.986131075720914773819476011084917042631e-13,
3.059465615097100043459732875824410477155e-13,
1.761166468641741173160080093253469114373e-13,
8.110438978136277111810617566687226891283e-14,
3.112471163113610554191105522304214240568e-14,
1.023802201201999663794896500324982966591e-14,
2.946645573689949876300877911952211049782e-15,
7.538299319049497662338801379701810148415e-16,
1.735539952455300411037838799034285726416e-16,
3.632004793153931986237598988824779417319e-17,
6.963782143950135858183807155660371849832e-18,
1.232258374501144417610649378248961545295e-18,
2.067524758703619276582646220373976364585e-19,
3.151898504981703161861562126542096303387e-20,
1.010721506131720358376405131353774419978e-7,
-5.033979412042399781633781085194144038184e-14,
-5.795580296703212712835838576005017447097e-14,
-4.448268152142071719919263582014721340184e-14,
-2.560624248537125903784609369116854790308e-14,
-1.179206682995359904366417215930409282471e-14,
-4.525339406268789633351920370054434732156e-15,
-1.488546412738670231820371447571316890857e-15,
-4.284254129506956138212022219639254557749e-16,
-1.096030658381106619776917233810824820615e-16,
-2.523410737646120180212786332424850082502e-17,
-5.280897735579384084872358128091569173972e-18,
-1.012563861367961633170133797240884263922e-18,
-1.791888889469196606816493955053575397246e-19,
-3.007000222818667912075190619303277558456e-20,
-4.585549563860188728762735277933096045062e-21,
-1.461398411490580688892471679516660156654e-8,
6.815522458153917634050513604270455173176e-15,
7.846656823491288110991072334839162082805e-15,
6.022526484009685610465163974809863467851e-15,
3.466838947176434342622326522458834042076e-15,
1.596532829166568211323311209644683345712e-15,
6.126878889607177980845994251275126632749e-16,
2.01535219372370685810317267570331013311e-16,
5.800489745796949060143725511720510296987e-17,
1.48393157833147686603201092629370288071e-17,
3.41650918419002425018850215547580128478e-18,
7.150054409729003198080145560960712367294e-19,
1.371001061429417629961747691185993289225e-19,
2.426354268222788731576464490530849196499e-20,
4.072304165813271521776612614024047935444e-21,
6.211782695382262966543741752538111085207e-22,
1.99900408279868220885309666563362464284e-9,
-8.750599481152487559130259505476629905942e-16,
-1.007449589748530065520601660442909043475e-15,
-7.732455121422730293077365571762823092933e-16,
-4.45115179397634015633499437323997694946e-16,
-2.049824540722792014615041370080242526951e-16,
-7.866441630430643985463385924415304560659e-17,
-2.58755964255216541414642144608810003701e-17,
-7.447402999130434511639389040823408543332e-18,
-1.905266010096130359030616054507591331548e-18,
-4.386593985263025271971831292106732305573e-19,
-9.180374541105562391823851127471888590933e-20,
-1.760358659284045622062839891678252169431e-20,
-3.115605062352517711541214624282696923883e-21,
-5.229801982631776230772718657191611072621e-22,
-7.979336917866905604429037313362006326245e-23,
-2.517807103505619670305243552738627348639e-10,
1.040149021330005280733553804545481749221e-16,
1.19751536126444172729159251954084717053e-16,
9.191263092105828455522884623021713726858e-17,
5.290908317658206671802122808859746020746e-17,
2.436545930296626681116208012984853066112e-17,
9.350533813663395244996069994716210772297e-18,
3.075734061152724194254090293179704818826e-18,
8.85245919825019434345636788379270561517e-19,
2.264727891430234398537493528426044683093e-19,
5.214233915352563383256277281166880932611e-20,
1.091261406032311086368914691290911644215e-20,
2.092570616805874081741938557149247651785e-21,
3.703758421202690889214700988533631795878e-22,
6.217764242112263230806054305213444317667e-23,
9.488690209803289795558723168911062929121e-24,
// [{0,1.e-6},{2.,0.00001}]: m=5 maxabserror=1.39969431657727867907e-20 maxrelerror=7.19164313709368222382e-19
0.03936483207368320008312264371200782015325,
-7.469532324104459812622024723167292492735e-8,
-8.59959872989758769916208437588556129478e-8,
-6.600408069478701418187238386537014492385e-8,
-3.799468211962971078945738968475186075937e-8,
-1.749690212656169453570154278959166406977e-8,
-6.714457451485987834528734322245395414641e-9,
-2.2085092580208439163333715740212240732e-9,
-6.355741324891847683680347873982981339633e-10,
-1.625630962876256141539443709873723407012e-10,
-3.74113698887662260424419550669253405286e-11,
-7.822687596224921353449359834460693490629e-12,
-1.497409633927750979569946968835407698549e-12,
-2.640915091449843548671305356968180332125e-13,
-4.397233795861693404522235203420292235856e-14,
-6.607825452689436140447375324212481940019e-15,
-0.06513402548366442036963921909971417894233,
9.899546555031725817460683045640926252293e-8,
1.139725581510104775896069044229944212189e-7,
8.747688949363054723657540988088012125646e-8,
5.035542117999778381296719406258943420558e-8,
2.318922978569079069300234331627378968879e-8,
8.898966586150616065721828976657525758279e-9,
2.927081745964764700563963408063079173176e-9,
8.423950319327690618297312407403388982078e-10,
2.154762792160343880371672916608107138178e-10,
4.959489918557321181324042908638352044809e-11,
1.037292643170430558412390519973245036581e-11,
1.986590996951650473622681297692423548579e-12,
3.507297396788016955868608454809024129222e-13,
5.853812993846337393251329765295341764665e-14,
8.836649583530279278660864434621769249577e-15,
0.05549197343743454335849564854599571777621,
-7.020776697495789317005061848219297822829e-8,
-8.082957401690198191733047108982724773469e-8,
-6.203882984942218242689092190518297945863e-8,
-3.571223597370292131796481927254414305862e-8,
-1.64459218393039332526355723379848633127e-8,
-6.311224806288300831847142176739206041501e-9,
-2.075932737772021816811035296160939976178e-9,
-5.974518763529574960252054813028856700548e-10,
-1.528283824631549719125609371316855457433e-10,
-3.517842744097547741344548209537937686221e-11,
-7.358859036536757033017340498004682782579e-12,
-1.409796136483258226068899939096563044812e-12,
-2.490581306167245339980212473425825259652e-13,
-4.163065873729126360881990170498814091555e-14,
-6.301997470968055885202424652653603644086e-15,
-0.03220704372079360521234091665591122648655,
3.486053293122820690557812130987089425864e-8,
4.01346282436878804344631154964395403031e-8,
3.080439881405438751539341637519570431045e-8,
1.7732360522688667117620522225999876467e-8,
8.165983015381506479797656245388406251427e-9,
3.133757464249916516822660148563924520799e-9,
1.030784718059770871562904609232735691922e-9,
2.966631115569493296344031629322804473482e-10,
7.588859047966744334975366077131068088976e-11,
1.746918371845923166126416163514713782881e-11,
3.654720289016154813229707146664589910788e-12,
7.003163692731082066255232800284147265074e-13,
1.237739195237532148295453270407751906462e-13,
2.071000208089799034439026165690211600067e-14,
3.140994735652614538180945307790751987758e-15,
0.01425351391656745010911076085735382102205,
-1.347067263269297664334264987584736799934e-8,
-1.550867058260109570264503581130459525985e-8,
-1.190332243628760767590041261490970856416e-8,
-6.852077722879579673201137786682085747652e-9,
-3.155474939153367077956244615023837753834e-9,
-1.210940249477951235127077045185123704934e-9,
-3.983157182886061648204707378182839754041e-10,
-1.146376572264381728572765063069441395493e-10,
-2.932572817262598500097580949278905099821e-11,
-6.75090612211498305782520785925721959215e-12,
-1.412465645448810383433672531086454242884e-12,
-2.706986771949752307808215927445546674442e-13,
-4.785843345298407351168873832087426930875e-14,
-8.013561627231428930888683147215696101239e-15,
-1.217037428292059541857261131843547433503e-15,
-0.005112781096289068173148849294215005605401,
4.286018106012214088530751616206457051013e-9,
4.934456686630753687758609593787317817993e-9,
3.787329309417538269609147041075435159502e-9,
2.180154910418602340776246204157525496664e-9,
1.003991907364084612596939251739955584923e-9,
3.852911197316815315839779842970822090805e-10,
1.267346429444988814952860706107244523082e-10,
3.647526325335287808644754256343461147908e-11,
9.330961615543106878791002902921335171311e-12,
2.148090653214523247097411461862246114323e-12,
4.494633834250102951181522497293537194706e-13,
8.614973739880974699374923685078159432793e-14,
1.523456366559443929387887261845828577149e-14,
2.552321553050603015974129822334572474205e-15,
3.880240379728740874733041721533885902589e-16,
0.001544542461441856146023379273958986304737,
-1.162972086490027278835049467251563865796e-9,
-1.338920127622051815737198195279907220867e-9,
-1.027657690606247539092026835453061718808e-9,
-5.915656101990876499697910503404280918088e-10,
-2.724244565415404677347381168660249766692e-10,
-1.04545540249195060357588477377595075781e-10,
-3.438849100688183792533524388949124549753e-11,
-9.897345520436553752324108240401592862197e-12,
-2.531930307862561736158265992185180999195e-12,
-5.828919411364319685212202274583257889445e-13,
-1.219691424313476730622350464688002862149e-13,
-2.338028126311872189437823296867711920809e-14,
-4.135297150211936057050631458337267540726e-15,
-6.931031611039346017322328371739100223925e-16,
-1.054550918492859101600210046166578202527e-16,
-0.0004034418029504159175630964625018281562906,
2.756455000372091452502917991945860235053e-10,
3.173484034869127494788897900973843670853e-10,
2.435735845515426878123738727892560743375e-10,
1.402118618250873862292458092472045297597e-10,
6.456961297050029925544013797688886026855e-11,
2.477924712739168914242888968881906296546e-11,
8.150734115548031092746033117525041379355e-12,
2.345872272896391298870279365932238105807e-12,
6.001245925484618556429639828248262293934e-13,
1.381611135879045585176835630587829968411e-13,
2.891105520409579077526550578541301979005e-14,
5.542374399670745718436308085099740666681e-15,
9.804325001417535851182238601840949219717e-16,
1.643832836024808747770041512527722772524e-16,
2.502675117447127923706366975626821805134e-17,
0.00009288474099059203856361133067722909777191,
-5.807443763902061379081923969636184068114e-11,
-6.686062774170070776621555771694509431484e-11,
-5.131736768448683706840082006535006170471e-11,
-2.954058173334400445479820895623097067901e-11,
-1.360387640652026519021583923901908939885e-11,
-5.220631212555008514256866692082778401533e-12,
-1.717245801550653695707977068214199671169e-12,
-4.942443985232728364541668426367952711799e-13,
-1.264393143431271648738346687718226610773e-13,
-2.910939401885290573549903017384996733315e-14,
-6.091504207553688020052255735036724401277e-15,
-1.167838523465086295212857858542961485686e-15,
-2.066130404618784166585701725004876517967e-16,
-3.465129332351465043712103678123067753954e-17,
-5.27828557794194370899949064287871821396e-18,
-0.00001912735204862190279216337614276362424704,
1.102188663901908947343012088732564530381e-11,
1.268940907840672413404334204713390844946e-11,
9.739470867739726363087975119248541925503e-12,
5.606477989303623426715982383492390131115e-12,
2.581867366363616996301014723609893640376e-12,
9.908196511800136447583169937473575423539e-13,
3.259153007270452399337130380130085779814e-13,
9.380271824088648410609864843996103870655e-14,
2.399708901398762787587626139138950607351e-14,
5.524781709541374947760747669124332601411e-15,
1.15615900227186452256574684692659088817e-15,
2.216653246373570238437737468496786364282e-16,
3.922084426849306236602580033048189318485e-17,
6.579306206105763372154949247724765244784e-18,
1.002633428689623124140337995784529793702e-18,
3.563947998592708291691437998847403079101e-6,
-1.904271472094731904357203733511545459173e-12,
-2.192372459728531508512744820330450782629e-12,
-1.682706370816610688513213053176217865452e-12,
-9.686417203804111341439234206716893015525e-13,
-4.460742186900021806192443249892206111015e-13,
-1.711859427121543868454418696353913186115e-13,
-5.630913052006190263328844217912715481585e-14,
-1.620655337630174801182578350366783856083e-14,
-4.146065321597047681638923515520077269817e-15,
-9.545471341243771968038717862575349821082e-16,
-1.997602971671101024046225837497025629671e-16,
-3.830080822421962585355454163755530652766e-17,
-6.777422198373668881163703140042989261885e-18,
-1.137138808471012464052710143434745155144e-18,
-1.733544469600917562817691700499479709879e-19,
-6.065056916980192420781446634795843574617e-7,
3.020672279677948756579216942095952890094e-13,
3.477675873125676331979514123929579185648e-13,
2.669212406392136083664910744689284175948e-13,
1.536519332648891902540596727439126517154e-13,
7.075906848842756156335090387480845211122e-14,
2.715459517398190077339615177712175044731e-14,
8.932120139392549578154429826644950233829e-15,
2.570794722223138766961312120097905077518e-15,
6.576803687021159715281060972039958043983e-16,
1.514189129484150905447423572284598210747e-16,
3.168837267005819707537957916537675127564e-17,
6.075955816349804654297630720376605545726e-18,
1.075234694321234826206715584513298362759e-18,
1.804370312057650034610388817686668094411e-19,
2.75158948911032566687046331917580561212e-20,
9.49881823077103278935095783013804116102e-8,
-4.429988834585276345640121191662539493274e-14,
-5.100210927370532873929408693429860965727e-14,
-3.914553175313837532082933736468231407978e-14,
-2.253394060597298994796879103535775178777e-14,
-1.037722735191455113426168034427950956307e-14,
-3.98238069593324025915251757015380032738e-15,
-1.309949130032174816549809265489262986317e-15,
-3.770232577169660984810859465247716783991e-16,
-9.645335864041815662212846649975757889749e-17,
-2.220680456402722185320546129176169914793e-17,
-4.647429647289847062671487349202312837537e-18,
-8.9113041672793036735772426904421907607e-19,
-1.577094388699783316258869938642183392265e-19,
-2.646937452576538006364896928737364174053e-20,
-4.037566766577930302396631119137796141308e-21,
-1.37839708071354058524706473663718049668e-8,
6.043670021553519807047459723779793252357e-15,
6.958029439213750061364093412654274777239e-15,
5.340480640805468385223657434261239028217e-15,
3.074222811970568960670580393298689370714e-15,
1.415727349783387246817795762629012265294e-15,
5.433019378663498956874734462697909119581e-16,
1.787118250732957096163216770001902037403e-16,
5.143606771426862254085659326879514825027e-17,
1.315886676757145165717834006603524436601e-17,
3.029634521350929254287036761748258584446e-18,
6.340493558413903144776495416770032270955e-19,
1.215803967973452266263424612550126414364e-19,
2.151811636832415309368209528438626738499e-20,
3.611984261056313229801793736177998143792e-21,
5.510932511856065088394610068872839847631e-22,
1.891696346877820279305535463664141865674e-9,
-7.813519862805532698544216668238896515595e-16,
-8.995643768322429493699673103082164449765e-16,
-6.904406510560840967849624616484683860354e-16,
-3.974489847424451932086315059118230118738e-16,
-1.830314661736018356374023972402576071591e-16,
-7.024049470582789799966010087607181085236e-17,
-2.310467902550999437208039612415252402214e-17,
-6.649899670586196768883554969680191727405e-18,
-1.701246291616574166737989109835898885896e-18,
-3.916892749568977640713941065188950643149e-19,
-8.197472723424615229858519599231752196939e-20,
-1.571923241804721656877168411115310134934e-20,
-2.78223571597939742883137426052404473465e-21,
-4.670739551233977483616166101806531263697e-22,
-7.127839466365856745584853243210260122623e-23,
-2.389484407061603143808386552844662277035e-10,
9.343706014387731501881084141231076283167e-17,
1.07573352399420081250515191786119806107e-16,
8.2565540096489562008469494879079928806e-17,
4.752847739517037339593025301628700073121e-17,
2.188761002294408431151449122950886021642e-17,
8.399632647845148572113487500029045101355e-18,
2.762949621782107759965315290423609271571e-18,
7.952225935572637429149604061018591563007e-19,
2.034426437893763940111547732066203467882e-19,
4.684021116093758501244099383975371871983e-20,
9.803064812673865897020287969771445508957e-21,
1.879847474509553531856930395888803977972e-21,
3.32739306224860907371337286997790028347e-22,
5.586491336456075606688227653343995078139e-23,
8.526910239717915488261640946171816916245e-24,
// [{0,1.e-6},{2.,0.00001}]: m=6 maxabserror=1.33506973542780209415e-20 maxrelerror=8.51686512243835180271e-19
0.03256701274183221017295718043182748164117,
-4.949773277515862908311253066026830150957e-8,
-5.698627907550523878997851959798593823258e-8,
-4.37384447468152736145844346871925284714e-8,
-2.517771058999889190435182605541288837546e-8,
-1.159461489284539534551945737151675947832e-8,
-4.449483293075308032484169647916947830138e-9,
-1.463540872982382350158056258379274587929e-9,
-4.211975159663845308791977451157993721101e-10,
-1.077381396080171940094586530310043082459e-10,
-2.479744959278660590451927571582088722762e-11,
-5.186463215852152791622244481413401908534e-12,
-9.932954984758252367270185923492050289536e-13,
-1.753648698394008477785040305164328849999e-13,
-2.926906496923168696375017305233651937559e-14,
-4.418324791765139638947737373319978125539e-15,
-0.05549197343743453659150129186470555286783,
7.020776697495789065794456300792318228471e-8,
8.082957401690197902516247377188924177605e-8,
6.203882984942218020707145445952707845015e-8,
3.5712235973702920040135748141414767555e-8,
1.644592183930393266417513399295287742279e-8,
6.311224806288300606018328096085793264356e-9,
2.075932737772021742527546661414656360949e-9,
5.974518763529574746451629514958392636775e-10,
1.528283824631549664428685447655701941518e-10,
3.517842744097547615410874532564852862637e-11,
7.358859036536756769451492551297737308587e-12,
1.409796136483258175526219225297090256435e-12,
2.490581306167245250514487443600857208598e-13,
4.163065873729126210661060372006674676709e-14,
6.301997470968055655875609346947894598121e-15,
0.04831056558119041313376708379284753816161,
-5.229079939684231223616939106654587563174e-8,
-6.020194236553182281359366463604309624282e-8,
-4.620659822108158293240785327015672915928e-8,
-2.659854078403300163160962041852698555263e-8,
-1.224897452307226015957146215927830704546e-8,
-4.700636196374874944041382128664418197372e-9,
-1.546177077089656362871411382519729510257e-9,
-4.449946673354240104332463045904032796993e-10,
-1.138328857195011691132498216705733787504e-10,
-2.620377557768884843326017561432885321207e-11,
-5.48208043352423241686379773507497655668e-12,
-1.050474553909662347720319441068445110675e-12,
-1.856608792856298289323601814909859884828e-13,
-3.106500312134698663965758769065494076388e-14,
-4.711492103478921978744830859254311706341e-15,
-0.02850702783313603742566120884234342723038,
2.694134526538637543926613830567207100743e-8,
3.101734116520267742624513322773291740361e-8,
2.380664487257558838641660570616791353548e-8,
1.370415544575937408209749340732384116765e-8,
6.310949878306833045086479953367377911594e-9,
2.421880498955940420171320698955335988772e-9,
7.966314365772248127789008174925598310723e-10,
2.292753144528799385724752525117940062273e-10,
5.865145634525288916886346311494652475796e-11,
1.350181224423017774376018756226182981222e-11,
2.824931290897665058390680364459699913406e-12,
5.41397354389958955121641903297194101275e-13,
9.571686690596965047057679363125723769813e-14,
1.602712325446311030397892078967664529606e-14,
2.43407485658415762146743552712025479327e-15,
0.01278195274072228768474865588546926493252,
-1.071504526503040000355187513660539878104e-8,
-1.233614171657672854423010697023623739231e-8,
-9.468323273543726188993925163601259873109e-9,
-5.450387276046437070917535524621303588885e-9,
-2.509979768410179856742211163371144952298e-9,
-9.632277993291916733879525767703236674834e-10,
-3.168366073612432053166971713178382736567e-10,
-9.118815813338104440161711313075133403824e-11,
-2.332740403885747278151323532678196233664e-11,
-5.37022663303624033151123974347923533992e-12,
-1.12365845856251155072986943256505669665e-12,
-2.153743434970216468556216878555849232578e-13,
-3.808640916398561663860961414551069253918e-14,
-6.380803882626426669155999354231257913927e-15,
-9.700600949321728711342644503102534544873e-16,
-0.004633627384270968945735358281744306445734,
3.488916259449813951013505270980392623141e-9,
4.016760382842821189621050101537980196535e-9,
3.082973071800832924855851585992417891101e-9,
1.774696830586953316190631110924145855284e-9,
8.172733696198736542954035705649149896591e-10,
3.136366207457631749767766557744619367949e-10,
1.031654730200461882659003713208316816783e-10,
2.969203656113716525356294224018099037891e-11,
7.595790923543555264474830489885357766919e-12,
1.748675823399135469488044005605146185829e-12,
3.659074272919165474542029881133507115098e-13,
7.014084378894838301908763712883697699771e-14,
1.240589145056362645777121663079853517492e-14,
2.079309483299683850952046212949070489564e-15,
3.163652755460075016794418625770393798053e-16,
0.001412046310336663388859876253148243426906,
-9.647592501338381574515212359265294247555e-10,
-1.110719412208346354392209038434232057239e-9,
-8.525075459335859767617747339557035548611e-10,
-4.907415163896401862512856505820336315954e-10,
-2.259936453975957874507720232002265483887e-10,
-8.672736494619509130632546614413924860403e-11,
-2.852756940452474350383684371000130657369e-11,
-8.210552955168060841276134509863738375203e-12,
-2.100436073927468317892892126449021887306e-12,
-4.835638975594737589947611707849783724979e-13,
-1.011886932147136253170979883767860992415e-13,
-1.939831039892016699094843936173473356901e-14,
-3.431513750508981327555750828784672356186e-15,
-5.753414926108398202762723802584046154457e-16,
-8.75936291109787765255796297843396887269e-17,
-0.000371538965106589597181174652410173943767,
2.322977509808211267039531403715177164036e-10,
2.67442511455801132073708670279936336165e-10,
2.052694711132671599798482883377534110005e-10,
1.181623271494271757833078582394112491743e-10,
5.441550572557602610148338855306293155252e-11,
2.088252488840243099293293447955954445776e-11,
6.868983218762223982513086559929271965758e-12,
1.976977597707958985575227195286044753306e-12,
5.057572582973063561348126017780045731461e-13,
1.164375762883361599422533085210188062787e-13,
2.436601687477760421674680949505151574659e-14,
4.671354102405936638744494227240648073495e-15,
8.264521633601710090220646614400032808814e-16,
1.386051735480472844103018422328162522737e-16,
2.111314235054161760326989467873577877708e-17,
0.00008607308409046256282940742284998753918275,
-4.95984898302479415005677340973021253885e-11,
-5.710234080063301867869202198539029564027e-11,
-4.382761886476593223742508932764067027739e-11,
-2.522915092880431263936101177895597659198e-11,
-1.161840313801586366724157076549825766691e-11,
-4.45868842623434834835329887514362697115e-12,
-1.466618851931049368988078802753545290026e-12,
-4.221122316981258318873496900475152245149e-13,
-1.079869004642280369050904813476300609965e-13,
-2.486151767020774366668655652061710426497e-14,
-5.202715505466525893251078149708784492297e-15,
-9.974939599558910213079213498015132220594e-16,
-1.764937990467415994681337473047045530258e-16,
-2.960687790036029587862103392800237984366e-17,
-4.511850424963221542134874535251011762462e-18,
-0.00001781972778587155023847681821523847246261,
9.52135282923249395260759112338128662479e-12,
1.096185708186024543397937862871688741754e-11,
8.413527850057295878176349902034216645041e-12,
4.843206297002675260911502764118779182445e-12,
2.230370032007498223930099156694882030976e-12,
8.559293062193631678835966720560707352532e-13,
2.815455186105834527422070588327135358714e-13,
8.10327283170026913033100973546540382329e-14,
2.073031674196248379261057733264195243858e-14,
4.772733399078242020111036602101598676865e-15,
9.988010104255051817558717834495113192403e-16,
1.915039499541317377934277918907939339212e-16,
3.38870948543800045710922030920015559822e-17,
5.685691332726525688101907200762689824816e-18,
8.667718211492901272490281847222121512316e-19,
3.335782125747712351459985664891146029249e-6,
-1.661370044004575302459865943016660649954e-12,
-1.912722064303046824725645239836381971924e-12,
-1.468067079934398193291316195145389101255e-12,
-8.450857805631830274398129617618826767316e-13,
-3.891749446613863275530912990335247277172e-13,
-1.493502995431497529480447486682822494496e-13,
-4.912666934740048089123961856840022930421e-14,
-1.413937344191227911224194684501097187456e-14,
-3.617242659686714873840181751284510392579e-15,
-8.328041666877228908698009790558683036403e-16,
-1.742860801312201654381655013390482866843e-16,
-3.341776282848100058918981682388220597764e-17,
-5.913791852287547810282177740766308647534e-18,
-9.924038451830172346681337458678410104271e-19,
-1.513374483993092825298020949274704860149e-19,
-5.699983512549203258136388282617702169841e-7,
2.658250379084746744710622369369306311558e-13,
3.060422528691320868195873196352304199144e-13,
2.34895907214582498063075017731012151578e-13,
1.352167203993593230166809775622485363086e-13,
6.22693861673081777280219518321558640953e-14,
2.389659521239381084864493779184396317166e-14,
7.860454966072439060673279196257277523994e-15,
2.262358340636361068975271214128833273744e-15,
5.787761263669028310515963786011859021709e-16,
1.332537149051442950585310588635503779154e-16,
2.788727510549985640963506812074749269378e-17,
5.347299732868427885420811190669943110253e-18,
9.46348188679639531786188947773527579333e-19,
1.588316201349580606354849695760307553454e-19,
2.42277474346304519748033832078169144822e-20,
8.959322140947196201667064204642544613926e-8,
-3.928294057805153133648233198601933399853e-14,
-4.522613842676094750048949353416392277881e-14,
-3.471231601355151370814429528704020305264e-14,
-1.998198306890239965001363821892991295514e-14,
-9.202013537525008048135054896815670132968e-15,
-3.531380380425546820830593473123946978413e-15,
-1.161599819160862016780457184145362596709e-15,
-3.343266564673616351991143048711365440279e-16,
-8.553064267401889330111031281460323363989e-17,
-1.96921659082625752350306901048598985194e-17,
-4.121224857006297243287933138218929104878e-18,
-7.902541778753573560283100454948815389383e-19,
-1.398644990596414463075065125801751265233e-19,
-2.347735071736559258260165706209368657724e-20,
-3.582022618528099658063393405404810805005e-21,
-1.304295697288348042328715429299911194825e-8,
5.395628062464296202891078709781785855912e-15,
6.211944012654631343487943500276114550858e-15,
4.767839605645336770643348300293474955952e-15,
2.744584930794467757676583822329730150934e-15,
1.26392422924291973800166672244795220979e-15,
4.850459006036246156244142002194668634259e-16,
1.595494122749681748776704014781341241389e-16,
4.592089530832745778680556694287795823859e-17,
1.174795879683125826124504499415389664411e-17,
2.704810488476301616523533351613208412591e-18,
5.660763608245919352394129169803381959274e-19,
1.085490759387508491687309334239848784805e-19,
1.921269224244353195174606243220308604777e-20,
3.225364724312757530308561824514161022872e-21,
4.922083828678081040934103520885129411102e-22,
1.79529972989018907005458999756445990707e-9,
-7.01903618668822412836438927808336082191e-16,
-8.080961152845017214460244807798539376855e-16,
-6.202362455745528808865438212460733633004e-16,
-3.57036172110650124106043039931430197361e-16,
-1.644207626913191162590782971345762508056e-16,
-6.309843816297675534053426227753635123817e-17,
-2.075540841967090350808289998161572852811e-17,
-5.973749808907119013956080820028187299635e-18,
-1.528270792776791051130066952762684736432e-18,
-3.518658938734017018616838598698969032919e-19,
-7.364109127762010546489809328515584970179e-20,
-1.412150488344243181165978631218122034947e-20,
-2.499554011667799658399015523898778206698e-21,
-4.196600873380705274820013540909705753742e-22,
-6.405461829955905437287852355487550741366e-23,
-2.273583888641527412672935469512328010911e-10,
8.439195879154340933825905861310109071312e-17,
9.715980021042699192134379511261532507876e-17,
7.457285198400363276672927254688662115568e-17,
4.292752613196160771242961260083122597434e-17,
1.97688027477026903384163866260069454896e-17,
7.586517278233312326126814172778476039357e-18,
2.495487447004001263876347367791029370691e-18,
7.182434328509813325379278157070032893495e-19,
1.837494314821663724326567797443865090191e-19,
4.230629350081452559366967380311411396873e-20,
8.854259559516205163856539638855592407258e-21,
1.69793634073706491888016457006667639574e-21,
3.005521583393684316674599718836660652979e-22,
5.046539646495154238383050638457338678153e-23,
7.704034682218358919580601708551225042546e-24,
// [{0,1.e-6},{2.,0.00001}]: m=7 maxabserror=1.27614648670427073561e-20 maxrelerror=9.74966414225342967747e-19
0.02774598671871726828441294699475948521641,
-3.510388348747894532515150413663703918199e-8,
-4.041478700845098950818240572857109976361e-8,
-3.101941492471109010015950161498927525806e-8,
-1.785611798685146001812436475926663468569e-8,
-8.222960919651966331192550076054892551943e-9,
-3.155612403144150302665690294941409027806e-9,
-1.037966368886010871150791931956743352282e-9,
-2.987259381764787372900634532032662473814e-10,
-7.64141912315774832131150969794198898088e-11,
-1.758921372048773807513895766912148905318e-11,
-3.679429518268378384324863488847803218196e-12,
-7.048980682416290876862318106849890023172e-13,
-1.245290653083622625121153035834379950634e-13,
-2.081532936864563105101986819805612735782e-14,
-3.150998735484027827588812082689625840046e-15,
-0.04831056558119040667990781394332098384868,
5.229079939684230995610337373325647836755e-8,
6.020194236553182018857149814878978556387e-8,
4.620659822108158091763018029248407107785e-8,
2.659854078403300047181185454061327945854e-8,
1.224897452307225962546622793821907089207e-8,
4.700636196374874739071979134760937101647e-9,
1.546177077089656295449321180295108248862e-9,
4.449946673354239910280088207691765644254e-10,
1.138328857195011641487642414724545438085e-10,
2.62037755776888472902367507810933907042e-11,
5.48208043352423217763899324111657409135e-12,
1.050474553909662301844597130603402751812e-12,
1.856608792856298208116020157067076889027e-13,
3.106500312134698527600027634312671843591e-14,
4.711492103478921770538296159703787786155e-15,
0.04276054174970406121863232174385597624854,
-4.041201789807956487087017772494842315079e-8,
-4.65260117478040181103465139857314360616e-8,
-3.570996730886338409240612713165394690848e-8,
-2.055623316863906199397204382827484847841e-8,
-9.466424817460249968658840039912768636557e-9,
-3.632820748433910784156839088372535724192e-9,
-1.194947154865837269791786275228517278057e-9,
-3.439129716793199224290228665193179067076e-10,
-8.797718451787933748085779067958083005125e-11,
-2.025271836634526747387790078571385356085e-11,
-4.237396936346497767209073764003029903834e-12,
-8.120960315849384671290044025600839278985e-13,
-1.43575300358954481803663759421346670192e-13,
-2.404068488169466647999984110036775158267e-14,
-3.651112284876236588573841327551255045104e-15,
-0.02556390548144565995531179339870304409547,
2.14300905300611831669106625230354569185e-8,
2.46722834331538982173480680000502427575e-8,
1.89366465470877909567036857379100854248e-8,
1.0900774552093069043160154995657942096e-8,
5.019959536820449468630494835832491608063e-9,
1.926455598658417791408778696385922521026e-9,
6.336732147224977407593120875115210092514e-10,
1.823763162667653498083975788627252310828e-10,
4.665480807771577983331774112906726973446e-11,
1.074045326607267274545926146860168791612e-11,
2.247316917125063302633734971598797743405e-12,
4.30748686994051003020127229349576799657e-13,
7.617281832797259795184435283057619027865e-14,
1.276160776525308249777781864076760515281e-14,
1.94012018986438073089899502412940558342e-15,
0.01158406846067705654653034718438983185694,
-8.722290648624411600908202695511798537824e-9,
-1.004190095710691104663593438901946082439e-8,
-7.707432679501973378888377834136962174093e-9,
-4.436742076467320583533294172599548803363e-9,
-2.043183424049655258194707280977100229152e-9,
-7.840915518643968553292745437375945552443e-10,
-2.579136825501118253422794782650960587234e-10,
-7.423009140284186394634483910882222914165e-11,
-1.898947730885861974463868926913417576327e-11,
-4.371689558497776873234199247397430328512e-12,
-9.147685682297784342316356371406644776943e-13,
-1.753521094723684771006170166984414698259e-13,
-3.101472862640862705051006443741684419368e-14,
-5.198273708249135888310589556130639640106e-15,
-7.909131888650074940202917119565826457686e-16,
-0.004236138930957917085728737134814657337785,
2.8942777503831186259213332594808561699e-9,
3.332158236603860069107090143214738362628e-9,
2.557522637784502462071194970925197314934e-9,
1.472224549159563171101589630028039231257e-9,
6.779809361884781371827607097495354732764e-10,
2.601820948369315561607679540775557676624e-10,
8.558270821303026099075167267415552052916e-11,
2.463165886534761873719963163804805868499e-11,
6.301308221742350887695195862160965541728e-12,
1.450691692669199226659753427642454833703e-12,
3.035660796422107814711179524694481650006e-13,
5.819493119639037012478555091808118300661e-14,
1.0294541251461424726548125365942205005e-14,
1.726024477821517308426369896742147892526e-15,
2.627808873312564938090743803443857265803e-16,
0.001300386377882819749322050921634665860824,
-8.130421284361616341437577488724811025397e-10,
-9.360487900990890548735483904446274508543e-10,
-7.184431488993402240937733683786339378683e-10,
-4.135681450246674601169038581954767207523e-10,
-1.904542700402862327440213414618356227233e-10,
-7.308883710970405970703126564116716623289e-11,
-2.40414412657650018230633759268845061285e-11,
-6.919421592005837456912047277205183849252e-12,
-1.770150404047730704784883311198349744428e-12,
-4.07531517010824730169898049296181613928e-13,
-8.528105906206656514136693960139995209911e-14,
-1.634973935848692980996299848262857057545e-14,
-2.892582571772308821263866057236775629147e-15,
-4.851181074201320584887811326049379276346e-16,
-7.389599822719596172743257324089955986226e-17,
-0.0003442923374531275255636020907281852410016,
1.983939597065001452974083946416495161465e-10,
2.284093636463648555834204214103448422034e-10,
1.753104757997177580405121636688114931167e-10,
1.009166039113132204544408897052646049207e-10,
4.647361264236875360150229539315710049011e-11,
1.783475373959315414902581324688056638844e-11,
5.866475419123771242094309921652271884164e-12,
1.688448930073496779017966686942891793898e-12,
4.319476026962960889429494138345416617588e-13,
9.944607087409077911597834451297781301457e-14,
2.081086206231369057696656929046906584829e-14,
3.989975847580127257162121297210403962734e-15,
7.059751975600058444418830651464711785603e-16,
1.184275118320053035793295940245295006223e-16,
1.804740173505598642842981909104895058748e-17,
0.00008018877491376264877481902652915123443012,
-4.284608769021202403534126578235369523985e-11,
-4.932835682078336409152640493133763916082e-11,
-3.786087528873291330578480256932386036407e-11,
-2.17944283154866314237227733345233333802e-11,
-1.003666513435120787271835448137469658916e-11,
-3.851681874271342672515689096609932028774e-12,
-1.266954832525362331260661431670958914504e-12,
-3.646472770747233831550846513072776823915e-13,
-9.328642524883209636538795883567355987903e-14,
-2.147730027513061361163203798629953893982e-14,
-4.494604542577915292344263174060561186544e-15,
-8.617677739619080297016781863366422435944e-16,
-1.524919266974834434288168846539678391853e-16,
-2.558561097254492601510115461521081191923e-17,
-3.900473191396308926676304669453215612194e-18,
-0.00001667889898647178583333177370413375046606,
8.306846107296985078400508560754816270659e-12,
9.563605586566093221806401580116474720868e-12,
7.340331765466560610050500995775909549897e-12,
4.225426810801795751183606430343946419538e-12,
1.945873759901306685921944186045592360635e-12,
7.467511279970805797311166364986377090854e-13,
2.456332251227270453675018373360287775391e-13,
7.069683220688064970620187120582625836929e-14,
1.808620434361895096085296410249144674572e-14,
4.164018771681604545459733453901354878218e-15,
8.714299691483878167139026359094070504732e-16,
1.670887313929235474854126284646470431252e-16,
2.956894461341634513749339434516290914527e-17,
4.962016766183689361224309739635190956684e-18,
7.566868664386565231480771408436131838441e-19,
3.134991716977598427785371208454257188003e-6,
-1.462037973052712635380955606708530630719e-12,
-1.683232695361601459678085956196210921308e-12,
-1.291927723454905071662301887971206642354e-12,
-7.43692096767846997629366567978014524525e-13,
-3.424816858924495501492273658255800848525e-13,
-1.31431297450780997704705007802222582059e-13,
-4.323251013639242781075526646226671484037e-14,
-1.244297312509448477884622933619667792591e-14,
-3.183269271049597902701029882528811968625e-15,
-7.328955646043744311686390079185153787905e-16,
-1.533800408379484172797374995479080955491e-16,
-2.941015385390571365446526087741535819579e-17,
-5.204915980049488406701046247119029322101e-18,
-8.735740689889913237440343652055843372256e-19,
-1.332526350552205526562215276666076475808e-19,
-5.376253813464384945983323664417834550526e-7,
2.357209768962730040683205543658350587118e-13,
2.713836941536201380698872917581223738542e-13,
2.082945146376764140977117672668888594365e-13,
1.199037673932695769471501113895985725934e-13,
5.521754707829573816258123462075193119109e-14,
2.119037987041586524971656808582310100859e-14,
6.970288889937748160876443503141832947734e-15,
2.00615852547191405882848059076037448313e-15,
5.132346609184635005857756618944720401707e-16,
1.181646927666431854154916729372816428892e-16,
2.472979728821699164497761283148020975971e-17,
4.741994543976535049130005606492917056097e-18,
8.392700994726646811346047179602631870019e-19,
1.408780595175537520846770340955753866365e-19,
2.149426642782552452192366106408108480614e-20,
8.477674599736543596954850949514298926963e-8,
-3.507074860750311487924772616099561797778e-14,
-4.037667613653375851391025861161039495937e-14,
-3.099022065157670037724744184592438593381e-14,
-1.783937792307633543068594704633705136477e-14,
-8.215312172815656319968644281749321644784e-15,
-3.152723398521081710471145763518992797938e-15,
-1.037046524144340587043973780977280526603e-15,
-2.984787231788657986775127453035097813294e-16,
-7.635991670693360571188887232366195525531e-17,
-1.758085017895645748112316194342206368912e-17,
-3.679408861728814227506300569278193288948e-18,
-7.055522167544146504019605863857902059569e-19,
-1.248795297033151509327504223030282524258e-19,
-2.096437196359828372342242298045241130119e-20,
-3.199278328856144498849152752461908962835e-21,
-1.23773844084357780870201745249782064222e-8,
4.846308989582832267670965071360577548559e-15,
5.579517417818618623287271624002605491617e-15,
4.282434807482723772455983370109768493972e-15,
2.465164102919354377460972316214253970593e-15,
1.135246767699388995064244999398874954996e-15,
4.356645488438959625517794059155225333387e-16,
1.43306169912266884709984668651037701033e-16,
4.12458844668491700250533099572457331492e-17,
1.055197799299887857927737908465589349956e-17,
2.429465190856488991312505186722288013138e-18,
5.084562760327006691021908169122748959776e-19,
9.750214197351062711244289428292405427255e-20,
1.72581904441047004124207372553652703993e-20,
2.897539601095422555376887798164141689785e-21,
4.422626596641821489740862356101847568411e-22,
1.708233398378929200841238003413192792973e-9,
-6.339659529733705911227455901006506354421e-16,
-7.298800290500109411397328641514269540998e-16,
-5.60203245172330159828908831953253465252e-16,
-3.224784732195049732178821892421369966633e-16,
-1.48506422442171902562804091144681939219e-16,
-5.699113674798582895015967898148340814266e-17,
-1.874650269281282447892451942861781381331e-17,
-5.395560097774993729235950458408859332834e-18,
-1.380355269330062402024468474920084400773e-18,
-3.178116823473532419734354962377300997494e-19,
-6.651462394440275678314302879938669651821e-20,
-1.275517195869929925513041169899061461335e-20,
-2.257796588019304310678953456987469454386e-21,
-3.791043417969861696325336803707239768915e-22,
-5.787399966644491075563007559337640706094e-23,
-2.168387889955444662352063374131009777183e-10,
7.659755544815059403142356928230594489836e-17,
8.818616629021196568538017492366832156725e-17,
6.768534040887531233884159541662256327957e-17,
3.896276380904232049402233823586270664049e-17,
1.794296963509027387491516104060067679048e-17,
6.885833615689501212872038393366086687225e-18,
2.265007795781506300906441521391729650003e-18,
6.51908212087620086455059602274009487353e-19,
1.667791458782399496515163708295020047178e-19,
3.839923979090600058410984100955493375189e-20,
8.036625145104164847340534977227974220986e-21,
1.541169601746350434595651982287158398587e-21,
2.728124136379772598713220065275687970308e-22,
4.581132651762647021847373294159907928939e-23,
6.994587557995175791034119167940413931997e-24,
// [{0,1.e-6},{2.,0.00001}]: m=8 maxabserror=1.22220062904421811353e-20 maxrelerror=1.089397498079960770824e-18
0.02415528279059520332909654853802423741354,
-2.614539969842115497455412908445098252578e-8,
-3.010097118276591009025903804557925779484e-8,
-2.310329911054079045572447702303425105324e-8,
-1.329927039201650023412682942354434402987e-8,
-6.124487261536129811913811048363314563873e-9,
-2.350318098187437369221571922178916689013e-9,
-7.730885385448281476212367883654716444755e-10,
-2.224973336677119954842372045704499660679e-10,
-5.691644285975058206676668063369819581506e-11,
-1.310188778884442364336498276789853259796e-11,
-2.741040216762116088452521320370321497682e-12,
-5.252372769548311508519222378090966004437e-13,
-9.283043964281491039334248458126352002758e-14,
-1.5532501560673492635907782815838293051e-14,
-2.355746051739460884949600049696725854965e-15,
-0.04276054174970405505025463840235165242456,
4.041201789807956279216072821171088576067e-8,
4.652601174780401571714455150841075737692e-8,
3.570996730886338225555686467629776952269e-8,
2.055623316863906093659790694852097322136e-8,
9.466424817460249481721248245096874284966e-9,
3.632820748433910597288548253881931612258e-9,
1.194947154865837208323797260706051457473e-9,
3.439129716793199047374605828597905153626e-10,
8.797718451787933295477661075493612700995e-11,
2.02527183663452664317885902061709931506e-11,
4.237396936346497549107164325802518394532e-12,
8.12096031584938425303323681663831856525e-13,
1.435753003589544743995946184061758449094e-13,
2.404068488169466523660034300400276902181e-14,
3.651112284876236398702995579432747891079e-15,
0.03834585822216849479788238866298119611803,
-3.214513579509177631751409017408807048022e-8,
-3.700842514973084913026749737274241691836e-8,
-2.840496982063168781986423639946035609646e-8,
-1.635116182813960436189927247446830662158e-8,
-7.529939305230674570050188456135147956158e-9,
-2.889683397987626827994046901772834707911e-9,
-9.505098220837466574799935601807146573535e-10,
-2.735644744001480380503659933440789686956e-10,
-6.998221211657367316222115908330996705775e-11,
-1.611067989910900990383021316898335989333e-11,
-3.370975375687595118380951050674137959716e-12,
-6.46123030491076536063659448299719759941e-13,
-1.142592274919589025100478091844295130717e-13,
-1.91424116478796246841868566425588400829e-14,
-2.910180284796571239528148619151452912716e-15,
-0.02316813692135514970425012977679206845721,
1.744458129724917252489408707221536140574e-8,
2.008380191421422426620433349237213892959e-8,
1.541486535900425543672068566239969807936e-8,
8.873484152934818856732579057783353031329e-9,
4.08636684809939234530411167779618228018e-9,
1.568183103728825113511172997522764256683e-9,
5.158273651002339802604969961828375883565e-10,
1.484601828056867009253053777024922807446e-10,
3.797895461771800008841309788146846259074e-11,
8.743379116995728867549754074211394063411e-12,
1.829537136459593520064999980981055069535e-12,
3.507042189447439829255939118816786440383e-13,
6.202945725281849834046959260568123651612e-14,
1.039654741649848072750120203643285662793e-14,
1.581826377730046895470996648860823821037e-15,
0.01059034732739444239463540440865508672784,
-7.235694375957683716572963315711704305075e-9,
-8.330395591509520251479181918234158245917e-9,
-6.393806594461156436962180928294472599356e-9,
-3.680561372898850525401768639062883781119e-9,
-1.694952340471168908258603562581256623996e-9,
-6.504552370923187457589789497968808725761e-10,
-2.139567705325723155218548298371566078656e-10,
-6.157914716336808640811529226626985909609e-11,
-1.575327055435563150808922233059583113019e-11,
-3.626729231672941493672576404566927321346e-12,
-7.589151991055151132691208414984749794678e-13,
-1.454873279909736546292127866849623213707e-13,
-2.573635312865315984378525188058771454213e-14,
-4.315061194553725761498420822662049245471e-15,
-6.569522183281309243473521837084367330482e-16,
-0.003901159133598689476036287151761846429688,
2.439126385291713557988887061887188528508e-9,
2.808146370277958446683726919338398014828e-9,
2.155329446683200692664699884591115148499e-9,
1.240704435065471324767184350876948124404e-9,
5.713628101169300115762420038459446438276e-10,
2.192665113276044972884909045140995070696e-10,
7.212432379679907237133249187370938218934e-11,
2.075826477587477415141710097985075928692e-11,
5.310451212106675001908442292576831638555e-12,
1.222594551024066455174051396537007321795e-12,
2.558431771844400159751803602817046156867e-13,
4.90492180751233334579197903393878706316e-14,
8.677747715257189302882302946551889861517e-15,
1.455354322250364237717121261751137155043e-15,
2.216879946800559779095381172743331635297e-16,
0.001205023181095289175659222629776347169552,
-6.943788589757600841813880883088379900124e-10,
-7.994327727657418955324153100325256284691e-10,
-6.135866653016715613772592435453073602739e-10,
-3.532081136911271482408831654161827864776e-10,
-1.626576442489956307079701196909738885797e-10,
-6.242163808884658935811300622173020456403e-11,
-2.053266396702219337517774870435569121062e-11,
-5.909571255282852787340684032122679493312e-12,
-1.511816609443589238944309346098237057446e-12,
-3.480612480608264847531229249797062854188e-13,
-7.283801721841369162646331458760835445829e-14,
-1.396491546659100276552608047395256124064e-14,
-2.470913191470740755792908158259777250493e-15,
-4.144962914138189908853538683178081985291e-16,
-6.316590607297091696915461754469183704561e-17,
-0.000320755100698059028781006926398453541083,
1.713843511123134786385206421600478986318e-10,
1.973134276877728076462405868544815371042e-10,
1.514435014655036423995237064203952103975e-10,
8.717771344072591479960870815670875040293e-11,
4.014666061973558100518131641846410017019e-11,
1.540672752868080860399140603303862308338e-11,
5.067819340494373791272424746761823498128e-12,
1.458589111290158964819803869413465760116e-12,
3.731457017605920740210947039903000266275e-13,
8.590920127671750746898832078901439787611e-14,
1.797841820718803777112604324750832812445e-14,
3.447071102919461922910070977717850324081e-15,
6.099677080418038675283946794089580343983e-16,
1.023424441004120444742915679132641823603e-16,
1.56018927976883521122228956956615539894e-17,
0.00007505504532166017854774541027531951955866,
-3.73808074449987895021188414827133669767e-11,
-4.303622509598523546140687435605294966476e-11,
-3.303149291116433042598528684142939581589e-11,
-1.901442062936125952400633396938948849818e-11,
-8.756431910692412019163813028865118623945e-12,
-3.360380072585396938372714896189722549911e-12,
-1.105349511933401574696515057359134108091e-12,
-3.181357446089322414506546877754379742196e-13,
-8.138791946389913295650167366039338560277e-14,
-1.873808445359848592140387365154909250167e-14,
-3.921434857197694771774943984976039831997e-15,
-7.518992905068034411805516651892836126357e-16,
-1.330602506255934548588281519177000223217e-16,
-2.232907542519086361202760734221038483317e-17,
-3.40509089551698595357139473362685870243e-18,
-0.00001567494745756916858948664451982672684595,
7.310186115714642345388747768094880637216e-12,
8.416159159981604239928970651383239952005e-12,
6.459635303989846799972336953441047567933e-12,
3.718458576561594324260230235438416741206e-12,
1.712407551130587264793202519160103618135e-12,
6.57156150183325499112231716482363946556e-13,
2.161624398068072374057140312714209919845e-13,
6.221483371366364342845983676660310901834e-14,
1.591633819116189866134875986191228682279e-14,
3.664475943314779412985410980867444857099e-15,
7.668998107803607619997926372454109697639e-16,
1.47050693824909104263949438078106110151e-16,
2.602456654488309166314271541167416426795e-17,
4.367868102116748203352490626981570193987e-18,
6.662628327894162006730026305945229365151e-19,
2.9569403492213612896042490221808010984e-6,
-1.296465615106304473877659527205027434795e-12,
-1.492610596661177455463750451993284023353e-12,
-1.145620044506488332786616187106578009519e-12,
-6.594708438507198138389417194094832784256e-13,
-3.036965656605433732626962094403018598143e-13,
-1.165471110580955995909240305273675455131e-13,
-3.833659605589618320957508965583690485113e-14,
-1.103387395122709324227043621221667709703e-14,
-2.822791162357474678541262920876287330185e-15,
-6.499059316244023408146041357083266469899e-16,
-1.360139104951828378332658201661047802028e-16,
-2.608097486484674406216900900326617032478e-17,
-4.615986409748875486817340064533444378937e-18,
-7.748294722247774126035154734842821511016e-19,
-1.182184874790901225871038910218018349879e-19,
-5.087236073289236945616442719340747694016e-7,
2.104457646210255218250362695448822673916e-13,
2.422845482304195262189776479929762319903e-13,
1.859601217507365064031949273051751349897e-13,
1.070470884324764381002716395119187976033e-13,
4.929685623053537752033229457847523847422e-14,
1.89182527529871501794127586402667503557e-14,
6.222908192402241879720360690878679773643e-15,
1.791053389956157293034314412710531383984e-15,
4.582058189885636484672260489848631192926e-16,
1.05495765546932897717556897331513927792e-16,
2.207868516908443561809338462442548147354e-17,
4.233741333771343148691852358247135861148e-18,
7.493529495607934696297513553417413006232e-19,
1.257989564141145180736381159388919738962e-19,
1.919761306327154369785129495012175910741e-20,
8.045062915236628292008343338374166974565e-8,
-3.150024516605883150280005272952183910171e-14,
-3.62659844733567021026067658872041697191e-14,
-2.783515178926558038094446958345199609889e-14,
-1.602317841940560274644625432854413197018e-14,
-7.378925194929470649609750630025558392711e-15,
-2.831750952644450162003009280600967253251e-15,
-9.314675344251141171364357854014786727839e-16,
-2.680917529865906410564592068186818881628e-16,
-6.858619504963324998149458978084227003481e-17,
-1.579114110060266327264427040170238992919e-17,
-3.304885709800747295375139682900417933518e-18,
-6.33748564718240842459611347315878199886e-19,
-1.12175519083669491242788168094101863455e-19,
-1.883355079582761922590182624798335815825e-20,
-2.87463755336386158078859201765156719846e-21,
-1.177631111467169095879684949263926440815e-8,
4.376663135723268326921048319033168643932e-15,
5.038817936843693472900716808801012156279e-15,
3.867433064524090291199776834042149790956e-15,
2.226270408828130046226081698179928086625e-15,
1.025232628087757616232444153874218466719e-15,
3.934454249159081998239173782421842110715e-16,
1.294188189803849965296938898046891106286e-16,
3.724892086274782653074848198803305676627e-17,
9.529453896043390176400425896907709185907e-18,
2.19405213201890022238260352699770240752e-18,
4.591917999506958393925127146955033743014e-19,
8.805684095579368388609837321481863631744e-20,
1.558695174674386029989805128140397543323e-20,
2.617183722882204615887407308130132036972e-21,
3.995372097656242672797227398711770435079e-22,
1.629207379181610969034781188259081525865e-9,
-5.75421115148748000196645350822269105206e-16,
-6.624778278231771566433225977891478700176e-16,
-5.08470196405962974673918853451738382304e-16,
-2.926985969288318766273015140928592628568e-16,
-1.347923382616107611106806381522753303651e-16,
-5.172820517072552045631818894659046181457e-17,
-1.70153382573029372277143311861154402559e-17,
-4.897307106983715420822301126484076659505e-18,
-1.252889112775133206387024929601006801167e-18,
-2.884652623345106200617368813651951258844e-19,
-6.03732587081110736685959307799338876711e-20,
-1.157767520123534055467698357877658673635e-20,
-2.049439480606249827449989677894610367199e-21,
-3.44146958756810745373964886958447916616e-22,
-5.25452377898857689836168122030159268679e-23,
-2.072481037995366609750094938427166292541e-10,
6.983374370342417561179770986806658115515e-17,
8.039904399468113383380111120143251512287e-17,
6.170850893019474391446805718932281312021e-17,
3.55222296735533141526437616798094323252e-17,
1.635855122004138532985914242226853255236e-17,
6.277795265982290055236675733624698964635e-18,
2.065002302534463098715300998749721377301e-18,
5.943437797863237662539874342334852406765e-19,
1.520526092661632841929881325557388838633e-19,
3.500874018266122833824657812563627781661e-20,
7.327081402477472838169525443280795845305e-21,
1.405123770860341079755334104594749321228e-21,
2.487379538158943371787889875980427305741e-22,
4.17717187506359421773159377737805400174e-23,
6.378668968171663613460674211865256483966e-24,
// [{0,1.e-6},{2.,0.00001}]: m=9 maxabserror=1.17262670894173418114e-20 maxrelerror=1.195595269190857329212e-18
0.02138027087485202751471130862522594314576,
-2.020600894903978139286672790074312696916e-8,
-2.32630058739020078548724413777817696034e-8,
-1.785498365443169112493870609766528867065e-8,
-1.027811658431953046666427747369344860453e-8,
-4.733212408730124740107829686947677036293e-9,
-1.816410374216955298355379877405093055294e-9,
-5.974735774329186040668703953175793312598e-10,
-1.71956485839659952341379456241370452833e-10,
-4.39885922589396664703910416405786923544e-11,
-1.01263591831726332142832272155023189859e-11,
-2.118698468173248774216392416614767088957e-12,
-4.060480157924692125869967641511001755248e-13,
-7.178765017947723718834953144835929422517e-14,
-1.202034244084733261637745075496507463334e-14,
-1.825556142438118199057823886003344109946e-15,
-0.03834585822216848889083609430272222903734,
3.214513579509177441465221255008555429082e-8,
3.700842514973084693951744086032556167866e-8,
2.840496982063168613840241162325211242103e-8,
1.635116182813960339397317087397956356639e-8,
7.52993930523067412430478801815483910961e-9,
2.889683397987626656933727669654986824503e-9,
9.505098220837466012118138939421004619429e-10,
2.735644744001480218553851831721986439026e-10,
6.998221211657366901900707542297295221389e-11,
1.611067989910900894988915196730230109058e-11,
3.370975375687594918726405219966476223243e-12,
6.461230304910764977751050667414671467806e-13,
1.142592274919588957319327068819876908869e-13,
1.914241164787962354583158853232006623155e-14,
2.910180284796571065676613160227314819483e-15,
0.03475220538203272922353528740300177793281,
-2.616687194587376022727416743146600013843e-8,
-3.012570287132133805709020983515059345393e-8,
-2.312229803850638442747633656988139708732e-8,
-1.331022622940222901754766725023934492396e-8,
-6.129550272149088855260550660885977521048e-9,
-2.352274655593237799711521612930680743995e-9,
-7.737410476503510129700190508518564074046e-10,
-2.226902742085300636430388151370205650274e-10,
-5.696843192657700326788157071510275420792e-11,
-1.311506867549359402319535075544844867884e-11,
-2.7443057046893904311820117553425436063e-12,
-5.260563284171160033628531171668739586235e-13,
-9.304418587922775264010690108921287176717e-14,
-1.559482112474772195276475373963827401496e-14,
-2.3727395665950704747928833895839350718e-15,
-0.02118069465478987748413881705691151943854,
1.447138875191568720603725442413274417546e-8,
1.66607911830194086549971377662359568162e-8,
1.278761318892259544089136042947092096997e-8,
7.361122745797863709234900806697052305377e-9,
3.389904680942412723317950458968451877862e-9,
1.300910474184666237930678420422757309613e-9,
4.279135410651540868211999963941926362828e-10,
1.231582943267388943568238479024952498405e-10,
3.150654110871195927667159742799442643388e-11,
7.253458463346043295613445227144105981196e-12,
1.517830398211063778165188821530773289643e-12,
2.909746559819537435887678184003557285712e-13,
5.147270625730745873899208398658357193626e-14,
8.630122389107642821788596795523743875278e-15,
1.313904436656291064170448617346387891397e-15,
0.009752897833996387610459240641940312028949,
-6.097815963229180207245203486636481238778e-9,
-7.020365925694776741835393374248999733889e-9,
-5.388323616707910108111219835627195036491e-9,
-3.101761087663625569221497233984857033784e-9,
-1.428407025292300740085563019340848041489e-9,
-5.481662783190019220703017202262099018433e-10,
-1.803108094919946148495755840875538070985e-10,
-5.189566193968605290593108159301294565993e-11,
-1.327612803026646173859004346759954495461e-11,
-3.056486377560114156952465845323929039928e-12,
-6.396079429610891605364391029405460176765e-13,
-1.22623045187806247231006612054735848338e-13,
-2.169436928814260389552034290555626759312e-14,
-3.638385805625848557851173378604578613561e-15,
-5.542199867001304694067120882208805424026e-16,
-0.00361506954323820622428116530646970472102,
2.083136576911927616414420393450922027863e-9,
2.398298318279550316217091722675577024e-9,
1.840759995891448343943668245321740463999e-9,
1.059624341065572040680021039613739193152e-9,
4.879729327433905370646112609669541963729e-10,
1.872649142651596222690501559348066124821e-10,
6.15979919006125982054836498411810298216e-11,
1.772871376571789430761367787415636087932e-11,
4.535449828297339511039885984962672985189e-12,
1.044183744174782884019803158216406174622e-12,
2.185140516536302256265674832374198254028e-13,
4.189474639946408925964893492194706027491e-14,
7.412739574357535197624148804739196944137e-15,
1.243488874232272514036999655830614170154e-15,
1.894977182175100847497174567773999627861e-16,
0.001122642852452169665349046806142172029427,
-5.998452288958624490415964749517754605135e-10,
-6.905969969103884649951733564071054257884e-10,
-5.300522551317062796788572479079523173755e-10,
-3.051219970439473099019391603551916250276e-10,
-1.405133121697222990404434910918578312652e-10,
-5.392354635063141820869797136923024377642e-11,
-1.773736769181207828715772730944282765887e-11,
-5.105061889539091258664850530606467183457e-12,
-1.306009956168093273568724793301034669459e-12,
-3.006822044698975699112928609320462507624e-13,
-6.292446372544827766714227002388799762107e-14,
-1.206474886027375981932757421540699708151e-14,
-2.134886978156164135185292253396862103606e-15,
-3.581985543530966209987093940313277706097e-16,
-5.460662479216193332756471901172692965366e-17,
-0.0003002201822854633676030999487953146743552,
1.4952323010173009056244611651999380004e-10,
1.721449007543518634028890721070687936077e-10,
1.321259719289580443029836048579077192165e-10,
7.605768268110149824983275184860259522406e-11,
3.502572771813605699469911744840848199765e-11,
1.344152031926438080938925350020150269611e-11,
4.421398057247401925556217859432181726451e-12,
1.272542981173968210307308982710200397358e-12,
3.255516785561290956185252793235119548045e-13,
7.495233797568582163193953780851751907051e-14,
1.568573946254827023006173949469733434495e-14,
3.00759716850102357895882010957050659311e-15,
5.322410036484142051910929989690722530941e-16,
8.931630189323602199764465634568251899357e-17,
1.362036361146268321725190759954867776464e-17,
0.00007053726344637305041755664117527104988927,
-3.289583748594969394308907743925071927955e-11,
-3.787271617989116723343808997734770748611e-11,
-2.906835883723319766105146262826324602813e-11,
-1.67330635768427000482485512597747979939e-11,
-7.705833971943659462148707602145271215534e-12,
-2.957202672699609652481803259545031062222e-12,
-9.727309781025851808446851333591532880651e-13,
-2.799667514155958670089841315182367151816e-13,
-7.162352178452979280330482737168182837963e-14,
-1.64901417274874333590167445664107710703e-14,
-3.451049144863791381747281253680628923527e-15,
-6.617281215125224203189678894970488917886e-16,
-1.171105493281279998187873626499897508206e-16,
-1.965540643872472575888713930766248017749e-17,
-2.998182744375309338778465282051190648596e-18,
-0.00001478469109017702517116895251713599969087,
6.482324643153033252759542305949892101021e-12,
7.463049031635270725136564629873923792148e-12,
5.728097189514929532622985735934332072987e-12,
3.297352473310412256971654654916996494256e-12,
1.518482024268045424906008739852659505775e-12,
5.827352467322124901328100706085911829583e-13,
1.916828787830496522482299589514243706401e-13,
5.516934054366105164440970595492710139237e-14,
1.41139483382659681495565045958222136999e-14,
3.249527937404994652253792281875019742971e-15,
6.800691923394317001077980300880220000448e-16,
1.30404805259412105337858999755536737778e-16,
2.307991982239270769404425280036597855245e-17,
3.874145307760524402956810974190896799619e-18,
5.910921238022786707234148063021158196748e-19,
2.79798056156525550934780481801428674062e-6,
-1.157451927933991048416979370461156191699e-12,
-1.332565271450954418374976974973034492133e-12,
-1.022780866257156489120861618217766974087e-12,
-5.887590995667301871483501658897295893489e-13,
-2.711327613928789334855454126396614083841e-13,
-1.040504101450227160082445929417317674092e-13,
-3.422600163815006875473667144678942635559e-14,
-9.850795538583292155726822823629770809973e-15,
-2.520132488941098423731437766580209476771e-15,
-5.802268220615702317292567291451743652217e-16,
-1.214327917776311258175018207427316590286e-16,
-2.328558181327675482327238520934039553232e-17,
-4.121442015250547865071704776816800890497e-18,
-6.918943934105254433084144991199110278675e-19,
-1.055868921825434731399669547085265726723e-19,
-4.827642318419552934399624177811633993754e-7,
1.890209445319414607465924407864021010323e-13,
2.176183265699659299067395618745869081601e-13,
1.670281185040988510547720867996123039817e-13,
9.614897609266666354808112451193592263677e-14,
4.427811284534745749616953153560078911046e-14,
1.699225631545358951070145958401965051182e-14,
5.589381044667894867195012926923567685848e-15,
1.608716254350470496947433494995478133761e-15,
4.115595711826783130317859108682179566233e-16,
9.475660905965965122125397649725571274188e-17,
1.983135748645381202011033856026157351505e-17,
3.802883226294347865353649928535156100437e-18,
6.731224804819908793817769881345063411454e-19,
1.130129544941888006557032029463811937066e-19,
1.724960448531951472233187812447656404242e-20,
7.654374905787303627539838302035419086219e-8,
-2.844760907306387310111880572096361798958e-14,
-3.275150917772692965591210916017039612302e-14,
-2.513769520832759396715464886462818148259e-14,
-1.44704009234083776530855380870739738839e-14,
-6.6638478008712353739137774301126448643e-15,
-2.557332216803273178770990420433841174201e-15,
-8.412015854403472991527434694048618222118e-16,
-2.421120168579963058707954768714981521966e-16,
-6.193992331727243868727184070463490082379e-17,
-1.426098727612480872804589733585926071106e-17,
-2.984673115042637059864541999229110702852e-18,
-5.723553544067637092833739046718225584703e-19,
-1.013126881147517014427158699477531333617e-19,
-1.701127460494841183694528128649913418149e-20,
-2.596927775252024304595591417532365344119e-21,
-1.123081023240098339260068943351699152315e-8,
3.972017433993290085165947579608909517188e-15,
4.572952593116400177604433596536089510324e-15,
3.509868562520076345295204334745770564603e-15,
2.020440154028483010871913472222694697478e-15,
9.304446780089401596778944829551913234786e-16,
3.570695004221764038445815120166332373899e-16,
1.174534904148432907505201260727715908085e-16,
3.380513448166289122164905067711591318453e-17,
8.648443270559458695080639010974120457079e-18,
1.991217870488368493898318288680475064929e-18,
4.167444116404792751118574263135170131261e-19,
7.991831986375865683931250291591329457606e-20,
1.414684879746649337876471040163616904889e-20,
2.37556929436453514591302547175595271881e-21,
3.627066847607539292887506463900776325421e-22,
1.557158693028424657884954802576908878524e-9,
-5.246162688234652362466677474550675011253e-16,
-6.039866151019912033509556788849979140567e-16,
-4.635765748347229336794831128605813618267e-16,
-2.668558007794874496431828346016872887815e-16,
-1.228913366948097732927824758222225886097e-16,
-4.716106224213785720665785252466325125009e-17,
-1.551304210026081296420947045220106447465e-17,
-4.464924853919339026835633748202669419634e-18,
-1.1422740527521997464458468997476412953e-18,
-2.629982884002762620839670784543972390191e-19,
-5.50436805632302734750741281948146018536e-20,
-1.055579748982955552686213012293518053945e-20,
-1.868609556692076162214392555802543383656e-21,
-3.138043384896992537158152620535200736098e-22,
-4.791889885541088223934663759427848648223e-23,
-1.984686630567465017887237255727646901286e-10,
6.39267374709177120564492478729210830321e-17,
7.359835486646253316475821088539224608196e-17,
5.64887919157071390600921238484136946852e-17,
3.25175245396228075747444255656852754236e-17,
1.497483844753154424256810153958510182261e-17,
5.746779762588023722044869520758794931777e-18,
1.890332240364440120925365515704018660457e-18,
5.440711712630882115033963708347688599495e-19,
1.391914800208510474973229800068295225707e-19,
3.204769690683081766143833817447903056944e-20,
6.707404396992831204277043086487349273426e-21,
1.286305927624230045526447448970897639143e-21,
2.277111347269095958094439968725682813686e-22,
3.824311066524828327163689711108894795356e-23,
5.840553835479831885665643015466487094474e-24,
// [{0,1.e-6},{2.,0.00001}]: m=10 maxabserror=1.126913985008619557507e-20 maxrelerror=1.294236983296636304073e-18
0.01917292911108424443540894896170453516058,
-1.607256789754588720436320897277455477744e-8,
-1.850421257486542346634755976289203422666e-8,
-1.420248491031584306658304464550635034703e-8,
-8.175580914069801695479452332257855113714e-9,
-3.764969652615337061458335050965410179278e-9,
-1.444841698993813328200510006846044411396e-9,
-4.752549110418733005182930753069905519919e-10,
-1.367822372000740109024757245282042198362e-10,
-3.499110605828683450305220508800037847654e-11,
-8.055339949554504473459200192301978846977e-12,
-1.685487687843797459052317817190900166693e-12,
-3.230615152455382488279314159274611868796e-13,
-5.712961374597944785541126275468277542811e-14,
-9.571205823939811771142907740536443671009e-15,
-1.455090142398285532567490501050850465482e-15,
-0.03475220538203272355660641799124642814359,
2.616687194587375847887993178708036129506e-8,
3.012570287132133604417752037078368814624e-8,
2.31222980385063828825096157552641338915e-8,
1.331022622940222812819432599882945530884e-8,
6.129550272149088445699116861801288220727e-9,
2.352274655593237642537215500923952543331e-9,
7.737410476503509612694506669954497287073e-10,
2.226902742085300487626853633619986695263e-10,
5.696843192657699946098657417006559217644e-11,
1.311506867549359314668611592778451102e-11,
2.744305704689390247732307908872225016642e-12,
5.260563284171159681815069333792582992891e-13,
9.304418587922774641188828955802723848928e-14,
1.559482112474772090669926175985491793813e-14,
2.372739566595070315018177100308202885228e-15,
0.03177104198218482071104303121070184179995,
-2.170708312787353213664167041446849636604e-8,
-2.499118677452911451093492108177182208438e-8,
-1.918141978338389433445686300345051815657e-8,
-1.104168411869679623915368215837118024748e-8,
-5.084857021413619395964015488468545704943e-9,
-1.951365711276999476241212815029373354604e-9,
-6.418703115977311694889591461556232475614e-10,
-1.847374414901083528341607571286516373725e-10,
-4.725981166306794180565686622973347503686e-11,
-1.088018769501906560897269757549665770107e-11,
-2.276745597316595806545974201064591059555e-12,
-4.364619839729306420975939370107052297825e-13,
-7.720905938596119283790907821348085647195e-14,
-1.294518358366146502706041947411793981967e-14,
-1.970856654984436717600276420373132663314e-15,
-0.01950579566799372756436101068488073224891,
1.21956319264586542299006062365492296057e-8,
1.404073185138989175106809155110543641844e-8,
1.077664723341607984589953133059533331073e-8,
6.203522175327400593132020901169265448309e-9,
2.856814050584670306445104767341500055592e-9,
1.096332556638030257081284083593005395738e-9,
3.606216189839979179134016017203878973393e-10,
1.037913238793746064361880985412029002313e-10,
2.655225606053356322100562640095312590961e-11,
6.112972755120375610158823172494933434558e-12,
1.279215885922209149560669311503171367567e-12,
2.452460903756184066422226995782559843986e-13,
4.338873857628625443522298434037281447833e-14,
7.276771611251872905677512892134764257922e-15,
1.108439973400287788751082420118895586927e-15,
0.009037673858095192610090676384975822345514,
-5.207841442279723443219422614953996432182e-9,
-5.99574579569876572951843666733168751987e-9,
-4.601899989728536384946430653656657268282e-9,
-2.649060852663881474083403098213135109714e-9,
-1.219932331858453948864428998794018989741e-9,
-4.681622856628904617721919503540217785864e-10,
-1.5399497975152866865405587847871600772e-10,
-4.432178441429392214736972871962589512205e-11,
-1.133862457074314062549346880625909562081e-11,
-2.610459360436909284431958932229049170207e-12,
-5.46285129134065533375322176708211606107e-13,
-1.047368659986582994750498731924225684738e-13,
-1.853184893589349743428227954519918673697e-14,
-3.108722185580624082944640173816560939434e-15,
-4.737442955437664739985466660375322838535e-16,
-0.003367928557310785011090541283682300809537,
1.7995356866734809357729884173766452869e-9,
2.07179099071492479327550943193547809332e-9,
1.590156765382653723535094476158225964845e-9,
9.153659911246664404402618660564842671273e-10,
4.215399365058624695830556714326283078845e-10,
1.617706390506261393626376653932112844143e-10,
5.321210307501910383323166741793933623448e-11,
1.531518566849721596358268135183786554371e-11,
3.918029868473564993431582757594807012891e-12,
9.020466134026208493705166481554426579711e-13,
1.887733911748647223014113137235644400704e-13,
3.619424658053742897221393209833425130185e-14,
6.404660934418241829248973990032452142937e-15,
1.074595663050849986362679194104312654969e-15,
1.638198743751967038807482129580926383707e-16,
0.001050770638007734709936840927431791570594,
-5.233313053586048404461231995100053793645e-10,
-6.025071526431667685014641516364161033823e-10,
-4.624409017536060388698507460267863313192e-10,
-2.662018893851521066551775955315662695511e-10,
-1.225900470140734255842116759766845357003e-10,
-4.704532111765452583844569401555830621396e-11,
-1.547489320044129700785278569286266222568e-11,
-4.453900434130587427626312103755839330148e-12,
-1.139430874952003098289566879997425983911e-12,
-2.623331829161785166940158099800690320812e-13,
-5.490008811918645696186917265643394834066e-14,
-1.052659008980488549962609156100720725237e-14,
-1.862843512778532197116215261542418651068e-15,
-3.126070566278516162421962702316930533975e-16,
-4.767127264035242398993051922868184349501e-17,
-0.000282149054743715731722396499446896572376,
1.31583350239417776642336347264902449645e-10,
1.514908650599085261578107475152719922802e-10,
1.162734356101562087357601302125350178183e-10,
6.69322544577429192670348446863050745201e-11,
3.082333595702340303862247161923485735738e-11,
1.182881071737351556405449364293495296971e-11,
3.890923921151887723435346468001615514731e-12,
1.119867008178357920078888694919561354365e-12,
2.864940877817900761856419729982066916074e-13,
6.596056705815016849705812451230842327833e-14,
1.380419661047289479359454500866746526469e-14,
2.646912491998562020542646404820474039463e-15,
4.684421983655810648610349570974653698627e-16,
7.862162593176798258785785527811767599694e-17,
1.199273100451599827917170126021419904747e-17,
0.00006653110979751053214592737853606116602719,
-2.917046086213494230340060262210170467913e-11,
-3.358372060545553379724120831445257518407e-11,
-2.577643732449295724435580817534717087523e-11,
-1.483808611359213766963946238714464878719e-11,
-6.833169101697620600548161856067208949508e-12,
-2.622308607413443017347203889174304471394e-12,
-8.625729535758845072390530219527537180655e-13,
-2.482620321736694357372143290936202796281e-13,
-6.351276745240397921875598103401142647101e-14,
-1.462287570225313695035033637370682344489e-14,
-3.060311362164177156385457812721831556171e-15,
-5.868216230223513937985405993286935119382e-16,
-1.038596390865783463637583595241773439806e-16,
-1.743365386574262297189045418497593122265e-17,
-2.659914554180466081866286466322285653002e-18,
-0.00001398989258502230300274352774797565701621,
5.787256485901902119914758822497537600769e-12,
6.662822726346133490764838883212891135957e-12,
5.113901544461971090920690230557554710993e-12,
2.943793893610702369515834186387168849352e-12,
1.355663068194076306818332990983804099398e-12,
5.202517672127937703762282875366533316016e-13,
1.711299149328352953118267550617658388768e-13,
4.925395085161116724160488299860224885871e-14,
1.260065557779662394741174250262402389813e-14,
2.901132529253192860706076910248034447106e-15,
6.071636279800485356921386252972885529313e-16,
1.164278456059765952108034859987846720121e-16,
2.060719884173934389536153709040685856951e-17,
3.459470080150674034369572286530647693116e-18,
5.279341727096755432637090668295079029572e-19,
2.65520396821144409078897341195247526858e-6,
-1.039615400083033617069194560103467653609e-12,
-1.196901032330883749901147323493185836485e-12,
-9.18654833059630795633816814772497739564e-13,
-5.28819472866791030812198482257078518616e-13,
-2.435296687075399223790243381979215296391e-13,
-9.345742817790431417040615288406967683735e-14,
-3.074160181224556434929740745079982238533e-14,
-8.84794114499747846153449641396159396317e-15,
-2.263578088208821230588625716584084720852e-15,
-5.211614526787300435713141322958535162583e-16,
-1.090724877018251572307798891237925263829e-16,
-2.091586187291288171996376346319872947251e-17,
-3.702174373508069808935253171329876774699e-18,
-6.21571372476510545567676596845429650755e-19,
-9.487284342114626736643026190908598384456e-20,
-4.593204939416220254060052434857838903328e-7,
1.707035472985399274317249873846781645482e-13,
1.965296549771407117524997616697989978011e-13,
1.508419822569573389347299268088960250194e-13,
8.683150707753097695590081954393281146038e-14,
3.998727820858120403353424936512790522925e-14,
1.534560180411033150970633421637921187089e-14,
5.047738610154861261097710467132019732385e-15,
1.452824384928564995954387038433446547642e-15,
3.716784992177350785134849984533559263082e-16,
8.557489374886347978545829258436048429579e-17,
1.790991609290671605197158761023193639995e-17,
3.434492168199838636491724552467861246329e-18,
6.079398675482512250675674948132790656883e-19,
1.020783529425426688678496021785998114779e-19,
1.558320176763639503636853866154325690007e-20,
7.29980821235737155065512263511266676268e-8,
-2.581746672809496935285834884565608841717e-14,
-2.972344743791384041057321552422473923556e-14,
-2.281357429526081951545288348763478812114e-14,
-1.313253209963797503370234316977180098039e-14,
-6.047738942622453916681235532830601532122e-15,
-2.320893626367739322351365290024991123131e-15,
-7.634285677276662287040146943493023568984e-16,
-2.197278710557480029168907587410927983484e-16,
-5.621347338478592517687276321744698091818e-17,
-1.29425920047221748816136694912026380064e-17,
-2.708770831296704123077607518056112874202e-18,
-5.194560680020165563102092964838581961228e-19,
-9.195221374675119181513459371655280911514e-20,
-1.544081351643198795523823978237789474488e-20,
-2.357534350759401270559239094766975635453e-21,
-1.073352719614166194084137571129073827054e-8,
3.620923363916634095095803734182429527602e-15,
4.168740802083625791216348834230877648981e-15,
3.1996248469886845153305067237948049137e-15,
1.841849859946773602598015604315591591275e-15,
8.482011255813731967758032306256403278555e-16,
3.255076143611453778789388337832578061221e-16,
1.070716608959473994193333710064757656754e-16,
3.081709603571960833276090074452487203967e-17,
7.88402237776941363278093472884533875128e-18,
1.815224799535440961229230217930547298519e-18,
3.799136302172821232589948641833344881662e-19,
7.285649774974466473005524790752663708867e-20,
1.289720096914651448573373287052223506309e-20,
2.165883379909886387655309926109009461787e-21,
3.307360350772684346343655094849232486552e-22,
1.491203589316849909484848723819025522757e-9,
-4.802463759778194593179046658806919746931e-16,
-5.529039116077057524324242275456269947447e-16,
-4.243691869390879505077148857351636526163e-16,
-2.442862554574324661262581066650719549228e-16,
-1.1249771510630354606817364654759932411e-16,
-4.317239182227253788083450286255678548697e-17,
-1.420102520598746599147437704494314695497e-17,
-4.087307126302522753211924933648024405561e-18,
-1.0456689514692069745856441532877066491e-18,
-2.407567041209381437222960696145192576203e-19,
-5.038903775981528007289227780177730719528e-20,
-9.663308905678318578299873238798682851728e-21,
-1.710668646187689702308974658338590350823e-21,
-2.872995337852566682370685308193227626703e-22,
-4.387689596225030725866101501737877320955e-23,
-1.904018420482176126507297564227780354905e-10,
5.873785858861232771506486496561835913379e-17,
6.762443989907958088271798204393109202179e-17,
5.190364674552801159680967031153650663132e-17,
2.987810743069200022433326782630504837827e-17,
1.375934620540061075139118008085965259097e-17,
5.280320642691769776549953931095834664293e-18,
1.736896986977871569937149314023167220798e-18,
4.999101930393643009031300874077438986851e-19,
1.278938450935948198043844959487375360725e-19,
2.944660601173060294405135986289273834811e-20,
6.163051127748479948934920711459125588786e-21,
1.181928543810327752072141434647815107226e-21,
2.092390021048470214566350068655652473659e-22,
3.514291027814139409981095185229313854386e-23,
5.36768448074506315297668684009216329906e-24,
// [{0,1.e-6},{2.,0.00001}]: m=11 maxabserror=1.084628419213628227329e-20 maxrelerror=1.385989464347024212929e-18
0.01737610269101636176867046212565339293155,
-1.308343597293687923669959635118562400423e-8,
-1.506285143566066801893379396678988339813e-8,
-1.156114901925319143883328305998655994592e-8,
-6.655113114701114062703222694350575415214e-9,
-3.06477513607454422220762651623570650719e-9,
-1.176137327796618821022258286362141292506e-9,
-3.868705238251754805536916274255736851284e-10,
-1.113451371042650243580196898995549692295e-10,
-2.848421596328849972452646393112939737671e-11,
-6.557534337746796571969233399128890016037e-12,
-1.372152852344695123578614911815896930845e-12,
-2.630281642085579840356089630698807570282e-13,
-4.65220929396138731961813601194650018333e-14,
-7.797410562373860451709740967633400401651e-15,
-1.186369783297535157258564758183538554661e-15,
-0.03177104198218481526549693893144095661537,
2.170708312787353052466215042582065194157e-8,
2.499118677452911265507541125895717022664e-8,
1.918141978338389291003281137994784432139e-8,
1.104168411869679541919016303782825944118e-8,
5.084857021413619018357668714284602512646e-9,
1.951365711276999331330042429192140204657e-9,
6.418703115977311218221815295260727922401e-10,
1.847374414901083391147945018873863450092e-10,
4.725981166306793829577616151463560732678e-11,
1.088018769501906480084635587332512734612e-11,
2.276745597316595637407502964007851268908e-12,
4.364619839729306096604181304290253075339e-13,
7.720905938596118709535763997495030140273e-14,
1.294518358366146406251236672693124775558e-14,
1.970856654984436570261389969530979531047e-15,
0.02925869350199059566274438667681240454655,
-1.82934478896879825727297403915740062309e-8,
-2.106109777708483904024952049696062474539e-8,
-1.616497085012412085386320351058670388974e-8,
-9.305283262991101514281601523378115059979e-9,
-4.285221075877005747298429876085363397983e-9,
-1.644498834957045496003860882215160680497e-9,
-5.409324284759969131789179719949483890385e-10,
-1.556869858190619201046274217798227173655e-10,
-3.982838409080034750506604985316671924303e-11,
-9.169459132680564030808535466238645061414e-12,
-1.918823828883313853178775357181543043394e-12,
-3.678691355634276346719611208328293195018e-13,
-6.508310786442938602725061936235289918087e-14,
-1.091515741687781009330262963565987059225e-14,
-1.662659960100431795378957591672020798274e-15,
-0.0180753477161913003604661819393667493106,
1.041568288455971777800985388901692652282e-8,
1.199149159139784333440002549880609693402e-8,
9.203799979457312142952102498427123511113e-9,
5.29812170532790074222877749562942297219e-9,
2.439864663716971354103608046298913945869e-9,
9.363245713258052757238769618505249269199e-10,
3.079899595030653476631555437492085520777e-10,
8.864356882859014982073088802065727078737e-11,
2.267724914148687108298407751546523020748e-11,
5.220918720873954373700295213595256933175e-12,
1.092570258268159490304360503286921610523e-12,
2.09473731997322049985620385204353225022e-13,
3.706369787178795989870294406906051170893e-14,
6.217444371161410257248368392917869882945e-15,
9.474885910875577081544952700711650469592e-16,
0.008419821393276651720100293649837509380827,
-4.498839216683613921330200905595540879917e-9,
-5.179477476787210188112793792534907654898e-9,
-3.975391913456556178269697638321836621917e-9,
-2.288414977811621125576532335475102867986e-9,
-1.05384984126463546200590834858176245594e-9,
-4.044265976265573999340330921175972511715e-10,
-1.33030257687545145028216219316159637608e-10,
-3.828796417124228739195411960486145370262e-11,
-9.795074671183719963857649806778951401387e-12,
-2.255116533506507796936989851663519035121e-12,
-4.719334779371525282979793525468086596072e-13,
-9.048561645134179319151660395017705634917e-14,
-1.601165233604528957658708482713826496267e-14,
-2.686489157627072054808918075245045804069e-15,
-4.095496859379836765437441817472620015238e-16,
-0.003152311913979266313210293249126243042131,
1.569993916062808691133265694179025179228e-9,
1.807521457914526794135143598250445733885e-9,
1.387322705249325528070822848750450484265e-9,
7.986056681488406612846141079712345170447e-10,
3.677701410391736598630152132799001759299e-10,
1.411359633517944000821696662486389512672e-10,
4.64246796009393042413782785913356898111e-11,
1.336170130228107120642785645203561523838e-11,
3.418292624827690751086535209751909631457e-12,
7.869995487420153964989796826330029247054e-13,
1.647002643561947218715518714947623043158e-13,
3.157977026915294572337933846554262016784e-14,
5.588530538289264332560781032211759988879e-15,
9.378211698757726472507557176580108812688e-16,
1.43013817919868506926001226179007168425e-16,
0.0009875216916112941396634484557577717254918,
-4.605417258403202653203052714435768656052e-10,
-5.302180277123946428736583499851077833654e-10,
-4.06957024637630416522696027665343164997e-10,
-2.342628906032996822529400409559390914498e-10,
-1.078816758501342834625110285942800146717e-10,
-4.140083751101928450961779072133206305402e-11,
-1.361823372410133532613920938997566680631e-11,
-3.91953452864432180646472550153110953085e-12,
-1.002729307241399628886858396505546826072e-12,
-2.308619847047077452681822684136899159071e-13,
-4.831468813690255483207297331807599129065e-14,
-9.264193722042418094550961104568155463979e-15,
-1.639547694287934457684733398265230402937e-15,
-2.751756907625990399300352495592176690749e-16,
-4.19745585160215659865583224472010699402e-17,
-0.0002661244401108340324997483748096204639804,
1.166818437210949133529454900629304606762e-10,
1.343348827356127571772753581593603572798e-10,
1.031057495388149029178782909284645182956e-10,
5.935234459300882023220543826006905064516e-11,
2.733267647063654931541834687262017411164e-11,
1.048923445415550081989651640312386911268e-11,
3.450291822363085495310921262855673807404e-12,
9.930481310143622103371387795396639046621e-13,
2.540510704030701345955236781945267632071e-13,
5.849150294565137632855416159785224473381e-14,
1.224124547725481458037083968470615215897e-14,
2.347286497573916566909474348590285938371e-15,
4.154385573172699086346741384004588962652e-16,
6.973461562605728337553842087626902007155e-17,
1.063965824163408024758767051019837664191e-17,
0.00006295451652838579916727659980952484180354,
-2.604265415691216270389900620112638573033e-11,
-2.998270223442593376529876758492023340136e-11,
-2.301255692388186086208283500877095140118e-11,
-1.324707250616796552378559895567679247247e-11,
-6.100483799928671141394952354123399919184e-12,
-2.341132949792466453702344502093342977295e-12,
-7.700846163211042859722641490235931108617e-13,
-2.216427785799329428834490480084691145153e-13,
-5.670295003553336507221548692736323851103e-14,
-1.305509636677679266819385712990100172556e-14,
-2.732236322799507789934905228545993491649e-15,
-5.239253046303197123095581893971557877103e-16,
-9.273239468220939481305000037150618425609e-17,
-1.55676153429370569453752074145508746222e-17,
-2.375703774483274494020464161307082105174e-18,
-0.00001327601001758745702131563772028025615707,
5.198074092697692136035393240738709634223e-12,
5.984501814021857167904007251649894153353e-12,
4.593271595896584705522055981332104021389e-12,
2.64409588526910046653249294618331858579e-12,
1.217647662404620544002340608601732834089e-12,
4.672868794961616653018681450849336985922e-13,
1.537079230790421064628304863120363323034e-13,
4.423968097774921911253313680708165420254e-14,
1.131788410985851453294273993179864309941e-14,
2.605805805680894409153389809217810507263e-15,
5.453621334141219552977402038394734478605e-16,
1.045792508538046298347407962015160623613e-16,
1.851086150902263365825383812573228392156e-17,
3.107855122513254145846222215472517902004e-18,
4.743639513331296004407315426464978955662e-19,
2.526263383700162817940014343641314790315e-6,
-9.388696998915856448800082894352405336708e-13,
-1.08091332083153647171422474302545308921e-12,
-8.296310700853246617938191015787715938887e-13,
-4.775733854461172990894660149892796584422e-13,
-2.199300745960683782972834471870887832113e-13,
-8.440082698042166094309070117571453118233e-14,
-2.776256796681565473048975517239266706107e-14,
-7.990535732045776438228637047578019606179e-15,
-2.044232158854377390035917942276946773574e-15,
-4.706620107455854976411749474289497508126e-16,
-9.850455842086502376480914909757757100988e-17,
-1.888971074343399109676870353351560431151e-17,
-3.343669947513522977454664846808424326824e-18,
-5.614310547338194354689159945650347338543e-19,
-8.570762706885830855701130892222776289128e-20,
-4.380442267167622844286820299092877624564e-7,
1.549212972775808639070558258333978876222e-13,
1.783596773907854527186533214186646454576e-13,
1.368960232483150100509951413586457818939e-13,
7.880358405901055350711898035112584265237e-14,
3.62902980581476852073260008118900474812e-14,
1.392684477108870370505116763989371226263e-14,
4.581059225525285875346344647456715311433e-15,
1.31850762956827527348442873018437183498e-15,
3.373167602333902948612612094905648458605e-16,
7.766382234858600320772808573020045854519e-17,
1.625435594155202853200727572897973253825e-17,
3.117068368284625690401411713853881809669e-18,
5.517720514384981731521396480319418226414e-19,
9.265475223168911641369914262161413048344e-20,
1.41467139631013845119580445642517804277e-20,
6.976582451927719725039878652896497254161e-8,
-2.353540383286116071695231805679777409157e-14,
-2.709612670324891797757167027537772235308e-14,
-2.079703305451755987226494117082964130301e-14,
-1.197171988917017876025387128406154256336e-14,
-5.513167227066821347911814110219060597838e-15,
-2.115745732346401299941597995791756001877e-15,
-6.959481117861701688671941089558439443656e-16,
-2.003060344407649635632536876803877889183e-16,
-5.124484331186641947771046916008192309419e-17,
-1.179866138636569436987442158648641067698e-17,
-2.469375846582541788735688088088938765137e-18,
-4.735552011527912830688659445819929627745e-19,
-8.382967576061823278481340800507439317168e-20,
-1.407788409515540292875430804913504109745e-20,
-2.149729556024336200711626951961129097408e-21,
-1.027834861420147997086473212861906672517e-8,
3.314343426028646234084511286823809818272e-15,
3.81577776675056351168863930518556316989e-15,
2.928715954585736027248034918900522800191e-15,
1.68590245205864409671743282333948239544e-15,
7.763849540388205227029902421028477447945e-16,
2.979473424912394626704920953035590141413e-16,
9.800609821717975072424975321194458477588e-17,
2.820789406723162211447213094762128259481e-17,
7.216516100790573709778501613918391271723e-18,
1.661543524721703897407182102753367144841e-18,
3.477517464988340030550954122058529350952e-19,
6.668973051432367903648250108912354025174e-20,
1.180588865329793377773528989697806392039e-20,
1.982745595174557285900042736311884104755e-21,
3.028075114095449113562951182191007331037e-22,
1.430601342067882287714379737602920732277e-9,
-4.41270015201581588652459668323684469694e-16,
-5.080307375927123980153999322681428706499e-16,
-3.899277832277808468312084955986867572014e-16,
-2.244602244687194136891445765954550571093e-16,
-1.03367522387480004537791513113236595471e-16,
-3.966857541248503651101630994522491143743e-17,
-1.304849342625645106308068808010876946921e-17,
-3.755591110021072824609258531201040863292e-18,
-9.608065541840561624875781146952962338357e-19,
-2.212185606489518422910843354969846315154e-19,
-4.630011776043473621518834150034919820002e-20,
-8.879276144714421141530420221532312663676e-21,
-1.571914844507164562775416091643640712457e-21,
-2.640123090601545993056053377287204316979e-22,
-4.032492545560253558279986316786674921544e-23,
-1.829643622544462052521763878881919818535e-10,
5.415536503417162738302835500516168398033e-17,
6.234865143315246522141372991966936762351e-17,
4.785433284261621609502086377747300942135e-17,
2.754713887488158264418286196712797390623e-17,
1.268589910914680487795434829907134697563e-17,
4.86837285378432371815544313463864603867e-18,
1.601392396096143996707643795695845861038e-18,
4.609098817819563187353337234975941581813e-19,
1.179164311131601417298295087805744246782e-19,
2.714946254313801723475713526385622337413e-20,
5.682302892981421477636890473399493723781e-21,
1.089745350938011331171618566097546621391e-21,
1.929242883480245355377372215203713208346e-22,
3.240454540951436041494221105473624437295e-23,
4.949935545225213955864135321092879139574e-24,
// [{0,1.e-6},{2.,0.00001}]: m=12 maxabserror=1.045398723121944809172e-20 maxrelerror=1.471478052037119967163e-18
0.01588552099109240762346482761471001291789,
-1.085354156393676525978909724977847819218e-8,
-1.24955933872645563246111460694507486338e-8,
-9.590709891691946452770189326496573658048e-9,
-5.520842059348397708302056716863423158354e-9,
-2.542428510706809508583375606021462711228e-9,
-9.756828556384996654365063763154379523459e-10,
-3.209351557988655608359235212596364522981e-10,
-9.236872074505416953576272121834084193711e-11,
-2.362990583153396914235321717322534741901e-11,
-5.440093847509532399148806164002190260185e-12,
-1.138372798658297818437026368151380196123e-12,
-2.182309919864653047790557571272591796189e-13,
-3.860452969298059353862245165108038400861e-14,
-6.472591791830732029734881605784218704484e-15,
-9.854283274922182848982676219654975852735e-16,
-0.02925869350199059042195428328799757992905,
1.829344788968798108181673911106142335309e-8,
2.106109777708483732377293541488138804884e-8,
1.616497085012411953641941435274878730597e-8,
9.305283262991100755900773048724789414968e-9,
4.285221075877005398051869240092257131033e-9,
1.644498834957045361976090820353242548569e-9,
5.409324284759968690920880490447828723049e-10,
1.556869858190619074156264870793802888026e-10,
3.982838409080034425878335569692396445391e-11,
9.169459132680563283371784518252606878771e-12,
1.918823828883313696741590061018415693621e-12,
3.678691355634276046702929321172513096026e-13,
6.508310786442938071575431599162499912139e-14,
1.091515741687780920111156010936897301496e-14,
1.662659960100431659080117028960768087759e-15,
0.02711302157428695470047834380609880140579,
-1.562352432683957780600113246300853305107e-8,
-1.798723738709676631290621180962845989955e-8,
-1.380569996918596922089233948630181484193e-8,
-7.947182557991851692709951968329048687001e-9,
-3.65979699557545729796315011844719074181e-9,
-1.404486856988708015976664515479240106808e-9,
-4.619849392545980551749877068476540033716e-10,
-1.329653532428852344248995228141940528787e-10,
-3.4015873712230309104487421001718884841e-11,
-7.831378081310932131559349704128571986716e-12,
-1.638855387402239354968302696289446252553e-12,
-3.142105979959830978987394599423093103739e-13,
-5.559554680768194390594956654646303269005e-14,
-9.326166556742116067523615898564191696245e-15,
-1.421232886631336666375685460892141941403e-15,
-0.0168396427865541841713864102617038551918,
8.997678433367478389534994824215235466755e-9,
1.035895495357470882890078557349674820808e-8,
7.950783826913333752035676784545171113131e-9,
4.57682995562336969651451090034044823478e-9,
2.107699682529329614649138893518690016817e-9,
8.088531952531373231399638025916192759019e-10,
2.660605153750976988169988448437147442551e-10,
7.657592834248670716153553282211191442064e-11,
1.959014934236798546322510883139924223237e-11,
4.510233067013141200091300495190336867029e-12,
9.438669558743313457543726348445367887825e-13,
1.809712329026886281421949911014148713219e-13,
3.202330467209147174638900775990293779193e-14,
5.37297831525429404170298192531663589271e-15,
8.190993718759902580134230432113232231964e-16,
0.007880779784947866239299709078092355733906,
-3.924984790156939710720506992931314078798e-9,
-4.518803644786222559670675631201061232687e-9,
-3.468306763123241345834946126233066023388e-9,
-1.996514170372059933667778306114684227927e-9,
-9.194253525979149371355628566495041192331e-10,
-3.528399083794786271567550375995664920775e-10,
-1.160616990023458353266061990102490268468e-10,
-3.340425325570197997631924439812749407387e-11,
-8.545731562069048294920860494312486206426e-12,
-1.967498871854997373545002998093912140847e-12,
-4.117506608904781987727149970719171423775e-13,
-7.894942567288071384304862351146443861457e-14,
-1.397132634572286862698158613623110927315e-14,
-2.344552924689382533207613571910344177054e-15,
-3.575345447996637680277788065583803322026e-16,
-0.002962565074791596626804905659256142365069,
1.381625177508931723249588123005456682886e-9,
1.590654083123334950423240259739196035078e-9,
1.220871073902261771443115245897300355249e-9,
7.027886718037802335742742267207698014103e-10,
3.236450275475850385708125572545150134569e-10,
1.242025125319764827241629902108268417905e-10,
4.085470117194830200196935603321318803374e-11,
1.175860358583058726926529816073966372448e-11,
3.008187921698007036004653412833608690278e-12,
6.925859541080927222446332995306552247594e-13,
1.449440644094454887055493791335923100754e-13,
2.779258116588519303979962962918044896564e-14,
4.918643082820948841749068166963794137904e-15,
8.255270722805986902420031871471666864966e-16,
1.259236755469650033750908851984120709502e-16,
0.0009314355403959077921327671407022752622763,
-4.083864530260195351513739450770645279439e-10,
-4.701720895771629159140455397757498215366e-10,
-3.6087012338778499968403562737617044948e-10,
-2.077332060766435015528766668633384397759e-10,
-9.566436764774030698358166792560346961741e-11,
-3.671232058974088686559146222413187708797e-11,
-1.207602137833547965245861526024310853251e-11,
-3.47566845856888396287774376942726940308e-12,
-8.891787464155081480003469765415706886806e-13,
-2.047202603108763972087539012421433093875e-13,
-4.284435917062136446554278303453997642008e-14,
-8.215502741552724729824854596655467637501e-15,
-1.45403495061823756560685882542786977873e-15,
-2.44071154692509551933087793460079334357e-16,
-3.723880384591928156163780522346678391621e-17,
-0.0002518180669997146087782589074636069862942,
1.041706168797347637801811755271076424236e-10,
1.199308092279285234709903157660834336243e-10,
9.205022791828308618983884846055126089782e-11,
5.298829015290018598214568404402560837118e-11,
2.440193525876588867985254483689441888354e-11,
9.364531821831509766985154251217987652673e-12,
3.080338472738693542541156683468628867611e-12,
8.86571116465209694056906116987639512249e-13,
2.268118006910204765915166480526843188986e-13,
5.222038559348505214756411243402824159729e-14,
1.092894531764869762289806922061309342553e-14,
2.095701223594012216601865782916762561546e-15,
3.70929579626914483568669110157891878408e-16,
6.227046152260143371419708372328009549059e-17,
9.502815120978743950377170785003772681089e-18,
0.0000597420449787057568938692149061354581042,
-2.339133338963942993104099036020253404239e-11,
-2.693025813143760741863383622397577162774e-11,
-2.066972215723411963351811759909059304238e-11,
-1.189843146972246700179536518201662796473e-11,
-5.479414474378869714877195831483563752469e-12,
-2.102790955260558046352071780005213615224e-12,
-6.916856530424986846062998047980532329187e-13,
-1.990785641658200614133124994665871286673e-13,
-5.093047843448483758573528662135435647573e-14,
-1.172612611177733598881751462161800313122e-14,
-2.45412959747800452666122668320974589055e-15,
-4.706066282887228648987563265821724991361e-16,
-8.329887669262625382183914832104720150569e-17,
-1.398534803485156144496710225183194748327e-17,
-2.134637778484586063263187704016532339724e-18,
-0.00001263130746437538950482329685840277755175,
4.694345810109110046007291159359231860714e-12,
5.404563507931228075437516446470248462068e-12,
4.148152973986217648366889488264483445713e-12,
2.387865559242928411433547491731023862259e-12,
1.099649743000038191219251060815961595411e-12,
4.220038931392254951810101192069423987622e-13,
1.388127603090731426208439665377147934955e-13,
3.995265577146896693403026376179101012389e-14,
1.022115493854015939191254898278384892193e-14,
2.353308705481478190165809547471780573579e-15,
4.925225099187339340633258375114612471649e-16,
9.444849959935516790955982321783914655377e-17,
1.6718340156547608770358179917413387249e-17,
2.807153664310702727884735859911749623926e-18,
4.285378894847185674384068521170626330477e-19,
2.409243889790517173762111299637795603068e-6,
-8.520673110396970184768112780705499085975e-13,
-9.809784282917275755182010919622574609295e-13,
-7.52928283399451423916382060111959249326e-13,
-4.334198018568752911208165963831037399848e-13,
-1.995966805508866704641080973396218637985e-13,
-7.659766206393493891854097246258635421307e-14,
-2.51958309451596882995903778885885004609e-14,
-7.251793460655233129363978039416855457967e-15,
-1.855242564531642094459241751532680953436e-15,
-4.271511111579576107894122762428743430357e-16,
-8.939897614725980481696946503161301963256e-17,
-1.714387956755031892393641086122551404697e-17,
-3.034746909997680419212228372673989537217e-18,
-5.096012426130915162658323235798052192943e-19,
-7.780694289092043548850823406400996222353e-20,
-4.186485856175973671730242671367520401982e-7,
1.412276810051581718179708083921996232845e-13,
1.625943266458577018947887970951543654173e-13,
1.24795681050675982140569281101035955176e-13,
7.183808060662638144132889194560466199444e-14,
3.308257755271925488427584771719052442191e-14,
1.269584603466785022812127292095585069905e-14,
4.176139855463226862501864707158674176722e-15,
1.201966065917381205813098085048836753322e-15,
3.075022823378970535810430960152603899537e-16,
7.079961758815341764132182328152199588715e-17,
1.481785605813649326906536348144923469685e-17,
2.841638244088457012261669641437829494294e-18,
5.03032412436656899608199825968054058578e-19,
8.44764352584940317237000096844064554329e-20,
1.289977221935116692649772415574570800248e-20,
6.68072399223098123713814472842300121324e-8,
-2.15426775300185465413234592765253342018e-14,
-2.480191681696731151261578222100387209221e-14,
-1.903616351007941571618667328494086098062e-14,
-1.095808375989148248293116312297743334738e-14,
-5.046372253512104527930407986382971722579e-15,
-1.936607857101717470998018433715911745259e-15,
-6.370232345660300567951803136633732973665e-16,
-1.833465901053487231756651555041079522793e-16,
-4.690614677463370865069741351767546867122e-17,
-1.079975480287485601298145601162730841566e-17,
-2.260328144472184118254356676241125022329e-18,
-4.334720850896987517265450963907825366431e-19,
-7.673629986327385452275173003477525150389e-20,
-1.288751437293679054974055229901962030945e-20,
-1.968198101226190995587221794424247418772e-21,
-9.860151351549243155385670796736806195633e-9,
3.045067152207891250451084599913639755887e-15,
3.505762135563935774093294442968041738262e-15,
2.690770372742513309394381070041101496424e-15,
1.548930204654462330444886528263443011152e-15,
7.133071240996507998690093895449158867189e-16,
2.73740500344012911798884444125217938796e-16,
9.004359357499726621432289913109053809005e-17,
2.591616529764084277014363636933793237144e-17,
6.630226697550329244608188238556461930932e-18,
1.52656024097145527011272623202060498258e-18,
3.195026084959287512140938456837045209357e-19,
6.12730829062644371726670266670487381079e-20,
1.084728113328050616698173028558151918396e-20,
1.821861658170822355038991315820629023854e-21,
2.782681947196536505296753227328638099318e-22,
1.374726472100704049579726829429996038899e-9,
-4.068480269141035318419235441828291589729e-16,
-4.684009756228654195428866121166194331048e-16,
-3.595108422971981486206403674984371500418e-16,
-2.069508550822254403734721321964745104925e-16,
-9.530418678984967550887847624767440489655e-17,
-3.65741767364520406033003484177750019735e-17,
-1.203063330268613315265181146382379422601e-17,
-3.462635266162337697801716091726389237468e-18,
-8.858599279270482064797302798637061163252e-19,
-2.039632722905690123027167504804139329659e-19,
-4.268891551984709383391372158808550980996e-20,
-8.186830190154127493339364209341536651034e-21,
-1.449364752696942764554053266253260433479e-21,
-2.434427205687720313480511025931292360673e-22,
-3.718694785994580255598673553387264347466e-23,
-1.760854212304082927023754250812166246233e-10,
5.008841335169634454081471887867191246881e-17,
5.766640215109188020916935190713476286938e-17,
4.426057659096821287389689189509422069408e-17,
2.547840979876475109685657436042831639772e-17,
1.173321721789083830065476125337609699852e-17,
4.502770011813142252867538752405538528683e-18,
1.481132273943159699399116690297624042688e-18,
4.262971247826962340226918748055731663899e-19,
1.090614611870083655866082748434821905791e-19,
2.511073507059053884522860799110685311876e-20,
5.25563234317965494363311656172125073242e-21,
1.007930059429767079515145945934674642965e-21,
1.784439788569928089541696861770723559115e-22,
2.997387796061282648739847755997054769437e-23,
4.579070325920429464518224761615302080099e-24,
// [{0,1.e-6},{2.,0.00001}]: m=13 maxabserror=1.008905381586705257691e-20 maxrelerror=1.551275141229510874434e-18
0.01462934675099529520201821107301351510401,
-9.146723944843990538544012489955362873366e-9,
-1.053054888854241865916440168725180671598e-8,
-8.082485425062059766120445288965062383119e-9,
-4.652641631495550376747711847886846676176e-9,
-2.142610537938502698472083516295504115688e-9,
-8.222494174785226807754980021875853837085e-10,
-2.704662142379984344761290570031433075638e-10,
-7.784349290953095368769040456105721863521e-11,
-1.991419204540017212424355113551456419318e-11,
-4.584729566340281640500561710257918112411e-12,
-9.594119144416568481227050079862183325596e-13,
-1.83934567781713802287566602601096820798e-13,
-3.254155393221469034945328605880355658146e-14,
-5.457578708438904599140664734580344844801e-15,
-8.313299800502158293238371965735475203113e-16,
-0.02711302157428694964962083236114644131335,
1.562352432683957642302341234600843962869e-8,
1.798723738709676472069466362817748522695e-8,
1.380569996918596799882541745796390960116e-8,
7.947182557991850989232377121665479326397e-9,
3.659796995575456974000394337219694050023e-9,
1.404486856988707891651853419651639692222e-9,
4.619849392545980142798168723688574286128e-10,
1.329653532428852226545092848754988915247e-10,
3.401587371223030609321307666536169220485e-11,
7.83137808131093143823006206268659471475e-12,
1.638855387402239209854971309339110006658e-12,
3.142105979959830700684881028612914968167e-13,
5.559554680768193897878028757992471683247e-14,
9.326166556742115239850638157417415441949e-15,
1.421232886631336539922238898743073634913e-15,
0.02525946417983128027136489859318414139968,
-1.349651765005121864370290761660861188457e-8,
-1.553843243036206446303069059437004455985e-8,
-1.192617574037000156419169142918196173985e-8,
-6.865244933435055083655706682485343037231e-9,
-3.161549523793994670138462276288825460822e-9,
-1.213279792879706079946327555179907177187e-9,
-3.990907730626465795523848538446517873673e-10,
-1.148638925137300697587688281075592504656e-10,
-2.938522401355198050156521349356121121421e-11,
-6.765349600519712331249486917857014426099e-12,
-1.415800433811497129793564660377927819579e-12,
-2.714568493540329635324612851176584965108e-13,
-4.803495700813721139407834364073269222527e-14,
-8.059467472881441696626971626027426640478e-15,
-1.228649057813985483902694241688707064758e-15,
-0.01576155956989658129169846614105236589336,
7.84996958031411183022576642762868810578e-9,
9.037607289572712689776941715052358108207e-9,
6.936613526246688059467296252880926958566e-9,
3.993028340744238086426073039536470642038e-9,
1.838850705195884316066743161312385390598e-9,
7.056798167589781470421822437788300298625e-10,
2.321233980046985430683068530165132463682e-10,
6.680850651140593796143305788950345491436e-11,
1.709146312413860263314356159278127825542e-11,
3.934997743710111260765723499532254818938e-12,
8.235013217809807837757282538824580894131e-13,
1.578988513457661045473889328527165043714e-13,
2.794265269144656526256540161183047250363e-14,
4.689105849378904156493818074056446683878e-15,
7.150690895993487865024053347991259655917e-16,
0.007406412686978702500134831343887087067973,
-3.454062943772253021858246059026783066436e-9,
-3.976635207808249548269836563345315062409e-9,
-3.052177684755587018321146869525301476341e-9,
-1.756971679509411779492275445292417512405e-9,
-8.0911256886894472635440551050012477725e-10,
-3.105062813299343489426669042832810134609e-10,
-1.021367529298684991900680530833706037383e-10,
-2.939650896457581890733757460371737710324e-11,
-7.520469804244851485082478732003562556252e-12,
-1.73146488527019356077845097740226240653e-12,
-3.623601610236057171093532867709583722875e-13,
-6.948145291471144742945463115487951582364e-14,
-1.229660770705210030712400577961847407455e-14,
-2.063817680701451066736753681908623142305e-15,
-3.148091888674055320302727905383432791337e-16,
-0.002794306621146970013863169348654536822619,
1.225159359066900351663489940788372614246e-9,
1.410516268718642336491456211978932463717e-9,
1.082610370153495018904081542056432285371e-9,
6.231996182242546494351544843322603900762e-10,
2.869931029406070981858158633736168887027e-10,
1.101369617682195730018647108833994901323e-10,
3.622806413467648519990294222318558003363e-11,
1.042700537561168506470193734219403089804e-11,
2.667536239222228634343732587726147556652e-12,
6.141607809270352156158034058255150787938e-13,
1.285330775106932781534628109591970112467e-13,
2.464650822443363187822504772230099874174e-14,
4.362104851814958905702824289290864727141e-15,
7.322134640708507565302752020828213653613e-16,
1.117164115367375824917118542057869520262e-16,
0.0008813632345067103988273241053720877841169,
-3.645971590811061749892570398649260222536e-10,
-4.197578323000921383025703279788842687929e-10,
-3.221757977157885872215020889258517466378e-10,
-1.854590155361855385101504531229023337193e-10,
-8.540677340615719281329169378583694026651e-11,
-3.277586137659317875723702327778644650063e-11,
-1.078118465464558841539174155270312745336e-11,
-3.102998907645549398135483650230023202376e-12,
-7.938413024230015712437566926393827968033e-13,
-1.827713495782176456722562384941784564381e-13,
-3.825130861198392026073821436713072074876e-14,
-7.334954282619984677808248133761025741519e-15,
-1.298253528701449336513533665316283038208e-15,
-2.179466153303227083429085564138930823473e-16,
-3.325985292361165977630099249651099653146e-17,
-0.0002389681807688801917793907842672978755302,
9.356533379239483475909194117919519888593e-11,
1.077210327949652908693665414863627391527e-10,
8.267888883556641861263518152524918208133e-11,
4.759372599783550553692153356991273671095e-11,
2.191765795229186108414394002971815509947e-11,
8.411163842063362708797587381886937481221e-12,
2.76674261908464609936392909462059918049e-12,
7.963142586534454236898123062697937292531e-13,
2.03721914247092677492426719167291532811e-13,
4.690450456433908605476322794601778235181e-14,
9.81651841444812069044145055867574615922e-15,
1.882426517860495725176702388973159364553e-15,
3.33195507603602391593018588833723175726e-16,
5.594139227935114897703779755473989753939e-17,
8.538551135319394245608088131489863702979e-18,
0.00005684088349276432390733977980900141394588,
-2.112455611991233041629199630479772439676e-11,
-2.43205357562420072122333539681847532996e-11,
-1.86666883603354164387231220740246542194e-11,
-1.074539500358210907024647697754874851605e-11,
-4.948423837508364643755208524789562470734e-12,
-1.899017516827082471851024657658395794483e-12,
-6.246574206344579722568903403922856292232e-13,
-1.797869507539125419903727641022948659974e-13,
-4.599519716773599599462204958049644445756e-14,
-1.058988916184321950041504981563926217617e-14,
-2.216351291950354637189858348714756048159e-15,
-4.250182476823581535702490565736180059215e-16,
-7.523253061333104880455881752898629402755e-17,
-1.263219147408881523672033603925425906683e-17,
-1.928420500342054996456097250250626705062e-18,
-0.00001204621033743424161406581229996382227115,
4.260334060534699369119771984725889929084e-12,
4.904889269371524149445022688461213260729e-12,
3.764639212590020537020244278851684423489e-12,
2.167097740326818640922415712351094571465e-12,
9.979828183790358274754840518987942100171e-13,
3.829880860582136836634091857480618853996e-13,
1.259790809576528604617668219962891363797e-13,
3.625894607143280186662229990822688029076e-14,
9.27620739081576169080986428555298487468e-15,
2.135754305138057213887019311556689600598e-15,
4.469946189757708516985861003862925189454e-16,
8.571934763656510609208004799604024725359e-17,
1.517372566218682858113252136633683805172e-17,
2.548004720079663982735672923584807958503e-18,
3.890344863533712358774453443542874866703e-19,
2.302567841261219463754100026884407526966e-6,
-7.767524092428727227687882880442903271643e-13,
-8.942689850354593867050414223975186179389e-13,
-6.86376390444883625571433694130632474906e-13,
-3.951095266129051307421283269301877759175e-13,
-1.819542148901101131555574075235412090646e-13,
-6.982716790803280510374475136378810758061e-14,
-2.296877404614993028240611132299350746635e-14,
-6.610814755905605361954211786062191582009e-15,
-1.691262909328706073854988270550375964337e-15,
-3.893979788103497051643753917020615129446e-16,
-8.14982254981776253529971886785126640122e-17,
-1.562901363704550417995045723769179334991e-17,
-2.766678851693398733672445596036567907412e-18,
-4.646204919081517021250589466331395872519e-19,
-7.094876217818482876628862853689080342524e-20,
-4.008951342547382289433234583087591492668e-7,
1.292702186535309886345341159129490630886e-13,
1.488277956862377378507283102904554721497e-13,
1.142294877635472519078212638335037009996e-13,
6.575570198925538499039236891583829621801e-14,
3.028154897452316197275686647116374748308e-14,
1.162091948986843500343473350131565046683e-14,
3.822557930923814354912121598946887355722e-15,
1.100199999482103659028363608384204247135e-15,
2.814676982025390164833077966700816238973e-16,
6.480562438906645600742412578102762043063e-17,
1.356345396502878128860745024341785466671e-17,
2.601117326939576278763406321764715898872e-18,
4.604682241167809080114943538033251285649e-19,
7.733355669176181272910152608412970114813e-20,
1.181048273960211762122393840375099823546e-20,
6.408902857743894154759778397645802176466e-8,
-1.979242051115049973186836993004841248693e-14,
-2.278685983944997146062306056271432697817e-14,
-1.748955147917663199752707538262880364827e-14,
-1.006778386824063797606672217307940764814e-14,
-4.636375438653541361131969462734330707745e-15,
-1.779266867605442784024659237987632679639e-15,
-5.852681005593182953615170921497498546215e-16,
-1.684506829887138380911459066674065297526e-16,
-4.309535004845643798126946651227280668834e-17,
-9.922382889342232719085482275028881343054e-18,
-2.076712814059077535968632217110886827229e-18,
-3.982646554451791092109053563392527407543e-19,
-7.050548900843671386249900903876722441688e-20,
-1.184179195473947442344576589564155163544e-20,
-1.80869607927468930496420413541912871406e-21,
-9.474610053454960228635264043131710114674e-9,
2.807285574278764165354011781018430728127e-15,
3.232006091862780382573014371688074111006e-15,
2.480655020308826935746274780126407546785e-15,
1.427978287717387350893071801245944835378e-15,
6.576068945594997551237768114245760307647e-16,
2.523648905586502131461845708212553392948e-16,
8.301237918337053601421568946965996225657e-17,
2.389247339886884754170299478702795736968e-17,
6.112507475207200179271197604956719808637e-18,
1.407363502077166787680382524359664741904e-18,
2.945570137057787204317622290255919065496e-19,
5.648978162675411452013544749466698321665e-20,
1.000072629826802753023448631572879811105e-20,
1.679770798980002608944919685383166946129e-21,
2.565917189768516410542092878318797063826e-22,
1.323047194928154708484823725668308632451e-9,
-3.762981813174606025227260761101305480273e-16,
-4.332291801881512648576906946233550808849e-16,
-3.325155133167994671824522109623284237274e-16,
-1.914111194737447603589900526195862799655e-16,
-8.814789702442338519986556895625182918334e-17,
-3.382786665933688880427362140743924298634e-17,
-1.112727165463046233748132868827549682322e-17,
-3.202633557000768543102977542135565442519e-18,
-8.193437781233444284768206649891550495672e-19,
-1.886489002723552767590012176661967552676e-19,
-3.948388111511299190643222791730472384638e-20,
-7.57225569660180512657929676174412512116e-21,
-1.34059254651353913966799630257323960963e-21,
-2.251841936157741141509940229417723594349e-22,
-3.440110586108712551044390881424337600353e-23,
-1.697044428199057090951872541273795601867e-10,
4.646254170469571006821404571517718287926e-17,
5.349196475518819463704132335455856711441e-17,
4.105657994954615650712631258645477168472e-17,
2.363404391063384281783660115166898053999e-17,
1.088385795177939010999357102628097544897e-17,
4.176818353896483975032541847061123613596e-18,
1.373914818305925395891847080286026727411e-18,
3.954382206498149746292745978054484775715e-19,
1.011668218215820617144508800124541201492e-19,
2.329310214937105677507963065406479833029e-20,
4.875229922688344022291941695330071501952e-21,
9.34985613750555469394919706719078560629e-22,
1.655332731641632846202422090866439225868e-22,
2.78065200311730939807594872887663713939e-23,
4.248333655116059730865647449309831404365e-24,
// [{0,1.e-6},{2.,0.00001}]: m=14 maxabserror=9.74871918749290351237e-21 maxrelerror=1.625898074899141090694e-18
0.01355651078714347481615427128810454335857,
-7.811762163419788209306998476061243917756e-9,
-8.993618693548382357809068856630196560297e-9,
-6.902849984592983997464520805231831375331e-9,
-3.973591278995925493494722470157293361919e-9,
-1.829898497787728486483743894174953668009e-9,
-7.022434284943539456277311674773324240692e-10,
-2.309924696272990070747143280136409065233e-10,
-6.648267662144261130849054502686624622697e-11,
-1.700793685611515304180602001334797585855e-11,
-3.915689040655465718009733157462203386263e-12,
-8.194276937011196046961454779081918077873e-13,
-1.571052989979915349898761650975050875607e-13,
-2.779777340384096948153480492573472558261e-14,
-4.663083278371057618605657919994775418322e-15,
-7.10616443315668269759467980244833296377e-16,
-0.02525946417983127539716851372956597086264,
1.349651765005121735736021323076866619283e-8,
1.553843243036206298207428612683639757564e-8,
1.192617574037000042751618472541271252765e-8,
6.865244933435054429333309126532559637421e-9,
3.161549523793994368812435222932781749571e-9,
1.213279792879705964308630748480962979086e-9,
3.990907730626465415147258996657538673185e-10,
1.148638925137300588108171447744253115325e-10,
2.938522401355197770069588361622222369205e-11,
6.765349600519711686363265840440613623801e-12,
1.415800433811496994818694229365302756227e-12,
2.714568493540329376463500618250202818056e-13,
4.803495700813720681102007473929044280188e-14,
8.059467472881440926724951573315745722704e-15,
1.228649057813985366266181140663077279977e-15,
0.02364233935484487581616332788565094273056,
-1.177495437047116873320549011321324628998e-8,
-1.355641093435907017198888250652872283895e-8,
-1.040492028937003296212856719438009185292e-8,
-5.989542511116357632136182185758933922202e-9,
-2.758276057793826705508144565397318644666e-9,
-1.058519725138467309369061317422979829118e-9,
-3.481850970070478438140867256665265584707e-10,
-1.002127597671089153498081871498746701814e-10,
-2.563719468620790610069112675124636974858e-11,
-5.902496615565167386401140197022211492109e-12,
-1.235251982671471279320548984903034590291e-12,
-2.368482770186491767010720122728302125862e-13,
-4.191397903716985141360216024141336155387e-14,
-7.033658774068356826043387900905735714506e-15,
-1.072603634399023270107902361493118167031e-15,
-0.01481282537395822412550294055829627378071,
6.908125887544722213340134317885910087451e-9,
7.953270415616747970957029435985431253242e-9,
6.104355369511365054726015502168233244212e-9,
3.513943359018933517728082073896386902055e-9,
1.618225137737940090485315524556045198587e-9,
6.210125626598881307763592340095625031135e-10,
2.042735058597433906008551887123707987078e-10,
5.879301792915347761569150423755979984082e-11,
1.504093960849017365567692068959485224591e-11,
3.46292977054049549455319596444705101173e-12,
7.24720322047234116717869416655775945312e-13,
1.389629058294272450145878720932315578649e-13,
2.459321541410497079625726779583634146808e-14,
4.127635361403031515354240119070475167798e-15,
6.296183777348308328539218664200489376801e-16,
0.006985766552867145737209505323943227622726,
-3.062898397667179743907384385582095911923e-9,
-3.526290671796523943762732390998351134397e-9,
-2.706525925383674688660939923249445822847e-9,
-1.557999045560600439302621063574114325788e-9,
-7.174827573515010820158947955774445604568e-10,
-2.753424044205425376933491572614498131993e-10,
-9.057016033668910950128526566711171523656e-11,
-2.606751343902860723510890186177063770415e-11,
-6.668840598055416696357169971894024650765e-12,
-1.535401952317552376424301337762038997977e-12,
-3.213326937767257311553080552967164541956e-13,
-6.161627056108264815850295376729686298106e-14,
-1.09052621295371438104703155508989742166e-14,
-1.830533660177084312242783290504481482959e-15,
-2.792910288418374499114338916346830383465e-16,
-0.002644089703480803189374148196154848230792,
1.093791477232939922859306369538226441805e-9,
1.259273496888327610495660302020351534553e-9,
9.665273931381947197156416072275531069537e-10,
5.563770466032773444272314547175078275054e-10,
2.562203202160403888713611035114044036734e-10,
9.832758412884653634139531912432704635865e-11,
3.234355396362986590328218996753354927318e-11,
9.308996722848316807251848573539854358254e-12,
2.381523907246406452377703586956030831836e-12,
5.4831404872944979981765477555457537241e-13,
1.147539258348627426740520547924490673236e-13,
2.200486284765109705112353069478517120153e-14,
3.894760586067370507250910847507291595391e-15,
6.538398459847563220765106578484458667359e-16,
9.977955876988585219816369968357387959486e-17,
0.000836388632698529395322520431810584581298,
-3.274786682752790502935899308655975776243e-10,
-3.770236147845626676019048695939894570526e-10,
-2.893761109261588611150552200187376859282e-10,
-1.66578040993389279588434869419257757804e-10,
-7.671180283346591660487563219290787966819e-11,
-2.943907344739231473704447996631640140272e-11,
-9.683599166852360217377584886850829147697e-12,
-2.787099905303205298644699776158743498939e-12,
-7.130266998689551686082342933998271468975e-13,
-1.641657659761378988169641658871359995089e-13,
-3.435781445076748829608523112914179048728e-14,
-6.588492812549913155265590894458935794519e-15,
-1.166184276619367810246880072403718370396e-15,
-1.957948729788645765356691137241258110865e-16,
-2.988492897379139892369275606359353320564e-17,
-0.0002273635347952440767367745300405991439627,
8.449822469714792941347233138606908239636e-11,
9.728214327537249533932356015510566702093e-11,
7.466675363353410503066826276366015706467e-11,
4.298158012496319257109022035062398258917e-11,
1.979369540098254987105928088339278666926e-11,
7.596070086860691927337111609428355630982e-12,
2.498629688969351193265032501937271306728e-12,
7.191478048667620550583234459777542530871e-13,
1.839807891445232131064579938767306679039e-13,
4.235955675641213846841610788284199362989e-14,
8.865405190623367077086912634904753339912e-15,
1.700072995106332575507806810704911548782e-15,
3.00930123228241210761250326543105686226e-16,
5.052876602653257361214949093757300567784e-17,
7.71368202125855193016057663563709184101e-18,
0.00005420794642480483525566406298055962240219,
-1.91715032485545898016599005865074771101e-11,
-2.207200168471174475019478568824217068303e-11,
-1.694087643557868574571832309845528545663e-11,
-9.75193981933814004318106013840881088154e-12,
-4.490922677118428541036963398059921218819e-12,
-1.723446385117789650972534369571700535624e-12,
-5.669058636041375670141849488553872030908e-13,
-1.631652571184488404814610692881371958142e-13,
-4.174293320673667872110292807747723791393e-14,
-9.610894361163628897453635753981831477803e-15,
-2.011475782888222757225384980866525481696e-15,
-3.857370638845504583588064054422811125062e-16,
-6.828176539485800222621994753457511322535e-17,
-1.146602122608177639232824469314231961698e-17,
-1.750655186408610534534857357877348855265e-18,
-0.00001151283041345667581427472705019236412886,
3.883759725854199269121860900932410532526e-12,
4.471342253764569123194666285131705890044e-12,
3.431879901840350826607919458539100421848e-12,
1.975546452769700091324155624848444259478e-12,
9.097705309057293757649858156832233067089e-13,
3.491356309479230463643637909847152741683e-13,
1.148438016167877195315078996455169368164e-13,
3.30540540311428371775996320767360559751e-14,
8.456309494315195697264390932430240885555e-15,
1.946988730778294495050596342446675746587e-15,
4.074908840174198094388727233303596051076e-16,
7.814502149074761666612771935488820767419e-17,
1.383338599134927835754993235770921041773e-17,
2.323101070758270134209297449096380832847e-18,
3.547435986930782468645102932475204507352e-19,
2.204923837799741011251350662414646659807e-6,
-7.109863552547366769952094638319501234198e-13,
-8.185530520309515455493223407305725396881e-13,
-6.282623175976575870608738105948381227476e-13,
-3.616564385944494849202881018588332986876e-13,
-1.665485551205908483212166241065649964531e-13,
-6.391507091790706783557891513178766966801e-14,
-2.102407313430895994371261434040651691964e-14,
-6.051101296431765703475771136087164703949e-15,
-1.548072672515691718420439192643906609493e-15,
-3.564310106738767544691416913318973375827e-16,
-7.459901282631913302487276694805716528541e-17,
-1.43061483703280657536482422300116554182e-17,
-2.53257577656862002583345878123766376846e-18,
-4.253346531818392328873678653200820379674e-19,
-6.495766903074264757246567445740166451842e-20,
-3.845840582163777724770013409114652529468e-7,
1.187676876375914425489146768030395377711e-13,
1.36736315305210962944768508526143067444e-13,
1.049489417355128384147948986524588436613e-13,
6.041339961584802710958018009921963197101e-14,
2.782133643517347176974090327488691615426e-14,
1.067678465436782278965096981565147621231e-14,
3.511997884884732352037415685532697497031e-15,
1.010816140457784499693433154980933231039e-15,
2.586007646914482273698145346370937003421e-16,
5.954089717166021108248578094492447257808e-17,
1.246165823184572653347283213831768602266e-17,
2.389852853950856915987995501070382768344e-18,
4.230798375694061516271115641640431303472e-19,
7.105863099040767287329799556828284589521e-20,
1.085338038084152180275689884391615404657e-20,
6.158307621750551164837064954144027137556e-8,
-1.824687509391166257517572792751206947689e-14,
-2.100748566560516181536783308365711974546e-14,
-1.612383247406170051155195730852967160146e-14,
-9.28161412980021192469732808257358763355e-15,
-4.274332107741000425531701099536247113716e-15,
-1.640328535920016691684795770206728855962e-15,
-5.395662372178659732324107803847478129858e-16,
-1.552969821565176925107152001367501662196e-16,
-3.973025095966965014879609361957164384198e-17,
-9.1476215515682493377647298446126088495e-18,
-1.914570103139046868242817813925033182428e-18,
-3.671738980584080566452885709960286577226e-19,
-6.500300664834069238179164099264368992558e-20,
-1.091822220037659933469030642906242821982e-20,
-1.667802166435783171989783964007823476052e-21,
-9.118047838408662845699586785588469060261e-9,
2.596276890647311587352042624577918399701e-15,
2.989073464623995679116531226974490670191e-15,
2.294197487906925883773062473635933046527e-15,
1.320644876333710367432891743011398174052e-15,
6.081781906125907480786331276938737810875e-16,
2.333960461867924840428345908659105638129e-16,
7.677283382865657500499546896198892889545e-17,
2.209663402854773033246953186351625963275e-17,
5.65307851770884056502737710302758188916e-18,
1.301586705937673269149196572354183672475e-18,
2.7241975611210614083420974316425144054e-19,
5.224490111213778521563374674704507421211e-20,
9.249434749277889676083811540970730269612e-21,
1.553659078173367009043898526836017899367e-21,
2.373499668437266184009471969478775510474e-22,
1.275108526475540077466412377378133037307e-9,
-3.490612628591788931025924008012560754673e-16,
-4.018715310389802952908594305626166488256e-16,
-3.084476466709822133888862536484356638931e-16,
-1.775565630501283936781391867975856437517e-16,
-8.176765763903482129428712092889083079359e-17,
-3.13793743780923260184553785387605226684e-17,
-1.032187273566099094447661630847700996629e-17,
-2.97082682410050653815941177250693765615e-18,
-7.60040616823769029855207359229360259432e-19,
-1.749951569447954538153866077102150351358e-19,
-3.662636402776595755224560632784201112813e-20,
-7.024309631303919104818914820937021985962e-21,
-1.24360954836968742550927202872636437352e-21,
-2.089033705811902085572066325960959352733e-22,
-3.191666743288286934321259771400890164769e-23,
-1.637692968501783351328146331155037477315e-10,
4.321625139618596445440878636296026419264e-17,
4.975453630117971590863855356042378853923e-17,
3.818799972279798155224809097710784950535e-17,
2.198275883590049927097305804870343513855e-17,
1.012341532175348771774606503263287839091e-17,
3.88498943638666849474742998504487054821e-18,
1.277921537698883100634969349428478121416e-18,
3.678097877973356957634784561809087477712e-19,
9.409862103723479787155922768090024787933e-20,
2.166573920525422279416714743944410792614e-20,
4.534645457236498617004127692694943842884e-21,
8.696755088095445514504828848989954602354e-22,
1.539734441134575803233486652770306737374e-22,
2.586580185605267773501784426592796932928e-23,
3.952143522760095595231691178310523404878e-24,
// [{0,1.e-6},{2.,0.00001}]: m=15 maxabserror=9.4305788160237194444e-21 maxrelerror=1.695811385654931258818e-18
0.01262973208991563769021111835892071294983,
-6.748258825025608676619420119602935527665e-9,
-7.769216215181031488664690584496952658047e-9,
-5.963087870185000211937168596995981402772e-9,
-3.432622466717527213618447510329499617842e-9,
-1.580774761896997183923501278061821605305e-9,
-6.066398964398529819690667903922606081016e-10,
-1.995453865313232706964275768458297872945e-10,
-5.743194625686502938787021055603165253103e-11,
-1.469261200677598884586100532474029507219e-11,
-3.382674800259855842148533750589255801948e-12,
-7.079002169057484971931173300963828569077e-13,
-1.357284246770164687817047752443098577684e-13,
-2.40174785040686033981676044414009384987e-14,
-4.029733736440720462128934420055828601823e-15,
-6.143245289069926829445856445477739360193e-16,
-0.02364233935484487110669939154342878280701,
1.177495437047116753372043199981966482771e-8,
1.355641093435906879103099168920498731837e-8,
1.040492028937003190220470146532420200961e-8,
5.989542511116357021995517812762019145694e-9,
2.758276057793826424528499611935486862701e-9,
1.058519725138467201539532725911466607264e-9,
3.481850970070478083448230476871150211012e-10,
1.002127597671089051410832350379709592331e-10,
2.563719468620790348893900851617855537132e-11,
5.902496615565166785056895151137774039685e-12,
1.23525198267147115345847384271906425598e-12,
2.3684827701864915256244494462741148517e-13,
4.191397903716984713985572733045637265575e-14,
7.033658774068356108073442966699288747144e-15,
1.072603634399023160398152075234247674472e-15,
0.0222192380609373399400628369099996277439,
-1.036218883131708424334586574288877808669e-8,
-1.192990562342512301946477739928770516226e-8,
-9.156533054267048397993751237668322940974e-9,
-5.270915038528400746264223893152047809048e-9,
-2.427337706606910352019586438109995595462e-9,
-9.315188439898322791692193709480330876636e-10,
-3.064102587896151132047096835966254179291e-10,
-8.81895268937302242819839484797283172677e-11,
-2.256140941273526249398543036577038350409e-11,
-5.194394655810743704732477650183670629138e-12,
-1.087080483070851271963289606945523756433e-12,
-2.084443587441408861035371561117522959096e-13,
-3.688982312115745948432363016804125868497e-14,
-6.191453042104547825746565765378814356524e-15,
-9.444275666022463337446419506988380729482e-16,
-0.01397153310573508291636096301451093960348,
6.125796795334561061303188262352430554634e-9,
7.052581343593279957527113299478856246071e-9,
5.413051850767527497549082226424393116676e-9,
3.115998091121303412756306618631137564058e-9,
1.43496551470304938266684380218785039724e-9,
5.506848088411031961411744869762059157978e-10,
1.811403206733841796130549604068189088868e-10,
5.21350268780589300466547019277388105847e-11,
1.333768119611127229771145875235929002428e-11,
3.070803904635205808761453865249368412025e-12,
6.426653875534726134350036785936750791549e-13,
1.232325411221693528138136640388936221371e-13,
2.181052425907500582412908793150769470557e-14,
3.661067320354289279354270784919355282318e-15,
5.585820576836933365501094896697606023898e-16,
0.006610224258701737807244976701367246245091,
-2.734478693082283318683727295208378781337e-9,
-3.148183742220742478582416987922132592703e-9,
-2.416318482845428046817307204972617597635e-9,
-1.390942616508159540456543110015141058932e-9,
-6.405508005400853972387486844213126412404e-10,
-2.458189603221103637706448838880613128442e-10,
-8.085888490907269866613114022207568175905e-11,
-2.327249180712022613935491563219013125111e-11,
-5.95380976811587135903539050861665746807e-12,
-1.370785121823591166391428107599108860827e-12,
-2.868848145871498799875808322081863722196e-13,
-5.501215711912640458165182418842819037184e-14,
-9.736901465168189363047073399179147162367e-15,
-1.634599614961851004729378509040133749925e-15,
-2.494488969247085483456037650924004630651e-16,
-0.002509165898057589293337897726939623519543,
9.824360048161593189090760381163735000509e-10,
1.131070844342545989541751504684690680668e-9,
8.68128332769924776045705169273775372489e-10,
4.997341229752450272727395802901547213048e-10,
2.301354084981307154958005627499182986792e-10,
8.831722034130694082717800918650101482069e-11,
2.905079750027090320299170522829757421228e-11,
8.361299715827248613268032523603009704647e-12,
2.13908009958579304807774677350627450999e-12,
4.924972979235618572838366487106055392482e-13,
1.030734433512869690995549300076538255721e-13,
1.976547843745498124088979541660792351905e-14,
3.498552829823621466182216515607471432187e-15,
5.873846189308009163129764193891417814152e-16,
8.965478692048902302544340718196272406822e-17,
0.0007957723717905594681462980218186085302453,
-2.957437864417909557018082800200759969286e-10,
-3.404875014658452083513171056750233833762e-10,
-2.61333637718936256624197299251377828767e-10,
-1.504355304382731470245979754689139178964e-10,
-6.927793390385429774299656932103898482588e-11,
-2.658624530417182653622152898468302139119e-11,
-8.745203911445163533373935237881240069476e-12,
-2.517017317048758800086781526686447508755e-12,
-6.439327620096922155833277006880244270596e-13,
-1.482584486483314574659183820414797322999e-13,
-3.102891816736784861436500418347226647952e-14,
-5.950255482907848807945894856123728889881e-15,
-1.053255431305162337295472308269821531467e-15,
-1.768506810939254592800741736898704533668e-16,
-2.699788707456713861556584633316046861529e-17,
-0.0002168317864955525825728500739140037175618,
7.668601319703149538192235101859568438683e-11,
8.82880069723441775455737647352232138711e-11,
6.776350592153038378535838906527647348824e-11,
3.900775938051728141897231796436352030266e-11,
1.796369075598273698906007656066325014549e-11,
6.893785558703353099063370197633410820372e-12,
2.267623460413817646088651706319624692545e-12,
6.526610301999223468713068419346354048981e-13,
1.669717332685509149110761999715185025735e-13,
3.844357754633190801368612490848248169328e-14,
8.0459031528340919129561167510522133748e-15,
1.542948259619645564491263453420685756422e-15,
2.731270623020520626306756717562963603569e-16,
4.586408502572399133773038349315715694393e-17,
7.002620764184554738876935477650176044643e-18,
0.00005180773676996749047223510639613235922436,
-1.747691874405038372396724131862772814131e-11,
-2.012104011627421138949742639742302945723e-11,
-1.544345953858193605052253621033552268657e-11,
-8.889959026123634548898537760892512822972e-12,
-4.093967383853521128454185606578952766657e-12,
-1.571110337261544049468939053880023768474e-12,
-5.167971066163161107255938764217630041968e-13,
-1.487432429504042028017204481168665958654e-13,
-3.805339267587651017837910399601429972573e-14,
-8.761449277325753788410943694826360560754e-15,
-1.833708975739109706301634069021848413617e-15,
-3.516525962597187882310198836229054934406e-16,
-6.225023688163772483862498755026571118518e-17,
-1.045395480506716183130172133268246724171e-17,
-1.5963461920795135159838615727469404538e-18,
-0.00001102461069330195020981754255149887117149,
3.554929612582274472332570220011188310764e-12,
4.092762769113536111959006264236503061562e-12,
3.141309676044369199736132496759775491776e-12,
1.808281092369863985464936403121914193682e-12,
8.327422687577543966006244511526617033307e-13,
3.195751600812143209812208424528815293198e-13,
1.05120301690304976922161942501121601017e-13,
3.025548806714785024817409948665591706081e-14,
7.740358651368759033879970136396303721604e-15,
1.782153968634415918699224475020469108753e-15,
3.729948370952581262202332207502765349555e-16,
7.153069830917089890363575633565169589151e-17,
1.266287117364414183622957466272655066103e-17,
2.126671970798783109331328820587336382815e-18,
3.247881472537064852498958515658237782817e-19,
2.115212899992535942664456804857242384603e-6,
-6.532224246949504615340867306357460931356e-13,
-7.520498984544822771602704490423272309843e-13,
-5.772193056316178244345218835994064908863e-13,
-3.32273770468207084756294724860475048731e-13,
-1.530173838182004981976831494990222148212e-13,
-5.872232842619813627977639593329322238325e-14,
-1.93159925862165012866816552803454222896e-14,
-5.559489986927306364076931410103981466609e-15,
-1.422304516492088413703171574357430759222e-15,
-3.274750059790586053650444575081053706873e-16,
-6.853913524755924471214607870884271038999e-17,
-1.314419356825633158948458117282549521433e-17,
-2.32693961504412701845875542894536508381e-18,
-3.908225558614021933145333323032511256042e-19,
-5.969360514728424302926603809107691412497e-20,
-3.69546658159136609829546327823850291254e-7,
1.094935262811415038013144276106010302484e-13,
1.260590469326530501745789249596297672174e-13,
9.675384227097348999183680374198231133775e-14,
5.569592905378071508438212192872296645956e-14,
2.56488682360753901048248894300924143603e-14,
9.843074759779648216077225363571119642588e-15,
3.237760421299057538535346633285432774297e-15,
9.318863706270134538756518943489978393396e-16,
2.384082348377545600246072133882341671807e-16,
5.48918835605071142570742254823163786266e-17,
1.14887087110157078498571036123859893458e-17,
2.203290426842881712446478643632080350344e-18,
3.900617780822438344458714393718452463464e-19,
6.551668101998146197921617568977836451955e-20,
1.000793578566728176482730235036083104049e-20,
5.926548358105496384607706297294355852113e-8,
-1.687535007928321544243590442545259790463e-14,
-1.942845977248645189654304669090324810913e-14,
-1.491188628562549483015035058211502135213e-14,
-8.58396294273407017789582551337562810784e-15,
-3.953052894318189829977123169014694650402e-15,
-1.517033872848409948978504250252659129183e-15,
-4.990101217732143404616553054551799782456e-16,
-1.436242937351468526889331355732732879841e-16,
-3.674403116721645243167214679846883993375e-17,
-8.460088132198498672759709400315335530822e-18,
-1.770681226240238715634974973918170453266e-18,
-3.395828070478516106142622819477497123552e-19,
-6.011972350862821033067845673339786339333e-20,
-1.009851480859693230617731572382922264718e-20,
-1.542733646470909705830326218592004299767e-21,
-8.787319281602581381311715163664564432747e-9,
2.408171345360511386729561569810883136673e-15,
2.772509035764153064364794223760487662882e-15,
2.127978274050314760129797262201977952649e-15,
1.224961552698605540446947929473178579027e-15,
5.641145274094147499787888468933212561539e-16,
2.164860946869859738109659568230377337164e-16,
7.121053061358510404408714098865151211135e-17,
2.049571394636248091228037302405084566294e-17,
5.24351484395091032888667627953601194366e-18,
1.207290270512987265860412339311038335206e-18,
2.526849760390167620323026430686265436316e-19,
4.846063999339860010597490340560093882669e-20,
8.57964492952027646306379505443812658634e-21,
1.441219683478612953384613885059430628833e-21,
2.201918781065422578369581709710991743742e-22,
1.230518913978965893558709140905105653684e-9,
-3.246754019428068374577493849655600365323e-16,
-3.737962815059123078742696765612557158951e-16,
-2.868991122523485792252324262977920866508e-16,
-1.651522478623969103715054180269724877265e-16,
-7.605527628674829340386161289474954539959e-17,
-2.918717998795044196062093837984774758825e-17,
-9.600779249387816414334731286653231474109e-18,
-2.763284349317645839883724528092854840256e-18,
-7.069448839311558061174721013292638778019e-19,
-1.627705425385047851966664000411355026887e-19,
-3.40679219371097339952956528704465654123e-20,
-6.533705550528232107180614244659659949431e-21,
-1.156773065699668963290995972554783097935e-21,
-1.943248527830677837623616730854044237459e-22,
-2.96917103227365869813343189125811109015e-23,
-1.582348779374632764091382945182439642624e-10,
4.029839203342905395359365777303754490473e-17,
4.639522776083186774706799233159468989695e-17,
3.560963696903919615490104628248032854954e-17,
2.049853603881246489723548499912061969253e-17,
9.439907410625516789160832851672910036582e-18,
3.622685075701854092900690825290816863716e-18,
1.191639933234871369737581222489569082237e-18,
3.429765118832852174623532363814510640322e-19,
8.774549591905674750234170988519710227524e-20,
2.02030081229658971037789377603600075282e-20,
4.228513987621644080586974022536663900829e-21,
8.109712483245765476304742217797152459462e-22,
1.435825495208023909503169756611692243857e-22,
2.412121684918196673732464094037552615708e-23,
3.685855010376327987877276468518966910044e-24,
// [{0,1.e-6},{2.,0.00001}]: m=16 maxabserror=9.13253156125254577846e-21 maxrelerror=1.761430895918213253192e-18
0.01182116967742243554524165960218201865322,
-5.887477185235583764929896295729844773438e-9,
-6.778205467179534393293133631450981489856e-9,
-5.202460144685015949396625426829764480208e-9,
-2.99477125555817851001586532970154969107e-9,
-1.379138028896913211812071876024351175134e-9,
-5.292598625692336005962372624308847047374e-10,
-1.740925485035239041153311253686783727961e-10,
-5.010637988355445255411278300621199984444e-11,
-1.281859734310395174026642030454179429042e-11,
-2.951248307782583391560702470353935832391e-12,
-6.17625991335735576526685104987652467424e-13,
-1.184241385093245762423751916487717693618e-13,
-2.09569895185849235630497315698119096988e-14,
-3.51682938703417805288114320075549371121e-15,
-5.363018171995115800224737346115675912093e-16,
-0.02221923806093733538457036923327276621875,
1.036218883131708312221595055165989698065e-8,
1.192990562342512172871654765287687868504e-8,
9.156533054267047407308311599455898589013e-9,
5.27091503852840017598034675805228120294e-9,
2.427337706606910089394619927516832761795e-9,
9.31518843989832178383520268318564304721e-10,
3.064102587896150800524229600195849797516e-10,
8.818952689373021474012391476209620737833e-11,
2.256140941273526005283839937105991052215e-11,
5.194394655810743142668142445041346652634e-12,
1.087080483070851154322066198072870320824e-12,
2.084443587441408635413742763282379748361e-13,
3.688982312115745548962512883453476333997e-14,
6.191453042104547154630338877728829510571e-15,
9.444275666022462311873061322566368230338e-16,
0.02095729965860262800756489310944794067434,
-9.188695193001842456877309195744965687336e-9,
-1.057887201538992093206931568888316323559e-8,
-8.119577776151292010611652087345170464724e-9,
-4.673997136681955559093639522046071631151e-9,
-2.152448272054574276608609231378146306056e-9,
-8.260272132616548719653213013196798582436e-10,
-2.717104810100762949957201029906082444361e-10,
-7.820254031708840243128548482863115199773e-11,
-2.000652179416691032985211113988306707997e-11,
-4.606205856952809146761824641298006131596e-12,
-9.639980813302090109103363756622398685358e-13,
-1.848488116832540466271056808011917331495e-13,
-3.27157863886125118180931905321876925951e-14,
-5.491600980531434436813877613846450174777e-15,
-8.37873086525540083955743275670400162812e-16,
-0.01322044851740424118149057128309415575748,
5.468957386164755043512017212923752301411e-9,
6.296367484441701867706844727309885227304e-9,
4.832636965691022578554541940255354614203e-9,
2.781885233016414917252072997093203201424e-9,
1.281101601080214928664569614722047469347e-9,
4.916379206442376646016074097802482710795e-10,
1.617177698181509685818044450746121645311e-10,
4.654498361424205579052191617181948913562e-11,
1.190761953623215295340095343159274715925e-11,
2.741570243647276787826103263519106526918e-12,
5.737696291743195296103674682665336546983e-13,
1.100243142382566007400878012523335878972e-13,
1.947380293033705003612374567654323749213e-14,
3.269199229923814790701961184713021132813e-15,
4.988977938494343314767796663192086041943e-16,
0.006272914745143711620744355302869380530978,
-2.456090012040336015047809412231794900219e-9,
-2.827677110856293268808408064588446165943e-9,
-2.170320831924756904481122101149784085741e-9,
-1.249335307438080887151799435075062568572e-9,
-5.753385212453121991109235811867630363692e-10,
-2.207930508532617531101971850805820342791e-10,
-7.262699375067541629483070212260734958402e-11,
-2.090324928956759145291242386148878533516e-11,
-5.347700248964347006689682875759402456563e-12,
-1.231243244808873418683282117563240282639e-12,
-2.576836083782108873662770223498006930033e-13,
-4.941369609363619968545411860576358776942e-14,
-8.746382074558831740882247050526304200545e-15,
-1.468461547326965005772740494685222995167e-15,
-2.241369673012168594478687438921859191434e-16,
-0.002387317115334921806076816227381432165636,
8.872313593163272089784197978870645469437e-10,
1.021462504387121428575729715716540133815e-9,
7.840009131488155822168610698750513591271e-10,
4.513065913102181964559418441783451337412e-10,
2.078338017094439455220759830729978734023e-10,
7.975873591170230625021676595722387989974e-11,
2.623561173406800665565402045188514725766e-11,
7.55105195106928942250149974777286008612e-12,
1.931798286009380640761276828619832536274e-12,
4.447753459404594458269139739878534749194e-13,
9.308675450115437636450898487762724674995e-14,
1.785076644854150720387487934413492157169e-14,
3.15976629388325642235636313898054841974e-15,
5.305520432763615831035572162437967756769e-16,
8.099366122287394820815671651863240841939e-17,
0.0007589112527414111199729393317981236409858,
-2.684010461912712596648613728168035698693e-10,
-3.090080244051169476565736276228458259753e-10,
-2.3717227072682410725831029903035635871e-10,
-1.365271578326553971267412701307751641525e-10,
-6.287291764632867522599219843985255138846e-11,
-2.412824945561105635426613001360741505193e-11,
-7.93668211149747902202760177200178334232e-12,
-2.28431360571386510464380309432422138696e-12,
-5.84401066443544924848127848397953442578e-13,
-1.345525214129944155553755617986190502165e-13,
-2.816066103509361603611910280751095131331e-14,
-5.400318908702187273758392891155088325341e-15,
-9.559447180631008011282520499003858923137e-16,
-1.605242975910283362925308777472203628102e-16,
-2.450917267479790657537732887845639012609e-17,
-0.000207230947850169086829660555087333824804,
6.99076751657667004387673263902531766445e-11,
8.048416068334175949102799677385853940741e-11,
6.177383832183683197794485396414888966929e-11,
3.555983620092043506866971512382054835212e-11,
1.637586957981977254834760318021912641626e-11,
6.284441366087428493547517571216212898596e-12,
2.067188432070786728861593449451627574454e-12,
5.949729734149929728761660647800106691426e-13,
1.52213571116265022541104464484957742843e-13,
3.504579720433911924835231264528259347059e-14,
7.334835922847691327611806307477495058813e-15,
1.40661038885377668702204249221140675363e-15,
2.490009482019906544599791282806441361631e-16,
4.181581933374369486217754096362729930837e-17,
6.385384785658865022694674102404836973936e-18,
0.00004961074803213923716646320114403882431043,
-1.599718323573705474085157348514312606832e-11,
-1.841743243696826771442820767438268431498e-11,
-1.413589352374625745132683125225104930685e-11,
-8.137264905041763797862730037770171662118e-12,
-3.74734020451800394537257134613590540131e-12,
-1.438088218488138371896489846148458353941e-12,
-4.730413569888476122132650110516769991575e-13,
-1.361496961244298379633646679137225215464e-13,
-3.483161388568831554149511099511232253698e-14,
-8.019692848385312824815923349729013037681e-15,
-1.67847676473735297974186240869618738251e-15,
-3.218881419709993984071588009069566604405e-16,
-5.698292020698750489029126355435341176233e-17,
-9.57002385609288967402801942233653074622e-18,
-1.461546660731105433836844299548640545819e-18,
-0.00001057605628200845456689729755121915863813,
3.266110101116574741262759236947244669284e-12,
3.760247163947029759129566146768098518889e-12,
2.886094741103107198761613264726690570676e-12,
1.661367823630404358438479995573307066078e-12,
7.650864453530872307439727224611672789224e-13,
2.936114603279899036483296991094916046617e-13,
9.657990312909407807890899095041373744349e-14,
2.779743272248436414723271279703790491142e-14,
7.111518178979979971753712406290735232044e-15,
1.637374016011534584368164847702521390982e-15,
3.426954640298352217487003771549112581627e-16,
6.572092714236248204435491117483688463122e-17,
1.163469086935492992058373864319933145047e-17,
1.954111568709091261657479463073972487329e-18,
2.984678407375994036414781969128677115141e-19,
2.032507181321178554745292025495069983435e-6,
-6.022145282077690273485926804377685314519e-13,
-6.933249120130369739404370794140581288924e-13,
-5.321462506002127379639368740834485086999e-13,
-3.06327677785235757339850186818907194241e-13,
-1.410688066086561973113487202562175277899e-13,
-5.413692319449625111614098962787548818189e-14,
-1.780768626957359811783746677379901132286e-14,
-5.125376176033456764174346824369094559171e-15,
-1.311245582642584254344488773785940131642e-15,
-3.019054265925459231472519299265686349277e-16,
-6.318791193592005853717083965531290231218e-17,
-1.211810003754545910996039401411206832042e-17,
-2.145340255716150991939298903706391198601e-18,
-3.603418256258277284753272014102996841798e-19,
-5.504365904967811166720220330262475061112e-20,
-3.55639526565410216017643524002996944957e-7,
1.012635743450682630111044594958759310643e-13,
1.16583968412283392997758202520667880054e-13,
8.94814565880855824356750199150564798971e-14,
5.150961405646965688541336472969592317226e-14,
2.372100512271467532864586761582219649172e-14,
9.10323469823571004354176200488380567858e-15,
2.994400017819434858551333032061493530534e-15,
8.618434157285630241489444289643656546183e-16,
2.204891701938022286101890445808473020568e-16,
5.076628107285170387154318387224350376988e-17,
1.062529132143532033597824035158558854883e-17,
2.037727748013480270191318717815807704556e-18,
3.607592236033266384972469351154575959258e-19,
6.059795719111945349606085415985515508907e-20,
9.257451471529587538035941554709346364876e-21,
5.711580581604732612501479304856936533732e-8,
-1.565269248426396811879569937481353493454e-14,
-1.802082373840542517838033586758033595071e-14,
-1.383148653478725348257620159316842795258e-14,
-7.962035810390624171434194012165433591003e-15,
-3.666645747752789796518669488885543856991e-15,
-1.407121745588578553987565767209917198509e-15,
-4.628559921285967486422313724030035450451e-16,
-1.332185553279835029975562868506595407306e-16,
-3.408192923162132576833173392127334844732e-17,
-7.847175563854830571530219334527941256363e-18,
-1.642408140645248747606646687025565443222e-18,
-3.149856821758243569800655912306768749623e-19,
-5.576619100244262381709047510774702622425e-20,
-9.367675756607841190648711676139204858937e-21,
-1.431208667134345878429333781554925257764e-21,
-8.479717831952978985814980260995464438457e-9,
2.23977331740319045526313791883086055123e-15,
2.578633713081382064465713592589380399235e-15,
1.979173574886598208203242959030897154912e-15,
1.13930280898558458862600715025878871056e-15,
5.246673349270143945463264598601851151279e-16,
2.013477647628266423182935279345885334882e-16,
6.623097632615411035990374502313501406525e-17,
1.906251698127437924512515245057123737943e-17,
4.876859103831407436841472678041425713412e-18,
1.122872476821140712395833467421318104211e-18,
2.35017507016153727688749923868581355797e-19,
4.507274654575708194718909119877368570446e-20,
7.979991271830608480152305039471680130228e-21,
1.340547174163104850673108388568743257806e-21,
2.048274007410966589846470661934968254671e-22,
1.188939563394603906892450205900741348708e-9,
-3.027564405170777445975096281987406695675e-16,
-3.485611535707720821345596209562742877681e-16,
-2.675304495713344923341491693899910024353e-16,
-1.540027652448303108699001215353254979738e-16,
-7.092076441194620973178018464668172671782e-17,
-2.721674945792517191824217908999607648787e-17,
-8.952631779072613556890726411757029490082e-18,
-2.576736763606419848660569967056203407207e-18,
-6.592202034412928112658268854594994101734e-19,
-1.517825054775221142728046573029334696538e-19,
-3.176826204575463189699894987494320665883e-20,
-6.092719072127665501893622633798405044267e-21,
-1.078716646166916603594615827574642782355e-21,
-1.812195245332668531130546968672234097901e-22,
-2.769134946343001017058743326095991274427e-23,
-1.530619617032547180851851850136546652001e-10,
3.766614158593936335839751247935498167023e-17,
4.336473847994181719811957606100339506388e-17,
3.32836520843336625529656017507201614372e-17,
1.915959334596916578835623107412873057727e-17,
8.823303206197343138923688837382085590653e-18,
3.386055766530415041231634723000456770377e-18,
1.113803770757283578764605430600825285153e-18,
3.205739557724034666280164517632173741317e-19,
8.201421519410295772562657949609236292354e-20,
1.888344494141175058309677570872069606314e-20,
3.952343969344610869759649646735288091301e-21,
7.580117534120467293443617953970466152001e-22,
1.342082558037450940329045508091342315049e-22,
2.254721998086890572098223167474420175578e-23,
3.445577801006072985829024073236500322191e-24,
// [{0,1.e-6},{2.,0.00001}]: m=17 maxabserror=8.85273328219926399223e-21 maxrelerror=1.823128433096014428114e-18
0.01110961903046866768442599235980753662532,
-5.181094415658541559296039875309356740058e-9,
-5.964952811712560862272206536087506121193e-9,
-4.578266527133523702053040646092996776736e-9,
-2.635457519264200087068498169505128496437e-9,
-1.213668853303455044272863545713971619922e-9,
-4.657594219949160890288733401175773693238e-10,
-1.532051293948075399726317337165234165408e-10,
-4.409476344686510735464067090362866655266e-11,
-1.128070470636763002247387907112398355714e-11,
-2.597197327905371570425673588794173584802e-12,
-5.435402415354255769709022004237180423579e-13,
-1.042221793720704317342217993955480387724e-13,
-1.844491156057872773835607676059856625071e-14,
-3.095726521052273576230395286494922383437e-15,
-4.722137833011231154278614745357432003579e-16,
-0.02095729965860262359630313890364490152617,
9.188695193001841406673859406451538189982e-9,
1.057887201538991972297816986346379155496e-8,
8.119577776151291082600298990502774264446e-9,
4.673997136681955024887818936013923671607e-9,
2.152448272054574030598157736313386913166e-9,
8.260272132616547775556441771965771582847e-10,
2.717104810100762639407444587169816371027e-10,
7.820254031708839349306729897645206461725e-11,
2.000652179416690804313594708040619593721e-11,
4.606205856952808620253574975505765726782e-12,
9.639980813302089007106548617689096274768e-13,
1.848488116832540254919806557703814240429e-13,
3.271578638861250807599902834358174265211e-14,
5.491600980531433808113714009598481296716e-15,
8.378730865255399878740672731013554927732e-16,
0.01983067277610636529375920753171918333082,
-8.203436079247133377146333380281310019956e-9,
-9.444551226662553736269518129999672140129e-9,
-7.248955448536534585247379038031653717358e-9,
-4.172827849524622788855365209310109255606e-9,
-1.92165240162032258317959462559726996044e-9,
-7.374568809663565698874936076617361485264e-10,
-2.425766547272264768803140763621178080761e-10,
-6.981747542136309059563626381410626772046e-11,
-1.786142930434823119789084689805767447333e-11,
-4.112355365470915588767095306217263272593e-12,
-8.606544437614793796079661520550407147704e-13,
-1.650364713573849174492449168308681414044e-13,
-2.921070439550557794715979059949099164019e-14,
-4.903798844885722672110346701357807971299e-15,
-7.483466907741515715018143429662686685714e-16,
-0.01254582949028816457045516530694243307296,
4.912180024080848517242369388594401509158e-9,
5.655354221712789725910029005283266559801e-9,
4.340641663849669761673973570651457240317e-9,
2.498670614876251547824219427800143338331e-9,
1.150677042490665740385278948160646460841e-9,
4.415861017065393718077210058567476598278e-10,
1.45253987501356051391833841690258372725e-10,
4.180649857913668497728136528111805097983e-11,
1.069540049792907829702623452984056173462e-11,
2.462486489617835317307222160783374736725e-12,
5.153672167564402938370642675417378424508e-13,
9.882739218727595113789526862596126097238e-14,
1.749276414911829234232726800051169097667e-14,
2.936923094654035664885307135530482858267e-15,
4.482739346024498654643386935298809307069e-16,
0.005968292788337050931608395295226201266881,
-2.218078398290759559855941092243957266258e-9,
-2.553656260967736263908989744673576427373e-9,
-1.96000228287198729512483457541673448053e-9,
-1.128266478275515753037727354567883611944e-9,
-5.195845042735961689256951736633859699454e-10,
-1.993968397792505100386857459562063026467e-10,
-6.558902933516828787400055917511597986142e-11,
-1.88776298776727259842374235688426305254e-11,
-4.829495715023324305056917407282154851947e-12,
-1.111938364851119304869710043919905321816e-12,
-2.327168862528798062859262053603923208651e-13,
-4.462691612135259144557307220842045188307e-14,
-7.899415734707932735551838779546902580149e-15,
-1.326380108190868957223758523628384814285e-15,
-2.024841530571795212091123200072531782216e-16,
-0.002276733758188640466600426014901383175185,
8.052031385653403614955958558754188024315e-10,
9.270240732055954626431385136201723485178e-10,
7.115168121729847938675146305018777625617e-10,
4.095814734936560275263974355056204639181e-10,
1.88618752937001125261511590834318601482e-10,
7.238474836607143798054162735220133926429e-11,
2.381004633424187440203115071765117897701e-11,
6.852940817069478568865541792323279870878e-12,
1.753203199312184729651087785582733644188e-12,
4.036575642347351895553226577054403380122e-13,
8.44819831043917176100131123993697966924e-14,
1.620095672593603606179193352403351905057e-14,
2.867834154159109846784887867853207381081e-15,
4.815728927680124305036740289285493695539e-16,
7.352751802361849826007628113984225268481e-17,
0.000725308317482354756214026857195367058301,
-2.4467686308174261081358973307663410461e-10,
-2.816945623934912063031844215548575583508e-10,
-2.162084341278066616737651171530327564888e-10,
-1.244594267040146185945203091986731693949e-10,
-5.731554352973443745377068565705815824731e-11,
-2.199554478144616281278005091527695595761e-11,
-7.235159512293858593470557057797587918753e-12,
-2.082405406965745327325696035926505267309e-12,
-5.32747498910322503043024243005071589639e-13,
-1.226602902159685879529584274599124246484e-13,
-2.567192573013052611737383115683481465836e-14,
-4.92313636101959660482349751294115625807e-15,
-8.715033187125230586749281682981593330696e-16,
-1.463553676690363735499435977158878268126e-16,
-2.234884674994869023739759170260837692264e-17,
-0.0001984429928744688914913334495005015187603,
6.398873312052137361071664860802333320215e-11,
7.366972995231167660173055397032233583663e-11,
5.654357425189739145855826960324281101852e-11,
3.254905971049299424453256672412624595146e-11,
1.498936085966857687015613757221344466906e-11,
5.752352889915769190870387087145075517838e-12,
1.892165433206306352054278961193572998412e-12,
5.44598786009033757177277030369649315008e-13,
1.393264559294015864918050155206929923575e-13,
3.207877148256565065139355591278471814478e-14,
6.713907077582473246385621561710215504045e-15,
1.287552571457620305719009348026701606319e-15,
2.279316814606802704762691572821545914463e-16,
3.8280095530675038377757078080454291136e-17,
5.846186659170349383872907567164370663766e-18,
0.00004759225318401063153712587123640015167249,
-1.469749543542211300547959734840535286309e-11,
-1.692111221519345714079256099573481324284e-11,
-1.29874263176422737456231121345260346857e-11,
-7.476155196365650823343616100642095883055e-12,
-3.442888999497007205036852140842473197647e-12,
-1.32125156971375927197419036355510116539e-12,
-4.346095635012693814375910526099539164304e-13,
-1.250884470843440235340016766696386031271e-13,
-3.200183176272734943618949038337419047214e-14,
-7.368183062224380632198120646470149127652e-15,
-1.542129586077322091150274178591997041027e-15,
-2.957441717461298866816869471152688519572e-16,
-5.235610884224749235722621779952515780774e-17,
-8.793502047455250845457665396512914967188e-18,
-1.343105281525576203843026149374349300347e-18,
-0.00001016252794882420111090952641812125935022,
3.011070746615073462145827411028177786327e-12,
3.466622379029682405603468894183037439917e-12,
2.660729578995166920737761227436364136402e-12,
1.531637425291746073642504781751835115597e-12,
7.05343589273983170108743502243782824461e-13,
2.70684445670301498728666596820961676839e-13,
8.903837532892790233555633658141010175909e-14,
2.562686475684085867696835187361434618875e-14,
6.556223788288865338202519259135128536605e-15,
1.50952618321365906118050708983306398668e-15,
3.159393608944040311435201449110948887719e-16,
6.059046206284371922014563935542896444288e-17,
1.07266945283529878990711108564889506283e-17,
1.801707994039680066681796408975867488482e-18,
2.752181219301163307816962826401695970775e-19,
1.956017940324902676788625857542151620776e-6,
-5.569497843623130189648394224869818321984e-13,
-6.412119707138006459710947721079212611753e-13,
-4.921481221010127367640712969649714155151e-13,
-2.833029411304421206830665606702656906589e-13,
-1.304655575650133351909964457490774100691e-13,
-5.00678021191201430251811243477436736345e-14,
-1.646920380804684949747538789382196068554e-14,
-4.740139854328298011580689890652322149144e-15,
-1.212690709253042795275019086478222787837e-15,
-2.792146088011600567343969850931528350772e-16,
-5.843911543319056261454529992472438257066e-17,
-1.120750513905559593827641692861365951549e-17,
-1.9841761768870026178682977705232060488e-18,
-3.332888396645341044921974909268156229545e-19,
-5.091599457337567851074020400453361445283e-20,
-3.427399838830753040090246636879589247218e-7,
9.392690294375750651091801704750176466095e-14,
1.08137316564028856356797492880140236558e-13,
8.299841670318626483161932646671170429818e-14,
4.777768205496626444324084007720592150482e-14,
2.200239221746199792170183828935888332583e-14,
8.443696685187260669645233739349472550423e-15,
2.777453776964663305680747474562721054116e-15,
7.994028078723615578716987093070516137636e-16,
2.045149782005988675139963433946341157415e-16,
4.708844179697181707399992032602913581184e-17,
9.855576654297970466521871089157885785582e-18,
1.89013039508394905743978062114129383293e-18,
3.346354435209260305357166746053043875452e-19,
5.621248881120480318637287129276390298819e-20,
8.588235326345402011981075876670376545434e-21,
5.511645069954433211947521694082739925055e-8,
-1.45581311370869269320858965267664064856e-14,
-1.67606638840776219055796860119435802578e-14,
-1.286427881888921083862784998064214967134e-14,
-7.405267117475736097822061009339371652568e-15,
-3.410245048357031004852634950396468337628e-15,
-1.308724923510641511145513888225563511217e-15,
-4.304896531939882824396203269679461282639e-16,
-1.239029949281950591533941978753385100841e-16,
-3.169872317153437128683544252526848352345e-17,
-7.298472856025479419573792736086981289158e-18,
-1.527572302565180191740333870658429952162e-18,
-2.929648945680701339615355185124658602252e-19,
-5.186853424128782064124039522534978927281e-20,
-8.71331989736816485793039516730293497668e-21,
-1.331341923438864541614196975188910777909e-21,
-8.192901915475606062751211408746595687122e-9,
2.088425257632371871900904964276798691883e-15,
2.404387882014385661404782519963276339343e-15,
1.845435052463175954136169954121704502653e-15,
1.062316836665974430579032461037476700713e-15,
4.892140855207286547919596549301464601831e-16,
1.87742155049262812179841330935490136376e-16,
6.175558818762547923945174872823178542132e-17,
1.777442611861050840992477409443658615822e-17,
4.547325371464842480569039770530094968243e-18,
1.047001281641399247648665560468833727355e-18,
2.191386095328195448951269071245062771635e-19,
4.202778468628620371783577021096031400808e-20,
7.441020880901369596507703191899543174972e-21,
1.250056569325788073022962499562533063722e-21,
1.910152073547150763990519392406689769161e-22,
1.150075849887664792659122156566497118299e-9,
-2.829827643114188293841007012109009721394e-16,
-3.257958753487056541856674450730949421441e-16,
-2.50057464803337855079350499469851382865e-16,
-1.439445204838362146586145743948448720044e-16,
-6.628878423550862821633628325090738952973e-17,
-2.543917113130172364680030898882963385135e-17,
-8.367920290473316948650692419357416733606e-18,
-2.408446966857030462072705668821349748937e-18,
-6.161663631509256687719444793404915706158e-19,
-1.418698409723917706861854034755180714185e-19,
-2.969365066843114171261098507079450815328e-20,
-5.694883074184905042460849152686863258212e-21,
-1.008296190208501845516737610135724734221e-21,
-1.693955301338511393912123258500148277911e-22,
-2.588636665138016870684286220690002598995e-23,
-1.482162772610292639902394105871266820613e-10,
3.528343163081826765923503527497838859004e-17,
4.062154317665037902528341298863161324748e-17,
3.11781732747614163167306564019065849692e-17,
1.794758392143298708650603380463274363427e-17,
8.265153718304967892497549858638619429707e-18,
3.171859119790171153619254055740431938769e-18,
1.043346516651533661310619450456932448187e-18,
3.002951580523925737458530323954854173688e-19,
7.682625095078127440867187528262824872486e-20,
1.768897064185802841071298106628873078234e-20,
3.70235214590442319572568266638831536816e-21,
7.100717149520705876887033023985671394553e-22,
1.257222423992105615774403535173742747782e-22,
2.112229067954936908253508678076215214141e-23,
3.228033815507756762991047647967059310443e-24,
// [{0,1.e-6},{2.,0.00001}]: m=18 maxabserror=8.58955871305431611058e-21 maxrelerror=1.881236548247837856302e-18
0.01047864982930131179052641277239163210559,
-4.594347596500920701632819913833463196023e-9,
-5.289436007694959859527156425353342191294e-9,
-4.059788888075645539794314320419576884908e-9,
-2.336998568340977511577081755262247274425e-9,
-1.07622413602728701489989059323311872056e-9,
-4.130136066308273886246284171694116730569e-10,
-1.358552405050381319199809142744393648591e-10,
-3.910127015854419673203004908048051444217e-11,
-1.000326089708345401785742698384513692535e-11,
-2.303102928476404309272444414020894970743e-12,
-4.819990406651044501765097493123750043326e-13,
-9.242440584162701271169453176851175127214e-14,
-1.635789319430625403192708084443086747933e-14,
-2.745800490265716903036577856601636538253e-15,
-4.189365432627699937810903398054507941297e-16,
-0.01983067277610636101788271495464444996257,
8.20343607924713239135027516567847727282e-9,
9.444551226662552601330098429801168234902e-9,
7.248955448536533714149542573342774099325e-9,
4.172827849524622287411556424904152266653e-9,
1.921652401620322352256568495854806442082e-9,
7.374568809663564812678002885868579509546e-10,
2.425766547272264477298804100908582603121e-10,
6.981747542136308220557808611970853013675e-11,
1.786142930434822905141172282524132353201e-11,
4.11235536547091509454704366026714554801e-12,
8.6065444376147927616592809869401202528e-13,
1.650364713573848976100236586425043927435e-13,
2.92107043955055744344627516118848776232e-14,
4.903798844885722081931416730262857809546e-15,
7.483466907741514813017436355546889080041e-16,
0.01881874423543225027234114741613905123468,
-7.368270036121273539428614608905966343507e-9,
-8.483031332569185467951630562713553658331e-9,
-6.51096249577450531723458061598286713949e-9,
-3.748005922314377710138155759040721353069e-9,
-1.726015563735998789443283323871501965841e-9,
-6.623791525598091263534822430600922546604e-10,
-2.178809812520340996667229604044459521641e-10,
-6.270974786870503396458932559860157698401e-11,
-1.604310074689361910813393632043290234406e-11,
-3.693729734426753358768634420817363463137e-12,
-7.7305082513466052087891648994688264212e-13,
-1.482410882809139420738526480998323474268e-13,
-2.623914622367744123438247041391064573812e-14,
-4.405384641981053954487192778760233534523e-15,
-6.724109019036748680704431313260955712775e-16,
-0.01193658557667482044060541604439303160183,
4.436156796581684783355564027225915613042e-9,
5.107312521935663255096770733878313615491e-9,
3.920004565744120978785503955587681013134e-9,
2.256532956551115774020913519661563298016e-9,
1.039169008547231144610255015014229291913e-9,
3.987936795585159126722207007298642782909e-10,
1.311780586703414744965982310497730153345e-10,
3.77552597553468619229958750589233806849e-11,
9.658991430047009327272483208930660913908e-12,
2.22387672970232166372813639065441135242e-12,
4.654337725057769960710637559461820103224e-13,
8.925383224270851688470349091045257280037e-14,
1.579883146941645578204560721226158702714e-14,
2.652760216381837094388854305125053501036e-15,
4.049683061143742005974850966587681616101e-16,
0.005691834395471355134146870390147783683041,
-2.013007846413295920115679776650279610865e-9,
-2.317560183013925354384816136330640625555e-9,
-1.778792030432413398436528577389937146924e-9,
-1.023953683734112100354847523961858478228e-9,
-4.715468823424899332220539996000042482465e-10,
-1.809618709151736521107127986084815383265e-10,
-5.952511583560306011389145531534182428834e-11,
-1.713235204267322845906266998672240672146e-11,
-4.383007998280342102208640934343586342004e-12,
-1.009143910586810408247807393056650442531e-12,
-2.112049577609735244178511675242606563121e-13,
-4.050239181483898359012600498384620079188e-14,
-7.169585385397578688041798932163188418393e-15,
-1.203932231919998156639576393150729390017e-15,
-1.838187950590412140917484744027385300844e-16,
-0.002175924952412563714315181820466887235201,
7.340305892372740606705365544622268109288e-10,
8.450836871713165026458236513349699446283e-10,
6.486253023763916414575420947268262394144e-10,
3.733782801079980193474911967341077563222e-10,
1.719466305873401389075221939885500411237e-10,
6.598663434362347156514005455216891820948e-11,
2.170547853664637916489183420568038299199e-11,
6.247216220829541850532433807898311227609e-12,
1.598242496713648911686937554624028603364e-12,
3.67980870643918211386871428765470527422e-13,
7.701577718955696924506080630505747710011e-14,
1.47694090828987195454976982194895433466e-14,
2.614509956109227420044922275018515340935e-15,
4.390661030023473357397765452035167250936e-16,
6.704654024911830267566951724485688733063e-17,
0.0006945504750672026860769145572235556927485,
-2.239605659232911856547664415712301579003e-10,
-2.578440548347790978498840017075822275345e-10,
-1.979025098829366338003233123496502863472e-10,
-1.139217089874713808011390079282186617571e-10,
-5.246276300918351857520087987019615404015e-11,
-2.01332351148370145621179608400414295721e-11,
-6.622579016265433708769395737871645925992e-12,
-1.906095751044098426305655751582844193861e-12,
-4.876425957560984596235236399557779583929e-13,
-1.12275700189714935256948203523183157772e-13,
-2.349867477169252809070099473638097138019e-14,
-4.506434000131182432662762041829073506869e-15,
-7.977608851176062455097874709347738288812e-16,
-1.339803343582405795016735375669560986338e-16,
-2.04616533072304112873525281720276837135e-17,
-0.0001903690134590628524485719579310594145927,
5.878998190837177534256448396317854227534e-11,
6.768444905267505668090212607777115288654e-11,
5.194970541785866985297582531173505111245e-11,
2.990462087024922808835420942976501457205e-11,
1.377155603703364795324676886315139634481e-11,
5.285006293839297650988584439086161766659e-12,
1.738438258933978511001864149127703103365e-12,
5.003537897560090557074228275639522977321e-13,
1.280073274138468143732341473914352973017e-13,
2.947273233246271876469396331884336705541e-14,
6.168518361799785202051808154539959537347e-15,
1.182976690339034273006360655907903677817e-15,
2.094244359629343595870074704300301008774e-16,
3.517400828961141401967746790891333898886e-17,
5.372421141353785962080830758421347665462e-18,
0.00004573137568721341558100651767941592683753,
-1.354981834133184089928573105556572239038e-11,
-1.559980068440835756573381367229419697764e-11,
-1.197328308918730444680188345937031353591e-11,
-6.892368404435042083263309830729079985242e-12,
-3.174046147414287659183213286756840647285e-12,
-1.218080003859024004550772667009865264711e-12,
-4.006726884350148138371089243414469856728e-13,
-1.153208912488759997173959945318900386657e-13,
-2.950300700715717637244887725156186300112e-14,
-6.792867815218716139135324730190151778202e-15,
-1.421727122090270864173907514252230514835e-15,
-2.726570789117660937204333236334400968987e-16,
-4.827012531189354641636880636498447215509e-17,
-8.107685962140623139093072124602478430563e-18,
-1.238481546998443637192974505266632573489e-18,
-9.780081988060194082381874642063577002697e-6,
2.784747143563917419061992203158559863183e-12,
3.206057806286163598074005346416330195161e-12,
2.460739039158063729995598031458792629006e-12,
1.416513801112913602519469689334438595992e-12,
6.523273712700148902876005941996111089684e-13,
2.503388507372203483339814648952146872736e-13,
8.234596645664994412338122700590613115465e-14,
2.370068413706967304618081138879695039513e-14,
6.063449674296531943929043284033401424471e-15,
1.396072152497214833847270658376295750439e-15,
2.921953905699916556988592704797023636541e-16,
5.603748990790688877329204921373665292047e-17,
9.920874547986935612050304949073032963537e-18,
1.666443133716669934934533277718085368435e-18,
2.545798101576708173017845619090102525579e-19,
1.885070439366627435923259525668982520321e-6,
-5.165980841891249252371000910963687562157e-13,
-5.947553769528774582328253832629925916825e-13,
-4.564913961367626856265750885282252586159e-13,
-2.627773113244648176998833637002231993474e-13,
-1.210131848372184793963790064520396444307e-13,
-4.644034237618984975290083386493989072005e-14,
-1.527599926257467776445451606204234765299e-14,
-4.396716447577469200506240801499750476819e-15,
-1.1248326370343775560393639340621003976e-15,
-2.589864890410159420397093446731189287071e-16,
-5.420568398059396329054407222350979324679e-17,
-1.039571954772134958803580074936297881892e-17,
-1.840495359841400544042295330350252072615e-18,
-3.091687591092891393863028189467912668659e-19,
-4.723530509295440430679676257758685259584e-20,
-3.30742467612862522282261247702276058531e-7,
8.735887573918645462195711777990509189025e-14,
1.005755985966245843184074251856889168092e-13,
7.71945879758435540413752195757989015358e-14,
4.443673462312215782125100029846166369574e-14,
2.046383362193650018111893002080693686179e-14,
7.853256500159170298655305578100048475895e-15,
2.58323625297628147637549579957086830024e-15,
7.435038358061111382950942843475833927151e-16,
1.90214306705885372753034701542844045034e-16,
4.37958951244732701930803924730761670575e-17,
9.166492470583435946927529718437045900348e-18,
1.757992407635329888139169264996849415034e-18,
3.112471553881906107848457626826767149068e-19,
5.228595944359003695940116822506275694846e-20,
7.988974673970780910136403229231116390897e-21,
5.325219831708557129419428154253430349226e-8,
-1.357439227901199637813623458005641972536e-14,
-1.562809307254863730714399327733180142787e-14,
-1.199499921577947312205384903227169912917e-14,
-6.904870266590615029358402423988260280644e-15,
-3.179804439219292982002225703857302812675e-15,
-1.220290575671365807333120118158257384929e-15,
-4.014003260946130784167434142221711604603e-16,
-1.155306045845517132701554470598432231575e-16,
-2.95568051451374043546103029911160230606e-17,
-6.805321883509531444774272539379732284653e-18,
-1.424361937770405758361222323815558163538e-18,
-2.731731159338160875991319062973256500749e-19,
-4.836531051118916693141081399615268359584e-20,
-8.125145040463691965714580918283837097123e-21,
-1.24156481558940877062522408512511843674e-21,
-7.924835471435844782042169710880372826677e-9,
1.951902597778244639872960318532064242316e-15,
2.247210415271313035633912756274521168832e-15,
1.724796971358684884063462106032221300817e-15,
9.928720702561663128195074230531748185099e-16,
4.572336765935946831864192265710521483806e-16,
1.754692870037252768469120684261816544089e-16,
5.771858640633890137771279231954815046944e-17,
1.661250915851911137611045933228203285686e-17,
4.250070361644500818952773254749759680334e-18,
9.7856165061364230555942822886822647808e-19,
2.048149517625908580575492192342912200247e-19,
3.92810221379451816988933815399140525867e-20,
6.954820171117648558190652788218961073188e-21,
1.168420831744560032624705770618535492538e-21,
1.785532009326850879706353494661646144817e-22,
1.113670352330858452232018978033169631877e-9,
-2.650834777515076660284410085380591378039e-16,
-3.051885669687684813525584850411556311365e-16,
-2.342407815845957639259730361189106019169e-16,
-1.348397177940456774041140054441742223254e-16,
-6.209587875374722181587640583512390183019e-17,
-2.383009271364681062785402072980549467264e-17,
-7.838634473909235774392112179218847804186e-18,
-2.256109494011443839627141740955045215894e-18,
-5.771935711502382483929061961617184001196e-19,
-1.328967647022440951555370161784564545193e-19,
-2.78156732690696489620152859936326046408e-20,
-5.334750047825561204369748898901742173238e-21,
-9.445479328999084536419791545158155157898e-22,
-1.586912370515513565530063869175869573715e-22,
-2.425214151333563520989934000767698721398e-23,
-1.436677497535284091996034651871552031726e-10,
3.311970914434870686497340028061917460222e-17,
3.813046640255910595694540000640380436551e-17,
2.926620241677242809209234182854922200957e-17,
1.684696643148491226704059510701926371304e-17,
7.75830193096399946061534924759296497198e-18,
2.977348554181462081872242242470685234166e-18,
9.793647249706017940730203362911151448547e-19,
2.818800955814185710887079525214001608426e-19,
7.21150830042323105306726254871881334909e-20,
1.660427059035885077828415646592105175689e-20,
3.475333707308496427615957518522178087709e-21,
6.665367077272529774912122501564989933169e-22,
1.180158014111312241758745475463454452274e-22,
1.982819578007466400145734649518017027475e-23,
3.030445205842415754267522523082989430805e-24,
// [{0,1.e-6},{2.,0.00001}]: m=19 maxabserror=8.3415699331139442882e-21 maxrelerror=1.936052952263322277234e-18
0.009915336388053180501536710776622560188824,
-4.101718039623566194069513268825795671224e-9,
-4.722275613331276298816506268259236987442e-9,
-3.624477724268266855655962692844344296076e-9,
-2.086413924762311142889046966639845200269e-9,
-9.608262008101611757521661932470726758542e-10,
-3.687284404831782404895599545860929727574e-10,
-1.212883273636132238174611327312780935953e-10,
-3.490873771068154108912363739910441898498e-11,
-8.93071465217411452220975270656169157382e-12,
-2.056177682735457546468551215668485352164e-12,
-4.303272218807396379144797076421015395171e-13,
-8.251823567869244877269768385699110567798e-14,
-1.460535219775278721150974301119743290063e-14,
-2.451899422442861040004342539150702979626e-15,
-3.741733453870757405039252634743573629308e-16,
-0.01881874423543224612379338587648298774463,
7.368270036121272612295486201081420539287e-9,
8.48303133256918440055038379083666345005e-9,
6.510962495774504497974175444879566946089e-9,
3.748005922314377238534334152444341380009e-9,
1.72601556373599857226204508186766438236e-9,
6.623791525598090430073687862058303621801e-10,
2.178809812520340722509673013791780256245e-10,
6.270974786870502607380171024460410999148e-11,
1.604310074689361708938452275118769650658e-11,
3.693729734426752893957169738039449052873e-12,
7.730508251346604235918767850156517279501e-13,
1.482410882809139234149792446939858785487e-13,
2.623914622367743793063163723547220609569e-14,
4.405384641981053399397013291560389523375e-15,
6.724109019036747832283744992128749595769e-16,
0.01790487836501223397876197024063640163751,
-6.654235194872527894470144307993917519582e-9,
-7.660968782903495710927218963417488931469e-9,
-5.880006848616182103907986228107574238474e-9,
-3.384799434826674026986536385961891444546e-9,
-1.558753512820846885443703048940081322824e-9,
-5.981905193377739336832634396087468369866e-10,
-1.967670880055122330189846135509029147698e-10,
-5.663288963302029900759223110172013972311e-11,
-1.448848714507051555742041319227044772763e-11,
-3.335815094553482856277750422409089270904e-12,
-6.981506587586655695998691985759023463403e-13,
-1.338807483640627898061492777647659562459e-13,
-2.369824720412468623677722698692687107426e-14,
-3.979140324572756072345295207628489096444e-15,
-6.074524591715613667390035491206104933583e-16,
-0.0113836687909434074479866999952625117687,
4.026015692826747645699317359742636964137e-9,
4.635120366028030086407704850014316312902e-9,
3.557584060864964474243110327862070083512e-9,
2.047907367468303454111247138700647556538e-9,
9.430937646850163639258837644208258118737e-10,
3.619237418303613106028320678180797696944e-10,
1.190502316712107274675739993106025971193e-10,
3.426470408534778297133156887869700250064e-11,
8.76601599656102345688030052759709627467e-12,
2.018287821173698928436263761827665942931e-12,
4.224099155219633980010364990847619508854e-13,
8.100478362968110281895845019693439029544e-14,
1.433917077079571257407658708009516929139e-14,
2.407864463840089596633230196239278495231e-15,
3.676375901180966859622639382139037529685e-16,
0.005439812381031170368262488625343260083953,
-1.8350764730931333456670958631227893321e-9,
-2.112709217928231612753819762468532045674e-9,
-1.621563255940933325306738246163833881127e-9,
-9.334457002699686962600165517973063458052e-10,
-4.298665764683382116930988510289705679501e-10,
-1.649665858590540217280168194688910105595e-10,
-5.426369634161441598397070876659118438562e-11,
-1.561804055207341370741492428526538431499e-11,
-3.995606241784009476092404873178731529207e-12,
-9.199521766097695558191560542480009490566e-13,
-1.925394429738869869086055348756924947269e-13,
-3.692352270724575623695097304004840395883e-14,
-6.536274890272883939700771641528384002998e-15,
-1.097665257505837320556411314815471358173e-15,
-1.676163506227910154088423753507474099159e-16,
-0.002083651425168134841763047835642761483753,
6.718816977623930853097543143517681217412e-10,
7.735321644957250840126389613728936102773e-10,
5.937075296421997889468753270686886940993e-10,
3.417651269586090588487811093078622907145e-10,
1.573882890257982527963397375986884277925e-10,
6.039970534383857473852755985775961055682e-11,
1.986773704857510011763436304822818424644e-11,
5.718287253068629327039612480085782122547e-12,
1.462927787252007321278838961180353087638e-12,
3.368271005653945255886254820074398685105e-13,
7.049602431429263448940296612388807223495e-14,
1.351930200024300022857419567895136861523e-14,
2.393282655326162785667303562944505673445e-15,
4.019410030702430542025924695850921737077e-16,
6.138495992100669488754882509962524151179e-17,
0.0006662915471130918014380286567546930562643,
-2.057649366806828472503503974015808726104e-10,
-2.368955716859533624843156085111476640456e-10,
-1.818239689637262238275673190897642524092e-10,
-1.046661730465750924073710042088675649151e-10,
-4.820044612994141597691732547924035109648e-11,
-1.849752202856174595698294349890979362552e-11,
-6.084533906309780347769603589641266084298e-12,
-1.751238264157790724033848750204050251943e-12,
-4.480256459514722384147726034343692171122e-13,
-1.031545631643121897980090656182945553137e-13,
-2.158981426644422833633663406064444526027e-14,
-4.140418416214426153750072159707584454072e-15,
-7.329855258751937016724700012148353221448e-16,
-1.231090290144672006989964158163916530084e-16,
-1.880347399486469782212391311291260667346e-17,
-0.0001829255034503445541487658329810101898062,
5.419927352209207628478332176705005997431e-11,
6.239920291811543942321121600366136806648e-11,
4.789313249527422363718476031600217479277e-11,
2.75694736974815078837948336291226632057e-11,
1.269618462637933580675277029017329045144e-11,
4.872320029528710264121353214655584343201e-12,
1.602690758375664358541414421860374343075e-12,
4.612835663297212939717827548783485034018e-13,
1.180120283699698385165495876609648948743e-13,
2.717147133946771579905465065184632476898e-14,
5.686908504810905491669683599360667053253e-15,
1.090628318802008245481473870270930112955e-15,
1.930805018061903680905131159728716533999e-16,
3.243074394242016688035223504762065996033e-17,
4.953926202339335231315050880487463419006e-18,
0.00004401036886616098500189746360576457268066,
-1.253136212866708093809870221881119042334e-11,
-1.442726010828915826520847463630425465201e-11,
-1.107332566086181693481569902722671473073e-11,
-6.374312096172252951040319522906649211041e-12,
-2.935473166646010217448301372815892378619e-12,
-1.126524826755938162732579821651921087961e-12,
-3.70556848541269423656570706695289270545e-13,
-1.066530784689734795072463219976582258606e-13,
-2.728552349651152216261399699856278417392e-14,
-6.282324677528841597391081633799573191118e-15,
-1.31487925574220401202392044123650958343e-15,
-2.521687042359883842110685840874606092565e-16,
-4.464393540404136530277789977408109450726e-17,
-7.498994091324417678693761006554196513346e-18,
-1.14560914411976800775873747961182589295e-18,
-9.425344712953994132080761051583949353235e-6,
2.582988748512904420113302826069832331079e-12,
2.973774959305447241282545132164891097718e-12,
2.282455502840053951353254641127969820772e-12,
1.313885705907752338677791552544732371592e-12,
6.050655324181812090674329261051214404112e-13,
2.322015615349384950059338584342242828297e-13,
7.637994685826386239330785970859823477412e-14,
2.198356800388900229040720257839349123002e-14,
5.624159543599303466872320897822548874205e-15,
1.294931606743069540524632347273119985423e-15,
2.71028244409262104497422443179209196696e-16,
5.197856408032172829707696706566456692269e-17,
9.202470839651609311849947338297606512062e-18,
1.545842794232785349982951757733991136494e-18,
2.36176372420215743038629961743502396561e-19,
1.819084084611555581943065293804013452639e-6,
-4.804739277447098857480445421371120218727e-13,
-5.531659202811766952196052589476998777102e-13,
-4.245703321105336505211260040401092240578e-13,
-2.444020969805716781482240278982181315228e-13,
-1.125511109644134112869442878834451419311e-13,
-4.319292074550769815123790015244187793851e-14,
-1.420780267899075016890708001595415779577e-14,
-4.089272043175296545691342948044360909535e-15,
-1.046178928965471849146864332815364833186e-15,
-2.408774789236546849225275377329928381378e-16,
-5.041572025466888164468265645277230529478e-17,
-9.668960479541634696169374300138570150116e-18,
-1.711859750821427499735032798153376607916e-18,
-2.875728435081654592763567188275773291917e-19,
-4.393937088194665920407367242470864456512e-20,
-3.195556501949220056495895559927027597847e-7,
8.14558422527148563599835250620626055309e-14,
9.377948256297456559608957569854568834555e-14,
7.197837986917381692493153301177231406091e-14,
4.143404814474294308734916853468084104502e-14,
1.908104933796336986992540441299979576337e-14,
7.32259644496141306403666326803455579252e-15,
2.408682538229424171758823220213684341501e-15,
6.932643843659172260709591629075797654232e-16,
1.773614914017068517965860140014978538591e-16,
4.083668833112074414980678326553065756751e-17,
8.547167293491216915878410976753784589514e-18,
1.639229656519657586653231770824722129208e-18,
2.902256747175089000956693411949875928668e-19,
4.875655121483890267448886779396239568768e-20,
7.450257194743712561625341222928480225154e-21,
5.150981455381492765036425871645583048554e-8,
-1.268701648219033092747636725705368215787e-14,
-1.460646428255563733194786509750297324059e-14,
-1.12108706801856087405871833059144797136e-14,
-6.453490217349064906038366176981014903943e-15,
-2.971936815747322326316478929701392335709e-15,
-1.140518865447753241015200441769598446564e-15,
-3.751604500474461249220524623804408908252e-16,
-1.07978327261026127826896017537136386743e-16,
-2.762469437752186499428486468292377352158e-17,
-6.360475056253051328403474879995334785804e-18,
-1.331260417281932822931513815688840308098e-18,
-2.553195918200966572916533980435662097576e-19,
-4.520508245188959934128830209124177871805e-20,
-7.59452560268853493850898252074442582469e-21,
-1.160563737182355519914997644987673250528e-21,
-7.673739738643014606899914161646671804206e-9,
1.828331833493715366777119109553700229697e-15,
2.104944362539646563091617362094797717971e-15,
1.615603812989801531324272780771793740404e-15,
9.300155189121968698230050717736664693919e-16,
4.282872417238466871787653926181658331782e-16,
1.643607410095707070665766148508259046292e-16,
5.406457196156549217467475768538272469196e-17,
1.556082158604909566949195609474746535298e-17,
3.981015094603821189996777285955833136907e-18,
9.166145043481237920978090638539642762646e-19,
1.918500198649288590588133047222599261327e-19,
3.679478415759816401235271046290427966115e-20,
6.514723791451782278433228576029951598118e-21,
1.09452212135283609171683142160434976868e-21,
1.672711093203402315303973825065799491397e-22,
1.079497164763871215141206764481942257978e-9,
-2.488291058782121781245146296953671176878e-16,
-2.864750357717044056816998685350621767801e-16,
-2.198776247869679413947135019884912071192e-16,
-1.265716306951463770729894843606421902702e-16,
-5.828829368142072608036575049474488336759e-17,
-2.23688854240451559089684112208737443624e-17,
-7.357988807122313815993177978067970856526e-18,
-2.117771386147761411278264499640553248026e-18,
-5.41802213487569856362254628408830568041e-19,
-1.247482528602893955686608196578868692135e-19,
-2.611025944174379047595905502508100639956e-20,
-5.007705221737449249055222884091895077376e-21,
-8.866554003691337018584235263762661374778e-22,
-1.489697011700250234298007355280189489192e-22,
-2.276781041298260432321649960624016588749e-23,
-1.393898776684177255064263949771996391839e-10,
3.114895512491692994193716855877778161646e-17,
3.58615526915498369884833178249789064682e-17,
2.752474786579348397112934756184686467615e-17,
1.58445058507833877807781001405461384065e-17,
7.296652916632244325518402823147070293843e-18,
2.800185075443317379826400143891185944404e-18,
9.210890188079000963854186832245962315773e-19,
2.651073316983535298206161453762162405787e-19,
6.782406237750357462226062542552015883096e-20,
1.561630268927916846911727313901017244112e-20,
3.268559377164861634234715026061695501685e-21,
6.268834651439921949966689555356829590254e-22,
1.109963495307044555541669719052468604095e-22,
1.864940518814553662036104039047599237038e-23,
2.850445531034412393910526719739468106738e-24,
// [{0,1.e-6},{2.,0.00001}]: m=20 maxabserror=8.10749013563994089085e-21 maxrelerror=1.987844551997861099463e-18
0.009409372117716123054700169453010343814745,
-3.684135018060636304632311930533099113756e-9,
-4.241515666284592198530487613026085281855e-9,
-3.255481247887252247647978202394933788299e-9,
-1.874002961157188618496314251859347153903e-9,
-8.630077818679992857760322309759866364265e-10,
-3.311895762799045213674522373533532231229e-10,
-1.089404906260170360806716161509678985318e-10,
-3.135487393435251302400307034391488786574e-11,
-8.021550373446808541392535628931388375215e-12,
-1.846864867213376446218829837571323328703e-12,
-3.865254125673302116369174274878898223549e-13,
-7.412054414045696167699030940322419190028e-14,
-1.311957311183871895991546150185036972646e-14,
-2.202692320990526698791098064806670756691e-15,
-3.36205450951837391475481243341390177852e-16,
-0.01790487836501222995018428309353168655397,
6.65423519487252702091843700166389770084e-9,
7.660968782903494705213844436126922931219e-9,
5.880006848616181331994744340994984665302e-9,
3.384799434826673582637900177148240057979e-9,
1.558753512820846680813911414011549338117e-9,
5.981905193377738551539225122806468257142e-10,
1.9676708800551220718764640918985779206e-10,
5.663288963302029157282785715602298639248e-11,
1.448848714507051365533677920059677936332e-11,
3.335815094553482418327571863365178245719e-12,
6.981506587586654779347248409379482679326e-13,
1.338807483640627722254009284053421930577e-13,
2.369824720412468312388084340110771808771e-14,
3.979140324572755549307147382338874504538e-15,
6.074524591715612867916491714844398677022e-16,
0.01707550318641511439657946836141872794269,
-6.039023539240122147573016291825041004185e-9,
-6.952680549042045911366726578689762337646e-9,
-5.336376091297447311383706040615767495746e-9,
-3.071861051202455526565335253522762818023e-9,
-1.414640647027524704950457276506922109443e-9,
-5.428856127455420269462212675592017550941e-10,
-1.785753475068161112804311341550164452019e-10,
-5.139705612802168023614859803851464845093e-11,
-1.314902399484153666383900943687493615087e-11,
-3.027431731760548733080237290922182330043e-12,
-6.336148732829451682545819265045007082189e-13,
-1.215071754445216678943613955749951687777e-13,
-2.150875615619357128087000113091844827451e-14,
-3.611796695760134801535285991211523739206e-15,
-5.514563851771450910938369624561603140533e-16,
-0.01087962476206301775513007301114457205465,
3.670152946186413492549523531413744752122e-9,
4.22541843585663223661988589429479550818e-9,
3.243126511881996371385690788942263094749e-9,
1.8668914005400120657411858354245711213e-9,
8.597331529367108116220117671014206420891e-10,
3.299331717181212403882725984368002283663e-10,
1.085273926832331729494896652012540084208e-10,
3.123608110414807683422556618984174376292e-11,
7.991212483568338599192581206757423298824e-12,
1.839904353219612709592549875392587079407e-12,
3.850788859477893782340640160643279946359e-13,
7.384704541449446693580773281628970142785e-14,
1.307254978054629100467829473002261325489e-14,
2.195330515011762538185663221910967146536e-15,
3.352327012455954660492575575688226563543e-16,
0.00520912856292010490205392528424818506677,
-1.679704244405933817332663180963890270753e-9,
-1.933830411239256416508932917769042435623e-9,
-1.484268824105456265508078662121997371669e-9,
-8.544128173964977752732515433420784438004e-10,
-3.934707225644841780984838480510503432935e-10,
-1.509992633595920412659185877836408965899e-10,
-4.966934262143630441737896152794515899914e-11,
-1.429571813267115716584921826005442857029e-11,
-3.657319468129911836337283213915733181133e-12,
-8.420677514134618001971775966795646288979e-13,
-1.762400607857264553538140142968681901171e-13,
-3.379825500060651649992693387697170769707e-14,
-5.983206638315232719665872083924173727301e-15,
-1.004852507675578357635495325101363304296e-15,
-1.53462399802512261818540717770408234211e-16,
-0.001998874641306770154953899108665254836315,
6.17294810035000373083471088859009252464e-10,
7.106867150497455849733963589736048334747e-10,
5.454719068849505630832175167597256285823e-10,
3.139985191361400926140947954531706737875e-10,
1.446013383881732119658242557431937912142e-10,
5.549256608505163137040046560685682872599e-11,
1.825360171872092335363930705812524314844e-11,
5.253714792413385484520704368546527937559e-12,
1.344076937839069934760746857110140336285e-12,
3.094636894894030101206709268715005450559e-13,
6.476944279859309352632914877559155922121e-14,
1.242125524850142986754462002727118869895e-14,
2.198956577600464996698183327206158795481e-15,
3.693270870391815184410588900322680630513e-16,
5.641042198394904579102537176244952272398e-17,
0.0006402392620823986679409022177177665988525,
-1.896974573286262913018254975442995890197e-10,
-2.183972102149053511615807779932086163347e-10,
-1.676259637346120827460692239955197485114e-10,
-9.649315794184859430375691996033585431168e-11,
-4.44366461926331434976070195007154159168e-11,
-1.705312010346771331539443217285614964245e-11,
-5.609417654353385885935376852225277070993e-12,
-1.614492482165123036820603266187135289879e-12,
-4.130420992977338396343857667311503043881e-13,
-9.510014968879077238860411872911200293886e-14,
-1.990417976697500631934388673254111752531e-14,
-3.817199115833273433329563990858513001159e-15,
-6.757817563263132806668534601886884618924e-16,
-1.13507603799251406668547438618728262536e-16,
-1.733874170830702945063096863457282466829e-17,
-0.000176041476145849588758997475797315322869,
5.012544866237356449310907520831439514934e-11,
5.770904060320854282128687542345901213563e-11,
4.429330277396688125854044953787645224239e-11,
2.549724845982208262172913092419207396473e-11,
1.174189270118404495327538879593605143147e-11,
4.50609932030195371545546027356337692855e-12,
1.482227398532791704247183013496452403049e-12,
4.266123151330074393921307089745707404882e-13,
1.091420943076615343236081152187168777557e-13,
2.512929878416654881022617697823923333756e-14,
5.259517038468095846783471807113550195982e-15,
1.008674819916609522389738614093375136165e-15,
1.785757421425122378498275642548439049419e-16,
2.999597645373603163734534498808864852801e-17,
4.58243658999704107424426916503879424087e-18,
0.0000424140511304346826633180743677103978617,
-1.162344935191325813520789268816965090758e-11,
-1.338198729799929156303794463864515390956e-11,
-1.027104974829298071620314349898212442352e-11,
-5.912485668245353384922433025133843862071e-12,
-2.722794892041324745918886875156314665753e-12,
-1.044907025433384894857009728783013301153e-12,
-3.437097603773848470719495276215159179118e-13,
-9.892605587796480731911480489979694161793e-14,
-2.53087179104985220532921258497502792719e-14,
-5.827192222124343121302212290683108341932e-15,
-1.219627098121298596726407268919650057642e-15,
-2.339035380314885489795863278846867911304e-16,
-4.141111872000805089456398323939395956503e-17,
-6.956292564230662271437338344126329299431e-18,
-1.06279367439036883322944859321343891741e-18,
-9.095413155590366560780205204690672344598e-6,
2.40236806294026627551019495328114789331e-12,
2.765827787218686559424751105507623357396e-12,
2.122850268113076556069012679620141912313e-12,
1.222009683350818570742656375806309038406e-12,
5.62755185694284183744718206602303959783e-13,
2.15964462069956375879409338608243974919e-13,
7.103896679829483582128788431349328262325e-14,
2.044634680444664773383712614514177242521e-14,
5.230891213694918764381812075760202091544e-15,
1.204386604608285415334634449026670552713e-15,
2.52078435920335053818952560361357186461e-16,
4.834477068413049161762256295877804450589e-17,
8.559293138812420304031293497522525436653e-18,
1.437863274042192511217461118821518683181e-18,
2.196967101941982218180022037647298924176e-19,
1.757556574401660410061332134099868673668e-6,
-4.480072373239991000008525496860246176356e-13,
-5.157872749061470338869478077700596375139e-13,
-3.95881182005359243373039048708969854986e-13,
-2.278873181727909978750492557123609462017e-13,
-1.049457959396424870584543774494791442089e-13,
-4.027428988050684347983912447895509268727e-14,
-1.324775706321308993616242838113271278552e-14,
-3.812955007102937028634749040938228626246e-15,
-9.754884311946209493494242667908293636326e-16,
-2.246018384294167680608072254044885278135e-16,
-4.700943112540239158512084598301219201467e-17,
-9.015765222743539550983399704859353337559e-18,
-1.596241584887037418045019911445453801054e-18,
-2.681610945139483248354603588540225082652e-19,
-4.097642417560902190090000577557149522215e-20,
-3.091001197986764310307501473556944656975e-7,
7.613103913354432760900486549164174896414e-14,
8.764907852547659325343197688973555299515e-14,
6.72731241171329798139869844970555979438e-14,
3.87254889268593150796089090166098127966e-14,
1.783371514891182656468537659419955636913e-14,
6.84391689003026120760389805644520313274e-15,
2.251227067432837940844014095396170965905e-15,
6.479460536022484598313924778330242536334e-16,
1.657676328689531521429680101109006603221e-16,
3.816733247620718166905359406449611693091e-17,
7.988500637553689523860889016377898565546e-18,
1.532097478587302819476708508806786237276e-18,
2.712623532070833317862680523877634777589e-19,
4.557250657603381190398266643961318146011e-20,
6.964200633061355614484829037309906320804e-21,
4.987773771051062286936914339116748795875e-8,
-1.188382619701134047627406389194496466762e-14,
-1.368175760030500122380115086787261287515e-14,
-1.050113254335824185891222126972644818635e-14,
-6.044932645569938954423627277191235208248e-15,
-2.783789599759675178575435439344597625323e-15,
-1.068315085885875265942451663673863577825e-15,
-3.5140993817876914603176481106607974722e-16,
-1.011425255563498232630333456815743753835e-16,
-2.587587799802023496057886787470704419036e-17,
-5.957828472833990791698855764067539285535e-18,
-1.246990425121024155581059263580763779943e-18,
-2.391594409951405353089646953097272047039e-19,
-4.234452609541667551894208092827471807548e-20,
-7.114195760125586387094405072189134588256e-21,
-1.087231940020823229471417002955274805526e-21,
-7.438053886309533983963783316777240968633e-9,
1.716126123421345555301130170635761967869e-15,
1.975762806235749945984600829465768425254e-15,
1.516453367893859743830084151623644567427e-15,
8.729400078270196632022251046964326224379e-16,
4.020030648746559712910008918479457301588e-16,
1.54273867069790544724702568435424839573e-16,
5.074662231729821533981734269865858527544e-17,
1.460585850370019039254956676979011300688e-17,
3.736704692349264155308375122974946544212e-18,
8.603644423767018627591456934785164626113e-19,
1.800773647535713780153893065053139777667e-19,
3.453715918945406937232493230332150406272e-20,
6.115085757588004599227995727918986285927e-21,
1.027413460355239561466240036744840344635e-21,
1.570246596581943942077919833962310968298e-22,
1.047357219962644295478409909475760201113e-9,
-2.340242247577212989407509904150139081869e-16,
-2.6943029176307941394253709250266006929e-16,
-2.067953083983361349044760290950399171803e-16,
-1.190408533469118999617222147217944178097e-16,
-5.482025113914737086059765382761693183055e-17,
-2.103798150693276245506760647075020880403e-17,
-6.920204641708269468512226631994014923711e-18,
-1.991769473236138690200409912837764392088e-18,
-5.095668101144515603762571485122824233851e-19,
-1.173263486482661250665863079700450273678e-19,
-2.455691009256085693578984453840224295542e-20,
-4.709818436400570795606938685155421865825e-21,
-8.339232162720217858968782391466333174196e-22,
-1.401142787556418520761418783058644288238e-22,
-2.141559943152504271993236819001561715318e-23,
-1.353592177761270397321699229079864622096e-10,
2.934890095142165353886953694754631532172e-17,
3.378916435978193366415815751984111716993e-17,
2.593413199324084659830984928484203333845e-17,
1.492887484989857094950480911344287181715e-17,
6.874990269557206936905329258651282338048e-18,
2.638366830946572174933676921027636748664e-18,
8.678609185255710777972490303973985656817e-19,
2.497873471914685299175579386510898330584e-19,
6.390470525225447530483041229340148502869e-20,
1.471390462432104133797073564949371076039e-20,
3.079693232972778041585870350471154300521e-21,
5.906641274028454255426857573566188602312e-22,
1.045846424238805189284951847948488548075e-22,
1.757262515931031130928626537448944933551e-23,
2.686008793047604855917104054598974070308e-24
}
,{
// [{0,0.00001},{2.,0.0001}]: m=-1 maxabserror=5.53669368933797495e-20 maxrelerror=6.22879698452209297e-22
155.7492388328066977994060873572447437715,
-181.4219983211385556849119459163727452352,
104.4543434307174409338422796274700992082,
-40.07851371037724106216193238516597011566,
11.5375507714380742018307907963993520282,
-2.656188792208225645683705926515960088169,
0.5097440435646096006367278078350732348746,
-0.08383075712616093575361680644877409642401,
0.01206405474255716670194611012618637523821,
-0.00154354553437674575654579188801814374943,
0.000177618786760173750853549774291697339636,
-0.00001860819367828355379265314496180321601487,
1.782528728515215116385685318533508412711e-6,
-1.581114948853511594075022790278311512811e-7,
1.309309875048033566285098101576256845316e-8,
-9.896655853111108682274224137504208978586e-10,
-1.473877706255828019828075601385980967016,
0.02257417276539369143223544776694045825176,
0.01278021301086679665074877712228240782036,
0.004741503220823926777511382957381454504516,
0.001272180866809063264639185868678691621217,
0.0002512380136162860223806857511002231454986,
0.00003273135290175263312709159286034685443647,
5.462756719850154099577361984020402368339e-7,
-1.206485135445219369856698304145900887473e-6,
-4.432635997165408216386433963199457164274e-7,
-1.043612727623789238939185627237429551345e-7,
-1.817345321434349843787482690118069000664e-8,
-2.097899641635827317537678498886510254025e-9,
-1.625108580032984183993843355916316379821e-12,
8.830682536131130770609196747317075109242e-11,
2.916009393797762473768700994226528661035e-11,
0.3789098587274559788245009046412879962783,
-0.00007972913557794160341837290010571146098176,
-0.00009097260281315200749175720186130395872256,
-0.00006888749517667559912749323422646683912183,
-0.00003885335509431764490171777063183153749836,
-0.00001734559097238333819246480906240210839184,
-6.346736054468507801219993913542244684492e-6,
-1.938069260229024564337246949330532550072e-6,
-4.950760719829509875751623970977129269807e-7,
-1.035157206568305870727812811893012787992e-7,
-1.626156785512813890695883713813632639207e-8,
-1.197356304857663151128447324693898840852e-9,
3.4093074862740380875864899164042608153e-10,
1.907545764696372152292914472699610002352e-10,
5.900762959199679301731398603779434820518e-11,
1.291000780666323507983312752058008205856e-11,
-0.1336879700167898427220168720575072184013,
8.658955055462718573483430344799844599458e-6,
9.967370526976452679306782508613075720678e-6,
7.647766188161030182459008806473583039675e-6,
4.39957941372082362109528009308959184004e-6,
2.023497543076764522258681480815287429526e-6,
7.74583505327511622619211039622699764079e-7,
2.535178997443738305107335918981305744802e-7,
7.22468600860235942784312400069018287462e-8,
1.812226849787269387837480988914784239071e-8,
4.010580810575626501584840863241435127166e-9,
7.738289660769786364764379963447029055257e-10,
1.244397209735652104054825357514720688363e-10,
1.394245378498971252290913861046808935632e-11,
-4.941766338472281483540540185226223497461e-13,
-8.094206007918378472319570064546867250507e-13,
0.04448747619111063154020271054082551110189,
-1.627869828841208428416831064428264057301e-6,
-1.874056042999759794500875352683240466646e-6,
-1.438240202105188974580845383285986455136e-6,
-8.277438346222682926076089797947637905288e-7,
-3.810301085037590918393263330949650240001e-7,
-1.461029391557440989088098173176956020604e-7,
-4.79784856442039767488806586858273365229e-8,
-1.376289067908576521781791678474274436403e-8,
-3.497409867411435462552094698902081701595e-9,
-7.944010475830671662069863118493339152581e-10,
-1.61735289793126334758133011822887233274e-10,
-2.930022529488272079966033446801565331775e-11,
-4.578685935462783291669100499079522437143e-12,
-5.381810465539651155500976225720353869867e-13,
-1.776605052483004804059863473949027970392e-14,
-0.01323272002832564302972524858494716128592,
3.321977717632279001396438166004373922779e-7,
3.824452065540865448369455987502310177703e-7,
2.935197193660073024580873807510963556458e-7,
1.689430125644405039484082305231907698199e-7,
7.778223443384311031524167383621119736505e-8,
2.983553266194098463234974714461075028394e-8,
9.804582440441512917919452864634657928183e-9,
2.816495937613054829222936660869036454654e-9,
7.177723685080721179544191374139616545279e-10,
1.639809745344065109295023394947409258958e-10,
3.378495469597434278664421189202987945495e-11,
6.275660747922670136938323433256340936614e-12,
1.038586061817361967317141269157045418404e-12,
1.467371600096235119650473003173740169554e-13,
1.461326843801872528145469113439501702333e-14,
0.003499070232786285384433560542065966902965,
-6.639458097408752045707179932204424171815e-8,
-7.643797198637335926367426631267425915369e-8,
-5.866583375178054241305305419854977553576e-8,
-3.376791591936750180368650488751811308785e-8,
-1.554807270929165942285170685996022701384e-8,
-5.964777065992146756022923015727030681334e-9,
-1.96073174241172842012924740221922711677e-9,
-5.635805685651496652600950819040996394915e-10,
-1.437975082493602884758996818520149786302e-10,
-3.293084928197109181266235894658595444298e-11,
-6.818052400142619241501624172779207945393e-12,
-1.279319581927436684836935121438772718249e-12,
-2.164293423414042480357507722882731985121e-13,
-3.249797865012296355369882136727360229919e-14,
-3.876684938054947787815737931201842068636e-15,
-0.0008270938228321231356338941972355318874138,
1.257067064107027078304422611993090572283e-8,
1.447228643707915639133156891157846984919e-8,
1.110753271065217085461128133170269173022e-8,
6.393598086674464240809491428148543640723e-9,
2.943981531132497431201232686132825661715e-9,
1.129503634752924759879180684028642188383e-9,
3.713482992310549659416817270731736697477e-10,
1.067724380565638383277984252377999848462e-10,
2.726058400373969425046311790438058811289e-11,
6.251033329181505992399318320513992709004e-12,
1.297640180281750855260031738505115380765e-12,
2.447976479499008745860625608869355733353e-13,
4.189078948309208237934731637763944271533e-14,
6.481010301722216435463026318304109787472e-15,
8.332275062999445251327915653376136811471e-16,
0.0001761641234748246063228590074420798213278,
-2.228791987420852344963814803231158591304e-9,
-2.565958331277156191429345520445224954075e-9,
-1.969394727863430247734032968785976135401e-9,
-1.133615936635166218036400299328496197337e-9,
-5.219952769279537388979257602639656773761e-10,
-2.002815271453517213262686294960080464257e-10,
-6.585340910134863665196911744580719767226e-11,
-1.893839660994694430394112771021185145066e-11,
-4.837200414293219913732491194759554627005e-12,
-1.110100717905497532901721976278939307244e-12,
-2.308210257321745785546067770058678929628e-13,
-4.368858746908711416675741510977963621927e-14,
-7.52849450574904517654586471959167963101e-15,
-1.185477980440985672893771178951824191485e-15,
-1.587545727458758452064484442060814005023e-16,
-0.00003408138351530461374032563053548724464702,
3.688909308230775086559043721568492465249e-10,
4.246967774128478840485562408962079935606e-10,
3.259597590800329176227351353762122639648e-10,
1.876293881319339456755011020529725394226e-10,
8.63990363580228481133023287560322062403e-11,
3.315110687779182132469907034209583544571e-11,
1.090096746774221577309335357433299670024e-11,
3.135373827513518373439799975844992899765e-12,
8.010490773570438510130265756511775659215e-13,
1.839358310499269260646225279845861841589e-13,
3.828786526378848183350369192406943510504e-14,
7.263171484852772541582798354715586938325e-15,
1.257464454613652550436772774773696674654e-15,
2.00315424080533011194987036532822854028e-16,
2.75201204631371981945760786912898902546e-17,
6.033214551662457771795001391059715202463e-6,
-5.701826146516395623212261882279093892854e-11,
-6.564408925858648957288671826232528340872e-11,
-5.038276380254759514441609255068729471261e-11,
-2.900157186898398814592445395123728538197e-11,
-1.335472423278408703409979118485609371844e-11,
-5.124302551192196883577196028371355069496e-12,
-1.68509034493993440184709923204881293777e-12,
-4.847193348870393644195656979922394180436e-13,
-1.238642632654975532095521355259165190183e-13,
-2.845284315365197386033986766673031085137e-14,
-5.927448398778034842124323663930706852639e-15,
-1.126242709033180851489089976345095466195e-15,
-1.956373915799461130924239187284804995474e-16,
-3.14210310378354964707432437903794440748e-17,
-4.392879403007467844559538342804455159156e-18,
-9.83697221242337420435891387435414536298e-7,
8.246248605071517084599639523642613406677e-12,
9.493767346864062883993920683799225676365e-12,
7.286617204140264702940690890256787418134e-12,
4.19437758959117969446954123602753122881e-12,
1.931456590622927657006501604732719538834e-12,
7.41127404506320122428732228436374276983e-13,
2.437235342850737853466722424353657201025e-13,
7.011274654100652421256319437233254780056e-14,
1.791915296262351233788095917857953028414e-14,
4.117439194895321805428701492591359107998e-15,
8.582840303367943621175191024707596741737e-16,
1.632754940212693983704194709850582780673e-16,
2.843329778716806078836528370869817402291e-17,
4.594402121116346265745104689066033947511e-18,
6.505316762360666924026493287070324609447e-19,
1.485684785210759096169207495289081945007e-7,
-1.118686438554175106490603268366804257739e-12,
-1.287926053371217349728206815838379258866e-12,
-9.88505493194944795540299960508771849157e-13,
-5.690130584116887464340445594343133967747e-13,
-2.620250511604120550136641134287649134435e-13,
-1.005442046923223943365311920677444078926e-13,
-3.306543634979568370303621366651912896766e-14,
-9.512595443741267815503627053983309197524e-15,
-2.431476649453902346744445849662075861138e-15,
-5.588320239951671045705200037278379256089e-16,
-1.165437892076520814096362118362491742983e-16,
-2.219158416077106480921507608965745849379e-17,
-3.87201791019874973019158549588113383345e-18,
-6.285895281266266272704825297705084593273e-19,
-8.986328952593978341474059765520342616497e-20,
-2.089646627292602959176335752425249254956e-8,
1.427747994461498556268540926382242672664e-13,
1.64374494466946046747053192759910673651e-13,
1.261604475010224004462198427897035181328e-13,
7.262190405033916799285987110336339263963e-14,
3.344188441350907924430603794019997851103e-14,
1.283246323367038706618992449886859242759e-14,
4.220242077915111474077188010133913740305e-15,
1.214178065025490078671869596612903733353e-15,
3.103801994743890222657220205765737835051e-16,
7.134877327639173191217562486584841139616e-17,
1.488530612443531441863883451366396829023e-17,
2.836509929667372610032286965334906216494e-18,
4.956852060807887011092934922240985532119e-19,
8.076903793366188334851931495259950965172e-20,
1.163408067684708512794165613370280136248e-20,
2.789215382307517569744760986126929839184e-9,
-1.740259718299661856509887927890320537403e-14,
-2.003536242415757193941235222173698832693e-14,
-1.537752781082556422958748964803041210365e-14,
-8.851808033175596255915966873337269981239e-15,
-4.076216171631714531243586627864608426643e-15,
-1.564158346472577243269671518237709315664e-15,
-5.144184025927217998099502967186765410198e-16,
-1.480056911047554657524805036984576613159e-16,
-3.783762556631775313853824481341905405633e-17,
-8.699298176709927222408744327024749512297e-18,
-1.815481101058920913095174468459725714313e-18,
-3.461712244294124939656766899391932846008e-19,
-6.057197672689630568732541817373718159101e-20,
-9.900160070524876031287888438745102925146e-21,
-1.43486052060760395631138310899702927827e-21,
-3.440844006581088555945583260283293712581e-10,
1.979292950835458612734439557546058416894e-15,
2.278732926886545710596840223941467504225e-15,
1.748973283074063476415734095964355399735e-15,
1.006768224157195652950561791865379840654e-15,
4.636138887444795885276729066258477891561e-16,
1.779030451156053113956656720604866815034e-16,
5.850945242281598208549405927342535389724e-17,
1.683455738193709943866347134505663090229e-17,
4.304024048073327181047597693909629729299e-18,
9.896695583094601490551979463792552023278e-19,
2.065896281840563942076712179016804708409e-19,
3.941207384184360812933973129224204711284e-20,
6.903408312172469273002856064000395614136e-21,
1.131123081987969313320209738286696841298e-21,
1.647499454800527625589662739922004163499e-22,
// [{0,0.00001},{2.,0.0001}]: m=0 maxabserror=1.944154123412122788e-20 maxrelerror=3.1565042340329120787e-20
0.7369388531279140098976195985120517144596,
-0.01128708638269684571611764222752241174193,
-0.006390106505433398325374294551691187279233,
-0.002370751610411963388755619324437663348062,
-0.0006360904334045316323195513997796174642963,
-0.0001256190068081430111903237488850591496744,
-0.00001636567645087631656353845684350139554962,
-2.731378359925077049764541669835439066613e-7,
6.032425677226096849290437322431259418396e-7,
2.216317998582704108194992964117091720014e-7,
5.218063638118946194700012656192308642908e-8,
9.086726607171749218945943146637436249158e-9,
1.048949820817913658770467804341277874534e-9,
8.125542900164920922826463897737168179646e-13,
-4.415341268065565385299898634096692114019e-11,
-1.458004696898881236883660715426625216796e-11,
-0.3789098587274559692819492194097686688679,
0.00007972913557794160336746131457130293779709,
0.00009097260281315200743314336461531945055375,
0.00006888749517667559908250589938765907184796,
0.0000388533550943176448758214945224266972278,
0.00001734559097238333818053960801567099610798,
6.346736054468507796643893319176001580423e-6,
1.93806926022902456283222083918416932708e-6,
4.950760719829509871421190732185370302076e-7,
1.035157206568305869620608815628429792754e-7,
1.626156785512813888149699111051176647131e-8,
1.197356304857663145812239388983368776308e-9,
-3.409307486274038097732846449099181520869e-10,
-1.907545764696372154071715763356041500252e-10,
-5.900762959199679304652049182597670966953e-11,
-1.291000780666323508410473666929698381583e-11,
0.2005319550251847714395697046448761003518,
-0.00001298843258319407789681222117052707090827,
-0.00001495105579046467906108240676747639782218,
-0.00001147164928224154530601822325263271710255,
-6.599369120581235450253053516451814962185e-6,
-3.035246314615146791957988780248475506646e-6,
-1.161875257991267437217419786790374169509e-6,
-3.802768496165607468476960766566396813355e-7,
-1.083702901290353917288631055000852646995e-7,
-2.718340274680904089713756707177277337759e-8,
-6.015871215863439770678518311174132135964e-9,
-1.160743449115467958536505488643300962629e-9,
-1.866595814603478163379204519146034045158e-10,
-2.091368067748456891238665706843761486914e-11,
7.412649507708422014732326423478471886063e-13,
1.214130901187756767757268522125487018494e-12,
-0.08897495238222286670871905400203493517152,
3.255739657682425412214111115476132200109e-6,
3.748112085999529438698475692300620240421e-6,
2.876480404210385509008061568333738386576e-6,
1.65548766924454093692597836586067090412e-6,
7.620602170075201876357300660399381674665e-7,
2.922058783114889668033300411278642482939e-7,
9.595697128840820640819348772253527930439e-8,
2.752578135817160320591847536449980821127e-8,
6.994819734822889530990740594500266306765e-9,
1.588802095166138611121794127330157738855e-9,
3.234705795862535628726433922819484565009e-10,
5.860045058976561210269562394064108900998e-11,
9.157371870925596475027319181632259286996e-12,
1.076362093107935139082640337620158356193e-12,
3.553210104966081390136140716797530845127e-14,
0.03308180007081357783646780035772153831791,
-8.304944294080671157877709130054121458643e-7,
-9.561130163852133289555364138020319909816e-7,
-7.337992984150159281481685725222585536627e-7,
-4.223575314110999197929452465953487061064e-7,
-1.944555860846071586821401671426413400068e-7,
-7.458883165485222477520505645246834199488e-8,
-2.45114561011037044112797534264783353102e-8,
-7.041239844032614663004600106669816589594e-9,
-1.794430921270174564825740281118912042286e-9,
-4.099524363360149594871996978224826874321e-10,
-8.446238673993558176300998899711409134827e-11,
-1.568915186980662279835863347771563898999e-11,
-2.596465154543395699616672144941583724774e-12,
-3.668429000240572635786432879607752830577e-13,
-3.653317109504659065068550485924299037386e-14,
-0.01049721069828186357175347894647782237474,
1.991837429218518173016771991012796954271e-7,
2.293139159586471935585531719830654107769e-7,
1.759975012549786787901397058214341095012e-7,
1.013037477578935796479572839016964846025e-7,
4.664421812777876822952903946268451804632e-8,
1.789433119793952124110513793331700910498e-8,
5.882195227223043022918079249145011310756e-9,
1.69074170569195529228647142487067032332e-9,
4.313925247471875962296617386653883093095e-10,
9.879254784570785453362174941909565461669e-11,
2.045415720038496765211257595599815277488e-11,
3.837958745774124180054586749436744069465e-12,
6.492880270227776423881461653658094151215e-13,
9.749393595013325797676349122077587467622e-14,
1.163005481413038070454640647760039461647e-14,
0.002894828379926558739403075061193887874789,
-4.399734724381620893788737512183375087299e-8,
-5.065300252985793818885021796776443249104e-8,
-3.887636448734468341595216289588835024873e-8,
-2.237759330339636342618344977748384288817e-8,
-1.030393535898019862711934132579475463619e-8,
-3.953262721641552037253100761841468868555e-9,
-1.299719047310769458758996697618119523232e-9,
-3.737035331985710885358714475451071100353e-10,
-9.541204401324174503291758297531058998171e-11,
-2.187861665217041639790732923789785824782e-11,
-4.541740630993467407072682652057353655148e-12,
-8.567917678260543584074772928056762872091e-13,
-1.466177631910681415386598758917005711624e-13,
-2.268353605606819670048545883981360450929e-14,
-2.916296272055741115232377750502982449342e-15,
-0.000704656495512792200973326852902144922921,
8.915167958290946850824936948497761360647e-9,
1.026383333501836918504804563976265626816e-8,
7.877578919059655215504194471745432386641e-9,
4.534463750918905410146181981016227534692e-9,
2.08798110972798896476141471476841662699e-9,
8.011261093550806463580519878320959713246e-10,
2.634136366598468260370123018459406937166e-10,
7.575358651300169898217557724255422756764e-11,
1.934880167589219635074909245852010195611e-11,
4.440402875926783229135991856148028133049e-12,
9.232841038275011846648646853588029335443e-13,
1.747543500478913782859986630613621019319e-13,
3.011397805307013338936841302813327014002e-14,
4.741911926701857641911703853110966676634e-15,
6.350182917057031498328726211588003513428e-16,
0.0001533662256412499470572486099432914247348,
-1.660009187820501095630032114949182658634e-9,
-1.911135497340828558558963556663483844719e-9,
-1.466818915079589030336487675222524795779e-9,
-8.443322461443851176713436087409610145238e-10,
-3.887956634041920406529534285964518278022e-10,
-1.49179980870664117528584189511333589847e-10,
-4.905435357872623957780560350277193699363e-11,
-1.410918221629691818451280200945085371402e-11,
-3.604720846185453135133391757102213441891e-12,
-8.277112392828109148796232194627495760003e-13,
-1.722953935947745568370211994535087921547e-13,
-3.268427166421988744450461633424206347203e-14,
-5.658590042670485660370636336377561645444e-15,
-9.014194078539832611040720755627988862524e-16,
-1.238405420094970058511979043609947968501e-16,
-0.00003016605554490377884823511198471853589104,
2.850912154990071260975865869189808093018e-10,
3.282203405739335577227097633621079658169e-10,
2.519137378712152508175841647871293120447e-10,
1.450078126370345244450936829467403913587e-10,
6.677359965500061814415832590504224061044e-11,
2.562150450226520183093910614673309038349e-11,
8.425449010155354061769233344379401732699e-12,
2.423595893375435885244510292173499501747e-12,
6.193211166263264360387381363620339472858e-13,
1.42264169843923211216254038202476680771e-13,
2.963723240529283440543205448179759629322e-14,
5.6312117151137118019405094020218687584e-15,
9.781866370650754208463752535436893536352e-16,
1.571051025105353180728069931687574131167e-16,
2.196438931046176940417893184860256936383e-17,
5.410335853684108257591726508941474252372e-6,
-4.535437298166033341847528719069253688369e-11,
-5.22157269168620868510209468193494821104e-11,
-4.007639961865167481246443598058092728387e-11,
-2.306907961855820473740127823517215541882e-11,
-1.062301257273511855719930254481832863613e-11,
-4.076201232969581349795715128466635790318e-12,
-1.340479605705890116189645800201485680328e-12,
-3.856201540674958784190971437651797257093e-13,
-9.855535359113556950482866731196860476249e-14,
-2.264591840000088462619656896510171113765e-14,
-4.720562757439202519095837400901229679215e-15,
-8.980153298763753629112631036619016528908e-16,
-1.563831576127082951914631083161691323773e-16,
-2.526921492019549720683484520853357390589e-17,
-3.577924696898023789888815470241153290906e-18,
-8.915085315796443330885044716087695422094e-7,
6.712639602579005752470713955815790597885e-12,
7.728156107564255599985027041036284703839e-12,
5.931493308381732300498661397590960028263e-12,
3.414343343503704022062865005006739984339e-12,
1.572272335906066010857733920709001391476e-12,
6.033120547629394902020172917125307885271e-13,
1.984080188245920351168296474507189251325e-13,
5.708000393557448278326963032531767925955e-14,
1.45899928835229256374436900524374069104e-14,
3.353252691621017450858485552506449303487e-15,
6.993171353045670345750173909746381799681e-16,
1.331598876046899505445861905421994710687e-16,
2.323392768868339804154570944705405512247e-17,
3.771836036570966590225432516943720132358e-18,
5.392234484467787374938196545429737348147e-19,
1.358234477619485359030722287522642738995e-7,
-9.280183775562164045680797938836986672329e-13,
-1.068413699427862524895071846311637546495e-12,
-8.200271633590677751658175222752842627503e-13,
-4.720333127151626806634973687476132169466e-13,
-2.173680748943885497889677682981111241096e-13,
-8.340940938477091284172393435866736269387e-14,
-2.743104674161350340619251403444684714423e-14,
-7.892005852371755660857718284825158469915e-15,
-2.017432541344851713756427985058873849154e-15,
-4.637581131142032790386774641666914767108e-16,
-9.675262847021157500303932475652385081322e-17,
-1.843695916170087815641856611274771958009e-17,
-3.221891489009041963860017704895171155444e-18,
-5.249884908359362758122529576469798343584e-19,
-7.562001915911266398576273103715450262835e-20,
-1.924401369924565625554379701564744403562e-8,
1.203219031321074869579574417425974539436e-13,
1.385248928122319655756814372773210755209e-13,
1.063205295823612850934970370202511041863e-13,
6.120157197292600442023038073231390845439e-14,
2.81830349003578834302455291097495339048e-14,
1.081461811584886860314718475346568712386e-14,
3.556696523098329817885240920749995278185e-15,
1.023312815410799888084554927569401395726e-15,
2.616093370661993471909774277581674595731e-16,
6.0146770500157930663883648656616819192e-17,
1.25521257461991255734133218279794053453e-17,
2.393378673713370451120624736667724552429e-18,
4.187759755421769451321029627017381381042e-19,
6.844274422864107587151196689490361156911e-20,
9.918480648497502934421253874783943289042e-21,
2.585043085524568482602577549319061282676e-9,
-1.486662897747386254034599239096456665765e-14,
-1.711574680613798108111769220651743590515e-14,
-1.313667942361282787437815021023909500095e-14,
-7.561917385114113698854608045258796085478e-15,
-3.482241367339297551448007151646881384445e-15,
-1.336244166752558316635392619111524037281e-15,
-4.394692475491357771174910821740007345085e-16,
-1.264457365986008953348547005140406093758e-16,
-3.232788120755891299380890084228209544147e-17,
-7.43349223903505499535280237703396288027e-18,
-1.551713190185656225692339905674916800339e-18,
-2.960279651834229023401194252451942275429e-19,
-5.185230481087615196589014003125151047952e-20,
-8.49604611174264415860246637725689255147e-21,
-1.237477276783028489265612570114951257927e-21,
-3.205974202196005600440330380232520451535e-10,
1.710184140954667431903696954705656142519e-15,
1.968912457156055071321283343995048105849e-15,
1.511181118152521567377093939822215821613e-15,
8.698884639928435311568090188721006407642e-16,
4.005824945071850048299322572146297686076e-16,
1.53716973456974849135372684043727685276e-16,
5.055572081477360275671848369419279297388e-17,
1.454647083253469265328881234415414023678e-17,
3.719238068586050079639920482451433349334e-18,
8.552957291366777523843792780358861586454e-19,
1.785782406003109414681706577108627561512e-19,
3.408293829087798556933415487632939397545e-20,
5.975235367748625703604926932296299940371e-21,
9.810898207145197167056892160788415009948e-22,
1.434907194327953497079009654858061124524e-22,
// [{0,0.00001},{2.,0.0001}]: m=1 maxabserror=1.80127840009783264807e-20 maxrelerror=1.37889542970672242561e-19
0.1894549293637279846255434346361319074913,
-0.00003986456778897080168365878776124100901903,
-0.00004548630140657600371648893981618064946202,
-0.00003444374758833779954118944303161500762546,
-0.00001942667754715882243787419051745756618656,
-8.672795486191669090252969585138492108083e-6,
-3.173368027234253898315486656249593142107e-6,
-9.690346301145122814139857542254612483255e-7,
-2.475380359914754935704481773302584218266e-7,
-5.175786032841529348087411516561150535889e-8,
-8.130783927564069440712539898745813029307e-9,
-5.986781524288315728986098762507435060426e-10,
1.704653743137019048880766137424919019295e-10,
9.537728823481860770383759438695673314701e-11,
2.950381479599839652330172794583183274451e-11,
6.45500390333161754205847505466791441622e-12,
-0.2005319550251847625071321592601467087961,
0.00001298843258319407785238728843513594171662,
0.00001495105579046467900993654899059194301827,
0.00001147164928224154526676268920847035543498,
6.599369120581235427656169001103586452032e-6,
3.035246314615146781552123294586354457024e-6,
1.161875257991267433224316363588357273909e-6,
3.802768496165607455343958257975792321176e-7,
1.083702901290353913509766394791717409726e-7,
2.718340274680904080051520573080919215509e-8,
6.015871215863439748456679445151616072589e-9,
1.160743449115467953895922601291147824517e-9,
1.866595814603478154519047759111793953512e-10,
2.091368067748456875693804271839952411943e-11,
-7.412649507708422270421864964863648541683e-13,
-1.214130901187756771510030801056405295729e-12,
0.1334624285733343069773709320397406186678,
-4.8836094865236381505233663785585888348e-6,
-5.622168128999294195121706399550209058674e-6,
-4.31472060631557829196718839607672874478e-6,
-2.483231503866811421768755411125200583452e-6,
-1.143090325511280288996506321324899452458e-6,
-4.383088174672334530994947788380983257005e-7,
-1.439354569326123105642778692241080836077e-7,
-4.128867203725740508280625147608784564091e-8,
-1.049222960223433436653010847879407790837e-8,
-2.383203142749207932793153654970401754675e-9,
-4.852058693793803476738500949609178233201e-10,
-8.790067588464841879669888515407389184151e-11,
-1.373605780638839482536650130316268699308e-11,
-1.614543139661902727210609209555724537363e-12,
-5.329815157449122358825181265784678415325e-14,
-0.06616360014162865677486308616862733579872,
1.660988858816141696945561520583084756729e-6,
1.912226032770435252696249261586381304954e-6,
1.467598596830038452976828301066081285107e-6,
8.447150628222036368702980343191349949342e-7,
3.889111721692160660137801256952242563688e-7,
1.491776633097051205698779807075882391561e-7,
4.902291220220762951557605333102240073305e-8,
1.408247968806529282779020607030269063852e-8,
3.588861842540365366518115402313188934824e-9,
8.199048726720336532347029956476996003494e-10,
1.689247734798719433510357525471261183232e-10,
3.137830373961339448691389656575012620105e-11,
5.192930309086817521550258786764949773684e-12,
7.336858000481188238879459855447224676717e-13,
7.306634219009381193464298150086122368084e-14,
0.02624302674570416103726492848935273766633,
-4.979593573046272244351924290303001791169e-7,
-5.732847898966153142688461519618223554827e-7,
-4.399937531374446479781383911350850572256e-7,
-2.532593693947327696426002515071605458528e-7,
-1.16610545319446377423167148818739202844e-7,
-4.473582799484859467535680908381751892029e-8,
-1.470548806805753900648032622835910665866e-8,
-4.226854264229868505644284010328863432372e-9,
-1.078481311867963946839367543324254516149e-9,
-2.469813696142684762503361272063601971796e-10,
-5.113539300096217683131365615504407376791e-11,
-9.594896864435264173737451864961406780686e-12,
-1.623220067556935981617673072008793715189e-12,
-2.437348398753318065520758902155513314275e-13,
-2.907513703532575473191025535347834240314e-14,
-0.008684485139707605948324838587248587064663,
1.319920417310902129526456467512499509994e-7,
1.519590075891611772649905690975550527465e-7,
1.166290934617173423392909194167230389743e-7,
6.713277991000678191828506435821124403987e-8,
3.091180607685664287992668910446543783059e-8,
1.185978816489244033697727753942028505281e-8,
3.899157141921712861711967376885090203314e-9,
1.121110599592664532750467472986249151412e-9,
2.862361320389456999611802293215846002317e-10,
6.563584995633196662168644114743366643262e-11,
1.362522189294296266636085218409383299276e-11,
2.570375303471014826215350994827914522535e-12,
4.398532895719502864743942779049277271494e-13,
6.805060816799830299749119128200290221068e-14,
8.748888816136946449516010327355492410473e-15,
0.002466297734308051172343843802369699352818,
-3.12030878540801547122346460108165274175e-8,
-3.592341667263548861762782916646195559857e-8,
-2.75715262167634380938069379161473600207e-8,
-1.587062312824762449196006772185259177879e-8,
-7.307933884062446696739189560210402869349e-9,
-2.803941382748340826273314269509763110953e-9,
-9.219477283112920772635379276816252564619e-10,
-2.651375527960319956626071123159906894798e-10,
-6.772080586575719891941712947418690887817e-11,
-1.554141006577467965064142925981358296495e-11,
-3.231494363402716033522251449011853684867e-12,
-6.116402251688539724050219150269930651734e-13,
-1.053989231859621357931689474928084764323e-13,
-1.659669174349219536688043334116280855336e-14,
-2.222564020975215620281705699567354026969e-15,
-0.00061346490407534149512670204992751307563,
6.640036758792932941567339036054343157553e-9,
7.644541998010550377224421226732991873361e-9,
5.867275666955293848301746184722195545412e-9,
3.377328988397998381429036358491231952651e-9,
1.555182655376089063980455643331426577196e-9,
5.96719924157770939559898739501765337812e-10,
1.962174145369447902153978986344905699051e-10,
5.643672892907698470673826682074010008291e-11,
1.441888340107776802608519957937051687653e-11,
3.310844960888293279428665582471979357874e-12,
6.891815751636824236399535501321608783509e-13,
1.307370868066784405009958533601259722554e-13,
2.26343601969636995029046868914731044864e-14,
3.605677635738894006572472394172976522559e-15,
4.953621686724725198047857455569491688479e-16,
0.0001357472497851238365285827979727797014869,
-1.282910468968048485399112051717961436381e-9,
-1.476991531687593810927493949512236477172e-9,
-1.133611819733454380861965473293546411259e-9,
-6.525351564711849800481367854041237791504e-10,
-3.004811982653882148743738677627030564568e-10,
-1.152967701903091755239075653871007223968e-10,
-3.791452052271449061326052453439129994508e-11,
-1.09061815135757845593190857457156782932e-11,
-2.786945023127340386934958105049400941856e-12,
-6.401887639086865822776556677747196310203e-13,
-1.333675457425766206322904377188806238629e-13,
-2.534045270249555171859294096534841949689e-14,
-4.401839864068800550706243944170764170128e-15,
-7.06972960848655961889717780468570387935e-16,
-9.883975183101527820863430684520690337958e-17,
-0.00002705166315546007346842749285816459738367,
2.26771784780130460613289481142249752717e-10,
2.610785423337700730212017016609739434942e-10,
2.003819272890058204490199469211794102142e-10,
1.153453573353396202436656407618037659679e-10,
5.311504409486885174751201207148674337552e-11,
2.038099896258423082663377088408554817471e-11,
6.702395659761645077114526518960633548611e-12,
1.92810008875280682445594903789353438511e-12,
4.92776593680252927584462512283744131105e-13,
1.132295519190043412882825804533985525842e-13,
2.360280541708547766430208050801016018419e-14,
4.490075051295414962539485671671413827352e-15,
7.819155076841135874959278714671663767867e-16,
1.263460284826820491553261414115270889105e-16,
1.788961671566482819796519041558249868542e-17,
4.903297992198168063942296744832536550095e-6,
-3.691952279038459921328674469405145188704e-11,
-4.250486432064078525233944067498321040176e-11,
-3.262321759326034970398672013463245232254e-11,
-1.877889092043601644729143014875369675796e-11,
-8.647499013088066296834531080754157779178e-12,
-3.318216748482684792160396652860557551166e-12,
-1.091244250645734409768246354607074482985e-12,
-3.139400639757878393937440230596483310964e-13,
-8.024497168326278417909780904154655509001e-14,
-1.844289229346265243471265807844127784261e-14,
-3.846244764150279363200922212585150297657e-15,
-7.323794811352597264047483759391607596361e-16,
-1.277866197226786729591875341541770456316e-16,
-2.074510107333626330512447436845670815078e-17,
-2.965729389284637849572470786122570040818e-18,
-8.150321037184892376042599683881681856936e-7,
5.568564866285458292151669635652159988942e-12,
6.41100557283407391235467326619417098009e-12,
4.920564682575251581845223014518933967852e-12,
2.832431110522119375518396470426376254738e-12,
1.304314932731931392890952760531780475943e-12,
5.00497317791596109173970001530249766532e-13,
1.645997194696784196967231320465238757653e-13,
4.735590203190189590384626908158364992058e-14,
1.210558398615786230068780569368537986091e-14,
2.78277607513059627109764010129660346392e-15,
5.805632579959713380348551224157736963797e-16,
1.10630821590802884298590874886963135076e-16,
1.933293964540686141651270757430610492419e-17,
3.150192593748510768462830780435299508036e-18,
4.537585174102447536130004220141181334314e-19,
1.250827214223034492824121853922941448317e-7,
-7.82076686974995806390742523769935753615e-13,
-9.003937471944926592363534562961481303659e-13,
-6.910695838472943313167315626872173811799e-13,
-3.978022404031991728528595488985166474486e-13,
-1.831860532408223306805542974368391098658e-13,
-7.029360804963130882177620478855844207862e-14,
-2.311806375517931237088617910337079952253e-14,
-6.651399889206868332910408375598006866293e-15,
-1.700426577517046503226085913825558687296e-15,
-3.90946161998517897488519768274794606109e-16,
-8.15871785556171420771244075703643605382e-17,
-1.555664838759541543455828314302213174235e-17,
-2.721988891752341874698957106293502003527e-18,
-4.448687852452283401286154026307926241691e-19,
-6.446879159860781930352999228579827301133e-20,
-1.783273899973377163154020406763624825396e-8,
1.027607450840571943400579676420037344903e-13,
1.183070405374982203018399713431954838171e-13,
9.08030278780359550995181508294449064744e-14,
5.226929468678365142237239543066226029852e-14,
2.406985907737409882979838303198694191877e-14,
9.236351047862715635209466369416852456576e-15,
3.037686571397690867193070986177437857336e-15,
8.740139956820244830457154407373291301888e-16,
2.234554172780346189632011138489775952965e-16,
5.138134113482208397599106980230497661058e-17,
1.072560457800026196646628342698757304297e-17,
2.046155544395453793428874023941964441301e-18,
3.583974561237432060050817357141445504423e-19,
5.872084197290852995438786934334573394863e-20,
8.552045254939367084971882041106496794389e-21,
2.408625625949220950065586478708677128299e-9,
-1.284568454183259212507993106184643169239e-14,
-1.478906729100444679593100394132078292062e-14,
-1.135091568395977184925230829796111371425e-14,
-6.533982280752643032223455997979151722389e-15,
-3.008890277919746601747319687365959028391e-15,
-1.154612397654256781054067250206186275558e-15,
-3.797385714441278216332942662918674427457e-16,
-1.092627366566976410861016142759673223474e-16,
-2.793627312153995179358682525187645904629e-17,
-6.424375324340221227542865747522428438319e-18,
-1.341353872328482528046527190400539865241e-18,
-2.560072746928934532623795106746568933144e-19,
-4.48818981456648172522343283999045554401e-20,
-7.369315372837987734871801382283250420109e-21,
-1.077820612938244094921642295615532725437e-21,
-3.001025519117535849453638569215429863138e-10,
1.492316087323331214991420753480852800365e-15,
1.718084456416129502709406164395887626064e-15,
1.318666376688466280556896630565477009713e-15,
7.590713674218678732586756438233472199519e-16,
3.495523721033714822250053839207100843542e-16,
1.341357708377139884148417276958499111258e-16,
4.411619897749910010791822565656980246708e-17,
1.269391002475235088906507565196023435772e-17,
3.245725300402159117159850499117542378821e-18,
7.464731318045573776647942850954642898802e-19,
1.558859112731317676456624743095756968406e-19,
2.976295366258916174180627742756629443709e-20,
5.221822081249976266686837758671205652818e-21,
8.589137816140633758290692087278011425469e-22,
1.260638056526050590183987609651371480361e-22,
// [{0,0.00001},{2.,0.0001}]: m=2 maxabserror=1.65070285372490542027e-20 maxrelerror=2.7875109610681776355e-19
0.1002659775125923812390102708710608575376,
-6.494216291597038926129905177789628050302e-6,
-7.475527895232339504894892509885386763331e-6,
-5.735824641120772633325022303387830239056e-6,
-3.299684560290617713795663301097198242983e-6,
-1.517623157307573390761131614997020212615e-6,
-5.809376289956337166064289399633575509185e-7,
-1.90138424808280372765313575205519883876e-7,
-5.418514506451769567494610380301206708546e-8,
-1.359170137340452040011895248196678957706e-8,
-3.007935607931719874196447225988173381138e-9,
-5.803717245577339769412991933048389980458e-10,
-9.332979073017390772467964386989493517547e-11,
-1.045684033874228437824544914021421192495e-11,
3.706324753854211135579734302066907740151e-13,
6.070654505938783857604588939092124750209e-13,
-0.1334624285733342985819263762480700968107,
4.883609486523638111422686876131638760394e-6,
5.622168128999294150105579365881220092424e-6,
4.314720606315578257416331600443612702363e-6,
2.483231503866811401880026030323327415363e-6,
1.143090325511280279837723480384548164514e-6,
4.383088174672334495849241375705573097401e-7,
1.43935456932612309408351758921994355407e-7,
4.128867203725740475019568293530723346372e-8,
1.049222960223433428148101532435857393274e-8,
2.383203142749207913231445858474671823278e-9,
4.852058693793803435881265143418441158527e-10,
8.790067588464841801637134118497837978843e-11,
1.37360578063883946883710736729035638218e-11,
1.614543139661902704642262053186474702589e-12,
5.329815157449122026588230346329350492116e-14,
0.0992454002124429916843654741170495655728,
-2.491483288224212573977611589837397928799e-6,
-2.868339049155652911924315152778646228534e-6,
-2.20139789524505770470132639502486199944e-6,
-1.267072594233305469832270332671588722381e-6,
-5.833667582538241057103036540631130279104e-7,
-2.237664949645576834218929936650612726071e-7,
-7.353436830331144511767092966024940817686e-8,
-2.112371953209793948463360485098761735867e-8,
-5.383292763810548111901637499790251538093e-9,
-1.229857309008050494141984700364106670003e-9,
-2.533871602198079180116147674878333347281e-10,
-4.706745560942009230064372909128141151316e-11,
-7.789395463630226382500429866025314989623e-12,
-1.100528700072178252356668719823213378577e-12,
-1.095995132851407203410094593232629389149e-13,
-0.05248605349140973293733937569907722232152,
9.959187146092610195536127206784304984682e-7,
1.146569579793238193283745013197125278071e-6,
8.799875062748951020634400897802526849301e-7,
5.065187387894688814915855332740246703066e-7,
2.33221090638894293936234801902640344069e-7,
8.947165598969777995759713722172506132422e-8,
2.941097613611527226084760059799666371036e-8,
8.453708528459792904913697007124973283036e-9,
2.156962623735942185774849725107291997368e-9,
4.939627392285402397528641676003153963734e-10,
1.022707860019250402491405872323106647837e-10,
1.918979372887065947784458888145435799846e-11,
3.24644013511389498467858482430399696521e-12,
4.87469679750667405612303042019276146128e-13,
5.815027407065206777365674747134698223676e-14,
0.02171121284926854522185697025436188943104,
-3.299801043277234758801119962610587658943e-7,
-3.798975189729005755371753820820274920441e-7,
-2.915727336542915386433127093396363254672e-7,
-1.678319497750159087453537947604382903241e-7,
-7.727951519214112549136920304964054432942e-8,
-2.964947041223091599192591106532617620347e-8,
-9.7478928548042213572654206055989188721e-9,
-2.802776498981643837607215026383432220488e-9,
-7.155903300973597764321958294519533987242e-10,
-1.640896248908288875620737105197050180234e-10,
-3.406305473235719171701901318003918525227e-11,
-6.425938258677496001211605599371980885069e-12,
-1.099633223929868502760266769692233411196e-12,
-1.701265204199945675757308826043400143515e-13,
-2.187222204034219049238837523254547850439e-14,
-0.00739889320285641565798055300709217912036,
9.360926356192500339372792586339311612589e-8,
1.07770250017543279814579837196130596176e-7,
8.271457865001156109600252336013955918756e-8,
4.761186938458241300721177001292937449693e-8,
2.192380165211344785900115282527480264665e-8,
8.411824148216667240794077624682568247314e-9,
2.765843184924550324417067962881641536425e-9,
7.954126583854125149429241070937090603976e-10,
2.031624175965854283295584317069914482243e-10,
4.662423019716621684402412761763445382137e-11,
9.69448309017518484414156748204225813057e-12,
1.834920675500266302012114588817187262178e-12,
3.161967695567811395312151505644469575128e-13,
4.97900752302945063084133773786243992575e-14,
6.667692062898842159815529058143191601686e-15,
0.002147127164276220482245984357425145275986,
-2.324012865583011033089776620931255925488e-8,
-2.675589699310006874607488708360800613084e-8,
-2.053546483439199168087541313508050045316e-8,
-1.18206514594208915521601063985703618792e-8,
-5.443139293829158452636446500150374901393e-9,
-2.088519734557128084605588709266995732117e-9,
-6.867609508809281671573494299158592134483e-10,
-1.975285512522360028093370206253925560072e-10,
-5.046609190389149151232113018223669233295e-11,
-1.158795736313646876852235522686578089287e-11,
-2.412135513078620975321825363797203906482e-12,
-4.575798038244696903077179399696688301084e-13,
-7.92202606895653238340551636926500973768e-14,
-1.261987172511786307182601913523388231099e-14,
-1.733767590358337753579835483281814712897e-15,
-0.0005429890005600467306962168733871739569821,
5.131641882483012636796191173872767514943e-9,
5.907966134361328763376510049070349261846e-9,
4.534447284775389925211256900962232710434e-9,
2.610140629247361388640475761041961545371e-9,
1.201924794610043931978410581676194292856e-9,
4.611870813554511720297183634968203653262e-10,
1.516580822862923692308514103104251643084e-10,
4.362472611053817781282995576940314872306e-11,
1.114778010688875829332070934548083094628e-11,
2.560755058942078264544099121031825862233e-12,
5.334701836610869896969667764114751416645e-13,
1.01361810941913609831233483300562888789e-13,
1.760735947943728577087607798137297576061e-14,
2.827891847210304585028210365968869379685e-15,
3.953590078857833620449927519702911864569e-16,
0.0001217324840420969149050233322029544702663,
-1.020473030821055239026854210185639873111e-9,
-1.174853439708115669911431284143858909282e-9,
-9.017186721912289773017718686841346352949e-10,
-5.190541076582942791053090457352883350331e-10,
-2.390176982653960633994463524256177524773e-10,
-9.171449526964983942754602989589017854538e-11,
-3.016078044854255165819993877318137066985e-11,
-8.676450393521913882740016390413280141213e-12,
-2.217494670061211940896243132171410682844e-12,
-5.095329832905050218977802649827083210353e-13,
-1.062126243048136547450773034485960688115e-13,
-2.020533771706075842276509941339979487065e-14,
-3.518619782159894767608042995874607551495e-15,
-5.685571277730970370864300840132956156442e-16,
-8.050327516160355608660026928380078144467e-17,
-0.00002451647481660272069021555029234937585298,
1.845975434261662442111076531108783178273e-10,
2.125242404077754375348091160917863597396e-10,
1.631160256470439768350538665457663327767e-10,
9.389441872894942937963308208930756842871e-11,
4.323747854577614637278897498797527504049e-11,
1.659107740319475909223419224690104322612e-11,
5.456219168288797861708210354036758750333e-12,
1.569699719950406472846135589077847641494e-12,
4.012247050135504611311698919297166497671e-13,
9.221442618392291231460533500601423682374e-14,
1.923121645134315471417400166820739523976e-14,
3.661895998201082700394175907285606188393e-15,
6.389328515148029027822997625644258263741e-16,
1.037254646600808771961059880755945274327e-16,
1.482864095383069633368541502306714954019e-17,
4.482677578351634038379694503999760650827e-6,
-3.062711117784786186253268811249098806208e-11,
-3.526053573154079642890953554407672865012e-11,
-2.7063109653908268418041367480948301294e-11,
-1.557837335270875889367588289740441000008e-11,
-7.173733163777953248108159641607823725411e-12,
-2.752735644545292628490750440728718780881e-12,
-9.052985875543826129988941853706526463038e-13,
-2.604574987183800189110279417406934485696e-13,
-6.65807215239924607578324934893186150431e-14,
-1.530527062144835175806725328801512591196e-14,
-3.193098380260871989301764109380115793258e-15,
-6.084696068739913222984073791705422329613e-16,
-1.063311835298458085883016448284493576813e-16,
-1.732606181919803915101575082229594469583e-17,
-2.495672222664246334334973404649112799091e-18,
-7.505822505509944710416585730318677039345e-7,
4.692860244954793756037180274546254811881e-12,
5.402823139931836730844805089982352279326e-12,
4.146771067172445107612712180370869561099e-12,
2.387016966764004274409414781411407498131e-12,
1.099210042641040564358664245226868841522e-12,
4.217976134256522650917451464103378060594e-13,
1.3872021129630414753484233312250944034e-13,
3.991180298917104293246769038237992086358e-14,
1.020342978530622578645589621873003094279e-14,
2.345877149923331643453900756037630009161e-15,
4.895648811750284554181721526658773411165e-16,
9.334787554193760889642989670981418088648e-17,
1.633333524800331924624493237725424607829e-17,
2.66944365774561619085158966250337405706e-18,
3.868467481998276725613482995026981233141e-19,
1.159096268994194901499062059943402247261e-7,
-6.679309338033673649139390705210591826518e-13,
-7.68979749950531311587065203479945029744e-13,
-5.902073904577597255804886331753358387604e-13,
-3.397433404541147811247296326744416306579e-13,
-1.564508259455659308420845414749301692555e-13,
-6.003503156608140588415609482214812205252e-14,
-1.974455151066282724773015272818047191826e-14,
-5.680972648634229333940834301574602803655e-15,
-1.452429955779937076283372491413726249741e-15,
-3.339717577399544653680043291698899747644e-16,
-6.971497594010175650796800321187907559923e-17,
-1.329973329802504494010545204009483499365e-17,
-2.329534676440241589144072480800436882044e-18,
-3.816774247492556869109130546352125079897e-19,
-5.558710626318934102749537233159078440866e-20,
-1.661359934880510031419267077919588718138e-8,
8.877059791001564668440234158039842834327e-14,
1.022004183816599188578232369499645383259e-13,
7.844093809146993372147993345483239394175e-14,
4.515333353487498208157352065617142074133e-14,
2.079304948025631899826491920751816810317e-14,
7.978991311490250470627242468851438939519e-15,
2.624196594113246739314612106320604662808e-15,
7.550635194108300120497138589881159988966e-16,
1.930542644764224023527915433398100197268e-16,
4.439569605836847460698811989905570114851e-17,
9.269395021549165050436791869639281764303e-18,
1.769116574102504725350876533435440573709e-18,
3.101468952312059055553104283160526781042e-19,
5.092190630637168557451259479495231055362e-20,
7.447096761679884844119419521547505177472e-21,
2.254678996656599478771467687462058304486e-9,
-1.120949049448732539197711241248968233829e-14,
-1.290534328730620585020441773703196743848e-14,
-9.905125582945991500381914103123409122488e-15,
-5.701743352554734176463553868805787648091e-15,
-2.625652888189309319516919180045873970416e-15,
-1.007557113717496669222107161360131806241e-15,
-3.313776116521687565950559674809302091839e-16,
-9.534996042249743338710241166629631232499e-17,
-2.4380180233710715873301084539449739304e-17,
-5.607114580851380399331678581363267351942e-18,
-1.17093372830584575637461561463360652911e-18,
-2.235640024015170797744300883806214344224e-19,
-3.922371553704736412567548923471558578847e-20,
-6.451759132837236799276330738626447080729e-21,
-9.46940632099566268022823027617792362245e-22,
-2.820636683608052846880742356312200062713e-10,
1.313485684127351882451256919090004271659e-15,
1.512199767375895660016093756984805387966e-15,
1.160646219751544566575123682522925486238e-15,
6.681101647197713084504937332750233650704e-16,
3.076655035961402093630435451540548039717e-16,
1.180628665473479868955536848358954446561e-16,
3.883033421650493863499977299517963354472e-17,
1.117318823761357729106067538367927690313e-17,
2.857003618171150045164199384872223631706e-18,
6.571249167792003549356806059311984102089e-19,
1.372493443039115681190623651032121899637e-19,
2.621310653550223306747543189143060300591e-20,
4.602016325695676228202894690639479912379e-21,
7.581289398959530175565208755319460061848e-22,
1.116075770046034098357381129991138709501e-22,
// [{0,0.00001},{2.,0.0001}]: m=3 maxabserror=1.55088436333127525492e-20 maxrelerror=4.28888668422004594433e-19
0.06673121428666714927718897976215305449226,
-2.441804743261819055654431882013050286307e-6,
-2.811084064499647074987268081216166752454e-6,
-2.1573603031577891286578764939877131743e-6,
-1.24161575193340570091106460273568567729e-6,
-5.715451627556401399055309082087509306392e-7,
-2.191544087336167247873464834899761103131e-7,
-7.196772846630615470249335940673701953167e-8,
-2.064433601862870237461369087353430608818e-8,
-5.246114801117167140616701394907529236689e-9,
-1.191601571374603956587243135098845447297e-9,
-2.426029346896901717881133027496633991485e-10,
-4.395033794232420900704869751514061460945e-11,
-6.868028903194197343985714064694160213284e-12,
-8.072715698309513522881296993728578702312e-13,
-2.664907578724561012805899815849947442187e-14,
-0.09924540021244298376516532121892878700803,
2.491483288224212539300287819787789181875e-6,
2.868339049155652872000731805264915902398e-6,
2.201397895245057674059090976963105926217e-6,
1.267072594233305452193466316357238775187e-6,
5.833667582538240975875963468140315423129e-7,
2.23766494964557680304890056694864706199e-7,
7.353436830331144409249407281323361139794e-8,
2.112371953209793918964017925487917663214e-8,
5.383292763810548036468679822331218573379e-9,
1.229857309008050476790821925346392459822e-9,
2.5338716021980791438708474262935623317e-10,
4.706745560942009160820526778973269483887e-11,
7.789395463630226260865594587942324312086e-12,
1.100528700072178232291940533337792170258e-12,
1.095995132851407173794660455123466939761e-13,
0.07872908023711460557787108890760029721133,
-1.493878071913891554830570993187311000637e-6,
-1.719854369689857319283640977326468740294e-6,
-1.319981259412342675628104894917848245298e-6,
-7.597781081842033352081871476387290568192e-7,
-3.49831635958341446877449137417015896177e-7,
-1.342074839845466722285172262926585488247e-7,
-4.411646420417290914515198537077284312762e-8,
-1.268056279268968957430212581477947804934e-8,
-3.235443935603913334135694929631959944185e-9,
-7.409441088428103723901334088281688080703e-10,
-1.534061790028875630396852705873117418241e-10,
-2.878469059330598972620629701963858696753e-11,
-4.869660202670842566551754881991424410821e-12,
-7.312045196260011232052460356796745447268e-13,
-8.722541110597810384801616731101178614217e-14,
-0.04342242569853842127563929523219478562989,
6.599602086554527791397478177765685914665e-7,
7.597950379458078600659006458103981250501e-7,
5.83145467308588226586395196370578669095e-7,
3.356638995500347816181044995489508536075e-7,
1.545590303842836159698014759787994481173e-7,
5.929894082446235578318768257355011621942e-8,
1.949578570960861499122410647979522422028e-8,
5.605552997963337247629140078602278455054e-9,
1.431180660194732229058487993523288155855e-9,
3.281792497816606909148161488673437423672e-10,
6.812610946471499252125796402998708474417e-11,
1.285187651735510836384607308193463892909e-11,
2.199266447859757445757396009010593226547e-12,
3.402530408399925069490605179909420816842e-13,
4.374444408068487866093236523299467844016e-14,
0.01849723300714059471393514764646226833195,
-2.340231589048106722619381232230488851354e-7,
-2.694256250438560855153275573207527619995e-7,
-2.067864466250272801811430333735250521174e-7,
-1.190296734614550985122397881923221570256e-7,
-5.480950413028318953499513393391275115989e-8,
-2.102956037054150305022950316658734365982e-8,
-6.91460796231132152538934697348988855769e-9,
-1.988531645963515666484667098018475530702e-9,
-5.07906043991459576277605546901980646296e-10,
-1.165605754929146232239518883473082810474e-10,
-2.423620772543777013808277883776276434684e-11,
-4.587301688750629071164793574545339526956e-12,
-7.904919238919464016452027544855568805404e-13,
-1.244751880757352009989900374344865430856e-13,
-1.666923015724694787902896624782832433462e-14,
-0.00644138149276476590838242924601632211139,
6.972038596721055573869535803303209872013e-8,
8.026769097897810437280650828537000663724e-8,
6.16063945029287547190591707279134934749e-8,
3.546195437812036549461161459155370647348e-8,
1.632941788142194168170393329116216995254e-8,
6.265559203646236399264968339833003021025e-9,
2.060282852634513415691675844277501814299e-9,
5.925856537543280132630802303761895343173e-10,
1.513982757110658844326160395015301137388e-10,
3.476387208926941780595267528785843643715e-11,
7.236406539206620356769094641081859094866e-12,
1.372739411467822502704518982453287669506e-12,
2.376607820677146256364599545679601308848e-13,
3.785961517519170746911942327962512635754e-14,
5.201302771051119548530544813802168868935e-15,
0.001900461501972016266407131063533813486029,
-1.796074658873951467065404504919969167604e-8,
-2.067788147032102976266164018883315998729e-8,
-1.587056549675713696130536293495491999368e-8,
-9.135492202390673976203411659373240537377e-9,
-4.206736781146624485611758045717017287324e-9,
-1.614154784748480887801147354538883586486e-9,
-5.308032880034710431158433073140711262444e-10,
-1.526865413873002173319447248280142334021e-10,
-3.901723037421718507684462670736279886233e-11,
-8.962642706321779813677389154930471423322e-12,
-1.867145642818924196383872265553495237166e-12,
-3.547663382976759610312094924321110134676e-13,
-6.162575817820244094119925431773313315119e-14,
-9.897621465264462594495800325517968484895e-15,
-1.383756527604442704020564376856399004281e-15,
-0.0004869299375074189045446728804526267482697,
4.081892129147225194983761851632053472825e-9,
4.699413765582468534213511741271035152815e-9,
3.606874693945695069083504343136685830784e-9,
2.076216433615425216696378738528008943572e-9,
9.560707944349159416471018486384070484272e-10,
3.668579816056008565864349711913610119431e-10,
1.2064312196750008675806008665313957949e-10,
3.470580162396312408805485767451946190585e-11,
8.869978692998536248054385750947892312893e-12,
2.038131936095636227259803742960985494076e-12,
4.248504978320655053587144194930312691243e-13,
8.08213509853158559603678296853002661098e-14,
1.407447914920478924294556813159202299447e-14,
2.274228514484804191489584567987571680452e-15,
3.220131011471345169205973169547686256135e-16,
0.0001103241365256942575677745989934402331457,
-8.306889448020732738916032130513922928798e-10,
-9.563590811261703206681298806054389384172e-10,
-7.34022114867663221931275395662740132135e-10,
-4.225248839671056517878997280778324700446e-10,
-1.945686533117784034369443783879226728261e-10,
-7.46598482590355094776095202381461156413e-11,
-2.455298623909792232899078490813356097932e-11,
-7.063648734539240146031845920261091304541e-12,
-1.805511171221628608608556626486954389739e-12,
-4.149649175195558568060115387958070735693e-13,
-8.654047396667699111291252034575476244417e-14,
-1.647853197960498090230032012756486250124e-14,
-2.875197829654909057936879158942563450862e-15,
-4.667645906133517746582310455193945371835e-16,
-6.672888423942234443417426914393972610442e-17,
-0.00002241337360637931617612973196099283789926,
1.531354933412235338537498944030045928528e-10,
1.763026066469300678305736204085188795554e-10,
1.353154929996756752839757062192647031849e-10,
7.789183494816490160604195970660584551811e-11,
3.586865116783909732344119980848051586013e-11,
1.376367260054084102082537133358526785197e-11,
4.526491088644796531770817911882836811566e-12,
1.302286961507751129788842863073444279498e-12,
3.329034715603775352191776837997480364251e-13,
7.652632181067988770331668483623518867022e-14,
1.59654853636819945530553649143373731103e-14,
3.042346785407232167904164582904938304672e-15,
5.316556982542913516364967672359853070395e-16,
8.663027290481362165043853485175457697367e-17,
1.24783557715034870038389882737508313225e-17,
4.12820333181225979333944561399650307187e-6,
-2.581073528781781225500287720083813764413e-11,
-2.97155318063526709273922726421351038154e-11,
-2.280724435148912017160707926250757544862e-11,
-1.312859532159534463547265477616976989324e-11,
-6.045656157554946337694435751564918230302e-12,
-2.319887228045141817981808353401089843541e-12,
-7.629612786276674997293841967647066571752e-13,
-2.195149499631163907183787764803894795131e-13,
-5.611887239155304213536454939923520893835e-14,
-1.290232629652462832861201620260591157108e-14,
-2.692607258438662280319798199064605504837e-15,
-5.134133942049107974603585717695331215105e-16,
-8.983335769979457151334291682868671063092e-17,
-1.468194240262287466440691869096041002128e-17,
-2.127657453141498773033894891366802405597e-18,
-6.955388098750047540650353725735814699758e-7,
4.007940465319148345892198017630378267328e-12,
4.614287048605447674803460505335239597082e-12,
3.541557913087791783422323130724883897561e-12,
2.038640545410877988650504631611139404473e-12,
9.387880775501252819855645083380561850687e-13,
3.602420865369202261664295493007342946084e-13,
1.184777999782555373885969260721750122604e-13,
3.408885464003866077466267615270427714019e-14,
8.715351660764888175885346177409526486712e-15,
2.004008105653082707604896992346862465542e-15,
4.183269464598280777904589985752011819975e-16,
7.980548570574314912192467275718799258648e-17,
1.397845278324675626279856762407082252509e-17,
2.290269877119158821607788600438540334876e-18,
3.335529441009969741195396282464970882121e-19,
1.079853897316298728114371727090260629106e-7,
-5.769964669999972875546568107045876871368e-13,
-6.64288421154988170153218086189564002507e-13,
-5.098551233072012500974769218535650496963e-13,
-2.934903507649289515859568261814651959187e-13,
-1.35151912526429160164324709198508198962e-13,
-5.186232718589490724694833263154455989898e-14,
-1.705691069702097224174132825625914487839e-14,
-4.907807223333133733825163757756975299954e-15,
-1.254825701710137648037788910592140912875e-15,
-2.885658094302710258939563770832156161971e-16,
-6.024976922239007771481824884223801223451e-17,
-1.149900961778598157157214259954135761974e-17,
-2.015911213022084616845706579609340875707e-18,
-3.309851893257545158391745273620375274995e-19,
-4.840506354796384896602201509687509884581e-20,
-1.554997025721341270267494987921440508271e-8,
7.744723120370819118243856788556082406831e-14,
8.916400778109074168463717245636813179731e-14,
6.843527222379266081491010094203868539832e-14,
3.939378085096560924846421729269346413785e-14,
1.814083548276860561903041779321082682242e-14,
6.961287868336903199330466831977867175962e-15,
2.289512277069576109003921396963989323302e-15,
6.587795618583155267337919100424103445669e-16,
1.684442090563603073597536891924384111557e-16,
3.873983339867694451010690572834672611829e-17,
8.090007375901343439457228688696760204907e-18,
1.544596517413317936314426567177704874451e-18,
2.709910286226468134720343434653753543894e-19,
4.45725883601010716779137147574579051725e-20,
6.54154084100189741145288314627300079079e-21,
2.119177436461979155553241961947510939564e-9,
-9.866428761507143838476885563718572018993e-15,
-1.135909699672855414778781171402421807271e-14,
-8.718354078864755769232851993636729470577e-15,
-5.018601619574158394897985534565344222768e-15,
-2.311071865043683705369713480206901679622e-15,
-8.868455171548144164997362245810844825448e-16,
-2.916794222517700812545743534504509094547e-16,
-8.39289519694827674267556993938635168779e-17,
-2.146078081991762863277703108078460607011e-17,
-4.936086392651365500224778532950568163744e-18,
-1.030968207663477197004125543220756583355e-18,
-1.969036838735521949050073568236084907048e-19,
-3.456879379195844619109803432076745594163e-20,
-5.69483104312480430928706768597279209256e-21,
-8.383681529139456421499866250489249378729e-22,
-2.660652429013054925797259577878304507561e-10,
1.164911495230914247065115373478691263397e-15,
1.341148512637607117041125224429004275381e-15,
1.029361220904103093358917469100480382874e-15,
5.92538391128488542774698930448319549265e-16,
2.728652087164831913843955488875067993867e-16,
1.047091359881580777100434221231559319319e-16,
3.44386536903178506443753832279203602643e-17,
9.909682114534256484604060360813503000476e-18,
2.534011324948350065646871089507075384161e-18,
5.82875843448690289368282765925628444877e-19,
1.217585004027174845224408354510409000217e-19,
2.326103329928734008543798167828565904035e-20,
4.086074335290836454317773063787503060069e-21,
6.740353580528177763666015879996627250307e-22,
9.948776160310093191440443177040513752726e-23,
// [{0,0.00001},{2.,0.0001}]: m=4 maxabserror=1.47097374824824962845e-20 maxrelerror=5.77651861687830363706e-19
0.04962270010622149186951055843113384482768,
-1.245741644112106269599020656161063994255e-6,
-1.434169524577826435941508292392284228351e-6,
-1.100698947622528836984370926654891374504e-6,
-6.335362971166527260707289624468638776395e-7,
-2.916833791269120487818231417355128293099e-7,
-1.118832474822788401478497033847139198177e-7,
-3.676718415165572204473562007029052633903e-8,
-1.056185976604896959438516874266434545841e-8,
-2.69164638190527401812311955193541204265e-9,
-6.149286545040252383698249690524558919401e-10,
-1.266935801099039571881963984265718326696e-10,
-2.353372780471004580308085165917049392373e-11,
-3.894697731815113130253139289289356018843e-12,
-5.502643500360891161162682601740679103276e-13,
-5.479975664257035868533006394373746063847e-14,
-0.07872908023711459808390231286053795910088,
1.493878071913891523867716537249199728766e-6,
1.719854369689857283636472656865897472615e-6,
1.319981259412342648268099690468161793589e-6,
7.597781081842033194587411109192165980817e-7,
3.498316359583414396247813252898947156471e-7,
1.34207483984546669445372042236388726884e-7,
4.411646420417290822977332944407954919783e-8,
1.268056279268968931089895264776402120807e-8,
3.2354439356039132667786283161000839542e-9,
7.409441088428103568956398564606427536158e-10,
1.534061790028875598025996440103941746613e-10,
2.878469059330598910763360013403851428866e-11,
4.869660202670842457837728768663548989636e-12,
7.312045196260011052507967137059080149558e-13,
8.722541110597810119186810978556258545963e-14,
0.06513363854780763777073034554671705066778,
-9.899403129831791916162654808805813149559e-7,
-1.13969255691871181647100476618153530604e-6,
-8.747182009628823601208239198658249445914e-7,
-5.034958493250521840787791417629773590137e-7,
-2.318385455764254293203189272689475569578e-7,
-8.89484112366935357337950714430638645753e-8,
-2.924367856441292316405196995523402473223e-8,
-8.408329496945006066317414545213275359563e-9,
-2.146770990292098393421907169986593731522e-9,
-4.922688746724910478364643568255497112368e-10,
-1.021891641970724911772411992928458131027e-10,
-1.927781477603266300359607793285369139869e-11,
-3.298899671789636249134938122177058571822e-12,
-5.103795612599887737320866960947229240071e-13,
-6.56166661210273199642211380004209273942e-14,
-0.03699446601428244880121295411113741948339,
4.680463178096265477186922675227460680113e-7,
5.388512500877181614073400371912648941592e-7,
4.135728932500591581114211226803924150297e-7,
2.380593469229128436614733957346504550366e-7,
1.096190082605675978543784808448456546702e-7,
4.205912074108347379786282640471983997708e-8,
1.382921592462279687682588239632419543775e-8,
3.977063291927075596912972955560925649237e-9,
1.015812087982930471665026472748122281638e-9,
2.331211509858318502412083850817657797356e-10,
4.847241545087608425666647105837863492526e-11,
9.174603377501362091240052201696782222183e-12,
1.580983847783911072294603435776291754357e-12,
2.489503761514734191807719625251946137601e-13,
3.333846031449434211497813936080773509045e-14,
0.01610345373191149299310029962628629893737,
-1.743009649180247398764769884948032938406e-7,
-2.006692274474433619159977417642982042464e-7,
-1.540159862573204292594263561732161911884e-7,
-8.865488594530007472209962695214502638712e-8,
-4.082354470355446783490327243819132478494e-8,
-1.566389800911544273193645408535294477871e-8,
-5.15070713158623477401703168310787856634e-9,
-1.481464134385806000618261328937444151596e-9,
-3.784956892776611226033795459356390399537e-10,
-8.690968022317271899352726351256954482015e-11,
-1.809101634801637840634085162523982680977e-11,
-3.431848528669523289381071907603845826613e-12,
-5.941519551692807674989474269951087996008e-13,
-9.464903793797831034923033115914041156651e-14,
-1.300325692762765681146110555298905448506e-14,
-0.005701384505855584029930806610394418791913,
5.388223976596873553353747341170192016276e-8,
6.203364441067548773972525058666847948469e-8,
4.761169649005067021274671247907570323635e-8,
2.740647660704495531201058624515770774772e-8,
1.26202103433813588932412854436521122804e-8,
4.842464354222988232757425197187986759178e-9,
1.592409864003027849271612026187381612569e-9,
4.580596241597755137056923368221318417432e-10,
1.170516911221081180223658702431431185758e-10,
2.688792811884032976981783307295678911746e-11,
5.601436928430655759308142068028463688676e-12,
1.064299014888037233151762742239352565806e-12,
1.848772745337302167404239350418445236508e-13,
2.969286439564853092615399794661565031326e-14,
4.151269582791898215375383996304908177975e-15,
0.001704254781287214734359883106534333160843,
-1.428662245205927815099275299853116857781e-8,
-1.644794817958928501133464284650426772571e-8,
-1.262406142884880404613364499821875732367e-8,
-7.266757517676364059465469940996985700065e-9,
-3.346247780532509937797538777263075351194e-9,
-1.284002935623557132162519364311148693965e-9,
-4.222509268875508303761740043367938897304e-10,
-1.214703056842451701981546256334588901475e-10,
-3.104492542559057852858017711328719800032e-11,
-7.133461776356742747981399766482978811075e-12,
-1.486976742416829312637597579896296563398e-12,
-2.82874728449484707904971570841887813313e-13,
-4.926067702237135255432577330446481255553e-14,
-7.959799800722372352229235869907025414558e-15,
-1.127045854018759427326411805068074627278e-15,
-0.0004412965473699125136281269801200426647921,
3.322755784443320712530394931987731311371e-9,
3.825436330531706696002288793989574669689e-9,
2.936088464096530749432512575246543761132e-9,
1.690099538531251553660873994493801942142e-9,
7.782746144733544470280878091386748804541e-10,
2.98639393506700785803760796206536123825e-10,
9.821194511115883564248125414433198330096e-11,
2.825459498269170901183398066058146208515e-11,
7.22204469627487428390560772919632119065e-12,
1.659859672697946783830190042516061828445e-12,
3.461618964140165930020253787473171984237e-13,
6.591412802300482139168570027362134379959e-14,
1.150079133700042131787533169369553997383e-14,
1.867058365489053257967152017848004645295e-15,
2.669155374067784293619516574158507167449e-16,
0.0001008601810872844251445566032932740092001,
-6.891097194824470292957035764419689173038e-10,
-7.933617292744550265886401912832074721445e-10,
-6.089197180098354888885661756884335625547e-10,
-3.505132569854248453594768414553082330529e-10,
-1.614089301257282849210257671715316106385e-10,
-6.193652665272088347737123461676301905388e-11,
-2.036920988255086015439899370765977830757e-11,
-5.860291322079841933193591694867801493296e-12,
-1.498065620818500666678104468490970792633e-12,
-3.443684478712664327059755549509501492296e-13,
-7.184468407873544568081110359371965615434e-14,
-1.369056052327875077516439497991091102518e-14,
-2.392450640200743114724883000049588951218e-15,
-3.898362277503401691436107435577485981173e-16,
-5.615260092413369732485602914774268326608e-17,
-0.00002064100314068597334071013472787791743526,
1.290536205903913650041288040299926559395e-10,
1.485775947338178678768580795693554511874e-10,
1.140361724073230746170549971491585275046e-10,
6.564294820019365212450192310488800680438e-11,
3.022826770590417170348910346681328194916e-11,
1.159943112017706144975366754544046419289e-11,
3.814804742040342606710658414130769419628e-12,
1.097574274706775832859828582397480837129e-12,
2.805942404636446669734126971049655454997e-13,
6.451160353470136473430980590641810766869e-14,
1.346303045335571884392986420608208279277e-14,
2.567065855284295208976890243341446180324e-15,
4.491665924077116373275915051226748320447e-16,
7.3409679627998168696793624771748233231e-17,
1.063828247469801400261705992780403029282e-17,
3.825464359480107950722496330341398147414e-6,
-2.204367609905680069196134182656977814746e-11,
-2.537858284266243705192098165964853508084e-11,
-1.947857164989372587652660194211688469037e-11,
-1.121252480030427900942363003924094975049e-11,
-5.163335255683301502925157004961376682984e-12,
-1.981331794135826020619749758677945120461e-12,
-6.51628004531683721986890304924476593478e-13,
-1.874887306343684550570871084807631642761e-13,
-4.793444183516451421959385258328232124642e-14,
-1.102204635268002800954856961614123508739e-14,
-2.30079857568715058767003147220849474857e-15,
-4.389302421303630758210878544830276449709e-16,
-7.688150274748296966313031072698218347483e-17,
-1.259648638074156731873475116227460706579e-17,
-1.834541497419727580123441387394786127569e-18,
-6.479890353124228034450143808097992881427e-7,
3.462295656770344396238579585126925866439e-12,
3.986095318081617366897895710306429890488e-12,
3.059410725275057186906301116554195065831e-12,
1.761103274714499866279248986687663103164e-12,
8.109856944916363849523592110453906441659e-13,
3.112024441082948521648687513174260160078e-13,
1.023508316033780370892303004286220114986e-13,
2.944953884587184845618291625007013127454e-14,
7.529643501036756220148548070426136808177e-15,
1.731553417710799543760206632965878920787e-15,
3.615317416867615949537190315932156716043e-16,
6.900038780348363554473934410569642255261e-17,
1.209657979225246497447336158236246483844e-17,
1.986094871363700426482828671371556968981e-18,
2.904575628644042864611131673512333584708e-19,
1.010719538529281523759082896617528849831e-7,
-5.033958464868375382919916369223194179564e-13,
-5.795532064151345679763658689073019408843e-13,
-4.448194112666248941986551336532530000663e-13,
-2.560539007833461194235248356850856536547e-13,
-1.179128173948484363009361482139812766162e-13,
-4.524736833251995791415680999786707654774e-14,
-1.488149997314634288473975641233958606183e-14,
-4.281972241762446475510111898415305778909e-15,
-1.094863087877876655680621563502802518311e-15,
-2.518033336047777535013583427368678160801e-16,
-5.258388132182288666358041210599432363375e-17,
-1.003965438536186618190986026805222943138e-17,
-1.761402480268925696841298928718348480866e-18,
-2.897153426288108326932949556957239841147e-19,
-4.251905463027188281574880384315328950328e-20,
-1.461395747546333793336338586611634652325e-8,
6.815496011804518240041336306704205593575e-14,
7.846595928637144531565868635403561950356e-14,
6.02243300722061985935432925131380616371e-14,
3.466731328506424186440639985499679479444e-14,
1.596433709344178660128284402012405221356e-14,
6.126118124099188768959743742249708376266e-15,
2.014851707458516480286936174701668121002e-15,
5.797608789808326968080080546740060951076e-16,
1.48245747965785575267994441791626970261e-16,
3.409720000481023359106618436416620908049e-17,
7.121634977955072127560292974448141714722e-18,
1.360145062071432319085821013476173255359e-18,
2.387862949347396158311574156417682635681e-19,
3.93361091000964276705154363453539137396e-20,
5.790508575079584298835704962733418424418e-21,
1.999000662501527562269888727064209304675e-9,
-8.750567723098568520764687680401938456252e-15,
-1.007442277199324048210264750643522483616e-14,
-7.732342869942248437430184243931973724207e-15,
-4.451022560198681801700589632582118459342e-15,
-2.049705512725932800585100881179768220545e-15,
-7.865528064889580982162351841326112782778e-16,
-2.586958632841777923854952457149639972059e-16,
-7.443943393520124527000150085800753919656e-17,
-1.903495829848518438700943940005881378292e-17,
-4.378441125876396306922009793091397060719e-18,
-9.1462466104789739893574401922152688384e-19,
-1.747321966360246505345778976086880243487e-19,
-3.069381300538243649860806001569754126608e-20,
-5.063243045418088626006320494797570544901e-21,
-7.473408345187619256659054128022877089924e-22,
-2.517803037933736428953116166035499562672e-10,
1.040145470417045797518582905823811138667e-15,
1.197507184998762384914097443612529160278e-15,
9.191137582101784956954190096577918729824e-16,
5.290763819465886092874631192505711928585e-16,
2.436412843288349167421490175154520269278e-16,
9.349512341603169450959910555599932898713e-17,
3.075062062135764774991709808714287105552e-17,
8.848590950411605809301935926336709533322e-18,
2.262748616998396216076963163733836206831e-18,
5.205118011823210476617152860291164329449e-19,
1.087445465654327260316593147340006939049e-19,
2.077993834200899547763564582281993361384e-20,
3.652073520562765906840092540463195911452e-21,
6.031523381111609797095572544646080211176e-22,
8.922963945728615329015973784893792245165e-23,
// [{0,0.00001},{2.,0.0001}]: m=5 maxabserror=1.39995374388869512843e-20 maxrelerror=7.19178446885327441828e-19
0.03936454011855729902951318614673218323874,
-7.469390359569457618876845038620705801877e-7,
-8.599271848449286417650769974145183300417e-7,
-6.599906297061713240932488274594754748573e-7,
-3.798890540921016597058839200917306048717e-7,
-1.749158179791707198015749606580457733889e-7,
-6.710374199227333471853556721172646009074e-8,
-2.205823210208645411352155949557443216903e-8,
-6.34028139634484465505665271337318534464e-9,
-1.617721967801956633288856690528459171946e-9,
-3.704720544214051784247087824906370310079e-10,
-7.670308950144377989647047344866881302942e-11,
-1.439234529665299455289358032003441093407e-11,
-2.434830101335421228756471855576997043151e-12,
-3.656022598130005525985257954239903117092e-13,
-4.361270555298905059194335200919178527493e-14,
-0.06513363854780763065874432887109320282402,
9.899403129831791638025216535098603329788e-7,
1.139692556918711784449363457433618783538e-6,
8.74718200962882335543481936530127939225e-7,
5.034958493250521699311264419337721118175e-7,
2.318385455764254228052707037815605869942e-7,
8.894841123669353323369615122516307828091e-8,
2.924367856441292234176184132557263473667e-8,
8.408329496945005829697535235440791644376e-9,
2.146770990292098332912170762037272802564e-9,
4.922688746724910339163353950583812954588e-10,
1.021891641970724882687501524292887209198e-10,
1.927781477603266244769266176307323194774e-11,
3.298899671789636151391502815772057377421e-12,
5.103795612599887575726249881333250735274e-13,
6.561666612102731756877799028637592756656e-14,
0.055491699021423678774956848369850621117,
-7.020694767144398422670084956933194634838e-7,
-8.082768751315772659299863811865551055806e-7,
-6.203593398750887554487476844985049407187e-7,
-3.570890203843692760158115242160990924797e-7,
-1.644285123908514016277338563689075121418e-7,
-6.308868111162521255647835507469769208973e-8,
-2.074382388693419592689831116141695303516e-8,
-5.965594937890613571381011075926782590406e-9,
-1.523718131974395752509281292621873505767e-9,
-3.496817264787477857171695117083909280756e-10,
-7.270862317631412854887465645419023905589e-11,
-1.37619050662520435505250190710212602542e-11,
-2.37147577167586668120475809703447975769e-12,
-3.734255642272101408118886312636890810008e-13,
-5.000769047174151496057367872239486769532e-14,
-0.03220690746382418116854915977181044612132,
3.486019298360541537645999796974595730491e-7,
4.013384548948921049674997596135884559522e-7,
3.080319725146449886634102247818585481527e-7,
1.773097718906025269124732018383122219987e-7,
8.164708940711003050304819402869040125935e-8,
3.13277960182313055975873165192429955805e-8,
1.030141426317260773128928738896999478104e-8,
2.962928268771651764459072099824565074924e-9,
7.569913785553324136767680969190194799819e-10,
1.73819360446347777220803286105603764577e-10,
3.618203269603324557545010944860829252498e-11,
6.863697057339139996591661361990032788471e-12,
1.188303910338577960479790524209694556823e-12,
1.892980758759593362473422951423311000577e-13,
2.600651385525571617031434111458109781451e-14,
0.01425346126463855875702104728801575304885,
-1.347055994149203490530355468043109036228e-7,
-1.550841110266870041815866289644239866903e-7,
-1.190292412251253591009116353499454834689e-7,
-6.851619151761163049172784704256876393395e-8,
-3.155052585845304826815849575497409676922e-8,
-1.21061608855573366689102164182308914861e-8,
-3.981024660007525578523170781553389059954e-9,
-1.1451490603994261099439661334532510618e-9,
-2.926292278052670538298361721596742296178e-10,
-6.721982029710007875125809809815257743633e-11,
-1.400359232107648358096850091134028991896e-11,
-2.66074753722006329550307167615973334914e-12,
-4.621931863343203023094808442670141368985e-13,
-7.42321609891204602806509701678772517949e-14,
-1.037817395697961677956022877262499939919e-14,
-0.005112764343804261288665161192043808945021,
4.285986735595343185905494547047956714072e-8,
4.934384453850950292515915821058458250314e-8,
3.787218428634812098673018522275385074655e-8,
2.180027255291494825057760027181860933825e-8,
1.003874334154496609762888092398628331583e-8,
3.852008806850500480648202714168976476017e-9,
1.266752780656018215603514268642947995267e-9,
3.644109170508264502304536450550778078745e-10,
9.313477627628354016261077940773587998381e-11,
2.140038532895791997805799155755036630563e-11,
4.460930227227022090920072297714100521213e-12,
8.486241853439690671250749861089088247377e-13,
1.477820310663254584351500604873155682451e-13,
2.387939940203674154573737584321624416535e-14,
3.381137562036951669097459479294349451281e-15,
0.001544537915805396713552886486688755755144,
-1.162964524559135371532483196025038440722e-8,
-1.338902715690671554009936920222909030613e-8,
-1.027630962437296574734051797224754368773e-8,
-5.915348384879590024727210064140466043657e-9,
-2.723961150666047170935265876847379874994e-9,
-1.045237877277024098779218873301477312856e-9,
-3.437418078902305592789915016017070234835e-10,
-9.889108243975899517712263397180717728257e-11,
-2.52771564370485008119820639804233640214e-11,
-5.809508854462700233278122908940494402528e-12,
-1.21156663745321359415084600142164516721e-12,
-2.306994480813112796008402077522925524424e-13,
-4.025276967964120886885352748804385786571e-14,
-6.534704279234809508216931707409512616811e-15,
-9.342043809271583974494105058288663964232e-16,
-0.0004034407255516892044786959070062658309553,
2.756438882632414651722744546084237501044e-9,
3.1734469225118996013676405101985966836e-9,
2.435678876194771780552928767146289762899e-9,
1.402053030333722818336313503192521390621e-9,
6.456357216044490908851700503605375117026e-10,
2.477461070335893618049035651329747002305e-10,
8.14768396692326724355214902191826614596e-11,
2.344116532832602648907087025043741729385e-11,
5.992262493504725714002820121821847395003e-12,
1.377473793838620740222212595540798250311e-12,
2.873787368066968924628168757528138365803e-13,
5.476224218710477664571564974419505050002e-14,
9.569802577329023260683188966275388576786e-15,
1.559344913733538106650412419029990627089e-15,
2.246104041015477254737761737999027558837e-16,
0.00009288451399852454249960970637811832500966,
-5.807412921572445246696662649104708577804e-10,
-6.685991757270925957814766582973913814369e-10,
-5.131627753915606221814945038881905556676e-10,
-2.953932666467885211197799720510019691065e-10,
-1.360272045595624398367644130770647567255e-10,
-5.219743999589637219758972547747832842265e-11,
-1.716662132441357218310853308110800612273e-11,
-4.939084231930850225240512879694307698908e-12,
-1.262674080999632865692952642373502616752e-12,
-2.903022156561353283933181677346916372314e-13,
-6.058363698785591082683278985987956647461e-14,
-1.155179633879175771754716900920795974059e-14,
-2.021249664077907893484997474206286137137e-15,
-3.303435580352788751177649121629364034676e-16,
-4.787227109296876206252127631642230472991e-17,
-0.00001912730896802573984201359617174799715648,
1.102183303263073965625885970139693468267e-10,
1.268928564543501343414480277989691364333e-10,
9.739281391814438214346631771402497124064e-11,
5.606259848272524704501390313530398493163e-11,
2.581666452691317056850452289997912462162e-11,
9.906654461131397216762751407923245307332e-12,
3.258138539454457654990978204314886804336e-12,
9.374432263692615157688076091402218168701e-13,
2.396721000315159446471718345758424417e-13,
5.511020665499557787069295115121632867867e-14,
1.150398763225007168257385666196049071123e-14,
2.194650207941681379249298047963303403865e-15,
3.844073374326968856282243811054246453697e-16,
6.29824027560362986123495531083617939715e-17,
9.172703166299393233794618727185892944403e-18,
3.563940555478069126987182299738117403362e-6,
-1.904262930934810099562317314532969653533e-11,
-2.192352793024672189975704940227312681327e-11,
-1.682676181411039779470732871206816179576e-11,
-9.686069637164595340554062304160100900049e-12,
-4.460422068592514945987729664358360566593e-12,
-1.711613729976623290817272259268951275438e-12,
-5.629296683396407983448552275403494225319e-13,
-1.619724908517405682994359475307852265843e-13,
-4.141304621146395010166591402839087112729e-14,
-9.52354539764515118608803004741150688048e-15,
-1.988424913665495046637873131879615443079e-15,
-3.795021968437112821192810225653789516213e-16,
-6.653120010159463051576304394080951450629e-17,
-1.092352365318238217367307074306048393194e-17,
-1.597516872074761069522833323197221169003e-18,
-6.065045110253032473917611205389271738259e-7,
3.020659710456442430624552752008828022583e-12,
3.477646931482877761804532816915019343003e-12,
2.669167979465103947116375462977753845237e-12,
1.536468184494747114085213132346199736596e-12,
7.075435760189191385306982201289755695772e-13,
2.715097947206595544266822211466072182637e-13,
8.92974147329128575416577742661801042897e-14,
2.569425489671163563331069627432665522123e-14,
6.569797752813547149720714993121643791982e-15,
1.510962453087636054937710101952333729994e-15,
3.155330519416440682533902976624252955611e-16,
6.024361514562132631652385740157476143341e-17,
1.056941513905623074999348123730549071683e-17,
1.738457423905686341178839047498567055146e-18,
2.551388416717749222604678997050991865292e-19,
9.498800915527275540882177151707650335206e-8,
-4.429971644765554111319696168363838629782e-13,
-5.10017134642312408430500095877222393157e-13,
-3.914492416487431808012069336330749544106e-13,
-2.253324109712652644022001983171378540866e-13,
-1.037658308458981043430338161254621366523e-13,
-3.981886207195516364698764938553707497283e-14,
-1.309623819777032055485500058166845619801e-14,
-3.768359989263026400567298838262115272769e-15,
-9.635754394002181473431486803929854287544e-16,
-2.216267565905455287738103407929668353957e-16,
-4.628957346973416621019166250915975793378e-17,
-8.840741433341507213754132120310130324362e-18,
-1.552075478865975549449348236244798531614e-18,
-2.556788448641262632263773817787003999509e-19,
-3.763743486215475714072301040046558863801e-20,
-1.378394718458546978415627021977176021947e-8,
6.043648054311803844174829491657918746703e-14,
6.95797885786012735047219920289744542424e-14,
5.340402995764764219420051409018063248945e-14,
3.074133420170774171543660229232687703344e-14,
1.41564501738571406003903355719586804271e-14,
5.432387459766641333207425288779288877763e-15,
1.786702528632165455859944249069503642792e-15,
5.141213741087722692138356631849834945033e-16,
1.314662232316494953081867919623955649233e-16,
3.023995139305802437393016099065439907621e-17,
6.316887065097483186717195366403844044125e-18,
1.206786410892239346896039603750182459905e-18,
2.119838396155355537772920879836382273473e-19,
3.496774542377115794616929418280885314541e-20,
5.160979162859248787500061431265490808743e-21,
1.891693292851327814812741710623776174358e-9,
-7.813493193124455528831939296236612422704e-15,
-8.995582359214232299904809297448141405676e-15,
-6.904312244330712748386423881951755238345e-15,
-3.974381319821713925946798272897413037044e-15,
-1.83021470467949870584158371713702875926e-15,
-7.023282278188018099330338932613039954786e-16,
-2.30996318729131541371373037679612446998e-16,
-6.64699436318401229698143080426846084268e-17,
-1.699759726917616915419334146530159539285e-17,
-3.910046109072921873928515305250565659707e-18,
-8.168812512066576647950410926347346260304e-19,
-1.560975123255733702961314970472354680122e-19,
-2.743416969238839696205890485745112398334e-20,
-4.530860455660302504097050335540465978534e-21,
-6.702941932612849636453668808307014152318e-22,
-2.389480754939520325285686648081560789658e-10,
9.343675909398560366743714961126305201896e-16,
1.075726592075092644661026358295641411855e-15,
8.256447601007431350469309321027084432781e-16,
4.752725232471735785327600998404220575882e-16,
2.188648169730181993163057971336342706478e-16,
8.398766632666529797798679383064648730597e-17,
2.762379893244111218765808418396443766453e-17,
7.948946386646285032894578039821350642976e-18,
2.032748381440059728382774524789693523459e-18,
4.676292506418494838864675299564249248244e-19,
9.770712533854713757972248635696400866519e-20,
1.867488931105547699835317576999502319294e-20,
3.283573001575487250071806412358374443903e-21,
5.42858778625123144256101746631053010598e-22,
8.047251674705697805915063319254019350782e-23,
// [{0,0.00001},{2.,0.0001}]: m=6 maxabserror=1.33533075172921486711e-20 maxrelerror=8.51721298331083060789e-19
0.03256681927390381531750975169819565023277,
-4.949701564915895818593521024610238139631e-7,
-5.698462784593558921764326820816502878416e-7,
-4.373591004814411677347086947799749489153e-7,
-2.517479246625260849442460051655735602561e-7,
-1.159192727882127113928186639741125849183e-7,
-4.447420561834676661308097639270328567844e-8,
-1.462183928220646116964189592565129424839e-8,
-4.204164748472502914492221099625308508829e-9,
-1.07338549514604916636490311400557089345e-9,
-2.461344373362455169371894719461426055971e-10,
-5.109458209853624412999103994393270480361e-11,
-9.638907388016331223008093507379996610462e-12,
-1.649449835894818075548254415840920264745e-12,
-2.551897806299943787618844602306315310794e-13,
-3.280833306051365878075546898404251423268e-14,
-0.05549169902142367200797231061776362344303,
7.020694767144398171460245784260152129281e-7,
8.082768751315772370084828720555193436364e-7,
6.203593398750887332508238917678804836481e-7,
3.57089020384369263237832675982011036987e-7,
1.64428512390851395743416707999373454651e-7,
6.308868111162521029841067371744658908724e-8,
2.07438238869341951842084593653978473669e-8,
5.965594937890613357664072622638266322095e-9,
1.523718131974395697855075392313960352658e-9,
3.496817264787477731434767902547120866175e-10,
7.270862317631412592145209267454016272251e-11,
1.376190506625204304824433969705271850297e-11,
2.371475771675866592854573474597302936335e-12,
3.734255642272101261917817171889668978034e-13,
5.000769047174151278941777692022731844029e-14,
0.04831036119573627706807210880508793204552,
-5.229028947540812494248676723578392802342e-7,
-6.020076823423381790701143200371997793522e-7,
-4.620479587719674995881003844336030763016e-7,
-2.659646578359037999202768499845548732691e-7,
-1.224706341106650501531182233752489691049e-7,
-4.699169402734696008429843766210768120325e-8,
-1.545212139475891215210154725106829521286e-8,
-4.444392403157477806445774525405755853769e-9,
-1.135487067832998661371029138754154805168e-9,
-2.607290406695216752308814445010609653345e-10,
-5.427304904404987032752260465967768940664e-11,
-1.0295545586008710370475059003748962949e-11,
-1.782455865507867006808413485633914197111e-12,
-2.839471138139390153164436315094303095714e-13,
-3.900977078288357588354047340548705495668e-14,
-0.02850692252927825471983173739310702833757,
2.694111988298449196190011088637236468532e-7,
3.101682220533788685430703742409432105012e-7,
2.380584824502544485024613717891111216466e-7,
1.370323830352254082880015507595226364254e-7,
6.310105171690708537978913272869200865835e-8,
2.421232177111505279994549205733244500531e-8,
7.962049320015175964053933562859711806207e-9,
2.290298120798888134437797660278182030185e-9,
5.852584556105432921503376754440755297128e-10,
1.344396405942022704774327159255743892301e-10,
2.800718464215340869318462507749204004153e-11,
5.321495074440210997922241136676065407632e-12,
9.24386372668655451632501958179402783222e-13,
1.484643219782433774324820454127671912456e-13,
2.075634791395959841657350501538889350198e-14,
0.0127819108595102704740679538665091135747,
-1.071496683898822274738036967317566319698e-7,
-1.233596113462722005702514928037505454857e-7,
-9.468046071586910763037879424337425605066e-8,
-5.450068138228668283215021206371889079464e-8,
-2.50968583538620985112492933436411595905e-8,
-9.630022017126129657166639424301388957119e-9,
-3.166881951640005562205256261724475764914e-9,
-9.110272926270546216975199054640086451749e-10,
-2.328369406907059084348935020659233050159e-10,
-5.350096332239412308825301595086242672761e-11,
-1.115232556806741377752527906918005144099e-11,
-2.121560463359895622302502462215938758891e-12,
-3.694550776658088871351151211360838407832e-13,
-5.969849850509106569976708735167493952823e-14,
-8.452843905092261937817080374926218162821e-15,
-0.004633613747361590727543836546154924131821,
3.488893573657138290934560337784263973472e-8,
4.016708147048680546805023479669711840382e-8,
3.082892887293980250320956891255794320648e-8,
1.774604515453567625300942977730586190549e-8,
8.171883451950666341041823267278144513195e-9,
3.135713631812854013976681795353369991583e-9,
1.031225423664699592829997197371198039825e-9,
2.966732473175526990434162286656523509812e-10,
7.583146931070454763179829083970184256017e-11,
1.74285265632866550680629755554263936401e-11,
3.634699912338442509958237854786020725696e-12,
6.920983442398813941517900526794136277881e-13,
1.207583090382108093092081161429699322387e-13,
1.960411283758647208202285334390263347745e-14,
2.802613142763958068404258827165529711564e-15,
0.001412042539441119878969318921300300965923,
-9.647536089249512667339027129850707400439e-9,
-1.110706422883316567645319380013480488013e-8,
-8.524876066713566556947991417770692566714e-9,
-4.907185606186372783642804850525762830058e-9,
-2.259725025624018827206101595096049266013e-9,
-8.671113746208042589413749921474193967358e-10,
-2.851689388433805026555538721161477256755e-10,
-8.204407864944789188350450813420876410944e-11,
-2.097291872734500001184389975663376911689e-11,
-4.821158278453223818807347379134350452423e-12,
-1.00582557882721147521824121680080127248e-12,
-1.916678476555880002597479673507246357408e-13,
-3.349430902077849886154243513343962753972e-14,
-5.457707198088403092572540766793949664068e-15,
-7.861364143585436017682478455029544997951e-16,
-0.0003715380571383179527727486186785917108747,
2.322965172876351857333035528362879660008e-9,
2.674396707798323559233425833471470378976e-9,
2.052651105319394809036472772181413498174e-9,
1.181573068747612938836035758241649914227e-9,
5.441088192331508512133124845663965089537e-10,
2.087897603653721860643728118228104806105e-10,
6.866648542322586039157544952445668250304e-11,
1.975633696385796255411690824842771102702e-11,
5.050696333239286285549227850999775924966e-12,
1.161208864750460379829161031420013504601e-12,
2.423345483956597555301605504820293727655e-13,
4.620718544009104380630194395521215208207e-14,
8.084998671249605606897446646334174198448e-15,
1.321374234613040352859544329737465535482e-15,
1.914890847389685070037449339693756341044e-16,
0.00008607289022778000676371384094243065459119,
-4.95982486015004986355567399771273491997e-10,
-5.710178535226062288637833513359490949426e-10,
-4.382676622310259970261743843688915109611e-10,
-2.522816929416490274233944016376915399488e-10,
-1.161749902649100609464621652994960900724e-10,
-4.457994503433793434723942589705865396251e-11,
-1.466162341414100239682614976228800554163e-11,
-4.21849451480447383979073819216795617866e-12,
-1.078524449155390807953324222245654258365e-12,
-2.479959297205327759355895616334415044134e-13,
-5.176794429769779515078758169698849622352e-14,
-9.875925926669317467774781030752848277792e-15,
-1.729833016851478456716176682913583235849e-15,
-2.834208121378948975768512116795086679838e-16,
-4.127716420903884641589648157892723576112e-17,
-0.00001781969057031606542525136640771724335024,
9.521310123446707381524683473032310604183e-11,
1.096175874837277616836924697401598763435e-10,
8.413376903078297977545861048422849224551e-11,
4.843032513739165364591026047967215414063e-11,
2.230209972905550954667622992811307639259e-11,
8.558064576866652843517728869635299796917e-12,
2.81464700206252993497639760168885077001e-12,
8.098620687642205113400420904536924746299e-13,
2.070651324741390884885013490175576628877e-13,
4.76177043082748110540481734381602259009e-14,
9.942119829081446281812856167233947572678e-15,
1.897510078223297010255344596711189740633e-15,
3.326558411450956421639741956505487480016e-16,
5.46175918946548287925303981838360295467e-17,
7.987580444105668641456984194273712757175e-18,
3.33577563204664016351422505650202495536e-6,
-1.661363130931906375399201242754899681949e-11,
-1.912706146397572411287336453507060818431e-11,
-1.468042645121559882869174499331547575116e-11,
-8.45057649074983334232854734413888456117e-12,
-3.89149034782290288716695494301204655559e-12,
-1.493304131801943742067065025907156863213e-12,
-4.911358668225300035315667482497373103749e-13,
-1.413184266196085153152691463426462463261e-13,
-3.613389395404057330378467528387984172908e-14,
-8.310294944538757004498667043067196070469e-15,
-1.735432089234840345477747022202833495768e-15,
-3.313399413414622208675618548124268271162e-16,
-5.813179347767823947115415039464085407876e-17,
-9.561517522908925220608874220875367079902e-18,
-1.403263880785016779084529952083904360091e-18,
-5.699973122398121126422456268782486629969e-7,
2.658240064408711322589469914126386672854e-12,
3.060398778317186232476775823520103719828e-12,
2.348922614078152068453883463891800288417e-12,
1.352125230271629390061748588260739387722e-12,
6.226552026944302068986137069547290619599e-13,
2.389362805437971367051996512522253632593e-13,
7.85850295613325241765964461706919868351e-14,
2.261234702463473119708015917673735108475e-14,
5.782011944527990528982216034198578343362e-15,
1.329889213429923227075740739475814183955e-15,
2.777643287610247116177280110258011399322e-16,
5.304958873193027767562880936990343972346e-17,
9.313357012893279406780160315262108916264e-18,
1.534222685617956329201327960957324197328e-18,
2.258468279963185848877259077752605916116e-19,
8.959306786647207564675793891227907975998e-8,
-3.928279779362919305018403504826957898988e-13,
-4.522580965406151438944865332348095223664e-13,
-3.471181133014940379915745183740105705758e-13,
-1.998140203298263832024756008040147087994e-13,
-9.201478386867823796189732548933075632356e-14,
-3.530969640762321098232802032295206314548e-14,
-1.161329604808174229254062195315625444362e-14,
-3.341711123808745575174958280177527966528e-15,
-8.545105526184224832212721795870365784387e-16,
-1.965551060498660789513777992618977539451e-16,
-4.105880921010506029764913602960631133165e-17,
-7.843928745133803535205183907512913519614e-18,
-1.377862769727401283767361037839158410347e-18,
-2.272850144023620798334087148279509291419e-19,
-3.354557162448993945681168911660941188427e-20,
-1.304293588329607976952961652077772207148e-8,
5.395609618916948601927071908072603551227e-14,
6.211901544888002810475033056208081208262e-14,
4.767774415376890341463029560858231691443e-14,
2.744509878005036734607196053925051223031e-14,
1.26385510345677429345795303640226920915e-14,
4.84992845042915263531442363986527143275e-15,
1.595145084479453259570139426527697861567e-15,
4.590080351548942171581017938657606188459e-16,
1.173767838767630172946683128095241790729e-16,
2.700075661826875317772508709278298276306e-17,
5.640943505120321599138640003577752644293e-18,
1.077919537761379266987122616495545475387e-18,
1.894423947024243561996919827494811966474e-19,
3.128630751868906067518353371314664358537e-20,
4.628244304849285843886418168366232698998e-21,
1.795296986398792323553461130024472944274e-9,
-7.019013575344152159262533633233260676146e-15,
-8.080909088382485687583960389344418039073e-15,
-6.202282534029114702893612228028131770989e-15,
-3.570269708153433952495106790934149234561e-15,
-1.644122880297848034035337402063017858738e-15,
-6.309193367060652691010170257803607935717e-16,
-2.075112928574033142313162863983977181631e-16,
-5.971286595606408330204575376652030353378e-17,
-1.527010433170701400132570670653728953233e-17,
-3.51285411167688814818515104509640947837e-18,
-7.339809882093824119404975613828042939476e-19,
-1.402868196737016773157733159686494165491e-19,
-2.466641509241131318540661168384637139899e-20,
-4.078002196857442219986682609805350732676e-21,
-6.04519840484082254342812516117028433332e-22,
-2.273580590059976571031819623505645053551e-10,
8.439170136406670390547096282493412582925e-16,
9.715920746263006448882233627276130354184e-16,
7.457194208452087511640405788990428409041e-16,
4.292647857494474761114878715030423451409e-16,
1.976783791683132652934585691757753150098e-16,
7.585776748622023303062466591697306261541e-17,
2.4950002717865963240021360010988663634e-17,
7.179629981447291640233545832236935017496e-18,
1.836059404160650331930768907407314697816e-18,
4.224020579931077330886525782631217968185e-19,
8.826594882137091758277289568358620412755e-20,
1.68736840711121856906034121844961206363e-20,
2.968050259825833224367412558494475643482e-21,
4.911511365426640335402210075485583907733e-22,
7.293856088103864385761973101001031259682e-23,
// [{0,0.00001},{2.,0.0001}]: m=7 maxabserror=1.27637780376258079242e-20 maxrelerror=9.75006986311608959909e-19
0.02774584951071183599264847130535067966446,
-3.510347383572199085348046208738895847879e-7,
-4.041384375657886184602533669944948225254e-7,
-3.10179669937544366591650062048838517679e-7,
-1.785445101921846315994816735160874618744e-7,
-8.221425619542569786275857958526565074388e-8,
-3.154434055581260514577090233807154836117e-8,
-1.03719119434670975909746150380737545317e-8,
-2.982797468945306678506970834642007628181e-9,
-7.618590659871978488444046562006358439908e-10,
-1.748408632393738865526112872450142369406e-10,
-3.635431158815706295672853848752050006337e-11,
-6.880952533126021523357716121625586693108e-12,
-1.1857378858379332962927293600081124488e-12,
-1.867127821136050630735890659118965877983e-13,
-2.500384523587075639138681533928376112976e-14,
-0.04831036119573627061422175092346240906383,
5.229028947540812266242735386267337629285e-7,
6.020076823423381528200447167550887605106e-7,
4.620479587719674794405570773357842065307e-7,
2.659646578359037883225679281513893422547e-7,
1.224706341106650448123133958735422702981e-7,
4.69916940273469580347943809598808193084e-8,
1.545212139475891147800562376634674430664e-8,
4.444392403157477612465341668978636328035e-9,
1.135487067832998611762984206487677958531e-9,
2.607290406695216638176012179727623282247e-10,
5.42730490440498679423716283201190116448e-11,
1.02955455860087099144289344598334872935e-11,
1.78245586550786692656212793164610593801e-12,
2.839471138139390020262793419268334400189e-13,
3.900977078288357390670627039077201093587e-14,
0.04276038379391738715988142308331498797849,
-4.041167982447673965481641696643579959229e-7,
-4.652523330800683225242850294599765167193e-7,
-3.570877236753816878813374239932600986059e-7,
-2.055485745528381211400683059368067221505e-7,
-9.465157757536063207979800960269853394379e-8,
-3.631848265667258073878105083800059451098e-8,
-1.194307398002276445222593272091006616562e-8,
-3.435447181198332347308381722216621380726e-9,
-8.778876834158149754748248840599427902169e-10,
-2.016594608913034142864087317306835496382e-10,
-4.201077696323011483093539161191493706842e-11,
-7.982242611660316839411222812656879697519e-12,
-1.386579559002983237739720168957466635178e-12,
-2.226964829673650761414633262795594027093e-13,
-3.113452187093939911337856083478791343564e-14,
-0.02556382171902162553245275382113727401887,
2.142993367797682865345790032932724571067e-7,
2.467192226925488124038285946219634467726e-7,
1.893609214317416010086908251436618078769e-7,
1.09001362764575314632391820134438684389e-7,
5.0193716707725094532366123087181361343e-8,
1.92600440342526037287382844843974058504e-8,
6.33376390328012440466788398151387649343e-9,
1.822054585254141841357305237770689650489e-9,
4.656738813814201533868796459474776747725e-10,
1.070019266447901641518640584397985501274e-10,
2.23046511361352283741756809330860728752e-11,
4.243120926719867882111889867009013818672e-12,
7.389101553316312594771097287145181874479e-13,
1.193969970101843647825093097817079378342e-13,
1.690568781018485607854964820823816562583e-14,
0.01158403436840361100153338740529497048762,
-8.722233934142722451050690696675544341353e-8,
-1.004177036762155944037840111068418811305e-7,
-7.707232218234841693752371680773388694716e-8,
-4.436511288633856357692037530463553713353e-8,
-2.042970862987637708990405108163432031034e-8,
-7.839284079532024223591368670726541565258e-9,
-2.578063559161712535281882975081198444087e-9,
-7.416831182938712594351730312622956796567e-10,
-1.895786732767586868083645517987830737081e-10,
-4.357131640821602053778396910263725509823e-11,
-9.086749780845977296086274718462346056077e-12,
-1.73024586059967882042756116405330765621e-12,
-3.01895772595522681804556430786993013574e-13,
-4.901028209396546064165570519571467513713e-14,
-7.006532856909787984834806136791192820837e-15,
-0.004236127618271286627959892377639378312255,
2.894260826756458007047521666448115835464e-8,
3.332119268628770831545782403090315651492e-8,
2.557462819997814687189652921156302230439e-8,
1.472155681846554664250596889593290775872e-8,
6.779175076828966226807455045859208480094e-9,
2.601334123845877131897019106096758918684e-9,
8.555068165247028210536152571383059415825e-10,
2.461322359467786181935431080058864283405e-10,
6.291875618163475635628115039350707439264e-11,
1.446347483526758773384364603954692173162e-11,
3.017476736462390738168644599252140257857e-12,
5.750035429630845647413976290590987697344e-13,
1.004829270616880595120839527776077954036e-13,
1.63731215941579824906324637128351299387e-14,
2.358409243059681425335324438138977023034e-15,
0.001300383199993868981042144232092115939325,
-8.130378105100108316830190155428902944478e-9,
-9.360388477331983174778949326862388365088e-9,
-7.184278868646933152914633609967136344418e-9,
-4.135505740633368365856939697202877494117e-9,
-1.904380867323729053438378006386091090614e-9,
-7.307641612817579028179802872447427507139e-10,
-2.403326989822625186887938871370061470931e-10,
-6.914717937378258027792494914092036432927e-11,
-1.767743716640903606207952613710931607479e-11,
-4.064231026643069764811372375264685102116e-12,
-8.481709193882489078838923791396039090699e-13,
-1.617251490409764482319532992974884384392e-13,
-2.829749534948940318697395136898099353654e-14,
-4.624809821164831429611826607510558716882e-15,
-6.702117965892483468951638919886635732309e-16,
-0.0003442915620023957944855530924872862662381,
1.983929947915092573262230412638764612002e-9,
2.284071418528727015558428151549603296367e-9,
1.753070652330604814961754157899411507187e-9,
1.009126773727510374138462326456082849362e-9,
4.646999619626513865641625197123281920342e-10,
1.783197804838772267569131051191322962751e-10,
5.864649377053861751352839447105417766091e-11,
1.687397809201566686525387257165813047321e-11,
4.31409780500917914501514033777179621448e-12,
9.919837208118627841375250112895666648767e-13,
2.070717775940671711727854948240379963973e-13,
3.950370378378454452745337472836174862538e-14,
6.919332080973784927165509929757791214435e-15,
1.133683250798654519349007557497677219004e-15,
1.651086571703952829441078400501542580035e-16,
0.00008018860744376312867601168477208955630753,
-4.284589551417609841429602979689371164463e-10,
-4.932791432009001477280550970627443014096e-10,
-3.786019602732782551499669797198831070938e-10,
-2.17936462908013005858421926500102635649e-10,
-1.003594486839287223852295494791472932304e-10,
-3.851129055874529988540896805752457718947e-11,
-1.26659114970609091070148394408983848514e-11,
-3.644379305922346358350708543445547757644e-12,
-9.317930952342702509816440876490070700108e-13,
-2.1427966918031443171529414901586988318e-13,
-4.473953918762038621772333862175841252119e-14,
-8.538795343734768171963608797912613047628e-15,
-1.496951283697251714327585180562569109398e-15,
-2.457791632846796686221948802761122181969e-16,
-3.594411196253634793974448380925375041452e-17,
-0.00001667886651798250007776681236624434663222,
8.306811541945551569415036482400440749555e-11,
9.563525997066147498244249958588771647027e-11,
7.340209591444469963144322944334614165455e-11,
4.225286153409267591217110457623662435626e-11,
1.945744210550469083241158832621985136979e-11,
7.466516962165679026829189114104207393207e-12,
2.4556781181953119517536224904058199536e-12,
7.065917832009921141690503938449013943053e-13,
1.806693802884499645276811169561802469214e-13,
4.155145413570253429177238543578654736827e-14,
8.677156143897585145588715365382844824086e-15,
1.656698884102325849573826077195503123588e-15,
2.906588226420035249677010446756507989352e-16,
4.780756364202537690631996410270901036748e-17,
7.016315838144654077286005786422390917378e-18,
3.134986002393469199471048058917990104862e-6,
-1.462032299980163837389669165763258991e-11,
-1.683219632654148100511865532378882899721e-11,
-1.291907671515107139709757856262688958231e-11,
-7.436690112177990576678894007034372640263e-12,
-3.424604234514577281440303194252869211162e-12,
-1.314149780796054703116214041864693623708e-12,
-4.322177408034668461472073277986807022615e-13,
-1.243679311434909983088277794187902981524e-13,
-3.180107145115500702151731350102796347147e-14,
-7.314391998253039332168418826237220569141e-15,
-1.527704084978848908728564027026709154364e-15,
-2.917727909575033540467288517823441060018e-16,
-5.122347288786402509546227026604731719353e-17,
-8.438226315108763685559904635918605205895e-18,
-1.24215778400543713190956912715828517804e-18,
-5.376244599972370973684712476101247103168e-7,
2.357201201221623664472678990436818957918e-12,
2.713817213618228665339892687003004710068e-12,
2.082914862984083947414813568654187430138e-12,
1.199002809027594774399923097078520965523e-12,
5.521433592107726460021908046289271319409e-13,
2.118791523804183547024974365895368626398e-13,
6.968667475934332311099097875094352670977e-14,
2.005225187336631380045131955798483583975e-14,
5.127570987777972769475653923043738834354e-15,
1.179447435983774098275627259029968042351e-15,
2.463772640999632586615442211516807741108e-16,
4.706823949607931486770388769800052474468e-17,
8.267997832819114282608580045284288340768e-18,
1.363846093836140561048160952473171972734e-18,
2.012936601104833748834011220491823310657e-19,
8.477660891830635407398872199218150695284e-8,
-3.507062872674392089265184975237880404088e-13,
-4.037640010134330850681822494942271271893e-13,
-3.09897969229562781098042348587616905569e-13,
-1.783889008929865858986258261496603365481e-13,
-8.214862863820679235864388185341718694678e-14,
-3.152378543988659769038690268005611666998e-14,
-1.036819653618684456788251853672521479592e-14,
-2.98348129029427095062495609719148296902e-15,
-7.629309532866497037782314942226209401549e-16,
-1.755007439583768747646012467715906329977e-16,
-3.666526041718756710734092413221739844532e-17,
-7.006310170606734643512856974578921418663e-18,
-1.231346201433477377053512780859880778215e-18,
-2.033561320013899994262536697788020423501e-19,
-3.008286301193868788537392711117731821744e-20,
-1.237736546593906578366632182204956804145e-8,
4.846293355727922643950798553915466961274e-14,
5.579481419593616904226693054994600317173e-14,
4.282379548294762409140190427289250383175e-14,
2.465100483651987935464458587996836528279e-14,
1.135188172497704639310230116195972338053e-14,
4.356195757158503613293256775429609950375e-15,
1.432765832782562297782944659615062711482e-15,
4.122885340638303886634105883236051759644e-16,
1.054326366042320748252416087857893332785e-16,
2.425451638644933891506461100452462741765e-17,
5.067761866427486435814954701250435193325e-18,
9.686034929721350463194031783066618382358e-19,
1.703062811170286184766196362388612341353e-19,
2.81553859978457323088797047280865427643e-20,
4.173534871755733277016491468578447616183e-21,
1.708230920431472142543740079844422287938e-9,
-6.339640194381698005125045031656580812979e-15,
-7.29875576927240415059520969822216244269e-15,
-5.601964109264191764810034201820047691531e-15,
-3.224706050292288332788954645158078577707e-15,
-1.484991756071418568022379514017866932136e-15,
-5.698557463747189637190239965728894298776e-16,
-1.874284352461479630647816143285336238116e-16,
-5.393453755488646318342046228095028128537e-17,
-1.379277509357326193657867470120355178999e-17,
-3.173152982747770598844041901527363484401e-18,
-6.630683482439696164517675727179098994242e-19,
-1.267579631212494664956841609905774749446e-19,
-2.229651912843015506952212003896596122517e-20,
-3.689623801687216757914893080528598606461e-21,
-5.479315192222843545179954206250213217691e-22,
-2.168384896029170729329851525782301016089e-10,
7.659733361604902127858625175675133801681e-16,
8.818565550363446979967456098460130338485e-16,
6.768455632414382846660324088172823609985e-16,
3.896186110097137974349470646097560488227e-16,
1.794213821414556830122497362865794468751e-16,
6.885195480974830553583439013808323336397e-17,
2.264587983260484377771170335343148318318e-17,
6.51666553436554297406684142030062963294e-18,
1.666554953348282476228942812996926058059e-18,
3.834228992709779472266232834037964298046e-19,
8.012785545442662264214328257575189087918e-20,
1.532062812946546180260240410339568732089e-20,
2.695833459722298583130806697620772753315e-21,
4.464771256262730766223436065800807497436e-22,
6.641108019070092365352349769392942658947e-23,
// [{0,0.00001},{2.,0.0001}]: m=8 maxabserror=1.22239868946179857165e-20 maxrelerror=1.089438664564130053079e-18
0.0241551805978681352962535306988073766631,
-2.614514473770406132771612834813110300183e-7,
-3.010038411711690763697554599032712506163e-7,
-2.310239793859837396893727325815256417575e-7,
-1.329823289179518941434933599448423917065e-7,
-6.123531705533252239796401350474871379115e-8,
-2.349584701367347901425327865119115879598e-8,
-7.726060697379455737968747954413890871575e-9,
-2.222196201578738805935098988203859687046e-9,
-5.677435339164993058053889781763381441181e-10,
-1.303645203347608318912902990644152929958e-10,
-2.713652452202493396752594715448286338312e-11,
-5.147772793004354956514480458561302263962e-12,
-8.912279327539334631578178139135278913549e-13,
-1.419735569069695009926986747749948032224e-13,
-1.950488539144178695030424898773712440072e-14,
-0.04276038379391738099151186467900164642174,
4.041167982447673757611269814915679133949e-7,
4.652523330800682985923973586627805566557e-7,
3.570877236753816695130473558758072773997e-7,
2.055485745528381105665601381585619200732e-7,
9.465157757536062721063687677054082162083e-8,
3.631848265667257887026299507267916872488e-8,
1.194307398002276383765449493277672613461e-8,
3.43544718119833217045518787468191488401e-9,
8.778876834158149302459564381891893081375e-10,
2.016594608913034038802278371917728092326e-10,
4.201077696323011265607494538328306931561e-11,
7.982242611660316423507044094869912548004e-12,
1.386579559002983164533224290983413983154e-12,
2.22696482967365064008079495569419236826e-13,
3.113452187093939730599029727432303472221e-14,
0.03834573257853244316358770387075244859146,
-3.21449005169652445473308251607854444504e-7,
-3.700788340388232366481019396059424118452e-7,
-2.840413821476124153609776297408431577571e-7,
-1.635020441468629799200104033964277720252e-7,
-7.529057506158764546943916539070820327173e-8,
-2.889006605137890700179764729187533399048e-8,
-9.500645854920187070334077320551007105102e-9,
-2.733081877881212895368752839887091416541e-9,
-6.98510822072130264179790061607267370047e-10,
-1.605028899671852540736276950550762828716e-10,
-3.345697670420284420113745397576082468157e-11,
-6.364681390079802136810407719921941251633e-12,
-1.108365232997446944438484257315053866954e-12,
-1.790954955152765563327489432856496412782e-13,
-2.535853171527728548393758089586007656311e-14,
-0.02316806873680825861289083033528715344569,
1.744446786828579422421605496628583606362e-7,
2.008354073524352105147186175945808428876e-7,
1.541446443646999206304483738566802067949e-7,
8.87302257726789040113126648468466315725e-8,
4.085941725975357243286175938701860568587e-8,
1.567856815906436244800651726031774841679e-8,
5.15612711832352834809839667176951698568e-9,
1.48336623658777223870569650404530842019e-9,
3.791573465535249742402027840476341420001e-10,
8.714263281643378981408513303232837182874e-11,
1.817349956169232007326699784128725036819e-11,
3.460491721199427532754012347822810284436e-12,
6.037915451910576658221926013793820396877e-13,
9.80205641879329602762613509507154541585e-14,
1.401306571381987969817811750567418737305e-14,
0.01059031904567786625065437620935868369299,
-7.235652066891032169685231050750712042332e-8,
-8.330298171571797158259311403498586877516e-8,
-6.393657049994437000807379799686002139398e-8,
-3.68038920461632925948205140345609310302e-8,
-1.694793769207215123115953135180451915157e-8,
-6.503335309614591391850974994289696682059e-9,
-2.138767041311723688700624837062628586095e-9,
-6.153305898669369443682671595538329994728e-10,
-1.572968904540844354335888141790768922044e-10,
-3.615868708816840436680030667675390684408e-11,
-7.543691841155858760297834265288129447268e-12,
-1.437508857407688826871544723874572668059e-12,
-2.512073176542161722586223563183254628732e-13,
-4.0932803985394296700194728534783038069e-14,
-5.896023107649105191314363081065357562991e-15,
-0.003901149599931837236749797835570664137117,
2.43911343151326119684070780049940210567e-8,
2.808116543180286340954429726530878696941e-8,
2.155283660579260129675997217697067642972e-8,
1.240651722181479642315180433866719750844e-8,
5.713142601931902026597578110840868207725e-9,
2.192292483830198220123485743129122699602e-9,
7.209980969418291000583718904846162187546e-10,
2.07441538119920862304399871837341319931e-10,
5.303231149886219477396272669796604154031e-11,
1.21926930798452506360715461701873675058e-11,
2.544512758147199615827079647997524403789e-12,
4.851754471195737654829667303867452438991e-13,
8.489248604787756806417226262697430163622e-14,
1.387442946339660017826862702443897159215e-14,
2.010635389753162719899359875467106803962e-15,
0.001205020467017728105122687763272868426331,
-6.943754817732919683669629042572005510452e-9,
-7.994249964885193382103191241456700917813e-9,
-6.135747283183710654948426979335457135408e-9,
-3.531943708061594753889078622268523060436e-9,
-1.626449866876329487338865133775567477666e-9,
-6.241192316962755643187209565359675732666e-10,
-2.05262728197774951780490492311976500255e-10,
-5.905892332231088840864328739146774559837e-11,
-1.509934231759761216347631836645903678854e-11,
-3.471943022856587002249434568626440996696e-12,
-7.247512215823843387471360690691061320623e-13,
-1.382629632438482299994224827714131720626e-13,
-2.421766228351429803235072737087279542503e-14,
-3.967891377812879883687872112989602874507e-15,
-5.778803000990069977707457669038434671801e-16,
-0.0003207544308180595746323852777465095909313,
1.713835824081688072757662136969188243677e-9,
1.973116576849971794489528494332627292974e-9,
1.514407844198798666507306312054107343991e-9,
8.717458534198064875992726559175217543462e-10,
4.014377955589860713464140408085098886712e-10,
1.540451625509077073484589520889975842118e-10,
5.066364609215454524320004516354465817677e-11,
1.457751725359148499722255464297834464351e-11,
3.727172388584317283558362217175696448915e-12,
8.571186784807208896802660109444379069222e-13,
1.78958157118204079189259136614110907237e-13,
3.415518144525961600892636345952914140139e-14,
5.987805147166671837677919334014988634937e-15,
9.831166551902182843924430591069694893205e-16,
1.437764481557372122738467347407215897708e-16,
0.00007505489921345854054162604119768068761062,
-3.738065190091743822519007953498486189837e-10,
-4.303586694323570884340330217822527693438e-10,
-3.303094312806527425411068115451872468855e-10,
-1.901378767109528775772975792454439993416e-10,
-8.755848938614015781536839506301547218646e-11,
-3.359932629573376158316004360319782882326e-11,
-1.105055152069208576543522616413297318323e-11,
-3.179663021185241772783659579249498523661e-12,
-8.130122104747180746087233344024587800302e-13,
-1.869815434212295376750136083700073361919e-13,
-3.904720260794557478723091498339579602969e-14,
-7.455144970887794915894742105822151681189e-15,
-1.307964700555700914985632102991570067459e-15,
-2.151340361679770657951301327802897965476e-16,
-3.157342123866709884324727455295666937236e-17,
-0.00001567491888466317810336825727129502092437,
7.310157750362234530807759345394619675373e-11,
8.416093846468137335900445533501602903636e-11,
6.45953504432739125164556281755559204619e-11,
3.718343148853415949145089369558137458352e-11,
1.712301238964367893270240406697072760447e-11,
6.570745533571815138384511535421917759919e-12,
2.161087595461395414674612328972033784205e-12,
6.218393367119672944620908153470396302496e-13,
1.590052756725287874414188582250499821284e-13,
3.657194122072996365616690421970487366694e-14,
7.638516501908483189999514110582102293286e-15,
1.458863204584642878849259126067550373749e-15,
2.561172323902742462568200748952972653177e-16,
4.219110968945935197409751420589289494973e-17,
6.210785659870087232452870944420752324398e-18,
2.956935281799807021642270421011084916531e-6,
-1.296460902848059042261850389803118254524e-11,
-1.492599746304825890546645510839350791739e-11,
-1.145603388638262960184701774208555527166e-11,
-6.594516681503224079816481904424632281106e-12,
-3.036789042934545888685768993990691949027e-12,
-1.165335555782062191102921046909206856629e-12,
-3.832767827767202626999780065252979539739e-13,
-1.102874059078918479726953944961311908267e-13,
-2.820164570228782459711312799774643805971e-14,
-6.486962110354243879976798493834996743999e-15,
-1.355075205965198374518394360538070543293e-15,
-2.588753656967141020459976198826619342695e-16,
-4.547399661428113051647105962320349790438e-17,
-7.501154931469452536791746965003171664955e-18,
-1.107115341718173338526766179394100799654e-18,
-5.087227847714206929518123206966289319969e-7,
2.104450452778289943155765610517809071021e-12,
2.422828918842502754533246992981360847408e-12,
1.859575791717409695446647097438124740957e-12,
1.070441611911792253063759595375814088028e-12,
4.929416015677908447586735712149312766668e-13,
1.891618345710141344709284708465779298894e-13,
6.221546858270612949037066475972382691267e-14,
1.790269761176864301132918724451196648762e-14,
4.578048580317909182382176702770157247416e-15,
1.053110957934321185694281877524732813699e-15,
2.200138194697050593203432429317729196738e-16,
4.204211728198936119093855540023704409531e-17,
7.388826385810234220241710977308606301219e-18,
1.220260962224032818187743857412027442114e-18,
1.805156745068843438092306359277333919627e-19,
8.045050602912098983076801861520171689602e-8,
-3.150014354800929883416583849101830764636e-13,
-3.626575048951634809870550739884728305129e-13,
-2.783479261163909155827472312092384819018e-13,
-1.602276490233641766826352985788431576898e-13,
-7.378544333642138105350290916565503341377e-14,
-2.831458633086705968446183578520368774735e-14,
-9.312752251029790554812890638288896613919e-15,
-2.679810532803624380331527518290645897382e-15,
-6.852955300682435392916404341567019529159e-16,
-1.57650535265774937283941434211947922067e-16,
-3.293965344496153383658871717858040350848e-17,
-6.295769947323619898461911441582126365005e-18,
-1.10696393144192481273315268795691514539e-18,
-1.830055481757085636996267482839188507423e-19,
-2.712731131132926114080918882607927780827e-20,
-1.177629400785197217539780404159037886546e-8,
4.376649769400209250970941501340750091787e-14,
5.038787159792872811255200374606588366944e-14,
3.867385820109689618641005393647028515927e-14,
2.226216016866636782806249572321268850479e-14,
1.025182531489228398015975788567966063954e-14,
3.934069746388425341791279848625774311208e-15,
1.293935235410559421598640015591013011814e-15,
3.723435994357362600376083380154898910906e-16,
9.522003456742711376076812682779803500475e-17,
2.190620682236045572452805925373325559276e-17,
4.577553761835527451573454934226366475698e-18,
8.750812573083607402586222201002459653193e-19,
1.539239069493997304124090453788616099604e-19,
2.547073478218753407624396746744872021171e-20,
3.782396627463548899198186321238231669163e-21,
1.629205130064931573113348570553521014648e-9,
-5.754194489372571485790772628131689328453e-15,
-6.624739912347892206099235390942624924246e-15,
-5.084643070374685774062674072618233038485e-15,
-2.926918165640810524955111539620506360947e-15,
-1.347860933442871761586709803694639306549e-15,
-5.172341205291460642846233634324401288815e-16,
-1.701218498758021317370965643030426859891e-16,
-4.895491975535256579623747332725849154834e-17,
-1.251960356491269354301326008190782772574e-17,
-2.880375040514624510402202306874352745523e-18,
-6.019419618511761669072267328196496965679e-19,
-1.150927285306011567699254792579893140329e-19,
-2.025185507072159992516058994480857161737e-20,
-3.354068932049134619912961598395609091438e-21,
-4.989020391326808160351241973814043218173e-22,
-2.072478308442270014859145846552998920289e-10,
6.983355120238456297876749866708441050692e-16,
8.039860074524423642392281073149382326079e-16,
6.170782851851654041099755541514992147592e-16,
3.552144632299683664818988231588575085092e-16,
1.635782973074117736862088376656203921776e-16,
6.277241506138142444334214496256571427703e-17,
2.064637997889838714073235148895181218127e-17,
5.94134073226518300286602049091905912896e-18,
1.519453076605935993267171956817265728087e-18,
3.495932007713418154766396776662849704195e-19,
7.306393754788549286755440870051891772953e-20,
1.397221005755586369842542023402068377048e-20,
2.459357895802540048973766888949693965141e-21,
4.076192931686305667637095239719723871981e-22,
6.071913315898415326410453294985836830709e-23,
// [{0,0.00001},{2.,0.0001}]: m=9 maxabserror=1.1727952867889687785e-20 maxrelerror=1.195635113003174227812e-18
0.02138019189695869048533993432451538466641,
-2.020583991223836878484272094999990762413e-7,
-2.326261665400341492592005216280975964577e-7,
-1.78543861837690834728126701146655114263e-7,
-1.027742872764190552669336378975137007313e-7,
-4.732578878768031359779079688603999051107e-8,
-1.815924132833628943224278749075486556942e-8,
-5.971536990011381917877118039022553765166e-9,
-1.717723590599166084954173613425324979335e-9,
-4.389438417079074650530506235311329667531e-10,
-1.008297304456517019240239847753295020441e-10,
-2.100538848161505632467425931377978237447e-11,
-3.991121305830158211110188658033265809852e-12,
-6.932897795014915821533106566651106183641e-13,
-1.113482414836825319852364375524113703946e-13,
-1.556726093546969865018718513525158566518e-14,
-0.03834573257853243725654884712243215045899,
3.214490051696524264447395223608542613444e-7,
3.700788340388232147407166117964951477432e-7,
2.840413821476123985465362774593774085515e-7,
1.635020441468629702409530452613651912198e-7,
7.529057506158764101217273604263482409286e-8,
2.889006605137890529133842322319111634476e-8,
9.500645854920186507746993788629218610606e-9,
2.73308187788121273347346498494379617467e-9,
6.985108220721302227755459029672565691465e-10,
1.605028899671852445470655303482481144212e-10,
3.345697670420284220997047063587026537556e-11,
6.364681390079801755979470168247750691298e-12,
1.108365232997446877385859971760682155157e-12,
1.790954955152765452117315350394328517455e-13,
2.535853171527728382517672392600231671189e-14,
0.03475210310521239258649071005307041143412,
-2.616670180242869277625349867563472994377e-7,
-3.012531110286528323498316551327876244879e-7,
-2.312169665470498936694976683591981909516e-7,
-1.330953386590183633413096497270223796337e-7,
-6.128912588963036202220077127988347439523e-8,
-2.35178522385965449663532446633171407251e-8,
-7.734190677485292947871811275537574168801e-9,
-2.225049354881658480569910070864007091001e-9,
-5.68736019830287492692741799976817967827e-10,
-1.307139492246506919305397819209606631435e-10,
-2.726024934253848161685458805656456345642e-11,
-5.190737581799141587389243363534026076303e-12,
-9.05687317786586549500261301187411746868e-13,
-1.470308462818994488395884070719157055611e-13,
-2.101959857072982080543136846638204554683e-14,
-0.02118063809135672519492688188243623997504,
1.447130413378238411142077858281090540246e-7,
1.666059634314396246662089907085302534003e-7,
1.278731409998915656560913002512948747773e-7,
7.360778409232821173973111427636380843691e-8,
3.389587538414505149880557661709519246207e-8,
1.300667061922947022363610751141082673095e-8,
4.277534082623541919260149043415062682446e-9,
1.230661179733901094980648927367426737914e-9,
3.145937809081758287842307574863510464414e-10,
7.231737417633840965717488941376130782528e-11,
1.508738368231205213304294660350684603102e-11,
2.875017714815441651781589387195244908942e-12,
5.02414635308443612606676452984988237231e-13,
8.18656079707904622707439838451928037621e-14,
1.179204621529848913509527489863202686981e-14,
0.00975287399982925701264829591109612793248,
-6.09778357878304930463546731572939751912e-8,
-7.020291357950596478112461194315443454192e-8,
-5.388209151448058701560972640641501917697e-8,
-3.101629305453646364152411552826098388847e-8,
-1.428285650482951218771495787000356591553e-8,
-5.480731209575402346299265610938360682271e-9,
-1.80249524235454209429231159933451571706e-9,
-5.186038452997933338750352415677620272198e-10,
-1.325807787471532307263341431564037395744e-10,
-3.048173269961260744967491178847426302045e-11,
-6.361281895367890525737662072308697188347e-12,
-1.212938617798913656602026222899441468267e-12,
-2.122312151196902644955946544577135739017e-13,
-3.468607365849089375796189844552730163555e-14,
-5.026588474382816200917126662463531267025e-15,
-0.003615061401005523072679568181340694538024,
2.083126445304523309348207925290100969958e-8,
2.398274989447882737222309446191220099232e-8,
1.840724184941546999012684848616662917324e-8,
1.059583112410669186431801996990550990002e-8,
4.879349600593026424747069944541248442008e-9,
1.872357695075026396414658987455840450385e-9,
6.157881845887858002704100049111638231805e-10,
1.771767699656264645419284286493335624386e-10,
4.529802695245877949815398977144543455164e-11,
1.041582906849289896344148643796555152025e-11,
2.174253664731087916335040196208690119055e-12,
4.147888897284720758431375720842030513612e-13,
7.265298685000190102944001445848615890114e-14,
1.19036741333489131548667755921224558619e-14,
1.733640900283637777483542419742837394164e-15,
0.001122640507872171565020396227068956103124,
-5.998425384313560923190175906670613369793e-9,
-6.905908019006737502949532673796036067393e-9,
-5.300427454720230399823081787803549148632e-9,
-3.051110486983388504692261677857559568599e-9,
-1.405032284462928644340810382312336087729e-9,
-5.391580689306626566542402226129032210648e-10,
-1.773227613233584769448421200578374873916e-10,
-5.102131038780547056409876445645258505316e-11,
-1.304510336010528188094167148413362853072e-11,
-2.999915374696368201385882599959613283351e-12,
-6.26353549916608259577179621388857023552e-13,
-1.195431350589622324675847981874355847819e-13,
-2.0957318015180845276326021903140523076e-14,
-3.440908293181943904117982765813067184531e-15,
-5.032175685474964467084564656981509509289e-16,
-0.0003002195978526555580309235162889329140824,
1.495226079254038393130385081036775449835e-9,
1.721434681433518086200845082292599651253e-9,
1.321237727965588288535561405503921974803e-9,
7.605515084803416795258961430490300747618e-10,
3.502339582981930072369164843796011970983e-10,
1.343973054721386362602309977671497955915e-10,
4.420220617789028623379095207292642898848e-11,
1.271865211211414182874232381592290179368e-11,
3.252048848899481460710846878790604753662e-12,
7.479261752956646504008323147761015408075e-13,
1.561888107684478748374687307660627503458e-13,
2.982057994794190667783742020684644124534e-14,
5.231858813560035910046121209487175183961e-15,
8.605361465522472465731114701707889665225e-16,
1.262936852351317407865195248037749285608e-16,
0.00007053713486829622911875916654298041671809,
-3.28957098418639461922091399596314535679e-10,
-3.787242226908076744493206391541803317454e-10,
-2.906790766875245666866174479167949043168e-10,
-1.673254415215625307997381600529654924888e-10,
-7.705355567195999918956366919128578591048e-11,
-2.956835486982213181533390215165565097563e-11,
-9.724894169297459803025937563711145322344e-12,
-2.798277012245899822231321137637843919027e-12,
-7.155237397698792913328884687972363810275e-13,
-1.645737353192185152338204120760829965803e-13,
-3.437332422220379779816811137111003022248e-14,
-6.564884413671094657930454383948838711207e-15,
-1.152527544530500003080449483487139471021e-15,
-1.898599933991463675228167411402652617129e-16,
-2.794853543903784302460713945740072214334e-17,
-0.00001478466575308266978105636614917312876617,
6.482301081870832904783985246262298672179e-11,
7.462994779874297872715038814862693874995e-11,
5.728013910205708720617206562717901165481e-11,
3.29725659484515832205583858779435431921e-11,
1.518393717466433789161648225210569269138e-11,
5.826674693587326638544347371810693163216e-12,
1.91638289909011960717126692614388389947e-12,
5.514367375130514548975341388467885116404e-13,
1.410081538265413833548950084797740931305e-13,
3.243479336777536720591642041731061277669e-14,
6.775372438162143948367753911612341349747e-15,
1.294376141541179572508190020516760268508e-15,
2.273698621219084922082481679172082696951e-16,
3.75057545972398161684583283572017364005e-17,
5.535573716509696884332762677710344270282e-18,
2.797976037498119255160755293018588880712e-6,
-1.157447971545850658856780863154975616821e-11,
-1.332556161545735271391434739709484180246e-11,
-1.022766882070703475856933446655915767247e-11,
-5.887429997373187722405000160698716411172e-12,
-2.711179329851223710392673223096930656302e-12,
-1.040390290160417044815799620028140434689e-12,
-3.421851429936728581981918093545934584667e-13,
-9.846485579687683648267641074769831673169e-14,
-2.517927203366983351738630435031424811578e-14,
-5.792111382736792123745523093937779212784e-15,
-1.210076239958767570976778426944034994295e-15,
-2.312316895965931930582537846008705853515e-16,
-4.06385529671730446170184284525903008234e-17,
-6.711436594210905704078350101458133061033e-18,
-9.928364042170713479956019391311018072483e-19,
-4.827634930263683935477537832975638979471e-7,
1.890203347724313983221816354703599227806e-12,
2.176169225490019718538846778417777471413e-12,
1.670259632573235558453855057190443789266e-12,
9.614649478184935634738137822622389608024e-13,
4.427582748567876246817003926430003113873e-13,
1.69905022507850486997804525844711185947e-13,
5.58822709181555716931969350397910894652e-14,
1.608052000322773924485323174410529816882e-14,
4.112196903792777289080321183890285718507e-15,
9.460007046774928005908679694864238080144e-16,
1.97658297908565612202368996237662144674e-16,
3.777851703909544723862273812151058901511e-17,
6.64246979346924342706284618008002582658e-18,
1.098147099734539848675003467998983454083e-18,
1.627808433950426293171389306896434915762e-19,
7.65436378662860329334064749393271078181e-8,
-2.844752219372731539167896276987953536776e-13,
-3.275130913095679928467558994795526637598e-13,
-2.513738812586662170445678576439518276232e-13,
-1.447004738283423488451632342639232925861e-13,
-6.663522179589706786981116488846593527445e-14,
-2.557082295074842863997497709949140236953e-14,
-8.41037168421779131944545996696425110503e-15,
-2.420173728043018531397112396302913247918e-15,
-6.189149644471595511794782458072507476968e-16,
-1.423868330523284706840110178569868584098e-16,
-2.975336550059471949076137760062242296805e-17,
-5.687887778360291208154103334608719750775e-18,
-1.000480669468855878678239881822819527429e-18,
-1.655556726488076317860546224385654849421e-19,
-2.458496529754156445525678275385884921405e-20,
-1.123079470719620772376012073234992760865e-8,
3.972005917601049316249565585252718996697e-14,
4.572926075680343034444056935444237935496e-14,
3.509827856836725525155111823717719618595e-14,
2.020393290026043478214449866221646344628e-14,
9.304015148710037502192123626690561410235e-15,
3.570363717204325907773903079532288563853e-15,
1.174316958888318010383917023243218793421e-15,
3.379258879661961541546179563056045058994e-16,
8.642023964955493595567961902148956982857e-17,
1.988261324115223312934079108055712306641e-17,
4.15506781326542156855477551367922513361e-18,
7.944554191785035620954291940768651787587e-19,
1.397921212407412545627891147163231226467e-19,
2.315160427139487359836925030652171419913e-20,
3.443558462416248674661972407729354526814e-21,
1.557156642489694473348442895228165868368e-9,
-5.246148228953248619723204056054781345404e-15,
-6.039832857338204053098718535760333243626e-15,
-4.635714640758668684255622976926121082553e-15,
-2.668499168184623634400528961195342871145e-15,
-1.228859173906553965873839860950511958513e-15,
-4.715690279995926864637536491605641034933e-16,
-1.551030570808139047633785412075907842134e-16,
-4.463349690385511641054311500488248305852e-17,
-1.141468080936641391760907519498543956335e-17,
-2.626270804192558196028046040206347922871e-18,
-5.488828996050738104191263006184225887188e-19,
-1.049643765040301828079814160273329586054e-19,
-1.847561731091846608058678891299359124529e-20,
-3.062195323185026662340502049569985152614e-21,
-4.561477269276843820496369910463114077297e-22,
-1.984684131898110880635465182426131292632e-10,
6.39265693549200898555894266939005368093e-16,
7.359796776556077916041469157693522220135e-16,
5.648819769498756464192489546629396933002e-16,
3.25168404196805355867612529632966832999e-16,
1.497420835246061966116431413825591576416e-16,
5.746296149787929827813899549580982636972e-17,
1.890014083538344378607895877796564069724e-17,
5.43888028877114899704929899689719450409e-18,
1.390977705372042119194126912270299712118e-18,
3.200453688008989876708530348311602871403e-19,
6.689337223668183269469153506064448678119e-20,
1.279404170535719022078113150350122253165e-20,
2.252638947297173632078569786384377268037e-21,
3.736121189417774752476162871533599464892e-22,
5.572645472255197892995236558205324738567e-23,
// [{0,0.00001},{2.,0.0001}]: m=10 maxabserror=1.127057979066017673599e-20 maxrelerror=1.29427483159923109481e-18
0.01917286628926621861826533695247508891308,
-1.607245025848262131927408595191533073034e-7,
-1.850394170194116073362468635410662090559e-7,
-1.420206910738061992470867793017101738235e-7,
-8.175102207343148510540548197683519227853e-8,
-3.764528753079382049914604590143064534779e-8,
-1.444503302568945264300587861468885539144e-8,
-4.750322927460093252997493228303767076777e-9,
-1.366540938940606366484641561937038575677e-9,
-3.492554110360651113232994030048019944347e-10,
-8.025144498359262225869732785995962466705e-11,
-1.672848835210142110188405658938027978611e-11,
-3.182340695039900877396453602509027664966e-12,
-5.541826164987234385884179057346693822237e-13,
-8.954774775763827258851126607651407647725e-14,
-1.267926585763864190999393022850081023673e-14,
-0.0347521031052123869195686744944420037871,
2.616670180242869102786365924875129436947e-7,
3.012531110286528122208059870161430530701e-7,
2.312169665470498782199858483938973090547e-7,
1.330953386590183544479551339824811458284e-7,
6.128912588963035792675120263385546634092e-8,
2.351785223859654339473664793121919121171e-8,
7.734190677485292430949325247126269581847e-9,
2.225049354881658331814267203475983591797e-9,
5.687360198302874546482968459131428523884e-10,
1.307139492246506831767337888642129484047e-10,
2.726024934253847978708212934554816349177e-11,
5.190737581799141237380601968129535433632e-12,
9.056873177865864878580355132482436074254e-13,
1.47030846281899438609554941791751057956e-13,
2.101959857072981927774468490649009998212e-14,
0.0317709571370350922772199393865969126332,
-2.170695620067357749471375919977312823304e-7,
-2.499089451471594522836320064021845484108e-7,
-1.918097114998373602152221571712431353876e-7,
-1.104116761384923243624798658376863024091e-7,
-5.084381307621758035795942299196561314763e-8,
-1.951000592884420652881413308920713364566e-8,
-6.416301123935313271401303662585083233309e-9,
-1.845991769600851755425390675254001821291e-9,
-4.718906713622637720650178292838548799032e-10,
-1.084760612645076211330788178550840250857e-10,
-2.263107552346807958911003217233511452774e-11,
-4.312526572223162743504114276198787524865e-12,
-7.536219529626654657387626321286750036934e-13,
-1.227984119561857011821520128553227897957e-13,
-1.768806932294773486513097290531341263419e-14,
-0.01950574799965946636759070096484420327425,
1.219556715756639242394237248559513637085e-7,
1.404058271590153122192116823063223904715e-7,
1.077641830289637703018781965179090133247e-7,
6.203258610907442179987582685137683693971e-8,
2.856571300965971261048107448920831302328e-8,
1.096146241915106880075365721467478785198e-8,
3.604990484709171056746169706302550125837e-9,
1.037207690599611665945387913762583466475e-9,
2.651615574943128547729843938495415506621e-10,
6.096346539922668596527563884436284775911e-11,
1.272256379073608854241226086358135096074e-11,
2.425877235597886131715489111285460416165e-12,
4.244624302393908878910182417542734354904e-13,
6.937214731698350666094309643927239096479e-14,
1.005317694876588912792950254657678190118e-14,
0.0090376535025134847314603415603776898712,
-5.207816113261212675784133896934534555753e-8,
-5.995687473619596782561633204658334234588e-8,
-4.601810462353783023432784502647691449591e-8,
-2.648957781026624339399789145629777065286e-8,
-1.219837400148234213252612768038801771577e-8,
-4.680894237687480058655618470315323526706e-9,
-1.539470461471936236436804003110890172533e-9,
-4.429419249140580276464030312138726585431e-10,
-1.132450673811448685077232074089562714678e-10,
-2.603957267123176874352918989927948767834e-11,
-5.435634161827619731367838310699379580209e-12,
-1.0369722243211610473915516018296061703e-12,
-1.816324671250013804928162994982705227907e-13,
-2.975918533337172294426768453170468531623e-14,
-4.334102250709010734337652197621164755549e-15,
-0.003367921523570790765241549716099934269305,
1.799527615279961901073360882350077155487e-8,
2.07177240568578073084309020383211186418e-8,
1.590128236403604129810603853635549915237e-8,
9.153331460878412064737020647573139430676e-9,
4.21509685335574298697725586757869685008e-9,
1.617474206779307837626337839968805084708e-9,
5.319682839659047917811872008516680559222e-10,
1.530639311622162199517636346147008603178e-10,
3.913531008000889507331362598446866661918e-11,
8.999746124018477057365446664670911447851e-12,
1.879060649735061789024506393409440441153e-12,
3.586294051740627536009923959858249615033e-13,
6.28719540450451931823813767779798646714e-14,
1.032272487946329356985828403613651909254e-14,
1.509652705630163617121335374841576177347e-15,
0.00105076859249290736646903961381754528768,
-5.233291277414629549328461172102143686153e-9,
-6.02502138504666562622985030080189379633e-9,
-4.624332047902087630932420878601060373472e-9,
-2.661930279694164256276840296042033715288e-9,
-1.225818854049647556217660726225808717119e-9,
-4.703905691547769803292930849303825858406e-10,
-1.547077216233697882969152022645008795319e-10,
-4.451528239261641642405185871315366985467e-11,
-1.138217097120366352164134080677672279822e-11,
-2.617741613547591922116382813326977164527e-12,
-5.466608376922360744726461282693795670767e-13,
-1.043720298183071822270954398959319708869e-13,
-1.831150584755005660772604027383390796481e-14,
-3.01187651294779863111667576149041977247e-15,
-4.420278983251935609545260408527989913725e-16,
-0.0002821485404314072910573517827945141743046,
1.315828396630740423678344256951981475987e-9,
1.514896894166652155611628290569706531325e-9,
1.162716309362306176094289739944436716574e-9,
6.693017675899410677612316837272910218833e-10,
3.082142233802997910120975953553960259467e-10,
1.182734197450179153969135035473001056719e-10,
3.889957676459124291178256619639336214863e-11,
1.119310807413524674089529207780883666e-11,
2.862094965512083138892757027586814499917e-12,
6.582949427569702210685297961059314027313e-13,
1.374932971981936964787892326081723997837e-13,
2.625953771386396000693552218681858712548e-14,
4.61011018854449221148025957453175198416e-15,
7.594399753262849646096867893283631907475e-16,
1.117941420144538328355198444033766004974e-16,
0.00006653099578058605817700384586503734617203,
-2.917035483636511793616341932984653587841e-10,
-3.35834764725313337176069755652111619899e-10,
-2.577606256760173645580577976877148582302e-10,
-1.4837654660498809109692838222075792676e-10,
-6.832771721090657578815644210460064928705e-11,
-2.622003609233005873802571449978155903026e-11,
-8.623723036428609928956778308795615483558e-12,
-2.481465316081519570916631540506527517571e-12,
-6.345366915219377656580368436678375124367e-13,
-1.459565699944939545178547157569214485317e-13,
-3.048917593817995809813715655306559030258e-14,
-5.824692630516970642413475539084142051776e-15,
-1.023164378417937842591374731351634782503e-15,
-1.687758954998316659101048508534874702718e-16,
-2.491008169622607568248644740259008775694e-17,
-0.00001398986996469894869287575355670918982232,
5.787236703969129548515711616325245738778e-11,
6.662777176838295797772974324786697442416e-11,
5.113831623557733104111494826496600622175e-11,
2.943713394495912575263521826624602973474e-11,
1.355588926185012637344871193824085165851e-11,
5.201948615906988611083294558797733012469e-12,
1.710924782539276161862372794336663281126e-12,
4.9232401065771253346243171885160023553e-13,
1.258962915434597229903023022731383963898e-13,
2.896054112349436844844022683556074615549e-14,
6.050377899234404335996742621351431840099e-15,
1.156157816634215554896183566362087853583e-15,
2.031926536450159281681686775613520135347e-16,
3.355716451800267396290020001647320901987e-17,
4.964179265421558711155830153603916638126e-18,
2.655199904724914253980397926039394588499e-6,
-1.039612046405234172082866938075575826333e-11,
-1.196893310214444270821208963199197749208e-11,
-9.186429792006202259297802747327833512339e-12,
-5.288058256552851760961501758895649868243e-12,
-2.435170992275102159090896344518798578808e-12,
-9.34477808208059744905039493418235737704e-13,
-3.073525507062262541951318496360462468951e-13,
-8.844287747306880410283082636387249355807e-14,
-2.261708743514699476484584842964913571275e-14,
-5.203004902963723888333726509961981351277e-15,
-1.087120853229392505090968506951891259852e-15,
-2.077818847951146580385008645934090961095e-16,
-3.653359110072436581176261662213688358441e-17,
-6.039810250203988318100243910828530103846e-18,
-8.95294818317099290104116010855141441328e-19,
-4.593198267221631593891476419037877053574e-7,
1.707030259775338583216089538468420220551e-12,
1.965284545929342967666296687830234851143e-12,
1.508401396031819698724186606212893105552e-12,
8.682938565102012347321118431170452546968e-13,
3.998532431228270296858305195024207846532e-13,
1.534410214432808205556456493965124236462e-13,
5.046752022906699293824497242098415107844e-14,
1.452256471598622681041389388282861013637e-14,
3.71387912906290177203928475720864290339e-15,
8.544105837412550223255217210136899786722e-16,
1.785389186832058534753887273854954579984e-16,
3.413090861893235804037196947377475950136e-17,
6.003514856663002472548096279703996962506e-18,
9.934387290599073584285789160985997665427e-19,
1.475254260149353679152527027153515694763e-19,
7.299798121226997602147337879246525484343e-8,
-2.581739187310265393627223143807859577511e-13,
-2.972327507816516452588072910069792921988e-13,
-2.281330971382327575742322987910527830303e-13,
-1.313222748995908818924660279229159494591e-13,
-6.0474583880624097665572219632283374318e-14,
-2.320678294286090821483114238318261945207e-14,
-7.632869062556681459350270641426230966823e-15,
-2.19646325799410965182724914892378643758e-15,
-5.617174876639086319967784263214484977363e-16,
-1.292337485308908926387556199180512161532e-16,
-2.700726401613482066028541221252307354478e-17,
-5.163830752854078719429449930949793493392e-18,
-9.086259803899121110730130253358475683245e-19,
-1.504816404884134450541417358799685432162e-19,
-2.238256382182081717457086006745842614399e-20,
-1.073351304323786304822932344014108257077e-8,
3.620913371625912673490397794589358011989e-14,
4.168717794014483110128137683356625137492e-14,
3.199589528367606009007537257063033456143e-14,
1.841809198003018287788308487528210244178e-14,
8.481636747147525370465561732242320248256e-15,
3.254788699488422107144878910831590497392e-15,
1.070527506717600095009714174244179868084e-15,
3.080621064610022151651090198016424687051e-16,
7.878452596085773253359992654486221539488e-17,
1.812659514633363978305668597953253282339e-17,
3.78839781691834587932275642200140625748e-18,
7.244628329978993767434481756763664582971e-19,
1.27517470541959030996338211429045269731e-19,
2.113467540692186508860528445928677201138e-20,
3.148130616843795903009226611265649331392e-21,
1.491201712204158436165732873981160689261e-9,
-4.802451131911372418808612612772977261056e-15,
-5.529010039375827110978379567758782855597e-15,
-4.243647235089450477860082723948391492615e-15,
-2.442811167581709564856832301280823054155e-15,
-1.124929822095154155378655820855653819076e-15,
-4.316875921256675260527454324864201979958e-16,
-1.419863540245934208111235924093181004896e-16,
-4.085931470383536360774114291529143677697e-17,
-1.04496506194888354075615009765500667492e-17,
-2.404325118463794627962304513693451336861e-18,
-5.025332797242530798931696227071258796187e-19,
-9.611467038730876512069964163799012411799e-20,
-1.692286444303587617727276316922638413314e-20,
-2.806752379434470246859443208740645555983e-21,
-4.186452858289474618595207009160533424623e-22,
-1.904016124627554486334226517227156580198e-10,
5.873771091082123126339951603874127468892e-16,
6.762409985880847190951162721607481178621e-16,
5.190312476536418607361793881847450075244e-16,
2.987750648044867116495622124027325586182e-16,
1.375879271201923376259891700202824203963e-16,
5.279895823367289523006980905483684337218e-17,
1.736617508793497075587389515348264286915e-17,
4.997493153494035535713485316165101571107e-18,
1.278115278294754881024897213013753900878e-18,
2.940869287340848793826992151781495420626e-19,
6.147180313565810047353024230538781959877e-20,
1.175865788698887975893365360193692555057e-20,
2.070892465433597339812325829343111571759e-21,
3.436820637343913987605928260953199247653e-22,
5.132337553322305933730917029113938212028e-23,
// [{0,0.00001},{2.,0.0001}]: m=11 maxabserror=1.084752252448665545545e-20 maxrelerror=1.386025149687674063139e-18
0.01737605155260619345015160108838513911913,
-1.308335090121434551119146641526074052797e-7,
-1.506265555143264060788534771501232389196e-7,
-1.156084832735249390857778998744854916245e-7,
-6.654766932950917721003842166139156309232e-8,
-3.064456294481517895695651953901751331516e-8,
-1.175892611929827169490501151085304749717e-8,
-3.867095338742646214664445418780888225715e-9,
-1.112524677440829165673972677390320578104e-9,
-2.843680099151437272645154937844227562151e-10,
-6.53569746123253415746449081562859188038e-11,
-1.363012467126923989067248060665567940757e-11,
-2.595368790899570618141456036291611870159e-12,
-4.528436588932932438323118676333665343221e-13,
-7.351542314094971928871082213011065814683e-14,
-1.050979928536490963646804084349799092385e-14,
-0.0317709571370350868316801477640427537105,
2.170695620067357588273812163468438846103e-7,
2.499089451471594337251263041772796308318e-7,
1.918097114998373459711188686356096708426e-7,
1.104116761384923161630026634502880557962e-7,
5.084381307621757658204146776406989917887e-8,
1.951000592884420507981411357331512349237e-8,
6.416301123935312794807001907526575932503e-9,
1.845991769600851618274022660675840695908e-9,
4.718906713622637369878519045105442117764e-10,
1.084760612645076130617827386544588392182e-10,
2.263107552346807790189775431568947459333e-11,
4.312526572223162420726258108982391126301e-12,
7.536219529626654088784228197107449795574e-13,
1.227984119561856917403444404766759745931e-13,
1.768806932294773345361649950278557463163e-14,
0.02925862199948920386758412275329652634698,
-1.829335073634958986378955206049691132463e-7,
-2.106087407385229824652260146703797437028e-7,
-1.616462745434456663028560587275760546004e-7,
-9.304887916361163894553396626039134505151e-8,
-4.28485695144895717919229822996236639536e-8,
-1.644219362872660430486820206515760608307e-8,
-5.407485727063756948153706971457058464661e-9,
-1.555811535899417603390621034950437538448e-9,
-3.977423362414693088792349292212370384996e-10,
-9.144519809884003509633120573862466537351e-11,
-1.908384568610413409894641171603886605826e-11,
-3.638815853396829443494495093324359299232e-12,
-6.366936453590863751675916195329390612876e-13,
-1.040582209754752671904084054425954181138e-13,
-1.507976542314883476919153949854557792028e-14,
-0.01807530700502788460214669313486886190989,
1.041563222652269624248685378058121727334e-7,
1.199137494723950543898416158243228195154e-7,
9.20362092470780541761876447502845875186e-8,
5.297915562053386470206623220075557122689e-8,
2.439674800296531880434707525074613179567e-8,
9.361788475375203620338149044903421064337e-9,
3.078940922943952564077023189178412524265e-9,
8.858838498281391034453259781535141771579e-10,
2.264901347622956316987309099788588149876e-10,
5.207914534246489386045879828790930165734e-11,
1.087126832365552299711521267227200883786e-11,
2.073944448642376337290733266438844905971e-12,
3.63264934250012316312137991838101881986e-13,
5.951837066674503257586188955909513196487e-14,
8.668204501418258672554268043079726103926e-15,
0.008419803808926666105823409776785187028885,
-4.498819038199816334785469952293145507541e-8,
-5.179431014214350032502250569829165078293e-8,
-3.9753205910089321946807215197193225833e-8,
-2.288332865219558041491652313390546961424e-8,
-1.053774213338915035558438033265553027652e-8,
-4.043685516948190115218355236485566926038e-9,
-1.329920709914735837771412931579487473152e-9,
-3.826598279055330269354128667250301612498e-10,
-9.783827520002031362507904769002795102721e-11,
-2.249936531004574990311872329657140879002e-11,
-4.697651624337561917608586508679180978213e-12,
-8.965735129351391755024716652874373040196e-13,
-1.57179885112609862736966381805169005255e-13,
-2.580681219865771553351106122595941848366e-14,
-3.774131764075331467866928900930677750207e-15,
-0.003152305777434784333642070708685396080818,
1.569987383211383065916464022335062653115e-8,
1.807506415499026248623564203370289291028e-8,
1.387299614359133811455019228022047416761e-8,
7.985790839016337456660318084721290640681e-9,
3.677456562118477673738115557738118709583e-9,
1.411171707452640067715018335009065496559e-9,
4.641231648662640898536122594470017728611e-10,
1.335458471767426797360144286081818856906e-10,
3.414651291332797972565078868633954559209e-11,
7.85322484057765464606655688828812181338e-12,
1.639982513063095396088344271529800211081e-12,
3.131160894523172983775973117489538468418e-13,
5.493451754219140701083722202700843963436e-14,
9.035629538767217092945528541155365229407e-15,
1.326083694964192229231204720182864329468e-15,
0.000987519891518214588119021114144052492123,
-4.605399388231171899100443427006067300732e-9,
-5.302139129610430432374573255978461154306e-9,
-4.06950708278890828318779376237903936445e-9,
-2.342556186576788163588862683046083248608e-9,
-1.078749781836572792569179590412530568353e-9,
-4.139569691096823474793557263052459890595e-10,
-1.361485186767665300010612801430121353586e-10,
-3.917587825967399508884875360030818729547e-11,
-1.001733237934360423219427564101474573446e-11,
-2.304032299661203338473181888414557306821e-12,
-4.81226540196146311614891806103087430105e-13,
-9.190838199899613297671813629790623285611e-14,
-1.613538565998893673854464190508193338871e-14,
-2.658039913655822496460653489198805896847e-15,
-3.912794970526572832832382109286725409994e-16,
-0.0002661239840431350713025810523315657667245,
1.166814196180149594763627755700729017602e-9,
1.343339062039144454260447636624613767832e-9,
1.031042505112476996327569129707574984565e-9,
5.935061878063283484990472014853252706108e-10,
2.733108694820623702486582423503754084508e-10,
1.048801446143186398046450627763842220849e-10,
3.449489222629749194174846945690655600227e-11,
9.925861287515772151579216513255626185847e-12,
2.538146772018634340244340985465888818022e-12,
5.83826281342678909399857594456931481145e-13,
1.219567040379954516805032499819817782582e-13,
2.329877057664350891066521243576045493418e-14,
4.092657523285761621522024445311432546995e-15,
6.751035835957592614906315551939920345675e-16,
9.964032702356525808566207257731933942508e-17,
0.00006295441473693082065013670552045160678989,
-2.604256513821475464573758533472762438058e-10,
-2.998249726164082190398316083338045479407e-10,
-2.301224227981303208721218653421830121491e-10,
-1.324671026015169025260485834522180436973e-10,
-6.100150160888141414820263449377713574902e-11,
-2.340876874493236451498325578974894278733e-11,
-7.699161512661493903419367779185544934951e-12,
-2.215458045437279676477283076119949317847e-12,
-5.665333113004362283742571837382662540513e-13,
-1.303224349072748002322382481608896544434e-13,
-2.722670051552134466767287946952202385634e-14,
-5.202710168916348153048860439946464527481e-15,
-9.143669403563689085653762804953333549151e-16,
-1.510072401571965629119558895759391312834e-16,
-2.233880666838629107493473649423476591011e-17,
-0.00001327598970016617307447982717714658201743,
5.198057324315697620108222389027089805259e-11,
5.984463203455784087313866918201016924475e-11,
4.59321232662628355221889743065636633063e-11,
2.644027649240067561320654303264273142246e-11,
1.217584815030718034961658624559700660735e-11,
4.672386427308144189336996911171954298587e-12,
1.536761893841799566260648652162350901586e-12,
4.422141399692487465285193962369549597496e-13,
1.13085373902913047809174505822765412521e-13,
2.601500995566910152461991692920788540046e-14,
5.435601222722724672371853924514515376705e-15,
1.038908841742888851835114912737492764448e-15,
1.826678529378473923772129136396036982808e-16,
3.019903421969091312051822404051821324763e-17,
4.476471545462030936947135056006271332631e-18,
2.526259713992397390803570903295053160815e-6,
-9.388668326256137536105976651082204398847e-12,
-1.080906718717391481136214644950606750363e-11,
-8.296209354880101752158258849951843750976e-12,
-4.775617175985231557282458447738184743436e-12,
-2.199193281647830900958134194808968552634e-12,
-8.439257885035783816538244770907925194966e-13,
-2.775714173612088583288008599120340787157e-13,
-7.987412208253385501252006807371626797888e-14,
-2.042633933896998153715786357199394539974e-14,
-4.699259160719473335284686509386478822724e-15,
-9.81964251385143199603946685929198495618e-16,
-1.877200354074475960468279198950028806929e-16,
-3.301933840779192281185501140798168986192e-17,
-5.463914122322946157592360861030604203773e-18,
-8.113900095619330412974958638538691360009e-19,
-4.380436211844592761947902333913808948402e-7,
1.54920848107897580117822570489778197779e-12,
1.783586431408131985408958304669940596514e-12,
1.368944356192626950918209902265013616153e-12,
7.880175623926503264114984616010160362746e-13,
3.628861458188239951043738810033462746114e-13,
1.392555266431063983971488803577128480627e-13,
4.580209181505889446060176771531472110435e-14,
1.31801831474965209939133180519984820283e-14,
3.370663903773521600301202164319941888081e-15,
7.754850923906917053161356145082067036018e-16,
1.62060850937411993374131914334128790657e-16,
3.098628780922515815437105916745231588067e-17,
5.452337788407669739064339314031773236771e-18,
9.029864700471191212931765402444261731176e-19,
1.343098283469139201326045561495529032251e-19,
6.976573252774000205917537322054141550382e-8,
-2.353533888435351833846637291298292708671e-13,
-2.709597715398176754455464610520481476757e-13,
-2.079680348836551721516647839890327225837e-13,
-1.197145559215978207807961764800941962496e-13,
-5.512923801613675068470435225978789683289e-14,
-2.115558897642119899956421756216030129132e-14,
-6.958251979444622691840704261026726459158e-15,
-2.002352809138223419376440431281460661877e-15,
-5.120864050129508113139646737828411973426e-16,
-1.178198738931608246351997651796927785549e-16,
-2.462395979696308459732088898931109095274e-17,
-4.708888639675155158483893411423241373946e-18,
-8.288424543250469362092490806533582106826e-19,
-1.373718839064611788512220438946743858281e-19,
-2.046232431614422794009835118826419107366e-20,
-1.027833565960898274233941636415192211535e-8,
3.314334700628676672453925423100754746489e-14,
3.815757675800030298808030083462695693244e-14,
2.928685113895348012657975024654106316149e-14,
1.685866945502625015810353154774661115528e-14,
7.763522514314934686649647937769989917985e-15,
2.979222424704213724728477330178270654379e-15,
9.79895855382774423060270566086708636035e-16,
2.819838878203587422775720206233928226129e-16,
7.211652478732560530824132835151172242161e-17,
1.659303473416250973934981794447552385055e-17,
3.468140410277904085061473992159589239353e-18,
6.633152202105617513978904440337988014172e-19,
1.167887432282167000970244369719722435898e-19,
1.936974131594562496052947735041924111889e-20,
2.889027923898762765104040374745601053288e-21,
1.430599617299856509037359482805623394514e-9,
-4.412689059170913489615589901355099884202e-15,
-5.080281833738548704673804006100713293591e-15,
-3.899238623640147392792838009761857262206e-15,
-2.244557104197221187357227878801333694874e-15,
-1.033633648115870639366905355923893982544e-15,
-3.966538437417612873632106500038374502569e-16,
-1.304639412063991820361895137942764394925e-16,
-3.754382674237572882619723008087749401544e-17,
-9.601882265100980905468304546406680512035e-18,
-2.209337753979401704419129560433296077177e-18,
-4.618090384072933796156451326118585316605e-19,
-8.833735645103058280361951800461438661873e-20,
-1.555766914759100714972714556880381654244e-20,
-2.581931057984610010006720295071038569826e-21,
-3.855711243208619839956894484456542334194e-22,
-1.829641505803152899507664837905651217226e-10,
5.415523461436425735814484895927718126108e-16,
6.234835113079374136219942587080972500345e-16,
4.785387186225554878096620363983400632949e-16,
2.754660815300359082286916859117198229011e-16,
1.268541029813054856994914587795675374076e-16,
4.867997679612033523168731193330063959628e-17,
1.601145578137331611410355652616507690646e-17,
4.607678044065281163612101407821562476547e-18,
1.17843733454510223872268112119304546944e-18,
2.711597989321450436314750072943565991372e-19,
5.66828669655775058471425785277439646929e-20,
1.084391056666130332780963580989193173145e-20,
1.910257329899072909433656208256308063841e-21,
3.172035965879782882891948566619828477703e-22,
4.742084789400626518818917298161793847301e-23,
// [{0,0.00001},{2.,0.0001}]: m=12 maxabserror=1.045506042320124525566e-20 maxrelerror=1.471511616742610604041e-18
0.01588547856851754340655644196670289929686,
-1.085347810033678793882708850052390178754e-7,
-1.249544725735797168332976864993981363943e-7,
-9.590485574991867296309747025703128916527e-8,
-5.520583806924615806857131347214809837228e-8,
-2.542190653810878828506635799376965663758e-8,
-9.755002964422102537622070829609168348085e-9,
-3.208150561967656396651935374758386193702e-9,
-9.229958848004258089207275433580928182508e-10,
-2.359453356811318684386087898277266090598e-10,
-5.423803063225380651816214747051098396047e-11,
-1.13155377617340389482876941675885705053e-11,
-2.156263286111581209853914064330296614206e-12,
-3.768109764813327043494696945160668313596e-13,
-6.139920597809284585525542164093472627384e-14,
-8.84403466147386672457396708439802628722e-15,
-0.02925862199948919862679984681535294607209,
1.829335073634958837287999638729586471866e-7,
2.106087407385229653005395018024421313326e-7,
1.616462745434456531285399552061589929443e-7,
9.304887916361163136186589484796934884419e-8,
4.284856951448956829958651671257050517189e-8,
1.644219362872660296468962010958811292568e-8,
5.40748572706375650735061552242102766818e-9,
1.55581153589941747653814767375408357602e-9,
3.977423362414692764356142865240592956668e-10,
9.14451980988400276308096287562355450326e-11,
1.908384568610413253827756785987127638892e-11,
3.638815853396829144892394714643821681526e-12,
6.366936453590863225542208270559543591885e-13,
1.040582209754752584492589520092804650819e-13,
1.507976542314883346111766555069789776569e-14,
0.02711296050754183106299465870490897715129,
-1.562344833978404550271410238041874682741e-7,
-1.798706242085925946977659058529889102768e-7,
-1.380543138706170913288339022303559558513e-7,
-7.946873343080080284666425458888999966519e-8,
-3.659512200444798087450317236520207762749e-8,
-1.404268271306280645434293686905293799179e-8,
-4.618411384415929182870200165043220885998e-9,
-1.328825774742208752078460225757565774583e-9,
-3.39735202143443472334107252457769775542e-10,
-7.81187180136973464942821628910278812558e-11,
-1.630690248548328568807150877840668322252e-11,
-3.110916672963564734100531576091248196539e-12,
-5.448974013750185146788627398838843959859e-13,
-8.927755600011755554757787613796416186837e-14,
-1.300230675212738900994895640709701923555e-14,
-0.01683960761785421294185334352134695625109,
8.997638076399883215866513751358607437324e-8,
1.035886202842898851634645969707560835917e-7,
7.950641182018085782811129772316948944874e-8,
4.576665730439243525988527395894311116254e-8,
2.107548426677888759584044327914610755301e-8,
8.08737103389660544649923092391854628761e-9,
2.659841419829545752190608982158052431174e-9,
7.653196558110873713393412096682534758859e-10,
1.956765504000460793777220657176315027889e-10,
4.49987306200927543818905710504819056656e-11,
9.395303248675386104526904162392418053591e-12,
1.793147025870328530882354417337938713958e-12,
3.1435977022522856711570886328077514705e-13,
5.161362439731690001174097966588298214637e-14,
7.548263528150882756847352122469281208898e-15,
0.007880764443586661290699728585998861789869,
-3.924968458028375647860677856040839363153e-8,
-4.518766038747471196311200237915814844232e-8,
-3.468249035897762054939351047840790926123e-8,
-1.996447709754042645362654149221206444326e-8,
-9.19364140529600206595342904928234032769e-9,
-3.527929268631526444041427739670045249294e-9,
-1.160307912165635975313283680597330595894e-9,
-3.3386461794184972092712552711705103093e-10,
-8.536628228331816450164368528785857155658e-11,
-1.963306210144372590584279262115264303621e-11,
-4.099956282657652626944510221773611232583e-12,
-7.827902236307768160818530299893194655592e-13,
-1.373362938554756220032126632654950318612e-13,
-2.258907384691756144050527529516191493852e-14,
-3.315209237410408483712140505782560713756e-15,
-0.002962559674512358019189008414667421894299,
1.3816198164573225248177608060145266708e-8,
1.59064173886928021552402708825365892163e-8,
1.22085212482604310508924747083691991426e-8,
7.027668559669177490153994445010019793542e-9,
3.236249345481541301440431530825569043844e-9,
1.241870907318234134074659670929317508416e-9,
4.084455560267430763312076317856923957864e-10,
1.175276347779985066033655462793255609026e-10,
3.005199713776904914530426300393964526025e-11,
6.912096898923376248279470951584142999788e-12,
1.443679620575847052596000588343346470784e-12,
2.75725145994579199251429199810960534442e-13,
4.840615697954231171908392375795308097704e-14,
7.974119740896941564907427373556100008412e-15,
1.173838491147417951200965953656159775413e-15,
0.0009314339441589614193931499696489280226325,
-4.083849686652396917248893300795502635608e-9,
-4.701686717162188135977669985483150619416e-9,
-3.608648767912997710135022431464720178936e-9,
-2.077271657333275329441750192180956763276e-9,
-9.565880431923419575727203814887534941752e-10,
-3.670805061520814395144043638687023625961e-10,
-1.207321227926879340391411673284121707754e-10,
-3.474051450649131187017693592890760575883e-11,
-8.883513702112819878300836689115227383275e-12,
-2.043391984710329510324814326261072993747e-12,
-4.268484641352739938058249255636118764389e-13,
-8.154569701869045401194967234601330796763e-14,
-1.432430133157738725592804047134037808864e-14,
-2.362862542597993130865832738202839252978e-15,
-3.487411445844009763376242861443601109913e-16,
-0.0002518176598338937093943674137093706986058,
1.041702608049445489897463116439232385333e-9,
1.199299893367867346383254110739684960507e-9,
9.204896934200571198800338406523074880201e-10,
5.298684116883271427411686545664494547329e-10,
2.440060070260158635691998649602391381829e-10,
9.363507520632913933153767778178831627769e-11,
3.07966461251777147511556984039107781228e-11,
8.861832203197551624387893470283614679347e-12,
2.266133250687367817615343212058609277173e-12,
5.21289740891382410857415252719698116492e-13,
1.089068023259659659183246967179177984749e-13,
2.0810840726153559308997669560968102407e-14,
3.657467770321439171481333480972012229843e-15,
6.040289621067565369590626646246834444435e-16,
8.935522689471708101588906262892222691731e-17,
0.00005974195355031008662159481795467706307629,
-2.339125793192051569153173110022429518245e-10,
-2.693008438389041920270740819558721367323e-10,
-2.066945544551798034401930697428286384333e-10,
-1.189812440759206749223133022734209049289e-10,
-5.479131661196537359179465598323214643348e-11,
-2.102573889816671150866923836789407014165e-11,
-6.915428514157346078422774849533423636694e-12,
-1.989963627521770535325286490884068891802e-12,
-5.088841819646644183144709942674149007484e-13,
-1.170675446628008855383852711144463264325e-13,
-2.446020547346246390070670768317862506519e-14,
-4.675089782334097385947802055701046945417e-15,
-8.220053372494493893890221058074023599836e-16,
-1.358956538272328018878361940150598645861e-16,
-2.01441219304076955325051024044291364293e-17,
-0.00001263128911584707408116002716574237124076,
4.694331473785465459402428416670555046779e-11,
5.404530497374813373195814190764392669733e-11,
4.14810230102161222569806625114496956804e-11,
2.387807220030248086976864204491555876756e-11,
1.09959601086690497575181046202878585716e-11,
4.219626525067844946333803453800561121054e-12,
1.387856291673608781886661233376545777139e-12,
3.993703815927740834689817329255609065964e-13,
1.021316381721751886378118246492464102198e-13,
2.349628233708835368439374947834055718669e-14,
4.909818441748951640394672960317734818216e-15,
9.38599638410582228389523252001779763984e-16,
1.650965971334855463422487268056927475653e-16,
2.731955484407130822018518149704027827173e-17,
4.056947688263724276229422114149205683868e-18,
2.409240559362162655959100688090012900211e-6,
-8.52064840606048007430972432441682163872e-12,
-9.809727399159799823785823240651736031205e-12,
-7.529195514382818431933879411638234135271e-12,
-4.334097488466840183304741790855293056194e-12,
-1.995874214299623239173715771500333830087e-12,
-7.659055547553095327999156042979293812423e-13,
-2.519115570231313782483358286295156021506e-13,
-7.249102228726909130530970404010736998892e-14,
-1.853865530105510742315075741728500568955e-14,
-4.265168889552457677449783532383267240841e-15,
-8.913348644228444407296786790181993670419e-16,
-1.704246182100827681638243671465733655223e-16,
-2.998786405018860106327369267790914291539e-17,
-4.966426618136995068879218416453932150184e-18,
-7.387042106156891673860489184285500274458e-19,
-4.186480336087360468558462113461789347749e-7,
1.412272912788526399884452896227602585442e-12,
1.625934292690664808636096987127682034293e-12,
1.247943035291352577866796125432039902854e-12,
7.183649468108053079975122930338791745045e-13,
3.308111686784770853091404150732861898362e-13,
1.269472492501179594838801389737544022141e-13,
4.175402305684385359410469534018808812639e-14,
1.201541506344303622374976717227772835217e-14,
3.072850458202296824754592161075998816007e-15,
7.069956455361324600379410049552054080094e-16,
1.477597306744623563970907813515680503836e-16,
2.825638773403587275175111339603896641588e-17,
4.973593171772999472052383533328491813061e-18,
8.243207605437195845565485089557766514086e-19,
1.22787332776086795465446181465491912299e-19,
6.680715571962685941261237672853710659186e-8,
-2.154262081615089485662395825315656894801e-13,
-2.480178622862597392262443419766430065322e-13,
-1.903596304994703958733987940064386820746e-13,
-1.095785297229139360010499412585682821925e-13,
-5.046159691182559225375325437764087129073e-14,
-1.936444710510889071450854964724238900191e-14,
-6.369159044849998831334640750240953862748e-15,
-1.832848070938665438771338851320802888071e-15,
-4.687453391807609661730909355469775346173e-16,
-1.078519478572134637990224786358036555889e-16,
-2.254233191330814182683856845015914497261e-17,
-4.311437804693252997828220617980487363088e-18,
-7.591072465233812225909319345864230631651e-19,
-1.259000632382005765543223596011256453125e-19,
-1.877819391400150917485285337166765971175e-20,
-9.860139449461469511384066778182475935151e-9,
3.045059488485893156318586098208451871684e-14,
3.505744489213164184116732912516686563003e-14,
2.690743284641976457153305288206575372832e-14,
1.548899018410819597893945210346153834233e-14,
7.132784006245059746418957193098135548328e-15,
2.737184543943314200014565290337364718663e-15,
9.002909008709181654531724928678722649092e-16,
2.590781656872490969053795472545228585299e-16,
6.625954852836819543737413775387570080752e-17,
1.524592743189258254908186384855960353297e-17,
3.18678994528002673266465891617268277896e-18,
6.095845698868905920828280070213698209639e-19,
1.073571984885192834295936503940354866803e-19,
1.781658508569691595377961680678177541563e-20,
2.660549022094717537794182962377292077619e-21,
1.374724881875941076788038444489920025762e-9,
-4.068470472489868289062156525372363634527e-15,
-4.683987198631669486057775497999602968896e-15,
-3.59507379584071209035373653874807855201e-15,
-2.069468684967413861542811412607563639349e-15,
-9.530051502317939675387822794484234092678e-16,
-3.657135856751444809625637628086405290539e-16,
-1.20287792979147547811648205527257939959e-16,
-3.461568033722497360572783015530274236463e-17,
-8.853138501326894927405696765617349629744e-18,
-2.037117630669329421409789465710222211863e-18,
-4.258363106033234741618159977378512325724e-19,
-8.146610720774252505807868607484880854206e-20,
-1.435103510008574971795376823510911347269e-20,
-2.38303371197871393046424099466328067965e-21,
-3.562565009516798838178989466280771581165e-22,
-1.760852254525407672541173932429495624579e-10,
5.00882976044310843743927520773858761392e-16,
5.766613563345812588475029545730092577304e-16,
4.426016747195772816121681334252728107258e-16,
2.547793878426668102457294920142156363565e-16,
1.173278339911944242499924824120370374928e-16,
4.502437045425458647675874920363716123704e-17,
1.480913223378326290600540330030874501381e-17,
4.261710312576100342745728706248167473375e-18,
1.089969420361275826347470341521452807182e-18,
2.508101919149679399153557045299808770101e-19,
5.243192934298280413256844250400389729508e-20,
1.003178097613949112501751079358347060929e-20,
1.767589948648048345135203831176201607564e-21,
2.936665205248276029307938855844159112295e-22,
4.394597555594602528765662801914957655945e-23,
// [{0,0.00001},{2.,0.0001}]: m=13 maxabserror=1.008999108096333415253e-20 maxrelerror=1.551306711327815817615e-18
0.01462931099974459930444100207812636017727,
-9.146675368174794184075646183243538340475e-8,
-1.053043703692614826230492070988266586454e-7,
-8.08231372717228265433775374085408140218e-8,
-4.652443958180581566890640637119750307662e-8,
-2.142428475724478414425493678585370328421e-8,
-8.221096814363301480219481395523770354395e-9,
-2.703742863531878252976253754802667767668e-9,
-7.779057679497087380679005175993938866901e-10,
-1.988711681207346381663540544838537027197e-10,
-4.572259904942001380356448714956579100679e-11,
-9.541922843052066266663316571561804292063e-12,
-1.819407926698414571972474134493008141886e-12,
-3.183468226795431611936076136427978115226e-13,
-5.202911048773762921074353374992919390254e-14,
-7.539882711574416728477191046779898699569e-15,
-0.02711296050754182601214255283028512580106,
1.562344833978404411973945415005581685837e-7,
1.79870624208592578775721156767430142822e-7,
1.38054313870617079108273260526175599492e-7,
7.946873343080079581201351153334619969737e-8,
3.659512200444797763499074838045399536407e-8,
1.404268271306280521118319392478642969859e-8,
4.618411384415928773976627027363354551108e-9,
1.328825774742208634408022616969728460407e-9,
3.39735202143443442238486973982814441104e-10,
7.811871801369733956887578951675921626842e-11,
1.630690248548328424023958145323054441531e-11,
3.110916672963564457059179260316744855876e-12,
5.448974013750184658543630738626905641929e-13,
8.927755600011754743200654636910565402902e-14,
1.300230675212738779437422871018760104786e-14,
0.02525941142678132342706115766128471192174,
-1.349645711459982588319792095563843435924e-7,
-1.553829304264348399419398631079649327817e-7,
-1.19259617730271296103468648823598144e-7,
-6.864998595658865827857514166010624513491e-8,
-3.161322640016833387532331046995071485167e-8,
-1.213105655084490912204750682134942182835e-8,
-3.989762129744318941511913381803204003538e-9,
-1.147979483716631147148991864831089198855e-9,
-2.935148256000691421212328317643949965843e-10,
-6.749809593013913687814609747890774652372e-11,
-1.409295487301308026597612883597238737656e-11,
-2.689720538805493008585297571568893273615e-12,
-4.715396553378428880887709021072120854892e-13,
-7.742043659597535623950437204713755110552e-14,
-1.13223952922263250679952739526107823172e-14,
-0.01576152888717417139359010149084973268182,
7.849936916056983703989889960813309837851e-8,
9.037532077495209961869355869931207407747e-8,
6.936498071795729475851486747155136103474e-8,
3.99289541950820350771515907424637720526e-8,
1.838728281059254853051525597311936262183e-8,
7.055858537263261800519687857650651858715e-9,
2.320615824331340665008124195006955230419e-9,
6.677292358837192163185766505957321977362e-10,
1.70732564566641386558826790151960272721e-10,
3.926612420288861562314764485863198143603e-11,
8.199912565315548561407272386505370067264e-12,
1.565580447261600188843546130319264411123e-12,
2.746725877109594489434415667961618334679e-13,
4.517814769383648669976732340814369736654e-14,
6.630418474821021244405621338860613681433e-15,
0.007406399186280605981393264251901221220615,
-3.45404954114323002594178025821254401365e-8,
-3.976604347173112711397360618676415217932e-8,
-3.052130312065040353012977827835533467253e-8,
-1.756917139917255568758807578558847442619e-8,
-8.090623363703674558987877749320783809804e-9,
-3.104677268295516761201165002501709596948e-9,
-1.021113890066835135766169857397006625203e-9,
-2.938190869449897756269788060815238841363e-10,
-7.512999284442096272312912668067432345195e-11,
-1.728024224730805859110424545438141816542e-11,
-3.609199051439537760233455962738880349058e-12,
-6.893128649864327133902216790043294513588e-13,
-1.210153924488530850692870753917104600468e-13,
-1.993529935224190588048091789244544802796e-14,
-2.934596227868477713524326080774552464153e-15,
-0.002794301832436130939257981840198049099202,
1.225154905984560846167934161455361606041e-8,
1.410506015135810086609594450128905924575e-8,
1.082594630364039420493384582890041272015e-8,
6.231814971943068444630761597280773673445e-9,
2.869764129550888573965467588929856759181e-9,
1.101241518446214155544856801772966817846e-9,
3.62196368374764733575968913119828848377e-10,
1.042215435185245373640796889666508386376e-10,
2.665054110609563968755955772301089347862e-11,
6.130175954075112398962657231546768960339e-12,
1.280545392394140464483028570900134323361e-12,
2.446370910538361139382176284139402929817e-13,
4.297290399433823179863393708311156891356e-14,
7.088587627728500621913744012996359035674e-15,
1.046223433743395312928287608142422426695e-15,
0.0008813618094263372430315563934295762049515,
-3.645959128193404188729347270751176916977e-9,
-4.197549626810958673724680427144361746877e-9,
-3.221713926988177621403184270826896703998e-9,
-1.854539440919493698312440692040257098513e-9,
-8.540210245958211838003929769223997703556e-10,
-3.277227632239808082588426280179376675236e-10,
-1.077882614387235294743315983936334572648e-10,
-3.101641271136453798844698525730042466242e-11,
-7.931466377450062146888536035451409282827e-12,
-1.82451409313002690221343576012125520923e-12,
-3.811738081430109917254842111025873013584e-13,
-7.28379425419450909582598746950046506749e-14,
-1.280113719619689030707234695728155594536e-14,
-2.11410136738559657791229124101843224562e-15,
-3.12743294133301014099454569142381035103e-16,
-0.0002389678150552965967037897094638957205089,
9.356503196151865842636775546819633872078e-10,
1.077203378047753421025136364938607691479e-9,
8.267782198870002567838024212765729646455e-10,
4.759249774931179398817615082844055161734e-10,
2.191652669956058505320171725047119439238e-10,
8.410295580286321057736508271001655567239e-11,
2.766171412576606879895900808775253358717e-11,
7.959854529983075915091981149309208719e-12,
2.035536732947295870981896474435759865543e-12,
4.682701798221675643127471106584878908467e-13,
9.784082213865270439311334426122969718523e-14,
1.870035917617920322488686301340016704315e-14,
3.288021357253162804008154598798294909865e-15,
5.435826166811326128584652760467287132851e-16,
8.057648792716348653894794432062732718887e-17,
0.00005684080092438700447880494696501158945029,
-2.112449160645598446389391992112038112076e-10,
-2.432038720873826697423422163425703667824e-10,
-1.866646033199488533396784745624348667872e-10,
-1.074513247712527015137000881102339929308e-10,
-4.94818204290947014144877182979911432531e-11,
-1.898831933981255286807059247790903203693e-11,
-6.245353304968562777201324216878516936231e-12,
-1.79716671499110104152349190362184140711e-12,
-4.595923712181459722853466006899617985841e-13,
-1.057332703888036680885548238133294553726e-13,
-2.209418296108957499529409508006337807057e-14,
-4.223698367722671010794626021785896209785e-15,
-7.429346861973142994912333813271490498929e-16,
-1.22937996648096494073820364114456988715e-16,
-1.825626457466660336282407487480648438458e-17,
-0.00001204619368530221978266927344860564378786,
4.260321708371995137458842628179350933119e-11,
4.904860827505544388001711403334026800454e-11,
3.764595552803757169613480838774274938805e-11,
2.167047475298409753813516406041262996543e-11,
9.979365227951810142525614888303288928734e-12,
3.829525531321328714914049790495211555066e-12,
1.259557047539060720629400205239267959993e-12,
3.624548991782728970878201869994538028592e-13,
9.269322221773644550441001291659386825005e-14,
2.13258319554700238407847528906178322754e-14,
4.45667171046371767957328053867712876361e-15,
8.521225913133308425693117830414304861072e-16,
1.499392321795384939766430012911082955201e-16,
2.483211845151177334214233918303288102914e-17,
3.693518860375801819803149335757274815457e-18,
2.302564805211842299947200373957990255648e-6,
-7.767502657478422768571382276986573988626e-12,
-8.942640494623017190633401538380663060254e-12,
-6.863688140751724615173434900847881590329e-12,
-3.951008040209785992389075489973853187134e-12,
-1.819461811220047351418155059107853066736e-12,
-6.982100180391761185448378700048184503134e-13,
-2.29647175217038898127243061061922427139e-13,
-6.60847967787236956552591763884722686737e-14,
-1.690068108286428175220956838175719008501e-14,
-3.88847687030517079204897642909301886282e-15,
-8.126786901176395082160433789370587182324e-16,
-1.55410165339085362558264923923355831233e-16,
-2.735476822671417109276062940818901798819e-17,
-4.533765144491554162424460654166688625055e-18,
-6.753304744072311724325101172356727702523e-19,
-4.008946289833195939725349756768764218539e-7,
1.29269878338889527941673622305770144946e-12,
1.48827012083806758714898259103030428787e-12,
1.142282848916412314987777931028859156596e-12,
6.575431713573301116742415519524240509246e-13,
3.028027348272594141189026674622378229546e-13,
1.161994051989378716964716288246778099615e-13,
3.821913890946107013492907266253909320868e-14,
1.099829267167692575602916990558473493183e-14,
2.812780035405376740890857941780411290323e-15,
6.471825621564684377972135596634115255328e-16,
1.352688086777123696284505941111595573357e-16,
2.587146208632636068927463581138095551039e-17,
4.555143152248284804886760144331063728836e-18,
7.554834347871333677983259479222699755133e-19,
1.126816037865404676503289958246666592142e-19,
6.408895121588518907414578189780367538028e-8,
-1.979237069806066674067036728547038507774e-13,
-2.278674514071006092770521095227102255041e-13,
-1.748937541042234147795684876566488743122e-13,
-1.006758116214606870238143966171247899208e-13,
-4.636188740199707527760472039849463181876e-14,
-1.779123572105925628529222896032909800182e-14,
-5.851738299756458866770528540103029210779e-15,
-1.683964174525254900295975343230556448345e-15,
-4.306758367273508920705018768324411596065e-16,
-9.909594436973451727459339347589037409414e-17,
-2.071359441825214269011250738349451226955e-17,
-3.962196322711992371555778199451324537734e-18,
-6.978035671910761558390003804741931335929e-19,
-1.158047726984531779866653306360267920406e-19,
-1.729311436212995037018234666051237930572e-20,
-9.474599080770479554844726890380335636227e-9,
2.807278806909172531469872155385733800189e-14,
3.231990509436387617213291232504685303295e-14,
2.480631100441672529645872389529531681771e-14,
1.427950749024051482829321665945077642426e-14,
6.575815305841589523487838752668953907346e-15,
2.523454230996827622568397579344831639127e-15,
8.299957201592510722565141485632714974913e-16,
2.388510112853884472474690319497042200139e-16,
6.10873525756664768601863695010964622081e-17,
1.405626116836955178904882542905390229648e-17,
2.938297256379998130795379420854612555019e-18,
5.621195203682419362798973804906636531145e-19,
9.902211950684725889884050563287483562898e-20,
1.644269016319661344109651005675695697758e-20,
2.458065328425371482571732163911757292443e-21,
1.323045724111840653901245918263696160939e-9,
-3.762973118551805510253335404953283896156e-15,
-4.332271781794728909429784534571036116233e-15,
-3.325124401249880871893728603969180082407e-15,
-1.914075813397010012385917508897869091538e-15,
-8.814463829465842425339212753843558350829e-16,
-3.382536550551286653078954378147546065652e-16,
-1.112562620578424617839565857880148515931e-16,
-3.201686376399606362643119218581353531678e-17,
-8.188591276370061028378875917422922422281e-18,
-1.884256825903541155063411833087750616453e-18,
-3.939043962474161129509462466491460116643e-19,
-7.536560238585867977852269066719261061967e-20,
-1.327935400186796965769527434028285101704e-20,
-2.20622875887213420361962625857235135878e-21,
-3.30153959795576293551205030103360877861e-22,
-1.697042612142780857794383793777477799226e-10,
4.646243851075817567005131594977594670038e-16,
5.349172714261729562434112274599229378831e-16,
4.105621520134918878355014893023258524349e-16,
2.363362397975380386288815980133557688863e-16,
1.088347118252589847287577671411219846505e-16,
4.176521499083603601043054958683112207259e-17,
1.37371952461020110668203622518203271427e-17,
3.953258023914355365614250087955032425364e-18,
1.011092999457931289701342435378882698794e-18,
2.326660900676008137906961165279967743019e-19,
4.864139569411020762298128490971779372709e-20,
9.307489926403151041131831036898375936623e-21,
1.64031016545335266749923372106817764247e-21,
2.726514017585753888577340845993713977295e-22,
4.083863118667746326463892496569406404862e-23,
// [{0,0.00001},{2.,0.0001}]: m=14 maxabserror=9.74954376049471808027e-21 maxrelerror=1.625927804284541904526e-18
0.01355648025377091299741514014009648867095,
-7.811724169892022057665023921778341049129e-8,
-8.993531210429628936247805343143429404174e-8,
-6.902715693530853953465491162652350631268e-8,
-3.973436671540039789479227975817262749446e-8,
-1.829756100222398881233101174290103535188e-8,
-7.021341356531402603609772246069365371336e-9,
-2.309205692207964386336458421146726243391e-9,
-6.644128873711043170164198329618166998597e-10,
-1.698676010717217210712636311371212954191e-10,
-3.905935900684866977339658118453432922889e-11,
-8.153451242741642117811272154440951433569e-12,
-1.55545833648178222808777620220353936167e-12,
-2.724487006875092328492896144941738431051e-13,
-4.463877800005877370304504266044527381699e-14,
-6.501153376063693895243020734313776481177e-15,
-0.02525941142678131855286980065609767885786,
1.349645711459982459685797684626942709398e-7,
1.553829304264348251324391458242685831461e-7,
1.19259617730271284736810792776264119886e-7,
6.864998595658865173546308413288827454319e-8,
3.161322640016833086216611989990531219332e-8,
1.213105655084490796574965515089528760551e-8,
3.989762129744318561187372645045211019249e-9,
1.147979483716631037699436258460783811513e-9,
2.935148256000691141278700247360574020359e-10,
6.749809593013913043634473663691203106662e-11,
1.40929548730130789191831872546450263141e-11,
2.68972053880549275085331749883236977779e-12,
4.715396553378428426585667691413229104835e-13,
7.742043659597534868477274934734156742323e-14,
1.132239529222632393546521153187372633018e-14,
0.02364229333076126096899691968826671379021,
-1.177490537408547654384963953501841390793e-7,
-1.355629811624281608012281596116678058683e-7,
-1.040474710769359508669765694168762067427e-7,
-5.989343129262305764061526561713606882953e-8,
-2.758092421588882510977687775909789176584e-8,
-1.058378780589489358877884577021794303e-8,
-3.48092373649701128958992186404269363292e-9,
-1.001593853825578908532272308218686305111e-9,
-2.560988468499621013366496901668320841431e-10,
-5.889918630433292838202024412156289165642e-11,
-1.229986884797332387649247707223277165152e-11,
-2.348370670892400481229365743844151024257e-12,
-4.120088815664392083163219100775191137166e-13,
-6.776722154075473585586696262574631682e-14,
-9.94562771223153273770190117628832866988e-15,
-0.01481279837256203108717487580523685604152,
6.908099082286676221045028857733273090903e-8,
7.953208694346474296147883991765168300154e-8,
6.104260624130271722476082433631998082332e-8,
3.513834279834621094380404917426409034359e-8,
1.61812467274078554784185912997841576909e-8,
6.209354536591227838017364431404354512059e-9,
2.042227780133734184992920038716456267928e-9,
5.876381738899979442292470230785719582418e-10,
1.502599856888466297251450578283782621241e-10,
3.456048449461719972562153428241391421098e-11,
7.218398102879301848753469861335940527687e-12,
1.378625729972908738590716863995760653131e-12,
2.420307848977138046765207099951987305092e-13,
3.987059870448508133260345401531811782976e-14,
5.869192455737145748660059774153668459652e-15,
0.006985754581090048050974579090431074847249,
-3.062887264961330980315095141835085676187e-8,
-3.526265037839443319395637101657954220257e-8,
-2.706486575910035693152369155687751421093e-8,
-1.557953742985730927468991072593014464529e-8,
-7.174410323877054805921776460759873008031e-9,
-2.753103796115471444966223003769793118837e-9,
-9.054909209368908017296030027008673861483e-10,
-2.605538587963052907407892019875495049033e-10,
-6.662635276523755114105237341275565021755e-11,
-1.532543988518742474762582241585032642864e-11,
-3.201363480985276676478165473322042574616e-12,
-6.115927276345760296623729492355459693907e-13,
-1.074322599858430663006242318424286161234e-13,
-1.772146906932083345521212534167547305414e-14,
-2.615558584358425555775242250573377587986e-15,
-0.002644085428239683762553128325496364993872,
1.093787738447642676699578383561413140506e-8,
1.259264888031338848797912330169172038865e-8,
9.665141780872823229019472870777767062016e-9,
5.563618322705689286860149069699821410719e-9,
2.562063073763152487365499300452973667335e-9,
9.831682896626130637846991344586458223257e-10,
3.233647843131020149239824382397034879318e-10,
9.304923813321054182106567990297682089623e-11,
2.379439913212432751358430217697353503645e-11,
5.473542279338106301608102513619189395908e-12,
1.143521424418166641197632322471616056348e-12,
2.185138276237558128935337905764020389078e-13,
3.840341158822412615376075620667676763477e-14,
6.342304102095835824918815166068290039335e-15,
9.382298823907654324662336821641555288922e-16,
0.0008363873527009868051427118251490973785237,
-3.274776118672124292193539544590990202494e-9,
-3.770211823188978379155085219133074512337e-9,
-2.893723769621264720259713677764922392084e-9,
-1.665737421235562732579288609659399105196e-9,
-7.670784344890643584306942077209320651058e-10,
-2.943603453117265771140193722373925603394e-10,
-9.681599944074215550149067720415662423684e-11,
-2.785949085510218626819218839499044462989e-11,
-7.124378565356821728927349478717443133228e-12,
-1.63894562938708741385008899458607619094e-12,
-3.424428774872709223394353980202636908181e-13,
-6.545125711700738731171790173885359729674e-14,
-1.150807475045309504044719253820934710069e-14,
-1.902539158395114576962547427423826556507e-15,
-2.820177077467450775354760286322008303381e-16,
-0.0002273632045217339488975374623482201137822,
8.449796664332208060258443650513779927821e-10,
9.728154908535646368336429936711020287424e-10,
7.466584152017033702283180476131727918188e-10,
4.298053001913394464836534776260136627045e-10,
1.979272822258522904371653477789710029549e-10,
7.595327755476045531572655355158670745497e-11,
2.498141328418064403160877781598578256997e-11,
7.188666878470457361111621299042790506338e-12,
1.838369489605784186991990464389509584897e-12,
4.229330826444134681762622495583575581612e-13,
8.83767320720780415039259427716740937118e-14,
1.689479351446877633129673733005051791426e-14,
2.971738752470733595478132763778076977658e-15,
4.917519878697636002505694507052873271324e-16,
7.302505849015834551253953105310543670855e-17,
0.00005420787149021083024168128848479701138566,
-1.917144766382246991344620370391191910667e-10,
-2.207187369631494900545654729075923386493e-10,
-1.694067996654067433254989645745558004307e-10,
-9.751713626710500076503552110536322764931e-11,
-4.490714346991266111046597683064012508801e-11,
-1.723286486950567396888772172948514676584e-11,
-5.668006706873700434142665725944080060692e-12,
-1.631047044272775839788349864556041768476e-12,
-4.17119499460745510310554706531917303157e-13,
-9.596624368016501689041080243221003984435e-14,
-2.005502267211209584125349932386675874404e-14,
-3.834551656130244121263236802074100920321e-15,
-6.747265439652517856581109956289569596469e-16,
-1.117445328916147018141695394427312500094e-16,
-1.662083485065896840258624243275418770078e-17,
-0.00001151281523321885946208391303826301189584,
3.88374900838400779934089782237889501423e-11,
4.471317575910203344884679887631815733463e-11,
3.431842020009329257022781733086872550339e-11,
1.975502839830254439698631089034949219694e-11,
9.097303620837953414511258160902985273619e-12,
3.491048004416175522730161560612927466247e-12,
1.148235190039457231146402187121393162749e-12,
3.304237864638085851664300472452219568501e-13,
8.450335491869015005655912876045438168256e-14,
1.944237273152718979668381416944769690104e-14,
4.063391021184916178469187486990934318805e-15,
7.770503617872788197366750894195851367485e-16,
1.367737591845690501896951480540685570353e-16,
2.266881209489071912653800217975258580253e-17,
3.376650329124385582220274440478984032968e-18,
2.204921058806341823730323225162276531132e-6,
-7.109844835238940360241511716398103875973e-12,
-8.185487422168567512538273265131025327033e-12,
-6.282557018010624674598873591236826152102e-12,
-3.616488218987961859414463454422914915807e-12,
-1.665415399145269917950560202055118420426e-12,
-6.390968658214148310578122976371498790742e-13,
-2.102053091383617707129870616012236783496e-13,
-6.049062268359774544100762706347664181605e-14,
-1.547029351699316820067860017412439812129e-14,
-3.559504856392988152968997524773825438435e-15,
-7.439786075759119734570756654992987274094e-16,
-1.422930720672354490003003019192280109341e-16,
-2.505329273082863008740458966329153594837e-17,
-4.155159788595125163997396496717195581613e-18,
-6.197489554408184018220862892942549407795e-19,
-3.845835939955996089805064345706944178319e-7,
1.187673887309078262961158269505840495988e-12,
1.367356270479661870829144978280988349263e-12,
1.049478852235074157765092874928077416684e-12,
6.041218326475066019873374547841510133938e-13,
2.782021613896484721875990588924332900382e-13,
1.067592480040792183321187103285480577087e-13,
3.511432208119188995790702640412855785378e-14,
1.010490516580198722912373989857758445951e-14,
2.584341507488486229107216268205865803898e-15,
5.946415923181296092252003752835363095989e-16,
1.24295349736988405314214781182192722464e-16,
2.377581559423360926656903344537744365211e-17,
4.18728634110919788880207743222244394411e-18,
6.949059522508470980549975115109223044167e-19,
1.037702766438737191095885321775802387501e-19,
6.158300489693698905581626430322176975863e-8,
-1.824683110700085924134360469927859943246e-13,
-2.100738438211671709349775133048248778255e-13,
-1.612367699842989241167930519964054991023e-13,
-9.281435132328449738986456255495428332888e-14,
-4.274167245617572474178652178669781215883e-14,
-1.640202000289070303047583409272876234391e-14,
-5.394829925059595582981996887664727135919e-15,
-1.552490634795498906059709582898243322574e-15,
-3.970573209770901338273682518299484853706e-16,
-9.136328802068600080183390208675456223745e-17,
-1.909842837261457220124841253746059139512e-17,
-3.653680464321135285239926243541694779855e-18,
-6.436267782381981711127799086567779634246e-19,
-1.068746581512789174990113965946995364137e-19,
-1.597700036963287222154614992293028588882e-20,
-9.118037690481855450668887806397308375563e-9,
2.596270885245737448225458099222370247786e-14,
2.989059636691110522664321197483129147493e-14,
2.294176261280639617706246383440737908119e-14,
1.320620438337804856206169347060041699311e-14,
6.081556824703441845288515798013018316939e-15,
2.333787706439323958965850373829805764703e-15,
7.676146866528847252401068125470012914826e-16,
2.209009182448276574715480487404939570236e-16,
5.649731022716182107398947530405976277735e-17,
1.300044934967240772447269163923884781714e-17,
2.71774353070415468122030647217670849965e-18,
5.199835157988636142761999593060030069567e-19,
9.162011492338102791850397536976616546589e-20,
1.522153937948033211395492977688939979454e-20,
2.277788349400644901806608791064745607844e-21,
1.275107162118632268952805493456560358686e-9,
-3.490604876842316744209140816212814460158e-15,
-4.018697461345902806376515992997533363039e-15,
-3.08444906745835678228754914073989928277e-15,
-1.775534086022437639579374926886979212609e-15,
-8.17647522955318251729946614417271188287e-16,
-3.137714445625988436282937057108558186725e-16,
-1.032040572331236314802784987703314689295e-16,
-2.969982357652801787978543241822676454079e-17,
-7.596085224743612062528933562134532947584e-18,
-1.747961450541028591108939224222251502032e-18,
-3.654305521774178357411185024541864446742e-19,
-6.9924848682175817168987877485466239534e-20,
-1.232324857042116049244393360067426211544e-20,
-2.048366188575642523419478982461557753919e-21,
-3.068119321193432802756209649151602630696e-22,
-1.637691279331433079056361805935759862899e-10,
4.321615900529780547210604662398236221949e-16,
4.975432356351422143205661031219927080432e-16,
3.81876731589112290496882353999989971962e-16,
2.19823828661927430032913842612034916415e-16,
1.012306904204351157968307235704120941377e-16,
3.884723658228390795423564157324180574798e-17,
1.277746688537945645573702555421190101047e-17,
3.677091381206191918460490672141888571859e-18,
9.404712084192284174579267890646267294047e-19,
2.164201947353156167148223665544095567678e-19,
4.52471607198332170726831566397612472203e-20,
8.658823801654567034509757045539104607839e-21,
1.52628440017346612976314314305654732102e-21,
2.538108875589683566049880550114500108983e-22,
3.804887013006635993959160000133144137252e-23,
// [{0,0.00001},{2.,0.0001}]: m=15 maxabserror=9.43130920909249988976e-21 maxrelerror=1.695839431120148486841e-18
0.01262970571339065926806176987668152279615,
-6.748228557299912296368306026262229794063e-8,
-7.76914652132174125424951425036983965589e-8,
-5.962980886513564235019630361066935506057e-8,
-3.432499297829432585724963833557268203412e-8,
-1.580661320008416542625605024251041767199e-8,
-6.065528275422453981022459649189797574054e-9,
-1.994881064872159279984410164357364640339e-9,
-5.739897418583155186743791641128991752332e-10,
-1.467574128000345570190884956067550165215e-10,
-3.374904796506956520785189990593160479009e-11,
-7.046477436506539457433700976003974324639e-12,
-1.344860269402746375013639029626782290598e-12,
-2.357698276689214212564557755642089729946e-13,
-3.871021829798767433026601010451910347579e-14,
-5.66119764611316196591288972068014170549e-15,
-0.02364229333076125625953767170889022084512,
1.177490537408547534436705342933018991586e-7,
1.355629811624281469917061714636341695565e-7,
1.040474710769359402678252874656981994249e-7,
5.989343129262305153930921624235153557675e-8,
2.758092421588882230007307874359640901707e-8,
1.058378780589489251055467141131408891869e-8,
3.480923736497010934944067707760003589855e-9,
1.001593853825578806471952615872864371926e-9,
2.560988468499620752329079096509784394633e-10,
5.889918630433292237492425569282208810537e-11,
1.229986884797332262052844028239477042208e-11,
2.348370670892400240857989827051190455456e-12,
4.120088815664391659387299164365880469116e-13,
6.776722154075472880585932417786629259505e-14,
9.945627712231531680005262089521631550023e-15,
0.02221919755884305038256713078774437345961,
-1.036214862343001525490137096602369277421e-7,
-1.192981304151971250724683033993735164945e-7,
-9.15639093619540839961236005336779075169e-8,
-5.270751419751932111235234464940540652061e-8,
-2.427187009111178538047518342052255538889e-8,
-9.314031804886842587020019246334191002641e-9,
-3.063341670200601550488891726661153712853e-9,
-8.814572608349969949083298241397258221406e-10,
-2.253899785332699646821806082323950674644e-10,
-5.184072674192580421274400016465908622514e-11,
-1.082759715431895374002123642887620056562e-11,
-2.067938594959363292948604761604538209103e-12,
-3.630461773465707396467875664182009863445e-13,
-5.980589805672762742970079000492421980095e-14,
-8.803788683605719438354011428102205596456e-15,
-0.01397150916218088754310323107587125063909,
6.125774529922863533703197149226819740252e-8,
7.052530075679118707836400737873234973705e-8,
5.412973151820249505063627341358087455935e-8,
3.115907485971564387398592148030360715857e-8,
1.434882064775458178262448522240276891986e-8,
5.506207592231124085527148587106397597745e-9,
1.810981841873841201702386907164374725374e-9,
5.21107717592627732720479742432085358084e-10,
1.332527055304794890164935486762487631283e-10,
3.06508797703758589878784409702561730861e-11,
6.40272696197076441774819888932118584235e-12,
1.22318545526919245374315354471622615275e-12,
2.148645199716932541577905961137168549858e-13,
3.544293813864285166483613342971867815386e-14,
5.231117168717028857639465884860884054567e-15,
0.006610213570598939240452306925596171162329,
-2.734469346119040203416656996909608926355e-8,
-3.148162220078270574642562881921365855229e-8,
-2.416285445218147055250519806968286123045e-8,
-1.390904580676388501641670458323270226693e-8,
-6.405157684407725473973908796694349036231e-9,
-2.457920724156472892437704742553567377598e-9,
-8.084119607827353788920329812841697843797e-10,
-2.32623095333020697205634705950475611392e-10,
-5.948599783030937180205604565139875114001e-11,
-1.368385569834493276202273638323514179663e-11,
-2.858803561045346978150438777465322767741e-12,
-5.462845690593762060683279574015578613357e-13,
-9.600852897055796558654242330384390575852e-14,
-1.585576025523919849615172810930618896356e-14,
-2.345574705976854867617683876410825725774e-15,
-0.002509162058064961560625694128253566843293,
9.824328355919594756306038977335923672e-9,
1.131063546945551546405817528678656494023e-8,
8.681171308778276792731517930385896529235e-9,
4.9972122636574608944106320120961080936e-9,
2.301235303444523479611116988676893053858e-9,
8.830810359264802712327725102119642928692e-10,
2.904479983193650694567372869026045878037e-10,
8.357847256448310324862028426415804000719e-11,
2.137313569585985178195935553845185756286e-11,
4.916836888112795053334779371575894290102e-12,
1.027328632451679243588454118914107793309e-12,
1.963537713490827678889196365247437508283e-13,
3.452422425101736893708507820539143888536e-14,
5.707617475128461955565382167046943277524e-15,
8.460531232317013825631583133528323248322e-16,
0.000795771215833274013778145632996995338536,
-2.957428832534004813367136573574936829953e-9,
-3.404854218007890894342796882664858180792e-9,
-2.613304453221630561303153315748119123799e-9,
-1.50431855067870764942555435278041164351e-9,
-6.927454877946366162819296507697012110886e-10,
-2.658364714432555400505610342421291798793e-10,
-8.743494649515653093199070586927344490697e-11,
-2.516033407479747841499569089428535052295e-11,
-6.434293213658834691504783998856179658988e-12,
-1.480265789264327811914507505452844980408e-12,
-3.093185622541299931728390439224043445106e-13,
-5.913177730099611706603504770746210903904e-14,
-1.040108563371023512075480916001537235981e-14,
-1.7211319575546020740152849949949415039e-15,
-2.555877047171200606422036506743375325215e-16,
-0.0002168314867571757697921027109293767061295,
7.668579085810259787388888235094957548208e-10,
8.828749501875603219019884049049159446216e-10,
6.776272004537686083245182513094091762989e-10,
3.900685461000502075126503822139554158157e-10,
1.796285743547252077866239704001112775386e-10,
6.893145966033261762721942134923914526244e-11,
2.267202688745956573580562427214303922471e-11,
6.52418819434782004261701534593614859078e-12,
1.668478002256694286485583165292755596435e-12,
3.838649757363609625070999640885549297588e-13,
8.02200909008112076653346219146941507705e-14,
1.533820666516382026740799922997330162059e-14,
2.698906183026362194774673397908589890872e-15,
4.469781327584999966068109055861554945672e-16,
6.64833395814752907914632311949219829614e-17,
0.00005180766845889740402483683608786129799863,
-1.747687051543456645260464564067499035125e-10,
-2.012092906592966748973502151747437272597e-10,
-1.544328907034249572050064865885943796442e-10,
-8.889762767896309561862907579470263155121e-11,
-4.093786624154984169756808463408056647132e-11,
-1.570971599983296885386769933242475367777e-11,
-5.167058348586110451602465281807656259469e-12,
-1.486907037190236053667411661166620212799e-12,
-3.802650966489341447610378363429563749555e-13,
-8.749067718022048225802881476045885360642e-14,
-1.828525957198698454016715831460393888586e-14,
-3.496726623574505019697591496819366835482e-15,
-6.154819155426758635119587657277959745426e-16,
-1.0200965429588413387100308211522851569e-16,
-1.519492646137313431905148312586114982984e-17,
-0.00001102459679834341137665322105457252519222,
3.554920253932520131283311559985936913435e-11,
4.092741220053329043763574838574367860592e-11,
3.141276597077153857555489363608536619921e-11,
1.808243008909742115628833855410666912159e-11,
8.327071927441468760567708776618195428476e-12,
3.195482384152130864938755549380680348035e-12,
1.051025905963794402609345289008939838752e-12,
3.024529293164534043652730143233660760588e-13,
7.735142049772332955097433983057176158514e-14,
1.779751344606264157972781500179069951121e-14,
3.719890772308211932719786227044282770407e-15,
7.114649267420911374050321752563003601407e-16,
1.252663872112703768941229800057512029297e-16,
2.077578622580205076371925594817417415571e-17,
3.098742869273014851125453713959360982814e-18,
2.11521034677769832571702386678900374347e-6,
-6.532207807079067611078826552794888760293e-12,
-7.520461130389825114764161140723003517628e-12,
-5.772134948145848441607887161715759111886e-12,
-3.322670805360166434482133157427030698935e-12,
-1.530112221879893428850766120964075910352e-12,
-5.871759922860224934818560663310551820724e-13,
-1.9312881363468901452359429069899969475e-13,
-5.557699055291403060529250153941981023704e-14,
-1.421388139649589095796205591935154621961e-14,
-3.270529472370348493318414263607855524429e-15,
-6.836245729724952700747644487452461676878e-16,
-1.307670143670303491065858851745206373546e-16,
-2.303007991890723201358652487681687278345e-17,
-3.821983576631123796288418003328614859714e-18,
-5.707366475441512904035700619344732000919e-19,
-3.695462301877440356977995765914383986697e-7,
1.094932623343795239713024503603642651529e-12,
1.260584391734735757449827099646472542886e-12,
9.675290932776755094489159824868440859927e-13,
5.569485496600744174809573713983545397352e-13,
2.564787896852140469091595905070626719769e-13,
9.84231547322233569083866609023205793843e-14,
3.237260905152869179063038558371702956182e-14,
9.315988310067090476945373499513333265227e-15,
2.382611075649128623916550270469815593951e-15,
5.482412056889090699936015321378177798391e-16,
1.146034239701531272682040871539357658514e-16,
2.192454278497930189023992382261362735255e-17,
3.862194368616654321045699764100216565924e-18,
6.413200998905820203721128895603482086877e-19,
9.5872826881655095842832058688988994515e-20,
5.926541762128847287753023560193434513791e-8,
-1.687531104506746649496151605328951851902e-13,
-1.942836989298231955857324200369162249962e-13,
-1.491174831571626497478834038281840695105e-13,
-8.583804099400638678671921359301171282584e-14,
-3.952906594746098321380958577287063634936e-14,
-1.516921584392954748461784446147858557325e-14,
-4.989362499041274861251770496687929859517e-15,
-1.435817703831673473024811931089120831196e-15,
-3.672227294836543085372754871423416461659e-16,
-8.450066850534678551314579119264223511177e-17,
-1.766486202601452811888358573598726063734e-17,
-3.379802718118665048963108793081735818731e-18,
-5.955148536042695813210042735956908478973e-19,
-9.893736090033690744687650193735077492675e-20,
-1.480522714828872895134648748548133951841e-20,
-8.787309868913303092411905261282558242611e-9,
2.40816599179211461503870260559550769378e-14,
2.772496708730419978127020978702241844592e-14,
2.127959351384292892019202576785328744076e-14,
1.224939767226204628823965216144602072029e-14,
5.640944623194890855604413157137878059956e-15,
2.16470694242320338384570424512242015192e-15,
7.120039902870781092859968329761936076943e-16,
2.048988183227386129309447721303411186118e-16,
5.240530683356338144759018238049181471988e-17,
1.205915840538415073882667052105082468449e-17,
2.521096228752899405409580289595960295346e-18,
4.824084958876645737863124373799773989996e-19,
8.501709812213976504760125662796036745507e-20,
1.41313360626169802606898922841190073081e-20,
2.116593639635982873117836963487964639739e-21,
1.230517644937702998384475101799594790944e-9,
-3.246747079101927156781508599417121230685e-15,
-3.737946834383856879352935962608450728152e-15,
-2.86896659131780278019647111914113405497e-15,
-1.651494236094381161153732860234558528455e-15,
-7.605267506256539227510612710370776756104e-16,
-2.91851834846812985957215990315528220883e-16,
-9.599465797131285468242542545670104649469e-17,
-2.762528277372727992659593433810366922133e-17,
-7.065580187748959501786229493010199137765e-18,
-1.62592361898777040941209982538868357229e-18,
-3.399333322569007407489660267036053895187e-19,
-6.505211885273328742089848977857086339805e-20,
-1.146669507275951803409466579444816138599e-20,
-1.906837283865384391881873048944131553992e-21,
-2.858553167177546373317684444873813655116e-22,
-1.5823472042530196346411091181869625257e-10,
4.029830898982876306093021836104898579424e-16,
4.639503654606292929099759654018250660913e-16,
3.560934344395250078531606187468489704135e-16,
2.049819810631296199766497620999209697324e-16,
9.439596164318939101196610197698890544073e-17,
3.622446186492752850240364329570686959894e-17,
1.191482773631953200451134989580672567802e-17,
3.428860449346019743047363132602735591951e-18,
8.769920596857602361026633756135438758327e-19,
2.018168808184776715557307617007898989454e-19,
4.21958913073327692583984929563591836599e-20,
8.075618529696772443146633325459610212209e-21,
1.423736093172969022411990252166085438951e-21,
2.368553555049826584819161805314435550311e-22,
3.553493378092065278595074093638873167544e-23,
// [{0,0.00001},{2.,0.0001}]: m=16 maxabserror=9.13318260780387464001e-21 maxrelerror=1.761457406319187243171e-18
0.01182114666538062812166080722985024904949,
-5.887452687042737670253210720783511669703e-8,
-6.778149058121407347362954903300211643613e-8,
-5.202373553846797011685552181838777238744e-8,
-2.994671564631152575983582333902228900259e-8,
-1.379046210794441114551489913393058319346e-8,
-5.291893902947446253542151433623783395073e-9,
-1.74046186824850546690130008644428599704e-9,
-5.007969269127894030717283825530850459698e-10,
-1.280494234249810375744437972094079688044e-10,
-2.944959315216646117779420240705473174442e-11,
-6.149934423986661308242689537949994360419e-12,
-1.174185335446200120042045405276291660317e-12,
-2.060044407832195829011237880143664713105e-13,
-3.388361077037736439156854268711263333311e-14,
-4.972813856115765838295748342882316310052e-15,
-0.02221919755884304582707904521148029748192,
1.036214862343001413377368579781350519018e-7,
1.192981304151971121650373540644117330901e-7,
9.156390936195407408934802633113017246051e-8,
5.270751419751931540960432049337318591202e-8,
2.427187009111178275430909930387544719769e-8,
9.314031804886841579227178700097496720306e-9,
3.063341670200601219008227597113139348231e-9,
8.81457260834996899514023183968933457584e-10,
2.253899785332699402831408568920917543333e-10,
5.184072674192579859782587050278150013124e-11,
1.082759715431895256600566092629711176846e-11,
2.067938594959363068242528148505537163945e-12,
3.630461773465707000244499119871498294188e-13,
5.98058980567276208355365924509878515576e-14,
8.803788683605718448325372967765217009755e-15,
0.02095726374327133494767491452501142899193,
-9.188661794884296165475660061497391538039e-8,
-1.057879511351867905752941888384960174929e-7,
-8.119459727730375021877593627989347899888e-8,
-4.673861228957347021050302683330913575458e-8,
-2.152323097163187469995785413013081099253e-8,
-8.259311388346686905778494891957804028229e-9,
-2.716472762810762058283494880501752541549e-9,
-7.816615763889416726756431545227011215203e-10,
-1.998790582957192523483226548152724928062e-10,
-4.597631965556379281374598127550085759431e-11,
-9.604090442956147532413910197452874629812e-12,
-1.834778182903788853996041481547903877474e-12,
-3.222967799575399118136574212555071656183e-13,
-5.316440720796428258785653788437106909181e-14,
-7.846675753075544051266123255752051023614e-15,
-0.01322042714119864404716881872347107826383,
5.468938692238268812603128019084933371446e-8,
6.296324440156758058964246795890912067573e-8,
4.832570890436460594096384349293730089157e-8,
2.781809161352872838097348635884895869415e-8,
1.281031536881589227577300857902745721206e-8,
4.915841448313115144698292509886163089519e-9,
1.616823921565526463187383747472473213911e-9,
4.652461906660574254469082401625061469535e-10,
1.189719956606228438684961828299652568474e-10,
2.736771139669080911237170298082699256422e-11,
5.717607122090891249901736389838606912513e-12,
1.092569138118790174048732245701480140591e-12,
1.92017057941122589717377657689331039922e-13,
3.171152051047950514356470441447971131082e-14,
4.691149411953876109908796531165871055489e-15,
0.006272905145162142289207285511475966034546,
-2.456082088979836406971340562186206929336e-8,
-2.827658867363807161244218790982133732491e-8,
-2.170292827194514162972869817400317351659e-8,
-1.249303065914333543059755235010081086488e-8,
-5.75308825861116280722878778634677821598e-9,
-2.207702589816144691948163348468537249385e-9,
-7.261199957983942587808950457221039890307e-10,
-2.089461814112024586231032768214691993891e-10,
-5.34328392396482739871465591918728223889e-11,
-1.229209222028167569541447175735703502146e-11,
-2.56832158112913288380229857211880845639e-12,
-4.908844283726944347032940722737622537411e-13,
-8.631056062754122052475785682577748131121e-14,
-1.426904368782078831956486804497353816531e-14,
-2.115132808079198383392849686337807511081e-15,
-0.002387313647463065478328638586441852369014,
8.872286497511558038750911860563441643245e-9,
1.02145626539195311325258633986482837553e-8,
7.839913359584960443294075298111116149796e-9,
4.512955651990111234251782804264528128878e-9,
2.078236463362721046112928619087719475098e-9,
7.97509414321635404137004699574501661151e-10,
2.623048394827950938484070580832463827216e-10,
7.548100222362276147035747926841258879616e-11,
1.93028796407796443050963737145362500572e-11,
4.440797367747680361462036527215906935693e-12,
9.279556867529176211134210008113853470544e-13,
1.773953319011753457267271641091643402051e-13,
3.120325690081101874073538074774094883081e-14,
5.163395872610602221928027921993581383787e-15,
7.667631141433722824105843853709766238811e-16,
0.0007589102036570922687479606376333105530654,
-2.684002680050201151941376922595652423784e-9,
-3.090062325675584315615198607053734733412e-9,
-2.371695201602867656385799650394007164321e-9,
-1.365239911358624717979656652961374299165e-9,
-6.287000102454290652374696386935606239133e-10,
-2.412601088126572749298069091511442483784e-10,
-7.935209410659959226248656711986284173882e-11,
-2.283465868035870427505821750868188618189e-11,
-5.839673007934579433088105406269790518879e-12,
-1.34352741508558254732994827550279934124e-12,
-2.807703181545787390537049505247902719e-13,
-5.368372332840633816124570512346971793595e-14,
-9.446171640650988716517642150533382216964e-15,
-1.564423464664526151871893865521177447297e-15,
-2.326916885366322790875272122750754533211e-16,
-0.0002072306746058880000968561321746914178934,
6.990748225130305431004497054958952797774e-10,
8.048371648196271571858009222278227727273e-10,
6.177315644887773796432698215558715004427e-10,
3.555905116800960080365995113068260073078e-10,
1.637514654102421155999772539464973875652e-10,
6.28388641697335520684907236633942505192e-11,
2.066823345039252913549921139204041962239e-11,
5.947628164890598351330526532628859981816e-12,
1.521060390721224688745585609604092995432e-12,
3.499627096702749725318762104869007223268e-13,
7.314103848645524584301366682360784532746e-14,
1.398690653229223755848453553277583067146e-14,
2.461927668870210942191676204357292674194e-15,
4.08038618298505449818001924291911727276e-16,
6.077970601289088925698795664564312672121e-17,
0.00004961068550482589404219536105220115794407,
-1.59971411218132003448396251464340726844e-10,
-1.841733546619742833025923463113265784367e-10,
-1.413574466839393028542368776240467326969e-10,
-8.137093529471378721640008855817677739682e-11,
-3.747182362456920542357190723968316748793e-11,
-1.437967070991248282713915754503505630995e-11,
-4.729616570662586596548013779158867397534e-12,
-1.361038180147122706547629048272731430915e-12,
-3.480813917852677227847507156371128662814e-13,
-8.008881040268934889605752450551464448484e-14,
-1.673950845351700599805864490380353548736e-14,
-3.201592166153192981933271324799428974794e-15,
-5.636987417124488152873779509043266686436e-16,
-9.349103789319879101166001151899472090846e-17,
-1.394434289326262059586959783630993661386e-17,
-0.0000105760435159421711652715765530848635607,
3.26610188118537864720199070808775569062e-11,
3.760228236878792858831696677787633957989e-11,
2.886065687032159862352042008458785552759e-11,
1.661334373985820693676073259411473720105e-11,
7.650556372171073903100578439178214115506e-12,
2.935878143515816234902889172867845025992e-12,
9.656434702296847186571586014457027482695e-13,
2.778847806868682764670523485326731312102e-13,
7.106936297009647654492576591417025564071e-14,
1.635263723334103836678364407210304034629e-14,
3.418120747105843636020180895886624698667e-15,
6.538346664973889173044448910830264885893e-16,
1.151503281214623795106790908985968059843e-16,
1.910990598821191042736406581143468737319e-17,
2.853681451846393283129739919118556432897e-18,
2.032504827477996961491853113683193308051e-6,
-6.02213076500321234087914618350817192443e-12,
-6.933215693369583213452649879577575522489e-12,
-5.321411194116720220271776215675606877524e-12,
-3.063217703014373235813159368198711803798e-12,
-1.410633656361464035029946270886318962468e-12,
-5.413274711769200242904998878470933460052e-13,
-1.780493893028337153343620358150404791127e-13,
-5.123794707841912805507868523142143464153e-14,
-1.310436382498751560267079315067109985929e-14,
-3.015327300727006354723648048975664286728e-15,
-6.303189718130767973331187005903202590173e-16,
-1.205850121110077888338603625050240050135e-16,
-2.124207375262920329559924149119188314846e-17,
-3.527261336078837895772340742852849281722e-18,
-5.273006660392572896145418269756841718712e-19,
-3.556391307619639714287735810853423738484e-7,
1.01263340116952801796910908951633546686e-12,
1.165834290827114289096521655181937568731e-12,
8.948062868796743050228425603642016720522e-13,
5.150866090360281615504259208928005513445e-13,
2.372012723974941977610436974210675297974e-13,
9.102560901854507443178829701937941803192e-14,
2.993956743416313888826184265248684154941e-14,
8.615882507557017339462220040946963515344e-15,
2.203586081598688782433825189132463365634e-15,
5.070614752395550036821674374123566320547e-16,
1.060011872697912544902611276376617182868e-16,
2.028111599666124583794591639482644799217e-17,
3.573494624858466281635148394010196849735e-18,
5.936916514961905679319842550392897877296e-19,
8.884149506944022214644505574786131266683e-20,
5.711574463521357597030329997860530163782e-8,
-1.565265768687907044800571958010457826383e-13,
-1.802074361455051861540003614319638508717e-13,
-1.383136354032000348615662602447159793523e-13,
-7.961894208114886583225391818772694142927e-14,
-3.666515327702949540918973422271533395855e-14,
-1.407021645027441759690557943862355752596e-14,
-4.627901383592144521917761220018857944515e-15,
-1.331806474684689561559873876427098724598e-15,
-3.406253263908861597249443932597953074389e-16,
-7.838241976893175934806967993447110378619e-17,
-1.638668432099721741087319701702541953937e-17,
-3.135570777879555427724480927517828439181e-18,
-5.525962452741300627205967322219788236707e-19,
-9.185120502748271099128544000085474789826e-20,
-1.375748615797401551668494933753260101846e-20,
-8.479709077471613292698568694349530999559e-9,
2.239768524719275555160783006687026388086e-14,
2.578622677530074743383612523280031230444e-14,
1.979156634715170548745306144551329009459e-14,
1.139283305937186721786539008482646308073e-14,
5.24649372017281539794409266918452071465e-15,
2.013339777897317750725555343854481623696e-15,
6.622190620287181006735190683503254183445e-16,
1.905729588120127674034371782464602352364e-16,
4.874187583383273656328161793544064712958e-17,
1.121642039800579043859064867877315687879e-17,
2.345024302465437226450533739061948921517e-18,
4.487598186140259421660519283609265774373e-19,
7.910220559809265904636864949848537276458e-20,
1.315403181754156467366758279549930584934e-20,
1.97188622507732975433567278012040266635e-21,
1.188938380026759766532577872479385046117e-9,
-3.027558166934983813706907423133645102428e-15,
-3.485597171653033713996234316227464648257e-15,
-2.675282446106918472532879746778728902576e-15,
-1.54000226695673079426681311708383330995e-15,
-7.091842632948682413452611510397742885325e-16,
-2.721495492202855372430069479186242853575e-16,
-8.951451196030672148618877707463392804475e-17,
-2.576057175826731748985315806263798648023e-17,
-6.588724733013314752229296811093676984732e-18,
-1.516223493134787044968560900102535810668e-18,
-3.170121851418119952825617392621567646681e-19,
-6.067107691538917527852578084575604131309e-20,
-1.069635086321927384525461997763343830237e-20,
-1.77946686180547513444359170364016577277e-21,
-2.669704872634433188215865017276124124131e-22,
-1.530618144796241182787002210553945866768e-10,
3.766606667089396022500156757237469173834e-16,
4.336456598183778800940798630853956547817e-16,
3.328338729033318152379759243658260473792e-16,
1.915928849125796066696907884519000640543e-16,
8.823022425525646663636540249817836428352e-17,
3.385840260408253656152376128852154855058e-17,
1.113661994300395514143756339417560177502e-17,
3.204923439054730011366934127239543183412e-18,
8.197245616928477293091608372186775510952e-19,
1.886421171852326838148366013165693422864e-19,
3.944292671810566774609127555656333933295e-20,
7.549360616470366870129798165780061620542e-21,
1.331176405102039566519636239596369161924e-21,
2.215417847261219627701281840859133525826e-22,
3.32616941836916477541854043112062305071e-23,
// [{0,0.00001},{2.,0.0001}]: m=17 maxabserror=8.85331695574387817432e-21 maxrelerror=1.823153545145476092106e-18
0.01110959877942152290568033743112663170293,
-5.181074311715007065074910867657656933714e-8,
-5.964906520759855606165808170897146262356e-8,
-4.578195468097703702866298071918136057982e-8,
-2.6353757098759657695585545258594615131e-8,
-1.213593504555589137291021175144088686212e-8,
-4.65701590244342078798481833265130321392e-9,
-1.531670835100300608968380099051037152731e-9,
-4.40728630417498449602835431866330440661e-10,
-1.126949892666349701021360032999044012407e-10,
-2.592036337096289928983760901336414213911e-11,
-5.413798577159476281105142539009888554789e-12,
-1.033969297479681533757993980217583113002e-12,
-1.815230886732853499481505867843314618907e-13,
-2.990294902836381040709732824898358467921e-14,
-4.401894341802859222558476150224412693999e-15,
-0.02095726374327133053641726519333146115018,
9.188661794884295115274228871788850869477e-8,
1.057879511351867784844292105150981698661e-7,
8.119459727730374093873375454450250093418e-8,
4.673861228957346486852696464465030637353e-8,
2.152323097163187223992899606457184910429e-8,
8.259311388346685961739792194138376146178e-9,
2.716472762810761747771940389090214805348e-9,
7.816615763889415833154517858120908456845e-10,
1.99879058295719229492413077899661903665e-10,
4.597631965556378755384592439545135308102e-11,
9.604090442956146432586539949565020632842e-12,
1.834778182903788643473546545730813721124e-12,
3.222967799575398746865865243016796711813e-13,
5.316440720796427640676215384229437119859e-14,
7.846675753075543122624845992148830468744e-15,
0.01983064071179796959227340534681438462343,
-8.203408038357404030781489926751919595239e-8,
-9.444486660235138023152145108938406837749e-8,
-7.248856335654691608554806611201881459473e-8,
-4.172713742029309670117135336152261535128e-8,
-1.921547305322384031543033289897184328173e-8,
-7.373762172469673446854835590314711631875e-9,
-2.425235882348289934828579356849474222753e-9,
-6.978692859990862072524500736406999570022e-10,
-1.784579934909342834722232774031692054171e-10,
-4.105156709503621773496112583445257565973e-11,
-8.576410683136337725154272043969109104771e-12,
-1.638853707178185423844420885296667028039e-12,
-2.880255869116839132860275518430059452135e-13,
-4.756728076571926249671453423900640174564e-14,
-7.036724117930814883665889780958818312673e-15,
-0.01254581029032502590669119984145677494498,
4.912164177959849300750211569468687773368e-8,
5.655317734727817510000567980119062209526e-8,
4.340585654389184277458464727877387330587e-8,
2.49860613182875685825972917431776562489e-8,
1.150617651722273902337796157346550201164e-8,
4.415405179632448030011333733892913915452e-9,
1.452239991596840699163781410744744739337e-9,
4.178923628224199342653302800029719337272e-10,
1.06865678479300388919883391083726350028e-10,
2.458418444056423531934074319378904939384e-11,
5.13664316225845059408044003101126131465e-12,
9.817688567454242478064024646599858992807e-13,
1.726211212550886802709746161387954785491e-13,
2.853808737564261537510489403799199066639e-14,
4.230265616158552825470099603125462706426e-15,
0.005968284118657410112466460802961942499588,
-2.218071624377831047206328117485845753402e-8,
-2.553640663479815475851441782540907571417e-8,
-1.959978339896188450790441000669113243629e-8,
-1.128238912997498070903190533251269404556e-8,
-5.195591158406665670561759112492102138301e-9,
-1.993773535804035957601142808498620109069e-9,
-6.557620987069704490269809677720636850696e-10,
-1.887025055590519291399953834153676524771e-10,
-4.825719910194783840024156744797197141591e-11,
-1.110199341936890808577225296397792394538e-11,
-2.319889216882232823362591204025105067807e-12,
-4.434883297529266433072399376542774683335e-13,
-7.800814225202547947452358200114713839691e-14,
-1.290848968152616125301531953928317296847e-14,
-1.916907785358378945708514267175232548269e-15,
-0.002276730610935683946045084267860387118056,
8.052008040065869443696543292469811160488e-9,
9.270186976929199518583723618135162640654e-9,
7.115085604733728265734788819267104661757e-9,
4.095719734032773178142688380652634110948e-9,
1.886100030716438801953806941344911060401e-9,
7.23780326430354982468696190139132064527e-10,
2.380562823172934583634672459635390890066e-10,
6.850397604035512279561882524315019494578e-11,
1.75190190236193286329180782342858721135e-11,
4.030582245214308883237505009398763156015e-12,
8.423109544548624154397365887698968505928e-13,
1.610511699835204433558159159313628425237e-13,
2.833851492165341155704805573362715497813e-14,
4.693270393943707140414311663469139439446e-15,
6.980750656024042170807995691732301857295e-16,
0.0007253073611273709465550086057040894107275,
-2.446761878811198464638928183615426867249e-9,
-2.816930076886645464240400711321171307779e-9,
-2.162060475724498223787271884168784155206e-9,
-1.244566790888266868692826330070870328627e-9,
-5.731301289394996312849188904847079547226e-10,
-2.199360245954689796936698127375816565336e-10,
-7.233881707683484753206084624833206654122e-11,
-2.081669857724976186886592968522816487573e-11,
-5.323711367558219491551040753924130506341e-12,
-1.22486948385377166651807161125810867601e-12,
-2.559936347042263093301627521189908244621e-13,
-4.89541728633354231696950759229836286737e-14,
-8.616746841100873909760454343868991207768e-15,
-1.428135164053951380740831769114410323595e-15,
-2.127289710464985267508471253525568604794e-16,
-0.000198442742765214824923558319623610305645,
6.398856466482561472856411774473650582196e-10,
7.36693420692275331978421458315000022583e-10,
5.65429788304868764458414236674074662612e-10,
3.25483742082100650817587226810894617836e-10,
1.498872949142296407664164183809272863685e-10,
5.751868299927227030518891701194121973426e-11,
1.89184663351530463593135688279634562202e-11,
5.444152735697916800538332531331299742551e-12,
1.392325571005651672886523663136304680475e-12,
3.20355242500125159419973698382009202424e-13,
6.695803400003183473726541077201549563331e-14,
1.280636870020887585521992082977890854548e-14,
2.254794973127411084913335429433708736151e-15,
3.739641526179235145847172922596803804385e-16,
5.577737173006963510382739189135335733771e-17,
0.00004759219573671243284895288318195270863296,
-1.46974584457317670317154080318119952243e-10,
-1.692102704338647501747497014237951379824e-10,
-1.298729557432313956588609576252779501351e-10,
-7.476004672965172657364741739018861382903e-11,
-3.442750362885234535468461198352567515437e-11,
-1.321145162820026864686265687641444560594e-11,
-4.3453956102377313413570564287976849436e-12,
-1.250481511422948171740852814834424151637e-12,
-3.198121329388117169912859297078233299943e-13,
-7.358686745185300132441442078933124141978e-14,
-1.538154334144610572839751745921790232264e-14,
-2.942255995308202073265765070279846681459e-15,
-5.181764758533901998778008997102963431952e-16,
-8.599457683150937316904604278953221762025e-17,
-1.284156651595355728638214494720303244886e-17,
-0.00001016251617961569777764031207203217026091,
3.011063488081475567439387302581629856336e-11,
3.46660566565767301217383105131584345506e-11,
2.660703923065333038830484722824401390445e-11,
1.531607887887570661579118426317148747716e-11,
7.053163844250808964088417986061866058021e-12,
2.706635652967544338184866034469288809111e-12,
8.902463863936748915323109151532707045765e-13,
2.561895741984969810531768931269367501753e-13,
6.552177789599305454221873326822973293844e-14,
1.507662701549221002338984511866615586807e-14,
3.151592875126581899877236421678709934977e-15,
6.029246808010798687850643887577295004265e-16,
1.062103017909409622019319325346460682954e-16,
1.763629553053099914262150453162271343862e-17,
2.636501655050433228498415104671042684064e-18,
1.956015763405457935389554487893754025231e-6,
-5.569484961074446903993163181363530336561e-12,
-6.412090044006176695369176169548361817084e-12,
-4.921435686495383097333516268654548329948e-12,
-2.832976987887251526188934161871764696496e-12,
-1.304607292078300540676457446843038101438e-12,
-5.006409623835242358321918552564580425646e-13,
-1.64667657983881795153263119411613373087e-13,
-4.738736446723414032141788725728609025923e-14,
-1.211972617936367771317736404507077116918e-14,
-2.788838742223367441778744313618382155614e-15,
-5.830066613860887816796526656742332811282e-16,
-1.115461631356706949179934672041902013713e-16,
-1.965422487344538216811886745968227289177e-17,
-3.265304822122833513263346873316288401384e-18,
-4.886283339629198565045162476305417564262e-19,
-3.427396167560625204211207486965176404925e-7,
9.392669413879063330829203400519173671066e-13,
1.081368357733338382634190175586136777482e-12,
8.299767866336700294676754198309587447861e-13,
4.777683235724950890635972708531129110828e-13,
2.200160961973892707242172591454677950846e-13,
8.44309602239556927294386122343494783936e-14,
2.777058615254121885480232715611367417237e-14,
7.991753382111449015307243828430509085306e-15,
2.043985871305205302415935597218305549762e-15,
4.703483497171403926399305961510485083923e-16,
9.833136182907423659115973009444662653318e-17,
1.881557920643887232295007787642597631991e-17,
3.315957439359782179266757271485493328059e-18,
5.511704890708014513289282779741556345437e-19,
8.255442091305810050594223933086395138736e-20,
5.511639379696103577764003092242470466021e-8,
-1.455809998537674307856243119702093204374e-13,
-1.676059215468712844513098325654202658266e-13,
-1.286416871037378499703883765549881110945e-13,
-7.405140350653185207404553628922387845615e-14,
-3.410128292199525567314995511815832942714e-14,
-1.308635310300638185546584708161216312786e-14,
-4.304306987841377699803727834162757899441e-15,
-1.238690585787113083939836667632662148068e-15,
-3.168135869847190574997355771175056857146e-16,
-7.290475204159575957901176332093019576182e-17,
-1.524224382583741009106927932201761731787e-17,
-2.916859543068447398549495258589496532653e-18,
-5.141503531730021426343539878064448024876e-19,
-8.54988780437032885331141280427310896894e-20,
-1.281691036918030417436824249269829953839e-20,
-8.192893752559936880643897930968560577963e-9,
2.088420950197982191256960440176651323112e-14,
2.404377963789887041103699833543344452088e-14,
1.845419827448296768687800863657761045966e-14,
1.062299308258500175862742829527001039238e-14,
4.891979413141804866222120460111104561594e-15,
1.877297639730116337072899232312423247032e-15,
6.174743638948251102216865136575739100652e-16,
1.776973363858616683119164825225732342359e-16,
4.544924332543460667822905263544947653292e-17,
1.045895420716791149014102065769837267998e-17,
2.186756812428638611986222829979384193283e-18,
4.185094089927218351449654690421419941915e-19,
7.378313706643985750236117881653102052251e-20,
1.227457983391549711482102865033206628226e-20,
1.841496723570051406125104851243208115371e-21,
1.150074743808087496944537676935069133828e-9,
-2.829822015435969476704825807353635772705e-15,
-3.257945795291306844164187073292278750239e-15,
-2.500554756495953172094939343062667367305e-15,
-1.439422303908251891959139225960501320769e-15,
-6.628667498861012204998015047938147067395e-16,
-2.54375522320474901015257980974316325721e-16,
-8.366855254370399258272237479559917315886e-17,
-2.407833891973398720205153102057260349562e-17,
-6.158526660099523084862965626390956867522e-18,
-1.417253594603368771854028838215594767089e-18,
-2.963316867573410100807208568698432060147e-19,
-5.671778230883537079225030758019503891326e-20,
-1.000103400551500916402553594464546973843e-20,
-1.664429707104322740056171517076838060538e-21,
-2.498936125754765123294272000073410724398e-22,
-1.482161393505648538590745183389972722615e-10,
3.528336381780517576173982249356634120949e-16,
4.062138703155952546394906461222752934008e-16,
3.117793358351651399488815844878907337796e-16,
1.794730796725537646450324839656019508443e-16,
8.264899555895526503043575248303563660515e-17,
3.171664043811373212109680788127101581837e-17,
1.043218180677996378217183545087194645555e-17,
3.002212830061485430097573449192240040898e-18,
7.678845066835149932957231243645734324264e-19,
1.76715607077146005445298734097572882384e-19,
3.695064093480991375045131612703815737823e-20,
7.072875869818193583791645583032126489536e-21,
1.24735010467734254469502639014235834277e-21,
2.076650490919128823143204041162822557628e-22,
3.119943209130030766250017448020654709233e-23,
// [{0,0.00001},{2.,0.0001}]: m=18 maxabserror=8.59008475589977813019e-21 maxrelerror=1.881260385433004531029e-18
0.01047863187163566526058348257799821736089,
-4.594330897442147555933007715268534655423e-8,
-5.289397556759338922259539085466139298888e-8,
-4.059729863865187045430863399228127965366e-8,
-2.336930614478673242559533007343919024359e-8,
-1.076161548581593611597273030012515907575e-8,
-4.129655694173342979338047661276254909867e-9,
-1.358236381405380873382115120110858867618e-9,
-3.90830788194470791512723319829827306758e-10,
-9.993952914785961470911817933245289884965e-11,
-2.2988159827781893768387410074845203758e-11,
-4.802045221478073214508391269509755447547e-12,
-9.173890914518943213950752355361906288242e-13,
-1.611483899787699372830156911647258368005e-13,
-2.658220360398213819333929455990359056335e-14,
-3.923337876537771559801906512424465708095e-15,
-0.01983064071179796531640076589825252790828,
8.203408038357403044987264776008602589036e-8,
9.444486660235136888216946190542384597387e-8,
7.248856335654690737463449277464439221534e-8,
4.172713742029309168680785912128777421609e-8,
1.921547305322383800626877464564026657561e-8,
7.373762172469672560710633705015140292468e-9,
2.425235882348289643358933408147755206958e-9,
6.978692859990861233718375923103063576857e-10,
1.784579934909342620176499038248541893184e-10,
4.105156709503621279746672591082686744849e-11,
8.576410683136336692703942863003211590366e-12,
1.638853707178185226204794019088477608615e-12,
2.880255869116838784259193937713714538405e-13,
4.756728076571925669109949706579945824948e-14,
7.036724117930814010883891370496648514058e-15,
0.01881871543548754227669221471176655087743,
-7.368246266939774714689002863017339698162e-8,
-8.48297660209172714408427293355576471082e-8,
-6.510878481583777090906457228105247970026e-8,
-3.747909197743135675785824965340753164953e-8,
-1.725926477583411032366905586189704909195e-8,
-6.623107769448672731396453140856594096292e-9,
-2.178359987395261274509371893459005767433e-9,
-6.268385442336299663696888221620344346319e-10,
-1.602985177189505999981062982550398722323e-10,
-3.6876276660846356803558968566651034632e-11,
-7.704964743387676690876081921892407148742e-12,
-1.472653285118136524815169113449000280227e-12,
-2.589316818826330474151975529795601947387e-13,
-4.280713106346392756210656547123155880654e-14,
-6.345398424237829915026570489763312486623e-15,
-0.01193656823731553880167402640515165397125,
4.43614324875582775774829622375365985875e-8,
5.107281326959821678272382852951847385188e-8,
3.919956679792523289027914853000544113296e-8,
2.256477825995080408498312789149759829376e-8,
1.039118231681371939716678803586384195093e-8,
3.987547071608220832289412067999679056974e-9,
1.311524197413989879710244256567800076175e-9,
3.774050111181179544694102402980482263921e-10,
9.65143982038992822549822809343770923701e-11,
2.2203986838738645920580408197456115916e-11,
4.639778433764639150655031451852503016232e-12,
8.869766595058865000798823621900893066387e-13,
1.560162845040568172129273724797835622754e-13,
2.581697936305329814359663139338797198825e-14,
3.833815570716904563077762497881082119247e-15,
0.005691826527338963832973427586828304342982,
-2.013002010016412377399838952996225761228e-8,
-2.317546744232236577650886404185516197212e-8,
-1.778771401183383480551409660944858958722e-8,
-1.023929933508165326477443633792052470685e-8,
-4.715250076790968209278265188395999937566e-9,
-1.809450816075838030613611713963443922634e-9,
-5.951407057932173888706248516331087226939e-10,
-1.712599401008831284366782435493649051076e-10,
-4.379754755904712491502355373617635922353e-11,
-1.007645561303549680589032561593190529024e-11,
-2.10577738613709844894024718700701744894e-12,
-4.026279249587900833971340497762514891009e-13,
-7.084628730413158401809120563382966308607e-14,
-1.173317598485894384975936735692055265725e-14,
-1.745187664005961805395898570047629016617e-15,
-0.002175922083347612316426610873938737876741,
7.340285636354057824108012226223714702185e-9,
8.450790230568365570621099358157159935908e-9,
6.486181427103211758467502929962209137122e-9,
3.73370037262434284354696121051702275135e-9,
1.719390386799867713620371232329151770174e-9,
6.598080737792571957908248365504887410336e-10,
2.170164512281528563293779372388446453157e-10,
6.24500957310725054065657262900276460914e-11,
1.597113410250155493907767345309540250265e-11,
3.674608451521477444286166099418771012349e-12,
7.679809041043487315051009785557359163343e-13,
1.468625185884116387614896936522602125024e-13,
2.58502405230213572425467484255472918343e-14,
4.284405492115012237375152259349550997002e-15,
6.381869131324536395603667705075027572437e-16,
0.0006945495996848134473581478317274820006278,
-2.239599763283560269266352926817997148547e-9,
-2.578426972439845898560797919834688200391e-9,
-1.97900425907999821922382363273323999552e-9,
-1.139193097294811179859404848174754453978e-9,
-5.246055322032386390096647297371325415447e-10,
-2.013153904987710940474238806136813102395e-10,
-6.621463217346922705008633482181685912773e-11,
-1.905453457506748279718966430088078878927e-11,
-4.873139498551695204882980257605956975684e-12,
-1.121243348757782858388537208074315356212e-12,
-2.343531190016473009218003009607687515785e-13,
-4.482229045102509498655510788756570761054e-14,
-7.891782405997807357769725717322668975525e-15,
-1.30887453417137320849069690160670791101e-15,
-1.952208010565435158813290126339063838982e-16,
-0.0001903687836698694061896578181256956877032,
5.878983394961008151792116303944199290821e-10,
6.768410836544641454901394906008775680607e-10,
5.194918244458103765971199079344395810903e-10,
2.990401877664605421552458150367858917242e-10,
1.377100149058539566208407703492424617053e-10,
5.284580666263476454878086710452685813146e-11,
1.738158249023406980381497619287439840782e-11,
5.001926059874745947015429328665366189241e-12,
1.279248535382893424308289412989954978478e-12,
2.943474706422682699241997054438936281243e-13,
6.152617354035630021724866964009308961525e-14,
1.176902401465071035378591712026784713798e-14,
2.072705909307884340690929723425709776402e-15,
3.439783083076807089784571938287247496477e-16,
5.136626621138881855077101331319647057466e-17,
0.00004573132272577522264106745160605685172945,
-1.354978567793068357176717149395419667837e-10,
-1.559972547423439173797594498375792787381e-10,
-1.197316763750316932191263464672741276072e-10,
-6.892235486116387825638624660612026830652e-11,
-3.173923725594351855798929727767733689464e-11,
-1.217986042178157714275895647640795676e-11,
-4.006108733320557829835341020650741950519e-12,
-1.152853082324519436141054661437267522976e-12,
-2.948480001307266252262717068739309796786e-13,
-6.784482147737268150819612041490316305019e-14,
-1.418216791875982554969384645756841763123e-14,
-2.713161059908183143968537177963703588732e-15,
-4.779463574071185215781533737657272389655e-16,
-7.936332977875196032341419598328696477927e-17,
-1.186425743138534142544191941759303058971e-17,
-9.780071103469920917192270936612079030192e-6,
2.784740702292882201926376834814162912657e-11,
3.206042974727862035712062394928947236609e-11,
2.460716271912378457212328665550659686666e-11,
1.416487589417783733061714738519831066993e-11,
6.523032294964909340127219106029213185517e-12,
2.503203213428932660838396251397566991934e-12,
8.233377641461400131801562718572103963978e-13,
2.369366710264725489186203238105231234364e-13,
6.059859219556225103765153604798750648586e-14,
1.394418480451973480615297505498795709419e-14,
2.915031444524351983134600011818930188925e-15,
5.577304591621341511157467875107800618126e-16,
9.827106148410424337473086993748515239814e-17,
1.632651363803041969395258993380182025592e-17,
2.443140095426356746295958741129540445907e-18,
1.885068420167595911889911609416810226081e-6,
-5.165969357615946374332225292354213918282e-12,
-5.947527326035655939061772028411051101862e-12,
-4.564873369170056969758505460757210493004e-12,
-2.62772637986157987614200271049190057372e-12,
-1.210088805489451972449402374652950627898e-12,
-4.64370387302242958260863559670469587055e-13,
-1.527382587276457171924768231703485129908e-13,
-4.395465364209297195059179683851449994864e-14,
-1.124192486030503009598121631389037502038e-14,
-2.586916514475456612707402771117794754025e-15,
-5.408226136510943033327656688463180059913e-16,
-1.034857092957714072845412215843704180013e-16,
-1.823777009030750112072216170527939287783e-17,
-3.031438385217564029529321060075277867463e-18,
-4.540494196153284713776096464205810177033e-19,
-3.307421261579287333687548960641109289458e-7,
8.735868881016645151453649017956282972613e-13,
1.005751681770876981013796055004834705932e-12,
7.719392725844596062584566082203049361059e-13,
4.443597394585050735574630188542564561921e-13,
2.046313301468330416199416312810974941833e-13,
7.85271876693587565386497617429009787378e-14,
2.582882491015980124306313126154813772396e-14,
7.433001972733674097189672933420717923758e-15,
1.90110109410921876724028036838287047701e-15,
4.374790439721160484902387788651574402424e-16,
9.146402934616837840596454898911195664818e-17,
1.750317995899484671058660807098843444749e-17,
3.085258887472880473749438107165139924813e-18,
5.130526846440480918233240568491621565033e-19,
7.69103945349510684866415979421660976927e-20,
5.325214525958733015785428814909539305352e-8,
-1.35743642813581504523044008731192303983e-13,
-1.562802860563140626155534930574937428151e-13,
-1.199490025554982819829875081978005329216e-13,
-6.904756334667216942875439501446072614825e-14,
-3.179699504386710425145794836407777170242e-14,
-1.220210035602206293835820636505720291081e-14,
-4.013473406740664707477207608653830010649e-15,
-1.155001041939474525799828023628027135625e-15,
-2.954119876544597059662895398353110869512e-16,
-6.798133959432041330374188620401565844956e-17,
-1.42135297585929475862626647329999841023e-17,
-2.720236588131366877400915575242551247219e-18,
-4.795772362806556851056701414970278931075e-19,
-7.978257745541305276094951098336932457391e-20,
-1.196939905592965262742115501336490764207e-20,
-7.924827842138691461129737026562375081454e-9,
1.951898712281232647256232343563269736283e-14,
2.247201468592262748237557850345499102641e-14,
1.724783237718264197590704736087346392106e-14,
9.928562588519452000172647617746628373746e-15,
4.572191137985226045494622250244391945054e-15,
1.754581096977429258899287553300111638479e-15,
5.771123311718638335553670653406678341849e-16,
1.660827632844503235843489040850614983498e-16,
4.247904514195860281071438216701577461308e-17,
9.775641123313087241514587997257028143812e-18,
2.043973682239618749034484594688815242631e-18,
3.91215002482690101906728521054621559265e-19,
6.89825500978071224432052381294902275466e-20,
1.148035592902522601170914686289115092295e-20,
1.723600433308697727456563024041957045951e-21,
1.113669316213229347873940431228959392465e-9,
-2.650829683296406005904002554274415619915e-15,
-3.051873939826394687570558763303732417015e-15,
-2.342389809868054672671880923623476854046e-15,
-1.348376447834826990713250046297522677662e-15,
-6.209396944632445885596300774178891850487e-16,
-2.382862727265055573286872737362788847192e-16,
-7.837670394178806945144324418628106864263e-17,
-2.255554533209861741788025033473384926336e-17,
-5.76909609567293065822420086019544204219e-18,
-1.327659785770417722230635608638169249636e-18,
-2.776092428883857075128697390421276459723e-19,
-5.313835246567418896035165716386944723395e-20,
-9.371316934046536885205547566307816485858e-21,
-1.560185190781778582315965081159091105963e-21,
-2.344014807156296677138760997149190940897e-22,
-1.436676203002864449607940670885681579367e-10,
3.311964756381586077585829076342866150675e-16,
3.813032460826694765009762110674184540847e-16,
2.926598475477753164953450704719273978781e-16,
1.684671583934934494419084094949983047499e-16,
7.758071127762916243195986909834229054769e-17,
2.977171406949346049995367650888345738586e-17,
9.792481838776423782925385126170692312433e-18,
2.818130100916978449621133327467299132421e-18,
7.208075677482070739335636881179786239447e-19,
1.658846071205909252002694391345003684174e-19,
3.468715453814140621033724898311044109672e-20,
6.640084472056973167560867524753080899482e-21,
1.171192958900514901844357637080135891246e-21,
1.950510488114200064030234626274242845135e-22,
2.932286938457339783815426771523805362295e-23,
// [{0,0.00001},{2.,0.0001}]: m=19 maxabserror=8.34204633610389676885e-21 maxrelerror=1.936075625202789231681e-18
0.009915320355898982650795742524245137570738,
-4.101704019178701520888010876932843353647e-8,
-4.722243330117568442259936602636953881423e-8,
-3.624428167827345367312925952159959268195e-8,
-2.086356871014654583523673116379553610175e-8,
-9.607736526611918999373311830040220026911e-9,
-3.686881086234836278911995587048499314955e-9,
-1.212617941174144821204729026640717214339e-9,
-3.489346429995430615492952746960466776609e-10,
-8.92289967454671309738794890576898107243e-11,
-2.052578354751810639069085297386855990224e-11,
-4.288205341568168344670140443274064807274e-12,
-8.19426853589092612780406346076444267466e-13,
-1.440127934558419391561514343069913678001e-13,
-2.378364038285962833608315407650078590134e-14,
-3.518362058965407004017160123654027255232e-15,
-0.01881871543548753812814807700806251048391,
7.368246266939773787557544029117961765547e-8,
8.482976602091726076686870494437096575588e-8,
6.510878481583776271651953318331475067716e-8,
3.747909197743135204188797423895142507271e-8,
1.725926477583410815191924891466127242253e-8,
6.623107769448671897983346820434937973719e-9,
2.17835998739526100038341199075536815108e-9,
6.268385442336298874800009307497608887023e-10,
1.602985177189505798199187170171602656637e-10,
3.687627666084635215973071159726784561263e-11,
7.70496474338767571980003428361951541474e-12,
1.47265328511813633891190138870555024362e-12,
2.589316818826330146207519265325749491972e-13,
4.280713106346392209880238929120087240328e-14,
6.345398424237829093219081489250115376072e-15,
0.017904852355973311520362073757344704005,
-6.654214873133742356057986692119141515889e-8,
-7.660921990439733345687745303234060522301e-8,
-5.879935019688785569267163443120121424149e-8,
-3.384716738992620978697524561133184359858e-8,
-1.558677347522058078098631589472905375323e-8,
-5.981320607412331895147313481809518005439e-9,
-1.967286296120985032282470931231847691555e-9,
-5.661075166771769929214177002980465344094e-10,
-1.447715973058489390405895870534223202257e-10,
-3.330598025810797248450169496688661325084e-11,
-6.959667650646959479565507655217498520726e-12,
-1.330464989258829894395130411958517990123e-12,
-2.340244267560852512736378869353916282209e-13,
-3.87254690445799514571203921820509500805e-14,
-5.750723356075357483024699979932402175585e-15,
-0.01138365305467862484503082584208545647157,
4.02600402003298055998706750363241175941e-8,
4.635093488464652532293813760666693177587e-8,
3.557542802366904637481178568754540211489e-8,
2.047859867016409905214711722803687610161e-8,
9.430500153582301382858618098712547030107e-9,
3.618901632151816116970247165521596100881e-9,
1.190281411586480844829407066244994617666e-9,
3.425198802017795143489215154464745145934e-10,
8.759509511809764079073138188635013508053e-11,
2.015291122607177401086879628869261981474e-11,
4.211554772274360087997382026912310809838e-12,
8.052558499176114079902336374979026843737e-13,
1.416925746082686791699616233565320107495e-13,
2.346635196971880581247316138641494994711e-14,
3.490375328012061716290423103795319810335e-15,
0.005439805208368791873743552657783588824493,
-1.835071409088462650108193893190132755633e-8,
-2.112697557642031749002772715576606411408e-8,
-1.621545356775757161599414325731475710544e-8,
-9.334250931560593591460452700494174095583e-9,
-4.298475966999547931683408687339529421895e-9,
-1.649520184448096420230291748258885043466e-9,
-5.425411280703668232523651921448288296431e-10,
-1.561252393276768553124631381402514826956e-10,
-3.992783525625275982055665469936489455976e-11,
-9.186521128803434116417946263084444001855e-12,
-1.919952260260817563917698116963118282354e-12,
-3.671562964710187077658375020508593554274e-13,
-6.462560130755156016839866398409910621195e-14,
-1.071101373028722515049165999857796561095e-14,
-1.595467282831088127688233999615486778177e-15,
-0.002083648799020967154845269388143693875412,
6.718799289775876225956995392804702218241e-9,
7.735280917233415910478009446348749742166e-9,
5.937012777173894009251932214529731715464e-9,
3.417579291846383252185831511505478074945e-9,
1.573816596592193392603384629663122305648e-9,
6.039461714895889801621350135221182142889e-10,
1.986438965181959259896884548645769415069e-10,
5.716360372456593561805016218557470602895e-11,
1.461941849549228012521844475275986832934e-11,
3.363730046235880356492040468527295774901e-12,
7.030593569971068819818969771461399055264e-13,
1.344668713515753446965142923677204136323e-13,
2.367534721772882362608999175236185570532e-14,
3.926623602470039531389198370581309573217e-15,
5.856624031629998766254910376884256537938e-16,
0.0006662907428509147341315114346396561281513,
-2.057644188250169164522322474907629146036e-9,
-2.368943792806531094691836581446070953979e-9,
-1.818221385572545026261810878762675972534e-9,
-1.046640657189639740377593980047610099822e-9,
-4.819850521737252391819300208014242967104e-10,
-1.84960323320463648324329222488547897656e-10,
-6.083553871622775426138225428193453893687e-11,
-1.750674120967917483034615268605399524899e-11,
-4.477369873870197421897006699597452769489e-12,
-1.030216147254859493819150339864138113786e-12,
-2.153416073926942599268304677653837947463e-13,
-4.119158405155455799142776651312252513943e-14,
-7.254470682626478492816767487436286817534e-15,
-1.20392407908502845273513257569200273318e-15,
-1.797819317410868883885848236250844200338e-16,
-0.0001829252916045911696511141553871504908131,
5.419914286848716468649500545226924178629e-10,
6.239890207741892612009953396442576503353e-10,
4.789267068853668536418595483354194973449e-10,
2.756894202420574212637291793309260801163e-10,
1.26956949390985345796589156497240344741e-10,
4.871944182804433051025256222003926198708e-11,
1.602443497963294004664404012480404803853e-11,
4.611412342637175460664404294853560885823e-12,
1.179392003934744297589421040588648814593e-12,
2.713792866946945042469775769589280698667e-13,
5.672867183923413754403994190817885583902e-14,
1.085264427106627401100060328810346483835e-14,
1.911785435173539354971125893250847736338e-15,
3.17453320038773754444852625416905014668e-16,
4.745702986449726634218017984454348971339e-17,
0.00004401031988550482365388112344356899013745,
-1.253133314294745278396504706233888967821e-10,
-1.44271933662768710557560789137609193612e-10,
-1.107322320825634038662495007322354088442e-10,
-6.374194143544291933019504352265389388738e-11,
-2.935364528665266064465691209852321059674e-11,
-1.126441444481553522045446038266116408804e-11,
-3.705019933521650672995367168607767932038e-12,
-1.066215018141056315536523654003911579361e-12,
-2.726936645019704406597467708186487699795e-13,
-6.274883153333040509716544423293869184171e-14,
-1.311764148216458879925798654027371384328e-14,
-2.509787062746127094322490859442585968141e-15,
-4.422197760638852060759502953859887427561e-16,
-7.346931126872189394022591599253941478153e-17,
-1.099413041400445866206651069330287009329e-17,
-9.425334616965373460744146994322789688356e-6,
2.58298300637826452252888326161317519163e-11,
2.973761737565822244159996961768953876888e-11,
2.282435206751913576001967240847119075533e-11,
1.313862339228473176428871679486567815558e-11,
6.050440109881020271286168944403078233197e-12,
2.321850433137739571802569306266232630885e-12,
7.636907991491267452133124277326455382489e-13,
2.197731259032890175995679820637631452472e-13,
5.620958790258626957425259853477050996443e-14,
1.293457419548887896541888402497339352425e-14,
2.704111316555003178484481162647559632063e-15,
5.174282111324361930174727189791787709739e-16,
9.11887912944148416910485446588781953378e-17,
1.515718207095791490065811043367279308953e-17,
2.270245615635392241218675694084870327625e-18,
1.819082206608985182741545878689466361701e-6,
-4.804728996349057889714554623317347563984e-12,
-5.531635529732769364031607920259173955823e-12,
-4.24566698164160894337204034732863577101e-12,
-2.443979132547878241198692549106022349012e-12,
-1.125472576237934241963957150277976244597e-12,
-4.318996321222127285032981461272588164873e-13,
-1.420585698784179671039484789510337795309e-13,
-4.088152031033776332112389273997098353548e-14,
-1.045605843734988399470649098464761848746e-14,
-2.406135298738882695797741290482644469065e-15,
-5.030522778599410680116060571135737066471e-16,
-9.62675120702624435718583376645868235036e-17,
-1.696892781470960787328874862642502230247e-17,
-2.821790421043560242389617132694618742044e-18,
-4.230072685995990681820370242459790387826e-19,
-3.195553318128450561115983501459799350789e-7,
8.145567424970588497216758348001184086889e-13,
9.377909572212948377561982489273392824637e-13,
7.197778604740429005501208189650471464704e-13,
4.143336448367422298288371690848331902382e-13,
1.908041966493009852362709049284453508563e-13,
7.322113155395853388491726751681811072053e-14,
2.408364593371085588769344548267113109565e-14,
6.930813634089947050804081182767585902374e-15,
1.772678435995223274381776300529434266832e-15,
4.079355640009886240141988538841955205753e-16,
8.529111685743638729112301947009908001086e-17,
1.632332212310856145775723488295088610501e-17,
2.877799046760159072234094102402411137345e-18,
4.78751378006474201181225584457819108595e-19,
7.182480499652830924229609329209946202957e-20,
5.150976496475303411249137303416391170582e-8,
-1.268699122707143174375931813626922817911e-13,
-1.460640613055025171595768959849027623485e-13,
-1.121078141368490882480679854174479941342e-13,
-6.453387445710757306849186116316720974486e-14,
-2.971842159871920553638864141427249831629e-14,
-1.140446214718470791223329627627805509653e-14,
-3.751126548255575101250579110995875569961e-15,
-1.079508145319052479467885434807754811137e-15,
-2.761061671006869878563701195135554140526e-16,
-6.353991214457886651231262653141950469027e-17,
-1.328546190020298432366704058343502651579e-17,
-2.542827246506193513090497596201761066392e-18,
-4.483741780830440769823592114015880626937e-19,
-7.462024759550614521833063123116255547552e-20,
-1.120309187810233673432989379409002509681e-20,
-7.673732592340050368740297926122454857903e-9,
1.828328316613354755388581026086762824776e-14,
2.104936264630735128073070350881767377326e-14,
1.615591382257235089728642945898911681548e-14,
9.300012075318281919192332296855122815063e-15,
4.282740604959360464393956104474578164041e-15,
1.643506240889270085728626671879175835236e-15,
5.405791627355707679333369302539937502082e-16,
1.555699032002312844176205749291259408563e-16,
3.979054717678149075265475683477970117709e-17,
9.157116001808304673979183845790694481585e-18,
1.914720510187627695073982524685551583633e-18,
3.665039529569369615693521231950769885643e-19,
6.463524533517970832579081514782166189025e-20,
1.076070565572678201298629498903528877034e-20,
1.616653776840730133040931089154138271042e-21,
1.079496192178806721371161860520303555108e-9,
-2.48828643271344872793096582577051146453e-15,
-2.864739705809651992934329198628839771777e-15,
-2.19875989660914958937473117967273807748e-15,
-1.265697481904407817677329475485408458083e-15,
-5.828655983565875011871840755407709225761e-16,
-2.236755465403698911397891596114753981036e-16,
-7.357113324115985874790762832175826117607e-17,
-2.117267424799960505178827905181872022018e-17,
-5.415443471003991395813654977693306886335e-18,
-1.246294854839091238672152059957025930513e-18,
-2.606054162661790331452041365747451521223e-19,
-4.988712357544186990325136904437073994272e-20,
-8.799206483143380952115537471894208274363e-21,
-1.465425692903236482038005862051547187771e-21,
-2.203042330208654381956868585443789751544e-22,
-1.393897559181533906197226281935762134267e-10,
3.114889903635239804897636631590544578827e-16,
3.586142354296722282413160486957034073581e-16,
2.752454961564596872626002222382695758596e-16,
1.584427760730401211448179820076233796911e-16,
7.296442697222773127583733358947985595151e-17,
2.800023726762933466435189326324412814167e-17,
9.209828711959758670603617946228311159121e-18,
2.650462290720647499039142606371450474543e-18,
6.779279743775921101483880708915894357502e-19,
1.560190276055021197502093866297638612568e-19,
3.262531343190099366397902646658597369439e-20,
6.245806727282127942450395969889205723605e-21,
1.10179791590809809427839449905594364337e-21,
1.835512502799951481035775355187578341209e-22,
2.76103972082933051635211791822006199459e-23,
// [{0,0.00001},{2.,0.0001}]: m=20 maxabserror=8.10792350459847200977e-21 maxrelerror=1.987866159413811189031e-18
0.009409357717743769056877520942085642096088,
-3.684123133469886892263343411489890846482e-8,
-4.241488301045863036598736875415949781069e-8,
-3.25543924079188813448687621220041559905e-8,
-1.87395459887156760132355633333476698189e-8,
-8.629632387917054072409817566405839153787e-9,
-3.311553884724335947629425695301051343668e-9,
-1.08917999369763049974363422935707675303e-9,
-3.134192721168149436110505817488893126105e-10,
-8.014925885947528987697640973113416398214e-11,
-1.843813833042317607227439575369657468101e-11,
-3.85248237169383785831256628638258035899e-12,
-7.363266425590681691520114656701980262789e-13,
-1.294658409413165072567461013803270013369e-13,
-2.140356553173196104046179155749177387352e-14,
-3.172699212118914545263399338172231981657e-15,
-0.01790485235597330749178780101543499839471,
6.654214873133741482507804337709657108493e-8,
7.660921990439732339977882104607524326597e-8,
5.879935019688784797359311638031553351342e-8,
3.384716738992620534355093902049595078633e-8,
1.558677347522057873474555461165421910879e-8,
5.981320607412331109897772164316045998924e-9,
1.967286296120984773997948619740296606561e-9,
5.661075166771769185903867317939570318754e-10,
1.447715973058489200282536595085730929116e-10,
3.330598025810796810891501101308852476315e-11,
6.959667650646958564552988160714443773908e-12,
1.330464989258829719213739510710377986284e-12,
2.340244267560852203666836652180689732622e-13,
3.872546904457994630674957098796055936783e-14,
5.750723356075356707859480841001840179659e-15,
0.01707547958201794049214300306635709317287,
-6.039006030049471519003491341907772646443e-8,
-6.952640232696979580193241592270758384464e-8,
-5.336314203550357556236743035662414552448e-8,
-3.071789800524615203215851712196755346589e-8,
-1.414575023037345366486113532500143010961e-8,
-5.428352448227724785842015830925047257573e-9,
-1.785422117379721468013045040163337349458e-9,
-5.137798203026693293023648461999789177271e-10,
-1.313926426771464759648713782510470552397e-10,
-3.022936683910766441760871497665654477553e-11,
-6.317332158411540843290214214526438365746e-12,
-1.207883774876417248172367328898859227811e-12,
-2.125388619124030427850460740627437928066e-13,
-3.519952795457821272421698724741891380568e-14,
-5.235562992018093177605660958893983178093e-15,
-0.01087961041673826076551840695705329277402,
3.670142818177072101175454415055426215667e-8,
4.225395115284232508527719911877769883236e-8,
3.243090713551644043065250245602761441032e-8,
1.866850186312193390470412822325067912514e-8,
8.596951933999439736120161352954315589719e-9,
3.299040368896324802411049240687649994239e-9,
1.085082256140777051470391533789687931461e-9,
3.122504786553662020271399064236287354992e-10,
7.985567051250871468271341175178730369882e-11,
1.837304225760760355445312551185879924821e-11,
3.83990452052178889658595080186360662168e-12,
7.343125929420668549371016129280053992706e-13,
1.292512026151083142812848983715366530968e-13,
2.14220274605753158260778011944104306543e-14,
3.190934565662306522725925728331459652549e-15,
0.005209121997552185684950596142737902261859,
-1.679699822443920160630348108585170877652e-8,
-1.933820229308297684287542115873934497338e-8,
-1.484253194293430295746614873712252027739e-8,
-8.543948229615709415347871198443531561748e-9,
-3.934541491480368945688963605298946926177e-9,
-1.509865428723928496983853551800013157262e-9,
-4.966097412954753577745572226972761351715e-10,
-1.429090093114106784298864065715274799259e-10,
-3.65485462387296361061155630214852924987e-11,
-8.409325115589455966120244645032058429638e-12,
-1.757648392492715985269885448876087555162e-12,
-3.361671783789285550301413882677065952787e-13,
-5.918836804432032867787171968639831525979e-14,
-9.816559006174810395279867872904640481592e-15,
-1.46415600790745625779439378941621765424e-15,
-0.001998872228520238980583150235868244163595,
6.172932564680025929926587382379599566917e-9,
7.106831378338448542579297738572686079419e-9,
5.454664156655354429670535666498076313666e-9,
3.139921971533067875725711706657063963237e-9,
1.445955156504665819032207674590794306583e-9,
5.548809699550552339007879107428333785359e-10,
1.825066161465993187321234153441481337933e-10,
5.252022362843779164957185326592390264978e-11,
1.343210962145719304346450530889211542362e-11,
3.090648441729274476354456149563015767488e-12,
6.460248221707000880404085062178916466468e-13,
1.235747521532502394467154663683626851019e-13,
2.176341204763006560232143896882085952089e-14,
3.611772237213530059702045481209887484229e-15,
5.393457952170063116449852314744795584035e-16,
0.0006402385206222618171021506231539348484038,
-1.896970000410090984990214082911254226548e-9,
-2.18396157272467549514755557513816480538e-9,
-1.676243474110306909833850481232280869352e-9,
-9.649129708538340516443864026716037571429e-10,
-4.443493228715033092423232540272095032911e-10,
-1.705180463993273671556413822602647865098e-10,
-5.608552242910085467216680751563168491996e-11,
-1.613994319934107512896705314288672420369e-11,
-4.127872013799986777510559167784231752705e-12,
-9.49827503437962764999382522708211816279e-13,
-1.985503514386854785060057185004642220103e-13,
-3.798425494899349792117761280299898688692e-14,
-6.691249023153536097165582445461139544712e-15,
-1.111086620143400474865352833054036799464e-15,
-1.660996045268987839904144033692029811001e-16,
-0.000176041280223224366039296995260730625088,
5.012533271949479403983064915458397182361e-10,
5.770877363515880029292416527117248391919e-10,
4.429289296354406371822654270546659095872e-10,
2.549677664930918932395249842919701475868e-10,
1.174145814926010197145686495928925699593e-10,
4.50576579120367343942859438933920003233e-11,
1.482007977775886322493229025910731433435e-11,
4.264860085132551611632312765894041044512e-12,
1.090774661222598981500148033346056672642e-12,
2.509953268731714846694218385310666555762e-13,
5.247056608337404618494895359145392592216e-14,
1.003914828060520936986173445955019826001e-14,
1.768879109481471514452264971221522084673e-15,
2.93877245945743094485020721706233769655e-16,
4.397652178708750736418336755985254187204e-17,
0.00004241400569848595372383553422662203526308,
-1.16234235123074063659663136724659006677e-10,
-1.338192780017104301846621262887510626643e-10,
-1.027095841589644718233839628067013908257e-10,
-5.912380518188710159967388421872714457463e-11,
-2.722698045606072508516962596532918736828e-11,
-1.044832693438224359693659957325880281493e-11,
-3.4366085913235705622022001494554031817e-12,
-9.889790651697460737230518157354891270902e-13,
-2.529431452048095731736005373316748639865e-13,
-5.820558379757655268868186345709157858406e-14,
-1.21685009073235510132238170436599554158e-14,
-2.328426946807771990267050980967211421892e-15,
-4.10349560244667773266331085410490451989e-16,
-6.820731922259893592775666706595945822004e-17,
-1.021610525579591492348406163726251408922e-17,
-9.095403765583673745257807455304509462029e-6,
2.402362922393996479116170848147182700356e-11,
2.765815950685521452126995467119682890674e-11,
2.122832098390935331637664558431111805703e-11,
1.221988764733092786623553478604575471712e-11,
5.627359190014938012352562873409434928228e-12,
2.159496744114370914514651979281530594199e-12,
7.102923834775574767658715754562350732354e-13,
2.044074674673563565098803128428637864982e-13,
5.228025789075794316607484955739809555329e-14,
1.203066860065654037711608120251073619363e-14,
2.515259738725880730158491898031763332279e-15,
4.813372443448726914901952463381060185538e-16,
8.484458332105878763768312102978575757881e-17,
1.410894281455358861946041676348417330063e-17,
2.115034944689670432042242186058516476358e-18,
1.75755482329982703737185993421252435925e-6,
-4.480063133072720184547637362422344670226e-12,
-5.157851472810898252297988719912300045081e-12,
-3.958779159849986111058212312798259257799e-12,
-2.27883558036189756925878308843682694636e-12,
-1.049423327372933306068457543932850190194e-12,
-4.027163178738496748046267505083809519177e-13,
-1.324600836615585646197206249093042424404e-13,
-3.811948391646234878350052884307676635976e-14,
-9.749733681835304215889428723007336539755e-15,
-2.243646127631643419961128744916199323073e-15,
-4.691012526368837694576716581327044796384e-16,
-8.977829272297754851027035873271122578729e-17,
-1.582789847071203393154972623891995135311e-17,
-2.633133198033305377262123826785199325225e-18,
-3.950365206928187352381885512077889076332e-19,
-3.090998222293608266400138022992455635459e-7,
7.613088758722497365222030335682829703383e-13,
8.764872957751026096966336614093845894082e-13,
6.727258846296809153522934584305583569908e-13,
3.872487223352349760764742383974441883145e-13,
1.783314715516841697022118465782383739052e-13,
6.843480940761248610242010665368286316988e-14,
2.250940266567211669623902625302729185551e-14,
6.47780960226448139324077330797232835352e-15,
1.656831581651345799249278009754222036166e-15,
3.812842541882362757147471868602105699596e-16,
7.972213596751861418319392715475045309581e-17,
1.525875634843660463053118364143720218971e-17,
2.690561381467405713258997964712480864086e-18,
4.477741963639212955271745633460137564707e-19,
6.722648460324600404552574796403615486704e-20,
4.987769126083402579354978175425008101046e-8,
-1.188380333784917439088114011135805951163e-13,
-1.36817049651869331207843595136970357396e-13,
-1.050105174557656009051671295388055842364e-13,
-6.044839623877097801733517417995477339342e-14,
-2.783703923877798330137770237203953586851e-14,
-1.068249327513143147252973598550712737555e-14,
-3.513666772668522812980746948583498113022e-15,
-1.011176229374372930346159385484947742243e-15,
-2.586313586025904501572799009445289391372e-16,
-5.951959739564726183725012006142493379759e-17,
-1.244533687825574428440991154237817228671e-17,
-2.382209363918281863459988472549326615718e-18,
-4.201173907423009873968111847362093380971e-19,
-6.994263586708843286178186378320481886108e-20,
-1.050795577344798081153168397415956816164e-20,
-7.438047178578824112369507162223744114116e-9,
1.716122929995455649675486314726046877537e-14,
1.975755453107376733667500578048901773145e-14,
1.516442080439587558491707570371108439107e-14,
8.729270126908308255167091472580266242991e-15,
4.019910959474701607637115628413002041731e-15,
1.542646806187143044520728957202947024543e-15,
5.074057876228202990896589513342677796881e-16,
1.460237960338745169200648138429160938896e-16,
3.734924612493985361267496965398307749984e-17,
8.595445782127637373690433177810480102753e-18,
1.797341572587564751744785416697934317174e-18,
3.440604938407991048381202382958599698589e-19,
6.068595035436239822487728077757245217763e-20,
1.01065870869397805180362029390119666629e-20,
1.519343981784431150012879780336472652023e-21,
1.047356305244602762351126245910236119794e-9,
-2.340238034040048829765687881907527718336e-15,
-2.694293215611191191642516092740357034956e-15,
-2.067938190851909244805926002619411978819e-15,
-1.190391387150769769390543380178927543106e-15,
-5.481867190940162953646243246996102714185e-16,
-2.103676940841032291482717604509379804691e-16,
-6.919407229771891415730262551761484778075e-17,
-1.991310452418706541787583655484552752e-17,
-5.09331938733449624183198400177144046346e-18,
-1.172181721674550945191990064514698716895e-18,
-2.451162573622784206292971946828960128669e-19,
-4.69251918539531323310296398060071676428e-20,
-8.277889938517793126046515265004096785025e-21,
-1.379035599622231611233532536416658349296e-21,
-2.074395677549373136296799091133835913669e-22,
-1.353591030616355624324957651893608289126e-10,
2.934884972105088746111313010260476511847e-16,
3.378904639759117344809785028208654117106e-16,
2.593395091481019434654343591535734765885e-16,
1.492866637603832269847672259970173302534e-16,
6.874798258570166082606655106021679576099e-17,
2.638219457668030085551224109488038219965e-17,
8.677639649915905266630543968635284620549e-18,
2.497315370111268887466689607194860629237e-18,
6.387614833364803424923106626641325961784e-19,
1.470075194018629997580206361045059841122e-19,
3.074187309290845926187733481765143274408e-20,
5.885607852893506318677350454123770092027e-21,
1.038388067773807119369616504593197970326e-21,
1.730383139111868894660453472120142575709e-22,
2.604345593443307316789933159117973827756e-23
}
,{
// [{0,0.0001},{2.,0.001}]: m=-1 maxabserror=3.32901170310096187e-20 maxrelerror=1.201937963996575517e-21
48.02102665402209368126888165211052759414,
-57.32373297496431077058376259658948616538,
33.05723545371803889625720238202192559232,
-12.66486976017775527262900030118840582359,
3.650628428285160476043096316718919917276,
-0.8396754529610724793137863969575271178155,
0.1611778873478245282458097204274690156818,
-0.02653282198113176425678048116100646203093,
0.00380714112150870149353721323027680832512,
-0.0004897957242940234647551677027462856809257,
0.00005596136937133466395867037482915413817499,
-5.871320138637540415404057258896318664579e-6,
5.796550041724300839745576953096163901539e-7,
-4.469841295626467004074544520465783471007e-8,
5.282926328289451149853591749091572129989e-9,
-1.687869742311658594656084165954171827712e-10,
-1.432226895012692704074775841051510154348,
0.06888932578355599081739945808933660373318,
0.03759706814740095370312938817334780446967,
0.01289561987730127752200288455378283696242,
0.002869339369869316818712243171059257911679,
0.0002996112679554334588776196950979801434686,
-0.00006625705100372790670280898169055343470692,
-0.00004468494970915405132377657998637185934739,
-0.00001338831640303825689594297569996424654853,
-2.537927375953535982684067136167074654811e-6,
-1.989623400288232730421488797630983819891e-7,
6.958602290406541119802257753501664587048e-8,
3.817754912490289298533744219396117751449e-8,
1.077124650878555164291222916866369690431e-8,
1.960175283314781358401702590219642540628e-9,
1.498822385716509513659911010502583223832e-10,
0.3786051702961769129020626985862871397851,
-0.0007671855345105107323322193254361133096023,
-0.0008584537144192756486557453916392172241331,
-0.0006309349266155846630142898164699893302896,
-0.0003397388757139924947490505863077486961549,
-0.0001408649032577984043065389876764528086136,
-0.00004554153590523611575793113035449079635182,
-0.00001106846090450970953254535966626304460428,
-1.656848908216020502695186091584180140088e-6,
8.543136989261247309173507587944419241562e-8,
1.624054425910094857024290203220473303364e-7,
6.616196858089345207745119907519884268116e-8,
1.768471667272861838735714588342807285623e-8,
3.163162614972936663174340474155041741626e-9,
1.24898067504759361225705728757887228055e-10,
-1.388662691452452872355214021184922152828e-10,
-0.1336541494561747540439485222972739516905,
0.00008646627254119339682578171115632034813885,
0.00009939324843278375733403436778446258157112,
0.00007605359870305596719942741996809162810337,
0.00004351673753237430383531704676183385513743,
0.00001980412961434968542214699951795415595909,
7.424917073150804033080893825273851963229e-6,
2.331899918895038464303001355762471607413e-6,
6.109404858075674290980824194465857264914e-7,
1.275476780746993226948756679058710899992e-7,
1.726037532765432681526653453402479005221e-8,
-8.938134471665934985188771114591388838689e-10,
-1.64585255880356800973417544605740768806e-9,
-7.129738167904851696736488091814317320172e-10,
-2.263659069443763179912320553504845698651e-10,
-5.194688260387262130091756545918935316762e-11,
0.04448111491880526091392175777572017193084,
-0.0000162710171195894875803437860250336074836,
-0.0000187228846169240790097427986439218493308,
-0.00001435529310411399034451886099788465521398,
-8.246269788518711157108573821096279232524e-6,
-3.781650641958394386499482854987800372781e-6,
-1.439103761655710165573663921181816813577e-6,
-4.654227364149110810730170677228552013077e-7,
-1.294140653751824917117960612081732387072e-7,
-3.081002772771366772208137917704492402167e-8,
-6.052556633564100955605331834577017363598e-9,
-8.414906932227104336943357977886420183166e-10,
-4.926198167386016821475357648859241987953e-12,
5.194568718685478559130817519114452773668e-11,
2.685524316758693994312400738721942614695e-11,
8.620879849603311688694382013630816506561e-12,
-0.0132314217607563707666407433768482159406,
3.321070277783606106102578816836643062639e-6,
3.822363041444374114560950764157153736615e-6,
2.931991420412900636213135830930760423587e-6,
1.685741063561321215491653497388594125753e-6,
7.744269672911139985727462086090090340635e-7,
2.957520082257697881842868652135236723155e-7,
9.633583849496779490845600895163752979185e-8,
2.718293170976506207773788694119165868221e-8,
6.677005051387835594478594651930933188704e-9,
1.410409668207587019358204569734205386408e-9,
2.425767239106723891540780990578606477175e-10,
2.676700457022694449423871505846026646973e-11,
-2.149714776792408144056916587135785711747e-12,
-2.885185539885155570842079051482871545674e-12,
-1.11840739607870744439882143120403299219e-12,
0.003498810744242982858015671432010569349159,
-6.638196466473165565823838715506617009285e-7,
-7.640892539064569261803832069183866330936e-7,
-5.862125370619689371762239543428761510693e-7,
-3.371660527536171950086647371260877088347e-7,
-1.550083323536912474332529822060875631016e-7,
-5.928541722139325380115992144741661029841e-8,
-1.936915169551524700070498402807519155655e-8,
-5.498896659878151449888443415784320850476e-9,
-1.368065976794694247978547198590721604649e-9,
-2.972100267113107203393319499027818298215e-10,
-5.480599576958856341742954731719522236173e-11,
-7.717461882817959030411023966244036607978e-12,
-3.832721186810164278304838618001032094688e-13,
3.029551822706781963667883639760628507666e-13,
1.47085917150351878983776994942493395039e-13,
-0.0008270446920350620670719631251076076636145,
1.256884964792138591691207172414152273836e-7,
1.446809380253401578095475450014952878418e-7,
1.110109760100837181433380238391832673953e-7,
6.386190812608935553357750438453987124507e-8,
2.937161140505651243560062001756558980802e-8,
1.124271047901403928383286155074300459419e-8,
3.679081038243183737181647633487545973603e-9,
1.047940313654525705751157791593985792224e-9,
2.624973343889202078211770951717297082485e-10,
5.786470370751665516522522789841386899019e-11,
1.103798264309734582729759075223502112704e-11,
1.710868020110886695203473003624331505445e-12,
1.594412185204874590051242324638183679311e-13,
-2.728056631096934011421959073394849219612e-14,
-1.914337529861502171463436953677939432754e-14,
0.0001761554124145428127224734451634966672434,
-2.228531921622011324322137698252505778743e-8,
-2.565359546726692846645037565710616976629e-8,
-1.968475649589783649249254863230054839254e-8,
-1.132557964041568967668433260539622421256e-8,
-5.210210627745628366731815256848372217668e-9,
-1.9953403711204232794142161869877426746e-9,
-6.536189300707731949028532284979885115023e-10,
-1.865566868082821728976801150430386731632e-10,
-4.692693701183991322377559274022850327107e-11,
-1.043654701982208142955745321864151933082e-11,
-2.030746653791182728517349204728433862812e-12,
-3.312618826420129100851553813721463323028e-13,
-3.803991945150346002175003574031301353078e-14,
1.412554557687433441981821473143617883908e-15,
2.388102978507922494982668667692656429752e-15,
-0.00003407994171994234764798008809697806387255,
3.688549609458009298803290704271732625115e-9,
4.246139580791800240934284119530471431274e-9,
3.258326367651829433792320644277589283942e-9,
1.874830505310078502137852169801642807817e-9,
8.626427844423229457663463492223266565627e-10,
3.304770397051853897910135519083866941779e-10,
1.08329678704112206454159410082947447874e-10,
3.096253796149070588386340909583627746605e-11,
7.810499323524602529605093763644389230876e-12,
1.747370005988284079588193908320849500921e-12,
3.444478556929641033034391530561419108088e-13,
5.799200152081561637910580508796720739745e-14,
7.406771129814090479828629830191384402989e-15,
1.580643496382012101726167481908436295077e-16,
-2.791966626822522782485889004537305390259e-16,
6.032991696537171093449322183844685587175e-6,
-5.701349184592805950008707752781797579896e-10,
-6.563310728986963526647602795418831312423e-10,
-5.03659069752685167089278726830157541365e-10,
-2.898216665946326904113736578147384789523e-10,
-1.333685404047105616167581792804278008996e-10,
-5.11058973951965960888507581067869225264e-11,
-1.67607196912231244777663262081105908153e-11,
-4.795305756128106315905572577901308892599e-12,
-1.212112505582402746068313401135901716599e-12,
-2.72322906630376427281144764917534704182e-13,
-5.417358595197527477424484493190173366422e-14,
-9.318398998254543777864109824010257332112e-15,
-1.269613456758514287322640223316516810994e-15,
-6.863392345768578595308081330754130561452e-17,
2.999651371130786660964895551459305766466e-17,
-9.836649907194580937810803631990657997935e-7,
8.245645078844920561659345822130982921425e-11,
9.49237772916845898421916123114043694602e-11,
7.284484183710352499462274978840792273052e-11,
4.191922068994122403877510141354334427339e-11,
1.92919526256130758156090316503220334427e-11,
7.393921047340875430240696105813198783475e-12,
2.425822421903406527910567952990544686845e-12,
6.945605303193001117621783353131081730267e-13,
1.758334989758229249918569335841783236384e-13,
3.962923929318254040318538664378898696742e-14,
7.936939855772817028750827709822920922296e-15,
1.386509365732135839328550631258661777193e-15,
1.972956502441449881899662009605404244558e-16,
1.478555636744657999357046303318957590052e-17,
-2.886775661393655022284121402837341433806e-18,
1.48564106109106238268915006045038314997e-7,
-1.118613700943079144455168389174567826028e-11,
-1.287758574407769097849111743263290777834e-11,
-9.882484163228994340431564481232048347556e-12,
-5.68717109894373057427658766890787349203e-12,
-2.617525031272478552404185144570875175362e-12,
-1.003350515804571145524340426910819688002e-12,
-3.292787319005002194985893406128878791694e-13,
-9.433438079400932616839927721136127780947e-14,
-2.390995933034280057487657356504171847231e-14,
-5.402031057049759110362443402670363569878e-15,
-1.087551680060828991215288841307221638604e-15,
-1.922145965609109107074483538952098480947e-16,
-2.821776632993227402946638850682500474001e-17,
-2.522936662272583667555557114594755826441e-18,
2.367788485182654727971528740906986561783e-19,
-2.089590823247336946033947421676656526865e-8,
1.427664512626457406710059544956297470762e-12,
1.643552726331945401135375004235516674059e-12,
1.261309422062310971345519045621415972915e-12,
7.258793708738784590958956587698007571737e-13,
3.341060281062321148708672645390874703297e-13,
1.280845731263911534714561266463420715632e-13,
4.204452579595894718671216054477901185993e-14,
1.20509200228133241515311013164336887346e-14,
3.057333356560471079176930140247533467444e-15,
6.921011863805878382598270717439835680305e-16,
1.399102256883963196845149643670614406414e-16,
2.495414146189096618446851248485351006907e-17,
3.750346062127458517230127009003491593004e-18,
3.751177709123814190513501472464964982452e-19,
-1.428370635295548342822619992855549208916e-20,
2.789147363442904995797267175912842129063e-9,
-1.740167476356508480108080997294402503478e-13,
-2.00332385314295139685011556817693193929e-13,
-1.537426764510496377898878499850850044294e-13,
-8.848054853358719326365099960645818764482e-14,
-4.07275967564185739253263873717935501522e-14,
-1.561505744800652866262503275098285894679e-14,
-5.126736578082907312242621400534918517741e-15,
-1.470016437999651194808552512745994076571e-15,
-3.73241016148078211657935510586385855768e-16,
-8.462937575167247586118348752947202995292e-17,
-1.71663490447377250764166484246427230558e-17,
-3.084633495798819154861094995641839183513e-18,
-4.723067221558519636377539072640952635709e-19,
-5.114261151102827931520925831515809589715e-20,
1.126983578761054845781326479904366530799e-22,
-3.440766644818778801618693104749161267792e-10,
1.979196842925603492571761334712750280201e-14,
2.278511635598536921539165478438658192294e-14,
1.748633600717777043985671663486098935199e-14,
1.006377171675671204140709582135844861405e-14,
4.6325374549957904511161153719905016824e-15,
1.776266587798037893016458141865978501291e-15,
5.832765638706328239239908619930814264799e-16,
1.67299364391367580195968425842654566208e-16,
4.250513043416437804989367381551808978703e-17,
9.650384155947871978592059252921780973481e-18,
1.962879051075942899242524466598651240453e-18,
3.548165321656642394621169450164310199822e-19,
5.512507464064376608048238657687740198787e-20,
6.319504659958749428375343836924656894365e-21,
1.383994127643036959592785687042688148409e-22,
// [{0,0.0001},{2.,0.001}]: m=0 maxabserror=5.033663359066132363e-20 maxrelerror=9.2344914434711016704e-20
0.7161134475063463520209700375027327024977,
-0.03444466289177799540869891251912253994521,
-0.01879853407370047685156375407030440356891,
-0.006447809938650638761000720854292106585139,
-0.001434669684934658409355706378002033411489,
-0.0001498056339777167294386187080565689959213,
0.00003312852550186395335147778912464312382645,
0.00002234247485457702566191236512442690930353,
6.694158201519128447978396709175764774141e-6,
1.268963687976767991343790654222911243418e-6,
9.94811700144116365214741930322493607941e-8,
-3.479301145203270559892963053491788153801e-8,
-1.908877456245144649265382411497567267609e-8,
-5.38562325439277582145374888333101941466e-9,
-9.800876416573906792005578480854176818972e-10,
-7.494111928582547568297998234717340445009e-11,
-0.3786051702961769033597100044842231502916,
0.0007671855345105107318231262731224438649052,
0.0008584537144192756480696595239333178019116,
0.0006309349266155846625644970631776762228878,
0.000339738875713992494490180609118390285404,
0.0001408649032577984041873724279498790495885,
0.00004554153590523611571223570292405192571196,
0.00001106846090450970951753823418697332819899,
1.656848908216020498389577339389614182583e-6,
-8.543136989261247418624152762240444234242e-8,
-1.62405442591009485951202489975163194359e-7,
-6.616196858089345212816848084910818247723e-8,
-1.768471667272861839657063541696324663489e-8,
-3.163162614972936664622960228602285904172e-9,
-1.248980675047593613992306437346871633951e-10,
1.388662691452452872286577794078076685526e-10,
0.2004812241842621384223241768902526745045,
-0.0001296994088117900956045281196551605923475,
-0.0001490898726491756364222388748266200017985,
-0.0001140803980545839511223844944594451522254,
-0.00006527510629856145593901504099194308937634,
-0.00002970619442152452821886319094654553039365,
-0.00001113737560972620608246364843530533559345,
-3.497849878342557707241697803946523235949e-6,
-9.164107287113511467427337803556030316749e-7,
-1.91321517112048984829600393105593543185e-7,
-2.589056299148149040201480210345760221615e-8,
1.340720170749890211190183773133179690631e-9,
2.468778838205352007926452152569308927436e-9,
1.069460725185727753450483810283449285502e-9,
3.395488604165644768553635193874917931809e-10,
7.792032390580893194440033754492932100576e-11,
-0.08896222983761212542271790665810561979139,
0.00003254203423917906071066028694211931537584,
0.00003744576923384825650763005480595903902304,
0.00002871058620822805627395839358737897222204,
0.00001649253957703746581573353252369087977656,
7.563301283916808798210770491594645119784e-6,
2.878207523311428009984751469557761735085e-6,
9.308454728298246840019332830160328136153e-7,
2.588281307503657069549620736278192064198e-7,
6.162005545542751936935857084346232597465e-8,
1.210511326712824371610845820472172564044e-8,
1.682981386445429390133585231214239171953e-9,
9.852396334773581919603161099451971767886e-12,
-1.038913743737093277487708775530312389555e-10,
-5.371048633517385072567494022916251230223e-11,
-1.724175969920662222376605100860263144048e-11,
0.03307855440189039718905390244661360181323,
-8.302675694458988920737826842635156672891e-6,
-9.555907603610904957554841586758323887441e-6,
-7.329978551032228314431701737671517261069e-6,
-4.214352658903289642402941842378351131437e-6,
-1.936067418227778829474744786354774824095e-6,
-7.393800205644221055524983320903327599431e-7,
-2.408395962374187105069522106502428642829e-7,
-6.795732927441243228569855934824934661848e-8,
-1.669251262846953229524987838618026226405e-8,
-3.526024170518954650682154006743710626625e-9,
-6.064418097766783382459773712409374971213e-10,
-6.691751142556688059525742846137053203941e-11,
5.374286941981096688081479080648103462917e-12,
7.212963849712898395130700032736812374235e-12,
2.796018490196769113351993454605782285468e-12,
-0.01049643223265195759791880559217010550518,
1.991458939937842413010224180001997780482e-6,
2.292267761714642359787059054186298630365e-6,
1.758637611182277977221766055621933162902e-6,
1.011498158258763075908810105732920275258e-6,
4.650249970601123312646445862239773735325e-7,
1.778562516638111001741477655051480073724e-7,
5.810745508642466661461388553793103609827e-8,
1.649668997959971758084517566345779651494e-8,
4.10419793037525248662176512538817610341e-9,
8.916300801319251051608599714594716210375e-10,
1.644179873083565124004140779834879524595e-10,
2.315238564837954404854622773362175383728e-11,
1.14981635603136193441904826570890413705e-12,
-9.088655468134346187602589565573759828436e-13,
-4.412577514511110313570754529201073975135e-13,
0.002894656422136844724815569974525718578261,
-4.399097376779510898682248052165588882494e-7,
-5.063832830894993933003601629874514897951e-7,
-3.885384160359137645588587947572564636036e-7,
-2.235166784416700114035185598032925816227e-7,
-1.028006399178622602947600296088477113981e-7,
-3.93494866766122073043570075383477254256e-8,
-1.28767836338718586287962506149448179791e-8,
-3.667791097796784728052550476926412999706e-9,
-9.187406703627326201718614844231557503137e-10,
-2.025264629766522626847973976472159400395e-10,
-3.863293925091097370860543700563227554884e-11,
-5.988038070400921660000652592562367886692e-12,
-5.580442648237417039111918591897236586244e-13,
9.54819820881401854605206018066848821782e-14,
6.700181354513917811603873663485551912576e-14,
-0.0007046216512716313834709361523779278311362,
8.91412769509519727447756071655765000527e-8,
1.026143819681562819335370199517619399618e-7,
7.87390260596370633124076554198151381898e-8,
4.530231860542947861956985547984549691456e-8,
2.08408425311298077902421517515975213899e-8,
7.981361492207344434338671839413810225135e-9,
2.614475722820323334941616158360168193179e-9,
7.462267479610712364616745866139505208864e-10,
1.877077482324062521475377526170664046989e-10,
4.17461881213481389781814451016151209379e-11,
8.12298662373945733588889710401035498688e-12,
1.325047532125776145193342889256030303665e-12,
1.521596780509349149234202402348237175503e-13,
-5.650218201410255341063893868374560789979e-15,
-9.552411912870693511213800710765784520843e-15,
0.0001533597375621232022672169106855085535881,
-1.659847323372793197038570687743863723377e-8,
-1.910762810339407705487137785521195794347e-8,
-1.466246864662893880229513747880713096887e-8,
-8.436737269403670429937217092637801037207e-9,
-3.881892527922721011885493088929928787423e-9,
-1.487146677880399106915141262400277707518e-9,
-4.87483553908061991242114482257902376682e-10,
-1.39331420751968651799486721461207729056e-10,
-3.514724693685267830047389039142222014959e-11,
-7.863165022622774397992848124220107320054e-12,
-1.550015349734963770745929130336698763556e-12,
-2.609640066825150098562616708186863683686e-13,
-3.333047005857112977380202887608299413821e-14,
-7.112895701973080759968951391384847624314e-16,
1.256384982238583847520554783223147932606e-15,
-0.00003016494126963625632160517609811333188133,
2.850673674069400829938220890841427280771e-9,
3.281654307398183206154289998297265833465e-9,
2.518294537493548803549539778101211788865e-9,
1.449107866061641564606705111639990540771e-9,
6.668424870884618295108229804576045030768e-10,
2.555294045572935338919085828371679270109e-10,
8.380357138846591455799831157172784605954e-11,
2.397652101481295088530659343419832821886e-11,
6.060560553799945645928135693112216967293e-12,
1.36161408444973746483064328444618389738e-12,
2.70867838283004315809184793368608160117e-13,
4.659197837314186279596930630858061688139e-14,
6.348064670916297851512842459750822490883e-15,
3.431693042848859060214865736864619076564e-16,
-1.49982580943629157503076536207508603634e-16,
5.410158585786173821875934027958074902687e-6,
-4.535105358717912238352366600001232610611e-10,
-5.220808401899532978529632685623930796242e-10,
-4.006466800545681631125813959198493299474e-10,
-2.305557425431846779194426071845227297022e-10,
-1.061057526751583236134156697048690116724e-10,
-4.066657083546658682485599339770054451622e-11,
-1.334202498740433639937184022340311163542e-11,
-3.820083395118045669760402739044777120649e-12,
-9.670843660258027853638303465092472550405e-13,
-2.179608437910074955015203284330503351809e-13,
-4.365317486069243147353699008424583932734e-14,
-7.625802542983597239103390290528715839907e-15,
-1.085126240143561429647080889399123058069e-15,
-8.132058033971052105143437091589542081876e-17,
1.587726505949787071538660450834878455406e-17,
-8.914822950715774348715129886300083963465e-7,
6.712203153581242931686045539725038159555e-11,
7.727151180062713379363575007217259839828e-11,
5.929950764687645544147418576010546345383e-11,
3.412567557466872399855341352142317970673e-11,
1.570636960277155072795321743001571096458e-11,
6.020570689943234475875689411413996060126e-12,
1.975825957313998675867225934182074584064e-12,
5.660503435006687471372199733354307562936e-13,
1.434709559336253694474460645616379150016e-13,
3.241473201508291989659375694478680023967e-14,
6.525829066712275227002942019240903637467e-15,
1.153381861024394670440458679174568512151e-15,
1.69321421961390061035051114606320545321e-16,
1.513939579311050445389697320152701392158e-17,
-1.420602807513057161385211798258179580284e-18,
1.358198205686524276737184097109203990333e-7,
-9.279641151038587019750214276329026672805e-12,
-1.068288759213320715078944097118872850108e-11,
-8.198353815598747037307143408028248039473e-12,
-4.71812530468715914625587925130733551555e-12,
-2.17164747250272024729117139859894385081e-12,
-8.325337302746347989896739220381741759918e-13,
-2.732841640321094351258881610347040944201e-13,
-7.832947250635332778551459832390678585279e-14,
-1.987228338852316803527238406845272965766e-14,
-4.498570477775020426656524598715091399825e-15,
-9.093986475737496803858966130984867424919e-16,
-1.621986686819529183744544291876054556719e-16,
-2.437673315606629728651951220122388270788e-17,
-2.438201472518209190534949539283456384526e-18,
9.284748941119912557896283301522921702528e-20,
-1.924354341548659286857940570245017297062e-8,
1.203155132044603511461772864475135291879e-12,
1.38510179852197750080891197958717095907e-12,
1.062979452569055695413150267001274639127e-12,
6.117557236650530584848523006203228031907e-13,
2.815909053168947413800535657228549967312e-13,
1.079624261141258107675461694751150412047e-13,
3.544610066797035156402192200720641595972e-14,
1.016357432854294218531582912996607565564e-14,
2.580519820745090917827768496220767924653e-15,
5.850942222561597477630934699789635577427e-16,
1.186738658897395416275681993182776559229e-16,
2.132164848987277034121429357779804561828e-17,
3.263571072544901347449110288526756928303e-18,
3.528979109730582050988561050467223917289e-19,
-9.907655401287091757914206259932203161104e-22,
2.584984978480699127656861063208249460055e-9,
-1.486590725683006085878587736828535278309e-13,
-1.711408502312924554097789375153345398814e-13,
-1.313412858495526035927745027539792546873e-13,
-7.558980783376842163111164060360851699668e-14,
-3.479536877928191376363160957538234302537e-14,
-1.334168648338771943799555697143488131522e-14,
-4.381040533105163978661317788269442943165e-15,
-1.25660087365770090985488915711591274746e-15,
-3.192604117418863477225143956083653926555e-16,
-7.2485250443846429882131410374241650872e-17,
-1.474352542093183148779922444916688419525e-17,
-2.665125178606549847287666807893232621928e-18,
-4.140734703339615663487246023062645013294e-19,
-4.747510520261777674768781750387476522916e-20,
-1.042178164312873406720057234834253197355e-21,
-3.205907358574590429860981407350691315122e-10,
1.710107554022612298295687552077898414396e-14,
1.96873611313678110290632072465005251051e-14,
1.510910429079300535080772956162043295504e-14,
8.695768372232157530089662753333480247666e-15,
4.002954971162197400245507458613242602581e-15,
1.534967195150686644147992719562359161654e-15,
5.04108442298801061143905764117404368525e-16,
1.44630945698923144442646256716255693527e-16,
3.676591713848626239830885927352673970928e-17,
8.356645663919054487668100293103803339537e-18,
1.703670683487306044290335454740017771534e-18,
3.094978202160129316143357937605178530404e-19,
4.866277047342100660768050872854121850273e-20,
5.829568698646846123111203274983330347713e-21,
2.307532262446703771387843942556039917719e-22,
// [{0,0.0001},{2.,0.001}]: m=1 maxabserror=3.41970303712260948372e-20 maxrelerror=2.87999242231631961598e-19
0.1893025851480884516644241080807567638526,
-0.0003835927672552553659108444691689013337004,
-0.0004292268572096378240340024011817532342861,
-0.000315467463307792331281613563406900961826,
-0.0001698694378569962472447248504502736710924,
-0.00007043245162889920209351797412081286309934,
-0.00002277076795261805785605333153006796056575,
-5.534230452254854758747923129462346756363e-6,
-8.284244541080102491887054008148932250407e-7,
4.271568494630623709466850866545085146914e-8,
8.120272129550474297595366073354965493268e-8,
3.308098429044672606415635143406793574657e-8,
8.842358336364309198298520601827645167706e-9,
1.581581307486468332313594563681296099688e-9,
6.244903375237968069988515602867191130216e-11,
-6.943313457262264361431170319085929576977e-11,
-0.2004812241842621294900602694259712698888,
0.0001296994088117900951602972530208297490022,
0.0001490898726491756359108228035660013247454,
0.0001140803980545839507298944019172611453746,
0.00006527510629856145571312131180133598795383,
0.00002970619442152452811487371567240160255112,
0.00001113737560972620604258570600190927241403,
3.497849878342557694143617977435495309753e-6,
9.164107287113511429839674641538737056805e-7,
1.913215171120489838736572377956039370128e-7,
2.589056299148149018452896915356269617479e-8,
-1.34072017074989025561638511887124077563e-9,
-2.468778838205352016031167579311614662664e-9,
-1.069460725185727754737547302985242930288e-9,
-3.395488604165644770150146593945076301538e-10,
-7.792032390580893195287057989849717273954e-11,
0.133443344756418195048243346323976428104,
-0.00004881305135876859138799994827859341591253,
-0.0000561686538507723851321562769731297772718,
-0.00004306587931234208469544444398805751046243,
-0.00002473880936555619888734739971491772841611,
-0.00001134495192587521327269850297216374806082,
-4.317311284967142043886234367410509817731e-6,
-1.396268209244737035499168335532960597895e-6,
-3.88242196125548563158141653019238829564e-7,
-9.243008318314127974752788306810373816947e-8,
-1.81576699006923657320678175563323635893e-8,
-2.524472079668144117510804006323018369841e-9,
-1.477859450216037879516542678131077870144e-11,
1.558370615605639906757426684923765383486e-10,
8.056572950276077596760800545040172700347e-11,
2.586263954880993332794803436156089254484e-11,
-0.06615710880378229545085637556406641818001,
0.00001660535138891805249207373039744026602266,
0.00001911181520722189585581869780987513521381,
0.00001465995710206452258470412544976624284793,
8.428705317806617245027550311472039147962e-6,
3.872134836455575133819621905319484372175e-6,
1.47876004112885091237818431305157316929e-6,
4.816791924748396220756984150435558503205e-7,
1.359146585488254962119021588899593115311e-7,
3.338502525693922523164849994812334455652e-8,
7.052048341037945848713537017618376922395e-9,
1.212883619553364142087525236619396060834e-9,
1.338350228511351231488869283497697592554e-10,
-1.074857388396197709042686260495745064664e-11,
-1.442592769942576996115247124478275379621e-11,
-5.592036980393536803145444460223834749185e-12,
0.02624108058162939611174152215627042866305,
-4.978647349844582845234145293905370086544e-6,
-5.730669404286579205261321735792830976156e-6,
-4.396594027955674456258312617987162232544e-6,
-2.52874539564689589865545176280484078215e-6,
-1.162562492650275400022469596686908203498e-6,
-4.446406291595256687456456112635497235139e-7,
-1.452686377160609827283278674444583973069e-7,
-4.124172494899909767974349665921774086143e-8,
-1.026049482593808127965244574070584936441e-8,
-2.229075200329801392451384269139807567423e-9,
-4.110449682708889543874258898868227526902e-10,
-5.788096412094843413817363588304257988231e-11,
-2.874540890078336614404696405855389768792e-12,
2.27216386703359525306531634700439511938e-12,
1.103144378627778132950870232888001977525e-12,
-0.008683969266338465305447676048977610419692,
1.319729213030269279923909251688775805799e-6,
1.519149849264372149801081049222977818949e-6,
1.165615248104574740969671834397455075902e-6,
6.705500353231875565959449052896465854684e-7,
3.084019197527478089670514919042241998828e-7,
1.180484600295148924762805184118004124747e-7,
3.86303509015099024748375864948061968117e-8,
1.100337329336002899630900825353989416286e-8,
2.756222011080485445372777893174407739587e-9,
6.075793889282021416009989769897781664034e-10,
1.158988177523744959610765473826654341843e-10,
1.796411421113737691357220049996950981327e-11,
1.674132794460841127609590224956252172169e-12,
-2.864459462657086500303612921126836863962e-13,
-2.010054406354858865848354166603687851522e-13,
0.002466175779463988069376352649883233359564,
-3.119944693289502879858752853134571033948e-7,
-3.591503368892588962881539476184065876496e-7,
-2.755865912092760852886389797720406170443e-7,
-1.585581151193176332224235147764491380284e-7,
-7.294294885909909066180385555663686597232e-8,
-2.793476522278122223928398369198914329492e-8,
-9.150665029889368198259952271717363703135e-9,
-2.611793617868983728478162955558687537207e-9,
-6.56977118814753653152675363625546487702e-10,
-1.461116584250217257855833217222683243112e-10,
-2.843045318315014931535831880100181245571e-11,
-4.637666362451577093177236981939800546934e-12,
-5.325588731800916137620749892229645631034e-13,
1.977576370470370695101610307368457558106e-14,
3.34334416950326372968679364164716572498e-14,
-0.0006134389517588051589830627733676996010793,
6.639389301001789257279443086900716836095e-8,
7.643051250004148366033010753045000584409e-8,
5.86498746528741019163377470232467421604e-8,
3.374694911580656200736425690764199677074e-8,
1.552757012927239782330307348607238430778e-8,
5.948586718263765623862743913317880840474e-9,
1.949934217846742387667471169962224106194e-9,
5.573256836433699769204896633354967794702e-10,
1.405889879090322926769188907174055082613e-10,
3.145266012726152578215983851802653787929e-11,
6.200061406451028666552340094562869538788e-12,
1.043856028100336867184326770711047227161e-12,
1.333218804518926108926969346021501047321e-13,
2.845158307782943582529355083683664927609e-15,
-5.025539927521825891183774851240012910278e-15,
0.0001357422355464230240113316084071153436249,
-1.282803152553776919950451016981325469284e-8,
-1.476744437434144616104766205157040029635e-8,
-1.133232541185189200948660987578004679954e-8,
-6.520985393323909167645866929564009922955e-9,
-3.000791190078061612710846717586050228053e-9,
-1.149882319809845068260036121392787163368e-9,
-3.771160710188205562559408783384371305855e-10,
-1.078943445008495370259122445653686315929e-10,
-2.727252247535626236083885713118952166014e-11,
-6.127263376211385343700995885026285901211e-12,
-1.218905271493421665389391619916817008936e-12,
-2.096639025363089707558999539362153075137e-13,
-2.856629099624901286890264150255875721961e-14,
-1.544261866362837588289737165332831826691e-15,
6.749216144322807937695421682777673046279e-16,
-0.0000270507768162835877864839942256101773,
2.267551878110537857309580277044872206961e-9,
2.610403278521023123261425804177713057662e-9,
2.00323269234798949608527609066478422657e-9,
1.152778305276880568850481522365553370279e-9,
5.305285758124891937404553925232315537716e-10,
2.033327822504469346180107322017660581941e-10,
6.671010131232648825886846073317217853696e-11,
1.910041019599075417522079694614866056123e-11,
4.835420105915514269730448367647277642503e-12,
1.08980382668017522851258207457373036705e-12,
2.182657941726045856113642687661938341375e-13,
3.812899809648795852305016252571024781814e-14,
5.425628879218994386499533410065944534113e-15,
4.06602613720448190244694314691128905374e-16,
-7.938634058085700015052307759229222268317e-17,
4.903153691384350274539257708985115769967e-6,
-3.691712232070407076297044983742594223392e-10,
-4.249933721893829722442557170183469843851e-10,
-3.26147336022613178399495554381488242324e-10,
-1.876912409644880719313762555075266576508e-10,
-8.638504446406426592583362376093516528962e-11,
-3.311314326200711136103460507954557336647e-11,
-1.086704423268378645966393138275891925148e-11,
-3.1132773104554718803291048514874442625e-12,
-7.890903647998751090050732112866990687775e-13,
-1.782810504840291291810612254051007225805e-13,
-3.589206485985099131170477086188362725521e-14,
-6.343601149799101004138440919975545362865e-15,
-9.312679671925441931781403767311185684185e-16,
-8.326669554588779101093042180158525950892e-17,
7.813314251147111223486384413917629564457e-18,
-8.150103387818733539939641190885762759163e-7,
5.568239272682624087110914974805109413416e-11,
6.410255888054901209941678874256933157122e-11,
4.919413925019574101178506830522585360451e-11,
2.831106340186087990280623528280234041249e-11,
1.303094896083882420795696462070420486822e-11,
4.995610453251427015090374079560294528158e-12,
1.639839017069790149177028323420530343134e-12,
4.700152985720501125149090437421538922558e-13,
1.192434825241514587328711808057226110544e-13,
2.699364840840693713588621064976825995737e-14,
5.456846501979045389459777847934456137461e-15,
9.73274948750180211918303140806651553567e-16,
1.462735698262250526568173008147142721346e-16,
1.463084267326659046759754409318573634065e-17,
-5.569982224100851565085965923811623399201e-19,
1.250796646391692125235305997143212924631e-7,
-7.820351530530331295948153768573367009961e-12,
-9.00298114353625289899662841878612421385e-12,
-6.90922787879860366725818477268667333448e-12,
-3.976332454343678335185524443622049728332e-12,
-1.8303041712195976007050441073413042792e-12,
-7.017416901865971520856374618489601850978e-13,
-2.303950293894254478565710103323452532904e-13,
-6.606190564276682832246434910154827055543e-14,
-1.677304108537630188096196474927717241488e-14,
-3.803035540312401067215829877251758756799e-15,
-7.713643921568127131621372214952842675752e-16,
-1.385878340283435385956211741909878196866e-16,
-2.121275054974082152129191725474334736991e-17,
-2.293777535838097286362458109188751522885e-18,
6.443727124101326684212079126138293501919e-21,
-1.783233735368030096678925692593760809803e-8,
1.027557472889645682153667140254451637142e-12,
1.182955329677742182518609040097210824985e-12,
9.078536374753903143223223958388002579756e-13,
5.224895921341880127428539566088257619243e-13,
2.405113094540738610543483941541809112704e-13,
9.22197843666873910341839979997250478434e-14,
3.028232836932506783126590559896384208021e-14,
8.685735128599442672813249638444376811773e-15,
2.206727476162664826632354950874380825786e-15,
5.010047805362338579156902288263950676427e-16,
1.018989745614766961013807050075931712817e-16,
1.841767384374535529183667417899425167334e-17,
2.860686111427567348145405419836549446016e-18,
3.276331543884147231166572205377788991814e-19,
7.046183562486058834727042570940106177591e-21,
2.408575417784049591373329727211231593913e-9,
-1.284510939182060978222285110290370905731e-13,
-1.478774298850927657619033272746578993549e-13,
-1.134888287208000172434089564757991634746e-13,
-6.531642036287978635954138511867833967669e-14,
-3.006734994322767865310932132356279027317e-14,
-1.152958341788077572205492554154268989933e-14,
-3.786505819599375356114059885432551465087e-15,
-1.086366002708352549585243065230122425361e-15,
-2.761600887044054246964749916637086967015e-16,
-6.276949821166356004499058199744890448645e-17,
-1.279689853262489864471716825113080686269e-17,
-2.324779849085484281946428071989026212989e-18,
-3.655387082005354058620293825847255635588e-19,
-4.379424313611119196211292624092006137498e-20,
-1.735266225570594328941345307531634888902e-21,
-3.000967190911536027261600293678943920792e-10,
1.492254083063417530539006680086183298631e-14,
1.717941689251522913058739484590928370725e-14,
1.318447227715152777250871400349190824359e-14,
7.588190744532996600241254796483415635247e-15,
3.493200177313212745142061929520075259357e-15,
1.339574507141260651495830782771679521434e-15,
4.39989037026704967862046894254579257516e-16,
1.262640544849189331965383644679768837287e-16,
3.211196186997966995279354860313241220504e-17,
7.305778319564447861808577314674657478264e-18,
1.492369084289221991508524085760692005713e-18,
2.722564185412202705890411386178358901778e-19,
4.323625521670718661634642797331757162181e-20,
5.363479840038517094318963747141106654199e-21,
2.846823396919888967958404422742012966476e-22,
// [{0,0.0001},{2.,0.001}]: m=2 maxabserror=2.1480329983499780398e-20 maxrelerror=3.07705514847552182856e-19
0.100240612092131064730474575083070280877,
-0.00006484970440589504757951125925172573632111,
-0.00007454493632458781795467763520768474166882,
-0.00005704019902729197536438405973394927017899,
-0.00003263755314928072785623653805944000447388,
-0.00001485309721076226405728764422646627925368,
-5.568687804863103021235627131546811874894e-6,
-1.748924939171278847053009387181308371743e-6,
-4.582053643556755714865867666659071139543e-7,
-9.566075855602449193545500257028990823096e-8,
-1.294528149574074509195149272786708690879e-8,
6.703600853749451278723315484333938901721e-10,
1.234389419102676008027363906518937830382e-9,
5.347303625928638773706739458894878504886e-10,
1.697744302082822385077556112020197535063e-10,
3.896016195290446597645323904538235989455e-11,
-0.1334433447564181866529516184550798001862,
0.00004881305135876859099700830587391616604619,
0.00005616865385077238468202989617003226878004,
0.00004306587931234208434998943191982166029947,
0.0000247388093655561986885217617676928200761,
0.00001134495192587521318116745807057055195621,
4.317311284967142008784106723019690902844e-6,
1.396268209244737023968572760855817841152e-6,
3.882421961255485598485335348237874691396e-7,
9.243008318314127890547579655129998614486e-8,
1.815766990069236554033566550825352198597e-8,
2.524472079668144078278724260326082966424e-9,
1.477859450216037161211175910735621080007e-11,
-1.558370615605639918261134631797962617797e-10,
-8.056572950276077611441249302467095626041e-11,
-2.586263954880993333729866464561720201237e-11,
0.0992356632056734496982437820387932406771,
-0.00002490802708337707902369292102459875825539,
-0.00002866772281083284411250358731950351336147,
-0.00002198993565309678412938038370928058689235,
-0.00001264305797670992601276737211188684887504,
-5.808202254683362767586914939723548758818e-6,
-2.218140061693276394208218914262551347104e-6,
-7.225187887122594415370021933626759552247e-7,
-2.038719878232382467360478374192652750822e-7,
-5.007753788540883846294304053855047125784e-8,
-1.057807251155691891331122576990441922754e-8,
-1.819325429330046241869780907336244140792e-9,
-2.00752534276702690001602921725720101367e-10,
1.612286082594296478418106427605200091557e-11,
2.163889154913865483048133249901051131789e-11,
8.388055470590305196675498849649936577587e-12,
-0.0524821611632602030606105574432127158958,
9.957294699689231394754325068524155833023e-6,
0.000011461338808573234052120338058226501445,
8.793188055911406964588734111265223460917e-6,
5.05749079129382520901411129728870652834e-6,
2.325124985300566181402051224971450767288e-6,
8.892812583190572362371560339438084150395e-7,
2.905372754321239031185736563739537337729e-7,
8.248344989799875152348927113916259544621e-8,
2.05209896518763040622036220027428416718e-8,
4.458150400659635004602234639464120370676e-9,
8.220899365417845015489625585692466442649e-10,
1.15761928241898075358051583640453425368e-10,
5.749081780156866544457930479154359216982e-12,
-4.544327734067165835866176123020530196781e-12,
-2.206288757255554694431426423247861792468e-12,
0.02170992316584569362270206329727620178097,
-3.299323032575652635541298975279322457289e-6,
-3.797874623160906699968649885526293790999e-6,
-2.9140381202614186830136611300867149876e-6,
-1.676375088307958434023984640250997869133e-6,
-7.710047993818647081308215608618756653424e-7,
-2.951211500737853848326257187424245788698e-7,
-9.657587725377414962929438722427884188206e-8,
-2.750843323339989836092693893658163761244e-8,
-6.890555027701169294519863204369752028346e-9,
-1.518948472320495255503913329421222341833e-9,
-2.897470443809341704944751959491990976118e-10,
-4.491028552784306220460723675318596174894e-11,
-4.185331986152041506826535360587188442599e-12,
7.161148656642796358536921328768732853928e-13,
5.025136015887152956166731082257808421341e-13,
-0.0073985273383242275820799284450684711158,
9.359834079836963787707851777744489308909e-7,
1.077451010664145109950805781830082513019e-6,
8.267597736250411560708965447167342144757e-7,
4.756743453563487923858312173348385103586e-7,
2.188288465765588077710559239442971270461e-7,
8.380429566806046590689787157140693658097e-8,
2.745199508957507677861178394749679540417e-8,
7.835380853580249558199771483503428153775e-9,
1.970931356437467355089452970477719194225e-9,
4.383349752735182977048434459538444743772e-10,
8.529135954913392623985967807609552846665e-11,
1.39129990872967787331581450943078701157e-11,
1.597676619530993640840750451350428800478e-12,
-5.932729111529556665822264490692053998169e-14,
-1.003003250851733641456474166860828063626e-13,
0.002147036331168343091377071743554927626366,
-2.323786255356110544493701030946738073805e-7,
-2.675067937507765712264716664939908412268e-7,
-2.0527456128554391845628702973970738888e-7,
-1.181143219056018581851816025154401896454e-7,
-5.434649545258178505809570061987153752129e-8,
-2.082005351397242038442235753050574126977e-8,
-6.824769762479774705281106909426725861044e-9,
-1.95063989275643880498756347577194797164e-9,
-4.920614576827949698036661500902779066719e-10,
-1.100843104456846581208806924775686863563e-10,
-2.170021492263378960296436561587191249119e-11,
-3.653496098361315416239274290081085899113e-12,
-4.666265815832592822548812557470245648407e-13,
-9.958054077453943909873605849390835209037e-15,
1.758938974631094473649094959206197231636e-14,
-0.0005429689436052176417491307857688946358398,
5.131212616825670207201249701285772823912e-8,
5.906977757346942147124948561337723441965e-8,
4.532930170581423798145775482472475640403e-8,
2.608394160691142791227575296376679052341e-8,
1.200316477578755744514739093013563566681e-8,
4.599529285174157614316061328678601867448e-9,
1.508464286024780143588032557117470088144e-9,
4.315773785629594910050748328097325224799e-10,
1.09090090043792358952203636110468399975e-10,
2.450905353726208120382044435162589956553e-11,
4.875621092606745365923929526083563051362e-12,
8.386556113596961721821961368236460675622e-13,
1.142651641794944364657133960607152240379e-13,
6.177047490272992873070796387400153338558e-15,
-2.699686456147847047055344883112874843563e-15,
0.0001217284955158054244261932122081957935481,
-1.020398344460235232837327924153224971538e-8,
-1.174681474540668381266030852651653884529e-8,
-9.01454710947386528369187520015952560659e-9,
-5.187502370239640946110215105282671392567e-9,
-2.38737858954200169999084243808130378292e-9,
-9.149975195079391074854960986136401059668e-10,
-3.001954557020942268768381750638036195948e-10,
-8.595184582357376184291539621583527571094e-11,
-2.175939046175996285843377482936195116729e-11,
-4.904117216674825054373999099309778921264e-12,
-9.821960730828607088196310560802111747931e-13,
-1.715804913067574298389079781801912522129e-13,
-2.441532993592781138675984056039658817705e-14,
-1.829711759056027392821748351207448057994e-15,
3.5723853280805142127685163280173829671e-16,
-0.00002451575331280928692524979271533129788371,
1.845855410804964121290685829362197082753e-9,
2.124966049055554058988250008776529049975e-9,
1.630736057017077464780388484986259295394e-9,
9.384558462013316102736004745403435899203e-10,
4.319250572260898563408556613661695108941e-10,
1.655656529964442315803482771522326561325e-10,
5.433520036571913902365061026812864453709e-11,
1.556638058274577978216475888497882342715e-11,
3.945450305191395411114925823697041685478e-12,
8.914049065927972470476297315213192243283e-13,
1.794602535361798366455897006938353518049e-13,
3.171799279282804931790838311818991549246e-14,
4.65633776100090142154240449965048847076e-15,
4.163332129236209583154618455866926423549e-16,
-3.90665881259858164392195953489735539829e-17,
4.482557871182997031698310939053566167346e-6,
-3.062532041287206790352779259819013010704e-10,
-3.525641246488646553984413211646387210478e-10,
-2.705678048678580401647844083810553785424e-10,
-1.557108711520870636773886299930508147858e-10,
-7.167022961613316205650970365869460968973e-11,
-2.747586145519040919691233547992611804527e-11,
-9.019115895564525511396982376812834825301e-12,
-2.585084515831142855244411596238490195898e-12,
-6.558392489917957495939857706752793322757e-13,
-1.484650879177535679091407801256393097552e-13,
-3.001266020186543411977155171646498153591e-14,
-5.353013033782812510135259842206998319134e-15,
-8.045047656216347383251194503258151862051e-16,
-8.046965189443083587740110795105089028025e-17,
3.063488980311375714145302501583023773659e-18,
-7.505639082882780424762321583938809937981e-7,
4.692611025918833298297848198552372564266e-11,
5.402249307187606342639164836971564163353e-11,
4.145890236569371419353319157296085232863e-11,
2.386002933864641108083844100782956853346e-11,
1.098276167826888971990165475836630322953e-11,
4.210809346499567310960136484924850424337e-12,
1.382488170682682852558238918654500547282e-12,
3.96405301592519302652540834118143199495e-13,
1.006468633678927855695396541138305294527e-13,
2.282017527056720683045505988259474793056e-14,
4.628587822727848350654634857070179303074e-15,
8.316005102126159106633597564857448104791e-16,
1.272882754905506423096304133907189542046e-16,
1.37641675860684057945183959597737367459e-17,
-3.856664655012819232854152700212682845207e-20,
1.159070162544373114104156171657351622508e-7,
-6.678984486401799567787783645587804957114e-12,
-7.689049519099136813843373221948264480079e-12,
-5.900925753941214322789761433030651917003e-12,
-3.39611161931748514320392324195605981483e-12,
-1.563290949799384692954722538337662801356e-12,
-5.994161104547402426480590623817687764089e-13,
-1.968310319185542294797288303829071717949e-13,
-5.645610060044184460962266362653429190108e-14,
-1.434342884194787845070639598515260263626e-14,
-3.256462771778166955488642508655990250747e-15,
-6.62329338092529685412757001143220847942e-16,
-1.197123092930553891881779751868165162208e-16,
-1.859404503384622209079797566564388563193e-17,
-2.129561321344528362247975654017043194302e-18,
-4.57962757413872234785892132321940701681e-20,
-1.661325238335893320681024164513014325166e-8,
8.876661638894812848539528238167469428759e-13,
1.02191250794096626341912281609697161575e-12,
7.842686579304726992129911426658799941632e-13,
4.513713301175588428710997679992913768352e-13,
2.077812936482415765101163315772374605368e-13,
7.967540985394898914907737928754357666034e-14,
2.616664907140784799114218829148615838025e-14,
7.507290461282989120716634403618030331376e-15,
1.908372139626090805002340020893374885875e-15,
4.337513417319034257237531344662854769248e-16,
8.842522736798094402229368415914763931168e-17,
1.606234192540890074735417356575231623231e-17,
2.524959944787624657622492114785656997832e-18,
3.022447085058061898154145190306994959784e-19,
1.187194724384764023745764733636170296462e-20,
2.254635183587847478479503247283694807223e-9,
-1.12090248410796897901364793991865438881e-13,
-1.290427110263642068431408038286514421912e-13,
-9.903479769137730701477552582024491974419e-14,
-5.699848626567486046457653500949955462725e-14,
-2.623907901498199045550432024606981564393e-14,
-1.006217925453302385911388341077313055756e-14,
-3.304967213931127226773094358113766792752e-15,
-9.48429994538184572680023807472428228126e-16,
-2.412086575691268424497841021752228121378e-16,
-5.487740483273796614312196519630414100772e-17,
-1.120999544377761144566426325646449485585e-17,
-2.045087210768156470037340934775172032562e-18,
-3.247823258491293985618416894925864008449e-19,
-4.029278774569080213666150526873636961272e-20,
-2.139939253068905386888193519862217205118e-21,
-2.82058534504008528658026981218221988505e-10,
1.31343478968332114349402987858102139224e-14,
1.512082580812338805440220660726668089021e-14,
1.160466336850848804785090956496514867818e-14,
6.679030757228693510405539796933972584618e-15,
3.0747477980093197011610492320167599573e-15,
1.17916494678149444303302436299038006147e-15,
3.873405276555421634809524571327238874489e-16,
1.111777639477766841655998189307819905685e-16,
2.828659319440038112684969373118896738507e-17,
6.440762700587943730136514963878172321283e-18,
1.317907873863291112185931605109711106137e-18,
2.412991196449296268534549046628767727143e-19,
3.864481412288187309879499037567644850512e-20,
4.93190843835128345300706718414362883447e-21,
3.142287878589397489704531148474655699832e-22,
// [{0,0.0001},{2.,0.001}]: m=3 maxabserror=1.81254073048321187091e-20 maxrelerror=4.66771851151116177652e-19
0.06672167237820909331270182330923320768024,
-0.00002440652567938429549793505680726202476652,
-0.00002808432692538619234035977680817243490829,
-0.00002153293965617104217449189157491337785517,
-0.00001236940468277809934397147582434763254039,
-5.672475962937606590450493532707317438039e-6,
-2.158655642483571004340953393177035896439e-6,
-6.981341046223685119674979407048038895501e-7,
-1.941210980627742799194464186106663725591e-7,
-4.621504159157063945151065835737018925746e-8,
-9.078834950346182769888017507633055531831e-9,
-1.262236039834072039081947156408185738575e-9,
-7.389297251080185795481803916160348057734e-12,
7.791853078028199591477320715270770123708e-11,
4.02828647513803880574350049959423931629e-11,
1.293131977440496666866749315420836621483e-11,
-0.09923566320567344177917916821364678238955,
0.00002490802708337707867693227205036315656354,
0.00002866772281083284371329673994440941542061,
0.00002198993565309678382300252365448129035579,
0.0000126430579767099258364305556627082480424,
5.808202254683362686407017831268377204122e-6,
2.218140061693276363074395192083183053396e-6,
7.225187887122594313090494439368534892102e-7,
2.03871987823238243799820245905335551685e-7,
5.007753788540883771562485736020235157814e-8,
1.057807251155691874302748522053293987766e-8,
1.819325429330046206974848197877606410743e-9,
2.007525342767026835926059311512520318244e-10,
-1.612286082594296581804133853677464802765e-11,
-2.163889154913865496556004240491916224391e-11,
-8.38805547059030520644096524431881898684e-12,
0.07872324174489031076267819204791819279531,
-0.00001493594204953384734712430056017773587906,
-0.00001719200821285985137174069531119319228124,
-0.0000131897820838671106721817772487272149867,
-7.586236186940737943193829723793022754252e-6,
-3.487687477950849331801419735629468704373e-6,
-1.333921887478585877251909633100671267734e-6,
-4.358059131481858622001953031371589224604e-7,
-1.237251748469981294450700569120296337245e-7,
-3.078148447781445664319040087431350984705e-8,
-6.687225600989452632279180839214088434626e-9,
-1.233134904812676778049176584307633736854e-9,
-1.736428923628471177749708355458978382181e-10,
-8.623622670235300585783998512536759683226e-12,
6.816491601100748651299501314769752136042e-12,
3.309433135883332033509644261149142046895e-12,
-0.04341984633169271805455270580312482290682,
6.598646065151363542762418083367620523742e-6,
7.59574924632188048498195462648168882344e-6,
5.828076240522888851548196874072534345296e-6,
3.35275017661594650071427063897157386855e-6,
1.542009598763743058204792716889710431903e-6,
5.902423001475760015745883756865926627196e-7,
1.931517545075500180234949605976011345385e-7,
5.501686646680029014272372780303696395658e-8,
1.378111005540246417278131340035328715679e-8,
3.037896944641019126498133436101180924699e-9,
5.794940887618742049444573081341986363804e-10,
8.982057105568720141734922774438006332534e-11,
8.370663972304256750596948375963811530443e-12,
-1.432229731328536571921238152445922359863e-12,
-1.00502720317742895007495986661685007317e-12,
0.01849631834581012453136061495326129064584,
-2.339958519959222585330054372357393388901e-6,
-2.69362752666034163610927994547583499457e-6,
-2.066899434062586666804386114695067798377e-6,
-1.189185863390862643457594538189135349034e-6,
-5.470721164413927206519083097887887933092e-7,
-2.09510739170149516052726130984682890287e-7,
-6.86299877239371502760321684714832116087e-8,
-1.958845213395046836937824933903135328139e-8,
-4.927328391093628791441622582227750837737e-9,
-1.095837438183786716160643645804673277392e-9,
-2.132283988728329631326631057396924600442e-10,
-3.478249771824160566493164789312058616075e-11,
-3.994191548827428720609915641157791424607e-12,
1.48318227788246297522609915432521523651e-13,
2.507508127129339963446121394560222290125e-13,
-0.006441108993441134829299483996776674063889,
6.971358766040355123678697233924439935912e-7,
8.025203812491089288710326060744311788029e-7,
6.158236838541599110902217932660850375579e-7,
3.543429657153828961849439149404354985843e-7,
1.630394863570903990050366712247311435363e-7,
6.246016054166607469735962767323783530568e-8,
2.047430928735680539252229362231633249619e-8,
5.851919678245627042038622561777936158602e-9,
1.476184373042355572893572640191971171569e-9,
3.302529313356801303969220156924319210454e-10,
6.510064476761983722853229167498175304811e-11,
1.096048829503223846458053315051852843119e-11,
1.399879744741436613773460122666971707314e-12,
2.987416223127198991843939843130169379283e-14,
-5.276816923901163132307586064239932416234e-14,
0.001900391302630114263687263095177695893434,
-1.795924415893881449517851988816692666584e-7,
-2.067442215077067275616863383109043272585e-7,
-1.58652555970782496073496477843292894569e-7,
-9.129379562443902082263847764306134672321e-8,
-4.201107671537109564050436290862534304895e-8,
-1.609835249815352142209554720925871241443e-8,
-5.279625001101176380407449886358608954148e-9,
-1.510520824974505964082542382946959288131e-9,
-3.818153151543292545776195123877230964426e-10,
-8.578168738065805581488967065892913449781e-11,
-1.706467382417301247146549330309578587039e-11,
-2.935294639768035260708054620723817064644e-12,
-3.999280746297075061217811387681178033071e-13,
-2.161966621615231752242305861955584766979e-14,
9.448902596501836793512209129542421102867e-15,
-0.0004869139834022300266117918878268978650335,
4.08159338370373234466802447105437311533e-8,
4.698725904912189339354179022409506020181e-8,
3.605818848969573053710591909784146725686e-8,
2.075000951077238488361861385796085532861e-8,
9.549514371893348091229593848875499046954e-9,
3.659990083295650475973153959083190693635e-9,
1.200781824537649395855061294829072570833e-9,
3.438073837907324781537892440869423017056e-10,
8.703756197339138693278262880242085808734e-11,
1.961646889548975353892341748696991461478e-11,
3.928784298231257939028342544781800441098e-12,
6.863219663106262665909160125858133388505e-13,
9.76613199185118229941505254962096764285e-14,
7.318847059063212503017471787295960335371e-15,
-1.428954129580849704222397024648281322745e-15,
0.0001103208897586262120419619020152553518882,
-8.306349342465800490247771687025924702155e-9,
-9.562347213662285766957708982566930277279e-9,
-7.338312251137244777488567524052544165355e-9,
-4.223051304775179733229238828690285909159e-9,
-1.943662756076049509316597857383721865735e-9,
-7.45045437931194515380813135980305325799e-10,
-2.445084014641171090784104724422052493608e-10,
-7.004871257020898874902941018696967780134e-11,
-1.775452636008487095071770600514294981274e-11,
-4.011322076640515943951421568489495109919e-12,
-8.075711402916872714641154763103113477336e-13,
-1.427309674533343918925061541584988643738e-13,
-2.095351990593489987325828478836551841495e-14,
-1.873499455681507034805391609474518926947e-15,
1.757996467634185829446600711890065491184e-16,
-0.00002241277507078060502845121097322972910152,
1.531265395186150031474053021930104621747e-9,
1.762819903188862000020151952276674481543e-9,
1.352838471720880891206634995524367474277e-9,
7.785540376990308938732867832214961238304e-10,
3.583510016552433082660716393101311109215e-10,
1.373792511193945033770530385640963374837e-10,
4.509556102950447198940421029838446724498e-11,
1.292541728303487357871375363602551960122e-11,
3.2791948970085273894878148080715640608e-12,
7.423251324448041245223637795440720895003e-13,
1.500632380685586309503053273475808619193e-13,
2.676505360881414190291364244691344088084e-14,
4.022521963285206124546765554000715202171e-15,
4.023480158166315083984346415699187104367e-16,
-1.531746251929979401381519337861018919932e-17,
4.128102449351917402782002282367517388511e-6,
-2.580936458298549736940804490800561726788e-10,
-2.971237572594963670787043592916033065428e-10,
-2.280239978269671667582206308323384440601e-10,
-1.312301814010143011740182271422961702507e-10,
-6.040519845572951033489950400493079047649e-11,
-2.315945494391890565510905872201022270311e-11,
-7.603686101189510335611955689095168880777e-12,
-2.180229492520765364219258464821367254664e-12,
-5.535578334977681512643135271451592848484e-13,
-1.25510983362598072110400564759561457586e-13,
-2.545723700043475057390499608363591304374e-14,
-4.573803538323505503015989565134744278674e-15,
-7.00085634048241426781852146664655129824e-16,
-7.570293756306170382931731720656250462234e-17,
2.121152984436469262073538209084377974523e-19,
-6.955231446181034294421275580924622198044e-7,
4.007745541459002929011054369340164577644e-11,
4.613838230702620281949693861773528091188e-11,
3.540868977178737244852931382904385004779e-11,
2.037847421863614482652851513640423457928e-11,
9.380576434850280493261648428164851934008e-12,
3.596815263669770447563030658345001751526e-12,
1.181090856966172129423279685570299084633e-12,
3.387666508358129688503020146886423677366e-13,
8.606822057063857797429822208620544403249e-14,
1.954051919445057239377419496729362688131e-14,
3.974333119530505364577221185208678756705e-15,
7.183394413898269994619133036261875004515e-16,
1.115748501960277921337198417653019889796e-16,
1.277875030385741066647067571988401450636e-17,
2.748776108409882145462663799307547814851e-19,
1.079831345047721090050667927843734470174e-7,
-5.769705875370593585935064050085234837945e-12,
-6.642288328121088092654738338800076445344e-12,
-5.0976365486606494508698077571500615165e-12,
-2.933850490899300749250107398807967321142e-12,
-1.350549333650683507078966188468601677377e-12,
-5.178790128573562681917359957927652123728e-13,
-1.700795553385926912167074674292806469746e-13,
-4.879633608667476248995198238791859075e-14,
-1.240415109534110776324633905286170576104e-14,
-2.819322659042012634440234681628640682493e-15,
-5.747514485900654050781397188881442832622e-16,
-1.044029149966006576193941067578818843148e-16,
-1.641186506257442916408948483167413177118e-17,
-1.964540683486970032346177050913470185009e-18,
-7.716369354369536227112761929064384758278e-20,
-1.554966754936509553953157441307578069941e-8,
7.74440086250477336711649396387020136782e-13,
8.915658767147359733017537218223900685458e-13,
6.842388228450818998602801826697157406836e-13,
3.938066830304554783929619785693966493764e-13,
1.81287592145735150684666557682924712713e-13,
6.952019950048894287714640599189953256223e-14,
2.283416034136665727944434404424941956884e-14,
6.552711156204830228961355550760886520038e-15,
1.666496124947376913742052917294752511584e-15,
3.7913700689435637288221036864980671498e-16,
7.744436489798022833310677452791447806614e-17,
1.412724147030922379945292872287149108906e-17,
2.243089361338959857937710439097321702134e-18,
2.780791604081042126925147023924751342058e-19,
1.469248176176676009214789522441041668455e-20,
2.119138872788884059929086945823714394489e-9,
-9.866046531308351866911255057888203953016e-14,
-1.13582168958750491566612365859456190183e-13,
-8.717003112590105243308546351921894995417e-14,
-5.017046328595216509978397216991759744887e-14,
-2.3096394808713783285357153600963664783e-14,
-8.857462272002355904275413718449272660758e-15,
-2.909563240564488497054255460941427504662e-15,
-8.35127949148637057005526826586382320708e-16,
-2.124790790450748301204314117644396531304e-16,
-4.838087718228028092264265250160096015854e-17,
-9.899730438877925974519099231640801092478e-18,
-1.812583550748678152566872436739338378798e-18,
-2.902971470850073955864630078055523057417e-19,
-3.705075844963893194551347136456236905511e-20,
-2.361594379933820564465996312717460632097e-21,
-2.660606897522338887224967842692594464103e-10,
1.164869211500798953989356157349807703208e-14,
1.341051152475143134464199181513280600576e-14,
1.029211771501604681998272843003470697174e-14,
5.923663380014352234070949589562353906297e-15,
2.727067514012234846511213273167148806892e-15,
1.04587526395585048938930839151378812377e-15,
3.435865975854581088020052364124772115652e-16,
9.863643386863320439723929715199663397051e-17,
2.510461054684904276514620385613939770762e-17,
5.720338305026972124537983154995316997017e-18,
1.172228079721675276086988072843860019055e-18,
2.152991940551116607232432824703851479083e-19,
3.473122660323892134881574661705851665221e-20,
4.537997034420065153769304779554480773761e-21,
3.281446853255653310061902543687868920826e-22,
// [{0,0.0001},{2.,0.001}]: m=4 maxabserror=1.57658997930972020733e-20 maxrelerror=5.9726663825098980328e-19
0.04961783160283672087651768174819631967509,
-0.00001245401354168853933795491996122961895897,
-0.00001433386140541642185605983180056158764247,
-0.00001099496782654839191104957443347671845823,
-6.321528988354962917955302905117684119511e-6,
-2.904101127341681343083820333573470668288e-6,
-1.1090700308466381814912917257723635703e-6,
-3.612593943561297156394417249087918007546e-7,
-1.019359939116191218955788516059644380038e-7,
-2.503876894270441885670940101777544303365e-8,
-5.289036255778459371262107293567724948351e-9,
-9.096627146650231034357318574974199400341e-10,
-1.003762671383513417867598076753809316796e-10,
8.0614304129714829105783212649833104156e-12,
1.081944577456932748299116121608197163648e-11,
4.194027735295152603238501679357012612972e-12,
-0.07872324174489030326883043690637339180575,
0.00001493594204953384703750632727870325654743,
0.00001719200821285985101529335296954299202208,
0.00001318978208386711039861908887953895039365,
7.586236186940737785742384271122094488903e-6,
3.487687477950849259314357595731479634052e-6,
1.333921887478585849450861630284927180114e-6,
4.358059131481858530664083428377250335937e-7,
1.237251748469981268225487953885126756389e-7,
3.078148447781445597550781755174509096334e-8,
6.687225600989452480045063567871480248465e-9,
1.233134904812676746812423811347036835753e-9,
1.736428923628471120221173506360429151205e-10,
8.623622670235299651930045739901550613259e-12,
-6.816491601100748775756667146004039922411e-12,
-3.309433135883332043390271142923015513466e-12,
0.06512976949753908293901092878479209521869,
-9.897969097727045543202683602157489766267e-6,
-0.00001139362386948282099117747464935751490204,
-8.742114360784333479708518479220825607688e-6,
-5.029125264923919867557595920155903935727e-6,
-2.313014398145614640935695363921123966624e-6,
-8.853634502213640229307892325341452066298e-7,
-2.89727631761325033793436161530261392059e-7,
-8.252529970020043715478555479516387166064e-8,
-2.067166508310369675340235241399195333673e-8,
-4.556845416961528802496717403296003643912e-9,
-8.692411331428113305782876184045187122164e-10,
-1.347308565835308064020031912728766505428e-10,
-1.255599595845638582382969673695283936349e-11,
2.148344596992804763276338641157892590103e-12,
1.507540804766143417038500447010591819247e-12,
-0.03699263669162150841572676672486948424849,
4.679917039918497200831856375858143560781e-6,
5.38725505332074317189513587278425011988e-6,
4.133798868125219304821477623840891637693e-6,
2.378371726781751746056839818423659377726e-6,
1.094144232882797622490572851340778124448e-6,
4.190214783403037039703862800480943874542e-7,
1.372599754478758354517751247085593206691e-7,
3.917690426790137744395707792267417164558e-8,
9.85465678218736978453956356334960995609e-9,
2.191674876367599014724561807564913114224e-9,
4.264567977456711754939609700079977050743e-10,
6.956499543648417807828624685199529535285e-11,
7.988383097655014372809467879043057533764e-12,
-2.966364555764716801720103754468908289382e-13,
-5.015016254258663321952381280828303462233e-13,
0.01610277248360241530184003512476140391716,
-1.742839691510072286748552516664532499476e-6,
-2.006300953122753333241183307229195408331e-6,
-1.539559209635385204221877378609189190374e-6,
-8.858574142884488524807372083517533108532e-7,
-4.075987158927221358108151984787591419911e-7,
-1.561504013541637056097733807140671367774e-7,
-5.118577321839152683472481486632582086663e-8,
-1.462979919561392785843254344501829770077e-8,
-3.690460932605853343501896126636435450588e-9,
-8.256323283391922070806729886180955301184e-10,
-1.627516119190479252412205822916937772446e-10,
-2.740122073758028825483041261569837338225e-11,
-3.499699361853541277218259570783936733675e-12,
-7.468540557817316237015518786516926006732e-14,
1.319204230975296597098428636739727359486e-13,
-0.005701173907829878998168528578345573040824,
5.387773247656664353557314082560408511289e-7,
6.202326645202443635743037141892814221249e-7,
4.759576679101403829432084215848010138594e-7,
2.738813868720467433281527434460014976062e-7,
1.260332301455284608906451741329701691754e-7,
4.829505749423626524520007876096159058215e-8,
1.58388750032298376888158437856353755642e-8,
4.531562474902359370978939634689208900562e-9,
1.145445945457600894227909363326412591958e-9,
2.573450621407459404749981524571288896568e-10,
5.119402147226701858663925212268937023253e-11,
8.80588391925769152433141586051734558839e-12,
1.199784223881588107235482510940480092572e-12,
6.48589986474528055330672128241667037096e-14,
-2.834670778958523516642930332128964799359e-14,
0.0017041989419190534896561643760382206737,
-1.428557684300705175745632727176798623959e-7,
-1.644554066724330456562164573962132364779e-7,
-1.262036597143237198247294122631139562322e-7,
-7.262503328792704742687964827106724654663e-8,
-3.342330030172970662080847591515259847725e-8,
-1.28099652915742772400216767681081579171e-8,
-4.202736385894751336060589277992561538801e-9,
-1.203325843271290598336136769641303655965e-9,
-3.04631466907818975552683111854966229283e-10,
-6.86576411344306618900690917191493822405e-11,
-1.375074504385388241256556262517861947582e-11,
-2.40212688209540354674441054373673182809e-12,
-3.418146197161316997985565680586237917423e-13,
-2.561596470690292613290468940288171584785e-14,
5.001339453517468231901946631685138624115e-15,
-0.0004412835603016198699816972542186172728985,
3.322539742221169092636566021664490314296e-8,
3.82493889149152820795200544940515597471e-8,
2.935324905080144093915711197742458276221e-8,
1.689220524572173619877360783625908906179e-8,
7.774651036559908802173360367062220646885e-9,
2.980181756425225398480611182278525937677e-9,
9.780336074007587218509887649466727483319e-10,
2.801948507242374529632542770038181189916e-10,
7.101810555322762958197080788337472533532e-11,
1.604528833230100020936541373056257475186e-11,
3.230284566448101233243807225610044090299e-12,
5.709238707860039567257782688049772153064e-13,
8.38140797816325113269162538106863116369e-14,
7.49399784376929643920094199864765116619e-15,
-7.031985853828888932029975073331831180788e-16,
0.0001008574876770923866589267741215060565292,
-6.890694272807264614742607346479441167269e-9,
-7.932689557982986536081705768646657416889e-9,
-6.087773117857543365071305305675851297048e-9,
-3.503493166833192023959563571116967135946e-9,
-1.61257950615378618205649529679235359218e-9,
-6.182066295406587883600709926855777240985e-10,
-2.029300244696000284004988290987458037527e-10,
-5.81643777268005915905934293943160058864e-11,
-1.475637702460565303244608386355858307026e-11,
-3.340463093279388488337786088175928282902e-12,
-6.75284570749298640812184381599882929039e-13,
-1.204427411364239979057075748615414667269e-13,
-1.810134881793239342938336840754168076183e-14,
-1.810566068890652935462102000206311968919e-15,
6.892858153179552259023054038628062516642e-17,
-0.00002064049872860255069283677714401055662074,
1.290467670681363981523735773964985182448e-9,
1.485618143361927501101993512932456178855e-9,
1.140119495700998702970040375449293058738e-9,
6.56150623004821351998456328578032480196e-10,
3.020258615313922833129175454413989794842e-10,
1.15797224573943606247201573367608928323e-10,
3.801841403103834873461759280388812546208e-11,
1.090114273227574444596132993576986154258e-11,
2.76778796316722564597733693901078059997e-12,
6.275546422229328198338796479288950807795e-13,
1.272861286592370522641826252011975226194e-13,
2.286900731493422607715808430453267075311e-14,
3.500426485791801655688319129351930518608e-15,
3.785144633182447260775972180169725848641e-16,
-1.060594317142141950632829723433358633643e-18,
3.825378200553315041935571171324464201234e-6,
-2.204260401771194410516230005027903240643e-10,
-2.537611434393426501766815118565089733838e-10,
-1.947478250199079664819016834080704385589e-10,
-1.120816262033022631052154243483919570761e-10,
-5.159317867897834201826810201787808190751e-11,
-1.978248712873097834227529812609804141379e-11,
-6.496000757668866499393821960032336111378e-12,
-1.863216879496589895992702764543384920952e-12,
-4.73375289512774149130889490341958890535e-13,
-1.074728729928586817378640909452258025201e-13,
-2.185883573662311909074588938865449384253e-14,
-3.950867588420025243810893838964572408151e-15,
-6.136617839317350910865230727605890758498e-16,
-7.028314129099459424402609759920713820863e-17,
-1.511828107374651267439836096904308405029e-18,
-6.479755027128228555379253150130651447076e-7,
3.46214036917582136525842806799502699886e-11,
3.985737763117932281973091612478160057536e-11,
3.058861876396440431399804979364514699075e-11,
1.760471420650164998734403426525121207943e-11,
8.104037789870351341610416670566934417938e-12,
3.107558575970851223490565223307650580551e-12,
1.020570801601290194781733304916949074642e-12,
2.928048537996801538566349809903059363514e-13,
7.443173923091100653695389232373433917761e-14,
1.691749382751498717481901085306292159531e-14,
3.448828350525176020846842696441281195043e-15,
6.26476361635604146572910026069272581134e-16,
9.848074703774002133885019809141081544478e-17,
1.178851778212877752887070164917068951396e-17,
4.630832926165532334741145653660679232923e-19,
1.010699862955196097047631454644363760821e-7,
-5.033749000850136362293741542445944098973e-12,
-5.795049765303183340784985977055399843534e-12,
-4.447453779318051738796546216681194797338e-12,
-2.559686706845652965150874226111329480721e-12,
-1.178343229987054641547629371784071082215e-12,
-4.518712789752302378926189599022876611916e-13,
-1.484187507416902034347325198654374061523e-13,
-4.259167732634595872731056762067756057996e-14,
-1.083198410457270087795827698695255746402e-14,
-2.464335631810416176742004509907140489471e-15,
-5.033770913087669450293569371183326879438e-16,
-9.182498699875863282323681694079327065682e-17,
-1.457974092793266806837182569275939523583e-17,
-1.807468465610747432999675978581334087614e-18,
-9.549719890572574677051503270537075220519e-20,
-1.461369108672384888094632641692923015839e-8,
6.815231557358813498555258552433664566026e-13,
7.845987011347011480415355892846488453017e-13,
6.021498311287574174432477041386056771406e-13,
3.465655266069979824923348099240071346079e-13,
1.595442682791941340224133976052288295001e-13,
6.118512445398736344187635446906636836853e-14,
2.009848795034029213562596801595110036134e-14,
5.768816066386679248261177288696145996251e-15,
1.46772941492271566433807412326672987375e-15,
3.341917585373383916077139911171150648067e-16,
6.838001742295286167731324440151494337991e-17,
1.251899892031401533983907034440125960105e-17,
2.004632202691134038106244404512184982917e-18,
2.556971380302125113981280845011381115223e-19,
1.624069418751882638378479952774464471223e-20,
1.998966460212688454654673756188148360027e-9,
-8.750250152680918299780863271154338033595e-14,
-1.00736915520308048737407837346156039509e-13,
-7.731220435630366418486708580315693886675e-14,
-4.449730361425634081117719531618072142049e-14,
-2.048515424792713604376823952851924900668e-14,
-7.856394620302992583418314821019612334399e-15,
-2.580950717315850544742737070904372190633e-15,
-7.409366171242254256450066061216120872638e-16,
-1.885808482445834210685469308977130358194e-16,
-4.297012563983209438525721831568552442929e-17,
-8.805594966530981124705318073660810355653e-18,
-1.617307222984218738474723676407297452184e-18,
-2.6090258314372909752678562352248279947e-19,
-3.409169069342323104364154881849570764196e-20,
-2.465925454954493837743323883457492664891e-21,
-2.517762382978249748123509559958000227631e-10,
1.040109962348080149099915531161549553998e-14,
1.197425426005213743558204418589036823309e-14,
9.189882566409489276826113798792168216387e-15,
5.289318983203974861789858500876295317617e-15,
2.435082174439095998090347379192160804375e-15,
9.339299937724979267544374585286020787187e-16,
3.06834435805050720937823913130541608712e-16,
8.809928208150504238336123768217656190438e-17,
2.242971020359518309059564593320975647066e-17,
5.114063802296799739366478770289307249701e-18,
1.049351836686743683681662102357250663441e-18,
1.932595079029748576244948969975027883861e-19,
3.137196935343237141632229363848020089651e-20,
4.181182986964547750402988588232897456556e-21,
3.319992914504690218434560996067925680721e-22,
// [{0,0.0001},{2.,0.001}]: m=5 maxabserror=1.44865788610823445583e-20 maxrelerror=7.29724263031879104089e-19
0.03936162087244515162197742864399819074474,
-7.467971024766923518291440077879183752949e-6,
-8.596004106429925507115115608674749136238e-6,
-6.594891041933555198901584049087120553081e-6,
-3.793118093470368892636383099456795538395e-6,
-1.74384373897542462954907456680804302276e-6,
-6.669609437392929246839667899688813076423e-7,
-2.179029565740929265195797695072753540175e-7,
-6.186258742349906340736150012605414626494e-8,
-1.539074223890722798675718064763404233374e-8,
-3.343612800494726239795032976487522401808e-9,
-6.165674524063383733594299238928607347052e-10,
-8.682144618142355600240345863603362048674e-11,
-4.31181133511764982454544703445609876493e-12,
3.408245800550374388073596486004467501548e-12,
1.65471656794166602171278880562037661045e-12,
-0.06512976949753907582713362455681675069147,
9.897969097727045265074207625456631959893e-6,
0.00001139362386948282067098169769118777942681,
8.742114360784333233966775533185247205182e-6,
5.029125264923919726117537004992726669999e-6,
2.313014398145614575818799705140066152877e-6,
8.853634502213639979555766452911001502648e-7,
2.897276317613250255874908206732561771325e-7,
8.25252997002004347983456119365466734698e-8,
2.067166508310369615329712890181073528794e-8,
4.556845416961528665593820925463798400819e-9,
8.692411331428113024549740510599906395461e-10,
1.347308565835308012100184588953519665131e-10,
1.255599595845638497638352476447295030621e-11,
-2.148344596992804878148137102829783629469e-12,
-1.507540804766143426841969774835844933047e-12,
0.05548895503743226819664670257398832238653,
-7.019875559877746008131174050203986809068e-6,
-8.080882579981114996017934608989209689016e-6,
-6.200698302187829140026068792110394593121e-6,
-3.567557590172627724295592256082952171399e-6,
-1.641216349324196482173868013115455066527e-6,
-6.285322175104555745342678745502911064059e-7,
-2.058899631718137592823165751589585451553e-7,
-5.876535640185206791917853097268325457606e-8,
-1.47819851732810551234110283769190881389e-8,
-3.287512314551398624021723980425463753875e-9,
-6.39685196618506784202444832273166222912e-10,
-1.043474931547262709955561007615748391289e-10,
-1.198257464648252219528167850058023035914e-11,
4.449546833647074327664931211197685605336e-13,
7.522524381387994903828543664165180247913e-13,
-0.03220554496720602576775984790519142274002,
3.485679383020191312107521830086315556475e-6,
4.012601906245560474369670821523966960931e-6,
3.079118419270811704566279136468748136748e-6,
1.7717148285769214735160405283985909806e-6,
8.15197431785455214310088013999872462853e-7,
3.123008027083316082251342573822748463972e-7,
1.023715464367844326526891273596887975169e-7,
2.925959839122825170919284928194065378964e-8,
7.380921865211807532814069285794122160153e-9,
1.651264656678407420272006428693578798294e-9,
3.255032238381005765213527636288294175925e-10,
5.480244147516144900819395766903426569443e-11,
6.999398723707224965765947965595659325709e-12,
1.493708111563656288270473682260921611196e-13,
-2.63840846195057671903830217870536962461e-13,
0.01425293476957429618343829564631233134578,
-1.346943311914151191035720344834672262122e-6,
-1.55058166130059375830494208421282119823e-6,
-1.189894169775337794654790781701230402261e-6,
-6.847034671801092822866799555241175889462e-7,
-3.150830753638176642803348109138729481696e-7,
-1.207376437355893252902998902419632502955e-7,
-3.959718750807415463532339035248191059309e-8,
-1.132890618725577217912460047440287357371e-8,
-2.863614863643970076468623106968482029447e-9,
-6.433626553518575110125448062854124195153e-10,
-1.279850536806660370604774318363301077168e-10,
-2.20147097981439495526743421120770452084e-11,
-2.999460559703924465768784908931609206017e-12,
-1.621474966186257136735462274530625796513e-13,
7.086676947396365751211845289697184693863e-14,
-0.005112596825699778431651148607607980529222,
4.285673052879675990890244623865022735789e-7,
4.933662200147157823650225152061266998021e-7,
3.786109791409885035151406809946140093149e-7,
2.178750998626399972137446573828234994887e-7,
1.00269900904663753669126858090411905468e-7,
3.842989587452133051807135860454364358484e-8,
1.260820915761804804736334766839496285817e-8,
3.609977529794859922241098007117557777174e-9,
9.138944007186152472111108278583657758626e-10,
2.059729234021874456161884352630310826476e-10,
4.125223513133474658411630464969034234482e-11,
7.206380646244321296625055622795796833979e-12,
1.02544385914155780490413757037168750844e-12,
7.684789411978196619772090753981602462637e-14,
-1.50040183606315059297098835859316463838e-14,
0.001544492461066372305497298981406981711998,
-1.162888909781382183366499207565636308594e-7,
-1.338728612026608804115898304270260291893e-7,
-1.027363716781560816914475214079170791006e-7,
-5.912271836022812324641335027005758708947e-8,
-2.721127862805270144927755364939999551292e-8,
-1.043063614752396751949803063720428910757e-8,
-3.423117625914378940704151800185292147263e-9,
-9.806819775381980238102867027757135770575e-10,
-2.485633694371543602230364865607477406633e-10,
-5.615850916324925715644884608656315800823e-11,
-1.130599598260860894171680393557545448089e-11,
-1.998233547758461437424747139312809079961e-12,
-2.933492792369353013797288171036008524971e-13,
-2.622899245336055819995020054722178150945e-14,
2.461195048824920280027995298187826535134e-15,
-0.0004034299519109026699095091001596252737759,
2.756277713825380860303261405192253569834e-8,
3.173075828606925226891074840231171073607e-8,
2.435109251297911629054930105005319648565e-8,
1.401397269124683702659291398771996966562e-8,
6.450318035624825960952897449528055115887e-9,
2.472826522385335535985316027110945979212e-9,
8.117200992658257926007361294628352093991e-10,
2.326575113056190840978936216939062045836e-10,
5.902550819988585155477475145494042421479e-11,
1.336185239626452859370176950007651838551e-11,
2.701138287752174270963461139231186582808e-12,
4.817709654235388899324004263142536627476e-13,
7.240539541501376063711540437889583478959e-14,
7.242264294985238259317230796608843075384e-15,
-2.757143244694718647927243524995317076392e-16,
0.00009288224414415109299019605794153962509377,
-5.807104513071124118622650293550087334999e-9,
-6.68528163937814652164792356668076737974e-9,
-5.130537726241100610626518752218333541327e-9,
-2.952677800981486995866273176021827315993e-9,
-1.359116375721773001941934268607148277144e-9,
-5.210875101341804533510680495828053057458e-10,
-1.710828629922811702696052913097003023183e-10,
-4.905514225291036799607769798065333103338e-11,
-1.245504582346971591071770690600153888074e-11,
-2.823995887542070248146396989442077706502e-12,
-5.727875784604695424970859942095550071332e-13,
-1.029105328235699354377762766467011867323e-13,
-1.575191917070576105778469108560808099912e-14,
-1.703315082819672593852010623909359952984e-15,
4.772674618126924809837915122873271729025e-18,
-0.0000191268781735878651263391409957130924269,
1.102129699211995492964318594795785474546e-9,
1.268805139644311967397834108549746949954e-9,
9.737386818434296450061564605845527399802e-10,
5.604078758943234989016517207458949739846e-10,
2.579657759404349317288262862198154875139e-10,
9.891239059466814493077591052151255334477e-11,
3.247998898688638708998237481581701166086e-11,
9.316080147058158927563945903047967709312e-12,
2.366875365124606253026936996017790266311e-12,
5.373641180256192182678349372573841087585e-13,
1.092941279555906710990284042147597731356e-13,
1.97543285770075468273260717609366163596e-14,
3.068307391057641329463352971885238018281e-15,
3.514154992473587562187317627013031091249e-16,
7.559122851510008380846589505145753712751e-18,
3.563866126167773214306763054770933710192e-6,
-1.904177522748069531426849301053990651087e-10,
-2.19215613777218883953542603117044151665e-10,
-1.682374314493329242056774995927018304894e-10,
-9.682594439413900969740888004144882473038e-11,
-4.457221532951711494108249508465829098521e-11,
-1.709157503884461691570690439828229101277e-11,
-5.613140352172507975908952244079071868153e-12,
-1.610426966830692782536905906276343288648e-12,
-4.093746347843530737334055794970867202005e-13,
-9.304623180355907680910981616447111737434e-14,
-1.896855916711876862087316383749719110738e-14,
-3.445620588292619674538610259140508407198e-15,
-5.416442070009817560347583826475059894623e-16,
-6.483686132215277258478905512131583789803e-17,
-2.546959331798476441103439578517384203878e-18,
-6.064927045683447671014717598347511092657e-7,
3.020534022874839844591824296254457976593e-11,
3.477357531058086888487407139492320012804e-11,
2.668723747042850277844387430952390507116e-11,
1.535956766586141588949606775084766047992e-11,
7.070725752746390329837196405173390491941e-12,
2.711483257347885391040320417218955675453e-12,
8.905964798889849506955339668770389789851e-13,
2.555741785621280049669027666421239050492e-13,
6.499804580087970687447363014171226579388e-14,
1.478741478717067482823494503487589692633e-14,
3.020550348429830215678510093159714978562e-15,
5.510030544974649733042125918939991410298e-16,
8.748711803910411899431794811493490767134e-17,
1.08459863840391032717581144509717969165e-17,
5.730835326588385315174935277073593568484e-19,
9.498627766785017303550922884065142911848e-8,
-4.429799752449638208422887356952868913219e-12,
-5.09977555726210134870559995023178564597e-12,
-3.913884874995173802913039012426609394508e-12,
-2.252624681636446499454404536617324468874e-12,
-1.037014152719271117739488362647144419276e-12,
-3.976942604447102553548069688193731500034e-13,
-1.306371984855849971361500643667881200651e-13,
-3.749645053746922570392075641683285888116e-14,
-9.540023685448242713332712840769968860163e-15,
-2.17219678441541201463656340425941912836e-15,
-4.444599042103864565388453714178125268144e-16,
-8.137160418596794144935354053183033504453e-17,
-1.30297995272619490859339213986716289694e-17,
-1.66198878490781640082602392608529002921e-18,
-1.055606595464893987349554574822640946829e-19,
-1.378371096380843785761275519060209148423e-8,
6.043428388905711453522120781104406114241e-13,
6.957473068538994545313580431957668813214e-13,
5.339626601114194548962436045270192129866e-13,
3.073239598458871723176233752745387589059e-13,
1.414821826429526455866119487261451550709e-13,
5.426069802208652980892071631862149481622e-14,
1.782546818776332435236009949072122093864e-14,
5.117296483653215692001897026124700546964e-15,
1.30242780075875783253414510473431365751e-15,
2.967670609741711502419393358570367633567e-16,
6.081256905624905373229237794276450520681e-17,
1.116854794692211120610575677264214645423e-17,
1.801409729329582221602928156803656528061e-18,
2.352653912587024367834066547203245813787e-19,
1.697328763131262737163149238258795152447e-20,
1.891662753159725792439524070571936382898e-9,
-7.8132265042784386316854122609531427612e-14,
-8.994968295641258754277403504543852504216e-14,
-6.903369645370347452048956385385050835446e-14,
-3.973296153178133621616200486732622589427e-14,
-1.829215285229857091503405146308270199095e-14,
-7.015612093975516899540966651434336034558e-15,
-2.304917751420911622790674437467124274254e-15,
-6.617956109930992285492368687786200913792e-16,
-1.68490545502124348607254118497576867489e-16,
-3.841658422630920674275219775400367773239e-17,
-7.882704331994069832388039255289026092249e-18,
-1.451771090176067177475511471333936724368e-18,
-2.356710684272785400812158948148311773602e-19,
-3.141132083097973441013044574102656423846e-20,
-2.494736686374234090390046900612040107336e-21,
-2.389444234365864886192055630413009125107e-10,
9.34337486796588442571936417699563848978e-15,
1.075657275805629411127623866628725637614e-14,
8.255383581864044800472938910610597549158e-15,
4.751500278191028516845157447720293986363e-15,
2.187520004582162417100717527308943811266e-15,
8.390108328592666860269618784707727633937e-16,
2.756684431144723555381716322901906835987e-16,
7.916166638108393313946434417688898368044e-17,
2.015979898132468285480665966400452349595e-17,
4.599090015400241492628350400515211412279e-18,
9.44771434948364574926846120720473965975e-19,
1.744197861532387430518892936452807288659e-19,
2.846945588174049079186300633346627908342e-20,
3.859178193922493605232268998040008647525e-21,
3.293971676805622978642006776479651312772e-22,
// [{0,0.0001},{2.,0.001}]: m=6 maxabserror=1.36083398673574759454e-20 maxrelerror=8.57942286240356725338e-19
0.03256488474876953790170456334523453919799,
-4.948984548863522632118028708030031017991e-6,
-5.696811934741410335008386328184527572634e-6,
-4.371057180392166616613107934055463407931e-6,
-2.514562632461959862845645736046230282031e-6,
-1.156507199072807287811278462571474224237e-6,
-4.426817251106819989401522422103887186865e-7,
-1.448638158806625127813781283317095036181e-7,
-4.126264985010021739562055855813124567488e-8,
-1.033583254155184807574350352391758848566e-8,
-2.278422708480764332590241462175640003138e-9,
-4.346205665714056511849492631023608136075e-10,
-6.736542829176540059712411364126617117796e-11,
-6.277997979228192486892918350384716801924e-12,
1.074172298496402439255023531719249965491e-12,
7.537704023830717134381340539818904861943e-13,
-0.05548895503743226142976035246644079205073,
7.019875559877745756928998421770216415403e-6,
8.080882579981114706820545220346147510476e-6,
6.200698302187828918073917420618131845914e-6,
3.567557590172627596546987289430535598424e-6,
1.64121634932419642335941618024810448286e-6,
6.28532217510455551975632565184469548225e-7,
2.05889963171813751869917130329077901655e-7,
5.876535640185206579035404783012625351675e-8,
1.478198517328105458113786812302630699589e-8,
3.287512314551398500250252009283086089752e-9,
6.396851966185067587505499201646216065577e-10,
1.043474931547262662866545967049000673215e-10,
1.19825746464825214229557605224496582238e-11,
-4.449546833647075390003192981296173178644e-13,
-7.522524381387994999872783648726533891219e-13,
0.04830831745080904396681474555827098424534,
-5.228519074530287155935521089290849608216e-6,
-6.018902859368340927730630180614659039469e-6,
-4.618677628906217722760046282520692550108e-6,
-2.657572242865382305767600784323896316235e-6,
-1.222796147678182865430209378461976123806e-6,
-4.684512040624974292012333816298157136735e-7,
-1.53557319655176654520419945578831719619e-7,
-4.388939758684237915543855734789551128379e-8,
-1.107138279781771170475019394867864682514e-8,
-2.476896985017611223009843516695788341314e-9,
-4.882548357571508838418579036192603100292e-10,
-8.220366221274217704536423409785506894225e-11,
-1.049909808556083803062088436096999528846e-11,
-2.240562167345485243211866077131707856445e-13,
3.957612692925865001716160804873474461472e-13,
-0.02850586953914972955616606785317899186253,
2.693886623828344595912937975980761857609e-6,
3.101163322601236115443623348688818445002e-6,
2.379788339550712887764263887937854430782e-6,
1.369406934360240032378655479937315805365e-6,
6.301661507276452121692625988686679967719e-7,
2.414752874711824414979358980433624573363e-7,
7.919437501614955490425890554716963616066e-8,
2.265781237451190210144785843548247912576e-8,
5.72722972728803128048650254052877306001e-9,
1.286725310703735821493788146655817908856e-9,
2.559701073613363512467281975173656861558e-10,
4.402941959628869042500567551241642674182e-11,
5.998921119407978719365109877769205666961e-12,
3.242949932372692798533270616720439912324e-13,
-1.417335389479257009661771781195962325422e-13,
0.01278149206424906333681802057893366307749,
-1.071418263219905476375851858433472676453e-6,
-1.233415550036773889387835025336710270689e-6,
-9.465274478524593118075823371227684561385e-7,
-5.446877496565931166849897766460949266271e-7,
-2.506747522616562183122474745210361201934e-7,
-9.607473968630211197703048615372807054988e-8,
-3.152052289404472109132609505435125437274e-8,
-9.024943824487035193273862579698375082813e-9,
-2.284736001796508916471865342203678402276e-9,
-5.149323085054619459174095942131693978567e-10,
-1.031305878283354939895498163080330390448e-10,
-1.801595161561054882995775200373164189598e-11,
-2.56360964785385260524686643354931476265e-12,
-1.92119735299449076973860246117106509067e-13,
3.751004590157931815454863186448828119866e-14,
-0.004633477383144518295563348833009013791319,
3.488666729323879344707746308014365255832e-7,
4.016185836056493720723833596199872304928e-7,
3.082091150326775162122100569763889055918e-7,
1.773681550796536831065158291732339279178e-7,
8.163383588368358433148858668340795466514e-8,
3.129190844238989755895091580680318763703e-8,
1.02693528776833329460992026959323757613e-8,
2.942045932597418530646178445864177796852e-9,
7.456901083070879727886494809021363590816e-10,
1.684755274887491718397907444141443408565e-10,
3.39179879476204784116551392849258858182e-11,
5.994700643237392357219135404235395650404e-12,
8.800478377045746644565676792256745627865e-13,
7.868697735922455367104656381119914774705e-14,
-7.38358514655225540154225895223956072464e-15,
0.001412004831698366867027856512154961990601,
-9.646971998424893352941289968687514445724e-8,
-1.110576540016575296093087027381907989449e-7,
-8.522882379574552335194428315432271777151e-8,
-4.904890441954731628898079170900677231238e-8,
-2.257611312477132181346203784437538005509e-8,
-8.65489282838105926251833248684165321146e-9,
-2.841020347441032004966953873739144512572e-9,
-8.143012895727234128877397036099418232336e-10,
-2.065892787003792624580161709528855089853e-10,
-4.676648338710368357146512627338557478541e-11,
-9.453984007169212647664114314313671726743e-12,
-1.6861983789891710713432611840123181695e-12,
-2.534188839536657899643221747650516378852e-13,
-2.534792503260404306648446896127956258789e-14,
9.650001356283944958100364246349613721635e-16,
-0.000371528977720807553489432738110154826118,
2.322841809475693842016404079984133825928e-8,
2.674112660640913456827713325008125889039e-8,
2.052215094249134624373991738446287771403e-8,
1.181071122552526447061741270104095898097e-8,
5.436465512831247424522696267848453975527e-9,
2.084350044350862328365907326602926191574e-9,
6.843314532223891047035655074707392718203e-10,
1.962205693715762536221801759975333854613e-10,
4.982018338556468837426691701355672716769e-11,
1.12959835710951809761006265465135035747e-11,
2.291150318145211529613204250957871452199e-12,
4.116421320904493109027571586393987544583e-13,
6.300767681340676722609956120183137805869e-14,
6.813260349240854622667331430681405381414e-15,
-1.909069684847306352175308283562741660663e-17,
0.00008607095165281134261475456955784354280773,
-4.959583641920328045539912261282381089809e-9,
-5.709623123180012442400530980172441612643e-9,
-4.381824064289660284630806386642831918411e-9,
-2.521835439218844209911145593966893707384e-9,
-1.160845990670457219012639488648722528895e-9,
-4.451057572688507890986955591404249749787e-10,
-1.461599503071966059535285937056228051687e-10,
-4.192236062333267245720350358518524420846e-11,
-1.065093913326956584034800610561417072498e-11,
-2.418138528879491786049487010085257353418e-12,
-4.918235753399740051928611022765554634983e-13,
-8.88944785112307066232671516980004570168e-14,
-1.380738324570810414697733140054667257013e-14,
-1.581369744655470639036387662812262499174e-15,
-3.401605264626205952073474346070590401205e-17,
-0.00001781931842394169299336526219628351693802,
9.52088308265122540329255471365378334949e-10,
1.096077547242862002349744210361925427534e-9,
8.411867568978282578053092351412812254074e-10,
4.841294915426248866755246928488995962877e-10,
2.228609705603141272508441800777299908718e-10,
8.545783450381284502132170504996083815015e-11,
2.806568839065655120091822946007661717749e-11,
8.052130994259633640082576367144301271766e-12,
2.046872195789410611856563253693607711091e-12,
4.652309357632115395818702154902408625043e-13,
9.484274992630208749741423566138337475371e-14,
1.722809444767501989823581359223988154857e-14,
2.708219641894805336260645360623606889593e-15,
3.241841149837625258523255654048405526536e-16,
1.273477933294188771214175099876124327859e-17,
3.335710696522026530884142944991914807086e-6,
-1.661294002753620686333352029100666041295e-10,
-1.912546976144586161677527300385682047184e-10,
-1.467798317259615690441472490677141684224e-10,
-8.447763691910525991138086843661687404112e-11,
-3.888899843414404717749827392608652295999e-11,
-1.4913160521379313285326694311016310552e-11,
-4.898281495714435627678105053837511825047e-12,
-1.40565822805347810217223755863443235758e-12,
-3.57489314572329909712428191401143505878e-13,
-8.133079563945093542235064808218093862902e-14,
-1.661302986173269158361462440527441327269e-14,
-3.030517345712392554430916576432515505856e-15,
-4.811792391491683611629869650681615906826e-16,
-5.965293764197363947036905700516878947454e-17,
-3.151960617120110568306210016729037845765e-18,
-5.699869223104656939296574296303847793168e-7,
2.658136921177348976359114432193227277969e-11,
3.060161286764397408830402019234747505221e-11,
2.348558061466156730173883323386173031252e-11,
1.351705541517002133641297290737517130543e-11,
6.222686798628795952011486744591713656461e-12,
2.386396418246605451881233362802158905937e-12,
7.838990462971214190079603611193023173572e-13,
2.250004887251813478135577326676226171847e-13,
5.724569151193920232368984802544554300797e-14,
1.303444733360242118200609149234031965261e-14,
2.667019890090296221279581944045271491136e-15,
4.882778143606981447467380694431581007705e-16,
7.81867009392572422940487147418727737621e-17,
9.973019903979003146557850319359805872612e-18,
6.334622577090665295816222197963359887742e-19,
8.959153246716777944349276688355828897514e-8,
-3.928136999497708189429004480641052034464e-12,
-4.522252208446299826936641873557127614448e-12,
-3.470676485854008138669761640318908827584e-12,
-1.997559229963518289627665641984439299718e-12,
-9.196127744916895320672176907556979433262e-13,
-3.526863239532412771098440942686052356898e-13,
-1.15862844351580942832287640028971081338e-13,
-3.326165194908205010495250699118469423881e-14,
-8.465583196574282202415161520253179452735e-15,
-1.928940795641735603703599156160765116244e-15,
-3.952724159825677316376855955711893331849e-16,
-7.259384090760068286237225760459217413295e-17,
-1.170887979626351500668489847815307948312e-17,
-1.529185553221395707145419366435062178546e-18,
-1.103226269624637739704918563342223667405e-19,
-1.304272499138691354238409885573287768036e-8,
5.39542518895905911452071418700457665576e-13,
6.211476886271677276431901528157044550596e-13,
4.767122556555960498987312532587936441551e-13,
2.743759425858918804985239692063425273099e-13,
1.263163950242715265061244029469474878402e-13,
4.844624099123348401094827772062654409487e-14,
1.59165589060867195485953695146728031542e-14,
4.569998822079129864544620375282553330784e-15,
1.163495306853027751439050481351555277186e-15,
2.652781907818192266457634032103840059145e-16,
5.443084522201911888474526298804747267305e-17,
1.002399249164185632677116685084049838823e-17,
1.626996891303109760124395952947209724541e-18,
2.167566847051968206953580488982195637283e-19,
1.718082250867565727529175879688160412063e-20,
1.795269551970905275102105683929202590457e-9,
-7.018787468255898145938748734911894871881e-14,
-8.08038846569759272550469790161857926244e-14,
-6.2014833673839955913588855218075258759e-14,
-3.569349665864458202605016065497145471767e-14,
-1.643275534670474571356655105227564378982e-14,
-6.302690262263441439529712576689820825597e-15,
-2.070835163869023740858214051397847049615e-15,
-5.946666283382315081524958063561542374863e-16,
-1.51441590972797609526156506963929976332e-16,
-3.454868626347723147245795957822905164265e-17,
-7.097211386170166125910792587879186374342e-18,
-1.310266339006709965872254889013756772168e-18,
-2.138697903113953056181115300051952472088e-19,
-2.899244184158152804494528944502123999239e-20,
-2.475085325475338944085821123229161054722e-21,
-2.273547604797865509919846441886255952531e-10,
8.438912715758138831791398000977378239858e-15,
9.715328022049536748005481955531642982439e-15,
7.456284363271572957598874177908422810445e-15,
4.291600394252683488448670564709280462371e-15,
1.975819090363982666112220375904947269748e-15,
7.578372943999779604475470445604458288086e-16,
2.490129991385286360065243882647173197447e-16,
7.151599216955699276107096505102980473587e-17,
1.821720049730486356738769219226852877961e-17,
4.158000366850595499628429019405086207122e-18,
8.550371583595816018381828723916239772644e-19,
1.581926692115867741028208343325323797811e-19,
2.594606978304814339243523237820842209478e-20,
3.568999289764662370182406653450403692583e-21,
3.227030556405223088579962695111492439411e-22,
// [{0,0.0001},{2.,0.001}]: m=7 maxabserror=1.29099862479865025922e-20 maxrelerror=9.78979193636715270153e-19
0.02774447751871613070354264156804646144354,
-3.509937779938872878082433060655427264845e-6,
-4.040441289990557352970416173019680124431e-6,
-3.100349151093914458699377101224022090859e-6,
-1.783778795086313798079189860464455074636e-6,
-8.206081746620982115902498201922266918894e-7,
-3.142661087552277759535022329338666339628e-7,
-1.029449815859068759236823475907240364287e-7,
-2.938267820092603289193783934977501045944e-8,
-7.390992586640527289743471481158360381166e-9,
-1.643756157275699249936556647881160277954e-9,
-3.198425983092533793364303251073364496976e-10,
-5.217374657736313313611431594726366908059e-11,
-5.991287323241260710285170021368865047159e-12,
2.224773416823537696682091558679599003012e-13,
3.761262190693997500102032998303120989401e-13,
-0.04830831745080903751305350593598705373199,
5.228519074530286927936183546270942929416e-6,
6.018902859368340665245139733884981197909e-6,
4.618677628906217521307954160180846408218e-6,
2.657572242865382189817382982357511924947e-6,
1.222796147678182812046909426904730146029e-6,
4.684512040624974087251865147545530926064e-7,
1.535573196551766477919549888465608305433e-7,
4.388939758684237722282534002766651933714e-8,
1.10713827978177112123484623120149483748e-8,
2.476896985017611110570803796327715828497e-9,
4.882548357571508606990261573586511299048e-10,
8.220366221274217275543553447234968096292e-11,
1.04990980855608373239790950153372163697e-11,
2.240562167345484258716251468703460470248e-13,
-3.957612692925865095017869680770951931546e-13,
0.04275880430872459941431600492114962591904,
-4.040829935742517065061312510670351409464e-6,
-4.651744983901854370251362758558433882559e-6,
-3.569682509326069482906168448830751924602e-6,
-2.054110401540360135629438826398852118068e-6,
-9.452492260914678583373500804154334432321e-7,
-3.622129312067736776219576688557360721146e-7,
-1.187915625242243374089092972706395823484e-7,
-3.398671856176785460354927027095951011571e-8,
-8.590844590932047290593786464325245941879e-9,
-1.930087966055603816732737847504836113374e-9,
-3.839551610420045442751672272814000557174e-10,
-6.604412939443303886942347284361562479799e-11,
-8.998381679111968613464883812837600761725e-12,
-4.864424898559039950780915852575597848383e-13,
2.126003084218885440272912385889107961745e-13,
-0.02556298412849921124297677041534969629883,
2.142836526439849267511696423942537377154e-6,
2.466831100073591888853729260845007280604e-6,
1.893054895704952477172206981848383437563e-6,
1.089375499313205718535331999784354128947e-6,
5.013495045233214075643803351760831539857e-7,
1.921494793726076649063469449197713011962e-7,
6.304104578809057288564615269288143470847e-8,
1.804988764897439515775229534170848320928e-8,
4.569472003593100579930783514966405122163e-9,
1.029864617010942786962943073696845186876e-9,
2.062611756566748770817529109467910402661e-10,
3.603190323122181857379971766295086364988e-11,
5.127219295707823960472854795073251365591e-12,
3.842394705989146983351172513692942561841e-13,
-7.502009180315706834506719640536007819401e-14,
0.01158369345786092992640054066273831707161,
-8.721666823309575088882077902099099939809e-7,
-1.004046459014109238300047919052492367309e-6,
-7.705227875816828985266892053101774465217e-7,
-4.43420387699127938593109945461591849465e-7,
-2.040845897092060744753135317824451759773e-7,
-7.822977110597363676133037903780236067556e-8,
-2.567338219420796854030262866128769013791e-8,
-7.35511483149344181495668749769053517788e-9,
-1.8642252707676932985798038316304297549e-9,
-4.211888187218668454441831081654900432983e-10,
-8.479496986904994271370848387515438646738e-11,
-1.498675160809324816722804243088843201487e-11,
-2.200119594261398178450621351305647623037e-12,
-1.967174433980559620465317597644601745753e-13,
1.845896286638117295603836307548664486721e-14,
-0.00423601449504302831115232401354433608227,
2.894091599509072745505257481120853897931e-7,
3.331729620028548243636475566388080736247e-7,
2.55686471385611230375100211964191069034e-7,
1.471467132577064485743613068802442786903e-7,
6.772833937388326255535649068346464157659e-8,
2.596467848497797457454936321488722557432e-8,
8.523061042268809946378585162670929353552e-9,
2.442903868702577680121764148224451651085e-9,
6.197678360971650295260365323369490715282e-10,
1.402994501604038783277351899919452782993e-10,
2.836195202132091849963064983459660415852e-11,
5.058595136932901440543714139844319475391e-12,
7.602566518552960588882623230458208602002e-13,
7.60437750970178118929539222558077776484e-14,
-2.895000406960464786175506553589144047257e-15,
0.001300351422032582455048331331100133603211,
-8.129946333197804356897080552616665379984e-8,
-9.35939431228104572949640606384823036628e-8,
-7.182752829901019303207225743853971747665e-8,
-4.133748928950561956719314304273038055995e-8,
-1.902762929498634276219790988217915189595e-8,
-7.295225155257544597431119714769205086572e-9,
-2.395160086288064791865417195168860056373e-9,
-6.867719928033041315384826741487932043572e-10,
-1.74370641850186700976835666622792029904e-10,
-3.953594249899539307614294301300560151882e-11,
-8.019026113541665299809077485066850624598e-12,
-1.440747462322779206252827161711566461802e-12,
-2.205268688479499896214957880490108986528e-13,
-2.384641122248759559122315530859628130161e-14,
6.681743895540217010779112203502971278838e-17,
-0.0003442838077025060699769883049698201142927,
1.98383346062309219774622981683376090031e-8,
2.283849253710050000917334990029374698258e-8,
1.752729629121970322501604017063552135033e-8,
1.00873417764799764167353034623467746798e-8,
4.643383971707756181222822997054147171467e-9,
1.780423032537446843839735265302193440346e-9,
5.846398023664201340420326388338990170547e-10,
1.676894428200926258970446674253085136264e-10,
4.260375661633247303447076720364345320848e-11,
9.672554134528924729718205188444929828293e-12,
1.967294305272841912199261156893337931892e-12,
3.555779147702574649017071467079062444394e-13,
5.522953310231095250046303656569645910989e-14,
6.325478995267922744532595775661721990584e-15,
1.360642121626969024137267573630556912246e-16,
0.00008018693278508006831510026456385682599388,
-4.284397383059756897335105671272679544442e-9,
-4.932348957834393579225762129442771298596e-9,
-3.785340402388178362162492843567931226633e-9,
-2.178582709839781292793283335512498846405e-9,
-1.002874366553629892799086678923835979104e-9,
-3.845602548959391560422643454337989442536e-10,
-1.262955976359653118584442596875513202737e-10,
-3.623458943912597481894878467974654044814e-11,
-9.210924872122268442258140066303195189936e-12,
-2.093539208894456559819717819059740647223e-12,
-4.267923742481271368894832132340079115345e-13,
-7.752642493650539987485088482021291392791e-14,
-1.218698837562349149534233153498358410797e-14,
-1.458828515608900739954229920019385631861e-15,
-5.730650681903561152396483542047486533885e-17,
-0.00001667854184052018119569221314209306689912,
8.30646590117323139547957586751856083392e-10,
9.562730146075469353321478522601060549139e-10,
7.338987952555734260332637970602683269551e-10,
4.223879754474275888391186922419473135738e-10,
1.94444895879258914966474594001074850231e-10,
7.456576567271385120659227946265358350734e-11,
2.449139534193390131505536922088223966462e-11,
7.028287654267018214468753790011541307449e-12,
1.787445684679180731296092926326390598538e-12,
4.066537753822699228346877831195464628938e-13,
8.306510756409312615747545609614134548679e-14,
1.515257899045386107482986108942762573088e-14,
2.405894921108132257100554800562313734542e-15,
2.982645106236450336576670741246464387045e-16,
1.575978625444797729025766367548256720676e-17,
3.134928857771723494618057714916874748521e-6,
-1.461975571195621562670654872521998881231e-10,
-1.683089012283321753110741753879819075268e-10,
-1.291707167552732784507422021436172295102e-10,
-7.434381823730781766182209898819318329184e-11,
-3.422478358667736092439084647918508363829e-11,
-1.31251826763104215593278588421574462714e-11,
-4.311445535415705730029298185093828968172e-12,
-1.237502912274319660239473446339069163395e-12,
-3.148513604718982358275067832467215130777e-13,
-7.168947339163522179794470460229511704754e-14,
-1.466861208515874133696880251411269725422e-14,
-2.685528478422570533622786455081704458766e-15,
-4.300269377514086446471749176178951642624e-16,
-5.485162110806244671944378430966445367079e-17,
-3.484043564380300416288670338433036513208e-18,
-5.376152466894050571460485108031684515907e-7,
2.357115526545005938830286758345601382474e-11,
2.713619943882836646619305076868787804948e-11,
2.082612050803338453597469240304825827267e-11,
1.19865419752992535201757018322252535575e-11,
5.518222953694005387419954785374144868015e-12,
2.116327488708638612482746621549071710119e-12,
6.952459229673106635577113578436904739376e-13,
1.995896894148555859395865455035144390397e-13,
5.079853825675592560948698579141474499804e-14,
1.157479543886274631348086775528995393621e-14,
2.371871332569797662621683807487884262439e-15,
4.356069474085878887134046937488177273634e-16,
7.026051040976524737183538749381573646837e-17,
9.176120854170575024669780293572706543755e-18,
6.62031254235633235113772337162014055308e-19,
8.477523815348650300781747422157928260664e-8,
-3.506942995500274517685746440343531941517e-12,
-4.037363987326165355728386716464107362589e-12,
-3.098555992186066933717152599960105016209e-12,
-1.783401224387761076672317183824841876718e-12,
-8.210370454068576596981681867017454296981e-13,
-3.148930781749799971920509740504547366768e-13,
-1.034551721090783239915881523281835434964e-13,
-2.970428546437724622331540106598937932648e-14,
-7.562539355877125429118664659772338157797e-15,
-1.724267089038731060382343090973458499068e-15,
-3.537920169637284623915303039148784557243e-16,
-6.515437711969090656090755611868110075261e-17,
-1.057521950951180095485696649487568065784e-17,
-1.408881776907387765287412231695939596285e-18,
-1.116717313615307458385531108371334981854e-19,
-1.237717604433278255866885850755847342192e-8,
4.846137021576803754763782155320733506045e-13,
5.579121452533525016027327011604358587772e-13,
4.281826991390781719638444079548303647161e-13,
2.464464351378018370583846414381884024652e-13,
1.13460230392418167847635845473728889297e-13,
4.351699405006749504105872467166822490314e-14,
1.429808117331835113369203307450909445476e-14,
4.105862464006009725187910838402219766671e-15,
1.045618314674305863399264556599616864369e-15,
2.38535958436699335290999052211057662762e-16,
4.900025676551439805459562313932100821192e-17,
9.045772696675797092679619407502604524569e-18,
1.476318404424475018039456809306926110748e-18,
2.000533231407072681892908188922896447343e-19,
1.705132824413121400861769939995746553888e-20,
1.708206141372557760240439514261476967587e-9,
-6.339446845989497236580545573813964407903e-14,
-7.298310574706251023385303327908317427613e-14,
-5.601280725453439622968576371359859788084e-14,
-3.22391930168864878007595880403442070749e-14,
-1.484267169860604091321806967907992636562e-14,
-5.692996473325209387536333117441426864518e-15,
-1.870626289547493255628311429290218568932e-15,
-5.372399874782363736167480766566480570567e-16,
-1.368507233402709486854617263513494817158e-16,
-3.123565258504941056329719227886898576061e-17,
-6.423212387388108310556133647107136607816e-18,
-1.188382435427486081853870094676625410025e-18,
-1.949158881828191297542209643195870063796e-19,
-2.681263370583061397266708369722884414515e-20,
-2.424722310887577963813273737094576635173e-21,
-2.168354957243309042031168139075411532715e-10,
7.659511535075045965533359636960240054419e-15,
8.818054783029809478076060388130728353482e-15,
6.767671591993000261229553025976454538908e-15,
3.895283478545810468558539828697542785179e-15,
1.793382506183423562913427085070417315277e-15,
6.878815350874587118207016210784100330867e-16,
2.260391059009678941054498758583880669728e-16,
6.492510037432500029892985778696211563597e-17,
1.654197856792833907390031537970205866724e-17,
3.777334199800283540495128605924649742411e-18,
7.774735109181258774995042330539034099664e-19,
1.441188827774771040932543051512090431751e-19,
2.373963009251774868619006592500841334317e-20,
3.307498612639209435797860753638728742537e-21,
3.134842763888320854618161536754266639514e-22,
// [{0,0.0001},{2.,0.001}]: m=8 maxabserror=1.23134246210433107956e-20 maxrelerror=1.092128984646656463515e-18
0.02415415872540451874566954491021643798765,
-2.614259537265143463618346113577704960415e-6,
-3.009451429684170332219922062866642776918e-6,
-2.309338814453108760344951532136740819116e-6,
-1.328786121432691094730822880678627222258e-6,
-6.1139807383909140594156234271297385394e-7,
-2.342256020312487043311805968537554308354e-7,
-7.677865982758832388565425953945747208801e-8,
-2.194469879342118860844696884955334398252e-8,
-5.535691398908855605418324517725846794497e-9,
-1.238448492508805555112658364760686899042e-9,
-2.441274178785754303139017127159156647571e-10,
-4.110183110637108637109482291150519028584e-11,
-5.249549042780418660890605532499364296234e-12,
-1.120281083672742127794205871402154098031e-13,
1.978806346462932547668299120032859339654e-13,
-0.04275880430872459324602769465680403894948,
4.040829935742516857196671188209443229191e-6,
4.651744983901854130945680976075641334985e-6,
3.569682509326069299243522324201347450509e-6,
2.054110401540360029917675373278117362054e-6,
9.452492260914678096672146702034611944597e-7,
3.622129312067736589532593833541172860946e-7,
1.187915625242243312740372087525156224208e-7,
3.398671856176785284125768704325415355049e-8,
8.590844590932046841497485026407974030239e-9,
1.930087966055603714140798943901016932277e-9,
3.839551610420045231415797933779674991433e-10,
6.604412939443303494516881676029047504535e-11,
8.998381679111967964565227347303177199691e-12,
4.864424898559039036497858019089633899383e-13,
-2.126003084218885530391539448036781093216e-13,
0.03834447619274882172931247538932786825941,
-3.214254789659774057977820473443059074942e-6,
-3.700246650110388013694694085876371971328e-6,
-2.839582343557428854223156547259957153663e-6,
-1.634063248969808657500453355451630251303e-6,
-7.520242567849821480400239596893243804515e-7,
-2.882242190589115114345678667000604109443e-7,
-9.456156868213586395399346575564206750136e-8,
-2.70748314734615940654680077268944060296e-8,
-6.854208005389651208594729807602470591158e-9,
-1.544796925516414257845495533952511275705e-9,
-3.093917634850123315789938324893666575672e-10,
-5.4047854846832730828239717166045588658e-11,
-7.690828943561736433112252476520709135739e-12,
-5.76359205898372117577425662541367693471e-13,
1.125301377047355953768838174332797748667e-13,
-0.02316738691572289644897154503728778416907,
1.744333364661949949024897799076881324134e-6,
2.008092918028258691454275949269765289493e-6,
1.541045575163396661203734513359959397105e-6,
8.868407753982736418424552001878011362587e-7,
4.081691794184203278722680520047129055541e-7,
1.564595422119504107611543735396251668651e-7,
5.134676438841696803397170047387254946704e-8,
1.471022966298717977961365997071657303303e-8,
3.728450541535462066934060123037449834213e-9,
8.423776374437509312709379534501582535826e-10,
1.695899397381034368885395504920805135533e-10,
2.997350321618715579891367843288043717777e-11,
4.400239188522905403614826038975561800997e-12,
3.934348867961272885815896672889030791562e-13,
-3.691792573276083144385714375846539431711e-14,
0.01059003623760722046304622843235849316047,
-7.235228998772569018797470371995424516982e-7,
-8.329324050071240695319799906837544865857e-7,
-6.392161784640181052700756808470963631409e-7,
-3.678667831442603825291312474386845891112e-7,
-1.693208484347055141420598850011795550776e-7,
-6.491169621244392291109413181846633565592e-8,
-2.130765260567169178815008956208499449021e-8,
-6.107259671756348512347821608336664747621e-9,
-1.549419590242888184585057670407908809402e-9,
-3.507486254010041222705640490929266519118e-10,
-7.090488005330114725233669940304368071092e-11,
-1.264648784233203991264147670831249288236e-11,
-1.900641629638204689895554872338238941047e-12,
-1.901094377425394837263916096602154072603e-13,
7.237501017401676164126413825684532050387e-15,
-0.003901054266047978314290727610195886798727,
2.438983899942570471190116797439037011846e-7,
2.807818293665006171908211204916558290015e-7,
2.154825848955487608858350027177794114736e-7,
1.240124678676639600838702848715103975329e-7,
5.708288788456635021256177006355446017317e-8,
2.188567546562201188445836951606305422971e-8,
7.185480258814697288803342477399933056246e-9,
2.06031597839569395518242878479364694053e-9,
5.231119255469367242761715676590558239819e-10,
1.186078274961584512444000801054950704812e-10,
2.405707834045448664817112990450545973184e-11,
4.322242386936676039482561250969716690368e-12,
6.615806065386145139772575867538511465708e-13,
7.15392336667251172079187213961269267577e-14,
-2.004523169389192405673293940512745308443e-16,
0.00120499332696811395171077884840880846677,
-6.943417112210917577853954784432265325642e-8,
-7.993472388019822008363983275672771143969e-8,
-6.134553701953487133757038989092488013259e-8,
-3.53056962178329696951924468782779641748e-8,
-1.625184390104761331505038571794185794586e-8,
-6.231480613908093894490003831741711948294e-9,
-2.04623930829135339831892543512279791927e-9,
-5.869130498728761150343702850892421061755e-10,
-1.491131481578140976952119233558067392345e-10,
-3.385393947099987883777283791767594490903e-11,
-6.885530068485589560995092404450597333519e-12,
-1.24452270170160004406707881470067583482e-12,
-1.933033658590339544129585662471558011571e-13,
-2.213917648357230308063314879331361530026e-14,
-4.762247425831525544878733901772895317591e-16,
-0.0003207477321833135958630990352652631932439,
1.713758956738450009573398695102626270554e-8,
1.972939587179905551008641286828258865363e-8,
1.514136164060614550586119439580778659763e-8,
8.714330857232727442037554134909171653133e-9,
4.011497474443600493944100822548541515149e-9,
1.538241022740235073766393750916239348641e-9,
5.051823915811372489737215924054767805465e-10,
1.449383580544698491230807131463524857792e-10,
3.6843699564421706024353888673634424495e-11,
8.374156852923949538869583441455008283297e-12,
1.707169500565754046257248829077110627385e-12,
3.10105700409531984798506764436711029472e-13,
4.874795361221000323697652321592606298316e-14,
5.835314077894522150948872139000304926739e-15,
2.292260287999602887000680456484491075914e-16,
0.00007505343816487958449012723082948786979827,
-3.737909651744299255494358173832406865124e-9,
-4.303228561377994849347028641779543041273e-9,
-3.302544575306948080379442235917067257819e-9,
-1.900745887589187432042076106895606633445e-9,
-8.750020305707285396095127447130904511539e-10,
-3.35545945187380607357587421098782928245e-10,
-1.102112789270226547504987820655516523272e-10,
-3.162729441211772063705406222874285484982e-11,
-8.043505572878683151139816086379039670913e-12,
-1.829941987351421521546184161989424539229e-12,
-3.737929836531640361878660613938637525062e-13,
-6.818660538539317856847058159412684935806e-14,
-1.082652713309784620322376031205923984584e-14,
-1.342190296114484849879498307271147779566e-15,
-7.091903797260419731513039747329138489194e-17,
-0.00001567463316170100391164207106125975872158,
7.309874106542882445705644455699390986703e-10,
8.415440744851996002279888430599823440938e-10,
6.458532524880840984526564878095545609975e-10,
3.717189005050390933889679418637166953038e-10,
1.711238301428297909636193081182037382392e-10,
6.562587970719579074889733187235874269166e-11,
2.155721661107484673269302422444386956057e-11,
6.18751138257214454482105804910179290846e-12,
1.574255992284973742344530765191717903879e-12,
3.584471819039565122508772514032255541324e-13,
7.334302230521227999551844145910522086591e-14,
1.342763531355822083006462476921703905511e-14,
2.150133518267799842505572872948477430477e-15,
2.742579406186329030939222741644602582394e-16,
1.742020156506167631807748526469832095695e-17,
2.956884608597265105362919338693579606897e-6,
-1.296413781769550190777779983533021637709e-10,
-1.492491247935695065047572452838771338731e-10,
-1.145436841916341427273772329525756324276e-10,
-6.592599318006876261419138670360154282502e-11,
-3.035023191568308757807310667336584018543e-11,
-1.163980336296322397667856616504832603045e-11,
-3.823853291118470464428665901710261341867e-12,
-1.097743497131892352550721486800611273423e-12,
-2.793920127524259028386727861878890487045e-13,
-6.366138687480672774414383664190870379175e-14,
-1.30452947949282507010203424896831504495e-14,
-2.395838669332330066150520777333853368155e-15,
-3.864328833467500296960658939492597241685e-16,
-5.046867552694272540589279838963157448965e-17,
-3.641173001809392269464621206365667097738e-18,
-5.087145593510290904709213792665811219598e-7,
2.104378520609822904075337969658544732774e-11,
2.422663291655431450424403680997051694542e-11,
1.859321550925485130001469972515124437801e-11,
1.070148917325335030114470630039431649539e-11,
4.926720350066752933845626344936317018875e-12,
1.889549519706171175260287561625575534669e-12,
6.207938153627754436650930677767659556684e-13,
1.782437476296596074954449046528960505467e-13,
4.537983207405806037235157055364956373073e-14,
1.034665243510912453958349084842773697926e-14,
2.122968378069143845863627264812009439011e-15,
3.909664227592247027066801531449865367617e-16,
6.345795781069573621772662386290459924793e-17,
8.454226344566887375299336003607041871872e-18,
6.701226221472294810496379262871259050643e-19,
8.044927481851308616133251933809023774994e-8,
-3.14991273961003691184211700479326024868e-12,
-3.626341074984574828970253516262092319759e-12,
-2.783120106271219269212215574279913017489e-12,
-1.601863012423632377292698323894487745644e-12,
-7.374736263141748645722279223551684496477e-13,
-2.828536061923631868580567967399513489645e-13,
-9.293527480395238306713530259385637967849e-14,
-2.668745881587980341380003517237818262284e-14,
-6.796354085072306516672417202637522831627e-15,
-1.550446032276507013515668742625181572746e-15,
-3.18493897555069991825995358381871907872e-16,
-5.879607720986237085182864886868794345103e-17,
-9.595829806924539472015636838457029598845e-18,
-1.300312470694081960299748282219767062895e-18,
-1.108301556381963912047828559122531005171e-19,
-1.177612294252817135729673414669162784028e-8,
4.376516109718963787714763138528730542435e-13,
5.038479401543556417766988551793408951286e-13,
3.866913404192469474423804685834997713553e-13,
2.225672145996814059992023045573010013434e-13,
1.024681632846320855738650083406455629819e-13,
3.930225493971841990552325583896826614753e-14,
1.291406456518063579220591478745125050853e-14,
3.708881679942767278102263651490228853002e-15,
9.4475497564182740273775237110422131338e-16,
2.156341265475154004959358037477718495089e-16,
4.434131511199615925452718182440384211569e-17,
8.203332523736816694072417450042686892423e-18,
1.345338150548176536198927692168718074859e-18,
1.850010322793248623344821410827164966515e-19,
1.670814622274752413263326851270227919319e-20,
1.629182639256326985294639532348499065564e-9,
-5.754027872407883731453213358385280529549e-14,
-6.624356267961368368693769731097177312069e-14,
-5.084054166802436379533972035107379976736e-14,
-2.926240186632483219765797221156456551926e-14,
-1.347236521102132366242662574995526254519e-14,
-5.167549001490805504095607019880504287707e-15,
-1.698066130964076014619783649671833546234e-15,
-4.877348447620347148864418027110935492493e-16,
-1.24267877000452616081340846648925179156e-16,
-2.837640570834612407409472121636541588678e-17,
-5.840616613731594327362176375790707345769e-18,
-1.082670559495387709619384578442668716014e-18,
-1.783424052320164030437598403622490245563e-19,
-2.484824746046388643737695852021307349266e-20,
-2.355412846062740078387386674027562785729e-21,
-2.072451013325128374421701985880512076304e-10,
6.983162623790017608689500136300456571922e-15,
8.03941684094474741049475942290211145026e-15,
6.170102476685645680025486250352381319131e-15,
3.551361344796579584348082509865756693858e-15,
1.635061570883664027949248139566581221504e-15,
6.271704910564813222711581007973535229949e-16,
2.060995941057664930233970939855343624017e-16,
5.920378619884859998785100737059881776632e-17,
1.508729473460163554002722216783089832827e-17,
3.446557282181262347241010427998556739019e-18,
7.099802031266738624303677598686420309221e-19,
1.318353138141480429354741288550856047755e-19,
2.179995446255188058331590061691776548507e-20,
3.071629179235257074194210038537963377201e-21,
3.027868106725414817921107506554935403999e-22,
// [{0,0.0001},{2.,0.001}]: m=9 maxabserror=1.17853201346949308652e-20 maxrelerror=1.197539532056353297059e-18
0.02137940215436229661259797492132393113108,
-2.020414967871258428276980862005631898709e-6,
-2.325872491950927065102877516494573158369e-6,
-1.784841254663034649337819954154661367791e-6,
-1.02705520077018001479540625480736470113e-6,
-4.726246130457339047583612024654935974858e-7,
-1.811064656033868294477658323744869088797e-7,
-5.939578126211216562753259862786738645161e-8,
-1.699335928088392641790343982157091830174e-8,
-4.295422295466023420053968237613490400344e-9,
-9.650439830278018569115729088094014215791e-10,
-1.919775805210022615380250855569200778697e-10,
-3.30220646972165174664822029161355320452e-11,
-4.499190839555983981266902000849668779231e-12,
-2.432212449279519516790502360029093876331e-13,
1.063001542109442765348687198445389767322e-13,
-0.03834447619274881582234799368452072707187,
3.214254789659773867697137766635602512366e-6,
3.70024665011038779463236414675863617314e-6,
2.839582343557428686096431668762474010202e-6,
1.634063248969808560730244000394485910058e-6,
7.520242567849821034861150132499708256093e-7,
2.882242190589114943443699689705394785856e-7,
9.456156868213585833759149399283503158027e-8,
2.707483147346159245196503914048947695322e-8,
6.854208005389650797340332920035676344156e-9,
1.544796925516414163863595362462813572085e-9,
3.093917634850123122044666642252634151755e-10,
5.404785484683272722499546427797676780527e-11,
7.690828943561735835227301447382218157897e-12,
5.76359205898372032491425904043155369878e-13,
-1.125301377047356040472420441545685231124e-13,
0.034751080373584349340555501007661295804,
-2.616500046992925067526667802740025530178e-6,
-3.012139377042388202950614759736946259322e-6,
-2.311568362745095119031056150736679451266e-6,
-1.330261163097410535992356984242673761295e-6,
-6.12253769127630525523914964039041978395e-7,
-2.346893133179256290747527221080154950823e-7,
-7.702014658262545630134947439368831063627e-8,
-2.206534449448077089059138571349211791214e-8,
-5.592675812303193411708425291610865570839e-9,
-1.263566456165626468071791696027045889815e-9,
-2.543849096071551700137341105017061098964e-10,
-4.49602548242807364325860078359429268623e-11,
-6.600358782784358560532604056128918300579e-12,
-5.901523301941909982203277086215976722566e-13,
5.537688859914124031393738159649166550408e-14,
-0.02118007247521543360721197936405173206181,
1.447045799754545780123533507237721058001e-6,
1.665864810014284952137755896939356322644e-6,
1.278432356928064463967112122767242605638e-6,
7.357335662885370271370707079684347216176e-7,
3.386416968694185154972552839797022702665e-7,
1.29823392424890717802642195775532406079e-7,
4.26153052113443274037003864066072005386e-8,
1.221451934351296817131034431360918634251e-8,
3.098839180485845479825552796541106159447e-9,
7.014972508020240380547583820434778599708e-10,
1.418097601066055503653670582170500458436e-10,
2.52929756846646853456363283469100378472e-11,
3.801283259276509853727732267235513437077e-12,
3.802188754850932661365550427024122130213e-13,
-1.447500203480189525282047230175456099881e-14,
0.009752635665119609710553349898010792925967,
-6.097459749856322493116053150362896257688e-7,
-7.019545734162396061499827826055537153701e-7,
-5.387064622388627408731500191365235708569e-7,
-3.100311696691546271069682981150434840015e-7,
-1.42707219711413447720650632522365848316e-7,
-5.471418866405409842090872296761383312525e-8,
-1.796370064703643715674425830791454708949e-8,
-5.150789945989146953006544578690973479859e-9,
-1.307779813867319393847822200673451666226e-9,
-2.965195687403910035823971277771738170203e-10,
-6.014269585113515946560208887765373778557e-11,
-1.080560596734149321124779801849917690294e-11,
-1.653951516346503512989771608411307313715e-12,
-1.788480841668080873836821382824930113328e-13,
5.011307923477914986637316603150582262391e-16,
-0.003614979980856681212515236215814824262551,
2.083025133647923081364968591129430589036e-7,
2.398041716388272254783945324967402248385e-7,
1.840366110572481369745021317531691194214e-7,
1.059170886527181494072011990084166317547e-7,
4.875553170278337088740787573453823116965e-8,
1.86944418415863948491675698070481536657e-8,
6.138717924828746037428363842755974536211e-9,
1.760739149605610307210880000136194906652e-9,
4.47339444470124216634101732063864065014e-10,
1.01561818412241372927277468222175381488e-10,
2.065659020530045125988240591997259172386e-11,
3.733568105075728421341859662289723463438e-12,
5.799100975722779902336339391077386120597e-13,
6.641752945003040972498547013807836331601e-14,
1.428674227679500556546950161072761565598e-15,
0.001122617062650560531244640983136022242837,
-5.998156348612227006766478845754685796592e-8,
-6.905288555161504049847153571131678976358e-8,
-5.299476574236583536641392373055518627241e-8,
-3.050015800045517573632033161118624664883e-8,
-1.404024116061734961847325540932256486198e-8,
-5.383843579615659569554450062344452650625e-9,
-1.76813837054214290225131944772367428099e-9,
-5.072842531929896310585894666423707559544e-10,
-1.289529484760738114754654453578666597516e-10,
-2.930954898537049073069769979283137059213e-11,
-5.975093252008332693625978211212577636232e-12,
-1.085369951438612789919607243240423285661e-12,
-1.706178376436090155882596677206398148751e-13,
-2.042359927275632362365711487978016749726e-14,
-8.022911008130196394847498876652885221936e-16,
-0.0003002137536583271585298360452499322110624,
1.495163863914975954072464367014759433984e-8,
1.721291428255092847760017892847021712933e-8,
1.321017832965457489608697192714326172416e-8,
7.6029835667186084520483684889298215071e-9,
3.500008129816066962208175419629655251795e-9,
1.342183783639124685222862864253600674757e-9,
4.408451166577091552677453873978236616394e-10,
1.265091779212812166936806825440889103816e-10,
3.217402236104945106300852350024349170091e-11,
7.319767965296113004334759602955122137403e-12,
1.495171937888497486249293406224054042387e-12,
2.7274642215080973541165718433754612221e-13,
4.330610863348228276426252314283760645974e-14,
5.368761198844528415968883988246361321266e-15,
2.836761533564845672419232502254031854226e-16,
0.00007053584911496780412455221780628849034097,
-3.289443344467773593765655269274710604693e-9,
-3.786948331181014417445328092302355546835e-9,
-2.906339633124607006682415103866246216564e-9,
-1.672735050504619744866818056708637576691e-9,
-7.700572348286960919891379894907485730444e-10,
-2.953164583701221167119573837607799338213e-10,
-9.700747464721400502593618055940687527532e-11,
-2.784380119209031331537062187495863574988e-11,
-7.084151957766078227124904596351489389014e-12,
-1.613012316849564251071944539928092631591e-12,
-3.300436000189941396891734622338568345312e-13,
-6.042435884499613868998629874729164555257e-14,
-9.675600821216737587574173609266792046435e-15,
-1.234160731206054626893614640785774425984e-15,
-7.839090687734069330005313826786879697219e-17,
-0.00001478441238720411775611527610734563359071,
6.482065476568554698854538684090687788657e-10,
7.462452288236486388041428850003920606029e-10,
5.727181176915145266691270796348389546733e-10,
3.296297913464287208885981342477247119499e-10,
1.517510792121599199251397359568527149152e-10,
5.819898598754887592102504091944396678301e-11,
1.911925632473621066810253547103339643801e-11,
5.488714575225206007489412105778032284711e-12,
1.396959321941856073830912674011557888499e-12,
3.183067648494811111277394400822172722977e-13,
6.522643902682927768291783550066074017311e-14,
1.197918684710695458643916518260195305119e-14,
1.93216333825949611265823545517338980874e-15,
2.523432241529636870509460426764994189422e-16,
1.82058493683251327930037743343626405652e-17,
2.797930797677268108460877264806075055944e-6,
-1.157408408847599025991900205910498238113e-10,
-1.332465066579963795052068578154043375308e-10,
-1.022627049615370323398028010281076045679e-10,
-5.885820176920015188744755746852490599695e-11,
-2.709696713555416105527965088223155924523e-11,
-1.039252435697313978538674408651216576924e-11,
-3.414366641324593853770993588504439543257e-12,
-9.803408006753493505334771935612213327012e-13,
-2.495891245148407316378850371063016801112e-13,
-5.690659939056351772352782199839498327435e-14,
-1.167632834808161359635570428048251898296e-14,
-2.150315747705242459713371947613290834598e-15,
-3.49018838289033214325079689153361302929e-16,
-4.64982549936799050739820550972762940568e-17,
-3.685675480680733766605165829613474419239e-18,
-4.827561050015805673342233497793597926346e-7,
1.89014237348860783697205882861635672862e-11,
2.176028829318001933713344445152247403267e-11,
1.670044121536910122890028163811799016271e-11,
9.612168402938651749547368222365415739949e-12,
4.425297714345004642339280012087477619652e-12,
1.697296535083983913321200945529887473606e-12,
5.576691260490187716280923344876516444235e-13,
1.601412651906494445885864623922124877932e-13,
4.078233321432754797615120516528881874291e-14,
9.303637988221423463077421801476197893578e-15,
1.911161661160630204788257140502876089116e-15,
3.528133383880302803126228312944618998341e-16,
5.758109755440857363762748302564506813466e-17,
7.802745603330467379035464633370494659461e-18,
6.650696721747015749744854544537930184672e-19,
7.654252596909263604957136622231924173917e-8,
-2.844665342343210070642184219296785098788e-12,
-3.274930874293696259343742555629744636906e-12,
-2.51343174847279737913258032343497757494e-12,
-1.446651229393077514225107040086986351538e-12,
-6.660266404492672923931149858492285448181e-13,
-2.554583581720684205398866061780490360662e-13,
-8.393934955041293528668579457582738125267e-14,
-2.410713615696227057297213421348012347947e-14,
-6.140755721613007569014008540077533182881e-15,
-1.40158716194769552615338920582796997195e-15,
-2.882113979809344933654327669240091655349e-16,
-5.332032972138136319267878142383464393422e-17,
-8.744476319338557401704789519426919731957e-18,
-1.202474882220115764778040447974702184372e-18,
-1.08599613199577537687364707377657127206e-19,
-1.123063945762415669418522827887661397046e-8,
3.971890756574323989272579070767124695233e-13,
4.572660911321016263375672922356194289738e-13,
3.509420823031663581545503913340847847152e-13,
2.019924689769730866521828857840185474509e-13,
9.299699384321420916502542470486054224272e-14,
3.567051479542315642508643577941892890762e-14,
1.172138130438900737310855978316107263951e-14,
3.366718583071506878756366658469787571218e-15,
8.577872266393008980361512974249666207219e-16,
1.958724481325607129767282540326597586642e-16,
4.031484373304447999008109573244004427062e-17,
7.472783979602724963407674777239861907888e-18,
1.230823123462681277996385339373271098302e-18,
1.71436739984900627504448408401925208441e-19,
1.623302009491279611603116532160813646108e-20,
1.557136137413227424119473150135496534581e-9,
-5.246003639587293580708977635620508706031e-14,
-6.039499932430279903151759240348447187438e-14,
-4.635203592294601593548569999958907359524e-14,
-2.667910819436719754661074588566431768106e-14,
-1.228317308912643618943343302289080135024e-14,
-4.711531590995517514645513195394860803864e-15,
-1.548294921852767637440526719147746671077e-15,
-4.447604471497245595395609607723795235007e-16,
-1.133413287555200151475173898924151473635e-16,
-2.589184087562799708426949987779967271119e-17,
-5.33365224998788783042316109736852119829e-18,
-9.904039268351801764388988343494627407201e-19,
-1.637724830238196013351349678629353472905e-19,
-2.307639319416190832912466620961778339418e-20,
-2.275008673943793823008156784760856481295e-21,
-1.984659145565972944286790789418479363461e-10,
6.392488823311367204927425871631501336858e-15,
7.359409688837603145833348721675791839578e-15,
5.648225579134483741098711393737989985517e-15,
3.25099997444677656258275997080394243386e-15,
1.496790812596076636087484457927557051225e-15,
5.741460855548375964531760460119390267922e-16,
1.88683333802109138912259104404555080869e-16,
5.420573153154642396099876184320930226807e-17,
1.381612208726905840397671741020246744095e-17,
3.157331389584235491592150360651384779182e-18,
6.50890223184870945958712748080316128108e-19,
1.210519442911451441442804113142820273359e-19,
2.008624944973412824345547040352228732089e-20,
2.858567173537525828799702482965518208901e-21,
2.913110077081856194380459522119589163101e-22,
// [{0,0.0001},{2.,0.001}]: m=10 maxabserror=1.13086926705806908434e-20 maxrelerror=1.295669085291838349023e-18
0.01917223809637440790116502604114123049783,
-1.607127394829886933552287002698077341369e-6,
-1.850123325055193896975084080849546309653e-6,
-1.419791171778714342786427462247688935767e-6,
-8.170316244849042802144406309757656584328e-7,
-3.760121283924910516736810287446870232173e-7,
-1.441121095294557471455721795779308160138e-7,
-4.728078434106792916004921221289428578207e-8,
-1.353741573673079622346938151839266985761e-8,
-3.427104002694825398029406639425760491161e-9,
-7.723984627582070817852739068240634991911e-10,
-1.546958817425061560719875478676849727826e-10,
-2.702392742341636360685737209965032219093e-11,
-3.845414471780867916672137605648434847267e-12,
-2.881796029491860161094360357651673221093e-13,
5.626506885236780203826815147387391946268e-14,
-0.03475108037358434367370180303523510327506,
2.616500046992924892692079982308391578779e-6,
3.012139377042388001670480402309140770352e-6,
2.311568362745094964551476011711301818179e-6,
1.330261163097410447076700195684669094054e-6,
6.122537691276304845858944049292879688827e-7,
2.346893133179256133712311130832659163043e-7,
7.702014658262545114044234211350403243635e-8,
2.206534449448076940782234964888891105537e-8,
5.592675812303193033713116502748508987776e-9,
1.263566456165626381661425835703931177777e-9,
2.543849096071551521878767442017086453051e-10,
4.496025482428073311265014502165160522587e-11,
6.600358782784358007929206691715593390713e-12,
5.901523301941909188737174894044619665663e-13,
-5.537688859914124863354869673819527179163e-14,
0.0317701087128231548955956956724658441849,
-2.170568699631818802940362006934359342035e-6,
-2.498797215021427581042456879088901612192e-6,
-1.917648535392096813250219099025516487643e-6,
-1.103600349432805608221427409818197616748e-6,
-5.079625453041278043314107699500204888883e-7,
-1.947350886373360886283664565047790038518e-7,
-6.392295781701649502461166645879437822573e-8,
-1.832177901526945338302766503028257447529e-8,
-4.64825877072876850684369137908271798974e-9,
-1.052245876203036122735075752872669496264e-9,
-2.127146401599083391002877919880191083435e-10,
-3.793946352699703054573313343497393877991e-11,
-5.701924888914765202456132085904855405839e-12,
-5.703283132276399602666732132531136526874e-13,
2.171250305220283631622152419028546032365e-14,
-0.01950527133024017175191676516880406509686,
1.219491949971293879351609011496182014132e-6,
1.403909146832513037168586468218957766539e-6,
1.077412924477751441841797470765102796269e-6,
6.200623393383241963761655096057666260947e-7,
2.854144394228337750232536709945789465139e-7,
1.094283773281108357985502714630275191753e-7,
3.592740129407374159735318903166246327763e-8,
1.0301579891978543083469911603202202659e-8,
2.615559627734702309333477566938933128852e-9,
5.930391374807965283209449654406502701623e-10,
1.20285391702273314545747110540143491754e-10,
2.161121193468354433424859419645388586876e-11,
3.307903032693099890550628647241824649678e-12,
3.576961683336295089634999860425506574112e-13,
-1.002261584694184867061638320176891060795e-15,
0.009037449952141380084786042032911261052074,
-5.207562834119712108128412391442574622577e-7,
-5.995104290970570581767080459205011207104e-7,
-4.600915276431118958401369786406452857509e-7,
-2.647927216317905117868995655587272050958e-7,
-1.218888292569561887879581612507363203749e-7,
-4.673610460396512846133499334423288101464e-8,
-1.534679481207158288680704025916123872788e-8,
-4.40184787401394468167692713960006749624e-9,
-1.118348611175289867480584485710817652885e-9,
-2.539045460305987047304012110374707419916e-10,
-5.1641475513250152269546320090736491565e-11,
-9.333920262689139067035167355193265299613e-12,
-1.449775243930664597603849028115296647179e-12,
-1.660438236250716273119827772400296035132e-13,
-3.571685569198278793356416650615320959097e-15,
-0.00336785118790595821527626100177698704379,
1.799446904569562080819658969814870769188e-7,
2.071586566532211511568247561392418568383e-7,
1.589842972258511324446554492396222177627e-7,
9.150047400064813703658962774614943673184e-8,
4.21207234815217523141461747240623223997e-8,
1.61515307387202793983329558903288739329e-8,
5.304415111584789422565404963502190113973e-9,
1.521852759567005599829912956461488140096e-9,
3.868588454251716880797533970804669587524e-10,
8.792864695541429481310903000858802338424e-11,
1.792527975588117514718113062052911229259e-11,
3.256109854289052362998364787246460449315e-12,
5.118535129263685026012314923918071471791e-13,
6.127079781762877713847749625289303328204e-14,
2.406873302371931935651049027948001702012e-15,
0.001050748137812757868564715475919048431825,
-5.233073523727910398603412817147882816415e-8,
-6.024519998922175877864571373568313873294e-8,
-4.623562415401627664428296798670840004277e-8,
-2.661044248364478837613558750653068027675e-8,
-1.225002845441593166510699656426025182052e-8,
-4.697643242759836271508403735481465398942e-9,
-1.542957908309508290423920223963241606574e-9,
-4.427821227266467718240405558936879437799e-10,
-1.126090782642244419193997090830463432873e-10,
-2.561918787866247681869086466176660643425e-11,
-5.233101782635767213713864961850937948627e-12,
-9.546124775326875173813039133837515236859e-13,
-1.515713802179981488189774040060751928434e-13,
-1.879066419607311449418340417803355234557e-14,
-9.928665367602999080486294729998315313224e-16,
-0.0002821433974180820365417588543896274386365,
1.315777340743217688008256084623240534266e-8,
1.514779335875656086091599714148589024888e-8,
1.162535855861788009149265327645222933154e-8,
6.690940217052364028421035479923240310392e-9,
3.08022894623659685136756931363063028695e-9,
1.181265836135644559366225455508307097504e-9,
3.880298994614637740965315596898119414345e-10,
1.113752050190683205839966223711678692928e-10,
2.833660789497589501655815270975488618081e-11,
6.452049282008558720990954386496083590448e-12,
1.320174403089982747346465582601094561976e-12,
2.416974359413222094163085863283221243653e-13,
3.870240337830197963511370480564636096388e-14,
4.936642938240413149174922057977136758032e-15,
3.135636289161197478723748518540925769998e-16,
0.00006652985563413382691400437956908679865679,
-2.916929461250563798001792510514249812571e-9,
-3.358103526016295954397074573129607712669e-9,
-2.577231526779692944072525565058872252964e-9,
-1.483334059428803035255582537416719509941e-9,
-6.828798557041795011981994556710735261526e-10,
-2.618954366560628700677976369505636091631e-10,
-8.603665336668972805076191122664261577593e-11,
-2.469921556132537656456231171220468593417e-11,
-6.286316941806376407802835515776231374812e-12,
-1.432380440237516408216778795374053881346e-12,
-2.935189752935214613931737262943811385897e-13,
-5.390634075096169241682997073716227930952e-14,
-8.694735011982055089863351216322728461675e-15,
-1.13554450721402725737518988402788829626e-15,
-8.192632199900031655281847665017515026799e-17,
-0.00001398964376571796086545081191605501343706,
5.787038890557163430400717945824162698591e-10,
6.662321702192012902273508011443721536813e-10,
5.113132461561324475680732627724778619337e-10,
2.942908484591975519499305893909263322624e-10,
1.354847618334267669785367360585810089935e-10,
5.196259345872112885362159802835974914024e-11,
1.707182389733462079649513858600079087774e-11,
4.901701328744962225947452880657532765742e-12,
1.247944940742779383787671448361827311809e-12,
2.845328410849227826734379909371974044587e-13,
5.838160958591201272263102070882321852916e-14,
1.075157274997297818794066669466802641727e-14,
1.745093194645598236256978982031994109883e-15,
2.32491131839104833477504014739446798013e-16,
1.842836239544567014619396075741824279787e-17,
2.655159270580562442010182793491609449925e-6,
-1.039578510570654877474388386239912580442e-10,
-1.19681609230845774477517355872342913368e-10,
-9.185244481131775898024114868116512039475e-11,
-5.286693664966343169239165856829214886163e-11,
-2.433914223267353814276631098466032778632e-11,
-9.335132785689590536247045780509195370363e-12,
-3.067180798898448366296231632569836941919e-12,
-8.807771325636578890625555610227435148287e-13,
-2.243028770463963559612411366742203103672e-13,
-5.117001908084351903589815008949737564856e-14,
-1.051139123066873800880229623212243163303e-14,
-1.940473751685687487369069648513101449716e-15,
-3.166961017419544196056498082499506955886e-16,
-4.291511025453889552011246875293979369092e-17,
-3.657884211194491085152575385448602286223e-18,
-4.593131546396439893590696523944855765921e-7,
1.706978129059050874411922158592808720343e-11,
1.965164512289926094645847240274404987119e-11,
1.508217141663322327572088488130383112479e-11,
8.68081732870732412536246748823838737718e-12,
3.996578797579211472453145718228968983673e-12,
1.532910857029933667708536605785494984021e-12,
5.0368891342433404255391128398593881093e-13,
1.446579914294151134175191642481360637448e-13,
3.684840269129132185742889804547412183635e-14,
8.410407286205986128036468592950369734384e-15,
1.729450816039596289205621898196466022497e-15,
3.199559543257225413054574171202247457195e-16,
5.24725132526479298753683303351130272863e-17,
7.215661338237331164131852198025594182714e-18,
6.516828274930246496996286349194829115817e-19,
7.299697211532433318658239008482183970676e-8,
-2.581664334200111255302882155704480892321e-12,
-2.972155154568538185760182470028350030072e-12,
-2.281066404913017353317697981337037454346e-12,
-1.312918165165832729944686127093085597278e-12,
-6.044653199569113804083676138244729657955e-13,
-2.31852538459560085412453784130554208408e-13,
-7.618706972273598758861804902263061276471e-14,
-2.188312234794711750329856906865947721949e-14,
-5.575477140143450717287507915490992628782e-15,
-1.27313893696916725628330626020959611815e-15,
-2.620398837211775138117578137823751068051e-16,
-4.857186496888051811650115724680599942195e-17,
-8.000144835043367162608282504684871385105e-18,
-1.114309069796299675163779628211924120754e-18,
-1.055114340526952097677860632291660280306e-19,
-1.073337151634794186268053122362677018741e-8,
3.620813451104365585771453986871322449616e-13,
4.168487721562790071308617651905145474433e-13,
3.199236361129297946386269456647261618272e-13,
1.841402611329276103722167913349786552695e-13,
8.477892113125391342320771551730564623994e-14,
3.251914779368699484247226781406897623024e-14,
1.068636998522350624326091349559776891174e-14,
3.069740114417933311924015617823288267036e-15,
7.822788852880744993839805362246715543875e-16,
1.787030245971346845271580447950738159847e-16,
3.681160927938607095276011090394783368946e-17,
6.835244146724695708235139094219449637445e-18,
1.130164532373076632548919787368951644223e-18,
1.592024515319172312594251207381351405286e-19,
1.568050213934997645862791104371496123052e-20,
1.49118294134870831873640243776387818778e-9,
-4.802324856109856264454771223372505263812e-14,
-5.528719282264695145979892713340342994338e-14,
-4.243200914873210931314176241265265565647e-14,
-2.442297337025831281533026378816905510932e-14,
-1.124456586807375330766587550696028743886e-14,
-4.31324393773918092111163009312450218434e-15,
-1.4174743546313831161391179518426268231e-15,
-4.072180245817638449921341890903020334214e-16,
-1.037930261206086257835194208745620726674e-16,
-2.37193422648963307823442707044134270708e-17,
-4.889800812181025611265939837544845351379e-18,
-9.094046075560248089016711020337871409684e-19,
-1.508997662067483274797990417276190262859e-19,
-2.147585881361889135339787596001876294788e-20,
-2.18876699284267631574104071743090500795e-21,
-1.903993166398805174381456148776659962077e-10,
5.873623416490213688234093956952307877229e-15,
6.76206995665925565453701255235779959893e-15,
5.189790521814791413025670394472715832761e-15,
2.987149741738055746743133120622476589815e-15,
1.375325838520018765875605127636939474113e-15,
5.275648328938842404610550915600262065132e-16,
1.733823416532749744264815563445689130048e-16,
4.981411337877079732285954785842277375466e-17,
1.269888121266632476197172284790065732602e-17,
2.902987771305059310736160230846222747986e-18,
5.988670599434080420547895221670853125137e-19,
1.115349582326290189906511583574180745498e-19,
1.856512010516847017968856688687051268564e-20,
2.665758470783392969025026538977799568986e-21,
2.795253734784696948092188445752896640315e-22,
// [{0,0.0001},{2.,0.001}]: m=11 maxabserror=1.087351100312394647472e-20 maxrelerror=1.387072812209032968584e-18
0.0173755401867921718272182724687597966534,
-1.308250023496462446072010003356676989843e-6,
-1.506069688521194000519759619948145549515e-6,
-1.155784181372547482033610147030727132085e-6,
-6.651305815487052233989844148970715985486e-7,
-3.061268845638152422287801191749052889533e-7,
-1.173446566589628066610006478729725671264e-7,
-3.851007329131272556213098189384639496168e-8,
-1.103267224724038470158646258886617586466e-8,
-2.796337906151596516263757401254743529934e-9,
-6.317832280828131906951177499821911666497e-10,
-1.271924548035775760659323879109117445699e-10,
-2.248012741214036655109619444611284664649e-11,
-3.300179391392179003089506421051209568448e-12,
-2.950761650970954593092742157212209643726e-13,
2.768844429957062433078811078083804241175e-14,
-0.03177010871282314945011890978236296174699,
2.170568699631818641746680593560490558992e-6,
2.498797215021427395466339179391006085477e-6,
1.917648535392096670822908344018662703832e-6,
1.103600349432805526242453163229241564811e-6,
5.079625453041277665867809431429849524942e-7,
1.947350886373360741495329388393703809014e-7,
6.392295781701649026601435648661549754431e-8,
1.832177901526945201574194204285417697106e-8,
4.648258770728768158234995664827778728287e-9,
1.052245876203036043018053782706887980697e-9,
2.127146401599083226449096303798666358504e-10,
3.793946352699702747706484685718193746619e-11,
5.701924888914764690220584448480030835465e-12,
5.703283132276398861243391080573882824591e-13,
-2.171250305220284428512109783698436079335e-14,
0.02925790699536026194402522623465550528009,
-1.82923792495694094181217520212010224049e-6,
-2.10586372024876969711043075971576968234e-6,
-1.61611938671662727125305417386081686441e-6,
-9.300935090074863570099037243130075612954e-7,
-4.281216591342506912862596120808812009893e-7,
-1.641425659921662647270406671633831999708e-7,
-5.389110194111061602100519325289872189483e-8,
-1.545236983796781566683994942420711572622e-8,
-3.923339441602053729616827634673597972284e-9,
-8.895587062211948532376255845892087643353e-10,
-1.804280875534099843672808017211792982403e-10,
-3.241681790202531884428057144397449569053e-11,
-4.961854549039650227931622779800141980111e-12,
-5.365442525004443206123104958829264178474e-13,
1.503392377041271021380083547343109964566e-15,
-0.01807489990428367529821004278013635046232,
1.041512566823969510065131919154244603832e-6,
1.199020858194145302237295295535364625559e-6,
9.201830552862477264496552605507901083542e-7,
5.295854432635948000597628585537813237347e-7,
2.437776585139187205238528800796698653122e-7,
9.347220920793269007643246479022333309083e-8,
3.069358962414396545123727151140657553178e-8,
8.803695748028119134391109647304630554273e-9,
2.236697222350638318318353599962544095157e-9,
5.078090920612108058320574728122638708112e-10,
1.032829510265030698509503740170301530371e-10,
1.866784052537879382142631771023405558704e-11,
2.899550487861415276125018249924105446604e-12,
3.320876472501557142556539051967780427917e-13,
7.143371138397896778292833176464217405344e-15,
0.008419627969764584734366094522874763093125,
-4.498617261423816786194553465175816703274e-7,
-5.178966416330426989020052390937449862065e-7,
-3.974607430646200188492780023449694233911e-7,
-2.287511850016158459536775777436965252154e-7,
-1.053018087038023104325558053289500983779e-7,
-4.037882684679990429508105836448678981156e-8,
-1.326103777896171252621800118438396117141e-8,
-3.804631898917438992662324313900927359222e-9,
-9.671471135629100934602225345778004181054e-10,
-2.198216173885313620495551008932663916499e-10,
-4.481319938970203425355625882896638527827e-11,
-8.140274635722462197400018314233859965675e-12,
-1.279633782315893021406746972237383540723e-12,
-1.531769945440678263029665708410491162685e-13,
-6.017183255929377677198250382935206209617e-15,
-0.003152244413394336348274178695414842860385,
1.569922057105367633922756978751454095934e-7,
1.807355999661680045330150632175774162151e-7,
1.387068724608996928592406046910164389279e-7,
7.983132745027293946169233238805250015321e-8,
3.67500853629432624319949573337407576298e-8,
1.409292972816269017350514830376296134288e-8,
4.628873724890131385381635969847595062558e-9,
1.328346368168908730873515631100577988024e-9,
3.378272347898606679530320538902111475516e-10,
7.685756363534425439464065960173967002489e-11,
1.569930534777453562454949515995901870653e-11,
2.863837432573303755999090090941056971492e-12,
4.547141406498615889230913383201809320983e-13,
5.637199258762113829448751631287353588617e-14,
2.978599610216602532403878277710507565736e-15,
0.0009875018909715761051479090279837419170013,
-4.605220692624841779315528315057488593705e-8,
-5.301727675591942934298491601683209112341e-8,
-4.068875495537092772790447100749673688875e-8,
-2.341829075980319618934137230280288360538e-8,
-1.078080131188330379745805333964471283547e-8,
-4.134430426495936719634294633928363021235e-9,
-1.358104648122084696633749913493601517587e-9,
-3.898132175687395023964214307645988557437e-10,
-9.917812763292572893306060860341121322262e-11,
-2.258217248714663318457086377399473631653e-11,
-4.620610410839038365267755014930433781061e-12,
-8.459410257991271114548528590547085450775e-13,
-1.35458411824809939038093768974218252101e-13,
-1.727825028395123149436888332724480205602e-14,
-1.097472701218478020227231497236512477306e-15,
-0.0002661194234573154931769611447241924988332,
1.166771787225704757114080721318086676708e-8,
1.34324141354425834874173521645651731475e-8,
1.030892613120052713445295023720776728333e-8,
5.933336251576301026354160350614418244847e-9,
2.731519429198618730107112854852831733663e-9,
1.047581749072347560544648774925569986265e-9,
3.441466142713474837773919798432516201901e-10,
9.879686247648361736371990181335574494806e-11,
2.514526782616864265100721796156126652726e-11,
5.729521774428711549907268315278813860069e-12,
1.174075903956382346674758719068130861838e-12,
2.156253635227019985869864350071988687945e-13,
3.477894013453811767583641511413110804908e-14,
4.542178041392381646164480432750403288908e-15,
3.277052893434547927001479114737012645131e-16,
0.00006295339684151753418464688614444380332297,
-2.60416749778615922319675875766291981785e-9,
-2.998044762573412639875672943466346593964e-9,
-2.300909605083161480886032745491794357294e-9,
-1.324308816558676134449697848304786904702e-9,
-6.096814275562356663408455848768858139368e-10,
-2.338316702979512972964327974392660416233e-10,
-7.682320745048293646427281065569642426e-11,
-2.205765595420267476900101345853985226697e-11,
-5.615752226929352740499961347379105030854e-12,
-1.28039778341522993187018435087445118843e-12,
-2.62717242833624012283161646841413947441e-13,
-4.838207731831023318029862961910911169857e-14,
-7.852919366438011157410246155256062255682e-15,
-1.046210091895698508636132744664009152349e-15,
-8.292763062789501014645507799140680692608e-17,
-0.0000132757865295580648813065137545922245838,
5.197889645212826786599221851710479904569e-10,
5.984077114087089595326658748031058537247e-10,
4.592619671436575788251190248901559714807e-10,
2.643345353731757028299722845919026933341e-10,
1.216956430789276574444349795107104934803e-10,
4.667563781126769091706112062439421610819e-11,
1.533589541084834301249517586693282218247e-11,
4.403883196483283222068127325024273385155e-12,
1.121513756405089760462344151972668859828e-12,
2.558499516090926602153552763641058812805e-13,
5.255692647078167028231999999425188263987e-14,
9.702363223088079884289882271400907728829e-15,
1.583479584722472444519355308133054973583e-15,
2.145754175306753437075976923610786865765e-16,
1.828940668069648100078930291412706593202e-17,
2.526223017531125409468959685440182648337e-6,
-9.388381607272704891463706019837815578318e-11,
-1.080840700205615419957549824737635367737e-10,
-8.295195955698377457415378438913785116599e-11,
-4.774450495789720065039612685831524152915e-11,
-2.198118782976511823040489188349349480834e-11,
-8.431011418058713153120927785942804543441e-12,
-2.770289584017550691890669300727571299578e-12,
-7.956191138303329244772670413965287848506e-13,
-2.0266625584903449545807709506410354568e-13,
-4.625724946306535591910215666254983193732e-14,
-9.511981427419877546799223008122341005878e-15,
-1.759758110852040642824160898513177185835e-15,
-2.885988834836046841009577082771388712452e-16,
-3.968614619465691895020754300895558156053e-17,
-3.584256521587530195303252830113505788165e-18,
-4.380375659579882466950438596995110158785e-7,
1.549163565240026482155042825360102261741e-11,
1.783483010311609366069452969601662518469e-11,
1.368785602268990028589574500491832027607e-11,
7.878347959285148772543543762936842014674e-12,
3.627178196202855386036982384545537967358e-12,
1.391263406346572912068709644000034536305e-12,
4.571711175639343330984700232237547895453e-13,
1.313127268177144154110666285726249424285e-13,
3.345643048484761100052304077433641107721e-14,
7.639649442284478671238112829089627913672e-15,
1.572407706125859341577532376046743065848e-15,
2.914625945360247462833790903516129167947e-16,
4.800611125060062842193027424131962179522e-17,
6.686613205324521545150173056334631017472e-18,
6.331501630419154306082393493845943301656e-19,
6.976481262633019335782294121123348644921e-8,
-2.353468941478365664297454213582401487833e-12,
-2.709448171486758553126770304210066006135e-12,
-2.079450795016401015604122088172516953616e-12,
-1.196881283501682012984020622374495079418e-12,
-5.510489841292964657955769908838831786851e-13,
-2.113690889315201539700183990981361159548e-13,
-6.94596393766740075359896234546138570524e-14,
-1.995280342020669967961078892721167226802e-14,
-5.084683387026854333176892132958218772835e-15,
-1.161540068844102306354781019347280408324e-15,
-2.392693485450190724554498432137463958922e-16,
-4.442794584957619929005268484156438368942e-17,
-7.345878486496595216727991286833906398837e-18,
-1.034788091756780209649777592562851972322e-18,
-1.019202055683285323957990237203136309015e-19,
-1.027820611555973289244882888666015263611e-8,
3.314247448612039810904730171437701160067e-13,
3.815556773143886330398190730167283247106e-13,
2.92837672276213972866559521100392202768e-13,
1.685511907177027616871086046408994460946e-13,
7.76025262983506454764760679313014494757e-14,
2.9767128557914311825918536860702514934e-14,
9.782450149374749973778707160489640911916e-15,
2.810337283261567222375118920276286231797e-15,
7.163044581792503454291433871701820089823e-16,
1.636922561574767431591542202443137293953e-16,
3.374492858821138138880456399414455792638e-17,
6.275633877072370430287952700536392224974e-18,
1.041241970770045862985734125552197853996e-18,
1.481516750070325089198691192947959856512e-19,
1.508712020241683322533629505310793278482e-20,
1.430582369858064721022282073014828359201e-9,
-4.412578133124655241041531831672758911832e-14,
-5.080026420151592374530043465381907232718e-14,
-3.898846556372029474080251900295422358955e-14,
-2.24410573229623747889897874180129653166e-14,
-1.033217936115225114331985230372010261754e-14,
-3.963347923958297073907851627410153531212e-15,
-1.302540624362292429535590147899307855828e-15,
-3.74230278771839996793438098944754405309e-16,
-9.540083816296152258975428439264019481521e-17,
-2.180882978958455358286133392934724178199e-17,
-4.499025494506687179581002980966551230983e-18,
-8.37916690939996349708171840798605619473e-19,
-1.394734571129587041452172594842436218155e-19,
-2.002745878181907034160968944670730821333e-20,
-2.100204601905307325099111613384696799652e-21,
-1.82962033867042865699811652315781365713e-10,
5.415393044330445675771751762867353681122e-15,
6.234534820050853756478023053331013529924e-15,
4.784926227348268878360915508567567098704e-15,
2.754130130522366606062597087464401866664e-15,
1.268052270051480150136337334853175175445e-15,
4.864246527970847550719879104957929966551e-16,
1.598677980835106102255117567157403451083e-16,
4.593475333582871686713448479047165021425e-17,
1.171171427098558553212428855784290850262e-17,
2.678142041565031008438612254122546228501e-18,
5.528292287368039988859519195444362845857e-19,
1.030942135387937274098891569312084083179e-19,
1.720904312050976175313806677455923104298e-20,
2.490925447408567514686800072303540992603e-21,
2.677413996213140536367644323441208240262e-22,
// [{0,0.0001},{2.,0.001}]: m=12 maxabserror=1.047311771455036921926e-20 maxrelerror=1.472314978512889048597e-18
0.01588505435641157471577592233156907574289,
-1.085284349815909320619148711304446752504e-6,
-1.249398607510713697440527934535380394745e-6,
-9.588242676960483351868544879464760461829e-7,
-5.518001747164027629919493743590637745067e-7,
-2.539812726520638832338678729430280948232e-7,
-9.736754431866803705193285007625209882703e-8,
-3.196147890850824512550220573845086580071e-8,
-9.160889507634726005714282178031886035381e-9,
-2.324129385364384078567472013668070997635e-9,
-5.261229381015180213831831969127283178048e-10,
-1.063573200799541612964491331672169897535e-10,
-1.896973176349851373367170834608959521552e-11,
-2.85096244445738234429487184332940909286e-12,
-2.851641566138199429425010505503571160337e-13,
1.085625152610142215595936086836554938254e-14,
-0.02925790699536025670329922406471164244918,
1.829237924956940792724665173736688175052e-6,
2.105863720248769525471499190165137980768e-6,
1.616119386716627139522071400576877927313e-6,
9.300935090074862811872434045611086720633e-7,
4.281216591342506563758077361889316091435e-7,
1.641425659921662513351652203530836424961e-7,
5.389110194111061161949358297962106873913e-8,
1.54523698379678144020675419866848349119e-8,
3.923339441602053407100274482180040267487e-9,
8.895587062211947794663271983890916090589e-10,
1.804280875534099691304691686095498017033e-10,
3.241681790202531599947973619968755803865e-11,
4.961854549039649751829943229866560372818e-12,
5.365442525004442511990994620574872021708e-13,
-1.503392377041278645689959019969333655621e-15,
0.02711234985642551710704516477224517023142,
-1.56226885023595437899355017792741165135e-6,
-1.798531287291218084480152581097603215093e-6,
-1.380274582929371690311065396850258990173e-6,
-7.943781648953922580149989162555617721772e-7,
-3.656664877708781074561237290180771284364e-7,
-1.402083138118990453457291400480323660218e-7,
-4.604038443621595153961574646218533200612e-8,
-1.320554362204217966793620868056339852807e-8,
-3.355045833525957723928111430870466581887e-9,
-7.617136380918162651349917529013684940226e-10,
-1.549244265397546164288183272638347049376e-10,
-2.800176078806819291008576654310684236969e-11,
-4.349325731792123279554135275949306116902e-12,
-4.981314708752336250036217191433481175103e-13,
-1.071505670759685117110748371398121653821e-14,
-0.01683925593953005018914584754452198126438,
8.997234522847884112894604013111172908566e-7,
1.035793283266114241605006587185345114758e-6,
7.949214861292621749970212785149187928089e-7,
4.575023700032444338518117701457715028374e-7,
2.106036174076104875418925043487624194469e-7,
8.075765369360205908539272881853112793217e-8,
2.652207555792416472337340460341077617167e-8,
7.609263797835090529447875198759791225894e-9,
1.934294227125874385606784498358401736951e-9,
4.3964323477707512131720704279547589344e-10,
8.962639877940662904403651237172517614013e-11,
1.628054927144540246214451232815300361984e-11,
2.559267564631866051568263801491609563234e-12,
3.06353989088147317520371280751649028155e-13,
1.203436651186003663650285961627747253134e-14,
0.007880611033485541330485717980163487157702,
-3.924805142763337069698125982755496864676e-7,
-4.518389999154105692272277429600720547285e-7,
-3.467671811522419854221681937224892855693e-7,
-1.995783186256781775152722413195692554303e-7,
-9.187521340735623557879216489492662013239e-8,
-3.523232432040598870528322869212264768557e-8,
-1.157218431222508631493664254768987447632e-8,
-3.320865920422202241449467155412343174211e-9,
-8.445680869746339232553451569313692585991e-10,
-1.921439090883565756291599395020301166867e-10,
-3.924826336943549998562162629305671708124e-11,
-7.159593581433102558487229365588096461316e-12,
-1.136785351624627662647525631188540001636e-12,
-1.409299814690489846014677462801496980688e-13,
-7.446499025541074010853795712320894223318e-15,
-0.002962505672872443040443543932358125939496,
1.3815662077754237668663247317338774254e-7,
1.590518302663734606176049345307107861747e-7,
1.220662648650499434504996209368657923537e-7,
7.025487227879783167760889413410826190753e-8,
3.234240393536824480924667472956899734952e-8,
1.240329127937976103156894625096027573897e-8,
4.074313944330741550541820385734416735685e-9,
1.169439652696013994102953681719037290419e-9,
2.975343828961750389355118530883035172499e-10,
6.7746517460844693275576541922501265399e-11,
1.386183123239418041759335379913484800919e-11,
2.537823077374428693603602502913088913547e-12,
4.063752354705884876300031248831193756672e-13,
5.183475085129364434876305526641622091001e-14,
3.292418103593917230585039277929889466575e-15,
0.0009314179821085928104592093045370769499903,
-4.083701255311839499640219107730925917912e-8,
-4.701344947430085647996985029612678084002e-8,
-3.608124145939511002859784377546180795856e-8,
-2.076667688062829491981189919376805964672e-8,
-9.560318002246383964778662426979163021696e-9,
-3.666536121772864489769699666580451596461e-9,
-1.204513149956174123077107068911874206122e-9,
-3.457890186695484631584390009743198880269e-10,
-8.800843739206353930300368520508883804858e-11,
-2.005332621060877729717516250346406521755e-11,
-4.109265663869715774632143931857844863856e-12,
-7.546887723336395821427758752613511019555e-13,
-1.217262904715850724599497297865816129616e-13,
-1.589762314497630969544050435949560972924e-14,
-1.146968512713621507784915867590574434609e-15,
-0.0002518135882522307105043231972669898233799,
1.041667001635260738723716759735575274221e-8,
1.19921790793146539142650615199926270726e-8,
9.203638442605945277037904558002156576504e-9,
5.297235279054929399620212202750640980105e-9,
2.438725716127661537821587457752442641509e-9,
9.353266834561264293934278821499218184518e-10,
3.072928305461469014989114592115166860245e-10,
8.823062403066061270350244341870487062294e-11,
2.246300896224907922217240753472173230895e-11,
5.121591146134305609366106491908046088111e-12,
1.050868973910765884063536820809152286446e-12,
1.935283097542461362159206597346050942499e-13,
3.141167754625263361330478804708999353481e-14,
4.184840379319479533671281858532414233928e-15,
3.317105238007662497794287191209224072714e-16,
0.00005974103928257467462405138666807517299717,
-2.339050337595820775073961675527996152689e-9,
-2.692834698173270041588277509668598100223e-9,
-2.066678849716645431731488089779683993122e-9,
-1.189505407780715557278309349687060929791e-9,
-5.476303932112339916010502485900251567375e-10,
-2.100403699036809234568894579397814548465e-10,
-6.901152926762559628773904840542695572776e-11,
-1.981747436084280680067049026436420019849e-11,
-5.046811897872492469700502000486664545191e-12,
-1.151324780879486480137532176975378786005e-12,
-2.365061688371768898586210432526030828834e-13,
-4.366063445131101108031718599966046124965e-14,
-7.125658122429533379174768136040437739821e-15,
-9.655893775934032154911924166035775506037e-16,
-8.230232991817664326666258072962855947319e-17,
-0.00001263110563364582995864691760829414486229,
4.694188114355896601298426389641056978015e-10,
5.40420040495903131447679901078135358315e-10,
4.147595601650410373206234880409956302432e-10,
2.387223880185379327899896763338054521889e-10,
1.099058761764154293998009503920391692865e-10,
4.215503293366851571172528483575803582596e-11,
1.385143998052232022739130643393081079376e-11,
3.978093287720813899404809553935062570184e-12,
1.01333069748091952840897463068224573459e-12,
2.312861142445656602539533104781263756321e-13,
4.755987965248157963579450965156287356309e-14,
8.798785422713634562296370376992001546946e-15,
1.442993558606472562856627011205897289665e-15,
1.984306057615095477286795809875619025767e-16,
1.792126885428748660109501236896596443947e-17,
2.409207255609692352588240656444972005063e-6,
-8.520401368907164543648842858987482251679e-11,
-9.80915858303890847252234392984393204351e-11,
-7.528322367664636434955582490230043662872e-11,
-4.333092272755014634550613304091208094848e-11,
-1.994948420061148332295055706353064250339e-11,
-7.651950315963922674059794018771500661601e-12,
-2.514441666265003778191376610880750480724e-12,
-7.22220146832053543494101407654888252678e-13,
-1.840104057518539714767633984089764034552e-13,
-4.201808064630549212650911025821803498638e-14,
-8.648244184393388641678123264408384471083e-15,
-1.603044606517054522307443385849463939689e-15,
-2.640336683403184651557978573697797728953e-16,
-3.677638091552160592698831895546460336827e-17,
-3.482326824524291218374954755710501730291e-18,
-4.186425136039032828299238701302213414965e-7,
1.412233941088436906721485564785485628264e-11,
1.625844558225223691445896995983788553608e-11,
1.247805290536971720667570383008887201435e-11,
7.182063670348414058781370529979070152354e-12,
3.306651178452950621291382415826095941799e-12,
1.2683515860899455181486174811328379719e-12,
4.168028813482920461704800977045427261299e-13,
1.197297642089751749189871433118601540464e-13,
3.051140095916086839649881629558079424035e-14,
6.969995389509575814542213170188122442909e-15,
1.435772025163742502072200976955511094196e-15,
2.665967889192408503560427255466245979717e-16,
4.408014338805910042556357812986265704901e-17,
6.209438941027163866930204114899099928541e-18,
6.115992653047181169725477123280919168546e-19,
6.680631370498926077549486905455912640765e-8,
-2.154205369036402528255093193117931388326e-12,
-2.480048038973151067695083659289622177734e-12,
-1.903395855113077942957867526448589801351e-12,
-1.095554527331213955748415322289916917623e-12,
-5.044034312446997307640543255158143259589e-13,
-1.934813526157347019540816000713833144067e-13,
-6.358428815088459993266044050673970633071e-14,
-1.826672168411706758412618630449135225326e-14,
-4.65585894528091242963878523976742362707e-15,
-1.063972201975174086317991073320118448508e-15,
-2.193363605632683483033392761486116102005e-16,
-4.07905594384149773559090493805605122906e-17,
-6.767894858915807689850711190106072230733e-18,
-9.629597718318078624221233611691500939116e-19,
-9.80633571846217070204842401754305690727e-20,
-9.860020430231224863236757021999444384289e-9,
3.044982852927753880803160481535287678001e-13,
3.50556803144520287093194412458746978746e-13,
2.690472416852748279037593590719787149035e-13,
1.548587178797544944193795915816061762764e-13,
7.129911974038520352470612835763767606175e-14,
2.734980311980532476500028452965496082763e-14,
8.988409102893934680793250279421201035258e-15,
2.582436020483527101164113198042003364859e-15,
6.583260141703814446703713458263448975207e-16,
1.504934191796552424820231749228367885974e-16,
3.104531623203713292765281504550507607233e-17,
5.781798169638726702877786574447083644237e-18,
9.623198300605344917276197237490961953331e-19,
1.381518738807703064394055980985584442388e-19,
1.447731307454852140886080761400773502919e-20,
1.374708979838912834602448120272413012447e-9,
-4.068372508007128380632492437449345610159e-14,
-4.683761629669449429416735427063775530644e-14,
-3.594727540663520883647019053769329615241e-14,
-2.069070054283669671463858842092004643742e-14,
-9.526380120605711453198536788014019806808e-15,
-3.654318131005967749657041126784668839048e-15,
-1.201024362357016768866428140681687291085e-15,
-3.450899484993626419858902889711987464207e-16,
-8.798559701278341827040021086584717918729e-17,
-2.011986763477543373710073716715653926618e-17,
-4.153204491933336982546842416503027306771e-18,
-7.745122192951648566721302575091708123483e-19,
-1.292868508841004266236432994808980272604e-19,
-1.871408486924232484563296788314538725789e-20,
-2.01165961236914824957048988956312348272e-21,
-1.760832676987480558821370892393604468644e-10,
5.008714015474541238645952169452634261019e-15,
5.766347053644500354119314364445516260057e-15,
4.425607646450243420564466761634112067632e-15,
2.547322895470663002680618308076344465808e-15,
1.172844564716821446511893431516081982206e-15,
4.499107883231332713736001549086393876992e-16,
1.47872321278541726122084954261473846742e-16,
4.249105234046831063736777268708913871529e-17,
1.083520785687263336092607885114895305337e-17,
2.47840874222061093748671853278539855162e-18,
5.11894130126798645291350028262381005253e-19,
9.557384170850497761862267952054690547487e-20,
1.59951879660232346796007014167114075378e-20,
2.332053945256519764700412788287087952087e-21,
2.561634424612808634376350767865811377839e-22,
// [{0,0.0001},{2.,0.001}]: m=13 maxabserror=1.010269716974912265814e-20 maxrelerror=1.551932575345501461028e-18
0.01462895349768012834269078311607060178076,
-9.14618962478470396125902440906327789985e-7,
-1.052931860124384762463555796688480440915e-6,
-8.080596933583135695521291655626357039411e-7,
-4.650467545037431404733768616787093944883e-7,
-2.140608295671253281325395973419649554477e-7,
-8.207128299608312564634386362460125059916e-8,
-2.694555097055530580276581630964683323754e-8,
-7.726184918983907199027543129467977055022e-9,
-1.96166972080102670303842286676926712472e-9,
-4.447793531105973896160572382536674332095e-10,
-9.021404377670498454102262344913093041114e-11,
-1.620840895101265799520985497337647570879e-11,
-2.480927274519824875153363422230577602221e-12,
-2.682721262502221254871060529198433930636e-13,
7.516961885206393356516551143752832415455e-16,
-0.02711234985642551205624711394053321840095,
1.562268850235954240699157183029743195973e-6,
1.79853128729121792526677816109164533195e-6,
1.380274582929371568116316372505532151936e-6,
7.943781648953921876809912234076725767223e-7,
3.656664877708780750725117619999746357824e-7,
1.402083138118990329229672341782659981056e-7,
4.604038443621594745649227484686923791465e-8,
1.320554362204217849457722103104296701739e-8,
3.355045833525957424683389581773012460263e-9,
7.617136380918161966690000753388838537898e-10,
1.549244265397546022802748573079389322822e-10,
2.800176078806819026558475785676034792534e-11,
4.349325731792122835919625095452724197408e-12,
4.981314708752335598971533237228142272384e-13,
1.071505670759684388136709158095624876046e-14,
0.0252588839092950792979585059693319937439,
-1.349585178427182722871740624601377782077e-6,
-1.553689924899171484369724231550951241171e-6,
-1.192382229193893356100543241400271272176e-6,
-6.86253555004866704655973272028485761094e-7,
-3.159054261114157561199766177892133457753e-7,
-1.211364805404030981445607954792936607371e-7,
-3.978311333688625021303440394885754206585e-8,
-1.141389569675263669310486100665085544994e-8,
-2.901441340688811807694689340687175760612e-9,
-6.594648521656127344478107162502125533037e-10,
-1.344395981691099544147412138835756297626e-10,
-2.442082390716810572298653247436595835276e-11,
-3.838901346947799418607530851312459096195e-12,
-4.59530983632221026663480832057972695862e-13,
-1.805154976779006069310127270617660606931e-14,
-0.01576122206697193146407815459208050294463,
7.849610285526906542502702586331907588283e-7,
9.036779998308478941905499190141181636129e-7,
6.935343623045045056170736808732210858668e-7,
3.991566372513681746289989143727998610935e-7,
1.83750426814717913209077162315429287653e-7,
7.046464864081406505016057989670884652744e-8,
2.314436862445085879696197495317453353634e-8,
6.64173184084460166536311555419697362418e-9,
1.689136173949318134458594351392902364751e-9,
3.842878181767246569405991717385372458048e-10,
7.849652673887337762892713546200192515963e-11,
1.431918716286664952468049695445628870675e-11,
2.273570703249329878051987185242725512362e-12,
2.818599629381089103792000857078228160487e-13,
1.489299805108337307852285138576306754606e-14,
0.00740626418218081853751132817831225506262,
-3.453915519438483132694185134836074538976e-7,
-3.976295756659248691782882989290595236404e-7,
-3.051656621626181182317116210546379545541e-7,
-1.756371806969906994797312198161066850028e-7,
-8.085600983841882568823380667857403656909e-8,
-3.100822819844871730819446444475149313462e-8,
-1.018578486082662863434212166424367480541e-8,
-2.92359913173997025406964114528587974962e-9,
-7.438359572404210868108238837517180484702e-10,
-1.693662936521079547371753626341856169128e-10,
-3.465457808098466984176544605747904133137e-11,
-6.344557693435925572443486688931957160503e-12,
-1.015938088676446645643192625689472454663e-12,
-1.295868771282304828445147750194395947789e-13,
-8.23104525898437986191085156258432221761e-15,
-0.002794253946285025548587472018927869807539,
1.225110376582393868719593087406250955324e-7,
1.410403484216179910868827207458176480656e-7,
1.082437243771994284282312433192841685524e-7,
6.230003064131741017003584178660563883611e-8,
2.868095400647787178751433464325809734935e-8,
1.099960836521836312409047987805513579044e-8,
3.61353944983557857697128902694150755396e-9,
1.037367055999178397514341616736253148546e-9,
2.640253121737762266176218206821088296285e-10,
6.015997863127392871557099371473955481627e-11,
1.232779699149499277690735710124289651461e-11,
2.264066316979582124270480025382704961611e-12,
3.651788714111758339190588501950486660605e-13,
4.769286943440362627395451190885666355126e-14,
3.440905538082047183932644499578504853355e-15,
0.000881347558890516667395861888622526181884,
-3.645834505743757124649167930947434486847e-8,
-4.197262677783550829826049695501300038335e-8,
-3.221273454930057011373697049854579286635e-8,
-1.85403234767957221861421830435268107411e-8,
-8.535540006494455693979690575472058742311e-9,
-3.273643392114718197657864498860717829011e-9,
-1.075524906917521203446225463768430601955e-9,
-3.08807184109038480347430292999046179608e-10,
-7.862053136831210161720821487643847667625e-11,
-1.792556901157083832739322484690806140086e-11,
-3.678041408708514718733692468739255709618e-12,
-6.773490841437595056239616615828280180691e-13,
-1.099408714125395744997859065529168144803e-13,
-1.464694132771493551363906255913851353863e-14,
-1.160986833313702071992804967304105616792e-15,
-0.0002389641579843458089602327338798247630128,
9.356201373766423301522839165627302531875e-9,
1.077133881961325082653314340815359107926e-8,
8.266715419527556459549468673675459785308e-9,
4.758021643015101256376210982190649852965e-9,
2.190521578320433107550517767445615616185e-9,
8.401614817151934861700074967914446791105e-10,
2.760461177608865307741501374084501554373e-10,
7.92698976417655483309629905138924061322e-11,
2.018724764208698574179876584364263484296e-11,
4.60529913509434402006616132567560856767e-12,
9.46024677740979688013689401251732581639e-13,
1.746425382523837071688261664733857730692e-13,
2.850263256472933297420910957626238418066e-14,
3.862357521382123957659426942397514119932e-15,
3.292093209053204223394564785545793360627e-16,
0.00005683997525448240569523844915977544318293,
-2.112384648902347146565411464925446329292e-9,
-2.431890179286850689631133254866850316365e-9,
-1.866418018482640989069322653918206003291e-9,
-1.074250744782558600983717197977023508203e-9,
-4.945764421949141556604583678383776787036e-10,
-1.896976479717381223534724244761159985754e-10,
-6.233147983682714744186542039336735879386e-11,
-1.790141977303939638270593639010321402962e-11,
-4.559988133128183424998987179518086345023e-12,
-1.040787512833636347774468421183200357843e-12,
-2.140194581742311530080833921358047742532e-13,
-3.959453435320358158098854098895809647691e-14,
-6.493471005489682504834379390537489241232e-15,
-8.929377247103171294378371749624022407248e-16,
-8.064570970574230158106626069706217097951e-17,
-0.00001204602716663737465087174432973190555789,
4.260198189850744552725820475627972847351e-10,
4.90457641957267711080645205323170103938e-10,
3.7641589796405031424037092969818362415e-10,
2.16654486766795725763590180827149205112e-10,
9.974736258835927372380436939152008124166e-11,
3.825972917120423519731149796330450845603e-11,
1.257220096604274689953939835862950505231e-11,
3.611098617613686511170973208609321418429e-12,
9.200514889709115498644566408701694317738e-13,
2.100902797300662672533846652567274264315e-13,
4.324119540028517616056807395723127844214e-14,
8.015218262325396521990953274352526987689e-15,
1.320167541452390182552696052348799780016e-15,
1.838817871342292546540310163209362135716e-16,
1.741162097251295125291950466227828707092e-17,
2.302534445178863152425548656574313183973e-6,
-7.767288313092929111917189076077826905438e-11,
-8.942146954982498061840946565119566690133e-11,
-6.862930544478916984868344388035917986381e-11,
-3.950135851299558032034015267349335457967e-11,
-1.818658531506371072654052502055396536429e-11,
-6.975935194123218999284915589514114746842e-12,
-2.292416330797309182830462249071287197022e-12,
-6.585138420660435637598911294509739969628e-13,
-1.678127407078854201015943154914543684707e-13,
-3.833498275106873719494975793418542816287e-14,
-7.896747814904031171962053888181571906086e-15,
-1.466282652726820513395757019424190447987e-15,
-2.424408413703521466963867986686163191372e-16,
-3.41519219616296885622502981324470709741e-17,
-3.363796845967557177387011808218196577791e-18,
-4.008895763422915877678465611436410633498e-7,
1.292664752698187905608320662585433522604e-11,
1.488191763266311177477241348845568976357e-11,
1.142162567876736384905799557516582751927e-11,
6.574046966272129037335177485669476497118e-12,
3.026752003222665624941732565397640626333e-12,
1.161015250960651528085026751559471627491e-12,
3.815475158302948375095705533384059999185e-13,
1.096123383307731371530645779540590383626e-13,
2.793821616078777961275590537844067532063e-14,
6.384533897401334401369846376078497927215e-15,
1.316162960661824206026455306293317716038e-15,
2.447704207109251804434124490216625696024e-16,
4.061190937180648325960463291578080833467e-17,
5.778424947710577259247045795509583784022e-18,
5.884547507800420174914539793561913933128e-19,
6.408817761105612383802240933865040369595e-8,
-1.979187257796410573897492820269095139678e-12,
-2.278559819061866301743783463768987843221e-12,
-1.748761480878274272500617019630101876076e-12,
-1.006555424954809525431538773646444556469e-12,
-4.634321960607701135464927239199476316869e-13,
-1.777690853059832271891485620768887052077e-13,
-5.842313569704325818079738404187995367431e-14,
-1.678539631011374296639226606627972737129e-14,
-4.279007419665112680350739241921504848596e-15,
-9.781816683079921137513423526553165498371e-16,
-2.017892716799714805289443009506318925284e-16,
-3.758069950710290646828593394324808722683e-17,
-6.254912687443196196241342487407721898249e-18,
-8.979626411634990984334482456965043174272e-19,
-9.409974008009680441318661180828825432166e-20,
-9.474489355380474101581350546766970180785e-9,
2.807211134616315433987573294314187873355e-13,
3.231834690018420117714682162220494857691e-13,
2.480391912928256921971023143025276433437e-13,
1.427675381359845430318463084759549266892e-13,
6.573279174516211362460333653905252213196e-14,
2.521507791579177921563998949316261468541e-14,
8.287153058447710951290258096556621779922e-15,
2.381140453499255004882351541628044425165e-15,
6.071033121173042967122871453321151481e-16,
1.388266133114915655333803798129149590374e-16,
2.865655475015927824120747923232404680606e-17,
5.343853946048354780097767880146312068291e-18,
8.919678472223538376138286905826727178573e-19,
1.290848415228541877945318862289090414445e-19,
1.386733303131888458849564634287806971872e-20,
1.32303101613561107007288034066214795675e-9,
-3.762886174048805329457162789287017091806e-14,
-4.332071586884806757385257460632513992199e-14,
-3.324817095787223828569763954985422753956e-14,
-1.91372202368331446271166180549133903176e-14,
-8.811205426994468554987853465884611471622e-15,
-3.380035773532168925273038369692168756388e-15,
-1.11091754355947905891597124018016333273e-15,
-3.192217780497405063332982447851215852251e-16,
-8.140150866339494142102484377850671545453e-17,
-1.861952108893370820602484118360075225761e-17,
-3.84570946809557668482841556387705010787e-18,
-7.180206055678808086566994160335028694124e-19,
-1.201684834644182100789252967190468277824e-19,
-1.752060801646586335849635390135205536444e-20,
-1.924665877371162137560962502877998564595e-21,
-1.697024451801857798372934772739631529959e-10,
4.646140659103256962939278519513100911523e-15,
5.348935108477565017006296029127991738593e-15,
4.105256787564847391601018082819753293393e-15,
2.362942494081710710248497624694163539284e-15,
1.087960386281571689053817834421820789952e-15,
4.17355338017896394284904147689580790379e-16,
1.371767011207537297152989107323923788036e-16,
3.942019854770897655818190707696687514975e-17,
1.005343618513553807338124524213266688113e-17,
2.30018718148801419857339418221673884027e-18,
4.753357918826282852689226851723005014986e-19,
8.884511747599740969929398393929032460591e-20,
1.49045005119904456176774894321749603224e-20,
2.187371260771338664402888740964821262784e-21,
2.449223679815519419898018462865967851674e-22,
// [{0,0.0001},{2.,0.001}]: m=14 maxabserror=9.7585464451307165781e-21 maxrelerror=1.62642140551430021951e-18
0.01355617492821275601946750686846979262632,
-7.811344251179771201291128198032616347751e-7,
-8.992656436456089623795742929769614245678e-7,
-6.901372914646857838633570593441074508018e-7,
-3.971890824476960937283693403446840315797e-7,
-1.828332438854390374846292847099665859347e-7,
-7.010415690594951644167843889313889708546e-8,
-2.302019221810797372173618368961654332755e-8,
-6.60277181102108924541764412895528389811e-9,
-1.677522916762978711864427822684925252754e-9,
-3.808568190459080982252526270161561800624e-10,
-7.746221326987730111754006586129776421313e-11,
-1.400088039403409512856050951314354944258e-11,
-2.174662865896061417246890996923216454122e-12,
-2.490657354376167798427413069278609735535e-13,
-5.35752835379842192844369962521133702974e-15,
-0.02525888390929507442381742695722042428168,
1.349585178427182594240496439793706129539e-6,
1.553689924899171336281049624004991654864e-6,
1.192382229193893242443685379608759540153e-6,
6.862535550048666392360438086083838803872e-7,
3.159054261114157259987117532790950282975e-7,
1.211364805404030865894928187732477189758e-7,
3.978311333688624641499279195337930248715e-8,
1.141389569675263560160449080620800815982e-8,
2.901441340688811529293391393147093605755e-9,
6.594648521656126707353844771180175220748e-10,
1.344395981691099412420758103027591112948e-10,
2.442082390716810325840472457558973528932e-11,
3.838901346947799004249691366221744294783e-12,
4.595309836322209654877067860291244183142e-13,
1.805154976779005372551778197031706949422e-14,
0.02364183310045790107469038755696960209712,
-1.177441542829036080159850005230499776153e-6,
-1.355516999746271955013015440366894636744e-6,
-1.040301543456756845710457494587068769987e-6,
-5.987349558770523121840929831485969220053e-7,
-2.756256402220768929460259186129284069493e-7,
-1.056969729612211064493782398990039570105e-7,
-3.471655293667629111236820240480694117245e-8,
-9.962597761266903336371547145537825841346e-9,
-2.53370426092397741553766509555524772039e-9,
-5.764317272650870343615638630513436954622e-10,
-1.17744790108310076568629147593175761382e-10,
-2.147878074429997618320211572851400602878e-11,
-3.410356054873995136518212024213933679264e-12,
-4.227899444071634129907404142085997362454e-13,
-2.233949707662506510214969319780425408674e-14,
-0.01481252836436245619096179732220520205407,
6.907831038877182429928184621453266230031e-7,
7.952591513318746246277285365573698851219e-7,
6.103313243252553364749082114357031198122e-7,
3.512743613939923927651161740405614442061e-7,
1.617120196768427132488355560674437182531e-7,
6.201645639689937644320207967291648779735e-8,
2.037156972165389552881134507385412861403e-8,
5.847198263480123934562190655313433072459e-9,
1.487671914480888958908064643018425654873e-9,
3.387325873042266163371137009372761405121e-10,
6.930915616197155334836263568244280318872e-11,
1.268911538687226531778347862670076486418e-11,
2.031876177352962924189108765907043301841e-12,
2.591737542564712463203601645487229782209e-13,
1.646209051796993064148298175961564323894e-14,
0.0069856348657122845770786983984080204918,
-3.062775941455913538160218671485430600233e-7,
-3.526008710540367883419220930971733357925e-7,
-2.706093109429922857806199657251074030848e-7,
-1.557500766032899076527500166042707034811e-7,
-7.170238501619301372827351237044266821008e-8,
-2.749902091304526879293130449577103456061e-8,
-9.03384862458873639770951176822003675349e-9,
-2.593417639997885626748622768731149157294e-9,
-6.600632804344251674462028886919282667694e-10,
-1.503999465781812969027103285392019716841e-10,
-3.081949247873675283435995176411718212923e-11,
-5.660165792448818768595938650972536906974e-12,
-9.129471785279165822231080493860789811845e-13,
-1.192321735860056508737924505329633058148e-13,
-8.602263845204723034304158832934452511372e-15,
-0.002644042676632222441304107369630228237422,
1.093750351712748779363852679984074502263e-7,
1.259178803323117006539884371595379441106e-7,
9.663820364698469241593683539713354882253e-8,
5.56209704298593387675795751817046569324e-8,
2.560662001924033959882232228783820743853e-8,
9.820930176250924805316478470285332828284e-9,
3.226574720721919859585824331403382851979e-9,
9.264215523183088847685126355279805307759e-10,
2.358615941026900784251428701221399671069e-10,
5.377670703419846361306309421259948445465e-11,
1.10341242260192630074635407981333432283e-11,
2.032047252411393487585301837167802294521e-12,
3.298226142342755457970093959042684152766e-13,
4.394082398265121711719970237935028679303e-14,
3.48296049988488820102353371799680342985e-15,
0.0008363745529526589738890544437322495324986,
-3.274670480837219011840418052330027511158e-8,
-3.769968586886478294636383328640083664128e-8,
-2.893350396851407200494348260938364895617e-8,
-1.665307575064933791829690369113474156645e-8,
-7.666825524165940039911789571298105852252e-9,
-2.940565186020219357103474681795028644621e-9,
-9.66161412168704607155373708704363491919e-10,
-2.774446417477893669007328848708424852487e-10,
-7.065536674771513354950776131064418182499e-11,
-1.611854697292421038900786326015357120336e-11,
-3.311086372112873721807437294973908670404e-12,
-6.112488838869844604347377660634085840179e-13,
-9.975921397716612880531544125640343837824e-14,
-1.351825132492850468598320530594272714565e-14,
-1.152232623179153918463279246570040661082e-15,
-0.0002273599018421070526122569545115643263497,
8.449538617358737868178011023014485489711e-9,
9.727560742186671662600582386199140715748e-9,
7.465672093148000003844283884425209892452e-9,
4.297002990191628677893168359254430701144e-9,
1.978305773872648813802397477746022670949e-9,
7.587905938407174581741771754669703591705e-10,
2.493259199894926904972907062820237714037e-10,
7.160567927671170827265323967645698355668e-11,
1.823995257958565890290436480924036983627e-11,
4.163150062107236596127900877816634023011e-12,
8.560778349242004439125791952817672346971e-13,
1.583781378295341411003515237422522592308e-13,
2.597388409201995188357597321733675699133e-14,
3.571750909185184615923669533866490164623e-15,
3.225828400011099584854823892768303972671e-16,
0.00005420712215621995941104205436269763762439,
-1.917089183047733381609153475372274691451e-9,
-2.207059386061817804573092228512901405332e-9,
-1.693871538730776854284800412647955736227e-9,
-9.749451892375463977882890097541315995816e-10,
-4.488631310890960995280398877368375230161e-10,
-1.721687810561573876771012574266220426163e-10,
-5.657490427676463848688772078907713854498e-11,
-1.62499437590205994192581430694325861076e-11,
-4.140231695205804100570297604660316158326e-12,
-9.454062576034082631022720520515862416287e-13,
-1.945853790568142870081647386158561928128e-13,
-3.606848213468187503827754201765467762245e-14,
-5.940753928823012835620767853535030295688e-15,
-8.274680409590464634974274838191106343317e-16,
-7.835229424388921712742091807143364908791e-17,
-0.00001151266343314465732648177270504624906675,
3.883641836240867660811557460885117089218e-10,
4.471070806204166243458470905770371191448e-10,
3.431463222048260727842489956126910986711e-10,
1.975066745576998048551444090246222844153e-10,
9.093287224128685321021504194837785471438e-11,
3.487965512708753308729946640760516371361e-11,
1.146207480291542208255389394167026761805e-11,
3.292567241434629514740595860969555535777e-12,
8.390632013470264160483391728519882104171e-13,
1.91674798828047132316241834039233513605e-13,
3.94837153130643225127120964368733919266e-14,
7.331408817901690818252026010994599793163e-15,
1.212203459410361295740153762657866467164e-15,
1.707594994548853376045199523946679148059e-16,
1.681897166087398287966595504520263373421e-17,
2.204893269274720905419786853352369825058e-6,
-7.109657666408589642594259236062012872608e-11,
-8.185056455451468269082608399400302277611e-11,
-6.281895472181210732475205012858236691064e-11,
-3.615726607844300533530993245483620739063e-11,
-1.664713959249905407532484137641884243793e-11,
-6.385585251651248215232441633176835433258e-12,
-2.098511787834607449684599933809194808191e-12,
-6.028679903703717503322751095596979585266e-13,
-1.536602219316804119737399748074443463792e-13,
-3.511494400031618049157836793572976804738e-14,
-7.238897848347915277092285397560690284418e-15,
-1.346237606937438233963200464320016088125e-15,
-2.233655509098604192853438320096301656604e-16,
-3.178134454081845275724705181238689650075e-17,
-3.236501976832207823762315786025196890421e-18,
-3.845789518520747813464162876412418464529e-7,
1.187643997288874285333030201890961668686e-11,
1.367287446993824648375454137586481115807e-11,
1.049373206189139949754311157853435432401e-11,
6.040002064393405337929829674725075332868e-12,
2.780901440665433189500539214654364507478e-12,
1.066732767661590558420547694488069339842e-12,
3.505776837563858053211434953523109611942e-13,
1.007235483963176536783814447208694930888e-13,
2.567689370832079604976130045295162004367e-14,
5.869742050302637506891440608541331058506e-15,
1.210870440806139738111968578667321764007e-15,
2.255094199316192259398167819529243453515e-16,
3.753371674010333280842903326635743641555e-17,
5.388401938116207594363992073472119124873e-18,
5.646697510054347577351478173126210060682e-19,
6.158229170070775832527036803875843179342e-8,
-1.824639124701253626471735500281241631969e-12,
-2.100637157873040746301291929267190596095e-12,
-1.612212231463825696010515789021573994983e-12,
-9.279645282857920583464762369783509651034e-13,
-4.272518797415634515659683668017533068381e-13,
-1.638936843187202139216285229278097162132e-13,
-5.386507419626704162881859812004508173704e-14,
-1.547700464200199154262659697758905795105e-14,
-3.94606737356846952486280824701506574396e-15,
-9.023491451765622725714691094852332183279e-16,
-1.86262674392085334981265317903759475128e-16,
-3.473412711602904325133900617832576651147e-17,
-5.797635423650261485857710789545980032738e-18,
-8.390283729554193139194456792526493089299e-19,
-9.013499350225322389413966616601280086092e-20,
-9.11793621250478100251152907876255583114e-9,
2.596210832422704550931110959784356111708e-13,
2.988921361481699882456442898565291400706e-13,
2.29396400450305311185149205761888546405e-13,
1.320376074759035835001925487349063317048e-13,
6.079306236777162022828898209040285703203e-14,
2.332060412684959169074332609543818671574e-14,
7.664784274060596017074349314467402766815e-15,
2.202469197927215261092810841116559698621e-15,
5.616273108488911150737089703255312918934e-16,
1.284639014848592363816928531408999250654e-16,
2.653277206023526455743189291788375178852e-17,
4.95370075415868558591531324456051045476e-18,
8.289997682998783392170798612534163962012e-19,
1.208460362085185084630049802173369729697e-19,
1.326784677961033566644384986887140728725e-20,
1.275093518716195994795435796826327259413e-9,
-3.490527360823475555097071341919287605445e-14,
-4.018518976004379135242224421643505650172e-14,
-3.084175086680976475099751788058681246558e-14,
-1.77521866150328373307732569255503676901e-14,
-8.173570166076732831546692490732718511276e-15,
-3.135484846181385840698746659221769539935e-15,
-1.03057387811205538624174260314904039892e-15,
-2.961540439698295906969374434709020552716e-16,
-7.552896870276016496877249654429356547567e-17,
-1.728074850295080944751499413780492727673e-17,
-3.571088256774380899082640284644602740024e-18,
-6.674750934992821292498251740304150205134e-19,
-1.11975250453603059676628000095360305728e-19,
-1.643371288396822649892677619475551581911e-20,
-1.840205560996549984113369153498615316033e-21,
-1.637674387826546064871864656712676284568e-10,
4.321523511332625238281217313152755456134e-15,
4.975219624526410624910851956513082166783e-15,
3.818440765452465929718787956673008796227e-15,
2.197862340135287973362588430120723352077e-15,
1.011960656578725539149925293227269501565e-15,
3.882066246025346285521683005990948206629e-16,
1.275998561429605797794795459084132851925e-16,
3.667029560403837671924973401025402218876e-17,
9.353236042195799405055054356605856103041e-18,
2.140498931072198098730922065024138951891e-18,
4.425527109397120