/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Benchmark;
import com.google.caliper.ConfigurationException;
import com.google.caliper.ConfiguredBenchmark;
import com.google.caliper.Parameter;
import com.google.caliper.Scenario;
import com.google.caliper.TypeConverter;
import com.google.caliper.UserException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class SimpleBenchmark
extends com.google.caliper.api.Benchmark
implements Benchmark {
    private static final Class<?>[] ARGUMENT_TYPES = new Class[]{Integer.TYPE};
    private final Map<String, Parameter<?>> parameters = Parameter.forClass(this.getClass());
    private final Map<String, Method> methods = this.createTimedMethods();

    protected SimpleBenchmark() {
        if (this.methods.isEmpty()) {
            throw new ConfigurationException("No benchmarks defined in " + this.getClass().getName());
        }
    }

    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Override
    public Set<String> parameterNames() {
        return ImmutableSet.builder().add((Object)"benchmark").addAll(this.parameters.keySet()).build();
    }

    @Override
    public Set<String> parameterValues(String parameterName) {
        if ("benchmark".equals(parameterName)) {
            return this.methods.keySet();
        }
        Parameter<?> parameter = this.parameters.get(parameterName);
        if (parameter == null) {
            throw new IllegalArgumentException();
        }
        try {
            Iterable<?> values = parameter.values();
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (Object value : values) {
                result.add((Object)String.valueOf(value));
            }
            return result.build();
        }
        catch (Exception e) {
            throw new UserException.ExceptionFromUserCodeException(e);
        }
    }

    @Override
    public ConfiguredBenchmark createBenchmark(Map<String, String> parameterValues) {
        if (!this.parameterNames().equals(parameterValues.keySet())) {
            throw new IllegalArgumentException("Invalid parameters specified. Expected " + this.parameterNames() + " but was " + parameterValues.keySet());
        }
        String methodName = parameterValues.get("benchmark");
        final Method method = this.methods.get(methodName);
        if (method == null) {
            throw new IllegalArgumentException("Invalid parameters specified. \"time" + methodName + "\" " + "is not a method of this benchmark.");
        }
        try {
            final SimpleBenchmark copyOfSelf = (SimpleBenchmark)this.getClass().newInstance();
            for (Map.Entry<String, String> entry : parameterValues.entrySet()) {
                String parameterName = entry.getKey();
                if ("benchmark".equals(parameterName)) continue;
                Parameter<?> parameter = this.parameters.get(parameterName);
                Object value = TypeConverter.fromString(entry.getValue(), parameter.getType());
                parameter.set(copyOfSelf, value);
            }
            copyOfSelf.setUp();
            return new ConfiguredBenchmark(copyOfSelf){

                @Override
                public Object run(int reps) throws Exception {
                    try {
                        return method.invoke((Object)copyOfSelf, reps);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof Exception) {
                            throw (Exception)cause;
                        }
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        throw e;
                    }
                }

                @Override
                public void close() throws Exception {
                    copyOfSelf.tearDown();
                }
            };
        }
        catch (Exception e) {
            throw new UserException.ExceptionFromUserCodeException(e);
        }
    }

    public Scenario normalizeScenario(Scenario scenario) {
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>(scenario.getVariables());
        String benchmark = (String)variables.get("benchmark");
        Map<String, Method> timedMethods = this.createTimedMethods();
        if (timedMethods.get(benchmark) == null) {
            char[] benchmarkChars = benchmark.toCharArray();
            benchmarkChars[0] = Character.toUpperCase(benchmarkChars[0]);
            String upperCasedBenchmark = String.valueOf(benchmarkChars);
            if (timedMethods.get(upperCasedBenchmark) != null) {
                variables.put("benchmark", upperCasedBenchmark);
            } else if (benchmark.startsWith("time")) {
                variables.put("benchmark", benchmark.substring(4));
            }
        }
        return new Scenario(variables);
    }

    private Map<String, Method> createTimedMethods() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Method method : this.getClass().getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (!method.getName().startsWith("time")) continue;
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || !Arrays.equals(method.getParameterTypes(), ARGUMENT_TYPES)) {
                throw new ConfigurationException("Timed methods must be public, non-static, non-abstract and take a single int parameter. But " + method + " violates these requirements.");
            }
            result.put((Object)method.getName().substring(4), (Object)method);
        }
        return result.build();
    }

    @Override
    public Map<String, Integer> getTimeUnitNames() {
        return ImmutableMap.of((Object)"ns", (Object)1, (Object)"us", (Object)1000, (Object)"ms", (Object)1000000, (Object)"s", (Object)1000000000);
    }

    @Override
    public double nanosToUnits(double nanos) {
        return nanos;
    }

    @Override
    public Map<String, Integer> getInstanceUnitNames() {
        return ImmutableMap.of((Object)" instances", (Object)1, (Object)"K instances", (Object)1000, (Object)"M instances", (Object)1000000, (Object)"B instances", (Object)1000000000);
    }

    @Override
    public double instancesToUnits(long instances) {
        return instances;
    }

    @Override
    public Map<String, Integer> getMemoryUnitNames() {
        return ImmutableMap.of((Object)"B", (Object)1, (Object)"KiB", (Object)1024, (Object)"MiB", (Object)0x100000, (Object)"GiB", (Object)0x40000000);
    }

    @Override
    public double bytesToUnits(long bytes) {
        return bytes;
    }
}

