//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// <cuda/std/complex>

// template<class T>
//   bool
//   operator==(const complex<T>& lhs, const complex<T>& rhs);

#include <cuda/std/complex>
#include <cuda/std/cassert>

#include "test_macros.h"

template <class T>
__host__ __device__ void
test_constexpr()
{
#if TEST_STD_VER > 11
    {
    constexpr cuda::std::complex<T> lhs(1.5,  2.5);
    constexpr cuda::std::complex<T> rhs(1.5, -2.5);
    static_assert( !(lhs == rhs), "");
    }
    {
    constexpr cuda::std::complex<T> lhs(1.5, 2.5);
    constexpr cuda::std::complex<T> rhs(1.5, 2.5);
    static_assert(lhs == rhs, "");
    }
#endif
}

template <class T>
__host__ __device__ void
test()
{
    {
    cuda::std::complex<T> lhs(1.5,  2.5);
    cuda::std::complex<T> rhs(1.5, -2.5);
    assert( !(lhs == rhs));
    }
    {
    cuda::std::complex<T> lhs(1.5, 2.5);
    cuda::std::complex<T> rhs(1.5, 2.5);
    assert(lhs == rhs);
    }
    test_constexpr<T> ();
}

int main(int, char**)
{
    test<float>();
    test<double>();
// CUDA treats long double as double
//  test<long double>();
//    test_constexpr<int> ();

  return 0;
}
