/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Controller;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;

public class DocumentNodeTest
extends NodeTest {
    private NodeTest elementTest;

    public DocumentNodeTest(NodeTest nodeTest) {
        this.elementTest = nodeTest;
        this.originalText = "document-node(" + nodeTest.originalText + ")";
    }

    public boolean matchesItem(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            return this.matches(nodeInfo, null);
        }
        return false;
    }

    public boolean matches(int n, int n2, int n3) {
        return n == 9;
    }

    public boolean matches(NodeInfo nodeInfo, Controller controller) {
        if (nodeInfo.getNodeKind() != 9) {
            return false;
        }
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3);
        boolean bl = false;
        while (true) {
            NodeInfo nodeInfo2;
            if ((nodeInfo2 = (NodeInfo)axisIterator.next()) == null) {
                return bl;
            }
            int n = nodeInfo2.getNodeKind();
            if (n == 3) {
                return false;
            }
            if (n != 1) continue;
            if (bl) {
                return false;
            }
            if (!this.elementTest.matchesItem(nodeInfo2)) break;
            bl = true;
        }
        return false;
    }

    public final double getDefaultPriority() {
        return this.elementTest.getDefaultPriority();
    }

    public int getNodeKind() {
        return 9;
    }

    public boolean allowsTextNodes() {
        return false;
    }

    public String toString() {
        return this.originalText;
    }
}

