### NAME

ed25519-cli - command-line interface for the lib25519 implementation of the Ed25519 signature system

### SYNOPSIS

Key generation:

    ed25519-keypair 5>publickey 9>secretkey

Signature generation:

    ed25519-sign 8<secretkey <message >signedmessage

Signature verification and message recovery:

    ed25519-open 4<publickey <signedmessage >message

### DESCRIPTION

lib25519 is an implementation
of the X25519 encryption system
and the Ed25519 signature system.
The command-line interface for lib25519
provides three Ed25519 tools,
documented here,
and two X25519 tools,
documented separately.

Each tool exits nonzero on failure (e.g., running out of memory), 0 on success.

These tools allow lib25519
to be easily used from shell scripts.
Other languages can also use lib25519 via these tools,
but languages typically have good support for FFI
and can use the C interface directly.

### KEY GENERATION

Alice runs the `ed25519-keypair` command.
This command randomly generates
Alice's secret key and Alice's corresponding public key.
It writes the public key to file descriptor 5,
and then writes the secret key to file descriptor 9.

### SIGNATURE GENERATION

Alice runs the `ed25519-sign` command.
This command reads Alice's secret key from file descriptor 8.
It then reads a message (into memory) from standard input (file descriptor 0).
It signs the message using Alice's secret key,
and then writes the signed message to standard output (file descriptor 1).

### SIGNATURE VERIFICATION AND MESSAGE RECOVERY

Bob runs the `ed25519-open` command.
This command reads Alice's public key from file descriptor 4.
It then reads a signed message (into memory) from standard input (file descriptor 0).
It verifies the signed message using Alice's public key,
and then writes the verified message to standard output (file descriptor 1).

For `ed25519-open`,
exit code 100 specifically indicates an invalid signature;
retrying on the same input will then always fail.
In this case, `ed25519-open` produces an empty output.

### SEE ALSO

**x25519-cli**(1), **lib25519**(3)
