<?php
/*
 * LTSP-Cluster Control Center
 * Copyright (2009) Stéphane Graber <stgraber@ubuntu.com>, Revolution Linux Inc.

 * Author: Stéphane Graber <stgraber@ubuntu.com>

 * 2009, Stéphane Graber <stgraber@ubuntu.com>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of·
 * the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, you can find it on the World Wide
 * Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

    require "loadbalancer.data.php";
    function loadbalancer_appservlist() {
        global $config;

        # Jquery
        $content= "
            <script type=\"text/javascript\">
                $(document).ready(function() {
                    $(\"tr.toggle_detail\").toggle();
                    $(\"a.toggle_detail\").click(function() {
                        $(this).parent().parent().next(\"tr.toggle_detail\").toggle();
                    });
                });
            </script>
        ";

        # Generate a block containing a list of all application servers
        $lbserver = LoadBalancer::getInstance($config['loadbalancer']['host'],$config['loadbalancer']['port']);
        $content.="<b>"._("Server list from")." ".$config['loadbalancer']['host']."</b><br /><br />";
        $server_id=0;
        $group_id=0;
        foreach ($lbserver->getStatusRaw() as $group_name => $group_content) {
            if (count($group_content) == 0) {
                continue;
            }

            $content.= "<div style=\"font-weight:bold;padding-bottom:0.5em;\">"._("Group").": ".$group_name."</div>";
            $content.= "
                <form class=\"filter\" action=\"#\"><p style=\"font-weight:bold\">"._("Search").": <input onkeyup=\"javascript:filterTable(this,'listing$server_id')\" /></p></form>
                <table class=\"listing\" id=\"listing$server_id\">
                    <tr class=\"trheader\">
                        <td><b>"._("Server name")."</b></td>
                        <td><b>"._("Status")."</b></td>
                        <td><b>"._("Number of users")."</b></td>
                    </tr>
            ";
            foreach ($group_content as $server_name => $server_content) {
                foreach ($server_content as $attribute_name => $attribute_content) {
                    switch ($attribute_name) {
                        case "active":
                            if ($attribute_content == "1") {
                                $server_attribute[$attribute_name]="<span style=\"color:green;font-weight:bold;\">"._("Active")."</span>";
                                $server_disabled=false;
                            }
                            else {
                                $server_attribute[$attribute_name]="<span style=\"color:red;font-weight:bold;\">"._("Inactive")."</span>";
                                $server_disabled=true;
                            }
                        break;
                        case "MEMFREE":
                        case "MEMUSED":
                        case "MEMTOTAL":
                            $server_attribute[$attribute_name]=round($attribute_content/1024)."MB";
                        break;
                        case "LOADAVG":
                        case "NBUSERS":
                            if ($attribute_content == Null) {
                                $server_attribute[$attribute_name]="0";
                            }
                            else {
                                $server_attribute[$attribute_name]=$attribute_content;
                            }
                        break;
                        default:
                            $server_attribute[$attribute_name]=$attribute_content;
                        break;
                    }
                }
                $content.= "
                    <tr>";
                if ($server_disabled) {
                    $content.= "
                        <td>$server_name</td>
                        <td>".$server_attribute["active"]."</td>
                        <td>0</td>
                    ";
                }
                else {
                    $content.= "
                        <td><a class=\"toggle_detail\" style=\"text-decoration:none;color:inherit;\" href=\"#\">".$server_name."</a></td>
                        <td>".$server_attribute["active"]."</td>
                        <td><a style=\"text-decoration:none;color:inherit;\" href=\"/appservers/$server_name/users\">".$server_attribute["NBUSERS"]." ("._("click for list").")</a></td>
                    ";
                }
                $content.= "
                    </tr>
                ";

                if (is_array($server_attribute["ADDRESSES"])) {
                    $server_attribute["ADDRESSES"]=implode(",",$server_attribute["ADDRESSES"]);
                }

                # Advanced information, will only display when the header is clicked
                $content.="
                        <tr class=\"toggle_detail\">
                            <td colspan=\"3\" style=\"padding: 0 1em 1em 1em;\">
                                <b>"._("CPU").":</b> ".$server_attribute["CPUCOUNT"]." x ".$server_attribute["CPUFREQ"]."Mhz<br />
                                <b>"._("Operating system").":</b> ".$server_attribute["DISTRO"]."<br />
                                <b>"._("Memory").":</b> ".$server_attribute["MEMUSED"]."/".$server_attribute["MEMTOTAL"]." (".$server_attribute["MEMFREE"]." "._("free").")<br />
                                <b>"._("Load average").":</b> ".$server_attribute["LOADAVG"]."<br />
                                <b>"._("IP addresses").":</b> ".$server_attribute["ADDRESSES"]."<br />
                                <b>"._("Hostname").":</b> ".$server_attribute["HOSTNAME"]."<br />
                            </td>
                        </tr>
                    ";
                $server_id++;
            }
            $content.= "
                </table>
                <br />
            ";
            $group_id++;
        }
        return $content;
    }

    function loadbalancer_userlist($server = Null) {
        global $config;

        # Jquery
        $content= "
            <script type=\"text/javascript\">
                $(document).ready(function() {
                    $(\"tr.toggle_detail\").toggle();
                    $(\"a.toggle_detail\").click(function() {
                        $(this).parent().parent().next(\"tr.toggle_detail\").toggle();
                    });

                    $(\"a.confirm_url\").click(function() {
                        url=$(this).attr(\"href\").replace(\"#\",\"\");
                        user=$(this).parent().parent().find(\"a.toggle_detail\").text().split(' (')[0];

                        var states = {
                            state0: {
                                html:'".str_replace("'","\'",_("Are you sure you want to disconnect"))." '+user+' ?',
                                buttons: { '".str_replace("'","\'",_("Cancel"))."': false, '".str_replace("'","\'",_("Yes"))."': true },
                                focus: 1,
                                submit:function(v,m,f){
                                    if(!v) {
                                        return true;
                                    }
                                    else {
                                        jQuery.get(url);
                                        $.prompt.goToState('state1');
                                    }
                                    return false;
                                }
                            },
                            state1: {
                                html:'".str_replace("'","\'",_("User"))." '+user+' ".str_replace("'","\'",_("disconnected."))."<br />".str_replace("'","\'",_("It may take a few seconds for the user to disappear (depending on your loadbalancer setting)."))."',
                                buttons: { '".str_replace("'","\'",_("Exit"))."': 0 }
                            }
                        };
                        $.prompt(states,{show:\"show\",persistent:false,overlayspeed:0,promptspeed:0});
                    });

                });
            </script>
        ";


        # Generate a block containing a list of all application servers
        $lbserver = LoadBalancer::getInstance($config['loadbalancer']['host'],$config['loadbalancer']['port']);
        $users=array();
        foreach ($lbserver->getStatusRaw() as $group) {
            foreach ($group as $server_name => $server_content) {
                if ($server == Null || $server_name == $server) {
                    if (is_array($server_content['USERS']) && $server_content['IP']) {
                        foreach ($server_content['USERS'] as $user) {
                            $users[]=array($user,$server_name,$server_content['IP']);
                        }
                    }
                    elseif ($server_content['USERS'] && $server_content['IP']) {
                        $users[]=array($server_content['USERS'],$server_name,$server_content['IP']);
                    }
                }
            }
        }

        # Clear and sort the array
        sort($users);

        if (count($users) > 1) {
            $struser=count($users)." "._("users");
        }
        else {
            $struser=count($users)." "._("user");
        }

        if ($server == Null) {
            $content.="<b>"._("Full user list")." (".$struser.")</b><br /><br />";
        }
        else {
            $content.="<b>"._("Users on")." ".$server." (".$struser.")</b><br /><br />";
        }
        $content.= "
            <form class=\"filter\" action=\"#\"><p style=\"font-weight:bold\">"._("Search").": <input onkeyup=\"javascript:filterTable(this,'listing')\" /></p></form>
            <table class=\"listing\">
                <tr class=\"trheader\">
                    <td><b>"._("Username")."</b></td>
            ";
        if ($server == Null) {
            $content.= "
                    <td><b>"._("Application server")."</b></td>
            ";
        }
        $content.= "
                    <td><b>"._("Actions")."</b></td>
                </tr>
        ";

        $user_id=0;
        foreach ($users as $user) {
            $colspan=2;
            $content.= "
                <tr>
                    <td><a class=\"toggle_detail\" style=\"text-decoration:none;color:inherit;\" href=\"#\">".$user[0]." ("._("click to expand").")</a></td>
            ";
            if ($server == Null) {
                $colspan=3;
                $content.= "
                    <td>".$user[1]."</td>
                ";
            }
            $content.= "
                    <td>
                        <a class=\"confirm_url\" href=\"#/appservers/".$user[2]."/".$user[0]."/kill\"><img style=\"border:0\" src=\"/themes/".$config['theme']."/icons/system-log-out.png\" /></a>
                        <a href=\"/appservers/".$user[2]."/".$user[0]."/plist\"><img style=\"border:0\" src=\"/themes/".$config['theme']."/icons/utilities-system-monitor.png\" /></a>
                    </td>
                </tr>
            ";
            # Advanced information, will only display when the header is clicked
            $content.="
                <tr class=\"toggle_detail\">
                    <td colspan=\"$colspan\" style=\"padding: 0 1em 1em 1em;\">
                        <b>Some ajax magic will happen here</b>
                    </td>
                </tr>
            ";
            $user_id++;
        }
        $content.= "
            </table>
        ";
        return $content;
    }
?>
