/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.lisaac.ldt.LisaacMessages;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.editors.AbstractLisaacEditor;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.editors.ILisaacColor;
import org.lisaac.ldt.editors.LisaacAutoEditStrategy;
import org.lisaac.ldt.editors.LisaacCompletionProcessor;
import org.lisaac.ldt.editors.LisaacDamagerRepairer;
import org.lisaac.ldt.editors.LisaacDoubleClickStrategy;
import org.lisaac.ldt.editors.LisaacHyperLinkDetector;
import org.lisaac.ldt.editors.LisaacScanner;
import org.lisaac.ldt.editors.LisaacTextHover;
import org.lisaac.ldt.editors.NonRuleBasedDamagerRepairer;
import org.lisaac.ldt.model.LisaacModel;

public class LisaacConfiguration
extends SourceViewerConfiguration {
    private LisaacDoubleClickStrategy doubleClickStrategy;
    private LisaacScanner scanner;
    private ColorManager colorManager;
    private ContentAssistant contentAssistant = null;
    private ITextHover textHover = null;
    private AbstractLisaacEditor editor;

    public LisaacConfiguration(ColorManager colorManager, AbstractLisaacEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__lisaac_comment", "__lisaac_string", "__lisaac_characters", "__lisaac_external"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new LisaacDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.contentAssistant == null) {
            int delay;
            this.contentAssistant = new ContentAssistant();
            LisaacCompletionProcessor cap = new LisaacCompletionProcessor();
            this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)cap, "__dftl_partition_content_type");
            this.contentAssistant.setRepeatedInvocationMode(true);
            this.contentAssistant.setStatusLineVisible(true);
            this.contentAssistant.enableColoredLabels(true);
            this.contentAssistant.setStatusMessage(LisaacMessages.getString("LisaacConfiguration_0"));
            try {
                delay = LisaacPlugin.getDefault().getPreferenceStore().getInt("lisaac_competion_delay");
            }
            catch (Exception exception) {
                delay = 500;
            }
            this.contentAssistant.enableAutoActivation(true);
            this.contentAssistant.setAutoActivationDelay(delay);
            this.contentAssistant.setProposalPopupOrientation(10);
        }
        return this.contentAssistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.textHover != null) {
            return this.textHover;
        }
        if (this.editor != null) {
            IProject project = this.editor.getProject();
            LisaacModel model = LisaacModel.getModel(project);
            this.textHover = new LisaacTextHover(model, this.editor.getFileName(), this.colorManager);
        }
        return this.textHover;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("__lisaac_comment")) {
            return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy()};
        }
        if (contentType.equals("__dftl_partition_content_type")) {
            return new IAutoEditStrategy[]{new LisaacAutoEditStrategy()};
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{new String("  "), new String()};
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        return new IHyperlinkDetector[]{new LisaacHyperLinkDetector(), new URLHyperlinkDetector()};
    }

    protected LisaacScanner getLisaacScanner() {
        if (this.scanner == null) {
            this.scanner = new LisaacScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ILisaacColor.DEFAULT))));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        LisaacDamagerRepairer dr = new LisaacDamagerRepairer((ITokenScanner)this.getLisaacScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(this.colorManager.getToken("comment_color", "normal"));
        reconciler.setDamager((IPresentationDamager)ndr, "__lisaac_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__lisaac_comment");
        ndr = new NonRuleBasedDamagerRepairer(this.colorManager.getToken("string_color", "string_style"));
        reconciler.setDamager((IPresentationDamager)ndr, "__lisaac_string");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__lisaac_string");
        ndr = new NonRuleBasedDamagerRepairer(this.colorManager.getToken("character_color", "local_slot_color"));
        reconciler.setDamager((IPresentationDamager)ndr, "__lisaac_characters");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__lisaac_characters");
        ndr = new NonRuleBasedDamagerRepairer(this.colorManager.getToken2("external_color", "local_slot_color"));
        reconciler.setDamager((IPresentationDamager)ndr, "__lisaac_external");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__lisaac_external");
        return reconciler;
    }
}

