/*
 * Copyright (c) 2007 - 2015 Joseph Gaeddert
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

//
// fftfilt_crcf_data_h7x256.c: autotest fftfilt data
//

#include <complex.h>

float fftfilt_crcf_data_h7x256_h[] = {
   -0.040934386849,
    0.135112583637,
    0.002939097211,
    0.060173767805,
   -0.080519974232,
    0.155969536304,
    0.169374001026};

float complex fftfilt_crcf_data_h7x256_x[] = {
    0.040651902556 +   0.099964648485*_Complex_I,
   -0.099666911364 +   0.065967345238*_Complex_I,
    0.160125207901 +   0.220931744576*_Complex_I,
    0.040764364600 +  -0.044899615645*_Complex_I,
   -0.134997522831 +   0.246626877785*_Complex_I,
    0.081977373362 +  -0.136002039909*_Complex_I,
    0.110743105412 +   0.054145228863*_Complex_I,
    0.044197705388 +  -0.067522579432*_Complex_I,
   -0.109018945694 +  -0.106943678856*_Complex_I,
    0.006750953943 +  -0.091825586557*_Complex_I,
    0.074130672216 +   0.058626526594*_Complex_I,
   -0.109099924564 +  -0.185111522675*_Complex_I,
    0.050862681866 +  -0.099265706539*_Complex_I,
    0.139591431618 +  -0.009831842780*_Complex_I,
    0.098799163103 +   0.068593806028*_Complex_I,
   -0.134761643410 +  -0.071746927500*_Complex_I,
    0.040908864141 +  -0.077851450443*_Complex_I,
    0.009703576565 +   0.085823422670*_Complex_I,
   -0.088899284601 +  -0.024389025569*_Complex_I,
    0.131887495518 +   0.003364508972*_Complex_I,
   -0.016711652279 +  -0.064561820030*_Complex_I,
   -0.028739383817 +   0.119105470181*_Complex_I,
   -0.037841024995 +   0.130922996998*_Complex_I,
   -0.036886861920 +   0.049854472280*_Complex_I,
    0.195188224316 +   0.196104526520*_Complex_I,
    0.090881633759 +  -0.049584397674*_Complex_I,
    0.095823466778 +  -0.010633364320*_Complex_I,
   -0.026297450066 +   0.112273478508*_Complex_I,
    0.064357328415 +  -0.151258838177*_Complex_I,
    0.083770233393 +  -0.010217200220*_Complex_I,
   -0.085294854641 +  -0.001434229873*_Complex_I,
   -0.024482454360 +  -0.028102940321*_Complex_I,
    0.007926462591 +   0.049879977107*_Complex_I,
   -0.019109925628 +  -0.122103679180*_Complex_I,
    0.065177565813 +  -0.099032187462*_Complex_I,
   -0.029712364078 +   0.058807843924*_Complex_I,
    0.014222274721 +  -0.111795830727*_Complex_I,
   -0.013231332600 +  -0.097048926353*_Complex_I,
   -0.042737719417 +  -0.082051867247*_Complex_I,
   -0.000470168283 +   0.065859609842*_Complex_I,
   -0.012786905468 +   0.140206325054*_Complex_I,
    0.101196074486 +   0.024098466337*_Complex_I,
    0.029521119595 +   0.073089057207*_Complex_I,
    0.036042726040 +  -0.055842936039*_Complex_I,
    0.006287913024 +   0.163206160069*_Complex_I,
    0.162955164909 +  -0.168543994427*_Complex_I,
    0.025857266784 +   0.046382865310*_Complex_I,
    0.105994081497 +  -0.114217007160*_Complex_I,
    0.166455543041 +  -0.042309248447*_Complex_I,
   -0.055975890160 +  -0.082556062937*_Complex_I,
    0.100109672546 +   0.042784979939*_Complex_I,
   -0.133630573750 +   0.026788604259*_Complex_I,
   -0.124175155163 +   0.100820934772*_Complex_I,
   -0.018217980862 +   0.020558734238*_Complex_I,
    0.020028033853 +  -0.023399496078*_Complex_I,
    0.041591683030 +   0.234618091583*_Complex_I,
    0.114061284065 +   0.076200354099*_Complex_I,
   -0.044339376688 +   0.155996751785*_Complex_I,
   -0.137206864357 +   0.152004182339*_Complex_I,
   -0.125251030922 +  -0.189576375484*_Complex_I,
   -0.096886903048 +   0.100963902473*_Complex_I,
    0.045814022422 +  -0.153462719917*_Complex_I,
    0.018112409115 +   0.033487904072*_Complex_I,
   -0.094020819664 +  -0.066115939617*_Complex_I,
   -0.183385014534 +  -0.106691968441*_Complex_I,
    0.008264037967 +  -0.041415163875*_Complex_I,
   -0.061662602425 +  -0.034961605072*_Complex_I,
    0.125767064095 +   0.063457810879*_Complex_I,
    0.017231588066 +  -0.019841212034*_Complex_I,
    0.129437744617 +  -0.025927716494*_Complex_I,
   -0.060927426815 +   0.096969240904*_Complex_I,
   -0.015513072908 +   0.036051341891*_Complex_I,
   -0.111995267868 +   0.039143866301*_Complex_I,
   -0.073930400610 +   0.029889217019*_Complex_I,
   -0.175347507000 +   0.054301995039*_Complex_I,
    0.052788543701 +   0.158147716522*_Complex_I,
    0.015504409373 +   0.139973330498*_Complex_I,
   -0.031992411613 +  -0.023225200176*_Complex_I,
    0.025022339821 +  -0.131516921520*_Complex_I,
    0.018602204323 +   0.044248020649*_Complex_I,
   -0.173263669014 +  -0.001720846072*_Complex_I,
   -0.067457306385 +  -0.031605756283*_Complex_I,
   -0.120310330391 +   0.084929233789*_Complex_I,
   -0.217696404457 +   0.025325486064*_Complex_I,
   -0.051374822855 +   0.090975987911*_Complex_I,
    0.090311527252 +  -0.099616253376*_Complex_I,
   -0.032548421621 +   0.022745725513*_Complex_I,
    0.136037707329 +   0.054802763462*_Complex_I,
    0.137908041477 +  -0.013432055712*_Complex_I,
   -0.055867260695 +   0.124781918526*_Complex_I,
   -0.042160874605 +  -0.145593822002*_Complex_I,
   -0.119642519951 +   0.119596099854*_Complex_I,
    0.139787364006 +   0.183254098892*_Complex_I,
   -0.134095728397 +  -0.062589937449*_Complex_I,
   -0.132995867729 +  -0.087235867977*_Complex_I,
   -0.066653913260 +  -0.209919691086*_Complex_I,
    0.103792250156 +  -0.098301386833*_Complex_I,
   -0.047595480084 +  -0.060045230389*_Complex_I,
   -0.112747573853 +  -0.090008395910*_Complex_I,
   -0.209859752655 +  -0.037542074919*_Complex_I,
    0.126466608047 +  -0.080237525702*_Complex_I,
    0.016278307140 +   0.020775717497*_Complex_I,
   -0.172989428043 +  -0.065381830931*_Complex_I,
   -0.146700656414 +  -0.139556598663*_Complex_I,
   -0.016435039043 +   0.061182838678*_Complex_I,
    0.033882060647 +  -0.038332518935*_Complex_I,
   -0.062427771091 +  -0.101914501190*_Complex_I,
    0.005463292450 +  -0.123674154282*_Complex_I,
   -0.021189038455 +   0.067074733973*_Complex_I,
   -0.026172134280 +  -0.118123090267*_Complex_I,
   -0.056077581644 +  -0.012562614679*_Complex_I,
   -0.044715997577 +  -0.070106768608*_Complex_I,
   -0.131478667259 +  -0.141248393059*_Complex_I,
    0.029736247659 +  -0.026428756118*_Complex_I,
   -0.037444081903 +  -0.068290340900*_Complex_I,
    0.001371991076 +   0.079103118181*_Complex_I,
    0.096291542053 +  -0.006254652143*_Complex_I,
    0.011948133260 +  -0.061023879051*_Complex_I,
    0.012181475013 +  -0.016896595061*_Complex_I,
    0.018844342232 +  -0.121562480927*_Complex_I,
   -0.075810509920 +  -0.044127961993*_Complex_I,
   -0.065980046988 +  -0.120858967304*_Complex_I,
    0.017340828478 +   0.001790644042*_Complex_I,
   -0.158844494820 +  -0.130223393440*_Complex_I,
    0.112532448769 +  -0.015026393533*_Complex_I,
    0.207700538635 +   0.072319573164*_Complex_I,
   -0.005225989595 +  -0.052219772339*_Complex_I,
   -0.040421813726 +  -0.137831771374*_Complex_I,
   -0.173290038109 +   0.160280382633*_Complex_I,
    0.051121586561 +  -0.104382145405*_Complex_I,
   -0.088693290949 +   0.112509071827*_Complex_I,
    0.035253915191 +  -0.128079938889*_Complex_I,
    0.069757878780 +  -0.118046510220*_Complex_I,
    0.072834354639 +   0.093183624744*_Complex_I,
    0.098304384947 +  -0.038691642880*_Complex_I,
    0.043434667587 +  -0.021110518277*_Complex_I,
    0.053629237413 +   0.059115654230*_Complex_I,
    0.016377405822 +  -0.074930238724*_Complex_I,
   -0.082616806030 +  -0.107039499283*_Complex_I,
    0.063279908895 +   0.085305947065*_Complex_I,
   -0.034898114204 +   0.129442250729*_Complex_I,
   -0.014594067633 +  -0.068186104298*_Complex_I,
   -0.013007178903 +   0.240023064613*_Complex_I,
   -0.017352801561 +  -0.107890737057*_Complex_I,
   -0.104129159451 +   0.294831180573*_Complex_I,
    0.034248217940 +  -0.020147347450*_Complex_I,
   -0.068929183483 +  -0.145515120029*_Complex_I,
    0.021941699088 +  -0.150268518925*_Complex_I,
    0.106213212013 +   0.050292271376*_Complex_I,
   -0.139671075344 +  -0.032991030812*_Complex_I,
   -0.077905637026 +  -0.102883970737*_Complex_I,
    0.060987144709 +   0.119357335567*_Complex_I,
    0.035836818814 +  -0.036872345209*_Complex_I,
    0.104147458076 +   0.079617452621*_Complex_I,
   -0.002261339687 +  -0.082611733675*_Complex_I,
   -0.012895359099 +   0.065233492851*_Complex_I,
    0.006274250150 +   0.018203525245*_Complex_I,
    0.133517765999 +   0.130283260345*_Complex_I,
   -0.197759151459 +  -0.014819876850*_Complex_I,
   -0.113921284676 +  -0.029470649362*_Complex_I,
    0.057060551643 +   0.010812921077*_Complex_I,
   -0.017510490119 +  -0.139960432053*_Complex_I,
   -0.051596522331 +  -0.019726826251*_Complex_I,
    0.128962993622 +   0.032193422318*_Complex_I,
   -0.085369610786 +   0.007678684592*_Complex_I,
   -0.040599119663 +   0.058400410414*_Complex_I,
    0.034683728218 +   0.006657131016*_Complex_I,
   -0.062493687868 +   0.258592700958*_Complex_I,
    0.030317050219 +  -0.182111239433*_Complex_I,
   -0.029376697540 +   0.052327275276*_Complex_I,
   -0.109441542625 +  -0.079162907600*_Complex_I,
   -0.090063333511 +  -0.016401563585*_Complex_I,
   -0.209231019020 +   0.104617154598*_Complex_I,
    0.033998718858 +   0.114239072800*_Complex_I,
    0.016250103712 +  -0.094514828920*_Complex_I,
   -0.065307158232 +  -0.109144735336*_Complex_I,
    0.044777354598 +   0.034570571780*_Complex_I,
    0.047505182028 +   0.106286907196*_Complex_I,
    0.032323399186 +  -0.060076057911*_Complex_I,
    0.009413731098 +   0.113497722149*_Complex_I,
   -0.001863899827 +   0.103868281841*_Complex_I,
   -0.136217641830 +   0.035371488333*_Complex_I,
    0.035117888451 +  -0.181699144840*_Complex_I,
    0.012568083405 +   0.029830288887*_Complex_I,
    0.222174477577 +  -0.128343975544*_Complex_I,
   -0.073185539246 +   0.019389149547*_Complex_I,
    0.101314771175 +   0.003134848550*_Complex_I,
    0.029810345173 +   0.106935989857*_Complex_I,
    0.062490916252 +  -0.069559586048*_Complex_I,
    0.149825906754 +   0.072701114416*_Complex_I,
    0.123934853077 +  -0.025215783715*_Complex_I,
    0.009782531857 +  -0.153410112858*_Complex_I,
    0.160168147087 +   0.089273881912*_Complex_I,
    0.168133974075 +   0.006127674505*_Complex_I,
    0.045770967007 +  -0.068010586500*_Complex_I,
    0.031379061937 +  -0.011051291972*_Complex_I,
    0.158589434624 +  -0.111993229389*_Complex_I,
   -0.076348328590 +  -0.078152877092*_Complex_I,
   -0.134444558620 +  -0.117534625530*_Complex_I,
   -0.079543095827 +  -0.066662031412*_Complex_I,
   -0.071512258053 +  -0.002769588307*_Complex_I,
    0.044172352552 +  -0.001636494324*_Complex_I,
    0.106910932064 +   0.067301118374*_Complex_I,
   -0.189863562584 +  -0.210064339638*_Complex_I,
    0.160713946819 +  -0.175641644001*_Complex_I,
    0.107809066772 +  -0.015213376284*_Complex_I,
    0.122092103958 +  -0.030190780759*_Complex_I,
   -0.003812288493 +  -0.100728774071*_Complex_I,
   -0.106180906296 +   0.040024718642*_Complex_I,
   -0.023936416209 +   0.098257493973*_Complex_I,
    0.036565282941 +   0.003215969726*_Complex_I,
   -0.103855776787 +  -0.073435127735*_Complex_I,
   -0.050348949432 +   0.062807798386*_Complex_I,
   -0.112694954872 +   0.127760851383*_Complex_I,
   -0.090150475502 +   0.123642957211*_Complex_I,
    0.045266637206 +  -0.160168957710*_Complex_I,
    0.026377058029 +   0.006977221370*_Complex_I,
    0.102039659023 +  -0.043179959059*_Complex_I,
    0.013855941594 +   0.044194161892*_Complex_I,
   -0.218561863899 +  -0.144262731075*_Complex_I,
   -0.137404084206 +   0.063279211521*_Complex_I,
    0.238168430328 +   0.085272878408*_Complex_I,
   -0.048531836271 +   0.178845489025*_Complex_I,
   -0.144287097454 +   0.058967697620*_Complex_I,
   -0.049209004641 +  -0.025680020452*_Complex_I,
    0.024836380780 +  -0.005075773597*_Complex_I,
    0.102902829647 +   0.135188984871*_Complex_I,
    0.011638478935 +  -0.053264147043*_Complex_I,
    0.022318521142 +  -0.005398513377*_Complex_I,
   -0.073730462790 +  -0.112155592442*_Complex_I,
   -0.006353335828 +  -0.047271516919*_Complex_I,
   -0.009832777083 +  -0.083933675289*_Complex_I,
   -0.189570760727 +  -0.024030640721*_Complex_I,
    0.170936667919 +  -0.021397763491*_Complex_I,
    0.027291259170 +   0.065315496922*_Complex_I,
    0.021211113036 +   0.016976553202*_Complex_I,
    0.009872701019 +  -0.091594105959*_Complex_I,
    0.057232087851 +  -0.185351312160*_Complex_I,
    0.200562620163 +  -0.098748236895*_Complex_I,
    0.055897176266 +  -0.010039170831*_Complex_I,
   -0.127369284630 +  -0.044656923413*_Complex_I,
    0.137353527546 +   0.299679923058*_Complex_I,
    0.045141702890 +  -0.044110915065*_Complex_I,
   -0.004061393067 +  -0.012276126444*_Complex_I,
   -0.177904891968 +   0.037945824862*_Complex_I,
    0.154672491550 +  -0.095904517174*_Complex_I,
   -0.175321102142 +   0.007050059736*_Complex_I,
   -0.146184301376 +  -0.079787492752*_Complex_I,
    0.189255583286 +   0.028883567452*_Complex_I,
   -0.122478711605 +  -0.069346314669*_Complex_I,
   -0.046293541789 +   0.053173589706*_Complex_I,
   -0.007427679747 +   0.097887659073*_Complex_I,
    0.015306715667 +   0.002264038287*_Complex_I,
   -0.000068226655 +   0.105025970936*_Complex_I,
    0.003785865381 +  -0.108235859871*_Complex_I,
   -0.007453963161 +   0.090025615692*_Complex_I};

float complex fftfilt_crcf_data_h7x256_y[] = {
   -0.001664060705 +  -0.004091991592*_Complex_I,
    0.009572387490 +   0.010806149100*_Complex_I,
   -0.019901401209 +   0.000163118771*_Complex_I,
    0.022119513679 +   0.037897731040*_Complex_I,
    0.002233819268 +  -0.019592330428*_Complex_I,
    0.002525225428 +   0.062331636862*_Complex_I,
   -0.012953756015 +  -0.013138017071*_Complex_I,
    0.010082536290 +   0.073767533264*_Complex_I,
    0.060041705276 +  -0.002211361863*_Complex_I,
   -0.028964339812 +   0.034181387304*_Complex_I,
   -0.018779359256 +  -0.002983805531*_Complex_I,
    0.035540274574 +  -0.000359767320*_Complex_I,
    0.018230003371 +  -0.019050266810*_Complex_I,
   -0.004763113580 +  -0.030748598959*_Complex_I,
   -0.014980219026 +  -0.052722939755*_Complex_I,
    0.043826553194 +   0.014698974734*_Complex_I,
   -0.019748368274 +  -0.017846203362*_Complex_I,
   -0.011106427606 +  -0.056159008955*_Complex_I,
    0.019392753020 +  -0.015821591090*_Complex_I,
    0.034983837452 +   0.006944986235*_Complex_I,
    0.011247676464 +   0.014886292150*_Complex_I,
   -0.023269214094 +  -0.046261333224*_Complex_I,
    0.021153525557 +   0.012909728412*_Complex_I,
   -0.027534552856 +   0.022575118010*_Complex_I,
   -0.007955539149 +   0.007852778474*_Complex_I,
    0.042312648793 +   0.017460367142*_Complex_I,
    0.002444803765 +  -0.005588089285*_Complex_I,
    0.018236124634 +   0.042201155890*_Complex_I,
   -0.028316282736 +   0.032506714358*_Complex_I,
    0.027833124697 +   0.022694313405*_Complex_I,
    0.052935514738 +   0.031327141782*_Complex_I,
    0.026052595484 +  -0.027272295746*_Complex_I,
    0.008104080597 +   0.021431694747*_Complex_I,
   -0.004512749861 +   0.007815877639*_Complex_I,
    0.024134102168 +  -0.041085781838*_Complex_I,
    0.013299793171 +  -0.012836542385*_Complex_I,
   -0.024458533812 +  -0.003758988445*_Complex_I,
    0.004926203119 +  -0.004067048560*_Complex_I,
   -0.008670506918 +  -0.009165691319*_Complex_I,
    0.004383190990 +  -0.061656974229*_Complex_I,
    0.004798093293 +  -0.001521204143*_Complex_I,
   -0.010192016400 +   0.013551533652*_Complex_I,
    0.016184999222 +  -0.022825917758*_Complex_I,
   -0.006827691414 +  -0.013869452441*_Complex_I,
    0.004506159339 +  -0.027475686016*_Complex_I,
   -0.014160870823 +   0.064266780404*_Complex_I,
    0.034386845087 +  -0.005930865931*_Complex_I,
    0.018854367860 +   0.040245466115*_Complex_I,
    0.027504376699 +  -0.033177621818*_Complex_I,
    0.020613311216 +   0.029686212518*_Complex_I,
    0.019605341108 +  -0.022282553995*_Complex_I,
    0.051946574188 +  -0.010220239313*_Complex_I,
   -0.008537785955 +  -0.011901108333*_Complex_I,
    0.038021151548 +  -0.003863047727*_Complex_I,
   -0.000285452285 +  -0.017843481523*_Complex_I,
    0.010371007070 +  -0.016105029388*_Complex_I,
    0.006025408264 +   0.033055735207*_Complex_I,
   -0.021980650718 +   0.021798423647*_Complex_I,
   -0.023022513053 +   0.051363849161*_Complex_I,
   -0.009988970700 +   0.014282686356*_Complex_I,
   -0.015333264002 +   0.006580976190*_Complex_I,
    0.004814453158 +   0.067575161384*_Complex_I,
    0.021078361301 +  -0.008218606426*_Complex_I,
   -0.018224318008 +   0.078249889963*_Complex_I,
   -0.037359896117 +  -0.025653924650*_Complex_I,
   -0.064316968357 +  -0.014904552890*_Complex_I,
   -0.013278818311 +  -0.017987895509*_Complex_I,
   -0.006335027346 +  -0.029308988553*_Complex_I,
    0.019772938592 +   0.010742017022*_Complex_I,
   -0.051503658033 +  -0.028040995216*_Complex_I,
    0.002794574067 +  -0.025427598795*_Complex_I,
   -0.024524259323 +  -0.007221318106*_Complex_I,
    0.017882433375 +   0.007567005700*_Complex_I,
   -0.002250551860 +   0.019747472870*_Complex_I,
    0.023938973082 +  -0.011112496998*_Complex_I,
   -0.019139308840 +   0.011136397615*_Complex_I,
   -0.002187533851 +   0.036491286044*_Complex_I,
   -0.021134226221 +   0.033399966516*_Complex_I,
   -0.018505797162 +   0.019092652268*_Complex_I,
   -0.040662996211 +  -0.010428531884*_Complex_I,
   -0.014960045707 +   0.026857740562*_Complex_I,
   -0.005153165788 +   0.043765214305*_Complex_I,
   -0.007957971301 +   0.025585809340*_Complex_I,
   -0.020982171142 +  -0.017767345049*_Complex_I,
   -0.010632593672 +  -0.017190118051*_Complex_I,
   -0.036959052593 +   0.031325636500*_Complex_I,
   -0.029896295979 +  -0.024658675955*_Complex_I,
   -0.025453655228 +   0.011865474671*_Complex_I,
   -0.032120802983 +   0.013036366771*_Complex_I,
   -0.032795629447 +   0.021107115286*_Complex_I,
    0.010773771971 +   0.024117992872*_Complex_I,
    0.006601385448 +  -0.042746141925*_Complex_I,
   -0.020772448711 +   0.029219872585*_Complex_I,
    0.070536673110 +   0.016052326150*_Complex_I,
   -0.001423170033 +   0.031759755912*_Complex_I,
   -0.013628227138 +  -0.003553860969*_Complex_I,
   -0.058771606883 +  -0.049123627122*_Complex_I,
    0.020108788723 +   0.037188142016*_Complex_I,
    0.007949063332 +   0.010951582458*_Complex_I,
   -0.038626115166 +  -0.024020666588*_Complex_I,
   -0.078006273376 +  -0.045266963734*_Complex_I,
    0.017751019078 +  -0.063270144075*_Complex_I,
    0.016258961397 +  -0.015778900175*_Complex_I,
   -0.018458853139 +  -0.029074158472*_Complex_I,
   -0.080688576156 +  -0.034942123609*_Complex_I,
   -0.031578691749 +  -0.015054873307*_Complex_I,
    0.036145679578 +  -0.014310450501*_Complex_I,
   -0.021959415316 +  -0.000580080691*_Complex_I,
   -0.047396546182 +  -0.059828747217*_Complex_I,
   -0.035670847715 +  -0.003606200086*_Complex_I,
    0.006553370474 +  -0.010100243677*_Complex_I,
   -0.011536306226 +  -0.007568475396*_Complex_I,
   -0.010414782074 +  -0.052787147602*_Complex_I,
   -0.022759606756 +  -0.019938883855*_Complex_I,
   -0.000682229297 +  -0.011460511608*_Complex_I,
   -0.022518239866 +  -0.037363417124*_Complex_I,
   -0.007962730587 +   0.007463843703*_Complex_I,
   -0.020202765636 +  -0.034000570007*_Complex_I,
   -0.013134852636 +  -0.025359042386*_Complex_I,
    0.005789769049 +  -0.019359516099*_Complex_I,
   -0.007477326398 +  -0.017065274446*_Complex_I,
    0.007535152908 +   0.014947146624*_Complex_I,
    0.008478526310 +  -0.033064163294*_Complex_I,
    0.006495736538 +  -0.000621013504*_Complex_I,
   -0.018881009743 +  -0.042515704819*_Complex_I,
    0.003959382518 +  -0.023006182258*_Complex_I,
   -0.005478138646 +  -0.022439956712*_Complex_I,
    0.012649989781 +  -0.011810626415*_Complex_I,
   -0.016784136514 +  -0.039783192634*_Complex_I,
   -0.052016102486 +  -0.007841932680*_Complex_I,
    0.059471950363 +  -0.013592303981*_Complex_I,
    0.013914799172 +   0.044984722860*_Complex_I,
    0.011486842937 +  -0.061671443344*_Complex_I,
   -0.036780337271 +  -0.003311742125*_Complex_I,
   -0.006092641235 +   0.007927763608*_Complex_I,
    0.007902421446 +  -0.001011649739*_Complex_I,
   -0.006795769455 +   0.008805976503*_Complex_I,
    0.023605170020 +  -0.038943989870*_Complex_I,
    0.023625556066 +  -0.009183727558*_Complex_I,
    0.013693690762 +  -0.003169361400*_Complex_I,
    0.029827583427 +  -0.013202113602*_Complex_I,
    0.005499368566 +   0.025768234920*_Complex_I,
    0.020555898301 +  -0.006579736075*_Complex_I,
   -0.018397046470 +   0.008180231852*_Complex_I,
   -0.000311933642 +  -0.045290959470*_Complex_I,
   -0.009854739488 +   0.094914113403*_Complex_I,
   -0.001041015584 +  -0.010428696751*_Complex_I,
   -0.019479887241 +   0.038746806007*_Complex_I,
    0.003949972577 +  -0.023915676515*_Complex_I,
   -0.005952904345 +   0.028280800121*_Complex_I,
   -0.020794732314 +   0.049370817714*_Complex_I,
   -0.013758601114 +  -0.029866172207*_Complex_I,
   -0.018665194668 +  -0.036784877494*_Complex_I,
    0.027598854453 +  -0.029032203867*_Complex_I,
    0.020417636582 +   0.032869611698*_Complex_I,
   -0.038033374173 +  -0.047062159994*_Complex_I,
   -0.002307491697 +   0.016775992609*_Complex_I,
    0.002741426303 +   0.000401399904*_Complex_I,
    0.047873297365 +   0.035012972663*_Complex_I,
   -0.002960979438 +  -0.003970085476*_Complex_I,
   -0.013174401910 +  -0.001911987889*_Complex_I,
   -0.015764753015 +   0.009609419552*_Complex_I,
    0.030869778703 +   0.004752229880*_Complex_I,
   -0.007925303167 +   0.018384260100*_Complex_I,
   -0.036144266243 +  -0.012421792859*_Complex_I,
   -0.021583982780 +   0.005519018931*_Complex_I,
    0.011692092106 +  -0.008831839761*_Complex_I,
   -0.019409391330 +  -0.038426827460*_Complex_I,
    0.006223391109 +   0.046989172728*_Complex_I,
    0.018999067344 +  -0.023638921178*_Complex_I,
   -0.026744966281 +   0.035209035395*_Complex_I,
   -0.005797132267 +  -0.030721098320*_Complex_I,
   -0.012007029920 +   0.052541286005*_Complex_I,
   -0.040002533893 +   0.015828735411*_Complex_I,
    0.007259346684 +   0.002315325843*_Complex_I,
   -0.022414689402 +  -0.003834870337*_Complex_I,
   -0.024299572844 +  -0.033955598422*_Complex_I,
   -0.045734353675 +  -0.001347407015*_Complex_I,
   -0.030146751771 +   0.053501404395*_Complex_I,
    0.020367548034 +   0.003025664117*_Complex_I,
   -0.006737275010 +  -0.018512929694*_Complex_I,
   -0.000605709571 +  -0.012347963683*_Complex_I,
   -0.006890463622 +   0.046621939143*_Complex_I,
    0.016047502033 +  -0.019923449202*_Complex_I,
   -0.008396903768 +   0.010041927047*_Complex_I,
    0.047436458062 +   0.003595322623*_Complex_I,
   -0.037015474086 +   0.041649052012*_Complex_I,
    0.007016220323 +  -0.036370210637*_Complex_I,
   -0.012617538063 +   0.002683467470*_Complex_I,
    0.051168439092 +  -0.028397908806*_Complex_I,
    0.035205638612 +  -0.001881106820*_Complex_I,
    0.021551345104 +  -0.005936731955*_Complex_I,
    0.020923031070 +   0.002729234686*_Complex_I,
    0.024976448430 +   0.011252084504*_Complex_I,
    0.045876193259 +  -0.003769034340*_Complex_I,
    0.058950819572 +   0.017386610345*_Complex_I,
    0.017620108715 +  -0.032126491912*_Complex_I,
    0.040499252854 +  -0.028610567370*_Complex_I,
    0.047208712591 +   0.014810229612*_Complex_I,
    0.027499183980 +  -0.028800252172*_Complex_I,
   -0.012932302613 +  -0.018166904753*_Complex_I,
    0.016403288642 +  -0.020622110742*_Complex_I,
    0.022373704021 +  -0.028689811011*_Complex_I,
   -0.009452243729 +  -0.008680644929*_Complex_I,
   -0.058678992249 +  -0.051174770891*_Complex_I,
   -0.005006438141 +  -0.031267299630*_Complex_I,
   -0.015215097299 +  -0.020119691971*_Complex_I,
    0.066084164099 +   0.016564502968*_Complex_I,
   -0.013768201897 +  -0.023474209345*_Complex_I,
   -0.021803271593 +  -0.062476214596*_Complex_I,
    0.028932477041 +  -0.022490403547*_Complex_I,
    0.040341712936 +   0.006962852165*_Complex_I,
    0.015330216728 +  -0.030617975708*_Complex_I,
   -0.015573978799 +  -0.015495893724*_Complex_I,
   -0.042595498240 +   0.029811952687*_Complex_I,
   -0.007383005008 +   0.050473873697*_Complex_I,
   -0.007960910417 +  -0.029841422966*_Complex_I,
   -0.022273885029 +  -0.003249632656*_Complex_I,
   -0.002824822559 +   0.003348401440*_Complex_I,
   -0.024087272328 +   0.065990131062*_Complex_I,
   -0.028057881818 +  -0.029151797322*_Complex_I,
   -0.024558131583 +  -0.015268822223*_Complex_I,
    0.039877624209 +  -0.013405850916*_Complex_I,
    0.028823486535 +   0.037004255305*_Complex_I,
   -0.023970193031 +  -0.005435181200*_Complex_I,
   -0.088636699560 +  -0.013757698161*_Complex_I,
    0.008098637338 +   0.006870343753*_Complex_I,
    0.054927003829 +   0.056475265541*_Complex_I,
   -0.024306265176 +   0.034672928541*_Complex_I,
   -0.021853531429 +   0.018230890552*_Complex_I,
   -0.021682656382 +  -0.032466179919*_Complex_I,
    0.019989585378 +   0.020908798620*_Complex_I,
    0.019423343509 +  -0.002219973236*_Complex_I,
   -0.021632746497 +  -0.006294932050*_Complex_I,
    0.013621743308 +  -0.025286913038*_Complex_I,
   -0.020772874190 +  -0.012989704190*_Complex_I,
    0.025482399527 +  -0.014215236725*_Complex_I,
   -0.044300771406 +  -0.017049381631*_Complex_I,
   -0.006816700080 +  -0.032915524093*_Complex_I,
    0.057073619573 +  -0.013791458776*_Complex_I,
    0.023935306468 +   0.010113795207*_Complex_I,
   -0.010074654341 +  -0.020758506394*_Complex_I,
    0.014148879115 +   0.005089223239*_Complex_I,
    0.035479315734 +  -0.053250867185*_Complex_I,
    0.068075559099 +  -0.000004138871*_Complex_I,
   -0.049122106052 +  -0.026433363499*_Complex_I,
    0.023522704576 +   0.028855355307*_Complex_I,
    0.002677137744 +   0.051086576447*_Complex_I,
    0.002630815479 +  -0.030154181511*_Complex_I,
   -0.021284842311 +   0.018492273061*_Complex_I,
   -0.014785053010 +  -0.025361228004*_Complex_I,
    0.015700956081 +  -0.004007983078*_Complex_I,
   -0.076870199719 +  -0.004459394713*_Complex_I,
    0.013883703469 +  -0.003931123862*_Complex_I,
    0.016113428385 +   0.014312499105*_Complex_I,
   -0.025629511396 +  -0.029198167224*_Complex_I};

