/* yacc input SKI expression */
%{
#include "k.h"

exp x;

yyerror(char *s) {
    printf("%s\n", s); exit(1);
}
%} 
 
%token <yt_int> NUM
/* the next 2 lines force left associativity */
%left '(' 'i' 's' 'k' '+' NUM
%left LEFT
 
%type <yt_exp> exp 
%% 

theroot:	exp			{ x = $1;}; 
 
exp:		'(' exp ')' 		{ $$ = $2;} 
|		exp exp  %prec LEFT	{ $$ = ap($1, $2);}
|		'i'			{ $$ = I();}
|		's'			{ $$ = S();}
|		'k'			{ $$ = K();}
|		NUM			{ $$ = num($1);}
|		'+'			{ $$ = plus();}
;
