#include "../JuceLibraryCode/JuceHeader.h"

#include "GoogleAnalyticsDestination.h"
#include "MainComponent.h"
#include "DemoAnalyticsEventTypes.h"

//==============================================================================
class AnalyticsCollectionApplication  : public JUCEApplication
{
public:
    //==============================================================================
    AnalyticsCollectionApplication() {}

    const String getApplicationName() override       { return ProjectInfo::projectName; }
    const String getApplicationVersion() override    { return ProjectInfo::versionString; }
    bool moreThanOneInstanceAllowed() override       { return true; }

    //==============================================================================
    void initialise (const String&) override
    {
        // Add an analytics identifier for the user. Make sure you don't accidentally
        // collect identifiable information if you haven't asked for permission!
        Analytics::getInstance()->setUserId ("AnonUser1234");

        // Add any other constant user information.
        StringPairArray userData;
        userData.set ("group", "beta");
        Analytics::getInstance()->setUserProperties (userData);

        // Add any analytics destinations we want to use to the Analytics singleton.
        Analytics::getInstance()->addDestination (new GoogleAnalyticsDestination());

        // The event type here should probably be DemoAnalyticsEventTypes::sessionStart
        // in a more advanced app.
        Analytics::getInstance()->logEvent ("startup", {}, DemoAnalyticsEventTypes::event);

        mainWindow = new MainWindow (getApplicationName());
    }

    void shutdown() override
    {
        // The event type here should probably be DemoAnalyticsEventTypes::sessionEnd
        // in a more advanced app.
        Analytics::getInstance()->logEvent ("shutdown", {}, DemoAnalyticsEventTypes::event);

        // Add your application's shutdown code here..

        mainWindow = nullptr; // (deletes our window)
    }

    //==============================================================================
    void systemRequestedQuit() override
    {
        // This is called when the app is being asked to quit: you can ignore this
        // request and let the app carry on running, or call quit() to allow the app to close.
        quit();
    }

    void anotherInstanceStarted (const String&) override
    {
        // When another instance of the app is launched while this one is running,
        // this method is invoked, and the commandLine parameter tells you what
        // the other instance's command-line arguments were.
    }

    //==============================================================================
    /*
        This class implements the desktop window that contains an instance of
        our MainContentComponent class.
    */
    class MainWindow    : public DocumentWindow
    {
    public:
        MainWindow (String name)  : DocumentWindow (name,
                                                    Desktop::getInstance().getDefaultLookAndFeel()
                                                                          .findColour (ResizableWindow::backgroundColourId),
                                                    DocumentWindow::allButtons)
        {
            setUsingNativeTitleBar (true);
            setContentOwned (new MainContentComponent(), true);

            centreWithSize (getWidth(), getHeight());
            setVisible (true);
        }

        void closeButtonPressed() override
        {
            // This is called when the user tries to close this window. Here, we'll just
            // ask the app to quit when this happens, but you can change this to do
            // whatever you need.
            JUCEApplication::getInstance()->systemRequestedQuit();
        }

        /* Note: Be careful if you override any DocumentWindow methods - the base
           class uses a lot of them, so by overriding you might break its functionality.
           It's best to do all your work in your content component instead, but if
           you really have to override any DocumentWindow methods, make sure your
           subclass also calls the superclass's method.
        */

    private:
        JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (MainWindow)
    };

private:
    ScopedPointer<MainWindow> mainWindow;
};

//==============================================================================
// This macro generates the main() routine that launches the app.
START_JUCE_APPLICATION (AnalyticsCollectionApplication)
