#
# Copyright (C) 2020-2022 Intel Corporation
#
# SPDX-License-Identifier: MIT
#

include(${CMAKE_CURRENT_SOURCE_DIR}/cmake${BRANCH_DIR_SUFFIX}not_supported_platforms.cmake)

set(L0_SUPPORTED_PRODUCT_FAMILIES ${ALL_SUPPORTED_PRODUCT_FAMILY})
# Remove unsupported products
list(LENGTH L0_SUPPORTED_PRODUCT_FAMILIES L0_SUPPORTED_PRODUCT_FAMILIES_COUNT)
if(L0_SUPPORTED_PRODUCT_FAMILIES_COUNT GREATER 0)
  list(REMOVE_ITEM L0_SUPPORTED_PRODUCT_FAMILIES ${L0_NOT_SUPPORTED_PRODUCT_FAMILIES})
  list(LENGTH L0_SUPPORTED_PRODUCT_FAMILIES L0_SUPPORTED_PRODUCT_FAMILIES_COUNT)
endif()

if(L0_SUPPORTED_PRODUCT_FAMILIES_COUNT EQUAL 0)
  set(BUILD_WITH_L0 FALSE)
  message(STATUS "L0: Selected platforms are not supported.")
endif()

set(L0_TESTED_PRODUCT_FAMILIES ${ALL_TESTED_PRODUCT_FAMILY})
# Remove unsupported products
list(LENGTH L0_TESTED_PRODUCT_FAMILIES L0_TESTED_PRODUCT_FAMILIES_COUNT)
if(L0_TESTED_PRODUCT_FAMILIES_COUNT GREATER 0)
  list(REMOVE_ITEM L0_TESTED_PRODUCT_FAMILIES ${L0_NOT_SUPPORTED_PRODUCT_FAMILIES})
  list(LENGTH L0_TESTED_PRODUCT_FAMILIES L0_TESTED_PRODUCT_FAMILIES_COUNT)
endif()

if(L0_TESTED_PRODUCT_FAMILIES_COUNT EQUAL 0)
  set(NEO_SKIP_L0_UNIT_TESTS TRUE)
  set(NEO_SKIP_L0_UNIT_TESTS TRUE PARENT_SCOPE)
  message(STATUS "L0: Selected platforms for testing are not supported. Skipping tests.")
endif()
