# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
UBUNTU_RELEASES ?=
GARDEN_SYSTEMS += $(foreach r,$(UBUNTU_RELEASES),$(foreach a,x86_64 aarch64,ubuntu-cloud-$r.$a))

$(foreach R,$(UBUNTU_RELEASES),ubuntu-cloud-$R.x86_64.run): ubuntu-cloud-%.x86_64.run: $(MAKEFILE_LIST) | ubuntu-cloud-%.x86_64.qcow2 ubuntu-cloud-%.x86_64.efi-code.img ubuntu-cloud-%.x86_64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/ubuntu" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(UBUNTU_RELEASES),ubuntu-cloud-$R.aarch64.run): ubuntu-cloud-%.aarch64.run: $(MAKEFILE_LIST) | ubuntu-cloud-%.aarch64.qcow2 ubuntu-cloud-%.aarch64.efi-code.img ubuntu-cloud-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/ubuntu" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

# Ubuntu cloud images do not contain a standalone installer that you only need
# during the setup process. Instead each image can be used as a read-only base
# for a read-write template.
$(foreach R,$(UBUNTU_RELEASES),ubuntu-cloud-$R.x86_64.qcow2): ubuntu-cloud-%.x86_64.qcow2: $(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-%.x86_64.qcow2 ubuntu-cloud-%.seed.iso ubuntu-cloud-%.x86_64.efi-code.img ubuntu-cloud-%.x86_64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

# Replicated because we have more releases than architectures and architecture-specific quirks are easier to express.
$(foreach R,$(UBUNTU_RELEASES),ubuntu-cloud-$R.aarch64.qcow2): ubuntu-cloud-%.aarch64.qcow2: $(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-%.aarch64.qcow2 ubuntu-cloud-%.seed.iso ubuntu-cloud-%.aarch64.efi-code.img ubuntu-cloud-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

# Ubuntu specific downloads.
$(GARDEN_DL_DIR)/ubuntu: | $(GARDEN_DL_DIR)
	mkdir -p $@

ubuntu-cloud-%.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,ubuntu-$*)
ubuntu-cloud-%.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@

ubuntu-cloud-%.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,UBUNTU,$*),ubuntu-$*,ubuntu)
ubuntu-cloud-%.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(UBUNTU_RELEASES),$(foreach A,x86_64 aarch64,ubuntu-cloud-$R.$A.qcow2 ubuntu-cloud-$R.$A.run))
