#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "adpcm.h"

#ifndef le32toh
#include "endian.h"
#endif

#define SOX "sox -r %ld -c %d -t raw -s -w - %s"

typedef struct
   {
   char           chunkID[4];
   long           chunkSize;

   short          wFormatTag;
   unsigned short wChannels;
   unsigned long  dwSamplesPerSec;
   unsigned long  dwAvgBytesPerSec;
   unsigned short wBlockAlign;
   unsigned short wBitsPerSample;
   }
FormatChunk;

//const struct adpcm_state state={0,0};

#define NSAMPLES 1008

FormatChunk fc;

int read_header(FILE *infile)
   {
   long num;
   unsigned char first_two_bytes[2];
   char abuf[NSAMPLES];

   num = fread(abuf, 1, 12, infile);
   if (num < 0)
      {
      perror("input file");
      return(1);
      }
   if (num < 12) return 1;
   if (strncmp(abuf, "RIFF", 4))
      {
      first_two_bytes[0] = abuf[0];
      first_two_bytes[1] = abuf[1];
      if (first_two_bytes[0] == 0xFF)
         {
         if ((first_two_bytes[1] & 0xE0) == 0xE0)
            {
            // this matches the "synch frame of the MP3 header
            fprintf(stderr, "This appears to be an MP3 file\r\n");
            fprintf(stderr, "This just rename to *.mp3\r\n");
            return 77; // Ascii letter M for mp3
            }
         }
      return 2;
      }
   if (strncmp(abuf+8, "WAVE", 4))
      return 3;
   num = fread(&fc, 1, sizeof(FormatChunk), infile);

   // change endian for host architecture
   fc.chunkSize = le32toh(fc.chunkSize);
   fc.wFormatTag = le16toh(fc.wFormatTag);
   fc.wChannels = le16toh(fc.wChannels);
   fc.dwSamplesPerSec = le32toh(fc.dwSamplesPerSec);
   fc.dwAvgBytesPerSec = le32toh(fc.dwAvgBytesPerSec);
   fc.wBlockAlign = le16toh(fc.wBlockAlign);
   fc.wBitsPerSample = le16toh(fc.wBitsPerSample);

   if (num < 0)
      {
      perror("input file");
      return(1);
      }
   if (num < (signed)sizeof(fc)) 
      return 4;
   if (strncmp(fc.chunkID, "fmt ", 4)) 
      return 5;
   if ((fc.wFormatTag) != 0x11)
      {
      fprintf(stderr, "This doesn't seem to be a rec file\r\n");
      return(1);
      }
   if ((fc.wChannels>2) || (!fc.wChannels))
      {
      fprintf(stderr, "I can only handle 1 or 2 channel[s]s\r\n");
      return(1);
      }
   fread(abuf, fc.chunkSize + 8 - sizeof(fc), 1, infile);
   fread(abuf, 4, 1, infile);
   if (strncmp(abuf, "fact", 4)) 
      return 6;
   fread(&num, 4, 1, infile);
   num = le32toh(num);
   fread(abuf, num, 1, infile);
   fread(abuf, 4, 1, infile);
   if (strncmp(abuf, "data", 4)) 
      return 6;
   fread(abuf, 4, 1, infile);
   return 0;
   }


int ifprecconv(const char *sourcefile, const char *destfile)
   {
   long num, cnt, ret;
   signed short header[8];
   char command[1000];
   FILE *PIPE, *infile;
   unsigned char abuf[NSAMPLES];
   unsigned char labuf[NSAMPLES/2];
   unsigned char rabuf[NSAMPLES/2];
   short lsbuf[NSAMPLES];
   short rsbuf[NSAMPLES];
   short buf[NSAMPLES*2];
   struct adpcm_state lstate={0,0};
   struct adpcm_state rstate={0,0};

   infile = fopen(sourcefile, "r");
   if (!infile)
      {
      fprintf(stderr, "Error opening recfile: %s\r\n", sourcefile);
      return(10);
      }
   ret = read_header(infile);
   if ((ret) && (ret != 77))
      {
      fprintf(stderr, "There was an error reading the header. Code %ld\r\n", ret);
      return(ret);
      }
   sprintf(command, SOX, fc.dwSamplesPerSec, fc.wChannels, destfile);
   fprintf(stderr, "I'm going to run '%s'\r\n", command);
   fflush(stderr);
   PIPE = popen(command, "w");
   if (PIPE == NULL)
      {
      perror("program failed");
      return(11);
      }
   while(1)
      {
      fread(header, 1, 16, infile); //read block header
      for (cnt = 0; cnt < 8; cnt++)
         {	    // change endian for host architecture
         header[cnt] = le16toh(header[cnt]);
         }
      lstate.valprev=header[2]; //somehow we need the previous value from
      rstate.valprev=header[6]; //the rec file to avoid inexplicable drifting
      lstate.index=header[0]; //somehow we need the previous value from
      rstate.index=header[4]; //the rec file to avoid inexplicable drifting
      num = fread(abuf, 1, NSAMPLES, infile);
      if (num < 0)
         {
         perror("input file");
         return(12);
         }
      if (num == 0) 
         break;
      for (cnt = 0; cnt < num; cnt++)
         {  //swab nibbles
         char nib  =  (abuf[cnt] >> 4) & (char)0x0F;
         abuf[cnt] = ((abuf[cnt] << 4) & (char)0xF0) | nib;
         }
      if (fc.wChannels == 2)
         {
         for (cnt = 0; cnt < NSAMPLES / 2; cnt++)
            {
            labuf[cnt] = abuf[2 * cnt];
            rabuf[cnt] = abuf[2 * cnt + 1];
            }
         adpcm_decoder(labuf, lsbuf, num, &lstate);
         adpcm_decoder(rabuf, rsbuf, num, &rstate);
         for (cnt = 0; cnt < num; cnt++)
            {
            buf[2 * cnt] = rsbuf[cnt];  //I'm not sure which is the left
            buf[2 * cnt + 1] =lsbuf[cnt];//and which the right channel
            }
         fwrite(buf, 4*num, 1, PIPE);
         }
      else
         {
         adpcm_decoder(abuf, buf, 2 * num, &lstate);
         fwrite(buf, 4 * num, 1, PIPE);
         }
      }
   pclose(PIPE);
   return 0;
   }

