<?php

//    showtidy.php
//    Shows the output produced by tidy given the source code of an URL
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: showtidy.php,v 1.7 2003/12/30 09:39:23 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");
include ("./include/header.inc.php"); 

if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   die;
}
else
{
   if (!isset($IDUrl))
   {
      DisplayErrMsg($strErrorNoUrlSelected);
      die;
   }

   // Check whether tidy is properly set
   if (!isset($Tidy) || !is_executable($Tidy)) 
   {
      DisplayErrMsg($strErrorNoTidy);
      die;
   }

   // Retrieve Information from the DB
   $strSQL = "Select Url, Contents" .
      " FROM Url" .
      " WHERE IDUrl=" . $IDUrl . ' AND Contents IS NOT NULL';

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows()>1)
   {
      DisplayErrMsg($strErrorDuplicateKey);
      die;
   }
   else if ($MyDB->NumRows()==0)
   {
?>
<p><?php echo $strNoOccurrencies; ?></p>
<?php
   }
   else
   {

      // Information retrieved
      $row = $MyDB->FetchArray();
      $MyDB->Free();

      $URLName = $row["Url"];
      $pagetitle = "Database: $dbname - " . $strShowUrlSource . ": " . $URLName;

      // Creates a temporary file for placing the content of the URL
      srand(time());
      if (!is_dir($TidyDirTmp))
      {
         DisplayErrMsg($strErrorNoDirTmp);
         die;
      }
      
      $filename = $TidyDirTmp . '/' . md5(rand()) . '.htcheck.tmp';
      if (!$fp = fopen($filename, 'w'))
      {
         DisplayErrMsg($strErrorFileTmp);
         die;
      }

      fputs($fp, $row['Contents']);
      fclose($fp);

      // Execute the tidy command, putting the output in an array
      exec ("cat $filename | " . $Tidy . ' -q 2>&1', $outarray, $rv);
      unlink($filename);   // erases the temporary file
      
?>
<h3><?php echo $URLName; ?></h3>

<?php

      // The tidy program should produce an output containing warning first, then the proposed
      // source code, according to the default configuration file settings.
      $warnings = true; // by default we set there are warnings
      $numwarnings = 0; // number of warnings
      switch($rv)
      {
         case 0: $strtidy = &$strTidyMessages;
            break;
         case 1: $strtidy = &$strTidyWarnings;
            break;
         case 2: $strtidy = &$strTidyErrors;
            break;
      }

      $str_ereg='^line ([0-9]+) column ([0-9]+) \- (.*)$';
      while(list($outindex, $outrow) = each($outarray))
      {
         if ($warnings && ereg($str_ereg, $outrow, $arrline))
         {
            // This is a typical output line produced by tidy containing warnings
            ++$numwarnings;
         }
         else
         {
            if ($warnings)
            {
               $warnings = false;
?>
<h4><?php echo $strtidy;
      if ($numwarnings)
         echo ' (' . $strNumber . ': ' . $numwarnings . ')';
?></h4>
<ol>
<?php
               // Display the warning report
               for ($i=0; $i < $numwarnings; ++$i)
               {
                  if (ereg($str_ereg, $outarray[$i], $arrline))
                  {
?>
<li><a href="showsource.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $IDUrl; ?>&RowNumber=<?php echo $arrline[1]; ?>#<?php echo $arrline[1];
?>" target="_urlsource"><?php
   echo $strTidyRow . ' ' . $arrline[1]; ?></a> / <?php echo $strTidyColumn . ' ' . $arrline[2]; ?>:
   <i><?php echo WriteHTML($arrline[3]); ?></i></li>
<?php
                  }
               }
?>
</ol>

<h4><?php echo $strTidyHTML; ?></h4>
<pre>
<?php
            }

            echo WriteHTML($outrow) . "\n";
         }
      }
?>
</pre>
<?php
   }
}
?>

<?php include ("./include/footer.inc.php"); ?>
