<?php

///////////////////////////////////////////////////////////
// registerglobals.inc.php - Check for register globals variables
///////////////////////////////////////////////////////////
//
// Author: Gabriele Bartolini
// Date started: ven apr 25 17:57:50 CEST 2003
// Part of the ht://Check package
//
// This script makes ht://Check's interface to be used even
// when register globals is turned off, automatically
//
// For copyright details, see the file COPYING in your distribution
// or the GNU General Public License version 2 or later 
// <http://www.gnu.org/copyleft/gpl.html>
//
// Copyright (c) 2003 - Gabriele Bartolini
///////////////////////////////////////////////////////////
// $Id: registerglobals.inc.php,v 1.9 2006/08/24 12:53:21 angusgb Exp $
///////////////////////////////////////////////////////////

if ( defined( '__REGISTERGLOBALS_INC' ) ) return;
define( '__REGISTERGLOBALS_INC', 1 );

// This function simply gets global any variable we want
// and which was usually shipped through the GET method
// and used as globals before register_globals was turned off
function HtCheck_SetGlobal($var)
{
	eval ("if (isset(\$_GET['$var'])) \$GLOBALS['$var'] = &\$_GET['$var'];");
}

// Current version of PHP (numeric form)
$curver=intval(str_replace('.', '',phpversion()));

// Let's check if our current PHP version is greater than 4.1.0
// that is to say when the $_GET superarray has been added
if ($curver >= 410)
{
	// List of variables to be rendered globals
	$vars=array(
		'anchor',
		'acheckcode',
		'charset', 
		'cmd',
		'confirmed',
		'count',
		'ctype', 
		'dbname',
		'description',
		'dest',
		'doctype', 
		'initpage',
		'linkdomain',
		'linkresult',
		'linktype',
		'keywords',
		'htdigemail',
		'htdigemailsubject',
		'pagesize', 
		'scode', 
		'server',
		'size', 
		'sizeadd', 
		'src',
		'title', 
		'url', 
		'whatanchor',
		'whatcharset', 
		'whatctype', 
		'whatdescription',
		'whatdest',
		'whatdoctype', 
		'whatlinkdomain',
		'whatlinkresult',
		'whatlinktype',
		'whatkeywords',
		'whathtdigemail',
		'whathtdigemailsubject',
		'whatscode', 
		'whatsrc',
		'whatsize', 
		'whatsizeadd', 
		'whattitle', 
		'whaturl', 
		'AttrPosition', 
		'IDUrl', 
		'StatusCode', 
		'TagPosition', 
		'RowNumber', 
	);

	for ($i=0; $i < count($vars); ++$i)
		htCheck_SetGlobal($vars[$i]);

	// Accept language
	$HTTP_ACCEPT_LANGUAGE=&$_SERVER['HTTP_ACCEPT_LANGUAGE'];

	// PHP_SELF
	$PHP_SELF = &$_SERVER['PHP_SELF'];
}

?>
