module Language.Brainfuck.Examples where

-- Example Programs
helloWorld, bottles, helloum, sort, toupper :: String
helloWorld =
  ">+++++++++[<++++++++>-]<.>+++++++[<++++>-]<+.+++++++..+++.[-]>++++++++[<++++>-]"++
  "<.#>+++++++++++[<+++++>-]<.>++++++++[<+++>-]<.+++.------.--------.[-]>++++++++["++
  "<++++>-]<+.[-]++++++++++."
-- works now, thanks to int-e for explaining the BF spec to me
bottles =
  "99 Bottles of Beer in Urban Mueller's BrainF*** (The actual"++
  "name is impolite)"++
  ""++
  "by Ben Olmstead"++
  ""++
  "ANSI C interpreter available on the internet; due to"++
  "constraints in comments the address below needs to have the"++
  "stuff in parenthesis replaced with the appropriate symbol:"++
  ""++
  "http://www(dot)cats(dash)eye(dot)com/cet/soft/lang/bf/"++
  ""++
  "Believe it or not this language is indeed Turing complete!"++
  "Combines the speed of BASIC with the ease of INTERCAL and"++
  "the readability of an IOCCC entry!"++
  ""++
  ">+++++++++[<+++++++++++>-]<[>[-]>[-]<<[>+>+<<-]>>[<<+>>-]>>>"++
  "[-]<<<+++++++++<[>>>+<<[>+>[-]<<-]>[<+>-]>[<<++++++++++>>>+<"++
  "-]<<-<-]+++++++++>[<->-]>>+>[<[-]<<+>>>-]>[-]+<<[>+>-<<-]<<<"++
  "[>>+>+<<<-]>>>[<<<+>>>-]>[<+>-]<<-[>[-]<[-]]>>+<[>[-]<-]<+++"++
  "+++++[<++++++<++++++>>-]>>>[>+>+<<-]>>[<<+>>-]<[<<<<<.>>>>>-"++
  "]<<<<<<.>>[-]>[-]++++[<++++++++>-]<.>++++[<++++++++>-]<++.>+"++
  "++++[<+++++++++>-]<.><+++++..--------.-------.>>[>>+>+<<<-]>"++
  ">>[<<<+>>>-]<[<<<<++++++++++++++.>>>>-]<<<<[-]>++++[<+++++++"++
  "+>-]<.>+++++++++[<+++++++++>-]<--.---------.>+++++++[<------"++
  "---->-]<.>++++++[<+++++++++++>-]<.+++..+++++++++++++.>++++++"++
  "++[<---------->-]<--.>+++++++++[<+++++++++>-]<--.-.>++++++++"++
  "[<---------->-]<++.>++++++++[<++++++++++>-]<++++.-----------"++
  "-.---.>+++++++[<---------->-]<+.>++++++++[<+++++++++++>-]<-."++
  ">++[<----------->-]<.+++++++++++..>+++++++++[<---------->-]<"++
  "-----.---.>>>[>+>+<<-]>>[<<+>>-]<[<<<<<.>>>>>-]<<<<<<.>>>+++"++
  "+[<++++++>-]<--.>++++[<++++++++>-]<++.>+++++[<+++++++++>-]<."++
  "><+++++..--------.-------.>>[>>+>+<<<-]>>>[<<<+>>>-]<[<<<<++"++
  "++++++++++++.>>>>-]<<<<[-]>++++[<++++++++>-]<.>+++++++++[<++"++
  "+++++++>-]<--.---------.>+++++++[<---------->-]<.>++++++[<++"++
  "+++++++++>-]<.+++..+++++++++++++.>++++++++++[<---------->-]<"++
  "-.---.>+++++++[<++++++++++>-]<++++.+++++++++++++.++++++++++."++
  "------.>+++++++[<---------->-]<+.>++++++++[<++++++++++>-]<-."++
  "-.---------.>+++++++[<---------->-]<+.>+++++++[<++++++++++>-"++
  "]<--.+++++++++++.++++++++.---------.>++++++++[<---------->-]"++
  "<++.>+++++[<+++++++++++++>-]<.+++++++++++++.----------.>++++"++
  "+++[<---------->-]<++.>++++++++[<++++++++++>-]<.>+++[<----->"++
  "-]<.>+++[<++++++>-]<..>+++++++++[<--------->-]<--.>+++++++[<"++
  "++++++++++>-]<+++.+++++++++++.>++++++++[<----------->-]<++++"++
  ".>+++++[<+++++++++++++>-]<.>+++[<++++++>-]<-.---.++++++.----"++
  "---.----------.>++++++++[<----------->-]<+.---.[-]<<<->[-]>["++
  "-]<<[>+>+<<-]>>[<<+>>-]>>>[-]<<<+++++++++<[>>>+<<[>+>[-]<<-]"++
  ">[<+>-]>[<<++++++++++>>>+<-]<<-<-]+++++++++>[<->-]>>+>[<[-]<"++
  "<+>>>-]>[-]+<<[>+>-<<-]<<<[>>+>+<<<-]>>>[<<<+>>>-]<>>[<+>-]<"++
  "<-[>[-]<[-]]>>+<[>[-]<-]<++++++++[<++++++<++++++>>-]>>>[>+>+"++
  "<<-]>>[<<+>>-]<[<<<<<.>>>>>-]<<<<<<.>>[-]>[-]++++[<++++++++>"++
  "-]<.>++++[<++++++++>-]<++.>+++++[<+++++++++>-]<.><+++++..---"++
  "-----.-------.>>[>>+>+<<<-]>>>[<<<+>>>-]<[<<<<++++++++++++++"++
  ".>>>>-]<<<<[-]>++++[<++++++++>-]<.>+++++++++[<+++++++++>-]<-"++
  "-.---------.>+++++++[<---------->-]<.>++++++[<+++++++++++>-]"++
  "<.+++..+++++++++++++.>++++++++[<---------->-]<--.>+++++++++["++
  "<+++++++++>-]<--.-.>++++++++[<---------->-]<++.>++++++++[<++"++
  "++++++++>-]<++++.------------.---.>+++++++[<---------->-]<+."++
  ">++++++++[<+++++++++++>-]<-.>++[<----------->-]<.+++++++++++"++
  "..>+++++++++[<---------->-]<-----.---.+++.---.[-]<<<]"++
  "@"
helloum =
  "++++++++++[>+++++++>++++++++++>+++>+<<<<-]>++.>+.+++++++..+++.>++.<<+++++++++++++++.>.+++.------.--------.>+.>.@"
-- can't figure this one out either...
sort =
  "Here is a Brainf*** program that bubblesorts its input and spits it out:"++
  ">>>>>,+[>>>,+]<<<[<<<"++
  "[>>>[-<<<-<+>[>]>>]<<<[<]>>"++
  "[>>>+<<<-]<[>+>>>+<<<<-]"++
  "<<]>>>[-.[-]]>>>[>>>]<<<]"
toupper =
  ",----------[----------------------.,----------]"

{-
Example optimized programs:

++++[>++++++++<-]>[.+]

[(0,IncByteBy 4),  (1,SetIpTo 7),     (2,IncPtrBy 1),
 (3,IncByteBy 8),  (4,IncPtrBy (-1)), (5,IncByteBy (-1)),
 (6,SetIpTo (-1)), (7,IncPtrBy 1),    (8,SetIpTo 12),
 (9,OutputByte),   (10,IncByteBy 1),  (11,SetIpTo (-8)),
 (12,Halt)
]

[[]]

[(0,SetIpTo 4),
 (1,SetIpTo 3),
 (2,SetIpTo (-1)),
 (3,SetIpTo 0),
 (4,Halt)
]

-}
