/*******************************************************************************
 * Copyright 2019-2022 Microchip FPGA Embedded Systems Solutions.
 *
 * SPDX-License-Identifier: MIT
 *
 * MPFS HAL Embedded Software
 *
 */

/***************************************************************************
 *
 * @file mss_beu.h
 * @author Microchip-FPGA Embedded Systems Solutions
 * @brief Bus Error Unit (BEU) user defines and function prototypes
 *
 */

#ifndef MSS_BEU_H
#define MSS_BEU_H

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Default user values. Define these in mss_sw_config.h if you want to change
 * from the default.
 */
#ifndef LIBERO_SETTING_BEU_ENABLE_HART0
#define LIBERO_SETTING_BEU_ENABLE_HART0    BEU_ENABLE
#endif
#ifndef LIBERO_SETTING_BEU_ENABLE_HART1
#define LIBERO_SETTING_BEU_ENABLE_HART1    BEU_ENABLE
#endif
#ifndef LIBERO_SETTING_BEU_ENABLE_HART2
#define LIBERO_SETTING_BEU_ENABLE_HART2    BEU_ENABLE
#endif
#ifndef LIBERO_SETTING_BEU_ENABLE_HART3
#define LIBERO_SETTING_BEU_ENABLE_HART3    BEU_ENABLE
#endif
#ifndef LIBERO_SETTING_BEU_ENABLE_HART4
#define LIBERO_SETTING_BEU_ENABLE_HART4    BEU_ENABLE
#endif

#ifndef LIBERO_SETTING_BEU_PLIC_ENABLE_HART0
#define LIBERO_SETTING_BEU_PLIC_ENABLE_HART0    BEU_PLIC_INT
#endif
#ifndef LIBERO_SETTING_BEU_PLIC_ENABLE_HART1
#define LIBERO_SETTING_BEU_PLIC_ENABLE_HART1    BEU_PLIC_INT
#endif
#ifndef LIBERO_SETTING_BEU_PLIC_ENABLE_HART2
#define LIBERO_SETTING_BEU_PLIC_ENABLE_HART2    BEU_PLIC_INT
#endif
#ifndef LIBERO_SETTING_BEU_PLIC_ENABLE_HART3
#define LIBERO_SETTING_BEU_PLIC_ENABLE_HART3    BEU_PLIC_INT
#endif
#ifndef LIBERO_SETTING_BEU_PLIC_ENABLE_HART4
#define LIBERO_SETTING_BEU_PLIC_ENABLE_HART4    BEU_PLIC_INT
#endif

#ifndef LIBERO_SETTING_BEU_LOCAL_ENABLE_HART0
#define LIBERO_SETTING_BEU_LOCAL_ENABLE_HART0    BEU_LOCAL_INT
#endif
#ifndef LIBERO_SETTING_BEU_LOCAL_ENABLE_HART1
#define LIBERO_SETTING_BEU_LOCAL_ENABLE_HART1    BEU_LOCAL_INT
#endif
#ifndef LIBERO_SETTING_BEU_LOCAL_ENABLE_HART2
#define LIBERO_SETTING_BEU_LOCAL_ENABLE_HART2    BEU_LOCAL_INT
#endif
#ifndef LIBERO_SETTING_BEU_LOCAL_ENABLE_HART3
#define LIBERO_SETTING_BEU_LOCAL_ENABLE_HART3    BEU_LOCAL_INT
#endif
#ifndef LIBERO_SETTING_BEU_LOCAL_ENABLE_HART4
#define LIBERO_SETTING_BEU_LOCAL_ENABLE_HART4    BEU_LOCAL_INT
#endif

/***************************************************************************//**
  The handle_local_beu_interrupt() function is used to handle local interrupts
  generated by the Bus Error Unit (BEU)

  Example:
  @code
    void handle_local_beu_interrupt(void)
    {
        uint32_t hart_id = read_csr(mhartid);

        if(BEU->regs[hart_id].CAUSE == ECC2BIT)
        {
            while(1U);  wait for watchdog, or orderly reboot ...
        }
        // Clear ECC interrupt
        BEU->regs[hart_id].CAUSE       = 0ULL;
        BEU->regs[hart_id].ACCRUED     = 0ULL;
        BEU->regs[hart_id].VALUE       = 0ULL;
    }
  @endcode
 */
void handle_local_beu_interrupt(void);

/***************************************************************************//**
  The init_bus_error_unit() function is used to setup the Bus Error Unit (BEU)
  for all the harts used in the system. Define the defines
  (LIBERO_SETTING_BEU_ENABLE_HART0 etc) in mss_sw_config.h if you want to use
  non default values.
  Example:
  @code
    when all mem init, call the setup function
    init_bus_error_unit();
  @endcode
 */
uint8_t init_bus_error_unit(void);

#ifdef __cplusplus
}
#endif

#endif /*MSS_SEG_H*/
