/* GSequencer - Advanced GTK Sequencer
 * Copyright (C) 2005-2018 Joël Krähemann
 *
 * This file is part of GSequencer.
 *
 * GSequencer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GSequencer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GSequencer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __AGS_CAPTURE_SOUND_AUDIO_H__
#define __AGS_CAPTURE_SOUND_AUDIO_H__

#include <glib.h>
#include <glib-object.h>

#include <ags/audio/ags_recall_audio.h>

#define AGS_TYPE_CAPTURE_SOUND_AUDIO                (ags_capture_sound_audio_get_type())
#define AGS_CAPTURE_SOUND_AUDIO(obj)                (G_TYPE_CHECK_INSTANCE_CAST((obj), AGS_TYPE_CAPTURE_SOUND_AUDIO, AgsCaptureSoundAudio))
#define AGS_CAPTURE_SOUND_AUDIO_CLASS(class)        (G_TYPE_CHECK_CLASS_CAST((class), AGS_TYPE_CAPTURE_SOUND_AUDIO, AgsCaptureSoundAudio))
#define AGS_IS_CAPTURE_SOUND_AUDIO(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AGS_TYPE_CAPTURE_SOUND_AUDIO))
#define AGS_IS_CAPTURE_SOUND_AUDIO_CLASS(class)     (G_TYPE_CHECK_CLASS_TYPE ((class), AGS_TYPE_CAPTURE_SOUND_AUDIO))
#define AGS_CAPTURE_SOUND_AUDIO_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), AGS_TYPE_CAPTURE_SOUND_AUDIO, AgsCaptureSoundAudioClass))

typedef struct _AgsCaptureSoundAudio AgsCaptureSoundAudio;
typedef struct _AgsCaptureSoundAudioClass AgsCaptureSoundAudioClass;

struct _AgsCaptureSoundAudio
{
  AgsRecallAudio recall_audio;

  AgsPort *playback;

  AgsPort *record;
  AgsPort *filename;

  AgsPort *audio_channels;
  AgsPort *format;
  AgsPort *samplerate;
  AgsPort *buffer_size;
};

struct _AgsCaptureSoundAudioClass
{
  AgsRecallAudioClass recall_audio;
};

GType ags_capture_sound_audio_get_type();

AgsCaptureSoundAudio* ags_capture_sound_audio_new();

#endif /*__AGS_CAPTURE_SOUND_AUDIO_H__*/
