// Copyright 2022 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v5.29.4
// source: sigstore_verification.proto

package v1

import (
	v12 "github.com/sigstore/protobuf-specs/gen/pb-go/bundle/v1"
	v1 "github.com/sigstore/protobuf-specs/gen/pb-go/common/v1"
	v11 "github.com/sigstore/protobuf-specs/gen/pb-go/trustroot/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The identity of a X.509 Certificate signer.
type CertificateIdentity struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The X.509v3 issuer extension (OID 1.3.6.1.4.1.57264.1.1)
	Issuer string                     `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	San    *v1.SubjectAlternativeName `protobuf:"bytes,2,opt,name=san,proto3" json:"san,omitempty"`
	// An unordered list of OIDs that must be verified.
	// All OID/values provided in this list MUST exactly match against
	// the values in the certificate for verification to be successful.
	Oids          []*v1.ObjectIdentifierValuePair `protobuf:"bytes,3,rep,name=oids,proto3" json:"oids,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CertificateIdentity) Reset() {
	*x = CertificateIdentity{}
	mi := &file_sigstore_verification_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateIdentity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateIdentity) ProtoMessage() {}

func (x *CertificateIdentity) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateIdentity.ProtoReflect.Descriptor instead.
func (*CertificateIdentity) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{0}
}

func (x *CertificateIdentity) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *CertificateIdentity) GetSan() *v1.SubjectAlternativeName {
	if x != nil {
		return x.San
	}
	return nil
}

func (x *CertificateIdentity) GetOids() []*v1.ObjectIdentifierValuePair {
	if x != nil {
		return x.Oids
	}
	return nil
}

type CertificateIdentities struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Identities    []*CertificateIdentity `protobuf:"bytes,1,rep,name=identities,proto3" json:"identities,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CertificateIdentities) Reset() {
	*x = CertificateIdentities{}
	mi := &file_sigstore_verification_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateIdentities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateIdentities) ProtoMessage() {}

func (x *CertificateIdentities) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateIdentities.ProtoReflect.Descriptor instead.
func (*CertificateIdentities) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{1}
}

func (x *CertificateIdentities) GetIdentities() []*CertificateIdentity {
	if x != nil {
		return x.Identities
	}
	return nil
}

type PublicKeyIdentities struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PublicKeys    []*v1.PublicKey        `protobuf:"bytes,1,rep,name=public_keys,json=publicKeys,proto3" json:"public_keys,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PublicKeyIdentities) Reset() {
	*x = PublicKeyIdentities{}
	mi := &file_sigstore_verification_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublicKeyIdentities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKeyIdentities) ProtoMessage() {}

func (x *PublicKeyIdentities) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKeyIdentities.ProtoReflect.Descriptor instead.
func (*PublicKeyIdentities) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{2}
}

func (x *PublicKeyIdentities) GetPublicKeys() []*v1.PublicKey {
	if x != nil {
		return x.PublicKeys
	}
	return nil
}

// A light-weight set of options/policies for identifying trusted signers,
// used during verification of a single artifact.
type ArtifactVerificationOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// At least one identity MUST be provided. Providing zero identities
	// is an error. If at least one provided identity is found as a
	// signer, the verification is considered successful.
	//
	// Types that are valid to be assigned to Signers:
	//
	//	*ArtifactVerificationOptions_CertificateIdentities
	//	*ArtifactVerificationOptions_PublicKeys
	Signers isArtifactVerificationOptions_Signers `protobuf_oneof:"signers"`
	// Optional options for artifact transparency log verification.
	// If none is provided, the default verification options are:
	// Threshold: 1
	// Online verification: false
	// Disable: false
	TlogOptions *ArtifactVerificationOptions_TlogOptions `protobuf:"bytes,3,opt,name=tlog_options,json=tlogOptions,proto3,oneof" json:"tlog_options,omitempty"`
	// Optional options for certificate transparency log verification.
	// If none is provided, the default verification options are:
	// Threshold: 1
	// Disable: false
	CtlogOptions *ArtifactVerificationOptions_CtlogOptions `protobuf:"bytes,4,opt,name=ctlog_options,json=ctlogOptions,proto3,oneof" json:"ctlog_options,omitempty"`
	// Optional options for certificate signed timestamp verification.
	// If none is provided, the default verification options are:
	// Threshold: 0
	// Disable: true
	TsaOptions *ArtifactVerificationOptions_TimestampAuthorityOptions `protobuf:"bytes,5,opt,name=tsa_options,json=tsaOptions,proto3,oneof" json:"tsa_options,omitempty"`
	// Optional options for integrated timestamp verification.
	// If none is provided, the default verification options are:
	// Threshold: 0
	// Disable: true
	IntegratedTsOptions *ArtifactVerificationOptions_TlogIntegratedTimestampOptions `protobuf:"bytes,6,opt,name=integrated_ts_options,json=integratedTsOptions,proto3,oneof" json:"integrated_ts_options,omitempty"`
	// Optional options for observed timestamp verification.
	// If none is provided, the default verification options are:
	// Threshold 1
	// Disable: false
	ObserverOptions *ArtifactVerificationOptions_ObserverTimestampOptions `protobuf:"bytes,7,opt,name=observer_options,json=observerOptions,proto3,oneof" json:"observer_options,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ArtifactVerificationOptions) Reset() {
	*x = ArtifactVerificationOptions{}
	mi := &file_sigstore_verification_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArtifactVerificationOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactVerificationOptions) ProtoMessage() {}

func (x *ArtifactVerificationOptions) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactVerificationOptions.ProtoReflect.Descriptor instead.
func (*ArtifactVerificationOptions) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{3}
}

func (x *ArtifactVerificationOptions) GetSigners() isArtifactVerificationOptions_Signers {
	if x != nil {
		return x.Signers
	}
	return nil
}

func (x *ArtifactVerificationOptions) GetCertificateIdentities() *CertificateIdentities {
	if x != nil {
		if x, ok := x.Signers.(*ArtifactVerificationOptions_CertificateIdentities); ok {
			return x.CertificateIdentities
		}
	}
	return nil
}

func (x *ArtifactVerificationOptions) GetPublicKeys() *PublicKeyIdentities {
	if x != nil {
		if x, ok := x.Signers.(*ArtifactVerificationOptions_PublicKeys); ok {
			return x.PublicKeys
		}
	}
	return nil
}

func (x *ArtifactVerificationOptions) GetTlogOptions() *ArtifactVerificationOptions_TlogOptions {
	if x != nil {
		return x.TlogOptions
	}
	return nil
}

func (x *ArtifactVerificationOptions) GetCtlogOptions() *ArtifactVerificationOptions_CtlogOptions {
	if x != nil {
		return x.CtlogOptions
	}
	return nil
}

func (x *ArtifactVerificationOptions) GetTsaOptions() *ArtifactVerificationOptions_TimestampAuthorityOptions {
	if x != nil {
		return x.TsaOptions
	}
	return nil
}

func (x *ArtifactVerificationOptions) GetIntegratedTsOptions() *ArtifactVerificationOptions_TlogIntegratedTimestampOptions {
	if x != nil {
		return x.IntegratedTsOptions
	}
	return nil
}

func (x *ArtifactVerificationOptions) GetObserverOptions() *ArtifactVerificationOptions_ObserverTimestampOptions {
	if x != nil {
		return x.ObserverOptions
	}
	return nil
}

type isArtifactVerificationOptions_Signers interface {
	isArtifactVerificationOptions_Signers()
}

type ArtifactVerificationOptions_CertificateIdentities struct {
	CertificateIdentities *CertificateIdentities `protobuf:"bytes,1,opt,name=certificate_identities,json=certificateIdentities,proto3,oneof"`
}

type ArtifactVerificationOptions_PublicKeys struct {
	// To simplify verification implementation, the logic for
	// bundle verification should be implemented as a
	// higher-order function, where one of argument should be an
	// interface over the set of trusted public keys, like this:
	// `Verify(bytes artifact, bytes signature, string key_id)`.
	// This way the caller is in full control of mapping the
	// identified (or hinted) key in the bundle to one of the
	// trusted keys, as this process is inherently application
	// specific.
	PublicKeys *PublicKeyIdentities `protobuf:"bytes,2,opt,name=public_keys,json=publicKeys,proto3,oneof"`
}

func (*ArtifactVerificationOptions_CertificateIdentities) isArtifactVerificationOptions_Signers() {}

func (*ArtifactVerificationOptions_PublicKeys) isArtifactVerificationOptions_Signers() {}

type Artifact struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Data:
	//
	//	*Artifact_ArtifactUri
	//	*Artifact_Artifact
	//	*Artifact_ArtifactDigest
	Data          isArtifact_Data `protobuf_oneof:"data"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Artifact) Reset() {
	*x = Artifact{}
	mi := &file_sigstore_verification_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Artifact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Artifact) ProtoMessage() {}

func (x *Artifact) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Artifact.ProtoReflect.Descriptor instead.
func (*Artifact) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{4}
}

func (x *Artifact) GetData() isArtifact_Data {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Artifact) GetArtifactUri() string {
	if x != nil {
		if x, ok := x.Data.(*Artifact_ArtifactUri); ok {
			return x.ArtifactUri
		}
	}
	return ""
}

func (x *Artifact) GetArtifact() []byte {
	if x != nil {
		if x, ok := x.Data.(*Artifact_Artifact); ok {
			return x.Artifact
		}
	}
	return nil
}

func (x *Artifact) GetArtifactDigest() *v1.HashOutput {
	if x != nil {
		if x, ok := x.Data.(*Artifact_ArtifactDigest); ok {
			return x.ArtifactDigest
		}
	}
	return nil
}

type isArtifact_Data interface {
	isArtifact_Data()
}

type Artifact_ArtifactUri struct {
	// Location of the artifact
	ArtifactUri string `protobuf:"bytes,1,opt,name=artifact_uri,json=artifactUri,proto3,oneof"`
}

type Artifact_Artifact struct {
	// The raw bytes of the artifact
	Artifact []byte `protobuf:"bytes,2,opt,name=artifact,proto3,oneof"`
}

type Artifact_ArtifactDigest struct {
	// Digest of the artifact. SHOULD NOT be used when verifying an
	// in-toto attestation as the subject digest cannot be
	// reconstructed. This option will not work with Ed25519
	// signatures, use Ed25519Ph or another algorithm instead.
	ArtifactDigest *v1.HashOutput `protobuf:"bytes,3,opt,name=artifact_digest,json=artifactDigest,proto3,oneof"`
}

func (*Artifact_ArtifactUri) isArtifact_Data() {}

func (*Artifact_Artifact) isArtifact_Data() {}

func (*Artifact_ArtifactDigest) isArtifact_Data() {}

// Input captures all that is needed to call the bundle verification method,
// to verify a single artifact referenced by the bundle.
type Input struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The verification materials provided during a bundle verification.
	// The running process is usually preloaded with a "global"
	// dev.sisgtore.trustroot.TrustedRoot.v1 instance. Prior to
	// verifying an artifact (i.e a bundle), and/or based on current
	// policy, some selection is expected to happen, to filter out the
	// exact certificate authority to use, which transparency logs are
	// relevant etc. The result should b ecaptured in the
	// `artifact_trust_root`.
	ArtifactTrustRoot           *v11.TrustedRoot             `protobuf:"bytes,1,opt,name=artifact_trust_root,json=artifactTrustRoot,proto3" json:"artifact_trust_root,omitempty"`
	ArtifactVerificationOptions *ArtifactVerificationOptions `protobuf:"bytes,2,opt,name=artifact_verification_options,json=artifactVerificationOptions,proto3" json:"artifact_verification_options,omitempty"`
	Bundle                      *v12.Bundle                  `protobuf:"bytes,3,opt,name=bundle,proto3" json:"bundle,omitempty"`
	// If the bundle contains a message signature, the artifact must be
	// provided.
	Artifact      *Artifact `protobuf:"bytes,4,opt,name=artifact,proto3,oneof" json:"artifact,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Input) Reset() {
	*x = Input{}
	mi := &file_sigstore_verification_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Input) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Input) ProtoMessage() {}

func (x *Input) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Input.ProtoReflect.Descriptor instead.
func (*Input) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{5}
}

func (x *Input) GetArtifactTrustRoot() *v11.TrustedRoot {
	if x != nil {
		return x.ArtifactTrustRoot
	}
	return nil
}

func (x *Input) GetArtifactVerificationOptions() *ArtifactVerificationOptions {
	if x != nil {
		return x.ArtifactVerificationOptions
	}
	return nil
}

func (x *Input) GetBundle() *v12.Bundle {
	if x != nil {
		return x.Bundle
	}
	return nil
}

func (x *Input) GetArtifact() *Artifact {
	if x != nil {
		return x.Artifact
	}
	return nil
}

type ArtifactVerificationOptions_TlogOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Number of transparency logs the entry must appear on.
	Threshold int32 `protobuf:"varint,1,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// Perform an online inclusion proof.
	PerformOnlineVerification bool `protobuf:"varint,2,opt,name=perform_online_verification,json=performOnlineVerification,proto3" json:"perform_online_verification,omitempty"`
	// Disable verification for transparency logs.
	Disable       bool `protobuf:"varint,3,opt,name=disable,proto3" json:"disable,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ArtifactVerificationOptions_TlogOptions) Reset() {
	*x = ArtifactVerificationOptions_TlogOptions{}
	mi := &file_sigstore_verification_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArtifactVerificationOptions_TlogOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactVerificationOptions_TlogOptions) ProtoMessage() {}

func (x *ArtifactVerificationOptions_TlogOptions) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactVerificationOptions_TlogOptions.ProtoReflect.Descriptor instead.
func (*ArtifactVerificationOptions_TlogOptions) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ArtifactVerificationOptions_TlogOptions) GetThreshold() int32 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

func (x *ArtifactVerificationOptions_TlogOptions) GetPerformOnlineVerification() bool {
	if x != nil {
		return x.PerformOnlineVerification
	}
	return false
}

func (x *ArtifactVerificationOptions_TlogOptions) GetDisable() bool {
	if x != nil {
		return x.Disable
	}
	return false
}

type ArtifactVerificationOptions_CtlogOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of ct transparency logs the certificate must
	// appear on.
	Threshold int32 `protobuf:"varint,1,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// Disable ct transparency log verification
	Disable       bool `protobuf:"varint,3,opt,name=disable,proto3" json:"disable,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ArtifactVerificationOptions_CtlogOptions) Reset() {
	*x = ArtifactVerificationOptions_CtlogOptions{}
	mi := &file_sigstore_verification_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArtifactVerificationOptions_CtlogOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactVerificationOptions_CtlogOptions) ProtoMessage() {}

func (x *ArtifactVerificationOptions_CtlogOptions) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactVerificationOptions_CtlogOptions.ProtoReflect.Descriptor instead.
func (*ArtifactVerificationOptions_CtlogOptions) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{3, 1}
}

func (x *ArtifactVerificationOptions_CtlogOptions) GetThreshold() int32 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

func (x *ArtifactVerificationOptions_CtlogOptions) GetDisable() bool {
	if x != nil {
		return x.Disable
	}
	return false
}

type ArtifactVerificationOptions_TimestampAuthorityOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of signed timestamps that are expected.
	Threshold int32 `protobuf:"varint,1,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// Disable signed timestamp verification.
	Disable       bool `protobuf:"varint,2,opt,name=disable,proto3" json:"disable,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ArtifactVerificationOptions_TimestampAuthorityOptions) Reset() {
	*x = ArtifactVerificationOptions_TimestampAuthorityOptions{}
	mi := &file_sigstore_verification_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArtifactVerificationOptions_TimestampAuthorityOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactVerificationOptions_TimestampAuthorityOptions) ProtoMessage() {}

func (x *ArtifactVerificationOptions_TimestampAuthorityOptions) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactVerificationOptions_TimestampAuthorityOptions.ProtoReflect.Descriptor instead.
func (*ArtifactVerificationOptions_TimestampAuthorityOptions) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{3, 2}
}

func (x *ArtifactVerificationOptions_TimestampAuthorityOptions) GetThreshold() int32 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

func (x *ArtifactVerificationOptions_TimestampAuthorityOptions) GetDisable() bool {
	if x != nil {
		return x.Disable
	}
	return false
}

type ArtifactVerificationOptions_TlogIntegratedTimestampOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of integrated timestamps that are expected.
	Threshold int32 `protobuf:"varint,1,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// Disable integrated timestamp verification.
	Disable       bool `protobuf:"varint,2,opt,name=disable,proto3" json:"disable,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ArtifactVerificationOptions_TlogIntegratedTimestampOptions) Reset() {
	*x = ArtifactVerificationOptions_TlogIntegratedTimestampOptions{}
	mi := &file_sigstore_verification_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArtifactVerificationOptions_TlogIntegratedTimestampOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactVerificationOptions_TlogIntegratedTimestampOptions) ProtoMessage() {}

func (x *ArtifactVerificationOptions_TlogIntegratedTimestampOptions) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactVerificationOptions_TlogIntegratedTimestampOptions.ProtoReflect.Descriptor instead.
func (*ArtifactVerificationOptions_TlogIntegratedTimestampOptions) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{3, 3}
}

func (x *ArtifactVerificationOptions_TlogIntegratedTimestampOptions) GetThreshold() int32 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

func (x *ArtifactVerificationOptions_TlogIntegratedTimestampOptions) GetDisable() bool {
	if x != nil {
		return x.Disable
	}
	return false
}

type ArtifactVerificationOptions_ObserverTimestampOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of external observers of the timestamp.
	// This is a union of RFC3161 signed timestamps, and
	// integrated timestamps from a transparency log, that
	// could include additional timestamp sources in the
	// future.
	Threshold int32 `protobuf:"varint,1,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// Disable observer timestamp verification.
	Disable       bool `protobuf:"varint,2,opt,name=disable,proto3" json:"disable,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ArtifactVerificationOptions_ObserverTimestampOptions) Reset() {
	*x = ArtifactVerificationOptions_ObserverTimestampOptions{}
	mi := &file_sigstore_verification_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArtifactVerificationOptions_ObserverTimestampOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactVerificationOptions_ObserverTimestampOptions) ProtoMessage() {}

func (x *ArtifactVerificationOptions_ObserverTimestampOptions) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_verification_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactVerificationOptions_ObserverTimestampOptions.ProtoReflect.Descriptor instead.
func (*ArtifactVerificationOptions_ObserverTimestampOptions) Descriptor() ([]byte, []int) {
	return file_sigstore_verification_proto_rawDescGZIP(), []int{3, 4}
}

func (x *ArtifactVerificationOptions_ObserverTimestampOptions) GetThreshold() int32 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

func (x *ArtifactVerificationOptions_ObserverTimestampOptions) GetDisable() bool {
	if x != nil {
		return x.Disable
	}
	return false
}

var File_sigstore_verification_proto protoreflect.FileDescriptor

var file_sigstore_verification_proto_rawDesc = string([]byte{
	0x0a, 0x1b, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x64,
	0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x15, 0x73, 0x69, 0x67,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x18, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x72, 0x75,
	0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x73, 0x69,
	0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xb6, 0x01, 0x0a, 0x13, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x03, 0x73, 0x61, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x52, 0x03, 0x73, 0x61, 0x6e, 0x12, 0x45, 0x0a, 0x04, 0x6f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x52, 0x04, 0x6f, 0x69, 0x64, 0x73, 0x22, 0x6a, 0x0a, 0x15,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x64, 0x65, 0x76, 0x2e,
	0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x59, 0x0a, 0x13, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x42, 0x0a, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b,
	0x65, 0x79, 0x73, 0x22, 0x9c, 0x0b, 0x0a, 0x1b, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x6c, 0x0a, 0x16, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x15, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x54, 0x0a, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x6d, 0x0a, 0x0c, 0x74, 0x6c, 0x6f, 0x67, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e,
	0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54, 0x6c, 0x6f, 0x67, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52, 0x0b, 0x74, 0x6c, 0x6f, 0x67, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a, 0x0d, 0x63, 0x74, 0x6c, 0x6f, 0x67, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e,
	0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x74, 0x6c, 0x6f, 0x67, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x02, 0x52, 0x0c, 0x63, 0x74, 0x6c, 0x6f, 0x67, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x79, 0x0a, 0x0b, 0x74, 0x73, 0x61, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e,
	0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x48, 0x03, 0x52, 0x0a, 0x74, 0x73, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x91, 0x01, 0x0a, 0x15, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x74, 0x73, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54,
	0x6c, 0x6f, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x04, 0x52,
	0x13, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x54, 0x73, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x82, 0x01, 0x0a, 0x10, 0x6f, 0x62, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x52, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x62,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x05, 0x52, 0x0f, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x1a, 0x85, 0x01, 0x0a,
	0x0b, 0x54, 0x6c, 0x6f, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1c, 0x0a, 0x09,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x3e, 0x0a, 0x1b, 0x70, 0x65,
	0x72, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x19, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x1a, 0x4c, 0x0a, 0x0c, 0x43, 0x74, 0x6c, 0x6f, 0x67, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4a, 0x04, 0x08, 0x02,
	0x10, 0x03, 0x1a, 0x53, 0x0a, 0x19, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x1c, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x18, 0x0a,
	0x07, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x58, 0x0a, 0x1e, 0x54, 0x6c, 0x6f, 0x67, 0x49,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x1a, 0x52, 0x0a, 0x18, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1c, 0x0a,
	0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x73,
	0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x74, 0x6c, 0x6f, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63, 0x74, 0x6c, 0x6f, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x73, 0x61, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x74, 0x73, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x13, 0x0a,
	0x11, 0x5f, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0xa4, 0x01, 0x0a, 0x08, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12,
	0x23, 0x0a, 0x0c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x55, 0x72, 0x69, 0x12, 0x1c, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x12, 0x4d, 0x0a, 0x0f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65,
	0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x48,
	0x00, 0x52, 0x0e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0xec, 0x02, 0x0a, 0x05, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x56, 0x0a, 0x13, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x75,
	0x73, 0x74, 0x65, 0x64, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x11, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x54, 0x72, 0x75, 0x73, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x7d, 0x0a, 0x1d, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x1b, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x0a, 0x06, 0x62, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x64, 0x65, 0x76,
	0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x52, 0x06, 0x62, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x48, 0x00, 0x52, 0x08,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x42, 0x94, 0x01, 0x0a, 0x22, 0x64, 0x65, 0x76,
	0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42,
	0x11, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2d, 0x73, 0x70, 0x65, 0x63, 0x73, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x62, 0x2d,
	0x67, 0x6f, 0x2f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0xea, 0x02, 0x1a, 0x53, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a, 0x3a, 0x56,
	0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_sigstore_verification_proto_rawDescOnce sync.Once
	file_sigstore_verification_proto_rawDescData []byte
)

func file_sigstore_verification_proto_rawDescGZIP() []byte {
	file_sigstore_verification_proto_rawDescOnce.Do(func() {
		file_sigstore_verification_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_sigstore_verification_proto_rawDesc), len(file_sigstore_verification_proto_rawDesc)))
	})
	return file_sigstore_verification_proto_rawDescData
}

var file_sigstore_verification_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_sigstore_verification_proto_goTypes = []any{
	(*CertificateIdentity)(nil),                                        // 0: dev.sigstore.verification.v1.CertificateIdentity
	(*CertificateIdentities)(nil),                                      // 1: dev.sigstore.verification.v1.CertificateIdentities
	(*PublicKeyIdentities)(nil),                                        // 2: dev.sigstore.verification.v1.PublicKeyIdentities
	(*ArtifactVerificationOptions)(nil),                                // 3: dev.sigstore.verification.v1.ArtifactVerificationOptions
	(*Artifact)(nil),                                                   // 4: dev.sigstore.verification.v1.Artifact
	(*Input)(nil),                                                      // 5: dev.sigstore.verification.v1.Input
	(*ArtifactVerificationOptions_TlogOptions)(nil),                    // 6: dev.sigstore.verification.v1.ArtifactVerificationOptions.TlogOptions
	(*ArtifactVerificationOptions_CtlogOptions)(nil),                   // 7: dev.sigstore.verification.v1.ArtifactVerificationOptions.CtlogOptions
	(*ArtifactVerificationOptions_TimestampAuthorityOptions)(nil),      // 8: dev.sigstore.verification.v1.ArtifactVerificationOptions.TimestampAuthorityOptions
	(*ArtifactVerificationOptions_TlogIntegratedTimestampOptions)(nil), // 9: dev.sigstore.verification.v1.ArtifactVerificationOptions.TlogIntegratedTimestampOptions
	(*ArtifactVerificationOptions_ObserverTimestampOptions)(nil),       // 10: dev.sigstore.verification.v1.ArtifactVerificationOptions.ObserverTimestampOptions
	(*v1.SubjectAlternativeName)(nil),                                  // 11: dev.sigstore.common.v1.SubjectAlternativeName
	(*v1.ObjectIdentifierValuePair)(nil),                               // 12: dev.sigstore.common.v1.ObjectIdentifierValuePair
	(*v1.PublicKey)(nil),                                               // 13: dev.sigstore.common.v1.PublicKey
	(*v1.HashOutput)(nil),                                              // 14: dev.sigstore.common.v1.HashOutput
	(*v11.TrustedRoot)(nil),                                            // 15: dev.sigstore.trustroot.v1.TrustedRoot
	(*v12.Bundle)(nil),                                                 // 16: dev.sigstore.bundle.v1.Bundle
}
var file_sigstore_verification_proto_depIdxs = []int32{
	11, // 0: dev.sigstore.verification.v1.CertificateIdentity.san:type_name -> dev.sigstore.common.v1.SubjectAlternativeName
	12, // 1: dev.sigstore.verification.v1.CertificateIdentity.oids:type_name -> dev.sigstore.common.v1.ObjectIdentifierValuePair
	0,  // 2: dev.sigstore.verification.v1.CertificateIdentities.identities:type_name -> dev.sigstore.verification.v1.CertificateIdentity
	13, // 3: dev.sigstore.verification.v1.PublicKeyIdentities.public_keys:type_name -> dev.sigstore.common.v1.PublicKey
	1,  // 4: dev.sigstore.verification.v1.ArtifactVerificationOptions.certificate_identities:type_name -> dev.sigstore.verification.v1.CertificateIdentities
	2,  // 5: dev.sigstore.verification.v1.ArtifactVerificationOptions.public_keys:type_name -> dev.sigstore.verification.v1.PublicKeyIdentities
	6,  // 6: dev.sigstore.verification.v1.ArtifactVerificationOptions.tlog_options:type_name -> dev.sigstore.verification.v1.ArtifactVerificationOptions.TlogOptions
	7,  // 7: dev.sigstore.verification.v1.ArtifactVerificationOptions.ctlog_options:type_name -> dev.sigstore.verification.v1.ArtifactVerificationOptions.CtlogOptions
	8,  // 8: dev.sigstore.verification.v1.ArtifactVerificationOptions.tsa_options:type_name -> dev.sigstore.verification.v1.ArtifactVerificationOptions.TimestampAuthorityOptions
	9,  // 9: dev.sigstore.verification.v1.ArtifactVerificationOptions.integrated_ts_options:type_name -> dev.sigstore.verification.v1.ArtifactVerificationOptions.TlogIntegratedTimestampOptions
	10, // 10: dev.sigstore.verification.v1.ArtifactVerificationOptions.observer_options:type_name -> dev.sigstore.verification.v1.ArtifactVerificationOptions.ObserverTimestampOptions
	14, // 11: dev.sigstore.verification.v1.Artifact.artifact_digest:type_name -> dev.sigstore.common.v1.HashOutput
	15, // 12: dev.sigstore.verification.v1.Input.artifact_trust_root:type_name -> dev.sigstore.trustroot.v1.TrustedRoot
	3,  // 13: dev.sigstore.verification.v1.Input.artifact_verification_options:type_name -> dev.sigstore.verification.v1.ArtifactVerificationOptions
	16, // 14: dev.sigstore.verification.v1.Input.bundle:type_name -> dev.sigstore.bundle.v1.Bundle
	4,  // 15: dev.sigstore.verification.v1.Input.artifact:type_name -> dev.sigstore.verification.v1.Artifact
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_sigstore_verification_proto_init() }
func file_sigstore_verification_proto_init() {
	if File_sigstore_verification_proto != nil {
		return
	}
	file_sigstore_verification_proto_msgTypes[3].OneofWrappers = []any{
		(*ArtifactVerificationOptions_CertificateIdentities)(nil),
		(*ArtifactVerificationOptions_PublicKeys)(nil),
	}
	file_sigstore_verification_proto_msgTypes[4].OneofWrappers = []any{
		(*Artifact_ArtifactUri)(nil),
		(*Artifact_Artifact)(nil),
		(*Artifact_ArtifactDigest)(nil),
	}
	file_sigstore_verification_proto_msgTypes[5].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_sigstore_verification_proto_rawDesc), len(file_sigstore_verification_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sigstore_verification_proto_goTypes,
		DependencyIndexes: file_sigstore_verification_proto_depIdxs,
		MessageInfos:      file_sigstore_verification_proto_msgTypes,
	}.Build()
	File_sigstore_verification_proto = out.File
	file_sigstore_verification_proto_goTypes = nil
	file_sigstore_verification_proto_depIdxs = nil
}
