// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists eventbridge rule template groups.
func (c *Client) ListEventBridgeRuleTemplateGroups(ctx context.Context, params *ListEventBridgeRuleTemplateGroupsInput, optFns ...func(*Options)) (*ListEventBridgeRuleTemplateGroupsOutput, error) {
	if params == nil {
		params = &ListEventBridgeRuleTemplateGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEventBridgeRuleTemplateGroups", params, optFns, c.addOperationListEventBridgeRuleTemplateGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEventBridgeRuleTemplateGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
type ListEventBridgeRuleTemplateGroupsInput struct {

	// Placeholder documentation for MaxResults
	MaxResults *int32

	// A token used to retrieve the next set of results in paginated list responses.
	NextToken *string

	// A signal map's identifier. Can be either be its id or current name.
	SignalMapIdentifier *string

	noSmithyDocumentSerde
}

// Placeholder documentation for ListEventBridgeRuleTemplateGroupsResponse
type ListEventBridgeRuleTemplateGroupsOutput struct {

	// Placeholder documentation for __listOfEventBridgeRuleTemplateGroupSummary
	EventBridgeRuleTemplateGroups []types.EventBridgeRuleTemplateGroupSummary

	// A token used to retrieve the next set of results in paginated list responses.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEventBridgeRuleTemplateGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEventBridgeRuleTemplateGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEventBridgeRuleTemplateGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEventBridgeRuleTemplateGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEventBridgeRuleTemplateGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListEventBridgeRuleTemplateGroupsPaginatorOptions is the paginator options for
// ListEventBridgeRuleTemplateGroups
type ListEventBridgeRuleTemplateGroupsPaginatorOptions struct {
	// Placeholder documentation for MaxResults
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEventBridgeRuleTemplateGroupsPaginator is a paginator for
// ListEventBridgeRuleTemplateGroups
type ListEventBridgeRuleTemplateGroupsPaginator struct {
	options   ListEventBridgeRuleTemplateGroupsPaginatorOptions
	client    ListEventBridgeRuleTemplateGroupsAPIClient
	params    *ListEventBridgeRuleTemplateGroupsInput
	nextToken *string
	firstPage bool
}

// NewListEventBridgeRuleTemplateGroupsPaginator returns a new
// ListEventBridgeRuleTemplateGroupsPaginator
func NewListEventBridgeRuleTemplateGroupsPaginator(client ListEventBridgeRuleTemplateGroupsAPIClient, params *ListEventBridgeRuleTemplateGroupsInput, optFns ...func(*ListEventBridgeRuleTemplateGroupsPaginatorOptions)) *ListEventBridgeRuleTemplateGroupsPaginator {
	if params == nil {
		params = &ListEventBridgeRuleTemplateGroupsInput{}
	}

	options := ListEventBridgeRuleTemplateGroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEventBridgeRuleTemplateGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEventBridgeRuleTemplateGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEventBridgeRuleTemplateGroups page.
func (p *ListEventBridgeRuleTemplateGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEventBridgeRuleTemplateGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEventBridgeRuleTemplateGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEventBridgeRuleTemplateGroupsAPIClient is a client that implements the
// ListEventBridgeRuleTemplateGroups operation.
type ListEventBridgeRuleTemplateGroupsAPIClient interface {
	ListEventBridgeRuleTemplateGroups(context.Context, *ListEventBridgeRuleTemplateGroupsInput, ...func(*Options)) (*ListEventBridgeRuleTemplateGroupsOutput, error)
}

var _ ListEventBridgeRuleTemplateGroupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEventBridgeRuleTemplateGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEventBridgeRuleTemplateGroups",
	}
}
