/*
 * Copyright (c) 2016-2019 by pwessel
 * See LICENSE.TXT file for copying and redistribution conditions.
 */

/* gmt_mbsystem_module.h declares the prototypes for mbsystem module functions
 * and the array that contains mbsystem GMT module parameters such as name
 * and purpose strings.
 * DO NOT edit this file directly! Regenerate the file by running
 *	 gmt_make_custom_code.sh mbsystem
 */

#pragma once
#ifndef GMT_MBSYSTEM_MODULE_H
#define GMT_MBSYSTEM_MODULE_H

#ifdef __cplusplus /* Basic C++ support */
extern "C" {
#endif

/* Declaration modifiers for DLL support (MSC et al) */
#include "declspec.h"

/* Prototypes of all modules in the GMT mbsystem library */
EXTERN_MSC int GMT_mbcontour (void *API, int mode, void *args);
EXTERN_MSC int GMT_mbgrdtiff (void *API, int mode, void *args);
EXTERN_MSC int GMT_mbswath (void *API, int mode, void *args);

/* Pretty print all modules in the GMT mbsystem library and their purposes */
EXTERN_MSC void gmt_mbsystem_module_show_all (void *API);
/* List all modules in the GMT mbsystem library to stdout */
EXTERN_MSC void gmt_mbsystem_module_list_all (void *API);
/* Function called by GMT_Encode_Options so developers can get information about a module */
EXTERN_MSC const char * gmt_mbsystem_module_info (void *API, char *candidate);

#ifdef __cplusplus
}
#endif

#endif /* !GMT_MBSYSTEM_MODULE_H */
