// Code generated by protoc-gen-go. DO NOT EDIT.
// source: diff.proto

package gitalypb

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type CommitDiffRequest_DiffMode int32

const (
	// DEFAULT is the standard diff mode and results in a linewise diff for textfiles.
	CommitDiffRequest_DEFAULT CommitDiffRequest_DiffMode = 0
	// WORDDIFF is a word diff and computes the diff for whitespace separated words instead of for whole lines.
	CommitDiffRequest_WORDDIFF CommitDiffRequest_DiffMode = 1
)

var CommitDiffRequest_DiffMode_name = map[int32]string{
	0: "DEFAULT",
	1: "WORDDIFF",
}

var CommitDiffRequest_DiffMode_value = map[string]int32{
	"DEFAULT":  0,
	"WORDDIFF": 1,
}

func (x CommitDiffRequest_DiffMode) String() string {
	return proto.EnumName(CommitDiffRequest_DiffMode_name, int32(x))
}

func (CommitDiffRequest_DiffMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{0, 0}
}

type ChangedPaths_Status int32

const (
	ChangedPaths_ADDED       ChangedPaths_Status = 0
	ChangedPaths_MODIFIED    ChangedPaths_Status = 1
	ChangedPaths_DELETED     ChangedPaths_Status = 2
	ChangedPaths_TYPE_CHANGE ChangedPaths_Status = 3
	ChangedPaths_COPIED      ChangedPaths_Status = 4
)

var ChangedPaths_Status_name = map[int32]string{
	0: "ADDED",
	1: "MODIFIED",
	2: "DELETED",
	3: "TYPE_CHANGE",
	4: "COPIED",
}

var ChangedPaths_Status_value = map[string]int32{
	"ADDED":       0,
	"MODIFIED":    1,
	"DELETED":     2,
	"TYPE_CHANGE": 3,
	"COPIED":      4,
}

func (x ChangedPaths_Status) String() string {
	return proto.EnumName(ChangedPaths_Status_name, int32(x))
}

func (ChangedPaths_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{14, 0}
}

type CommitDiffRequest struct {
	Repository             *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId           string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId          string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	IgnoreWhitespaceChange bool        `protobuf:"varint,4,opt,name=ignore_whitespace_change,json=ignoreWhitespaceChange,proto3" json:"ignore_whitespace_change,omitempty"`
	Paths                  [][]byte    `protobuf:"bytes,5,rep,name=paths,proto3" json:"paths,omitempty"`
	CollapseDiffs          bool        `protobuf:"varint,6,opt,name=collapse_diffs,json=collapseDiffs,proto3" json:"collapse_diffs,omitempty"`
	EnforceLimits          bool        `protobuf:"varint,7,opt,name=enforce_limits,json=enforceLimits,proto3" json:"enforce_limits,omitempty"`
	// These limits are only enforced when enforce_limits == true.
	MaxFiles int32 `protobuf:"varint,8,opt,name=max_files,json=maxFiles,proto3" json:"max_files,omitempty"`
	MaxLines int32 `protobuf:"varint,9,opt,name=max_lines,json=maxLines,proto3" json:"max_lines,omitempty"`
	MaxBytes int32 `protobuf:"varint,10,opt,name=max_bytes,json=maxBytes,proto3" json:"max_bytes,omitempty"`
	// Limitation of a single diff patch,
	// patches surpassing this limit are pruned by default.
	// If this is 0 you will get back empty patches.
	MaxPatchBytes int32 `protobuf:"varint,14,opt,name=max_patch_bytes,json=maxPatchBytes,proto3" json:"max_patch_bytes,omitempty"`
	// These limits are only enforced if collapse_diffs == true.
	SafeMaxFiles int32 `protobuf:"varint,11,opt,name=safe_max_files,json=safeMaxFiles,proto3" json:"safe_max_files,omitempty"`
	SafeMaxLines int32 `protobuf:"varint,12,opt,name=safe_max_lines,json=safeMaxLines,proto3" json:"safe_max_lines,omitempty"`
	SafeMaxBytes int32 `protobuf:"varint,13,opt,name=safe_max_bytes,json=safeMaxBytes,proto3" json:"safe_max_bytes,omitempty"`
	// DiffMode is the mode used for generating the diff. Please refer to the enum declaration for supported modes.
	DiffMode             CommitDiffRequest_DiffMode `protobuf:"varint,15,opt,name=diff_mode,json=diffMode,proto3,enum=gitaly.CommitDiffRequest_DiffMode" json:"diff_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *CommitDiffRequest) Reset()         { *m = CommitDiffRequest{} }
func (m *CommitDiffRequest) String() string { return proto.CompactTextString(m) }
func (*CommitDiffRequest) ProtoMessage()    {}
func (*CommitDiffRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{0}
}

func (m *CommitDiffRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDiffRequest.Unmarshal(m, b)
}
func (m *CommitDiffRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDiffRequest.Marshal(b, m, deterministic)
}
func (m *CommitDiffRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDiffRequest.Merge(m, src)
}
func (m *CommitDiffRequest) XXX_Size() int {
	return xxx_messageInfo_CommitDiffRequest.Size(m)
}
func (m *CommitDiffRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDiffRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDiffRequest proto.InternalMessageInfo

func (m *CommitDiffRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitDiffRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *CommitDiffRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

func (m *CommitDiffRequest) GetIgnoreWhitespaceChange() bool {
	if m != nil {
		return m.IgnoreWhitespaceChange
	}
	return false
}

func (m *CommitDiffRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *CommitDiffRequest) GetCollapseDiffs() bool {
	if m != nil {
		return m.CollapseDiffs
	}
	return false
}

func (m *CommitDiffRequest) GetEnforceLimits() bool {
	if m != nil {
		return m.EnforceLimits
	}
	return false
}

func (m *CommitDiffRequest) GetMaxFiles() int32 {
	if m != nil {
		return m.MaxFiles
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxLines() int32 {
	if m != nil {
		return m.MaxLines
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxBytes() int32 {
	if m != nil {
		return m.MaxBytes
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxPatchBytes() int32 {
	if m != nil {
		return m.MaxPatchBytes
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxFiles() int32 {
	if m != nil {
		return m.SafeMaxFiles
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxLines() int32 {
	if m != nil {
		return m.SafeMaxLines
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxBytes() int32 {
	if m != nil {
		return m.SafeMaxBytes
	}
	return 0
}

func (m *CommitDiffRequest) GetDiffMode() CommitDiffRequest_DiffMode {
	if m != nil {
		return m.DiffMode
	}
	return CommitDiffRequest_DEFAULT
}

// A CommitDiffResponse corresponds to a single changed file in a commit.
type CommitDiffResponse struct {
	FromPath []byte `protobuf:"bytes,1,opt,name=from_path,json=fromPath,proto3" json:"from_path,omitempty"`
	ToPath   []byte `protobuf:"bytes,2,opt,name=to_path,json=toPath,proto3" json:"to_path,omitempty"`
	// Blob ID as returned via `git diff --full-index`
	FromId       string `protobuf:"bytes,3,opt,name=from_id,json=fromId,proto3" json:"from_id,omitempty"`
	ToId         string `protobuf:"bytes,4,opt,name=to_id,json=toId,proto3" json:"to_id,omitempty"`
	OldMode      int32  `protobuf:"varint,5,opt,name=old_mode,json=oldMode,proto3" json:"old_mode,omitempty"`
	NewMode      int32  `protobuf:"varint,6,opt,name=new_mode,json=newMode,proto3" json:"new_mode,omitempty"`
	Binary       bool   `protobuf:"varint,7,opt,name=binary,proto3" json:"binary,omitempty"`
	RawPatchData []byte `protobuf:"bytes,9,opt,name=raw_patch_data,json=rawPatchData,proto3" json:"raw_patch_data,omitempty"`
	EndOfPatch   bool   `protobuf:"varint,10,opt,name=end_of_patch,json=endOfPatch,proto3" json:"end_of_patch,omitempty"`
	// Indicates the diff file at which we overflow according to the limitations sent,
	// in which case only this attribute will be set.
	OverflowMarker bool `protobuf:"varint,11,opt,name=overflow_marker,json=overflowMarker,proto3" json:"overflow_marker,omitempty"`
	// Indicates the patch surpassed a "safe" limit and was therefore pruned, but
	// the client may still request the full patch on a separate request.
	Collapsed bool `protobuf:"varint,12,opt,name=collapsed,proto3" json:"collapsed,omitempty"`
	// Indicates the patch was pruned since it surpassed a hard limit, and can
	// therefore not be expanded.
	TooLarge             bool     `protobuf:"varint,13,opt,name=too_large,json=tooLarge,proto3" json:"too_large,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitDiffResponse) Reset()         { *m = CommitDiffResponse{} }
func (m *CommitDiffResponse) String() string { return proto.CompactTextString(m) }
func (*CommitDiffResponse) ProtoMessage()    {}
func (*CommitDiffResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{1}
}

func (m *CommitDiffResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDiffResponse.Unmarshal(m, b)
}
func (m *CommitDiffResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDiffResponse.Marshal(b, m, deterministic)
}
func (m *CommitDiffResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDiffResponse.Merge(m, src)
}
func (m *CommitDiffResponse) XXX_Size() int {
	return xxx_messageInfo_CommitDiffResponse.Size(m)
}
func (m *CommitDiffResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDiffResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDiffResponse proto.InternalMessageInfo

func (m *CommitDiffResponse) GetFromPath() []byte {
	if m != nil {
		return m.FromPath
	}
	return nil
}

func (m *CommitDiffResponse) GetToPath() []byte {
	if m != nil {
		return m.ToPath
	}
	return nil
}

func (m *CommitDiffResponse) GetFromId() string {
	if m != nil {
		return m.FromId
	}
	return ""
}

func (m *CommitDiffResponse) GetToId() string {
	if m != nil {
		return m.ToId
	}
	return ""
}

func (m *CommitDiffResponse) GetOldMode() int32 {
	if m != nil {
		return m.OldMode
	}
	return 0
}

func (m *CommitDiffResponse) GetNewMode() int32 {
	if m != nil {
		return m.NewMode
	}
	return 0
}

func (m *CommitDiffResponse) GetBinary() bool {
	if m != nil {
		return m.Binary
	}
	return false
}

func (m *CommitDiffResponse) GetRawPatchData() []byte {
	if m != nil {
		return m.RawPatchData
	}
	return nil
}

func (m *CommitDiffResponse) GetEndOfPatch() bool {
	if m != nil {
		return m.EndOfPatch
	}
	return false
}

func (m *CommitDiffResponse) GetOverflowMarker() bool {
	if m != nil {
		return m.OverflowMarker
	}
	return false
}

func (m *CommitDiffResponse) GetCollapsed() bool {
	if m != nil {
		return m.Collapsed
	}
	return false
}

func (m *CommitDiffResponse) GetTooLarge() bool {
	if m != nil {
		return m.TooLarge
	}
	return false
}

type CommitDeltaRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId         string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId        string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	Paths                [][]byte    `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CommitDeltaRequest) Reset()         { *m = CommitDeltaRequest{} }
func (m *CommitDeltaRequest) String() string { return proto.CompactTextString(m) }
func (*CommitDeltaRequest) ProtoMessage()    {}
func (*CommitDeltaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{2}
}

func (m *CommitDeltaRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDeltaRequest.Unmarshal(m, b)
}
func (m *CommitDeltaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDeltaRequest.Marshal(b, m, deterministic)
}
func (m *CommitDeltaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDeltaRequest.Merge(m, src)
}
func (m *CommitDeltaRequest) XXX_Size() int {
	return xxx_messageInfo_CommitDeltaRequest.Size(m)
}
func (m *CommitDeltaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDeltaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDeltaRequest proto.InternalMessageInfo

func (m *CommitDeltaRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitDeltaRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *CommitDeltaRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

func (m *CommitDeltaRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

type CommitDelta struct {
	FromPath []byte `protobuf:"bytes,1,opt,name=from_path,json=fromPath,proto3" json:"from_path,omitempty"`
	ToPath   []byte `protobuf:"bytes,2,opt,name=to_path,json=toPath,proto3" json:"to_path,omitempty"`
	// Blob ID as returned via `git diff --full-index`
	FromId               string   `protobuf:"bytes,3,opt,name=from_id,json=fromId,proto3" json:"from_id,omitempty"`
	ToId                 string   `protobuf:"bytes,4,opt,name=to_id,json=toId,proto3" json:"to_id,omitempty"`
	OldMode              int32    `protobuf:"varint,5,opt,name=old_mode,json=oldMode,proto3" json:"old_mode,omitempty"`
	NewMode              int32    `protobuf:"varint,6,opt,name=new_mode,json=newMode,proto3" json:"new_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitDelta) Reset()         { *m = CommitDelta{} }
func (m *CommitDelta) String() string { return proto.CompactTextString(m) }
func (*CommitDelta) ProtoMessage()    {}
func (*CommitDelta) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{3}
}

func (m *CommitDelta) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDelta.Unmarshal(m, b)
}
func (m *CommitDelta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDelta.Marshal(b, m, deterministic)
}
func (m *CommitDelta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDelta.Merge(m, src)
}
func (m *CommitDelta) XXX_Size() int {
	return xxx_messageInfo_CommitDelta.Size(m)
}
func (m *CommitDelta) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDelta.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDelta proto.InternalMessageInfo

func (m *CommitDelta) GetFromPath() []byte {
	if m != nil {
		return m.FromPath
	}
	return nil
}

func (m *CommitDelta) GetToPath() []byte {
	if m != nil {
		return m.ToPath
	}
	return nil
}

func (m *CommitDelta) GetFromId() string {
	if m != nil {
		return m.FromId
	}
	return ""
}

func (m *CommitDelta) GetToId() string {
	if m != nil {
		return m.ToId
	}
	return ""
}

func (m *CommitDelta) GetOldMode() int32 {
	if m != nil {
		return m.OldMode
	}
	return 0
}

func (m *CommitDelta) GetNewMode() int32 {
	if m != nil {
		return m.NewMode
	}
	return 0
}

type CommitDeltaResponse struct {
	Deltas               []*CommitDelta `protobuf:"bytes,1,rep,name=deltas,proto3" json:"deltas,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CommitDeltaResponse) Reset()         { *m = CommitDeltaResponse{} }
func (m *CommitDeltaResponse) String() string { return proto.CompactTextString(m) }
func (*CommitDeltaResponse) ProtoMessage()    {}
func (*CommitDeltaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{4}
}

func (m *CommitDeltaResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDeltaResponse.Unmarshal(m, b)
}
func (m *CommitDeltaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDeltaResponse.Marshal(b, m, deterministic)
}
func (m *CommitDeltaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDeltaResponse.Merge(m, src)
}
func (m *CommitDeltaResponse) XXX_Size() int {
	return xxx_messageInfo_CommitDeltaResponse.Size(m)
}
func (m *CommitDeltaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDeltaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDeltaResponse proto.InternalMessageInfo

func (m *CommitDeltaResponse) GetDeltas() []*CommitDelta {
	if m != nil {
		return m.Deltas
	}
	return nil
}

type RawDiffRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId         string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId        string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RawDiffRequest) Reset()         { *m = RawDiffRequest{} }
func (m *RawDiffRequest) String() string { return proto.CompactTextString(m) }
func (*RawDiffRequest) ProtoMessage()    {}
func (*RawDiffRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{5}
}

func (m *RawDiffRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawDiffRequest.Unmarshal(m, b)
}
func (m *RawDiffRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawDiffRequest.Marshal(b, m, deterministic)
}
func (m *RawDiffRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawDiffRequest.Merge(m, src)
}
func (m *RawDiffRequest) XXX_Size() int {
	return xxx_messageInfo_RawDiffRequest.Size(m)
}
func (m *RawDiffRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawDiffRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawDiffRequest proto.InternalMessageInfo

func (m *RawDiffRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RawDiffRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *RawDiffRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

type RawDiffResponse struct {
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawDiffResponse) Reset()         { *m = RawDiffResponse{} }
func (m *RawDiffResponse) String() string { return proto.CompactTextString(m) }
func (*RawDiffResponse) ProtoMessage()    {}
func (*RawDiffResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{6}
}

func (m *RawDiffResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawDiffResponse.Unmarshal(m, b)
}
func (m *RawDiffResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawDiffResponse.Marshal(b, m, deterministic)
}
func (m *RawDiffResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawDiffResponse.Merge(m, src)
}
func (m *RawDiffResponse) XXX_Size() int {
	return xxx_messageInfo_RawDiffResponse.Size(m)
}
func (m *RawDiffResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawDiffResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawDiffResponse proto.InternalMessageInfo

func (m *RawDiffResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type RawPatchRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId         string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId        string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RawPatchRequest) Reset()         { *m = RawPatchRequest{} }
func (m *RawPatchRequest) String() string { return proto.CompactTextString(m) }
func (*RawPatchRequest) ProtoMessage()    {}
func (*RawPatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{7}
}

func (m *RawPatchRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawPatchRequest.Unmarshal(m, b)
}
func (m *RawPatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawPatchRequest.Marshal(b, m, deterministic)
}
func (m *RawPatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawPatchRequest.Merge(m, src)
}
func (m *RawPatchRequest) XXX_Size() int {
	return xxx_messageInfo_RawPatchRequest.Size(m)
}
func (m *RawPatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawPatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawPatchRequest proto.InternalMessageInfo

func (m *RawPatchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RawPatchRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *RawPatchRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

type RawPatchResponse struct {
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawPatchResponse) Reset()         { *m = RawPatchResponse{} }
func (m *RawPatchResponse) String() string { return proto.CompactTextString(m) }
func (*RawPatchResponse) ProtoMessage()    {}
func (*RawPatchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{8}
}

func (m *RawPatchResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawPatchResponse.Unmarshal(m, b)
}
func (m *RawPatchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawPatchResponse.Marshal(b, m, deterministic)
}
func (m *RawPatchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawPatchResponse.Merge(m, src)
}
func (m *RawPatchResponse) XXX_Size() int {
	return xxx_messageInfo_RawPatchResponse.Size(m)
}
func (m *RawPatchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawPatchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawPatchResponse proto.InternalMessageInfo

func (m *RawPatchResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type DiffStatsRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId         string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId        string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *DiffStatsRequest) Reset()         { *m = DiffStatsRequest{} }
func (m *DiffStatsRequest) String() string { return proto.CompactTextString(m) }
func (*DiffStatsRequest) ProtoMessage()    {}
func (*DiffStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{9}
}

func (m *DiffStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiffStatsRequest.Unmarshal(m, b)
}
func (m *DiffStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiffStatsRequest.Marshal(b, m, deterministic)
}
func (m *DiffStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiffStatsRequest.Merge(m, src)
}
func (m *DiffStatsRequest) XXX_Size() int {
	return xxx_messageInfo_DiffStatsRequest.Size(m)
}
func (m *DiffStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DiffStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DiffStatsRequest proto.InternalMessageInfo

func (m *DiffStatsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *DiffStatsRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *DiffStatsRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

type DiffStats struct {
	Path                 []byte   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Additions            int32    `protobuf:"varint,2,opt,name=additions,proto3" json:"additions,omitempty"`
	Deletions            int32    `protobuf:"varint,3,opt,name=deletions,proto3" json:"deletions,omitempty"`
	OldPath              []byte   `protobuf:"bytes,4,opt,name=old_path,json=oldPath,proto3" json:"old_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiffStats) Reset()         { *m = DiffStats{} }
func (m *DiffStats) String() string { return proto.CompactTextString(m) }
func (*DiffStats) ProtoMessage()    {}
func (*DiffStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{10}
}

func (m *DiffStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiffStats.Unmarshal(m, b)
}
func (m *DiffStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiffStats.Marshal(b, m, deterministic)
}
func (m *DiffStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiffStats.Merge(m, src)
}
func (m *DiffStats) XXX_Size() int {
	return xxx_messageInfo_DiffStats.Size(m)
}
func (m *DiffStats) XXX_DiscardUnknown() {
	xxx_messageInfo_DiffStats.DiscardUnknown(m)
}

var xxx_messageInfo_DiffStats proto.InternalMessageInfo

func (m *DiffStats) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *DiffStats) GetAdditions() int32 {
	if m != nil {
		return m.Additions
	}
	return 0
}

func (m *DiffStats) GetDeletions() int32 {
	if m != nil {
		return m.Deletions
	}
	return 0
}

func (m *DiffStats) GetOldPath() []byte {
	if m != nil {
		return m.OldPath
	}
	return nil
}

type DiffStatsResponse struct {
	Stats                []*DiffStats `protobuf:"bytes,1,rep,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DiffStatsResponse) Reset()         { *m = DiffStatsResponse{} }
func (m *DiffStatsResponse) String() string { return proto.CompactTextString(m) }
func (*DiffStatsResponse) ProtoMessage()    {}
func (*DiffStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{11}
}

func (m *DiffStatsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiffStatsResponse.Unmarshal(m, b)
}
func (m *DiffStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiffStatsResponse.Marshal(b, m, deterministic)
}
func (m *DiffStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiffStatsResponse.Merge(m, src)
}
func (m *DiffStatsResponse) XXX_Size() int {
	return xxx_messageInfo_DiffStatsResponse.Size(m)
}
func (m *DiffStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DiffStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DiffStatsResponse proto.InternalMessageInfo

func (m *DiffStatsResponse) GetStats() []*DiffStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

// Given a list of commits, return the files changed. Each commit is compared
// to its parent. Merge commits will show files which are different to all of
// its parents.
type FindChangedPathsRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	Commits              []string    `protobuf:"bytes,2,rep,name=commits,proto3" json:"commits,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *FindChangedPathsRequest) Reset()         { *m = FindChangedPathsRequest{} }
func (m *FindChangedPathsRequest) String() string { return proto.CompactTextString(m) }
func (*FindChangedPathsRequest) ProtoMessage()    {}
func (*FindChangedPathsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{12}
}

func (m *FindChangedPathsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FindChangedPathsRequest.Unmarshal(m, b)
}
func (m *FindChangedPathsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FindChangedPathsRequest.Marshal(b, m, deterministic)
}
func (m *FindChangedPathsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FindChangedPathsRequest.Merge(m, src)
}
func (m *FindChangedPathsRequest) XXX_Size() int {
	return xxx_messageInfo_FindChangedPathsRequest.Size(m)
}
func (m *FindChangedPathsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FindChangedPathsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FindChangedPathsRequest proto.InternalMessageInfo

func (m *FindChangedPathsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindChangedPathsRequest) GetCommits() []string {
	if m != nil {
		return m.Commits
	}
	return nil
}

// Returns a list of files that have been changed in the commits given
type FindChangedPathsResponse struct {
	Paths                []*ChangedPaths `protobuf:"bytes,1,rep,name=paths,proto3" json:"paths,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *FindChangedPathsResponse) Reset()         { *m = FindChangedPathsResponse{} }
func (m *FindChangedPathsResponse) String() string { return proto.CompactTextString(m) }
func (*FindChangedPathsResponse) ProtoMessage()    {}
func (*FindChangedPathsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{13}
}

func (m *FindChangedPathsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FindChangedPathsResponse.Unmarshal(m, b)
}
func (m *FindChangedPathsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FindChangedPathsResponse.Marshal(b, m, deterministic)
}
func (m *FindChangedPathsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FindChangedPathsResponse.Merge(m, src)
}
func (m *FindChangedPathsResponse) XXX_Size() int {
	return xxx_messageInfo_FindChangedPathsResponse.Size(m)
}
func (m *FindChangedPathsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FindChangedPathsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FindChangedPathsResponse proto.InternalMessageInfo

func (m *FindChangedPathsResponse) GetPaths() []*ChangedPaths {
	if m != nil {
		return m.Paths
	}
	return nil
}

// Includes the path of the file, and the status of the change
type ChangedPaths struct {
	Path                 []byte              `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Status               ChangedPaths_Status `protobuf:"varint,2,opt,name=status,proto3,enum=gitaly.ChangedPaths_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ChangedPaths) Reset()         { *m = ChangedPaths{} }
func (m *ChangedPaths) String() string { return proto.CompactTextString(m) }
func (*ChangedPaths) ProtoMessage()    {}
func (*ChangedPaths) Descriptor() ([]byte, []int) {
	return fileDescriptor_686521effc814b25, []int{14}
}

func (m *ChangedPaths) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChangedPaths.Unmarshal(m, b)
}
func (m *ChangedPaths) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChangedPaths.Marshal(b, m, deterministic)
}
func (m *ChangedPaths) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChangedPaths.Merge(m, src)
}
func (m *ChangedPaths) XXX_Size() int {
	return xxx_messageInfo_ChangedPaths.Size(m)
}
func (m *ChangedPaths) XXX_DiscardUnknown() {
	xxx_messageInfo_ChangedPaths.DiscardUnknown(m)
}

var xxx_messageInfo_ChangedPaths proto.InternalMessageInfo

func (m *ChangedPaths) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *ChangedPaths) GetStatus() ChangedPaths_Status {
	if m != nil {
		return m.Status
	}
	return ChangedPaths_ADDED
}

func init() {
	proto.RegisterEnum("gitaly.CommitDiffRequest_DiffMode", CommitDiffRequest_DiffMode_name, CommitDiffRequest_DiffMode_value)
	proto.RegisterEnum("gitaly.ChangedPaths_Status", ChangedPaths_Status_name, ChangedPaths_Status_value)
	proto.RegisterType((*CommitDiffRequest)(nil), "gitaly.CommitDiffRequest")
	proto.RegisterType((*CommitDiffResponse)(nil), "gitaly.CommitDiffResponse")
	proto.RegisterType((*CommitDeltaRequest)(nil), "gitaly.CommitDeltaRequest")
	proto.RegisterType((*CommitDelta)(nil), "gitaly.CommitDelta")
	proto.RegisterType((*CommitDeltaResponse)(nil), "gitaly.CommitDeltaResponse")
	proto.RegisterType((*RawDiffRequest)(nil), "gitaly.RawDiffRequest")
	proto.RegisterType((*RawDiffResponse)(nil), "gitaly.RawDiffResponse")
	proto.RegisterType((*RawPatchRequest)(nil), "gitaly.RawPatchRequest")
	proto.RegisterType((*RawPatchResponse)(nil), "gitaly.RawPatchResponse")
	proto.RegisterType((*DiffStatsRequest)(nil), "gitaly.DiffStatsRequest")
	proto.RegisterType((*DiffStats)(nil), "gitaly.DiffStats")
	proto.RegisterType((*DiffStatsResponse)(nil), "gitaly.DiffStatsResponse")
	proto.RegisterType((*FindChangedPathsRequest)(nil), "gitaly.FindChangedPathsRequest")
	proto.RegisterType((*FindChangedPathsResponse)(nil), "gitaly.FindChangedPathsResponse")
	proto.RegisterType((*ChangedPaths)(nil), "gitaly.ChangedPaths")
}

func init() { proto.RegisterFile("diff.proto", fileDescriptor_686521effc814b25) }

var fileDescriptor_686521effc814b25 = []byte{
	// 1097 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0xcd, 0x6e, 0xdb, 0x46,
	0x10, 0x2e, 0xf5, 0x43, 0x51, 0x23, 0x5a, 0x96, 0xd7, 0x81, 0x4d, 0xcb, 0x05, 0x2a, 0x10, 0x71,
	0x22, 0xf4, 0x47, 0x6e, 0x95, 0x1c, 0x72, 0x28, 0x50, 0xd8, 0xa6, 0x94, 0x2a, 0xb5, 0x6b, 0x83,
	0x71, 0x11, 0xb4, 0x17, 0x62, 0x2d, 0x2e, 0x25, 0xa2, 0x24, 0x57, 0x25, 0x37, 0x96, 0xfd, 0x1a,
	0xbd, 0x34, 0xed, 0xb9, 0x40, 0xef, 0x7d, 0x88, 0x3e, 0x4c, 0x9f, 0xa0, 0xe8, 0xa9, 0xd8, 0x5d,
	0x92, 0xa2, 0x2d, 0xb9, 0xa7, 0x1c, 0x74, 0xe3, 0x7e, 0xdf, 0xa7, 0xd9, 0xd9, 0x6f, 0x67, 0x66,
	0x21, 0x00, 0xd7, 0xf7, 0xbc, 0xde, 0x2c, 0xa6, 0x8c, 0x22, 0x75, 0xe2, 0x33, 0x1c, 0xdc, 0xb6,
	0x21, 0xf0, 0x23, 0x26, 0xb1, 0xb6, 0x9e, 0x4c, 0x71, 0x4c, 0x5c, 0xb9, 0x32, 0x7f, 0xae, 0xc2,
	0xd6, 0x09, 0x0d, 0x43, 0x9f, 0x59, 0xbe, 0xe7, 0xd9, 0xe4, 0xa7, 0xb7, 0x24, 0x61, 0xe8, 0x05,
	0x40, 0x4c, 0x66, 0x34, 0xf1, 0x19, 0x8d, 0x6f, 0x0d, 0xa5, 0xa3, 0x74, 0x1b, 0x7d, 0xd4, 0x93,
	0xc1, 0x7a, 0x76, 0xce, 0x1c, 0x57, 0xde, 0xfd, 0xf5, 0xa9, 0x62, 0x17, 0xb4, 0xe8, 0x31, 0x34,
	0x03, 0xe2, 0x31, 0x67, 0x2c, 0x62, 0x3a, 0xbe, 0x6b, 0x94, 0x3a, 0x4a, 0xb7, 0x6e, 0xeb, 0x1c,
	0x95, 0x1b, 0x8d, 0x5c, 0xf4, 0x04, 0x36, 0x63, 0x7f, 0x32, 0x2d, 0xca, 0xca, 0x42, 0xb6, 0x21,
	0xe0, 0x5c, 0xf7, 0x02, 0x0c, 0x7f, 0x12, 0xd1, 0x98, 0x38, 0xf3, 0xa9, 0xcf, 0x48, 0x32, 0xc3,
	0x63, 0xe2, 0x8c, 0xa7, 0x38, 0x9a, 0x10, 0xa3, 0xd2, 0x51, 0xba, 0x9a, 0xbd, 0x23, 0xf9, 0x37,
	0x39, 0x7d, 0x22, 0x58, 0xf4, 0x08, 0xaa, 0x33, 0xcc, 0xa6, 0x89, 0x51, 0xed, 0x94, 0xbb, 0xba,
	0x2d, 0x17, 0xe8, 0x00, 0x9a, 0x63, 0x1a, 0x04, 0x78, 0x96, 0x10, 0x87, 0xdb, 0x94, 0x18, 0xaa,
	0x88, 0xb2, 0x91, 0xa1, 0xdc, 0x04, 0x21, 0x23, 0x91, 0x47, 0xe3, 0x31, 0x71, 0x02, 0x3f, 0xf4,
	0x59, 0x62, 0xd4, 0xa4, 0x2c, 0x45, 0x4f, 0x05, 0x88, 0xf6, 0xa1, 0x1e, 0xe2, 0x1b, 0xc7, 0xf3,
	0x03, 0x92, 0x18, 0x5a, 0x47, 0xe9, 0x56, 0x6d, 0x2d, 0xc4, 0x37, 0x43, 0xbe, 0xce, 0xc8, 0xc0,
	0x8f, 0x48, 0x62, 0xd4, 0x73, 0xf2, 0x94, 0xaf, 0x33, 0xf2, 0xea, 0x96, 0x91, 0xc4, 0x80, 0x9c,
	0x3c, 0xe6, 0x6b, 0x6e, 0x0e, 0x27, 0x67, 0x98, 0x8d, 0xa7, 0xa9, 0xa4, 0x29, 0x24, 0x1b, 0x21,
	0xbe, 0xb9, 0xe0, 0xa8, 0xd4, 0x3d, 0x86, 0x66, 0x82, 0x3d, 0xe2, 0x2c, 0x72, 0x68, 0x08, 0x99,
	0xce, 0xd1, 0xb3, 0x2c, 0x8f, 0xa2, 0x4a, 0x26, 0xa3, 0xdf, 0x51, 0xc9, 0x84, 0x8a, 0x2a, 0xb9,
	0xe5, 0xc6, 0x1d, 0x95, 0xdc, 0xf1, 0x2b, 0xa8, 0x73, 0xd7, 0x9c, 0x90, 0xba, 0xc4, 0xd8, 0xec,
	0x28, 0xdd, 0x66, 0xdf, 0xcc, 0xaa, 0x62, 0xa9, 0x88, 0x7a, 0xfc, 0xfb, 0x8c, 0xba, 0xc4, 0xd6,
	0xdc, 0xf4, 0xcb, 0x3c, 0x00, 0x2d, 0x43, 0x51, 0x03, 0x6a, 0xd6, 0x60, 0x78, 0xf4, 0xdd, 0xe9,
	0x65, 0xeb, 0x03, 0xa4, 0x83, 0xf6, 0xe6, 0xdc, 0xb6, 0xac, 0xd1, 0x70, 0xd8, 0x52, 0xcc, 0x7f,
	0x4a, 0x80, 0x8a, 0xf1, 0x92, 0x19, 0x8d, 0x12, 0xc2, 0x5d, 0xf3, 0x62, 0x1a, 0x72, 0x67, 0xa6,
	0xa2, 0x28, 0x75, 0x5b, 0xe3, 0xc0, 0x05, 0x66, 0x53, 0xb4, 0x0b, 0x35, 0x46, 0x25, 0x55, 0x12,
	0x94, 0xca, 0x68, 0x46, 0x88, 0x5f, 0xe5, 0x35, 0xa6, 0xf2, 0xe5, 0xc8, 0x45, 0xdb, 0x50, 0x65,
	0x94, 0xc3, 0x15, 0x01, 0x57, 0x18, 0x1d, 0xb9, 0x68, 0x0f, 0x34, 0x1a, 0xb8, 0xf2, 0x84, 0x55,
	0x61, 0x41, 0x8d, 0x06, 0xae, 0x48, 0x78, 0x0f, 0xb4, 0x88, 0xcc, 0x25, 0xa5, 0x4a, 0x2a, 0x22,
	0x73, 0x41, 0xed, 0x80, 0x7a, 0xe5, 0x47, 0x38, 0xbe, 0x4d, 0x0b, 0x25, 0x5d, 0x71, 0x5b, 0x63,
	0x3c, 0x4f, 0xaf, 0xd2, 0xc5, 0x0c, 0x8b, 0x4a, 0xd0, 0x6d, 0x3d, 0xc6, 0x73, 0x71, 0x93, 0x16,
	0x66, 0x18, 0x75, 0x40, 0x27, 0x91, 0xeb, 0x50, 0x4f, 0x0a, 0x45, 0x41, 0x68, 0x36, 0x90, 0xc8,
	0x3d, 0xf7, 0x84, 0x0a, 0x3d, 0x85, 0x4d, 0x7a, 0x4d, 0x62, 0x2f, 0xa0, 0x73, 0x27, 0xc4, 0xf1,
	0x8f, 0x24, 0x16, 0x77, 0xad, 0xd9, 0xcd, 0x0c, 0x3e, 0x13, 0x28, 0xfa, 0x10, 0xea, 0x59, 0x29,
	0xbb, 0xe2, 0xa2, 0x35, 0x7b, 0x01, 0x70, 0x03, 0x19, 0xa5, 0x4e, 0x80, 0xe3, 0x09, 0x11, 0x17,
	0xac, 0xd9, 0x1a, 0xa3, 0xf4, 0x94, 0xaf, 0x5f, 0x55, 0x34, 0xad, 0x55, 0x37, 0xff, 0x54, 0x72,
	0xeb, 0x49, 0xc0, 0xf0, 0xba, 0x0d, 0x84, 0xbc, 0xad, 0x2b, 0x85, 0xb6, 0x36, 0xff, 0x50, 0xa0,
	0x51, 0x48, 0x7a, 0x7d, 0x0b, 0xc5, 0x3c, 0x86, 0xed, 0x3b, 0xee, 0xa6, 0x95, 0xfd, 0x09, 0xa8,
	0x2e, 0x07, 0x12, 0x43, 0xe9, 0x94, 0xbb, 0x8d, 0xfe, 0xf6, 0xbd, 0xae, 0x12, 0xe2, 0x54, 0x62,
	0xbe, 0x53, 0xa0, 0x69, 0xe3, 0xf9, 0x1a, 0xce, 0x6b, 0xf3, 0x00, 0x36, 0xf3, 0xcc, 0xd2, 0xa3,
	0x21, 0xa8, 0x88, 0xc2, 0x97, 0xd7, 0x20, 0xbe, 0xcd, 0x5f, 0x15, 0xa1, 0x13, 0xb5, 0xbd, 0x6e,
	0x47, 0x78, 0x02, 0xad, 0x45, 0x6a, 0xff, 0x73, 0x86, 0xdf, 0x14, 0x68, 0xf1, 0x83, 0xbe, 0x66,
	0x98, 0x25, 0xeb, 0x76, 0x88, 0x6b, 0xa8, 0xe7, 0xb9, 0xf1, 0xec, 0x0b, 0x8d, 0x20, 0xbe, 0xf9,
	0x9c, 0xc0, 0xae, 0xeb, 0x33, 0x9f, 0x46, 0x89, 0xd8, 0xa9, 0x6a, 0x2f, 0x00, 0xce, 0xba, 0x24,
	0x20, 0x92, 0x2d, 0x4b, 0x36, 0x07, 0xb2, 0xca, 0x17, 0x31, 0x2b, 0x22, 0x26, 0xaf, 0x7c, 0xde,
	0x42, 0xe6, 0x97, 0xb0, 0x55, 0xf0, 0x24, 0x75, 0xef, 0x29, 0x54, 0x13, 0x0e, 0xa4, 0xb5, 0xbd,
	0x95, 0xf9, 0xb1, 0x50, 0x4a, 0xde, 0x0c, 0x61, 0x77, 0xe8, 0x47, 0xae, 0x7c, 0xc1, 0x45, 0xc0,
	0xf7, 0x60, 0xac, 0x01, 0x35, 0x69, 0x16, 0x3f, 0x67, 0xb9, 0x5b, 0xb7, 0xb3, 0xa5, 0x39, 0x04,
	0x63, 0x79, 0xbb, 0x34, 0xe7, 0x8f, 0xb3, 0x39, 0x23, 0x73, 0x7e, 0x94, 0xf7, 0x63, 0x51, 0x9c,
	0x4e, 0x9f, 0xdf, 0x15, 0xd0, 0x8b, 0xf8, 0x4a, 0xc3, 0x9f, 0x81, 0xca, 0x0f, 0xf9, 0x56, 0xba,
	0xdd, 0xec, 0xef, 0xaf, 0x8a, 0xd8, 0x7b, 0x2d, 0x24, 0x76, 0x2a, 0x35, 0xbf, 0x01, 0x55, 0x22,
	0xa8, 0x0e, 0xd5, 0x23, 0xcb, 0x1a, 0x58, 0xf2, 0xa9, 0x3c, 0x3b, 0xb7, 0x46, 0xc3, 0xd1, 0xc0,
	0x6a, 0x29, 0xf2, 0x15, 0x3d, 0x1d, 0x5c, 0x0e, 0xac, 0x56, 0x09, 0x6d, 0x42, 0xe3, 0xf2, 0xfb,
	0x8b, 0x81, 0x73, 0xf2, 0xf5, 0xd1, 0xb7, 0x2f, 0x07, 0xad, 0x32, 0x02, 0x50, 0x4f, 0xce, 0x2f,
	0xb8, 0xb2, 0xd2, 0xff, 0xbb, 0x0c, 0x0d, 0x61, 0x39, 0x89, 0xaf, 0xfd, 0x31, 0x41, 0x67, 0x00,
	0x8b, 0x37, 0x16, 0xed, 0x3d, 0xf8, 0x8e, 0xb7, 0xdb, 0xab, 0x28, 0xe9, 0x93, 0xa9, 0xfe, 0xfb,
	0x4b, 0xb7, 0xa4, 0x95, 0x3e, 0x57, 0xd0, 0xc5, 0xdd, 0x11, 0xdc, 0x5e, 0x35, 0xc1, 0xd2, 0x80,
	0xfb, 0x2b, 0xb9, 0xa5, 0x88, 0x16, 0xd4, 0xd2, 0x61, 0x82, 0x76, 0xf2, 0xab, 0xbe, 0x33, 0xf7,
	0xda, 0xbb, 0x4b, 0xf8, 0x52, 0x94, 0x97, 0xa0, 0x65, 0xfd, 0x8c, 0x8a, 0xf2, 0xe2, 0xf0, 0x69,
	0x1b, 0xcb, 0xc4, 0x52, 0xa0, 0x57, 0xc5, 0x9e, 0x32, 0x96, 0x8b, 0x38, 0x0d, 0xb5, 0xb7, 0x82,
	0x59, 0x8a, 0xe5, 0x40, 0xeb, 0x7e, 0xe9, 0xa1, 0x8f, 0xb2, 0x1f, 0x3e, 0xd0, 0x03, 0xed, 0xce,
	0xc3, 0x82, 0xfb, 0x1b, 0x1c, 0x3f, 0xff, 0xa1, 0x3f, 0xf1, 0x59, 0x80, 0xaf, 0x7a, 0x63, 0x1a,
	0x1e, 0xca, 0xcf, 0xcf, 0x68, 0x3c, 0x39, 0x94, 0x21, 0x0e, 0xaf, 0xbf, 0x78, 0x7e, 0x28, 0xfe,
	0x00, 0x1c, 0x4e, 0x68, 0x8a, 0xcd, 0xae, 0xae, 0x54, 0x01, 0x3d, 0xfb, 0x2f, 0x00, 0x00, 0xff,
	0xff, 0x20, 0x11, 0x8c, 0x4f, 0x43, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DiffServiceClient is the client API for DiffService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DiffServiceClient interface {
	// Returns stream of CommitDiffResponse with patches chunked over messages
	CommitDiff(ctx context.Context, in *CommitDiffRequest, opts ...grpc.CallOption) (DiffService_CommitDiffClient, error)
	// Return a stream so we can divide the response in chunks of deltas
	CommitDelta(ctx context.Context, in *CommitDeltaRequest, opts ...grpc.CallOption) (DiffService_CommitDeltaClient, error)
	RawDiff(ctx context.Context, in *RawDiffRequest, opts ...grpc.CallOption) (DiffService_RawDiffClient, error)
	RawPatch(ctx context.Context, in *RawPatchRequest, opts ...grpc.CallOption) (DiffService_RawPatchClient, error)
	DiffStats(ctx context.Context, in *DiffStatsRequest, opts ...grpc.CallOption) (DiffService_DiffStatsClient, error)
	// Return a list of files changed along with the status of each file
	FindChangedPaths(ctx context.Context, in *FindChangedPathsRequest, opts ...grpc.CallOption) (DiffService_FindChangedPathsClient, error)
}

type diffServiceClient struct {
	cc *grpc.ClientConn
}

func NewDiffServiceClient(cc *grpc.ClientConn) DiffServiceClient {
	return &diffServiceClient{cc}
}

func (c *diffServiceClient) CommitDiff(ctx context.Context, in *CommitDiffRequest, opts ...grpc.CallOption) (DiffService_CommitDiffClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[0], "/gitaly.DiffService/CommitDiff", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitDiffClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitDiffClient interface {
	Recv() (*CommitDiffResponse, error)
	grpc.ClientStream
}

type diffServiceCommitDiffClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitDiffClient) Recv() (*CommitDiffResponse, error) {
	m := new(CommitDiffResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) CommitDelta(ctx context.Context, in *CommitDeltaRequest, opts ...grpc.CallOption) (DiffService_CommitDeltaClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[1], "/gitaly.DiffService/CommitDelta", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitDeltaClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitDeltaClient interface {
	Recv() (*CommitDeltaResponse, error)
	grpc.ClientStream
}

type diffServiceCommitDeltaClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitDeltaClient) Recv() (*CommitDeltaResponse, error) {
	m := new(CommitDeltaResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) RawDiff(ctx context.Context, in *RawDiffRequest, opts ...grpc.CallOption) (DiffService_RawDiffClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[2], "/gitaly.DiffService/RawDiff", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceRawDiffClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_RawDiffClient interface {
	Recv() (*RawDiffResponse, error)
	grpc.ClientStream
}

type diffServiceRawDiffClient struct {
	grpc.ClientStream
}

func (x *diffServiceRawDiffClient) Recv() (*RawDiffResponse, error) {
	m := new(RawDiffResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) RawPatch(ctx context.Context, in *RawPatchRequest, opts ...grpc.CallOption) (DiffService_RawPatchClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[3], "/gitaly.DiffService/RawPatch", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceRawPatchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_RawPatchClient interface {
	Recv() (*RawPatchResponse, error)
	grpc.ClientStream
}

type diffServiceRawPatchClient struct {
	grpc.ClientStream
}

func (x *diffServiceRawPatchClient) Recv() (*RawPatchResponse, error) {
	m := new(RawPatchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) DiffStats(ctx context.Context, in *DiffStatsRequest, opts ...grpc.CallOption) (DiffService_DiffStatsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[4], "/gitaly.DiffService/DiffStats", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceDiffStatsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_DiffStatsClient interface {
	Recv() (*DiffStatsResponse, error)
	grpc.ClientStream
}

type diffServiceDiffStatsClient struct {
	grpc.ClientStream
}

func (x *diffServiceDiffStatsClient) Recv() (*DiffStatsResponse, error) {
	m := new(DiffStatsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) FindChangedPaths(ctx context.Context, in *FindChangedPathsRequest, opts ...grpc.CallOption) (DiffService_FindChangedPathsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[5], "/gitaly.DiffService/FindChangedPaths", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceFindChangedPathsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_FindChangedPathsClient interface {
	Recv() (*FindChangedPathsResponse, error)
	grpc.ClientStream
}

type diffServiceFindChangedPathsClient struct {
	grpc.ClientStream
}

func (x *diffServiceFindChangedPathsClient) Recv() (*FindChangedPathsResponse, error) {
	m := new(FindChangedPathsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// DiffServiceServer is the server API for DiffService service.
type DiffServiceServer interface {
	// Returns stream of CommitDiffResponse with patches chunked over messages
	CommitDiff(*CommitDiffRequest, DiffService_CommitDiffServer) error
	// Return a stream so we can divide the response in chunks of deltas
	CommitDelta(*CommitDeltaRequest, DiffService_CommitDeltaServer) error
	RawDiff(*RawDiffRequest, DiffService_RawDiffServer) error
	RawPatch(*RawPatchRequest, DiffService_RawPatchServer) error
	DiffStats(*DiffStatsRequest, DiffService_DiffStatsServer) error
	// Return a list of files changed along with the status of each file
	FindChangedPaths(*FindChangedPathsRequest, DiffService_FindChangedPathsServer) error
}

// UnimplementedDiffServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDiffServiceServer struct {
}

func (*UnimplementedDiffServiceServer) CommitDiff(req *CommitDiffRequest, srv DiffService_CommitDiffServer) error {
	return status.Errorf(codes.Unimplemented, "method CommitDiff not implemented")
}
func (*UnimplementedDiffServiceServer) CommitDelta(req *CommitDeltaRequest, srv DiffService_CommitDeltaServer) error {
	return status.Errorf(codes.Unimplemented, "method CommitDelta not implemented")
}
func (*UnimplementedDiffServiceServer) RawDiff(req *RawDiffRequest, srv DiffService_RawDiffServer) error {
	return status.Errorf(codes.Unimplemented, "method RawDiff not implemented")
}
func (*UnimplementedDiffServiceServer) RawPatch(req *RawPatchRequest, srv DiffService_RawPatchServer) error {
	return status.Errorf(codes.Unimplemented, "method RawPatch not implemented")
}
func (*UnimplementedDiffServiceServer) DiffStats(req *DiffStatsRequest, srv DiffService_DiffStatsServer) error {
	return status.Errorf(codes.Unimplemented, "method DiffStats not implemented")
}
func (*UnimplementedDiffServiceServer) FindChangedPaths(req *FindChangedPathsRequest, srv DiffService_FindChangedPathsServer) error {
	return status.Errorf(codes.Unimplemented, "method FindChangedPaths not implemented")
}

func RegisterDiffServiceServer(s *grpc.Server, srv DiffServiceServer) {
	s.RegisterService(&_DiffService_serviceDesc, srv)
}

func _DiffService_CommitDiff_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitDiffRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitDiff(m, &diffServiceCommitDiffServer{stream})
}

type DiffService_CommitDiffServer interface {
	Send(*CommitDiffResponse) error
	grpc.ServerStream
}

type diffServiceCommitDiffServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitDiffServer) Send(m *CommitDiffResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_CommitDelta_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitDeltaRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitDelta(m, &diffServiceCommitDeltaServer{stream})
}

type DiffService_CommitDeltaServer interface {
	Send(*CommitDeltaResponse) error
	grpc.ServerStream
}

type diffServiceCommitDeltaServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitDeltaServer) Send(m *CommitDeltaResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_RawDiff_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RawDiffRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).RawDiff(m, &diffServiceRawDiffServer{stream})
}

type DiffService_RawDiffServer interface {
	Send(*RawDiffResponse) error
	grpc.ServerStream
}

type diffServiceRawDiffServer struct {
	grpc.ServerStream
}

func (x *diffServiceRawDiffServer) Send(m *RawDiffResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_RawPatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RawPatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).RawPatch(m, &diffServiceRawPatchServer{stream})
}

type DiffService_RawPatchServer interface {
	Send(*RawPatchResponse) error
	grpc.ServerStream
}

type diffServiceRawPatchServer struct {
	grpc.ServerStream
}

func (x *diffServiceRawPatchServer) Send(m *RawPatchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_DiffStats_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DiffStatsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).DiffStats(m, &diffServiceDiffStatsServer{stream})
}

type DiffService_DiffStatsServer interface {
	Send(*DiffStatsResponse) error
	grpc.ServerStream
}

type diffServiceDiffStatsServer struct {
	grpc.ServerStream
}

func (x *diffServiceDiffStatsServer) Send(m *DiffStatsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_FindChangedPaths_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindChangedPathsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).FindChangedPaths(m, &diffServiceFindChangedPathsServer{stream})
}

type DiffService_FindChangedPathsServer interface {
	Send(*FindChangedPathsResponse) error
	grpc.ServerStream
}

type diffServiceFindChangedPathsServer struct {
	grpc.ServerStream
}

func (x *diffServiceFindChangedPathsServer) Send(m *FindChangedPathsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _DiffService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.DiffService",
	HandlerType: (*DiffServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "CommitDiff",
			Handler:       _DiffService_CommitDiff_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitDelta",
			Handler:       _DiffService_CommitDelta_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RawDiff",
			Handler:       _DiffService_RawDiff_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RawPatch",
			Handler:       _DiffService_RawPatch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "DiffStats",
			Handler:       _DiffService_DiffStats_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindChangedPaths",
			Handler:       _DiffService_FindChangedPaths_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "diff.proto",
}
