/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.coordinates.Accuracy;
import geotrans3.coordinates.CoordinateTuple;
import geotrans3.enumerations.CoordinateType;
import geotrans3.exception.CoordinateConversionException;
import geotrans3.gui.CoordPanel;
import geotrans3.gui.MSP_GEOTRANS3;
import geotrans3.jni.FillList;
import geotrans3.jni.JNICoordinateConversionService;
import geotrans3.jni.JNIDatumLibrary;
import geotrans3.jni.JNIEllipsoidLibrary;
import geotrans3.misc.FormatOptions;
import geotrans3.misc.Info;
import geotrans3.misc.StringHandler;
import geotrans3.parameters.CoordinateSystemParameters;
import geotrans3.parameters.EquidistantCylindricalParameters;
import geotrans3.parameters.GeodeticParameters;
import geotrans3.parameters.LocalCartesianParameters;
import geotrans3.parameters.MapProjection3Parameters;
import geotrans3.parameters.MapProjection4Parameters;
import geotrans3.parameters.MapProjection5Parameters;
import geotrans3.parameters.MapProjection6Parameters;
import geotrans3.parameters.MercatorScaleFactorParameters;
import geotrans3.parameters.MercatorStandardParallelParameters;
import geotrans3.parameters.NeysParameters;
import geotrans3.parameters.ObliqueMercatorParameters;
import geotrans3.parameters.PolarStereographicScaleFactorParameters;
import geotrans3.parameters.PolarStereographicStandardParallelParameters;
import geotrans3.parameters.UTMParameters;
import geotrans3.utility.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class MasterPanel
extends JPanel {
    private MSP_GEOTRANS3 parent;
    private JNIDatumLibrary jniDatumLibrary;
    private JNIEllipsoidLibrary jniEllipsoidLibrary;
    private JNICoordinateConversionService jniCoordinateConversionService;
    private FillList datumList;
    private StringHandler stringHandler;
    private int projectionType;
    private long datumIndex;
    private int direction;
    private int state;
    private CoordPanel coordPanel;
    private int heightType;
    private long override;
    private FormatOptions formatOptions;
    private boolean createHeader;
    private boolean useNSEW;
    private boolean useMinutes;
    private boolean useSeconds;
    private String currLookAndFeel;
    private CoordinateSystemParameters coordinateSystemParameters;
    private String datumCode;
    private int inputFileType;
    private JLabel _3ParamFieldsRow1LabelA;
    private JLabel _3ParamFieldsRow1LabelB;
    private JLabel _3ParamFieldsRow1LabelC;
    private JLabel _3ParamFieldsRow1PS_SFLabelA;
    private JLabel _3ParamFieldsRow1PS_SFLabelB;
    private JPanel _3ParamFieldsRow1PS_SFPanel;
    private JTextField _3ParamFieldsRow1PS_SFTextFieldA;
    private JTextField _3ParamFieldsRow1PS_SFTextFieldB;
    private JPanel _3ParamFieldsRow1Panel;
    private JTextField _3ParamFieldsRow1TextFieldA;
    private JTextField _3ParamFieldsRow1TextFieldB;
    private JTextField _3ParamFieldsRow1TextFieldC;
    private JLabel _3ParamFieldsRow2LabelA;
    private JLabel _3ParamFieldsRow2LabelB;
    private JLabel _3ParamFieldsRow2LabelC;
    private JPanel _3ParamFieldsRow2Panel;
    private JTextField _3ParamFieldsRow2TextFieldA;
    private JTextField _3ParamFieldsRow2TextFieldB;
    private JTextField _3ParamFieldsRow2TextFieldC;
    private JLabel _4ParamFieldsRow1LabelA;
    private JLabel _4ParamFieldsRow1LabelB;
    private JLabel _4ParamFieldsRow1LabelC;
    private JLabel _4ParamFieldsRow1LabelD;
    private JPanel _4ParamFieldsRow1Panel;
    private JTextField _4ParamFieldsRow1TextFieldA;
    private JTextField _4ParamFieldsRow1TextFieldB;
    private JTextField _4ParamFieldsRow1TextFieldC;
    private JTextField _4ParamFieldsRow1TextFieldD;
    private JLabel _4ParamFieldsRow2LabelA;
    private JLabel _4ParamFieldsRow2LabelB;
    private JLabel _4ParamFieldsRow2LabelC;
    private JLabel _4ParamFieldsRow2LabelD;
    private JPanel _4ParamFieldsRow2Panel;
    private JTextField _4ParamFieldsRow2TextFieldA;
    private JTextField _4ParamFieldsRow2TextFieldB;
    private JTextField _4ParamFieldsRow2TextFieldC;
    private JTextField _4ParamFieldsRow2TextFieldD;
    private JPanel _geodeticCoordinateOrderPanel;
    private JLabel centralMeridianNeysParamsLabel;
    private JPanel centralMeridianNeysParamsPanel;
    private JTextField centralMeridianNeysParamsTextField;
    private JComboBox datumComboBox;
    private JLabel datumLabel;
    private JPanel datumPanel;
    private JLayeredPane datumSelectLayeredPane;
    private JTextField datumTextField;
    private JLabel ellipsoidLabel;
    private JTextField ellipsoidTextField;
    private JPanel geodeticCoordinateOrderPanel;
    private JComboBox heightComboBox;
    private JLabel heightLabel;
    private JPanel heightLabelPanel;
    private JPanel heightPanel;
    private JPanel hemiBoxPanel;
    private JLabel inputProjectionLabel;
    private JRadioButton latitudeLongitudeRadioButton;
    private JRadioButton longitudeLatitudeRadioButton;
    private JRadioButton nHemiRadioButton;
    private JRadioButton neys71RadioButton;
    private JRadioButton neys74RadioButton;
    private JPanel neysParamsRow1Panel;
    private JLabel originLatitudeNeysParamsLabel;
    private JPanel originLatitudeNeysParamsPanel;
    private JTextField originLatitudeNeysParamsTextField;
    private JLayeredPane paramFieldsRow1LayeredPane;
    private JLayeredPane paramFieldsRow2LayeredPane;
    private JComboBox projectionComboBox;
    private JPanel projectionPanel;
    private JPanel row1HemiBoxPanel;
    private JRadioButton row1NHemiRadioButton;
    private JRadioButton row1SHemiRadioButton;
    private JRadioButton sHemiRadioButton;
    private JPanel stdParallel1NeysParamsPanel;
    private JLabel stdParallel2NeysParamsLabel;
    private JPanel stdParallel2NeysParamsPanel;
    private JTextField stdParallel2NeysParamsTextField;
    private JLabel tempZoneBoxLabel;
    private JPanel zoneBoxPanel;
    private JPanel zoneHemiPanel;
    private JLabel zoneLabel;
    private JRadioButton zoneRadioButton;
    private JLabel zoneRangeLabel;
    private JTextField zoneTextField;

    public MasterPanel(JNICoordinateConversionService jNICoordinateConversionService, int n, int n2, FormatOptions formatOptions, StringHandler stringHandler) {
        try {
            this.jniCoordinateConversionService = jNICoordinateConversionService;
            this.jniDatumLibrary = new JNIDatumLibrary(jNICoordinateConversionService.getDatumLibrary());
            this.jniEllipsoidLibrary = new JNIEllipsoidLibrary(jNICoordinateConversionService.getEllipsoidLibrary());
            this.stringHandler = stringHandler;
            this.inputFileType = this.projectionType = 10;
            this.datumIndex = 0L;
            this.currLookAndFeel = "Java";
            if (n == 2) {
                this.createHeader = true;
                this.state = 0;
            } else {
                this.createHeader = false;
                this.state = n;
            }
            this.direction = n2;
            this.formatOptions = formatOptions;
            if (this.state == 0) {
                this.init();
            } else {
                this.coordPanel = new CoordPanel(formatOptions, this.stringHandler);
                this.init();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                this.coordPanel.setPreferredSize(new Dimension(469, 78));
                this.coordPanel.setMinimumSize(new Dimension(469, 78));
                this.add((Component)this.coordPanel, gridBagConstraints);
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    public MasterPanel(JNICoordinateConversionService jNICoordinateConversionService, int n, FormatOptions formatOptions, StringHandler stringHandler, int n2) {
        try {
            this.jniCoordinateConversionService = jNICoordinateConversionService;
            this.jniDatumLibrary = new JNIDatumLibrary(jNICoordinateConversionService.getDatumLibrary());
            this.jniEllipsoidLibrary = new JNIEllipsoidLibrary(jNICoordinateConversionService.getEllipsoidLibrary());
            this.stringHandler = stringHandler;
            this.projectionType = 10;
            this.inputFileType = n2;
            this.datumIndex = 0L;
            this.currLookAndFeel = "Java";
            this.state = 0;
            this.createHeader = false;
            this.direction = n;
            this.formatOptions = formatOptions;
            this.init();
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    public MasterPanel(JNICoordinateConversionService jNICoordinateConversionService, String string, CoordinateSystemParameters coordinateSystemParameters, int n, int n2, FormatOptions formatOptions, StringHandler stringHandler) throws CoordinateConversionException {
        this.datumCode = string;
        this.coordinateSystemParameters = coordinateSystemParameters;
        this.jniCoordinateConversionService = jNICoordinateConversionService;
        this.jniDatumLibrary = new JNIDatumLibrary(jNICoordinateConversionService.getDatumLibrary());
        this.jniEllipsoidLibrary = new JNIEllipsoidLibrary(jNICoordinateConversionService.getEllipsoidLibrary());
        this.stringHandler = stringHandler;
        this.inputFileType = this.projectionType = coordinateSystemParameters.getCoordinateType();
        this.datumIndex = 0L;
        this.currLookAndFeel = "Java";
        this.createHeader = false;
        this.state = n;
        this.direction = n2;
        this.formatOptions = formatOptions;
        this.init();
    }

    private void init() throws CoordinateConversionException {
        this.initComponents();
        this.setFormat();
        if (this.direction == 0 && this.state == 0) {
            this.initFileInputPanel();
        } else {
            this.initMasterPanel();
        }
        if (Platform.isJavaV1_3) {
            this.datumLabel.setForeground(Color.black);
            this.ellipsoidLabel.setForeground(Color.black);
            this.inputProjectionLabel.setForeground(Color.black);
            this.centralMeridianNeysParamsLabel.setForeground(Color.black);
            this.originLatitudeNeysParamsLabel.setForeground(Color.black);
            this.stdParallel2NeysParamsLabel.setForeground(Color.black);
            this.heightLabel.setForeground(Color.black);
            this.hemiBoxPanel.setForeground(Color.black);
            this._3ParamFieldsRow1LabelA.setForeground(Color.black);
            this._3ParamFieldsRow1LabelB.setForeground(Color.black);
            this._3ParamFieldsRow1LabelC.setForeground(Color.black);
            this._3ParamFieldsRow2LabelA.setForeground(Color.black);
            this._3ParamFieldsRow2LabelB.setForeground(Color.black);
            this._3ParamFieldsRow2LabelC.setForeground(Color.black);
            this._4ParamFieldsRow1LabelA.setForeground(Color.black);
            this._4ParamFieldsRow1LabelB.setForeground(Color.black);
            this._4ParamFieldsRow1LabelC.setForeground(Color.black);
            this._4ParamFieldsRow1LabelD.setForeground(Color.black);
            this._4ParamFieldsRow2LabelA.setForeground(Color.black);
            this._4ParamFieldsRow2LabelB.setForeground(Color.black);
            this._4ParamFieldsRow2LabelC.setForeground(Color.black);
            this._4ParamFieldsRow2LabelD.setForeground(Color.black);
            this.zoneLabel.setForeground(Color.black);
            this.zoneRangeLabel.setForeground(Color.black);
        }
        if (Platform.isUnix) {
            this.datumLabel.setFont(new Font("Dialog", 1, 10));
            this.ellipsoidLabel.setFont(new Font("Dialog", 1, 10));
            this.inputProjectionLabel.setFont(new Font("Dialog", 1, 10));
            this.centralMeridianNeysParamsLabel.setFont(new Font("Dialog", 1, 10));
            this.originLatitudeNeysParamsLabel.setFont(new Font("Dialog", 1, 10));
            this.stdParallel2NeysParamsLabel.setFont(new Font("Dialog", 1, 10));
            this.heightLabel.setFont(new Font("Dialog", 1, 10));
            this.hemiBoxPanel.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow1LabelA.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow1LabelB.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow1LabelC.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow2LabelA.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow2LabelB.setFont(new Font("Dialog", 1, 10));
            this._3ParamFieldsRow2LabelC.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow1LabelA.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow1LabelB.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow1LabelC.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow1LabelD.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow2LabelA.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow2LabelB.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow2LabelC.setFont(new Font("Dialog", 1, 10));
            this._4ParamFieldsRow2LabelD.setFont(new Font("Dialog", 1, 10));
            this.zoneLabel.setFont(new Font("Dialog", 1, 10));
            this.zoneRangeLabel.setFont(new Font("Dialog", 1, 10));
            this.zoneRadioButton.setFont(new Font("Dialog", 1, 10));
            this.nHemiRadioButton.setFont(new Font("Dialog", 1, 10));
            this.sHemiRadioButton.setFont(new Font("Dialog", 1, 10));
            this.neys71RadioButton.setFont(new Font("Dialog", 1, 10));
            this.neys74RadioButton.setFont(new Font("Dialog", 1, 10));
            this.datumComboBox.setFont(new Font("Dialog", 1, 10));
            this.projectionComboBox.setFont(new Font("Dialog", 1, 10));
            this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 10), Color.black));
            this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 10), Color.black));
        }
    }

    private void initComponents() {
        this.datumPanel = new JPanel();
        this.datumLabel = new JLabel();
        this.ellipsoidLabel = new JLabel();
        this.datumSelectLayeredPane = new JLayeredPane();
        this.datumTextField = new JTextField();
        this.datumComboBox = new JComboBox();
        this.ellipsoidTextField = new JTextField();
        this.projectionPanel = new JPanel();
        this.inputProjectionLabel = new JLabel();
        this.projectionComboBox = new JComboBox();
        this.paramFieldsRow1LayeredPane = new JLayeredPane();
        this._3ParamFieldsRow1Panel = new JPanel();
        this._3ParamFieldsRow1LabelA = new JLabel();
        this._3ParamFieldsRow1LabelB = new JLabel();
        this._3ParamFieldsRow1LabelC = new JLabel();
        this._3ParamFieldsRow1TextFieldA = new JTextField();
        this._3ParamFieldsRow1TextFieldB = new JTextField();
        this._3ParamFieldsRow1TextFieldC = new JTextField();
        this._4ParamFieldsRow1Panel = new JPanel();
        this._4ParamFieldsRow1LabelA = new JLabel();
        this._4ParamFieldsRow1LabelB = new JLabel();
        this._4ParamFieldsRow1LabelC = new JLabel();
        this._4ParamFieldsRow1LabelD = new JLabel();
        this._4ParamFieldsRow1TextFieldA = new JTextField();
        this._4ParamFieldsRow1TextFieldB = new JTextField();
        this._4ParamFieldsRow1TextFieldC = new JTextField();
        this._4ParamFieldsRow1TextFieldD = new JTextField();
        this.neysParamsRow1Panel = new JPanel();
        this.centralMeridianNeysParamsPanel = new JPanel();
        this.centralMeridianNeysParamsLabel = new JLabel();
        this.centralMeridianNeysParamsTextField = new JTextField();
        this.originLatitudeNeysParamsPanel = new JPanel();
        this.originLatitudeNeysParamsLabel = new JLabel();
        this.originLatitudeNeysParamsTextField = new JTextField();
        this.stdParallel1NeysParamsPanel = new JPanel();
        this.neys71RadioButton = new JRadioButton();
        this.neys74RadioButton = new JRadioButton();
        this.stdParallel2NeysParamsPanel = new JPanel();
        this.stdParallel2NeysParamsLabel = new JLabel();
        this.stdParallel2NeysParamsTextField = new JTextField();
        this.heightLabelPanel = new JPanel();
        this.heightLabel = new JLabel();
        this.heightPanel = new JPanel();
        this.heightComboBox = new JComboBox();
        this._3ParamFieldsRow1PS_SFPanel = new JPanel();
        this._3ParamFieldsRow1PS_SFLabelA = new JLabel();
        this._3ParamFieldsRow1PS_SFLabelB = new JLabel();
        this.row1HemiBoxPanel = new JPanel();
        this.row1NHemiRadioButton = new JRadioButton();
        this.row1SHemiRadioButton = new JRadioButton();
        this._3ParamFieldsRow1PS_SFTextFieldA = new JTextField();
        this._3ParamFieldsRow1PS_SFTextFieldB = new JTextField();
        this.paramFieldsRow2LayeredPane = new JLayeredPane();
        this._3ParamFieldsRow2Panel = new JPanel();
        this._3ParamFieldsRow2LabelA = new JLabel();
        this._3ParamFieldsRow2LabelB = new JLabel();
        this._3ParamFieldsRow2LabelC = new JLabel();
        this._3ParamFieldsRow2TextFieldA = new JTextField();
        this._3ParamFieldsRow2TextFieldB = new JTextField();
        this._3ParamFieldsRow2TextFieldC = new JTextField();
        this._4ParamFieldsRow2Panel = new JPanel();
        this._4ParamFieldsRow2LabelA = new JLabel();
        this._4ParamFieldsRow2LabelB = new JLabel();
        this._4ParamFieldsRow2LabelC = new JLabel();
        this._4ParamFieldsRow2LabelD = new JLabel();
        this._4ParamFieldsRow2TextFieldA = new JTextField();
        this._4ParamFieldsRow2TextFieldB = new JTextField();
        this._4ParamFieldsRow2TextFieldC = new JTextField();
        this._4ParamFieldsRow2TextFieldD = new JTextField();
        this.zoneHemiPanel = new JPanel();
        this.zoneBoxPanel = new JPanel();
        this.zoneRadioButton = new JRadioButton();
        this.zoneLabel = new JLabel();
        this.zoneTextField = new JTextField();
        this.tempZoneBoxLabel = new JLabel();
        this.zoneRangeLabel = new JLabel();
        this.hemiBoxPanel = new JPanel();
        this.nHemiRadioButton = new JRadioButton();
        this.sHemiRadioButton = new JRadioButton();
        this.geodeticCoordinateOrderPanel = new JPanel();
        this._geodeticCoordinateOrderPanel = new JPanel();
        this.latitudeLongitudeRadioButton = new JRadioButton();
        this.longitudeLatitudeRadioButton = new JRadioButton();
        this.setAlignmentX(1.0f);
        this.setAlignmentY(1.0f);
        this.setMinimumSize(new Dimension(463, 268));
        this.setPreferredSize(new Dimension(463, 268));
        this.setLayout(new GridBagLayout());
        this.datumPanel.setMinimumSize(new Dimension(460, 40));
        this.datumPanel.setPreferredSize(new Dimension(460, 40));
        this.datumPanel.setLayout(new GridBagLayout());
        this.datumLabel.setText("Datum:");
        this.datumLabel.setMaximumSize(new Dimension(270, 16));
        this.datumLabel.setMinimumSize(new Dimension(270, 16));
        this.datumLabel.setPreferredSize(new Dimension(270, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.datumPanel.add((Component)this.datumLabel, gridBagConstraints);
        this.ellipsoidLabel.setText("Ellipsoid:");
        this.ellipsoidLabel.setMaximumSize(new Dimension(172, 16));
        this.ellipsoidLabel.setMinimumSize(new Dimension(172, 16));
        this.ellipsoidLabel.setPreferredSize(new Dimension(172, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.datumPanel.add((Component)this.ellipsoidLabel, gridBagConstraints);
        this.datumSelectLayeredPane.setMinimumSize(new Dimension(270, 20));
        this.datumTextField.setEditable(false);
        this.datumTextField.setText("jTextField1");
        this.datumTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.datumTextField.setMinimumSize(new Dimension(320, 20));
        this.datumTextField.setPreferredSize(new Dimension(320, 20));
        this.datumTextField.setBounds(0, 0, 270, 20);
        this.datumSelectLayeredPane.add((Component)this.datumTextField, JLayeredPane.DEFAULT_LAYER);
        this.datumComboBox.setMinimumSize(new Dimension(320, 20));
        this.datumComboBox.setPreferredSize(new Dimension(320, 20));
        this.datumComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MasterPanel.this.datumComboBoxActionPerformed(actionEvent);
            }
        });
        this.datumComboBox.setBounds(0, 0, 270, 20);
        this.datumSelectLayeredPane.add((Component)this.datumComboBox, JLayeredPane.DEFAULT_LAYER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.datumPanel.add((Component)this.datumSelectLayeredPane, gridBagConstraints);
        this.ellipsoidTextField.setEditable(false);
        this.ellipsoidTextField.setText("jTextField2");
        this.ellipsoidTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.ellipsoidTextField.setMinimumSize(new Dimension(172, 20));
        this.ellipsoidTextField.setPreferredSize(new Dimension(172, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.datumPanel.add((Component)this.ellipsoidTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.datumPanel, gridBagConstraints);
        this.projectionPanel.setMinimumSize(new Dimension(460, 31));
        this.projectionPanel.setPreferredSize(new Dimension(460, 31));
        this.projectionPanel.setLayout(new GridBagLayout());
        this.inputProjectionLabel.setHorizontalAlignment(0);
        this.inputProjectionLabel.setText("jLabel7");
        this.projectionPanel.add((Component)this.inputProjectionLabel, new GridBagConstraints());
        this.projectionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MasterPanel.this.projectionComboBoxActionPerformed(actionEvent);
            }
        });
        this.projectionPanel.add((Component)this.projectionComboBox, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 1, 2);
        this.add((Component)this.projectionPanel, gridBagConstraints);
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(460, 40));
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(460, 40));
        this._3ParamFieldsRow1Panel.setMaximumSize(new Dimension(460, 40));
        this._3ParamFieldsRow1Panel.setMinimumSize(new Dimension(460, 40));
        this._3ParamFieldsRow1Panel.setOpaque(false);
        this._3ParamFieldsRow1Panel.setPreferredSize(new Dimension(460, 40));
        this._3ParamFieldsRow1Panel.setLayout(new GridLayout(2, 3, 12, 0));
        this._3ParamFieldsRow1LabelA.setText("Longitude");
        this._3ParamFieldsRow1LabelA.setMaximumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelA.setMinimumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelA.setOpaque(true);
        this._3ParamFieldsRow1LabelA.setPreferredSize(new Dimension(105, 16));
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1LabelA);
        this._3ParamFieldsRow1LabelB.setText("Latitude");
        this._3ParamFieldsRow1LabelB.setMaximumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelB.setMinimumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelB.setOpaque(true);
        this._3ParamFieldsRow1LabelB.setPreferredSize(new Dimension(105, 16));
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1LabelB);
        this._3ParamFieldsRow1LabelC.setText("Scale Factor");
        this._3ParamFieldsRow1LabelC.setMaximumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelC.setMinimumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1LabelC.setOpaque(true);
        this._3ParamFieldsRow1LabelC.setPreferredSize(new Dimension(105, 16));
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1LabelC);
        this._3ParamFieldsRow1TextFieldA.setText("0 0 0.00E");
        this._3ParamFieldsRow1TextFieldA.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow1TextFieldA.setMinimumSize(new Dimension(138, 20));
        this._3ParamFieldsRow1TextFieldA.setPreferredSize(new Dimension(138, 20));
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1TextFieldA);
        this._3ParamFieldsRow1TextFieldB.setText("0 0 0.0N");
        this._3ParamFieldsRow1TextFieldB.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow1TextFieldB.setMinimumSize(new Dimension(138, 20));
        this._3ParamFieldsRow1TextFieldB.setPreferredSize(new Dimension(138, 20));
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1TextFieldB);
        this._3ParamFieldsRow1TextFieldC.setText("1.00000");
        this._3ParamFieldsRow1TextFieldC.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow1TextFieldC.setMinimumSize(new Dimension(138, 20));
        this._3ParamFieldsRow1TextFieldC.setPreferredSize(new Dimension(138, 20));
        this._3ParamFieldsRow1Panel.add(this._3ParamFieldsRow1TextFieldC);
        this._3ParamFieldsRow1Panel.setBounds(4, 2, 460, 40);
        this.paramFieldsRow1LayeredPane.add((Component)this._3ParamFieldsRow1Panel, JLayeredPane.DEFAULT_LAYER);
        this._4ParamFieldsRow1Panel.setMinimumSize(new Dimension(1, 1));
        this._4ParamFieldsRow1Panel.setPreferredSize(new Dimension(466, 40));
        this._4ParamFieldsRow1Panel.setLayout(new GridLayout(2, 4, 12, 0));
        this._4ParamFieldsRow1LabelA.setText("Latitude");
        this._4ParamFieldsRow1LabelA.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1LabelA);
        this._4ParamFieldsRow1LabelB.setText("Longitude");
        this._4ParamFieldsRow1LabelB.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1LabelB);
        this._4ParamFieldsRow1LabelC.setText("False Easting");
        this._4ParamFieldsRow1LabelC.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1LabelC.setPreferredSize(new Dimension(66, 16));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1LabelC);
        this._4ParamFieldsRow1LabelD.setText("False Northing");
        this._4ParamFieldsRow1LabelD.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1LabelD);
        this._4ParamFieldsRow1TextFieldA.setText("0 0 0.00N");
        this._4ParamFieldsRow1TextFieldA.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1TextFieldA);
        this._4ParamFieldsRow1TextFieldB.setText("0 0 0.00W");
        this._4ParamFieldsRow1TextFieldB.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow1TextFieldB.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1TextFieldB);
        this._4ParamFieldsRow1TextFieldC.setText("200000");
        this._4ParamFieldsRow1TextFieldC.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow1TextFieldC.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1TextFieldC.setPreferredSize(new Dimension(40, 20));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1TextFieldC);
        this._4ParamFieldsRow1TextFieldD.setText("400000");
        this._4ParamFieldsRow1TextFieldD.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow1TextFieldD.setMinimumSize(new Dimension(4, 10));
        this._4ParamFieldsRow1Panel.add(this._4ParamFieldsRow1TextFieldD);
        this._4ParamFieldsRow1Panel.setBounds(4, 2, 460, 40);
        this.paramFieldsRow1LayeredPane.add((Component)this._4ParamFieldsRow1Panel, JLayeredPane.DEFAULT_LAYER);
        this.neysParamsRow1Panel.setMinimumSize(new Dimension(461, 55));
        this.neysParamsRow1Panel.setPreferredSize(new Dimension(461, 55));
        this.neysParamsRow1Panel.setLayout(new GridBagLayout());
        this.centralMeridianNeysParamsPanel.setMinimumSize(new Dimension(106, 36));
        this.centralMeridianNeysParamsPanel.setPreferredSize(new Dimension(106, 36));
        this.centralMeridianNeysParamsPanel.setLayout(new GridLayout(2, 1, 12, 0));
        this.centralMeridianNeysParamsLabel.setText("Central Meridian:");
        this.centralMeridianNeysParamsLabel.setMinimumSize(new Dimension(4, 10));
        this.centralMeridianNeysParamsPanel.add(this.centralMeridianNeysParamsLabel);
        this.centralMeridianNeysParamsTextField.setText("0 0 0.00E");
        this.centralMeridianNeysParamsTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.centralMeridianNeysParamsTextField.setMinimumSize(new Dimension(4, 10));
        this.centralMeridianNeysParamsPanel.add(this.centralMeridianNeysParamsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.neysParamsRow1Panel.add((Component)this.centralMeridianNeysParamsPanel, gridBagConstraints);
        this.originLatitudeNeysParamsPanel.setMinimumSize(new Dimension(106, 36));
        this.originLatitudeNeysParamsPanel.setPreferredSize(new Dimension(106, 36));
        this.originLatitudeNeysParamsPanel.setLayout(new GridLayout(2, 1, 12, 0));
        this.originLatitudeNeysParamsLabel.setText("Origin Latitude:");
        this.originLatitudeNeysParamsLabel.setMinimumSize(new Dimension(4, 10));
        this.originLatitudeNeysParamsPanel.add(this.originLatitudeNeysParamsLabel);
        this.originLatitudeNeysParamsTextField.setText("0 0 0.00N");
        this.originLatitudeNeysParamsTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.originLatitudeNeysParamsTextField.setMinimumSize(new Dimension(4, 10));
        this.originLatitudeNeysParamsPanel.add(this.originLatitudeNeysParamsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.neysParamsRow1Panel.add((Component)this.originLatitudeNeysParamsPanel, gridBagConstraints);
        this.stdParallel1NeysParamsPanel.setBorder(BorderFactory.createTitledBorder(null, "Std. Parallel 1:", 2, 0));
        this.stdParallel1NeysParamsPanel.setAlignmentX(0.0f);
        this.stdParallel1NeysParamsPanel.setAlignmentY(0.0f);
        this.stdParallel1NeysParamsPanel.setMaximumSize(new Dimension(107, 39));
        this.stdParallel1NeysParamsPanel.setMinimumSize(new Dimension(107, 39));
        this.stdParallel1NeysParamsPanel.setPreferredSize(new Dimension(107, 39));
        this.stdParallel1NeysParamsPanel.setLayout(new GridBagLayout());
        this.neys71RadioButton.setText("71");
        this.neys71RadioButton.setAlignmentY(0.0f);
        this.neys71RadioButton.setHorizontalTextPosition(4);
        this.neys71RadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.neys71RadioButton.setMaximumSize(new Dimension(30, 17));
        this.neys71RadioButton.setMinimumSize(new Dimension(30, 17));
        this.neys71RadioButton.setModel(this.nHemiRadioButton.getModel());
        this.neys71RadioButton.setPreferredSize(new Dimension(40, 17));
        this.neys71RadioButton.setVerticalAlignment(1);
        this.neys71RadioButton.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.stdParallel1NeysParamsPanel.add((Component)this.neys71RadioButton, gridBagConstraints);
        this.neys74RadioButton.setText("74");
        this.neys74RadioButton.setAlignmentY(0.0f);
        this.neys74RadioButton.setHorizontalTextPosition(4);
        this.neys74RadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.neys74RadioButton.setMaximumSize(new Dimension(30, 17));
        this.neys74RadioButton.setMinimumSize(new Dimension(30, 17));
        this.neys74RadioButton.setModel(this.sHemiRadioButton.getModel());
        this.neys74RadioButton.setPreferredSize(new Dimension(40, 17));
        this.neys74RadioButton.setVerticalAlignment(1);
        this.neys74RadioButton.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 2, 5, 0);
        this.stdParallel1NeysParamsPanel.add((Component)this.neys74RadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.neysParamsRow1Panel.add((Component)this.stdParallel1NeysParamsPanel, gridBagConstraints);
        this.stdParallel2NeysParamsPanel.setMinimumSize(new Dimension(106, 36));
        this.stdParallel2NeysParamsPanel.setPreferredSize(new Dimension(106, 36));
        this.stdParallel2NeysParamsPanel.setLayout(new GridLayout(2, 1, 12, 0));
        this.stdParallel2NeysParamsLabel.setText("Std. Parallel 2:");
        this.stdParallel2NeysParamsLabel.setMinimumSize(new Dimension(4, 10));
        this.stdParallel2NeysParamsPanel.add(this.stdParallel2NeysParamsLabel);
        this.stdParallel2NeysParamsTextField.setEditable(false);
        this.stdParallel2NeysParamsTextField.setText("89 59 59.0");
        this.stdParallel2NeysParamsTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.stdParallel2NeysParamsTextField.setMinimumSize(new Dimension(4, 10));
        this.stdParallel2NeysParamsPanel.add(this.stdParallel2NeysParamsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.neysParamsRow1Panel.add((Component)this.stdParallel2NeysParamsPanel, gridBagConstraints);
        this.neysParamsRow1Panel.setBounds(0, 2, 460, 40);
        this.paramFieldsRow1LayeredPane.add((Component)this.neysParamsRow1Panel, JLayeredPane.DEFAULT_LAYER);
        this.heightLabelPanel.setMinimumSize(new Dimension(213, 20));
        this.heightLabelPanel.setPreferredSize(new Dimension(213, 20));
        this.heightLabelPanel.setLayout(new GridBagLayout());
        this.heightLabel.setHorizontalAlignment(0);
        this.heightLabel.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.heightLabelPanel.add((Component)this.heightLabel, gridBagConstraints);
        this.heightLabelPanel.setBounds(4, 2, 460, 40);
        this.paramFieldsRow1LayeredPane.add((Component)this.heightLabelPanel, JLayeredPane.DEFAULT_LAYER);
        this.heightPanel.setAlignmentX(0.0f);
        this.heightPanel.setAlignmentY(0.0f);
        this.heightPanel.setMinimumSize(new Dimension(469, 50));
        this.heightPanel.setOpaque(false);
        this.heightPanel.setPreferredSize(new Dimension(469, 50));
        this.heightPanel.setLayout(new GridBagLayout());
        this.heightComboBox.setMinimumSize(new Dimension(276, 21));
        this.heightComboBox.setPreferredSize(new Dimension(276, 21));
        this.heightComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MasterPanel.this.heightComboBoxActionPerformed(actionEvent);
            }
        });
        this.heightPanel.add((Component)this.heightComboBox, new GridBagConstraints());
        this.heightPanel.setBounds(0, 0, 462, 45);
        this.paramFieldsRow1LayeredPane.add((Component)this.heightPanel, JLayeredPane.DEFAULT_LAYER);
        this._3ParamFieldsRow1PS_SFPanel.setMaximumSize(new Dimension(460, 40));
        this._3ParamFieldsRow1PS_SFPanel.setMinimumSize(new Dimension(460, 40));
        this._3ParamFieldsRow1PS_SFPanel.setOpaque(false);
        this._3ParamFieldsRow1PS_SFPanel.setPreferredSize(new Dimension(460, 40));
        this._3ParamFieldsRow1PS_SFPanel.setLayout(new GridBagLayout());
        this._3ParamFieldsRow1PS_SFLabelA.setText("Longitude");
        this._3ParamFieldsRow1PS_SFLabelA.setMaximumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1PS_SFLabelA.setMinimumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1PS_SFLabelA.setOpaque(true);
        this._3ParamFieldsRow1PS_SFLabelA.setPreferredSize(new Dimension(105, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this._3ParamFieldsRow1PS_SFPanel.add((Component)this._3ParamFieldsRow1PS_SFLabelA, gridBagConstraints);
        this._3ParamFieldsRow1PS_SFLabelB.setText("Latitude");
        this._3ParamFieldsRow1PS_SFLabelB.setMaximumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1PS_SFLabelB.setMinimumSize(new Dimension(105, 16));
        this._3ParamFieldsRow1PS_SFLabelB.setOpaque(true);
        this._3ParamFieldsRow1PS_SFLabelB.setPreferredSize(new Dimension(105, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        this._3ParamFieldsRow1PS_SFPanel.add((Component)this._3ParamFieldsRow1PS_SFLabelB, gridBagConstraints);
        this.row1HemiBoxPanel.setBorder(BorderFactory.createTitledBorder(null, "Hemisphere:", 2, 0));
        this.row1HemiBoxPanel.setMaximumSize(new Dimension(101, 41));
        this.row1HemiBoxPanel.setMinimumSize(new Dimension(101, 41));
        this.row1HemiBoxPanel.setPreferredSize(new Dimension(101, 41));
        this.row1HemiBoxPanel.setRequestFocusEnabled(false);
        this.row1HemiBoxPanel.setLayout(new GridBagLayout());
        this.row1NHemiRadioButton.setText("N");
        this.row1NHemiRadioButton.setHorizontalTextPosition(4);
        this.row1NHemiRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.row1NHemiRadioButton.setMaximumSize(new Dimension(28, 20));
        this.row1NHemiRadioButton.setModel(this.nHemiRadioButton.getModel());
        this.row1NHemiRadioButton.setPreferredSize(new Dimension(28, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 3, 7);
        this.row1HemiBoxPanel.add((Component)this.row1NHemiRadioButton, gridBagConstraints);
        this.row1SHemiRadioButton.setText("S");
        this.row1SHemiRadioButton.setHorizontalTextPosition(4);
        this.row1SHemiRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.row1SHemiRadioButton.setMaximumSize(new Dimension(28, 20));
        this.row1SHemiRadioButton.setModel(this.sHemiRadioButton.getModel());
        this.row1SHemiRadioButton.setPreferredSize(new Dimension(28, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 7, 3, 0);
        this.row1HemiBoxPanel.add((Component)this.row1SHemiRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this._3ParamFieldsRow1PS_SFPanel.add((Component)this.row1HemiBoxPanel, gridBagConstraints);
        this._3ParamFieldsRow1PS_SFTextFieldA.setText("0 0 0.0E");
        this._3ParamFieldsRow1PS_SFTextFieldA.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow1PS_SFTextFieldA.setMaximumSize(new Dimension(138, 22));
        this._3ParamFieldsRow1PS_SFTextFieldA.setMinimumSize(new Dimension(138, 22));
        this._3ParamFieldsRow1PS_SFTextFieldA.setPreferredSize(new Dimension(138, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 0, 15);
        this._3ParamFieldsRow1PS_SFPanel.add((Component)this._3ParamFieldsRow1PS_SFTextFieldA, gridBagConstraints);
        this._3ParamFieldsRow1PS_SFTextFieldB.setText("0 0 0.0N");
        this._3ParamFieldsRow1PS_SFTextFieldB.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow1PS_SFTextFieldB.setMaximumSize(new Dimension(138, 22));
        this._3ParamFieldsRow1PS_SFTextFieldB.setMinimumSize(new Dimension(138, 22));
        this._3ParamFieldsRow1PS_SFTextFieldB.setPreferredSize(new Dimension(138, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 15, 0, 15);
        this._3ParamFieldsRow1PS_SFPanel.add((Component)this._3ParamFieldsRow1PS_SFTextFieldB, gridBagConstraints);
        this._3ParamFieldsRow1PS_SFPanel.setBounds(4, 2, 460, 40);
        this.paramFieldsRow1LayeredPane.add((Component)this._3ParamFieldsRow1PS_SFPanel, JLayeredPane.DEFAULT_LAYER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 1, 2);
        this.add((Component)this.paramFieldsRow1LayeredPane, gridBagConstraints);
        this.paramFieldsRow2LayeredPane.setMinimumSize(new Dimension(460, 55));
        this._3ParamFieldsRow2Panel.setOpaque(false);
        this._3ParamFieldsRow2Panel.setLayout(new GridLayout(2, 3, 12, 0));
        this._3ParamFieldsRow2LabelA.setText("Latitude");
        this._3ParamFieldsRow2LabelA.setOpaque(true);
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2LabelA);
        this._3ParamFieldsRow2LabelB.setText("Longitude");
        this._3ParamFieldsRow2LabelB.setOpaque(true);
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2LabelB);
        this._3ParamFieldsRow2LabelC.setText("Scale Factor");
        this._3ParamFieldsRow2LabelC.setOpaque(true);
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2LabelC);
        this._3ParamFieldsRow2TextFieldA.setText("0 0 0.00S");
        this._3ParamFieldsRow2TextFieldA.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2TextFieldA);
        this._3ParamFieldsRow2TextFieldB.setText("0 0 0.0E");
        this._3ParamFieldsRow2TextFieldB.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2TextFieldB);
        this._3ParamFieldsRow2TextFieldC.setText("4500");
        this._3ParamFieldsRow2TextFieldC.setBorder(BorderFactory.createBevelBorder(1));
        this._3ParamFieldsRow2Panel.add(this._3ParamFieldsRow2TextFieldC);
        this._3ParamFieldsRow2Panel.setBounds(0, 0, 462, 38);
        this.paramFieldsRow2LayeredPane.add((Component)this._3ParamFieldsRow2Panel, JLayeredPane.DEFAULT_LAYER);
        this._4ParamFieldsRow2Panel.setMinimumSize(new Dimension(460, 40));
        this._4ParamFieldsRow2Panel.setPreferredSize(new Dimension(460, 40));
        this._4ParamFieldsRow2Panel.setLayout(new GridLayout(2, 4, 12, 0));
        this._4ParamFieldsRow2LabelA.setText("Latitude");
        this._4ParamFieldsRow2LabelA.setMaximumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelA.setMinimumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelA.setPreferredSize(new Dimension(100, 16));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2LabelA);
        this._4ParamFieldsRow2LabelB.setText("Longitude");
        this._4ParamFieldsRow2LabelB.setMaximumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelB.setMinimumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelB.setPreferredSize(new Dimension(100, 16));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2LabelB);
        this._4ParamFieldsRow2LabelC.setText("False Easting");
        this._4ParamFieldsRow2LabelC.setMaximumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelC.setMinimumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelC.setPreferredSize(new Dimension(100, 16));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2LabelC);
        this._4ParamFieldsRow2LabelD.setText("False Northing");
        this._4ParamFieldsRow2LabelD.setMaximumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelD.setMinimumSize(new Dimension(100, 16));
        this._4ParamFieldsRow2LabelD.setPreferredSize(new Dimension(100, 16));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2LabelD);
        this._4ParamFieldsRow2TextFieldA.setText("0 0 0.00N");
        this._4ParamFieldsRow2TextFieldA.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow2TextFieldA.setMinimumSize(new Dimension(100, 20));
        this._4ParamFieldsRow2TextFieldA.setPreferredSize(new Dimension(100, 20));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2TextFieldA);
        this._4ParamFieldsRow2TextFieldB.setText("0 0 0.00W");
        this._4ParamFieldsRow2TextFieldB.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow2TextFieldB.setMinimumSize(new Dimension(100, 20));
        this._4ParamFieldsRow2TextFieldB.setPreferredSize(new Dimension(100, 20));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2TextFieldB);
        this._4ParamFieldsRow2TextFieldC.setText("200000");
        this._4ParamFieldsRow2TextFieldC.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow2TextFieldC.setMinimumSize(new Dimension(100, 20));
        this._4ParamFieldsRow2TextFieldC.setPreferredSize(new Dimension(100, 20));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2TextFieldC);
        this._4ParamFieldsRow2TextFieldD.setText("400000");
        this._4ParamFieldsRow2TextFieldD.setBorder(BorderFactory.createBevelBorder(1));
        this._4ParamFieldsRow2TextFieldD.setMinimumSize(new Dimension(100, 20));
        this._4ParamFieldsRow2TextFieldD.setPreferredSize(new Dimension(100, 20));
        this._4ParamFieldsRow2Panel.add(this._4ParamFieldsRow2TextFieldD);
        this._4ParamFieldsRow2Panel.setBounds(4, 2, 460, 40);
        this.paramFieldsRow2LayeredPane.add((Component)this._4ParamFieldsRow2Panel, JLayeredPane.DEFAULT_LAYER);
        this.zoneHemiPanel.setMinimumSize(new Dimension(220, 60));
        this.zoneHemiPanel.setOpaque(false);
        this.zoneHemiPanel.setPreferredSize(new Dimension(220, 60));
        this.zoneHemiPanel.setLayout(new GridBagLayout());
        this.zoneBoxPanel.setMinimumSize(new Dimension(175, 58));
        this.zoneBoxPanel.setPreferredSize(new Dimension(175, 58));
        this.zoneBoxPanel.setLayout(new GridBagLayout());
        this.zoneRadioButton.setText("Override:");
        this.zoneRadioButton.setActionCommand("( set )");
        this.zoneRadioButton.setHorizontalTextPosition(2);
        this.zoneRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.zoneRadioButton.setVerticalAlignment(1);
        this.zoneRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MasterPanel.this.zoneActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.zoneBoxPanel.add((Component)this.zoneRadioButton, gridBagConstraints);
        this.zoneLabel.setText("Zone");
        this.zoneLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.zoneBoxPanel.add((Component)this.zoneLabel, gridBagConstraints);
        this.zoneTextField.setHorizontalAlignment(2);
        this.zoneTextField.setText("0");
        this.zoneTextField.setBorder(BorderFactory.createBevelBorder(1));
        this.zoneTextField.setMinimumSize(new Dimension(35, 19));
        this.zoneTextField.setPreferredSize(new Dimension(41, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.zoneBoxPanel.add((Component)this.zoneTextField, gridBagConstraints);
        this.tempZoneBoxLabel.setOpaque(true);
        this.zoneBoxPanel.add((Component)this.tempZoneBoxLabel, new GridBagConstraints());
        this.zoneRangeLabel.setText("(1-60):");
        this.zoneRangeLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.zoneBoxPanel.add((Component)this.zoneRangeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.zoneHemiPanel.add((Component)this.zoneBoxPanel, gridBagConstraints);
        this.hemiBoxPanel.setBorder(BorderFactory.createTitledBorder(null, "Hemisphere:", 2, 0));
        this.hemiBoxPanel.setMaximumSize(new Dimension(101, 45));
        this.hemiBoxPanel.setMinimumSize(new Dimension(101, 45));
        this.hemiBoxPanel.setPreferredSize(new Dimension(101, 45));
        this.hemiBoxPanel.setLayout(new GridBagLayout());
        this.nHemiRadioButton.setText("N");
        this.nHemiRadioButton.setHorizontalTextPosition(4);
        this.nHemiRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.nHemiRadioButton.setMaximumSize(new Dimension(28, 20));
        this.nHemiRadioButton.setModel(this.nHemiRadioButton.getModel());
        this.nHemiRadioButton.setPreferredSize(new Dimension(28, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 7);
        this.hemiBoxPanel.add((Component)this.nHemiRadioButton, gridBagConstraints);
        this.sHemiRadioButton.setText("S");
        this.sHemiRadioButton.setHorizontalTextPosition(4);
        this.sHemiRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.sHemiRadioButton.setMaximumSize(new Dimension(28, 20));
        this.sHemiRadioButton.setModel(this.sHemiRadioButton.getModel());
        this.sHemiRadioButton.setPreferredSize(new Dimension(28, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 7, 5, 0);
        this.hemiBoxPanel.add((Component)this.sHemiRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(14, 0, 4, 55);
        this.zoneHemiPanel.add((Component)this.hemiBoxPanel, gridBagConstraints);
        this.zoneHemiPanel.setBounds(0, 0, 462, 55);
        this.paramFieldsRow2LayeredPane.add((Component)this.zoneHemiPanel, JLayeredPane.DEFAULT_LAYER);
        this.geodeticCoordinateOrderPanel.setMaximumSize(new Dimension(200, 60));
        this.geodeticCoordinateOrderPanel.setMinimumSize(new Dimension(200, 60));
        this.geodeticCoordinateOrderPanel.setPreferredSize(new Dimension(200, 60));
        this.geodeticCoordinateOrderPanel.setLayout(new GridBagLayout());
        this._geodeticCoordinateOrderPanel.setBorder(BorderFactory.createTitledBorder(null, "Coordinate Order", 2, 2));
        this._geodeticCoordinateOrderPanel.setMinimumSize(new Dimension(173, 50));
        this._geodeticCoordinateOrderPanel.setPreferredSize(new Dimension(173, 50));
        this._geodeticCoordinateOrderPanel.setLayout(new GridBagLayout());
        this.latitudeLongitudeRadioButton.setText("Latitude-Longitude");
        this.latitudeLongitudeRadioButton.setHorizontalAlignment(0);
        this.latitudeLongitudeRadioButton.setHorizontalTextPosition(4);
        this.latitudeLongitudeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.latitudeLongitudeRadioButton.setMaximumSize(new Dimension(161, 16));
        this.latitudeLongitudeRadioButton.setMinimumSize(new Dimension(161, 16));
        this.latitudeLongitudeRadioButton.setModel(this.latitudeLongitudeRadioButton.getModel());
        this.latitudeLongitudeRadioButton.setPreferredSize(new Dimension(161, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this._geodeticCoordinateOrderPanel.add((Component)this.latitudeLongitudeRadioButton, gridBagConstraints);
        this.longitudeLatitudeRadioButton.setText("Longitude-Latitude");
        this.longitudeLatitudeRadioButton.setHorizontalAlignment(0);
        this.longitudeLatitudeRadioButton.setHorizontalTextPosition(4);
        this.longitudeLatitudeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.longitudeLatitudeRadioButton.setMaximumSize(new Dimension(161, 16));
        this.longitudeLatitudeRadioButton.setMinimumSize(new Dimension(161, 16));
        this.longitudeLatitudeRadioButton.setModel(this.longitudeLatitudeRadioButton.getModel());
        this.longitudeLatitudeRadioButton.setPreferredSize(new Dimension(161, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this._geodeticCoordinateOrderPanel.add((Component)this.longitudeLatitudeRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.geodeticCoordinateOrderPanel.add((Component)this._geodeticCoordinateOrderPanel, gridBagConstraints);
        this.geodeticCoordinateOrderPanel.setBounds(0, 0, 462, 55);
        this.paramFieldsRow2LayeredPane.add((Component)this.geodeticCoordinateOrderPanel, JLayeredPane.DEFAULT_LAYER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.paramFieldsRow2LayeredPane, gridBagConstraints);
    }

    private void heightComboBoxActionPerformed(ActionEvent actionEvent) {
        this.heightType = this.heightComboBox.getSelectedIndex();
        if (this.heightType == 2) {
            this.heightType = 7;
        } else if (this.heightType > 1) {
            --this.heightType;
        }
        if (this.state != 0) {
            if (this.heightComboBox.getSelectedIndex() == 0) {
                this.setHeightFieldEditable(false);
            } else {
                this.setHeightFieldEditable(true);
            }
        }
    }

    private void zoneActionPerformed(ActionEvent actionEvent) {
        if (this.zoneRadioButton.isSelected()) {
            this.override = 1L;
        } else if (!this.zoneRadioButton.isSelected()) {
            this.override = 0L;
        }
    }

    private void projectionComboBoxActionPerformed(ActionEvent actionEvent) {
        this.projectionType = CoordinateType.index((String)this.projectionComboBox.getSelectedItem());
        this.createMasterPanel();
        if (this.state != 0) {
            this.coordPanel.createCoordPanel(this.projectionType);
            if (this.parent != null) {
                this.parent.checkValidConversion();
            }
        }
        if (this.parent != null) {
            this.parent.check3DConversion();
        }
    }

    private void datumComboBoxActionPerformed(ActionEvent actionEvent) {
        try {
            this.datumIndex = this.datumComboBox.getSelectedIndex();
            String string = this.jniDatumLibrary.getDatumInfo(this.datumIndex).getDatumEllipsoidCode();
            long l = this.jniEllipsoidLibrary.getEllipsoidIndex(string);
            String string2 = this.jniEllipsoidLibrary.getEllipsoidInfo(l).getName();
            this.ellipsoidTextField.setText(string + ":  " + string2);
            this.ellipsoidTextField.setCaretPosition(0);
            if (this.parent != null) {
                this.parent.checkValidConversion();
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void initFileInputPanel() throws CoordinateConversionException {
        this.datumComboBox.setVisible(false);
        this.projectionComboBox.setVisible(false);
        this.datumIndex = this.jniDatumLibrary.getDatumIndex(this.datumCode);
        Info info = this.jniDatumLibrary.getDatumInfo(this.datumIndex);
        String string = info.getName();
        this.datumTextField.setText(this.datumCode + ":  " + string);
        String string2 = info.getDatumEllipsoidCode();
        long l = this.jniEllipsoidLibrary.getEllipsoidIndex(string2);
        String string3 = this.jniEllipsoidLibrary.getEllipsoidInfo(l).getName();
        this.ellipsoidTextField.setText(string2 + ":  " + string3);
        switch (this.projectionType) {
            case 0: 
            case 15: {
                if (this.projectionType == 0) {
                    this.inputProjectionLabel.setText("Albers Equal Area Conic Projection");
                } else {
                    this.inputProjectionLabel.setText("Lambert Conformal Conic (2 Standard Parallel) Projection");
                }
                MapProjection6Parameters mapProjection6Parameters = (MapProjection6Parameters)this.coordinateSystemParameters;
                this.setSixParams();
                this.setSixParamsUnedit();
                this._4ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(mapProjection6Parameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(mapProjection6Parameters.getOriginLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(mapProjection6Parameters.getStandardParallel1() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow1TextFieldD.setText(this.stringHandler.latitudeToString(mapProjection6Parameters.getStandardParallel2() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mapProjection6Parameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mapProjection6Parameters.getFalseNorthing()));
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 29: 
            case 36: {
                switch (this.projectionType) {
                    case 6: {
                        this.inputProjectionLabel.setText("Eckert IV Projection");
                        break;
                    }
                    case 7: {
                        this.inputProjectionLabel.setText("Eckert VI Projection");
                        break;
                    }
                    case 20: {
                        this.inputProjectionLabel.setText("Miller Cylindrical Projection");
                        break;
                    }
                    case 21: {
                        this.inputProjectionLabel.setText("Mollweide Projection");
                        break;
                    }
                    case 29: {
                        this.inputProjectionLabel.setText("Sinusoidal Projection");
                        break;
                    }
                    case 36: {
                        this.inputProjectionLabel.setText("Van der Grinten Projection");
                    }
                }
                MapProjection3Parameters mapProjection3Parameters = (MapProjection3Parameters)this.coordinateSystemParameters;
                this.setThreeParams();
                this.setThreeParamsUnedit();
                this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(mapProjection3Parameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mapProjection3Parameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mapProjection3Parameters.getFalseNorthing()));
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 25: 
            case 28: 
            case 30: {
                switch (this.projectionType) {
                    case 1: {
                        this.inputProjectionLabel.setText("Azimuthal Equidistant Projection");
                        break;
                    }
                    case 2: {
                        this.inputProjectionLabel.setText("Bonne Projection");
                        break;
                    }
                    case 4: {
                        this.inputProjectionLabel.setText("Cassini Projection");
                        break;
                    }
                    case 5: {
                        this.inputProjectionLabel.setText("Cylindrical Equal Area Projection");
                        break;
                    }
                    case 13: {
                        this.inputProjectionLabel.setText("Gnomonic Projection");
                        break;
                    }
                    case 25: {
                        this.inputProjectionLabel.setText("Orthographic Projection");
                        break;
                    }
                    case 28: {
                        this.inputProjectionLabel.setText("Polyconic Projection");
                        break;
                    }
                    case 30: {
                        this.inputProjectionLabel.setText("Stereographic Projection");
                    }
                }
                MapProjection4Parameters mapProjection4Parameters = (MapProjection4Parameters)this.coordinateSystemParameters;
                this.setFourParams();
                this.setFourParamsUnedit();
                this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(mapProjection4Parameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(mapProjection4Parameters.getOriginLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mapProjection4Parameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mapProjection4Parameters.getFalseNorthing()));
                break;
            }
            case 14: {
                this.inputProjectionLabel.setText("Lambert Conformal Conic (1 Standard Parallel) Projection");
                MapProjection5Parameters mapProjection5Parameters = (MapProjection5Parameters)this.coordinateSystemParameters;
                this.setFiveParams();
                this._3ParamFieldsRow1LabelB.setText("Origin Latitude:");
                this.setFiveParamsUnedit();
                this._3ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(mapProjection5Parameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(mapProjection5Parameters.getOriginLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this.stringHandler.setNumberFormat(this._3ParamFieldsRow1TextFieldC, mapProjection5Parameters.getScaleFactor(), 5);
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mapProjection5Parameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mapProjection5Parameters.getFalseNorthing()));
                break;
            }
            case 31: 
            case 32: {
                switch (this.projectionType) {
                    case 31: {
                        this.inputProjectionLabel.setText("Transverse Cylindrical Equal Area Projection");
                        break;
                    }
                    case 32: {
                        this.inputProjectionLabel.setText("Transverse Mercator Projection");
                    }
                }
                MapProjection5Parameters mapProjection5Parameters = (MapProjection5Parameters)this.coordinateSystemParameters;
                this.setFiveParams();
                this.setFiveParamsUnedit();
                this._3ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(mapProjection5Parameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(mapProjection5Parameters.getOriginLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this.stringHandler.setNumberFormat(this._3ParamFieldsRow1TextFieldC, mapProjection5Parameters.getScaleFactor(), 5);
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mapProjection5Parameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mapProjection5Parameters.getFalseNorthing()));
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 22: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                switch (this.projectionType) {
                    case 3: {
                        this.inputProjectionLabel.setText("British National Grid Coordinates");
                        break;
                    }
                    case 38: {
                        break;
                    }
                    case 12: {
                        this.inputProjectionLabel.setText("GARS Coordinates");
                        break;
                    }
                    case 9: {
                        this.inputProjectionLabel.setText("Geocentric Coordinates");
                        break;
                    }
                    case 11: {
                        this.inputProjectionLabel.setText("GEOREF Coordinates");
                        break;
                    }
                    case 19: {
                        this.inputProjectionLabel.setText("MGRS Coordinates");
                        break;
                    }
                    case 22: {
                        this.inputProjectionLabel.setText("New Zealand Map Grid Projection");
                        break;
                    }
                    case 33: {
                        this.inputProjectionLabel.setText("Universal Polar Stereographic (UPS) Projection");
                        break;
                    }
                    case 35: {
                        this.inputProjectionLabel.setText("USNG Coordinates");
                        break;
                    }
                    case 34: {
                        this.inputProjectionLabel.setText("Universal Transverse Mercator (UTM) Projection");
                        break;
                    }
                    case 37: {
                        this.inputProjectionLabel.setText("Web Mercator Projection");
                    }
                }
                this.hideParams();
                break;
            }
            case 8: {
                this.inputProjectionLabel.setText("Equidistant Cylindrical");
                EquidistantCylindricalParameters equidistantCylindricalParameters = (EquidistantCylindricalParameters)this.coordinateSystemParameters;
                this.setFourParams();
                this._4ParamFieldsRow1LabelC.setText("Standard Parallel:");
                this.setFourParamsUnedit();
                this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(equidistantCylindricalParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(equidistantCylindricalParameters.getStandardParallel() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(equidistantCylindricalParameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(equidistantCylindricalParameters.getFalseNorthing()));
                break;
            }
            case 10: {
                this.inputProjectionLabel.setText("Geodetic Coordinates");
                GeodeticParameters geodeticParameters = (GeodeticParameters)this.coordinateSystemParameters;
                this.hideParams();
                this.heightLabelPanel.setVisible(true);
                this.paramFieldsRow1LayeredPane.moveToFront(this.heightLabelPanel);
                int n = geodeticParameters.getHeightType();
                if (n == 2) {
                    this.heightLabel.setText("MSL-EGM96-15M-BL Height");
                    break;
                }
                if (n == 3) {
                    this.heightLabel.setText("MSL-EGM96-VG-NS Height");
                    break;
                }
                if (n == 4) {
                    this.heightLabel.setText("MSL-EGM84-10D-BL Height");
                    break;
                }
                if (n == 5) {
                    this.heightLabel.setText("MSL-EGM84-10D-NS Height");
                    break;
                }
                if (n == 6) {
                    this.heightLabel.setText("MSL-EGM84-30M-BL Height");
                    break;
                }
                if (n == 7) {
                    this.heightLabel.setText("MSL-EGM2008-2.5M-BCS Height");
                    break;
                }
                if (n == 0) {
                    this.heightLabel.setText("No Height");
                    break;
                }
                this.heightLabel.setText("Ellipsoid Height");
                break;
            }
            case 16: {
                this.inputProjectionLabel.setText("Local Cartesian Coordinates");
                LocalCartesianParameters localCartesianParameters = (LocalCartesianParameters)this.coordinateSystemParameters;
                this.setLCFourParams();
                this.setLCFourParamsUnedit();
                this._3ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(localCartesianParameters.getLongitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(localCartesianParameters.getLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._3ParamFieldsRow1TextFieldC.setText(this.stringHandler.meterToString(localCartesianParameters.getHeight()));
                this._3ParamFieldsRow2TextFieldB.setText(this.stringHandler.longitudeToString(localCartesianParameters.getOrientation() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                break;
            }
            case 17: {
                this.inputProjectionLabel.setText("Mercator (Standard Parallel) Projection");
                MercatorStandardParallelParameters mercatorStandardParallelParameters = (MercatorStandardParallelParameters)this.coordinateSystemParameters;
                this.setFiveParams();
                this._3ParamFieldsRow1LabelB.setText("Standard Parallel:");
                this.setFiveParamsUnedit();
                this._3ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(mercatorStandardParallelParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(mercatorStandardParallelParameters.getStandardParallel() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this.stringHandler.setNumberFormat(this._3ParamFieldsRow1TextFieldC, mercatorStandardParallelParameters.getScaleFactor(), 5);
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mercatorStandardParallelParameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mercatorStandardParallelParameters.getFalseNorthing()));
                break;
            }
            case 18: {
                this.inputProjectionLabel.setText("Mercator (Scale Factor) Projection");
                MercatorScaleFactorParameters mercatorScaleFactorParameters = (MercatorScaleFactorParameters)this.coordinateSystemParameters;
                this.setFourParams();
                this._4ParamFieldsRow1LabelC.setText("Scale Factor:");
                this.setFourParamsUnedit();
                this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(mercatorScaleFactorParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this.stringHandler.setNumberFormat(this._4ParamFieldsRow1TextFieldC, mercatorScaleFactorParameters.getScaleFactor(), 5);
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mercatorScaleFactorParameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mercatorScaleFactorParameters.getFalseNorthing()));
                break;
            }
            case 23: {
                this.inputProjectionLabel.setText("Ney's (Modified Lambert Conformal Conic) Projection");
                boolean bl = true;
                NeysParameters neysParameters = (NeysParameters)this.coordinateSystemParameters;
                this.setSixParams();
                this.setSixParamsUnedit();
                double d = neysParameters.getOriginLatitude();
                if (d < 0.0) {
                    bl = false;
                }
                this._4ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(neysParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(d * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                if (bl) {
                    this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(neysParameters.getStandardParallel1() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                } else {
                    this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(neysParameters.getStandardParallel1() * -57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                if (bl) {
                    this._4ParamFieldsRow1TextFieldD.setText(this.stringHandler.latitudeToString(89.99944444444444, this.useNSEW, this.useMinutes, this.useSeconds));
                } else {
                    this._4ParamFieldsRow1TextFieldD.setText(this.stringHandler.latitudeToString(-89.99944444444444, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(neysParameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(neysParameters.getFalseNorthing()));
                break;
            }
            case 24: {
                this.inputProjectionLabel.setText("Oblique Mercator Projection");
                ObliqueMercatorParameters obliqueMercatorParameters = (ObliqueMercatorParameters)this.coordinateSystemParameters;
                this.setEightParams();
                this.setEightParamsUnedit();
                this._4ParamFieldsRow1TextFieldA.setText(this.stringHandler.latitudeToString(obliqueMercatorParameters.getOriginLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this.stringHandler.setNumberFormat(this._4ParamFieldsRow1TextFieldB, obliqueMercatorParameters.getScaleFactor(), 5);
                this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.longitudeToString(obliqueMercatorParameters.getLongitude1() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow1TextFieldD.setText(this.stringHandler.latitudeToString(obliqueMercatorParameters.getLatitude1() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow2TextFieldA.setText(this.stringHandler.longitudeToString(obliqueMercatorParameters.getLongitude2() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.latitudeToString(obliqueMercatorParameters.getLatitude2() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(obliqueMercatorParameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldD.setText(this.stringHandler.meterToString(obliqueMercatorParameters.getFalseNorthing()));
                break;
            }
            case 26: {
                this.inputProjectionLabel.setText("Polar Stereographic (Standard Parallel) Projection");
                PolarStereographicStandardParallelParameters polarStereographicStandardParallelParameters = (PolarStereographicStandardParallelParameters)this.coordinateSystemParameters;
                this.setFourParams();
                this._4ParamFieldsRow1LabelB.setText("Central Meridian:");
                this._4ParamFieldsRow1LabelC.setText("Standard Parallel:");
                this.setFourParamsUnedit();
                this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(polarStereographicStandardParallelParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(polarStereographicStandardParallelParameters.getStandardParallel() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(polarStereographicStandardParallelParameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(polarStereographicStandardParallelParameters.getFalseNorthing()));
                break;
            }
            case 27: {
                this.inputProjectionLabel.setText("Polar Stereographic (Scale Factor) Projection");
                PolarStereographicScaleFactorParameters polarStereographicScaleFactorParameters = (PolarStereographicScaleFactorParameters)this.coordinateSystemParameters;
                this.setPS_SFFourParams();
                this._3ParamFieldsRow1PS_SFLabelA.setText("Central Meridian:");
                this._3ParamFieldsRow1PS_SFLabelB.setText("Scale Factor:");
                this.setPS_SFFourParamsUnedit();
                this._3ParamFieldsRow1PS_SFTextFieldA.setText(this.stringHandler.longitudeToString(polarStereographicScaleFactorParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                this.stringHandler.setNumberFormat(this._3ParamFieldsRow1PS_SFTextFieldB, polarStereographicScaleFactorParameters.getScaleFactor(), 5);
                char c = polarStereographicScaleFactorParameters.getHemisphere();
                if (c == 'N') {
                    this.row1NHemiRadioButton.setSelected(true);
                    this.row1SHemiRadioButton.setSelected(false);
                } else {
                    this.row1NHemiRadioButton.setSelected(false);
                    this.row1SHemiRadioButton.setSelected(true);
                }
                this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(polarStereographicScaleFactorParameters.getFalseEasting()));
                this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(polarStereographicScaleFactorParameters.getFalseNorthing()));
                break;
            }
        }
    }

    private void initMasterPanel() {
        try {
            this.datumTextField.setVisible(false);
            this.inputProjectionLabel.setVisible(false);
            this.fillHeightList();
            this.datumList = new FillList(this.jniDatumLibrary, this.jniEllipsoidLibrary, this.datumComboBox, 0);
            this.fillProjectionList();
            if (this.state == 0) {
                this.datumIndex = 0L;
                this.projectionType = 10;
            } else {
                this.datumIndex = this.jniDatumLibrary.getDatumIndex(this.jniCoordinateConversionService.getDatum(this.direction));
                this.projectionType = this.jniCoordinateConversionService.getCoordinateSystem(this.direction).getCoordinateType();
            }
            this.datumComboBox.setSelectedIndex((int)this.datumIndex);
            this.projectionComboBox.setSelectedItem(CoordinateType.name(this.projectionType));
            if (this.state == 1) {
                this.coordPanel.createCoordPanel(this.projectionType);
            }
            this.createButtonGroups();
            this.createMasterPanel();
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void createMasterPanel() {
        this.setFormat();
        switch (this.projectionType) {
            case 10: {
                this.hideParams();
                this.setHeight();
                if (this.state != 0 || this.direction != 1) break;
                this.geodeticCoordinateOrderPanel.setVisible(true);
                this.latitudeLongitudeRadioButton.setSelected(true);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 22: 
            case 35: 
            case 37: 
            case 38: {
                this.hideParams();
                break;
            }
            case 33: {
                if (this.state == 1) {
                    this.setZone_Hemi();
                    this.zoneHemiPanel.setBounds(90, 0, 462, 55);
                    this.zoneBoxPanel.setVisible(false);
                } else {
                    this.hideParams();
                }
                if (Platform.isJavaV1_3) break;
                if (Platform.isUnix) {
                    if (this.currLookAndFeel.equals("Java")) {
                        this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                        break;
                    }
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                    break;
                }
                if (this.currLookAndFeel.equals("Java")) {
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 12)));
                    break;
                }
                this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 12)));
                break;
            }
            case 34: {
                this.setZone_Hemi();
                this.zoneHemiPanel.setBounds(0, 0, 462, 55);
                if (this.state == 1) {
                    this.hemiBoxPanel.setVisible(true);
                } else {
                    this.hemiBoxPanel.setVisible(false);
                }
                this.zoneBoxPanel.setVisible(true);
                if (Platform.isJavaV1_3) break;
                if (Platform.isUnix) {
                    if (this.currLookAndFeel.equals("Java")) {
                        this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                        break;
                    }
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                    break;
                }
                if (this.currLookAndFeel.equals("Java")) {
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 12)));
                    break;
                }
                this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 12)));
                break;
            }
            case 16: {
                this.setLCFourParams();
                this._3ParamFieldsRow1TextFieldC.setEditable(true);
                break;
            }
            case 24: {
                this.setEightParams();
                break;
            }
            case 0: 
            case 15: {
                this.setSixParams();
                break;
            }
            case 23: {
                this.setSixParams();
                this._4ParamFieldsRow1Panel.setVisible(false);
                this.neysParamsRow1Panel.setVisible(true);
                this.neys71RadioButton.setSelected(true);
                try {
                    this.centralMeridianNeysParamsTextField.setText(this.stringHandler.longitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.originLatitudeNeysParamsTextField.setText(this.stringHandler.latitudeToString(80.0, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.stdParallel2NeysParamsTextField.setText(this.stringHandler.latitudeToString(89.99944444444444, false, this.useMinutes, this.useSeconds));
                }
                catch (CoordinateConversionException coordinateConversionException) {
                    this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
                }
                if (Platform.isJavaV1_3) break;
                if (Platform.isUnix) {
                    if (this.currLookAndFeel.equals("Java")) {
                        this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                        break;
                    }
                    this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                    break;
                }
                if (this.currLookAndFeel.equals("Java")) {
                    this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 12)));
                    break;
                }
                this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 0, 12)));
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 13: 
            case 25: 
            case 28: 
            case 30: {
                this.setFourParams();
                break;
            }
            case 2: {
                this.setFourParams();
                try {
                    this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(45.0, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                catch (CoordinateConversionException coordinateConversionException) {
                    this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
                }
                break;
            }
            case 8: {
                this.setFourParams();
                this._4ParamFieldsRow1LabelC.setText("Standard Parallel:");
                break;
            }
            case 26: {
                this.setFourParams();
                try {
                    this._4ParamFieldsRow1LabelB.setText("Central Meridian:");
                    this._4ParamFieldsRow1LabelC.setText("Standard Parallel:");
                    this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(90.0, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                catch (CoordinateConversionException coordinateConversionException) {
                    this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
                }
                break;
            }
            case 27: {
                this.setPS_SFFourParams();
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 29: 
            case 36: {
                this.setThreeParams();
                break;
            }
            case 17: {
                this.setFiveParams();
                this._3ParamFieldsRow1LabelB.setText("Standard Parallel:");
                this._3ParamFieldsRow1TextFieldC.setEditable(false);
                break;
            }
            case 18: {
                this.setFourParams();
                this._4ParamFieldsRow1LabelC.setText("Scale Factor:");
                this._4ParamFieldsRow1TextFieldC.setText("1.00000");
                break;
            }
            case 14: {
                this.setFiveParams();
                this._3ParamFieldsRow1LabelB.setText("Origin Latitude:");
                this._3ParamFieldsRow1TextFieldC.setEditable(true);
                try {
                    this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(45.0, this.useNSEW, this.useMinutes, this.useSeconds));
                }
                catch (CoordinateConversionException coordinateConversionException) {
                    this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
                }
                break;
            }
            case 31: 
            case 32: {
                this.setFiveParams();
                this._3ParamFieldsRow1TextFieldC.setEditable(true);
                break;
            }
        }
    }

    public CoordinateSystemParameters getParameters() throws CoordinateConversionException {
        switch (this.projectionType) {
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 29: 
            case 36: {
                return new MapProjection3Parameters(this.projectionType, this.stringHandler.stringToLongitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 25: 
            case 28: 
            case 30: {
                return new MapProjection4Parameters(this.projectionType, this.stringHandler.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 14: {
                return new MapProjection5Parameters(this.projectionType, this.stringHandler.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.stringHandler.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Scale Factor"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 31: 
            case 32: {
                return new MapProjection5Parameters(this.projectionType, this.stringHandler.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.stringHandler.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Scale Factor"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 0: 
            case 15: {
                return new MapProjection6Parameters(this.projectionType, this.stringHandler.stringToLongitude(this._4ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid 1st Standard Parallel"), this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldD.getText().trim(), "Invalid 2nd Standard Parallel"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 8: {
                return new EquidistantCylindricalParameters(this.projectionType, this.stringHandler.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Standard Parallel"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 10: {
                return new GeodeticParameters(this.projectionType, this.heightType);
            }
            case 16: {
                return new LocalCartesianParameters(this.projectionType, this.stringHandler.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Origin Longitude"), this.stringHandler.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude"), this.stringHandler.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Height"), this.stringHandler.stringToLongitude(this._3ParamFieldsRow2TextFieldB.getText().trim(), "Invalid Orientation"));
            }
            case 17: {
                return new MercatorStandardParallelParameters(this.projectionType, this.stringHandler.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Standard Parallel"), this.stringHandler.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Scale Factor"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 18: {
                return new MercatorScaleFactorParameters(this.projectionType, this.stringHandler.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToDouble(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Scale Factor"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 23: {
                double d = 71.0;
                if (this.neys71RadioButton.isSelected()) {
                    d = 71.0;
                } else if (this.neys74RadioButton.isSelected()) {
                    d = 74.0;
                }
                return new NeysParameters(this.projectionType, this.stringHandler.stringToLongitude(this.centralMeridianNeysParamsTextField.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToLatitude(this.originLatitudeNeysParamsTextField.getText().trim(), "Invalid Origin Latitude"), d * (Math.PI / 180), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 24: {
                return new ObliqueMercatorParameters(this.projectionType, this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Origin Latitude"), this.stringHandler.stringToLongitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Longitude 1"), this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldD.getText().trim(), "Invalid Latitude 1"), this.stringHandler.stringToLongitude(this._4ParamFieldsRow2TextFieldA.getText().trim(), "Invalid Longitude 2"), this.stringHandler.stringToLatitude(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid Latitude 2"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldD.getText().trim(), "Invalid False Northing"), this.stringHandler.stringToDouble(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Scale Factor"));
            }
            case 26: {
                return new PolarStereographicStandardParallelParameters(this.projectionType, this.stringHandler.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Standard Parallel"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 27: {
                char c = 'N';
                if (this.row1NHemiRadioButton.isSelected()) {
                    c = 'N';
                } else if (this.row1SHemiRadioButton.isSelected()) {
                    c = 'S';
                }
                return new PolarStereographicScaleFactorParameters(this.projectionType, this.stringHandler.stringToLongitude(this._3ParamFieldsRow1PS_SFTextFieldA.getText().trim(), "Invalid Central Meridian"), this.stringHandler.stringToDouble(this._3ParamFieldsRow1PS_SFTextFieldB.getText().trim(), "Invalid Scale Factor"), c, this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting"), this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing"));
            }
            case 34: {
                if (this.zoneRadioButton.isSelected()) {
                    long l = this.stringHandler.stringToInt(this.zoneTextField.getText().trim(), "Invalid zone");
                    if (l < 1L || l > 60L) {
                        throw new CoordinateConversionException("Zone out of range (1-60)");
                    }
                    return new UTMParameters(this.projectionType, this.stringHandler.stringToInt(this.zoneTextField.getText().trim(), "Invalid zone"), this.override);
                }
                return new UTMParameters(this.projectionType, 0L, this.override);
            }
            case 3: {
                return new CoordinateSystemParameters(3);
            }
            case 12: {
                return new CoordinateSystemParameters(12);
            }
            case 9: {
                return new CoordinateSystemParameters(9);
            }
            case 11: {
                return new CoordinateSystemParameters(11);
            }
            case 19: 
            case 38: {
                return new CoordinateSystemParameters(19);
            }
            case 22: {
                return new CoordinateSystemParameters(22);
            }
            case 33: {
                return new CoordinateSystemParameters(33);
            }
            case 35: {
                return new CoordinateSystemParameters(35);
            }
            case 37: {
                return new CoordinateSystemParameters(37);
            }
        }
        throw new CoordinateConversionException("Invalid coordinate type");
    }

    public CoordinateTuple initTargetCoordinates() throws CoordinateConversionException {
        return this.coordPanel.initTargetCoordinates(this.projectionType);
    }

    public void setCoordinates(CoordinateTuple coordinateTuple) {
        if (this.coordPanel.setCoordinates(this.state, this.direction, this.projectionType, coordinateTuple)) {
            if (this.projectionType == 17) {
                try {
                    MercatorStandardParallelParameters mercatorStandardParallelParameters = (MercatorStandardParallelParameters)this.jniCoordinateConversionService.getCoordinateSystem(this.direction);
                    this.stringHandler.setNumberFormat(this._3ParamFieldsRow1TextFieldC, mercatorStandardParallelParameters.getScaleFactor(), 5);
                }
                catch (CoordinateConversionException coordinateConversionException) {
                    this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
                }
            } else if (this.projectionType == 34) {
                this.zoneTextField.setText(String.valueOf(this.coordPanel.getZone()));
                if (this.coordPanel.getHemisphere() == 'N') {
                    this.nHemiRadioButton.setSelected(true);
                } else {
                    this.sHemiRadioButton.setSelected(true);
                }
            } else if (this.projectionType == 33) {
                if (this.coordPanel.getHemisphere() == 'N') {
                    this.nHemiRadioButton.setSelected(true);
                } else {
                    this.sHemiRadioButton.setSelected(true);
                }
            }
        }
    }

    public CoordinateTuple getCoordinates() throws CoordinateConversionException {
        if (this.state != 0) {
            if (this.projectionType == 34) {
                this.coordPanel.setZone(this.stringHandler.stringToInt(this.zoneTextField.getText().trim(), "Invalid zone"));
                if (this.nHemiRadioButton.isSelected()) {
                    this.coordPanel.setHemisphere('N');
                } else {
                    this.coordPanel.setHemisphere('S');
                }
            } else if (this.projectionType == 33) {
                if (this.nHemiRadioButton.isSelected()) {
                    this.coordPanel.setHemisphere('N');
                } else {
                    this.coordPanel.setHemisphere('S');
                }
            }
            return this.coordPanel.getCoordinates(this.state, this.direction, this.projectionType);
        }
        throw new CoordinateConversionException("getCoordinates: Unable to get coordinates: Conversion state is file processing, not interactive");
    }

    public Accuracy getAccuracy() {
        return this.coordPanel.getAccuracy();
    }

    public void setCoordinateConversionService(JNICoordinateConversionService jNICoordinateConversionService) throws CoordinateConversionException {
        try {
            this.jniCoordinateConversionService = jNICoordinateConversionService;
            this.jniDatumLibrary = new JNIDatumLibrary(jNICoordinateConversionService.getDatumLibrary());
            this.jniEllipsoidLibrary = new JNIEllipsoidLibrary(jNICoordinateConversionService.getEllipsoidLibrary());
        }
        catch (CoordinateConversionException coordinateConversionException) {
            throw new CoordinateConversionException("setCoordinateConversionService: " + coordinateConversionException.getMessage());
        }
    }

    private void createButtonGroups() {
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ButtonGroup buttonGroup3 = new ButtonGroup();
        ButtonGroup buttonGroup4 = new ButtonGroup();
        buttonGroup.add(this.row1NHemiRadioButton);
        buttonGroup.add(this.row1SHemiRadioButton);
        buttonGroup2.add(this.nHemiRadioButton);
        buttonGroup2.add(this.sHemiRadioButton);
        buttonGroup3.add(this.neys71RadioButton);
        buttonGroup3.add(this.neys74RadioButton);
        buttonGroup4.add(this.latitudeLongitudeRadioButton);
        buttonGroup4.add(this.longitudeLatitudeRadioButton);
    }

    private void hideParams() {
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(460, 55));
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(460, 55));
        this.paramFieldsRow1LayeredPane.setPreferredSize(new Dimension(460, 55));
        this.paramFieldsRow2LayeredPane.setMinimumSize(new Dimension(460, 55));
        this.paramFieldsRow2LayeredPane.setMaximumSize(new Dimension(460, 55));
        this.paramFieldsRow2LayeredPane.setPreferredSize(new Dimension(460, 55));
        this._3ParamFieldsRow1Panel.setBounds(0, 0, 462, 38);
        this._3ParamFieldsRow1PS_SFPanel.setBounds(0, 0, 462, 38);
        this._3ParamFieldsRow2Panel.setBounds(0, 0, 462, 38);
        this._3ParamFieldsRow1Panel.setVisible(false);
        this._3ParamFieldsRow1PS_SFPanel.setVisible(false);
        this._4ParamFieldsRow1Panel.setVisible(false);
        this._3ParamFieldsRow2Panel.setVisible(false);
        this._4ParamFieldsRow2Panel.setVisible(false);
        this.neysParamsRow1Panel.setVisible(false);
        this.zoneHemiPanel.setVisible(false);
        this.heightPanel.setVisible(false);
        this.heightLabelPanel.setVisible(false);
        this.geodeticCoordinateOrderPanel.setVisible(false);
        this.row1HemiBoxPanel.setVisible(false);
    }

    private void setHeight() {
        this.hideParams();
        this.heightPanel.setVisible(true);
        this.paramFieldsRow2LayeredPane.moveToFront(this.heightPanel);
        if (this.state == 0 && !this.createHeader) {
            if (this.inputFileType != 10 && this.inputFileType != 9 && this.inputFileType != 16) {
                this.selectNoHeightButton();
                this.enableHeightComboBox(false);
            }
        } else {
            if (this.heightType == 7) {
                this.heightType = 2;
            } else if (this.heightType < 7 && this.heightType >= 2) {
                ++this.heightType;
            }
            this.heightComboBox.setSelectedIndex(this.heightType);
            this.enableHeightComboBox(true);
        }
    }

    private void setZone_Hemi() {
        this.hideParams();
        this.zoneHemiPanel.setVisible(true);
        this.paramFieldsRow2LayeredPane.moveToFront(this.zoneHemiPanel);
        this.nHemiRadioButton.setSelected(true);
        this.zoneTextField.setText("0");
        this.zoneRadioButton.setSelected(false);
        this.override = 0L;
    }

    private void setThreeParams() {
        this.setFormat();
        this.hideParams();
        this._3ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setPreferredSize(new Dimension(439, 55));
        this._3ParamFieldsRow1Panel.setBounds(2, 2, 439, 37);
        this._3ParamFieldsRow1LabelA.setVisible(false);
        this._3ParamFieldsRow1LabelC.setVisible(false);
        this._4ParamFieldsRow2LabelA.setVisible(false);
        this._4ParamFieldsRow2LabelD.setVisible(false);
        this._3ParamFieldsRow1TextFieldA.setVisible(false);
        this._3ParamFieldsRow1TextFieldC.setVisible(false);
        this._4ParamFieldsRow2TextFieldA.setVisible(false);
        this._4ParamFieldsRow2TextFieldD.setVisible(false);
        this._3ParamFieldsRow1LabelB.setText("Central Meridian:");
        this._4ParamFieldsRow2LabelB.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelC.setText("False Northing (m):");
        try {
            this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
        this._4ParamFieldsRow2TextFieldB.setText("0");
        this._4ParamFieldsRow2TextFieldC.setText("0");
    }

    private void setThreeParamsUnedit() {
        this._3ParamFieldsRow1TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
    }

    private void setFourParams() {
        this.setFormat();
        this.hideParams();
        this._4ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this._4ParamFieldsRow1LabelA.setVisible(false);
        this._4ParamFieldsRow1LabelD.setVisible(false);
        this._4ParamFieldsRow2LabelA.setVisible(false);
        this._4ParamFieldsRow2LabelD.setVisible(false);
        this._4ParamFieldsRow1TextFieldA.setVisible(false);
        this._4ParamFieldsRow1TextFieldD.setVisible(false);
        this._4ParamFieldsRow2TextFieldA.setVisible(false);
        this._4ParamFieldsRow2TextFieldD.setVisible(false);
        this._4ParamFieldsRow1LabelB.setText("Central Meridian:");
        this._4ParamFieldsRow1LabelC.setText("Origin Latitude:");
        this._4ParamFieldsRow2LabelB.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelC.setText("False Northing (m):");
        try {
            this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
        this._4ParamFieldsRow2TextFieldB.setText("0");
        this._4ParamFieldsRow2TextFieldC.setText("0");
    }

    private void setFourParamsUnedit() {
        this._4ParamFieldsRow1TextFieldB.setEditable(false);
        this._4ParamFieldsRow1TextFieldC.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
    }

    private void setLCFourParams() {
        this.setFormat();
        this.hideParams();
        this._3ParamFieldsRow1Panel.setVisible(true);
        this._3ParamFieldsRow2Panel.setVisible(true);
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setPreferredSize(new Dimension(439, 55));
        this.paramFieldsRow2LayeredPane.setMinimumSize(new Dimension(439, 55));
        this.paramFieldsRow2LayeredPane.setMaximumSize(new Dimension(439, 55));
        this.paramFieldsRow2LayeredPane.setPreferredSize(new Dimension(439, 55));
        this._3ParamFieldsRow1Panel.setBounds(2, 2, 439, 37);
        this._3ParamFieldsRow2Panel.setBounds(2, 2, 439, 37);
        this._3ParamFieldsRow1LabelA.setVisible(true);
        this._3ParamFieldsRow1LabelC.setVisible(true);
        this._3ParamFieldsRow1TextFieldA.setVisible(true);
        this._3ParamFieldsRow1TextFieldC.setVisible(true);
        this._3ParamFieldsRow2LabelA.setVisible(false);
        this._3ParamFieldsRow2LabelC.setVisible(false);
        this._3ParamFieldsRow2TextFieldA.setVisible(false);
        this._3ParamFieldsRow2TextFieldC.setVisible(false);
        this._3ParamFieldsRow1LabelA.setText("Origin Longitude:");
        this._3ParamFieldsRow1LabelB.setText("Origin Latitude:");
        this._3ParamFieldsRow1LabelC.setText("Origin Height (m):");
        this._3ParamFieldsRow2LabelB.setText("Orientation:");
        try {
            this._3ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._3ParamFieldsRow1TextFieldC.setText("0");
            this._3ParamFieldsRow2TextFieldB.setText(this.stringHandler.longitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void setLCFourParamsUnedit() {
        this._3ParamFieldsRow1TextFieldA.setEditable(false);
        this._3ParamFieldsRow1TextFieldB.setEditable(false);
        this._3ParamFieldsRow1TextFieldC.setEditable(false);
        this._3ParamFieldsRow2TextFieldB.setEditable(false);
    }

    private void setPS_SFFourParams() {
        this.setFormat();
        this.hideParams();
        this._3ParamFieldsRow1PS_SFPanel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setPreferredSize(new Dimension(439, 55));
        this._3ParamFieldsRow1PS_SFPanel.setBounds(2, 2, 439, 37);
        this._3ParamFieldsRow1PS_SFLabelA.setVisible(true);
        this._3ParamFieldsRow1PS_SFTextFieldA.setVisible(true);
        this._4ParamFieldsRow2LabelA.setVisible(false);
        this._4ParamFieldsRow2LabelD.setVisible(false);
        this._4ParamFieldsRow2TextFieldA.setVisible(false);
        this._4ParamFieldsRow2TextFieldD.setVisible(false);
        this._3ParamFieldsRow1PS_SFLabelA.setText("Central Meridian:");
        this._3ParamFieldsRow1PS_SFLabelB.setText("Scale Factor:");
        this._4ParamFieldsRow2LabelB.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelC.setText("False Northing (m):");
        try {
            this._3ParamFieldsRow1PS_SFTextFieldA.setText(this.stringHandler.longitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._3ParamFieldsRow1PS_SFTextFieldB.setText("1.00000");
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
        this._4ParamFieldsRow2TextFieldB.setText("0");
        this._4ParamFieldsRow2TextFieldC.setText("0");
        this.row1HemiBoxPanel.setVisible(true);
        this.paramFieldsRow2LayeredPane.moveToFront(this.row1HemiBoxPanel);
        this.row1NHemiRadioButton.setSelected(true);
    }

    private void setPS_SFFourParamsUnedit() {
        this._3ParamFieldsRow1PS_SFTextFieldA.setEditable(false);
        this._3ParamFieldsRow1PS_SFTextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
        this.row1NHemiRadioButton.setEnabled(false);
        this.row1SHemiRadioButton.setEnabled(false);
    }

    private void setFiveParams() {
        this.setFormat();
        this.hideParams();
        this._3ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this.paramFieldsRow1LayeredPane.setMinimumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setMaximumSize(new Dimension(439, 55));
        this.paramFieldsRow1LayeredPane.setPreferredSize(new Dimension(439, 55));
        this._3ParamFieldsRow1Panel.setBounds(2, 2, 439, 37);
        this._3ParamFieldsRow1LabelA.setVisible(true);
        this._3ParamFieldsRow1LabelC.setVisible(true);
        this._3ParamFieldsRow1TextFieldA.setVisible(true);
        this._3ParamFieldsRow1TextFieldC.setVisible(true);
        this._4ParamFieldsRow2LabelA.setVisible(false);
        this._4ParamFieldsRow2LabelD.setVisible(false);
        this._4ParamFieldsRow2TextFieldA.setVisible(false);
        this._4ParamFieldsRow2TextFieldD.setVisible(false);
        this._3ParamFieldsRow1LabelA.setText("Central Meridian:");
        this._3ParamFieldsRow1LabelB.setText("Origin Latitude:");
        this._3ParamFieldsRow1LabelC.setText("Scale Factor:");
        this._4ParamFieldsRow2LabelB.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelC.setText("False Northing (m):");
        try {
            this._3ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
        this._3ParamFieldsRow1TextFieldC.setText("1.00000");
        this._4ParamFieldsRow2TextFieldB.setText("0");
        this._4ParamFieldsRow2TextFieldC.setText("0");
    }

    private void setFiveParamsUnedit() {
        this._3ParamFieldsRow1TextFieldA.setEditable(false);
        this._3ParamFieldsRow1TextFieldB.setEditable(false);
        this._3ParamFieldsRow1TextFieldC.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
    }

    private void setSixParams() {
        this.setFormat();
        this.hideParams();
        this._4ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this._4ParamFieldsRow1LabelA.setVisible(true);
        this._4ParamFieldsRow1LabelD.setVisible(true);
        this._4ParamFieldsRow2LabelA.setVisible(false);
        this._4ParamFieldsRow2LabelD.setVisible(false);
        this._4ParamFieldsRow1TextFieldA.setVisible(true);
        this._4ParamFieldsRow1TextFieldD.setVisible(true);
        this._4ParamFieldsRow2TextFieldA.setVisible(false);
        this._4ParamFieldsRow2TextFieldD.setVisible(false);
        this._4ParamFieldsRow1LabelA.setText("Central Meridian:");
        this._4ParamFieldsRow1LabelB.setText("Origin Latitude:");
        this._4ParamFieldsRow1LabelC.setText("Std. Parallel 1:");
        this._4ParamFieldsRow1LabelD.setText("Std. Parallel 2:");
        this._4ParamFieldsRow2LabelB.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelC.setText("False Northing (m):");
        try {
            this._4ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(0.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(45.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(40.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldD.setText(this.stringHandler.latitudeToString(50.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
        this._4ParamFieldsRow2TextFieldB.setText("0");
        this._4ParamFieldsRow2TextFieldC.setText("0");
    }

    private void setSixParamsUnedit() {
        this._4ParamFieldsRow1TextFieldA.setEditable(false);
        this._4ParamFieldsRow1TextFieldB.setEditable(false);
        this._4ParamFieldsRow1TextFieldC.setEditable(false);
        this._4ParamFieldsRow1TextFieldD.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
    }

    private void setEightParams() {
        this.setFormat();
        this.hideParams();
        this._4ParamFieldsRow1Panel.setVisible(true);
        this._4ParamFieldsRow2Panel.setVisible(true);
        this._4ParamFieldsRow1LabelA.setVisible(true);
        this._4ParamFieldsRow1LabelD.setVisible(true);
        this._4ParamFieldsRow2LabelA.setVisible(true);
        this._4ParamFieldsRow2LabelD.setVisible(true);
        this._4ParamFieldsRow1TextFieldA.setVisible(true);
        this._4ParamFieldsRow1TextFieldD.setVisible(true);
        this._4ParamFieldsRow2TextFieldA.setVisible(true);
        this._4ParamFieldsRow2TextFieldD.setVisible(true);
        this._4ParamFieldsRow1LabelA.setText("Origin Latitude:");
        this._4ParamFieldsRow1LabelB.setText("Scale Factor:");
        this._4ParamFieldsRow1LabelC.setText("Longitude 1:");
        this._4ParamFieldsRow1LabelD.setText("Latitude 1:");
        this._4ParamFieldsRow2LabelA.setText("Longitude 2:");
        this._4ParamFieldsRow2LabelB.setText("Latitude 2:");
        this._4ParamFieldsRow2LabelC.setText("False Easting (m):");
        this._4ParamFieldsRow2LabelD.setText("False Northing (m):");
        try {
            this._4ParamFieldsRow1TextFieldA.setText(this.stringHandler.latitudeToString(45.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldB.setText("1.00000");
            this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.longitudeToString(-5.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow1TextFieldD.setText(this.stringHandler.latitudeToString(40.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow2TextFieldA.setText(this.stringHandler.longitudeToString(5.0, this.useNSEW, this.useMinutes, this.useSeconds));
            this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.latitudeToString(50.0, this.useNSEW, this.useMinutes, this.useSeconds));
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
        this._4ParamFieldsRow2TextFieldC.setText("0");
        this._4ParamFieldsRow2TextFieldD.setText("0");
    }

    private void setEightParamsUnedit() {
        this._4ParamFieldsRow1TextFieldA.setEditable(false);
        this._4ParamFieldsRow1TextFieldB.setEditable(false);
        this._4ParamFieldsRow1TextFieldC.setEditable(false);
        this._4ParamFieldsRow1TextFieldD.setEditable(false);
        this._4ParamFieldsRow2TextFieldA.setEditable(false);
        this._4ParamFieldsRow2TextFieldB.setEditable(false);
        this._4ParamFieldsRow2TextFieldC.setEditable(false);
        this._4ParamFieldsRow2TextFieldD.setEditable(false);
    }

    private void fillHeightList() {
        this.heightComboBox.addItem("No Height");
        this.heightComboBox.addItem("Ellipsoid Height");
        this.heightComboBox.addItem("MSL-EGM2008-2.5M-BCS Height");
        this.heightComboBox.addItem("MSL-EGM96-15M-BL Height");
        this.heightComboBox.addItem("MSL-EGM96-VG-NS Height");
        this.heightComboBox.addItem("MSL-EGM84-10D-BL Height");
        this.heightComboBox.addItem("MSL-EGM84-10D-NS Height");
        this.heightComboBox.addItem("MSL-EGM84-30M-BL Height");
    }

    private void fillProjectionList() {
        this.projectionComboBox.addItem("Geodetic");
        this.projectionComboBox.addItem("GEOREF");
        this.projectionComboBox.addItem("Global Area Reference System (GARS)");
        this.projectionComboBox.addItem("Geocentric");
        this.projectionComboBox.addItem("Local Cartesian");
        this.projectionComboBox.addItem("Military Grid Reference System (MGRS)");
        this.projectionComboBox.addItem("United States National Grid (USNG)");
        this.projectionComboBox.addItem("Universal Transverse Mercator (UTM)");
        this.projectionComboBox.addItem("Universal Polar Stereographic (UPS)");
        this.projectionComboBox.addItem("Albers Equal Area Conic");
        this.projectionComboBox.addItem("Azimuthal Equidistant (S)");
        this.projectionComboBox.addItem("British National Grid");
        this.projectionComboBox.addItem("Bonne");
        this.projectionComboBox.addItem("Cassini");
        this.projectionComboBox.addItem("Cylindrical Equal Area");
        this.projectionComboBox.addItem("Eckert IV (S)");
        this.projectionComboBox.addItem("Eckert VI (S)");
        this.projectionComboBox.addItem("Equidistant Cylindrical (S)");
        this.projectionComboBox.addItem("Gnomonic (S)");
        this.projectionComboBox.addItem("Lambert Conformal Conic (1 Standard Parallel)");
        this.projectionComboBox.addItem("Lambert Conformal Conic (2 Standard Parallel)");
        this.projectionComboBox.addItem("Mercator (Standard Parallel)");
        this.projectionComboBox.addItem("Mercator (Scale Factor)");
        this.projectionComboBox.addItem("Miller Cylindrical (S)");
        this.projectionComboBox.addItem("Mollweide (S)");
        this.projectionComboBox.addItem("Ney's (Modified Lambert Conformal Conic)");
        this.projectionComboBox.addItem("New Zealand Map Grid");
        this.projectionComboBox.addItem("Oblique Mercator");
        this.projectionComboBox.addItem("Orthographic (S)");
        this.projectionComboBox.addItem("Polar Stereographic (Standard Parallel)");
        this.projectionComboBox.addItem("Polar Stereographic (Scale Factor)");
        this.projectionComboBox.addItem("Polyconic");
        this.projectionComboBox.addItem("Sinusoidal");
        this.projectionComboBox.addItem("Stereographic (S)");
        this.projectionComboBox.addItem("Transverse Cylindrical Equal Area");
        this.projectionComboBox.addItem("Transverse Mercator");
        this.projectionComboBox.addItem("Van der Grinten");
        this.projectionComboBox.addItem("Web Mercator (S)");
        if (this.state != 0) {
            this.projectionComboBox.addItem("F-16 Grid Reference System");
        }
        this.projectionComboBox.updateUI();
    }

    private void setFormat() {
        this.useNSEW = this.formatOptions.getUseNSEW();
        this.useMinutes = this.formatOptions.getUseMinutes();
        this.useSeconds = this.formatOptions.getUseSeconds();
    }

    public static void main(String[] stringArray) {
    }

    public void addDatumToList() {
        long l = this.datumIndex;
        this.datumList = new FillList(this.jniDatumLibrary, this.jniEllipsoidLibrary, this.datumComboBox, 0);
        this.datumComboBox.setSelectedIndex((int)l);
    }

    public void updateCurrentDatumIndex(int n) {
        if ((long)n <= this.datumIndex) {
            --this.datumIndex;
        }
    }

    public void deleteDatumFromList() {
        long l = this.datumIndex;
        this.datumList = new FillList(this.jniDatumLibrary, this.jniEllipsoidLibrary, this.datumComboBox, 0);
        this.datumComboBox.setSelectedIndex((int)l);
    }

    public void showErrors(Component component) {
        this.stringHandler.displayErrorMsg(component, this.direction, this.projectionType);
    }

    public boolean getError() {
        return this.stringHandler.getError();
    }

    public void setHeightFieldEditable(boolean bl) {
        this.coordPanel.setHeightFieldEditable(bl);
    }

    public void setHeightText(String string) {
        this.coordPanel.setHeightText(string);
    }

    public void selectNoHeightButton() {
        this.heightType = 0;
        this.heightComboBox.setSelectedIndex(this.heightType);
    }

    public void selectEllipsoidHeightButton() {
        this.heightType = 1;
        this.heightComboBox.setSelectedIndex(this.heightType);
    }

    public void enableHeightComboBox(boolean bl) {
        this.heightComboBox.setEnabled(bl);
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public String getProjectionCode() {
        return CoordinateType.code(this.projectionType);
    }

    public long getDatumIndex() {
        return this.datumIndex;
    }

    public String getDatumCode() {
        try {
            return this.jniDatumLibrary.getDatumInfo(this.datumIndex).getCode();
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.setErrorMessage(true, coordinateConversionException.getMessage());
            return "";
        }
    }

    public boolean getCoordinateOrder() {
        return this.latitudeLongitudeRadioButton.isSelected();
    }

    public void setAccuracy(Accuracy accuracy) {
        boolean bl = true;
        switch (this.projectionType) {
            case 3: 
            case 11: 
            case 12: 
            case 19: 
            case 35: 
            case 38: {
                bl = false;
            }
        }
        this.coordPanel.setAccuracy(accuracy, bl);
    }

    public void resetAccuracy() {
        this.coordPanel.resetOutputErrors();
    }

    public void updateSrcErrors(boolean bl) {
        boolean bl2 = true;
        switch (this.projectionType) {
            case 3: 
            case 11: 
            case 12: 
            case 19: 
            case 35: 
            case 38: {
                bl2 = false;
            }
        }
        this.coordPanel.updateSrcErrors(bl, bl2);
    }

    public void setParent(MSP_GEOTRANS3 mSP_GEOTRANS3) {
        this.parent = mSP_GEOTRANS3;
    }

    public void setLookAndFeel(String string) {
        this.currLookAndFeel = string;
        if (!Platform.isJavaV1_3) {
            switch (this.projectionType) {
                case 33: 
                case 34: {
                    if (Platform.isUnix) {
                        if (this.currLookAndFeel.equals("Java")) {
                            this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                            break;
                        }
                        this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                        break;
                    }
                    if (this.currLookAndFeel.equals("Java")) {
                        this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 1, 12)));
                        break;
                    }
                    this.hemiBoxPanel.setBorder(new TitledBorder(null, "Hemisphere:", 2, 0, new Font("Dialog", 0, 12)));
                    break;
                }
                case 23: {
                    if (Platform.isUnix) {
                        if (this.currLookAndFeel.equals("Java")) {
                            this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 10), Color.black));
                            break;
                        }
                        this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 0, 10), Color.black));
                        break;
                    }
                    if (this.currLookAndFeel.equals("Java")) {
                        this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 1, 12)));
                        break;
                    }
                    this.stdParallel1NeysParamsPanel.setBorder(new TitledBorder(null, "Std. Parallel 1:", 2, 0, new Font("Dialog", 0, 12)));
                }
            }
        }
    }

    public int getGeodeticHeight() {
        return this.heightType;
    }

    public long getZone() {
        if (this.zoneRadioButton.isSelected()) {
            long l = this.stringHandler.stringToInt(this.zoneTextField.getText().trim(), "Invalid zone");
            if (l < 1L || l > 60L) {
                return 0L;
            }
            return l;
        }
        return 0L;
    }

    public long getOverride() {
        return this.override;
    }

    public double get3ParamCentralMeridian() {
        return this.stringHandler.stringToLongitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian") * 57.29577951308232;
    }

    public double getFalseEasting() {
        return this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid False Easting");
    }

    public double getFalseNorthing() {
        return this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Northing");
    }

    public double get4ParamCentralMeridian() {
        return this.stringHandler.stringToLongitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Central Meridian") * 57.29577951308232;
    }

    public double get4ParamOriginLatitude() {
        return this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Latitude") * 57.29577951308232;
    }

    public double getPS_SFCentralMeridian() {
        return this.stringHandler.stringToLongitude(this._3ParamFieldsRow1PS_SFTextFieldA.getText().trim(), "Invalid Central Meridian") * 57.29577951308232;
    }

    public double getPS_SFScaleFactor() {
        return Double.parseDouble(this._3ParamFieldsRow1PS_SFTextFieldB.getText().trim());
    }

    public char getRow1Hemisphere() {
        if (this.row1NHemiRadioButton.isSelected()) {
            return 'N';
        }
        return 'S';
    }

    public double get5ParamCentralMeridian() {
        return this.stringHandler.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian") * 57.29577951308232;
    }

    public double get5ParamOriginLatitude() {
        return this.stringHandler.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude") * 57.29577951308232;
    }

    public double get5ParamScaleFactor() {
        return Double.parseDouble(this._3ParamFieldsRow1TextFieldC.getText().trim());
    }

    public double get6ParamCentralMeridian() {
        return this.stringHandler.stringToLongitude(this._4ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Central Meridian") * 57.29577951308232;
    }

    public double get6ParamOriginLatitude() {
        return this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude") * 57.29577951308232;
    }

    public double get6ParamStandardParallel1() {
        return this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid 1st Standard Parallel") * 57.29577951308232;
    }

    public double get6ParamStandardParallel2() {
        return this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldD.getText().trim(), "Invalid 2nd Standard Parallel") * 57.29577951308232;
    }

    public double getOriginLongitude() {
        return this.stringHandler.stringToLongitude(this._3ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Origin Longitude") * 57.29577951308232;
    }

    public double getOriginLatitude() {
        return this.stringHandler.stringToLatitude(this._3ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Origin Latitude") * 57.29577951308232;
    }

    public double getOriginHeight() {
        return this.stringHandler.stringToDouble(this._3ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Origin Height");
    }

    public double getOrientation() {
        return this.stringHandler.stringToLongitude(this._3ParamFieldsRow2TextFieldB.getText().trim(), "Invalid Orientation") * 57.29577951308232;
    }

    public double getNeysCentralMeridian() {
        return this.stringHandler.stringToLongitude(this.centralMeridianNeysParamsTextField.getText().trim(), "Invalid Central Meridian") * 57.29577951308232;
    }

    public double getNeysOriginLatitude() {
        return this.stringHandler.stringToLatitude(this.originLatitudeNeysParamsTextField.getText().trim(), "Invalid Origin Latitude") * 57.29577951308232;
    }

    public double getNeysStandardParallel1() {
        double d = 71.0;
        if (this.neys74RadioButton.isSelected()) {
            d = 74.0;
        }
        return d;
    }

    public double getOmercOriginLatitude() {
        return this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldA.getText().trim(), "Invalid Origin Latitude") * 57.29577951308232;
    }

    public double getOmercLongitude1() {
        return this.stringHandler.stringToLongitude(this._4ParamFieldsRow1TextFieldC.getText().trim(), "Invalid Longitude 1") * 57.29577951308232;
    }

    public double getOmercLatitude1() {
        return this.stringHandler.stringToLatitude(this._4ParamFieldsRow1TextFieldD.getText().trim(), "Invalid Latitude 1") * 57.29577951308232;
    }

    public double getOmercLongitude2() {
        return this.stringHandler.stringToLongitude(this._4ParamFieldsRow2TextFieldA.getText().trim(), "Invalid Longitude 2") * 57.29577951308232;
    }

    public double getOmercLatitude2() {
        return this.stringHandler.stringToLatitude(this._4ParamFieldsRow2TextFieldB.getText().trim(), "Invalid Latitude 2") * 57.29577951308232;
    }

    public double getOmercFalseEasting() {
        return this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldC.getText().trim(), "Invalid False Easting");
    }

    public double getOmercFalseNorthing() {
        return this.stringHandler.stringToDouble(this._4ParamFieldsRow2TextFieldD.getText().trim(), "Invalid False Northing");
    }

    public double getOmercScaleFactor() {
        return this.stringHandler.stringToDouble(this._4ParamFieldsRow1TextFieldB.getText().trim(), "Invalid Scale Factor");
    }

    public void setDefaults(int n, JNICoordinateConversionService jNICoordinateConversionService, FormatOptions formatOptions, StringHandler stringHandler) {
        try {
            this.jniCoordinateConversionService = jNICoordinateConversionService;
            this.jniDatumLibrary = new JNIDatumLibrary(this.jniCoordinateConversionService.getDatumLibrary());
            this.jniEllipsoidLibrary = new JNIEllipsoidLibrary(this.jniCoordinateConversionService.getEllipsoidLibrary());
            this.formatOptions = formatOptions;
            this.stringHandler = stringHandler;
            this.coordPanel.setDefaults(formatOptions, this.stringHandler);
            this.datumIndex = this.jniDatumLibrary.getDatumIndex(this.jniCoordinateConversionService.getDatum(n));
            CoordinateSystemParameters coordinateSystemParameters = this.jniCoordinateConversionService.getCoordinateSystem(n);
            this.projectionType = coordinateSystemParameters.getCoordinateType();
            this.datumComboBox.setSelectedIndex((int)this.datumIndex);
            this.projectionComboBox.setSelectedItem(CoordinateType.name(this.projectionType));
            this.createMasterPanel();
            switch (this.projectionType) {
                case 6: 
                case 7: 
                case 20: 
                case 21: 
                case 29: 
                case 36: {
                    MapProjection3Parameters mapProjection3Parameters = (MapProjection3Parameters)coordinateSystemParameters;
                    this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(mapProjection3Parameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mapProjection3Parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mapProjection3Parameters.getFalseNorthing()));
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 13: 
                case 25: 
                case 28: 
                case 30: {
                    MapProjection4Parameters mapProjection4Parameters = (MapProjection4Parameters)coordinateSystemParameters;
                    this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(mapProjection4Parameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(mapProjection4Parameters.getOriginLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mapProjection4Parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mapProjection4Parameters.getFalseNorthing()));
                    break;
                }
                case 8: {
                    EquidistantCylindricalParameters equidistantCylindricalParameters = (EquidistantCylindricalParameters)coordinateSystemParameters;
                    this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(equidistantCylindricalParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(equidistantCylindricalParameters.getStandardParallel() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(equidistantCylindricalParameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(equidistantCylindricalParameters.getFalseNorthing()));
                    break;
                }
                case 14: 
                case 31: 
                case 32: {
                    MapProjection5Parameters mapProjection5Parameters = (MapProjection5Parameters)coordinateSystemParameters;
                    this._3ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(mapProjection5Parameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(mapProjection5Parameters.getOriginLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.stringHandler.setNumberFormat(this._3ParamFieldsRow1TextFieldC, mapProjection5Parameters.getScaleFactor(), 5);
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mapProjection5Parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mapProjection5Parameters.getFalseNorthing()));
                    break;
                }
                case 17: {
                    MercatorStandardParallelParameters mercatorStandardParallelParameters = (MercatorStandardParallelParameters)coordinateSystemParameters;
                    this._3ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(mercatorStandardParallelParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(mercatorStandardParallelParameters.getStandardParallel() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.stringHandler.setNumberFormat(this._3ParamFieldsRow1TextFieldC, mercatorStandardParallelParameters.getScaleFactor(), 5);
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mercatorStandardParallelParameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mercatorStandardParallelParameters.getFalseNorthing()));
                    break;
                }
                case 18: {
                    MercatorScaleFactorParameters mercatorScaleFactorParameters = (MercatorScaleFactorParameters)coordinateSystemParameters;
                    this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(mercatorScaleFactorParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.stringHandler.setNumberFormat(this._4ParamFieldsRow1TextFieldC, mercatorScaleFactorParameters.getScaleFactor(), 5);
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mercatorScaleFactorParameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mercatorScaleFactorParameters.getFalseNorthing()));
                    break;
                }
                case 0: 
                case 15: {
                    MapProjection6Parameters mapProjection6Parameters = (MapProjection6Parameters)coordinateSystemParameters;
                    this._4ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(mapProjection6Parameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(mapProjection6Parameters.getOriginLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(mapProjection6Parameters.getStandardParallel1() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldD.setText(this.stringHandler.latitudeToString(mapProjection6Parameters.getStandardParallel2() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(mapProjection6Parameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(mapProjection6Parameters.getFalseNorthing()));
                    break;
                }
                case 16: {
                    LocalCartesianParameters localCartesianParameters = (LocalCartesianParameters)coordinateSystemParameters;
                    this._3ParamFieldsRow1TextFieldA.setText(this.stringHandler.longitudeToString(localCartesianParameters.getLongitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldB.setText(this.stringHandler.latitudeToString(localCartesianParameters.getLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._3ParamFieldsRow1TextFieldC.setText(this.stringHandler.meterToString(localCartesianParameters.getHeight()));
                    this._3ParamFieldsRow2TextFieldB.setText(this.stringHandler.longitudeToString(localCartesianParameters.getOrientation() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    break;
                }
                case 23: {
                    NeysParameters neysParameters = (NeysParameters)coordinateSystemParameters;
                    boolean bl = true;
                    double d = neysParameters.getOriginLatitude() * 57.29577951308232;
                    if (d < 0.0) {
                        bl = false;
                    }
                    this.centralMeridianNeysParamsTextField.setText(this.stringHandler.longitudeToString(neysParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.originLatitudeNeysParamsTextField.setText(this.stringHandler.latitudeToString(d, this.useNSEW, this.useMinutes, this.useSeconds));
                    double d2 = neysParameters.getStandardParallel1() * 57.29577951308232;
                    if (d2 == 71.0) {
                        this.neys71RadioButton.setSelected(true);
                        this.neys74RadioButton.setSelected(false);
                    } else {
                        this.neys71RadioButton.setSelected(false);
                        this.neys74RadioButton.setSelected(true);
                    }
                    this.stdParallel2NeysParamsTextField.setText(this.stringHandler.latitudeToString(89.99944444444444, false, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(neysParameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(neysParameters.getFalseNorthing()));
                    break;
                }
                case 24: {
                    ObliqueMercatorParameters obliqueMercatorParameters = (ObliqueMercatorParameters)coordinateSystemParameters;
                    this._4ParamFieldsRow1TextFieldA.setText(this.stringHandler.latitudeToString(obliqueMercatorParameters.getOriginLatitude() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.stringHandler.setNumberFormat(this._4ParamFieldsRow1TextFieldB, obliqueMercatorParameters.getScaleFactor(), 5);
                    this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.longitudeToString(obliqueMercatorParameters.getLongitude1() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldD.setText(this.stringHandler.latitudeToString(obliqueMercatorParameters.getLatitude1() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldA.setText(this.stringHandler.longitudeToString(obliqueMercatorParameters.getLongitude2() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.latitudeToString(obliqueMercatorParameters.getLatitude2() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(obliqueMercatorParameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldD.setText(this.stringHandler.meterToString(obliqueMercatorParameters.getFalseNorthing()));
                    break;
                }
                case 26: {
                    PolarStereographicStandardParallelParameters polarStereographicStandardParallelParameters = (PolarStereographicStandardParallelParameters)coordinateSystemParameters;
                    this._4ParamFieldsRow1TextFieldB.setText(this.stringHandler.longitudeToString(polarStereographicStandardParallelParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow1TextFieldC.setText(this.stringHandler.latitudeToString(polarStereographicStandardParallelParameters.getStandardParallel() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(polarStereographicStandardParallelParameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(polarStereographicStandardParallelParameters.getFalseNorthing()));
                    break;
                }
                case 27: {
                    PolarStereographicScaleFactorParameters polarStereographicScaleFactorParameters = (PolarStereographicScaleFactorParameters)coordinateSystemParameters;
                    this._3ParamFieldsRow1PS_SFTextFieldA.setText(this.stringHandler.longitudeToString(polarStereographicScaleFactorParameters.getCentralMeridian() * 57.29577951308232, this.useNSEW, this.useMinutes, this.useSeconds));
                    this.stringHandler.setNumberFormat(this._3ParamFieldsRow1PS_SFTextFieldB, polarStereographicScaleFactorParameters.getScaleFactor(), 5);
                    if (polarStereographicScaleFactorParameters.getHemisphere() == 'N') {
                        this.row1NHemiRadioButton.setSelected(true);
                        this.row1SHemiRadioButton.setSelected(false);
                    } else {
                        this.row1NHemiRadioButton.setSelected(false);
                        this.row1SHemiRadioButton.setSelected(true);
                    }
                    this._4ParamFieldsRow2TextFieldB.setText(this.stringHandler.meterToString(polarStereographicScaleFactorParameters.getFalseEasting()));
                    this._4ParamFieldsRow2TextFieldC.setText(this.stringHandler.meterToString(polarStereographicScaleFactorParameters.getFalseNorthing()));
                    break;
                }
                case 10: {
                    GeodeticParameters geodeticParameters = (GeodeticParameters)coordinateSystemParameters;
                    this.heightComboBox.setSelectedIndex(geodeticParameters.getHeightType());
                    break;
                }
                case 34: {
                    UTMParameters uTMParameters = (UTMParameters)coordinateSystemParameters;
                    if (uTMParameters.getOverride() != 0L) {
                        this.zoneRadioButton.setSelected(true);
                    } else {
                        this.zoneRadioButton.setSelected(false);
                    }
                    this.zoneTextField.setText(String.valueOf(uTMParameters.getZone()));
                    break;
                }
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }
}

