
/*
 * Header file for BBCized version of Doug Lea's malloc.c, automatically
 * generated by
 *  /source/prod/libbbc/compat/dlmalloc/cvt
 * from
 *  /source/prod/libbbc/compat/dlmalloc/malloc.c
 *
 * bbclabel: autogenerated
 */
#define _INCLUDE_MALLOC_H_ 1
void malloc_outofmem(void (*)(void));


struct mallinfo {
  int arena;    /* total space allocated from system */
  int ordblks;  /* number of non-inuse chunks */
  int smblks;   /* unused -- always zero */
  int hblks;    /* number of mmapped regions */
  int hblkhd;   /* total space in mmapped regions */
  int usmblks;  /* unused -- always zero */
  int fsmblks;  /* unused -- always zero */
  int uordblks; /* total allocated space */
  int fordblks; /* total non-inuse space */
  int keepcost; /* top-most, releasable (via malloc_trim) space */
};


#define M_MXFAST  1    /* UNUSED in this malloc */
#define M_NLBLKS  2    /* UNUSED in this malloc */
#define M_GRAIN   3    /* UNUSED in this malloc */
#define M_KEEP    4    /* UNUSED in this malloc */


#define M_TRIM_THRESHOLD    -1
#define M_TOP_PAD           -2
#define M_MMAP_THRESHOLD    -3
#define M_MMAP_MAX          -4
#define M_SCANHEAP	    -5
#define M_FILL

#ifdef MALLOC_DEBUG

#define dlmalloc(size)		malloc_dbg(size, __FILE__, __LINE__)
#define dlfree(p)			free_dbg(p, __FILE__, __LINE__)
#define dlrealloc(p, size)	realloc_dbg(p, size, __FILE__, __LINE__)
#define dlcalloc(n, size)		calloc_dbg(n, size, __FILE__, __LINE__)
#define dlmemalign(align, size)	memalign_dbg(align, size, __FILE__, __LINE__)
#define dlvalloc(size)		valloc_dbg(size, __FILE__, __LINE__)
#define dlpvalloc(size)		pvalloc_dbg(size, __FILE__, __LINE__)
#define dlmalloc_trim(pad)	malloc_trim_dbg(pad, __FILE__, __LINE__)
#define dlmalloc_usable_size(p)	malloc_usable_size_dbg(p, __FILE__, __LINE__)
#define dlmalloc_stats()		malloc_stats_dbg(__FILE__, __LINE__)
#define dlmallopt(flag, val)	mallopt_dbg(flag, val, __FILE__, __LINE__)
#define dlmallinfo()		mallinfo_dbg(__FILE__, __LINE__)


#ifdef __cplusplus
extern "C" {
#endif
void* malloc_dbg(size_t, const char *, int);
void    free_dbg(void*, const char *, int);
void* realloc_dbg(void*, size_t, const char *, int);
void* calloc_dbg(size_t, size_t, const char *, int);
void* memalign_dbg(size_t, size_t, const char *, int);
void* valloc_dbg(size_t, const char *, int);
void* pvalloc_dbg(size_t, const char *, int);
int     malloc_trim_dbg(size_t, const char *, int);
size_t  malloc_usable_size_dbg(void*, const char *, int);
void    malloc_stats_dbg(const char *, int);
int     mallopt_dbg(int, int, const char *, int);
struct mallinfo mallinfo_dbg(const char *, int);
#ifdef __cplusplus
}
#endif

#endif /* MALLOC_DEBUG */

#ifndef MALLOC_DEBUG

void* malloc(size_t);
void    free(void*);
void* realloc(void*, size_t);
void* calloc(size_t, size_t);
void* memalign(size_t, size_t);
void* valloc(size_t);
void* pvalloc(size_t);
int     malloc_trim(size_t);
size_t  malloc_usable_size(void*);
void    malloc_stats(void);
int     mallopt(int, int);
struct mallinfo mallinfo(void);
#endif /* !MALLOC_DEBUG */
