# Authors:
#   Tomas Babej <tbabej@redhat.com>
#
# Copyright (C) 2014  Red Hat
# see file 'COPYING' for use and warranty information
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

'''
This base platform module exports default filesystem paths.
'''


class BasePathNamespace(object):
    BASH = "/bin/bash"
    BIN_FALSE = "/bin/false"
    BIN_HOSTNAME = "/bin/hostname"
    LS = "/bin/ls"
    SH = "/bin/sh"
    SYSTEMCTL = "/bin/systemctl"
    TAR = "/bin/tar"
    BIN_TRUE = "/bin/true"
    DEV_NULL = "/dev/null"
    DEV_STDIN = "/dev/stdin"
    AUTOFS_LDAP_AUTH_CONF = "/etc/autofs_ldap_auth.conf"
    ETC_DIRSRV = "/etc/dirsrv"
    DS_KEYTAB = "/etc/dirsrv/ds.keytab"
    ETC_DIRSRV_SLAPD_INSTANCE_TEMPLATE = "/etc/dirsrv/slapd-%s"
    ETC_FEDORA_RELEASE = "/etc/fedora-release"
    GROUP = "/etc/group"
    ETC_HOSTNAME = "/etc/hostname"
    HOSTS = "/etc/hosts"
    ETC_HTTPD_DIR = "/etc/httpd"
    HTTPD_ALIAS_DIR = "/etc/httpd/alias"
    ALIAS_CACERT_ASC = "/etc/httpd/alias/cacert.asc"
    ALIAS_PWDFILE_TXT = "/etc/httpd/alias/pwdfile.txt"
    HTTPD_CONF_D_DIR = "/etc/httpd/conf.d/"
    HTTPD_IPA_KDCPROXY_CONF = "/etc/ipa/kdcproxy/ipa-kdc-proxy.conf"
    HTTPD_IPA_KDCPROXY_CONF_SYMLINK = "/etc/httpd/conf.d/ipa-kdc-proxy.conf"
    HTTPD_IPA_PKI_PROXY_CONF = "/etc/httpd/conf.d/ipa-pki-proxy.conf"
    HTTPD_IPA_REWRITE_CONF = "/etc/httpd/conf.d/ipa-rewrite.conf"
    HTTPD_IPA_CONF = "/etc/httpd/conf.d/ipa.conf"
    HTTPD_NSS_CONF = "/etc/httpd/conf.d/nss.conf"
    HTTPD_SSL_CONF = "/etc/httpd/conf.d/ssl.conf"
    IPA_KEYTAB = "/etc/httpd/conf/ipa.keytab"
    HTTPD_PASSWORD_CONF = "/etc/httpd/conf/password.conf"
    IDMAPD_CONF = "/etc/idmapd.conf"
    ETC_IPA = "/etc/ipa"
    CONNCHECK_CCACHE = "/etc/ipa/.conncheck_ccache"
    IPA_DNS_CCACHE = "/etc/ipa/.dns_ccache"
    IPA_DNS_UPDATE_TXT = "/etc/ipa/.dns_update.txt"
    IPA_CA_CRT = "/etc/ipa/ca.crt"
    IPA_DEFAULT_CONF = "/etc/ipa/default.conf"
    IPA_DNSKEYSYNCD_KEYTAB = "/etc/ipa/dnssec/ipa-dnskeysyncd.keytab"
    IPA_ODS_EXPORTER_KEYTAB = "/etc/ipa/dnssec/ipa-ods-exporter.keytab"
    DNSSEC_SOFTHSM2_CONF = "/etc/ipa/dnssec/softhsm2.conf"
    DNSSEC_SOFTHSM_PIN_SO = "/etc/ipa/dnssec/softhsm_pin_so"
    IPA_NSSDB_DIR = "/etc/ipa/nssdb"
    IPA_NSSDB_PWDFILE_TXT = "/etc/ipa/nssdb/pwdfile.txt"
    KRB5_CONF = "/etc/krb5.conf"
    KRB5_KEYTAB = "/etc/krb5.keytab"
    LDAP_CONF = "/etc/ldap.conf"
    LIBNSS_LDAP_CONF = "/etc/libnss-ldap.conf"
    NAMED_CONF = "/etc/named.conf"
    NAMED_VAR_DIR = "/var/named"
    NAMED_KEYTAB = "/etc/named.keytab"
    NAMED_RFC1912_ZONES = "/etc/named.rfc1912.zones"
    NAMED_ROOT_KEY = "/etc/named.root.key"
    NAMED_BINDKEYS_FILE = "/etc/named.iscdlv.key"
    NAMED_MANAGED_KEYS_DIR = "/var/named/dynamic"
    NSLCD_CONF = "/etc/nslcd.conf"
    NSS_LDAP_CONF = "/etc/nss_ldap.conf"
    NSSWITCH_CONF = "/etc/nsswitch.conf"
    NTP_CONF = "/etc/ntp.conf"
    NTP_STEP_TICKERS = "/etc/ntp/step-tickers"
    ETC_OPENDNSSEC_DIR = "/etc/opendnssec"
    OPENDNSSEC_CONF_FILE = "/etc/opendnssec/conf.xml"
    OPENDNSSEC_KASP_FILE = "/etc/opendnssec/kasp.xml"
    OPENDNSSEC_ZONELIST_FILE = "/etc/opendnssec/zonelist.xml"
    OPENLDAP_LDAP_CONF = "/etc/openldap/ldap.conf"
    PAM_LDAP_CONF = "/etc/pam_ldap.conf"
    PASSWD = "/etc/passwd"
    SYSTEMWIDE_IPA_CA_CRT = "/etc/pki/ca-trust/source/anchors/ipa-ca.crt"
    IPA_P11_KIT = "/etc/pki/ca-trust/source/ipa.p11-kit"
    NSS_DB_DIR = "/etc/pki/nssdb"
    PKI_TOMCAT = "/etc/pki/pki-tomcat"
    PKI_TOMCAT_ALIAS_DIR = "/etc/pki/pki-tomcat/alias"
    PKI_TOMCAT_PASSWORD_CONF = "/etc/pki/pki-tomcat/password.conf"
    ETC_REDHAT_RELEASE = "/etc/redhat-release"
    RESOLV_CONF = "/etc/resolv.conf"
    SAMBA_KEYTAB = "/etc/samba/samba.keytab"
    SMB_CONF = "/etc/samba/smb.conf"
    LIMITS_CONF = "/etc/security/limits.conf"
    SSH_CONFIG = "/etc/ssh/ssh_config"
    SSHD_CONFIG = "/etc/ssh/sshd_config"
    SSSD_CONF = "/etc/sssd/sssd.conf"
    SSSD_CONF_BKP = "/etc/sssd/sssd.conf.bkp"
    SSSD_CONF_DELETED = "/etc/sssd/sssd.conf.deleted"
    ETC_SYSCONFIG_DIR = "/etc/sysconfig"
    ETC_SYSCONFIG_AUTHCONFIG = "/etc/sysconfig/authconfig"
    SYSCONFIG_AUTOFS = "/etc/sysconfig/autofs"
    SYSCONFIG_DIRSRV = "/etc/sysconfig/dirsrv"
    SYSCONFIG_DIRSRV_INSTANCE = "/etc/sysconfig/dirsrv-%s"
    SYSCONFIG_DIRSRV_SYSTEMD = "/etc/sysconfig/dirsrv.systemd"
    SYSCONFIG_IPA_DNSKEYSYNCD = "/etc/sysconfig/ipa-dnskeysyncd"
    SYSCONFIG_IPA_ODS_EXPORTER = "/etc/sysconfig/ipa-ods-exporter"
    SYSCONFIG_HTTPD = "/etc/sysconfig/httpd"
    SYSCONFIG_KRB5KDC_DIR = "/etc/sysconfig/krb5kdc"
    SYSCONFIG_NAMED = "/etc/sysconfig/named"
    SYSCONFIG_NETWORK = "/etc/sysconfig/network"
    SYSCONFIG_NETWORK_IPABKP = "/etc/sysconfig/network.ipabkp"
    SYSCONFIG_NFS = "/etc/sysconfig/nfs"
    SYSCONFIG_NTPD = "/etc/sysconfig/ntpd"
    SYSCONFIG_ODS = "/etc/sysconfig/ods"
    SYSCONFIG_PKI = "/etc/sysconfig/pki"
    SYSCONFIG_PKI_TOMCAT = "/etc/sysconfig/pki-tomcat"
    SYSCONFIG_PKI_TOMCAT_PKI_TOMCAT_DIR = "/etc/sysconfig/pki/tomcat/pki-tomcat"
    ETC_SYSTEMD_SYSTEM_DIR = "/etc/systemd/system/"
    SYSTEMD_CERTMONGER_SERVICE = "/etc/systemd/system/multi-user.target.wants/certmonger.service"
    SYSTEMD_IPA_SERVICE = "/etc/systemd/system/multi-user.target.wants/ipa.service"
    SYSTEMD_SSSD_SERVICE = "/etc/systemd/system/multi-user.target.wants/sssd.service"
    SYSTEMD_PKI_TOMCAT_SERVICE = "/etc/systemd/system/pki-tomcatd.target.wants/pki-tomcatd@pki-tomcat.service"
    DNSSEC_TRUSTED_KEY = "/etc/trusted-key.key"
    HOME_DIR = "/home"
    ROOT_IPA_CACHE = "/root/.ipa_cache"
    ROOT_PKI = "/root/.pki"
    DOGTAG_ADMIN_P12 = "/root/ca-agent.p12"
    KRA_AGENT_PEM = "/etc/httpd/alias/kra-agent.pem"
    CACERT_P12 = "/root/cacert.p12"
    ROOT_IPA_CSR = "/root/ipa.csr"
    NAMED_PID = "/run/named/named.pid"
    IP = "/sbin/ip"
    NOLOGIN = "/sbin/nologin"
    SBIN_REBOOT = "/sbin/reboot"
    SBIN_RESTORECON = "/sbin/restorecon"
    SBIN_SERVICE = "/sbin/service"
    TMP = "/tmp"
    TMP_CA_P12 = "/tmp/ca.p12"
    TMP_KRB5CC = "/tmp/krb5cc_%d"
    USR_DIR = "/usr"
    CERTMONGER_COMMAND_TEMPLATE = "/usr/libexec/ipa/certmonger/%s"
    PKCS12EXPORT = "/usr/bin/PKCS12Export"
    CERTUTIL = "/usr/bin/certutil"
    CHROMIUM_BROWSER = "/usr/bin/chromium-browser"
    DS_NEWINST_PL = "/usr/bin/ds_newinst.pl"
    FIREFOX = "/usr/bin/firefox"
    GETCERT = "/usr/bin/getcert"
    GPG = "/usr/bin/gpg"
    GPG_AGENT = "/usr/bin/gpg-agent"
    IPA_GETCERT = "/usr/bin/ipa-getcert"
    KDESTROY = "/usr/bin/kdestroy"
    KINIT = "/usr/bin/kinit"
    BIN_KVNO = "/usr/bin/kvno"
    LDAPMODIFY = "/usr/bin/ldapmodify"
    LDAPPASSWD = "/usr/bin/ldappasswd"
    NET = "/usr/bin/net"
    BIN_NISDOMAINNAME = "/usr/bin/nisdomainname"
    NSUPDATE = "/usr/bin/nsupdate"
    ODS_KSMUTIL = "/usr/bin/ods-ksmutil"
    ODS_SIGNER = "/usr/sbin/ods-signer"
    OPENSSL = "/usr/bin/openssl"
    PK12UTIL = "/usr/bin/pk12util"
    SETPASSWD = "/usr/bin/setpasswd"
    SIGNTOOL = "/usr/bin/signtool"
    SOFTHSM2_UTIL = "/usr/bin/softhsm2-util"
    SSLGET = "/usr/bin/sslget"
    SSS_SSH_AUTHORIZEDKEYS = "/usr/bin/sss_ssh_authorizedkeys"
    SSS_SSH_KNOWNHOSTSPROXY = "/usr/bin/sss_ssh_knownhostsproxy"
    BIN_TIMEOUT = "/usr/bin/timeout"
    UPDATE_CA_TRUST = "/usr/bin/update-ca-trust"
    BIN_CURL = "/usr/bin/curl"
    ZIP = "/usr/bin/zip"
    BIND_LDAP_SO = "/usr/lib/bind/ldap.so"
    BIND_LDAP_DNS_IPA_WORKDIR = "/var/named/dyndb-ldap/ipa/"
    BIND_LDAP_DNS_ZONE_WORKDIR = "/var/named/dyndb-ldap/ipa/master/"
    USR_LIB_DIRSRV = "/usr/lib/dirsrv"
    LIB_FIREFOX = "/usr/lib/firefox"
    LIBSOFTHSM2_SO = "/usr/lib/pkcs11/libsofthsm2.so"
    LIB_SYSTEMD_SYSTEMD_DIR = "/usr/lib/systemd/system/"
    BIND_LDAP_SO_64 = "/usr/lib64/bind/ldap.so"
    USR_LIB_DIRSRV_64 = "/usr/lib64/dirsrv"
    LIB64_FIREFOX = "/usr/lib64/firefox"
    LIBSOFTHSM2_SO_64 = "/usr/lib64/pkcs11/libsofthsm2.so"
    DOGTAG_IPA_CA_RENEW_AGENT_SUBMIT = "/usr/libexec/certmonger/dogtag-ipa-ca-renew-agent-submit"
    DOGTAG_IPA_RENEW_AGENT_SUBMIT = "/usr/libexec/certmonger/dogtag-ipa-renew-agent-submit"
    IPA_SERVER_GUARD = "/usr/libexec/certmonger/ipa-server-guard"
    GENERATE_RNDC_KEY = "/usr/libexec/generate-rndc-key.sh"
    IPA_DNSKEYSYNCD_REPLICA = "/usr/libexec/ipa/ipa-dnskeysync-replica"
    IPA_DNSKEYSYNCD = "/usr/libexec/ipa/ipa-dnskeysyncd"
    IPA_ODS_EXPORTER = "/usr/libexec/ipa/ipa-ods-exporter"
    DNSSEC_KEYFROMLABEL = "/usr/sbin/dnssec-keyfromlabel-pkcs11"
    GETSEBOOL = "/usr/sbin/getsebool"
    GROUPADD = "/usr/sbin/groupadd"
    HTTPD = "/usr/sbin/httpd"
    IPA_CLIENT_INSTALL = "/usr/sbin/ipa-client-install"
    IPA_DNS_INSTALL = "/usr/sbin/ipa-dns-install"
    SBIN_IPA_JOIN = "/usr/sbin/ipa-join"
    IPA_REPLICA_CONNCHECK = "/usr/sbin/ipa-replica-conncheck"
    IPA_RMKEYTAB = "/usr/sbin/ipa-rmkeytab"
    IPACTL = "/usr/sbin/ipactl"
    NAMED = "/usr/sbin/named"
    NAMED_PKCS11 = "/usr/sbin/named-pkcs11"
    NTPD = "/usr/sbin/ntpd"
    PKIDESTROY = "/usr/sbin/pkidestroy"
    PKISPAWN = "/usr/sbin/pkispawn"
    REMOVE_DS_PL = "/usr/sbin/remove-ds.pl"
    RESTORECON = "/usr/sbin/restorecon"
    SELINUXENABLED = "/usr/sbin/selinuxenabled"
    SETSEBOOL = "/usr/sbin/setsebool"
    SETUP_DS_PL = "/usr/sbin/setup-ds.pl"
    SMBD = "/usr/sbin/smbd"
    USERADD = "/usr/sbin/useradd"
    USR_SHARE_IPA_DIR = "/usr/share/ipa/"
    CA_TOPOLOGY_ULDIF = "/usr/share/ipa/ca-topology.uldif"
    FFEXTENSION = "/usr/share/ipa/ffextension"
    IPA_HTML_DIR = "/usr/share/ipa/html"
    CA_CRT = "/usr/share/ipa/html/ca.crt"
    KERBEROSAUTH_XPI = "/usr/share/ipa/html/kerberosauth.xpi"
    KRB_CON = "/usr/share/ipa/html/krb.con"
    KRB_JS = "/usr/share/ipa/html/krb.js"
    HTML_KRB5_INI = "/usr/share/ipa/html/krb5.ini"
    HTML_KRBREALM_CON = "/usr/share/ipa/html/krbrealm.con"
    NIS_ULDIF = "/usr/share/ipa/nis.uldif"
    NIS_UPDATE_ULDIF = "/usr/share/ipa/nis-update.uldif"
    IPA_PLUGINS = "/usr/share/ipa/plugins"
    SCHEMA_COMPAT_ULDIF = "/usr/share/ipa/schema_compat.uldif"
    IPA_JS_PLUGINS_DIR = "/usr/share/ipa/ui/js/plugins"
    UPDATES_DIR = "/usr/share/ipa/updates/"
    DICT_WORDS = "/usr/share/dict/words"
    CACHE_IPA_SESSIONS = "/var/cache/ipa/sessions"
    VAR_KERBEROS_KRB5KDC_DIR = "/var/kerberos/krb5kdc/"
    VAR_KRB5KDC_K5_REALM = "/var/kerberos/krb5kdc/.k5."
    CACERT_PEM = "/var/kerberos/krb5kdc/cacert.pem"
    KRB5KDC_KADM5_ACL = "/var/kerberos/krb5kdc/kadm5.acl"
    KRB5KDC_KADM5_KEYTAB = "/var/kerberos/krb5kdc/kadm5.keytab"
    KRB5KDC_KDC_CONF = "/var/kerberos/krb5kdc/kdc.conf"
    KDC_PEM = "/var/kerberos/krb5kdc/kdc.pem"
    VAR_LIB = "/var/lib"
    AUTHCONFIG_LAST = "/var/lib/authconfig/last"
    VAR_LIB_CERTMONGER_DIR = "/var/lib/certmonger"
    CERTMONGER_CAS_DIR = "/var/lib/certmonger/cas/"
    CERTMONGER_CAS_CA_RENEWAL = "/var/lib/certmonger/cas/ca_renewal"
    CERTMONGER_REQUESTS_DIR = "/var/lib/certmonger/requests/"
    VAR_LIB_DIRSRV = "/var/lib/dirsrv"
    DIRSRV_BOOT_LDIF = "/var/lib/dirsrv/boot.ldif"
    VAR_LIB_DIRSRV_INSTANCE_SCRIPTS_TEMPLATE = "/var/lib/dirsrv/scripts-%s"
    VAR_LIB_SLAPD_INSTANCE_DIR_TEMPLATE = "/var/lib/dirsrv/slapd-%s"
    SLAPD_INSTANCE_BACKUP_DIR_TEMPLATE = "/var/lib/dirsrv/slapd-%s/bak/%s"
    SLAPD_INSTANCE_DB_DIR_TEMPLATE = "/var/lib/dirsrv/slapd-%s/db/%s"
    SLAPD_INSTANCE_LDIF_DIR_TEMPLATE = "/var/lib/dirsrv/slapd-%s/ldif"
    VAR_LIB_IPA = "/var/lib/ipa"
    IPA_CLIENT_SYSRESTORE = "/var/lib/ipa-client/sysrestore"
    SYSRESTORE_INDEX = "/var/lib/ipa-client/sysrestore/sysrestore.index"
    IPA_BACKUP_DIR = "/var/lib/ipa/backup"
    IPA_DNSSEC_DIR = "/var/lib/ipa/dnssec"
    IPA_KASP_DB_BACKUP = "/var/lib/ipa/ipa-kasp.db.backup"
    DNSSEC_TOKENS_DIR = "/var/lib/ipa/dnssec/tokens"
    DNSSEC_SOFTHSM_PIN = "/var/lib/ipa/dnssec/softhsm_pin"
    IPA_CA_CSR = "/var/lib/ipa/ca.csr"
    PKI_CA_PUBLISH_DIR = "/var/lib/ipa/pki-ca/publish"
    REPLICA_INFO_TEMPLATE = "/var/lib/ipa/replica-info-%s"
    REPLICA_INFO_GPG_TEMPLATE = "/var/lib/ipa/replica-info-%s.gpg"
    SYSRESTORE = "/var/lib/ipa/sysrestore"
    STATEFILE_DIR = "/var/lib/ipa/sysupgrade"
    VAR_LIB_KDCPROXY = "/var/lib/kdcproxy"
    VAR_LIB_PKI_DIR = "/var/lib/pki"
    VAR_LIB_PKI_CA_ALIAS_DIR = "/var/lib/pki-ca/alias"
    VAR_LIB_PKI_TOMCAT_DIR = "/var/lib/pki/pki-tomcat"
    CA_BACKUP_KEYS_P12 = "/var/lib/pki/pki-tomcat/alias/ca_backup_keys.p12"
    KRA_BACKUP_KEYS_P12 = "/var/lib/pki/pki-tomcat/alias/kra_backup_keys.p12"
    CA_CS_CFG_PATH = "/var/lib/pki/pki-tomcat/conf/ca/CS.cfg"
    CAJARSIGNINGCERT_CFG = (
        "/var/lib/pki/pki-tomcat/ca/profiles/ca/caJarSigningCert.cfg")
    CASIGNEDLOGCERT_CFG = (
        "/var/lib/pki/pki-tomcat/ca/profiles/ca/caSignedLogCert.cfg")
    KRA_CS_CFG_PATH = "/var/lib/pki/pki-tomcat/conf/kra/CS.cfg"
    KRACERT_P12 = "/root/kracert.p12"
    SAMBA_DIR = "/var/lib/samba/"
    SSSD_DB = "/var/lib/sss/db"
    SSSD_MC_GROUP = "/var/lib/sss/mc/group"
    SSSD_MC_PASSWD = "/var/lib/sss/mc/passwd"
    SSSD_PUBCONF_KNOWN_HOSTS = "/var/lib/sss/pubconf/known_hosts"
    SSSD_PUBCONF_KRB5_INCLUDE_D_DIR = "/var/lib/sss/pubconf/krb5.include.d/"
    DIRSRV_LOCK_DIR = "/var/lock/dirsrv"
    VAR_LOG_DIRSRV_INSTANCE_TEMPLATE = "/var/log/dirsrv/slapd-%s"
    SLAPD_INSTANCE_ACCESS_LOG_TEMPLATE = "/var/log/dirsrv/slapd-%s/access"
    SLAPD_INSTANCE_ERROR_LOG_TEMPLATE = "/var/log/dirsrv/slapd-%s/errors"
    VAR_LOG_HTTPD_DIR = "/var/log/httpd"
    IPABACKUP_LOG = "/var/log/ipabackup.log"
    IPACLIENT_INSTALL_LOG = "/var/log/ipaclient-install.log"
    IPACLIENT_UNINSTALL_LOG = "/var/log/ipaclient-uninstall.log"
    IPAREPLICA_CA_INSTALL_LOG = "/var/log/ipareplica-ca-install.log"
    IPAREPLICA_CONNCHECK_LOG = "/var/log/ipareplica-conncheck.log"
    IPAREPLICA_INSTALL_LOG = "/var/log/ipareplica-install.log"
    IPARESTORE_LOG = "/var/log/iparestore.log"
    IPASERVER_CA_INSTALL_LOG = "/var/log/ipaserver-ca-install.log"
    IPASERVER_INSTALL_LOG = "/var/log/ipaserver-install.log"
    IPASERVER_KRA_INSTALL_LOG = "/var/log/ipaserver-kra-install.log"
    IPASERVER_KRA_UNINSTALL_LOG = "/var/log/ipaserver-kra-uninstall.log"
    IPASERVER_UNINSTALL_LOG = "/var/log/ipaserver-uninstall.log"
    IPAUPGRADE_LOG = "/var/log/ipaupgrade.log"
    KADMIND_LOG = "/var/log/kadmind.log"
    MESSAGES = "/var/log/messages"
    VAR_LOG_PKI_DIR = "/var/log/pki/"
    TOMCAT_TOPLEVEL_DIR = "/var/log/pki/pki-tomcat"
    TOMCAT_CA_DIR = "/var/log/pki/pki-tomcat/ca"
    TOMCAT_CA_ARCHIVE_DIR = "/var/log/pki/pki-tomcat/ca/archive"
    TOMCAT_SIGNEDAUDIT_DIR = "/var/log/pki/pki-tomcat/ca/signedAudit"
    TOMCAT_KRA_DIR = "/var/log/pki/pki-tomcat/kra"
    TOMCAT_KRA_ARCHIVE_DIR = "/var/log/pki/pki-tomcat/kra/archive"
    TOMCAT_KRA_SIGNEDAUDIT_DIR = "/var/log/pki/pki-tomcat/kra/signedAudit"
    LOG_SECURE = "/var/log/secure"
    NAMED_RUN = "/var/named/data/named.run"
    VAR_OPENDNSSEC_DIR = "/var/opendnssec"
    OPENDNSSEC_KASP_DB = "/var/opendnssec/kasp.db"
    IPA_ODS_EXPORTER_CCACHE = "/var/opendnssec/tmp/ipa-ods-exporter.ccache"
    VAR_RUN_DIRSRV_DIR = "/var/run/dirsrv"
    KRB5CC_HTTPD = "/var/run/httpd/ipa/krbcache/krb5ccache"
    IPA_RENEWAL_LOCK = "/var/run/ipa/renewal.lock"
    SVC_LIST_FILE = "/var/run/ipa/services.list"
    IPA_MEMCACHED_DIR = "/var/run/ipa_memcached"
    VAR_RUN_IPA_MEMCACHED = "/var/run/ipa_memcached/ipa_memcached"
    KRB5CC_SAMBA = "/var/run/samba/krb5cc_samba"
    SLAPD_INSTANCE_SOCKET_TEMPLATE = "/var/run/slapd-%s.socket"
    ALL_SLAPD_INSTANCE_SOCKETS = "/var/run/slapd-*.socket"
    ADMIN_CERT_PATH = '/root/.dogtag/pki-tomcat/ca_admin.cert'
    ENTROPY_AVAIL = '/proc/sys/kernel/random/entropy_avail'
    LDIF2DB = '/usr/sbin/ldif2db'
    DB2LDIF = '/usr/sbin/db2ldif'
    BAK2DB = '/usr/sbin/bak2db'
    DB2BAK = '/usr/sbin/db2bak'
    KDCPROXY_CONFIG = '/etc/ipa/kdcproxy/kdcproxy.conf'
    CERTMONGER = '/usr/sbin/certmonger'
    NETWORK_MANAGER_CONFIG_DIR = '/etc/NetworkManager/conf.d'
    IPA_CUSTODIA_CONF_DIR = '/etc/ipa/custodia'
    IPA_CUSTODIA_CONF = '/etc/ipa/custodia/custodia.conf'
    IPA_CUSTODIA_SOCKET = '/run/httpd/ipa-custodia.sock'
    IPA_CUSTODIA_AUDIT_LOG = '/var/log/ipa-custodia.audit.log'
    IPA_GETKEYTAB = '/usr/sbin/ipa-getkeytab'

path_namespace = BasePathNamespace
