/*

  FITSPNG     FITS to PNG converter
  Copyright (C) 2006-2017  Filip Hroch, Masaryk University, Brno, CZ

  This is a routine for fast determination of k-th quantil (median).
  Modification of the Pascal routine by N. Wirth: Algorithms + data
  structures = programs.


  Fitspng is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Fitspng is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Fitspng.  If not, see <http://www.gnu.org/licenses/>.

*/


float qmed(int n, float *a, int k)
{
  float w,x;
  int l,r,i,j;

  x = 0.0;

  l = 0;
  r = n - 1;

  while( l < r ) {
    x = a[k];
    i = l;
    j = r;

    do {

      while( a[i] < x )
	i++;

      while( x < a[j] )
	j--;

      if( i <= j ) {
	w = a[i];
	a[i] = a[j];
	a[j] = w;
	i++;
	j--;
      }

    } while ( i <= j );

    if( j < k ) l = i;
    if( k < i ) r = j;
  }

  return(x);
}
