/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.colorspace.boxes;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import ucar.jpeg.colorspace.ColorSpaceException;
import ucar.jpeg.colorspace.boxes.JP2Box;
import ucar.jpeg.icc.ICCProfile;
import ucar.jpeg.jj2000.j2k.io.RandomAccessIO;

public final class ComponentMappingBox
extends JP2Box {
    private int nChannels;
    private Vector map = new Vector();

    public ComponentMappingBox(RandomAccessIO in, int boxStart) throws IOException, ColorSpaceException {
        super(in, boxStart);
        this.readBox();
    }

    void readBox() throws IOException {
        this.nChannels = (this.boxEnd - this.dataStart) / 4;
        this.in.seek(this.dataStart);
        for (int offset = this.dataStart; offset < this.boxEnd; offset += 4) {
            byte[] mapping = new byte[4];
            this.in.readFully(mapping, 0, 4);
            this.map.addElement(mapping);
        }
    }

    public int getNChannels() {
        return this.nChannels;
    }

    public int getCMP(int channel) {
        byte[] mapping = (byte[])this.map.elementAt(channel);
        return ICCProfile.getShort(mapping, 0) & 0xFFFF;
    }

    public short getMTYP(int channel) {
        byte[] mapping = (byte[])this.map.elementAt(channel);
        return (short)(mapping[2] & 0xFF);
    }

    public short getPCOL(int channel) {
        byte[] mapping = (byte[])this.map.elementAt(channel);
        return (short)(mapping[3] & 0xFF);
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[ComponentMappingBox ").append("  ");
        rep.append("nChannels= ").append(String.valueOf(this.nChannels));
        Enumeration enumeration = this.map.elements();
        while (enumeration.hasMoreElements()) {
            byte[] bfr = (byte[])enumeration.nextElement();
            rep.append(eol).append("  ").append("CMP= ").append(String.valueOf(this.getCMP(bfr))).append(", ");
            rep.append("MTYP= ").append(String.valueOf(this.getMTYP(bfr))).append(", ");
            rep.append("PCOL= ").append(String.valueOf(this.getPCOL(bfr)));
        }
        rep.append("]");
        return rep.toString();
    }

    private int getCMP(byte[] mapping) {
        return ICCProfile.getShort(mapping, 0) & 0xFFFF;
    }

    private short getMTYP(byte[] mapping) {
        return (short)(mapping[2] & 0xFF);
    }

    private short getPCOL(byte[] mapping) {
        return (short)(mapping[3] & 0xFF);
    }

    static {
        type = 1668112752;
    }
}

