/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class VisitechReader
extends FormatReader {
    private Vector files;

    public VisitechReader() {
        super("Visitech XYS", new String[]{"xys", "html"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        int plane = this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]);
        int div = this.core.sizeZ[0] * this.core.sizeT[0];
        int fileIndex = no / div;
        int planeIndex = no % div;
        String file = (String)this.files.get(fileIndex);
        RandomAccessStream s = new RandomAccessStream(file);
        s.skipBytes(374);
        while (s.read() != -16) {
        }
        s.skipBytes((plane + 164) * planeIndex + 1);
        s.read(buf);
        s.close();
        return buf;
    }

    public String[] getUsedFiles() {
        if (this.files == null) {
            return new String[0];
        }
        return this.files.toArray(new String[0]);
    }

    protected void initFile(String id) throws FormatException, IOException {
        int ndx;
        super.initFile(id);
        if (!id.toLowerCase().endsWith("html")) {
            Location file = new Location(id).getAbsoluteFile();
            String path = file.exists() ? file.getPath() : id;
            int ndx2 = path.lastIndexOf(File.separator);
            String base = path.substring(ndx2 + 1, path.indexOf(" ", ndx2));
            String suffix = " Report.html";
            this.currentId = null;
            this.initFile(file.exists() ? new Location(file.getParent(), base + suffix).getAbsolutePath() : base + suffix);
            return;
        }
        this.in = new RandomAccessStream(id);
        String s = this.in.readString((int)this.in.length());
        s = s.replaceAll("<[bB][rR]>", "\n");
        s = s.replaceAll("<[sS][tT][yY][lL][eE]\\p{ASCII}*?[sS][tT][yY][lL][eE]>", "");
        s = s.replaceAll("<[sS][cC][rR][iI][pP][tT]\\p{ASCII}*?[sS][cC][rR][iI][pP][tT]>", "");
        StringTokenizer st = new StringTokenizer(s, "\n");
        String token = null;
        String key = null;
        String value = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken().trim();
            if ((!token.startsWith("<") || token.startsWith("</")) && token.indexOf("pixels") == -1) continue;
            ndx = (token = token.replaceAll("<.*?>", "")).indexOf(":");
            if (ndx != -1) {
                key = token.substring(0, ndx).trim();
                value = token.substring(ndx + 1).trim();
                if (key.equals("Number of steps")) {
                    this.core.sizeZ[0] = Integer.parseInt(value);
                } else if (key.equals("Image bit depth")) {
                    int bits = Integer.parseInt(value);
                    while (bits % 8 != 0) {
                        ++bits;
                    }
                    switch (bits) {
                        case 16: {
                            this.core.pixelType[0] = 3;
                            break;
                        }
                        case 32: {
                            this.core.pixelType[0] = 5;
                            break;
                        }
                        default: {
                            this.core.pixelType[0] = 1;
                            break;
                        }
                    }
                } else if (key.equals("Image dimensions")) {
                    int n = value.indexOf(",");
                    this.core.sizeX[0] = Integer.parseInt(value.substring(1, n).trim());
                    this.core.sizeY[0] = Integer.parseInt(value.substring(n + 1, value.length() - 1).trim());
                }
                this.addMeta(key, value);
            }
            if (token.indexOf("pixels") == -1) continue;
            this.core.sizeC[0] = this.core.sizeC[0] + 1;
            this.core.imageCount[0] = this.core.imageCount[0] + Integer.parseInt(token.substring(0, token.indexOf(" ")));
        }
        this.core.sizeT[0] = this.core.imageCount[0] / (this.core.sizeZ[0] * this.core.sizeC[0]);
        this.core.rgb[0] = false;
        this.core.currentOrder[0] = "XYZTC";
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = true;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        this.files = new Vector();
        ndx = this.currentId.lastIndexOf(File.separator);
        String base = this.currentId.substring(ndx + 1, this.currentId.indexOf(" ", ndx));
        File f = new File(this.currentId).getAbsoluteFile();
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            this.files.add((f.exists() ? f.getParent() + File.separator : "") + base + " " + (i + 1) + ".xys");
        }
        this.files.add(this.currentId);
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

