/*
 * $Id: cb_intel_eepro100.c,v 1.28 2012-02-22 09:27:19 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue.h"

#include "chip_intel_82557_cardbus.h"

#include "cb_intel_eepro100.h"

struct cpssp {
	struct sig_boolean *port_opt_power_led;
	struct sig_pci_bus_idsel *sig_idsel;

	void *chip;
};

static void
cb_intel_eepro100_p5V_set(void *_cpss, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpss;

	sig_boolean_set(cpssp->port_opt_power_led, cpssp, val);
}

static int
cb_intel_eepro100_c0r(void *_cpss, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpss;

	if ((addr >> 11) & 1) {
		return sig_pci_bus_idsel_c0r(cpssp->sig_idsel, cpssp,
				addr, bs, valp);
	} else {
		return -1;
	}
}

static int
cb_intel_eepro100_c0w(void *_cpss, uint32_t addr, unsigned int bs, uint32_t val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpss;

	if ((addr >> 11) & 1) {
		return sig_pci_bus_idsel_c0w(cpssp->sig_idsel, cpssp,
				addr, bs, val);
	} else {
		return -1;
	}
}

void *
cb_intel_eepro100_create(
	const char *name,
	const char *mac,
	struct sig_manage *port_manage,
	struct sig_cardbus *port_card,
	struct sig_eth *port_eth,
	struct sig_boolean *port_opt_power_led,
	struct sig_boolean *port_opt_busy_led
)
{
	static const struct sig_boolean_funcs p5V_funcs = {
		.set = cb_intel_eepro100_p5V_set,
	};
	static const struct sig_pci_bus_main_funcs pci_bus_funcs = {
		.c0r = cb_intel_eepro100_c0r,
		.c0w = cb_intel_eepro100_c0w,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->port_opt_power_led = port_opt_power_led;

	cpssp->sig_idsel = sig_pci_bus_idsel_create("sig_idsel");

	sig_boolean_connect_in(port_card->p5V, cpssp, &p5V_funcs);
	sig_pci_bus_main_connect(port_card->bus, cpssp, &pci_bus_funcs);

	cpssp->chip = chip_intel_82557_cardbus_create("U1", mac,
			NULL,
			port_card->p5V,
			port_card->n_reset, cpssp->sig_idsel,
			port_card->bus, port_card->irq,
			port_eth, port_opt_busy_led);

	return cpssp;
}

void
cb_intel_eepro100_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	chip_intel_82557_cardbus_destroy(cpssp->chip);

	sig_pci_bus_idsel_destroy(cpssp->sig_idsel);

	shm_free(cpssp);
}

void
cb_intel_eepro100_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
	
	chip_intel_82557_cardbus_suspend(cpssp->chip, fComp);
}

void
cb_intel_eepro100_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
	
	chip_intel_82557_cardbus_resume(cpssp->chip, fComp);
}
