/* $Id: ptrace.h,v 1.14 2009-01-28 14:38:02 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PTRACE_H_INCLUDED
#define __PTRACE_H_INCLUDED

#include <inttypes.h>

#define ureg(reg) \
	union { \
		uint32_t e ## reg ## x; \
		struct { \
			uint16_t reg ## x; \
			uint16_t reg ## dummy0; \
		} u16; \
		struct { \
			uint8_t reg ## l; \
			uint8_t reg ## h; \
			uint16_t reg ## dummy1; \
		} u8; \
	} reg

struct regs {
	unsigned short es;	/* saved by interrupt handler */
	unsigned short ds;
	unsigned short di;
	unsigned short si;
	unsigned short bp;
	ureg(d) __attribute__((__packed__));
	ureg(c) __attribute__((__packed__));
	ureg(b) __attribute__((__packed__));
	ureg(a) __attribute__((__packed__));
	unsigned short ip;	/* saved by int $xx call */
	unsigned short cs;
	unsigned short flags;
} __attribute__((__packed__));

#define EAX	(regs->a.eax)
#define AX	(regs->a.u16.ax)
#define AL	(regs->a.u8.al)
#define AH	(regs->a.u8.ah)

#define EBX	(regs->b.ebx)
#define BX	(regs->b.u16.bx)
#define BL	(regs->b.u8.bl)
#define BH	(regs->b.u8.bh)

#define ECX	(regs->c.ecx)
#define CX	(regs->c.u16.cx)
#define CL	(regs->c.u8.cl)
#define CH	(regs->c.u8.ch)

#define EDX	(regs->d.edx)
#define DX	(regs->d.u16.dx)
#define DL	(regs->d.u8.dl)
#define DH	(regs->d.u8.dh)

#define BP	(regs->bp)
#define SI	(regs->si)
#define DI	(regs->di)

#define ES	(regs->es)
#define DS	(regs->ds)

#define IP	(regs->ip)
#define CS	(regs->cs)

#define F	(regs->flags)

#endif /* __PTRACE_H_INCLUDED */
