-- $Id: user-begin.vhdl,v 1.4 2009-08-25 06:29:16 sand Exp $
--
-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

library expect;
use expect.types.all;
use expect.procedures.all;
library ieee;
use ieee.std_logic_1164.ALL;

entity user is
	port(
		term0_power_switch : out boolean;
		term0_key : out boolean_array(0 to 127);
		term0_screen_shot : out boolean;
		term0_rec : out boolean;
		term0_opt_screen : in opt_rgb;

		term1_power_switch : out boolean;
		term1_key : out boolean_array(0 to 127);
		term1_screen_shot : out boolean;
		term1_rec : out boolean;
		term1_opt_screen : in opt_rgb
	);
end user;

architecture behaviour of user is
	signal pm0_int_text0 : cstring;
	signal pm0_int_text1 : cstring;
	signal pm0_int_text2 : cstring;
	signal pm0_int_text3 : cstring;
	signal pm0_int_text0_state : boolean;
	signal pm0_int_text1_state : boolean;
	signal pm0_int_text2_state : boolean;
	signal pm0_int_text3_state : boolean;
	signal pm0_int_slot0 : match;
	signal pm0_int_slot1 : match;
	signal pm0_int_slot2 : match;
	signal pm0_int_slot3 : match;
	signal pm0_int_slot4 : match;
	signal pm0_int_slot5 : match;
	signal pm0_int_slot6 : match;
	signal pm0_int_slot7 : match;
	signal pm0_int_slot8 : match;
	signal pm0_int_slot9 : match;
	signal pm0_int_slot10 : match;
	signal pm0_int_slot11 : match;
	signal pm0_int_slot12 : match;
	signal pm0_int_slot13 : match;
	signal pm0_int_slot14 : match;
	signal pm0_int_slot15 : match;
	signal pm0_int_rectangle0 : cstring;
	signal pm0_int_rectangle1 : cstring;
	signal pm0_int_rectangle2 : cstring;
	signal pm0_int_rectangle3 : cstring;

	signal pm1_int_text0 : cstring;
	signal pm1_int_text1 : cstring;
	signal pm1_int_text2 : cstring;
	signal pm1_int_text3 : cstring;
	signal pm1_int_text0_state : boolean;
	signal pm1_int_text1_state : boolean;
	signal pm1_int_text2_state : boolean;
	signal pm1_int_text3_state : boolean;
	signal pm1_int_slot0 : match;
	signal pm1_int_slot1 : match;
	signal pm1_int_slot2 : match;
	signal pm1_int_slot3 : match;
	signal pm1_int_slot4 : match;
	signal pm1_int_slot5 : match;
	signal pm1_int_slot6 : match;
	signal pm1_int_slot7 : match;
	signal pm1_int_slot8 : match;
	signal pm1_int_slot9 : match;
	signal pm1_int_slot10 : match;
	signal pm1_int_slot11 : match;
	signal pm1_int_slot12 : match;
	signal pm1_int_slot13 : match;
	signal pm1_int_slot14 : match;
	signal pm1_int_slot15 : match;
	signal pm1_int_rectangle0 : cstring;
	signal pm1_int_rectangle1 : cstring;
	signal pm1_int_rectangle2 : cstring;
	signal pm1_int_rectangle3 : cstring;


	signal t0_int_asc_text0 : cstring;
	signal t0_int_asc_text1 : cstring;
	signal t0_int_asc_text2 : cstring;
	signal t0_int_asc_text3 : cstring;
	signal t0_int_asc_text0_state : boolean;
	signal t0_int_asc_text1_state : boolean;
	signal t0_int_asc_text2_state : boolean;
	signal t0_int_asc_text3_state : boolean;

	signal t1_int_asc_text0 : cstring;
	signal t1_int_asc_text1 : cstring;
	signal t1_int_asc_text2 : cstring;
	signal t1_int_asc_text3 : cstring;
	signal t1_int_asc_text0_state : boolean;
	signal t1_int_asc_text1_state : boolean;
	signal t1_int_asc_text2_state : boolean;
	signal t1_int_asc_text3_state : boolean;


begin
	patternmatcher0 : patternm 
		port map (
			video => term0_opt_screen,
			text0 => pm0_int_text0,
			text0_state => pm0_int_text0_state,
			text1 => pm0_int_text1, 
			text1_state => pm0_int_text1_state,
			text2 => pm0_int_text2,
			text2_state => pm0_int_text2_state,
			text3 => pm0_int_text3, 
			text3_state => pm0_int_text3_state,
			asc_text0 => t0_int_asc_text0,
			asc_text0_state => t0_int_asc_text0_state,
			asc_text1 => t0_int_asc_text1, 
			asc_text1_state => t0_int_asc_text1_state,
			asc_text2 => t0_int_asc_text2,
			asc_text2_state => t0_int_asc_text2_state,
			asc_text3 => t0_int_asc_text3, 
			asc_text3_state => t0_int_asc_text3_state,
			slot0 => pm0_int_slot0,
			slot1 => pm0_int_slot1,
			slot2 => pm0_int_slot2,
			slot3 => pm0_int_slot3,
			slot4 => pm0_int_slot4,
			slot5 => pm0_int_slot5,
			slot6 => pm0_int_slot6,
			slot7 => pm0_int_slot7,
			slot8 => pm0_int_slot8,
			slot9 => pm0_int_slot9,
			slot10 => pm0_int_slot10,
			slot11 => pm0_int_slot11,
			slot12 => pm0_int_slot12,
			slot13 => pm0_int_slot13,
			slot14 => pm0_int_slot14,
			slot15 => pm0_int_slot15,
			pattern_rectangle0 => pm0_int_rectangle0,
			pattern_rectangle1 => pm0_int_rectangle1,
			pattern_rectangle2 => pm0_int_rectangle2,
			pattern_rectangle3 => pm0_int_rectangle3
		);

	patternmatcher1 : patternm 
		port map (
			video => term1_opt_screen,
			text0 => pm1_int_text0,
			text0_state => pm1_int_text0_state,
			text1 => pm1_int_text1, 
			text1_state => pm1_int_text1_state,
			text2 => pm1_int_text2,
			text2_state => pm1_int_text2_state,
			text3 => pm1_int_text3, 
			text3_state => pm1_int_text3_state,
			asc_text0 => t1_int_asc_text0,
			asc_text0_state => t1_int_asc_text0_state,
			asc_text1 => t1_int_asc_text1, 
			asc_text1_state => t1_int_asc_text1_state,
			asc_text2 => t1_int_asc_text2,
			asc_text2_state => t1_int_asc_text2_state,
			asc_text3 => t1_int_asc_text3, 
			asc_text3_state => t1_int_asc_text3_state,
			slot0 => pm1_int_slot0,
			slot1 => pm1_int_slot1,
			slot2 => pm1_int_slot2,
			slot3 => pm1_int_slot3,
			slot4 => pm1_int_slot4,
			slot5 => pm1_int_slot5,
			slot6 => pm1_int_slot6,
			slot7 => pm1_int_slot7,
			slot8 => pm1_int_slot8,
			slot9 => pm1_int_slot9,
			slot10 => pm1_int_slot10,
			slot11 => pm1_int_slot11,
			slot12 => pm1_int_slot12,
			slot13 => pm1_int_slot13,
			slot14 => pm1_int_slot14,
			slot15 => pm1_int_slot15,
			pattern_rectangle0 => pm1_int_rectangle0,
			pattern_rectangle1 => pm1_int_rectangle1,
			pattern_rectangle2 => pm1_int_rectangle2,
			pattern_rectangle3 => pm1_int_rectangle3
		);


	installation_script : process
	begin
