/* $Id: Operand.hpp 4991 2010-10-21 14:56:27Z potyra $ 
 *
 * Copyright (C) 2008-2010 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __OPERAND_HPP_INCLUDED
#define __OPERAND_HPP_INCLUDED

#include "intermediate/Node.hpp"

namespace intermediate {

//! different types of operands
enum OpType {
	//! an integer value (only immediate)
	OP_TYPE_INTEGER,
	//! a real value (only immediate)
	OP_TYPE_REAL,
	//! a pointer value (immediate or indirect, indirect & offset)
	OP_TYPE_POINTER
};

//! one operand
/** This class represents one operand for the intermediate code.
 */
class Operand : public Node {
public:
	//! c'tor
	/** @param t operand type
	 */
	Operand(enum OpType t) : type(t) {}
	
	//! base type of the Operand
	enum OpType type;
};

}; /* namespace intermediate */

#endif /* __OPERAND_HPP_INCLUDED */
