/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright  CNRS, INRIA, Universit Bordeaux 1
 * See COPYING in top-level directory.
 */

#ifndef __EV_CODES_H__
#define __EV_CODES_H__

#define NB_BITS 24
#define NB_BITS_PREFIX 8
#define NB_BITS_EVENTS (NB_BITS - NB_BITS_PREFIX)

#define SYSTEM_MODULE_MASK (0<<(NB_BITS_PREFIX-1))
#define USER_MODULE_MASK (1<<(NB_BITS_PREFIX-1))

#define USER_MODULE_ID(id)   (id | USER_MODULE_MASK)
#define SYSTEM_MODULE_ID(id) (id | SYSTEM_MODULE_MASK)

#define GENERATE_USER_MODULE_PREFIX(id)   ((id) << NB_BITS_EVENTS)
#define GENERATE_SYSTEM_MODULE_PREFIX(id) ((id) << NB_BITS_EVENTS)

#define PTHREAD_CORE_EVENTS_ID 0x00
#define PTHREAD_CORE_PREFIX    GENERATE_SYSTEM_MODULE_PREFIX(PTHREAD_CORE_EVENTS_ID)

/* thread creation/destruction */
#define FUT_NEW_THREAD          (PTHREAD_CORE_PREFIX | 0x0001)
#define FUT_END_THREAD          (PTHREAD_CORE_PREFIX | 0x0002)
#define FUT_START_THREAD_JOIN   (PTHREAD_CORE_PREFIX | 0x0004)
#define FUT_STOP_THREAD_JOIN    (PTHREAD_CORE_PREFIX | 0x0005)

#define FUT_SIGNAL_RECEIVED     (PTHREAD_CORE_PREFIX | 0xf000)
#define FUT_CALLING_FUNCTION    (PTHREAD_CORE_PREFIX | 0xf001)

#endif	/*  __EV_CODES_H__ */
