#!/usr/bin/env python
import re

from setuptools import find_packages, setup

with open('django_tables2/__init__.py', 'rb') as f:
    version = str(re.search('__version__ = "(.+?)"', f.read().decode('utf-8')).group(1))

try:
    # Verify output using
    # ./setup.py --long-description | rst2html.py > output.html
    import pypandoc
    long_description = pypandoc.convert('README.md', 'rst')
except ImportError:
    print('PyPI needs .rst and README is in .md.')
    print('Use `pip install pypandoc` to enable conversion')
    long_description = open('README.md').read()

setup(
    name='django-tables2',
    version=version,
    description='Table/data-grid framework for Django',
    long_description=long_description,

    author='Bradley Ayers',
    author_email='bradley.ayers@gmail.com',
    license='Simplified BSD',
    url='https://github.com/bradleyayers/django-tables2/',

    packages=find_packages(exclude=['tests.*', 'tests', 'example.*', 'example']),
    include_package_data=True,  # declarations in MANIFEST.in

    install_requires=['Django >=1.7', 'six'],

    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Software Development :: Libraries',
    ],
)
