#include "StdAfx.h"
#include "RawSpeed-API.h"

/* 
RawSpeed - RAW file decoder.

Copyright (C) 2009-2014 Klaus Post

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

http://www.klauspost.com
*/

using namespace RawSpeed;

#define _USE_GFL_
#ifdef _USE_GFL_
#include "libgfl.h"
#pragma comment(lib, "libgfl.lib") 
#endif

int startTime;


void compareIFD(TiffIFD *i1, TiffIFD *i2) {
  map<TiffTag, TiffEntry*>::iterator i =  i1->mEntry.begin();
  for ( ; i != i1->mEntry.end(); i++) {
    TiffEntry *e1 = (*i).second;
    TiffEntry *e2 = i2->mEntry[(*i).first];
    const uchar8 *d1 = e1->getData();
    const uchar8 *d2 = e2->getData();
    if (memcmp(d1,d2,min(e1->count*e1->getElementSize(),e2->count*e2->getElementSize())))
      Sleep(20);
  }

  for (uint32 i = 0 ; i < i1->mSubIFD.size(); i++) {
    compareIFD(i1->mSubIFD[i], i2->mSubIFD[i]);
  }

}
// Open file and save as tiff
void OpenFileID(FileReader f, CameraMetaData *meta) {
  FileReader f2(L"..\\testimg\\Panasonic-LF1hSLI06400.RW2");
  RawDecoder *d = 0;
  FileMap* m = 0;
  RawDecoder *d2 = 0;
  FileMap* m2 = 0;
  try {
    //    wprintf(L"Opening:%s\n",f.Filename());
    try {
      m = f.readFile();    	
      m2 = f2.readFile();    	
    } catch (FileIOException &e) {
      printf("Could not open image:%s\n", e.what());
      return;
    }
    RawParser t(m);
    d = t.getDecoder();
    RawParser t2(m2);
    d2 = t2.getDecoder();
    TiffIFD *ifd1 = d->getRootIFD();
    TiffIFD *ifd2 = d2->getRootIFD();
//    d->checkSupport(meta);
//    d->decodeRaw();
//    d->decodeMetaData(meta);
//    d->mRaw->scaleBlackWhite();
    compareIFD(ifd1, ifd2);
    string mode;
    if (d->mRaw->isCFA)
      mode = "cfa";
    else if (d->mRaw->metadata.subsampling.y == 2)
      mode = "sRaw1";
    else
      mode = "sRaw2";

    printf("Camera: %s, %s, mode:%s\r\n", d->getRootIFD()->getEntryRecursive(MAKE)->getString().c_str(), 
      d->getRootIFD()->getEntryRecursive(MODEL)->getString().c_str(), mode.c_str());
    printf("%s: <Sensor black=\"%d\", white=\"%d\" black_colors=\"%d,%d,%d,%d\" iso_list=\"%d\"/>\r\n", mode.c_str(),
      d->mRaw->blackLevel, d->mRaw->whitePoint, d->mRaw->blackLevelSeparate[0], d->mRaw->blackLevelSeparate[1], 
      d->mRaw->blackLevelSeparate[2], d->mRaw->blackLevelSeparate[3], d->mRaw->metadata.isoSpeed);
    if (d) delete d;
    if (m) delete m;
  } catch (RawDecoderException) {
  }
}
// Open file, or test corrupt file
#if 0
// Open file and save as tiff
void OpenFile(FileReader f, CameraMetaData *meta) {
  RawDecoder *d = 0;
  FileMap* m = 0;
  try {
    //    wprintf(L"Opening:%s\n",f.Filename());
    try {
      m = f.readFile();    	
    } catch (FileIOException &e) {
      printf("Could not open image:%s\n", e.what());
      return;
    }
    RawParser t(m);
    d = t.getDecoder();
    d->checkSupport(meta);
    startTime = GetTickCount();

    d->decodeRaw();
    d->decodeMetaData(meta);
    RawImage r = d->mRaw;
    r->scaleBlackWhite();

    uint32 time = GetTickCount()-startTime;
    float mpps = (float)r->dim.x * (float)r->dim.y * (float)r->getCpp()  / (1000.0f * (float)time);
    wprintf(L"Decoding %s took: %u ms, %4.2f Mpixel/s\n", f.Filename(), time, mpps);
    for (uint32 i = 0; i < r->errors.size(); i++) {
      printf("Error Encountered:%s", r->errors[i]);
    }
        
    if (r->isCFA) {
              printf("DCRAW filter:%x\n",r->cfa.getDcrawFilter());
              r->cfa.shiftLeft();
              printf("DCRAW filter:%x\n",r->cfa.getDcrawFilter());
              r->cfa.shiftDown();
              printf("DCRAW filter:%x\n",r->cfa.getDcrawFilter());
      //        printf(r->cfa.asString().c_str());
    }
    /*
    for (uint32 y=200;y<r->dim.y-400; y+=2) {
    printf("black,");
    for (uint32 x=20;x<=100; x+=2) {
    (x==100) ? printf("%d\n",(int)*(UINT16*)r->getData(x,y)) : printf("%d,",(int)*(UINT16*)r->getData(x,y));
    }
    printf("color,");
    for (uint32 x=1020;x<=1100; x+=2) {
    (x==1100) ? printf("%d\n",(int)*(UINT16*)r->getData(x,y)) : printf("%d,",(int)*(UINT16*)r->getData(x,y));
    }
    }
    */
#ifdef _USE_GFL_
    GFL_BITMAP* b;
    if (r->getCpp() == 1)
      b = gflAllockBitmapEx(GFL_GREY,r->dim.x, r->dim.y,16,16,NULL);
    else if (r->getCpp() == 3)
      b = gflAllockBitmapEx(GFL_RGB,r->dim.x, r->dim.y,16,8,NULL);
    else
      ThrowRDE("Unable to save image.");

    BitBlt(b->Data,b->BytesPerLine, r->getData(),r->pitch, r->dim.x*r->getBpp(), r->dim.y );

    GFL_SAVE_PARAMS s;
    gflGetDefaultSaveParams(&s);
    s.FormatIndex = gflGetFormatIndexByName("tiff");

    char ascii[1024];
    WideCharToMultiByte(CP_ACP, 0, f.Filename(), -1, ascii, 1024, NULL, NULL);
    string savename(ascii);

    size_t index = savename.rfind('.');
    if (r->mode.length() > 0) {
      int idx;
      while( (idx = (int)r->mode.find_first_of(':')) >= 0 )
        r->mode.replace( idx, 1, "-" );
      savename = savename.substr(0,index).append("[").append(r->mode).append("].tiff");
    } else {
      savename = savename.substr(0,index).append(".tiff");
    }

    gflSaveBitmap((char*)savename.c_str(),b,&s);
    gflFreeBitmap(b);
#endif
  } catch (RawDecoderException &e) {
    wchar_t uni[1024];
    MultiByteToWideChar(CP_ACP, 0, e.what(), -1, uni, 1024);
    //    MessageBox(0,uni, L"RawDecoder Exception",0);
    wprintf(L"Raw Decoder Exception:%s\n",uni);
  }
  if (d) delete d;
  if (m) delete m;

}

#else

// Test single file multiple times in corrupted state
// Used to test for states that might crash the app.

void OpenFile(FileReader f, CameraMetaData *meta) {
  RawDecoder *d = 0;
  FileMap* m = 0;
  wprintf(L"Opening:%s\n",f.Filename());
  try {
    m = f.readFile();
  } catch (FileIOException &e) {
    printf("Could not open image:%s\n", e.what());
    return;
  }
  srand(0xC01ACAB1);  // Hardcoded seed for re-producability (on the same platform)

  int tests = 100;
  // Try 50 permutations
  for (int i = 0 ; i < tests; i++) {  
    FileMap *m2 = m->clone();
    try {    
      // Insert 1000 random errors in file
      m2->corrupt(1000);
      RawParser t(m2);
      d = t.getDecoder();

      startTime = GetTickCount();


      d->decodeRaw();
      d->decodeMetaData(meta);
      RawImage r = d->mRaw;

      uint32 time = GetTickCount()-startTime;
      float mpps = (float)r->dim.x * (float)r->dim.y * (float)r->getCpp()  / (1000.0f * (float)time);
      wprintf(L"(%d/%d) Decoding %s took: %u ms, %4.2f Mpixel/s\n", i+1, tests, f.Filename(), time, mpps);
      if (r->errors.size())
        printf("%u Error Encountered.\n", r->errors.size());
      /*      for (uint32 i = 0; i < d->errors.size(); i++) {
      printf("Error Encountered:%s\n", d->errors[i]);
      }*/

    } catch (RawDecoderException &e) {
      _RPT1(0,"Exception: %s", e.what());
      wchar_t uni[1024];
      MultiByteToWideChar(CP_ACP, 0, e.what(), -1, uni, 1024);
      wprintf(L"Raw Decoder Exception:%s\n",uni);
    }
    delete m2;
    if (d)
      delete d;
    d = 0;
  }
  srand(0x88C0C01A);  // Hardcoded seed for re-producability (on the same platform)
  wprintf(L"Performing truncation tests\n");
  tests=100;
  for (int i = 0 ; i < tests; i++) {  
    // Get truncated file
    FileMap *m2 = m->cloneRandomSize();
    try {    
      RawParser t(m2);
      d = t.getDecoder();

      startTime = GetTickCount();
      d->decodeRaw();
      d->decodeMetaData(meta);
      RawImage r = d->mRaw;

      uint32 time = GetTickCount()-startTime;
      float mpps = (float)r->dim.x * (float)r->dim.y * (float)r->getCpp()  / (1000.0f * (float)time);
      wprintf(L"(%d/%d) Decoding %s took: %u ms, %4.2f Mpixel/s\n", i+1+tests, tests, f.Filename(), time, mpps);
      if (r->errors.size())
        printf("%u Error Encountered.\n", r->errors.size());
      /*      for (uint32 i = 0; i < d->errors.size(); i++) {
      printf("Error Encountered:%s\n", d->errors[i]);
      }*/
    } catch (RawDecoderException &e) {
      _RPT1(0,"Exception: %s", e.what());
      wchar_t uni[1024];
      MultiByteToWideChar(CP_ACP, 0, e.what(), -1, uni, 1024);
      wprintf(L"Raw Decoder Exception:%s\n",uni);
    }
    delete m2;
    if (d)
      delete d;
    d = 0;
  }
  delete m;
}
#endif

int wmain(int argc, _TCHAR* argv[])
{
  if (1) {  // for memory detection
#ifdef _USE_GFL_
    GFL_ERROR err;
    err = gflLibraryInit();
    if (err) {
      string errSt = string("Could not initialize GFL library. Library returned: ") + string(gflGetErrorString(err));
      return 1;
    }
#endif
    try {
      //    CameraMetaData meta();

      CameraMetaData meta("..\\data\\cameras.xml");
/*      OpenFile(FileReader(L"..\\testimg\\Minolta_DiMAGE_5.mrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Minolta_DiMAGE_7HI.mrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Minolta_DiMAGE_7i.mrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Minolta_DiMAGE_A1.mrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Minolta_DiMAGE_A2.mrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Minolta_Dynax_5D.mrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Minolta_Dynax_7D.mrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_MINOLTA_5D.MRW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_MINOLTA_A2.MRW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC_L10.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC_LX2.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-2.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-3.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-4.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-5.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-6.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ30.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ50.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ50_2.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ8.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ8-2.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_L1.raw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic_LX2.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_LEICA_DLUX3.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_LEICA_VLUX1.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_LEICA_DIGILUX2_SRGB.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_PANASONIC_G1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_PANASONIC_DMCL10.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_PANASONIC_LX2.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_PANASONIC_LUMIX_L1.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_PANASONIC_FZ30_SRGB.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_PANASONIC_LUMIX_FZ18.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_PANASONIC_FZ28.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_PANASONIC_FZ8.RAW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_MINOLTA_A1.MRW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_MINOLTA_7D_SRGB.MRW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_MINOLTA_DIMAGE_7I.MRW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\RAW_MINOLTA_DIMAGE_7HI.MRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax-K3-IMGP0202.PEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_K20D.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_K10D.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_K10D-2.dng"),&meta);


      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8812.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sigma_SD10.X3F"),&meta);
      OpenFile(FileReader(L"..\\testimg\\bench\\sigma_dp2.x3f"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sigma_SD10-2.x3f"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sigma_SD10-3.x3f"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sigma_SD14.X3F"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sigma_SD9.X3F"),&meta);
      OpenFile(FileReader(L"..\\testimg\\bench\\sigma_sd1_merrill_13.x3f"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\jb_1_2013-10-05_1127_C0000_000060.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\fujifilm_x100s_16.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\80fps 4-12_2013-06-04-183231-0000.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon-G16-G16hSLI12800NR2D.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-G16-G16hSLI01600NR2D.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-G16-G16hSLI00400NR2D.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-G16-G16hSLI00800NR2D.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-G16-G16hSLI00200NR2D.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-G16-G16hSLI00080NR2D.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-G16-G16hSLI00100NR2D.CR2"),&meta);
     OpenFile(FileReader(L"..\\testimg\\Panasoniv-GX7LL002003.RW2"),&meta);
     OpenFile(FileReader(L"..\\testimg\\Panasonic-GX7-P1000414.RW2"),&meta);
       OpenFile(FileReader(L"..\\testimg\\Panasonic-GX7-P1000412.RW2"),&meta);
       OpenFile(FileReader(L"..\\testimg\\Panasonic-GX7-P1000410.RW2"),&meta);
       OpenFile(FileReader(L"..\\testimg\\Panasonic-GX7-P1000409.RW2"),&meta);
   //   OpenFile(FileReader(L"..\\testimg\\IMG_6792.CR2"),&meta);
    //  OpenFile(FileReader(L"..\\testimg\\dng\\Frame000320.dng"),&meta);

      OpenFileID(FileReader(L"..\\testimg\\Panasonic-LF1hSLI12800.RW2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1228.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1229.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1230.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1231.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1232.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1233.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1234.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1235.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1236.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1237.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1238.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1239.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1240.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1241.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1242.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1243.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1244.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1245.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1246.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1247.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1248.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1249.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1250.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1251.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1253.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1254.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1255.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1256.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1257.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1258.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1259.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1260.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1261.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1262.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1263.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1264.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1265.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1266.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1267.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1268.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1269.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1270.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1271.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1272.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1280.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1281.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1282.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1283.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1284.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1285.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1286.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1287.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1288.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1289.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1290.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1318.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1319.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1320.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1321.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1322.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1323.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1324.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1325.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1326.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1327.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1328.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1329.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1330.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1331.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1332.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1333.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1334.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1335.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1336.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1337.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1338.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1339.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1340.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1341.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1342.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1343.CR2"),&meta);
      OpenFileID(FileReader(L"z:\\5d3-raw\\RWH_1344.CR2"),&meta);*/
/*
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Sony_SLT_A58hSLI16000NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Sony_SLT_A58hSLI12800NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Sony_SLT_A58hSLI06400NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Sony_SLT_A58hSLI03200NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Sony_SLT_A58hSLI01600NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Sony_SLT_A58hSLI00800NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Sony_SLT_A58hSLI00400NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Sony_SLT_A58hSLI00200NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic-lx3-P1010279.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-LF1hSLI12800.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-LF1hSLI06400.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-LF1hSLI03200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-LF1hSLI01600.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-LF1hSLI00800.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-LF1hSLI00400.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-LF1hSLI00200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-LF1hSLI00100.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-LF1hSLI00080.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GX1_Raw_3_2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GX1_Raw_16_9.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GX1_Raw_1_1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GF6hSLI25600NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GF6hSLI12800NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GF6hSLI06400NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GF6hSLI03200NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GF6hSLI01600NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GF6hSLI00800NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GF6hSLI00400NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GF6hSLI00200NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-GF6hSLI00160NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-G6hSLI25600NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-G6hSLI12800NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-G6hSLI06400NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-G6hSLI03200NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-G6hSLI01600NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-G6hSLI00800NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-G6hSLI00400NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-G6hSLI00200NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-G6hSLI00160NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-FZ70hSLI3200NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-FZ70hSLI1600NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-FZ70hSLI0800NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-FZ70hSLI0400NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-FZ70hSLI0200NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-FZ70hSLI0100NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-FZ50.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-FZ28-p1030657.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-FZ28-p1030602.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\PanasonicDMC-G3-LL08005.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\PanasonicDMC-G3-LL04006.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\PanasonicDMC-G3-LL02003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\PanasonicDMC-G3-INBI0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\PanasonicDMC-G3-hVFAI0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\PanasonicDMC-G3-hSLI0200_NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\PanasonicDMC-G3-hREST.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\PanasonicDMC-G3-FARI0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-DMCG1LL0207NR3.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-DMCG1LL0107LENROFF.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-DMCG1hSLI0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic-DMCG1hMULTII0100.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_LX5LL002003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_LX5INBI00200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_LX5hVFATB.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_LX5hSLI00200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_LX5hRESM.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_LX5FARWTT.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_LX5FARI0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lx-3_3-2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lx-3_16-9.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_LX3.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_LX2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_15.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_13.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_12.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_08.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_07.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_06.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_05.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_04.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_03.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_02.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_g5_01.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_lx3_06.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_lx3_05.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_lx3_04.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_lx3_03.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_lx3_02.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_lx3_01.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_20.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_17.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_16.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_14.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_13.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_11.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_09.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_08.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_07.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_06.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_05.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_02.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh3_01.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_Lumix_DMC_GH2-sample.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh2_DMCGH2hVFAI06400.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh2_DMCGH2hVFAI00200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh2_DMCGH2hHOUSE.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh2_12.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh2_07.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh2_06.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh2_05.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh2_01.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh1_05_portrait.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gh1_02_portrait.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf3_18.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf3_15.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf3_07.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf3_04.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf3_03.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf3_01.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf2_10.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf2_09.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf2_08.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf2_05.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf2_02.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf1_portrait2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_gf1_portrait1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_g10_12.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_g10_07.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_g10_06.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_g10_02.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_g1_08_portrait.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_g1_04_portrait.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz45_12.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz45_08.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz45_04.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz45_01.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz38_12.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz38_10_portrait.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz38_05.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz38_01.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz200_14.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz200_12.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz200_04.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz150_18.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz150_17.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz150_16.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz150_15.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz150_14.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz150_13.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz150_10.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz150_07.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz150_01.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz100_09.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz100_08.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz100_07.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_lumix_dmc_fz100_03.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_L1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_GF5-LL128003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_GF5-LL064007.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_GF5-LL032003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_GF5-LL016004.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_GF5-LL004007XNR.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_GF5-LL002007XNR.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_GF5-LL002003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_GF5-FAR2I0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_G1-2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ8-2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ8.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ50_2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ50.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ35hVFAWB.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ35hSLI0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ35FARI0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ30.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ28.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ18-6.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ18-5.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ18-4.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ18-3.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ18-2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_FZ18.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC-LX7_P1040044.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC-LX7_P1040040.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC-LX7_P1040037.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC-LX7_P1040033.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC-LX7_P1040032.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC-LX7_P1040027.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC-LX7_P1040024.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC-LX7_P1040021.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMCGF1hSLI0200_NR_LOW.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMCGF1hMULTII0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMCG2hVFATB.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMCG2hSLI0200_NR1.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMCG2hMULTII0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMCG2FARI0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_DMC-G1LL0207LENROFF.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_DMC-G1hSLI0400.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_DMC-G1hMULTII0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_DMC-G1FARI0200.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMCG1-aspect3x2_detail_on_the_right.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMCG1-aspect3x2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC-FX150.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC_LX5-P1020733.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC_LX5-P1020732.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC_LX5-P1020714.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC_LX5-P1020713.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC_LX2.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC_L10.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_DMC_gh1_studio_iso1600.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_DMC_gh1_studio_iso100.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_DMC_gh1_sample_iso400.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\panasonic_DMC_gh1_sample_iso100.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\Panasonic_DMC_G3_greenish_sample.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\FZ200LL64003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\FZ200LL32003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\FZ200LL16003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\FZ200LL08004.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\FZ200LL04003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\FZ200LL02003.dng"),&meta);
      OpenFileID(FileReader(L"d:\\temp\\dng2\\FZ200LL01003.dng"),&meta);*/
/*      OpenFile(FileReader(L"..\\testimg\\Olympus-E-M1-P9040027.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-M1-P9040023.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-M1-P9040017.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-M1-P9040013.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-M1-P9040011.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-M1-P9040007.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-M1-P9040005.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ70hSLI3200NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ70hSLI1600NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ70hSLI0800NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ70hSLI0400NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ70hSLI0200NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ70hSLI0100NR1.RW2"),&meta);

//      OpenFile(FileReader(L"..\\testimg\\RWH_0775.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS6500fd-2.raf"),&meta);*/
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS9500.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\FUJIFILM-FinePix-S9500.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fuji_S6500fd_aka_S6000fd.RAF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\dscf9210.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm IS-1 (which is the same as model S9100 and S9600).RAF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\FujiFilm_FinePix_S3_pro.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\fujifilm_finepix_s5_pro.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\FujiFilm_Finepix_S5600-4.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\FujiFilm_Finepix_S6000fd.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixE900.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixE900-2.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixE900-3.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS2Pro.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5000.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5200.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5200-2.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5500.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5600.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5600_S5200.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5600-2.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5600-3.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5600-nighttest.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS5Pro.raf"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Fujifilm_FinePixS6500fd.raf"),&meta);

        OpenFile(FileReader(L"..\\testimg\\FujiS5600.RAF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\FujiS5600_bird.RAF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\FujiS5600_fiori.RAF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\FujiS5600_merlo.RAF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\FujiS5600_merlo2.RAF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\FujiS5600_merlo3.RAF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\S9600-Fuji.raf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\fujifilm_finepix_x100_02.raf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\bench\\fujifilm_x_e1_20.raf"),&meta);

      OpenFile(FileReader(L"..\\testimg\\fujifilm_finepix_x100_02.raf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5LL256003.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5LL128003.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5LL064003.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5hVFAI00200.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5LL032003.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5LL016003.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5LL008003.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5LL004003.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5LL001003.ORF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Olympus-E-P5-EP5LL002003.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5ILL128003.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5IhVFAI00200.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5ILL064003.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5ILL256003.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5ILL016003.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5ILL001003.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5ILL032003.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5ILL008003.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5ILL004003.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon_EOS_700D-T5ILL002003.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_01.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_02.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_03.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_04.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_05.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_06.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_07.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_08.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_09.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_10.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_14.srw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\samsung_nx2000_19.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon-EOS-70D-E70DhSLI25600NR0.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-EOS-70D-E70DhSLI12800NR0.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-EOS-70D-E70DhSLI06400NR0.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-EOS-70D-E70DhSLI03200NR0.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-EOS-70D-E70DhSLI01600NR0.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-EOS-70D-E70DhSLI00800NR0.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-EOS-70D-E70DhSLI00400NR0.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-EOS-70D-E70DhSLI00200NR0.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon-EOS-70D-E70DhSLI00100NR0.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Nikon-Coolpix-A-CPALL256003.NEF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Nikon-Coolpix-A-CPALL128003.NEF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Nikon-Coolpix-A-CPALL064003.NEF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Nikon-Coolpix-A-CPALL032003.NEF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Nikon-Coolpix-A-CPALL016003.NEF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Nikon-Coolpix-A-CPALL004003.NEF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Nikon-Coolpix-A-CPALL008003.NEF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Nikon-Coolpix-A-CPALL002003.NEF"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Nikon-Coolpix-A-CPALL001003.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G11-IMG_0664.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Image030.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Image031.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI00050NR0.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI00100NR0.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI12800NR0.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI25600NR0.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI03200NR0.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI06400NR0.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI00800NR0.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI01600NR0.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI00400NR0.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX1RhSLI00200NR0.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IILL128003.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IILL064003.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IILL032003.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IILL016003.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IIhVFATB.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IILL002003.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IILL008003.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IILL004003.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IILL001603.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-RX100IILL001003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-LF1hSLI06400.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-LF1hSLI03200.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-LF1hSLI12800.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-LF1hSLI01600.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-LF1hSLI00800.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-LF1hSLI00400.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-LF1hSLI00200.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-LF1hSLI00100.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-LF1hSLI00080.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-NEX3NhSLI12800NR1.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-NEX3NhSLI06400NR1.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-NEX3NhSLI03200NR1.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-NEX3NhSLI01600NR1.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-NEX3NhSLI00800NR1.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-NEX3NhSLI00400NR1.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-NEX3NhSLI00200NR1.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-NEX3NFAR2I0400.ARW"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Sony-NEX3NFAR2I0200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p330_07.nrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p330_09.nrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p330_08.nrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p330_06.nrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p330_05.nrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p330_04.nrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p330_03.nrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p330_02.nrw"),&meta);
        OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p330_01.nrw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-G6hSLI00200NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-G6hSLI01600NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-G6hSLI00800NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-G6hSLI06400NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-G6hSLI03200NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-G6hSLI12800NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-G6hSLI00400NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-GF6hSLI00200NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-G6hSLI25600NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-G6hSLI00160NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-GF6hSLI06400NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-GF6hSLI25600NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-GF6hSLI12800NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-GF6hSLI03200NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-GF6hSLI01600NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-GF6hSLI00800NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-GF6hSLI00400NR1.RW2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Panasonic-GF6hSLI00160NR1.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon EOS 5D Mark III-L50A0070.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon EOS 5D Mark III-L50A0071.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX300hSLI00100NR0.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_Mk2-ISO100_sRAW2.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Canon EOS 6D-mRaw-IMG_0774.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\IT8-1053-mRAW.cr2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Bug538_2361_7D-mRAW.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Bug538_2328_7D-mRAW.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Bug538_2035_7D-mRAW.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Bug538_1871_7D-mRAW.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Bug538_1912_7D-mRAW.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Bug538_1911_7D-mRAW.CR2"),&meta);
        OpenFile(FileReader(L"..\\testimg\\Bug538_0268_7D-mRAW.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A58hSLI12800NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A58hSLI06400NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A58hSLI03200NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A58hSLI01600NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A58hSLI00800NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A58hSLI00400NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A58hSLI16000NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A58hSLI00200NR1.ARW"),&meta);
      
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_11.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_07.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_06.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_19.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_20.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_18.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_17.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_16.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_15.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_14.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex2f_13.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iv_01.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX210_SAM_2325.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX210_SAM_2337.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX210_SAM_2339.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX210_SAM_2329.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX210_SAM_2327.SRW"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Samsung_NX300hSLI25600NR0.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX300hSLI12800NR0.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX300hSLI01600NR0.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX300hSLI06400NR0.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX300hSLI03200NR0.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX300hSLI00800NR0.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX300hSLI00400NR0.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX300hSLI00200NR0.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A58hSLI00100NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_SL1hSLI06400NR0.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_SL1hSLI12800NR0.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_SL1hSLI03200NR0.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_SL1hSLI01600NR0.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_SL1hSLI00800NR0.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_SL1hSLI00400NR0.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_SL1hSLI00100NR0.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_SL1hSLI00200NR0.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\CANON-EOS300D-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\M8-1-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\FUJI-FINEPIXS2PRO-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DIMAGE5-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DIMAGE7HI-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DIMAGEA1-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-02-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-01-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-03-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-04-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-04-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-04-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\NIKON-COOLPIX5700-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\NIKON-D100-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\CANON-EOS10-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\CANON-EOS20D-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\CANON-EOS300D-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\CANON-POWERSHOTPRO1-linear.dng"),&meta);
      
      OpenFile(FileReader(L"..\\testimg\\FZ200hVFATB_20X.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\FZ200hSLI0200NR1.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\FZ200LL64003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\FZ200LL32003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\FZ200LL16003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\FZ200LL08004.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\FZ200LL04003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\FZ200LL02003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\FZ200LL01003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\FZ200hHOUSE.RW2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_08.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_09.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_07.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_15.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_14.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_10.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_06.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_05.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_04.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_03.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_02.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_a_01.nef"),&meta);

      OpenFile(FileReader(L"..\\testimg\\nikon_d5200_04.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_05.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_01.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-GX1_Raw_3_2.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-GX1_Raw_16_9.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-GX1_Raw_1_1.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_01.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_02.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_03.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_04.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_05.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_06.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_07.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_08.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d7100_09.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-p7100-6400iso-nrstan-big.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax-k5-2-IMGP0617.PEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d5200_06.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d5200_05.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d5200_03.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d5200_02.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d5200_01.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D7000-14bit-DSE_2835.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\_DSC0937.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_Lumix_DMC_GH2-sample.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon-6d-exemple6.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon-6d-exemple5.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon-6d-exemple4.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon-6d-exemple3.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon-6d-exemple2.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon-6d-exemple1.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_19.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_15.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_16.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_18.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_20.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_14.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_11.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_06.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_05.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_08.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_j2_01.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_20.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_16.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_18.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_12.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_10.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_13.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_01.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_06.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_05.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_04.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_03.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_1_v2_02.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_19.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_08.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_17.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_07.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_06.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_12.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_13.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_05.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_04.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_03.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_02.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epm2_01.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_19.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_11.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_12.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_17.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_09.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_08.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_07.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_06.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_05.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_04.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_03.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_02.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_5r_01.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon-6d-exemple7.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\IMG_6289.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_13.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_16.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_20.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_17.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_14.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_11.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_05.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_09.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_06.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_08.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_07.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_02.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh3_01.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl5_14.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl5_08.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl5_15.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl5_16.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl5_13.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl5_02.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl5_01.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_xz2_02.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_xz2_04.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_xz2_14.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_08.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_SLT_A65-AA65hVFAI00100.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6FAR2I0200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hSLI25600NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hSLI12800NR2D.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hSLI03200NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hSLI06400NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hSLI01600NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hSLI00800NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hSLI00200NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hSLI00400NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEX6_NEX6hSLI00100NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_05.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_04.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_01.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_22.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_11.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_19.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_07.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_09.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_06.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_03.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_sx50_hs_02.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_M_shadow.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_M_incandescent.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_M_flash.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_M_daylight.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_M_white_fluorescent.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_M_cloudy.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_M_automatic.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI00100NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI00100NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI00100NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\DSC09668.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_13.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_12.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_07.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_08.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_15.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_05.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_04.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_03.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_01.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_06.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_g5_02.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC-LX7_P1040027.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC-LX7_P1040032.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC-LX7_P1040021.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC-LX7_P1040024.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC-LX7_P1040040.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC-LX7_P1040044.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC-LX7_P1040033.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC-LX7_P1040037.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A99_beauty.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A99_green.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A99_bike.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A99_boat.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A99_bricks.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3200-DSC_0010.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-p7100-200iso-nrstan-big.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7700_SLI0800NR1.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7700_SLI0400NR1.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7700_SLI3200NR1.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7700_SLI0100NR1.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7700_SLI1600NR1.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7700_SLI0080NR1.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7700_SLI6400NR1.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7700_SLI0200NR1.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_S110_SLI12800NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI12800NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_S110_SLI06400NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_S110_SLI03200NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI03200NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_S110_SLI00800NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_S110_SLI00200NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI06400NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_S110_SLI01600NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_S110_SLI00100NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_S110_SLI00400NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI00800NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI00200NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_S110_SLI00080NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI01600NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI00400NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G15_SLI00080NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz200_12.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz200_14.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz200_04.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\LEICA D-LUX 4.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\leica_d_lux_5_titanium_05.rwl"),&meta);
      OpenFile(FileReader(L"..\\testimg\\leica_d_lux_5_titanium_08.rwl"),&meta);
      OpenFile(FileReader(L"..\\testimg\\leica_d_lux_5_titanium_01.rwl"),&meta);
      OpenFile(FileReader(L"..\\testimg\\leica_d_lux_5_titanium_03.rwl"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_E5700.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_E5700_(sRGB).nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-v1-100iso-nrstan-big.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-v1-1600iso-nrstan-big.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-v1-3200iso-nrstan-big.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-v1-6400iso-nrstan-big.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1INBI0100.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1LL32003.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1LL64003.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1hHOUSE_M1.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1hVFAI0100.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1hSLI0100NR0.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1hVFAI0200.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1hVFAI0400.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1LL01003.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1LL02003.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1LL04003.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1LL08003.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_J1-J1LL16003.NEF"),&meta);

      OpenFile(FileReader(L"..\\testimg\\20120623-134913.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D700-_DSC5032.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D700-_DSC5031.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\_DSC3496(1).NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\DSC_0088.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D600-hVFAI01600.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D600-hVFAI25600.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D600-hVFAI12800.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D600-hVFAI03200.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D600-hVFAI00800.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D600-hVFAI06400.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D600-INBI00100.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D600-INBI00200.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_5D_mk3_sRaw-UM8A1715.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_5D_mk3_sRaw-UM8A2255.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\fastload\\Olympus_OM-D_E-M5-P1010026_fastload.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\fastload\\Olympus_OM-D_E-M5-P1010021_fastload.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\fastload\\Olympus_OM-D_E-M5-P1010017_fastload.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\fastload\\Olympus_OM-D_E-M5-P1010005_fastload.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\fastload\\Olympus_OM-D_E-M5-P1010003_fastload.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX1000-08035015.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_OM-D_E-M5-P1010003.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_OM-D_E-M5-P1010003.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_OM-D_E-M5-P1010005.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_OM-D_E-M5-P1010005.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_OM-D_E-M5-P1010017.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_OM-D_E-M5-P1010017.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_OM-D_E-M5-P1010021.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_OM-D_E-M5-P1010021.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_OM-D_E-M5-P1010026.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_OM-D_E-M5-P1010026.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\pentax_kr_12.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kr_12.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\pentax_kr_06.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kr_06.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\pentax_kr_01.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kr_01.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\pentax_kr_07.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kr_07.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\pentax_kr_03.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kr_03.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Sony-A500-hSLI00200_NR_1D_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Sony_DSLR-A100-8_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Sony_A580hVFAI12800_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Sony SLT-A35-AA35LL032003_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Sony NEX-5N-NEX5NINBI00100_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\samsung_wb2000_12_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Pentax_K20D-2_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\PanasonicDMC-G3-hSLI0200_NR1_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\panasonic_lumix_dmc_g10_02_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Panasonic_GF5-LL064007_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\panasonic_DMC_gh1_sample_iso100_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Olympus_PEN_E-P3-EP3INBI00200_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\olympus_epl3_20_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Olympus_E400_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\nikon-p7100-3200iso-nrstan-big_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Nikon_J1-J1hVFAI0400_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Nikon_D5100-dsc_0060_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D5100-dsc_0060.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Nikon_D200-1_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\IMG_0261_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\EP1hSLI0200_NR_OFF_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Canon_Powershot_SX1IShMULTII1600_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Canon_EOS_60D-E60DINBI00200_P2_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Canon_EOS_500D-2_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Bug538_2035_7D-mRAW_small.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\lossy_dng\\Sony_DSLR-A100-8.dng"),&meta);
/*
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0008.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0009.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0010.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0011.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0012.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0013.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0014.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0015.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0016.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0017.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0018.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0019.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0020.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0021.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\1diso\\_MG_0022.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8828.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8827.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8826.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8825.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8824.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8823.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8822.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8821.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8820.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8819.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8818.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8817.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8816.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8815.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8814.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8813.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8811.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8810.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8809.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8808.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8807.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8806.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8805.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8804.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8803.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8802.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8801.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8800.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5diso\\IMG_8799.CR2"),&meta);
*/
      OpenFile(FileReader(L"..\\testimg\\IT8-1055-sRAW.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_GF5-LL128003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_GF5-LL064007.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_GF5-LL032003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_GF5-LL016004.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_GF5-LL004007XNR.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_GF5-LL002007XNR.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_GF5-LL002003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_GF5-FAR2I0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_RX100-LL640003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_RX100-LL320003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_RX100-LL160007XNR.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_RX100-LL008003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_RX100-LL020004.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_RX100-FAR2I0100.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_RX100-FAR2I0200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\leica_m_monochrom_01.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\leica_m_monochrom_07.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\leica_m_monochrom_02.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_01.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_04.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_05.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_03.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_02.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_06.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_07.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_08.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_09.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_17.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_23.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_19.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_34.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a37_40.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1D_X_A90I9160.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1D_X_A90I9144.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1D_X_A90I9102.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PENTAX_K-30_yIMGP0038.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PENTAX_K-30_yIMGP0347.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1D_X_A90I9100.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PENTAX_K-30_yIMGP0140.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1D_X_A90I9097.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4IFAR2I0200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1D_X__D4_8468.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4ILL001004.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4ILL002004.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4ILL008004.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4ILL004004.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4ILL032004.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4ILL016003.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4ILL128003.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4ILL064004.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_650D_T4ILL256004.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEXF3FAR2I0200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEXF3hVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEXF3hVFAI00800.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEXF3hVFAI00400.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEXF3hVFAI01600.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEXF3hVFAI12800.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEXF3hVFAI03200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEXF3hVFAI16000.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_NEXF3hVFAI06400.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung NX20 sample 2.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung NX20 sample.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX200LL064003.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX200-FW1.04-SAM_1460.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\SAM_0729-srw.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_nx100_13.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_wb2000_05.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX200-FW1.04-SAM_1428.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX200-FW1.04-SAM_1421.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung_NX200-FW1.04-SAM_1432.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\SAM_0729-dng.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3200-DSC_0027.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3200-DSC_0029.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3200-DSC_0018.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3200-DSC_0013.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\L1000666.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\K01hSLI00800NR0.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\K01hSLI00200NR0.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_16.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_18.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_14.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_08.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_09.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_07.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_06.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_05.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_04.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_03.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_02.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_nex_7_01.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D800_hSLI00100NR0.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D800_hSLI00200NR0.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\SONY_SLT-A57-DSC00320.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\SONY_SLT-A57-DSC00317.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\SONY_SLT-A57-DSC00297.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\SONY_SLT-A57-DSC00300.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sumsung_NX-5_SAM3961.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_5D_Mk3-_W3A2119.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_5D_Mk3-_W3A2112.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX200LL064006.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX200LL128003.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX200LL002003.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX200LL001003.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_nx100_02.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex1_10.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_nx10_05.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_nx10_08.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_nx10_11.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_nx10_12.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_nx100_04.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_nx100_12.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_wb2000_11.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_wb2000_12.srw"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL0256004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL0128004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL1024004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL0064004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL0512004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-hVFAI000200.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL0032004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL0004004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL0002004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL0001004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D4-LL0000503.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G1XhSLI00100NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G1XhSLI00200NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G1XhSLI00400NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G1XhSLI00800NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G1XhSLI03200NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G1XhSLI01600NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G1XhSLI06400NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G1XhSLI12800NR2D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC_G3_greenish_sample.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_eos_1000D_XShSLI1600.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_eos_1000D_XShSLI0800.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_eos_1000D_XShSLI0400.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_eos_1000D_XShSLI0200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_eos_1000D_XShSLI0100.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1000D.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_eos_1000d_01.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_eos_1000d_06.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_600D-T3INBI0200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_600D-T3IhSLI00200_NR_OFF.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_600D-T3IhVFAI00200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_600D-T3IINBI00200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_600D_IMG_6822.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_600D-T3IhSLI00100_NR_OFF.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\_MG_0750.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\E-620-NO-DF.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\E-620-WITH-DF.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-E620_NF-Std_ISO100.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-EPL1hVFATB.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-EPL1hSLI0200NR0.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-EPL1hREST.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-EPL1hMULTII0200NR2D.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-EPL1hHOUSE.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_EPL2-VFAI0200.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_EPL2-SLI0400NR0.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_EPL2-RESM.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_EPL2-L02007.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_EPL2-NBI6400.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_EPL2-NBI0400.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_EPL2-ARWTM.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E5-L01004.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E5-L02006.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E5-HOUSE.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E5-SLI0200_NR_STD.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E5-VFAI00200.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E30.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1hVFAI00200.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1LL002003.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1LL004003.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1LL008003.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1LL016003.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1LL032003.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1hHOUSE.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1hREST.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1LL064003.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1hSLI00200NR_OFF.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1LL128003.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E-PM1-EPM1hVFAI00200.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_31.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_30.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_24.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_29.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_28.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_27.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_26.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_25.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_17.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_20.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_11.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_epl3_02.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3INBI00200.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3INBI00800.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3LL002004.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3INBI12800.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3LL004005.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3LL008007.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3LL016007XNR.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3LL128007.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3hSLI00400NR0.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3hSLI01600NR0.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3hVFAI00200.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_PEN_E-P3-EP3hVFAWB.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_xz1_26.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_xz1_06.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_xz1_05.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_xz1_08.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\olympus_xz1_01.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex1_07.srw"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Olympus-EP2hVFAO.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-EP2hSLI0200NR0.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-EP2hRESM.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-EP2FARWTT.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-EP2FARI0200.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_500UZ.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_C7070WZ.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_C8080.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E1.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E10.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E20.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E3-2.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E3-3.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E3-4.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E3.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E300.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E330.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E400.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E410-2.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E410.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E420.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E500.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E510-2.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E510.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E520-2.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E520-3.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E520-4.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E520-5.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_E520.orf"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus_SP350.orf"),&meta);

      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz150_18.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz150_17.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz150_16.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz150_15.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz150_14.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz150_13.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz150_10.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz150_07.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz150_01.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_PowerShot_S100-PS100hSLI0200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_PowerShot_S100-PS100LL64003.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_PowerShot_S100-PS100LL32003.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_PowerShot_S100-PS100LL16003.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_PowerShot_S100-PS100LL08003.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_PowerShot_S100-PS100LL04003.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_PowerShot_S100-PS100LL00806.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_PowerShot_S100-PS100hVFATB.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\samsung_ex1_07.srw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_Kx_IGP2252.PEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-p7100-400iso-nrstan-big.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\E7DhMULTII00100.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\E7DhMULTII06400.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\E7DhMULTII12800.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\E7DhMULTII03200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_a550-black.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_a550-white.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC_LX5-P1020733.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC_LX5-P1020732.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC_LX5-P1020714.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC_LX5-P1020713.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PanasonicDMC-G3-FARI0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PanasonicDMC-G3-INBI0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PanasonicDMC-G3-LL02003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PanasonicDMC-G3-LL04006.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PanasonicDMC-G3-LL08005.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PanasonicDMC-G3-hREST.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PanasonicDMC-G3-hSLI0200_NR1.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\PanasonicDMC-G3-hVFAI0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf3_07.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf3_15.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf3_18.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf3_04.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf3_03.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf3_01.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMCG1-aspect3x2_detail_on_the_right.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMCG1-aspect3x2.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ28-FZ28VFAWL.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ28-FZ28hMULTII0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ28-p1030602.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ28-p1030657.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh2_DMCGH2hHOUSE.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh2_DMCGH2hVFAI00200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh2_DMCGH2hVFAI06400.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh2_01.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh2_05.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh2_07.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh2_12.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh2_06.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf2_05.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf2_08.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf2_02.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf2_09.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gf2_10.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMCG2hSLI0200_NR1.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX5FARI0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX5FARWTT.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX5hRESM.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX5INBI00200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX5LL002003.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX5hSLI00200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX5hVFATB.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lx-3_3-2.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lx-3_16-9.RW2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz100_09.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz100_07.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz100_03.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz100_08.rw2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz45_04.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz45_01.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz45_08.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_fz45_12.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMCG2hVFATB.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMCG2hMULTII0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_g10_07.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMCG2FARI0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_g10_12.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_g10_06.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_g10_02.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic DMC-LX3.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_G1-2.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX3.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic DMC-LX3.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A230_1.arw"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ35FARI0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ35hSLI0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ35hVFAWB.RW2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMCGF1hSLI0200_NR_LOW.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMCGF1hMULTII0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_lx3_02.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\gh1_sample_iso100.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\gh1_sample_iso400.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\gh1_studio_iso100.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\gh1_studio_iso1600.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC-FX150.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ28.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_lx3_01.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_lx3_02.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_lx3_03.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_lx3_04.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_lx3_05.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_lx3_06.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX3.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_DMC_gh1_sample_iso100.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_DMC_gh1_sample_iso400.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_DMC_gh1_studio_iso100.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_DMC_gh1_studio_iso1600.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_DMC-G1hMULTII0200.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_DMC-G1hSLI0400.RW2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_g1_04_portrait.rw2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\panasonic_lumix_dmc_gh1_02_portrait.rw2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\nikon-p7100-100iso-nrstan-big.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-p7100-800iso-nrstan-big.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-p7100-1600iso-nrstan-big.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon-p7100-3200iso-nrstan-big.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_Kx_IGP2252.PEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kx_03.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kx_04.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kx_10.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kx_12.pef"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35hVFAWB.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35hVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35hSLI12800NRA.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35hSLI00200NRA.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35LL128003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35LL064003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35LL032003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35LL016003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35LL008003_full.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35LL004003_full.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35LL002003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35LL001003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35INBI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony SLT-A35-AA35FARI0200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NLL004003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NINBI00100.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NhSLI00200_NR_LOW.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NLL256003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NLL128003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NLL064003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NhVFAI00400.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NhVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NLL032003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NLL008006.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NLL008003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-5N-NEX5NFARI0200.ARW"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3hVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3hSLI00400NRA.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3hREST.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3LL128006.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3LL032003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3LL008006.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3LL004006.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3LL002006.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3FARI6400.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony NEX-C3-NEXC3FARI0200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony Alpha SLT-A77-AA77FARI0200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony Alpha SLT-A77-AA77hSLI00050NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony Alpha SLT-A77-AA77hSLI00100NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony Alpha SLT-A77-AA77hSLI03200NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony Alpha SLT-A77-AA77hSLI16000NR1.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony Alpha SLT-A77-AA77hVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony Alpha SLT-A77-AA77hVFAWS_DISTORT_OFF.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 3.7.10 IIQ Raw Large-001.tif"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 3.7.10 IIQ Raw Small-001.tif"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 3.7.10 Raw Compatible with 3.0-001.Cap"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 3.7.10 Raw Compatible with 3.1-001.tif"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 4.8.3 IIQ 001.IIQ"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 4.8.3 TIF 001.TIF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 5.2.1 IIQ-001.IIQ"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 5.2.1 TIF-001.TIF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 6.0.1 IIQ-001.IIQ"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Phase One H25 Capture One PRO 6.0.1 TIF-001.TIF"),&meta);
/*
      OpenFile(FileReader(L"..\\testimg\\dng\\_DSC5230.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D5100-dsc_0081.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D5100-dsc_0064.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D5100-dsc_0060.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D5100-dsc_0059.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D5100-D5100LL002004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D5100-D5100hVFAI00400.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D5100-D5100hSLI00200_NR_0.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Samsung-NX-5_SAM0252.SRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K200D-_IGP9477.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7_IGP3526.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7-_IGP3528.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_E8400-DSCN0947.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\NikonCoolPix8800.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_E5400.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\350d-color_problem.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E20.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Leica-X1-L1090994.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Leica-X1-ISO100-L1090324.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Leica_M8.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\leica_m82_01.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\leica_m82_07.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\leica_m82_09.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\leica_m82_11.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Leica_M_8.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-KXhMULTII12800.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\CRW_0740.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E520-4.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Adobe-DNG-Converter-0425-IMG_0530.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Adobe-DNG-Converter-IMG_2312(210609).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Adobe-DNG-Converter-IMG_7903.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\5d-raw.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\5d.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\CANON-EOS10.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\CANON-EOS20D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\CANON-POWERSHOTPRO1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_1000D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_1Ds_Mk2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_1Ds_Mk3-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_1Ds_Mk3.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_1D_Mk2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_1D_Mk2_N.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_1D_Mk3.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_20D-demosaic.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_20d.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_30D-uga1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_30D-uga2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_30D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_350d-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_350D-3.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_350d.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_400D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_40D-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_40D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_450D-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_450D-3.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_450D-4.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_450D-5.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_450D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_5D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_5D_Mk2-ISO100_sRAW1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_5D_Mk2-ISO12800_sRAW1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_5D_Mk2-ISO12800_sRAW2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_EOS_Mk2-ISO100_sRAW2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_Powershot_G10.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_Powershot_G9-1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_Powershot_G9-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Canon_PowerShot_G9.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\FUJI-FINEPIXS2PRO.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\KODAK-DCSPRO.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\M8-1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DIMAGE5.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DIMAGE7HI.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DIMAGEA1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-01.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-02.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-03.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-04.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\MINOLTA-DYNAX7D-05.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\NIKON-COOLPIX5700.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\NIKON-D100.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\NIKON-D70-01-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\NIKON-D70-01.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\NIKON-D70-02-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\NIKON-D70-02.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\NikonCoolPix8800.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D100-1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D1H.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D1X.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D200-1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D200_compressed-1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D2H.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D2X_sRGB.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D3.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D300.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D40X.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D40_(sRGB).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D60-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D60.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D70.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D700.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D70s-3.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D80_(sRGB).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_D90.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_E5400.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_E5700.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Nikon_E5700_(sRGB).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\OLYMPUS-C5050Z-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\OLYMPUS-C5050Z.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\OLYMPUS-E10-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\OLYMPUS-E10.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_500UZ.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_C7070WZ.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_C8080.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E10.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E3-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E3-3.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E3-4.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E3.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E300.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E330.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E400.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E410-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E410.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E420.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E500.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E510-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E510.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E520-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E520-3.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E520-4.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E520-5.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_E520.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Olympus_SP350.dng"),&meta);

      OpenFile(FileReader(L"..\\testimg\\dng\\Panasonic_DMC-FX150(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_DMC-G1FARI0200(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_DMC-G1hMULTII0200(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_DMC-G1hSLI0400(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_DMC-G1LL0207LENROFF(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Panasonic_FZ28(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_lumix_dmc_lx3_01(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_lumix_dmc_lx3_02(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_lumix_dmc_lx3_03(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_lumix_dmc_lx3_04(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_lumix_dmc_lx3_05(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\panasonic_lumix_dmc_lx3_06(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Panasonic_LX3(010909).dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Panasonic_LX3(300109).dng"),&meta);

      OpenFile(FileReader(L"..\\testimg\\dng\\PENTAX-ISD-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\PENTAX-ISD.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Pentax_K100D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Pentax_K10D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Pentax_K20D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\SIGMA-SD10-linear.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\SIGMA-SD10.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\SONY-DSLR-A700.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\SONY_A200.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Sony_A300.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Sony_DSLR-A100-1.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Sony_DSLR-A350.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Sony_DSLR-A900-2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\Sony_DSLR-A900.dng"),&meta);

      OpenFile(FileReader(L"..\\testimg\\dng\\uncompressed.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\uncompressed2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\uncompressed3.dng"),&meta);

*/
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K200DFARI0100.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K200DFARI1600.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K20DFARI0100_43MM.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K20DFARI0200_43MM.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K20DFARI0400_43MM.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K20DFARI0800_43MM.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K20DFARI1600_43MM.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K20DFARI3200_43MM.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K20DFARI6400_43MM.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7FARI0200.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7FARI6400.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7hMULTII0200.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7hVFAO.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Ricoh_GR2.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_01.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_07.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_09.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_10.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_14.dng"),&meta);


      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_350d.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\500D_NR-Std_ISO1600.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\500D_NR-Std_ISO1600.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\500D_NR-Std_ISO6400.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_500D-2.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon-500D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1100D-T3hSLI0100_NR_OFF.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1100D-T3hSLI3200_NR_OFF.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1100D-T3hVFAI0100.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1100D-T3hVFATO.CR2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-E60DFARI00200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-E60DFARI12800.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-E60DhRESM.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-E60DhSLI00100_NR_OFF.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-E60DhSLI12800_NR_OFF.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-E60DhVFAI00100.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-E60DINBI00200_P2.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-E60DLL001006.CR2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_400D.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5d-ISO-200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5d-ISO-H2.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_40D.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G12FARI0100.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G12hREST.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G12hSLI0200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_G12hVFATL.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_s95_15.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_s95_07.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_s95_14.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_s95_02.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_s95_09.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-1.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_60D-2.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon-7d-IMG_0011.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon-7d-IMG_0012.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_550D_T2IhHOUSE.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_550D_T2IhMULTII00200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_550D_T2IhRESM.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_550D_T2IhSLI00200_NR0.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon-7D.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon-1D-Mk4-A28C0180.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon-1D-Mk4-DD9C0097.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon-1D-Mk4-DD9C0069.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_5DMk2-sRaw2.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_450D.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_5DMk2-sRaw1.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_5D_Mk2-ISO100_sRAW1.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_50D-1.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_50D-2.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_50D-3.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_50D-4.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\kp.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1Ds_Mk2.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\5d.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1Ds_Mk3-2.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_20D-demosaic.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_30D.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_450D.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_450D-2.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_Powershot_G10.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_PowerShot_G9.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1D_Mk2.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1D_Mk3.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1Ds_Mk3.cr2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\500D_NR-Std_ISO1600.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_1D_Mk2_N.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_30D-uga1.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_350D-3.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_450D-4.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_50D.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_Powershot_G9-1.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_7DhMULTII00200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_Powershot_SX1IShMULTII1600.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_Powershot_SX1ISFARI0200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_Powershot_SX1IShMULTII0200.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_Powershot_SX1IShSLI0080.CR2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Canon_Powershot_SX1IShSLI0200.CR2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\canon_powershot_g11_02.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_g11_07.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_g11_08.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_s90_02.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_s90_03.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\canon_powershot_s90_04.cr2"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Canon_EOS_5D.cr2"),&meta);
      OpenFile(FileReader(L"..\\testimg\\20101222_IMGP3849.PEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\20101204_IMGP2730.PEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_K-5-IMGP2058.PEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_K-5-IMGP2032.PEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_K-5-IMGP2028.PEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\pentax_kx_03.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_K100D.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_K10D.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_optio_33wr.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Pentax_K200D-2.pef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A580hVFAI12800.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A580hVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A580hSLI00100_NR_WEAK.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A580hREST.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A580hHOUSE.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3100hVFAL.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3100hVFAI00200.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3100hSLI00200_NR_OFF.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3100LL128007XNR.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3100LL032004.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3100LL001007.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3100INBI00200.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3100FARI06400.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3100FARI00200.NEF"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Nikon_D7000hVFAO.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D7000hSLI00200_NR3.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D7000hREST.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D7000LL004003.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D7000LL001005.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A290FARI0200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A290hREST.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A290hSLI0100_NR_OFF.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A290hSLI0400_NR_OFF.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A290hVFAI0200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A290hVFATB.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7000hRESM.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_coolpix_p6000_05.nrw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7000LL0200.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7000hSLI03200.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7000hVFATL.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7000hSLI00200.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_P7000FARI0200.NRW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA55-FAR4912.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA55-FARI00400.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA55-LL002003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA55-hREST.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA55-hSLI00200NRA.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA55-hVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA560-FAR4592.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA560-FARI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA560-INBI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA560-LL002005.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA560-hREST.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA560-hSLI00200NRW.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA560-hVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA33-FAR4592.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA33-FARI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA33-LL002003.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA33-hREST.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA33-hSLI00200NRW.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_AA33-hVFAI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sonya55-ISO100.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sonya55-ISO100-2.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a390_ISO100.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a390_ISO200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic-FZ50.RAW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-6.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-5.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-4.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-3.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC_L10.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ18-2.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_L1.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ8-2.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ8.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ50_2.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_LX2.RAW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_DMC_LX2.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ30.raw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Panasonic_FZ50.raw"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Sony-NEX3hVFA70L.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX3hSLI00200_NRW.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX3hREST.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX3hMULTI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX3FARWTT.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX3FARI00200.ARW"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A100-1.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A100-2.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A100-3.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A100-4.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A100-5.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A100-6.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A100-7.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A100-8.arw"),&meta);


      OpenFile(FileReader(L"..\\testimg\\sony_a450_03.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a450_04.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a450_06.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a450_08.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a450_09.arw"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Sony-NEX5FARI00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX5hMULTII00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX5hMULTII00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX5hREST.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX5hSLI00200_NRW.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX5hSLI06400_NRW.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-NEX5hVFATL.ARW"),&meta);


      OpenFile(FileReader(L"..\\testimg\\Nikon-D3000hMULTII0200.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D3000hSLI0200.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D3x_ISO100.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-A500-hMULTII00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony-A500-hSLI00200_NR_1D.ARW"),&meta);


      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Ricoh_GXR-A12-real_iso200.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D50.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_01.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_07.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_09.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_10.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\ricoh_gr_digital_iii_14.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7FARI0200.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7FARI6400.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7hMULTII0200.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Pentax-K7hVFAO.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Leica_M8.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Leica_M_8.dng"),&meta);  
      OpenFile(FileReader(L"..\\testimg\\sony_a330_02.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a330_04.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a330_05.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\sony_a330_06.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Olympus-E-620-1.ORF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\camera_dngs\\Leica-X1-L1090229.DNG"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\CANON-EOS300D.dng"),&meta);
      OpenFile(FileReader(L"..\\testimg\\dng\\KODAK-DCSPRO-linear.dng"),&meta);



      OpenFile(FileReader(L"..\\testimg\\SONY-DSLR-A700.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\SONY_A200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A300.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A100-1.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A350.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A900-2.arw"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_DSLR-A900.arw"),&meta);

      OpenFile(FileReader(L"..\\testimg\\Sony_a700_ISO1600_compressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_a700_ISO1600_uncompressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_a700_ISO200_compressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_a700_ISO200_uncompressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_a700_ISO6400_compressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_a700_ISO6400_uncompressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A900_ISO1600_uncompressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A900_ISO3200_uncompressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A900_ISO400_uncompressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A900_ISO6400_uncompressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A900_ISO800_uncompressed.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D1.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D100-backhigh.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D200_compressed-1.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D1H.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D1X.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D2H.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D2X_sRGB.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D100-1.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D200-1.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D3.nef"),&meta); 
      OpenFile(FileReader(L"..\\testimg\\Nikon_D300.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D40X.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D40_(sRGB).nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D60-2.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D60.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D70.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D700.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D70s-3.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D80_(sRGB).nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon_D90.nef"),&meta);



      OpenFile(FileReader(L"..\\testimg\\Sony_A550hVFAWB.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A550hVFATB.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A550hSLI00200_NR1D.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A550hMULTII00200.ARW"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Sony_A550FARI0200.ARW"),&meta);

      OpenFile(FileReader(L"..\\testimg\\nikon_d3s_Ycircus_vidrig_102400.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d3s_Ycircus_dogjump3_2500.NEF"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d3s_Ycircus_granny_10000.NEF"),&meta);

      OpenFile(FileReader(L"..\\testimg\\nikon_d300s_01.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d300s_03.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\nikon_d300s_06.nef"),&meta);
      OpenFile(FileReader(L"..\\testimg\\Nikon-D3XFARI0100.NEF"),&meta);
/*
      OpenFile(FileReader(L"z:\\converted-dngs\\_D2K0101.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\_DSC0937.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\_DSC0981.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\_DSC3496(1).dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\_MG_0750.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\07_cruas_eglise_dsc_1616.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\20101204_IMGP2730.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\20101222_IMGP3849.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\20120623-134913.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\20D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\350d-color_problem.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\500D_NR-Std_ISO1600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\500D_NR-Std_ISO6400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\5d.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\5d-ISO-200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\5d-ISO-H2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_0268_7D-mRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_1871_7D-mRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_1911_7D-mRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_1912_7D-mRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_2035_7D-mRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_2328_7D-mRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_2361_7D-mRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_2488_7D-RAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_2490_7D-sRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug538_2491_7D-mRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Bug541_2261.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_5DMk2-sRaw1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_5DMk2-sRaw2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_600D_IMG_6822.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1000D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_eos_1000d_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_eos_1000d_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_eos_1000d_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_eos_1000D_XShSLI0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_eos_1000D_XShSLI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_eos_1000D_XShSLI0400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_eos_1000D_XShSLI0800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_eos_1000D_XShSLI1600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1100D-T3hSLI0100_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1100D-T3hSLI3200_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1100D-T3hVFAI0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1100D-T3hVFATO.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1D_Mk2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1D_Mk2_N.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1D_Mk3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1D_X__D4_8468.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1D_X_A90I9097.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1D_X_A90I9100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1D_X_A90I9102.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1D_X_A90I9144.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1D_X_A90I9160.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1Ds_Mk2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1Ds_Mk3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_1Ds_Mk3-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_20d.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_20D-demosaic.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_30D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_30D-uga1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_30D-uga2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_350d.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_350d-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_350D-3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_400D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_40D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_40D-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_450D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_450D-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_450D-3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_450D-4.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_450D-5.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_500D-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_50D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_50D-1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_50D-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_50D-3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_50D-4.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_550D_T2IhHOUSE.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_550D_T2IhMULTII00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_550D_T2IhRESM.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_550D_T2IhSLI00200_NR0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_5D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_5D_Mk2-ISO100_sRAW1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_5D_Mk2-ISO12800_sRAW1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_5D_Mk2-ISO12800_sRAW2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_5D_mk3_sRaw-UM8A1715.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_5D_mk3_sRaw-UM8A2255.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_5D_Mk3-_W3A2112.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_5D_Mk3-_W3A2119.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_600D-T3IhSLI00100_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_600D-T3IhSLI00200_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_600D-T3IhVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_600D-T3IINBI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_600D-T3INBI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-E60DFARI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-E60DFARI12800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-E60DhRESM.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-E60DhSLI00100_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-E60DhSLI12800_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-E60DhVFAI00100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-E60DINBI00200_P2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_60D-E60DLL001006.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4IFAR2I0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4ILL001004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4ILL002004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4ILL004004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4ILL008004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4ILL016003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4ILL032004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4ILL064004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4ILL128003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_650D_T4ILL256004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_7DhMULTII00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_7DhMULTII12800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_7DhREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_7DhSLI00100_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_M_automatic.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_M_cloudy.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_M_daylight.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_M_flash.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_M_incandescent.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_M_shadow.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_M_white_fluorescent.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_EOS_Mk2-ISO100_sRAW2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G12FARI0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G12hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G12hSLI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G12hVFATL.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G15_SLI00080NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G15_SLI00100NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G15_SLI00200NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G15_SLI00400NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G15_SLI00800NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G15_SLI01600NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G15_SLI03200NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G15_SLI06400NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G15_SLI12800NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G1XhSLI00100NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G1XhSLI00200NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G1XhSLI00400NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G1XhSLI00800NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G1XhSLI01600NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G1XhSLI03200NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G1XhSLI06400NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_G1XhSLI12800NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_Powershot_G10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_g11_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_g11_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_g11_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_PowerShot_G9.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_Powershot_G9-1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_Powershot_G9-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_PowerShot_S100-PS100hSLI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_PowerShot_S100-PS100hVFATB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_PowerShot_S100-PS100LL00806.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_PowerShot_S100-PS100LL04003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_PowerShot_S100-PS100LL08003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_PowerShot_S100-PS100LL16003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_PowerShot_S100-PS100LL32003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_PowerShot_S100-PS100LL64003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_s90_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_s90_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_s90_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_s95_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_s95_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_s95_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_s95_14.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_s95_15.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx1_is_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_Powershot_SX1ISFARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_Powershot_SX1IShMULTII0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_Powershot_SX1IShMULTII1600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_Powershot_SX1IShSLI0080.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_Powershot_SX1IShSLI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_11.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_19.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon_powershot_sx50_hs_22.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_S110_SLI00080NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_S110_SLI00100NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_S110_SLI00200NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_S110_SLI00400NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_S110_SLI00800NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_S110_SLI01600NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_S110_SLI03200NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_S110_SLI06400NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon_S110_SLI12800NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-1D-Mk4-1DmarkIV.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-1D-Mk4-1DmarkIV-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-1D-Mk4-A28C0180.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-1D-Mk4-AH8A9021.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-1D-Mk4-DD9C0069.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-1D-Mk4-DD9C0097.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-500D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon50d-aondo.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon-6d-exemple1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon-6d-exemple2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon-6d-exemple3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon-6d-exemple4.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon-6d-exemple5.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon-6d-exemple6.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\canon-6d-exemple7.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-7D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-7d-IMG_0011.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Canon-7d-IMG_0012.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\D3hMULTII12800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\D3hMULTII25600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\d3x-400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\DSC_0088.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\DSC09668.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\E-620-NO-DF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\E-620-WITH-DF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\E7DhMULTII00100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\E7DhMULTII03200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\E7DhMULTII06400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\E7DhMULTII12800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\EP1FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\EP1hMULTII0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\EP1hMULTII0400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\EP1hRESM.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\EP1hSLI0100_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\EP1hSLI0200_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\EP1hSLI0200_NR_STD.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\EP1hVFATB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\fujifilm_finepix_x100_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\fujifilm_finepix_x100_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\fujifilm_finepix_x100_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\fujifilm_finepix_x100_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\fujifilm_finepix_x100_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\fujifilm_finepix_x100_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\fujifilm_finepix_x100_10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\fujifilm_finepix_x100_13.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\gh1_sample_iso100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\gh1_sample_iso400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\gh1_studio_iso100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\gh1_studio_iso1600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\hotpixels_DSF9264.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\hotpixels_f430978620.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMA_1442.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_0149.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_0241.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_0259.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_0261.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_0262.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_0270.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_0272.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\img_0364.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\img_1587.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_4213.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_4227.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IMG_6289.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IT8-1053-mRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\IT8-1055-sRAW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\kp.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\landscape_d800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\landscape_d800e.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\LEICA D-LUX 4.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\leica_d_lux_5_titanium_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\leica_d_lux_5_titanium_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\leica_d_lux_5_titanium_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\leica_d_lux_5_titanium_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Leica_M_8.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Leica_M8.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Leica-M9-L1000740.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Leica-M9-L1000742.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Leica-M9-L1000748.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\moire-test.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\NIKON COOLPIX P7100-DSCN0696.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\NIKON COOLPIX P7100-DSCN0696_1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_11.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_14.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_15.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_16.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_18.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_19.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_j2_20.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_13.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_16.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_18.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_1_v2_20.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_coolpix_p6000_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D100-1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D100-backhigh.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D1H.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D1X.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D200_compressed-1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D200-1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D2H.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D2X_sRGB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D300.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_d300s_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_d300s_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_d300s_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3100FARI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3100FARI06400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3100hSLI00200_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3100hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3100hVFAL.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3100INBI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3100LL001007.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3100LL032004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3100LL128007XNR.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3200-DSC_0010.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3200-DSC_0013.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3200-DSC_0018.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3200-DSC_0027.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D3200-DSC_0029.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D40_(sRGB).dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D40X.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D50.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D5100-D5100hSLI00200_NR_0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D5100-D5100hVFAI00400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D5100-D5100LL002004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D5100-dsc_0059.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D5100-dsc_0060.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D5100-dsc_0064.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D5100-dsc_0081.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_d5200_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_d5200_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_d5200_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_d5200_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_d5200_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon_d5200_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D60.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D60-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D70.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D700.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D7000-14bit-DSE_2835.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D7000hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D7000hSLI00200_NR3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D7000hVFAO.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D7000LL001005.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D7000LL004003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D70s-3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D80_(sRGB).dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D800_hSLI00100NR0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D800_hSLI00200NR0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_D90.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_E5400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_E5700.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_E5700_(sRGB).dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_E8400-DSCN0947.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1hHOUSE_M1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1hSLI0100NR0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1hVFAI0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1hVFAI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1hVFAI0400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1INBI0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1LL01003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1LL02003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1LL04003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1LL08003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1LL16003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1LL32003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_J1-J1LL64003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7000FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7000hRESM.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7000hSLI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7000hSLI03200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7000hVFATL.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7000LL0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7700_SLI0080NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7700_SLI0100NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7700_SLI0200NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7700_SLI0400NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7700_SLI0800NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7700_SLI1600NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7700_SLI3200NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon_P7700_SLI6400NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\NikonCoolPix8800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D3000hMULTII0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D3000hMULTII3200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D3000hSLI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D3000hVFAhTB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D300S-DSC_3488.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D300S-DSC_3489.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D300S-DSC_3490.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D3x_ISO100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D3XFARI0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D3XhMULTI0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D3XhMULTI6400_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D3XhSLI1600_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-hVFAI000200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL0000503.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL0001004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL0002004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL0004004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL0032004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL0064004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL0128004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL0256004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL0512004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D4-LL1024004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D5000FAR4288F.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D5000hSLI0200_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D600-hVFAI00800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D600-hVFAI01600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D600-hVFAI03200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D600-hVFAI06400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D600-hVFAI12800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D600-hVFAI25600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D600-INBI00100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D600-INBI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-d700.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D700-_DSC5031.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D700-_DSC5032.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Nikon-D80-underwater-hotpixels.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-p7100-100iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-p7100-1600iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-p7100-200iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-p7100-3200iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-p7100-400iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-p7100-6400iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-p7100-800iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-v1-100iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-v1-1600iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-v1-3200iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\nikon-v1-6400iso-nrstan-big.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_500UZ.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_C7070WZ.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_C8080.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E20.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E30.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E300.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E3-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E3-3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E330.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E3-4.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E410.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E410-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E420.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E500.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E510.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E510-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E520.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E520-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E520-3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E520-4.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E520-5.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E5-HOUSE.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E5-L01004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E5-L02006.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E5-SLI0200_NR_STD.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E5-VFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_EPL2-ARWTM.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_EPL2-L02007.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_EPL2-NBI0400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_EPL2-NBI6400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_EPL2-RESM.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_EPL2-SLI0400NR0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_EPL2-VFAI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_11.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_17.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_20.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_24.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_25.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_26.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_27.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_28.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_29.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_30.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl3_31.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl5_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl5_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl5_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl5_13.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl5_14.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl5_15.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epl5_16.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1hHOUSE.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1hSLI00200NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1LL002003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1LL004003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1LL008003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1LL016003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1LL032003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1LL064003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_E-PM1-EPM1LL128003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_13.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_17.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_epm2_19.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_OM-D_E-M5-P1010003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_OM-D_E-M5-P1010005.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_OM-D_E-M5-P1010017.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_OM-D_E-M5-P1010021.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_OM-D_E-M5-P1010026.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3hSLI00400NR0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3hSLI01600NR0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3hVFAWB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3INBI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3INBI00800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3INBI12800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3LL002004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3LL004005.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3LL008007.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3LL016007XNR.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_PEN_E-P3-EP3LL128007.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus_SP350.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_xz1_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_xz1_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_xz1_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_xz1_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_xz1_26.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_xz2_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_xz2_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\olympus_xz2_14.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-E620_NF-Std_ISO100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-E-620-1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-E-620-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EP2FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EP2FARWTT.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EP2hRESM.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EP2hSLI0200NR0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EP2hVFAO.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EPL1hHOUSE.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EPL1hMULTII0200NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EPL1hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EPL1hSLI0200NR0.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Olympus-EPL1hVFATB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC_G3_greenish_sample.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_DMC_gh1_sample_iso100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_DMC_gh1_sample_iso400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_DMC_gh1_studio_iso100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_DMC_gh1_studio_iso1600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC_L10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC_LX2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC_LX5-P1020713.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC_LX5-P1020714.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC_LX5-P1020732.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC_LX5-P1020733.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC-FX150.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMCG1-aspect3x2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMCG1-aspect3x2_detail_on_the_right.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_DMC-G1FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_DMC-G1hMULTII0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_DMC-G1hSLI0400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_DMC-G1LL0207LENROFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMCG2FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMCG2hMULTII0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMCG2hSLI0200_NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMCG2hVFATB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMCGF1hMULTII0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMCGF1hSLI0200_NR_LOW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC-LX7_P1040021.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC-LX7_P1040024.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC-LX7_P1040027.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC-LX7_P1040032.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC-LX7_P1040033.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC-LX7_P1040037.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC-LX7_P1040040.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_DMC-LX7_P1040044.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ18.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ18-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ18-3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ18-4.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ18-5.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ18-6.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ28.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ30.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ35FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ35hSLI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ35hVFAWB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ50.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ50_2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ8.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_FZ8-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_G1-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_GF5-FAR2I0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_GF5-LL002003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_GF5-LL002007XNR.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_GF5-LL004007XNR.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_GF5-LL016004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_GF5-LL032003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_GF5-LL064007.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_GF5-LL128003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_L1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz100_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz100_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz100_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz100_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz150_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz150_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz150_10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz150_13.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz150_14.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz150_15.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz150_16.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz150_17.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz150_18.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz200_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz200_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz200_14.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz38_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz38_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz38_10_portrait.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz38_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz45_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz45_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz45_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_fz45_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_g1_04_portrait.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_g1_08_portrait.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_g10_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_g10_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_g10_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_g10_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf1_portrait1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf1_portrait2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf2_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf2_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf2_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf2_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf2_10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf3_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf3_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf3_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf3_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf3_15.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gf3_18.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh1_02_portrait.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh1_05_portrait.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh2_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh2_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh2_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh2_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh2_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh2_DMCGH2hHOUSE.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh2_DMCGH2hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh2_DMCGH2hVFAI06400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_Lumix_DMC_GH2-sample.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_11.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_13.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_14.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_16.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_17.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_gh3_20.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_lx3_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_lx3_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_lx3_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_lx3_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_lx3_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_dmc_lx3_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_13.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lumix_g5_15.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_LX2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_LX3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lx-3_16-9.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic_lx-3_3-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_LX5FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_LX5FARWTT.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_LX5hRESM.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_LX5hSLI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_LX5hVFATB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_LX5INBI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic_LX5LL002003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-DMCG1hMULTII0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-DMCG1hSLI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-DMCG1LL0107LENROFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-DMCG1LL0207NR3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PanasonicDMC-G3-FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PanasonicDMC-G3-hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PanasonicDMC-G3-hSLI0200_NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PanasonicDMC-G3-hVFAI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PanasonicDMC-G3-INBI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PanasonicDMC-G3-LL02003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PanasonicDMC-G3-LL04006.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PanasonicDMC-G3-LL08005.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-FZ28-p1030602.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-FZ28-p1030657.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-FZ50.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-GX1_Raw_1_1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-GX1_Raw_16_9.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Panasonic-GX1_Raw_3_2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\panasonic-lx3-P1010279.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_645D-10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K100D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K10D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K10D-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K200D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K200D-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K200D-3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K200D-4.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K200D-5.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K20D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K20D-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PENTAX_K-30_yIMGP0038.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PENTAX_K-30_yIMGP0140.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\PENTAX_K-30_yIMGP0347.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_k5-20101126_0001.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K-5-IMGP2028.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_K-5-IMGP2058.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_k7_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_km_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_kr_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_kr_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_kr_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_kr_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_kr_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_kx_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_kx_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_kx_10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax_kx_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax_Kx_IGP2252.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\pentax-k5-2-IMGP0617.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Pentax-K5-FagedaJorda-24.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Phase One H25 Capture One PRO 3.7.10 IIQ Raw Large-001.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Phase One H25 Capture One PRO 3.7.10 IIQ Raw Small-001.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Phase One H25 Capture One PRO 4.8.3 IIQ 001.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Phase One H25 Capture One PRO 4.8.3 TIF 001.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Phase One H25 Capture One PRO 5.2.1 IIQ-001.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Phase One H25 Capture One PRO 5.2.1 TIF-001.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Phase One H25 Capture One PRO 6.0.1 IIQ-001.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Phase One H25 Capture One PRO 6.0.1 TIF-001.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\SAM_0729-dng.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\SAM_0729-srw.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung NX20 sample.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung NX20 sample 2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex1_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex1_10.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_11.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_13.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_14.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_15.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_16.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_17.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_18.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_ex2f_19.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_nx10_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_nx10_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_nx10_11.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_nx10_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_nx100_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_nx100_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_nx100_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_nx100_13.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung_NX1000-08035015.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung_NX200-FW1.04-SAM_1421.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung_NX200-FW1.04-SAM_1428.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung_NX200-FW1.04-SAM_1432.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung_NX200-FW1.04-SAM_1460.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung_NX-5_SAM3961.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_wb2000_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_wb2000_11.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\samsung_wb2000_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX200LL001003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX200LL002003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX200LL064003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX200LL064006.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX200LL128003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX210_SAM_2325.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX210_SAM_2327.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX210_SAM_2329.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX210_SAM_2337.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX210_SAM_2339.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Samsung-NX-5_SAM0252.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony Alpha SLT-A77-AA77FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony Alpha SLT-A77-AA77hSLI00050NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony Alpha SLT-A77-AA77hSLI00100NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony Alpha SLT-A77-AA77hSLI03200NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony Alpha SLT-A77-AA77hSLI16000NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony Alpha SLT-A77-AA77hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony Alpha SLT-A77-AA77hVFAWS_DISTORT_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NFARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NhSLI00200_NR_LOW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NhVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NhVFAI00400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NINBI00100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NLL004003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NLL008003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NLL008006.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NLL032003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NLL064003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NLL128003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-5N-NEX5NLL256003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3FARI6400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3hSLI00400NRA.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3LL002006.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3LL004006.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3LL008006.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3LL032003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony NEX-C3-NEXC3LL128006.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35hSLI00200NRA.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35hSLI12800NRA.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35hVFAWB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35INBI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35LL001003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35LL002003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35LL004003_full.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35LL008003_full.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35LL016003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35LL032003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35LL064003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony SLT-A35-AA35LL128003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\SONY_A200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A230_1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A230_2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A230_3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A290FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A290hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A290hSLI0100_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A290hSLI0400_NR_OFF.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A290hVFAI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A290hVFATB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A300.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a330_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a330_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a330_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a330_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a330_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_17.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_19.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_23.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_34.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a37_40.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a390_ISO100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a390_ISO200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a450_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a450_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a450_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a450_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_a450_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_a550-00103.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_a550-black.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A550FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A550hMULTII00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A550hSLI00200_NR1D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A550hVFATB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A550hVFAWB.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_a550-white.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A580hHOUSE.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A580hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A580hSLI00100_NR_WEAK.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A580hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A580hVFAI12800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_a700_ISO1600_compressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_a700_ISO1600_uncompressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_a700_ISO200_compressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_a700_ISO200_uncompressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_a700_ISO6400_compressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_a700_ISO6400_uncompressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A850FARI0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A850FARI1600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A850hMULTII0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A850hMULTII6400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A900_ISO1600_uncompressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A900_ISO3200_uncompressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A900_ISO400_uncompressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A900_ISO6400_uncompressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A900_ISO800_uncompressed.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A99_beauty.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A99_bike.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A99_boat.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A99_bricks.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_A99_green.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A100-1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A100-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A100-3.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A100-4.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A100-5.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A100-6.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A100-7.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A100-8.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A350.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A900.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_DSLR-A900-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_11.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_12.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_17.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_5r_19.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_01.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_02.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_03.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_04.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_05.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_06.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_07.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_08.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_09.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_14.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_16.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sony_nex_7_18.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6FAR2I0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hSLI00100NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hSLI00200NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hSLI00400NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hSLI00800NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hSLI01600NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hSLI03200NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hSLI06400NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hSLI12800NR2D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hSLI25600NR1.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEX6_NEX6hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEXF3FAR2I0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEXF3hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEXF3hVFAI00400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEXF3hVFAI00800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEXF3hVFAI01600.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEXF3hVFAI03200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEXF3hVFAI06400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEXF3hVFAI12800.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_NEXF3hVFAI16000.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_RX100-FAR2I0100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_RX100-FAR2I0200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_RX100-LL008003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_RX100-LL020004.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_RX100-LL160007XNR.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_RX100-LL320003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_RX100-LL640003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_SLT_A65-AA65hVFAI00100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\SONY_SLT-A57-DSC00297.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\SONY_SLT-A57-DSC00300.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\SONY_SLT-A57-DSC00317.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\SONY_SLT-A57-DSC00320.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA33-FAR4592.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA33-FARI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA33-hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA33-hSLI00200NRW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA33-hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA33-LL002003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA55-FAR4912.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA55-FARI00400.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA55-hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA55-hSLI00200NRA.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA55-hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA55-LL002003.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA560-FAR4592.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA560-FARI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA560-hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA560-hSLI00200NRW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA560-hVFAI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA560-INBI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony_AA560-LL002005.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sonya390_ISO100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sonya390_ISO200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-A500-hMULTII00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-A500-hSLI00200_NR_1D.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sonya55-ISO100.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\sonya55-ISO100-2.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\SONY-DSLR-A700.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX3FARI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX3FARWTT.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX3hMULTI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX3hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX3hSLI00200_NRW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX3hVFA70L.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX5FARI00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX5hMULTII00200.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX5hREST.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX5hSLI00200_NRW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX5hSLI06400_NRW.dng"),&meta);
      OpenFile(FileReader(L"z:\\converted-dngs\\Sony-NEX5hVFATL.dng"),&meta);
*/
    } catch (CameraMetadataException) {

    }
    MessageBox(0,L"Finished", L"Finished",0);
#ifdef _USE_GFL_
    gflLibraryExit();
#endif
  } // Dump objects
  _CrtDumpMemoryLeaks();
  return 0;
}

