/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> const options::filesystemAccess__option_t::type& Options::operator[](
    options::filesystemAccess__option_t) const
{
  return d_holder->filesystemAccess;
}
template <> bool Options::wasSetByUser(options::filesystemAccess__option_t) const
{
  return d_holder->filesystemAccess__setByUser__;
}
template <> const options::globalDeclarations__option_t::type& Options::operator[](
    options::globalDeclarations__option_t) const
{
  return d_holder->globalDeclarations;
}
template <> bool Options::wasSetByUser(options::globalDeclarations__option_t) const
{
  return d_holder->globalDeclarations__setByUser__;
}
template <> const options::memoryMap__option_t::type& Options::operator[](
    options::memoryMap__option_t) const
{
  return d_holder->memoryMap;
}
template <> bool Options::wasSetByUser(options::memoryMap__option_t) const
{
  return d_holder->memoryMap__setByUser__;
}
template <> const options::semanticChecks__option_t::type& Options::operator[](
    options::semanticChecks__option_t) const
{
  return d_holder->semanticChecks;
}
template <> bool Options::wasSetByUser(options::semanticChecks__option_t) const
{
  return d_holder->semanticChecks__setByUser__;
}
template <> const options::strictParsing__option_t::type& Options::operator[](
    options::strictParsing__option_t) const
{
  return d_holder->strictParsing;
}
template <> bool Options::wasSetByUser(options::strictParsing__option_t) const
{
  return d_holder->strictParsing__setByUser__;
}


namespace options {

struct filesystemAccess__option_t filesystemAccess;
struct globalDeclarations__option_t globalDeclarations;
struct memoryMap__option_t memoryMap;
struct semanticChecks__option_t semanticChecks;
struct strictParsing__option_t strictParsing;


}  // namespace options
}  // namespace CVC4
