#include "tcpdispatcher"

void TcpDispatcher::dispatch() {
    // Check that a working algorithm is available. May be missing if
    // constructor's "new" failed.
    if (!algorithm())
	throw Error("No algorithm in Tcpdispatcher::dispatch");
    
    bool connected = false;

    // Build up the target list, if not yet done so. The HTTP dispatcher
    // might've created it already for host-based matching (in which case
    // we won't bother here).
    if (! targetlist().isdefined()) {
	msg ("Creating target list for the TCP dispatcher\n");
	for (unsigned i = 0; i < balancer.nbackends(); i++)
	    if (balancer.backend(i).available()) {
		targetlist().add(i);
		if (config.verbose())
		    msg ("  Candidate target: " +
			 balancer.backend(i).description() + "\n");
	    }	
    }

    // Call the dispatch algorithm until we can connect,
    // or until the algorithm is out of back ends (throws exception).
    while (!connected) {
	targetbackend(algorithm()->target(clientip(), targetlist()));
	Backend tb = balancer.backend(targetbackend());
	if (!tb.connect()) {
	    balancer.backend(targetbackend()).live(false);
	    if (config.verbose())
		msg ("Failed to connect to back end " + tb.description() +
		     ", trying to dispatch to other\n");
	} else {
	    connected = true;
	    backendfd(tb.sock());
	    msg ((Mstr("Will dispatch client to back end ") +
		  tb.description()) +
		 (Mstr(" on fd ") + tb.sock()) + "\n");
	    break;
	}
    }
}
