
Newly introduced with critcl version 3 is support for TEApot
meta-data.

[para] While, from the package developer's perspective, some meta data
support was already present in critcl v2, through the command

[cmd ::critcl::license], this was only used to generate and place a
file [file license.txt] into the built package.

[para] Now critcl supports the declaration of arbitrary meta data,
which will be placed into a file [file teapot.txt] in a format
suitable for use by the
[uri {http://docs.activestate.com/activetcl/8.5/tpm/toc.html} {TEApot tools}].


[list_begin definitions]
[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::license] [arg author] [opt [arg text]...]]

This command provides information about the author of the package, and
its license.

[para] If no [arg text] is present the command expects to find a file
[file license.terms] in the same directory as the [file .critcl] file
and reads the license from that. Otherwise the license is the joined
[arg text]s.

[para] This information, the license, is ignored in mode "compile &
run", only mode "generate package" uses it. In that case the
information is written to a file [file license.terms], a sibling to
the [file pkgIndex.tcl] file in the directory hierarchy of the
generated package.

[para] This information is additionally placed into the meta data file
[file teapot.txt], under the keys [term as::author] and [term license].

[para] The data specified by this command has priority over any
information specified through the generic API [cmd ::critcl::meta].

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::summary] [arg text]]

Declares a short (one line is recommended) description of the package.

[para] This information is ignored in mode "compile & run", only mode
"generate package" uses it. In that case the information is placed
into the meta data file [file teapot.txt], under the key [term summary].

[para] The data specified by this command has priority over any
information specified through the generic API [cmd ::critcl::meta].

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::description] [arg text]]

Declares a longer description of the package.

[para] This information is ignored in mode "compile & run", only mode
"generate package" uses it. In that case the information is placed
into the meta data file [file teapot.txt], under the key [term description].

[para] The data specified by this command has priority over any
information specified through the generic API [cmd ::critcl::meta].

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::subject] [opt [arg key]...]]

Declares one or more keywords and key-phrases describing the package,
for an index.

[para] Multiple calls of this command accumulate keywords and phrases.

[para] This information is ignored in mode "compile & run", only mode
"generate package" uses it. In that case the information is placed
into the meta data file [file teapot.txt], under the key [term subject].

[para] The data specified by this command has priority over any
information specified through the generic API [cmd ::critcl::meta].

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::meta] [arg key] [opt [arg word]...]]

This command is for the declaration of arbitrary meta data outside of
the reserved keys

[term as::author],
[term as::build::date],
[term description],
[term license],
[term name],
[term platform],
[term require]
[term subject],
[term summary], and
[term version],

Its behaviour is like [cmd ::critcl::subject], in that it treats all
keys as list of words, with each call declaring one or more words for
the key, and multiple calls extending the data for an existing key, if
not reserved.

[para] While it is possible to declare information for one of the
reserved keys with this command such data is ignored when the final
meta data is assembled and written.

[para] Use the commands
[cmd ::critcl::license],
[cmd ::critcl::summary],
[cmd ::critcl::description]
[cmd ::critcl::subject],
[cmd {package require}], and
[cmd {package provide}]
to declare data for the reserved keys.

[para] The information for the reserved keys

[term as::build::date] and
[term platform]

is automatically generated by [package critcl] itself.

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::meta?] [arg key]]

This command enables the retrieval of meta data information from with
the code defining a critcl based package. Given the [arg key] the
associated value is returned as the result of the command.

[para] The envisioned main use is the retrieval of the package's name
from within utility packages having to adapt C code templates to their
environment. An example of a package using this command for exactly
this purpose is [package critcl::class].

[comment ---------------------------------------------------------------------]
[call [cmd ::critcl::buildrequirement] [arg script]]

This command provides control over the capturing of dependencies
declared via [cmd {package require}]. It runs the script, and any
dependencies declared within are ignored, i.e. not recorded in the
meta data.

[list_end]
