use warnings;
use strict;
use Module::Build::CipUX;

use version; our $VERSION = qv('3.4.0.7');

my $builder = Module::Build::CipUX->new(
    module_name   => 'CipUX::Task',
    license       => 'gpl2',
    dist_author   => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version  => $VERSION,
    dist_abstract => 'CipUX Task layer',

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'Test::Perl::Critic'  => 0,
        'Test::Pod'           => '1.14',
        'Test::Pod::Coverage' => '1.04',
    },

    build_requires => {
        'File::Spec'           => 0,
        'Module::Build::CipUX' => '0.3.0',
        'Test::More'           => 0,
        'Test::Refcount'       => 0,
        'Test::LeakTrace'      => 0,
    },

    requires => {
        'Carp'           => 0,
        'CipUX'          => '3.4.0.0',
        'CipUX::Object'  => '3.4.0.0',
        'CipUX::Storage' => '3.4.0.0',
        'Class::Std'     => '0.0.9',
        'Data::Dumper'   => 0,
        'English'        => 0,
        'File::Copy'     => 0,
        'Getopt::Long'   => 0,
        'Log::Log4perl'  => 0,
        'Pod::Usage'     => 0,
        'Readonly'       => 0,
        'Scalar::Util'   => 0,
        'Sys::Hostname'  => 0,
        'Term::ReadKey'  => 0,
        'version'        => 0,
    },

    add_to_cleanup => ['CipUX-Task-*'],
);

$builder->create_build_script();
