#ifndef H_CDW_FILE_MANAGER
#define H_CDW_FILE_MANAGER

#include <stddef.h> /* size_t */
#include <stdbool.h>

#include <dirent.h>

#include "main.h"
#include "cdw_dll.h"
#include "cdw_ncurses.h"


cdw_rv_t cdw_file_manager_init(void);
void cdw_file_manager_clean(void);

cdw_rv_t cdw_file_manager_handle_adding_to_selected_files(void);
cdw_rv_t cdw_file_manager_handle_deleting_from_selected_files(void);

cdw_rv_t cdw_file_manager_create_selected_files_view(WINDOW *window);
cdw_rv_t cdw_file_manager_regenerate_selected_files_view(void);

bool cdw_file_manager_any_files_selected(void);
size_t cdw_file_manager_number_of_selected_files(void);
double cdw_file_manager_calculate_selected_files_size_mb(bool follow_symlinks);
void cdw_file_manager_scan_selected_files(void);

cdw_rv_t cdw_file_manager_create_graftpoints_file(void);
void cdw_file_manager_delete_graftpoints_file(void);

cdw_dll_item_t *cdw_file_manager_get_list_of_selected_files(void);


bool      cdw_selected_files_file_over_4gb_present(void);
long long cdw_selected_files_get_size(void);



#endif /* H_CDW_FILE_MANAGER */

