/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: AmrPicture.H,v 1.44 2002/12/10 20:12:23 vince Exp $
//

// ---------------------------------------------------------------
// AmrPicture.H
// ---------------------------------------------------------------
#ifndef _AMRPICTURE_H
#define _AMRPICTURE_H

#include <cstdio>

#include "REAL.H"
#include "Box.H"
#include "AmrvisConstants.H"
#include "GlobalUtilities.H"
#include "GridPicture.H"
#include "Array.H"
#include "FArrayBox.H"

#include <string>
using std::string;

#include <X11/X.h>
#include <X11/Intrinsic.h>

class PltApp;
class PltAppState;
class DataServices;
class GraphicsAttributes;
class Palette;

struct GridBoxes {
  int xbox, ybox, wbox, hbox;
};

enum VectorDerived { enVelocity, enMomentum, enNoneFound };

class AmrPicture {
 public:
  AmrPicture(GraphicsAttributes *gaptr,
             PltApp *pltappptr, PltAppState *pltappstateptr,
	     DataServices *dataservicesptr,
	     bool bcartgridsmoothing);
  // construct an AmrPicture using data from filename
  // 3D: called by first XY view
  
  AmrPicture(int view,
             GraphicsAttributes *gaptr, const Box &region, 
             //AmrPicture *parentPicturePtr, 
             PltApp *parentPltAppPtr, PltApp *pltappptr,
	     PltAppState *pltappstateptr,
	     bool bcartgridsmoothing);
  // construct an AmrPicture using pointer to data & box
  
  ~AmrPicture();
  void	DoFrameUpdate();
  void  DoContourSweep();
  void	DoStop();   // removes TimeOutCallback, updates GridPictures 
  void	SetRegion(int, int, int, int);
  void	CreatePicture(Window drawPictureHere, Palette *palptr);
  void	APDraw(int fromLevel, int toLevel);
  void  DrawSlice(int);
  void	DoExposePicture();
  void	APMakeImages(Palette *palptr);
  void	APChangeScale(int newScale, int previousScale);
  void	APChangeLevel();
  XImage *GetPictureXImage(const bool bdrawboxesintoimage = true);
  void	APChangeSlice(int here);
  
  void	SetSubCut(int, int, int, int);
  void	ToggleShowSubCut();
  void	DrawDatasetPoint(int hplot, int vplot, int size);
  void	UnDrawDatasetPoint();
  void	Sweep(AnimDirection direction);
  void  SetHVLine(int scale);
  void	SetHLine(int hl)    { hLine = hl; }
  void	SetVLine(int vl)    { vLine = vl; }
  int	GetHLine() const    { return hLine; }
  int	GetVLine() const    { return vLine; }
  int	GetSlice() const    { return slice; }
  unsigned int ImageSizeH() const { return imageSizeH; }
  unsigned int ImageSizeV() const { return imageSizeV; }
  void	SetDataServicesPtr(DataServices *tothis) { dataServicesPtr = tothis; } 
  void	SetHColor(int c)          { hColor = c; }
  void	SetVColor(int c)          { vColor = c; }
  const Box &GetSliceBox(int level) const { return sliceBox[level]; }
  int	GetMyView() const         { return myView; }
  const Array<Box> &GetSubDomain() const { return subDomain; }
  void	SetFrameSpeed(int toThis) { frameSpeed = toThis; }
  Window PictureWindow()          { return pictureWindow; }
  void  SetCartGridSmoothing(bool tf) { bCartGridSmoothing = tf; }
  void APChangeContour(ContourType prevCType);
  void GetGridBoxes(Array< Array<GridBoxes> > &gb,
		    const int minlev, const int maxlev);

 private:
  Window 		pictureWindow;
  int			numberOfLevels;
  Array<unsigned long>  dataSize, dataSizeH, dataSizeV;
  unsigned int   	imageSize, imageSizeH, imageSizeV;
  int			hdspoint, vdspoint, dsBoxSize;
  int			datasetPointShowing, datasetPointColor;
  Pixmap 		pixMap;
  Array< Array<GridPicture> > gpArray;
  Array< Array< Array<GridPicture> > > frameGrids;
  int			regionX, regionY, region2ndX, region2ndY;
  int			subCutShowing;
  int			subcutX, subcutY, subcut2ndX, subcut2ndY;
  Array<Box>		subDomain;
  Array<Box>		sliceBox;
  Array<XImage *>	frameBuffer;
  bool			framesMade;
  int			frameSpeed;
  AnimDirection		sweepDirection;
  XtIntervalId		pendingTimeOut;
  Palette		*palPtr;
  Array<FArrayBox *>	sliceFab;
  Array<FArrayBox *>	vfSliceFab;
  Array<unsigned char *>  imageData, scaledImageData;
  Array<XImage *>       xImageArray;
  Array<bool>           xImageCreated;
  GraphicsAttributes	*gaPtr;
  PltApp	        *pltAppPtr;
  PltAppState	        *pltAppStatePtr;
  DataServices		*dataServicesPtr;
  Display		*display;
  GC			xgc;
  int			myView, hLine, vLine;
  int			maxLevelWithGrids;
  int			hColor, vColor, myColor, slice, sliceDir;
  bool                  bCartGridSmoothing;
  bool                  pixMapCreated, isSubDomain, findSubRange;
  
  
  // private functions
  void SetSlice(int view, int here);
  void CoarsenSliceBox();
  void ShowFrameImage(int iSlice);
  void CreateFrames(AnimDirection direction);
  void AmrPictureInit();
  void DrawBoxes(Array< Array<GridPicture> > &gp, Drawable &drawable);
  void DrawTerrBoxes(int level, bool bIsWindow, bool bIsPixmap);
  void CreateImage(const FArrayBox &fab, unsigned char *imagedata,
                   int datasizeh, int datasizev,
                   Real globalMin, Real globalMax, Palette *palptr,
		   const FArrayBox *vfracFab, const Real vfeps);
  void CreateScaledImage(XImage **ximage, int scale,
                         unsigned char *imagedata,
                         unsigned char *scaledimagedata,
                         int datasizeh, int datasizev,
                         int imagesizeh, int imagesizev);
  void DrawContour(Array<FArrayBox *> slicefab, Display *display,
		   Drawable &drawable, const GC &gc);
  bool DrawContour(const FArrayBox &fab, Real value,
                   bool has_mask, const bool *mask,
                   Display *display, Drawable &drawable, const GC &gc, int FGColor,
                   int xLength, int yLength,
                   Real leftEdge, Real bottomEdge, Real rightEdge, Real topEdge);
  inline bool Between(Real a, Real b, Real c) {
      return ( (a <= b) && (b <= c) || (a >= b) && (b >= c) );
  }

  void DrawVectorField(Display *display, Drawable &drawable, const GC &gc);
  void DrawVectorField(Display *display, Drawable &drawable, const GC &gc,
		       int hDir, int vDir, int maxLength,
                       const Real *hdat, const Real *vdat,
		       const Real velocityMax,
		       const Box &dvfSliceBox, int dvfFactor);
  VectorDerived FindVectorDerived(Array<string> &aVectorDeriveNames);

  static void CBFrameTimeOut(XtPointer, XtIntervalId *);
  static void CBContourSweep(XtPointer, XtIntervalId *);

};

#endif
